<?php
namespace CatFolders;

defined( 'ABSPATH' ) || exit;
class I18n {

	public function __construct() {
		add_action( 'init', array( __CLASS__, 'load_text_domain' ) );
	}

	public static function load_text_domain() {
		if ( function_exists( 'determine_locale' ) ) {
			$locale = determine_locale();
		} else {
			$locale = is_admin() ? get_user_locale() : get_locale();
		}
		unload_textdomain( 'catfolders' );
		load_textdomain( 'catfolders', CATF_PLUGIN_PATH . '/languages/catfolders-' . $locale . '.mo' );
		load_plugin_textdomain( 'catfolders', false, CATF_PLUGIN_PATH . '/languages/' );
	}

	public static function getTranslation() {
		return array(
			'global' => array(
				'loading'                               => __( 'Loading...', 'catfolders' ),
				'move_successfully'                     => __( 'Moved successfully!', 'catfolders' ),
				'something_went_wrong_please_try_again' => __( 'Something went wrong! Please try again!', 'catfolders' ),
				'all_files'                             => __( 'All Files', 'catfolders' ),
				'uncategorized'                         => __( 'Uncategorized', 'catfolders' ),
				'default'                               => __( 'Default', 'catfolders' ),
				'name_ascending'                        => __( 'Name Ascending', 'catfolders' ),
				'name_descending'                       => __( 'Name Descending', 'catfolders' ),
				'size_ascending'                        => __( 'Size Ascending', 'catfolders' ),
				'size_descending'                       => __( 'Size Descending', 'catfolders' ),
				'enter_folder_name'                     => __( 'Enter folder name', 'catfolders' ),
				'date_ascending'                        => __( 'Date Ascending', 'catfolders' ),
				'date_descending'                       => __( 'Date Descending', 'catfolders' ),
				'modified_ascending'                    => __( 'Modified Ascending', 'catfolders' ),
				'modified_descending'                   => __( 'Modified Descending', 'catfolders' ),
				'author_ascending'                      => __( 'Author Ascending', 'catfolders' ),
				'author_descending'                     => __( 'Author Descending', 'catfolders' ),
				'title_ascending'                       => __( 'Title Ascending', 'catfolders' ),
				'title_descending'                      => __( 'Title Descending', 'catfolders' ),
				'saving_progress'                       => __( 'Saving progress...', 'catfolders' ),
				'setting_saved'                         => __( 'Setting Saved!', 'catfolders' ),
				'settings'                              => __( 'Settings', 'catfolders' ),
				'previous_folder_selected'              => __( 'Previous folder selected', 'catfolders' ),
				'ascending'                             => __( 'Ascending', 'catfolders' ),
				'descending'                            => __( 'Descending', 'catfolders' ),
				'save_successfully'                     => __( 'Saved successfully!', 'catfolders' ),
				'something_went_wrong'                  => __( 'Something went wrong!', 'catfolders' ),
				'user_restriction'                      => __( 'User Restriction', 'catfolders' ),
				'settings'                              => __( 'Settings', 'catfolders' ),
				'license'                               => __( 'License', 'catfolders' ),
				'import'                                => __( 'Import', 'catfolders' ),
				'successfully'                          => __( 'Successfully!', 'catfolders' ),
				'backup_and_restore'                    => __( 'Backup and Restore', 'catfolders' ),
				'export'                                => __( 'Export', 'catfolders' ),
				'export_now'                            => __( 'Export Now', 'catfolders' ),
				'download_csv'                          => __( 'Download CSV', 'catfolders' ),
				'clear_all_data'                        => __( 'Clear all data', 'catfolders' ),
				'clear_now'                             => __( 'Clear now', 'catfolders' ),
				'import_from_other_plugin'              => __( 'Import From Other Plugins', 'catfolders' ),
				'import_from_other_plugin_normal'       => __( 'Import from other plugins', 'catfolders' ),
				'already_imported'                      => __( 'Already Imported', 'catfolders' ),
				'by'                                    => __( 'by', 'catfolders' ),
				'folders_found_to_import'               => __( 'folders found to import', 'catfolders' ),
				'import_now'                            => __( 'Import now', 'catfolders' ),
				'enter_your_license'                    => __( 'Enter your license', 'catfolders' ),
				'are_you_sure_to_delete'                => __( 'Are you sure to delete?', 'catfolders' ),
				'this_action_will_delete'               => __( 'This action will delete all CatFolders data, CatFolders settings and bring you back to WordPress default media library.', 'catfolders' ),
				'yes'                                   => __( 'Yes', 'catfolders' ),
				'no'                                    => __( 'No', 'catfolders' ),
				'startup_folder'                        => __( 'Startup Folder: ', 'catfolders' ),
				'auto_sort_folder_by'                   => __( 'Auto sort folder by (PRO): ', 'catfolders' ),
				'auto_sort_files_by'                    => __( 'Auto sort files by (PRO): ', 'catfolders' ),
				'sort_folders'                          => __( 'Sort Folders', 'catfolders' ),
				'by_author'                             => __( 'By Author', 'catfolders' ),
				'by_modified'                           => __( 'By Modified', 'catfolders' ),
				'by_date'                               => __( 'By Date', 'catfolders' ),
				'by_size'                               => __( 'By Size', 'catfolders' ),
				'sort_files'                            => __( 'Sort Files', 'catfolders' ),
				'by_name'                               => __( 'By Name', 'catfolders' ),
				'bulk_select'                           => __( 'Bulk Select', 'catfolders' ),
				'uploaded'                              => __( 'Uploaded', 'catfolders' ),
				'all_folders'                           => __( 'All Folders', 'catfolders' ),
				'view_our_document'                     => sprintf( __( '<a href="%s" target="_blank">Learn more</a>', 'catfolders' ), 'https://wpmediafolders.com/docs/settings/folder-access/' ),
				'user_mode_desc'                        => __( 'Users will only be able to access their folders and media.', 'catfolders' ),
				'welcome_mess'                          => sprintf( __( 'Welcome To <a href="%s" target="_blank">CatFolders</a>', 'catfolders' ), 'https://catfolders.com/' ),
				'export_desc'                           => __( 'The current folder structure will be exported.', 'catfolders' ),
				'more_plugins_to_import'                => sprintf( __( 'More Plugins To Import? <a href="%s" target="_blank">Send Us!</a>', 'catfolders' ), 'https://wpmediafolders.com/contact/' ),
				'license_desc'                          => __( 'Your license key provides access to updates and support.', 'catfolders' ),
				'deactivate_key'                        => __( 'Deactivate Key', 'catfolders' ),
				'your_license_is_activated'             => __( 'Your license is activated.', 'catfolders' ),
				'choose_csv_file_to_import'             => __( 'Choose CSV file to import.', 'catfolders' ),
				'noMedia'                               => __( 'No media', 'catfolders' ),
				'move'                                  => __( 'Move', 'catfolders' ),
				'item'                                  => __( 'item', 'catfolders' ),
				'items'                                 => __( 'items', 'catfolders' ),
				'new_folder'                            => __( 'New Folder', 'catfolders' ),
				'rename'                                => __( 'Rename', 'catfolders' ),
				'delete'                                => __( 'Delete', 'catfolders' ),
				'unlock_new_features'                   => __( 'Unlock new features', 'catfolders' ),
				'pro_feature_description'               => __( 'Browse media files of your full folder structure in the CatFolders drag-and-drop interface.', 'catfolders' ),
				'go_pro'                                => __( 'Go Pro', 'catfolders' ),
				'get_catf_pro'                          => __( 'Get CatFolders Pro', 'catfolders' ),
				'unlock_features'                       => __( 'Unlock full features and premium support', 'catfolders' ),
				'want_subfolders'                       => __( 'Want subfolders?', 'catfolders' ),
				'sort_files_pro'                        => __( 'Sort Files (PRO)', 'catfolders' ),
				'sort_folders_pro'                      => __( 'Sort Folders (PRO)', 'catfolders' ),
				'upgrade_to_pro'                        => __( 'Upgrade to Pro', 'catfolders' ),
				'lite'                                  => __( 'Lite', 'catfolders' ),
				'properties'                            => __( 'Properties', 'catfolders' ),
				'download'                              => __( 'Download', 'catfolders' ),
				'save'                                  => __( 'Save', 'catfolders' ),
				'cancel'                                => __( 'Cancel', 'catfolders' ),
				'folders'                               => __( 'Folders', 'catfolders' ),
				'verify'                                => __( 'Verify', 'catfolders' ),
				'type'                                  => __( 'Type', 'catfolders' ),
				'total_items'                           => __( 'Total Items', 'catfolders' ),
				'total_children'                        => __( 'Total Children', 'catfolders' ),
				'author'                                => __( 'Author', 'catfolders' ),
				'create_subfolders'                     => __( 'Create Subfolders', 'catfolders' ),
				'advanced_sort'                         => __( 'Advanced Sort Options', 'catfolders' ),
				'folders_for_post_type'                 => __( 'Folders for Post Types', 'catfolders' ),
				'file_count'                            => __( 'File Count', 'catfolders' ),
				'page_builders'                         => __( 'Page Builders', 'catfolders' ),
				'auto_update'                           => __( 'Auto Update', 'catfolders' ),
				'vip_support'                           => __( 'VIP Support', 'catfolders' ),
				'permission'                            => __( 'Permission', 'catfolders' ),
				'folder_access'                         => __( 'Folder Access', 'catfolders' ),
				'tools'                                 => __( 'Tools', 'catfolders' ),
				'support'                               => __( 'Support', 'catfolders' ),
				'media_folder_access'                   => __( 'Media Folder Access', 'catfolders' ),
				'user_based_folders'                    => __( 'User-Based Folders', 'catfolders' ),
				'common_folder_helper'                  => __( 'Folders are common folders, created by "All Accounts".', 'catfolders' ),
				'personal_folder_helper'                => __( 'Folders are personal folders. The users can only access their own folder structure.', 'catfolders' ),
				'media_folder_permissions'              => __( 'Media Folder Permissions', 'catfolders' ),
				'media_folder_permissions_helper'       => __( 'Allow user roles to manage media folders', 'catfolders' ),
				'plugin_fullname'                       => __( 'CatFolders - WP Media Folders', 'catfolders' ),
				'license_expire_date'                   => __( 'Expiration Date:', 'catfolders' ),
				'license_expired'                       => __( 'Your license is expired!', 'catfolders' ),
				'license_renew'                         => __( 'Renew Now!', 'catfolders' ),
				'license_buy_more'                      => __( 'Need more licenses?', 'catfolders' ),
				'expired'                               => __( 'Expired', 'catfolders' ),
				'license_link_upgrade'                  => __( 'Upgrade to unlimited', 'catfolders' ),
				'your_license_key'                      => __( 'Your license key:', 'catfolders' ),
				'update_key'                            => __( 'Update', 'catfolders' ),
				'license_not_entered'                   => __( 'License key for CatFolders - WP Media Folders is not entered. Please enter a valid license key, or you can', 'catfolders' ),
				'license_link_buy'                      => __( 'get it from our website', 'catfolders' ),
				'getting_started'                       => __( 'Getting started', 'catfolders' ),
				'enter_license_key'                     => __( 'Enter license key', 'catfolders' ),
				'need_help'                             => __( 'Need help?', 'catfolders' ),
				'create_support_topic'                  => __( 'Create a support topic', 'catfolders' ),
				'chat_with_us'                          => __( 'Chat with us', 'catfolders' ),
				'love'                                  => __( 'Love CatFolders?', 'catfolders' ),
				'write_us'                              => __( 'Write us a glowing review', 'catfolders' ),
				'send_us_idea'                          => __( 'Send us your ideas', 'catfolders' ),
				'to_make_work'                          => __( 'to make it work even better for you', 'catfolders' ),
				'tools'                                 => __( 'Tools', 'catfolders' ),
				'media_folder_access'                   => __( 'Media Folder Access', 'catfolders' ),
				'user_based_folders'                    => __( 'User-Based Folders', 'catfolders' ),
				'common_folder_helper'                  => __( 'Folders are common folders, created by "All Accounts".', 'catfolders' ),
				'personal_folder_helper'                => __( 'Folders are personal folders. The users can only access their own folder structure.', 'catfolders' ),
				'gallery_setting'                       => __( 'Gallery Setting', 'catfolders' ),
				'folders_layout_display'                => __( 'Layout Display', 'catfolders' ),
				'enable_lightbox'                       => __( 'Enable Lightbox', 'catfolders' ),
				'folders_columns'                       => __( 'Columns', 'catfolders' ),
				'attachments_caption'                   => __( 'Display Caption', 'catfolders' ),
				'none'                                  => __( 'None', 'catfolders' ),
				'thumbnail_link'                        => __( 'Thumbnail Link', 'catfolders' ),
				'attachment'                            => __( 'Attachment', 'catfolders' ),
				'media_file'                            => __( 'Media File', 'catfolders' ),
				'thumbnail_link_target'                 => __( 'Thumbnail Link Target', 'catfolders' ),
				'self'                                  => __( 'Self', 'catfolders' ),
				'blank'                                 => __( 'Blank', 'catfolders' ),
				'error_notice_choose_folder'            => __( 'Please choose folder in the block settings.', 'catfolders' ),
				'error_notice_folder_empty'             => __( 'This folder has no images, please choose another one.', 'catfolders' ),
				'dont_have_folder'                      => __( 'Oops, you don\'t have any folder.', 'catfolders' ),
				'create_first_folder'                   => __( 'Create your first folder', 'catfolders' ),
				'attachment_size'                       => __( 'Attachment Size', 'catfolders' ),
				'generate'                              => __( 'Generate', 'catfolders' ),
				'generate_size_desc'                    => __( 'Click to generate attachment size', 'catfolders' ),
				'editing_alert'                         => __( 'You are editing another folder! Please complete the task first!', 'catfolders' ),
				'allow_svg_upload_sanitization'         => __( 'Allow built-in SVG upload & sanitization', 'catfolders' ),
				'fail_download_csv'                     => __( 'Failed to download CSV file. Please try again later.', 'catfolders' ),
				'merge_now'                             => __( 'Merge Now', 'catfolders' ),
				'merge_title'                           => __( 'Merge user folders', 'catfolders' ),
				'merge_description'                     => __( 'Make your folder structure global by merging it now.', 'catfolders' ),
				'rest_api_key'                          => __( 'REST API Key', 'catfolders' ),
				'rest_api_key_desc'                     => __( 'Please see CatFolders API for developers.', 'catfolders' ),
				'enable_folders_for_pt'                 => __( 'Enable Folders for Post Types', 'catfolders' ),
			),
		);
	}
}
