<?php
	if(!current_user_can('manage_options'))
	{
		die('Access Denied');
	}
?>
<style type="text/css">
	.ts_main_div_wrapper {
		width: 99%;
		position: relative;
		height: 120px;
		background-color: #ffffff;
		margin-top: 10px;
		margin-left: 0;
		box-shadow: inset 0px 0px 10px #dedcdc;
		border-radius: 5px;
	}
	.ts_main_div {
		width: 150px;
		height: 80px;
		position: relative;
		margin: 0 auto;
		background: url("<?php echo esc_url(plugins_url('../Images/TotalSoftLogo.png',__FILE__));?>");
		background-size: 150px 60px;
		background-repeat: no-repeat;
	}
	.ts_products_div {
		width: 99%;
		position: relative;
		margin: 15px 0 30px 0;
		float: left;
	}
	.ts_products_table {
		width: 100%;
		display: table;
		text-align: center;
		color: #fff;
		border-spacing: 1px;
	}
	.ts_products_table img {
		max-height: 150px;
		width: auto;
		margin: 0 auto;
		display: block;
	}
	.ts_calendar_span a {
		padding: 5px 8px;
		border: 1px solid #ffffff;
		border-radius: 5px;
		background-color: #e8d21a;
		color: #ffffff;
		text-decoration: none;
	}
	.ts_calendar_span a:hover {
		background-color: #ffffff;
		color: #e8d21a;
		cursor: pointer;
	}
	.ts_calendar_span a:focus {
		outline: none !important;
		box-shadow: none !important;
	}
	.ts_portfolio_span a {
		padding: 5px 8px;
		border: 1px solid #ffffff;
		border-radius: 5px;
		background-color: #1184bf;
		color: #ffffff;
		text-decoration: none;
	}
	.ts_portfolio_span a:hover {
		background-color: #ffffff;
		color: #1184bf;
		cursor: pointer;
	}
	.ts_portfolio_span a:focus {
		outline: none !important;
		box-shadow: none !important;
	}
	.ts_gallery_span a {
		padding: 5px 8px;
		border: 1px solid #ffffff;
		border-radius: 5px;
		background-color: #2e2e2e;
		color: #ffffff;
		text-decoration: none;
	}
	.ts_gallery_span a:hover {
		background-color: #ffffff;
		color: #ff386d;
		cursor: pointer;
	}
	.ts_gallery_span a:focus {
		outline: none !important;
		box-shadow: none !important;
	}
	.ts_poll_span a {
		padding: 5px 8px;
		border: 1px solid #ffffff;
		border-radius: 5px;
		background-color: #613bc7;
		color: #ffffff;
		text-decoration: none;
	}
	.ts_poll_span a:hover {
		background-color: #ffffff;
		color: #0194af;
		cursor: pointer;
	}
	.ts_poll_span a:focus {
		outline: none !important;
		box-shadow: none !important;
	}
	.ts_event_span a {
		padding: 5px 8px;
		border: 1px solid #ffffff;
		border-radius: 5px;
		background-color: #b1014c;
		color: #ffffff;
		text-decoration: none;
	}
	.ts_event_span a:hover {
		background-color: #ffffff;
		color: #b1014c;
		cursor: pointer;
	}
	.ts_event_span a:focus {
		outline: none !important;
		box-shadow: none !important;
	}
	.ts_pricing_span a {
		padding: 5px 8px;
		border: 1px solid #ffffff;
		border-radius: 5px;
		background-color: #925189;
		color: #ffffff;
		text-decoration: none;
	}
	.ts_pricing_span a:hover {
		background-color: #ffffff;
		color: #925189;
		cursor: pointer;
	}
	.ts_pricing_span a:focus {
		outline: none !important;
		box-shadow: none !important;
	}
</style>
<form method="POST">
	<div class="ts_main_div_wrapper">
		<div class="ts_main_div"></div>
	</div>
	<div class="ts_products_div">
		<table class="ts_products_table">
			<tr style="background-color: #e8d21a;">
				<td style="width: 80% !important;">
					Calendar is a flexible plugin that allows you to connect to your database and show up your event days on a view. The plugin can render a Day, Week, Month and Resource calendar view. The also provides an interface for manipulating and formatting dates and times. Each event box has a link to the original event you defined in your calendar.
					<p>
						<span class="ts_calendar_span">
							<a href='<?php echo esc_url("https://total-soft.com/wp-event-calendar/"); ?>' target="_blank">
								View More ...
							</a>
						</span>
					</p>
				</td>
				<td style="width: 20% !important;">
					<img src="<?php echo esc_url(plugins_url('../Images/Products/Calendar.png',__FILE__));?>">
				</td>
			</tr>
		</table>
		<table class="ts_products_table">
			<tr style="background-color: #1184bf;">
				<td style="width: 20% !important;">
					<img src="<?php echo esc_url(plugins_url('../Images/Products/Portfolio.png',__FILE__));?>">
				</td>
				<td style="width: 80% !important;">
					A beautiful responsive gallery portfolio. Plugin supports desktop, tablet and mobile browsers. With this plugin, your visitors can filter items by groups. Great for creating a responsive & Filterable Portfolio website. Gallery can be used to creating portfolio, but not only. You can use it to showcase your latest work and expand it to do much more. Each item of the Portfolio is able to be in multiple categories and we can link to certain filters with a url.
					<p>
						<span class="ts_portfolio_span">
							<a href='<?php echo esc_url("https://total-soft.com/wp-portfolio-gallery/"); ?>' target="_blank">
								View More ...
							</a>
						</span>
					</p>
				</td>
			</tr>
		</table>
		<table class="ts_products_table">
			<tr style="background-color: #2e2e2e;">
				<td style="width: 80% !important;">
					Gallery Video plugin extension for WordPress is a simple way to add your videos to any WordPress website, and supports videos from Youtube and Vimeo. The software is responsive, user friendly and can really enhance the rating of your site when people search for related topics and videos, whether on Youtube and Vimeo or search engines in general. Getting your Youtube extension working is straightforward, with a few simple steps required to build this great video resource on your WordPress site. The benefits of the gallery plugin are already making a real difference for all kinds of sites, from business oriented to hobby or entertainment pages. The great thing about the Gallery is that it allows users to express their creative editing skills when composing a video collection, slideshow, or even workshop and information content. Being able to engage with site visitors this way, directly with gallery also helps to make your site much more rating.
					<p>
						<span class="ts_gallery_span">
							<a href='<?php echo esc_url("https://total-soft.com/wp-video-gallery/"); ?>' target="_blank">
								View More ...
							</a>
						</span>
					</p>
				</td>
				<td style="width: 20% !important;">
					<img src="<?php echo esc_url(plugins_url('../Images/Products/Gallery_video.png',__FILE__));?>">
				</td>
			</tr>
		</table>
		<table class="ts_products_table">
			<tr style="background-color: #613bc7;">
				<td style="width: 20% !important;">
					<img src="<?php echo esc_url(plugins_url('../Images/Products/Poll.png',__FILE__));?>">
				</td>
				<td style="width: 80% !important;">
					Poll WordPress plugin allows you to create polls on your WordPress site. It has many powerful features to put very beautiful and easy to use polls on your website. You can create / edit polls, change the color and appearance. If you are looking for a simple, easy but very professional polls on your website, this plugin is what you are looking for.
					<p>
						<span class="ts_poll_span">
							<a href='<?php echo esc_url("https://total-soft.com/wp-poll/"); ?>' target="_blank">
								View More ...
							</a>
						</span>
					</p>
				</td>
			</tr>
		</table>
		<table class="ts_products_table">
			<tr style="background-color: #b1014c;">
				<td style="width: 80% !important;">
					New Revolutionary Event Calendar from Total Soft. This Event calendar is different from all of its charm.  It is very flexible and easy to install and integrate into your website. Total Soft Calendar is the best if you want to be original on your website.
					<p>
						<span class="ts_event_span">
							<a href='<?php echo esc_url("https://total-soft.com/event-calendars/"); ?>' target="_blank">
								View More ...
							</a>
						</span>
					</p>
				</td>
				<td style="width: 20% !important;">
					<img src="<?php echo esc_url(plugins_url('../Images/Products/Event_Calendar.png',__FILE__));?>">
				</td>
			</tr>
		</table>
		<table class="ts_products_table">
			<tr style="background-color: #925189;">
				<td style="width: 20% !important;">
					<img src="<?php echo esc_url(plugins_url('../Images/Products/Pricing_Table.png',__FILE__));?>">
				</td>
				<td style="width: 80% !important;">
					WooCommerce Pricing plugin is a powerful, amazing pricing plugin which helps you to make a table with your products and to give them beautiful design for each one. WooCommerce Pricing plugin offers a powerful tool to directly modify prices.
					<p>
						<span class="ts_pricing_span">
							<a href='<?php echo esc_url("https://total-soft.com/wp-woocommerce-pricing-table/"); ?>' target="_blank">
								View More ...
							</a>
						</span>
					</p>
				</td>
			</tr>
		</table>
	</div>
</form>