<?php
class WC_Addi_Gateway extends WC_Payment_Gateway
{

    //Private variables
    private $version;
    private $widget_enabled;
    private $widget_slug;
    private $field_billing_first_name;
    private $field_billing_last_name;
    private $field_id;
    private $field_billing_address_1;
    private $field_billing_city;
    private $field_billing_email;
    private $field_billing_phone;
    private $prod_client_id;
    private $prod_client_secret;
    private $testmode;
    private $custom_order_status;
    private $logs;
    private $callback_user;
    private $callback_password;
    private $conf_widget_position;
    private $widgetBorderColor;
    private $widgetBorderRadius;
    private $widgetFontColor;
    private $widgetFontFamily;
    private $widgetFontSize;
    private $widgetBadgeBackgroundColor;
    private $widgetInfoBackgroundColor;
    private $widgetMargin;
    private $modalBackgroundColor;
    private $modalFontColor;
    private $modalPriceColor;
    private $modalBadgeBackgroundColor;
    private $modalBadgeBorderRadius;
    private $modalBadgeFontColor;
    private $modalBadgeLogoStyle;
    private $modalCardColor;
    private $modalButtonBorderColor;
    private $modalButtonBorderRadius;
    private $modalButtonBackgroundColor;
    private $modalButtonFontColor;
    private $field_home_banner_position;
    private $field_home_banner_type;
    private $element_reference;
    private $home_banner_enabled;
    private $has_requested_amount;

    //Getters and setters

    // Getters
    
    public function getVersion() {
        return $this->version;
    }

    public function getWidgetEnabled() {
        return $this->widget_enabled;
    }
    
    public function getWidgetSlug() {
        return $this->widget_slug;
    }

    public function getFieldBillingFirstName() {
        return $this->field_billing_first_name;
    }

    public function getFieldBillingLastName() {
        return $this->field_billing_last_name;
    }

    public function getFieldId() {
        return $this->field_id;
    }

    public function getFieldBillingAddress1() {
        return $this->field_billing_address_1;
    }

    public function getFieldBillingCity() {
        return $this->field_billing_city;
    }

    public function getFieldBillingEmail() {
        return $this->field_billing_email;
    }

    public function getFieldBillingPhone() {
        return $this->field_billing_phone;
    }

    public function getProdClientId() {
        return $this->prod_client_id;
    }

    public function getProdClientSecret() {
        return $this->prod_client_secret;
    }

    public function getTestmode() {
        return $this->testmode;
    }

    public function getCustomOrderStatus() {
        return $this->custom_order_status;
    }

    public function getLogs() {
        return $this->logs;
    }

    public function getCallbackUser() {
        return $this->callback_user;
    }

    public function getCallbackPassword() {
        return $this->callback_password;
    }

    public function getConfWidgetPosition() {
        return $this->conf_widget_position;
    }

    public function getWidgetBorderColor() {
        return $this->widgetBorderColor;
    }

    public function getWidgetBorderRadius() {
        return $this->widgetBorderRadius;
    }

    public function getWidgetFontColor() {
        return $this->widgetFontColor;
    }

    public function getWidgetFontFamily() {
        return $this->widgetFontFamily;
    }

    public function getWidgetFontSize() {
        return $this->widgetFontSize;
    }

    public function getWidgetBadgeBackgroundColor() {
        return $this->widgetBadgeBackgroundColor;
    }

    public function getWidgetInfoBackgroundColor() {
        return $this->widgetInfoBackgroundColor;
    }

    public function getWidgetMargin() {
        return $this->widgetMargin;
    }

    public function getModalBackgroundColor() {
        return $this->modalBackgroundColor;
    }

    public function getModalFontColor() {
        return $this->modalFontColor;
    }

    public function getModalPriceColor() {
        return $this->modalPriceColor;
    }

    public function getModalBadgeBackgroundColor() {
        return $this->modalBadgeBackgroundColor;
    }

    public function getModalBadgeBorderRadius() {
        return $this->modalBadgeBorderRadius;
    }

    public function getModalBadgeFontColor() {
        return $this->modalBadgeFontColor;
    }

    public function getModalBadgeLogoStyle() {
        return $this->modalBadgeLogoStyle;
    }

    public function getModalCardColor() {
        return $this->modalCardColor;
    }

    public function getModalButtonBorderColor() {
        return $this->modalButtonBorderColor;
    }

    public function getModalButtonBorderRadius() {
        return $this->modalButtonBorderRadius;
    }

    public function getModalButtonBackgroundColor() {
        return $this->modalButtonBackgroundColor;
    }

    public function getModalButtonFontColor() {
        return $this->modalButtonFontColor;
    }

    public function getFieldHomeBannerPosition() {
        return $this->field_home_banner_position;
    }

    public function getFieldHomeBannerType() {
        return $this->field_home_banner_type;
    }

    public function getElementReference() {
        return $this->element_reference;
    }

    public function getHomeBannerEnabled() {
        return $this->home_banner_enabled;
    }

    public function getHasRequestedAmount() {
        return $this->has_requested_amount;
    }

    // Setters

    public function setVersion($newVersion) {
        $this->version = $newVersion;
    }

    public function setWidgetEnabled($new_widget_enabled) {
        $this->widget_enabled = $new_widget_enabled;
    }

    public function setWidgetSlug($widget_slug) {
        $this->widget_slug = $widget_slug;
    }

    public function setFieldBillingFirstName($field_billing_first_name) {
        $this->field_billing_first_name = $field_billing_first_name;
    }

    public function setFieldBillingLastName($field_billing_last_name) {
        $this->field_billing_last_name = $field_billing_last_name;
    }

    public function setFieldId($field_id) {
        $this->field_id = $field_id;
    }

    public function setFieldBillingAddress1($field_billing_address_1) {
        $this->field_billing_address_1 = $field_billing_address_1;
    }

    public function setFieldBillingCity($field_billing_city) {
        $this->field_billing_city = $field_billing_city;
    }

    public function setFieldBillingEmail($field_billing_email) {
        $this->field_billing_email = $field_billing_email;
    }

    public function setFieldBillingPhone($field_billing_phone) {
        $this->field_billing_phone = $field_billing_phone;
    }

    public function setProdClientId($prod_client_id) {
        $this->prod_client_id = $prod_client_id;
    }

    public function setProdClientSecret($prod_client_secret) {
        $this->prod_client_secret = $prod_client_secret;
    }

    public function setTestmode($testmode) {
        $this->testmode = $testmode;
    }

    public function setCustomOrderStatus($custom_order_status) {
        $this->custom_order_status = $custom_order_status;
    }

    public function setLogs($logs) {
        $this->logs = $logs;
    }

    public function setCallbackUser($callback_user) {
        $this->callback_user = $callback_user;
    }

    public function setCallbackPassword($callback_password) {
        $this->callback_password = $callback_password;
    }

    public function setConfWidgetPosition($conf_widget_position) {
        $this->conf_widget_position = $conf_widget_position;
    }

    public function setWidgetBorderColor($widgetBorderColor) {
        $this->widgetBorderColor = $widgetBorderColor;
    }

    public function setWidgetBorderRadius($widgetBorderRadius) {
        $this->widgetBorderRadius = $widgetBorderRadius;
    }

    public function setWidgetFontColor($widgetFontColor) {
        $this->widgetFontColor = $widgetFontColor;
    }

    public function setWidgetFontFamily($widgetFontFamily) {
        $this->widgetFontFamily = $widgetFontFamily;
    }

    public function setWidgetFontSize($widgetFontSize) {
        $this->widgetFontSize = $widgetFontSize;
    }

    public function setWidgetBadgeBackgroundColor($widgetBadgeBackgroundColor) {
        $this->widgetBadgeBackgroundColor = $widgetBadgeBackgroundColor;
    }

    public function setWidgetInfoBackgroundColor($widgetInfoBackgroundColor) {
        $this->widgetInfoBackgroundColor = $widgetInfoBackgroundColor;
    }

    public function setWidgetMargin($widgetMargin) {
        $this->widgetMargin = $widgetMargin;
    }

    public function setModalBackgroundColor($modalBackgroundColor) {
        $this->modalBackgroundColor = $modalBackgroundColor;
    }

    public function setModalFontColor($modalFontColor) {
        $this->modalFontColor = $modalFontColor;
    }

    public function setModalPriceColor($modalPriceColor) {
        $this->modalPriceColor = $modalPriceColor;
    }

    public function setModalBadgeBackgroundColor($modalBadgeBackgroundColor) {
        $this->modalBadgeBackgroundColor = $modalBadgeBackgroundColor;
    }

    public function setModalBadgeBorderRadius($modalBadgeBorderRadius) {
        $this->modalBadgeBorderRadius = $modalBadgeBorderRadius;
    }

    public function setModalBadgeFontColor($modalBadgeFontColor) {
        $this->modalBadgeFontColor = $modalBadgeFontColor;
    }

    public function setModalBadgeLogoStyle($modalBadgeLogoStyle) {
        $this->modalBadgeLogoStyle = $modalBadgeLogoStyle;
    }

    public function setModalCardColor($modalCardColor) {
        $this->modalCardColor = $modalCardColor;
    }

    public function setModalButtonBorderColor($modalButtonBorderColor) {
        $this->modalButtonBorderColor = $modalButtonBorderColor;
    }

    public function setModalButtonBorderRadius($modalButtonBorderRadius) {
        $this->modalButtonBorderRadius = $modalButtonBorderRadius;
    }

    public function setModalButtonBackgroundColor($modalButtonBackgroundColor) {
        $this->modalButtonBackgroundColor = $modalButtonBackgroundColor;
    }

    public function setModalButtonFontColor($modalButtonFontColor) {
        $this->modalButtonFontColor = $modalButtonFontColor;
    }

    public function setFieldHomeBannerPosition($field_home_banner_position) {
        $this->field_home_banner_position = $field_home_banner_position;
    }

    public function setFieldHomeBannerType($field_home_banner_type) {
        $this->field_home_banner_type = $field_home_banner_type;
    }

    public function setElementReference($element_reference) {
        $this->element_reference = $element_reference;
    }

    public function setHomeBannerEnabled($home_banner_enabled) {
        $this->home_banner_enabled = $home_banner_enabled;
    }

    public function setHasRequestedAmount($has_requested_amount) {
        $this->has_requested_amount = $has_requested_amount;
    }

    /**
     * Class constructor
     */
    public function __construct()
    {

        global $woocommerce;
        global $post;
        global $wp;
        global $wpdb;

        $background_color = get_background_color();

        //TODO: change this per version, this is meant to be used for observability
        $this->version = '2.0.4';
        // Define plugin attributes.
        $this->id = 'addi';
        $this->icon = strpos($background_color, '000') !== false ? plugins_url('../assets/ADDI_logo_white.png', __FILE__) : plugins_url('../assets/ADDI_logo.png', __FILE__);
        $this->has_fields = false;
        $this->method_title = _x('Addi', 'Addi', 'buy-now-pay-later-addi');
        $this->method_description = __('Cuotas que se adaptan a ti - Addi.', 'buy-now-pay-later-addi');

        $this->supports = array(
            'products'
        );

        // Load the settings.
        $this->init_form_fields();
        $this->init_settings();

        // Define user set variables.
        // Pre defined , this cannot be changed.
        $this->title = __('Paga a cuotas', 'buy-now-pay-later-addi');
        $this->enabled = $this->get_option('enabled');
        $this->widget_enabled = $this->get_option('widget_enabled');
        $this->widget_slug = $this->get_option('widget_slug');

        $this->description = $this->get_option('description');
        $this->field_billing_first_name = $this->get_option('field_billing_first_name');
        $this->field_billing_last_name = $this->get_option('field_billing_last_name');
        $this->field_id = $this->get_option('field_id');
        $this->field_billing_address_1 = $this->get_option('field_billing_address_1');
        $this->field_billing_city = $this->get_option('field_billing_city');
        $this->field_billing_email = $this->get_option('field_billing_email');
        $this->field_billing_phone = $this->get_option('field_billing_phone');

        $this->prod_client_id = $this->get_option('prod_client_id');
        $this->prod_client_secret = $this->get_option('prod_client_secret');
        $this->testmode = 'yes' === $this->get_option('testmode');
        $this->custom_order_status = 'yes' === $this->get_option('custom_order_status');
        $this->logs = 'yes' === $this->get_option('logs');
        // Pre defined , this cannot be changed.
        $this->callback_user = 'AddiWooCommercePlugin2021';
        $this->callback_password = 'jDb!mW!ePWjt9z6';

        //Widget position
        $this->conf_widget_position = $this->get_option('conf_widget_position');

        //Widget Css properties
        $this->widgetBorderColor = $this->get_option('widgetBorderColor');
        $this->widgetBorderRadius = $this->get_option('widgetBorderRadius');
        $this->widgetFontColor = $this->get_option('widgetFontColor');
        $this->widgetFontFamily = $this->get_option('widgetFontFamily');
        $this->widgetFontSize = $this->get_option('widgetFontSize');
        $this->widgetBadgeBackgroundColor = $this->get_option('widgetBadgeBackgroundColor');
        $this->widgetInfoBackgroundColor = $this->get_option('widgetInfoBackgroundColor');
        $this->widgetMargin = $this->get_option('widgetMargin');
        //Modal Css properties
        $this->modalBackgroundColor = $this->get_option('modalBackgroundColor');
        $this->modalFontColor = $this->get_option('modalFontColor');
        $this->modalPriceColor = $this->get_option('modalPriceColor');
        $this->modalBadgeBackgroundColor = $this->get_option('modalBadgeBackgroundColor');
        $this->modalBadgeBorderRadius = $this->get_option('modalBadgeBorderRadius');
        $this->modalBadgeFontColor = $this->get_option('modalBadgeFontColor');
        $this->modalBadgeLogoStyle = 'yes' === $this->get_option('modalBadgeLogoStyle');
        $this->modalCardColor = $this->get_option('modalCardColor');
        $this->modalButtonBorderColor = $this->get_option('modalButtonBorderColor');
        $this->modalButtonBorderRadius = $this->get_option('modalButtonBorderRadius');
        $this->modalButtonBackgroundColor = $this->get_option('modalButtonBackgroundColor');
        $this->modalButtonFontColor = $this->get_option('modalButtonFontColor');

        //Home banner properties
        $this->field_home_banner_position = $this->get_option('field_home_banner_position');
        $this->field_home_banner_type = $this->get_option('field_home_banner_type');
        $this->element_reference = $this->get_option('element_reference');
        $this->home_banner_enabled = $this->get_option('home_banner_enabled');
        $this->has_requested_amount = true;

        // action hook to update options to new payment gateway
        add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));

        // action hook to link css / javascripts files or related to it.
        add_action('wp_enqueue_scripts', array($this, 'payment_scripts'));

        // action hook to init callback_handler function with the class
        //add_action('init', array($this, 'addi_callback_handler'));

        add_action('woocommerce_review_order_before_submit', array($this, 'log_gateway_loaded'));

        // action hook to register callack function to a woocommerce rest api
        add_action('woocommerce_api_wc_addi_gateway', array($this, 'addi_callback_handler', ));

        add_action('update_option', function ($option_name, $old_value, $value) {

            global $wpdb;

            $table_config_name = $wpdb->prefix . "wc_addi_config";

            $newValue = $this->get_option('widget_enabled');
            $newSlug = $this->get_option('widget_slug');
            $newWidgetPosition = $this->get_option('conf_widget_position');

            //field id control
            $newfieldId = $this->get_option('field_id');

            //custom order status
            $customOrderStatus = $this->get_option('custom_order_status');

            //Home banner
            $newFieldHomeBannerPosition = $this->get_option('field_home_banner_position');
            $newFieldHomeBannerType = $this->get_option('field_home_banner_type');
            $newElementReference = $this->get_option('element_reference');
            $newHomeBannerEnabled = $this->get_option('home_banner_enabled');
            
            $modalBadgeLogoStyleValue_ = 'false';

            switch ($newFieldHomeBannerPosition) {
                case 'on_header':
                    $newElementReference = 'header';
                    break;
                case 'on_footer':
                    $newElementReference = 'main';
                    break;
            }

            //variables for widget css
            $widgetBorderColor_ = $this->get_option('widgetBorderColor');
            $widgetBorderRadius_ = $this->get_option('widgetBorderRadius');
            $widgetFontColor_ = $this->get_option('widgetFontColor');
            $widgetFontFamily_ = $this->get_option('widgetFontFamily');
            $widgetFontSize_ = $this->get_option('widgetFontSize');
            $widgetBadgeBackgroundColor_ = $this->get_option('widgetBadgeBackgroundColor');
            $widgetInfoBackgroundColor_ = $this->get_option('widgetInfoBackgroundColor');
            $widgetMargin_ = $this->get_option('widgetMargin');
            //varibles for modal css
            $modalBackgroundColor_ = $this->get_option('modalBackgroundColor');
            $modalFontColor_ = $this->get_option('modalFontColor');
            $modalPriceColor_ = $this->get_option('modalPriceColor');
            $modalBadgeBackgroundColor_ = $this->get_option('modalBadgeBackgroundColor');
            $modalBadgeBorderRadius_ = $this->get_option('modalBadgeBorderRadius');
            $modalBadgeFontColor_ = $this->get_option('modalBadgeFontColor');
            $modalBadgeLogoStyle_ = 'yes' === $this->get_option('modalBadgeLogoStyle');
            $modalCardColor_ = $this->get_option('modalCardColor');
            $modalButtonBorderColor_ = $this->get_option('modalButtonBorderColor');
            $modalButtonBorderRadius_ = $this->get_option('modalButtonBorderRadius');
            $modalButtonBackgroundColor_ = $this->get_option('modalButtonBackgroundColor');
            $modalButtonFontColor_ = $this->get_option('modalButtonFontColor');

            $modalBadgeLogoStyleValue_ = ($modalBadgeLogoStyle_ == 1 || $modalBadgeLogoStyle_ == '1') ?
                'true' : 'false';

            if ($option_name == 'woocommerce_addi_settings') {

                $result = $wpdb->get_results($wpdb->prepare("select * from {$table_config_name} where element = %s", "widget"));

                if (isset ($result) && count($result) > 0) {
                    $wpdb->update($table_config_name, array ('value' => $newValue . '|' . $newSlug), array ('element' => 'widget'));
                } else {
                    $wpdb->insert($table_config_name, array ('element' => 'widget', 'value' => $newValue . '|' . $newSlug));
                }

                /* FIELD ID */
                $resultFI = $wpdb->get_results($wpdb->prepare("select * from {$table_config_name} where element = %s", "field_id"));

                if (isset ($resultFI) && count($resultFI) > 0) {
                    $wpdb->update($table_config_name, array ('value' => $newfieldId), array ('element' => 'field_id'));
                } else {
                    $wpdb->insert($table_config_name, array ('element' => 'field_id', 'value' => $newfieldId));
                }
                /* FIELD ID */

                /* WIDGET POSITION */
                $resultV = $wpdb->get_results($wpdb->prepare("select * from {$table_config_name} where element = %s", "widget_position"));

                if (isset ($resultV) && count($resultV) > 0) {
                    $wpdb->update($table_config_name, array ('value' => $newWidgetPosition), array ('element' => 'widget_position'));
                } else {
                    $wpdb->insert($table_config_name, array ('element' => 'widget_position', 'value' => $newWidgetPosition));
                }
                /* WIDGET POSITION */

                $conf_result = $wpdb->get_results($wpdb->prepare("select * from {$table_config_name} where element like %s", "conf_%"));

                if (isset ($conf_result) && count($conf_result) > 0) {
                    //update statements for widget css
                    $wpdb->update($table_config_name, array ('value' => $widgetBorderColor_), array ('element' => 'conf_widgetBorderColor'));
                    $wpdb->update($table_config_name, array ('value' => $widgetBorderRadius_), array ('element' => 'conf_widgetBorderRadius'));
                    $wpdb->update($table_config_name, array ('value' => $widgetFontColor_), array ('element' => 'conf_widgetFontColor'));
                    $wpdb->update($table_config_name, array ('value' => $widgetFontFamily_), array ('element' => 'conf_widgetFontFamily'));
                    $wpdb->update($table_config_name, array ('value' => $widgetFontSize_), array ('element' => 'conf_widgetFontSize'));
                    $wpdb->update($table_config_name, array ('value' => $widgetBadgeBackgroundColor_), array ('element' => 'conf_widgetBadgeBackgroundColor'));
                    $wpdb->update($table_config_name, array ('value' => $widgetInfoBackgroundColor_), array ('element' => 'conf_widgetInfoBackgroundColor'));
                    $wpdb->update($table_config_name, array ('value' => $widgetMargin_), array ('element' => 'conf_widgetMargin'));
                    //update statements for modal css
                    $wpdb->update($table_config_name, array ('value' => $modalBackgroundColor_), array ('element' => 'conf_modalBackgroundColor'));
                    $wpdb->update($table_config_name, array ('value' => $modalFontColor_), array ('element' => 'conf_modalFontColor'));
                    $wpdb->update($table_config_name, array ('value' => $modalPriceColor_), array ('element' => 'conf_modalPriceColor'));
                    $wpdb->update($table_config_name, array ('value' => $modalBadgeBackgroundColor_), array ('element' => 'conf_modalBadgeBackgroundColor'));
                    $wpdb->update($table_config_name, array ('value' => $modalBadgeBorderRadius_), array ('element' => 'conf_modalBadgeBorderRadius'));
                    $wpdb->update($table_config_name, array ('value' => $modalBadgeFontColor_), array ('element' => 'conf_modalBadgeFontColor'));
                    if (count($conf_result) <= 19) {
                        $wpdb->insert($table_config_name, array ('element' => 'conf_modalBadgeLogoStyle', 'value' => $modalBadgeLogoStyleValue_));
                    } else {
                        $wpdb->update($table_config_name, array ('value' => $modalBadgeLogoStyleValue_), array ('element' => 'conf_modalBadgeLogoStyle'));
                    }

                    $wpdb->update($table_config_name, array ('value' => $modalCardColor_), array ('element' => 'conf_modalCardColor'));
                    $wpdb->update($table_config_name, array ('value' => $modalButtonBorderColor_), array ('element' => 'conf_modalButtonBorderColor'));
                    $wpdb->update($table_config_name, array ('value' => $modalButtonBorderRadius_), array ('element' => 'conf_modalButtonBorderRadius'));
                    $wpdb->update($table_config_name, array ('value' => $modalButtonBackgroundColor_), array ('element' => 'conf_modalButtonBackgroundColor'));
                    $wpdb->update($table_config_name, array ('value' => $modalButtonFontColor_), array ('element' => 'conf_modalButtonFontColor'));
                } else {
                    //insert statements for widget css
                    $wpdb->insert($table_config_name, array ('element' => 'conf_widgetBorderColor', 'value' => $widgetBorderColor_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_widgetBorderRadius', 'value' => $widgetBorderRadius_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_widgetFontColor', 'value' => $widgetFontColor_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_widgetFontFamily', 'value' => $widgetFontFamily_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_widgetFontSize', 'value' => $widgetFontSize_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_widgetBadgeBackgroundColor', 'value' => $widgetBadgeBackgroundColor_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_widgetInfoBackgroundColor', 'value' => $widgetInfoBackgroundColor_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_widgetMargin', 'value' => $widgetMargin_));
                    //insert statements for modal css
                    $wpdb->insert($table_config_name, array ('element' => 'conf_modalBackgroundColor', 'value' => $modalBackgroundColor_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_modalFontColor', 'value' => $modalFontColor_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_modalPriceColor', 'value' => $modalPriceColor_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_modalBadgeBackgroundColor', 'value' => $modalBadgeBackgroundColor_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_modalBadgeBorderRadius', 'value' => $modalBadgeBorderRadius_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_modalBadgeFontColor', 'value' => $modalBadgeFontColor_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_modalBadgeLogoStyle', 'value' => $modalBadgeLogoStyle_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_modalCardColor', 'value' => $modalCardColor_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_modalButtonBorderColor', 'value' => $modalButtonBorderColor_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_modalButtonBorderRadius', 'value' => $modalButtonBorderRadius_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_modalButtonBackgroundColor', 'value' => $modalButtonBackgroundColor_));
                    $wpdb->insert($table_config_name, array ('element' => 'conf_modalButtonFontColor', 'value' => $modalButtonFontColor_));
                }

                /** WIDGET HOME  **/

                $resultH = $wpdb->get_results($wpdb->prepare("select * from {$table_config_name} where element = %s", "widget_home"));

                if (isset ($resultH) && count($resultH) > 0) {
                    $wpdb->update($table_config_name, array ('value' => $newHomeBannerEnabled . '|' . $newFieldHomeBannerType . '|' . $newElementReference . '|' . $newSlug), array ('element' => 'widget_home'));
                } else {
                    $wpdb->insert($table_config_name, array ('element' => 'widget_home', 'value' => $newHomeBannerEnabled . '|' . $newFieldHomeBannerType . '|' . $newElementReference . '|' . $newSlug));
                }

                /** WIDGET HOME  **/

                /** CUSTOM ORDER STATUS  **/

                $resultCOS = $wpdb->get_results($wpdb->prepare("select * from {$table_config_name} where element = %s", "custom_order_status"));

                if (isset ($resultCOS) && count($resultCOS) > 0) {
                    $wpdb->update($table_config_name, array ('value' => $customOrderStatus), array ('element' => 'custom_order_status'));
                } else {
                    $wpdb->insert($table_config_name, array ('element' => 'custom_order_status', 'value' => $customOrderStatus));
                }

                /** CUSTOM ORDER STATUS **/

            }

        }, 10, 3);

        /* Register action hook. */
        add_action('init', array($this, 'addi_start_session'), 1);

        /*
         * Callback response managament
         * In this place of the code it is verifying the order id and status from callback response,
         * so then, an action is taken ( display notice  or redirect to order received page).
         */

        // LOAD THE WC LOGGER
        $logger = wc_get_logger();

        // verify if this request is coming from admin site or frontend site
        if ((!is_admin() && (!defined('DOING_AJAX') || !DOING_AJAX))) {

            $order_id = $order_status = $woocommerce_order_id_query_param = null;
            $table_name = $wpdb->prefix . "wc_addi_gateway";

            $querys = $_SERVER['QUERY_STRING'];

            if (strpos($querys, 'wc-order-id') !== false) {
                $woocommerce_order_id_query_param = $_GET["wc-order-id"];
                $_SESSION["order_id_query_param"] = $woocommerce_order_id_query_param;
            }

            try {

                if (isset($woocommerce_order_id_query_param)) {

                    // This id is registered on database, so it's needed to see its status.
                    $result = $wpdb->get_results($wpdb->prepare("select * from {$table_name} where order_id = %d", $woocommerce_order_id_query_param));

                    // verifying the integrity of the resulset, otherwise could throw an error.
                    if (isset($result) && count($result) > 0) {
                        try {

                            foreach ($result as $item) {
                                $order_id = $item->order_id;
                                $order_status = $item->order_status;
                                $wpdb->delete($table_name, array('order_id' => $item->order_id));
                            }
                        } catch (Exception $e) {
                            if ($this->logs == 'yes') {
                                $logger->info('Error getting data from database: ' . $e . ' ', array('source' => 'addi-error-handler-log'));
                            }
                        }

                    }

                    // verifying assignment variables was ok , otherwise it will show a notification
                    if (isset($order_id) && isset($order_status)) {
                        if ($order_status !== 'APPROVED') {

                            add_filter('woocommerce_checkout_fields', function ($fields) {
                                global $woocommerce;
                                global $wp;

                                $order_id = $_SESSION["order_id_query_param"];

                                $order = wc_get_order($order_id);

                                // Get the Order meta data in an unprotected array
                                $order_data = $order->get_data(); // The Order data

                                if ($this->custom_order_status == 'yes') {
                                    $order->update_status('addi-declined', '', true);
                                }

                                //loop in array to verify if billing fields are populated or not
                                foreach ($fields['billing'] as $key1 => $billing) {

                                    if (!isset ($fields['billing'][$key1]['default'])) {
                                        switch ($key1) {
                                            case "billing_first_name":
                                                if (isset ($order_data['billing']['first_name'])) {
                                                    $fields['billing'][$key1]['default'] = $order->get_billing_first_name();
                                                }
                                                break;
                                            case "billing_last_name":
                                                if (isset ($order_data['billing']['last_name'])) {
                                                    $fields['billing'][$key1]['default'] = $order->get_billing_last_name();
                                                }
                                                break;
                                            case "billing_company":
                                                if (isset ($order_data['billing']['company'])) {
                                                    $fields['billing'][$key1]['default'] = $order->get_billing_company();
                                                }
                                                break;
                                            case "billing_address_1":
                                                if (isset ($order_data['billing']['address_1'])) {
                                                    $fields['billing'][$key1]['default'] = $order->get_billing_address_1();
                                                }
                                                break;
                                            case "billing_address_2":
                                                if (isset ($order_data['billing']['address_2'])) {
                                                    $fields['billing'][$key1]['default'] = $order->get_billing_address_2();
                                                }
                                                break;
                                            case "billing_city":
                                                if (isset ($order_data['billing']['city'])) {
                                                    $fields['billing'][$key1]['default'] = $order->get_billing_city();
                                                }
                                                break;
                                            case "billing_state":
                                                if (isset ($order_data['billing']['state'])) {
                                                    $fields['billing'][$key1]['default'] = $order->get_billing_state();
                                                }
                                                break;
                                            case "billing_postcode":
                                                if (isset ($order_data['billing']['postcode'])) {
                                                    $fields['billing'][$key1]['default'] = $order->get_billing_postcode();
                                                }
                                                break;
                                            case "billing_country":
                                                if (isset ($order_data['billing']['country'])) {
                                                    $fields['billing'][$key1]['default'] = $order->get_billing_country();
                                                }
                                                break;
                                            case "billing_email":
                                                if (isset ($order_data['billing']['email'])) {
                                                    $fields['billing'][$key1]['default'] = $order->get_billing_email();
                                                }
                                                break;
                                            case "billing_phone":
                                                if (isset ($order_data['billing']['phone'])) {
                                                    $fields['billing'][$key1]['default'] = $order->get_billing_phone();
                                                }
                                                break;
                                        }
                                    }
                                }

                                //loop in array to verify if shipping fields are populated or not
                                foreach ($fields['shipping'] as $key1 => $billing) {

                                    if (!isset ($fields['shipping'][$key1]['default'])) {
                                        switch ($key1) {
                                            case "shipping_first_name":
                                                if (isset ($order_data['shipping']['first_name'])) {
                                                    $fields['shipping'][$key1]['default'] = $order->get_shipping_first_name();
                                                }
                                                break;
                                            case "shipping_last_name":
                                                if (isset ($order_data['shipping']['last_name'])) {
                                                    $fields['shipping'][$key1]['default'] = $order->get_shipping_last_name();
                                                }
                                                break;
                                            case "shipping_company":
                                                if (isset ($order_data['shipping']['company'])) {
                                                    $fields['shipping'][$key1]['default'] = $order->get_shipping_company();
                                                }
                                                break;
                                            case "shipping_address_1":
                                                if (isset ($order_data['shipping']['addres_1'])) {
                                                    $fields['shipping'][$key1]['default'] = $order->get_shipping_address_1();
                                                }
                                                break;
                                            case "shipping_address_2":
                                                if (isset ($order_data['shipping']['addres_2'])) {
                                                    $fields['shipping'][$key1]['default'] = $order->get_shipping_address_2();
                                                }
                                                break;
                                            case "shipping_city":
                                                if (isset ($order_data['shipping']['city'])) {
                                                    $fields['shipping'][$key1]['default'] = $order->get_shipping_city();
                                                }
                                                break;
                                            case "shipping_state":
                                                if (isset ($order_data['shipping']['state'])) {
                                                    $fields['shipping'][$key1]['default'] = $order->get_shipping_state();
                                                }
                                                break;
                                            case "shipping_postcode":
                                                if (isset ($order_data['shipping']['postcode'])) {
                                                    $fields['shipping'][$key1]['default'] = $order->get_shipping_postcode();
                                                }
                                                break;
                                            case "shipping_country":
                                                if (isset ($order_data['shipping']['country'])) {
                                                    $fields['shipping'][$key1]['default'] = $order->get_shipping_country();
                                                }
                                                break;
                                            case "shipping_email":
                                                if (isset ($order_data['shipping']['email'])) {
                                                    $fields['shipping'][$key1]['default'] = $order->get_shipping_email();
                                                }
                                                break;
                                            case "shipping_phone":
                                                if (isset ($order_data['shipping']['phone'])) {
                                                    $fields['shipping'][$key1]['default'] = $order->get_shipping_phone();
                                                }
                                                break;
                                        }
                                    }
                                }

                                $_SESSION["order_id_query_param"] = null;
                                return $fields;
                            });
                            // display notification
                            $error_message = __('Tu pago no fue aprobado. Por favor, inténtalo de nuevo.', 'buy-now-pay-later-addi');
                            if (wp_is_json_request()) {
                                throw new Exception($error_message);
                            } else {
                                wc_add_notice($error_message, 'error');
                            }
                        }
                    }
                }
            } catch (Exception $e) {
                if ($this->logs == 'yes') {
                    $logger->info(' Fatal Error :   ' . $e . ' ', array('source' => 'addi-gateway-log'));
                }
            }
        }
        /*
         * Callback response management
         * In this place of the code it is verifying the order id and status from callback response,
         * so then, an action is taken ( display notice  or redirect to order received page).
         * --- END OF CODE ----
         */

    }

    /**
     * Plugin options
     */
    public function init_form_fields()
    {
        global $woocommerce;

        add_action('admin_footer', function() {
            ?>
            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    // Only add class if we're in the Addi gateway settings
                    if (window.location.search.indexOf('section=addi') !== -1) {
                        $('table.form-table').attr('id', 'addi-settings-form');
                    }
                });
            </script>
            <?php
        });

        $this->form_fields = array(
            //General configuration
            'hr1' => array(
                'type' => 'hr',
                'class' => 'hr-default',
            ),
            'addi_logo' => array(
                'title' => __(' ', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'class' => 'section-header',
            ),
            'addi_section_general_page' => array(
                'title' => __('Configuración General', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'class' => 'section-header',
            ),
            'enabled' => array(
                'title' => __('Estado del Plugin', 'buy-now-pay-later-addi'),
                'label' => __('Activar Addi', 'buy-now-pay-later-addi'),
                'type' => 'checkbox',
                'description' => __('Activa o desactiva el plugin de Addi. Esta es la configuración principal que controla todas las funcionalidades.', 'buy-now-pay-later-addi'),
                'default' => 'no'
            ),
            'allow_refunds' => array(
                'title' => __('Cancelaciones automáticas', 'buy-now-pay-later-addi'),
                'label' => __('Activar cancelaciones automáticas', 'buy-now-pay-later-addi'),
                'type' => 'checkbox',
                'description' => '',
                'default' => 'no'
            ),
            'widget_slug' => array(
                'title' => __('Ally slug en ADDI', 'buy-now-pay-later-addi'),
                'type' => 'text',
            ),
            'prod_client_id' => array(
                'title' => 'Client ID',
                'type' => 'text',
                'default' => '',
                'desc_tip' => __('Ingrese su "Client ID" proporcionado en el portal de aliados de Addi.', 'buy-now-pay-later-addi'),
            ),
            'prod_client_secret' => array(
                'title' => 'Client Secret',
                'type' => 'password',
                'desc_tip' => __('Ingrese su "Client Secret" proporcionado en el portal de aliados de Addi.', 'buy-now-pay-later-addi'),
            ),
            'testmode' => array(
                'title' => __('Modo de Pruebas', 'buy-now-pay-later-addi'),
                'label' => __('Activar modo de pruebas', 'buy-now-pay-later-addi'),
                'type' => 'checkbox',
                'description' => __('Activa el ambiente de pruebas para realizar tests sin procesar pagos reales.', 'buy-now-pay-later-addi'),
                'default' => 'no',
                'desc_tip' => true,
            ),
            'logs' => array(
                'title' => __('Logs', 'buy-now-pay-later-addi'),
                'label' => __('Activar Logs', 'buy-now-pay-later-addi'),
                'type' => 'checkbox',
                'description' => __('Activa el registro de logs para depuración y monitoreo del plugin.', 'buy-now-pay-later-addi'),
                'default' => 'no',
            ),
            //checkout settings
            'hr2' => array(
                'type' => 'hr',
                'class' => 'hr-default',
            ),
            'addi_section_checkout_page' => array(
                'title' => __('Configuración de Addi en el Checkout(Formulario de compra)', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'class' => 'section-header',
            ),
            'addi_sub_section_checkout_page' => array(
                'title' => __('Campos Personalizados del Formulario de Pago', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'class' => 'section-header',
            ),
            'addi_description_checkout_page' => array(
                'title' => __('Si has personalizado los campos del formulario de pago, ingresa aquí los nombres de las etiquetas personalizadas. Si usas los campos estándar de WooCommerce, déjalos en blanco.', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'class' => 'widget-description-header',
            ),
            'field_billing_first_name' => array(
                'title' => __('Campo Nombres', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'default' => '',
                'desc_tip' => __('Si has personalizado el campo "Nombre" en el formulario de pago, ingresa aquí el nombre de la etiqueta (label). Si usas el campo estándar, déjalo en blanco.', 'buy-now-pay-later-addi'),
            ),
            'field_billing_last_name' => array(
                'title' => __('Campo Apellidos', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'default' => '',
                'desc_tip' => __('En caso de tener un campo para el "Apellido" en el checkout de forma personalizada, escriba el nombre de la etiqueta(label) aquí. Si no lo tiene, déjelo en blanco.', 'buy-now-pay-later-addi'),
            ),
            'field_id' => array(
                'title' => __('Campo Documento', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'default' => '',
                'desc_tip' => __('En caso de tener un campo para el documento de identificación que ha sido personalizado, escriba el nombre de la etiqueta(label) aquí. Si no lo tiene, déjelo en blanco.', 'buy-now-pay-later-addi'),
            ),
            'field_billing_address_1' => array(
                'title' => __('Campo Dirección', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'default' => '',
                'desc_tip' => __('En caso de tener un campo para la dirección que ha sido personalizado, escriba el nombre de la etiqueta(label) aquí. Si no lo tiene, déjelo en blanco.', 'buy-now-pay-later-addi'),
            ),
            'field_billing_city' => array(
                'title' => __('Campo Ciudad', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'default' => '',
                'desc_tip' => __('En caso de tener un campo para la ciudad que ha sido personalizado, escriba el nombre de la etiqueta(label) aquí. Si no lo tiene, déjelo en blanco.', 'buy-now-pay-later-addi'),
            ),
            'field_billing_email' => array(
                'title' => __('Campo Email', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'default' => '',
                'desc_tip' => __('En caso de tener un campo para el correo electronico que ha sido personalizado, escriba el nombre de la etiqueta(label) aquí. Si no lo tiene, déjelo en blanco.', 'buy-now-pay-later-addi'),
            ),
            'field_billing_phone' => array(
                'title' => __('Campo Teléfono', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'default' => '',
                'desc_tip' => __('En caso de tener un campo para el número de celular que ha sido personalizado, escriba el nombre de la etiqueta(label) aquí. Si no lo tiene, déjelo en blanco.', 'buy-now-pay-later-addi'),
            ),
            'custom_order_status' => array(
                'title' => __('Estados de Pedido Personalizados', 'buy-now-pay-later-addi'),
                'label' => __('Activar estados personalizados de Addi', 'buy-now-pay-later-addi'),
                'type' => 'checkbox',
                'description' => __('Al activar esta opción, los pedidos realizados con Addi mostrarán estados personalizados que indican si la transacción fue aprobada o rechazada.', 'buy-now-pay-later-addi'),
                'default' => 'no',
                'desc_tip' => false,
            ),
            'description' => array(
                'title' => __('Descripción', 'buy-now-pay-later-addi'),
                'class' => 'description-hidden',
                'type' => 'textarea',
                'description' => __('Esta descricpión es visible en el checkout.', 'buy-now-pay-later-addi'),
                'default' => __('<b>Finaliza tu compra con ADDI</b></br><b>Es simple, rápido y seguro</b></br><b>1.</b> Sin tarjeta de crédito y en minutos.</br><b>2.</b> Proceso 100% online y sin papeleo.</br><b>3.</b> Solo necesitas tu cédula y WhatsApp para aplicar.', 'buy-now-pay-later-addi'),
                'desc_tip' => true,
            ),
            //Checkout descripton
            'hr5' => array(
                'type' => 'hr',
                'class' => 'hr-default',
            ),
            'section_checkout_description' => array(
                'title' => __('Vista previa de la descripción del checkout', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'class' => 'section-header',
            ),
            'description_checkout_page' => array(
                'title' => __('Dependiendo del producto que tengas activo te saldrá una de las siguientes descripciones: ', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'class' => 'widget-description-header',
            ),
            //Home banner settings
            'hr4' => array(
                'type' => 'hr',
                'class' => 'hr-default',
            ),
            'section_home_banner' => array(
                'title' => __('Banner en la pagina de inicio', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'class' => 'section-header',
            ),
            'home_banner_enabled' => array(
                'title' => __('Estado del Banner', 'buy-now-pay-later-addi'),
                'label' => __('Activar banner promocional', 'buy-now-pay-later-addi'),
                'type' => 'checkbox',
                'default' => 'no',
                'desc_tip' => true,
            ),
            'field_home_banner_position' => array(
                'title' => __('Ubicación del Banner', 'buy-now-pay-later-addi'),
                'type' => 'select',
                'default' => 'on_header',
                'desc_tip' => false,
                'options' => array(
                    'on_header' => 'Parte superior del Inicio',
                    'on_footer' => 'Parte inferior del Inicio',
                    'custom' => 'Personalizado',
                )
            ),
            'element_reference' => array(
                'type' => 'text',
                'default' => '',
                'desc_tip' => false,
                'description' => __('Para una ubicación personalizada, ingresa el ID o clase CSS del elemento donde deseas mostrar el banner. Por ejemplo: #miId o .miClase', 'buy-now-pay-later-addi'),
            ),
            'field_home_banner_type' => array(
                'title' => __('Estilo del Banner', 'buy-now-pay-later-addi'),
                'type' => 'select',
                'default' => 'banner_02',
                'desc_tip' => false,
                'options' => array(
                    'default' => 'default',
                    'banner_01' => 'banner_01',
                    'banner_02' => 'banner_02',
                    'banner_03' => 'banner_03',
                )
            ),
            //Widget settings
            'hr3' => array(
                'type' => 'hr',
                'class' => 'hr-default',
            ),
            'section_widget' => array(
                'title' => __('Widget de Addi en Página de Producto', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'class' => 'section-header',
            ),
            'widget_enabled' => array(
                'title' => __('Estado del Widget', 'buy-now-pay-later-addi'),
                'label' => __('Activar widget', 'buy-now-pay-later-addi'),
                'type' => 'checkbox',
                'description' => __('Muestra el widget de ADDI en la página de producto.', 'buy-now-pay-later-addi'),
                'default' => 'no',
            ),
            'conf_widget_position' => array(
                'title' => __('Posición del widget', 'buy-now-pay-later-addi'),
                'type' => 'select',
                'default' => 'woocommerce_single_product_summary',
                'desc_tip' => false,
                'options' => array(
                    'woocommerce_single_product_summary' => __('Ubicación predeterminada (Debajo del precio del producto)', 'buy-now-pay-later-addi'),
                    'woocommerce_before_add_to_cart_form' => __('Arriba del formulario de compra', 'buy-now-pay-later-addi'),
                    'woocommerce_after_add_to_cart_form' => __('Debajo del formulario de compra', 'buy-now-pay-later-addi'),
                    'woocommerce_product_meta_start' => __('Arriba de la información adicional', 'buy-now-pay-later-addi'),
                    'woocommerce_product_meta_end' => __('Debajo de la información adicional', 'buy-now-pay-later-addi'),
                )
            ),
            'section_widget_header' => array(
                'title' => __('Configuración de estilos del widget', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'class' => 'section-header',
            ),
            'widgetBorderColor' => array(
                'title' => __('Color del borde del widget', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Ingresa el color del borde del widget (nombre del color o código HEX).', 'buy-now-pay-later-addi'),
                'default' => 'black',
                'desc_tip' => true,
            ),
            'widgetBorderRadius' => array(
                'title' => __('Radio del Borde', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Ingresa el radio de curvatura del borde del widget (ejemplo: 5px).', 'buy-now-pay-later-addi'),
                'default' => '5px',
                'desc_tip' => true,
            ),
            'widgetFontColor' => array(
                'title' => __('Color del Texto', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Ingresa el color del texto del widget (nombre del color o código HEX).', 'buy-now-pay-later-addi'),
                'default' => 'black',
                'desc_tip' => true,
            ),
            'widgetFontFamily' => array(
                'title' => __('Tipo de fuente', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Indica el tipo de fuente que quieres usar para el widget de ADDI que aparece en la página de producto.', 'buy-now-pay-later-addi'),
                'default' => 'system-ui',
                'desc_tip' => true,
            ),
            'widgetFontSize' => array(
                'title' => __('Tamaño del Texto', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Ingresa el tamaño del texto del widget (ejemplo: 14px).', 'buy-now-pay-later-addi'),
                'default' => '14px',
                'desc_tip' => true,
            ),
            'widgetBadgeBackgroundColor' => array(
                'title' => __('Color de Fondo del Logo', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Ingresa el color de fondo para el contenedor del logo de ADDI (nombre del color o código HEX).', 'buy-now-pay-later-addi'),
                'default' => '#fff',
                'desc_tip' => true,
            ),
            'widgetInfoBackgroundColor' => array(
                'title' => __('Color de Fondo del Widget', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Ingresa el color de fondo para todo el widget (nombre del color o código HEX).', 'buy-now-pay-later-addi'),
                'default' => 'transparent',
                'desc_tip' => true,
            ),
            'widgetMargin' => array(
                'title' => __('Márgenes', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Ingresa el espacio exterior del widget (ejemplo: 10px o 1em).', 'buy-now-pay-later-addi'),
                'default' => '0',
                'desc_tip' => true,
            ),
            'modalBadgeLogoStyle' => array(
                'title' => __('Usar Logo en Color Blanco', 'buy-now-pay-later-addi'),
                'label' => __(' ', 'buy-now-pay-later-addi'),
                'type' => 'checkbox',
                'default' => 'no',
                'desc_tip' => false,
            ),
            //Modal configuration
            'widget_section_modal_header' => array(
                'title' => __('Configuración Estilos Modal', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'class' => 'section-header',
            ),
            'modalBackgroundColor' => array(
                'title' => __('Color de fondo', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Indica el color (palabra o código HEX) del fondo para el modal con la información de ADDI.', 'buy-now-pay-later-addi'),
                'default' => '#eee',
                'desc_tip' => true,
            ),
            'modalFontColor' => array(
                'title' => __('Color de fuente', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Indica el color (palabra o código HEX) de la fuente para el modal con la información de ADDI.', 'buy-now-pay-later-addi'),
                'default' => 'black',
                'desc_tip' => true,
            ),
            'modalPriceColor' => array(
                'title' => __('Color del precio', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Indica el color (palabra o código HEX) para el precio en el modal.', 'buy-now-pay-later-addi'),
                'default' => '#3c65ec',
                'desc_tip' => true,
            ),
            'modalBadgeBackgroundColor' => array(
                'title' => __('Color de fondo del banner', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Indica el color (palabra o código HEX) para el fondo del banner de tasa de interés.', 'buy-now-pay-later-addi'),
                'default' => '#4cbd99',
                'desc_tip' => true,
            ),
            'modalBadgeBorderRadius' => array(
                'title' => __('Curvatura del borde banner', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Indica el tamaño de la curvatura para el borde del banner de tasa de interés.', 'buy-now-pay-later-addi'),
                'default' => '5px',
                'desc_tip' => true,
            ),
            'modalBadgeFontColor' => array(
                'title' => __('Color del texto del banner', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Indica el color (palabra o código HEX) para la fuente del banner de tasa de interés.', 'buy-now-pay-later-addi'),
                'default' => 'white',
                'desc_tip' => true,
            ),
            'modalCardColor' => array(
                'title' => __('Color de fondo del modal', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Indica el color (palabra o código HEX) para el fondo del modal. ', 'buy-now-pay-later-addi'),
                'default' => 'white',
                'desc_tip' => true,
            ),
            'modalButtonBorderColor' => array(
                'title' => __('Color del borde del botón', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __(' Indica el color (palabra o código HEX) para el borde del botón del modal.', 'buy-now-pay-later-addi'),
                'default' => '#4cbd99',
                'desc_tip' => true,
            ),
            'modalButtonBorderRadius' => array(
                'title' => __('Curvatura del borde del botón', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Indica el tamaño de la curvatura para el borde del widget de ADDI que aparece en la página de producto.', 'buy-now-pay-later-addi'),
                'default' => '5px',
                'desc_tip' => true,
            ),
            'modalButtonBackgroundColor' => array(
                'title' => __('Color de fondo del botón', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Indica el color (palabra o código HEX) para el fondo del botón.', 'buy-now-pay-later-addi'),
                'default' => 'transparent',
                'desc_tip' => true,
            ),
            'modalButtonFontColor' => array(
                'title' => __('Color del texto del botón', 'buy-now-pay-later-addi'),
                'type' => 'text',
                'description' => __('Indica el color (nombre o código HEX) para el texto del botón.', 'buy-now-pay-later-addi'),
                'default' => '#4cbd99',
                'desc_tip' => true,
            ),
        );

        $brazilCheckoutFieldspluginPath = 'woocommerce-extra-checkout-fields-for-brazil/woocommerce-extra-checkout-fields-for-brazil.php';
        $checkoutFieldEditorAndManagerForWoocommercePath = 'checkout-field-editor-and-manager-for-woocommerce/start.php';
        $fieldEditorForWoocommercePluginPath = 'woo-checkout-field-editor-pro/checkout-form-designer.php';
        $yithWoocommerceCheckoutManagerPath = 'yith-woocommerce-checkout-manager/init.php';

        if (
            is_plugin_active($fieldEditorForWoocommercePluginPath) ||
            is_plugin_active($checkoutFieldEditorAndManagerForWoocommercePath) ||
            is_plugin_active($brazilCheckoutFieldspluginPath) ||
            is_plugin_active($yithWoocommerceCheckoutManagerPath)
        ) {
            set_transient("buy-now-pay-later-addi", "alive", 3);
        } else {

            $wc_array = array();

            if (isset(WC()->checkout)) {
                $wc_array = WC()->checkout->get_checkout_fields();
            }

            if (isset($wc_array) && isset($wc_array['billing'])) {

                foreach ($wc_array['billing'] as $key1 => $billing) {

                    switch ($key1) {
                        case "billing_cedula":
                            setcookie("billingField", "billing_cedula", time() + 120);
                            break;
                        case "billing_cpf":
                            setcookie("billingField", "billing_cpf", time() + 120);
                            break;
                        case "billing_id":
                            setcookie("billingField", "billing_id", time() + 120);
                    }

                }

            }
        }

        if (!function_exists('fx_addi_brazilcheckouteditor_notice') && is_plugin_active($brazilCheckoutFieldspluginPath)) {
            /* Add admin notice */
            add_action('admin_notices', function () {
                if ("alive" == get_transient("buy-now-pay-later-addi") || !isset ($this->field_id)) {
                    ?>
                    <div class="notice-warning notice is-dismissible">
                        <p>O plug-in <strong>Brazilian market for WooCommerce</strong> está instalado e modifica os campos de checkout.
                            Certifique-se de indicar o identificador do campo do documento para garantir o funcionamento correto do
                            <strong>ADDI</strong> plug-in.
                        </p>
                    </div>
                    <?php
                    /* Delete transient, only display this notice once. */
                    delete_transient("buy-now-pay-later-addi");
                } else {
                    return;
                }
            });
        }

        if (!function_exists('fx_addi_checkouteditor_notice') && is_plugin_active($checkoutFieldEditorAndManagerForWoocommercePath)) {
            /* Add admin notice */
            add_action('admin_notices', function () {
                if ("alive" == get_transient("buy-now-pay-later-addi") || !isset ($this->field_id)) {
                    ?>
                    <div class="notice-warning notice is-dismissible">
                        <p>El plug-in <strong>Checkout Field Editor and Manager for Woocommerce</strong> está instalado y este modifica los
                            campos del checkout. Por favor, asegúrate de configurar el nombre para el campo de documento y así asegurar el
                            correcto funcionamiento de <strong>ADDI</strong>.</p>
                    </div>
                    <?php

                } else {
                    return;
                }
                /* Delete transient, only display this notice once. */
                delete_transient("buy-now-pay-later-addi");
            });
        }

        if (!function_exists('fx_addi_checkouteditor_notice') && is_plugin_active($fieldEditorForWoocommercePluginPath)) {
            /* Add admin notice */
            add_action('admin_notices', function () {
                if ("alive" == get_transient("buy-now-pay-later-addi") || !isset ($this->field_id)) {
                    ?>
                    <div class="notice-warning notice is-dismissible">
                        <p>El plug-in <strong>Checkout Field Editor for Woocommerce</strong> está instalado y este modifica los campos del
                            checkout. Por favor, asegúrate de configurar el nombre para el campo de documento y así asegurar el correcto
                            funcionamiento de <strong>ADDI</strong>.</p>
                    </div>
                    <?php

                } else {
                    return;
                }
                /* Delete transient, only display this notice once. */
                delete_transient("buy-now-pay-later-addi");
            });
        }

        if (!function_exists('fx_addi_checkouteditor_notice') && is_plugin_active($yithWoocommerceCheckoutManagerPath)) {
            /* Add admin notice */
            add_action('admin_notices', function () {
                if ("alive" == get_transient("buy-now-pay-later-addi") || !isset ($this->field_id)) {
                    ?>
                    <div class="notice-warning notice is-dismissible">
                        <p>El plug-in <strong>Yith Woocommerce Checkout Manager</strong> está instalado y este modifica los campos del
                            checkout. Por favor, asegúrate de configurar el nombre para el campo de documento y así asegurar el correcto
                            funcionamiento de <strong>ADDI</strong>.</p>
                    </div>
                    <?php

                } else {
                    return;
                }
                /* Delete transient, only display this notice once. */
                delete_transient("buy-now-pay-later-addi");
            });
        }
    }
    
    /**
     * You will need it if you want your custom credit card form, Step 4 is about it
     */
    public function payment_fields(){

        // Only show payment fields on checkout page
        if (!is_checkout() || is_cart()) {
            return;
        }
        
        global $woocommerce;
        global $wp;

        $api_app_url = ''; // Default initialization
        $options_api = []; // Initialize as empty array

        if (isset($woocommerce->cart->total)) {
            if ($woocommerce->cart->total !== null) {
                $totals = $woocommerce->cart->total;
            } else {
                $totals = 0;
            }
        } else {
            $totals = 0;
        }

        if ($totals) {
            $options_api = [
                "headers" => [
                    "Content-Type" => "application/json",
                    "accept" => "application/json",
                    "WWW-Authenticate" => "Basic realm='" . gethostname() . "'",
                    "x-addi-woocommerce-version" => $this->version,
                ],
                "timeout" => 60,
                "data_format" => "body",
            ];

            if (get_locale() == "pt_PT" || get_locale() == "pt_BR") {
                $api_domain = $this->testmode
                    ? "https://channels-public-api.addi-staging-br.com/allies/"
                    : "https://channels-public-api.addi.com.br/allies/";
                $api_app_url =
                    $api_domain .
                    $this->widget_slug .
                    "/config?requestedAmount=" .
                    $totals;
            } else {
                $api_domain = $this->testmode
                    ? "https://channels-public-api.addi-staging.com/allies/"
                    : "https://channels-public-api.addi.com/allies/";
                $api_app_url =
                    $api_domain .
                    $this->widget_slug .
                    "/config?requestedAmount=" .
                    $totals;
            }

        } else {
            $this->has_requested_amount = false;
        }
        
        // request
        $api_response = wp_remote_get($api_app_url, $options_api);
        AddiLogger::logger_dna("GET_ALLY_CONFIG");

        if (!is_wp_error($api_response) && $this->has_requested_amount) {
            // getting decoded body
            $body_api_response = json_decode($api_response["body"], true);
            // Checking for erros
            if (!isset($body_api_response["widgetConfig"])) {
                // Logging an error
                $error_msg =
                    $body_api_response["code"] .
                    " " .
                    $body_api_response["message"];
                AddiLogger::logger_dna(
                    "GET_ALLY_CONFIG_ERROR",
                    $error_msg,
                    $api_app_url,
                    "GET"
                );
            }
            $country =
                get_locale() == "pt_PT" || get_locale() == "pt_BR"
                    ? "br"
                    : "co";
            $installments = number_format($totals / 4, 2);
            // Including the required template
            $plugin_path =
                WP_PLUGIN_DIR . "/" . plugin_basename(dirname(__DIR__));

            // Getting the template version
            $widgetversion = isset(
                $body_api_response["widgetConfig"]["widgetVersion"]
            )
                ? $body_api_response["widgetConfig"]["widgetVersion"]
                : null;
            $template_version = "bnpl";

            $checkout_version = isset(
                $body_api_response["checkoutConfig"]["version"]
            )
                ? $body_api_response["checkoutConfig"]["version"]
                : "DEFAULT";
            $is_active_paynow = isset($body_api_response["isActivePayNow"])
                ? $body_api_response["isActivePayNow"]
                : false;

            $bnpn_discount = 0;
            if (isset($body_api_response["policies"])) {
                foreach ($body_api_response["policies"] as $policy) {
                    if ($policy["productType"] === "ADDI_BNPN") {
                        $bnpn_discount = $policy["discount"];
                        break;
                    }
                }
            }

            if($is_active_paynow){
                add_action('wp_footer', 'bnpn_new_title');
            }

            $discount =
                isset($body_api_response["policy"]["discount"]) &&
                $body_api_response["policy"]["discount"] > 0
                    ? $body_api_response["policy"]["discount"]
                    : false;
            $min_amount = false;
            $max_amount = false;
            if (
                (isset($body_api_response["minAmount"]) &&
                    $body_api_response["minAmount"] !== "") ||
                $body_api_response["code"] == "007-015"
            ) {
                $min_amount = number_format(
                    intval($body_api_response["minAmount"]),
                    0,
                    ",",
                    "."
                );
            }

            if (
                isset($body_api_response["maxAmount"]) &&
                $body_api_response["maxAmount"] !== ""
            ) {
                $max_amount = number_format(
                    intval($body_api_response["maxAmount"]),
                    0,
                    ",",
                    "."
                );
            }

            if (
                isset($widgetversion) &&
                ($widgetversion === "1.0.2" ||
                    ($widgetversion === "ADDI_TEMPLATE_02" &&
                        $widgetversion === "ADDI_TEMPLATE_02_NO_CHECKOUT"))
            ) {
                $template_version = "bnpl_bnpn";
            }

            if (
                isset($widgetversion) &&
                $widgetversion === "ADDI_TEMPLATE_FLEX" &&
                $widgetversion === "ADDI_TEMPLATE_FLEX_NO_CHECKOUT"
            ) {
                $template_version = "flex";
            }

            if ($is_active_paynow && $checkout_version !== "DEFAULT") {
                $template_version = strtolower($checkout_version);
            }

            $template =
                $plugin_path .
                "/templates/" .
                $country .
                "/" .
                $template_version .
                ".php";
            $min_amount_int = isset($body_api_response["minAmount"]) ? $body_api_response["minAmount"] : 0;
            $max_amount_int = isset($body_api_response["maxAmount"]) ? $body_api_response["maxAmount"] : 0;

            if ($country == "br") {
                $params = [
                    "installments" => $installments,
                    "total" => $totals,
                    "discount" => $discount,
                    "min_amount" => $min_amount,
                    "max_amount" => $max_amount,
                    "min_amount_int" => $min_amount_int,
                    "max_amount_int" => $max_amount_int,
                ];
            } else {
                $params = [
                    "discount" => $discount,
                    "bnpn_discount" => $bnpn_discount,
                    "widgetversion" => $widgetversion,
                    "total" => $totals,
                    "min_amount" => $min_amount,
                    "max_amount" => $max_amount,
                    "min_amount_int" => $min_amount_int,
                    "max_amount_int" => $max_amount_int,
                ];
            }
            $from_blocks = class_exists('Automattic\\WooCommerce\\Blocks\\Payments\\Integrations\\AbstractPaymentMethodType') && function_exists('wc_get_page_id') && has_block('woocommerce/checkout', wc_get_page_id('checkout'));
            //echo $this->render_template($template, $params);
            echo $this->healthcheck_validation($widgetversion);
            
            if($from_blocks){
                return $this->render_template($template, $params);
            }else{
                echo $this->render_template($template, $params);
            }
        } else {
            $error_msg = $api_response->get_error_message();
            AddiLogger::logger_dna(
                "GET_ALLY_CONFIG_ERROR",
                $error_msg,
                $api_app_url,
                "GET"
            );
        }
    }

    /**
     * Here we call the health check to send status information of the ally
     */
    private function healthcheck_validation($widgetversion)
    {
        if (
            isset($widgetversion) && (
                $widgetversion !== 'ADDI_TEMPLATE_01_NO_CHECKOUT' &&
                $widgetversion !== 'ADDI_TEMPLATE_02_NO_CHECKOUT' &&
                $widgetversion !== 'ADDI_TEMPLATE_FLEX_NO_CHECKOUT'
            )
        ) {
            $checkouts = WC()->payment_gateways()->get_available_payment_gateways();
            $api_health_check_url = 'https://stores-health.addi.com/healthcheck';
            $body_health_check = [
                'allySlug' => $this->widget_slug,
                'component' => 'CHECKOUT',
                'checkoutPosition' => array_search('Addi', array_column($checkouts, 'method_title')) + 1,
                'checkoutMethods' => count($checkouts)
            ];
            $options_health_check = [
                'body' => json_encode($body_health_check),
                'headers' => [
                    'Content-Type' => 'application/json',
                    'accept' => 'application/json',
                ],
                'timeout' => 60,
                'data_format' => 'body',
            ];
            $api_response_health_check = wp_remote_post($api_health_check_url, $options_health_check);

            if (is_wp_error($api_response_health_check)) {
                if (isset($api_response_health_check['code'])) {
                    $error_message = json_decode($api_response_health_check['code'], true);
                } else {
                    $error_message = $api_response_health_check->get_error_message();
                }
                $logger->info('ERROR calling addi health check code:' . $error_message);
            }
        }
    }

    private function render_template(/*$template, $variables*/)
    {
        ob_start();
        foreach (func_get_args()[1] as $key => $value) {
            ${$key} = $value;
        }
        include func_get_args()[0];
        return ob_get_clean();
    }

    /*
     * Custom CSS and JS, in most cases required only when you decided to go with a custom credit card form
     */
    public function payment_scripts()
    {


    }

    /*
    * We're processing the payments here
    */
    public function process_payment($order_id)
    {

        global $woocommerce;
        global $wp;

        // LOAD THE WC LOGGER
        $logger = wc_get_logger();

        //we need it to get any order details
        $order = wc_get_order($order_id);
        $_SESSION["order_id_process_payment"] = $order_id;

        try {
            if (!is_admin()) {
                WC()->session->set('order_id_payment_session', $order_id);
            }
        } catch (Exception $e) {
            if ($this->logs == 'yes') {
                $logger->info('  ERROR saving variable session in Woocommerce :   ' . $e . ' ', array('source' => 'addi-error-handler-log'));
            }
        }

        //taking corresponding api and credentials
        $api_selected = $this->testmode ? ((get_locale() == 'pt_PT' || get_locale() == 'pt_BR') ? 'https://api.addi-staging-br.com' : 'https://api.staging.addi.com') : ((get_locale() == 'pt_PT' || get_locale() == 'pt_BR') ? 'https://api.addi.com.br' : 'https://api.addi.com');
        $client_id_selected = $this->prod_client_id;
        $client_secret_selected = $this->prod_client_secret;

        /*
         * Array with parameters for API interaction
         */

        $body_auth = [
            'audience' => $api_selected,
            'grant_type' => 'client_credentials',
            'client_id' => $client_id_selected,
            'client_secret' => $client_secret_selected,
        ];

        $body_auth = wp_json_encode($body_auth);

        $options_auth = [
            'body' => $body_auth,
            'headers' => [
                'Content-Type' => 'application/json',
                'accept' => 'application/json',
            ],
            'timeout' => 60,
            'data_format' => 'body',
        ];

        // getting api url based on test mode checkbox
        $auth_app_url = $this->testmode ? ((get_locale() == 'pt_PT' || get_locale() == 'pt_BR') ? 'https://auth.addi-staging-br.com/oauth/token' : 'https://auth.addi-staging.com/oauth/token') : ((get_locale() == 'pt_PT' || get_locale() == 'pt_BR') ? 'https://auth.addi.com.br/oauth/token' : 'https://auth.addi.com/oauth/token');

        // request
        $auth_response = wp_remote_post($auth_app_url, $options_auth);

        // verify if body response is an error or contains data
        $body_auth_response = json_decode($auth_response['body'], true);

        if (!is_array($body_auth_response)) {
            $body_auth_response = array();
        }

        $denied = $auth_response['response']['code'] != '200';

        if (!is_wp_error($auth_response) && !$denied) {
            // getting decoded body
            $items = [];
            $client = new stdClass();
            $client_address = new stdClass();
            $allyUrlRedirection = new stdClass();

            // Get and Loop Over Order Items
            foreach ($order->get_items() as $item_id => $item) {

                $object = new stdClass();
                //Get the WC_Product object
                $product = $item->get_product();
                $object->sku = $product->get_sku();
                $object->name = $item->get_name();
                $object->quantity = $item->get_quantity();
                $object->unitPrice = $product->get_regular_price();
                $object->tax = $item->get_subtotal_tax();
                $object->pictureUrl = wp_get_attachment_url($product->get_image_id());
                $object->category = $product->get_type();
                array_push($items, $object);
            }

            // Get Address Client
            $client_address->lineOne = isset($this->field_billing_address_1) && ($this->field_billing_address_1 !== '') ?
                WC()->checkout->get_value('' . $this->field_billing_address_1 . '') :
                (($order->get_shipping_address_1() !== "" && $order->get_shipping_address_1() !== " ") ?
                    $order->get_shipping_address_1() : $order->get_billing_address_1());

            $client_address->city = isset($this->field_billing_city) && ($this->field_billing_city !== '') ?
                WC()->checkout->get_value('' . $this->field_billing_city . '') :
                (($order->get_shipping_city() !== "" && $order->get_shipping_city() !== " ") ?
                    $order->get_shipping_city() : $order->get_billing_city());

            $client_address->country = (get_locale() == 'pt_PT' || get_locale() == 'pt_BR') ? 'BR' : 'CO';


            // // Get Order Client
            $id = '';
            // Check if the field_id is set in the classic checkout
            if (isset($this->field_id) && ($this->field_id !== '')) {
                $id = WC()->checkout->get_value('' . $this->field_id . '');

                if ((get_locale() == 'pt_PT' || get_locale() == 'pt_BR')) {
                    $id = str_replace('.', '', $id);
                    $id = str_replace('-', '', $id);
                }
            } else {
                if ((get_locale() == 'pt_PT' || get_locale() == 'pt_BR')) {
                    $id = WC()->checkout->get_value('billing_cpf') !== "" && WC()->checkout->get_value('billing_cpf') !== " " ? WC()->checkout->get_value('billing_cpf') : WC()->checkout->get_value('billing_id');

                    $id = str_replace('.', '', $id);
                    $id = str_replace('-', '', $id);

                } else {
                    $billing_cedula = WC()->checkout->get_value('billing_cedula');
                    $billing_id = WC()->checkout->get_value('billing_id');
                    $billing_nmero = WC()->checkout->get_value('billing_nmero');
                    $billing_numero = WC()->checkout->get_value('billing_numero');

                    if (isset($billing_id)) {
                        $id = $billing_id;
                    } else if (isset($billing_cedula)) {
                        $id = $billing_cedula;
                    } else if (isset($billing_nmero)) {
                        $id = $billing_nmero;
                    } else if (isset($billing_numero)) {
                        $id = $billing_numero;
                    }
                }
            }

            $client->idType = (get_locale() == 'pt_PT' || get_locale() == 'pt_BR') ? 'CPF' : 'CC';

            $request = json_decode(file_get_contents('php://input'), true);

            $id_number = $request['billing_address']['addi/cedula-id'] ?? $request['shipping_address']['addi/cedula-id'] ?? $id ?? null;

            $id_number = sanitize_text_field($id_number);

            if (!empty($id_number)) {
                $client->idNumber = $id_number;
            } else {
                error_log('ADDI: No se recibió la cédula en el checkout.');
                $error_message = __('Por favor ingrese su número de cédula para continuar. En caso de no ver el campo, por favor comuníquese con el administrador de la página.', 'buy-now-pay-later-addi');
                if (wp_is_json_request()) {
                    throw new Exception($error_message);
                } else {
                    wc_add_notice($error_message, 'error');
                    return;
                }
            }

            $client->firstName = isset($this->field_billing_first_name) && ($this->field_billing_first_name !== '') ?
                WC()->checkout->get_value('' . $this->field_billing_first_name . '') :
                (($order->get_shipping_first_name() !== "" && $order->get_shipping_first_name() !== " ") ?
                    $order->get_shipping_first_name() : $order->get_billing_first_name());

            $client->lastName = isset($this->field_billing_last_name) && ($this->field_billing_last_name !== '') ?
                WC()->checkout->get_value('' . $this->field_billing_last_name . '') :
                (($order->get_shipping_last_name() !== "" && $order->get_shipping_last_name() !== " ") ?
                    $order->get_shipping_last_name() : $order->get_billing_last_name());

            $client->email = isset($this->field_billing_email) && ($this->field_billing_email !== '') ?
                WC()->checkout->get_value('' . $this->field_billing_email . '') :
                $order->get_billing_email();

            $client->cellphone = isset($this->field_billing_phone) && ($this->field_billing_phone !== '') ?
                WC()->checkout->get_value('' . $this->field_billing_phone . '') :
                $order->get_billing_phone();

            $client->cellphoneCountryCode = (get_locale() == 'pt_PT' || get_locale() == 'pt_BR') ? '+55' : '+57';
            $client->address = $client_address;

            // //Get URL redirection
            $site_url = get_site_url();
            // note: may this code will not be needed in the future
            // $url = str_replace( 'https://', 'http://', $site_url );
            $allyUrlRedirection->logoUrl = '';
            $allyUrlRedirection->callbackUrl = $site_url . '/?wc-api=wc_addi_gateway';
            // Removing this redirect while we figure out the correct way to redirect after an error
            $allyUrlRedirection->redirectionUrl = $order->get_checkout_order_received_url();
            $account_url = get_permalink(get_option('woocommerce_myaccount_page_id'));
            //$allyUrlRedirection->redirectionUrl = $account_url . '/view-order/' . $order->get_id();
            $allyUrlRedirection->checkoutUrl = wc_get_checkout_url();
            /*
             * Array with parameters for API interaction
             */
            $body_online_application = [
                'orderId' => $order->get_id(),
                'totalAmount' => number_format($order->get_total(), 1, '.', ''),
                'shippingAmount' => number_format($order->get_shipping_total(), 1, '.', ''),
                'totalTaxesAmount' => number_format(round((($order->get_total() / 1.19) * 1.19) - ($order->get_total() / 1.19), 1), 1, '.', ''),
                'currency' => (get_locale() == 'pt_PT' || get_locale() == 'pt_BR') ? 'BRL' : 'COP',
                'ecommercePlatform' => 'WOOCOMMERCE',
                'items' => $items,
                'client' => $client,
                'shippingAddress' => $client_address,
                'allyUrlRedirection' => $allyUrlRedirection,
            ];

            $body_online_application = wp_json_encode($body_online_application);

            $options_online_application = [
                'body' => $body_online_application,
                'headers' => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
                    'Authorization' => 'Bearer ' . $body_auth_response['access_token'] . '',
                ],
                'timeout' => 100,
                'data_format' => 'body',
            ];

            // getting api url based on test mode checkbox
            $online_app_url = $this->testmode ?
                ((get_locale() == 'pt_PT' || get_locale() == 'pt_BR') ?
                    'https://api.addi-staging-br.com/v1/online-applications' : 'https://api.addi-staging.com/v1/online-applications') :
                ((get_locale() == 'pt_PT' || get_locale() == 'pt_BR') ?
                    'https://api.addi.com.br/v1/online-applications' : 'https://api.addi.com/v1/online-applications');

            // request
            $online_application_response = wp_remote_post($online_app_url, $options_online_application);
            
            // Check if the request was successful
            $status_code = wp_remote_retrieve_response_code($online_application_response);
            
            $expected_status_codes = [200, 301, 302];

            if (!in_array($status_code, $expected_status_codes, true)) {
                $logger->error(
                    'ADDI API Error - Unexpected status code: ' . $status_code . '\n' .
                    'Response: ' . print_r($online_application_response, true) . '\n' .
                    'Request body: ' . $body_online_application . '\n' .
                    'Request URL: ' . $online_app_url,
                    array('source' => 'addi-error-handler-log')
                );
            }
            
            // verify if body response is an error or contains data
            $body_online_application_response = json_decode($online_application_response['body'], true);

            if (!is_array($body_online_application_response)) {
                $body_online_application_response = array();
            }

            $invalid = in_array("000-009", $body_online_application_response) || in_array("El documento de identidad es inválido", $body_auth_response) || in_array("documento", $body_auth_response) || in_array("inválido", $body_auth_response);
            // verify if body response is an error or contains data
            if (!is_wp_error($online_application_response) && !$invalid) {

                try {
                    // getting decoded body
                    $http_response_history = $online_application_response['http_response']->get_response_object()->history;
                    $found = false;
                    $location_value = null;

                    //loop in response in order to look for a location header with a determined search parameter, it will
                    //contain Addi redirect url
                    foreach ($http_response_history as $key => $value) {
                        $response_link = $value->url;
                        if (isset($response_link)) {
                            $location_value = $response_link;
                            $found = true;
                            break;
                        }
                    }

                    //Redirect to addi checkout page
                    return array(
                        'result' => 'success',
                        'redirect' => $location_value
                    );
                } catch (Exception $e) {
                    // If something go wrong, show notification
                    $error_message = __('Error procesando el pedido. Por favor, inténtalo de nuevo.', 'buy-now-pay-later-addi');

                    if (wp_is_json_request()) {
                        throw new Exception($error_message);
                    } else {
                        wc_add_notice($error_message, 'error');
                        return;
                    }
                }

            } else {
                // If something go wrong, show notification
                $error_message = __('Error procesando el pedido. Documento de identidad inválido. Por favor, inténtalo de nuevo.', 'buy-now-pay-later-addi');

                if (wp_is_json_request()) {
                    throw new Exception($error_message);
                } else {
                    wc_add_notice($error_message, 'error');
                    return;
                }
            }

            return;
        } else {
            // If something go wrong, show notification
            $error_message = $this->testmode ?
                __('Error procesando el pedido. Las credenciales para Addi son inválidas. Además, el modo de pruebas está ACTIVO.', 'buy-now-pay-later-addi') :
                __('Error procesando el pedido. Las credenciales para Addi son inválidas. Por favor, verifica que sean correctas e inténtalo nuevamente.', 'buy-now-pay-later-addi');

            if (wp_is_json_request()) {
                throw new Exception($error_message);
            } else {
                wc_add_notice($error_message, 'error');
                return;
            }
        }
    }

    /* Function to start sessions : sessions are necesarry to store order id and use it when third party page is redirecting to checkout page
     * Disclaimer: use of this function may conflict with server based cache services, we cannot support it’s use on servers. if this is the case,
     * please contact an administrator.
     */
    function addi_start_session()
    {

        global $wp;
        global $wpdb;

        if (!session_id()) {
            session_start();
        }
    }

    /*
     * Callback function to process Addi response from official website
     */
    public function addi_callback_handler()
    {

        global $woocommerce;
        global $wp;
        global $wpdb;

        // LOAD THE WC LOGGER
        $logger = wc_get_logger();

        // set init headers
        // content should be json
        // accept json only
        header('Content-type: application/json');
        header('Accept: application/json');

        if ($this->logs == 'yes') {
            // Log authentication details if they exist
            if (isset($_SERVER['PHP_AUTH_USER'])) {
                $logger->info('auth user: ' . $_SERVER['PHP_AUTH_USER'], array('source' => 'auth-log'));
            }
            
            if (isset($_SERVER['PHP_AUTH_PW'])) {
                $logger->info('auth PW present', array('source' => 'auth-log')); // Don't log the actual password
            }
            
            if (isset($_SERVER['REMOTE_USER'])) {
                $logger->info('remote User: ' . $_SERVER['REMOTE_USER'], array('source' => 'auth-log'));
            }
            
            if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
                $logger->info('Server Auth present', array('source' => 'auth-log')); // Don't log the full authorization header
            }
        }

        // verify if user/password are correct
        if (
            (base64_encode($_SERVER['PHP_AUTH_USER']) != base64_encode($this->callback_user)) ||
            (base64_encode($_SERVER['PHP_AUTH_PW']) != base64_encode($this->callback_password))
        ) {
            // if not, will return a 401 Unauthorized error
            header('WWW-Authenticate: Basic realm="' . gethostname() . '"');
            header('HTTP/1.0 401 Unauthorized');
            return 'Bad request, try again.';
            exit;
        } else {
            // init headers to return a success response
            header("Authorization: Basic " . base64_encode("$this->callback_user':'$this->callback_password"));
            header('HTTP/1.1 200 OK');
            // read parameter from body request / response
            $raw_post = file_get_contents('php://input');
            $table_name = $wpdb->prefix . "wc_addi_gateway";

            if (!empty($raw_post)) {
                // handle post data
                $callback_response = json_decode($raw_post, true);

                $callback_order_id = $callback_response['orderId'];
                $callback_status = $callback_response['status'];
                $callback_applicationId = $callback_response['applicationId'];

                try {
                    if (!is_admin()) {
                        WC()->session->set('order_id_callback', $callback_order_id);
                        WC()->session->set('order_status_callback', $callback_status);
                    }
                } catch (Exception $e) {
                    //error logged in logger object
                    $logger->info('  ERROR saving order id/ order status variable in callback method. Error details: ' . $e . ' ', array('source' => 'addi-gateway-log'));
                }
                // insert in table taking callback order id / callback status
                $wpdb->insert($table_name, array('order_id' => $callback_order_id, 'order_status' => $callback_status, 'date' => date("Y-m-d h:i:s")));

                if ($callback_status == 'APPROVED') {

                    try {

                        // get woocommerce order object
                        $order = wc_get_order($callback_order_id);
                        // The text for the note
                        $note = __("ApplicationId : " . $callback_applicationId);
                        // Add the note
                        $order->add_order_note($note);
                        // mark this order as completed
                        $order->payment_complete();

                        if ($this->custom_order_status == 'yes') {
                            $order->update_status('addi-approved', '', true);
                        }

                        // Reduce stock of product in the store
                        wc_reduce_stock_levels($order->get_id());
                        $order->set_transaction_id($callback_applicationId);
                        $order->save();

                        // // Empty cart
                        if (isset($woocommerce) && isset($woocommerce->cart)) {
                            $woocommerce->cart->empty_cart();
                        }

                        if ($this->logs == 'yes') {
                            $logger->info('Order with ID = ' . $callback_order_id . '. not proccesed correctly. ', array('source' => 'auth-log'));
                        }
                    } catch (Exception $e) {
                        if ($this->logs == 'yes') {
                            $logger->info('Error processing order with ID =  ' . $callback_order_id . '. Details : ' . $e, array('source' => 'auth-log'));
                        }
                    }
                } else {
                    // get woocommerce order object
                    $order = wc_get_order($callback_order_id);
                    // The text for the note
                    $note = __("ApplicationId : " . $callback_applicationId);
                    // Add the note
                    $order->add_order_note($note);
                    $order->set_transaction_id($callback_applicationId);
                    $order->save();
                }

                // returning same data post
                echo $raw_post;
                // exit
                die();
            } else {
                // returning same data post
                echo $raw_post;
                // exit
                die();
            }
        }
    }

    public function log_gateway_loaded()
    {
        AddiLogger::logger_dna('DISPLAY_PAYMENT_METHOD');
    }
}
