<?php
defined( 'ABSPATH' ) || die();
return [
	[
		'id'       => 'review_notice_shown',
		'menu_id'  => 'general',
		'group_id' => 'general',
		'type'     => 'hidden',
		'label'    => '',
		'disabled' => false,
		'default'  => false,
	],
	[
		'id'       => 'burst_tour_shown_once',
		'menu_id'  => 'general',
		'group_id' => 'general',
		'type'     => 'hidden',
		'label'    => '',
		'disabled' => false,
		'default'  => false,
	],
	[
		'id'       => 'not_writable',
		'menu_id'  => 'general',
		'group_id' => 'general',
		'type'     => 'hidden',
		'label'    => '',
		'default'  => false,
	],
	[
		'id'       => 'enable_turbo_mode',
		'menu_id'  => 'general',
		'group_id' => 'general',
		'type'     => 'checkbox',
		'label'    => __( 'Enable Turbo mode', 'burst-statistics' ),
		'context'  => [
			'text' => __( 'Load the tracking script later for better pagespeed, could cause visitors who leave quickly to be missed.', 'burst-statistics' ),
			'url'  => 'definition/turbo-mode/',
		],
		'disabled' => false,
		'default'  => false,
	],
	[
		'id'       => 'enable_cookieless_tracking',
		'menu_id'  => 'general',
		'group_id' => 'general',
		'type'     => 'checkbox',
		'label'    => __( 'Enable Cookieless tracking', 'burst-statistics' ),
		'context'  => [
			'text' => __( 'Track visitors without cookies using browser & device info.', 'burst-statistics' ),
			'url'  => 'definition/what-is-cookieless-tracking/',
		],
		'disabled' => false,
		'default'  => false,
	],
	[
		'id'       => 'enable_do_not_track',
		'menu_id'  => 'general',
		'group_id' => 'general',
		'type'     => 'checkbox',
		'label'    => __( "Honor 'Do Not Track' requests", 'burst-statistics' ),
		'context'  => __( "Stop tracking visitors who have 'Do Not Track' enabled in their browser.", 'burst-statistics' ),
		'disabled' => false,
		'default'  => false,
	],
	[
		'id'       => 'dismiss_non_error_notices',
		'menu_id'  => 'general',
		'group_id' => 'general',
		'type'     => 'checkbox',
		'label'    => __( 'Dismiss all notices in your dashboard except critical ones', 'burst-statistics' ),
		'disabled' => false,
		'default'  => false,
	],
	[
		'id'       => 'email_reports_mailinglist',
		'menu_id'  => 'general',
		'group_id' => 'email_reports',
		'type'     => 'email_reports',
		'label'    => __( 'Email reports', 'burst-statistics' ),
		'disabled' => false,
		'default'  => '',
	],
	[
		'id'       => 'logo_attachment_id',
		'menu_id'  => 'general',
		'group_id' => 'email_reports',
		'type'     => 'logo_editor',
		'label'    => __( 'Change logo in the email reports', 'burst-statistics' ),
		'context'  => __( 'Recommended size is 200 pixels by 70 pixels and try to keep the filesize under 200 kb.', 'burst-statistics' ),
		'pro'      => [
			'url' => 'pricing/',
		],
		'disabled' => false,
		'default'  => false,
	],
	[
		'id'       => 'tips_tricks_mailinglist',
		'menu_id'  => 'general',
		'group_id' => 'email_reports',
		'type'     => 'hidden',
		'label'    => '',
		'disabled' => false,
		'default'  => '',
	],
	[
		'id'          => 'send_email_report',
		'menu_id'     => 'general',
		'group_id'    => 'email_reports',
		'type'        => 'button',
		'action'      => 'send_email_report',
		'button_text' => __( 'Send', 'burst-statistics' ),
		'label'       => __( 'Send an e-mail report', 'burst-statistics' ),
		'context'     => __( 'This will send an e-mail to all listed recipients.', 'burst-statistics' ),
		'disabled'    => false,
		'default'     => false,
	],

	[
		'id'       => 'goals',
		'menu_id'  => 'goals',
		'group_id' => 'goals',
		'type'     => 'goals',
		'label'    => __( 'Goals', 'burst-statistics' ),
		'notice'   => [
			'label'       => 'default',
			'title'       => __( 'How to set goals?', 'burst-statistics' ),
			'description' => __( 'To set goals for a website, you need to identify the purpose of the site and the key actions you want visitors to take. Set measurable and achievable goals for each action and track your progress.', 'burst-statistics' ),
			'url'         => 'how-to-set-goals/',
		],
		'default'  => [],
	],
	[
		'id'       => 'user_role_blocklist',
		'menu_id'  => 'advanced',
		'group_id' => 'tracking',
		'type'     => 'checkbox_group',
		'label'    => __( 'Exclude user roles from being tracked', 'burst-statistics' ),
		'notice'   => [
			'label'       => 'default',
			'title'       => __( 'Excluding visitors', 'burst-statistics' ),
			'description' => __( 'You can exclude visitors by user role and IP address. This will affect new data only.', 'burst-statistics' ),
			'url'         => 'exclude-ip-addresses-from-burst-statistics/',
		],
		'disabled' => false,
		'default'  => false,
		'options'  => 'get_user_roles()',
	],
	[
		'id'          => 'ip_blocklist',
		'menu_id'     => 'advanced',
		'group_id'    => 'tracking',
		'type'        => 'ip_blocklist',
		'label'       => __( 'Exclude IP addresses from being tracked', 'burst-statistics' ),
		'context'     => __( 'Enter one IP address per line', 'burst-statistics' ),
		'recommended' => true,
		'disabled'    => false,
		'default'     => '',
	],
	[
		'id'       => 'geo_ip_database_type',
		'menu_id'  => 'advanced',
		'group_id' => 'data_collection',
		'type'     => 'radio',
		'label'    => __( 'Visitor location detail', 'burst-statistics' ),
		'disabled' => false,
		'default'  => 'city',
		'pro'      => [
			'url' => 'pricing/',
		],
		'options'  => [
			'city'    => [
				'label'       => __( 'Country, City & Region details', 'burst-statistics' ),
				'context'     => __( 'Provides detailed location data including city and region. This uses a larger database and may result in slightly slower tracking.', 'burst-statistics' ),
				'recommended' => true,
			],
			'country' => [
				'label'   => __( 'Country only', 'burst-statistics' ),
				'context' => __( 'Provides basic location insights. This uses a smaller database for faster tracking and less data storage.', 'burst-statistics' ),
			],
		],
	],
	[
		'id'       => 'burst_update_to_city_geo_database_time',
		'menu_id'  => 'advanced',
		'group_id' => 'data_collection',
		'type'     => 'hidden',
		'label'    => '',
		'disabled' => false,
		'default'  => 1751328000,
	],
	[
		'id'       => 'filtering_by_domain',
		'menu_id'  => 'advanced',
		'group_id' => 'data_collection',
		'type'     => (bool) get_option( 'burst_is_multi_domain' ) ? 'checkbox' : 'hidden',
		'label'    => __( 'Enable filtering by domain', 'burst-statistics' ),
		'context'  => __( 'If you use multiple domains on your website, you can enable this to start storing the domain, so you can filter your data by domain.', 'burst-statistics' ),
		'disabled' => true,
		'default'  => false,
		'pro'      => [
			'url'      => 'filtering-by-domain',
			'disabled' => false,
		],
	],
	[
		'id'       => 'track_url_change',
		'menu_id'  => 'advanced',
		'group_id' => 'data_collection',
		'type'     => 'checkbox',
		'label'    => __( 'Track URL changes as separate pageviews', 'burst-statistics' ),
		'context'  => __( 'URL changes such as parameters or fragments will be tracked as separate pageviews. Useful for single-page applications or dynamic websites.', 'burst-statistics' ),
		'disabled' => false,
		'default'  => false,
	],
	[
		'id'       => 'combine_vars_and_script',
		'menu_id'  => 'advanced',
		'group_id' => 'scripts',
		'type'     => 'checkbox',
		'label'    => __( 'Merge tracking settings and script', 'burst-statistics' ),
		'context'  => __( 'Boost site speed by merging the Burst settings into the Burst script.', 'burst-statistics' ),
		'disabled' => false,
		'default'  => true,
	],

	[
		'id'       => 'archive_data',
		'menu_id'  => 'data',
		'group_id' => 'data_archiving',
		'options'  => [

			'none'    => __( 'Don\'t manage', 'burst-statistics' ),
			'archive' => __( 'Automatically Archive', 'burst-statistics' ),
			'delete'  => __( 'Automatically Delete', 'burst-statistics' ),
		],
		'pro'      => [
			'url'      => 'pricing/',
			'disabled' => false,
		],
		'notice'   => [
			'label'       => 'default',
			'title'       => __( 'Why should I manage old data?', 'burst-statistics' ),
			'description' => __( 'Managing old data can optimize storage and improve site performance. Choose to archive or delete based on your needs.', 'burst-statistics' ),
			'url'         => 'do-I-need-to-archive-my-data/',
		],
		'disabled' => [ 'archive' ],
		'type'     => 'select',
		'label'    => __( 'Choose how to manage old statistics', 'burst-statistics' ),
		// translators: %s is the current size of the database used by Burst, e.g. "10 MB".
		'context'  => strlen( get_option( 'burst_table_size' ) ) > 1 ? sprintf( _x( 'Burst currently uses %s of your database.', 'e.g. Burst currently uses 10 MB of your database.', 'burst-statistics' ), get_option( 'burst_table_size' ) ) : '',
		'default'  => false,
	],
	[
		'id'               => 'archive_after_months',
		'menu_id'          => 'data',
		'group_id'         => 'data_archiving',
		'min'              => 12,
		'type'             => 'number',
		'label'            => __( 'Retain data for how many months?', 'burst-statistics' ),
		'disabled'         => false,
		'default'          => 24,
		'react_conditions' => [
			'archive_data' => [ 'archive', 'delete' ],
		],
	],
	[
		'id'               => 'confirm_delete_data',
		'menu_id'          => 'data',
		'group_id'         => 'data_archiving',
		'type'             => 'checkbox',
		'label'            => __( 'Please confirm the deletion, without the possibility to restore.', 'burst-statistics' ),
		'disabled'         => false,
		'default'          => false,
		'react_conditions' => [
			'archive_data' => [ 'delete' ],
		],
	],
	[
		'id'          => 'reset',
		'menu_id'     => 'data',
		'group_id'    => 'data_archiving',
		'type'        => 'button',
		'warnTitle'   => __( 'Are you sure?', 'burst-statistics' ),
		'warnContent' => __( 'This will permanently delete all statistics, goals, and goal statistics.', 'burst-statistics' ) . ' ' . __( 'This action can not be undone.', 'burst-statistics' ),
		// 'info', 'warning', 'danger.
		'warnType'    => 'danger',
		'action'      => 'reset',
		'button_text' => __( 'Reset statistics', 'burst-statistics' ),
		'label'       => __( 'Reset statistics', 'burst-statistics' ),
		'comment'     => __( 'This will permanently delete all statistics, goals, and goal statistics.', 'burst-statistics' ),
		'disabled'    => false,
		'default'     => false,
	],
	[
		'id'               => 'restore_archives',
		'menu_id'          => 'data',
		'group_id'         => 'restore_archives',
		'type'             => 'restore_archives',
		'disabled'         => false,
		'default'          => false,
		'react_conditions' => [
			'archive_data' => [ 'archive' ],
		],
	],
	[
		'id'       => 'enable_shortcodes',
		'menu_id'  => 'secret',
		'group_id' => 'secret',
		'type'     => 'checkbox',
		'label'    => __( 'Enable shortcodes', 'burst-statistics' ),
		'context'  => [
			'text' => __( 'Enable statistics shortcodes for use on your website.', 'burst-statistics' ),
			'url'  => 'burst-statistics-shortcodes/',
		],
		'disabled' => false,
		'default'  => false,
	],
];
