<?php
/**
 * @package   StoreX
 */

// Only load if plugin constants are defined
if (!defined('BURGER_COMPANION_PLUGIN_DIR')) {
	return;
}

// Double-check: Verify plugin is actually active
if (!function_exists('is_plugin_active')) {
	require_once(ABSPATH . 'wp-admin/includes/plugin.php');
}

if (!is_plugin_active('burger-companion/burger-companion.php')) {
	return; // Exit if plugin is not active
}

if ( ! function_exists( 'burger_companion_storex_frontpage_sections' ) ) :
	function burger_companion_storex_frontpage_sections($from_theme = false) {	
		require BURGER_COMPANION_PLUGIN_DIR . 'inc/storex/sections/section-featured-categories.php';
		burger_storex_featured_categories();
		
		require BURGER_COMPANION_PLUGIN_DIR . 'inc/storex/sections/section-banner.php';
		burger_storex_banner();
		
		require BURGER_COMPANION_PLUGIN_DIR . 'inc/storex/sections/section-popular-categories.php';
		burger_storex_popular_categories();
		
		require BURGER_COMPANION_PLUGIN_DIR . 'inc/storex/sections/section-latest-offers.php';
		burger_storex_latest_offers();
		
		require BURGER_COMPANION_PLUGIN_DIR . 'inc/storex/sections/section-popular-picks.php';
		burger_storex_popular_picks();
    }
	add_action( 'storex_sections', 'burger_companion_storex_frontpage_sections', 10, 1 );
endif;
