<?php
/**
 * Featured Offers Section (Latest Offers)
 */
if ( ! function_exists( 'burger_storex_latest_offers' ) ) :
function burger_storex_latest_offers() {
?>

<!-- featured-offers-section -->
<?php if (get_theme_mod('storex_shop_one_enable', true)): ?>
<section class="featured-offers-section shop-one pb_70">
    <div class="large-container">
        <div class="row clearfix">
            <?php
            // Get individual offer settings
            $offers = array(
                array(
                    'upper_text' => get_theme_mod('storex_offer1_upper_text', 'Best Seller'),
                    'title' => get_theme_mod('storex_offer1_title', 'Men Regular Fit Casual Shirt'),
                    'subtitle' => get_theme_mod('storex_offer1_subtitle', ''),
                    'price' => get_theme_mod('storex_offer1_price', '$89.22'),
                    'button_text' => get_theme_mod('storex_offer1_button_text', 'Shop Now'),
                    'button_url' => get_theme_mod('storex_offer1_button_url', '#'),
                    'background_image' => get_theme_mod('storex_offer1_background_image', ''),
                    'bg_color' => get_theme_mod('storex_offer1_bg_color', '#b1aca7'),
                ),
                array(
                    'upper_text' => get_theme_mod('storex_offer2_upper_text', 'Flash Sale'),
                    'title' => get_theme_mod('storex_offer2_title', 'Premium Stylish Shoes For Men'),
                    'subtitle' => get_theme_mod('storex_offer2_subtitle', ''),
                    'price' => get_theme_mod('storex_offer2_price', '$49 Only'),
                    'button_text' => get_theme_mod('storex_offer2_button_text', 'Shop Now'),
                    'button_url' => get_theme_mod('storex_offer2_button_url', '#'),
                    'background_image' => get_theme_mod('storex_offer2_background_image', ''),
                    'bg_color' => get_theme_mod('storex_offer2_bg_color', '#146a55'),
                ),
                array(
                    'upper_text' => get_theme_mod('storex_offer3_upper_text', 'Limited Offer'),
                    'title' => get_theme_mod('storex_offer3_title', 'Digital Smart Health Watch'),
                    'subtitle' => get_theme_mod('storex_offer3_subtitle', ''),
                    'price' => get_theme_mod('storex_offer3_price', '$79.99'),
                    'button_text' => get_theme_mod('storex_offer3_button_text', 'Shop Now'),
                    'button_url' => get_theme_mod('storex_offer3_button_url', '#'),
                    'background_image' => get_theme_mod('storex_offer3_background_image', ''),
                    'bg_color' => get_theme_mod('storex_offer3_bg_color', '#68609c'),
                ),
            );
            // Display offers
            foreach ($offers as $index => $offer):
                // Get image URL
                $image_url = '';
                if (!empty($offer['background_image'])) {
                    $image_url = wp_get_attachment_image_url($offer['background_image'], 'medium');
                }
                
                // Fallback to default image if no custom image is set
                if (empty($image_url)) {
                    $default_images = array('offers01.png', 'offers02.png', 'offers03.png');
                    $image_url = (defined('STOREX_ASSETS_URL') ? STOREX_ASSETS_URL : get_template_directory_uri() . '/assets') . '/images/shop/' . $default_images[$index];
                }
                
                // Get background color
                $bg_color = !empty($offer['bg_color']) ? $offer['bg_color'] : '#F1EBD1';
                ?>
                <div class="col-lg-4 col-md-6 col-sm-12 feature-block">
                    <div class="shop-block-one">
                        <div class="inner-box" style="background-color: <?php echo esc_attr($bg_color); ?>;">
                            <span class="text"><?php echo esc_html($offer['upper_text']); ?></span>
                            <h2><?php echo esc_html($offer['title']); ?></h2>
                            <?php if (!empty($offer['subtitle'])): ?>
                                <h3><?php echo esc_html($offer['subtitle']); ?></h3>
                            <?php endif; ?>
                            <h4><span>From</span> <?php echo wp_kses_post($offer['price']); ?></h4>
                            <div class="link-box">
                                <a href="<?php echo esc_url($offer['button_url']); ?>"><?php echo esc_html($offer['button_text']); ?></a>
                            </div>
                            <figure class="image r_0 b_10">
                                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($offer['title']); ?>">
                            </figure>
                        </div>
                    </div>
                </div>
                <?php
            endforeach;
            ?>
        </div>
    </div>
</section>
<?php endif; ?>
<!-- featured-offers-section end -->
<?php
}
endif;


