<?php
/**
 * Featured Categories Section
 */
if ( ! function_exists( 'burger_storex_featured_categories' ) ) :
function burger_storex_featured_categories() {
?>

<!-- featured-section -->
<?php if (get_theme_mod('storex_featured_categories_enable', true)): ?>
<?php
// Get styling settings
$featured_bg_color = get_theme_mod('storex_featured_categories_bg_color', '#ffffff');
$featured_text_color = get_theme_mod('storex_featured_categories_text_color', '#333333');
$featured_animation_speed = get_theme_mod('storex_featured_categories_animation_speed', 190);
?>
<section class="featured-section" style="background-color: <?php echo esc_attr($featured_bg_color); ?>;">
    <div class="large-container">
        <div class="inner-container">
            <div class="featured-list" style="--animation-speed: <?php echo esc_attr($featured_animation_speed); ?>s; --text-color: <?php echo esc_attr($featured_text_color); ?>;">
                <?php
                // Get featured categories settings
                $featured_limit = get_theme_mod('storex_featured_categories_limit', 8);
                $featured_selection_mode = get_theme_mod('storex_featured_categories_selection_mode', 'auto');
                $featured_selected_categories_raw = get_theme_mod('storex_featured_categories_selected_categories', array());
                $featured_show_images = get_theme_mod('storex_featured_categories_show_images', true);
                $featured_image_size = get_theme_mod('storex_featured_categories_image_size', 'medium');
                $featured_show_count = get_theme_mod('storex_featured_categories_show_count', false);
                
                // Parse selected categories (handle JSON format from customizer)
                $featured_selected_categories = array();
                if (is_string($featured_selected_categories_raw)) {
                    $decoded = json_decode($featured_selected_categories_raw, true);
                    if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                        $featured_selected_categories = $decoded;
                    }
                } elseif (is_array($featured_selected_categories_raw)) {
                    $featured_selected_categories = $featured_selected_categories_raw;
                }
                
                $featured_categories_to_show = array();
                
                if ($featured_selection_mode === 'manual') {
                    // Manual selection mode - only show selected categories
                    // If no categories are selected in manual mode, show nothing
                    if (!empty($featured_selected_categories)) {
                        foreach ($featured_selected_categories as $category_id) {
                            if (function_exists('storex_is_woocommerce_active') && storex_is_woocommerce_active()) {
                                $category = get_term($category_id, 'product_cat');
                                if ($category && !is_wp_error($category)) {
                                    $featured_categories_to_show[] = $category;
                                }
                            }
                        }
                    }
                    // In manual mode, if no categories are selected, $featured_categories_to_show remains empty
                } else {
                    // Auto selection mode - get top categories by product count for featured section
                    // This section operates completely independently from Popular Categories
                    if (function_exists('storex_is_woocommerce_active') && storex_is_woocommerce_active()) {
                        // Featured Categories: Get categories with most products (top sellers)
                        $featured_categories_to_show = get_terms(array(
                            'taxonomy' => 'product_cat',
                            'hide_empty' => true,
                            'parent' => 0,
                            'number' => $featured_limit,
                            'orderby' => 'count',
                            'order' => 'DESC',
                            'meta_query' => array(
                                'relation' => 'OR',
                                array(
                                    'key' => 'featured_category',
                                    'value' => '1',
                                    'compare' => '='
                                ),
                                array(
                                    'key' => 'featured_category',
                                    'compare' => 'NOT EXISTS'
                                )
                            )
                        ));
                        
                        // If no featured categories found, get top categories by count
                        if (empty($featured_categories_to_show)) {
                            $featured_categories_to_show = get_terms(array(
                                'taxonomy' => 'product_cat',
                                'hide_empty' => true,
                                'parent' => 0,
                                'number' => $featured_limit,
                                'orderby' => 'count',
                                'order' => 'DESC'
                            ));
                        }
                    }
                }
                
                // Only show categories if WooCommerce is active and categories exist
                if (!function_exists('storex_is_woocommerce_active') || !storex_is_woocommerce_active() || empty($featured_categories_to_show)) {
                    $featured_categories_to_show = array();
                }
                
                // Apply limit
                if ($featured_limit > 0) {
                    $featured_categories_to_show = array_slice($featured_categories_to_show, 0, $featured_limit);
                }
                
                // Only display if we have WooCommerce categories
                // In manual mode, if no categories are selected, don't display anything
                if (!empty($featured_categories_to_show) && ($featured_selection_mode !== 'manual' || !empty($featured_selected_categories))) {
                    // Create multiple sets of categories for smooth scrolling effect
                    $total_categories = count($featured_categories_to_show);
                    $repetitions = 3; // Repeat categories 3 times for smooth scrolling
                    
                    for ($rep = 0; $rep < $repetitions; $rep++) {
                        foreach ($featured_categories_to_show as $index => $category) {
                            // WooCommerce category only
                            $category_name = $category->name;
                            $category_link = get_term_link($category);
                            $category_image = get_term_meta($category->term_id, 'thumbnail_id', true);
                            
                            // Use WooCommerce category image or placeholder
                            if ($category_image && $featured_show_images) {
                                $image_url = wp_get_attachment_image_url($category_image, $featured_image_size);
                            } else {
                                // Use WooCommerce placeholder image
                                if (function_exists('wc_placeholder_img_src')) {
                                    $image_url = wc_placeholder_img_src($featured_image_size);
                                } else {
                                    $image_url = '';
                                }
                            }
                            ?>
                            <div class="single-featured">
                                <?php if ($featured_show_images): ?>
                                <figure class="image-box">
                                    <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($category_name); ?>">
                                </figure>
                                <?php endif; ?>
                                <p>
                                    <a href="<?php echo esc_url($category_link); ?>"><?php echo esc_html($category_name); ?></a>
                                    <?php if ($featured_show_count): ?>
                                        <span class="product-count">(<?php echo esc_html($category->count); ?>)</span>
                                    <?php endif; ?>
                                </p>
                            </div>
                            <?php
                        }
                    }
                } else {
                    // Show message when no categories are found
                    if ($featured_selection_mode === 'manual') {
                        ?>
                        <div class="no-categories-message">
                            <p><?php _e('No categories selected. Please select some categories in the customizer.', 'storex'); ?></p>
                        </div>
                        <?php
                    } else {
                        ?>
                        <div class="no-categories-message">
                            <p><?php _e('No product categories found. Please add some product categories in WooCommerce.', 'storex'); ?></p>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
        </div>
    </div>
</section>
<!-- featured-section end -->
<?php endif; 
}
endif;