<?php
/**
 * Banner Section
 */
if ( ! function_exists( 'burger_storex_banner' ) ) :
function burger_storex_banner() {
?>

<!-- banner-section -->
<?php if (get_theme_mod('storex_banner_enable', true)) : ?>
<?php
// Get banner color and speed settings
$banner_title_color = get_theme_mod('storex_banner_title_color', '#333333');
$banner_subtitle_color = get_theme_mod('storex_banner_subtitle_color', '#00286f');
$banner_price_color = get_theme_mod('storex_banner_price_color', '#e74c3c');
$banner_upper_text_color = get_theme_mod('storex_banner_upper_text_color', '#ffffff');
$banner_upper_text_bg_color = get_theme_mod('storex_banner_upper_text_bg_color', '#e74c3c');
$banner_autoplay = get_theme_mod('storex_banner_autoplay', true);
$banner_autoplay_speed = get_theme_mod('storex_banner_autoplay_speed', 5000);
$banner_animation_speed = get_theme_mod('storex_banner_animation_speed', 1000);
?>
<section class="banner-section p_relative" style="--banner-title-color: <?php echo esc_attr($banner_subtitle_color); ?>; --banner-subtitle-color: <?php echo esc_attr($banner_title_color); ?>; --banner-price-color: <?php echo esc_attr($banner_price_color); ?>; --banner-upper-text-color: <?php echo esc_attr($banner_upper_text_color); ?>; --banner-upper-text-bg-color: <?php echo esc_attr($banner_upper_text_bg_color); ?>;">
    <div class="banner-carousel owl-theme owl-carousel owl-nav-none dots-style-one" 
         data-autoplay="<?php echo $banner_autoplay ? 'true' : 'false'; ?>" 
         data-autoplay-speed="<?php echo esc_attr($banner_autoplay_speed); ?>" 
         data-animation-speed="<?php echo esc_attr($banner_animation_speed); ?>">
        <?php
        $banner_slides_raw = get_theme_mod('storex_banner_slides', '');
        $banner_slides = array();
        
        // Handle JSON data
        if (is_string($banner_slides_raw)) {
            $decoded = json_decode($banner_slides_raw, true);
            if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                $banner_slides = $decoded;
            }
        } elseif (is_array($banner_slides_raw)) {
            $banner_slides = $banner_slides_raw;
        }
        
        // Use default slides if no slides are set
        if (empty($banner_slides)) {
            $banner_slides = array(
                array(
                    'upper_text' => 'Latest Arrival',
                    'title' => 'Modern Fashion Display',
                    'subtitle' => 'Smart Style Collection',
                    'price' => '$87.99',
                    'button_text' => 'Shop Now',
                    'button_url' => function_exists('storex_safe_wc_get_page_permalink') ? storex_safe_wc_get_page_permalink('shop') : '#',
                    'background_image' => 'banner-img-1.png',
                    'pattern_image' => 'shape-2.png',
                    'image_position' => 'r_95 b_0'
                ),
                array(
                    'upper_text' => 'Latest Arrival',
                    'title' => 'Ultra Real 3D Vision',
                    'subtitle' => 'Dive Into Adventure',
                    'price' => '$87.67',
                    'button_text' => 'Shop Now',
                    'button_url' => function_exists('storex_safe_wc_get_page_permalink') ? storex_safe_wc_get_page_permalink('shop') : '#',
                    'background_image' => 'banner-img-2.png',
                    'pattern_image' => 'shape-2.png',
                    'image_position' => 'r_95 b_0'
                )
            );
        }
        
        // Limit slides to 2 in lite version (safety check)
        if (count($banner_slides) > 2) {
            $banner_slides = array_slice($banner_slides, 0, 2);
        }
        
        if (!empty($banner_slides)) {
            foreach ($banner_slides as $index => $slide) {
                if (!empty($slide['title'])) {
                    ?>
                    <div class="slide-item p_relative">
                        <?php 
                        // Always show pattern layer, use default if no pattern image is set
                        $pattern_url = '';
                        if (!empty($slide['pattern_image']) && $slide['pattern_image'] != 0) {
                            if (is_numeric($slide['pattern_image'])) {
                                // Handle attachment ID
                                $pattern_url = wp_get_attachment_image_url($slide['pattern_image'], 'full');
                            } else {
                                // Fallback to filename (for backward compatibility)
                                $pattern_url = (defined('STOREX_ASSETS_URL') ? STOREX_ASSETS_URL : get_template_directory_uri() . '/assets') . '/images/shape/' . esc_attr($slide['pattern_image']);
                            }
                        }
                        
                        // Use default pattern if no custom pattern is set
                        if (empty($pattern_url)) {
                            $default_patterns = array('shape-1.png', 'shape-2.png', 'shape-3.png', 'shape-4.png', 'shape-5.png');
                            $default_pattern = $default_patterns[$index % count($default_patterns)];
                            $pattern_url = (defined('STOREX_ASSETS_URL') ? STOREX_ASSETS_URL : get_template_directory_uri() . '/assets') . '/images/shape/' . $default_pattern;
                        }
                        ?>
                        <div class="pattern-layer" style="background-image: url(<?php echo esc_url($pattern_url); ?>);"></div>
                        
                        <?php 
                        // Always show background image, use default if none is set
                        $background_url = '';
                        if (!empty($slide['background_image']) && $slide['background_image'] != 0) {
                            if (is_numeric($slide['background_image'])) {
                                // Handle attachment ID
                                $background_url = wp_get_attachment_image_url($slide['background_image'], 'full');
                            } else {
                                // Handle filename
                                $background_url = (defined('STOREX_ASSETS_URL') ? STOREX_ASSETS_URL : get_template_directory_uri() . '/assets') . '/images/banner/' . esc_attr($slide['background_image']);
                            }
                        }
                        
                        // Use default background image if no custom image is set
                        if (empty($background_url)) {
                            $default_images = array('banner-img-1.png', 'banner-img-2.png', 'banner-img-3.png', 'banner-img-5.png', 'banner-img-6.png');
                            $default_image = $default_images[$index % count($default_images)];
                            $background_url = (defined('STOREX_ASSETS_URL') ? STOREX_ASSETS_URL : get_template_directory_uri() . '/assets') . '/images/banner/' . $default_image;
                        }
                        ?>
                        <figure class="image-layer <?php echo esc_attr($slide['image_position']); ?>">
                            <img src="<?php echo esc_url($background_url); ?>" alt="<?php echo esc_attr($slide['title']); ?>">
                        </figure>
                        
                        <div class="large-container">
                            <div class="content-box">
                                <?php if (!empty($slide['upper_text'])) : ?>
                                    <span class="upper-text"><?php echo esc_html($slide['upper_text']); ?></span>
                                <?php endif; ?>
                                <h2>
                                    <?php if (!empty($slide['title'])) : ?>
                                        <span><?php echo esc_html($slide['title']); ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($slide['subtitle'])) : ?>
                                        <?php echo esc_html($slide['subtitle']); ?>
                                    <?php endif; ?>
                                </h2>
                                
                                <?php if (!empty($slide['price'])) : ?>
                                    <h3>Starting From <span><?php echo esc_html($slide['price']); ?></span></h3>
                                <?php endif; ?>
                                
                                <?php if (!empty($slide['button_text']) && !empty($slide['button_url'])) : ?>
                                    <div class="btn-box">
                                        <a href="<?php echo esc_url($slide['button_url']); ?>" class="theme-btn btn-one">
                                            <?php echo esc_html($slide['button_text']); ?>
                                            <span></span><span></span><span></span><span></span>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php
                }
            }
        } ?>
    </div>
</section>
<?php endif; 
}
endif;