<?php
namespace Woo_BG\Shipping\Econt;
use Woo_BG\Container\Client;

defined( 'ABSPATH' ) || exit;

class Office {
	private static $container = null;
	
	public function __construct() {
		add_filter( 'woocommerce_after_shipping_rate', array( __CLASS__, 'delivery_with_econt_render_form_button' ), 20, 2 );

		add_action( 'wp_ajax_woo_bg_econt_load_offices', array( __CLASS__, 'load_offices' ) );
		add_action( 'wp_ajax_nopriv_woo_bg_econt_load_offices', array( __CLASS__, 'load_offices' ) );
	}

	public static function delivery_with_econt_render_form_button( $method, $index ) {
		if ( $method->get_method_id() === Method::METHOD_ID ) {
			if ( $method->meta_data['delivery_type'] === 'office' ) {
				echo wp_kses( '<div data-cache="' . wp_rand() . '" id="woo-bg-econt-shipping-to--office" class="woo-bg-additional-fields" data-type="office"></div>', [
					'div' => [
						'data-cache' => [],
						'data-type' => [],
						'class' => [],
						'id' => [],
					]
				] );
			}
		}
	}

	public static function get_i18n() {
		return array(
			'selected' => __( 'Selected', 'bulgarisation-for-woocommerce' ),
			'choose' => __( 'Choose', 'bulgarisation-for-woocommerce' ),
			'searchOffice' => __( 'Search office', 'bulgarisation-for-woocommerce' ), 
			'select' => __( 'Select', 'bulgarisation-for-woocommerce' ), 
			'noResult' => __( 'No results was found for this city', 'bulgarisation-for-woocommerce' ),
			'noOptions' => __( 'Start typing office', 'bulgarisation-for-woocommerce' ), 
			'officeLocator' => __( 'Office locator', 'bulgarisation-for-woocommerce' ),
			'toOffice' => __( 'To Office: ', 'bulgarisation-for-woocommerce' ),
		);
	}

	public static function load_offices() {
		self::$container = woo_bg()->container();
		$args = [];
		$raw_state = sanitize_text_field( $_POST['state'] );
		$country = sanitize_text_field( $_POST[ 'country' ] );
		$states = self::$container[ Client::ECONT_CITIES ]->get_regions( $country );
		$state = $states[ $raw_state ];
		$raw_city = sanitize_text_field( $_POST['city'] );
		$cities_data = self::$container[ Client::ECONT_CITIES ]->get_filtered_cities( $raw_city, $state, $country );

		if ( !in_array( $cities_data['city'], $cities_data['cities_only_names'] ) || !$raw_city ) {
			$args[ 'status' ] = 'invalid-city';
			
			if ( !$state ) {
				$args[ 'error' ] = __( 'Please select region.', 'bulgarisation-for-woocommerce' );
			} elseif ( empty( $raw_city ) ) {
				$args[ 'error' ] = sprintf( __( 'Please enter a city.', 'bulgarisation-for-woocommerce' ), $raw_city, $state );
			} else {
				$args[ 'error' ] = sprintf( __( '%s is not found in %s region.', 'bulgarisation-for-woocommerce' ), $raw_city, $state );
			}
		} else {
			$offices = self::$container[ Client::ECONT_OFFICES ]->get_offices( $cities_data['cities'][ $cities_data['city_key'] ]['id'], $country );

			if ( empty( $offices ) ) {
				$offices = [];
				$args[ 'error' ] = sprintf( __( 'No offices were found at %s.', 'bulgarisation-for-woocommerce' ), $raw_city );
			} else {
				$offices = $offices['offices'];

				if ( woo_bg_get_option( 'econt', 'disable_apt' ) === 'yes' ) {
					$offices = array_values( array_filter( $offices, function( $office ) {
						return ( $office['isAPS'] === false );
					} ) );
				}
			}

			$args[ 'offices' ] = apply_filters( 'woo_bg/shipping_method/econt/offices', $offices );
			$args[ 'status' ] = 'valid-city';
		}

		wp_send_json_success( $args );

		wp_die();
	}
}
