jQuery(function ($) {
  'use strict';
  
  /*-----------------------------------------------------------------------------------*/
  /*  *.  WPBakery
  /*-----------------------------------------------------------------------------------*/
  
  
  /* ==================================================
  WPBakery - Counter
  ================================================== */
  
  $(document).ready(function () {
    const counter = $('.borderless-wpbakery-counter');
    $(counter).each(function () {
      $(this).appear(function () {
        const value = $(this).find('div.borderless-wpbakery-counter-paramns').attr('value');
        const speed = $(this).find('div.borderless-wpbakery-counter-paramns').attr('value-speed');
        const interval = $(this).find('div.borderless-wpbakery-counter-paramns').attr('value-interval');
        $(this).find('.borderless-wpbakery-counter-paramns').countTo({
          from: 0,
          to: value,
          speed: speed,
          refreshInterval: interval,
          onComplete: function () {}
        });
      });
    });
  });
  
  
  /* ==================================================
  WPBakery - Testimonial
  ================================================== */
  
  $(document).ready(function () {
    if ($('.borderless-wpbakery-testimonial').length > 0) {
      const elem = document.querySelector('.main-carousel');
      var flkty = new Flickity(elem, {
        // options
        prevNextButtons: false,
        wrapAround: true,
        autoPlay: true,
        contain: true
      }); // element argument can be a selector string
      //   for an individual element
      
      var flkty = new Flickity('.main-carousel', {// options
      });
    }
  });
  
  
  /* ==================================================
  WPBakery - Progress Bar
  ================================================== */
  
  $(document).ready(function () {
    $('.borderless-wpbakery-progress-bar-params').each(function () {
      $(this).appear(function () {
        const percentage_color = $(this).attr('percentage_color');
        const bar_color = $(this).attr('bar_color');
        const track_color = $(this).attr('track_color');
        const percentage = parseInt($(this).attr('percentage')) / 100;
        const bar = new ProgressBar.Line(this, {
          strokeWidth: 4,
          easing: 'easeInOut',
          duration: 1400,
          color: bar_color,
          trailColor: track_color,
          trailWidth: 8,
          svgStyle: {
            width: '100%',
            height: '100%'
          },
          text: {
            style: {
              // Text color.
              // Default: same as stroke color (options.color)
              color: percentage_color,
              position: 'absolute',
              right: '0',
              top: '-31px',
              padding: 0,
              margin: 0,
              transform: null
            },
            autoStyleContainer: true
          },
          from: {
            color: '#FFEA82'
          },
          to: {
            color: '#ED6A5A'
          },
          step: (state, bar) => {
            bar.setText(Math.round(bar.value() * 100) + ' %');
          }
        });
        bar.animate(percentage); // Number from 0.0 to 1.0
      });
    });
  });
  
  
  /* ==================================================
  WPBakery - Circular Progress Bar
  ================================================== */
  
  $(document).ready(function () {
    $('.borderless-wpbakery-circular-progress-bar-params').each(function () {
      $(this).appear(function () {
        
        if ( ! $('.borderless-wpbakery-circular-progress-bar').length ) {
          return;
        }
        
        // Custom Colors
        const percentage_color = $(this).attr('percentage_color');
        const bar_color = $(this).attr('bar_color');
        const track_color = $(this).attr('track_color'); // Thickness
        
        const bar_thickness = parseInt($(this).attr('bar_thickness'));
        const track_thickness = parseInt($(this).attr('track_thickness')); // Percentage Value
        
        const percentage = parseInt($(this).attr('percentage')) / 100;
        const bar = new ProgressBar.Circle(this, {
          strokeWidth: bar_thickness,
          easing: 'easeInOut',
          duration: 1400,
          color: bar_color,
          trailColor: track_color,
          trailWidth: track_thickness,
          svgStyle: null,
          text: {
            style: {
              // Text color.
              // Default: same as stroke color (options.color)
              color: percentage_color,
              position: 'absolute',
              right: '0',
              top: '0px',
              padding: 0,
              margin: 0,
              transform: null
            },
            autoStyleContainer: true
          },
          from: {
            color: '#FFEA82'
          },
          to: {
            color: '#ED6A5A'
          },
          step: (state, bar) => {
            bar.setText(Math.round(bar.value() * 100));
          }
        });
        bar.animate(percentage); // Number from 0.0 to 1.0
      });
    });
  });
  
  
  /* ==================================================
  WPBakery - Semi Circular Progress Bar
  ================================================== */
  
  $(document).ready(function () {
    $('.borderless-wpbakery-semi-circular-progress-bar-params').each(function () {
      $(this).appear(function () {
        // Custom Colors
        const percentage_color = $(this).attr('percentage_color');
        const bar_color = $(this).attr('bar_color');
        const track_color = $(this).attr('track_color'); // Thickness
        
        const bar_thickness = parseInt($(this).attr('bar_thickness'));
        const track_thickness = parseInt($(this).attr('track_thickness')); // Percentage Value
        
        const percentage = parseInt($(this).attr('percentage')) / 100;
        const bar = new ProgressBar.SemiCircle(this, {
          strokeWidth: bar_thickness,
          easing: 'easeInOut',
          duration: 1400,
          color: bar_color,
          trailColor: track_color,
          trailWidth: track_thickness,
          svgStyle: null,
          text: {
            style: {
              // Text color.
              // Default: same as stroke color (options.color)
              color: percentage_color,
              position: 'absolute',
              right: '0',
              top: '0px',
              padding: 0,
              margin: 0,
              transform: null
            },
            autoStyleContainer: true
          },
          from: {
            color: '#FFEA82'
          },
          to: {
            color: '#ED6A5A'
          },
          step: (state, bar) => {
            bar.setText(Math.round(bar.value() * 100));
          }
        });
        bar.animate(percentage); // Number from 0.0 to 1.0
      });
    });
  });
  
  
  /* ==================================================
  WPBakery - Modal
  ================================================== */
  
  $(document).ready(function () {
    const modalBtns = [...document.querySelectorAll('.borderless-wpbakery-modal-button, .borderless-wpbakery-modal-icon, .borderless-wpbakery-modal-text')];
    modalBtns.forEach(function (btn) {
      btn.onclick = function () {
        const modal = btn.getAttribute('data-modal');
        document.getElementById(modal).style.visibility = 'visible';
        document.getElementById(modal).style.opacity = '1';
        document.getElementById(modal).style.transition = 'all 0.25s';
      };
    });
    const closeBtns = [...document.querySelectorAll('.borderless-wpbakery-modal-close')];
    closeBtns.forEach(function (btn) {
      btn.onclick = function () {
        const modal = btn.closest('.borderless-wpbakery-modal');
        modal.style.visibility = 'hidden';
        modal.style.opacity = '0';
      };
    });
    
    window.onclick = function (event) {
      if (event.target.className === 'borderless-wpbakery-modal') {
        event.target.style.visibility = 'hidden';
        event.target.style.opacity = '0';
      }
    };
  });
}); // End Strict