( function( $ ) {
  
  "use strict";
  
  /* ==================================================
  Animated Text
  ================================================== */
  $( window ).on( 'elementor/frontend/init', function() {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/borderless-elementor-animated-text.default', function($scope, $){
      $('.borderless-elementor-animated-text-strings').each(function () {
        const strings = ($(this).attr('data-animated-text-strings')).split('|');
        const delay = $(this).attr('data-animated-text-delay');
        const delete_speed = $(this).attr('data-animated-text-delete-speed');
        const pause_for = $(this).attr('data-animated-text-pause-for');
        const cursor = $(this).attr('data-animated-text-cursor');
        const loop = $(this).attr('data-animated-text-loop') == "yes" ? true : false;
        new Typewriter('.borderless-elementor-animated-text-strings', {
          strings: strings,
          cursor: cursor,
          delay: delay,
          deleteSpeed: delete_speed,
          loop: loop,
          autoStart: true,
          pauseFor: pause_for,
        });
      });
    });
  });
  
  
  /* ==================================================
  Circular Progress Bar
  ================================================== */
  $( window ).on( 'elementor/frontend/init', function() {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/borderless-elementor-circular-progress-bar.default', function($scope, $){
      $('.borderless-elementor-circular-progress-bar').each(function () {
        $(this).appear(function () {
          const title = $(this).attr('title');
          const counter_color = $(this).attr('counter_color');
          const stroke_color_mode = $(this).attr('stroke_color_mode');
          const stroke_color = $(this).attr('stroke_color');
          const stroke_color_from = $(this).attr('stroke_color_from');
          const stroke_color_to = $(this).attr('stroke_color_to');
          const trail_color = $(this).attr('trail_color'); 
          const stroke_width = $(this).attr('stroke_width');
          const trail_width = $(this).attr('trail_width'); 
          const animation_duration = parseFloat($(this).attr('animation_duration'));
          const counter_value = $(this).attr('counter_value') / 100;
          const bar = new ProgressBar.Circle(this, {
            strokeWidth: stroke_width,
            easing: 'easeInOut',
            duration: animation_duration,
            color: stroke_color,
            trailColor: trail_color,
            trailWidth: trail_width,
            svgStyle: null,
            text: {
              style: {
                // Text color.
                // Default: same as stroke color (options.color)
                color: counter_color
              },
              autoStyleContainer: true
            },
            from: {color: stroke_color_from},
            to: {color: stroke_color_to},
            step: function(state, circle) {
              if (stroke_color_mode == 'gradient') {
                circle.path.setAttribute('stroke', state.color);
              }
              
              var value = '<h4 class="borderless-elementor-circular-progress-bar-title">'+title+'</h4>' + '<span class="borderless-elementor-circular-progress-bar-counter-value">' + Math.round(circle.value() * 100) + '</span>' + '<span class="borderless-elementor-circular-progress-bar-counter-postfix">%</span>';
              if (value === 0) {
                circle.setText('');
              } else {
                circle.setText(value);
              }
              
            }
          });
          bar.animate(counter_value); // Number from 0.0 to 1.0
        });
      });
    });
  });
  
  
  /* ==================================================
  Marquee Text
  ================================================== */

  $( window ).on( 'elementor/frontend/init', function() {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/borderless-elementor-marquee-text.default', function($scope, $){
      // Select the main widget
      const $widget = $scope.find( '.borderless-elementor-marquee-text' );
      
      // If this widget does not exist, exit
      if ( ! $widget.length ) {
        return;
      }
      
      // For each element with the class .marquee inside the widget
      $widget.find('.marquee').each(function(){
        const $this = $(this);
        
        // Read the data-attributes from the HTML
        const direction       = $this.data('direction') || 'left';
        const duration        = parseInt($this.data('duration'), 10) || 5000;
        const delayBeforeStart= parseInt($this.data('delaybeforestart'), 10) || 0;
        const gap             = parseInt($this.data('gap'), 10) || 0;
        const duplicateCount = parseInt($this.data('duplicatecount'), 10) || 1;
        
        // Here we use === true or === 'true' to handle boolean or string values
        const startVisible    = ($this.data('startvisible') === true  || $this.data('startvisible') === 'true');
        const duplicated      = ($this.data('duplicated')   === true  || $this.data('duplicated')   === 'true');
        const pauseOnHover    = ($this.data('pauseonhover') === true  || $this.data('pauseonhover') === 'true');
        
        // Initialize the marquee with the options
        $this.marquee({
          direction,
          duration,
          delayBeforeStart,
          gap,
          startVisible,
          duplicated,
          duplicateCount,
          pauseOnHover
        });
      });
    });
  });
  
  
  /* ==================================================
  Portfolio
  ================================================== */
  $( window ).on( 'elementor/frontend/init', function() {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/borderless-elementor-portfolio.default', function($scope, $){
      $('.borderless-elementor-portfolio').each(function () {
        // external js: isotope.pkgd.js
        const gutter = parseFloat($(this).attr('data-portfolio-gutter'));
        // init Isotope
        var $grid = $('.borderless-elementor-portfolio-items').isotope({
          itemSelector: '.borderless-elementor-portfolio-item',
          percentPosition: true
        });
        
        // store filter for each group
        var filters = {};
        
        $('.borderless-elementor-portfolio-filters').on( 'click', '.borderless-elementor-portfolio-filter-item', function( event ) {
          var $button = $( event.currentTarget );
          // get group key
          var $buttonGroup = $button.parents('.borderless-elementor-portfolio-filter');
          var filterGroup = $buttonGroup.attr('data-portfolio-filter-group');
          // set filter for group
          filters[ filterGroup ] = $button.attr('data-portfolio-filter');
          // combine filters
          var filterValue = concatValues( filters );
          // set filter for Isotope
          $grid.isotope({ filter: filterValue });
        });
        
        // change is-checked class on buttons
        $('.borderless-elementor-portfolio-filter').each( function( i, buttonGroup ) {
          var $buttonGroup = $( buttonGroup );
          $buttonGroup.on( 'click', '.borderless-elementor-portfolio-filter-item', function( event ) {
            $buttonGroup.find('.is-checked').removeClass('is-checked');
            var $button = $( event.currentTarget );
            $button.addClass('is-checked');
          });
        });
        
        // flatten object by concatting values
        function concatValues( obj ) {
          var value = '';
          for ( var prop in obj ) {
            value += obj[ prop ];
          }
          return value;
        }
        
      });
    });
  });
  
  
  /* ==================================================
  Progress Bar
  ================================================== */
  
  $( window ).on( 'elementor/frontend/init', function() {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/borderless-elementor-progress-bar.default', function($scope, $){
      $('.borderless-elementor-progress-bar').each(function () {
        $(this).appear(function () {
          const title = $(this).attr('title');
          const counter_color = $(this).attr('counter_color');
          const stroke_color_mode = $(this).attr('stroke_color_mode');
          const stroke_color = $(this).attr('stroke_color');
          const stroke_color_from = $(this).attr('stroke_color_from');
          const stroke_color_to = $(this).attr('stroke_color_to');
          const trail_color = $(this).attr('trail_color'); 
          const stroke_width = $(this).attr('stroke_width');
          const trail_width = $(this).attr('trail_width'); 
          const animation_duration = parseFloat($(this).attr('animation_duration'));
          const counter_value = $(this).attr('counter_value') / 100;
          const bar = new ProgressBar.Line(this, {
            strokeWidth: stroke_width,
            easing: 'easeInOut',
            duration: animation_duration,
            color: stroke_color,
            trailColor: trail_color,
            trailWidth: trail_width,
            svgStyle: {width: '100%', height: '100%'},
            text: {
              style: {
                // Text color.
                // Default: same as stroke color (options.color)
                color: counter_color
              },
              autoStyleContainer: false
            },
            from: {color: stroke_color_from},
            to: {color: stroke_color_to},
            step: function(state, bar) {
              if (stroke_color_mode == 'gradient') {
                bar.path.setAttribute('stroke', state.color);
              }
              
              var value = '<div><span class="borderless-elementor-progress-bar-title">'+title+'</span></div>' + '<div><span class="borderless-elementor-progress-bar-counter-value">' + Math.round(bar.value() * 100) + '</span>' + '<span class="borderless-elementor-progress-bar-counter-postfix">%</span></div>';
              if (value === 0) {
                bar.setText('');
              } else {
                bar.setText(value);
              }
              
            }
          });
          bar.animate(counter_value); // Number from 0.0 to 1.0
        });
      });
    });
  });
  
  
  /* ==================================================
  Semi Circular Progress Bar
  ================================================== */
  
  $( window ).on( 'elementor/frontend/init', function() {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/borderless-elementor-semi-circular-progress-bar.default', function($scope, $){
      $('.borderless-elementor-semi-circular-progress-bar').each(function () {
        $(this).appear(function () {
          const title = $(this).attr('title');
          const counter_color = $(this).attr('counter_color');
          const stroke_color_mode = $(this).attr('stroke_color_mode');
          const stroke_color = $(this).attr('stroke_color');
          const stroke_color_from = $(this).attr('stroke_color_from');
          const stroke_color_to = $(this).attr('stroke_color_to');
          const trail_color = $(this).attr('trail_color'); 
          const stroke_width = $(this).attr('stroke_width');
          const trail_width = $(this).attr('trail_width'); 
          const animation_duration = parseFloat($(this).attr('animation_duration'));
          const counter_value = $(this).attr('counter_value') / 100;
          const bar = new ProgressBar.SemiCircle(this, {
            strokeWidth: stroke_width,
            easing: 'easeInOut',
            duration: animation_duration,
            color: stroke_color,
            trailColor: trail_color,
            trailWidth: trail_width,
            svgStyle: null,
            text: {
              style: {
                // Text color.
                // Default: same as stroke color (options.color)
                color: counter_color
              },
              autoStyleContainer: false
            },
            from: {color: stroke_color_from},
            to: {color: stroke_color_to},
            step: function(state, circle) {
              if (stroke_color_mode == 'gradient') {
                circle.path.setAttribute('stroke', state.color);
              }
              
              var value = '<span class="borderless-elementor-semi-circular-progress-bar-counter-value">' + Math.round(circle.value() * 100) + '</span>' + '<span class="borderless-elementor-semi-circular-progress-bar-counter-postfix">%</span>' + '<br /><span class="borderless-elementor-semi-circular-progress-bar-title">'+title+'</span>';
              if (value === 0) {
                circle.setText('');
              } else {
                circle.setText(value);
              }
              
            }
          });
          bar.animate(counter_value); // Number from 0.0 to 1.0
        });
      });
    });
  });
  
  /* ==================================================
  Slider
  ================================================== */
  $( window ).on( 'elementor/frontend/init', function() {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/borderless-elementor-slider.default', function( $scope, $ ) {
      
      var $widget = $scope.find( '.borderless-elementor-slider-widget' );
      
      if ( ! $widget.length ) {
        return;
      }
      
      let autoPlay = $widget.attr('data-slider-autoplay') == "yes" ? true : false;
      const pauseAutoPlayOnHover = $widget.attr('data-slider-autoplay-pause-on-hover') == "yes" ? true : false;
      const autoPlaySpeed = parseInt($widget.attr('data-slider-autoplay-speed'));
      const draggable = $widget.attr('data-slider-draggable') == "yes" ? true : false;
      const wrapAround = $widget.attr('data-slider-infinite-scroll') == "yes" ? true : false;
      const adaptiveHeight = $widget.attr('data-slider-adaptative-height') == "yes" ? true : false;
      const fullscreen = $widget.attr('data-slider-fullscreen') == "yes" ? true : false;
      const fade = $widget.attr('data-slider-fade') == "yes" ? true : false;
      const asNavFor = $widget.attr('data-slider-as-nav-for') == "yes" ? true : false;
      
      autoPlay = autoPlaySpeed ? autoPlaySpeed : autoPlay;
      
      $('.borderless-elementor-slider').flickity({
        // options
        autoPlay: autoPlay,
        pauseAutoPlayOnHover: pauseAutoPlayOnHover,
        draggable: draggable,
        wrapAround: wrapAround,
        adaptiveHeight: adaptiveHeight,
        fullscreen: fullscreen,
        fade: fade,
      });
      
      if ( asNavFor ) {
        $('.borderless-elementor-slider-nav').flickity({
          asNavFor: '.borderless-elementor-slider',
          contain: true,
          prevNextButtons: false,
          pageDots: false,
          draggable: false
        });
        
      }
      
    });
  });
  
} )( jQuery );