"use strict";

(function ($) {
  $(function () {
    // if Shepherd is undefined, exit.
    if (!window.Shepherd) {
      return;
    }
    var button_classes = 'button button-primary';
    var plugins_page_tour = window.wpbc_plugins_page_tour = new Shepherd.Tour();
    var main_tour = window.wpbc_main_tour = new Shepherd.Tour();

    // Set up the defaults for each step
    main_tour.options.defaults = plugins_page_tour.options.defaults = {
      classes: 'wpbc_tour_theme202408 wpbc_tour_main',
      showCancelLink: true,
      scrollTo: false,
      tetherOptions: {
        constraints: [{
          to: 'scrollParent',
          attachment: 'together',
          pin: false
        }]
      }
    };

    /*
    	Plugins page
    */

    main_tour.addStep('intro', {
      title: wpbc_tour_i18n.plugins_page.title,
      text: wpbc_tour_i18n.plugins_page.text,
      attachTo: '.wpbc_plugins_links__start_tour top',
      buttons: [{
        classes: button_classes,
        text: wpbc_tour_i18n.plugins_page.button.text,
        action: function () {
          window.location = wpbc_tour_i18n.plugins_page.button.url;
        }
      }],
      tetherOptions: {
        constraints: [{
          to: 'scrollParent',
          attachment: 'together',
          pin: false
        }],
        offset: '20px 0'
      },
      when: {
        show: function () {
          $('body').addClass('plugins_page_highlight_wpbc');
          var popup = $(this.el);
          var target = $(this.tether.target);
          $('body, html').animate({
            scrollTop: popup.offset().top - 50
          }, 500, function () {
            window.scrollTo(0, popup.offset().top - 50);
          });
        },
        hide: function () {
          $('body').removeClass('plugins_page_highlight_wpbc');
        }
      }
    });

    /*
    	Main Tour steps
    */

    // 1. Your first backup
    main_tour.addStep('main_tour_start', {
      title: wpbc_tour_i18n.setup_page.title,
      text: wpbc_tour_i18n.setup_page.text,
      //attachTo: '.wpbc_page_top__wizard_button_content bottom',
      attachTo: {
        element: jQuery('#toplevel_page_wpbc ul li:nth-last-child(2)').get(0),
        on: 'right'
      },
      buttons: [{
        classes: 'wpbc_tour_end',
        text: wpbc_tour_i18n.button_end_tour.text,
        action: main_tour.cancel
      }, {
        classes: button_classes,
        text: wpbc_tour_i18n.button_next.text,
        action: function () {
          //jQuery('.wpbc_page_top__wizard_button_content .button').trigger('click');
          jQuery('#toplevel_page_wpbc ul li:nth-last-child(2) a').get(0).click();
        }
      }],
      tetherOptions: {
        constraints: [{
          to: 'window',
          attachment: 'together'
        }],
        offset: '0 0'
      }
    });
  });
})(jQuery);
jQuery(document).ready(function () {
  setTimeout(function () {
    if (jQuery('.wpbc_plugins_links__start_tour').length) {
      wpbc_main_tour.start();
    }
    if (jQuery('.wpbc_page_top__wizard_button_content').length) {
      wpbc_main_tour.show('main_tour_start');
    }
  }, 1000);
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5jbHVkZXMvX3RvdXIvX291dC93cGJjX3RvdXIuanMiLCJuYW1lcyI6WyIkIiwid2luZG93IiwiU2hlcGhlcmQiLCJidXR0b25fY2xhc3NlcyIsInBsdWdpbnNfcGFnZV90b3VyIiwid3BiY19wbHVnaW5zX3BhZ2VfdG91ciIsIlRvdXIiLCJtYWluX3RvdXIiLCJ3cGJjX21haW5fdG91ciIsIm9wdGlvbnMiLCJkZWZhdWx0cyIsImNsYXNzZXMiLCJzaG93Q2FuY2VsTGluayIsInNjcm9sbFRvIiwidGV0aGVyT3B0aW9ucyIsImNvbnN0cmFpbnRzIiwidG8iLCJhdHRhY2htZW50IiwicGluIiwiYWRkU3RlcCIsInRpdGxlIiwid3BiY190b3VyX2kxOG4iLCJwbHVnaW5zX3BhZ2UiLCJ0ZXh0IiwiYXR0YWNoVG8iLCJidXR0b25zIiwiYnV0dG9uIiwiYWN0aW9uIiwibG9jYXRpb24iLCJ1cmwiLCJvZmZzZXQiLCJ3aGVuIiwic2hvdyIsImFkZENsYXNzIiwicG9wdXAiLCJlbCIsInRhcmdldCIsInRldGhlciIsImFuaW1hdGUiLCJzY3JvbGxUb3AiLCJ0b3AiLCJoaWRlIiwicmVtb3ZlQ2xhc3MiLCJzZXR1cF9wYWdlIiwiZWxlbWVudCIsImpRdWVyeSIsImdldCIsIm9uIiwiYnV0dG9uX2VuZF90b3VyIiwiY2FuY2VsIiwiYnV0dG9uX25leHQiLCJjbGljayIsImRvY3VtZW50IiwicmVhZHkiLCJzZXRUaW1lb3V0IiwibGVuZ3RoIiwic3RhcnQiXSwic291cmNlcyI6WyJpbmNsdWRlcy9fdG91ci9fc3JjL3dwYmNfdG91ci5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyIoZnVuY3Rpb24gKCQpIHtcclxuXHQkKCBmdW5jdGlvbiAoKSB7XHJcblxyXG5cdFx0Ly8gaWYgU2hlcGhlcmQgaXMgdW5kZWZpbmVkLCBleGl0LlxyXG5cdFx0aWYgKCAhIHdpbmRvdy5TaGVwaGVyZCApIHtcclxuXHRcdFx0cmV0dXJuO1xyXG5cdFx0fVxyXG5cclxuXHRcdHZhciBidXR0b25fY2xhc3NlcyAgICA9ICdidXR0b24gYnV0dG9uLXByaW1hcnknO1xyXG5cdFx0dmFyIHBsdWdpbnNfcGFnZV90b3VyID0gd2luZG93LndwYmNfcGx1Z2luc19wYWdlX3RvdXIgPSBuZXcgU2hlcGhlcmQuVG91cigpO1xyXG5cdFx0dmFyIG1haW5fdG91ciAgICAgICAgID0gd2luZG93LndwYmNfbWFpbl90b3VyID0gbmV3IFNoZXBoZXJkLlRvdXIoKTtcclxuXHJcblx0XHQvLyBTZXQgdXAgdGhlIGRlZmF1bHRzIGZvciBlYWNoIHN0ZXBcclxuXHRcdG1haW5fdG91ci5vcHRpb25zLmRlZmF1bHRzID0gcGx1Z2luc19wYWdlX3RvdXIub3B0aW9ucy5kZWZhdWx0cyA9IHtcclxuXHRcdFx0Y2xhc3NlczogJ3dwYmNfdG91cl90aGVtZTIwMjQwOCB3cGJjX3RvdXJfbWFpbicsXHJcblx0XHRcdHNob3dDYW5jZWxMaW5rOiB0cnVlLFxyXG5cdFx0XHRzY3JvbGxUbzogZmFsc2UsXHJcblx0XHRcdHRldGhlck9wdGlvbnM6IHtcclxuXHRcdFx0XHRjb25zdHJhaW50czogW1xyXG5cdFx0XHRcdFx0e1xyXG5cdFx0XHRcdFx0XHR0bzogJ3Njcm9sbFBhcmVudCcsXHJcblx0XHRcdFx0XHRcdGF0dGFjaG1lbnQ6ICd0b2dldGhlcicsXHJcblx0XHRcdFx0XHRcdHBpbjogZmFsc2VcclxuXHRcdFx0XHRcdH1cclxuXHRcdFx0XHRdXHJcblx0XHRcdH1cclxuXHRcdH07XHJcblx0XHRcclxuXHRcdC8qXHJcblx0XHRcdFBsdWdpbnMgcGFnZVxyXG5cdFx0Ki9cclxuXHJcblx0XHRtYWluX3RvdXIuYWRkU3RlcCggJ2ludHJvJywge1xyXG5cdFx0XHR0aXRsZTogd3BiY190b3VyX2kxOG4ucGx1Z2luc19wYWdlLnRpdGxlLFxyXG5cdFx0XHR0ZXh0OiB3cGJjX3RvdXJfaTE4bi5wbHVnaW5zX3BhZ2UudGV4dCxcclxuXHRcdFx0YXR0YWNoVG86ICcud3BiY19wbHVnaW5zX2xpbmtzX19zdGFydF90b3VyIHRvcCcsXHJcblx0XHRcdGJ1dHRvbnM6IFtcclxuXHRcdFx0XHR7XHJcblx0XHRcdFx0XHRjbGFzc2VzOiBidXR0b25fY2xhc3NlcyxcclxuXHRcdFx0XHRcdHRleHQ6IHdwYmNfdG91cl9pMThuLnBsdWdpbnNfcGFnZS5idXR0b24udGV4dCxcclxuXHRcdFx0XHRcdGFjdGlvbjogZnVuY3Rpb24oKSB7XHJcblx0XHRcdFx0XHRcdHdpbmRvdy5sb2NhdGlvbiA9IHdwYmNfdG91cl9pMThuLnBsdWdpbnNfcGFnZS5idXR0b24udXJsO1xyXG5cdFx0XHRcdFx0fVxyXG5cdFx0XHRcdH1cclxuXHRcdFx0XSxcclxuXHRcdFx0dGV0aGVyT3B0aW9uczoge1xyXG5cdFx0XHRcdGNvbnN0cmFpbnRzOiBbXHJcblx0XHRcdFx0XHR7XHJcblx0XHRcdFx0XHRcdHRvOiAnc2Nyb2xsUGFyZW50JyxcclxuXHRcdFx0XHRcdFx0YXR0YWNobWVudDogJ3RvZ2V0aGVyJyxcclxuXHRcdFx0XHRcdFx0cGluOiBmYWxzZVxyXG5cdFx0XHRcdFx0fVxyXG5cdFx0XHRcdF0sXHJcblx0XHRcdFx0b2Zmc2V0OiAnMjBweCAwJ1xyXG5cdFx0XHR9LFxyXG5cdFx0XHR3aGVuOiB7XHJcblx0XHRcdFx0c2hvdzogZnVuY3Rpb24oKSB7XHJcblx0XHRcdFx0XHQkKCdib2R5JykuYWRkQ2xhc3MoJ3BsdWdpbnNfcGFnZV9oaWdobGlnaHRfd3BiYycpO1xyXG5cdFx0XHRcdFx0dmFyIHBvcHVwID0gJCh0aGlzLmVsKTtcclxuXHRcdFx0XHRcdHZhciB0YXJnZXQgPSAkKHRoaXMudGV0aGVyLnRhcmdldCk7XHJcblx0XHRcdFx0XHQkKCdib2R5LCBodG1sJykuYW5pbWF0ZSh7XHJcblx0XHRcdFx0XHRcdHNjcm9sbFRvcDogcG9wdXAub2Zmc2V0KCkudG9wIC0gNTBcclxuXHRcdFx0XHRcdH0sIDUwMCwgZnVuY3Rpb24oKSB7XHJcblx0XHRcdFx0XHRcdHdpbmRvdy5zY3JvbGxUbygwLCBwb3B1cC5vZmZzZXQoKS50b3AgLSA1MCk7XHJcblx0XHRcdFx0XHR9KTtcclxuXHRcdFx0XHR9LFxyXG5cdFx0XHRcdGhpZGU6IGZ1bmN0aW9uKCkge1xyXG5cdFx0XHRcdFx0JCgnYm9keScpLnJlbW92ZUNsYXNzKCdwbHVnaW5zX3BhZ2VfaGlnaGxpZ2h0X3dwYmMnKTtcclxuXHRcdFx0XHR9XHJcblx0XHRcdH1cclxuXHRcdH0pO1xyXG5cclxuXHJcblx0XHQvKlxyXG5cdFx0XHRNYWluIFRvdXIgc3RlcHNcclxuXHRcdCovXHJcblxyXG5cdFx0Ly8gMS4gWW91ciBmaXJzdCBiYWNrdXBcclxuXHRcdG1haW5fdG91ci5hZGRTdGVwKCAnbWFpbl90b3VyX3N0YXJ0Jywge1xyXG5cdFx0XHR0aXRsZTogd3BiY190b3VyX2kxOG4uc2V0dXBfcGFnZS50aXRsZSxcclxuXHRcdFx0dGV4dDogIHdwYmNfdG91cl9pMThuLnNldHVwX3BhZ2UudGV4dCxcclxuXHRcdFx0Ly9hdHRhY2hUbzogJy53cGJjX3BhZ2VfdG9wX193aXphcmRfYnV0dG9uX2NvbnRlbnQgYm90dG9tJyxcclxuXHRcdFx0YXR0YWNoVG86IHsgZWxlbWVudDogalF1ZXJ5KCAnI3RvcGxldmVsX3BhZ2Vfd3BiYyB1bCBsaTpudGgtbGFzdC1jaGlsZCgyKScpLmdldCgwKSwgb246ICdyaWdodCd9LFxyXG5cdFx0XHRidXR0b25zOiBbXHJcblx0XHRcdFx0e1xyXG5cdFx0XHRcdFx0Y2xhc3NlczogJ3dwYmNfdG91cl9lbmQnLFxyXG5cdFx0XHRcdFx0dGV4dDogd3BiY190b3VyX2kxOG4uYnV0dG9uX2VuZF90b3VyLnRleHQsXHJcblx0XHRcdFx0XHRhY3Rpb246IG1haW5fdG91ci5jYW5jZWxcclxuXHRcdFx0XHR9LFxyXG5cdFx0XHRcdHtcclxuXHRcdFx0XHRcdGNsYXNzZXM6IGJ1dHRvbl9jbGFzc2VzLFxyXG5cdFx0XHRcdFx0dGV4dDogd3BiY190b3VyX2kxOG4uYnV0dG9uX25leHQudGV4dCxcclxuXHRcdFx0XHRcdGFjdGlvbjogZnVuY3Rpb24oKSB7XHJcblx0XHRcdFx0XHRcdC8valF1ZXJ5KCcud3BiY19wYWdlX3RvcF9fd2l6YXJkX2J1dHRvbl9jb250ZW50IC5idXR0b24nKS50cmlnZ2VyKCdjbGljaycpO1xyXG5cdFx0XHRcdFx0XHRqUXVlcnkoICcjdG9wbGV2ZWxfcGFnZV93cGJjIHVsIGxpOm50aC1sYXN0LWNoaWxkKDIpIGEnKS5nZXQoMCkuY2xpY2soKTtcclxuXHRcdFx0XHRcdH1cclxuXHRcdFx0XHR9XHJcblx0XHRcdF0sXHJcblx0XHRcdHRldGhlck9wdGlvbnM6IHtcclxuXHRcdFx0XHRjb25zdHJhaW50czogW1xyXG5cdFx0XHRcdFx0e1xyXG5cdFx0XHRcdFx0XHQgIHRvOiAnd2luZG93JyxcclxuICAgICAgXHRcdFx0XHRcdCAgYXR0YWNobWVudDogJ3RvZ2V0aGVyJ1xyXG5cdFx0XHRcdFx0fVxyXG5cdFx0XHRcdF0sXHJcblx0XHRcdFx0b2Zmc2V0OiAnMCAwJ1xyXG5cdFx0XHR9XHJcblx0XHR9KTtcclxuXHJcblx0fSk7XHJcblxyXG59KShqUXVlcnkpO1xyXG5cclxualF1ZXJ5KGRvY3VtZW50KS5yZWFkeShmdW5jdGlvbigpe1xyXG5cclxuXHRzZXRUaW1lb3V0KGZ1bmN0aW9uKCl7XHJcblx0XHRpZiAoalF1ZXJ5KCcud3BiY19wbHVnaW5zX2xpbmtzX19zdGFydF90b3VyJykubGVuZ3RoKXtcclxuXHRcdFx0d3BiY19tYWluX3RvdXIuc3RhcnQoKTtcclxuXHRcdH1cclxuXHRcdGlmIChqUXVlcnkoJy53cGJjX3BhZ2VfdG9wX193aXphcmRfYnV0dG9uX2NvbnRlbnQnKS5sZW5ndGgpe1xyXG5cdFx0XHR3cGJjX21haW5fdG91ci5zaG93KCdtYWluX3RvdXJfc3RhcnQnKTtcclxuXHRcdH1cclxuXHR9LDEwMDApXHJcbn0pO1xyXG4iXSwibWFwcGluZ3MiOiI7O0FBQUEsQ0FBQyxVQUFVQSxDQUFDLEVBQUU7RUFDYkEsQ0FBQyxDQUFFLFlBQVk7SUFFZDtJQUNBLElBQUssQ0FBRUMsTUFBTSxDQUFDQyxRQUFRLEVBQUc7TUFDeEI7SUFDRDtJQUVBLElBQUlDLGNBQWMsR0FBTSx1QkFBdUI7SUFDL0MsSUFBSUMsaUJBQWlCLEdBQUdILE1BQU0sQ0FBQ0ksc0JBQXNCLEdBQUcsSUFBSUgsUUFBUSxDQUFDSSxJQUFJLENBQUMsQ0FBQztJQUMzRSxJQUFJQyxTQUFTLEdBQVdOLE1BQU0sQ0FBQ08sY0FBYyxHQUFHLElBQUlOLFFBQVEsQ0FBQ0ksSUFBSSxDQUFDLENBQUM7O0lBRW5FO0lBQ0FDLFNBQVMsQ0FBQ0UsT0FBTyxDQUFDQyxRQUFRLEdBQUdOLGlCQUFpQixDQUFDSyxPQUFPLENBQUNDLFFBQVEsR0FBRztNQUNqRUMsT0FBTyxFQUFFLHNDQUFzQztNQUMvQ0MsY0FBYyxFQUFFLElBQUk7TUFDcEJDLFFBQVEsRUFBRSxLQUFLO01BQ2ZDLGFBQWEsRUFBRTtRQUNkQyxXQUFXLEVBQUUsQ0FDWjtVQUNDQyxFQUFFLEVBQUUsY0FBYztVQUNsQkMsVUFBVSxFQUFFLFVBQVU7VUFDdEJDLEdBQUcsRUFBRTtRQUNOLENBQUM7TUFFSDtJQUNELENBQUM7O0lBRUQ7QUFDRjtBQUNBOztJQUVFWCxTQUFTLENBQUNZLE9BQU8sQ0FBRSxPQUFPLEVBQUU7TUFDM0JDLEtBQUssRUFBRUMsY0FBYyxDQUFDQyxZQUFZLENBQUNGLEtBQUs7TUFDeENHLElBQUksRUFBRUYsY0FBYyxDQUFDQyxZQUFZLENBQUNDLElBQUk7TUFDdENDLFFBQVEsRUFBRSxxQ0FBcUM7TUFDL0NDLE9BQU8sRUFBRSxDQUNSO1FBQ0NkLE9BQU8sRUFBRVIsY0FBYztRQUN2Qm9CLElBQUksRUFBRUYsY0FBYyxDQUFDQyxZQUFZLENBQUNJLE1BQU0sQ0FBQ0gsSUFBSTtRQUM3Q0ksTUFBTSxFQUFFLFNBQUFBLENBQUEsRUFBVztVQUNsQjFCLE1BQU0sQ0FBQzJCLFFBQVEsR0FBR1AsY0FBYyxDQUFDQyxZQUFZLENBQUNJLE1BQU0sQ0FBQ0csR0FBRztRQUN6RDtNQUNELENBQUMsQ0FDRDtNQUNEZixhQUFhLEVBQUU7UUFDZEMsV0FBVyxFQUFFLENBQ1o7VUFDQ0MsRUFBRSxFQUFFLGNBQWM7VUFDbEJDLFVBQVUsRUFBRSxVQUFVO1VBQ3RCQyxHQUFHLEVBQUU7UUFDTixDQUFDLENBQ0Q7UUFDRFksTUFBTSxFQUFFO01BQ1QsQ0FBQztNQUNEQyxJQUFJLEVBQUU7UUFDTEMsSUFBSSxFQUFFLFNBQUFBLENBQUEsRUFBVztVQUNoQmhDLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQ2lDLFFBQVEsQ0FBQyw2QkFBNkIsQ0FBQztVQUNqRCxJQUFJQyxLQUFLLEdBQUdsQyxDQUFDLENBQUMsSUFBSSxDQUFDbUMsRUFBRSxDQUFDO1VBQ3RCLElBQUlDLE1BQU0sR0FBR3BDLENBQUMsQ0FBQyxJQUFJLENBQUNxQyxNQUFNLENBQUNELE1BQU0sQ0FBQztVQUNsQ3BDLENBQUMsQ0FBQyxZQUFZLENBQUMsQ0FBQ3NDLE9BQU8sQ0FBQztZQUN2QkMsU0FBUyxFQUFFTCxLQUFLLENBQUNKLE1BQU0sQ0FBQyxDQUFDLENBQUNVLEdBQUcsR0FBRztVQUNqQyxDQUFDLEVBQUUsR0FBRyxFQUFFLFlBQVc7WUFDbEJ2QyxNQUFNLENBQUNZLFFBQVEsQ0FBQyxDQUFDLEVBQUVxQixLQUFLLENBQUNKLE1BQU0sQ0FBQyxDQUFDLENBQUNVLEdBQUcsR0FBRyxFQUFFLENBQUM7VUFDNUMsQ0FBQyxDQUFDO1FBQ0gsQ0FBQztRQUNEQyxJQUFJLEVBQUUsU0FBQUEsQ0FBQSxFQUFXO1VBQ2hCekMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDMEMsV0FBVyxDQUFDLDZCQUE2QixDQUFDO1FBQ3JEO01BQ0Q7SUFDRCxDQUFDLENBQUM7O0lBR0Y7QUFDRjtBQUNBOztJQUVFO0lBQ0FuQyxTQUFTLENBQUNZLE9BQU8sQ0FBRSxpQkFBaUIsRUFBRTtNQUNyQ0MsS0FBSyxFQUFFQyxjQUFjLENBQUNzQixVQUFVLENBQUN2QixLQUFLO01BQ3RDRyxJQUFJLEVBQUdGLGNBQWMsQ0FBQ3NCLFVBQVUsQ0FBQ3BCLElBQUk7TUFDckM7TUFDQUMsUUFBUSxFQUFFO1FBQUVvQixPQUFPLEVBQUVDLE1BQU0sQ0FBRSw2Q0FBNkMsQ0FBQyxDQUFDQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1FBQUVDLEVBQUUsRUFBRTtNQUFPLENBQUM7TUFDaEd0QixPQUFPLEVBQUUsQ0FDUjtRQUNDZCxPQUFPLEVBQUUsZUFBZTtRQUN4QlksSUFBSSxFQUFFRixjQUFjLENBQUMyQixlQUFlLENBQUN6QixJQUFJO1FBQ3pDSSxNQUFNLEVBQUVwQixTQUFTLENBQUMwQztNQUNuQixDQUFDLEVBQ0Q7UUFDQ3RDLE9BQU8sRUFBRVIsY0FBYztRQUN2Qm9CLElBQUksRUFBRUYsY0FBYyxDQUFDNkIsV0FBVyxDQUFDM0IsSUFBSTtRQUNyQ0ksTUFBTSxFQUFFLFNBQUFBLENBQUEsRUFBVztVQUNsQjtVQUNBa0IsTUFBTSxDQUFFLCtDQUErQyxDQUFDLENBQUNDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQ0ssS0FBSyxDQUFDLENBQUM7UUFDeEU7TUFDRCxDQUFDLENBQ0Q7TUFDRHJDLGFBQWEsRUFBRTtRQUNkQyxXQUFXLEVBQUUsQ0FDWjtVQUNHQyxFQUFFLEVBQUUsUUFBUTtVQUNQQyxVQUFVLEVBQUU7UUFDcEIsQ0FBQyxDQUNEO1FBQ0RhLE1BQU0sRUFBRTtNQUNUO0lBQ0QsQ0FBQyxDQUFDO0VBRUgsQ0FBQyxDQUFDO0FBRUgsQ0FBQyxFQUFFZSxNQUFNLENBQUM7QUFFVkEsTUFBTSxDQUFDTyxRQUFRLENBQUMsQ0FBQ0MsS0FBSyxDQUFDLFlBQVU7RUFFaENDLFVBQVUsQ0FBQyxZQUFVO0lBQ3BCLElBQUlULE1BQU0sQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDVSxNQUFNLEVBQUM7TUFDcEQvQyxjQUFjLENBQUNnRCxLQUFLLENBQUMsQ0FBQztJQUN2QjtJQUNBLElBQUlYLE1BQU0sQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDVSxNQUFNLEVBQUM7TUFDMUQvQyxjQUFjLENBQUN3QixJQUFJLENBQUMsaUJBQWlCLENBQUM7SUFDdkM7RUFDRCxDQUFDLEVBQUMsSUFBSSxDQUFDO0FBQ1IsQ0FBQyxDQUFDIiwiaWdub3JlTGlzdCI6W119
