class SearchAutocomplete{static SELECTOR='.search-form, form[role="search"]';static DEBOUNCE_DELAY=300;static CACHE_TIMEOUT=3e5;constructor(e){this.form=e,this.searchInput=e.querySelector('input[name="s"]'),this.submitButton=e.querySelector('input[type="submit"], button[type="submit"]'),this.selectedIndex=-1,this.debounceTimer=null,this.cache=new Map,this.observer=null,this.searchInput&&(this.form.classList.add("bsearch-enabled"),this.initializeElements(),this.bindEvents())}initializeElements(){this.announceRegion=this.createAnnounceRegion(),this.form.insertBefore(this.announceRegion,this.form.firstChild),this.resultsContainer=this.createResultsContainer(),this.insertResultsContainer(),this.configureSearchInput()}createAnnounceRegion(){const e=document.createElement("div");return e.className="bsearch-visually-hidden",e.setAttribute("aria-live","assertive"),e.id=`announce-${this.generateId()}`,e}createResultsContainer(){const e=document.createElement("div");return e.className="bsearch-autocomplete-results",e.setAttribute("role","listbox"),e.id=`search-suggestions-${this.generateId()}`,e}generateId(){return Math.random().toString(36).substring(2,9)}insertResultsContainer(){this.searchInput.parentNode.insertBefore(this.resultsContainer,this.searchInput.nextSibling),this.positionResults()}positionResults(){const e=this.searchInput.getBoundingClientRect(),t=this.form.getBoundingClientRect(),s=e.bottom-t.top+4,n=e.left-t.left,i=e.width;this.resultsContainer.style.position="absolute",this.resultsContainer.style.top=`${s}px`,this.resultsContainer.style.left=`${n}px`,this.resultsContainer.style.width=`${i}px`}configureSearchInput(){Object.entries({autocomplete:"off","aria-autocomplete":"list","aria-controls":this.resultsContainer.id,"aria-expanded":"false",autocapitalize:"off",spellcheck:"false"}).forEach((([e,t])=>{this.searchInput.setAttribute(e,t)}))}bindEvents(){this.form.addEventListener("submit",(()=>this.clearCache())),this.searchInput.addEventListener("input",this.handleInput.bind(this)),this.searchInput.addEventListener("keydown",this.handleInputKeydown.bind(this)),this.searchInput.addEventListener("focus",this.handleInputFocus.bind(this)),this.searchInput.addEventListener("focusout",this.handleInputBlur.bind(this)),this.submitButton&&this.submitButton.addEventListener("keydown",this.handleSubmitKeydown.bind(this)),this.resultsContainer.addEventListener("keydown",this.handleResultsKeydown.bind(this)),this.resultsContainer.addEventListener("focusout",this.handleResultsBlur.bind(this)),this.setupMutationObserver(),document.addEventListener("click",this.handleDocumentClick.bind(this)),window.addEventListener("resize",this.positionResults.bind(this))}handleInput(){clearTimeout(this.debounceTimer),this.debounceTimer=setTimeout((()=>{const e=this.searchInput.value.trim();e.length>2?(this.announce(bsearch_live_search.strings.searching),this.fetchResults(e)):(this.announce(0===e.length?"":bsearch_live_search.strings.min_chars),this.clearResults())}),SearchAutocomplete.DEBOUNCE_DELAY)}handleInputKeydown(e){const t=this.resultsContainer.querySelectorAll("li");switch(e.key){case"Escape":e.preventDefault(),this.clearResults(),this.announce(bsearch_live_search.strings.suggestions_closed);break;case"ArrowDown":e.preventDefault(),this.handleArrowDown(t);break;case"ArrowUp":e.preventDefault(),this.handleArrowUp(t);break;case"Enter":this.handleEnter(t,e);break}}handleArrowDown(e){!e.length&&this.searchInput.value.length>2?this.fetchResults(this.searchInput.value):(-1===this.selectedIndex?this.selectedIndex=0:this.selectedIndex=e.length?Math.min(this.selectedIndex+1,e.length-1):0,this.updateSelection(e))}handleArrowUp(e){e.length&&(-1===this.selectedIndex?this.selectedIndex=e.length-1:this.selectedIndex=this.selectedIndex>0?this.selectedIndex-1:e.length-1,this.updateSelection(e))}handleEnter(e,t){if(e.length&&this.selectedIndex>=0){t.preventDefault();const s=e[this.selectedIndex].querySelector("a");s?.href&&(this.announce(bsearch_live_search.strings.navigating_to.replace("%s",s.textContent)),window.location.href=s.href)}else this.announce(bsearch_live_search.strings.submitting_search),this.form.submit()}handleSubmitKeydown(e){const t=this.resultsContainer.querySelectorAll("li");switch(e.key){case"Escape":e.preventDefault(),this.clearResults(),this.searchInput.focus(),this.announce(bsearch_live_search.strings.suggestions_closed);break;case"ArrowDown":if(!t.length)return;e.preventDefault(),this.selectedIndex=0,this.updateSelection(t);break;case"ArrowUp":e.preventDefault(),this.searchInput.focus(),this.announce(bsearch_live_search.strings.back_to_input);break}}handleResultsKeydown(e){const t=this.resultsContainer.querySelectorAll("li");if(t.length)switch(e.key){case"ArrowDown":e.preventDefault(),this.selectedIndex=Math.min(this.selectedIndex+1,t.length-1),this.updateSelection(t);break;case"ArrowUp":e.preventDefault(),this.handleResultsArrowUp(t);break;case"Escape":e.preventDefault(),this.clearResults(),this.searchInput.focus(),this.announce(bsearch_live_search.strings.suggestions_closed);break;case"Enter":e.preventDefault(),this.handleResultsEnter(t);break}}handleResultsArrowUp(e){0===this.selectedIndex?(this.searchInput.focus(),this.selectedIndex=-1,this.announce(bsearch_live_search.strings.back_to_search)):(this.selectedIndex--,this.updateSelection(e))}handleResultsEnter(e){if(this.selectedIndex>=0&&this.selectedIndex<e.length){const t=e[this.selectedIndex].querySelector("a");t?.href?(this.announce(bsearch_live_search.strings.navigating_to.replace("%s",t.textContent)),window.location.href=t.href):(this.searchInput.value=e[this.selectedIndex].textContent,this.form.submit())}}setupMutationObserver(){this.observer=new MutationObserver((e=>{e.forEach((e=>{"childList"===e.type&&e.addedNodes.forEach((e=>{"A"===e.tagName||e.querySelectorAll}))}))})),this.observer.observe(this.resultsContainer,{childList:!0,subtree:!0})}handleDocumentClick(e){this.form.contains(e.target)||this.resultsContainer.contains(e.target)||this.clearResults()}handleInputFocus(){this.resultsContainer.innerHTML.trim()&&this.searchInput.value.length>2&&(this.resultsContainer.style.display="block")}handleInputBlur(){setTimeout((()=>{null!==document.activeElement?.closest(SearchAutocomplete.SELECTOR)||null!==document.activeElement?.closest(".bsearch-autocomplete-results")||(this.clearResults(),this.announce(bsearch_live_search.strings.suggestions_closed))}),150)}handleResultsBlur(){setTimeout((()=>{null!==document.activeElement?.closest(SearchAutocomplete.SELECTOR)||null!==document.activeElement?.closest(".bsearch-autocomplete-results")||(this.clearResults(),this.announce(bsearch_live_search.strings.suggestions_closed))}),150)}announce(e){this.announceRegion.textContent=e}clearResults(){this.observer&&(this.observer.disconnect(),this.observer.observe(this.resultsContainer,{childList:!0,subtree:!0})),this.resultsContainer.innerHTML="",this.resultsContainer.style.display="none",this.selectedIndex=-1,this.searchInput.removeAttribute("aria-activedescendant"),this.searchInput.setAttribute("aria-expanded","false"),this.announceRegion.textContent=""}updateSelection(e){e.forEach((e=>{e.classList.remove("bsearch-selected"),e.setAttribute("aria-selected","false")}));const t=e[this.selectedIndex];if(t){t.classList.add("bsearch-selected"),t.setAttribute("aria-selected","true"),t.scrollIntoView({block:"nearest"}),this.searchInput.setAttribute("aria-activedescendant",t.id);const s=t.querySelector("a");if(s&&s.focus(),bsearch_live_search.strings.result_position){const s=bsearch_live_search.strings.result_position.replace("%1$d",this.selectedIndex+1).replace("%2$d",e.length);this.announce(`${t.textContent}. ${s}`)}else this.announce(t.textContent)}}getCachedResults(e){const t=this.cache.get(e);if(!t)return null;return Date.now()-t.timestamp>SearchAutocomplete.CACHE_TIMEOUT?(this.cache.delete(e),null):t.results}cacheResults(e,t){if(this.cache.size>50){const e=this.cache.keys().next().value;this.cache.delete(e)}this.cache.set(e,{results:t,timestamp:Date.now()})}clearCache(){this.cache.clear()}async fetchResults(e){try{const t=this.getCachedResults(e);if(t)return void this.displayResults(t,t.length);this.showLoadingSpinner();const s=await fetch(bsearch_live_search.ajax_url,{method:"POST",headers:{"Content-Type":"application/x-www-form-urlencoded","Cache-Control":"no-cache"},body:new URLSearchParams({action:"bsearch_live_search",s:e}).toString()}),n=await s.json(),i=Array.isArray(n)?n:n.results,r=Array.isArray(n)?n.length:n.total;this.cacheResults(e,i),this.displayResults(i,r)}catch(e){this.clearResults(),this.announce(bsearch_live_search.strings.error_loading)}finally{this.hideLoadingSpinner()}}displayResults(e,t=e.length){if(this.resultsContainer.innerHTML="",!e.length)return void this.announce(bsearch_live_search.strings.no_suggestions);const s=document.createElement("ul");s.setAttribute("role","listbox"),e.forEach(((e,t)=>{const n=document.createElement("li");n.setAttribute("role","option"),n.setAttribute("aria-selected","false"),n.id=`search-suggestion-${t}`;const i=document.createElement("a");i.href=e.link,i.textContent=e.title,bsearch_live_search.strings.view_post&&i.setAttribute("aria-label",bsearch_live_search.strings.view_post.replace("%s",e.title)),n.appendChild(i),s.appendChild(n)})),this.resultsContainer.appendChild(s),this.resultsContainer.style.display="block",this.searchInput.setAttribute("aria-expanded","true"),this.positionResults(),this.announce(bsearch_live_search.strings.suggestions_found.replace("%d",t))}showLoadingSpinner(){this.resultsContainer.innerHTML="";const e=document.createElement("div");e.className="bsearch-loading-spinner",e.innerHTML='<div class="bsearch-spinner"></div>Searching...',this.resultsContainer.appendChild(e),this.resultsContainer.style.display="block",this.positionResults(),this.searchInput.classList.add("bsearch-search-loading"),this.announce("Searching for results...")}hideLoadingSpinner(){this.searchInput.classList.remove("bsearch-search-loading");const e=this.resultsContainer.querySelector(".bsearch-loading-spinner");e&&e.remove()}}document.addEventListener("DOMContentLoaded",(()=>{document.querySelectorAll(SearchAutocomplete.SELECTOR).forEach((e=>new SearchAutocomplete(e)))}));