<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace RexFeed\Google\Service\ShoppingContent;

class Address extends \RexFeed\Google\Model
{
    /**
     * @var string
     */
    public $administrativeArea;
    /**
     * @var string
     */
    public $city;
    /**
     * @var string
     */
    public $country;
    /**
     * @var string
     */
    public $postalCode;
    /**
     * @var string
     */
    public $streetAddress;
    /**
     * @param string
     */
    public function setAdministrativeArea($administrativeArea)
    {
        $this->administrativeArea = $administrativeArea;
    }
    /**
     * @return string
     */
    public function getAdministrativeArea()
    {
        return $this->administrativeArea;
    }
    /**
     * @param string
     */
    public function setCity($city)
    {
        $this->city = $city;
    }
    /**
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * @param string
     */
    public function setCountry($country)
    {
        $this->country = $country;
    }
    /**
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * @param string
     */
    public function setPostalCode($postalCode)
    {
        $this->postalCode = $postalCode;
    }
    /**
     * @return string
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * @param string
     */
    public function setStreetAddress($streetAddress)
    {
        $this->streetAddress = $streetAddress;
    }
    /**
     * @return string
     */
    public function getStreetAddress()
    {
        return $this->streetAddress;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(Address::class, 'RexFeed\\Google_Service_ShoppingContent_Address');
