<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Beehive\Google\Service\Analytics;

class AdWordsAccount extends \Beehive\Google\Model
{
    /**
     * @var bool
     */
    public $autoTaggingEnabled;
    /**
     * @var string
     */
    public $customerId;
    /**
     * @var string
     */
    public $kind;
    /**
     * @param bool
     */
    public function setAutoTaggingEnabled($autoTaggingEnabled)
    {
        $this->autoTaggingEnabled = $autoTaggingEnabled;
    }
    /**
     * @return bool
     */
    public function getAutoTaggingEnabled()
    {
        return $this->autoTaggingEnabled;
    }
    /**
     * @param string
     */
    public function setCustomerId($customerId)
    {
        $this->customerId = $customerId;
    }
    /**
     * @return string
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * @param string
     */
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    /**
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(AdWordsAccount::class, 'Beehive\\Google_Service_Analytics_AdWordsAccount');
