(function ($) {
    'use strict';
    
    jQuery(document).ready(function (jQuery) {

        // script for start with new layout modal
        $(document).on('click', '.wbm-old-layout-sec-main .wbm-widgets-cols', function(){
            $('body').addClass('wbm-new-layout-modal-active');
        });

        $(document).on('click', '.wbm-old-layout-sec-main .modal-close-btn', function(){
            $('body').removeClass('wbm-new-layout-modal-active');
        });

        // script for product & category slider settings tab
        $('.sliders-settings-tabs .wbm-slider-tab:first-child').addClass('active-tab');
        $('.wbm-sliders-table .wbm-slider-section').hide();
        $('.wbm-sliders-table .wbm-slider-section:first').show();
        
        $('.sliders-settings-tabs .wbm-slider-tab a').click(function() {
            $('.sliders-settings-tabs .wbm-slider-tab').removeClass('active-tab');
            $(this).parent().addClass('active-tab');

            // Display active tab
            let currentTab = $(this).attr('href');
            $('.wbm-sliders-table .wbm-slider-section').hide();
            $(currentTab).fadeIn();

            return false;
        });

        // script for plugin rating
        $(document).on('click', '.dotstore_plugin_sidebar .content_box .et-star-rating label', function(e){
            e.stopImmediatePropagation();
            var rurl = $('#et-review-url').val();
            window.open( rurl, '_blank' );
        });

        /**Set preview image of product specific banner */
        jQuery('#product_banner_preview_link').click(function(e){
            e.preventDefault();
            jQuery('html, body').animate({
                scrollTop: jQuery('#product_banner_previou_section').offset().top - 30
            }, 2000);
        });

        /**Set preview image of common page specific banner */
        jQuery('#other_pages_banner_preview_link').click(function(e){
            e.preventDefault();
            jQuery('html, body').animate({
                scrollTop: jQuery('#other_pages_banner_previou_section').offset().top - 30
            }, 2000);
        });
        jQuery('.cat_banner_title_color').wpColorPicker();
        jQuery('.cat_page_banner_button_text_color').wpColorPicker();
        jQuery('.cat_page_banner_button_bg_color').wpColorPicker();
        jQuery('.cat_page_banner_arrow_color').wpColorPicker();
        jQuery('.cat_page_banner_arrow_bg_color').wpColorPicker();
        jQuery('.wbm_slider_arrow_color').wpColorPicker();
        jQuery('.wbm_slider_arrow_bg_color').wpColorPicker();
        var readyCheckAttr = jQuery.trim(jQuery('#auto_display_banner').attr('checked'));
        var catSelectImageType = jQuery.trim(jQuery('#cat_select_image_type').val());

        if ('undefined' === readyCheckAttr || '' === readyCheckAttr) {
            jQuery('#select_banner').hide();
            jQuery('#hide_cat_banner_start_date').hide();
            jQuery('#hide_cat_banner_end_date').hide();
            jQuery('.hide_random_images_banner').hide();
            jQuery('.hide_cat_slider_setting').hide();

            jQuery('.hide_mdwbm_banner_url_form_field').hide();
            jQuery('.hide_mdwbm_banner_image_form_field').hide();

            jQuery('.hide_cat_single_banner_upload').hide();
            jQuery('.hide_cat_single_banner_image').hide();
            jQuery('.hide_banner_link_form_field').hide();
            jQuery('.top_display_banner').hide();
        } else {
            if ('cat-single-image' === catSelectImageType || '' === catSelectImageType ) {
                jQuery('.hide_random_images_banner').hide();
                jQuery('.hide_cat_slider_setting').hide();
                jQuery('.hide_mdwbm_banner_url_form_field').hide();
                jQuery('.hide_mdwbm_banner_image_form_field').hide();

                jQuery('.hide_cat_single_banner_upload').show();
                jQuery('.hide_banner_link_form_field').show();
            } else {
                jQuery('.hide_cat_single_banner_upload').hide();
                jQuery('.hide_cat_single_banner_image').hide();
                jQuery('.hide_banner_link_form_field').hide();

                jQuery('.hide_random_images_banner').show();
                jQuery('.hide_cat_slider_setting').show();
                jQuery('.hide_mdwbm_banner_url_form_field').show();
                jQuery('.hide_mdwbm_banner_image_form_field').show();
            }
            jQuery('.top_display_banner').show();
        }

        jQuery('#auto_display_banner').click(function () {
            var chkAttr = jQuery(this).is(':checked');
            if (!chkAttr) {
                jQuery('#select_banner').hide();
                jQuery('#hide_cat_banner_start_date').hide();
                jQuery('#hide_cat_banner_end_date').hide();
                jQuery('.hide_random_images_banner').hide();
                jQuery('.hide_cat_slider_setting').hide();

                jQuery('.hide_mdwbm_banner_url_form_field').hide();
                jQuery('.hide_mdwbm_banner_image_form_field').hide();

                jQuery('.hide_cat_single_banner_upload').hide();
                jQuery('.hide_cat_single_banner_image').hide();
                jQuery('.hide_banner_link_form_field').hide();
                jQuery('.top_display_banner').hide();
            } else {
                jQuery('#select_banner').show();
                jQuery('#hide_cat_banner_start_date').show();
                jQuery('#hide_cat_banner_end_date').show();
                if ('cat-single-image' === catSelectImageType || '' === catSelectImageType) {
                    jQuery('.hide_random_images_banner').hide();
                    jQuery('.hide_cat_slider_setting').hide();
                    jQuery('.hide_mdwbm_banner_url_form_field').hide();
                    jQuery('.hide_mdwbm_banner_image_form_field').hide();

                    jQuery('.hide_cat_single_banner_upload').show();
                    jQuery('.hide_cat_single_banner_image').show();
                    jQuery('.hide_banner_link_form_field').show();
                } else {
                    jQuery('.hide_cat_single_banner_upload').hide();
                    jQuery('.hide_cat_single_banner_image').hide();
                    jQuery('.hide_banner_link_form_field').hide();

                    jQuery('.hide_random_images_banner').show();
                    jQuery('.hide_cat_slider_setting').show();
                    jQuery('.hide_mdwbm_banner_url_form_field').show();
                    jQuery('.hide_mdwbm_banner_image_form_field').show();
                }
                jQuery('.top_display_banner').show();
            }
        });

        jQuery('#same_banner_for_child').click(function () {
            var chkAttr = jQuery(this).is(':checked');
            if (!chkAttr) {
                $('#same_banner_for_child').prop('checked', false);
            } else {
                $('#same_banner_for_child').prop('checked', true);
            }
        });

        jQuery('#mdwbm_remove_file_id').click(function () {
            jQuery('#cat_banner_single_img_admin_id').attr('src', '');
            jQuery('#mdwbm_image_id').val('');
            jQuery('#display_image_id').hide();
            jQuery('#cat-single-banner-image').hide();
        });

        jQuery('#mdwbm_upload_single_file_button').click(function () {
            jQuery('#display_image_id').show();
            jQuery('#cat-single-banner-image').show();
        });

        //Disable color and size fields if default title not selected
        var display_cate_title_flag = jQuery.trim(jQuery('#display_cate_title_flag').attr('checked'));

        if('undefined' === display_cate_title_flag || '' === display_cate_title_flag || 'checked' !== display_cate_title_flag){
            jQuery('#cat_page_banner_title_color_row td .button ').attr('disabled', true);
            jQuery('#cat_page_banner_title_size_row td #cat_banner_title_font_size ').attr('disabled', true);
        }

        // drag & drop js
        // jQuery( function() {
        //     jQuery( ".wbm-widget-title" ).draggable();
        //     jQuery( ".wbm-col-right" ).droppable({
        //       drop: function( event, ui ) {
        //       }
        //     });
        // });

        // script for sidebar toggle button
        var span_full = $('.toggleSidebar .dashicons');
        var show_sidebar = localStorage.getItem('wcbm-sidebar-display');
        if( ( null !== show_sidebar || undefined !== show_sidebar ) && ( 'hide' === show_sidebar ) ) {
            $('.all-pad').addClass('hide-sidebar');
            span_full.removeClass('dashicons-arrow-right-alt2').addClass('dashicons-arrow-left-alt2');
        } else {
            $('.all-pad').removeClass('hide-sidebar');
            span_full.removeClass('dashicons-arrow-left-alt2').addClass('dashicons-arrow-right-alt2');
        }

        $(document).on( 'click', '.toggleSidebar', function(){
            $('.all-pad').toggleClass('hide-sidebar');
            if( $('.all-pad').hasClass('hide-sidebar') ){
                localStorage.setItem('wcbm-sidebar-display', 'hide');
                span_full.removeClass('dashicons-arrow-right-alt2').addClass('dashicons-arrow-left-alt2');
                $('.all-pad .wcbm-section-right').css({'-webkit-transition': '.3s ease-in width', '-o-transition': '.3s ease-in width',  'transition': '.3s ease-in width'});
                $('.all-pad .wcbm-section-left').css({'-webkit-transition': '.3s ease-in width', '-o-transition': '.3s ease-in width',  'transition': '.3s ease-in width'});
                setTimeout(function() {
                    $('#dotsstoremain .dotstore_plugin_sidebar').css('display', 'none');
                }, 300);
            } else {
                localStorage.setItem('wcbm-sidebar-display', 'show');
                span_full.removeClass('dashicons-arrow-left-alt2').addClass('dashicons-arrow-right-alt2');
                $('.all-pad .wcbm-section-right').css({'-webkit-transition': '.3s ease-out width', '-o-transition': '.3s ease-out width',  'transition': '.3s ease-out width'});
                $('.all-pad .wcbm-section-left').css({'-webkit-transition': '.3s ease-out width', '-o-transition': '.3s ease-out width',  'transition': '.3s ease-out width'});
                $('#dotsstoremain .dotstore_plugin_sidebar').css('display', 'block');
            }
        });

        var bxSlider = jQuery.fn.bxSlider;
        var $window = $(window);
        jQuery.fn.bxSlider = function () {
            var slider = bxSlider.apply(this, arguments);
            if (!this.length || !arguments[0].mouseDrag) {
                return slider;
            }
            var posX;
            var $viewport = this.parents('.bx-viewport');
            $viewport
                .on('dragstart', dragHandler)
                .on('mousedown', mouseDownHandler);
            function dragHandler(e) {
                e.preventDefault();
            }
            function mouseDownHandler(e) {
                posX = e.pageX;
                $window.on('mousemove.bxSlider', mouseMoveHandler);
            }
            function mouseMoveHandler(e) {
                if (posX < e.pageX) {
                    slider.goToPrevSlide();
                } else {
                    slider.goToNextSlide();
                }
                $window.off('mousemove.bxSlider');
            }
            return slider;
        };

         /** Dynamic Promotional Bar START */
         $(document).on('click', '.dpbpop-close', function () {
            var popupName 		= $(this).attr('data-popup-name');
            setCookie( 'banner_' + popupName, 'yes', 60 * 24 * 7);
            $('.' + popupName).hide();
        });

		$(document).on('click', '.dpb-popup .dpb-popup-meta a', function () {
            var promotional_id = $(this).parents().find('.dpbpop-close').attr('data-bar-id');
            
            var dpb_api_url     = $('#dpb_api_url').val();
			//Create a new Student object using the values from the textfields
			var apiData = {
				'bar_id' : promotional_id
			};

			$.ajax({
				type: 'POST',
				url: dpb_api_url + '/wp-content/plugins/dots-dynamic-promotional-banner/bar-response.php',
				data: JSON.stringify(apiData),// now data come in this function
		        dataType: 'json',
		        cors: true,
		        contentType:'application/json',
		        
				success: function (data) {
					console.log(data);
				},
				error: function () {
				}
			 });
        });
        /** Dynamic Promotional Bar END */

        /** Plugin Setup Wizard Script START */
		// Hide & show wizard steps based on the url params 
	  	var urlParams = new URLSearchParams(window.location.search);
	  	if (urlParams.has('require_license')) {
	    	$('.ds-plugin-setup-wizard-main .tab-panel').hide();
	    	$( '.ds-plugin-setup-wizard-main #step5' ).show();
	  	} else {
	  		$( '.ds-plugin-setup-wizard-main #step1' ).show();
	  	}
	  	
        // Plugin setup wizard steps script
        $(document).on('click', '.ds-plugin-setup-wizard-main .tab-panel .btn-primary:not(.ds-wizard-complete)', function () {
	        var curruntStep = jQuery(this).closest('.tab-panel').attr('id');
	        var nextStep = 'step' + ( parseInt( curruntStep.slice(4,5) ) + 1 ); // Masteringjs.io

	        if( 'step5' !== curruntStep ) {
                // Youtube videos stop on next step
                $('iframe[src*="https://www.youtube.com/embed/"]').each(function(){
                    $(this).attr('src', $(this).attr('src'));
                    return false;
                });

	         	jQuery( '#' + curruntStep ).hide();
	            jQuery( '#' + nextStep ).show();   
	        }
	    });

	    // Get allow for marketing or not
	    if ( $( '.ds-plugin-setup-wizard-main .ds_count_me_in' ).is( ':checked' ) ) {
	    	$('#fs_marketing_optin input[name="allow-marketing"][value="true"]').prop('checked', true);
	    } else {
	    	$('#fs_marketing_optin input[name="allow-marketing"][value="false"]').prop('checked', true);
	    }

		// Get allow for marketing or not on change	    
	    $(document).on( 'change', '.ds-plugin-setup-wizard-main .ds_count_me_in', function() {
			if ( this.checked ) {
				$('#fs_marketing_optin input[name="allow-marketing"][value="true"]').prop('checked', true);
			} else {
		    	$('#fs_marketing_optin input[name="allow-marketing"][value="false"]').prop('checked', true);
		    }
		});

	    // Complete setup wizard
	    $(document).on( 'click', '.ds-plugin-setup-wizard-main .tab-panel .ds-wizard-complete', function() {
			if ( $( '.ds-plugin-setup-wizard-main .ds_count_me_in' ).is( ':checked' ) ) {
				$( '.fs-actions button'  ).trigger('click');
			} else {
		    	$('.fs-actions #skip_activation')[0].click();
		    }
		});

	    // Send setup wizard data on Ajax callback
		$(document).on( 'click', '.ds-plugin-setup-wizard-main .fs-actions button', function() {
            var setup_wizard_ajax_nonce = $('#wizard_ajax_nonce').val();
			var wizardData = {
                'action': 'wcbm_plugin_setup_wizard_submit',
                'survey_list': $('.ds-plugin-setup-wizard-main .ds-wizard-where-hear-select').val(),
                'nonce': setup_wizard_ajax_nonce
            };

            $.ajax({
                url: ajaxurl,
                data: wizardData,
                success: function ( success ) {
                    console.log(success);
                }
            });
		});
		/** Plugin Setup Wizard Script End */

        /** Upgrade Dashboard Script START */
	    // Dashboard features popup script
	    $(document).on('click', '.dotstore-upgrade-dashboard .premium-key-fetures .premium-feature-popup', function (event) {
            let $trigger = $('.feature-explanation-popup, .feature-explanation-popup *');
            if(!$trigger.is(event.target) && $trigger.has(event.target).length === 0){
                $('.feature-explanation-popup-main').not($(this).find('.feature-explanation-popup-main')).hide();
                $(this).parents('li').find('.feature-explanation-popup-main').show();
                $('body').addClass('feature-explanation-popup-visible');
            }
        });
        $(document).on('click', '.dotstore-upgrade-dashboard .popup-close-btn', function () {
            $(this).parents('.feature-explanation-popup-main').hide();
            $('body').removeClass('feature-explanation-popup-visible');
        });
	    /** Upgrade Dashboard Script End */

        // Script for Beacon configuration
        var helpBeaconCookie = getCookie( 'wcbm-help-beacon-hide' );
        if ( ! helpBeaconCookie ) {
            if ( typeof Beacon === 'function' ) {
                Beacon('init', 'afe1c188-3c3b-4c5f-9dbd-87329301c920');
                Beacon('config', {
                    display: {
                        style: 'icon',
                        iconImage: 'message',
                        zIndex: '99999'
                    }
                });

                // Add plugin articles IDs to display in beacon
                Beacon('suggest', ['5e0315a404286364bc93388f', '5e0325512c7d3a7e9ae58065', '5e032a612c7d3a7e9ae5806c', '601004dd2e764327f87c253b', '5e03344e04286364bc9338ca']);

                // Add custom close icon form beacon
                setTimeout(function() {
                    if ( $( '.hsds-beacon .BeaconFabButtonFrame' ).length > 0 ) {
                        let newElement = document.createElement('span');
                        newElement.classList.add('dashicons', 'dashicons-no-alt', 'dots-beacon-close');
                        let container = document.getElementsByClassName('BeaconFabButtonFrame');
                        container[0].appendChild( newElement );
                    }
                }, 3000);

                // Hide beacon
                $(document).on('click', '.dots-beacon-close', function(){
                    Beacon('destroy');
                    setCookie( 'wcbm-help-beacon-hide' , 'true', 24 * 60 );
                });
            }
        }

        /** Script for Freemius upgrade popup */
        $(document).on('click', '#dotsstoremain .wcbm-pro-label, .wcbm-section-left .wcbm-upgrade-to-pro, .form-field .wcbm-pro-label', function(){
            $('body').addClass('wcbm-modal-visible');
        });
        $(document).on('click', '.upgrade-to-pro-modal-main .modal-close-btn', function(){
            $('body').removeClass('wcbm-modal-visible');
        });
        $(document).on('click', '.dots-header .dots-upgrade-btn, .dotstore-upgrade-dashboard .upgrade-now', function(e){
            e.preventDefault();
            upgradeToProFreemius( '' );
        });
        $(document).on('click', '.upgrade-to-pro-modal-main .upgrade-now', function(e){
            e.preventDefault();
            $('body').removeClass('wcbm-modal-visible');
            let couponCode = $('.upgrade-to-pro-discount-code').val();
            upgradeToProFreemius( couponCode );
        });
        upgrdeProSelectOption( 'select.shop-select-image-type-pro', 'shop-multiple-images' );
        upgrdeProSelectOption( '#wbm_filter_categories', 'wbm_exclude_categories_disable' );
        
        $(".wcbm-doc-link").click(function (event) {
            event.preventDefault(); // Prevents any default anchor behavior
            event.stopPropagation(); // Prevents parent accordion click event
            var href = $(this).data("href");
            if (href) {
                window.open(href, "_blank"); // Opens link in a new tab
            }
        });
    });
    
    // Function to display upgrade to pro popup on premium option select
    function upgrdeProSelectOption(name, value) {
        jQuery(name).change(function () {
            let selectValue = $(this).val();
            if( value === selectValue ){
                jQuery(this).find(':selected').prop('selected', false);

                jQuery('body').addClass('wcbm-modal-visible');
            }
        });
    }

    // Set cookies
    function setCookie(name, value, minutes) {
        var expires = '';
        if (minutes) {
            var date = new Date();
            date.setTime(date.getTime() + (minutes * 60 * 1000));
            expires = '; expires=' + date.toUTCString();
        }
        document.cookie = name + '=' + (value || '') + expires + '; path=/';
    }

    // Get cookies
    function getCookie(name) {
        let nameEQ = name + '=';
        let ca = document.cookie.split(';');
        for (let i = 0; i < ca.length; i++) {
            let c = ca[i].trim();
            if (c.indexOf(nameEQ) === 0) {
                return c.substring(nameEQ.length, c.length);
            }
        }
        return null;
    }

    /** Script for Freemius upgrade popup */
    function upgradeToProFreemius( couponCode ) {
        let handler;
        handler = FS.Checkout.configure({
            plugin_id: '3494',
            plan_id: '5575',
            public_key:'pk_9edf804dccd14eabfd00ff503acaf',
            image: 'https://www.thedotstore.com/wp-content/uploads/sites/1417/2023/10/WooCommerce-Banner-Management-Banner-New.png',
            coupon: couponCode,
        });
        handler.open({
            name: 'Woo Category Banner Management',
            subtitle: 'You’re a step closer to our Pro features',
            licenses: jQuery('input[name="licence"]:checked').val(),
            purchaseCompleted: function( response ) {
                console.log (response);
            },
            success: function (response) {
                console.log (response);
            }
        });
    }

    $(window).load(function () {

        $('body').on('click', '#wbm_shop_setting_enable', function () {
            var checked = $('input[id="wbm_shop_setting_enable"][type="checkbox"]:checked').val();
            if ('on' === checked) {
                $('.wbm_shop_page_enable_open_div').css('display', 'block');
            } else {
                $('.wbm_shop_page_enable_open_div').css('display', 'none');
            }

        });

        //script for cart page setting script
        $('body').on('click', '#wbm_shop_setting_cart_enable', function () {
            var checked = $('input[id="wbm_shop_setting_cart_enable"][type="checkbox"]:checked').val();
            if ('on' === checked) {
                $('.wbm-cart-upload-image-html').css('display', 'block');
            } else {
                $('.wbm-cart-upload-image-html').css('display', 'none');
            }
        });

        //script for check out page setting script
        $('body').on('click', '#wbm_shop_setting_checkout_enable', function () {
            var checked = $('input[id="wbm_shop_setting_checkout_enable"][type="checkbox"]:checked').val();
            if ('on' === checked) {
                $('.wbm-checkout-upload-image-html').css('display', 'block');
            } else {
                $('.wbm-checkout-upload-image-html').css('display', 'none');
            }
        });

        //script for tahnk you page
        $('body').on('click', '#wbm_shop_setting_thank_you_page_enable', function () {
            var checked = $('input[id="wbm_shop_setting_thank_you_page_enable"][type="checkbox"]:checked').val();
            if ('on' === checked) {
                $('.wbm-thank-you-page-upload-image-html').css('display', 'block');
            } else {
                $('.wbm-thank-you-page-upload-image-html').css('display', 'none');
            }
        });

        //script for other pages
        $('body').on('click', '#wbm_other_page_setting_enable', function () {
            var checked = $('input[id="wbm_other_page_setting_enable"][type="checkbox"]:checked').val();
            if ('on' === checked) {
                $('.wbm_other_page_enable_open_div').css('display', 'block');
            } else {
                $('.wbm_other_page_enable_open_div').css('display', 'none');
            }
        });

         //script for product detail page
         $('body').on('click', '#wbm_shop_setting_banner_detail_page_enable', function () {
            var checked = $('input[id="wbm_shop_setting_banner_detail_page_enable"][type="checkbox"]:checked').val();
            if ('on' === checked) {
                $('.wbm-banner_detail-page-upload-image-html').css('display', 'block');
            } else {
                $('.wbm-banner_detail-page-upload-image-html').css('display', 'none');
            }
        });

        //Disable color and size fields if default title not selected
        $('body').on('click', '#display_cate_title_flag', function () {
            jQuery('#cat_page_banner_title_color_row td .button ').attr('disabled', !this.checked);
            jQuery('#cat_page_banner_title_size_row td #cat_banner_title_font_size ').attr('disabled', !this.checked);
        });

        //script for save the setting data
        $('body').on('click', '#save_top_wbm_shop_page_setting', function () {
            saveBannerSettingPage();
        });

        $('body').on('click', '#save_wbm_shop_page_setting', function () {
            saveBannerSettingPage();
            $('html, body').animate({scrollTop: 0}, 2000);
            return false;
        });

        //accrodian jquery script

        jQuery('.custom-accordian .aco-title').click(function () {
            jQuery(this).siblings().slideToggle(400);
            jQuery(this).toggleClass('open');
        });

        function closeAccordionSection() {
            jQuery('.accordion .accordion-section-title').removeClass('active');
            jQuery('.accordion .accordion-section-content').slideUp(300).removeClass('open');
        }

        function closeAccordionPreviewSection() {
            jQuery('.accordion_preview .accordion_preview-section-title').removeClass('active');
            jQuery('.accordion_preview .accordion_preview-section-content').slideUp(300).removeClass('open');
        }

        jQuery('.accordion-section-title').click(function (e) {

            // Grab current anchor value
            var currentAttrValue = jQuery(this).attr('href');

            if (jQuery(e.target).is('.active')) {
                closeAccordionSection();
            } else {
                closeAccordionSection();

                // Add active class to section title
                jQuery(this).addClass('active');

                // Open up the hidden content panel
                jQuery('.accordion ' + currentAttrValue).slideDown(300).addClass('open');
            }

            e.preventDefault();
        });

        jQuery("input[name='wbm_category_slider_general[dswbm_slider_mode]']+label").click(function(){
            jQuery("input[name='wbm_category_slider_general[dswbm_slider_mode]']").parent().removeClass('dswbm--active');   
            jQuery(this).parent().addClass('dswbm--active');
            jQuery(this).parent().find('input').prop('checked', true);
        });
        jQuery("input[name='wbm_product_slider_general[dswbm_slider_mode]']+label").click(function(){
            jQuery("input[name='wbm_product_slider_general[dswbm_slider_mode]']").parent().removeClass('dswbm--active');   
            jQuery(this).parent().addClass('dswbm--active');
            jQuery(this).parent().find('input').prop('checked', true);
        });
        jQuery("input[name='wbm_category_slider_general[dswbm_child_categories]']+label").click(function(){
            jQuery("input[name='wbm_category_slider_general[dswbm_child_categories]']").parent().removeClass('dswbm--active');   
            jQuery(this).parent().addClass('dswbm--active');
            jQuery(this).parent().find('input').prop('checked', true);
            if ( 'parent' === jQuery(this).parent().find('input').val() ) {
                jQuery('.wbm-parent-cat').show();
                jQuery('.wbm-parent-nd-child-cat').hide();
                if( 'wbm_specific_categories' === jQuery( '[name="wbm_category_slider_general[wbm_filter_categories]"]' ).val() ){
                    jQuery('.wbm-select-categories').show();
                    jQuery('.wbm-exclude-categories').hide();
                }else if( 'wbm_exclude_categories' === jQuery( '[name="wbm_category_slider_general[wbm_filter_categories]"]' ).val() ){
                    jQuery('.wbm-exclude-categories').show();
                    jQuery('.wbm-select-categories').hide();
                }else if( 'wbm_all_categories' === jQuery( '[name="wbm_category_slider_general[wbm_filter_categories]"]' ).val() ){
                    jQuery('.wbm-select-categories').hide();
                    jQuery('.wbm-exclude-categories').hide();
                }else{
                    jQuery('.wbm-select-categories').hide();
                }
            } else {
                jQuery('.wbm-parent-cat').hide();
                jQuery('.wbm-parent-nd-child-cat').show();
            }
        });
        jQuery(".dswbm--image-area").click(function(){
            jQuery(".dswbm--image-area").parent().removeClass('dswbm-active');   
            jQuery(this).parent().addClass('dswbm-active');
            jQuery(this).find('input').prop('checked', true);
        });
        jQuery(".wbm--image-area").click(function(){
            jQuery(".wbm--image-area").parent().removeClass('wbm-active');   
            jQuery(this).parent().addClass('wbm-active');
            jQuery(this).find('input').prop('checked', true);
            if( 'custom' === jQuery(this).find('input').val()){
                jQuery(this).parents('tr').next().fadeIn();
            } else {
                jQuery(this).parents('tr').next().fadeOut();
            }
        });
        jQuery(".dswbm_toggle_switch_to_next").click(function(){
            if( jQuery(this).find('[type="checkbox"]').is(":checked") ){
                jQuery(this).parents('tr').next().show();
            }else{
                jQuery(this).parents('tr').next().hide();
            }
        });

        jQuery('.accordion_preview-section-title').click(function (e) {

            // Grab current anchor value
            var currentAttrValue = jQuery(this).attr('href');

            if (jQuery(e.target).is('.active')) {
                closeAccordionPreviewSection();
            } else {
                closeAccordionPreviewSection();

                // Add active class to section title
                jQuery(this).addClass('active');

                // Open up the hidden content panel
                jQuery('.accordion_preview ' + currentAttrValue).slideDown(300).addClass('open');
            }

            e.preventDefault();
        });

    });

    function saveBannerSettingPage() {
        var shopPageBannerSelectImageResults = '';
        var shopPageBannerSelectTargetResults = '';
        var shopPageBannerSelectRelationResults = '';
        var shopPageBannerImageResults = '';
        var shopPageBannerLinkResults = '';
        var shopPageBannerEnableOrNotResults = '';
        var shopPageBannerEnableRandomImagesResults = '';
        var shopPageBannerStartDateResults = '';
        var shopPageBannerEndDateResults = '';
        var shopPageBannerTopOrNotResults = '';
        var shopPageBannerEnableRandomImagesDotsResults = '';
        var shopPageBannerSingleImageLinkResults = '';
        var shop_page_banner_image_sizeResult = '';
        var shopPageBannerSingleImageResult = '';
        var shopPageBannerArrowColorResults = '';
        var shopPageBannerArrowBgColorResults = '';
        var shopPageBannerSelectImage;
        var shopPageBannerSelectTarget;
        var shopPageBannerSelectRelation;
        var shopPageBannerSingleImage;
        var shopPageBannerImage;
        var shopPageBannerLink;
        var shopPageBannerSingleImageLink;
        var shop_page_banner_image_size;
        var shopPageBannerEnableOrNot;
        var shopPageBannerEnableRandomImages;
        var shopPageBannerStartDate;
        var shopPageBannerEndDate;
        var shopPageBannerTopOrNot;
        var shopPageBannerEnableRandomImagesDots;
        var shopPageBannerArrowColor;
        var shopPageBannerArrowBgColor;
        var shop = [];
        var shopPageUrl;

        var otherPageBannerSelectImageResults = '';
        var otherPageBannerSelectTargetResults = '';
        var otherPageBannerSelectRelationResults = '';
        var otherPageBannerImageResults = '';
        var otherPageBannerLinkResults = '';
        var otherPageBannerEnableOrNotResults = '';
        var otherPageBannerDetailEnableOrNotResults = '';
        var otherPageBannerEnableRandomImagesResults = '';
        var otherPageBannerStartDateResults = '';
        var otherPageBannerEndDateResults = '';
        var otherPageBannerTopOrNotResults = '';
        var otherPageBannerEnableRandomImagesDotsResults = '';
        var otherPageBannerSingleImageLinkResults = '';
        var other_page_banner_image_sizeResult = '';
        var otherPageBannerSingleImageResult = '';
        var otherPageBannerArrowColorResults = '';
        var otherPageBannerArrowBgColorResults = '';
        var otherPageBannerSelectImage;
        var otherPageBannerSelectTarget;
        var otherPageBannerSelectRelation;
        var otherPageBannerSingleImage;
        var otherPageBannerImage;
        var otherPageBannerLink;
        var otherPageBannerDetailEnableOrNot;
        var otherPageBannerSingleImageLink;
        var other_page_banner_image_size;
        var otherPageBannerEnableOrNot;
        var otherPageBannerEnableRandomImages;
        var otherPageBannerStartDate;
        var otherPageBannerEndDate;
        var otherPageBannerTopOrNot;
        var otherPageBannerEnableRandomImagesDots;
        var otherPageBannerArrowColor;
        var otherPageBannerArrowBgColor;
        var otherPage = [];

        var cartPageBannerSelectImageResults = '';
        var cartPageBannerSelectTargetResults = '';
        var cartPageBannerSelectRelationResults = '';
        var cartPageBannerImageResults = '';
        var cartPageBannerLinkResults = '';
        var cartPageBannerEnableOrNotResults = '';
        var cartPageBannerEnableRandomImagesResults = '';
        var cartPageBannerStartDateResults = '';
        var cartPageBannerEndDateResults = '';
        var cartPageBannerTopOrNotResults = '';
        var cartPageBannerEnableRandomImagesDotsResults = '';
        var cartPageBannerSingleImageLinkResults = '';
        var cartPageBannerSingleImageResults = '';
        var cartPageBannerArrowColorResults = '';
        var cartPageBannerArrowBgColorResults = '';
        var cartPageBannerSelectImage;
        var cartPageBannerImage;
        var cartPageBannerSingleImage;
        var cartPageBannerLink;
        var cartPageBannerSingleImageLink;
        var cartPageBannerEnableOrNot;
        var cartPageBannerEnableRandomImages;
        var cartPageBannerStartDate;
        var cartPageBannerEndDate;
        var cartPageBannerTopOrNot;
        var cartPageBannerEnableRandomImagesDots;
        var cartPageBannerArrowColor;
        var cartPageBannerArrowBgColor;
        var cart = [];
        var cartUrl;
        
        var cartPageBannerSelectTarget;
        var cartPageBannerSelectRelation;
        var checkoutPageBannerImageResults = '';
        var checkoutPageBannerLinkResults = '';
        var checkoutPageBannerEnableOrNotResults = '';
        var checkoutPageBannerEnableRandomImagesResults = '';
        var checkoutPageBannerStartDateResults = '';
        var checkoutPageBannerEndDateResults = '';
        var checkoutPageBannerTopOrNotResults = '';
        var checkoutPageBannerEnableRandomImagesDotsResults = '';
        var checkoutPageBannerSelectImageResults = '';
        var checkoutPageBannerSingleImageLinkResults = '';
        var checkoutPageBannerSelectTargetResults = '';
        var checkoutPageBannerSelectRelationResults = '';
        var checkoutPageBannerSingleImageResults = '';
        var checkoutPageBannerArrowColorResults = '';
        var checkoutPageBannerArrowBgColorResults = '';
        var checkoutPageBannerSelectImage;
        var checkoutPageBannerSingleImage;
        var checkoutPageBannerSingleImageLink;
        var checkoutPageBannerSelectTarget;
        var checkoutPageBannerSelectRelation;
        var checkoutPageBannerImage;
        var checkoutPageBannerLink;
        var checkoutPageBannerEnableOrNot;
        var checkoutPageBannerEnableRandomImages;
        var checkoutPageBannerStartDate;
        var checkoutPageBannerEndDate;
        var checkoutPageBannerTopOrNot;
        var checkoutPageBannerEnableRandomImagesDots;
        var checkoutPageBannerArrowColor;
        var checkoutPageBannerArrowBgColor;
        var checkout = [];
        var chekoutUrl;

        var thankyouPageBannerImageResults = '';
        var thankyouPageBannerLinkResults = '';
        var thankyouPageBannerEnableOrNotResults = '';
        var thankyouPageBannerStartDateResults = '';
        var thankyouPageBannerEndDateResults = '';
        var thankyouPageBannerTopOrNotResults = '';
        var thankyouPageBannerEnableRandomImagesDotsResults = '';
        var thankyouPageBannerSelectImageResults = '';
        var thankyouPageBannerSingleImageLinkResults = '';
        var thankyouPageBannerSingleImageResult = '';
        var thankyouPageBannerSelectTargetResults = '';
        var thankyouPageBannerSelectRelationResults = '';
        var thankyouPageBannerArrowColorResults = '';
        var thankyouPageBannerArrowBgColorResults = '';
        var thankyouPageBannerSelectImage;
        var thankyouPageBannerSingleImage;
        var thankyouPageBannerSelectTarget;
        var thankyouPageBannerSelectRelation;
        var thankyouPageBannerSingleImageLink;
        var thankyouPageBannerImage;
        var thankyouPageBannerLink;
        var thankyouPageBannerEnableOrNot;
        var thankyouPageBannerEnableRandomImages;
        var thankyouPageBannerEnableRandomImagesResults;
        var thankyouPageBannerStartDate;
        var thankyouPageBannerEndDate;
        var thankyouPageBannerTopOrNot;
        var thankyouPageBannerEnableRandomImagesDots;
        var thankyouPageBannerArrowColor;
        var thankyouPageBannerArrowBgColor;
        var thankyou = [];

        var banner_detailPageBannerImageResults = '';
        var banner_detailPageBannerLinkResults = '';
        var banner_detailPageBannerEnableOrNotResults = '';
        var banner_detailPageSectionBannerEnableOrNotResults = '';
        var banner_detailPageBannerStartDateResults = '';
        var banner_detailPageBannerEndDateResults = '';
        var banner_detailPageBannerTopOrNotResults = '';
        var banner_detailPageBannerEnableRandomImagesDotsResults = '';
        var banner_detailPageBannerSelectImageResults = '';
        var banner_detailPageBannerTargetResults = '';
        var banner_detailPageBannerRelationResults = '';
        var banner_detailPageBannerSingleImageLinkResults = '';
        var banner_detailPageBannerSingleImageResult = '';
        var banner_detailPageBannerArrowColorResults = '';
        var banner_detailPageBannerArrowBgColorResults = '';
        var banner_detailPageBannerSelectImage;
        var banner_detailPageBannerSingleImage;
        var banner_detailPageBannerSingleImageLink;
        var banner_detailPageBannerTarget;
        var banner_detailPageBannerRelation;
        var banner_detailPageBannerImage;
        var banner_detailPageBannerLink;
        var banner_detailPageBannerEnableOrNot;
        var banner_detailPageSectionBannerEnableOrNot;
        var banner_detailPageBannerEnableRandomImages;
        var banner_detailPageBannerEnableRandomImagesResults;
        var banner_detailPageBannerStartDate;
        var banner_detailPageBannerEndDate;
        var banner_detailPageBannerTopOrNot;
        var banner_detailPageBannerEnableRandomImagesDots;
        var banner_detailPageBannerArrowColor;
        var banner_detailPageBannerArrowBgColor;
        var banner_detail = [];

        var ProductSliderOnSaleSettingsResults = '';
        var ProductSliderFeaturedProductResults = [];
        var ProductSliderProductCatResults = [];
        var ProductSliderPriceRangeResults = '';
        var ProductSliderOnSaleSettings;
        var ProductSliderFeaturedProductArr;
        var ProductSliderProductCatArr;
        var ProductSliderPriceRange;

        var ProductCatSliderProductCatResults = [];
        var ProductCatSliderByTitleSettingsResults = '';
        var ProductCatSliderFeatureImgSettingsResults = '';
        var ProductCatSliderByDescSettingsResults = '';
        var ProductCatSliderByCountSettingsResults = '';
        var ProductCatSliderProductCatArr;
        var ProductCatSliderByTitleSettings;
        var ProductCatSliderFeatureImgSettings;
        var ProductCatSliderByDescSettings;
        var ProductCatSliderByCountSettings;

        $('.banner-setting-loader').css('display', 'inline-block');

        

        //get the value by shop page setting section


        shopPageBannerSelectImage = $('.shop-select-image-type option:selected').val();
        if ('' !== shopPageBannerSelectImage) {
            shopPageBannerSelectImageResults = shopPageBannerSelectImage;
        }

        shopPageBannerSelectTarget = $('#wbm_shop_page_select_banner_target option:selected').val();
        if ('' !== shopPageBannerSelectTarget) {
            shopPageBannerSelectTargetResults = shopPageBannerSelectTarget;
        }

        shopPageBannerSelectRelation = $('#wbm_shop_page_select_banner_relation option:selected').val();
        if ('' !== shopPageBannerSelectRelation) {
            shopPageBannerSelectRelationResults = shopPageBannerSelectRelation;
        }

        shopPageBannerSingleImage = $('.wbm_shop_page_cat_banner_img_admin_single').attr('src');
        if ('' !== shopPageBannerSingleImage) {
            shopPageBannerSingleImageResult = shopPageBannerSingleImage;
        }

        shopPageBannerImage = $('.wbm_shop_page_cat_banner_img_admin').attr('src');
        if ('' !== shopPageBannerImage) {
            shopPageBannerImageResults = shopPageBannerImage;
        }

        shopPageBannerLink = $('#shop_page_banner_image_link').val();
        if ('' !== shopPageBannerLink) {
            shopPageBannerLinkResults = shopPageBannerLink;
        }

        shopPageBannerSingleImageLink = $('#shop_page_banner_single_image_link').val();
        if ('' !== shopPageBannerSingleImageLink) {
            shopPageBannerSingleImageLinkResults = shopPageBannerSingleImageLink;
        }

        shop_page_banner_image_size = $('#shop_page_banner_image_size').val();
        if ('' !== shop_page_banner_image_size) {
            shop_page_banner_image_sizeResult = shop_page_banner_image_size;
        }

        shopPageBannerEnableOrNot = $('input[id="wbm_shop_setting_enable"][type="checkbox"]:checked').val();
        if ('' !== shopPageBannerEnableOrNot) {
            shopPageBannerEnableOrNotResults = shopPageBannerEnableOrNot;
        }

        shopPageBannerEnableRandomImages = $('input[id="wbm_shop_setting_enable_random_images"][type="radio"]:checked').val();
        if ('' !== shopPageBannerEnableRandomImages) {
            shopPageBannerEnableRandomImagesResults = shopPageBannerEnableRandomImages;
        }

        shopPageBannerStartDate = $('#shop_start_date').val();
        if ('' !== shopPageBannerStartDate) {
            shopPageBannerStartDateResults = shopPageBannerStartDate;
        }

        shopPageBannerEndDate = $('#shop_end_date').val();
        if ('' !== shopPageBannerEndDate) {
            shopPageBannerEndDateResults = shopPageBannerEndDate;
        }

        shopPageBannerTopOrNot = $('input[id="wbm_set_top_setting_enable"][type="checkbox"]:checked').val();
        if ('' !== shopPageBannerTopOrNot) {
            shopPageBannerTopOrNotResults = shopPageBannerTopOrNot;
        }

        shopPageBannerEnableRandomImagesDots = $('input[id="wbm_shop_setting_enable_random_images_dots"][type="checkbox"]:checked').val();
        if ('' !== shopPageBannerEnableRandomImagesDots) {
            shopPageBannerEnableRandomImagesDotsResults = shopPageBannerEnableRandomImagesDots;
        }

        shopPageBannerArrowColor = $('#wbm_shop_slider_arrow_color_setting').val();
        if ('' !== shopPageBannerArrowColor) {
            shopPageBannerArrowColorResults = shopPageBannerArrowColor;
        }

        shopPageBannerArrowBgColor = $('#wbm_shop_slider_arrow_bg_color_setting').val();
        if ('' !== shopPageBannerArrowBgColor) {
            shopPageBannerArrowBgColorResults = shopPageBannerArrowBgColor;
        }

        $.each($('.banner_shop_dynamic_div'), function () {
            var divId;
            var arr;
            var imageId;
            var imageLink;
            var imageSrc;
            var item = {};

            divId = $(this).attr('id');
            arr = divId.split('_');
            imageId = arr[2];

            if ('' !== imageId && null !== imageId && imageId !== undefined) {

                //shop[imageId] = new Array();
                imageLink = $('.banner_shop_input_' + imageId).val();

                imageSrc = $('.banner_shop_image_' + imageId).attr('src');

                item.image_id = imageId;
                item.image_src = imageSrc;
                item.image_link = imageLink;
                shop.push(item);
            }
        });

        //var myJsonString = JSON.stringify(shop);

        if ('on' === shopPageBannerEnableOrNot) {
            $('span#shop_page_status_enable_or_disable').html('');
            $('span.Preview_link_for_shop_page').html('');
            shopPageUrl = $('#shop_page_hidden_url').val();
            $('<strong />', {'text': wbmAdminVars.preview + ': '}).appendTo('span.Preview_link_for_shop_page');
            $('<a />', {
                'href': shopPageUrl,
                'text': wbmAdminVars.click,
                'target': '_blank'
            }).appendTo('span.Preview_link_for_shop_page');
            $('span#shop_page_status_enable_or_disable').text('( Enable )');
            $('span#shop_page_status_enable_or_disable').css('color', 'green');
        } else {
            $('span.Preview_link_for_shop_page').html('');
            $('span#shop_page_status_enable_or_disable').html('');
            $('span#shop_page_status_enable_or_disable').html('( Disable )');
            $('span#shop_page_status_enable_or_disable').css('color', 'red');
        }

        //get the value by other page setting section
        otherPageBannerSelectImage = $('.other-page-select-image-type option:selected').val();
        if ('' !== otherPageBannerSelectImage) {
            otherPageBannerSelectImageResults = otherPageBannerSelectImage;
        }

        otherPageBannerSelectTarget = $('#wbm_other_page_select_banner_target option:selected').val();
        if ('' !== otherPageBannerSelectTarget) {
            otherPageBannerSelectTargetResults = otherPageBannerSelectTarget;
        }

        otherPageBannerSelectRelation = $('#wbm_other_page_select_banner_relation option:selected').val();
        if ('' !== otherPageBannerSelectRelation) {
            otherPageBannerSelectRelationResults = otherPageBannerSelectRelation;
        }

        otherPageBannerSingleImage = $('.wbm_other_page_cat_banner_img_admin_single').attr('src');
        if ('' !== otherPageBannerSingleImage) {
            otherPageBannerSingleImageResult = otherPageBannerSingleImage;
        }

        otherPageBannerImage = $('.wbm_other_page_cat_banner_img_admin').attr('src');
        if ('' !== otherPageBannerImage) {
            otherPageBannerImageResults = otherPageBannerImage;
        }

        otherPageBannerLink = $('#other_page_banner_image_link').val();
        if ('' !== otherPageBannerLink) {
            otherPageBannerLinkResults = otherPageBannerLink;
        }

        otherPageBannerSingleImageLink = $('#other_page_banner_single_image_link').val();
        if ('' !== otherPageBannerSingleImageLink) {
            otherPageBannerSingleImageLinkResults = otherPageBannerSingleImageLink;
        }

        other_page_banner_image_size = $('#other_page_banner_image_size').val();
        if ('' !== other_page_banner_image_size) {
            other_page_banner_image_sizeResult = other_page_banner_image_size;
        }

        otherPageBannerEnableOrNot = $('input[id="wbm_other_page_setting_enable"][type="checkbox"]:checked').val();
        if ('' !== otherPageBannerEnableOrNot) {
            otherPageBannerEnableOrNotResults = otherPageBannerEnableOrNot;
        }

        otherPageBannerDetailEnableOrNot = $('input[id="wbm_other_page_setting_banner_detail_enable"][type="checkbox"]:checked').val();
        if ('' !== otherPageBannerDetailEnableOrNot) {
            otherPageBannerDetailEnableOrNotResults = otherPageBannerDetailEnableOrNot;
        }

        otherPageBannerEnableRandomImages = $('input[id="wbm_other_setting_enable_random_images"][type="radio"]:checked').val();
        if ('' !== otherPageBannerEnableRandomImages) {
            otherPageBannerEnableRandomImagesResults = otherPageBannerEnableRandomImages;
        } else {
            otherPageBannerEnableRandomImagesResults = '';
        }

        otherPageBannerStartDate = $('#other_page_start_date').val();
        if ('' !== otherPageBannerStartDate) {
            otherPageBannerStartDateResults = otherPageBannerStartDate;
        }

        otherPageBannerEndDate = $('#other_page_end_date').val();
        if ('' !== otherPageBannerEndDate) {
            otherPageBannerEndDateResults = otherPageBannerEndDate;
        }

        otherPageBannerTopOrNot = $('input[id="wbm_other_page_set_top_setting_enable"][type="checkbox"]:checked').val();
        if ('' !== otherPageBannerTopOrNot) {
            otherPageBannerTopOrNotResults = otherPageBannerTopOrNot;
        }

        otherPageBannerEnableRandomImagesDots = $('input[id="wbm_other_setting_enable_random_images_dots"][type="checkbox"]:checked').val();
        if ('' !== otherPageBannerEnableRandomImagesDots) {
            otherPageBannerEnableRandomImagesDotsResults = otherPageBannerEnableRandomImagesDots;
        }

        otherPageBannerArrowColor = $('#wbm_other_page_slider_arrow_color').val();
        if ('' !== otherPageBannerArrowColor) {
            otherPageBannerArrowColorResults = otherPageBannerArrowColor;
        }

        otherPageBannerArrowBgColor = $('#wbm_other_page_slider_arrow_bg_color').val();
        if ('' !== otherPageBannerArrowBgColor) {
            otherPageBannerArrowBgColorResults = otherPageBannerArrowBgColor;
        }

        $.each($('.banner_other_dynamic_div'), function () {
            var divId;
            var arr;
            var imageId;
            var imageLink;
            var imageSrc;
            var item = {};

            divId = $(this).attr('id');
            arr = divId.split('_');
            imageId = arr[2];
            if ('' !== imageId && null !== imageId && imageId !== undefined) {

                imageLink = $('.banner_other_input_' + imageId).val();

                imageSrc = $('.banner_other_image_' + imageId).attr('src');

                item.image_id = imageId;
                item.image_src = imageSrc;
                item.image_link = imageLink;
                otherPage.push(item);
            }
        });

        //var myJsonString = JSON.stringify(shop);

        if ('on' === otherPageBannerEnableOrNot || 'on' === otherPageBannerDetailEnableOrNot) {
            $('span#other_page_status_enable_or_disable').html('');
            $('span#other_page_status_enable_or_disable').text('( Enable )');
            $('span#other_page_status_enable_or_disable').css('color', 'green');
        } else {
            $('span.Preview_link_for_other_page').html('');
            $('span#other_page_status_enable_or_disable').html('');
            $('span#other_page_status_enable_or_disable').html('( Disable )');
            $('span#other_page_status_enable_or_disable').css('color', 'red');
        }

        //get the value by cart setting section

        cartPageBannerSelectImage = $('.cart-select-image-type option:selected').val();
        if ('' !== cartPageBannerSelectImage) {
            cartPageBannerSelectImageResults = cartPageBannerSelectImage;
        }

        cartPageBannerSelectTarget = $('#wbm_cart_page_select_banner_target option:selected').val();
        if ('' !== cartPageBannerSelectTarget) {
            cartPageBannerSelectTargetResults = cartPageBannerSelectTarget;
        }
        cartPageBannerSelectRelation = $('#wbm_cart_page_select_banner_relation option:selected').val();
        if ('' !== cartPageBannerSelectRelation) {
            cartPageBannerSelectRelationResults = cartPageBannerSelectRelation;
        }

        
        cartPageBannerImage = $('.wbm_cart_page_cat_banner_img_admin').attr('src');
        if ('' !== cartPageBannerImage) {
            cartPageBannerImageResults = cartPageBannerImage;
        }

        cartPageBannerSingleImage = $('.wbm_cart_page_cat_banner_img_admin_single').attr('src');
        if ('' !== cartPageBannerSingleImage) {
            cartPageBannerSingleImageResults = cartPageBannerSingleImage;
        }

        cartPageBannerLink = $('#shop_cart_banner_image_link').val();
        if ('' !== cartPageBannerLink) {
            cartPageBannerLinkResults = cartPageBannerLink;
        }

        cartPageBannerSingleImageLink = $('#cart_page_banner_single_image_link').val();
        if ('' !== cartPageBannerSingleImageLink) {
            cartPageBannerSingleImageLinkResults = cartPageBannerSingleImageLink;
        }

        cartPageBannerEnableOrNot = $('input[id="wbm_shop_setting_cart_enable"][type="checkbox"]:checked').val();
        if ('' !== cartPageBannerEnableOrNot) {
            cartPageBannerEnableOrNotResults = cartPageBannerEnableOrNot;
        }

        cartPageBannerEnableRandomImages = $('input[id="wbm_cart_setting_enable_random_images"][type="radio"]:checked').val();
        if ('' !== cartPageBannerEnableRandomImages) {
            cartPageBannerEnableRandomImagesResults = cartPageBannerEnableRandomImages;
        }

        cartPageBannerStartDate = $('#cart_start_date').val();
        if ('' !== cartPageBannerStartDate) {
            cartPageBannerStartDateResults = cartPageBannerStartDate;
        }

        cartPageBannerEndDate = $('#cart_end_date').val();
        if ('' !== cartPageBannerEndDate) {
            cartPageBannerEndDateResults = cartPageBannerEndDate;
        }

        cartPageBannerTopOrNot = $('input[id="wbm_cart_setting_top_enable"][type="checkbox"]:checked').val();
        if ('' !== cartPageBannerTopOrNot) {
            cartPageBannerTopOrNotResults = cartPageBannerTopOrNot;
        }

        cartPageBannerEnableRandomImagesDots = $('input[id="wbm_cart_setting_enable_random_images_dots"][type="checkbox"]:checked').val();
        if ('' !== cartPageBannerEnableRandomImagesDots) {
            cartPageBannerEnableRandomImagesDotsResults = cartPageBannerEnableRandomImagesDots;
        }

        cartPageBannerArrowColor = $('#wbm_cart_slider_arrow_color_setting').val();
        if ('' !== cartPageBannerArrowColor) {
            cartPageBannerArrowColorResults = cartPageBannerArrowColor;
        }

        cartPageBannerArrowBgColor = $('#wbm_cart_slider_arrow_bg_color_setting').val();
        if ('' !== cartPageBannerArrowBgColor) {
            cartPageBannerArrowBgColorResults = cartPageBannerArrowBgColor;
        }

        $.each($('.banner_cart_dynamic_div'), function () {
            var divId;
            var item = {};
            var arr;
            var imageId;
            var imageLink;
            var imageSrc;

            divId = $(this).attr('id');
            arr = divId.split('_');
            imageId = arr[2];
            if ('' !== imageId && null !== imageId && imageId !== undefined) {

                imageLink = $('.banner_cart_input_' + imageId).val();

                imageSrc = $('.banner_cart_image_' + imageId).attr('src');

                item.image_id = imageId;
                item.image_src = imageSrc;
                item.image_link = imageLink;
                cart.push(item);
            }
        });

        if ('on' === cartPageBannerEnableOrNot) {

            $('span.Preview_link_for_cart_page').text('');
            cartUrl = $('#cart_page_hidden_url').val();
            $('<strong />', {'text': wbmAdminVars.preview + ': '}).appendTo('span.Preview_link_for_cart_page');
            $('<a />', {
                'href': cartUrl,
                'text': wbmAdminVars.click,
                'target': '_blank'
            }).appendTo('span.Preview_link_for_cart_page');
            $('span#cart_page_status_enable_or_disable').text('');
            $('span#cart_page_status_enable_or_disable').text('( Enable )');
            $('span#cart_page_status_enable_or_disable').css('color', 'green');
        } else {
            $('span#cart_page_status_enable_or_disable').text('');
            $('span.Preview_link_for_cart_page').text('');
            $('span#cart_page_status_enable_or_disable').text('( Disable )');
            $('span#cart_page_status_enable_or_disable').css('color', 'red');
        }

        //get the value by cart setting section

        checkoutPageBannerSelectImage = $('.checkout-select-image-type option:selected').val();
        if ('' !== checkoutPageBannerSelectImage) {
            checkoutPageBannerSelectImageResults = checkoutPageBannerSelectImage;
        }

        checkoutPageBannerSingleImage = $('.wbm_checkout_page_cat_banner_img_admin_single').attr('src');
        if ('' !== checkoutPageBannerSingleImage) {
            checkoutPageBannerSingleImageResults = checkoutPageBannerSingleImage;
        }

        checkoutPageBannerSingleImageLink = $('#checkout_page_banner_single_image_link').val();
        if ('' !== checkoutPageBannerSingleImageLink) {
            checkoutPageBannerSingleImageLinkResults = checkoutPageBannerSingleImageLink;
        }

        checkoutPageBannerSelectTarget = $('#wbm_checkout_page_select_banner_target option:selected').val();
        if ('' !== checkoutPageBannerSelectTarget) {
            checkoutPageBannerSelectTargetResults = checkoutPageBannerSelectTarget;
        }
        checkoutPageBannerSelectRelation = $('#wbm_checkout_page_select_banner_relation option:selected').val();
        if ('' !== checkoutPageBannerSelectRelation) {
            checkoutPageBannerSelectRelationResults = checkoutPageBannerSelectRelation;
        }

        checkoutPageBannerImage = $('.wbm_checkout_page_cat_banner_img_admin').attr('src');
        if ('' !== checkoutPageBannerImage) {
            checkoutPageBannerImageResults = checkoutPageBannerImage;
        }

        checkoutPageBannerLink = $('#shop_checkout_banner_image_link').val();
        if ('' !== checkoutPageBannerLink) {
            checkoutPageBannerLinkResults = checkoutPageBannerLink;
        }

        checkoutPageBannerEnableOrNot = $('input[id="wbm_shop_setting_checkout_enable"][type="checkbox"]:checked').val();
        if ('' !== checkoutPageBannerEnableOrNot) {
            checkoutPageBannerEnableOrNotResults = checkoutPageBannerEnableOrNot;
        }

        checkoutPageBannerEnableRandomImages = $('input[id="wbm_checkout_setting_enable_random_images"][type="radio"]:checked').val();
        if ('' !== checkoutPageBannerEnableRandomImages) {
            checkoutPageBannerEnableRandomImagesResults = checkoutPageBannerEnableRandomImages;
        }

        checkoutPageBannerStartDate = $('#checkout_start_date').val();
        if ('' !== checkoutPageBannerStartDate) {
            checkoutPageBannerStartDateResults = checkoutPageBannerStartDate;
        }

        checkoutPageBannerEndDate = $('#checkout_end_date').val();
        if ('' !== checkoutPageBannerEndDate) {
            checkoutPageBannerEndDateResults = checkoutPageBannerEndDate;
        }

        checkoutPageBannerTopOrNot = $('input[id="wbm_checkout_setting_top_enable"][type="checkbox"]:checked').val();
        if ('' !== checkoutPageBannerTopOrNot) {
            checkoutPageBannerTopOrNotResults = checkoutPageBannerTopOrNot;
        }

        checkoutPageBannerEnableRandomImagesDots = $('input[id="wbm_checkout_setting_enable_random_images_dots"][type="checkbox"]:checked').val();
        if ('' !== checkoutPageBannerEnableRandomImagesDots) {
            checkoutPageBannerEnableRandomImagesDotsResults = checkoutPageBannerEnableRandomImagesDots;
        }

        checkoutPageBannerArrowColor = $('#wbm_checkout_slider_arrow_color_setting').val();
        if ('' !== checkoutPageBannerArrowColor) {
            checkoutPageBannerArrowColorResults = checkoutPageBannerArrowColor;
        }

        checkoutPageBannerArrowBgColor = $('#wbm_checkout_slider_arrow_bg_color_setting').val();
        if ('' !== checkoutPageBannerArrowBgColor) {
            checkoutPageBannerArrowBgColorResults = checkoutPageBannerArrowBgColor;
        }

        $.each($('.banner_checkout_dynamic_div'), function () {
            var divId;
            var arr;
            var imageId;
            var imageLink;
            var imageSrc;
            var item = {};

            divId = $(this).attr('id');
            arr = divId.split('_');
            imageId = arr[2];

            if ('' !== imageId && null !== imageId && imageId !== undefined) {

                imageLink = $('.banner_checkout_input_' + imageId).val();

                imageSrc = $('.banner_checkout_image_' + imageId).attr('src');

                item.image_id = imageId;
                item.image_src = imageSrc;
                item.image_link = imageLink;
                checkout.push(item);
            }
        });

        if ('on' === checkoutPageBannerEnableOrNot) {

            $('span.Preview_link_for_checkout_page').text('');
            chekoutUrl = $('#checkout_page_hidden_url').val();
            $('<strong />', {'text': wbmAdminVars.preview + ': '}).appendTo('span.Preview_link_for_checkout_page');
            $('<a />', {
                'href': chekoutUrl,
                'text': wbmAdminVars.click,
                'target': '_blank'
            }).appendTo('span.Preview_link_for_checkout_page');
            $('span#checkout_page_status_enable_or_disable').text('( Enable )');
            $('span#checkout_page_status_enable_or_disable').css('color', 'green');
        } else {
            $('span#checkout_page_status_enable_or_disable').text('');

            $('span.Preview_link_for_checkout_page').text('');
            $('span#checkout_page_status_enable_or_disable').text('( Disable )');
            $('span#checkout_page_status_enable_or_disable').css('color', 'red');
        }

        //get the value by cart setting section

        thankyouPageBannerSelectImage = $('.thankyou-select-image-type option:selected').val();
        if ('' !== thankyouPageBannerSelectImage) {
            thankyouPageBannerSelectImageResults = thankyouPageBannerSelectImage;
        }

        thankyouPageBannerSingleImage = $('.wbm_thankyou_page_cat_banner_img_admin_single').attr('src');
        if ('' !== thankyouPageBannerSingleImage) {
            thankyouPageBannerSingleImageResult = thankyouPageBannerSingleImage;
        }

        thankyouPageBannerSelectTarget = $('#wbm_thankyou_page_select_banner_target option:selected').val();
        if ('' !== thankyouPageBannerSelectTarget) {
            thankyouPageBannerSelectTargetResults = thankyouPageBannerSelectTarget;
        }
        thankyouPageBannerSelectRelation = $('#wbm_thankyou_page_select_banner_relation option:selected').val();
        if ('' !== thankyouPageBannerSelectRelation) {
            thankyouPageBannerSelectRelationResults = thankyouPageBannerSelectRelation;
        }

        thankyouPageBannerSingleImageLink = $('#thankyou_page_banner_single_image_link').val();
        if ('' !== thankyouPageBannerSingleImageLink) {
            thankyouPageBannerSingleImageLinkResults = thankyouPageBannerSingleImageLink;
        }

        thankyouPageBannerImage = $('.wbm_thankyou_page_cat_banner_img_admin').attr('src');
        if ('' !== thankyouPageBannerImage) {
            thankyouPageBannerImageResults = thankyouPageBannerImage;
        }

        thankyouPageBannerLink = $('#shop_thank_you_page_banner_image_link').val();
        if ('' !== thankyouPageBannerLink) {
            thankyouPageBannerLinkResults = thankyouPageBannerLink;
        }

        thankyouPageBannerEnableOrNot = $('input[id="wbm_shop_setting_thank_you_page_enable"][type="checkbox"]:checked').val();
        if ('' !== thankyouPageBannerEnableOrNot) {
            thankyouPageBannerEnableOrNotResults = thankyouPageBannerEnableOrNot;
        }

        thankyouPageBannerEnableRandomImages = $('input[id="wbm_thankyou_setting_enable_random_images"][type="radio"]:checked').val();
        if ('' !== thankyouPageBannerEnableRandomImages) {
            thankyouPageBannerEnableRandomImagesResults = thankyouPageBannerEnableRandomImages;
        } else {
            thankyouPageBannerEnableRandomImagesResults = '';
        }

        thankyouPageBannerStartDate = $('#thankyou_start_date').val();
        if ('' !== thankyouPageBannerStartDate) {
            thankyouPageBannerStartDateResults = thankyouPageBannerStartDate;
        }

        thankyouPageBannerEndDate = $('#thankyou_end_date').val();
        if ('' !== thankyouPageBannerEndDate) {
            thankyouPageBannerEndDateResults = thankyouPageBannerEndDate;
        }

        thankyouPageBannerTopOrNot = $('input[id="wbm_thankyou_setting_top_enable"][type="checkbox"]:checked').val();
        if ('' !== thankyouPageBannerTopOrNot) {
            thankyouPageBannerTopOrNotResults = thankyouPageBannerTopOrNot;
        }

        thankyouPageBannerEnableRandomImagesDots = $('input[id="wbm_thankyou_setting_enable_random_images_dots"][type="checkbox"]:checked').val();
        if ('' !== thankyouPageBannerEnableRandomImagesDots) {
            thankyouPageBannerEnableRandomImagesDotsResults = thankyouPageBannerEnableRandomImagesDots;
        }

        thankyouPageBannerArrowColor = $('#wbm_thankyou_slider_arrow_color_setting').val();
        if ('' !== thankyouPageBannerArrowColor) {
            thankyouPageBannerArrowColorResults = thankyouPageBannerArrowColor;
        }

        thankyouPageBannerArrowBgColor = $('#wbm_thankyou_slider_arrow_bg_color_setting').val();
        if ('' !== thankyouPageBannerArrowBgColor) {
            thankyouPageBannerArrowBgColorResults = thankyouPageBannerArrowBgColor;
        }

        $.each($('.banner_thankyou_dynamic_div'), function () {
            var divId;
            var arr;
            var imageId;
            var imageLink;
            var imageSrc;
            var item = {};

            divId = $(this).attr('id');
            arr = divId.split('_');
            imageId = arr[2];

            if ('' !== imageId && null !== imageId && imageId !== undefined) {

                imageLink = $('.banner_thankyou_input_' + imageId).val();

                imageSrc = $('.banner_thankyou_image_' + imageId).attr('src');

                item.image_id = imageId;
                item.image_src = imageSrc;
                item.image_link = imageLink;
                thankyou.push(item);
            }
        });
        if ('on' === thankyouPageBannerEnableOrNot) {
            $('span#thankyou_page_status_enable_or_disable').html('');
            $('span#thankyou_page_status_enable_or_disable').html('( Enable )');
            $('span#thankyou_page_status_enable_or_disable').css('color', 'green');
        } else {
            $('span#thankyou_page_status_enable_or_disable').html('');
            $('span#thankyou_page_status_enable_or_disable').html('( Disable )');
            $('span#thankyou_page_status_enable_or_disable').css('color', 'red');
        }
        //get the value by cart setting section banner detail

        banner_detailPageBannerSelectImage = $('.banner_detail-select-image-type option:selected').val();
        if ('' !== banner_detailPageBannerSelectImage) {
            banner_detailPageBannerSelectImageResults = banner_detailPageBannerSelectImage;
        }

        banner_detailPageBannerTarget = $('#wbm_banner_global_page_select_banner_target option:selected').val();
        if ('' !== banner_detailPageBannerTarget) {
            banner_detailPageBannerTargetResults = banner_detailPageBannerTarget;
        }

        banner_detailPageBannerRelation = $('#wbm_banner_global_page_select_banner_relation option:selected').val();
        if ('' !== banner_detailPageBannerRelation) {
            banner_detailPageBannerRelationResults = banner_detailPageBannerRelation;
        }

        banner_detailPageBannerSingleImage = $('.wbm_banner_detail_page_cat_banner_img_admin_single').attr('src');
        if ('' !== banner_detailPageBannerSingleImage) {
            banner_detailPageBannerSingleImageResult = banner_detailPageBannerSingleImage;
        }

        banner_detailPageBannerSingleImageLink = $('#banner_detail_page_banner_single_image_link').val();
        if ('' !== banner_detailPageBannerSingleImageLink) {
            banner_detailPageBannerSingleImageLinkResults = banner_detailPageBannerSingleImageLink;
        }

        banner_detailPageBannerImage = $('.wbm_banner_detail_page_cat_banner_img_admin').attr('src');
        if ('' !== banner_detailPageBannerImage) {
            banner_detailPageBannerImageResults = banner_detailPageBannerImage;
        }

        banner_detailPageBannerLink = $('#shop_thank_you_page_banner_image_link').val();
        if ('' !== banner_detailPageBannerLink) {
            banner_detailPageBannerLinkResults = banner_detailPageBannerLink;
        }

        banner_detailPageBannerEnableOrNot = $('input[id="wbm_shop_setting_banner_detail_page_enable"][type="checkbox"]:checked').val();
        if ('' !== banner_detailPageBannerEnableOrNot) {
            banner_detailPageBannerEnableOrNotResults = banner_detailPageBannerEnableOrNot;
        }
        banner_detailPageSectionBannerEnableOrNot = $('input[id="wbm_shop_setting_banner_detail_page_section_enable"][type="checkbox"]:checked').val();
        if ('' !== banner_detailPageSectionBannerEnableOrNot) {
            banner_detailPageSectionBannerEnableOrNotResults = banner_detailPageSectionBannerEnableOrNot;
        }

        banner_detailPageBannerEnableRandomImages = $('input[id="wbm_banner_detail_setting_enable_random_images"][type="radio"]:checked').val();
        if ('' !== banner_detailPageBannerEnableRandomImages) {
            banner_detailPageBannerEnableRandomImagesResults = banner_detailPageBannerEnableRandomImages;
        } else {
            banner_detailPageBannerEnableRandomImagesResults = '';
        }

        banner_detailPageBannerStartDate = $('#banner_detail_start_date').val();
        if ('' !== banner_detailPageBannerStartDate) {
            banner_detailPageBannerStartDateResults = banner_detailPageBannerStartDate;
        }

        banner_detailPageBannerEndDate = $('#banner_detail_end_date').val();
        if ('' !== banner_detailPageBannerEndDate) {
            banner_detailPageBannerEndDateResults = banner_detailPageBannerEndDate;
        }

        banner_detailPageBannerTopOrNot = $('input[id="wbm_banner_detail_setting_top_enable"][type="checkbox"]:checked').val();
        if ('' !== banner_detailPageBannerTopOrNot) {
            banner_detailPageBannerTopOrNotResults = banner_detailPageBannerTopOrNot;
        }

        banner_detailPageBannerEnableRandomImagesDots = $('input[id="wbm_banner_detail_setting_enable_random_images_dots"][type="checkbox"]:checked').val();
        if ('' !== banner_detailPageBannerEnableRandomImagesDots) {
            banner_detailPageBannerEnableRandomImagesDotsResults = banner_detailPageBannerEnableRandomImagesDots;
        }

        banner_detailPageBannerArrowColor = $('#wbm_banner_detail_arrow_color_setting').val();
        if ('' !== banner_detailPageBannerArrowColor) {
            banner_detailPageBannerArrowColorResults = banner_detailPageBannerArrowColor;
        }
        
        banner_detailPageBannerArrowBgColor = $('#wbm_banner_detail_arrow_bg_color_setting').val();
        if ('' !== banner_detailPageBannerArrowBgColor) {
            banner_detailPageBannerArrowBgColorResults = banner_detailPageBannerArrowBgColor;
        }

        $.each($('.banner_banner_detail_dynamic_div'), function () {
            var divId;
            var arr;
            var imageId;
            var imageLink;
            var imageSrc;
            var item = {};

            divId = $(this).attr('id');
            arr = divId.split('_');
            imageId = arr[3];
            if ('' !== imageId && null !== imageId && imageId !== undefined) {

                imageLink = $('.banner_banner_detail_input_' + imageId).val();

                imageSrc = $('.banner_banner_detail_image_' + imageId).attr('src');

                item.image_id = imageId;
                item.image_src = imageSrc;
                item.image_link = imageLink;
                banner_detail.push(item);
            }
        });

        if ('on' === banner_detailPageBannerEnableOrNot || 'on' === banner_detailPageSectionBannerEnableOrNot) {
            $('span.banner_detail_page_status_enable_or_disable').html('');
            $('span.banner_detail_page_status_enable_or_disable').html('( Enable )');
            $('span.banner_detail_page_status_enable_or_disable').css('color', 'green');
        } else {
            $('span.banner_detail_page_status_enable_or_disable').html('');
            $('span.banner_detail_page_status_enable_or_disable').html('( Disable )');
            $('span.banner_detail_page_status_enable_or_disable').css('color', 'red');
        }

        // get the value of product slider settings
        ProductSliderOnSaleSettings = $('input[id="wbm_prod_slider_setting_on_sale"][type="checkbox"]:checked').val();
        if ('' !== ProductSliderOnSaleSettings) {
            ProductSliderOnSaleSettingsResults = ProductSliderOnSaleSettings;
        }

        ProductSliderFeaturedProductArr = $('#featured-product').val();
        if ('' !== ProductSliderFeaturedProductArr) {
            ProductSliderFeaturedProductResults = ProductSliderFeaturedProductArr;
        }

        ProductSliderProductCatArr = $('#product-categories').val();
        if ('' !== ProductSliderProductCatArr) {
            ProductSliderProductCatResults = ProductSliderProductCatArr;
        }

        ProductSliderPriceRange = $('#wbm_max_price').val();
        if ('' !== ProductSliderPriceRange) {
            ProductSliderPriceRangeResults = ProductSliderPriceRange;
        }

        // get the value of categories slider settings
        ProductCatSliderProductCatArr = $('#categories-slider').val();
        if ('' !== ProductCatSliderProductCatArr) {
            ProductCatSliderProductCatResults = ProductCatSliderProductCatArr;
        }
        ProductCatSliderByTitleSettings = $('input[id="wbm_cat_slider_setting_by_title"][type="checkbox"]:checked').val();
        if ('' !== ProductCatSliderByTitleSettings) {
            ProductCatSliderByTitleSettingsResults = ProductCatSliderByTitleSettings;
        }

        ProductCatSliderFeatureImgSettings = $('input[id="wbm_cat_slider_setting_feature_img"][type="checkbox"]:checked').val();
        if ('' !== ProductCatSliderFeatureImgSettings) {
            ProductCatSliderFeatureImgSettingsResults = ProductCatSliderFeatureImgSettings;
        }
        
        ProductCatSliderByDescSettings = $('input[id="wbm_cat_slider_setting_by_desc"][type="checkbox"]:checked').val();
        if ('' !== ProductCatSliderByDescSettings) {
            ProductCatSliderByDescSettingsResults = ProductCatSliderByDescSettings;
        }
        ProductCatSliderByCountSettings = $('input[id="wbm_cat_slider_setting_by_count"][type="checkbox"]:checked').val();
        if ('' !== ProductCatSliderByCountSettings) {
            ProductCatSliderByCountSettingsResults = ProductCatSliderByCountSettings;
        }

        /**AJAX Call start */

        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: ({
                'action': 'wbm_save_shop_page_banner_data',
                'security': wbmConditionalVars.wbm_nonce,
                'shop_page_banner_image_results_arr': shop,
                'shop_page_banner_select_image_results': shopPageBannerSelectImageResults,
                'shop_page_banner_select_target_results': shopPageBannerSelectTargetResults,
                'shop_page_banner_select_relation_results': shopPageBannerSelectRelationResults,
                'shop_page_banner_image_results': shopPageBannerSingleImageResult,
                'shop_page_banner_link_results': shopPageBannerSingleImageLinkResults,
                'shop_page_banner_image_size': shop_page_banner_image_sizeResult,
                'shop_page_banner_enable_or_not_results': shopPageBannerEnableOrNotResults,
                'shop_page_banner_enable_random_images_results': shopPageBannerEnableRandomImagesResults,
                'shop_page_banner_start_date_results': shopPageBannerStartDateResults,
                'shop_page_banner_end_date_results': shopPageBannerEndDateResults,
                'shop_page_banner_top_or_not_results': shopPageBannerTopOrNotResults,
                'shop_page_banner_enable_random_images_dots_results': shopPageBannerEnableRandomImagesDotsResults,
                'shop_page_banner_arrow_color_results': shopPageBannerArrowColorResults,
                'shop_page_banner_arrow_bg_color_results': shopPageBannerArrowBgColorResults,
                'other_page_banner_image_results_arr': otherPage,
                'other_page_banner_select_image_results': otherPageBannerSelectImageResults,
                'other_page_banner_select_target_results': otherPageBannerSelectTargetResults,
                'other_page_banner_select_relation_results': otherPageBannerSelectRelationResults,
                'other_page_banner_image_results': otherPageBannerSingleImageResult,
                'other_page_banner_link_results': otherPageBannerSingleImageLinkResults,
                'other_page_banner_image_size': other_page_banner_image_sizeResult,
                'other_page_banner_enable_or_not_results': otherPageBannerEnableOrNotResults,
                'other_page_banner_enable_random_images_results': otherPageBannerEnableRandomImagesResults,
                'other_page_banner_start_date_results': otherPageBannerStartDateResults,
                'other_page_banner_end_date_results': otherPageBannerEndDateResults,
                'other_page_banner_top_or_not_results': otherPageBannerTopOrNotResults,
                'other_page_banner_enable_random_images_dots_results': otherPageBannerEnableRandomImagesDotsResults,
                'banner_other_detail_page_banner_enable_or_not_results': otherPageBannerDetailEnableOrNotResults,
                'other_page_banner_arrow_color_results': otherPageBannerArrowColorResults,
                'other_page_banner_arrow_bg_color_results': otherPageBannerArrowBgColorResults,
                'cart_page_banner_image_results_arr': cart,
                'cart_page_banner_select_image_results': cartPageBannerSelectImageResults,
                'cart_page_banner_select_target_results': cartPageBannerSelectTargetResults,
                'cart_page_banner_select_relation_results': cartPageBannerSelectRelationResults,
                'cart_page_banner_image_results': cartPageBannerSingleImageResults,
                'cart_page_banner_link_results': cartPageBannerSingleImageLinkResults,
                'cart_page_banner_enable_or_not_results': cartPageBannerEnableOrNotResults,
                'cart_page_banner_enable_random_images_results': cartPageBannerEnableRandomImagesResults,
                'cart_page_banner_start_date_results': cartPageBannerStartDateResults,
                'cart_page_banner_end_date_results': cartPageBannerEndDateResults,
                'cart_page_banner_top_or_not_results': cartPageBannerTopOrNotResults,
                'cart_page_banner_enable_random_images_dots_results': cartPageBannerEnableRandomImagesDotsResults,
                'cart_page_banner_arrow_color_results': cartPageBannerArrowColorResults,
                'cart_page_banner_arrow_bg_color_results': cartPageBannerArrowBgColorResults,
                'checkout_page_banner_image_results_arr': checkout,
                'checkout_page_banner_select_image_results': checkoutPageBannerSelectImageResults,
                'checkout_page_banner_image_results': checkoutPageBannerSingleImageResults,
                'checkout_page_banner_link_results': checkoutPageBannerSingleImageLinkResults,
                'checkout_page_banner_target_results': checkoutPageBannerSelectTargetResults,
                'checkout_page_banner_relation_results': checkoutPageBannerSelectRelationResults,
                'checkout_page_banner_enable_or_not_results': checkoutPageBannerEnableOrNotResults,
                'checkout_page_banner_enable_random_images_results': checkoutPageBannerEnableRandomImagesResults,
                'checkout_page_banner_start_date_results': checkoutPageBannerStartDateResults,
                'checkout_page_banner_end_date_results': checkoutPageBannerEndDateResults,
                'checkout_page_banner_top_or_not_results': checkoutPageBannerTopOrNotResults,
                'checkout_page_banner_enable_random_images_dots_results': checkoutPageBannerEnableRandomImagesDotsResults,
                'checkout_page_banner_arrow_color_results': checkoutPageBannerArrowColorResults,
                'checkout_page_banner_arrow_bg_color_results': checkoutPageBannerArrowBgColorResults,
                'thankyou_page_banner_image_results_arr': thankyou,
                'thankyou_page_banner_select_image_results': thankyouPageBannerSelectImageResults,
                'thankyou_page_banner_image_results': thankyouPageBannerSingleImageResult,
                'thankyou_page_banner_target_results': thankyouPageBannerSelectTargetResults,
                'thankyou_page_banner_relation_results': thankyouPageBannerSelectRelationResults,
                'thankyou_page_banner_link_results': thankyouPageBannerSingleImageLinkResults,
                'thankyou_page_banner_enable_or_not_results': thankyouPageBannerEnableOrNotResults,
                'thankyou_page_banner_enable_random_images_results': thankyouPageBannerEnableRandomImagesResults,
                'thankyou_page_banner_start_date_results': thankyouPageBannerStartDateResults,
                'thankyou_page_banner_end_date_results': thankyouPageBannerEndDateResults,
                'thankyou_page_banner_top_or_not_results': thankyouPageBannerTopOrNotResults,
                'thankyou_page_banner_enable_random_images_dots_results': thankyouPageBannerEnableRandomImagesDotsResults,
                'thankyou_page_banner_arrow_color_results': thankyouPageBannerArrowColorResults,
                'thankyou_page_banner_arrow_bg_color_results': thankyouPageBannerArrowBgColorResults,
                'banner_detail_page_banner_image_results_arr': banner_detail,
                'banner_detail_page_banner_select_image_results': banner_detailPageBannerSelectImageResults,
                'banner_detail_page_banner_target_results': banner_detailPageBannerTargetResults,
                'banner_detail_page_banner_relation_results': banner_detailPageBannerRelationResults,
                'banner_detail_page_banner_image_results': banner_detailPageBannerSingleImageResult,
                'banner_detail_page_banner_link_results': banner_detailPageBannerSingleImageLinkResults,
                'banner_detail_page_banner_enable_or_not_results': banner_detailPageBannerEnableOrNotResults,
                'banner_detail_page_section_banner_enable_or_not_results': banner_detailPageSectionBannerEnableOrNotResults,
                'banner_detail_page_banner_enable_random_images_results': banner_detailPageBannerEnableRandomImagesResults,
                'banner_detail_page_banner_start_date_results': banner_detailPageBannerStartDateResults,
                'banner_detail_page_banner_end_date_results': banner_detailPageBannerEndDateResults,
                'banner_detail_page_banner_top_or_not_results': banner_detailPageBannerTopOrNotResults,
                'banner_detail_page_banner_enable_random_images_dots_results': banner_detailPageBannerEnableRandomImagesDotsResults,
                'banner_detail_page_banner_arrow_color_results': banner_detailPageBannerArrowColorResults,
                'banner_detail_page_banner_arrow_bg_color_results': banner_detailPageBannerArrowBgColorResults,
                'product_slider_settings_on_sale_results': ProductSliderOnSaleSettingsResults,
                'product_slider_settings_featured_prod_results': ProductSliderFeaturedProductResults,
                'product_slider_settings_prod_cat_results': ProductSliderProductCatResults,
                'product_slider_price_range_results': ProductSliderPriceRangeResults,
                'product_cat_slider_settings_cat_results': ProductCatSliderProductCatResults,
                'product_cat_slider_settings_by_title_results': ProductCatSliderByTitleSettingsResults,
                'product_cat_slider_settings_feature_img_results': ProductCatSliderFeatureImgSettingsResults,
                'product_cat_slider_settings_by_desc_results': ProductCatSliderByDescSettingsResults,
                'product_cat_slider_settings_by_count_results': ProductCatSliderByCountSettingsResults,
            }),
            success: function () {
                $('.banner-setting-loader').css('display', 'none');
                $('#succesful_message_wbm').css('display', 'block');
            }
        });
    }

    var initCategorySlider;
    var initProductSlider;
    var windowWidth = $(window).width();
    var sliderNextText = $('<i></i>').addClass('fa fa-angle-right');
    var sliderPrevText = $('<i></i>').addClass('fa fa-angle-left');
    $(document).ready(function () {
        // slider settings color picker
        $('.wbm_sliders_colorpick').wpColorPicker({
            change: function(){
                $('.dotstore-plugins_page_wcbm-sliders-settings').trigger('change');
            }
        });
        
        $('.wbm_slider_live_preview').hide();

        $(document).on('click', '#wbm-category-slider-preview-btn:contains(Hide)', function (e) {
            e.preventDefault();
            $('.wbm_slider_live_preview').hide();
            $('#wbm-category-slider-preview-btn').text(wbmConditionalVars.show_preview);
            $('.wbm_slider_live_preview .wbm-category-slider-section').html('');
        });

        $(document).on('click', '#wbm-category-slider-preview-btn:not(:contains(Hide))', function (e) {
            e.preventDefault();
            showCategorySliderPreview();
        });

        $(document).on('click', '#wbm-product-slider-preview-btn:contains(Hide)', function (e) {
            e.preventDefault();
            $('.wbm_slider_live_preview').hide();
            $('#wbm-product-slider-preview-btn').text(wbmConditionalVars.show_preview);
            $('.wbm_slider_live_preview .wbm-product-slider-section').html('');
        });

        $(document).on('click', '.display-settings-tbl .wbm--image-area img,.forminp .wbm--sibling.wbm--image .wbm--image-area, .dswbm--sibling.dswbm--image', function (e) {
            e.preventDefault();
            $('#wbm-category-slider-preview-btn').text(wbmConditionalVars.update_preview);
        });

        $(document).on('click', '#wbm-product-slider-preview-btn:not(:contains(Hide))', function (e) {
            e.preventDefault();
            showProductSliderPreview();
        });
    });

    function isJson(str) {
        try {
            JSON.parse(str);
        } catch (err) {
            return false;
        }
        return true;
    }

    function showCategorySliderPreview() {
        $('.wbm_slider_live_preview').fadeIn();
        $('#wbm-category-slider-preview-btn').text(wbmConditionalVars.hide_preview);

        let dswbm_cat_slider_status;
        if ($('#dswbm_cat_slider_status').prop('checked') === true) {
            dswbm_cat_slider_status = 'on';
        } else {
            dswbm_cat_slider_status = 'off';
        }

        let wbm_filter_categories = $('#wbm_filter_categories').val();

        let wbm_choose_categories_arr = [];
        let wbm_choose_categories;
        wbm_choose_categories = $('#wbm_choose_categories').val();
        if ('' !== wbm_choose_categories) {
            wbm_choose_categories_arr = wbm_choose_categories;
        }

        let wbm_choose_categories_pnc_cat_arr = [];
        let wbm_choose_categories_pnc_cat;
        wbm_choose_categories_pnc_cat = $('#wbm_choose_categories_parent_nd_child').val();
        if ('' !== wbm_choose_categories_pnc_cat) {
            wbm_choose_categories_pnc_cat_arr = wbm_choose_categories_pnc_cat;
        }

        let wbm_exclude_categories_arr = [];
        let wbm_exclude_categories;
        wbm_exclude_categories = $('#wbm_exclude_categories').val();
        if ('' !== wbm_exclude_categories) {
            wbm_exclude_categories_arr = wbm_exclude_categories;
        }

        let wbm_total_cat_show = $('#wbm_total_cat_show').val();
        let wbm_cat_no_large_desktop = $('[name="wbm_category_slider_general[wbm_cat_no_of_cols][large_desktop]"]').val();
        let wbm_cat_no_desktop = $('[name="wbm_category_slider_general[wbm_cat_no_of_cols][desktop]"]').val();
        let wbm_cat_no_laptop = $('[name="wbm_category_slider_general[wbm_cat_no_of_cols][laptop]"]').val();
        let wbm_cat_no_tablet = $('[name="wbm_category_slider_general[wbm_cat_no_of_cols][tablet]"]').val();
        let wbm_cat_no_mobile = $('[name="wbm_category_slider_general[wbm_cat_no_of_cols][mobile]"]').val();
        let wbm_cat_order_by = $('#wbm_cat_order_by').val();
        let wbm_cat_order = $('#wbm_cat_order').val();

        let wbm_cat_sec_title_status;
        if ($('#wbm_cat_title').prop('checked') === true) {
            wbm_cat_sec_title_status = 'on';
        } else {
            wbm_cat_sec_title_status = 'off';
        }

        let wbm_cat_slider_rule_name = $('[name="dswbm_cat_slider_rule_name"]').val();
        let wbm_cat_title_color = $('#wbm_cat_title_color').val();
        let wbm_cat_title_top_margin = $('[name="wbm_category_slider_display[wbm_cat_title_margin][top]"]').val();
        let wbm_cat_title_right_margin = $('[name="wbm_category_slider_display[wbm_cat_title_margin][right]"]').val();
        let wbm_cat_title_bottom_margin = $('[name="wbm_category_slider_display[wbm_cat_title_margin][bottom]"]').val();
        let wbm_cat_title_left_margin = $('[name="wbm_category_slider_display[wbm_cat_title_margin][left]"]').val();
        let wbm_cat_title_unit_margin = $('[name="wbm_category_slider_display[wbm_cat_title_margin][unit]"]').val();
        let wbm_cat_space_between = $('#wbm_cat_space_between').val();

        let wbm_cat_make_card_style;
        if ($('#wbm_cat_make_card_style').prop('checked') === true) {
            wbm_cat_make_card_style = 'on';
        } else {
            wbm_cat_make_card_style = 'off';
        }

        let wbm_card_top_border = $('[name="wbm_category_slider_display[wbm_cat_card_border][top]"]').val();
        let wbm_card_right_border = $('[name="wbm_category_slider_display[wbm_cat_card_border][right]"]').val();
        let wbm_card_bottom_border = $('[name="wbm_category_slider_display[wbm_cat_card_border][bottom]"]').val();
        let wbm_card_left_border = $('[name="wbm_category_slider_display[wbm_cat_card_border][left]"]').val();
        let wbm_card_border_style = $('[name="wbm_category_slider_display[wbm_cat_card_border][style]"]').val();
        let wbm_card_border_color = $('[name="wbm_category_slider_display[wbm_cat_card_border][color]"]').val();
        let wbm_card_border_hov_color = $('[name="wbm_category_slider_display[wbm_cat_card_border][hover_color]"]').val();
        let wbm_card_bg_color = $('[name="wbm_category_slider_display[wbm_cat_card_background][bg_color]"]').val();
        let wbm_card_bg_hov_color = $('[name="wbm_category_slider_display[wbm_cat_card_background][bg_hover_color]"]').val();
        let wbm_inner_top_padding = $('[name="wbm_category_slider_display[wbm_cat_inner_padding][top]"]').val();
        let wbm_inner_right_padding = $('[name="wbm_category_slider_display[wbm_cat_inner_padding][right]"]').val();
        let wbm_inner_bottom_padding = $('[name="wbm_category_slider_display[wbm_cat_inner_padding][bottom]"]').val();
        let wbm_inner_left_padding = $('[name="wbm_category_slider_display[wbm_cat_inner_padding][left]"]').val();
        let wbm_inner_unit_padding = $('[name="wbm_category_slider_display[wbm_cat_inner_padding][unit]"]').val();

        let wbm_cat_name_status;
        if ($('#wbm_cat_name_status').prop('checked') === true) {
            wbm_cat_name_status = 'on';
        } else {
            wbm_cat_name_status = 'off';
        }

        let wbm_cat_name_color = $('#wbm_cat_name_color').val();
        let wbm_cat_name_top_margin = $('[name="wbm_category_slider_display[wbm_cat_name_margin][top]"]').val();
        let wbm_cat_name_right_margin = $('[name="wbm_category_slider_display[wbm_cat_name_margin][right]"]').val();
        let wbm_cat_name_bottom_margin = $('[name="wbm_category_slider_display[wbm_cat_name_margin][bottom]"]').val();
        let wbm_cat_name_left_margin = $('[name="wbm_category_slider_display[wbm_cat_name_margin][left]"]').val();
        let wbm_cat_name_unit_margin = $('[name="wbm_category_slider_display[wbm_cat_name_margin][unit]"]').val();

        let wbm_cat_prod_count;
        if ($('#wbm_cat_prod_count').prop('checked') === true) {
            wbm_cat_prod_count = 'on';
        } else {
            wbm_cat_prod_count = 'off';
        }

        let wbm_cat_count_position = $('[name="wbm_category_slider_display[wbm_cat_count_position]"]:checked').val();
        let wbm_prod_count_before = $('#wbm_prod_count_before').val();
        let wbm_prod_count_after = $('#wbm_prod_count_after').val();
        let wbm_prod_count_color = $('#wbm_prod_count_color').val();

        let wbm_cat_desc_status;
        if ($('#wbm_cat_desc_status').prop('checked') === true) {
            wbm_cat_desc_status = 'on';
        } else {
            wbm_cat_desc_status = 'off';
        }

        let wbm_cat_desc_color = $('#wbm_cat_desc_color').val();
        let wbm_cat_desc_top_margin = $('[name="wbm_category_slider_display[wbm_cat_desc_margin][top]"]').val();
        let wbm_cat_desc_right_margin = $('[name="wbm_category_slider_display[wbm_cat_desc_margin][right]"]').val();
        let wbm_cat_desc_bottom_margin = $('[name="wbm_category_slider_display[wbm_cat_desc_margin][bottom]"]').val();
        let wbm_cat_desc_left_margin = $('[name="wbm_category_slider_display[wbm_cat_desc_margin][left]"]').val();
        let wbm_cat_desc_unit_margin = $('[name="wbm_category_slider_display[wbm_cat_desc_margin][unit]"]').val();

        let wbm_shop_now_button;
        if ($('#wbm_shop_now_button').prop('checked') === true) {
            wbm_shop_now_button = 'on';
        } else {
            wbm_shop_now_button = 'off';
        }

        let wbm_shop_now_label = $('#wbm_shop_now_label').val();
        let wbm_shop_now_color = $('[name="wbm_category_slider_display[wbm_shop_now_color][color]"]').val();
        let wbm_shop_now_hov_color = $('[name="wbm_category_slider_display[wbm_shop_now_color][hover_color]"]').val();
        let wbm_shop_now_bg_color = $('[name="wbm_category_slider_display[wbm_shop_now_color][bg_color]"]').val();
        let wbm_shop_now_bg_hov_color = $('[name="wbm_category_slider_display[wbm_shop_now_color][bg_hover_color]"]').val();
        let wbm_shop_now_all_border = $('[name="wbm_category_slider_display[wbm_shop_now_border][all]"]').val();
        let wbm_shop_now_border_style = $('[name="wbm_category_slider_display[wbm_shop_now_border][style]"]').val();
        let wbm_shop_now_border_color = $('[name="wbm_category_slider_display[wbm_shop_now_border][color]"]').val();
        let wbm_shop_now_border_hov_color = $('[name="wbm_category_slider_display[wbm_shop_now_border][hover_color]"]').val();
        let wbm_shop_now_top_margin = $('[name="wbm_category_slider_display[wbm_shop_now_margin][top]"]').val();
        let wbm_shop_now_right_margin = $('[name="wbm_category_slider_display[wbm_shop_now_margin][right]"]').val();
        let wbm_shop_now_bottom_margin = $('[name="wbm_category_slider_display[wbm_shop_now_margin][bottom]"]').val();
        let wbm_shop_now_left_margin = $('[name="wbm_category_slider_display[wbm_shop_now_margin][left]"]').val();
        let wbm_shop_now_unit_margin = $('[name="wbm_category_slider_display[wbm_shop_now_margin][unit]"]').val();
        let wbm_shop_now_link_target = $('#wbm_shop_now_link_target').val();

        let wbm_cat_thumbnail;
        if ($('#wbm_cat_thumbnail').prop('checked') === true) {
            wbm_cat_thumbnail = 'on';
        } else {
            wbm_cat_thumbnail = 'off';
        }

        let wbm_cat_thumbnail_size = $('#wbm_cat_thumbnail_size').val();

        let wbm_cat_thumb_border;
        if ($('#wbm_cat_thumb_border').prop('checked') === true) {
            wbm_cat_thumb_border = 'on';
        } else {
            wbm_cat_thumb_border = 'off';
        }

        let wbm_thumb_all_border = $('[name="wbm_category_slider_thumbnail[wbm_thumb_border][all]"]').val();
        let wbm_thumb_border_style = $('[name="wbm_category_slider_thumbnail[wbm_thumb_border][style]"]').val();
        let wbm_thumb_border_color = $('[name="wbm_category_slider_thumbnail[wbm_thumb_border][color]"]').val();
        let wbm_thumb_border_hov_color = $('[name="wbm_category_slider_thumbnail[wbm_thumb_border][hover_color]"]').val();
        let wbm_thumb_top_margin = $('[name="wbm_category_slider_thumbnail[wbm_thumb_margin][top]"]').val();
        let wbm_thumb_right_margin = $('[name="wbm_category_slider_thumbnail[wbm_thumb_margin][right]"]').val();
        let wbm_thumb_bottom_margin = $('[name="wbm_category_slider_thumbnail[wbm_thumb_margin][bottom]"]').val();
        let wbm_thumb_left_margin = $('[name="wbm_category_slider_thumbnail[wbm_thumb_margin][left]"]').val();
        let wbm_thumb_unit_margin = $('[name="wbm_category_slider_thumbnail[wbm_thumb_margin][unit]"]').val();
        let wbm_cat_thumb_mode = $('#wbm_cat_thumb_mode').val();

        let wbm_cat_autoplay;
        if ($('#wbm_cat_autoplay').prop('checked') === true) {
            wbm_cat_autoplay = 'true';
        } else {
            wbm_cat_autoplay = 'false';
        }

        let wbm_cat_autoplay_speed = $('#wbm_cat_autoplay_speed').val();
        let wbm_cat_scroll_speed = $('#wbm_cat_scroll_speed').val();

        let wbm_cat_pause_on_hov;
        if ($('#wbm_cat_pause_on_hov').prop('checked') === true) {
            wbm_cat_pause_on_hov = 'true';
        } else {
            wbm_cat_pause_on_hov = 'false';
        }

        let wbm_cat_infinite_loop;
        if ($('#wbm_cat_infinite_loop').prop('checked') === true) {
            wbm_cat_infinite_loop = 'true';
        } else {
            wbm_cat_infinite_loop = 'false';
        }

        let wbm_cat_auto_height;
        if ($('#wbm_cat_auto_height').prop('checked') === true) {
            wbm_cat_auto_height = 'true';
        } else {
            wbm_cat_auto_height = 'false';
        }

        let wbm_cat_touch_swipe_sts;
        if ($('#wbm_cat_touch_swipe').prop('checked') === true) {
            wbm_cat_touch_swipe_sts = 'true';
        } else {
            wbm_cat_touch_swipe_sts = 'false';
        }

        let wbm_cat_mousewheel_sts;
        if ($('#wbm_cat_mousewheel').prop('checked') === true) {
            wbm_cat_mousewheel_sts = 'true';
        } else {
            wbm_cat_mousewheel_sts = 'false';
        }

        let wbm_cat_mouse_draggable_sts;
        if ($('#wbm_cat_mouse_draggable').prop('checked') === true) {
            wbm_cat_mouse_draggable_sts = 'true';
        } else {
            wbm_cat_mouse_draggable_sts = 'false';
        }

        let wbm_cat_nav_color = $('[name="wbm_category_slider_sliders[wbm_cat_nav_color][color]"]').val();
        let wbm_cat_nav_hov_color = $('[name="wbm_category_slider_sliders[wbm_cat_nav_color][hover_color]"]').val();
        let wbm_cat_nav_bg_color = $('[name="wbm_category_slider_sliders[wbm_cat_nav_color][bg_color]"]').val();
        let wbm_cat_nav_bg_hov_color = $('[name="wbm_category_slider_sliders[wbm_cat_nav_color][bg_hover_color]"]').val();
        let wbm_cat_nav_all_border = $('[name="wbm_category_slider_sliders[wbm_cat_nav_border][all]"]').val();
        let wbm_cat_nav_border_style = $('[name="wbm_category_slider_sliders[wbm_cat_nav_border][style]"]').val();
        let wbm_cat_nav_border_color = $('[name="wbm_category_slider_sliders[wbm_cat_nav_border][color]"]').val();
        let wbm_cat_nav_border_hov_color = $('[name="wbm_category_slider_sliders[wbm_cat_nav_border][hover_color]"]').val();
        let wbm_cat_pager_color = $('[name="wbm_category_slider_sliders[wbm_cat_pager_color][color]"]').val();
        let wbm_cat_pager_active_color = $('[name="wbm_category_slider_sliders[wbm_cat_pager_color][active_color]"]').val();
        let wbm_cat_pager_hov_color = $('[name="wbm_category_slider_sliders[wbm_cat_pager_color][hover_color]"]').val();
        let dswbm_slider_mode = $('[name="wbm_category_slider_general[dswbm_slider_mode]"]:checked').val();
        let wbm_cat_thumb_zoom = $('[name="wbm_category_slider_thumbnail[wbm_cat_thumb_zoom]"]').val();
        let wbm_layout_presets = $('[name="wbm_category_slider_general[wbm_layout_presets]"]:checked').val();
        let wbm_cat_thumbnail_shape = $('[name="wbm_category_slider_thumbnail[wbm_cat_thumbnail_shape]"]:checked').val();
        let wbm_cat_thumb_border_radius = $('[name="wbm_category_slider_thumbnail[wbm_cat_thumb_border_radius]"]').val();
        let wbm_thumb_shadow_v_offset    = $('[name="wbm_category_slider_thumbnail[wbm_thumb_shadow][v-offset]"]').val();
        let wbm_thumb_shadow_h_offset    = $('[name="wbm_category_slider_thumbnail[wbm_thumb_shadow][h-offset]"]').val();
        let wbm_thumb_shadow_blur        = $('[name="wbm_category_slider_thumbnail[wbm_thumb_shadow][blur]"]').val();
        let wbm_thumb_shadow_spread      = $('[name="wbm_category_slider_thumbnail[wbm_thumb_shadow][spread]"]').val();
        let wbm_thumb_shadow_shadow      = $('[name="wbm_category_slider_thumbnail[wbm_thumb_shadow][shadow]"]').val();
        let wbm_thumb_shadow_color       = $('[name="wbm_category_slider_thumbnail[wbm_thumb_shadow][color]"]').val();
        let wbm_thumb_shadow_hover_color = $('[name="wbm_category_slider_thumbnail[wbm_thumb_shadow][hover-color]"]').val();

        let wbm_cat_typo_on_off                    = $('[name="wbm_category_slider_typo[wbm_cat_typo_on_off]"]:checked').val();
        let wbm_cat_title_typo_font_family         = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_font_family]"]').val();
        let wbm_cat_title_typo_font_style          = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_font_style]"]').val();
        let wbm_cat_title_typo_text_align          = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_text_align]"]').val();
        let wbm_cat_title_typo_text_transform      = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_text_transform]"]').val();
        let wbm_cat_title_typo_text_font_size      = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_text_font_size]"]').val();
        let wbm_cat_title_typo_text_line_height    = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_text_line_height]"]').val();
        let wbm_cat_title_typo_text_letter_spacing = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_text_letter_spacing]"]').val();

        let wbm_cat_typo_shopbtn_on_off                    = $('[name="wbm_category_slider_typo[wbm_cat_typo_shopbtn_on_off]"]:checked').val();
        let wbm_cat_title_typo_shopbtn_font_family         = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_shopbtn_font_family]"]').val();
        let wbm_cat_title_typo_shopbtn_font_style          = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_shopbtn_font_style]"]').val();
        let wbm_cat_title_typo_shopbtn_text_align          = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_shopbtn_text_align]"]').val();
        let wbm_cat_title_typo_shopbtn_text_transform      = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_shopbtn_text_transform]"]').val();
        let wbm_cat_title_typo_shopbtn_text_font_size      = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_shopbtn_text_font_size]"]').val();
        let wbm_cat_title_typo_shopbtn_text_line_height    = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_shopbtn_text_line_height]"]').val();
        let wbm_cat_title_typo_shopbtn_text_letter_spacing = $('[name="wbm_category_slider_typo[wbm_cat_title_typo_shopbtn_text_letter_spacing]"]').val();

        let wbm_cat_no_cols_large_desktop = $('[name="wbm_category_slider_general[wbm_cat_no_of_cols][large_desktop]"]').val();
        let wbm_cat_no_cols_desktop    	  = $('[name="wbm_category_slider_general[wbm_cat_no_of_cols][desktop]"]').val();
        let wbm_cat_no_cols_laptop    	  = $('[name="wbm_category_slider_general[wbm_cat_no_of_cols][laptop]"]').val();
        let wbm_cat_no_cols_tablet    	  = $('[name="wbm_category_slider_general[wbm_cat_no_of_cols][tablet]"]').val();
        let wbm_cat_no_cols_mobile    	  = $('[name="wbm_category_slider_general[wbm_cat_no_of_cols][mobile]"]').val();

        let wbm_cat_content_position = $('[name="wbm_category_slider_display[wbm_cat_content_position]"]:checked').val();
        let dswbm_child_categories = $('[name="wbm_category_slider_general[dswbm_child_categories]"]:checked').val();

        let wbm_cat_slide_to_scroll_large_desktop = $('[name="wbm_category_slider_sliders[wbm_cat_slide_to_scroll][large_desktop]"]').val();
        let wbm_cat_slide_to_scroll_desktop    	  = $('[name="wbm_category_slider_sliders[wbm_cat_slide_to_scroll][desktop]"]').val();
        let wbm_cat_slide_to_scroll_laptop    	  = $('[name="wbm_category_slider_sliders[wbm_cat_slide_to_scroll][laptop]"]').val();
        let wbm_cat_slide_to_scroll_tablet    	  = $('[name="wbm_category_slider_sliders[wbm_cat_slide_to_scroll][tablet]"]').val();
        let wbm_cat_slide_to_scroll_mobile    	  = $('[name="wbm_category_slider_sliders[wbm_cat_slide_to_scroll][mobile]"]').val();

        let wbm_parent_child_display_type    	  = $('[name="wbm_category_slider_general[wbm_parent_child_display_type]"]:checked').val();

        if( '' === wbm_layout_presets || undefined === wbm_layout_presets ){
            wbm_layout_presets = 'slider';
        }

        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: {
                'action': 'wcbm_show_category_slider_settings_preview',
                'security': wbmConditionalVars.wbm_nonce,
                'wbm_cat_slider_status': dswbm_cat_slider_status,
                'wbm_filter_categories': wbm_filter_categories,
                'wbm_choose_categories': wbm_choose_categories_arr,
                'wbm_choose_categories_pnc_cat_arr': wbm_choose_categories_pnc_cat_arr,
                'wbm_exclude_categories': wbm_exclude_categories_arr,
                'wbm_total_cat_show': wbm_total_cat_show,
                'wbm_cat_order_by': wbm_cat_order_by,
                'wbm_cat_order': wbm_cat_order,
                'wbm_cat_sec_title_status': wbm_cat_sec_title_status,
                'wbm_cat_slider_rule_name': wbm_cat_slider_rule_name,
                'wbm_cat_title_color': wbm_cat_title_color,
                'wbm_cat_title_top_margin': wbm_cat_title_top_margin,
                'wbm_cat_title_right_margin': wbm_cat_title_right_margin,
                'wbm_cat_title_bottom_margin': wbm_cat_title_bottom_margin,
                'wbm_cat_title_left_margin': wbm_cat_title_left_margin,
                'wbm_cat_title_unit_margin': wbm_cat_title_unit_margin,
                'wbm_cat_make_card_style': wbm_cat_make_card_style,
                'wbm_card_top_border': wbm_card_top_border,
                'wbm_card_right_border': wbm_card_right_border,
                'wbm_card_bottom_border': wbm_card_bottom_border,
                'wbm_card_left_border': wbm_card_left_border,
                'wbm_card_border_style': wbm_card_border_style,
                'wbm_card_border_color': wbm_card_border_color,
                'wbm_card_border_hov_color': wbm_card_border_hov_color,
                'wbm_card_bg_color': wbm_card_bg_color,
                'wbm_card_bg_hov_color': wbm_card_bg_hov_color,
                'wbm_inner_top_padding': wbm_inner_top_padding,
                'wbm_inner_right_padding': wbm_inner_right_padding,
                'wbm_inner_bottom_padding': wbm_inner_bottom_padding,
                'wbm_inner_left_padding': wbm_inner_left_padding,
                'wbm_inner_unit_padding': wbm_inner_unit_padding,
                'wbm_cat_name_status': wbm_cat_name_status,
                'wbm_cat_name_color': wbm_cat_name_color,
                'wbm_cat_name_top_margin': wbm_cat_name_top_margin,
                'wbm_cat_name_right_margin': wbm_cat_name_right_margin,
                'wbm_cat_name_bottom_margin': wbm_cat_name_bottom_margin,
                'wbm_cat_name_left_margin': wbm_cat_name_left_margin,
                'wbm_cat_name_unit_margin': wbm_cat_name_unit_margin,
                'wbm_cat_prod_count': wbm_cat_prod_count,
                'wbm_cat_count_position': wbm_cat_count_position,
                'wbm_prod_count_before': wbm_prod_count_before,
                'wbm_prod_count_after': wbm_prod_count_after,
                'wbm_prod_count_color': wbm_prod_count_color,
                'wbm_cat_desc_status': wbm_cat_desc_status,
                'wbm_cat_desc_color': wbm_cat_desc_color,
                'wbm_cat_desc_top_margin': wbm_cat_desc_top_margin,
                'wbm_cat_desc_right_margin': wbm_cat_desc_right_margin,
                'wbm_cat_desc_bottom_margin': wbm_cat_desc_bottom_margin,
                'wbm_cat_desc_left_margin': wbm_cat_desc_left_margin,
                'wbm_cat_desc_unit_margin': wbm_cat_desc_unit_margin,
                'wbm_shop_now_button': wbm_shop_now_button,
                'wbm_shop_now_label': wbm_shop_now_label,
                'wbm_shop_now_color': wbm_shop_now_color,
                'wbm_shop_now_hov_color': wbm_shop_now_hov_color,
                'wbm_shop_now_bg_color': wbm_shop_now_bg_color,
                'wbm_shop_now_bg_hov_color': wbm_shop_now_bg_hov_color,
                'wbm_shop_now_all_border': wbm_shop_now_all_border,
                'wbm_shop_now_border_style': wbm_shop_now_border_style,
                'wbm_shop_now_border_color': wbm_shop_now_border_color,
                'wbm_shop_now_border_hov_color': wbm_shop_now_border_hov_color,
                'wbm_shop_now_top_margin': wbm_shop_now_top_margin,
                'wbm_shop_now_right_margin': wbm_shop_now_right_margin,
                'wbm_shop_now_bottom_margin': wbm_shop_now_bottom_margin,
                'wbm_shop_now_left_margin': wbm_shop_now_left_margin,
                'wbm_shop_now_unit_margin': wbm_shop_now_unit_margin,
                'wbm_shop_now_link_target': wbm_shop_now_link_target,
                'wbm_cat_thumbnail': wbm_cat_thumbnail,
                'wbm_cat_thumbnail_size': wbm_cat_thumbnail_size,
                'wbm_cat_thumb_border': wbm_cat_thumb_border,
                'wbm_thumb_all_border': wbm_thumb_all_border,
                'wbm_thumb_border_style': wbm_thumb_border_style,
                'wbm_thumb_border_color': wbm_thumb_border_color,
                'wbm_thumb_border_hov_color': wbm_thumb_border_hov_color,
                'wbm_thumb_top_margin': wbm_thumb_top_margin,
                'wbm_thumb_right_margin': wbm_thumb_right_margin,
                'wbm_thumb_bottom_margin': wbm_thumb_bottom_margin,
                'wbm_thumb_left_margin': wbm_thumb_left_margin,
                'wbm_thumb_unit_margin': wbm_thumb_unit_margin,
                'wbm_cat_thumb_mode': wbm_cat_thumb_mode,
                'wbm_cat_autoplay': wbm_cat_autoplay,
                'wbm_cat_autoplay_speed': wbm_cat_autoplay_speed,
                'wbm_cat_scroll_speed': wbm_cat_scroll_speed,
                'wbm_cat_pause_on_hov': wbm_cat_pause_on_hov,
                'wbm_cat_infinite_loop': wbm_cat_infinite_loop,
                'wbm_cat_auto_height': wbm_cat_auto_height,
                'wbm_cat_nav_color': wbm_cat_nav_color,
                'wbm_cat_nav_hov_color': wbm_cat_nav_hov_color,
                'wbm_cat_nav_bg_color': wbm_cat_nav_bg_color,
                'wbm_cat_nav_bg_hov_color': wbm_cat_nav_bg_hov_color,
                'wbm_cat_nav_all_border': wbm_cat_nav_all_border,
                'wbm_cat_nav_border_style': wbm_cat_nav_border_style,
                'wbm_cat_nav_border_color': wbm_cat_nav_border_color,
                'wbm_cat_nav_border_hov_color': wbm_cat_nav_border_hov_color,
                'wbm_cat_pager_color': wbm_cat_pager_color,
                'wbm_cat_pager_active_color': wbm_cat_pager_active_color,
                'wbm_cat_pager_hov_color': wbm_cat_pager_hov_color,
                'dswbm_slider_mode': dswbm_slider_mode,
                'wbm_cat_thumb_zoom': wbm_cat_thumb_zoom,
                'wbm_layout_presets': wbm_layout_presets,
                'wbm_cat_thumbnail_shape':wbm_cat_thumbnail_shape,
                'wbm_cat_thumb_border_radius': wbm_cat_thumb_border_radius,
                'wbm_thumb_shadow_v_offset' : wbm_thumb_shadow_v_offset,
                'wbm_thumb_shadow_h_offset' : wbm_thumb_shadow_h_offset,
                'wbm_thumb_shadow_blur' : wbm_thumb_shadow_blur,
                'wbm_thumb_shadow_spread' : wbm_thumb_shadow_spread,
                'wbm_thumb_shadow_shadow' : wbm_thumb_shadow_shadow,
                'wbm_thumb_shadow_color' : wbm_thumb_shadow_color,
                'wbm_thumb_shadow_hover_color' : wbm_thumb_shadow_hover_color,
                'wbm_cat_typo_on_off' : wbm_cat_typo_on_off,
                'wbm_cat_title_typo_font_family' : wbm_cat_title_typo_font_family,
                'wbm_cat_title_typo_font_style' : wbm_cat_title_typo_font_style,
                'wbm_cat_title_typo_text_align' : wbm_cat_title_typo_text_align,
                'wbm_cat_title_typo_text_transform' : wbm_cat_title_typo_text_transform,
                'wbm_cat_title_typo_text_font_size' : wbm_cat_title_typo_text_font_size,
                'wbm_cat_title_typo_text_line_height' : wbm_cat_title_typo_text_line_height,
                'wbm_cat_title_typo_text_letter_spacing' : wbm_cat_title_typo_text_letter_spacing,
                'wbm_cat_typo_shopbtn_on_off' : wbm_cat_typo_shopbtn_on_off,
                'wbm_cat_title_typo_shopbtn_font_family' : wbm_cat_title_typo_shopbtn_font_family,
                'wbm_cat_title_typo_shopbtn_font_style' : wbm_cat_title_typo_shopbtn_font_style,
                'wbm_cat_title_typo_shopbtn_text_align' : wbm_cat_title_typo_shopbtn_text_align,
                'wbm_cat_title_typo_shopbtn_text_transform' : wbm_cat_title_typo_shopbtn_text_transform,
                'wbm_cat_title_typo_shopbtn_text_font_size' : wbm_cat_title_typo_shopbtn_text_font_size,
                'wbm_cat_title_typo_shopbtn_text_line_height' : wbm_cat_title_typo_shopbtn_text_line_height,
                'wbm_cat_title_typo_shopbtn_text_letter_spacing' : wbm_cat_title_typo_shopbtn_text_letter_spacing,
                'wbm_cat_content_position': wbm_cat_content_position,
                'dswbm_child_categories' : dswbm_child_categories,
                'wbm_cat_no_cols_large_desktop': wbm_cat_no_cols_large_desktop,
                'wbm_cat_no_cols_desktop': wbm_cat_no_cols_desktop,
                'wbm_cat_no_cols_laptop': wbm_cat_no_cols_laptop,
                'wbm_cat_no_cols_tablet': wbm_cat_no_cols_tablet,
                'wbm_cat_no_cols_mobile': wbm_cat_no_cols_mobile,
                'wbm_cat_slide_to_scroll_large_desktop': wbm_cat_slide_to_scroll_large_desktop,
                'wbm_cat_slide_to_scroll_desktop': wbm_cat_slide_to_scroll_desktop,
                'wbm_cat_slide_to_scroll_laptop': wbm_cat_slide_to_scroll_laptop,
                'wbm_cat_slide_to_scroll_tablet': wbm_cat_slide_to_scroll_tablet,
                'wbm_cat_slide_to_scroll_mobile': wbm_cat_slide_to_scroll_mobile,
                'wbm_cat_touch_swipe': wbm_cat_touch_swipe_sts,
                'wbm_parent_child_display_type': wbm_parent_child_display_type,
            },
            success: function(response) {
                if (!response.error) {
                    if (isJson(response)) {
                        let result_data = JSON.parse(response);
                        $('.wbm_slider_live_preview .slider-preview-body').html(result_data);
                    } else {
                        $('.wbm_slider_live_preview .slider-preview-body').html(response);
                    }
                    $(document).on('keyup change', '.dotstore-plugins_page_wcbm-sliders-settings', function (e) {
                        e.preventDefault();
                        $('#wbm-category-slider-preview-btn').text(wbmConditionalVars.update_preview);
                    });
                    if ($('.wbm-category-slider-section').length !== 0) {
                        var numberOfCatSlides;
                        if (windowWidth <= 480) {
                            numberOfCatSlides = wbm_cat_no_mobile;
                        } else if (windowWidth <= 736) {
                            numberOfCatSlides = wbm_cat_no_tablet;
                        } else if (windowWidth <= 980) {
                            numberOfCatSlides = wbm_cat_no_laptop;
                        } else if (windowWidth <= 1280) {
                            numberOfCatSlides = wbm_cat_no_desktop;
                        } else {
                            numberOfCatSlides = wbm_cat_no_large_desktop;
                        }

                        var numberOfslideSlides;
                        if (windowWidth <= 480) {
                            numberOfslideSlides = wbm_cat_slide_to_scroll_mobile;
                        } else if (windowWidth <= 736) {
                            numberOfslideSlides = wbm_cat_slide_to_scroll_tablet;
                        } else if (windowWidth <= 980) {
                            numberOfslideSlides = wbm_cat_slide_to_scroll_laptop;
                        } else if (windowWidth <= 1280) {
                            numberOfslideSlides = wbm_cat_slide_to_scroll_desktop;
                        } else {
                            numberOfslideSlides = wbm_cat_slide_to_scroll_large_desktop;
                        }

                        $('.wbm-category-slider-section').each(function () {
                            let autoPlay = $('.wbm-category-slider-section').attr('auto-play');
                            let autoPlaySpeed = $('.wbm-category-slider-section').attr('auto-play-speed');
                            let scrollSpeed = $('.wbm-category-slider-section').attr('scroll-speed');
                            let pauseOnHover = $('.wbm-category-slider-section').attr('pause-hover');
                            let inFiniteLoop = $('.wbm-category-slider-section').attr('infinite-loop');
                            let autoHeight = $('.wbm-category-slider-section').attr('auto-height');
                            let sliderPager = $('input[name="wbm_category_slider_sliders[wbm_cat_pager_status]"]:checked').val();
                            let sliderNav = $('input[name="wbm_category_slider_sliders[wbm_cat_nav_status]"]:checked').val();
                            let slidermode = $('.wbm-category-slider-section').attr('slider-mode');
                            let sliderTouchStatus = $('.wbm-category-slider-section').attr('slider-touch-status');

                            var slidermodestatus;
                            if( 'ticker' === slidermode ){
                                slidermodestatus = true;
                                autoPlay         = 'false';
                            } else {
                                slidermodestatus = false;
                            }

                            if( 'slider' === wbm_layout_presets ){
                                initCategorySlider = $('.slider-preview-body ul').bxSlider({
                                    minSlides: numberOfCatSlides,
                                    maxSlides: numberOfCatSlides,
                                    moveSlides: numberOfslideSlides,
                                    controls: sliderNav === 'true' ? true : false,
                                    pager: sliderPager === 'true' ? true : false,
                                    auto: autoPlay === 'true' ? true : false,
                                    pause: parseInt(autoPlaySpeed),
                                    speed: parseInt(scrollSpeed),
                                    adaptiveHeight: autoHeight === 'true' ? true : false,
                                    autoHover: pauseOnHover === 'true' ? true : false,
                                    infiniteLoop: inFiniteLoop === 'true' ? true : false,
                                    responsive: true,
                                    touchEnabled: sliderTouchStatus === 'true' ? true : false,
                                    slideWidth: 2200,
                                    mouseDrag: wbm_cat_mouse_draggable_sts === 'true' ? true : false,
                                    ticker: slidermodestatus,
                                    tickerHover: slidermodestatus,
                                    useCSS: false,
                                    slideMargin: parseInt(wbm_cat_space_between),
                                    nextText: sliderNextText.get(0).outerHTML,
                                    prevText: sliderPrevText.get(0).outerHTML
                                });
                                if( 'true' === wbm_cat_mousewheel_sts ){
                                    initCategorySlider.on('mousewheel', function(e){
                                        e.preventDefault();
                                  
                                        if( !initCategorySlider.hasClass('dontMove') ) {
                                  
                                          if(e.originalEvent.wheelDelta > 0) {
                                            initCategorySlider.goToPrevSlide();
                                          } else {            
                                            initCategorySlider.goToNextSlide();
                                          }
                                  
                                        }
                                  
                                    })
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    function showProductSliderPreview() {
        $('.wbm_slider_live_preview').fadeIn();
        $('#wbm-product-slider-preview-btn').text(wbmConditionalVars.hide_preview);

        let dswbm_prod_slider_status;
        if ($('#dswbm_prod_slider_status').prop('checked') === true) {
            dswbm_prod_slider_status = 'on';
        } else {
            dswbm_prod_slider_status = 'off';
        }

        var wbm_filter_products_result = '';
        var wbm_filter_products;
        wbm_filter_products = $('#wbm_filter_products').val();
        if ('' !== wbm_filter_products) {
            wbm_filter_products_result = wbm_filter_products;
        }

        var wbm_exclude_products_result = '';
        var wbm_exclude_products;
        wbm_exclude_products = $('#wbm_exclude_products').val();
        if ('' !== wbm_exclude_products) {
            wbm_exclude_products_result = wbm_exclude_products;
        }

        var wbm_choose_products_arr = [];
        var wbm_choose_products;
        wbm_choose_products = $('#wbm_choose_products').val();
        if ('' !== wbm_choose_products) {
            wbm_choose_products_arr = wbm_choose_products;
        }

        var wbm_featured_products_arr = [];
        var wbm_featured_products;
        wbm_featured_products = $('#wbm_featured_products').val();
        if ('' !== wbm_featured_products) {
            wbm_featured_products_arr = wbm_featured_products;
        }

        var wbm_choose_by_cat_arr = [];
        var wbm_choose_by_cat;
        wbm_choose_by_cat = $('#wbm_choose_by_cat').val();
        if ('' !== wbm_choose_by_cat) {
            wbm_choose_by_cat_arr = wbm_choose_by_cat;
        }

        var wbm_total_prod_show = $('#wbm_total_prod_show').val();
        let wbm_prod_no_large_desktop = $('[name="wbm_product_slider_general[wbm_prod_no_of_cols][large_desktop]"]').val();
        let wbm_prod_no_desktop = $('[name="wbm_product_slider_general[wbm_prod_no_of_cols][desktop]"]').val();
        let wbm_prod_no_laptop = $('[name="wbm_product_slider_general[wbm_prod_no_of_cols][laptop]"]').val();
        let wbm_prod_no_tablet = $('[name="wbm_product_slider_general[wbm_prod_no_of_cols][tablet]"]').val();
        let wbm_prod_no_mobile = $('[name="wbm_product_slider_general[wbm_prod_no_of_cols][mobile]"]').val();
        let wbm_prod_order_by = $('#wbm_prod_order_by').val();
        let wbm_prod_order = $('#wbm_prod_order').val();

        let wbm_prod_sec_title_status;
        if ($('#wbm_prod_title').prop('checked') === true) {
            wbm_prod_sec_title_status = 'on';
        } else {
            wbm_prod_sec_title_status = 'off';
        }

        let wbm_prod_slider_rule_name = $('[name="dswbm_prod_slider_rule_name"]').val();
        let wbm_prod_title_color = $('#wbm_prod_title_color').val();
        let wbm_prod_title_top_margin = $('[name="wbm_product_slider_display[wbm_prod_title_margin][top]"]').val();
        let wbm_prod_title_right_margin = $('[name="wbm_product_slider_display[wbm_prod_title_margin][right]"]').val();
        let wbm_prod_title_bottom_margin = $('[name="wbm_product_slider_display[wbm_prod_title_margin][bottom]"]').val();
        let wbm_prod_title_left_margin = $('[name="wbm_product_slider_display[wbm_prod_title_margin][left]"]').val();
        let wbm_prod_title_unit_margin = $('[name="wbm_product_slider_display[wbm_prod_title_margin][unit]"]').val();
        let wbm_prod_space_between = $('#wbm_prod_space_between').val();

        let wbm_prod_autoplay;
        if ($('#wbm_prod_autoplay').prop('checked') === true) {
            wbm_prod_autoplay = 'true';
        } else {
            wbm_prod_autoplay = 'false';
        }

        let wbm_prod_autoplay_speed = $('#wbm_prod_autoplay_speed').val();
        let wbm_prod_scroll_speed = $('#wbm_prod_scroll_speed').val();

        let wbm_prod_pause_on_hov;
        if ($('#wbm_prod_pause_on_hov').prop('checked') === true) {
            wbm_prod_pause_on_hov = 'true';
        } else {
            wbm_prod_pause_on_hov = 'false';
        }

        let wbm_prod_infinite_loop;
        if ($('#wbm_prod_infinite_loop').prop('checked') === true) {
            wbm_prod_infinite_loop = 'true';
        } else {
            wbm_prod_infinite_loop = 'false';
        }

        let wbm_prod_auto_height;
        if ($('#wbm_prod_auto_height').prop('checked') === true) {
            wbm_prod_auto_height = 'true';
        } else {
            wbm_prod_auto_height = 'false';
        }

        let wbm_prod_nav_color = $('[name="wbm_product_slider_sliders[wbm_prod_nav_color][color]"]').val();
        let wbm_prod_nav_hov_color = $('[name="wbm_product_slider_sliders[wbm_prod_nav_color][hover_color]"]').val();
        let wbm_prod_nav_bg_color = $('[name="wbm_product_slider_sliders[wbm_prod_nav_color][bg_color]"]').val();
        let wbm_prod_nav_bg_hov_color = $('[name="wbm_product_slider_sliders[wbm_prod_nav_color][bg_hover_color]"]').val();
        let wbm_prod_nav_all_border = $('[name="wbm_product_slider_sliders[wbm_prod_nav_border][all]"]').val();
        let wbm_prod_nav_border_style = $('[name="wbm_product_slider_sliders[wbm_prod_nav_border][style]"]').val();
        let wbm_prod_nav_border_color = $('[name="wbm_product_slider_sliders[wbm_prod_nav_border][color]"]').val();
        let wbm_prod_nav_border_hov_color = $('[name="wbm_product_slider_sliders[wbm_prod_nav_border][hover_color]"]').val();
        let wbm_prod_pager_color = $('[name="wbm_product_slider_sliders[wbm_prod_pager_color][color]"]').val();
        let wbm_prod_pager_active_color = $('[name="wbm_product_slider_sliders[wbm_prod_pager_color][active_color]"]').val();
        let wbm_prod_pager_hov_color = $('[name="wbm_product_slider_sliders[wbm_prod_pager_color][hover_color]"]').val();
        let dswbm_slider_mode = $('[name="wbm_product_slider_general[dswbm_slider_mode]"]:checked').val();
        let wbm_prod_thumb_zoom = $('[name="wbm_product_slider_sliders[wbm_prod_thumb_zoom]"]').val();

        let v_offset = $('[name="wbm_product_slider_sliders[wbm_thumb_shadow][v-offset]"]').val();
        let h_offset = $('[name="wbm_product_slider_sliders[wbm_thumb_shadow][h-offset]"]').val();
        let blur = $('[name="wbm_product_slider_sliders[wbm_thumb_shadow][blur]"]').val();
        let spread = $('[name="wbm_product_slider_sliders[wbm_thumb_shadow][spread]"]').val();
        let shadow = $('[name="wbm_product_slider_sliders[wbm_thumb_shadow][shadow]"]').val();
        let color = $('[name="wbm_product_slider_sliders[wbm_thumb_shadow][color]"]').val();
        let hover_color = $('[name="wbm_product_slider_sliders[wbm_thumb_shadow][hover-color]"]').val();

        let wbm_product_typo_on_off = $('[name="wbm_product_slider_typo[wbm_product_typo_on_off]"]:checked').val();
        let wbm_product_title_typo_font_family = $('[name="wbm_product_slider_typo[wbm_product_title_typo_font_family]"]').val();
        let wbm_product_title_typo_font_style = $('[name="wbm_product_slider_typo[wbm_product_title_typo_font_style]"]').val();
        let wbm_product_title_typo_text_align = $('[name="wbm_product_slider_typo[wbm_product_title_typo_text_align]"]').val();
        let wbm_product_title_typo_text_transform = $('[name="wbm_product_slider_typo[wbm_product_title_typo_text_transform]"]').val();
        let wbm_product_title_typo_text_font_size = $('[name="wbm_product_slider_typo[wbm_product_title_typo_text_font_size]"]').val();
        let wbm_product_title_typo_text_line_height = $('[name="wbm_product_slider_typo[wbm_product_title_typo_text_line_height]"]').val();
        let wbm_product_title_typo_text_letter_spacing = $('[name="wbm_product_slider_typo[wbm_product_title_typo_text_letter_spacing]"]').val();

        let wbm_product_typo_shopbtn_on_off = $('[name="wbm_product_slider_typo[wbm_product_typo_shopbtn_on_off]"]:checked').val();
        let wbm_product_title_typo_shopbtn_font_family = $('[name="wbm_product_slider_typo[wbm_product_title_typo_shopbtn_font_family]"]').val();
        let wbm_product_title_typo_shopbtn_font_style = $('[name="wbm_product_slider_typo[wbm_product_title_typo_shopbtn_font_style]"]').val();
        let wbm_product_title_typo_shopbtn_text_align = $('[name="wbm_product_slider_typo[wbm_product_title_typo_shopbtn_text_align]"]').val();
        let wbm_product_title_typo_shopbtn_text_transform = $('[name="wbm_product_slider_typo[wbm_product_title_typo_shopbtn_text_transform]"]').val();
        let wbm_product_title_typo_shopbtn_text_font_size = $('[name="wbm_product_slider_typo[wbm_product_title_typo_shopbtn_text_font_size]"]').val();
        let wbm_product_title_typo_shopbtn_text_line_height = $('[name="wbm_product_slider_typo[wbm_product_title_typo_shopbtn_text_line_height]"]').val();
        let wbm_product_title_typo_shopbtn_text_letter_spacing = $('[name="wbm_product_slider_typo[wbm_product_title_typo_shopbtn_text_letter_spacing]"]').val();

        let wbm_product_typo_addtocart_on_off = $('[name="wbm_product_slider_typo[wbm_product_typo_addtocart_on_off]"]:checked').val();
        let wbm_product_title_typo_addtocart_font_family = $('[name="wbm_product_slider_typo[wbm_product_title_typo_addtocart_font_family]"]').val();
        let wbm_product_title_typo_addtocart_font_style = $('[name="wbm_product_slider_typo[wbm_product_title_typo_addtocart_font_style]"]').val();
        let wbm_product_title_typo_addtocart_text_align = $('[name="wbm_product_slider_typo[wbm_product_title_typo_addtocart_text_align]"]').val();
        let wbm_product_title_typo_addtocart_text_transform = $('[name="wbm_product_slider_typo[wbm_product_title_typo_addtocart_text_transform]"]').val();
        let wbm_product_title_typo_addtocart_text_font_size = $('[name="wbm_product_slider_typo[wbm_product_title_typo_addtocart_text_font_size]"]').val();
        let wbm_product_title_typo_addtocart_text_line_height = $('[name="wbm_product_slider_typo[wbm_product_title_typo_addtocart_text_line_height]"]').val();
        let wbm_product_title_typo_addtocart_text_letter_spacing = $('[name="wbm_product_slider_typo[wbm_product_title_typo_addtocart_text_letter_spacing]"]').val();

        let wbm_prod_thumb_image_mode = $('[name="wbm_product_slider_sliders[wbm_prod_thumb_image_mode]"] option:selected').val();
        let wbm_prod_slide_large_desktop = $('[name="wbm_product_slider_sliders[wbm_prod_slide_to_scroll][large_desktop]"]').val();
        let wbm_prod_slide_desktop = $('[name="wbm_product_slider_sliders[wbm_prod_slide_to_scroll][desktop]"]').val();
        let wbm_prod_slide_laptop = $('[name="wbm_product_slider_sliders[wbm_prod_slide_to_scroll][laptop]"]').val();
        let wbm_prod_slide_tablet = $('[name="wbm_product_slider_sliders[wbm_prod_slide_to_scroll][tablet]"]').val();
        let wbm_prod_slide_mobile = $('[name="wbm_product_slider_sliders[wbm_prod_slide_to_scroll][mobile]"]').val();

        let wbm_prod_touch_swipe_status        = $('[name="wbm_product_slider_sliders[wbm_prod_touch_swipe_status]"]:checked').val();
        let wbm_prod_mousewheel_control_status = $('[name="wbm_product_slider_sliders[wbm_prod_mousewheel_control_status]"]:checked').val();
        let wbm_prod_mouse_draggable_status    = $('[name="wbm_product_slider_sliders[wbm_prod_mouse_draggable_status]"]:checked').val();
        
        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: {
                'action': 'wcbm_show_product_slider_settings_preview',
                'security': wbmConditionalVars.wbm_nonce,
                'wbm_prod_slider_status': dswbm_prod_slider_status,
                'wbm_filter_products': wbm_filter_products_result,
                'wbm_exclude_products': wbm_exclude_products_result,
                'wbm_choose_products': wbm_choose_products_arr,
                'wbm_featured_products': wbm_featured_products_arr,
                'wbm_choose_by_cat': wbm_choose_by_cat_arr,
                'wbm_total_prod_show': wbm_total_prod_show,                
                'wbm_prod_order_by': wbm_prod_order_by,
                'wbm_prod_order': wbm_prod_order,
                'wbm_prod_sec_title_status': wbm_prod_sec_title_status,
                'wbm_prod_slider_rule_name': wbm_prod_slider_rule_name,
                'wbm_prod_title_color': wbm_prod_title_color,
                'wbm_prod_title_top_margin': wbm_prod_title_top_margin,
                'wbm_prod_title_right_margin': wbm_prod_title_right_margin,
                'wbm_prod_title_bottom_margin': wbm_prod_title_bottom_margin,
                'wbm_prod_title_left_margin': wbm_prod_title_left_margin,
                'wbm_prod_title_unit_margin': wbm_prod_title_unit_margin,
                'wbm_prod_autoplay': wbm_prod_autoplay,
                'wbm_prod_autoplay_speed': wbm_prod_autoplay_speed,
                'wbm_prod_scroll_speed': wbm_prod_scroll_speed,
                'wbm_prod_pause_on_hov': wbm_prod_pause_on_hov,
                'wbm_prod_infinite_loop': wbm_prod_infinite_loop,
                'wbm_prod_auto_height': wbm_prod_auto_height,
                'wbm_prod_nav_color': wbm_prod_nav_color,
                'wbm_prod_nav_hov_color': wbm_prod_nav_hov_color,
                'wbm_prod_nav_bg_color': wbm_prod_nav_bg_color,
                'wbm_prod_nav_bg_hov_color': wbm_prod_nav_bg_hov_color,
                'wbm_prod_nav_all_border': wbm_prod_nav_all_border,
                'wbm_prod_nav_border_style': wbm_prod_nav_border_style,
                'wbm_prod_nav_border_color': wbm_prod_nav_border_color,
                'wbm_prod_nav_border_hov_color': wbm_prod_nav_border_hov_color,
                'wbm_prod_pager_color': wbm_prod_pager_color,
                'wbm_prod_pager_active_color': wbm_prod_pager_active_color,
                'wbm_prod_pager_hov_color': wbm_prod_pager_hov_color,
                'dswbm_slider_mode': dswbm_slider_mode,
                'wbm_prod_thumb_zoom': wbm_prod_thumb_zoom,
                'wbm_prod_v_offset': v_offset,
                'wbm_prod_h_offset': h_offset,
                'wbm_prod_blur': blur,
                'wbm_prod_spread': spread,
                'wbm_prod_shadow': shadow,
                'wbm_prod_color': color,
                'wbm_prod_hover_color': hover_color,
                'wbm_product_typo_on_off' : wbm_product_typo_on_off,
                'wbm_product_title_typo_font_family' : wbm_product_title_typo_font_family,
                'wbm_product_title_typo_font_style' : wbm_product_title_typo_font_style,
                'wbm_product_title_typo_text_align' : wbm_product_title_typo_text_align,
                'wbm_product_title_typo_text_transform' : wbm_product_title_typo_text_transform,
                'wbm_product_title_typo_text_font_size' : wbm_product_title_typo_text_font_size,
                'wbm_product_title_typo_text_line_height' : wbm_product_title_typo_text_line_height,
                'wbm_product_title_typo_text_letter_spacing' : wbm_product_title_typo_text_letter_spacing,
                'wbm_product_typo_shopbtn_on_off' : wbm_product_typo_shopbtn_on_off,
                'wbm_product_title_typo_shopbtn_font_family' : wbm_product_title_typo_shopbtn_font_family,
                'wbm_product_title_typo_shopbtn_font_style' : wbm_product_title_typo_shopbtn_font_style,
                'wbm_product_title_typo_shopbtn_text_align' : wbm_product_title_typo_shopbtn_text_align,
                'wbm_product_title_typo_shopbtn_text_transform' : wbm_product_title_typo_shopbtn_text_transform,
                'wbm_product_title_typo_shopbtn_text_font_size' : wbm_product_title_typo_shopbtn_text_font_size,
                'wbm_product_title_typo_shopbtn_text_line_height' : wbm_product_title_typo_shopbtn_text_line_height,
                'wbm_product_title_typo_shopbtn_text_letter_spacing' : wbm_product_title_typo_shopbtn_text_letter_spacing,
                'wbm_product_typo_addtocart_on_off' : wbm_product_typo_addtocart_on_off,
                'wbm_product_title_typo_addtocart_font_family' : wbm_product_title_typo_addtocart_font_family,
                'wbm_product_title_typo_addtocart_font_style' : wbm_product_title_typo_addtocart_font_style,
                'wbm_product_title_typo_addtocart_text_align' : wbm_product_title_typo_addtocart_text_align,
                'wbm_product_title_typo_addtocart_text_transform' : wbm_product_title_typo_addtocart_text_transform,
                'wbm_product_title_typo_addtocart_text_font_size' : wbm_product_title_typo_addtocart_text_font_size,
                'wbm_product_title_typo_addtocart_text_line_height' : wbm_product_title_typo_addtocart_text_line_height,
                'wbm_product_title_typo_addtocart_text_letter_spacing' : wbm_product_title_typo_addtocart_text_letter_spacing,
                'wbm_prod_thumb_image_mode' : wbm_prod_thumb_image_mode,
            },
            success: function(response) {
                if (!response.error) {
                    if (isJson(response)) {
                        let result_data = JSON.parse(response);
                        $('.wbm_slider_live_preview .slider-preview-body').html(result_data);
                    } else {
                        $('.wbm_slider_live_preview .slider-preview-body').html(response);
                    }
                    $(document).on('keyup change', '.dotstore-plugins_page_wcbm-sliders-settings', function (e) {
                        e.preventDefault();
                        $('#wbm-product-slider-preview-btn').text(wbmConditionalVars.update_preview);
                    });
                    if ($('.wbm-product-slider-section').length !== 0) {
                        var numberOfProdSlides;
                        if (windowWidth <= 480) {
                            numberOfProdSlides = wbm_prod_no_mobile;
                        } else if (windowWidth <= 736) {
                            numberOfProdSlides = wbm_prod_no_tablet;
                        } else if (windowWidth <= 980) {
                            numberOfProdSlides = wbm_prod_no_laptop;
                        } else if (windowWidth <= 1280) {
                            numberOfProdSlides = wbm_prod_no_desktop;
                        } else {
                            numberOfProdSlides = wbm_prod_no_large_desktop;
                        }

                        var numberOfslideSlides;
                        if (windowWidth <= 480) {
                            numberOfslideSlides = wbm_prod_slide_mobile;
                        } else if (windowWidth <= 736) {
                            numberOfslideSlides = wbm_prod_slide_tablet;
                        } else if (windowWidth <= 980) {
                            numberOfslideSlides = wbm_prod_slide_laptop;
                        } else if (windowWidth <= 1280) {
                            numberOfslideSlides = wbm_prod_slide_desktop;
                        } else {
                            numberOfslideSlides = wbm_prod_slide_large_desktop;
                        }

                        $('.wbm-product-slider-section').each(function () {
                            let autoPlay = $('.wbm-product-slider-section').attr('auto-play');
                            let autoPlaySpeed = $('.wbm-product-slider-section').attr('auto-play-speed');
                            let scrollSpeed = $('.wbm-product-slider-section').attr('scroll-speed');
                            let pauseOnHover = $('.wbm-product-slider-section').attr('pause-hover');
                            let inFiniteLoop = $('.wbm-product-slider-section').attr('infinite-loop');
                            let autoHeight = $('.wbm-product-slider-section').attr('auto-height');
                            let sliderPager = $('input[name="wbm_product_slider_sliders[wbm_prod_pager_status]"]:checked').val();
                            let sliderNav = $('input[name="wbm_product_slider_sliders[wbm_prod_nav_status]"]:checked').val();
                            let slidermode = $('.wbm-product-slider-section').attr('slider-mode');

                            var slidermodestatus;
                            if( 'ticker' === slidermode ){
                                slidermodestatus = true;
                                autoPlay         = 'false';
                            } else {
                                slidermodestatus = false;
                            }
                            
                            initProductSlider = $('.slider-preview-body ul').bxSlider({
                                minSlides: numberOfProdSlides,
                                maxSlides: numberOfProdSlides,
                                moveSlides: numberOfslideSlides,
                                controls: sliderNav === 'true' ? true : false,
                                pager: sliderPager === 'true' ? true : false,
                                auto: autoPlay === 'true' ? true : false,
                                pause: parseInt(autoPlaySpeed),
                                speed: parseInt(scrollSpeed),
                                adaptiveHeight: autoHeight === 'true' ? true : false,
                                autoHover: pauseOnHover === 'true' ? true : false,
                                infiniteLoop: inFiniteLoop === 'true' ? true : false,
                                responsive: true,
                                mouseDrag: wbm_prod_mouse_draggable_status === 'true' ? true : false,
                                touchEnabled: wbm_prod_touch_swipe_status === 'true' ? true : false,
                                slideWidth: 2200,
                                ticker: slidermodestatus,
                                tickerHover: slidermodestatus,
                                useCSS: false,
                                slideMargin: parseInt(wbm_prod_space_between),
                                nextText: sliderNextText.get(0).outerHTML,
                                prevText: sliderPrevText.get(0).outerHTML
                            });
                            if( 'true' === wbm_prod_mousewheel_control_status ){
                                initProductSlider.on('mousewheel', function(e){
                                    e.preventDefault();
                              
                                    if( !initProductSlider.hasClass('dontMove') ) {
                              
                                      if(e.originalEvent.wheelDelta > 0) {
                                        initProductSlider.goToPrevSlide();
                                      } else {            
                                        initProductSlider.goToNextSlide();
                                      }
                              
                                    }
                              
                                })
                            }
                        });
                    }
                }
            }
        });
    }
})(jQuery);

