<?php

namespace BackWPup\ThirdParty;

class SGCachepress implements ThirdPartyInterface {

	/**
	 * {@inheritdoc}
	 *
	 * @param array $excluded_folders
	 *
	 * @return mixed
	 */
	public function exclude_folders( $excluded_folders ) {
		if (
			! is_array( $excluded_folders ) ||
			! self::is_active()
		) {
			return $excluded_folders;
		}
		if (
			defined( 'SiteGround_Optimizer\DIR' ) &&
			! in_array( \SiteGround_Optimizer\DIR, $excluded_folders, true )
		) {
			$excluded_folders[] = \SiteGround_Optimizer\DIR;
		}
		return $excluded_folders;
	}

	/**
	 * {@inheritdoc}
	 *
	 * @param array $excluded_cache_folders
	 *
	 * @return mixed
	 */
	public function exclude_cache_folders( $excluded_cache_folders ) {
		if (
			! is_array( $excluded_cache_folders ) ||
			! self::is_active()
		) {
			return $excluded_cache_folders;
		}
		$file_cacher = new \SiteGround_Optimizer\File_Cacher\File_Cacher();
		if ( ! in_array( $file_cacher->get_cache_dir(), $excluded_cache_folders, true ) ) {
			$excluded_cache_folders[] = $file_cacher->get_cache_dir();
		}
		return $excluded_cache_folders;
	}

	/**
	 * {@inheritdoc}.
	 *
	 * @return bool
	 */
	public static function is_active(): bool {
		return defined( 'SiteGround_Optimizer\VERSION' );
	}

	/**
	 * {@inheritdoc}
	 *
	 * @return void
	 */
	public function init(): void {
		if ( self::is_active() ) {
			add_filter( 'backwpup_exclusion_plugins_folders', [ $this, 'exclude_folders' ] );
			add_filter( 'backwpup_exclusion_plugins_cache_folders', [ $this, 'exclude_cache_folders' ] );
		}
	}
}
