<?php

// Namespace
namespace BMI\Plugin\Uploader;

// Use
use BMI\Plugin\Zipper\BMI_Zipper AS Zipper;

// Exit on direct access
if (!defined('ABSPATH')) exit;

header('Content-Type: application/json; charset=utf-8');
$file = isset($_FILES['file_data']) ? $_FILES['file_data'] : null;
$name = isset($this->post['file_name']) ? $this->post['file_name'] : null;
$total = isset($this->post['file_total']) ? $this->post['file_total'] : 0;
$index = isset($this->post['file_index']) ? $this->post['file_index'] : 0;
$size = isset($this->post['file_size']) ? $this->post['file_size'] : null;
$taskStart = isset($this->post['taskStart']) ? $this->post['taskStart'] : 123;

$info = pathinfo($name);
$ext = isset($info['extension']) ? $info['extension'] : '';

$beforename = $name;
$name = substr($name, 0, -(strlen($ext) + 1));
$noextname = $name;
$file_name = $name . '-' . $taskStart . '.' . $ext;
$newfile = BMI_BACKUPS . '/' . $file_name . '.part'; // Temporary .part file during upload
$afterfile = BMI_BACKUPS . '/' . $beforename;
$url = plugin_dir_url(BMI_ROOT_FILE) . '/backups' . '/' . $file_name;

function jsonMsg($status, $message, $url = '', $afterfile = false) {

  if ($status === 2) {

    require_once BMI_INCLUDES . '/zipper/zipping.php';
    $zipper = new Zipper();
    $manifest = $zipper->getZipFileContent($afterfile, 'bmi_backup_manifest.json');

    if ($manifest === false) {
      @unlink($afterfile);
      $status = 5;
    }

  }

  $arr['status'] = $status;
  $arr['message'] = $message;
  $arr['url'] = $url;

  echo json_encode($arr);
  die();

}

if (!$file || !$name) {

	jsonMsg(0, 'Missing file?');

}

$imgarr = array('zip', 'tar', 'gz');
if (!in_array(strtolower($ext), $imgarr)) {

  jsonMsg(0, 'Invalid file type');

}

function completed($newfile, $noextname, $ext) {

  chmod($newfile, 0755);

  $i = 1;
  $curr_fil = BMI_BACKUPS . '/' . $noextname . '.' . $ext;
  while (file_exists($curr_fil)) {
    $i++;
    $curr_fil = BMI_BACKUPS . '/' . $noextname . '-' . $i . '.' . $ext;
  }
  rename($newfile, $curr_fil);

}

clearstatcache($afterfile);
if (is_file($afterfile) && ($size == filesize($afterfile))) {

  jsonMsg(3, 'File already exists.', $url);

}

if ($file['error'] == 0) {

  if (!file_exists($newfile)) {

    if (!move_uploaded_file($file['tmp_name'], $newfile)) {

      jsonMsg(0, 'Cannot move file');

    }

    if ($index == $total) {

      completed($newfile, $noextname, $ext);
      jsonMsg(2, 'Upload completed', $url, $afterfile);

    }

    jsonMsg(1, 'Uploading');

  }

  if ($index <= $total) {

      $content = file_get_contents($file['tmp_name']);
      if (!file_put_contents($newfile, $content, FILE_APPEND)) {

        jsonMsg(0, 'Cannot write file');

      }

      if ($index == $total) {

        completed($newfile, $noextname, $ext);
        jsonMsg(2, 'Upload completed', $url, $afterfile);

      }

      jsonMsg(1, 'Uploading');
  }

} else {

  jsonMsg(0, 'No file uploaded');

}
