<?php

  // Namespace
  namespace BMI\Plugin\Progress;

  // Use
  use BMI\Plugin\BMI_Logger AS Logger;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

  /**
   * Main File Backup Includable Logs
   */
  class BMI_ZipProgress_Logger {

    public $latest;
    public $progress;
    public $latest_progress;
    public $file;
    public $muted = false;

    public function __construct() {

      if (!file_exists(BMI_BACKUPS)) mkdir(BMI_BACKUPS, 0755, true);

      $this->latest = BMI_BACKUPS . '/latest.log';
      $this->latest_progress = BMI_BACKUPS . '/latest_progress.log';

    }

    public function start($muted = false) {

      $this->muted = $muted;

    }

    public function progress($progress = '0') {

      $this->progress = fopen($this->latest_progress, 'w') or die(__("Unable to open file!", 'backup-backup'));
      fwrite($this->progress, $progress);
      fclose($this->progress);

    }

    public function log($log = '', $level = 'INFO') {

      if (!$this->muted) {
        $this->file = @fopen($this->latest, 'a');
        if ($this->file) {
          if (defined('BMI_CLI_REQUEST') && BMI_CLI_REQUEST === true) {
          $log_string = '[' . strtoupper($level) . '] [' . date('Y-m-d H:i:s') . '] [CLI] ' . $log . "\n";
        } else {
          $log_string = '[' . strtoupper($level) . '] [' . date('Y-m-d H:i:s') . '] ' . $log . "\n";
        }
          @fwrite($this->file, $log_string);
          if (defined('BMI_USING_CLI_FUNCTIONALITY') && BMI_USING_CLI_FUNCTIONALITY === true) {
            echo $log_string;
          }
        }
        @fclose($this->file);
      } else {
        error_log('[' . strtoupper($level) . '] [' . date('Y-m-d H:i:s') . '] ' . $log);
      }

    }

    public function end() {

      return true;

    }

  }
