<?php
add_shortcode( 'ticket-submit', 'wpas_sc_submit_form' );
/**
 * Submission for shortcode.
 */
function wpas_sc_submit_form() {

	global $post;

	/* Start the buffer */
	ob_start();

	/* Open main container */
	?><div class="wpas"><?php

		/**
		 * wpas_before_ticket_submit hook
		 */
		do_action( 'wpas_before_ticket_submit' );

		/**
		 * wpas_frontend_plugin_page_top is executed at the top
		 * of every plugin page on the front end.
		 */
		do_action( 'wpas_frontend_plugin_page_top', $post->ID, $post );

		/* If user is not logged in we display the register form */
		if( !is_user_logged_in() ):

			$registration = wpas_get_option( 'login_page', false );

			if ( false !== $registration && !empty( $registration ) && !is_null( get_post( intval( $registration ) ) ) ) {
				/* As the headers are already sent we can't use wp_redirect. */
				echo '<meta http-equiv="refresh" content="0; url=' . esc_url( get_permalink( $registration ) ) . '" />';
				echo wp_kses(wpas_get_notification_markup( 'info', __( 'You are being redirected...', 'awesome-support' ) ), get_allowed_html_wp_notifications());
				exit;
			}

			wpas_get_template( 'registration' );

		/**
		 * If user is logged in we display the ticket submission form
		 */
		else:

			/**
			 * Redirect to an alternate new ticket form if specified in settings.
			 * But only do so if there is no query string in the url that forces
			 * use of the standard ticket form.
			 * We will be looking for a force_standard_form=1 in the url query string to
			 * see if we should force the standard form to show up.
			 */
			if ( ! empty( wpas_get_option( 'new_ticket_form_redirect_fe', '' ) ) ) {
				if ( 1 <> filter_input( INPUT_GET, 'force_standard_form', FILTER_SANITIZE_NUMBER_INT ) ) {
					wpas_redirect( 'new_ticket_custom_form', wpas_get_option( 'new_ticket_form_redirect_fe', '' ) );
					exit ;
				}
			}

			/**
			 * wpas_before_ticket_submission_form hook
			 */
			do_action( 'wpas_before_ticket_submission_form_before_wrapper' );

			/* Namespace our content */
			echo '<div class="wpas">';

			/**
			 * wpas_before_all_templates hook.
			 *
			 * This hook is called at the top of every template
			 * used for the plugin front-end. This allows for adding actions
			 * (like notifications for instance) on all plugin related pages.
			 */
			do_action( 'wpas_before_all_templates' );

			/**
			 * wpas_before_ticket_submission_form hook
			 */
			do_action( 'wpas_before_ticket_submission_form' );

			/**
			 * Check if the current user is logged in
			 */
			if ( false === is_user_logged_in() ) {

				// translators: %s is the log-in link.
				$x_content = __( 'You need to <a href="%s">log-in</a> to submit a ticket.', 'awesome-support' );
				echo wp_kses(wpas_get_notification_markup( 'failure', sprintf( $x_content, esc_url( '' ) ) ), get_allowed_html_wp_notifications());
			} else {

				/**
				 * Make sure the current user can submit a ticket.
				 */
				if ( false === wpas_can_submit_ticket() ) {
					echo wp_kses(wpas_get_notification_markup( 'failure', __( 'You are not allowed to submit a ticket.', 'awesome-support' ) ), get_allowed_html_wp_notifications());
				}

				/**
				 * Show the actual submission form
				 */
				else {

					/**
					 * We check if the user is authorized to submit a ticket.
					 * User must be logged-in and can't have the capability. If the
					 * user isn't authorized to submit, we return the error message hereafter.
					 *
					 * Basically, admins and agents aren't allowed to submit a ticket as they
					 * need to do it in the back-end.
					 *
					 * If you want to allow admins and agents to submit tickets through the
					 * front-end, please use the filter wpas_agent_submit_front_end and set the value to (bool) true.
					 */
					if ( is_user_logged_in() && current_user_can( 'edit_ticket' ) && ( false === apply_filters( 'wpas_agent_submit_front_end', false ) ) ):

						/**
						 * Keep in mind that if you allow agents to open ticket through the front-end, actions
						 * will not be tracked.
						 */

						// translators: %s is the link to the admin panel.
						$x_content = __( 'Sorry, support team members cannot submit tickets from here. If you need to open a ticket, please go to your admin panel or <a href="%s">click here to open a new ticket</a>.', 'awesome-support' );
						echo wp_kses(wpas_get_notification_markup( 'info', sprintf( $x_content, add_query_arg( array( 'post_type' => 'ticket' ), admin_url( 'post-new.php' ) ) ) ), get_allowed_html_wp_notifications());

					/**
					 * If the user is authorized to post a ticket, we display the submit form
					 */
					else:

						global $post;

						/**
						 * wpas_submission_form_before hook
						 *
						 * @since  3.0.0
						 */
						do_action( 'wpas_submission_form_before' );

						wpas_get_template( 'submission' );

						/**
						 * wpas_submission_form_after hook
						 *
						 * @since  3.0.0
						 */
						do_action( 'wpas_submission_form_after' );

					endif;
				}
			}

			/**
			 * wpas_after_ticket_submission_form hook
			 */
			do_action( 'wpas_after_ticket_submission_form' );

			echo '</div>';

		endif;

		/**
		 * wpas_after_ticket_submit hook
		 */
		do_action( 'wpas_after_ticket_submit' ); ?>

	</div>

	<?php
	/* Get buffer content */
	$sc = ob_get_contents();

	/* Clean the buffer */
	ob_end_clean();

	/* Return shortcode's content */
	return $sc;

}
