<p><?php echo __( 'View a full changelog on <a href="https://wordpress.org/plugins/awesome-support/#developers">WordPress.org</a>', 'awesome-support' );?></p>

<div class="changelog">

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.3.6</h1>
				<h3>6.3.6 Revised plugin deactivation process with feedback.</h3>
				<ul>
					<li>Fix vulnerable issue of PHP Object Injection.</li>
					<li>Create a Get Help button to reach out to Support (Free and Premium).</li>						
				</ul>
			</div>
		</div>
	</div>

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.3.5</h1>
				<h3>6.3.5 Revised plugin deactivation process with feedback.</h3>
				<ul>
					<li>We improved the cache admin menu ticket count.</li>
					<li>New feature to support custom file type such as "*.k" and "*.dyn".</li>	
					<li>New feature to set the Maximum Lenght in the subject of ticket on Submit Ticket Form of front-end.</li>
					<li>We fixed Bug in load more ticket replies interface.</li>
					<li>New feature to allow embed images on Email notifications when replying.</li>
					<li>Fix vulnerable issue</li> 
				</ul>
			</div>
		</div>
	</div>

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.3.4</h1>
				<h3>6.3.4 Revised plugin deactivation process with feedback.</h3>
				<ul>
					<li>We improved the Wordpress Editor 'Zoom In, Zoom out' feature.</li>
					<li>New feature to export the Reports and statiscs data in csv, graphs and pdf.</li>	
					<li>We improved the tutorial process when user setups the plugin first time.</li>	
				</ul>
			</div>
		</div>
	</div>

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.3.3</h1>
				<h3>6.3.3 Revised plugin deactivation process with feedback.</h3>
				<ul>
					<li>We fixed Bug ticket reply from cron job (IMAP ADDON).</li>
					<li>We fixed the compatibility with Wordpress version 6.8.</li>					
				</ul>
			</div>
		</div>
	</div>

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.3.2</h1>
				<h3>6.3.2 Revised plugin deactivation process with feedback.</h3>
				<ul>
					<li>We fixed vulnerability Issue with ticket folder.</li>
				</ul>
			</div>
		</div>
	</div>

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.3.1</h1>
				<h3>6.3.1 Revised plugin deactivation process with feedback.</h3>
				<ul>
					<li>We updated the plugin deactivation process when you deactivate the plugin and submit a feedback.</li>
					<li>We fixed issue of HTML Formatting Lost in Email Settings After Saving.</li>
					<li>We fixed issue of Crashing site with an infinite loop</li>
					<li>We fixed the JavaScript error that appears when the user moves the browser window.</li>
					<li>We changed the column name from "creation date" to "last modified".</li>
					<li>We fixed the conflict issue of Company Profile and Canned Responses add-ons.</li>
					<li>Fix Bug for Nested Departments.</li>					
				</ul>
			</div>
		</div>
	</div>
	
	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.3.0</h1>
				<h3>6.3.0 Update General Rules and Improve Security, Performance, and Accessibility</h3>
				<ul>
					<li>We updated general rules and improve security, performance, and accessibility in the plugin.</li>
				</ul>
			</div>
		</div>
	</div>

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.2.3</h1>
				<h3>6.2.3 Updating security rules for multiple files upload</h3>
				<ul>
					<li>We updates security rules tmultiple files upload.</li>
				</ul>
			</div>
		</div>
	</div>

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.2.2</h1>
				<h3>6.2.2 Updating security rules for form upload via AJAX</h3>
				<ul>
					<li>We updates security rules to allow form upload via AJAX.</li>
				</ul>
			</div>
		</div>
	</div>

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.2.1</h1>
				<h3>6.2.1 We fixed the issue with the user search</h3>
				<ul>
					<li>We updates security rules to allow the user search.</li>
				</ul>
			</div>
		</div>
	</div>

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.2.0</h1>
				<h3>6.2.0 We fixed security vulnerabilities in all the plugin</h3>
				<ul>
					<li>We fixed various security vulnerabilities across all our plugins, enhancing overall protection through improved validation and sanitization.</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.1.11</h1>
				<h3>6.1.11 includes the vulnerabilities fix and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">					
					<li>We implement a CSRF protection (via a nonce) in the endpoints wpas_dismiss_free_addon_page and wpas_skip_wizard_setup.</li>										
				</ul>
			</div>
		</div>
	</div>

	<hr />	
	
	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.1.10</h1>
				<h3>6.1.10 includes the vulnerabilities fix and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">					
					<li>We fixed the vulnerability where a subscriber role could have the ability to skip the "Awesome Support: First Time Install" banner process in the admin+ dashboard.</li>										
				</ul>
			</div>
		</div>
	</div>

	<hr />	
	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.1.9</h1>
				<h3>6.1.9 includes the vulnerabilities fix and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">					
					<li>We fixed when the agent was not able to choose a user when changing the ticket creator field.</li>										
				</ul>
			</div>
		</div>
	</div>

	<hr />	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.1.8</h1>
				<h3>6.1.8 includes the 3 vulnerabilities fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">					
					<li>Authenticated (Subscriber+) SQL Injection.</li>	
					<li>Missing Authorization via wpas_get_users() function.</li>	
					<li>Missing Authorization via editor_html() function.</li>						
				</ul>
			</div>
		</div>
	</div>

	<hr />	
	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.1.7</h1>
				<h3>6.1.7 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">					
					<li>Fix: We fixed high priority vulnerabilities to keep the plugin safe and up to date.</li>										
				</ul>
			</div>
		</div>
	</div>

	<hr />
	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.1.6</h1>
				<h3>6.1.6 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">					
					<li>Fix: We applied several security patches to improve the plugin security.</li>										
				</ul>
			</div>
		</div>
	</div>

	<hr />
	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.1.5</h1>
				<h3>6.1.5 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">					
					<li>Fix: Patched security issues to keep the plugin secure.</li>
					<li>Fix: We solved the error messages when saving ticket settings.</li>
					<li>Fix: It was not possible to upload multiple files with the drag and drop uploader.</li>							
				</ul>
			</div>
		</div>
	</div>

	<hr />
	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.1.4</h1>
				<h3>6.1.4 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">					
					<li>Fix: We fixed an issue with the Email Support add-on and the Piping Subject Link.</li>
					<li>Fix: The Admin could not pull custom fields data, now it's possible.</li>
					<li>Fix: We fixed the role for users on the admin ticket list.</li>
					<li>Fix: Fixed deprecated errors from PHP 8.1 and 8.2</li>
					<li>Fix: We now display a horizontal scroll bar when ticket content is wider than the display element.</li>
					<li>Fix: An E_ERROR message was fixed.</li>
					<li>Fix: If I upload a file to a ticket with the character “#” on the filename, the file won’t load.</li>					
				</ul>
			</div>
		</div>
	</div>

	<hr />
	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.1.3</h1>
				<h3>6.1.3 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">					
					<li>New: Add attachments when you print tickets. You can enable or disable this option on the print screen.</li>
					<li>Tweak: We updated the assigned agent field, in the ticket details page in the back end to a select and search field. This is useful when there are hundreds of agents in the list.</li>
					<li>Fix: Fixed Deprecated error message.</li>
					<li>Fix: We fixed some warning messages for PHP 8.0.</li>
					<li>Fix: Solved Warning and Deprecated messages related that affect the Public Tickets add-on in PHP 8.0.</li>
					<li>Fix: We fixed a warning message when activating the E-mail Support add-on.</li>
					<li>Fix: We fixed a security vulnerability in the login fields.</li>
					<li>Fix: We did some security fixes to keep the plugin safe and stable.</li>
					<li>Fix: We fixed when using a command line task that generates multiple notice messages.</li>
					<li>Fix: Solved an Undefined array key warning message that shows to some users.</li>
					<li>Fix: When deactivating the plugin with add-ons activated, it crashed websites. From now, this won't happen, you can deactivate the plugin with the add-ons activated and the site won't crash.</li>	
				</ul>
			</div>
		</div>
	</div>

	<hr />
	
	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.1.2</h1>
				<h3>6.1.2 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">					
					<li>Fix: Fixed security vulnerability</li>					
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.1.1</h1>
				<h3>6.1.1 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>Fix: When activating Client tickets add-on with Version 6.1.0 SHOW EMPTY notice</li>
					<li>Fix: Fixed security vulnerability</li>
					<li>Fix: Errors when Awesome Support and WooCommerce are Enabled on PHP version 8.x</li>
					<li>Fix: Conflict with Email Support Add-on</li>
					<li>Fix: SSL verify throw warnings</li>
					<li>Fix: Registration form did not remember completed fields. Now these fields are saved properly</li>
					<li>New Feature: You can show the image attached on the ticket, in the print file.</li>
					<li>Fix: Now all the ticket with the "Awaiting for Reply" status filter are displayed </li>
					<li>Fix: Fixed login issue with the Guest tickets add-on on PHP 8.0</li>
					<li>Fix: fileinfo.dll extension not enable on server caused Drap-dop file not working</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />
	
	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.1.0</h1>
				<h3>6.1.0 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>Fix: 3984879 - GAS conflict with Download Monitor (Plugin)</li>
					<li>Fix: 3946543 - Error occurs when applying Close Filter</li>
					<li>Fix: 3862319 - Backslashes lost in Ticket body</li>
					<li>Fix: 3919242 - JS deprecated messages</li>
					<li>Fix: It's not possible to edit a ticket submission or reply in the back end.</li>
					<li>Fix: Reset filter button </li>
					<li>Fix: Invalid ticket ID a tag url in list</li>
					<li>Fix: Stability vulnerability</li>
					<li>Fix: 652: Arbitrary expressions in empty are allowed in PHP 5.5 only</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.0.14</h1>
				<h3>6.0.14 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>Fix: Fixed security vulnerability</li>
					<li>Fix: Fixed Error message format</li>
					<li>Fix: Fixed Tutorial message format</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.0.13</h1>
				<h3>6.0.13 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>Fix: Fixed security vulnerability</li>
					<li>Fix: Fixed custom fields check box issuee</li>
					<li>Fix: Fixed Mail Editor Problem</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.0.12</h1>
				<h3>6.0.12 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>Fix: Fixed security vulnerability</li>
					<li>
						This version won't work with older versions of the listed add-ons
						<br />
						<ol>
							<li>Awesome Support: Agent Front-end</li>
							<li>Awesome Support: Auto Close</li>
							<li>Awesome Support: Company Profiles</li>
							<li>Awesome Support: Documentation & Knowledgebase</li>
							<li>Awesome Support: E-Mail Support</li>
							<li>Awesome Support: FAQ</li>
							<li>Awesome Support: Issue Tracking</li>
							<li>Awesome Support: Service Level Agreements</li>
							<li>Awesome Support: Smart Replies Powered by AI and Machine Learning</li>
							<li>Awesome Support: Tasks and Todos</li>
						</ol>
					</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.0.11</h1>
				<h3>6.0.11 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>Fix: Fixed security vulnerability</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.0.10</h1>
				<h3>6.0.10 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>Fix: Fixed reply vulnerability</li>
					<li>Fix: Fixed typo in agent_last_name</li>
					<li>New: Added translate Ticket Type</li>
					<li>New: Added msg file type to allow upload attachment</li>
					<li>New: Updated Bootstrap4Themes</li>
					<li>Fix: Fixed Urgent security vulnerability</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.0.9</h1>
				<h3>6.0.9 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>Fix: Fixed Urgent security vulnerability vendor</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.0.8</h1>
				<h3>6.0.8 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>Fix: Fixed Urgent security vulnerability</li>
					<li>Fix: Fixed user permissions for close_ticket</li>
					<li>Fix: Fixed check the header hasn't been sent for calling session_set_save_handler()</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.0.7</h1>
				<h3>6.0.7 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>Fix: Fixed Urgent security vulnerability</li>
					<li>Fix: Fixed ticket filters in the portrait mobile view</li>
					<li>Fix: Fixed Vulnerability Reflected Cross-Site Scripting on load preview</li>
					<li>Fix: Unslash content before display</li>
					<li>Custom code request for the wp_editor</li>
					<li>Fix: Fixed redeclare formatbytes method</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.0.6</h1>
				<h3>6.0.6 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>Fix: Fixed get users with include and exclude args</li>
					<li>Fix: Typo fix: correct "rely" to "reply" in email templates</li>
					<li>Bump path-parse from 1.0.6 to 1.0.7</li>
					<li>Bump hosted-git-info from 2.8.8 to 2.8.9</li>
					<li>Fix: Fixed not possible to edit ticket in the back end</li>
					<li>Fix: Fixed corrupted files when downloading attachments</li>
					<li>Fix: Mobile view optimisation</li>
					<li>Fix: Fixed IDOR Vulnerability</li>
					<li>Fix: Fixed custom field validation error message.</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.0.5</h1>
				<h3>6.0.5 includes maintenance fixes and security patches. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>Fix: Fixed illegal offset type message on the ticket list</li>
					<li>Fix: Fixed a backslash showing when should not in emails</li>
					<li>Fix: Session Manager fix</li>
					<li>Fix: Correction of Product Sync</li>
					<li>Fix: Security update applied</li>
				</ul>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 6.0</h1>
				<h3>6.0 includes a few changes to the rest api, updates to a new version of the Gas Framework to 1.12.0 and more. Here is a more comprehensive list:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>New: Ticket Types</li>
					<li>New: Integration with myCRED</li>
					<li>New: Five more theme overlays</li>
					<li>New: A notifications button that can be hooked into by add-ons</li>
					<li>New: Option to redirect the standard ticket form to another page</li>
					<li>Enh: Choose which product statuses should be synced with Awesome Support</li>
					<li>Tweak: Added schemas to some REST API routes that did not have them</li>
					<li>Tweak: Updated the Gas Framework library that is used internally to manage settings - using version 1.12.1 now</li>
					<li>Tweak: Updated the session manager library that is used internally to manage sessions - using version 4.2.0 now</li>
					<li>Bug fixes related to stylesheets, autodelete of attachments, file-uploader and more</li>
					<li>Internal and developer related changes including the introduction of more than 20 new filters and action hooks</li>
				</ul>
				<p>Read all about these changes on our website: <a href="https://getawesomesupport.com/coming-in-early-2019-awesome-support-v-5-9-0/">What's New In Version 6.0</a> </p>
			</div>
		</div>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 5.8</h1>
				<h3>5.8 Introduces a number of new changes, tweaks and fixes! Among them are the following:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>The Awesome Support REST API is now integrated into the core. Turn it on using the new settings tab in TICKETS->SETTINGS->REST API</li>
					<li>Add new tab on privacy screen to submit a request to export ALL system data to the admin (not just tickets)</li>
					<li>Replace icon images on ticket screen in wp-admin with a true icon file - helps scale up properly on higher resolution screens</li>
					<li>Added the concept of an OVERLAY to the AS theme</li>
					<li>Added four overlays - "Subtle", "Angle", "Dark" and "Orange"</li>
					<li>More than a half dozen tweaks related to CSS, Add-ons and Licensing</li>
					<li>Bug fixes related to editing replies, drag-and-drop uploads and more</li>
					<li>Internal and developer related changes</li>
				</ul>
				<p>Read all about these changes on our website: <a href="https://getawesomesupport.com/coming-soon-in-awesome-support-5-8/">What's New In Version 5.8</a> </p>
			</div>
		</div>
	</div>

	<hr />

<div>
	<h2>Maintenance Releases since 5.5.0</h2>
	<p><b>Version 5.7.1</b> includes a couple of bug fixes for editing the opening ticket post and rendering the privacy popup. </p>
	<p><b>Version 5.7.0</b> includes minor enhancements to the privacy popups, a new settings option for auto-deleting attachments, some bug fixes and some new dev related filters. </p>
	<p><b>Version 5.6.0</b> includes a new check to prevent users from receiving duplicate alerts, another for a user-name fix, added four phone number fields to the user profile screen and includes a new function for internal use.</p>
	<p><b>Version 5.5.1</b> includes two bug fixes - one for a cron issue and another for better handling of attachments with empty replies. </p>
</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 5.5</h1>
				<h3>5.5 Introduces a number of new changes, tweaks and fixes! Among them are the following:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>New designs for the six core email alerts</li>
					<li>Email template sets</li>
					<li>Printing enhancements</li>
					<li>A NEW registration type: Moderated Registration</li>
					<li>Drag-and-drop attachments </li>
					<li>Paste images as attachments </li>
					<li>GDPR and privacy related enhancements </li>
					<li>Improved audit trails </li>
					<li>Options for automatically and manually deleting attachments </li>
					<li>New email template tags  </li>
					<li>UI changes in the settings area (new tabs for fields and permissions)  </li>
					<li>Bug Fixes  </li>
					<li>Internal and developer related changes  </li>
				</ul>
				<p>Read all about these changes on our website: <a href="https://getawesomesupport.com/awesome-support-5-5-0-new-and-enhanced-features/">What's New In Version 5.5</a> </p>
			</div>
		</div>
	</div>

	<hr />

	<div>
		<h2>Minor Releases Between 5.0.0 and 5.5.0</h2>
		<p><b>Version 5.1.1</b> Fixes a remote notification issue that left a blank strip across the top of the admin panel with no way to turn it off, added some GDPR related license disclosures and tweaked an internal filter. </p>
		<p><b>Version 5.1.0</b> Introduced a new on-boarding process wizard so that new users can get started quickly and added an option for the admin to set a default role for new users who register using our standard registration form. </p>
	</div>

	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 5.0</h1>
				<h3>5.0 Introduces dozens of new changes, tweaks and fixes! Among them are the following:</h3>
				<ul style="padding-left: 3em; list-style-type: disc;">
					<li>UI and UX Changes </li>
					<li>User Registration Enhancements </li>
					<li>GDPR Related Enhancements </li>
					<li>Email Template Tags Usability Enhancements </li>
					<li>New System Configuration Options </li>
					<li>Internal Architecture and Code Changes  </li>
					<li>Bug Fixes  </li>
				</ul>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<h2>UI and UX Changes: New Ticket Toolbar</h3>
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v500/AS-440-ReleaseNotes-01.jpg" alt="UI and UX Changes">
				<p><b>New:</b> We Introduced an icon toolbar at the top of the individual ticket view in the backend.</p>
			</div>
		</div>
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<h2>UI and UX Changes: New Ticket Tabs</h3>
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v500/AS-440-ReleaseNotes-02.jpg" alt="Metaboxes closer to ticket as tabs">
				<p><b>New:</b> We moved some of the metaboxes closer to the ticket as tabs. In particular you no longer have to scroll down to view custom fields – they are now right next to the ticket info, more easily accessible via a tab.</p>
			</div>
		</div>

		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<h2>UI and UX Changes: New Reply Icons</h3>
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v500/AS-440-ReleaseNotes-04.jpg" alt="Reply icons instead of links on hover">
				<p><b>New:</b> Hovering over a reply will show icons instead of links. This helps when you have a lot of add-ons installed where the links were just messy.</p>

			</div>
		</div>
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<h2>UI and UX Changes: New Reply Tabs</h3>
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v500/AS-440-ReleaseNotes-05.jpg" alt="New reply area tabs">
				<p><b>New:</b> Attachments, FAQ and similar tabs are now right next to the reply in tabs so you don’t have to scroll down to get to them.</p>
			</div>
		</div>
	</div>

	<hr />
	<div class="about-body">
		<h1>New Custom Fields Layout</h1>
		<br />
		<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v500/AS-440-ReleaseNotes-03.jpg" alt="New Custom Fields Layout">
		<p><b>Multi-column custom fields layout:</b> Version 5 introduces a new custom fields layout tab on the back-end. On large screens you get three columns for the fields. On medium sized screens you get two columns and on small screens you go back to one column.</p>
	</div>

	<hr />
	<div class="about-body">
		<h1>User Registration Changes</h1>
	</div>

	<div class="row">
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<h2>Registration: New User Notifications</h3>
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v500/AS-440-ReleaseNotes-09.jpg" alt="Registration Alerts">
				<p><b>New:</b> Control who will receive the default WordPress notification emails when a new user registers for support.</p>
			</div>
		</div>
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<h2>Registration: Field Descriptions</h3>
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v500/AS-440-ReleaseNotes-11.jpg" alt="Registration Field Descriptions">
				<p><b>New:</b> You can now add a description to each registration field which will show up underneath the field.  You can use these to indicate how the data will be used, helping you to meet your GDPR obligations.</p>

			</div>
		</div>

		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<h2>Registration: User Name Construction</h3>
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v500/AS-440-ReleaseNotes-10.jpg" alt="User name construction options">
				<p><b>New:</b> You can now control how the user name is generated when a new user registers. You can choose from seven options.</p>
			</div>
		</div>
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<h2>Registration: New Configurable Checkboxes</h3>
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v500/AS-440-ReleaseNotes-12.jpg" alt="New reply area tabs">
				<p><b>New:</b> For certain GDPR scenarios you must get explicit consent.  These three new checkboxes allow you to meet those needs and obligations.</p>
			</div>
		</div>
	</div>

	<hr />
	<div class="about-body">
		<h1>Other Changes</h1>
	</div>

	<div class="row">
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v400/numerous_smaller_enhancements.jpg" alt="Numerous smaller Enhancements">
				<h3>Numerous Smaller Enhancements</h3>
				<p><b>New:</b> Change the location of the core Awesome Support log files. </p>
				<p><b>New:</b> Control the page the user sees after logging out of the support system. </p>
				<p><b>New:</b> Control the page the user is directed to after submitting a new ticket. For example they could be redirected to a thank you page, an FAQ page or a SELF HELP page. </p>
				<p><b>New:</b> Integrate our new importer so make it more seamless when working with your HELPSCOUT, TICKSY or ZENDESK data.</p>
				<p><b>New:</b> Configure that product slug directly inside the standard configuration screens - helps with multisite installs that need to change this slug for each site.</p>
				<p> Many more! <a href="https://getawesomesupport.com/coming-soon-awesome-support-4-4-0-5-0-0/" target="_blank">Read the entire change log</a>.</p>
			</div>
		</div>
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v400/fixes.jpg" alt="Multiple bug fixes">
				<h3>And, Of Course, Multiple Bug Fixes</h3>
				<p><b>Fix:</b> Status filter on front-end was showing statuses commingled with PRIORITY when the priority field was enabled.</p>
				<p><b>Fix:</b> Tickets were not going to INPROCESS under certain circumstances. .</p>
				<p><b>Fix:</b> Make radio button custom field labels clickable.</p>
				<p><b>Fix:</b> WooCommerce 3.x styles stepped all over some of AS styles on AS pages.</p>
				<p><b>Fix:</b> Make sure that users with the administer_awesome_support capability can see an accurate ticket count of all tickets at various locations in the plugin.</p>
				<p><b>Fix:</b> Replace the get_the_author_meta function calls with get_user_option for better multi-site compatibility.</p>
				<p> Many more! <a href="https://getawesomesupport.com/coming-soon-awesome-support-4-4-0-5-0-0/" target="_blank">Read the entire change log</a>.</p>
			</div>
		</div>
	</div>

	<hr />
	<div>
		<h1>Minor Releases Between 4.0.0 and 5.0.0</h1>
		<p><b>Version 4.3.5</b> fixed a color-picker issue that popped up on WP 4.9 and added a compatiblity layer for the DIVI theme.</p>
		<p><b>Version 4.3.4</b> removed some old javascript queuing calls and fixed a few incorrect text-domain references.</p>
		<p><b>Version 4.3.3</b> fixed issues with logging, taxonomy custom fields and added a few new filters for use by developers.   </p>
		<p><b>Version 4.3.2</b> addressed some urgent security issues, tweaked our ongoing implementation of bootstrap 4 and addressed some minor grammar issues.  </p>
		<p><b>Version 4.3.1</b> fixed some urgent issues related to the changes we made for handling last reply dates in 4.3.0, added quick-start instructions and addressed some issues related to our ongoing implementation of bootstrap 4.  </p>
		<p><b>Version 4.3.0</b> added new attributes to custom fields to take advantage of bootstrap 4 and fixed an urgent issue related to some add-ons.</p>
		<p><b>Version 4.2.0</b> added options and related developer filters for cleaning up session transients, improved ticket filtering speed for certain filters and added options to control viewing tabs at the top of the ticket list among other fixes and improvements.</p>
	</div>
	<hr />

	<div class="row">
		<div>
			<div class="about-body">
				<h1>What's New In 4.0</h1>
				<h2>Improved Ticket List And Ticket Management</h2>
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/AS-V400-WhatsNew-TicketList-01.png" alt="Improved Ticket List">
				<p>Version 4 introduces <b>pre-configured custom fields</b> for tracking Priorities, Channels (the source of your tickets), additional agents, third parties and more!</a>.</p>
				<p><b>Sorting and filtering</b> options are substantially improved.  Now, 95% of the columns on the screen can be used for sorting and filtering.</p>
				<p>It is easier than ever to manage large volumes of tickets - Awesome Support now scales from a single person operation to the largest enterprises.</p>
				<p><b>Assign up to two additional agents</b> to each ticket without losing the flexibility to transfer tickets to any agent.</p>
			</div>

			<div class="about-body">
				<h2>NEW: Time Tracking</h2>
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/AS-V400-WhatsNew-TimeTracking-01.png" alt="New - Basic Time Tracking">
				<p><b>Basic time tracking</b> at the ticket level is now available. Agents can enter the total time they spent on a ticket along with any adjustments and time related notes.</a>.</p>
				<p>Time columns can optionally be added to the primary ticket list view.</p>
				<p>Advanced automatic and manual time-tracking down to the reply level is supported via add-ons.</p>
				<p><a href="https://getawesomesupport.com/documentation/awesome-support/admin-basic-time-tracking/" target="_blank">Read the documentation</a></p>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v400/custom_field_enhancement_green.jpg" alt="Custom Fields Enhancements">
				<h3>Custom Fields Enhancements</h3>
				<p><b>New:</b> Admin Only Fields (Finally!)</p>
				<p><b>New:</b> Read Only Fields.</p>
				<p><b>New:</b> Control over where fields show up in the ticket in the admin panel.</p>
				<p><b>New:</b> Control over how the fields are displayed.</p>
				<p><b>New:</b> Custom taxonomy fields now have options for individual <em>capabilities</em>.</p>
			</div>
		</div>
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v400/Security.jpg" alt="Security Enhancements">
				<h3>Security Enhancements</h3>
				<p><b>New:</b> 19 additional WordPress capabilities.</p>
				<p><b>New:</b> Granular control over who can view all tickets.</p>
				<p><b>New:</b> Granular control over who can view unassigned tickets created by the email add-on.</p>
				<p><b>New:</b> Granular control over who can view your license information in the license tab. </p>
				<p><b>New:</b> Granular control over all pre-installed taxonomies such as priorities, products and departments. </p>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v400/numerous_smaller_enhancements.jpg" alt="Numerous smaller Enhancements">
				<h3>Numerous Smaller Enhancements</h3>
				<p><b>New:</b> Additional options for the ticket URL/SLUG </p>
				<p><b>New:</b> Add ticket ID column to front end ticket list .</p>
				<p><b>New:</b> New options to control where an agent ends up after replying to a ticket (next ticket, previous ticket).</p>
				<p><b>New:</b> Additional action and filter hooks for developers.</p>
				<p> Many more! <a href="https://getawesomesupport.com/major-core-update-4-0-0/" target="_blank">Read the entire change log</a>.</p>
			</div>
		</div>
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/v400/fixes.jpg" alt="Multiple bug fixes">
				<h3>And, Of Course, Multiple Bug Fixes</h3>
				<p>Clean up some PHP notices.</p>
				<p>When the agent selected "Back to List" for their "after reply" action in their personal profile, this action did not work.</p>
				<p>Updated default styles on checkbox and radio button custom fields.</p>
				<p>Product syncing is now more reliable.</p>
				<p> Many more! <a href="https://getawesomesupport.com/major-core-update-4-0-0/" target="_blank">Read the entire change log</a>.</p>
			</div>
		</div>
	</div>

	<div class="row">
		<div>
			<div class="about-body">
				<h2>Release Notes For Version 3.0</h2>
			</div>
		</div>
	</div>


	<div class="row">
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/about-cf.png" alt="Improved Custom Fields">
				<h3>Improved Custom Fields</h3>
				<p>This feature lets your tailor your support system to your needs, allowing you to <mark>add more fields to the ticket submission form</mark>.</p>
				<p>Since version 3.1.2, custom fields become much more powerful. They are simpler to use, and many more field types are available: checkbox, email, number, radio, text, and much more. Find all the available field types in <a href="https://getawesomesupport.com/documentation/awesome-support/custom-fields/" target="_blank">the documentation</a>.</p>
			</div>
		</div>
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/about-autoassign.png" alt="Auto-Assignment">
				<h3>Auto-Assignment</h3>
				<p>Awesome Support comes with an "intelligent" ticket assignment system. New tickets are automatically assigned to the agent with the least open tickets.</p>
				<p>But you can also <mark>enable/disable the auto-assignation for specific users</mark> (for instance a site administrator).</p>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/about-multipleforms.png" alt="Multiple Submission Forms">
				<h3>Multiple Submission Forms</h3>
				<p>You can now create multiple submission forms for your users and pre-set values for each field. Need a for for your technical support? Create a new one and link it with the correct URL parameter to pre-populate the "type" field. More in the documentation.</p>
			</div>
		</div>
		<div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
			<div class="about-body">
				<img src="<?php echo esc_url( WPAS_URL ); ?>assets/admin/images/about-translations.png" alt="Translated in many languages">
				<h3>Translated in many languages</h3>
				<p>Thanks to our contributors, the plugin is available in several languages. Currently the plugin is <mark>available in nearly 10 languages</mark>.</p>
				<p>To check out available translations, please visit <a href="https://getawesomesupport.com/documentation/awesome-support/translations/" target="_blank">our POEditor.com project list</a>.</p>
			</div>
		</div>
	</div>

</div>