<?php
/**
 * Plugin Name:           AutomatorWP - H5P integration
 * Plugin URI:            https://automatorwp.com/add-ons/h5p/
 * Description:           Connect AutomatorWP with H5P.
 * Version:               1.0.1
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-h5p-integration
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          5.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\H5P
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Integration_H5P {

    /**
     * @var         AutomatorWP_Integration_H5P $instance The one true AutomatorWP_Integration_H5P
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Integration_H5P self::$instance The one true AutomatorWP_Integration_H5P
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Integration_H5P();
            
            if( ! self::$instance->pro_installed() ) {

                self::$instance->constants();
                self::$instance->includes();
                
            }

            self::$instance->hooks();
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_H5P_VER', '1.0.1' );

        // Plugin file
        define( 'AUTOMATORWP_H5P_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_H5P_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_H5P_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_H5P_DIR . 'includes/triggers/complete-content.php';

            // Includes
            require_once AUTOMATORWP_H5P_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_H5P_DIR . 'includes/functions.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'h5p', array(
            'label' => 'H5P',
            'icon'  => plugin_dir_url( __FILE__ ) . 'assets/h5p.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'H5P_Plugin' ) ) {
            return false;
        }

        return true;

    }

    /**
     * Check if the pro version of this integration is installed
     *
     * @since  1.0.0
     *
     * @return bool True if pro version installed
     */
    private function pro_installed() {

        if ( ! class_exists( 'AutomatorWP_H5P' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Integration_H5P instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Integration_H5P The one true AutomatorWP_Integration_H5P
 */
function AutomatorWP_Integration_H5P() {
    return AutomatorWP_Integration_H5P::instance();
}
add_action( 'automatorwp_pre_init', 'AutomatorWP_Integration_H5P' );
