<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Asgaros_Forum\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax function for selecting forums
 *
 * @since 1.0.0
 */
function automatorwp_asgaros_forum_ajax_get_forums() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';

    $results = array();

    // Get the forums
    $forums = automatorwp_asgaros_forum_get_forums();

    foreach( $forums as $forum ) {
        $results[] = array(
            'id' => $forum['id'],
            'text' => $forum['name'],
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_get_ajax_results_option_none( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_asgaros_forum_get_forums', 'automatorwp_asgaros_forum_ajax_get_forums', 5 );

/**
 * Ajax function for selecting topics
 *
 * @since 1.0.0
 */
function automatorwp_asgaros_forum_ajax_get_topics() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';

    $results = array();

    // Get the topics
    $topics = automatorwp_asgaros_forum_get_topics( );

    foreach( $topics as $topic ) {
        $results[] = array(
            'id' => $topic['id'],
            'text' => $topic['name'],
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_get_ajax_results_option_none( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_asgaros_forum_get_topics', 'automatorwp_asgaros_forum_ajax_get_topics', 5 );