!function(t){"use strict";let e=document.createElement("template");e.innerHTML=`
        <style>
            :host {                             
                display: block;  
                width: 100%;      
                contain: content;
            }

            :host([hidden]) {
                display: none;
            }

            :host([ratio="auto"]) {
                position: absolute;
                inset: 0;
                height: 100%;
            }

            #root {
                display: block;
                background-position: center center;
                background-repeat: no-repeat;
                background-size: cover;
                cursor: pointer;
                line-height: 1.5;
                font-size: 16px;
            }

            :host([ratio="auto"]) #root {
                position: absolute;
                inset: 0;
                width: 100%;
                height: 100%;
            }

            :host:not([ratio="auto"]) #root {      
                position: relative;
                padding-bottom: 56.25%;
                width: 100%;
                height: 0;
            }
        
            iframe {
                position: absolute;
                inset: 0;
                z-index: 1;
                border: 0;
                width: 100%;
                height: 100%;                   
            }        

            #play-button {
                display: block;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate3d(-50%, -50%, 0); 
                transition: all 0.2s cubic-bezier(0, 0, 0.2, 1); 
                z-index: 1;
                border: 0;        
                background: center/72px 48px no-repeat url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 72 48'%3E%3Cpath fill='%23f00' fill-opacity='.9' d='M66.5 7.7c-.8-2.9-2.5-5.4-5.4-6.2C55.8.1 34 0 34 0S12.2.1 6.9 1.6c-3 .7-4.6 3.2-5.4 6.1a89.6 89.6 0 000 32.5c.8 3 2.5 5.5 5.4 6.3C12.2 47.9 34 48 34 48s21.8-.1 27.1-1.6c3-.7 4.6-3.2 5.4-6.1C68 35 68 24 68 24s0-11-1.5-16.3z'/%3E%3Cpath fill='%23fff' d='M45 24L27 14v20'/%3E%3C/svg%3E");
                cursor: pointer;
                width: 72px;
                height: 48px;
                filter: grayscale(1);   
            }       
            
            #root:hover > #play-button,
            #play-button:focus {
                filter: none;
            }

            /* Cookie consent */
            #cookieconsent-modal {  
                box-sizing: border-box;
                display: none;
                position: absolute; 
                top: 50%;
                left: 50%;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                gap: 0.75em;  
                transform: translate3d(-50%, -50%, 0);
                z-index: 1;
                border-radius: 3px; 
                background: rgba(0, 0, 0, 0.7);
                padding: 1em;
                width: 90%;
                max-width: 640px;            
                color: #fff;
            }
            
            #cookieconsent-button {
                display: block;
                margin: 0;
                border: 0;
                border-radius: 3px;  
                background: #e70808;
                cursor: pointer; 
                padding: 0.5em 1em;   
                color: #fff; 
            }

            #cookieconsent-button:hover,
            #cookieconsent-button:focus {
                background: #fff;
                color: #333;
            }

            #root.cookieconsent {
                cursor: unset;
            }

            #root.cookieconsent > #play-button {
                display: none;
            }

            #root.cookieconsent > #cookieconsent-modal {
                display: flex;            
            }

            @media only screen and (max-width: 480px) {
                #cookieconsent-modal {
                    width: 100%;
                    height: 100%;
                    font-size: 90%;
                }
            }

            @media only screen and (max-width: 320px) {
                #cookieconsent-modal {
                    gap: 0.5em;
                }

                #cookieconsent-button {
                    border-radius: 2px;  
                    padding: 0.35em 0.75em;   
                }
            }

            /* Post-click styles */
            #root.initialized {
                cursor: unset;
            }

            #root.initialized > #play-button,
            #root.initialized > #cookieconsent-modal {            
                display: none;
            }
        </style>
        <div id="root" part="root">
            <button type="button" id="play-button" aria-label="Play Video"></button>
            <div id="cookieconsent-modal">
                <div id="cookieconsent-message">Please accept YouTube cookies to play this video. By accepting you will be accessing content from YouTube, a service provided by an external third party.</div>
                <button type="button" id="cookieconsent-button">I Agree</button>
            </div>
            <slot name="player"></slot>
        </div>
    `;class i extends HTMLElement{constructor(){super();let t=this.attachShadow({mode:"open"});this.shadowRoot.appendChild(e.content.cloneNode(!0)),this.rootEl=t.querySelector("#root"),this.playButtonEl=t.querySelector("#play-button"),this.cookieConsentMessageEl=t.querySelector("#cookieconsent-message"),this.cookieConsentButtonEl=t.querySelector("#cookieconsent-button"),this.playerEl=null,this._isRendered=!1,this._isCookieConsentAdded=!1,this._isPosterImageAdded=!1,this._isPlayerAdded=!1,this._forcePlayerElement=navigator.vendor.includes("Apple")||navigator.userAgent.includes("Mobi"),this._intersectionObserver=null,this._isInViewport=!1,this._hasPlayerControls=!0,this._hasAutoplayRequested=!1,this._hasMuted=!1,this._hasYTApiEnabled=!1,this._hideYouTubeLogo=!1,this._playerApi=null,this._playerType=ayg_config.player_type,this._playerColor=ayg_config.player_color,this._pendingPlay=!1,this._hasCookieConsent=1==parseInt(ayg_config.cookieconsent),this._cookieConsentMessage=ayg_config.cookieconsent_message||"",this._cookieConsentButtonLabel=ayg_config.cookieconsent_button_label||"",this._ajaxUrl=ayg_config.ajax_url,this._ajaxNonce=ayg_config.ajax_nonce}connectedCallback(){if(!this.src)return!1;let t=new URL(this.src),e=new URLSearchParams(t.search);this._hasPlayerControls=!(e.has("controls")&&(0==e.get("controls")||!1==e.get("controls"))),this._hasAutoplayRequested=e.has("autoplay")&&(1==e.get("autoplay")||!0==e.get("autoplay")),this._hasMuted=e.has("mute")&&(1==e.get("mute")||!0==e.get("mute")),this._hasYTApiEnabled=e.has("enablejsapi")&&(1==e.get("enablejsapi")||!0==e.get("enablejsapi")),this._hideYouTubeLogo=e.has("modestbranding")&&(1==e.get("modestbranding")||!0==e.get("modestbranding")),"custom"==this._playerType&&(this._forcePlayerElement=!0),this.lazyLoad||(this._forcePlayerElement=!0),this.poster||(this._forcePlayerElement=!0),this._hasAutoplayRequested&&(this._forcePlayerElement=!0),this._render(),this.addEventListener("pointerover",()=>this._warmConnections(),{once:!0}),this.addEventListener("focusin",()=>this._warmConnections(),{once:!0}),this.addEventListener("click",()=>this._addPlayer(!0)),this.cookieConsentButtonEl.addEventListener("click",()=>this._onCookieConsent())}disconnectedCallback(){this.removeEventListener("pointerover",()=>this._warmConnections(),{once:!0}),this.removeEventListener("focusin",()=>this._warmConnections(),{once:!0}),this.removeEventListener("click",()=>this._addPlayer(!0)),this.cookieConsentButtonEl.removeEventListener("click",()=>this._onCookieConsent())}static get observedAttributes(){return["ratio"]}attributeChangedCallback(t,e,i){if(e==i)return!1;"ratio"===t&&("auto"==i?this.rootEl.style.paddingBottom=0:this.rootEl.style.paddingBottom=`${parseFloat(i)}%`)}get title(){return this.getAttribute("title")||""}set title(t){this.setAttribute("title",t)}get src(){let t=this.getAttribute("src")||"";return i.isValidUrl(t)?t:""}set src(t){i.isValidUrl(t)&&this.setAttribute("src",t)}get poster(){let t=this.getAttribute("poster")||"";return i.isValidUrl(t)?t:""}set poster(t){i.isValidUrl(t)&&this.setAttribute("poster",t)}get lazyLoad(){return this.hasAttribute("lazyload")}_render(){return!this._isRendered&&(this.lazyLoad&&!this._isInViewport?(this._initIntersectionObserver(),!1):this._hasCookieConsent?(this._addCookieConsent(),!1):void(this._isRendered=!0,this._forcePlayerElement?this._addPlayer():this._addPosterImage()))}_addCookieConsent(){if(this._isCookieConsentAdded)return!1;this._isCookieConsentAdded=!0,this._addPosterImage(),this._cookieConsentMessage&&(this.cookieConsentMessageEl.innerHTML=this._cookieConsentMessage),this._cookieConsentButtonLabel&&(this.cookieConsentButtonEl.innerHTML=this._cookieConsentButtonLabel),this._addClass("cookieconsent")}_onCookieConsent(){this._isRendered=!0;let t=document.querySelectorAll("ayg-player");for(let e=0;e<t.length;e++)t[e].removeCookieConsent();this._addPlayer(!0),this._setCookie()}_addPosterImage(){if(this._isPosterImageAdded)return!1;this._isPosterImageAdded=!0,this.poster&&(this.rootEl.style.backgroundImage=`url("${this.poster}")`)}_addPlayer(t=!1){if(this._isPlayerAdded||this._hasCookieConsent)return!1;this._isPlayerAdded=!0,this._addClass("initialized");let e=this._createIframeEmbed(t);if("custom"==this._playerType){let i=document.createElement("div");i.setAttribute("slot","player"),i.style="--plyr-color-main: "+this._playerColor,i.append(e),this.playerEl=i,this.append(i),this._initPlyrApi(t)}else this.playerEl=e,this.rootEl.append(e),e.focus(),this._initYTApi(t)}_createIframeEmbed(t){let e=document.createElement("iframe");if(e.id="player",e.width=560,e.height=315,e.title=this.title,e.allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share",e.referrerPolicy="strict-origin-when-cross-origin",e.allowFullscreen=!0,t){let i=new URL(this.src),s=i.searchParams;s.set("autoplay",1),i.search=s.toString(),e.src=i.toString()}else e.src=this.src;return e.dataset.poster=this.poster,e}_initPlyrApi(t){this._hideYouTubeLogo&&this.classList.add("hide-youtube-logo");let e={resetOnEnd:!0,fullscreen:{enabled:!0,iosNative:!0}};t&&(e.autoplay=!0),this._hasMuted&&(e.muted=!0);let i=["play-large"];if(this._hasPlayerControls){i=["play-large","play","current-time","progress","duration","mute","volume","fullscreen"];let s=/Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent);s&&(i=["play-large","play","progress","current-time","mute","fullscreen"])}e.controls=i,this._plyr=new Plyr(this.playerEl,e),this._plyr.on("ready",t=>{this._playerApi=t.detail.plyr.embed,this._plyr.autoplay=!0});let a=!1;this._plyr.on("playing",t=>{a||(a=!0,t.target.className+=" plyr--initialized",this._hasPlayerControls||(t.target.className+=" plyr--no-controls"));let e=document.querySelectorAll("ayg-player");for(let i=0;i<e.length;i++)e[i]!=this&&e[i].pause()}),this._plyr.on("ended",t=>{t.target.className+=" plyr--stopped"})}_initYTApi(t){if(!this._hasYTApiEnabled)return!1;this._loadYTApi().then(()=>{this._playerApi=new YT.Player(this.playerEl,{events:{onReady:e=>{t&&this._pendingPlay&&(e.target.playVideo(),this._pendingPlay=!1)},onStateChange:t=>{if(0==t.data&&(document.fullscreenElement?(document.exitFullscreen().catch(()=>{}),setTimeout(()=>{this._dispatchEvent("ended")},500)):this._dispatchEvent("ended")),1==t.data){let e=document.querySelectorAll("ayg-player");for(let i=0;i<e.length;i++)e[i]!=this&&e[i].pause()}}}})})}_loadYTApi(){return new Promise(t=>{if(void 0===window.YT&&void 0===i.isApiLoaded){i.isApiLoaded=!0;var e=document.createElement("script");e.src="https://www.youtube.com/iframe_api";var s=document.getElementsByTagName("script")[0];s.parentNode.insertBefore(e,s)}if(void 0!==window.YT&&window.YT.loaded)t();else{let a=setInterval(function(){void 0!==window.YT&&window.YT.loaded&&(clearInterval(a),t())},10)}})}_initIntersectionObserver(){if(this._intersectionObserver)return!1;this._intersectionObserver=new IntersectionObserver((t,e)=>{t.forEach(t=>{t.isIntersecting?(this._isInViewport=!0,this._render(),this._isRendered&&e.unobserve(this)):this._isInViewport=!1})},{root:null,rootMargin:"0px",threshold:0}),this._intersectionObserver.observe(this)}_warmConnections(){if(i.isPreconnected)return!1;this.src.indexOf("www.youtube-nocookie.com")>-1?i.addPrefetch("preconnect","https://www.youtube-nocookie.com"):i.addPrefetch("preconnect","https://www.youtube.com"),i.addPrefetch("preconnect","https://www.google.com"),i.addPrefetch("preconnect","https://googleads.g.doubleclick.net"),i.addPrefetch("preconnect","https://static.doubleclick.net"),i.isPreconnected=!0}_hasClass(t){return this.rootEl.classList.contains(t)}_addClass(t){this.rootEl.classList.add(t)}_removeClass(t){this.rootEl.classList.remove(t)}_dispatchEvent(t){let e=new CustomEvent(t,{detail:{},bubbles:!0,cancelable:!0});this.dispatchEvent(e)}async _setCookie(){try{let t=new FormData;t.append("action","ayg_set_cookie"),t.append("security",this._ajaxNonce),fetch(this._ajaxUrl,{method:"POST",body:t})}catch(e){}}static isValidUrl(t){if(""==t)return!1;try{return new URL(t),!0}catch(e){return!1}}static addPrefetch(t,e){let i=document.createElement("link");i.rel=t,i.href=e,document.head.append(i)}removeCookieConsent(){this._hasCookieConsent=!1,this._removeClass("cookieconsent"),this._render()}play(t=null){if(t&&"object"==typeof t){this.change(t);return}this._playerApi&&this._playerApi.playVideo?this._playerApi.playVideo():this._pendingPlay=!0}pause(){if(!this._playerApi)return!1;this._playerApi.pauseVideo&&this._playerApi.pauseVideo()}change(t){let e=!0;if(t.hasOwnProperty("autoplay")&&(e=t.autoplay),this._playerApi)t.hasOwnProperty("id")&&(e?this._playerApi.loadVideoById&&this._playerApi.loadVideoById(t.id):this._playerApi.cueVideoById&&this._playerApi.cueVideoById(t.id));else{if(t.hasOwnProperty("id")){let i=new URL(this.src);i.pathname=`/embed/${t.id}`;let s=i.searchParams;s.set("autoplay",e?1:0),i.search=s.toString(),this.src=i.toString(),this._isPlayerAdded&&this.playerEl.setAttribute("src",this.src)}t.hasOwnProperty("poster")&&(this.poster=t.poster,this._isPosterImageAdded&&(this._isPlayerAdded?this.rootEl.style.backgroundImage="none":this.rootEl.style.backgroundImage=`url("${this.poster}")`)),this._isPlayerAdded||this._hasCookieConsent||this._addPlayer(!0)}t.hasOwnProperty("title")&&(this.title=t.title)}stop(){if(!this._playerApi)return!1;this._playerApi.stopVideo&&this._playerApi.stopVideo()}}class s extends HTMLElement{constructor(){super(),this._showMoreButtonLabel=ayg_config.i18n.show_more,this._showLessButtonLabel=ayg_config.i18n.show_less}connectedCallback(){t(this).on("click",".ayg-player-description-toggle-btn",t=>this._toggle(t))}disconnectedCallback(){t(this).off("click",".ayg-player-description-toggle-btn",t=>this._toggle(t))}_toggle(e){e.preventDefault();let i=t(this).find(".ayg-player-description-dots"),s=t(this).find(".ayg-player-description-more");i.is(":visible")?(e.currentTarget.innerHTML=this._showLessButtonLabel,i.hide(),s.fadeIn()):s.fadeOut(()=>{e.currentTarget.innerHTML=this._showMoreButtonLabel,i.show()})}}class a extends HTMLElement{constructor(){super(),this.$el=null,this.$root=null,this.$searchForm=null,this.$searchInput=null,this.$searchBtn=null,this.$resetBtn=null,this.$player=null,this.$videos=null,this.$pagination=null,this._formData={},this._ajaxUrl=ayg_config.ajax_url,this._ajaxNonce=ayg_config.ajax_nonce,this._searchTerm="",this._isLoading=!1}connectedCallback(){this.$el=t(this),this.$root=this.$el.closest(".ayg"),this.$searchForm=this.$el.find("form"),this.$searchInput=this.$el.find(".ayg-search-input"),this.$searchBtn=this.$el.find(".ayg-search-btn"),this.$resetBtn=this.$el.find(".ayg-reset-btn"),this.$player=this.$root.find(".ayg-theme > .ayg-player"),this.$videos=this.$root.find(".ayg-videos"),this.$pagination=this.$root.find(".ayg-pagination"),this._formData=this.$el.data("params"),this._formData.action="ayg_load_videos",this._formData.security=this._ajaxNonce,this._formData.searchTerm="",this.$searchForm.on("submit",t=>this._search(t)),this.$searchInput.on("blur",t=>this._search(t)),this.$searchBtn.on("click",t=>this._search(t)),this.$resetBtn.on("click",t=>this._reset(t))}disconnectedCallback(){this.$searchForm.off("submit",t=>this._search(t)),this.$searchInput.off("blur",t=>this._search(t)),this.$searchBtn.off("click",t=>this._search(t)),this.$resetBtn.off("click",t=>this._reset(t))}set loading(t){if(this._isLoading==t)return!1;this._isLoading=t,this.$searchBtn.hide(),this.$resetBtn.hide(),t?(this.$el.find(".ayg-status-message").remove(),this.$searchBtn.show(),this.$searchBtn.find("svg").hide(),this.$searchBtn.append('<span class="ayg-loading"></span>')):(this._searchTerm.length>0?this.$resetBtn.show():this.$searchBtn.show(),this.$searchBtn.find(".ayg-loading").remove(),this.$searchBtn.find("svg").show())}set message(t){this.$el.find(".ayg-status-message").remove(),t.data.message&&(t.success?this.$el.append('<div class="ayg-status-message"><svg xmlns="http://www.w3.org/2000/svg" fill="none" width="16" height="16" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75 11.25 15 15 9.75M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" /></svg>'+t.data.message+"</div>"):this.$el.append('<div class="ayg-status-message ayg-error"><svg xmlns="http://www.w3.org/2000/svg" fill="none" width="16" height="16" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m9-.75a9 9 0 1 1-18 0 9 9 0 0 1 18 0Zm-9 3.75h.008v.008H12v-.008Z" /></svg>'+t.data.message+"</div>"))}_search(t){if(t&&t.preventDefault(),this._searchTerm=this.$searchInput.val(),this._searchTerm==this._formData.searchTerm)return!1;this.loading=!0,this._formData.searchTerm=this._searchTerm,this._formData.pageToken=this._searchTerm.length>0?1:"",this._fetch(this._formData,t=>{t.success&&(this.$videos.html(t.data.html),this._updatePlayer(t),this._updatePagination(t),this.$el.trigger("videos.updated")),this._searchTerm.length>0&&(this.message=t),this.loading=!1})}_reset(t){this.$searchInput.val(""),this._search(t)}_updatePlayer(t){if(0==this.$player.length)return!1;let e=this.$videos.find(".ayg-video").eq(0),i=e.find(".ayg-thumbnail").data("id"),s=e.find(".ayg-thumbnail").data("title"),a=e.find(".ayg-thumbnail-description").html(),o=e.find(".ayg-thumbnail-image").attr("src"),n=this.$player.find("ayg-player").get(0),r=this.$root.find(".ayg-theme").data("params");n.change({id:i,title:s,poster:o,autoplay:!1}),1==r.player_title&&this.$player.find(".ayg-player-title").html(s),1==r.player_description&&this.$player.find(".ayg-player-description").html(a)}_updatePagination(t){if(0==this.$pagination.length)return!1;let e=parseInt(t.data.total_pages||1),i=this.$pagination.find(".ayg-pagination-prev-btn");i.length>0&&i.hide();let s=this.$pagination.find(".ayg-pagination-next-btn");s.length>0&&(1==e?s.hide():s.show());let a=this.$pagination.find(".ayg-pagination-current-page-number");a.length>0&&a.html(1);let o=this.$pagination.find(".ayg-pagination-total-pages");o.length>0&&o.html(e);let n=this.$pagination.get(0),r=n.formData;r.searchTerm=this._searchTerm,r.total_pages=e,r.next_page_token=t.data.next_page_token,n.update(r)}_fetch(e,i){t.post(this._ajaxUrl,e,i,"json")}}class o extends HTMLElement{constructor(){super(),this.$el=null,this.$videos=null,this.$nextButton=null,this.$previousButton=null,this._formData={},this._ajaxUrl=ayg_config.ajax_url,this._ajaxNonce=ayg_config.ajax_nonce,this._totalPages=1,this._paged=1,this._pageTokens=[""]}connectedCallback(){this.$el=t(this),this.$videos=this.$el.closest(".ayg").find(".ayg-videos"),this._formData=this.$el.data("params"),this._formData.action="ayg_load_videos",this._formData.security=this._ajaxNonce,this._totalPages=parseInt(this._formData.total_pages),this.$el.on("click",".ayg-pagination-next-btn",t=>this._next(t)),this.$el.on("click",".ayg-pagination-prev-btn",t=>this._previous(t))}disconnectedCallback(){this.$el.off("click",".ayg-pagination-next-btn",t=>this._next(t)),this.$el.off("click",".ayg-pagination-prev-btn",t=>this._previous(t))}get formData(){return this._formData}_next(e){this.$el.addClass("ayg-loading"),this.$nextButton=t(e.currentTarget);let i=this.$nextButton.data("type");this._formData.pageToken=this._formData.next_page_token,this._pageTokens[this._paged]=this._formData.pageToken,this._fetch(this._formData,t=>{if(t.success){switch(this._paged=Math.min(this._paged+1,this._totalPages),this._formData.next_page_token="",this._paged<this._totalPages&&t.data.next_page_token&&(this._formData.next_page_token=t.data.next_page_token),i){case"more":this.$videos.append(t.data.html);break;case"next":this.$el.find(".ayg-pagination-prev-btn").show(),this.$el.find(".ayg-pagination-current-page-number").html(this._paged),this.$videos.html(t.data.html)}""==this._formData.next_page_token&&this.$nextButton.hide(),this.$el.trigger("videos.updated")}this.$el.removeClass("ayg-loading")})}_previous(e){this.$el.addClass("ayg-loading"),this.$previousButton=t(e.currentTarget),this._paged=Math.max(this._paged-1,1),this._formData.pageToken=this._pageTokens[this._paged-1],this._fetch(this._formData,t=>{t.success&&(this._formData.next_page_token="",t.data.next_page_token&&(this._formData.next_page_token=t.data.next_page_token),this.$videos.html(t.data.html),this.$el.find(".ayg-pagination-next-btn").show(),this.$el.find(".ayg-pagination-current-page-number").html(this._paged),1==this._paged&&this.$previousButton.hide(),this.$el.trigger("videos.updated")),this.$el.removeClass("ayg-loading")})}_fetch(e,i){t.post(this._ajaxUrl,e,i,"json")}update(t){this._formData=t,this._totalPages=parseInt(this._formData.total_pages),this._paged=1,this._pageTokens=[""]}}window.getAYGPlayerHtml=function t(e,i){var s="https://www.youtube.com";1==ayg_config.privacy_enhanced_mode&&(s="https://www.youtube-nocookie.com"),e.src=s+"/embed/"+e.id+"?enablejsapi=1&playsinline=1&rel=0",ayg_config.hasOwnProperty("origin")&&ayg_config.origin.length>0&&(e.src+="&origin="+ayg_config.origin),1==(i.hasOwnProperty("autoplay")?parseInt(i.autoplay):0)&&(e.src+="&autoplay=1"),1==(i.hasOwnProperty("muted")?parseInt(i.muted):0)&&(e.src+="&mute=1"),0==(i.hasOwnProperty("controls")?parseInt(i.controls):1)&&(e.src+="&controls=0"),1==(i.hasOwnProperty("modestbranding")?parseInt(i.modestbranding):0)&&(e.src+="&modestbranding=1"),1==(i.hasOwnProperty("cc_load_policy")?parseInt(i.cc_load_policy):0)&&(e.src+="&cc_load_policy=1"),0==(i.hasOwnProperty("iv_load_policy")?parseInt(i.iv_load_policy):0)&&(e.src+="&iv_load_policy=3"),i.hasOwnProperty("hl")&&i.hl.length>0&&(e.src+="&hl="+i.hl),i.hasOwnProperty("cc_lang_pref")&&i.cc_lang_pref.length>0&&(e.src+="&cc_lang_pref="+i.cc_lang_pref);var a='<ayg-player class="mfp-prevent-close"';return a+=' title="'+e.title+'"',a+=' src="'+e.src+'"',a+=' poster="'+e.poster+'"',a+=' ratio="'+e.ratio+'"',a+=">",a+="</ayg-player>"},t(function(){customElements.get("ayg-player")||customElements.define("ayg-player",i),customElements.get("ayg-description")||customElements.define("ayg-description",s),customElements.get("ayg-search-form")||customElements.define("ayg-search-form",a),customElements.get("ayg-pagination")||customElements.define("ayg-pagination",o);let e=ayg_config.current_gallery_id,n=parseInt(ayg_config.top_offset);if(n>=0&&e){let r=t("#ayg-"+e);r.length>0&&(history.scrollRestoration?history.scrollRestoration="manual":window.onbeforeunload=function(){window.scrollTo(0,0)},t("html, body").animate({scrollTop:r.offset().top-n},500))}})}(jQuery);