<!-- Right Sidebar -->
<div class="tpa-dashboard-sidebar">
    <div class="tpa-dashboard-status">
        <h3><?php esc_html_e('Auto Translation status', $text_domain); ?></h3>
        <div class="tpa-dashboard-sts-top">
            <?php

            $all_data = get_option('cpt_dashboard_data', array());

            if (!is_array($all_data) || !isset($all_data['tpa'])) {

                $all_data['tpa'] = []; // Ensure $all_data['tpa'] is an array

            }

            $totals = array_reduce($all_data['tpa'] ?? [], function($carry, $translation) {
                // Ensure all values are properly handled
                $carry['string_count'] += intval($translation['string_count'] ?? 0);
                $carry['character_count'] += intval($translation['character_count'] ?? 0);
                $carry['time_taken'] += intval($translation['time_taken'] ?? 0);
                
                // Track unique post IDs
                if (!empty($translation['post_id'])) {
                    $carry['plugins_themes'][$translation['post_id']] = 1;
                }
                return $carry;
            }, ['string_count' => 0, 'character_count' => 0, 'time_taken' => 0, 'plugins_themes' => []]);
            // Update the time taken string using the new function
            $time_taken_str = tpa_format_time_taken($totals['time_taken'] ,$text_domain);
            ?>
            <span><?php echo esc_html(tpa_format_number($totals['string_count'], $text_domain)); ?></span>
            <span><?php esc_html_e('Total Strings Translated!', $text_domain); ?></span>
        </div>
        <ul class="tpa-dashboard-sts-btm">
            <li><span><?php esc_html_e('Total Characters', $text_domain); ?></span> <span><?php echo esc_html(tpa_format_number($totals['character_count'], $text_domain)); ?></span></li>
            <li><span><?php esc_html_e('Total Pages / Posts', $text_domain); ?></span> <span><?php echo esc_html(count($totals['plugins_themes'])); ?></span></li>
            <li><span><?php esc_html_e('Time Taken', $text_domain); ?></span> <span><?php echo esc_html($time_taken_str); ?></span></li>
        </ul>
    </div>
    <div class="tpa-dashboard-translate-full">
        <h3><?php esc_html_e('Automatically Translate Plugins, Themes & Webpages', $text_domain); ?></h3>
        <div class="tpa-dashboard-addon first">
            <div class="tpa-dashboard-addon-l">
                <strong><?php echo esc_html(tpa_get_plugin_display_name('automatic-translator-addon-for-loco-translate', $text_domain)); ?></strong>
                <span class="addon-desc"><?php esc_html_e('LocoAI to translate plugins and themes.', $text_domain); ?></span>
                <?php if (tpa_is_plugin_installed('automatic-translator-addon-for-loco-translate')): ?>
                    <span class="installed"><?php esc_html_e('Installed', $text_domain); ?></span>
                <?php else: ?>
                    <a href="<?php echo esc_url(admin_url('plugin-install.php?s=LocoAI+Auto+Translate+For+Loco+Translate+by+CoolPlugins&tab=search&type=term')); ?>" class="tpa-dashboard-btn" target="_blank"><?php _e('Install', $text_domain); ?></a>
                <?php endif; ?>
            </div>
            <div class="tpa-dashboard-addon-r">
                <img src="<?php echo esc_url(TPA_URL . 'admin/tpa-dashboard/images/atlt-logo.png'); ?>" alt="<?php _e('TranslatePress Addon', $text_domain); ?>">
            </div>
        </div>
        <div class="tpa-dashboard-addon">
            <div class="tpa-dashboard-addon-l">
                <strong><?php echo esc_html(tpa_get_plugin_display_name('linguator-multilingual-ai-translation', $text_domain)); ?></strong>
                <span class="addon-desc"><?php esc_html_e('Create a Multilingual WordPress Website 10X Faster – Powered by AI.', $text_domain); ?></span>
                <?php if (tpa_is_plugin_installed('linguator-multilingual-ai-translation')): ?>
                    <span class="installed"><?php esc_html_e('Installed', $text_domain); ?></span>
                <?php else: ?>
                    <a href="<?php echo esc_url(admin_url('plugin-install.php?s=Linguator+Multilingual+AI+Translation&tab=search&type=term')); ?>" class="tpa-dashboard-btn" target="_blank"><?php _e('Install', $text_domain); ?></a>
                <?php endif; ?>
            </div>
            <div class="tpa-dashboard-addon-r">
                <img src="<?php echo esc_url(TPA_URL . 'admin/tpa-dashboard/images/linguator-multilingual-ai-translation.png'); ?>" alt="<?php _e('TranslatePress Addon', $text_domain); ?>">
            </div>
        </div>
    </div>
    <div class="tpa-dashboard-rate-us">
        <h3><?php esc_html_e('Rate Us ⭐⭐⭐⭐⭐', $text_domain); ?></h3>
        <p><?php esc_html_e('We\'d love your feedback! Hope this addon made auto-translations easier for you.', $text_domain); ?></p>
        <a href="https://wordpress.org/support/plugin/automatic-translate-addon-for-translatepress/reviews/#new-post" class="review-link" target="_blank"><?php esc_html_e('Submit a Review →', $text_domain); ?></a>
    </div>
</div>

<?php

function tpa_format_time_taken($time_taken, $text_domain) {
    if ($time_taken === 0) return esc_html__('0', $text_domain);
    if ($time_taken < 60) return sprintf(esc_html__('%d sec', $text_domain), $time_taken);
    if ($time_taken < 3600) {
        $min = floor($time_taken / 60);
        $sec = $time_taken % 60;
        return sprintf(esc_html__('%d min %d sec', $text_domain), $min, $sec);
    }
    $hours = floor($time_taken / 3600);
    $min = floor(($time_taken % 3600) / 60);
    return sprintf(esc_html__('%d hours %d min', $text_domain), $hours, $min);
}

function tpa_is_plugin_installed($plugin_slug) {
    $plugins = get_plugins();
    
    // Check if the plugin is installed
    if ($plugin_slug === 'automatic-translator-addon-for-loco-translate') {
        return isset($plugins['automatic-translator-addon-for-loco-translate/automatic-translator-addon-for-loco-translate.php']) || isset($plugins['loco-automatic-translate-addon-pro/loco-automatic-translate-addon-pro.php']);
    } elseif ($plugin_slug === 'linguator-multilingual-ai-translation') {
        return isset($plugins['linguator-multilingual-ai-translation/linguator-multilingual-ai-translation.php']);
    }
    return false; // Return false if no match found
}

function tpa_get_plugin_display_name($plugin_slug, $text_domain) {
    $plugins = get_plugins();

    // Define free and pro plugin paths
    $plugin_paths = [
        'automatic-translator-addon-for-loco-translate' => [
            'free' => 'automatic-translator-addon-for-loco-translate/automatic-translator-addon-for-loco-translate.php',
            'pro'  => 'loco-automatic-translate-addon-pro/loco-automatic-translate-addon-pro.php',
            'free_name' => esc_html__('LocoAI – Auto Translate for Loco Translate', $text_domain),
            'pro_name'  => esc_html__('LocoAI – Auto Translate for Loco Translate (Pro)', $text_domain),
        ],
        'linguator-multilingual-ai-translation' => [
            'free' => 'linguator-multilingual-ai-translation/linguator-multilingual-ai-translation.php',
            'free_name' => __('Linguator Multilingual AI Translation', $text_domain),
        ],
    ];

    // Check if the provided plugin slug exists
    if (!isset($plugin_paths[$plugin_slug])) {
        return $plugin_slug['free_name'];
    }

    $free_installed = isset($plugins[$plugin_paths[$plugin_slug]['free']]);
    $has_pro = isset($plugin_paths[$plugin_slug]['pro']);
    $pro_installed = $has_pro && isset($plugins[$plugin_paths[$plugin_slug]['pro']]);

    // Determine which version is installed
    if ($pro_installed && isset($plugin_paths[$plugin_slug]['pro_name'])) {
        return $plugin_paths[$plugin_slug]['pro_name'];
    }

    if ($free_installed && isset($plugin_paths[$plugin_slug]['free_name'])) {
        return $plugin_paths[$plugin_slug]['free_name'];
    }

    // Default to free_name if defined, otherwise a generic label
    return $plugin_paths[$plugin_slug]['free_name'] ?? __('Unknown plugin', $text_domain);
}

function tpa_format_number($number, $text_domain) {
    if ($number >= 1000000000) {
        return round($number / 1000000000, 1) . esc_html__('B', $text_domain);
    } elseif ($number >= 1000000) {
        return round($number / 1000000, 1) . esc_html__('M', $text_domain);
    } elseif ($number >= 1000) {
        return round($number / 1000, 1) . esc_html__('K', $text_domain);
    }
    return $number;
}

