import { Icon } from '@wordpress/icons';

export const icons = {
    general: <Icon icon={
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M17 1H3C1.89543 1 1 1.89543 1 3V17C1 18.1046 1.89543 19 3 19H17C18.1046 19 19 18.1046 19 17V3C19 1.89543 18.1046 1 17 1Z" strokeWidth="1.8" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M1 7H19" strokeWidth="1.8" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M7 19V7" strokeWidth="1.8" strokeLinecap="round" strokeLinejoin="round"/>
        </svg>
    } />,
    style: <Icon icon={
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M13.2647 1.00654C13.6449 0.904684 14.0415 0.87872 14.4317 0.930132C14.822 0.981544 15.1983 1.10932 15.5392 1.30617C15.8801 1.50303 16.1788 1.76509 16.4184 2.07741C16.658 2.38973 16.8337 2.74618 16.9355 3.12642L19.8979 14.1803C19.9998 14.5605 20.0257 14.9571 19.9743 15.3473C19.9229 15.7376 19.7951 16.1139 19.5983 16.4548C19.4014 16.7956 19.1393 17.0944 18.827 17.334C18.5147 17.5736 18.1583 17.7493 17.778 17.8511L10.9367 19.6854C10.5563 19.7876 10.1595 19.8138 9.76901 19.7626C9.3785 19.7113 9.00193 19.5836 8.66081 19.3867C8.3197 19.1898 8.02073 18.9277 7.78099 18.6152C7.54126 18.3027 7.36547 17.946 7.26366 17.5655L4.30238 6.51168C4.20052 6.13145 4.17456 5.73489 4.22597 5.34463C4.27738 4.95438 4.40516 4.57807 4.60201 4.2372C4.79886 3.89633 5.06093 3.59757 5.37325 3.35798C5.68557 3.1184 6.04202 2.94268 6.42225 2.84086L13.2647 1.00654ZM4.29148 10.686L6.2119 17.8467C6.40058 18.5566 6.77796 19.2022 7.30399 19.7148L6.82116 19.6887C6.02742 19.647 5.28274 19.2917 4.75091 18.701C4.21908 18.1104 3.94365 17.3326 3.98521 16.5389L4.29148 10.686ZM13.6876 2.58582L6.84514 4.42123C6.49632 4.51473 6.1989 4.7429 6.01824 5.05559C5.83757 5.36827 5.78845 5.7399 5.88166 6.08879L8.84294 17.1438C8.88923 17.3166 8.96912 17.4786 9.07803 17.6206C9.18694 17.7625 9.32275 17.8816 9.47771 17.9711C9.63266 18.0606 9.80372 18.1187 9.98111 18.142C10.1585 18.1654 10.3388 18.1535 10.5116 18.1072L17.3551 16.2729C17.704 16.1794 18.0014 15.9512 18.182 15.6386C18.3627 15.3259 18.4118 14.9542 18.3186 14.6054L15.3562 3.5493C15.2627 3.20049 15.0346 2.90307 14.7219 2.7224C14.4092 2.54174 14.0376 2.49261 13.6887 2.58582H13.6876ZM3.28331 9.07515L2.89639 16.4822C2.85606 17.2429 3.02718 17.9666 3.35851 18.5966L2.90729 18.4211C2.53979 18.2801 2.20368 18.068 1.91814 17.7971C1.63259 17.5262 1.40322 17.2016 1.2431 16.842C1.08299 16.4824 0.995278 16.0948 0.984975 15.7013C0.974671 15.3078 1.04198 14.9162 1.18305 14.5487L3.28331 9.07515ZM8.58354 5.64629C8.72181 5.60922 8.86602 5.59974 9.00794 5.6184C9.14987 5.63707 9.28672 5.6835 9.4107 5.75505C9.53468 5.82661 9.64335 5.92188 9.73051 6.03543C9.81767 6.14898 9.88161 6.27859 9.91868 6.41685C9.95575 6.55512 9.96523 6.69933 9.94657 6.84125C9.9279 6.98318 9.88147 7.12003 9.80992 7.24401C9.73836 7.36799 9.64309 7.47667 9.52954 7.56382C9.41599 7.65098 9.28638 7.71492 9.14812 7.75199C9.00985 7.78906 8.86564 7.79854 8.72372 7.77988C8.5818 7.76122 8.44494 7.71478 8.32096 7.64323C8.07057 7.49872 7.88784 7.26066 7.81298 6.98143C7.73811 6.70219 7.77723 6.40466 7.92174 6.15427C8.06625 5.90388 8.30431 5.72115 8.58354 5.64629Z"/>
        </svg>
    } />,
    advanced: <Icon icon={
        <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M11 13.7273C12.5062 13.7273 13.7273 12.5062 13.7273 11C13.7273 9.49377 12.5062 8.27273 11 8.27273C9.49375 8.27273 8.27271 9.49377 8.27271 11C8.27271 12.5062 9.49375 13.7273 11 13.7273Z" strokeWidth="1.6" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M17.7273 13.7273C17.6063 14.0015 17.5702 14.3056 17.6236 14.6005C17.6771 14.8954 17.8177 15.1676 18.0273 15.3818L18.0818 15.4364C18.2509 15.6052 18.385 15.8057 18.4765 16.0265C18.568 16.2472 18.6151 16.4838 18.6151 16.7227C18.6151 16.9617 18.568 17.1983 18.4765 17.419C18.385 17.6397 18.2509 17.8402 18.0818 18.0091C17.913 18.1781 17.7124 18.3122 17.4917 18.4037C17.271 18.4952 17.0344 18.5423 16.7955 18.5423C16.5565 18.5423 16.3199 18.4952 16.0992 18.4037C15.8785 18.3122 15.678 18.1781 15.5091 18.0091L15.4545 17.9545C15.2403 17.745 14.9682 17.6044 14.6733 17.5509C14.3784 17.4974 14.0742 17.5335 13.8 17.6545C13.5311 17.7698 13.3018 17.9611 13.1403 18.205C12.9788 18.4489 12.8921 18.7347 12.8909 19.0273V19.1818C12.8909 19.664 12.6994 20.1265 12.3584 20.4675C12.0174 20.8084 11.5549 21 11.0727 21C10.5905 21 10.1281 20.8084 9.78708 20.4675C9.4461 20.1265 9.25455 19.664 9.25455 19.1818V19.1C9.24751 18.7991 9.15011 18.5073 8.97501 18.2625C8.79991 18.0176 8.55521 17.8312 8.27273 17.7273C7.99853 17.6063 7.69437 17.5702 7.39947 17.6236C7.10456 17.6771 6.83244 17.8177 6.61818 18.0273L6.56364 18.0818C6.39478 18.2509 6.19425 18.385 5.97353 18.4765C5.7528 18.568 5.51621 18.6151 5.27727 18.6151C5.03834 18.6151 4.80174 18.568 4.58102 18.4765C4.36029 18.385 4.15977 18.2509 3.99091 18.0818C3.82186 17.913 3.68775 17.7124 3.59626 17.4917C3.50476 17.271 3.45766 17.0344 3.45766 16.7955C3.45766 16.5565 3.50476 16.3199 3.59626 16.0992C3.68775 15.8785 3.82186 15.678 3.99091 15.5091L4.04545 15.4545C4.25503 15.2403 4.39562 14.9682 4.4491 14.6733C4.50257 14.3784 4.46647 14.0742 4.34545 13.8C4.23022 13.5311 4.03887 13.3018 3.79497 13.1403C3.55107 12.9788 3.26526 12.8921 2.97273 12.8909H2.81818C2.33597 12.8909 1.87351 12.6994 1.53253 12.3584C1.19156 12.0174 1 11.5549 1 11.0727C1 10.5905 1.19156 10.1281 1.53253 9.78708C1.87351 9.4461 2.33597 9.25455 2.81818 9.25455H2.9C3.2009 9.24751 3.49273 9.15011 3.73754 8.97501C3.98236 8.79991 4.16883 8.55521 4.27273 8.27273C4.39374 7.99853 4.42984 7.69437 4.37637 7.39947C4.3229 7.10456 4.18231 6.83244 3.97273 6.61818L3.91818 6.56364C3.74913 6.39478 3.61503 6.19425 3.52353 5.97353C3.43203 5.7528 3.38493 5.51621 3.38493 5.27727C3.38493 5.03834 3.43203 4.80174 3.52353 4.58102C3.61503 4.36029 3.74913 4.15977 3.91818 3.99091C4.08704 3.82186 4.28757 3.68775 4.50829 3.59626C4.72901 3.50476 4.96561 3.45766 5.20455 3.45766C5.44348 3.45766 5.68008 3.50476 5.9008 3.59626C6.12152 3.68775 6.32205 3.82186 6.49091 3.99091L6.54545 4.04545C6.75971 4.25503 7.03183 4.39562 7.32674 4.4491C7.62164 4.50257 7.9258 4.46647 8.2 4.34545H8.27273C8.54161 4.23022 8.77092 4.03887 8.93245 3.79497C9.09397 3.55107 9.18065 3.26526 9.18182 2.97273V2.81818C9.18182 2.33597 9.37338 1.87351 9.71435 1.53253C10.0553 1.19156 10.5178 1 11 1C11.4822 1 11.9447 1.19156 12.2856 1.53253C12.6266 1.87351 12.8182 2.33597 12.8182 2.81818V2.9C12.8193 3.19253 12.906 3.47834 13.0676 3.72224C13.2291 3.96614 13.4584 4.15749 13.7273 4.27273C14.0015 4.39374 14.3056 4.42984 14.6005 4.37637C14.8954 4.3229 15.1676 4.18231 15.3818 3.97273L15.4364 3.91818C15.6052 3.74913 15.8057 3.61503 16.0265 3.52353C16.2472 3.43203 16.4838 3.38493 16.7227 3.38493C16.9617 3.38493 17.1983 3.43203 17.419 3.52353C17.6397 3.61503 17.8402 3.74913 18.0091 3.91818C18.1781 4.08704 18.3122 4.28757 18.4037 4.50829C18.4952 4.72901 18.5423 4.96561 18.5423 5.20455C18.5423 5.44348 18.4952 5.68008 18.4037 5.9008C18.3122 6.12152 18.1781 6.32205 18.0091 6.49091L17.9545 6.54545C17.745 6.75971 17.6044 7.03183 17.5509 7.32674C17.4974 7.62164 17.5335 7.9258 17.6545 8.2V8.27273C17.7698 8.54161 17.9611 8.77092 18.205 8.93245C18.4489 9.09397 18.7347 9.18065 19.0273 9.18182H19.1818C19.664 9.18182 20.1265 9.37338 20.4675 9.71435C20.8084 10.0553 21 10.5178 21 11C21 11.4822 20.8084 11.9447 20.4675 12.2856C20.1265 12.6266 19.664 12.8182 19.1818 12.8182H19.1C18.8075 12.8193 18.5217 12.906 18.2778 13.0676C18.0339 13.2291 17.8425 13.4584 17.7273 13.7273V13.7273Z" strokeWidth="1.6" strokeLinecap="round" strokeLinejoin="round"/>
        </svg>
    } />,

    // Blocks Icons.
    flexContainerBlock: <Icon icon={<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M5 3.5H18.5C19.3285 3.5 20 4.17157 20 5V18.5C20 19.3285 19.3285 20 18.5 20H5C4.17157 20 3.5 19.3285 3.5 18.5V5C3.5 4.17157 4.17157 3.5 5 3.5ZM4 18.5C4 19.0522 4.44769 19.5 5 19.5H11.5V12H4V18.5ZM12 19.5H18.5C19.0522 19.5 19.5 19.0522 19.5 18.5V12H12V19.5ZM5 4C4.44772 4 4 4.44772 4 5V11.5H11.5V4H5ZM12 11.5H19.5V5C19.5 4.44769 19.0522 4 18.5 4H12V11.5Z" fill="#1E1E1E" stroke="#3858E9"/>
        </svg>
    } />,
    testimonialsBlock: <Icon icon={<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M10.2002 6.5V15.9004C10.2001 16.9874 9.83947 17.8428 9.35938 18.332C8.50962 19.0931 7.38463 19.2002 6.40039 19.2002V18.7207C6.7967 18.7546 7.22287 18.7656 7.63281 18.707C8.13456 18.6354 8.65141 18.456 9.05371 18.0537C9.4912 17.6162 9.7002 16.8543 9.7002 16V11.5H4.5V6.5H10.2002ZM19.2002 6.5V15.9004C19.2001 16.9874 18.8395 17.8428 18.3594 18.332C17.5096 19.0931 16.3846 19.2002 15.4004 19.2002V18.7207C15.7967 18.7546 16.2229 18.7656 16.6328 18.707C17.1346 18.6354 17.6514 18.456 18.0537 18.0537C18.4912 17.6162 18.7002 16.8543 18.7002 16V11.5H13.5V6.5H19.2002Z" fill="#3858E9" stroke="#3858E9"/>
        </svg>        
    } />,
    postGridBlock: <Icon icon={<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M6 13.5H9C9.39782 13.5 9.77924 13.6581 10.0605 13.9395C10.3419 14.2208 10.5 14.6022 10.5 15V18C10.5 18.3978 10.3419 18.7792 10.0605 19.0605C9.77924 19.3419 9.39782 19.5 9 19.5H6C5.60218 19.5 5.22076 19.3419 4.93945 19.0605C4.65815 18.7792 4.5 18.3978 4.5 18V15C4.5 14.6022 4.65815 14.2208 4.93945 13.9395C5.22076 13.6581 5.60218 13.5 6 13.5ZM15 13.5H18C18.3978 13.5 18.7792 13.6581 19.0605 13.9395C19.3419 14.2208 19.5 14.6022 19.5 15V18C19.5 18.3978 19.3419 18.7792 19.0605 19.0605C18.7792 19.3419 18.3978 19.5 18 19.5H15C14.6022 19.5 14.2208 19.3419 13.9395 19.0605C13.6581 18.7792 13.5 18.3978 13.5 18V15C13.5 14.6022 13.6581 14.2208 13.9395 13.9395C14.2208 13.6581 14.6022 13.5 15 13.5ZM6 14C5.73478 14 5.48051 14.1054 5.29297 14.293C5.10543 14.4805 5 14.7348 5 15V18C5 18.2652 5.10543 18.5195 5.29297 18.707C5.48051 18.8946 5.73478 19 6 19H9C9.26522 19 9.51949 18.8946 9.70703 18.707C9.89457 18.5195 10 18.2652 10 18V15C10 14.7348 9.89457 14.4805 9.70703 14.293C9.51949 14.1054 9.26522 14 9 14H6ZM15 14C14.7348 14 14.4805 14.1054 14.293 14.293C14.1054 14.4805 14 14.7348 14 15V18C14 18.2652 14.1054 18.5195 14.293 18.707C14.4805 18.8946 14.7348 19 15 19H18C18.2652 19 18.5195 18.8946 18.707 18.707C18.8946 18.5195 19 18.2652 19 18V15C19 14.7348 18.8946 14.4805 18.707 14.293C18.5195 14.1054 18.2652 14 18 14H15ZM6 4.5H9C9.39782 4.5 9.77924 4.65815 10.0605 4.93945C10.3419 5.22076 10.5 5.60218 10.5 6V9C10.5 9.39782 10.3419 9.77924 10.0605 10.0605C9.77924 10.3419 9.39782 10.5 9 10.5H6C5.60218 10.5 5.22076 10.3419 4.93945 10.0605C4.65815 9.77924 4.5 9.39782 4.5 9V6C4.5 5.60218 4.65815 5.22076 4.93945 4.93945C5.22076 4.65815 5.60218 4.5 6 4.5ZM15 4.5H18C18.3978 4.5 18.7792 4.65815 19.0605 4.93945C19.3419 5.22076 19.5 5.60218 19.5 6V9C19.5 9.39782 19.3419 9.77924 19.0605 10.0605C18.7792 10.3419 18.3978 10.5 18 10.5H15C14.6022 10.5 14.2208 10.3419 13.9395 10.0605C13.6581 9.77924 13.5 9.39782 13.5 9V6C13.5 5.60218 13.6581 5.22076 13.9395 4.93945C14.2208 4.65815 14.6022 4.5 15 4.5ZM6 5C5.73478 5 5.4805 5.10543 5.29297 5.29297C5.10543 5.4805 5 5.73478 5 6V9C5 9.26522 5.10543 9.51949 5.29297 9.70703C5.48051 9.89457 5.73478 10 6 10H9C9.26522 10 9.51949 9.89457 9.70703 9.70703C9.89457 9.51949 10 9.26522 10 9V6C10 5.73478 9.89457 5.48051 9.70703 5.29297C9.51949 5.10543 9.26522 5 9 5H6ZM15 5C14.7348 5 14.4805 5.10543 14.293 5.29297C14.1054 5.48051 14 5.73478 14 6V9C14 9.26522 14.1054 9.51949 14.293 9.70703C14.4805 9.89457 14.7348 10 15 10H18C18.2652 10 18.5195 9.89457 18.707 9.70703C18.8946 9.51949 19 9.26522 19 9V6C19 5.73478 18.8946 5.48051 18.707 5.29297C18.5195 5.10543 18.2652 5 18 5H15Z" fill="#1E1E1E" stroke="#3858E9"/>
        </svg>
    } />,
    iconBlock: <Icon icon={<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M9.70571 8.646C9.68783 8.68237 9.66137 8.71384 9.62862 8.7377C9.59587 8.76157 9.55781 8.77712 9.51771 8.783L4.89171 9.455C4.8454 9.46156 4.80185 9.48098 4.76602 9.51106C4.73019 9.54114 4.70352 9.58067 4.68904 9.62515C4.67456 9.66963 4.67285 9.71729 4.6841 9.76269C4.69536 9.8081 4.71913 9.84944 4.75271 9.882L8.10071 13.144C8.12987 13.1724 8.15166 13.2074 8.16421 13.2461C8.17676 13.2848 8.17968 13.3259 8.17271 13.366L7.38271 17.973C7.37482 18.0189 7.37992 18.0661 7.39743 18.1093C7.41493 18.1525 7.44416 18.1899 7.4818 18.2173C7.51943 18.2448 7.56399 18.2612 7.61045 18.2646C7.65691 18.2681 7.70341 18.2585 7.74471 18.237L11.8827 16.061C11.9186 16.0421 11.9586 16.0322 11.9992 16.0322C12.0398 16.0322 12.0798 16.0421 12.1157 16.061L16.2527 18.236C16.294 18.2577 16.3405 18.2675 16.387 18.2642C16.4335 18.2609 16.4782 18.2446 16.5159 18.2173C16.5537 18.1899 16.583 18.1525 16.6007 18.1094C16.6183 18.0662 16.6235 18.019 16.6157 17.973L15.8257 13.366C15.8188 13.3259 15.8217 13.2848 15.8342 13.2461C15.8468 13.2074 15.8686 13.1724 15.8977 13.144L19.2447 9.882C19.2783 9.84944 19.3021 9.8081 19.3133 9.76269C19.3246 9.71729 19.3229 9.66963 19.3084 9.62515C19.2939 9.58067 19.2672 9.54114 19.2314 9.51106C19.1956 9.48098 19.152 9.46156 19.1057 9.455L14.4797 8.783C14.4396 8.77712 14.4016 8.76157 14.3688 8.7377C14.3361 8.71384 14.3096 8.68237 14.2917 8.646L12.2227 4.454C12.202 4.41227 12.1701 4.37714 12.1305 4.35259C12.0909 4.32803 12.0453 4.31502 11.9987 4.31502C11.9521 4.31502 11.9065 4.32803 11.8669 4.35259C11.8273 4.37714 11.7954 4.41227 11.7747 4.454L9.70571 8.646ZM11.9997 7.39L11.0517 9.311C10.9262 9.5653 10.7407 9.78526 10.5113 9.95197C10.2819 10.1187 10.0154 10.2271 9.73471 10.268L7.61471 10.576L9.14871 12.071C9.56071 12.473 9.74871 13.053 9.65171 13.621L9.28971 15.731L11.1857 14.734C11.4369 14.6019 11.7164 14.5329 12.0002 14.5329C12.284 14.5329 12.5635 14.6019 12.8147 14.734L14.7097 15.731L14.3477 13.621C14.2997 13.3411 14.3204 13.0538 14.4082 12.7837C14.4961 12.5137 14.6483 12.2691 14.8517 12.071L16.3847 10.576L14.2647 10.268C13.9841 10.2271 13.7176 10.1187 13.4882 9.95197C13.2587 9.78526 13.0733 9.5653 12.9477 9.311L11.9997 7.39Z" fill="#3858E9"/>
        </svg>
    } />,
    imageBlock: <Icon icon={<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M19 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H19C20.1 21 21 20.1 21 19V5C21 3.9 20.1 3 19 3ZM5 4.5H19C19.3 4.5 19.5 4.7 19.5 5V13.4L16.5 10.5C16.2 10.2 15.7 10.2 15.5 10.5L11.9 14L9 12C8.7 11.8 8.4 11.8 8.2 12L4.6 14.6V5C4.5 4.7 4.7 4.5 5 4.5ZM19 19.5H5C4.7 19.5 4.5 19.3 4.5 19V16.6L8.6 13.6L11.6 15.5C11.9 15.7 12.3 15.7 12.5 15.4L16 12L19.5 15.4V19C19.5 19.3 19.3 19.5 19 19.5Z" fill="#3858E9"/>
        </svg>
    } />,
    teamMemberBlock: <Icon icon={<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.25 16.437C6.3853 15.5113 5.80992 14.3531 5.59459 13.1048C5.37927 11.8565 5.53339 10.5725 6.038 9.41062C6.54261 8.24874 7.37573 7.25961 8.43493 6.56484C9.49413 5.87007 10.7333 5.49994 12 5.49994C13.2667 5.49994 14.5059 5.87007 15.5651 6.56484C16.6243 7.25961 17.4574 8.24874 17.962 9.41062C18.4666 10.5725 18.6207 11.8565 18.4054 13.1048C18.1901 14.3531 17.6147 15.5113 16.75 16.437V16C16.75 15.2707 16.4603 14.5712 15.9445 14.0555C15.4288 13.5397 14.7293 13.25 14 13.25H10C9.27065 13.25 8.57118 13.5397 8.05546 14.0555C7.53973 14.5712 7.25 15.2707 7.25 16V16.437ZM8.75 17.63C9.73766 18.2015 10.8589 18.5017 12 18.5C13.1411 18.5017 14.2623 18.2015 15.25 17.63V16C15.25 15.31 14.69 14.75 14 14.75H10C9.31 14.75 8.75 15.31 8.75 16V17.63ZM4 12C4 9.87827 4.84285 7.84344 6.34315 6.34315C7.84344 4.84285 9.87827 4 12 4C14.1217 4 16.1566 4.84285 17.6569 6.34315C19.1571 7.84344 20 9.87827 20 12C20 14.1217 19.1571 16.1566 17.6569 17.6569C16.1566 19.1571 14.1217 20 12 20C9.87827 20 7.84344 19.1571 6.34315 17.6569C4.84285 16.1566 4 14.1217 4 12ZM14 10C14 10.5304 13.7893 11.0391 13.4142 11.4142C13.0391 11.7893 12.5304 12 12 12C11.4696 12 10.9609 11.7893 10.5858 11.4142C10.2107 11.0391 10 10.5304 10 10C10 9.46957 10.2107 8.96086 10.5858 8.58579C10.9609 8.21071 11.4696 8 12 8C12.5304 8 13.0391 8.21071 13.4142 8.58579C13.7893 8.96086 14 9.46957 14 10Z" fill="#3858E9"/>
        </svg>
    } />,
    googleMapsBlock: <Icon icon={<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M12 9C11.2 9 10.5 9.7 10.5 10.5C10.5 11.3 11.2 12 12 12C12.8 12 13.5 11.3 13.5 10.5C13.5 9.7 12.8 9 12 9ZM12 4C8.4 4 5.5 6.8 5.5 10.2C5.5 11 5.8 12 6.4 13.3C6.9 14.4 7.6 15.6 8.4 16.9C9.1 17.9 11.4 20.7 11.6 20.8L12 21.3L12.4 20.8C12.6 20.6 15 17.9 15.6 16.9C16.4 15.7 17.1 14.4 17.6 13.3C18.2 12 18.5 11 18.5 10.2C18.5 6.8 15.6 4 12 4ZM16.3 12.7C15.8 13.7 15.2 14.9 14.4 16.1C13.9 16.8 12.7 18.3 12 19.1C11.3 18.3 10.1 16.8 9.6 16.1C8.8 14.9 8.2 13.8 7.7 12.8C7.1 11.4 7 10.6 7 10.3C7 7.7 9.2 5.6 12 5.6C14.8 5.6 17 7.7 17 10.3C17 10.5 16.9 11.3 16.3 12.7Z" fill="#3858E9"/>
        </svg>        
    } />,
    headingBlock: <Icon icon={<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M6 5V18.5911L12 13.8473L18 18.5911V5H6Z" fill="#3858E9"/>
        </svg>
    } />,
    buttonBlock: <Icon icon={<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M8 12.5H16V11H8V12.5ZM19 6.5H5C4.46957 6.5 3.96086 6.71071 3.58579 7.08579C3.21071 7.46086 3 7.96957 3 8.5V15C3 15.5304 3.21071 16.0391 3.58579 16.4142C3.96086 16.7893 4.46957 17 5 17H19C19.5304 17 20.0391 16.7893 20.4142 16.4142C20.7893 16.0391 21 15.5304 21 15V8.5C21 7.96957 20.7893 7.46086 20.4142 7.08579C20.0391 6.71071 19.5304 6.5 19 6.5ZM5 8H19C19.1326 8 19.2598 8.05268 19.3536 8.14645C19.4473 8.24021 19.5 8.36739 19.5 8.5V15C19.5 15.1326 19.4473 15.2598 19.3536 15.3536C19.2598 15.4473 19.1326 15.5 19 15.5H5C4.86739 15.5 4.74021 15.4473 4.64645 15.3536C4.55268 15.2598 4.5 15.1326 4.5 15V8.5C4.5 8.36739 4.55268 8.24021 4.64645 8.14645C4.74021 8.05268 4.86739 8 5 8Z" fill="#3858E9"/>
        </svg>
    } />,
    textBlock: <Icon icon={<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M12.9004 6H10.9004L6.90039 17H8.80039L9.90039 14H14.1004L15.2004 17H17.1004L12.9004 6ZM10.4004 12.5L11.9004 7.6L13.6004 12.5H10.4004Z" fill="#3858E9"/>
        </svg>
    } />,                        

    // Alignment Icons.
    alignBottom: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path d="M13 10H17V16H13V10Z" fill="currentColor" fill-opacity="0.5" />
        <path d="M11 4H7V16H11V4Z" fill="currentColor" />
        <path d="M18 18H6V20H18V18Z" fill="currentColor" />
      </svg>
    } />,
    alignCenter: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path d="M9 13H15V17H9V13Z" fill="currentColor" fill-opacity="0.5" />
        <path d="M6 7H18V11H6V7Z" fill="currentColor" />
      </svg>
    } />,
    alignLeft: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path d="M8 13H14V17H8V13Z" fill="currentColor" fill-opacity="0.5" />
        <path d="M6 6H4V18H6V6Z" fill="currentColor" />
        <path d="M20 7H8V11H20V7Z" fill="currentColor" />
      </svg>
    } />,
    alignMiddle: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path d="M13 9H17V15H13V9Z" fill="currentColor" fill-opacity="0.5" />
        <path d="M7 6H11V18H7V6Z" fill="currentColor" />
      </svg>
    } />,
    alignRight: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          fill-rule="evenodd"
          clip-rule="evenodd"
          d="M15.9991 13.0039L9.99907 12.9911L9.99054 16.9911L15.9905 17.0039L15.9991 13.0039Z"
          fill="currentColor"
          fill-opacity="0.5"
        />
        <path
          fill-rule="evenodd"
          clip-rule="evenodd"
          d="M19.978 18.0021L20.0036 6.00214L18.0036 5.99788L17.978 17.9979L19.978 18.0021Z"
          fill="currentColor"
        />
        <path
          fill-rule="evenodd"
          clip-rule="evenodd"
          d="M3.9964 10.9851L15.9964 11.0107L16.0049 7.0107L4.00493 6.98512L3.9964 10.9851Z"
          fill="currentColor"
        />
      </svg>
    } />,
    alignTop: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          fill-rule="evenodd"
          clip-rule="evenodd"
          d="M13.0352 7.98797L13.0374 13.988L17.0374 13.9865L17.0352 7.98653L13.0352 7.98797Z"
          fill="currentColor"
          fill-opacity="0.5"
        />
        <path
          fill-rule="evenodd"
          clip-rule="evenodd"
          d="M17.9996 4.01189L5.99963 4.01837L6.00038 6.01837L18.0004 6.01189L17.9996 4.01189Z"
          fill="currentColor"
        />
        <path
          fill-rule="evenodd"
          clip-rule="evenodd"
          d="M11.0374 19.9864L11.0321 7.98637L7.03207 7.98813L7.03736 19.9881L11.0374 19.9864Z"
          fill="currentColor"
        />
      </svg>
    } />,
    spaceBetween: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path d="M19 5L15 5L15 19H19V17H17L17 7L19 7V5Z" fill="currentColor" />
        <path d="M5 5L9 5L9 19H5L5 17H7L7 7H5L5 5Z" fill="currentColor" />
        <path d="M13 7V17H11L11 7H13Z" fill="currentColor" />
      </svg>
    } />,
    spaceAround: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path d="M5 5V9H19V5H17V7H7V5H5Z" fill="currentColor" />
        <path d="M5 19V15H19V19H17V17H7V19H5Z" fill="currentColor" />
        <path d="M7 11H17V13H7V11Z" fill="currentColor" />
      </svg>
    } />,
    stretchHorizontal: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path d="M1 7H3V17H1V7Z" fill="currentColor" />
        <path
          d="M8.44769 7.75732L9.86191 9.17154L8.03344 11H15.9664L14.138 9.17154L15.5522 7.75732L19.7948 12L15.5522 16.2426L14.138 14.8284L15.9664 13H8.03354L9.86194 14.8284L8.44773 16.2426L4.20505 12L8.44769 7.75732Z"
          fill="currentColor"
        />
        <path d="M23 7H21V17H23V7Z" fill="currentColor" />
      </svg>
    } />,
    stretchVertical: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path d="M17 1V3L7 3V1L17 1Z" fill="currentColor" />
        <path
          d="M16.2427 8.44772L14.8285 9.86194L13 8.03347L13 15.9665L14.8285 14.138L16.2427 15.5522L12 19.7949L7.75742 15.5522L9.17163 14.138L11 15.9664L11 8.03357L9.17163 9.86194L7.75742 8.44772L12 4.20508L16.2427 8.44772Z"
          fill="currentColor"
        />
        <path d="M17 23V21H7V23H17Z" fill="currentColor" />
      </svg>
    } />,
    arrowRight: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M15.0378 6.34317L13.6269 7.76069L16.8972 11.0157L3.29211 11.0293L3.29413 13.0293L16.8619 13.0157L13.6467 16.2459L15.0643 17.6568L20.7079 11.9868L15.0378 6.34317Z"
          fill="currentColor"
        />
      </svg>
    } />,
    arrowLeft: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M20.3284 11.0001V13.0001L7.50011 13.0001L10.7426 16.2426L9.32842 17.6568L3.67157 12L9.32842 6.34314L10.7426 7.75735L7.49988 11.0001L20.3284 11.0001Z"
          fill="currentColor"
        />
      </svg>
    } />,
    arrowDown: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M11.0001 3.67157L13.0001 3.67157L13.0001 16.4999L16.2426 13.2574L17.6568 14.6716L12 20.3284L6.34314 14.6716L7.75735 13.2574L11.0001 16.5001L11.0001 3.67157Z"
          fill="currentColor"
        />
      </svg>
    } />,
    arrowUp: <Icon icon={<svg
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M17.6568 8.96219L16.2393 10.3731L12.9843 7.10285L12.9706 20.7079L10.9706 20.7059L10.9843 7.13806L7.75404 10.3532L6.34314 8.93572L12.0132 3.29211L17.6568 8.96219Z"
          fill="currentColor"
        />
      </svg>
    } />,
}