/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./assets/js/src/plugin-dashboard/App.jsx":
/*!************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/App.jsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   App: () => (/* binding */ App)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/development/chunk-WWGJGFF6.mjs");
/* harmony import */ var _router_PagesRouter_jsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./router/PagesRouter.jsx */ "./assets/js/src/plugin-dashboard/router/PagesRouter.jsx");
/* harmony import */ var _theme_default_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./theme/default.js */ "./assets/js/src/plugin-dashboard/theme/default.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _components_SettingsSavedMessages_SettingsSavedMessages_jsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./components/SettingsSavedMessages/SettingsSavedMessages.jsx */ "./assets/js/src/plugin-dashboard/components/SettingsSavedMessages/SettingsSavedMessages.jsx");
/* harmony import */ var _components_TopBar_TopBar_jsx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./components/TopBar/TopBar.jsx */ "./assets/js/src/plugin-dashboard/components/TopBar/TopBar.jsx");
/* harmony import */ var _components_Navigation_MainNavigation_jsx__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/Navigation/MainNavigation.jsx */ "./assets/js/src/plugin-dashboard/components/Navigation/MainNavigation.jsx");
/* harmony import */ var _components_Hero_Hero_jsx__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./components/Hero/Hero.jsx */ "./assets/js/src/plugin-dashboard/components/Hero/Hero.jsx");

/** @jsx jsx */;










const dashboardGeneralData = athemesBlocksGeneralData || {};
const styles = theme => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    position: relative;
    width: 100%;

    * {
        box-sizing: border-box;
    }

    a {
        &:focus {
            outline: none;
            box-shadow: none;
        }
    }

    .atb-dashboard__card {
        background-color: ${theme.colors.backgroundColorLight};
        border-radius: 10px;
        padding: 16px;
    }

    .atb-dashboard__pages-wrapper {
		position: relative;
        max-width: ${theme.containerMaxWidth}px;
        margin: 0 auto;
		z-index: 1;
    }
`;
const useQuery = () => {
  const {
    search
  } = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => new URLSearchParams(search), [search]);
};
function App() {
  const query = useQuery();
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_emotion_react__WEBPACK_IMPORTED_MODULE_2__.a, {
    theme: _theme_default_js__WEBPACK_IMPORTED_MODULE_5__["default"]
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard",
    css: styles(_theme_default_js__WEBPACK_IMPORTED_MODULE_5__["default"])
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_TopBar_TopBar_jsx__WEBPACK_IMPORTED_MODULE_8__.TopBar, {
    logo: dashboardGeneralData.topbar.logo,
    version: dashboardGeneralData.topbar.version,
    websiteUrl: dashboardGeneralData.topbar.website_url
  }), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_Hero_Hero_jsx__WEBPACK_IMPORTED_MODULE_10__.Hero, {
    title: dashboardGeneralData.hero.title,
    description: dashboardGeneralData.hero.description,
    buttonLabel: dashboardGeneralData.hero.button_label,
    buttonUrl: dashboardGeneralData.hero.button_url,
    image: dashboardGeneralData.hero.image
  }), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__pages-wrapper atb-dashboard__card"
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_Navigation_MainNavigation_jsx__WEBPACK_IMPORTED_MODULE_9__.MainNavigation, {
    links: [{
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)('Blocks'),
      id: 'blocks',
      path: 'blocks'
    }, {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_6__.__)('Settings'),
      id: 'settings',
      path: 'settings',
      section: 'editor-options'
    }]
  }), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_router_PagesRouter_jsx__WEBPACK_IMPORTED_MODULE_4__.PagesRouter, {
    page: query.get('path')
  })), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_SettingsSavedMessages_SettingsSavedMessages_jsx__WEBPACK_IMPORTED_MODULE_7__.SettingsSavedMessages, null)));
}
;

/***/ }),

/***/ "./assets/js/src/plugin-dashboard/components/BlocksCard/BlocksCard.jsx":
/*!*****************************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/components/BlocksCard/BlocksCard.jsx ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BlocksCard: () => (/* binding */ BlocksCard)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../contexts/GlobalContext.jsx */ "./assets/js/src/plugin-dashboard/contexts/GlobalContext.jsx");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/api-fetch */ "./node_modules/@wordpress/api-fetch/build-module/index.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/components */ "./node_modules/@wordpress/components/build-module/toggle-control/index.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/components */ "./node_modules/@wordpress/components/build-module/tooltip/index.js");
/* harmony import */ var _icons_icons_jsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../icons/icons.jsx */ "./assets/js/src/plugin-dashboard/icons/icons.jsx");

/** @jsx jsx */;








const styles = theme => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    display: flex;
    align-items: flex-start;
    flex-direction: column;
    gap: 24px;
    padding: 24px;
    background-color: ${theme.colors.backgroundColorLight};
    border: 1px solid ${theme.colors.borderColorGray};
    border-radius: 10px;
    box-shadow: 2px 2px 4px 0px #00285005;

    .atb-dashboard__blocks-card-title {
        display: flex;
        align-items: center;
        justify-content: space-between;
        width: 100%;
        font-size: ${theme.fontSize.cardTitle};
        line-height: ${theme.lineHeight.cardTitle};
        font-weight: 600;
        color: ${theme.colors.textColorDark};
        margin: 0;

        .components-base-control {
            margin: 0;
        }
    }

    .atb-dashboard__blocks-card-description {
        font-size: ${theme.fontSize.cardDescription};
        line-height: ${theme.lineHeight.cardDescription};
        color: ${theme.colors.textColorGray};
        margin: 0;
    }

    .atb-dashboard__blocks-card-icon {
        display: inline-flex;
        padding: 4px 0;
    }

    // Suggested Products.
    &.atb-dashboard__blocks-card--suggested-products {
        gap: 16px;

        .atb-dashboard__blocks-card-title {
            font-size: ${theme.fontSize.cardHeading};
            line-height: ${theme.lineHeight.cardHeading};
        }
    }

    // Quick Links.
    &.atb-dashboard__blocks-card--quick-links {
        gap: 16px;
        
        .atb-dashboard__blocks-card-title {
            font-size: ${theme.fontSize.cardHeading};
            line-height: ${theme.lineHeight.cardHeading};
        }
    }

    // Settings.
    &.atb-dashboard__blocks-card--settings {
        gap: 41px;
    }
`;
const BlocksCard = props => {
  const {
    title,
    className,
    description,
    documentation,
    children,
    hasSwitchToggle = false,
    switchToggleChecked = false,
    blockSlug
  } = props;
  const [isSwitchToggleChecked, setIsSwitchToggleChecked] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(switchToggleChecked);
  const [enabledBlocks, setEnabledBlocks] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_2__.EnabledBlocksContext);
  const swithToggleOnChangeHandler = () => {
    // Get current enabled blocks
    (0,_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__["default"])({
      path: '/wp-json/wp/v2/settings',
      method: 'GET',
      headers: {
        'X-WP-Nonce': wpApiSettings ? wpApiSettings.nonce : ''
      }
    }).then(response => {
      // Parse the string into an array if it's a string.
      let currentEnabledBlocks = [];
      if (typeof response.athemes_blocks_enabled_blocks === 'string' && response.athemes_blocks_enabled_blocks) {
        try {
          currentEnabledBlocks = JSON.parse(response.athemes_blocks_enabled_blocks);
        } catch (e) {
          currentEnabledBlocks = [];
        }
      } else if (Array.isArray(response.athemes_blocks_enabled_blocks)) {
        currentEnabledBlocks = response.athemes_blocks_enabled_blocks;
      }
      let updatedEnabledBlocks;
      if (isSwitchToggleChecked) {
        // Remove the block from enabled list.
        updatedEnabledBlocks = currentEnabledBlocks.filter(slug => slug !== blockSlug);
      } else {
        // Add the block to enabled list.
        updatedEnabledBlocks = [...currentEnabledBlocks, blockSlug];
      }

      // Update the state.
      setIsSwitchToggleChecked(!isSwitchToggleChecked);

      // Save to database.
      (0,_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__["default"])({
        path: '/wp-json/wp/v2/settings',
        method: 'POST',
        headers: {
          'X-WP-Nonce': wpApiSettings ? wpApiSettings.nonce : ''
        },
        data: {
          'athemes_blocks_enabled_blocks': JSON.stringify(updatedEnabledBlocks)
        }
      }).then(response => {
        setEnabledBlocks(updatedEnabledBlocks);
      });
    });
  };
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: `atb-dashboard__blocks-card ${className}`,
    css: styles
  }, title && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("h3", {
    className: "atb-dashboard__blocks-card-title"
  }, title, hasSwitchToggle && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__["default"], {
    checked: isSwitchToggleChecked,
    onChange: swithToggleOnChangeHandler
  })), description && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: "atb-dashboard__blocks-card-description"
  }, description), documentation && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__["default"], {
    text: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('View Documentation', 'athemes-blocks')
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("a", {
    href: documentation,
    className: "atb-dashboard__blocks-card-icon",
    target: "_blank"
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_icons_icons_jsx__WEBPACK_IMPORTED_MODULE_7__.CustomIcon, {
    icon: "docs"
  }))), children);
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/components/GridList/GridList.jsx":
/*!*************************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/components/GridList/GridList.jsx ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GridList: () => (/* binding */ GridList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");

/** @jsx jsx */;

const styles = (columns, gap) => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    display: grid;
    grid-template-columns: repeat( ${columns}, 1fr );
    gap: ${gap}px;
`;
const GridList = props => {
  const {
    children,
    columns = 3,
    gap = 24
  } = props;
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__grid-list",
    css: styles(columns, gap)
  }, children);
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/components/Hero/Hero.jsx":
/*!*****************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/components/Hero/Hero.jsx ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Hero: () => (/* binding */ Hero)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js");

/** @jsx jsx */;

const styles = theme => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    position: relative;
    max-width: ${theme.containerMaxWidth}px;
    margin: 0 auto;
    padding: 60px 60px 60px 0;
    z-index: 0;

    .atb-dashboard__hero-title {
        font-size: ${theme.fontSize.heroTitle};
        font-weight: 600;
        line-height: ${theme.lineHeight.heroTitle};
        color: ${theme.colors.textColorDark};
        margin: 0 0 4px;
    }

    .atb-dashboard__hero-description {
        font-size: ${theme.fontSize.default};
        line-height: ${theme.lineHeight.default};
        color: ${theme.colors.textColorGray};
        margin: 0 0 20px;
    }

    .atb-dashboard__hero-button {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        padding: 12px 24px;
        background-color: ${theme.colors.primary};
        color: ${theme.colors.textColorLight};
        border-radius: 2px;
        text-decoration: none;
        font-size: ${theme.fontSize.small};
        font-weight: 500;
        line-height: ${theme.lineHeight.small};
        transition: background-color 0.3s ease;

        &:hover {
            background-color: ${theme.colors.primaryHover};
        }
    }

    .atb-dashboard__hero-image {
        position: absolute;
        top: 16px;
        right: 0px;
        width: 370px;
        height: 100%;
        object-fit: contain;
        object-position: center bottom;
    }
`;
const Hero = props => {
  const {
    title,
    description,
    buttonLabel,
    buttonUrl,
    image
  } = props;
  const theme = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.u)();
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__hero",
    css: styles(theme)
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("h1", {
    className: "atb-dashboard__hero-title"
  }, title), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: "atb-dashboard__hero-description"
  }, description), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("a", {
    href: buttonUrl,
    className: "atb-dashboard__hero-button"
  }, buttonLabel), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
    src: image,
    width: 40,
    height: 40,
    alt: title,
    className: "atb-dashboard__hero-image"
  }));
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/components/LinksCard/LinksCard.jsx":
/*!***************************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/components/LinksCard/LinksCard.jsx ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LinksCard: () => (/* binding */ LinksCard)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _icons_icons_jsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../icons/icons.jsx */ "./assets/js/src/plugin-dashboard/icons/icons.jsx");

/** @jsx jsx */;



const styles = theme => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    gap: 10px;
    width: 100%;
    padding: 20px;
    background-color: ${theme.colors.backgroundColorLight};
    border: 1px solid ${theme.colors.borderColorLightGray};
    border-radius: 10px;
    box-shadow: 2px 2px 4px 0px #00285005;

    .atb-dashboard__links-card-title {
        font-size: ${theme.fontSize.cardTitle};
        line-height: ${theme.lineHeight.cardTitle};
        font-weight: 600;
        color: ${theme.colors.textColorDark};
        margin: 0;
    }

    .atb-dashboard__links-card-description {
        font-size: ${theme.fontSize.cardDescription};
        line-height: ${theme.lineHeight.cardDescription};
        color: ${theme.colors.textColorGray};
        margin: 0 0 5px 0;
    }

    &.atb-dashboard__links-card--active {
        border-color: ${theme.colors.primary};
    }

    .atb-dashboard__links-card-link {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        font-size: ${theme.fontSize.cardAction};
        line-height: ${theme.lineHeight.cardAction};
        font-weight: 600;

        &--underline {
            text-decoration: underline;
            color: ${theme.colors.primary};
            transition: ease opacity 250ms;

            &:hover {
                opacity: 0.8;
            }
        }

        &--button {
            background-color: transparent;;
            color: ${theme.colors.primary};
            border: 1px solid ${theme.colors.primary};
            padding: 8px 16px;
            border-radius: 4px;
            text-decoration: none;
            transition: ease color 250ms, ease background-color 250ms;

            &:hover {
                background-color: ${theme.colors.primary};
                color: ${theme.colors.backgroundColorLight};
            }
        }
    }
`;
const LinksCard = props => {
  const {
    title,
    description,
    linkUrl,
    linkLabel,
    linkStyle,
    isActive
  } = props;
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: `atb-dashboard__links-card ${isActive ? 'atb-dashboard__links-card--active' : ''}`,
    css: styles
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: "atb-dashboard__links-card-title"
  }, title), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: "atb-dashboard__links-card-description"
  }, description), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("a", {
    href: linkUrl,
    target: "_blank",
    className: `atb-dashboard__links-card-link atb-dashboard__links-card-link--${linkStyle}`
  }, linkLabel, linkStyle === 'underline' && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_icons_icons_jsx__WEBPACK_IMPORTED_MODULE_2__.CustomIcon, {
    icon: "external-link",
    className: "atb-dashboard__links-card-link-icon"
  })));
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/components/Navigation/MainNavigation.jsx":
/*!*********************************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/components/Navigation/MainNavigation.jsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MainNavigation: () => (/* binding */ MainNavigation)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/development/chunk-WWGJGFF6.mjs");
/* harmony import */ var _contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../contexts/GlobalContext.jsx */ "./assets/js/src/plugin-dashboard/contexts/GlobalContext.jsx");

/** @jsx jsx */;




const styles = theme => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    position: relative;
    max-width: ${theme.containerMaxWidth}px;
    margin: 0 auto 24px;

    &:after {
        content: '';
        display: block;
        position: absolute;
        bottom: 0;
        left: 50%;
        width: calc(100% + 32px);
        border-bottom: 2px solid ${theme.colors.borderColorGray};
        transform: translate3d(-50%, 0, 0);
        z-index: 0;
    }

    .atb-dashboard__navigation {
        position: relative;
        z-index: 1;

        ul {
            display: flex;
            padding: 0;
            margin: 0;

            li {
                list-style: none;
                margin: 0;

                a {
                    display: flex;
                    align-items: center;
                    gap: 8px;
                    font-size: ${theme.fontSize.menuItem};
                    line-height: ${theme.lineHeight.menuItem};
                    padding: 19px 21px;
                    color: ${theme.colors.textColorDefault};
                    background-color: none;
                    border-bottom-width: 2px;
                    border-bottom-style: solid;
                    border-bottom-color: transparent;
                    text-decoration: none;
                    transition: all 0.3s ease;
                    font-weight: 500;
                }

                &.active,
                &:hover,
                &:focus,
                &:active {
                    a {
                        color: ${theme.colors.textColorDark};
                    }

                    .atb-dashboard__navigation-icon {
                        svg {
                            path {
                                fill: ${theme.colors.primary};
                            }
                        }
                    }
                }

                &.active {
                    a {
                        border-bottom-color: ${theme.colors.primary};
                    }
                }
            }
        }

        .atb-dashboard__navigation-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 24px;
            height: 24px;
        }
    }
`;
const MainNavigation = props => {
  const {
    links
  } = props;
  const theme = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.u)();
  const [activePage, setActivePage, activeSection, setActiveSection] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_4__.PageContext);
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__main-navigation",
    css: styles(theme)
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("nav", {
    className: `atb-dashboard__navigation`
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("ul", null, links.map(link => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("li", {
    key: `${link.path}-${link.title}`,
    className: activePage === link.path ? 'active' : ''
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_3__.Link, {
    to: `?page=at-blocks&path=${link.path}${link.section ? `&section=${link.section}` : ''}`,
    onClick: () => {
      setActivePage(link.path);
      if (link.section) {
        setActiveSection(link.section);
      }
    }
  }, link.icon && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
    className: "atb-dashboard__navigation-icon"
  }, link.icon), link.title))))));
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/components/Navigation/Navigation.jsx":
/*!*****************************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/components/Navigation/Navigation.jsx ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Navigation: () => (/* binding */ Navigation)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/development/chunk-WWGJGFF6.mjs");
/* harmony import */ var _contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../contexts/GlobalContext.jsx */ "./assets/js/src/plugin-dashboard/contexts/GlobalContext.jsx");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");

/** @jsx jsx */;





const styles = theme => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    position: relative;
    z-index: 1;

    ul {
        display: flex;
        padding: 0;
        margin: 0;

        li {
            list-style: none;
            margin: 0;

            a {
                display: flex;
                align-items: center;
                gap: 8px;
                font-size: ${theme.fontSize.menuItem};
                line-height: ${theme.lineHeight.menuItem};
                padding: 19px 21px;
                color: ${theme.colors.textColorDefault};
                background-color: none;
                border-bottom-width: 2px;
                border-bottom-style: solid;
                border-bottom-color: transparent;
                text-decoration: none;
                transition: all 0.3s ease;
                font-weight: 500;
            }

            &.active,
            &:hover,
            &:focus,
            &:active {
                a {
                    color: ${theme.colors.textColorDark};
                }

                .atb-dashboard__navigation-icon {
                    svg {
                        path {
                            fill: ${theme.colors.primary};
                        }
                    }
                }
            }

            &.active {
                a {
                    border-bottom-color: ${theme.colors.primary};
                }
            }
        }
    }

    .atb-dashboard__navigation-icon {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 24px;
        height: 24px;
    }

    &.atb-dashboard__navigation--style-2 {
        ul {
            flex-direction: column;

            li {
                a {
                    border-bottom: none;
                    padding: 0px 17px;
                    color: ${theme.colors.textColorDark};
                }

                &.active {
                    a {
                        position: relative;

                        &:after {
                            content: '';
                            display: block;
                            position: absolute;
                            top: 0;
                            left: 0;
                            width: 4px;
                            height: 100%;
                            background-color: ${theme.colors.primary};
                            border-radius: 0 8px 8px 0;
                        }
                    }
                }

                & + li {
                    margin-top: 10px;
                }
            }
        }
    }
`;
const Navigation = props => {
  const {
    links
  } = props;
  const theme = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.u)();
  const [activePage, setActivePage, activeSection, setActiveSection] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_4__.PageContext);
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("nav", {
    className: `atb-dashboard__navigation atb-dashboard__navigation--style-2`,
    css: styles(theme)
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("ul", null, links.map(link => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("li", {
    key: `${link.path}-${link.title}`,
    className: activeSection === link.section ? 'active' : ''
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_router_dom__WEBPACK_IMPORTED_MODULE_3__.Link, {
    to: `?page=at-blocks&path=${link.path}${link.section ? `&section=${link.section}` : ''}`,
    onClick: () => {
      setActiveSection(link.section);
    }
  }, link.icon && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
    className: "atb-dashboard__navigation-icon"
  }, link.icon), link.title)))));
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/components/ProductsCard/ProductsCard.jsx":
/*!*********************************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/components/ProductsCard/ProductsCard.jsx ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ProductsCard: () => (/* binding */ ProductsCard)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "./node_modules/@wordpress/api-fetch/build-module/index.js");
/* harmony import */ var _utils_fetch_jsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/fetch.jsx */ "./assets/js/src/plugin-dashboard/utils/fetch.jsx");
/* harmony import */ var _icons_icons_jsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../icons/icons.jsx */ "./assets/js/src/plugin-dashboard/icons/icons.jsx");

/** @jsx jsx */;








const styles = theme => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    display: flex;
    flex-direction: row;
    align-items: center;
    gap: 16px;
    width: 100%;
    padding: 16px;
    background-color: ${theme.colors.backgroundColorLight};
    border: 1px solid ${theme.colors.borderColorLightGray};
    border-radius: 10px;
    box-shadow: 2px 2px 4px 0px #00285005;

    .atb-dashboard__products-card-title {
        font-size: ${theme.fontSize.cardTitle};
        line-height: ${theme.lineHeight.cardTitle};
        font-weight: 600;
        color: ${theme.colors.textColorDark};
        margin: 0;
    }

    .atb-dashboard__products-card-action {
        display: flex;
        align-items: center;
        gap: 4px;
        font-size: ${theme.fontSize.cardAction};
        line-height: ${theme.lineHeight.cardAction};
        font-weight: 600;
        color: ${theme.colors.textColorDark};
        margin: 0 0 0 auto;

        &--active {
            color: ${theme.colors.success};
        }

        &--install,
        &--inactive {
            color: ${theme.colors.primary};
        }
    }
`;
const ProductsCard = props => {
  const {
    image,
    title,
    pluginSlug,
    pluginStatus
  } = props;
  const [isActive, setIsActive] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(pluginStatus === 'active');
  const [isInactive, setIsInactive] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(pluginStatus === 'inactive');
  const [isInstalling, setIsInstalling] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [isActivating, setIsActivating] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [hasError, setHasError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [errorMessage, setErrorMessage] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
  const installPluginHandler = async e => {
    e.preventDefault();
    setIsInstalling(true);
    setHasError(false);
    setErrorMessage('');
    try {
      const data = await (0,_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__["default"])({
        path: '/wp-json/athemes-blocks/v1/plugin-installer',
        method: 'POST',
        data: {
          plugin: pluginSlug,
          action: 'install'
        },
        headers: {
          'X-WP-Nonce': wpApiSettings ? wpApiSettings.nonce : ''
        }
      });
      if (data.status === 'success') {
        setIsInstalling(false);
        setIsActive(true);
      } else {
        throw new Error(data.message || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Failed to install plugin.', 'athemes-blocks'));
      }
    } catch (error) {
      setHasError(true);
      setErrorMessage(error.message || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('An error occurred while installing the plugin.', 'athemes-blocks'));
      setIsInstalling(false);
      setIsActive(false);
      setIsInactive(false);
    }
  };
  const activatePluginHandler = async e => {
    e.preventDefault();
    setIsActivating(true);
    setHasError(false);
    setErrorMessage('');
    try {
      const data = await (0,_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__["default"])({
        path: '/wp-json/athemes-blocks/v1/plugin-installer',
        method: 'POST',
        data: {
          plugin: pluginSlug,
          action: 'activate'
        },
        headers: {
          'X-WP-Nonce': wpApiSettings ? wpApiSettings.nonce : ''
        }
      });
      if (data.status === 'success') {
        setIsActivating(false);
        setIsActive(true);
        setIsInactive(false);
      } else {
        throw new Error(data.message || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Failed to activate plugin.', 'athemes-blocks'));
      }
    } catch (error) {
      setHasError(true);
      setErrorMessage(error.message || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('An error occurred while activating the plugin.', 'athemes-blocks'));
      setIsActivating(false);
      setIsInstalling(false);
      setIsActive(false);
      setIsInactive(true);
    }
  };

  // Hide error message after 3 seconds.
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    let timeoutId;
    if (hasError) {
      timeoutId = setTimeout(() => {
        setHasError(false);
        setErrorMessage('');
      }, 3000);
    }
    return () => {
      if (timeoutId) {
        clearTimeout(timeoutId);
      }
    };
  }, [hasError]);
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__products-card",
    css: styles
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
    src: image,
    width: 40,
    height: 40,
    alt: title
  }), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: "atb-dashboard__products-card-title"
  }, title), isInstalling && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: "atb-dashboard__products-card-action atb-dashboard__products-card-action--installing"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Installing...', 'athemes-blocks')), isActivating && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: "atb-dashboard__products-card-action atb-dashboard__products-card-action--activating"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Activating...', 'athemes-blocks')), isActive && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: "atb-dashboard__products-card-action atb-dashboard__products-card-action--active"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Activated', 'athemes-blocks'), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_icons_icons_jsx__WEBPACK_IMPORTED_MODULE_5__.CustomIcon, {
    icon: "check"
  })), isInactive && !isActivating && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("a", {
    className: "atb-dashboard__products-card-action atb-dashboard__products-card-action--inactive",
    href: "#",
    onClick: activatePluginHandler
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Activate', 'athemes-blocks')), !isActive && !isInactive && !isInstalling && !isActivating && !hasError && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("a", {
    className: "atb-dashboard__products-card-action atb-dashboard__products-card-action--install",
    href: "#",
    onClick: installPluginHandler
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Install', 'athemes-blocks')), hasError && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: "atb-dashboard__products-card-action atb-dashboard__products-card-action--error"
  }, errorMessage));
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/components/Setting/Setting.jsx":
/*!***********************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/components/Setting/Setting.jsx ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Setting: () => (/* binding */ Setting)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");

/** @jsx jsx */;


const styles = theme => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    position: relative;
    width: 100%;
    display: grid;
    grid-template-columns: 9fr 1fr;
    align-items: center;
    gap: 24px;
    
    .atb-dashboard__setting-label {
        font-size: ${theme.fontSize.settingLabel};
        line-height: ${theme.lineHeight.settingLabel};
        font-weight: 500;
        color: ${theme.colors.textColorDark};
        margin: 0;
    }

    .atb-dashboard__setting-description {
        font-size: ${theme.fontSize.settingDescription};
        line-height: ${theme.lineHeight.settingDescription};
        color: ${theme.colors.textColorGray};
        margin: 0;
    }

    &:after {
        content: '';
        display: block;
        position: absolute;
        top: calc( 100% + 20px );
        width: 100%;
        border-bottom: 1px solid ${theme.colors.borderColorGray};
    }

    &:last-child {
        &:after {
            content: none;
        }
    }
        
    .components-input-control {
        min-width: 85px;
    }

    .components-base-control {
        margin: 0;

        .components-input-control__backdrop {
            border-color: ${theme.colors.borderColorGray} !important;
        }
    }
`;
const Setting = props => {
  const {
    label,
    description,
    children
  } = props;
  const theme = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.u)();
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__setting",
    css: styles(theme)
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", null, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("label", {
    className: "atb-dashboard__setting-label"
  }, label), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: "atb-dashboard__setting-description"
  }, description)), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", null, children));
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/components/SettingFieldNumber/SettingFieldNumber.jsx":
/*!*********************************************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/components/SettingFieldNumber/SettingFieldNumber.jsx ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SettingFieldNumber: () => (/* binding */ SettingFieldNumber)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "./node_modules/@wordpress/components/build-module/number-control/index.js");



const SettingFieldNumber = ({
  value,
  onChange
}) => {
  const [inputValue, setInputValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(value);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__["default"], {
    __next40pxDefaultSize: true,
    label: "",
    value: inputValue,
    onChange: value => {
      setInputValue(value);
      onChange(value);
    }
  });
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/components/SettingFieldToggle/SettingFieldToggle.jsx":
/*!*********************************************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/components/SettingFieldToggle/SettingFieldToggle.jsx ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SettingFieldToggle: () => (/* binding */ SettingFieldToggle)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "./node_modules/@wordpress/components/build-module/toggle-control/index.js");



const SettingFieldToggle = ({
  value,
  onChange
}) => {
  const [inputValue, setInputValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(value);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__["default"], {
    checked: inputValue,
    onChange: value => {
      setInputValue(value);
      onChange(value);
    }
  });
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/components/SettingsSavedMessages/SettingsSavedMessages.jsx":
/*!***************************************************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/components/SettingsSavedMessages/SettingsSavedMessages.jsx ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SettingsSavedMessages: () => (/* binding */ SettingsSavedMessages)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../contexts/GlobalContext.jsx */ "./assets/js/src/plugin-dashboard/contexts/GlobalContext.jsx");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/components */ "./node_modules/@wordpress/components/build-module/snackbar/index.js");

/** @jsx jsx */;





const styles = () => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    position: fixed;
    bottom: 20px;
    left: calc( 160px + 20px );
    z-index: 1000;
`;
const SettingsSavedMessages = () => {
  const [displaySnackBar, setDisplaySnackBar] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_3__.SnackBarContext);
  return displaySnackBar ? (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_4__["default"], {
    css: styles,
    className: "atb-dashboard__snackbar-list",
    onRemove: () => {
      setDisplaySnackBar(false);
    }
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Settings Saved.', 'athemes-blocks')) : null;
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/components/TopBar/TopBar.jsx":
/*!*********************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/components/TopBar/TopBar.jsx ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TopBar: () => (/* binding */ TopBar)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _icons_icons_jsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../icons/icons.jsx */ "./assets/js/src/plugin-dashboard/icons/icons.jsx");

/** @jsx jsx */;



const styles = theme => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    position: relative;
    width: 100%;
    display: flex;
    align-items: center;
    padding: 18px 24px;
    background-color: ${theme.colors.backgroundColorLight};
    color: ${theme.colors.textColorDefault};
    margin-bottom: 36px;
    
    .atb-dashboard__top-bar-item {
        &--version {
            margin-left: auto;
        }

        &-notification {
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 24px;
            height: 24px;
            border: 1px solid ${theme.colors.borderColorGray};
            border-radius: 50%;
            cursor: pointer;
            margin-left: 21px;

            &-count {
                position: absolute;
                top: -3px;
                right: -3px;
                width: 10px;
                height: 10px;
                border-radius: 50%;
                background-color: ${theme.colors.danger};
                font-size: 6px;
                line-height: 1.8;
                font-weight: 500;
                color: ${theme.colors.textColorLight};
                text-align: center;
            }

            svg {
                width: 13px;
                height: 11px;
            }

            &:before,
            &:after {
                content: '';
                display: block;
                position: absolute;
                top: 50%;
                height: calc( 100% - 10px );
                border-left: 1px solid ${theme.colors.borderColorGray};
                transform: translate3d(0, -50%, 0);
            }

            &:before {
                right: calc( 100% + 10px );
            }

            &:after {
                left: calc( 100% + 10px );
            }
        }

        &--website {
            margin-left: 21px;

            a {
                display: flex;
                align-items: center;
                gap: 7px;
                color: ${theme.colors.primary};
                font-weight: 500;
            }
        }
    }
`;
const TopBar = props => {
  const {
    logo,
    version,
    websiteUrl
  } = props;
  const theme = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.u)();
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__top-bar",
    css: styles(theme)
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__top-bar-item atb-dashboard__top-bar-item--logo"
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("a", {
    href: websiteUrl,
    target: "_blank"
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("img", {
    src: logo,
    width: 95,
    height: "auto",
    alt: "aThemes"
  }))), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__top-bar-item atb-dashboard__top-bar-item--version"
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", null, version)), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__top-bar-item"
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__top-bar-item-notification"
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
    className: "atb-dashboard__top-bar-item-notification-count"
  }, "1"), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_icons_icons_jsx__WEBPACK_IMPORTED_MODULE_4__.CustomIcon, {
    icon: "loudspeaker"
  }))), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__top-bar-item atb-dashboard__top-bar-item--website"
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("a", {
    href: websiteUrl,
    target: "_blank"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Website', 'a-themes-blocks'), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_icons_icons_jsx__WEBPACK_IMPORTED_MODULE_4__.CustomIcon, {
    icon: "external-link"
  }))));
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/contexts/GlobalContext.jsx":
/*!*******************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/contexts/GlobalContext.jsx ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EnabledBlocksContext: () => (/* binding */ EnabledBlocksContext),
/* harmony export */   GlobalContextProvider: () => (/* binding */ GlobalContextProvider),
/* harmony export */   PageContext: () => (/* binding */ PageContext),
/* harmony export */   SettingsContext: () => (/* binding */ SettingsContext),
/* harmony export */   SnackBarContext: () => (/* binding */ SnackBarContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/development/chunk-WWGJGFF6.mjs");



const PageContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)();
const SnackBarContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)();
const EnabledBlocksContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)();
const SettingsContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)();

// A custom hook that builds on useLocation to parse
// the query string for you.
const useQuery = () => {
  const {
    search
  } = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_1__.useLocation)();
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => new URLSearchParams(search), [search]);
};
const GlobalContextProvider = ({
  children
}) => {
  const query = useQuery();
  const [activePage, setActivePage] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(query.get('path'));

  // Set default activeSection to 'editor-options' when on settings page with no section specified.
  const getDefaultActiveSection = () => {
    const section = query.get('section');
    const path = query.get('path');

    // If we're on the settings page and no section is specified, default to 'editor-options'.
    if (path === 'settings' && !section) {
      return 'editor-options';
    }
    return section;
  };
  const [activeSection, setActiveSection] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(getDefaultActiveSection());
  const [displaySnackBar, setDisplaySnackBar] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const [enabledBlocks, setEnabledBlocks] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(athemesBlocksEnabledBlocks || []);

  // Default settings to prevent errors when the option is empty in the database.
  const defaultSettings = {
    editor_options: {
      container_content_width: 1200,
      container_columns_gap: 15,
      container_rows_gap: 15
    },
    performance: {
      load_google_fonts_locally: true
    }
  };
  const [settings, setSettings] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({
    ...defaultSettings,
    ...(athemesBlocksDashboardSettings || {}),
    editor_options: {
      ...defaultSettings.editor_options,
      ...(athemesBlocksDashboardSettings?.editor_options || {})
    },
    performance: {
      ...defaultSettings.performance,
      ...(athemesBlocksDashboardSettings?.performance || {})
    }
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(PageContext.Provider, {
    value: [activePage, setActivePage, activeSection, setActiveSection]
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(SnackBarContext.Provider, {
    value: [displaySnackBar, setDisplaySnackBar]
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(EnabledBlocksContext.Provider, {
    value: [enabledBlocks, setEnabledBlocks]
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(SettingsContext.Provider, {
    value: [settings, setSettings]
  }, children))));
};

/***/ }),

/***/ "./assets/js/src/plugin-dashboard/icons/icons.jsx":
/*!********************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/icons/icons.jsx ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CustomIcon: () => (/* binding */ CustomIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const icons = {
  'check': (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "11",
    height: "12",
    viewBox: "0 0 11 12",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M5.5 11.5C8.53759 11.5 11 9.03759 11 6C11 2.96244 8.53759 0.5 5.5 0.5C2.46244 0.5 0 2.96244 0 6C0 9.03759 2.46244 11.5 5.5 11.5ZM7.65741 3.84258C7.8364 4.02156 7.8364 4.31177 7.65741 4.49076L6.14821 6L7.65741 7.50926C7.8364 7.68826 7.8364 7.97841 7.65741 8.15741C7.47841 8.3364 7.18826 8.3364 7.00926 8.15741L5.5 6.64821L3.99076 8.15741C3.81177 8.3364 3.52156 8.3364 3.34258 8.15741C3.16359 7.97841 3.16359 7.68826 3.34258 7.50926L4.85179 6L3.34258 4.49076C3.16359 4.31177 3.16359 4.02156 3.34258 3.84258C3.52156 3.66359 3.81177 3.66359 3.99076 3.84258L5.5 5.35179L7.00926 3.84258C7.18826 3.66359 7.47841 3.66359 7.65741 3.84258Z",
    fill: "#3FB28F"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "1.8335",
    y: "2.33264",
    width: "6.11111",
    height: "6.72222",
    fill: "#3FB28F"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M7.59229 4.04529L8.03076 4.35681L8.15967 4.44763L8.06201 4.57166L5.43018 7.92615L5.34131 8.03943L5.22412 7.95642L3.57959 6.77966L3.45068 6.68787L3.54932 6.56482L3.87842 6.14978L3.96631 6.03748L4.08252 6.12048L5.17236 6.90173L7.38721 4.07458L7.47607 3.96228L7.59229 4.04529Z",
    fill: "white",
    stroke: "white",
    strokeWidth: "0.3"
  })),
  'external-link': (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "12",
    height: "13",
    viewBox: "0 0 12 13",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11.4375 0.5H8.25C7.94531 0.5 7.66406 0.6875 7.54688 0.992188C7.42969 1.27344 7.5 1.60156 7.71094 1.8125L8.67188 2.77344L4.14844 7.29688C3.84375 7.57812 3.84375 8.07031 4.14844 8.35156C4.28906 8.49219 4.47656 8.5625 4.6875 8.5625C4.875 8.5625 5.0625 8.49219 5.20312 8.35156L9.72656 3.82812L10.6875 4.78906C10.8281 4.92969 11.0156 5 11.2266 5C11.3203 5 11.4141 5 11.5078 4.95312C11.8125 4.83594 12 4.55469 12 4.25V1.0625C12 0.757812 11.7422 0.5 11.4375 0.5ZM9.1875 8C8.85938 8 8.625 8.25781 8.625 8.5625V11.1875C8.625 11.3047 8.53125 11.375 8.4375 11.375H1.3125C1.19531 11.375 1.125 11.3047 1.125 11.1875V4.0625C1.125 3.96875 1.19531 3.875 1.3125 3.875H3.9375C4.24219 3.875 4.5 3.64062 4.5 3.3125C4.5 3.00781 4.24219 2.75 3.9375 2.75H1.3125C0.585938 2.75 0 3.35938 0 4.0625V11.1875C0 11.9141 0.585938 12.5 1.3125 12.5H8.4375C9.14062 12.5 9.75 11.9141 9.75 11.1875V8.5625C9.75 8.25781 9.49219 8 9.1875 8Z",
    fill: "#3858E9"
  })),
  'docs': (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M3 8.4C3 5.3832 3 3.8744 3.9376 2.9376C4.8744 2 6.3832 2 9.4 2H11C14.0168 2 15.5256 2 16.4624 2.9376C17.4 3.8744 17.4 5.3832 17.4 8.4V11.6C17.4 14.6168 17.4 16.1256 16.4624 17.0624C15.5256 18 14.0168 18 11 18H9.4C6.3832 18 4.8744 18 3.9376 17.0624C3 16.1256 3 14.6168 3 11.6V8.4Z",
    stroke: "#5C5F62",
    strokeWidth: "1.5"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M7 8.39929H13.4M7 11.5993H11",
    stroke: "#5C5F62",
    strokeWidth: "1.5",
    strokeLinecap: "round"
  })),
  'cog': (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11.9277 6C15.2414 6 17.9277 8.68629 17.9277 12C17.9277 15.3137 15.2414 18 11.9277 18C8.61403 18 5.92773 15.3137 5.92773 12C5.92773 8.68629 8.61403 6 11.9277 6ZM11.9277 9C10.2709 9 8.92773 10.3431 8.92773 12C8.92773 13.6569 10.2709 15 11.9277 15C13.5846 15 14.9277 13.6569 14.9277 12C14.9277 10.3431 13.5846 9 11.9277 9Z",
    fill: "#101517"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M13.5674 19.1641C13.487 19.6461 13.0697 19.9998 12.5811 20H11.2744C10.7858 19.9998 10.3684 19.6461 10.2881 19.1641L9.92773 17H13.9277L13.5674 19.1641ZM12.5811 4C13.0697 4.00022 13.487 4.3539 13.5674 4.83594L13.9277 7H9.92773L10.2881 4.83594C10.3684 4.3539 10.7858 4.00022 11.2744 4H12.5811Z",
    fill: "#101517"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.54367 17.0016C6.08596 17.1731 5.57102 16.9887 5.32657 16.5654L4.67374 15.4347C4.42932 15.0113 4.52711 14.4732 4.90451 14.1625L6.59798 12.7676L8.59798 16.2317L6.54367 17.0016ZM19.1821 8.56591C19.4263 8.9892 19.3286 9.52747 18.9513 9.83806L17.2574 11.2322L15.2574 7.76807L17.3117 6.99811C17.7693 6.82666 18.2843 7.01125 18.5288 7.43433L19.1821 8.56591Z",
    fill: "#101517"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M18.9523 14.1633C19.3294 14.474 19.4265 15.0117 19.1822 15.4349L18.5294 16.5657C18.285 16.9889 17.7708 17.1736 17.3131 17.0024L15.2575 16.2328L17.2575 12.7687L18.9523 14.1633ZM5.32715 7.43459C5.57166 7.01152 6.08663 6.82693 6.54426 6.99837L8.59856 7.76833L6.59856 11.2324L4.90461 9.83833C4.52732 9.52773 4.42969 8.98946 4.67383 8.56617L5.32715 7.43459Z",
    fill: "#101517"
  })),
  'performance': (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M14.1109 6.79335L15.5547 7.62693L12.9157 13.0315L10.75 11.7811L14.1109 6.79335Z",
    fill: "#101517"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M12 3.5C16.6944 3.5 20.5 7.30558 20.5 12C20.5 14.3472 19.5489 16.4725 18.0107 18.0107L16.9502 16.9502C18.2169 15.6834 19 13.933 19 12C19 8.13401 15.866 5 12 5C8.13401 5 5 8.13401 5 12C5 13.933 5.78305 15.6834 7.0498 16.9502L5.98926 18.0107C4.45106 16.4725 3.5 14.3472 3.5 12C3.5 7.30558 7.30558 3.5 12 3.5Z",
    fill: "#101517"
  })),
  'loudspeaker': (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "10",
    height: "8",
    viewBox: "0 0 10 8",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.86194 0.131242C8.75503 0.0584347 8.63276 0.0143876 8.50589 0.0029728C8.37902 -0.00844195 8.25143 0.0131252 8.13433 0.0657785L4.29726 1.65655C4.20642 1.69547 4.10927 1.71548 4.01119 1.71547H1.55473C1.34856 1.71547 1.15083 1.80168 1.00505 1.95514C0.859264 2.1086 0.777363 2.31674 0.777363 2.53377V2.59923H0V4.56315H0.777363V4.64825C0.782235 4.86185 0.866281 5.06498 1.01154 5.21422C1.1568 5.36346 1.35175 5.44697 1.55473 5.44691L2.48756 7.52866C2.55073 7.66885 2.65017 7.78744 2.77448 7.87081C2.89878 7.95418 3.04291 7.99896 3.1903 8H3.58209C3.78718 7.99827 3.98331 7.9113 4.12775 7.75802C4.27219 7.60475 4.35324 7.3976 4.35323 7.1817V5.52547L8.13433 7.11624C8.22733 7.1552 8.32652 7.17519 8.42662 7.17515C8.58191 7.17252 8.73314 7.12249 8.86194 7.03114C8.96423 6.95843 9.0486 6.86114 9.10808 6.7473C9.16755 6.63347 9.20043 6.50636 9.20398 6.3765V0.80552C9.20341 0.672312 9.17196 0.541263 9.11235 0.423757C9.05274 0.30625 8.96678 0.205839 8.86194 0.131242ZM3.57587 2.53377V4.64825H1.55473V2.53377H3.57587ZM3.57587 7.1817H3.18408L2.41915 5.44691H3.57587V7.1817ZM4.58333 4.74645C4.5095 4.70672 4.4325 4.67387 4.35323 4.64825V2.48794C4.43174 2.47089 4.50872 2.4468 4.58333 2.41593L8.42662 0.80552V6.35686L4.58333 4.74645ZM9.22264 2.76289V4.39949C9.42881 4.39949 9.62653 4.31327 9.77232 4.15981C9.9181 4.00635 10 3.79821 10 3.58119C10 3.36416 9.9181 3.15602 9.77232 3.00256C9.62653 2.8491 9.42881 2.76289 9.22264 2.76289Z",
    fill: "#1E1E1E"
  }))
};
const CustomIcon = props => {
  const {
    icon
  } = props;
  return icons[icon];
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/pages/PageBlocks.jsx":
/*!*************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/pages/PageBlocks.jsx ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PageBlocks: () => (/* binding */ PageBlocks)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../contexts/GlobalContext.jsx */ "./assets/js/src/plugin-dashboard/contexts/GlobalContext.jsx");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _components_BlocksCard_BlocksCard_jsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../components/BlocksCard/BlocksCard.jsx */ "./assets/js/src/plugin-dashboard/components/BlocksCard/BlocksCard.jsx");
/* harmony import */ var _components_ProductsCard_ProductsCard_jsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/ProductsCard/ProductsCard.jsx */ "./assets/js/src/plugin-dashboard/components/ProductsCard/ProductsCard.jsx");
/* harmony import */ var _components_LinksCard_LinksCard_jsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../components/LinksCard/LinksCard.jsx */ "./assets/js/src/plugin-dashboard/components/LinksCard/LinksCard.jsx");
/* harmony import */ var _components_GridList_GridList_jsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../components/GridList/GridList.jsx */ "./assets/js/src/plugin-dashboard/components/GridList/GridList.jsx");

/** @jsx jsx */;








const blocksData = athemesBlocksBlocksData || {};
const suggestedProducts = athemesBlocksSuggestedProducts || {};
const quickLinks = athemesBlocksQuickLinks || {};
const styles = theme => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    display: grid;
    grid-template-columns: minmax(200px, 3fr) minmax(363px, 1fr);
    gap: 24px;
    align-items: flex-start;
    max-width: ${theme.containerMaxWidth}px;
    margin: 0 auto;
`;
const PageBlocks = () => {
  const [enabledBlocks, setEnabledBlocks] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_2__.EnabledBlocksContext);
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__page atb-dashboard__page--blocks",
    css: styles
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_GridList_GridList_jsx__WEBPACK_IMPORTED_MODULE_7__.GridList, {
    columns: 2,
    gap: 16
  }, Object.entries(blocksData).map(([blockId, blockData]) => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_BlocksCard_BlocksCard_jsx__WEBPACK_IMPORTED_MODULE_4__.BlocksCard, {
    key: blockId,
    blockSlug: blockId,
    title: blockData.title,
    description: blockData.description,
    documentation: blockData.documentation,
    hasSwitchToggle: true,
    switchToggleChecked: enabledBlocks.includes(blockId)
  }))), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_GridList_GridList_jsx__WEBPACK_IMPORTED_MODULE_7__.GridList, {
    columns: 1,
    gap: 16
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_BlocksCard_BlocksCard_jsx__WEBPACK_IMPORTED_MODULE_4__.BlocksCard, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Suggested Products', 'athemes-blocks'),
    className: "atb-dashboard__blocks-card--suggested-products"
  }, Object.keys(suggestedProducts).map(productId => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_ProductsCard_ProductsCard_jsx__WEBPACK_IMPORTED_MODULE_5__.ProductsCard, {
    key: productId,
    image: suggestedProducts[productId].image,
    title: suggestedProducts[productId].title,
    pluginSlug: suggestedProducts[productId].plugin_slug,
    pluginStatus: suggestedProducts[productId].plugin_status
  }))), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_BlocksCard_BlocksCard_jsx__WEBPACK_IMPORTED_MODULE_4__.BlocksCard, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Quick Links', 'athemes-blocks'),
    className: "atb-dashboard__blocks-card--quick-links"
  }, Object.keys(quickLinks).map(linkId => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_LinksCard_LinksCard_jsx__WEBPACK_IMPORTED_MODULE_6__.LinksCard, {
    key: linkId,
    title: quickLinks[linkId].title,
    description: quickLinks[linkId].description,
    linkUrl: quickLinks[linkId].link_url,
    linkLabel: quickLinks[linkId].link_label,
    linkStyle: quickLinks[linkId].link_style,
    isActive: quickLinks[linkId].is_active
  })))));
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/pages/PageSettings.jsx":
/*!***************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/pages/PageSettings.jsx ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PageSettings: () => (/* binding */ PageSettings)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/development/chunk-WWGJGFF6.mjs");
/* harmony import */ var _icons_icons_jsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../icons/icons.jsx */ "./assets/js/src/plugin-dashboard/icons/icons.jsx");
/* harmony import */ var _components_Navigation_Navigation_jsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/Navigation/Navigation.jsx */ "./assets/js/src/plugin-dashboard/components/Navigation/Navigation.jsx");
/* harmony import */ var _components_BlocksCard_BlocksCard_jsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../components/BlocksCard/BlocksCard.jsx */ "./assets/js/src/plugin-dashboard/components/BlocksCard/BlocksCard.jsx");
/* harmony import */ var _PageSettingsEditorOptions_jsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./PageSettingsEditorOptions.jsx */ "./assets/js/src/plugin-dashboard/pages/PageSettingsEditorOptions.jsx");
/* harmony import */ var _PageSettingsPerformance_jsx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./PageSettingsPerformance.jsx */ "./assets/js/src/plugin-dashboard/pages/PageSettingsPerformance.jsx");

/** @jsx jsx */;









const useQuery = () => {
  const {
    search
  } = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => new URLSearchParams(search), [search]);
};
const styles = theme => (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)`
    display: grid;
    grid-template-columns: 1fr 4fr 1fr;
    gap: 20px;
    align-items: flex-start;
    max-width: ${theme.containerMaxWidth}px;
    margin: 0 auto;
`;
const PageSettings = () => {
  const query = useQuery();
  const page = query.get('section');
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: "atb-dashboard__page atb-dashboard__page--settings",
    css: styles
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_Navigation_Navigation_jsx__WEBPACK_IMPORTED_MODULE_5__.Navigation, {
    links: [{
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Editor Options', 'athemes-blocks'),
      path: 'settings',
      section: 'editor-options',
      icon: (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_icons_icons_jsx__WEBPACK_IMPORTED_MODULE_4__.CustomIcon, {
        icon: "cog"
      })
    }, {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Performance', 'athemes-blocks'),
      path: 'settings',
      section: 'performance',
      icon: (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_icons_icons_jsx__WEBPACK_IMPORTED_MODULE_4__.CustomIcon, {
        icon: "performance"
      })
    }]
  }), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_BlocksCard_BlocksCard_jsx__WEBPACK_IMPORTED_MODULE_6__.BlocksCard, {
    className: "atb-dashboard__blocks-card--settings"
  }, page === 'editor-options' && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_PageSettingsEditorOptions_jsx__WEBPACK_IMPORTED_MODULE_7__.PageSettingsEditorOptions, null), page === 'performance' && (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_PageSettingsPerformance_jsx__WEBPACK_IMPORTED_MODULE_8__.PageSettingsPerformance, null)));
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/pages/PageSettingsEditorOptions.jsx":
/*!****************************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/pages/PageSettingsEditorOptions.jsx ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PageSettingsEditorOptions: () => (/* binding */ PageSettingsEditorOptions)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "./node_modules/@wordpress/components/build-module/number-control/index.js");
/* harmony import */ var _contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../contexts/GlobalContext.jsx */ "./assets/js/src/plugin-dashboard/contexts/GlobalContext.jsx");
/* harmony import */ var _components_Setting_Setting_jsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/Setting/Setting.jsx */ "./assets/js/src/plugin-dashboard/components/Setting/Setting.jsx");
/* harmony import */ var _components_SettingFieldNumber_SettingFieldNumber_jsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../components/SettingFieldNumber/SettingFieldNumber.jsx */ "./assets/js/src/plugin-dashboard/components/SettingFieldNumber/SettingFieldNumber.jsx");
/* harmony import */ var _utils_settings_jsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/settings.jsx */ "./assets/js/src/plugin-dashboard/utils/settings.jsx");

/** @jsx jsx */;








const PageSettingsEditorOptions = () => {
  const [displaySnackBar, setDisplaySnackBar] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_4__.SnackBarContext);
  const [settings, setSettings] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_4__.SettingsContext);
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_Setting_Setting_jsx__WEBPACK_IMPORTED_MODULE_5__.Setting, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Default Content Width', 'athemes-blocks'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Set the default content width for the editor.', 'athemes-blocks')
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_SettingFieldNumber_SettingFieldNumber_jsx__WEBPACK_IMPORTED_MODULE_6__.SettingFieldNumber, {
    value: parseInt(settings.editor_options.container_content_width),
    min: 0,
    max: 2000,
    onChange: value => {
      (0,_utils_settings_jsx__WEBPACK_IMPORTED_MODULE_7__.saveSettingValueDebounced)('editor_options', 'container_content_width', value, setDisplaySnackBar, setSettings);
    }
  })), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_Setting_Setting_jsx__WEBPACK_IMPORTED_MODULE_5__.Setting, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Container Columns Gap', 'athemes-blocks'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Set the default container columns gap for the Container block.', 'athemes-blocks')
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__["default"], {
    __next40pxDefaultSize: true,
    min: 0,
    max: 200,
    value: parseInt(settings.editor_options.container_columns_gap),
    onChange: value => {
      (0,_utils_settings_jsx__WEBPACK_IMPORTED_MODULE_7__.saveSettingValueDebounced)('editor_options', 'container_columns_gap', value, setDisplaySnackBar, setSettings);
    }
  })), (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_Setting_Setting_jsx__WEBPACK_IMPORTED_MODULE_5__.Setting, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Container Rows Gap', 'athemes-blocks'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Set the default container rows gap for the Container block.', 'athemes-blocks')
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__["default"], {
    __next40pxDefaultSize: true,
    min: 0,
    max: 200,
    value: parseInt(settings.editor_options.container_rows_gap),
    onChange: value => {
      (0,_utils_settings_jsx__WEBPACK_IMPORTED_MODULE_7__.saveSettingValueDebounced)('editor_options', 'container_rows_gap', value, setDisplaySnackBar, setSettings);
    }
  })));
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/pages/PageSettingsPerformance.jsx":
/*!**************************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/pages/PageSettingsPerformance.jsx ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PageSettingsPerformance: () => (/* binding */ PageSettingsPerformance)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _utils_settings_jsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/settings.jsx */ "./assets/js/src/plugin-dashboard/utils/settings.jsx");
/* harmony import */ var _components_Setting_Setting_jsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../components/Setting/Setting.jsx */ "./assets/js/src/plugin-dashboard/components/Setting/Setting.jsx");
/* harmony import */ var _components_SettingFieldToggle_SettingFieldToggle_jsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/SettingFieldToggle/SettingFieldToggle.jsx */ "./assets/js/src/plugin-dashboard/components/SettingFieldToggle/SettingFieldToggle.jsx");
/* harmony import */ var _contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../contexts/GlobalContext.jsx */ "./assets/js/src/plugin-dashboard/contexts/GlobalContext.jsx");

/** @jsx jsx */;







const PageSettingsPerformance = () => {
  const [displaySnackBar, setDisplaySnackBar] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_6__.SnackBarContext);
  const [settings, setSettings] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_contexts_GlobalContext_jsx__WEBPACK_IMPORTED_MODULE_6__.SettingsContext);
  return (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_Setting_Setting_jsx__WEBPACK_IMPORTED_MODULE_4__.Setting, {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Load Google Fonts Locally', 'athemes-blocks'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Load Google Fonts Locally', 'athemes-blocks')
  }, (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.jsx)(_components_SettingFieldToggle_SettingFieldToggle_jsx__WEBPACK_IMPORTED_MODULE_5__.SettingFieldToggle, {
    value: settings.performance.load_google_fonts_locally,
    onChange: value => {
      (0,_utils_settings_jsx__WEBPACK_IMPORTED_MODULE_3__.saveSettingValueDebounced)('performance', 'load_google_fonts_locally', value, setDisplaySnackBar, setSettings);
    }
  }));
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/router/PagesRouter.jsx":
/*!***************************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/router/PagesRouter.jsx ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PagesRouter: () => (/* binding */ PagesRouter)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _pages_PageBlocks_jsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../pages/PageBlocks.jsx */ "./assets/js/src/plugin-dashboard/pages/PageBlocks.jsx");
/* harmony import */ var _pages_PageSettings_jsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../pages/PageSettings.jsx */ "./assets/js/src/plugin-dashboard/pages/PageSettings.jsx");



function PagesRouter({
  page
}) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, page === 'blocks' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_pages_PageBlocks_jsx__WEBPACK_IMPORTED_MODULE_1__.PageBlocks, null), page === 'settings' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_pages_PageSettings_jsx__WEBPACK_IMPORTED_MODULE_2__.PageSettings, null));
}

/***/ }),

/***/ "./assets/js/src/plugin-dashboard/theme/default.js":
/*!*********************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/theme/default.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const theme = {
  containerMaxWidth: 1235,
  fontSize: {
    small: '13px',
    default: '16px',
    menuItem: '16px',
    heroTitle: '24px',
    cardHeading: '20px',
    cardTitle: '16px',
    cardDescription: '15px',
    cardAction: '13px',
    settingLabel: '16px',
    settingDescription: '13px'
  },
  lineHeight: {
    small: '18px',
    default: '24px',
    menuItem: '30px',
    heroTitle: '34px',
    cardHeading: '30px',
    cardTitle: '26px',
    cardDescription: '24px',
    cardAction: '20px',
    settingLabel: '26px',
    settingDescription: '23px'
  },
  colors: {
    primary: '#3858E9',
    primaryHover: '#2F48C5',
    success: '#3FB28F',
    danger: '#FF453A',
    textColorDefault: '#97A3B6',
    textColorDark: '#101517',
    textColorGray: '#4B5563',
    textColorLight: '#FFF',
    backgroundColorLight: '#FFF',
    backgroundColorGrey: '#F9FAFB',
    borderColorGray: '#EBEBEF',
    borderColorLightGray: '#F6F6F8'
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (theme);

/***/ }),

/***/ "./assets/js/src/plugin-dashboard/utils/fetch.jsx":
/*!********************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/utils/fetch.jsx ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fetchData: () => (/* binding */ fetchData)
/* harmony export */ });
const fetchData = async (endpoint, params = {}, method = 'GET') => {
  const url = `${wpApiSettings.root}athemes-blocks/v1/${endpoint}`;
  const paramsString = new URLSearchParams(params).toString();
  const separator = url.includes('?') ? '&' : '?';
  try {
    const response = await fetch(`${url}${separator}${paramsString}`, {
      method,
      credentials: 'same-origin',
      headers: {
        'X-WP-Nonce': wpApiSettings.nonce
      }
    });
    const result = await response.json();
    return result;
  } catch (error) {
    console.error("Error fetching data:", error);
  }
};


/***/ }),

/***/ "./assets/js/src/plugin-dashboard/utils/settings.jsx":
/*!***********************************************************!*\
  !*** ./assets/js/src/plugin-dashboard/utils/settings.jsx ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   saveSettingValue: () => (/* binding */ saveSettingValue),
/* harmony export */   saveSettingValueDebounced: () => (/* binding */ saveSettingValueDebounced)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/api-fetch */ "./node_modules/@wordpress/api-fetch/build-module/index.js");



/**
 * Keep track of the latest value being saved for each field.
 * 
 * @type {Map<string, Promise>}
 */
const currentSavePromises = new Map();

/**
 * Keep track of the last saved value for each field.
 * 
 * @type {Map<string, any>}
 */
const lastSavedValues = new Map();

/**
 * Save the setting value to the database.
 * 
 * @param {string} settingGroup - The setting group.
 * @param {string} settingId - The setting ID.
 * @param {any} value - The value to save.
 * @param {Function} setDisplaySnackBar - The function to set the display snackbar.
 * @returns {Promise<void>}
 */
const saveSettingValue = (settingGroup, settingId, value, setDisplaySnackBar, setSettings) => {
  const fieldKey = `${settingGroup}-${settingId}`;

  // If there's already a save in progress for this field, wait for it to complete
  if (currentSavePromises.has(fieldKey)) {
    return currentSavePromises.get(fieldKey);
  }

  // If the value hasn't changed since last save, skip
  if (value === lastSavedValues.get(fieldKey)) {
    return Promise.resolve();
  }

  // Create a new save promise
  const savePromise = (0,_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__["default"])({
    path: '/wp-json/athemes-blocks/v1/settings/save',
    method: 'POST',
    headers: {
      'X-WP-Nonce': wpApiSettings ? wpApiSettings.nonce : ''
    },
    data: {
      setting_group: settingGroup,
      setting_id: settingId,
      value: value
    }
  }).then(response => {
    lastSavedValues.set(fieldKey, value);
    setDisplaySnackBar(true);
    setSettings(prevSettings => ({
      ...prevSettings,
      [settingGroup]: {
        ...prevSettings[settingGroup],
        [settingId]: value
      }
    }));
    return response;
  }).catch(error => {
    console.error('Error saving setting:', error);
    throw error;
  }).finally(() => {
    currentSavePromises.delete(fieldKey);
  });
  currentSavePromises.set(fieldKey, savePromise);
  return savePromise;
};

/**
 * Create a debounced version of saveSettingValue for each field.
 * 
 * @param {string} settingGroup - The setting group.
 * @param {string} settingId - The setting ID.
 * @returns {Function} The debounced save function.
 */
const createDebouncedSave = (settingGroup, settingId) => {
  const fieldKey = `${settingGroup}-${settingId}`;
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.debounce)((value, setDisplaySnackBar, setSettings) => {
    return saveSettingValue(settingGroup, settingId, value, setDisplaySnackBar, setSettings);
  }, 400);
};

/**
 * Store debounced functions for each field.
 * 
 * @type {Map<string, Function>}
 */
const debouncedSaves = new Map();

/**
 * Save the setting value to the database with debouncing.
 * 
 * @param {string} settingGroup - The setting group.
 * @param {string} settingId - The setting ID.
 * @param {any} value - The value to save.
 * @param {Function} setDisplaySnackBar - The function to set the display snackbar.
 * @returns {Promise<void>} The result of the save operation.
 */
const saveSettingValueDebounced = (settingGroup, settingId, value, setDisplaySnackBar, setSettings) => {
  const fieldKey = `${settingGroup}-${settingId}`;
  if (!debouncedSaves.has(fieldKey)) {
    debouncedSaves.set(fieldKey, createDebouncedSave(settingGroup, settingId));
  }
  return debouncedSaves.get(fieldKey)(value, setDisplaySnackBar, setSettings);
};


/***/ }),

/***/ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js":
/*!*************************************************************!*\
  !*** ./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   canUseDOM: () => (/* binding */ canUseDOM),
/* harmony export */   contains: () => (/* binding */ contains),
/* harmony export */   getActiveElement: () => (/* binding */ getActiveElement),
/* harmony export */   getDocument: () => (/* binding */ getDocument),
/* harmony export */   getPopupItemRole: () => (/* binding */ getPopupItemRole),
/* harmony export */   getPopupRole: () => (/* binding */ getPopupRole),
/* harmony export */   getScrollingElement: () => (/* binding */ getScrollingElement),
/* harmony export */   getTextboxSelection: () => (/* binding */ getTextboxSelection),
/* harmony export */   getTextboxValue: () => (/* binding */ getTextboxValue),
/* harmony export */   getWindow: () => (/* binding */ getWindow),
/* harmony export */   isButton: () => (/* binding */ isButton),
/* harmony export */   isFrame: () => (/* binding */ isFrame),
/* harmony export */   isPartiallyHidden: () => (/* binding */ isPartiallyHidden),
/* harmony export */   isTextField: () => (/* binding */ isTextField),
/* harmony export */   isTextbox: () => (/* binding */ isTextbox),
/* harmony export */   isVisible: () => (/* binding */ isVisible),
/* harmony export */   scrollIntoViewIfNeeded: () => (/* binding */ scrollIntoViewIfNeeded),
/* harmony export */   setSelectionRange: () => (/* binding */ setSelectionRange),
/* harmony export */   sortBasedOnDOMPosition: () => (/* binding */ sortBasedOnDOMPosition)
/* harmony export */ });
"use client";

// src/utils/dom.ts
var canUseDOM = checkIsBrowser();
function checkIsBrowser() {
  var _a;
  return typeof window !== "undefined" && !!((_a = window.document) == null ? void 0 : _a.createElement);
}
function getDocument(node) {
  if (!node) return document;
  if ("self" in node) return node.document;
  return node.ownerDocument || document;
}
function getWindow(node) {
  if (!node) return self;
  if ("self" in node) return node.self;
  return getDocument(node).defaultView || window;
}
function getActiveElement(node, activeDescendant = false) {
  const { activeElement } = getDocument(node);
  if (!(activeElement == null ? void 0 : activeElement.nodeName)) {
    return null;
  }
  if (isFrame(activeElement) && activeElement.contentDocument) {
    return getActiveElement(
      activeElement.contentDocument.body,
      activeDescendant
    );
  }
  if (activeDescendant) {
    const id = activeElement.getAttribute("aria-activedescendant");
    if (id) {
      const element = getDocument(activeElement).getElementById(id);
      if (element) {
        return element;
      }
    }
  }
  return activeElement;
}
function contains(parent, child) {
  return parent === child || parent.contains(child);
}
function isFrame(element) {
  return element.tagName === "IFRAME";
}
function isButton(element) {
  const tagName = element.tagName.toLowerCase();
  if (tagName === "button") return true;
  if (tagName === "input" && element.type) {
    return buttonInputTypes.indexOf(element.type) !== -1;
  }
  return false;
}
var buttonInputTypes = [
  "button",
  "color",
  "file",
  "image",
  "reset",
  "submit"
];
function isVisible(element) {
  if (typeof element.checkVisibility === "function") {
    return element.checkVisibility();
  }
  const htmlElement = element;
  return htmlElement.offsetWidth > 0 || htmlElement.offsetHeight > 0 || element.getClientRects().length > 0;
}
function isTextField(element) {
  try {
    const isTextInput = element instanceof HTMLInputElement && element.selectionStart !== null;
    const isTextArea = element.tagName === "TEXTAREA";
    return isTextInput || isTextArea || false;
  } catch (_error) {
    return false;
  }
}
function isTextbox(element) {
  return element.isContentEditable || isTextField(element);
}
function getTextboxValue(element) {
  if (isTextField(element)) {
    return element.value;
  }
  if (element.isContentEditable) {
    const range = getDocument(element).createRange();
    range.selectNodeContents(element);
    return range.toString();
  }
  return "";
}
function getTextboxSelection(element) {
  let start = 0;
  let end = 0;
  if (isTextField(element)) {
    start = element.selectionStart || 0;
    end = element.selectionEnd || 0;
  } else if (element.isContentEditable) {
    const selection = getDocument(element).getSelection();
    if ((selection == null ? void 0 : selection.rangeCount) && selection.anchorNode && contains(element, selection.anchorNode) && selection.focusNode && contains(element, selection.focusNode)) {
      const range = selection.getRangeAt(0);
      const nextRange = range.cloneRange();
      nextRange.selectNodeContents(element);
      nextRange.setEnd(range.startContainer, range.startOffset);
      start = nextRange.toString().length;
      nextRange.setEnd(range.endContainer, range.endOffset);
      end = nextRange.toString().length;
    }
  }
  return { start, end };
}
function getPopupRole(element, fallback) {
  const allowedPopupRoles = ["dialog", "menu", "listbox", "tree", "grid"];
  const role = element == null ? void 0 : element.getAttribute("role");
  if (role && allowedPopupRoles.indexOf(role) !== -1) {
    return role;
  }
  return fallback;
}
function getPopupItemRole(element, fallback) {
  var _a;
  const itemRoleByPopupRole = {
    menu: "menuitem",
    listbox: "option",
    tree: "treeitem"
  };
  const popupRole = getPopupRole(element);
  if (!popupRole) return fallback;
  const key = popupRole;
  return (_a = itemRoleByPopupRole[key]) != null ? _a : fallback;
}
function scrollIntoViewIfNeeded(element, arg) {
  if (isPartiallyHidden(element) && "scrollIntoView" in element) {
    element.scrollIntoView(arg);
  }
}
function getScrollingElement(element) {
  if (!element) return null;
  const isScrollableOverflow = (overflow) => {
    if (overflow === "auto") return true;
    if (overflow === "scroll") return true;
    return false;
  };
  if (element.clientHeight && element.scrollHeight > element.clientHeight) {
    const { overflowY } = getComputedStyle(element);
    if (isScrollableOverflow(overflowY)) return element;
  } else if (element.clientWidth && element.scrollWidth > element.clientWidth) {
    const { overflowX } = getComputedStyle(element);
    if (isScrollableOverflow(overflowX)) return element;
  }
  return getScrollingElement(element.parentElement) || document.scrollingElement || document.body;
}
function isPartiallyHidden(element) {
  const elementRect = element.getBoundingClientRect();
  const scroller = getScrollingElement(element);
  if (!scroller) return false;
  const scrollerRect = scroller.getBoundingClientRect();
  const isHTML = scroller.tagName === "HTML";
  const scrollerTop = isHTML ? scrollerRect.top + scroller.scrollTop : scrollerRect.top;
  const scrollerBottom = isHTML ? scroller.clientHeight : scrollerRect.bottom;
  const scrollerLeft = isHTML ? scrollerRect.left + scroller.scrollLeft : scrollerRect.left;
  const scrollerRight = isHTML ? scroller.clientWidth : scrollerRect.right;
  const top = elementRect.top < scrollerTop;
  const left = elementRect.left < scrollerLeft;
  const bottom = elementRect.bottom > scrollerBottom;
  const right = elementRect.right > scrollerRight;
  return top || left || bottom || right;
}
function setSelectionRange(element, ...args) {
  if (/text|search|password|tel|url/i.test(element.type)) {
    element.setSelectionRange(...args);
  }
}
function sortBasedOnDOMPosition(items, getElement) {
  const pairs = items.map((item, index) => [index, item]);
  let isOrderDifferent = false;
  pairs.sort(([indexA, a], [indexB, b]) => {
    const elementA = getElement(a);
    const elementB = getElement(b);
    if (elementA === elementB) return 0;
    if (!elementA || !elementB) return 0;
    if (isElementPreceding(elementA, elementB)) {
      if (indexA > indexB) {
        isOrderDifferent = true;
      }
      return -1;
    }
    if (indexA < indexB) {
      isOrderDifferent = true;
    }
    return 1;
  });
  if (isOrderDifferent) {
    return pairs.map(([_, item]) => item);
  }
  return items;
}
function isElementPreceding(a, b) {
  return Boolean(
    b.compareDocumentPosition(a) & Node.DOCUMENT_POSITION_PRECEDING
  );
}




/***/ }),

/***/ "./node_modules/@ariakit/core/esm/__chunks/75BJEVSH.js":
/*!*************************************************************!*\
  !*** ./node_modules/@ariakit/core/esm/__chunks/75BJEVSH.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDisclosureStore: () => (/* binding */ createDisclosureStore)
/* harmony export */ });
/* harmony import */ var _SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SXKM4CGU.js */ "./node_modules/@ariakit/core/esm/__chunks/SXKM4CGU.js");
/* harmony import */ var _XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./XMCVU3LR.js */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
"use client";



// src/disclosure/disclosure-store.ts
function createDisclosureStore(props = {}) {
  const store = (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_0__.mergeStore)(
    props.store,
    (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_0__.omit)(props.disclosure, ["contentElement", "disclosureElement"])
  );
  (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_0__.throwOnConflictingProps)(props, store);
  const syncState = store == null ? void 0 : store.getState();
  const open = (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_1__.defaultValue)(
    props.open,
    syncState == null ? void 0 : syncState.open,
    props.defaultOpen,
    false
  );
  const animated = (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_1__.defaultValue)(props.animated, syncState == null ? void 0 : syncState.animated, false);
  const initialState = {
    open,
    animated,
    animating: !!animated && open,
    mounted: open,
    contentElement: (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_1__.defaultValue)(syncState == null ? void 0 : syncState.contentElement, null),
    disclosureElement: (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_1__.defaultValue)(syncState == null ? void 0 : syncState.disclosureElement, null)
  };
  const disclosure = (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_0__.createStore)(initialState, store);
  (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_0__.setup)(
    disclosure,
    () => (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_0__.sync)(disclosure, ["animated", "animating"], (state) => {
      if (state.animated) return;
      disclosure.setState("animating", false);
    })
  );
  (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_0__.setup)(
    disclosure,
    () => (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_0__.subscribe)(disclosure, ["open"], () => {
      if (!disclosure.getState().animated) return;
      disclosure.setState("animating", true);
    })
  );
  (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_0__.setup)(
    disclosure,
    () => (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_0__.sync)(disclosure, ["open", "animating"], (state) => {
      disclosure.setState("mounted", state.open || state.animating);
    })
  );
  return {
    ...disclosure,
    disclosure: props.disclosure,
    setOpen: (value) => disclosure.setState("open", value),
    show: () => disclosure.setState("open", true),
    hide: () => disclosure.setState("open", false),
    toggle: () => disclosure.setState("open", (open2) => !open2),
    stopAnimation: () => disclosure.setState("animating", false),
    setContentElement: (value) => disclosure.setState("contentElement", value),
    setDisclosureElement: (value) => disclosure.setState("disclosureElement", value)
  };
}




/***/ }),

/***/ "./node_modules/@ariakit/core/esm/__chunks/BFGNM53A.js":
/*!*************************************************************!*\
  !*** ./node_modules/@ariakit/core/esm/__chunks/BFGNM53A.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPopoverStore: () => (/* binding */ createPopoverStore)
/* harmony export */ });
/* harmony import */ var _KMAUV3TY_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./KMAUV3TY.js */ "./node_modules/@ariakit/core/esm/__chunks/KMAUV3TY.js");
/* harmony import */ var _SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SXKM4CGU.js */ "./node_modules/@ariakit/core/esm/__chunks/SXKM4CGU.js");
/* harmony import */ var _XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./XMCVU3LR.js */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
"use client";




// src/popover/popover-store.ts
function createPopoverStore({
  popover: otherPopover,
  ...props
} = {}) {
  const store = (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_1__.mergeStore)(
    props.store,
    (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_1__.omit)(otherPopover, [
      "arrowElement",
      "anchorElement",
      "contentElement",
      "popoverElement",
      "disclosureElement"
    ])
  );
  (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_1__.throwOnConflictingProps)(props, store);
  const syncState = store == null ? void 0 : store.getState();
  const dialog = (0,_KMAUV3TY_js__WEBPACK_IMPORTED_MODULE_0__.createDialogStore)({ ...props, store });
  const placement = (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(
    props.placement,
    syncState == null ? void 0 : syncState.placement,
    "bottom"
  );
  const initialState = {
    ...dialog.getState(),
    placement,
    currentPlacement: placement,
    anchorElement: (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(syncState == null ? void 0 : syncState.anchorElement, null),
    popoverElement: (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(syncState == null ? void 0 : syncState.popoverElement, null),
    arrowElement: (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(syncState == null ? void 0 : syncState.arrowElement, null),
    rendered: Symbol("rendered")
  };
  const popover = (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_1__.createStore)(initialState, dialog, store);
  return {
    ...dialog,
    ...popover,
    setAnchorElement: (element) => popover.setState("anchorElement", element),
    setPopoverElement: (element) => popover.setState("popoverElement", element),
    setArrowElement: (element) => popover.setState("arrowElement", element),
    render: () => popover.setState("rendered", Symbol("rendered"))
  };
}




/***/ }),

/***/ "./node_modules/@ariakit/core/esm/__chunks/KMAUV3TY.js":
/*!*************************************************************!*\
  !*** ./node_modules/@ariakit/core/esm/__chunks/KMAUV3TY.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDialogStore: () => (/* binding */ createDialogStore)
/* harmony export */ });
/* harmony import */ var _75BJEVSH_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./75BJEVSH.js */ "./node_modules/@ariakit/core/esm/__chunks/75BJEVSH.js");
"use client";


// src/dialog/dialog-store.ts
function createDialogStore(props = {}) {
  return (0,_75BJEVSH_js__WEBPACK_IMPORTED_MODULE_0__.createDisclosureStore)(props);
}




/***/ }),

/***/ "./node_modules/@ariakit/core/esm/__chunks/O6E4ZWCP.js":
/*!*************************************************************!*\
  !*** ./node_modules/@ariakit/core/esm/__chunks/O6E4ZWCP.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isApple: () => (/* binding */ isApple),
/* harmony export */   isFirefox: () => (/* binding */ isFirefox),
/* harmony export */   isMac: () => (/* binding */ isMac),
/* harmony export */   isSafari: () => (/* binding */ isSafari),
/* harmony export */   isTouchDevice: () => (/* binding */ isTouchDevice)
/* harmony export */ });
/* harmony import */ var _37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./37JWRFYW.js */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
"use client";


// src/utils/platform.ts
function isTouchDevice() {
  return _37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.canUseDOM && !!navigator.maxTouchPoints;
}
function isApple() {
  if (!_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.canUseDOM) return false;
  return /mac|iphone|ipad|ipod/i.test(navigator.platform);
}
function isSafari() {
  return _37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.canUseDOM && isApple() && /apple/i.test(navigator.vendor);
}
function isFirefox() {
  return _37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.canUseDOM && /firefox\//i.test(navigator.userAgent);
}
function isMac() {
  return _37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.canUseDOM && navigator.platform.startsWith("Mac") && !isTouchDevice();
}




/***/ }),

/***/ "./node_modules/@ariakit/core/esm/__chunks/SXKM4CGU.js":
/*!*************************************************************!*\
  !*** ./node_modules/@ariakit/core/esm/__chunks/SXKM4CGU.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   batch: () => (/* binding */ batch),
/* harmony export */   createStore: () => (/* binding */ createStore),
/* harmony export */   init: () => (/* binding */ init),
/* harmony export */   mergeStore: () => (/* binding */ mergeStore),
/* harmony export */   omit: () => (/* binding */ omit2),
/* harmony export */   pick: () => (/* binding */ pick2),
/* harmony export */   setup: () => (/* binding */ setup),
/* harmony export */   subscribe: () => (/* binding */ subscribe),
/* harmony export */   sync: () => (/* binding */ sync),
/* harmony export */   throwOnConflictingProps: () => (/* binding */ throwOnConflictingProps)
/* harmony export */ });
/* harmony import */ var _XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./XMCVU3LR.js */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
"use client";


// src/utils/store.ts
function getInternal(store, key) {
  const internals = store.__unstableInternals;
  (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_0__.invariant)(internals, "Invalid store");
  return internals[key];
}
function createStore(initialState, ...stores) {
  let state = initialState;
  let prevStateBatch = state;
  let lastUpdate = Symbol();
  let destroy = _XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_0__.noop;
  const instances = /* @__PURE__ */ new Set();
  const updatedKeys = /* @__PURE__ */ new Set();
  const setups = /* @__PURE__ */ new Set();
  const listeners = /* @__PURE__ */ new Set();
  const batchListeners = /* @__PURE__ */ new Set();
  const disposables = /* @__PURE__ */ new WeakMap();
  const listenerKeys = /* @__PURE__ */ new WeakMap();
  const storeSetup = (callback) => {
    setups.add(callback);
    return () => setups.delete(callback);
  };
  const storeInit = () => {
    const initialized = instances.size;
    const instance = Symbol();
    instances.add(instance);
    const maybeDestroy = () => {
      instances.delete(instance);
      if (instances.size) return;
      destroy();
    };
    if (initialized) return maybeDestroy;
    const desyncs = (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_0__.getKeys)(state).map(
      (key) => (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_0__.chain)(
        ...stores.map((store) => {
          var _a;
          const storeState = (_a = store == null ? void 0 : store.getState) == null ? void 0 : _a.call(store);
          if (!storeState) return;
          if (!(0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_0__.hasOwnProperty)(storeState, key)) return;
          return sync(store, [key], (state2) => {
            setState(
              key,
              state2[key],
              // @ts-expect-error - Not public API. This is just to prevent
              // infinite loops.
              true
            );
          });
        })
      )
    );
    const teardowns = [];
    for (const setup2 of setups) {
      teardowns.push(setup2());
    }
    const cleanups = stores.map(init);
    destroy = (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_0__.chain)(...desyncs, ...teardowns, ...cleanups);
    return maybeDestroy;
  };
  const sub = (keys, listener, set = listeners) => {
    set.add(listener);
    listenerKeys.set(listener, keys);
    return () => {
      var _a;
      (_a = disposables.get(listener)) == null ? void 0 : _a();
      disposables.delete(listener);
      listenerKeys.delete(listener);
      set.delete(listener);
    };
  };
  const storeSubscribe = (keys, listener) => sub(keys, listener);
  const storeSync = (keys, listener) => {
    disposables.set(listener, listener(state, state));
    return sub(keys, listener);
  };
  const storeBatch = (keys, listener) => {
    disposables.set(listener, listener(state, prevStateBatch));
    return sub(keys, listener, batchListeners);
  };
  const storePick = (keys) => createStore((0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_0__.pick)(state, keys), finalStore);
  const storeOmit = (keys) => createStore((0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_0__.omit)(state, keys), finalStore);
  const getState = () => state;
  const setState = (key, value, fromStores = false) => {
    var _a;
    if (!(0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_0__.hasOwnProperty)(state, key)) return;
    const nextValue = (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_0__.applyState)(value, state[key]);
    if (nextValue === state[key]) return;
    if (!fromStores) {
      for (const store of stores) {
        (_a = store == null ? void 0 : store.setState) == null ? void 0 : _a.call(store, key, nextValue);
      }
    }
    const prevState = state;
    state = { ...state, [key]: nextValue };
    const thisUpdate = Symbol();
    lastUpdate = thisUpdate;
    updatedKeys.add(key);
    const run = (listener, prev, uKeys) => {
      var _a2;
      const keys = listenerKeys.get(listener);
      const updated = (k) => uKeys ? uKeys.has(k) : k === key;
      if (!keys || keys.some(updated)) {
        (_a2 = disposables.get(listener)) == null ? void 0 : _a2();
        disposables.set(listener, listener(state, prev));
      }
    };
    for (const listener of listeners) {
      run(listener, prevState);
    }
    queueMicrotask(() => {
      if (lastUpdate !== thisUpdate) return;
      const snapshot = state;
      for (const listener of batchListeners) {
        run(listener, prevStateBatch, updatedKeys);
      }
      prevStateBatch = snapshot;
      updatedKeys.clear();
    });
  };
  const finalStore = {
    getState,
    setState,
    __unstableInternals: {
      setup: storeSetup,
      init: storeInit,
      subscribe: storeSubscribe,
      sync: storeSync,
      batch: storeBatch,
      pick: storePick,
      omit: storeOmit
    }
  };
  return finalStore;
}
function setup(store, ...args) {
  if (!store) return;
  return getInternal(store, "setup")(...args);
}
function init(store, ...args) {
  if (!store) return;
  return getInternal(store, "init")(...args);
}
function subscribe(store, ...args) {
  if (!store) return;
  return getInternal(store, "subscribe")(...args);
}
function sync(store, ...args) {
  if (!store) return;
  return getInternal(store, "sync")(...args);
}
function batch(store, ...args) {
  if (!store) return;
  return getInternal(store, "batch")(...args);
}
function omit2(store, ...args) {
  if (!store) return;
  return getInternal(store, "omit")(...args);
}
function pick2(store, ...args) {
  if (!store) return;
  return getInternal(store, "pick")(...args);
}
function mergeStore(...stores) {
  var _a;
  const initialState = {};
  for (const store2 of stores) {
    const nextState = (_a = store2 == null ? void 0 : store2.getState) == null ? void 0 : _a.call(store2);
    if (nextState) {
      Object.assign(initialState, nextState);
    }
  }
  const store = createStore(initialState, ...stores);
  return Object.assign({}, ...stores, store);
}
function throwOnConflictingProps(props, store) {
  if (false) // removed by dead control flow
{}
  if (!store) return;
  const defaultKeys = Object.entries(props).filter(([key, value]) => key.startsWith("default") && value !== void 0).map(([key]) => {
    var _a;
    const stateKey = key.replace("default", "");
    return `${((_a = stateKey[0]) == null ? void 0 : _a.toLowerCase()) || ""}${stateKey.slice(1)}`;
  });
  if (!defaultKeys.length) return;
  const storeState = store.getState();
  const conflictingProps = defaultKeys.filter(
    (key) => (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_0__.hasOwnProperty)(storeState, key)
  );
  if (!conflictingProps.length) return;
  throw new Error(
    `Passing a store prop in conjunction with a default state is not supported.

const store = useSelectStore();
<SelectProvider store={store} defaultValue="Apple" />
                ^             ^

Instead, pass the default state to the topmost store:

const store = useSelectStore({ defaultValue: "Apple" });
<SelectProvider store={store} />

See https://github.com/ariakit/ariakit/pull/2745 for more details.

If there's a particular need for this, please submit a feature request at https://github.com/ariakit/ariakit
`
  );
}




/***/ }),

/***/ "./node_modules/@ariakit/core/esm/__chunks/TIQDSBWP.js":
/*!*************************************************************!*\
  !*** ./node_modules/@ariakit/core/esm/__chunks/TIQDSBWP.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createHovercardStore: () => (/* binding */ createHovercardStore)
/* harmony export */ });
/* harmony import */ var _BFGNM53A_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BFGNM53A.js */ "./node_modules/@ariakit/core/esm/__chunks/BFGNM53A.js");
/* harmony import */ var _SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SXKM4CGU.js */ "./node_modules/@ariakit/core/esm/__chunks/SXKM4CGU.js");
/* harmony import */ var _XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./XMCVU3LR.js */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
"use client";




// src/hovercard/hovercard-store.ts
function createHovercardStore(props = {}) {
  var _a;
  const syncState = (_a = props.store) == null ? void 0 : _a.getState();
  const popover = (0,_BFGNM53A_js__WEBPACK_IMPORTED_MODULE_0__.createPopoverStore)({
    ...props,
    placement: (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(
      props.placement,
      syncState == null ? void 0 : syncState.placement,
      "bottom"
    )
  });
  const timeout = (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(props.timeout, syncState == null ? void 0 : syncState.timeout, 500);
  const initialState = {
    ...popover.getState(),
    timeout,
    showTimeout: (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(props.showTimeout, syncState == null ? void 0 : syncState.showTimeout),
    hideTimeout: (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(props.hideTimeout, syncState == null ? void 0 : syncState.hideTimeout),
    autoFocusOnShow: (0,_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(syncState == null ? void 0 : syncState.autoFocusOnShow, false)
  };
  const hovercard = (0,_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_1__.createStore)(initialState, popover, props.store);
  return {
    ...popover,
    ...hovercard,
    setAutoFocusOnShow: (value) => hovercard.setState("autoFocusOnShow", value)
  };
}




/***/ }),

/***/ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js":
/*!*************************************************************!*\
  !*** ./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   afterPaint: () => (/* binding */ afterPaint),
/* harmony export */   applyState: () => (/* binding */ applyState),
/* harmony export */   beforePaint: () => (/* binding */ beforePaint),
/* harmony export */   chain: () => (/* binding */ chain),
/* harmony export */   cx: () => (/* binding */ cx),
/* harmony export */   defaultValue: () => (/* binding */ defaultValue),
/* harmony export */   disabledFromProps: () => (/* binding */ disabledFromProps),
/* harmony export */   getKeys: () => (/* binding */ getKeys),
/* harmony export */   hasOwnProperty: () => (/* binding */ hasOwnProperty),
/* harmony export */   identity: () => (/* binding */ identity),
/* harmony export */   invariant: () => (/* binding */ invariant),
/* harmony export */   isEmpty: () => (/* binding */ isEmpty),
/* harmony export */   isFalsyBooleanCallback: () => (/* binding */ isFalsyBooleanCallback),
/* harmony export */   isInteger: () => (/* binding */ isInteger),
/* harmony export */   isObject: () => (/* binding */ isObject),
/* harmony export */   noop: () => (/* binding */ noop),
/* harmony export */   normalizeString: () => (/* binding */ normalizeString),
/* harmony export */   omit: () => (/* binding */ omit),
/* harmony export */   pick: () => (/* binding */ pick),
/* harmony export */   removeUndefinedValues: () => (/* binding */ removeUndefinedValues),
/* harmony export */   shallowEqual: () => (/* binding */ shallowEqual)
/* harmony export */ });
"use client";

// src/utils/misc.ts
function noop(..._) {
}
function shallowEqual(a, b) {
  if (a === b) return true;
  if (!a) return false;
  if (!b) return false;
  if (typeof a !== "object") return false;
  if (typeof b !== "object") return false;
  const aKeys = Object.keys(a);
  const bKeys = Object.keys(b);
  const { length } = aKeys;
  if (bKeys.length !== length) return false;
  for (const key of aKeys) {
    if (a[key] !== b[key]) {
      return false;
    }
  }
  return true;
}
function applyState(argument, currentValue) {
  if (isUpdater(argument)) {
    const value = isLazyValue(currentValue) ? currentValue() : currentValue;
    return argument(value);
  }
  return argument;
}
function isUpdater(argument) {
  return typeof argument === "function";
}
function isLazyValue(value) {
  return typeof value === "function";
}
function isObject(arg) {
  return typeof arg === "object" && arg != null;
}
function isEmpty(arg) {
  if (Array.isArray(arg)) return !arg.length;
  if (isObject(arg)) return !Object.keys(arg).length;
  if (arg == null) return true;
  if (arg === "") return true;
  return false;
}
function isInteger(arg) {
  if (typeof arg === "number") {
    return Math.floor(arg) === arg;
  }
  return String(Math.floor(Number(arg))) === arg;
}
function hasOwnProperty(object, prop) {
  if (typeof Object.hasOwn === "function") {
    return Object.hasOwn(object, prop);
  }
  return Object.prototype.hasOwnProperty.call(object, prop);
}
function chain(...fns) {
  return (...args) => {
    for (const fn of fns) {
      if (typeof fn === "function") {
        fn(...args);
      }
    }
  };
}
function cx(...args) {
  return args.filter(Boolean).join(" ") || void 0;
}
function normalizeString(str) {
  return str.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
}
function omit(object, keys) {
  const result = { ...object };
  for (const key of keys) {
    if (hasOwnProperty(result, key)) {
      delete result[key];
    }
  }
  return result;
}
function pick(object, paths) {
  const result = {};
  for (const key of paths) {
    if (hasOwnProperty(object, key)) {
      result[key] = object[key];
    }
  }
  return result;
}
function identity(value) {
  return value;
}
function beforePaint(cb = noop) {
  const raf = requestAnimationFrame(cb);
  return () => cancelAnimationFrame(raf);
}
function afterPaint(cb = noop) {
  let raf = requestAnimationFrame(() => {
    raf = requestAnimationFrame(cb);
  });
  return () => cancelAnimationFrame(raf);
}
function invariant(condition, message) {
  if (condition) return;
  if (typeof message !== "string") throw new Error("Invariant failed");
  throw new Error(message);
}
function getKeys(obj) {
  return Object.keys(obj);
}
function isFalsyBooleanCallback(booleanOrCallback, ...args) {
  const result = typeof booleanOrCallback === "function" ? booleanOrCallback(...args) : booleanOrCallback;
  if (result == null) return false;
  return !result;
}
function disabledFromProps(props) {
  return props.disabled || props["aria-disabled"] === true || props["aria-disabled"] === "true";
}
function removeUndefinedValues(obj) {
  const result = {};
  for (const key in obj) {
    if (obj[key] !== void 0) {
      result[key] = obj[key];
    }
  }
  return result;
}
function defaultValue(...values) {
  for (const value of values) {
    if (value !== void 0) return value;
  }
  return void 0;
}




/***/ }),

/***/ "./node_modules/@ariakit/core/esm/tooltip/tooltip-store.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@ariakit/core/esm/tooltip/tooltip-store.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createTooltipStore: () => (/* binding */ createTooltipStore)
/* harmony export */ });
/* harmony import */ var _chunks_TIQDSBWP_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../__chunks/TIQDSBWP.js */ "./node_modules/@ariakit/core/esm/__chunks/TIQDSBWP.js");
/* harmony import */ var _chunks_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../__chunks/SXKM4CGU.js */ "./node_modules/@ariakit/core/esm/__chunks/SXKM4CGU.js");
/* harmony import */ var _chunks_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../__chunks/XMCVU3LR.js */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
"use client";







// src/tooltip/tooltip-store.ts
function createTooltipStore(props = {}) {
  var _a;
  if (true) {
    if (props.type === "label") {
      console.warn(
        "The `type` option on the tooltip store is deprecated.",
        "Render a visually hidden label or use the `aria-label` or `aria-labelledby` attributes on the anchor element instead.",
        "See https://ariakit.org/components/tooltip#tooltip-anchors-must-have-accessible-names"
      );
    }
  }
  const syncState = (_a = props.store) == null ? void 0 : _a.getState();
  const hovercard = (0,_chunks_TIQDSBWP_js__WEBPACK_IMPORTED_MODULE_0__.createHovercardStore)({
    ...props,
    placement: (0,_chunks_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(
      props.placement,
      syncState == null ? void 0 : syncState.placement,
      "top"
    ),
    hideTimeout: (0,_chunks_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(props.hideTimeout, syncState == null ? void 0 : syncState.hideTimeout, 0)
  });
  const initialState = {
    ...hovercard.getState(),
    type: (0,_chunks_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(props.type, syncState == null ? void 0 : syncState.type, "description"),
    skipTimeout: (0,_chunks_XMCVU3LR_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(props.skipTimeout, syncState == null ? void 0 : syncState.skipTimeout, 300)
  };
  const tooltip = (0,_chunks_SXKM4CGU_js__WEBPACK_IMPORTED_MODULE_1__.createStore)(initialState, hovercard, props.store);
  return {
    ...hovercard,
    ...tooltip
  };
}



/***/ }),

/***/ "./node_modules/@ariakit/core/esm/utils/events.js":
/*!********************************************************!*\
  !*** ./node_modules/@ariakit/core/esm/utils/events.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addGlobalEventListener: () => (/* binding */ addGlobalEventListener),
/* harmony export */   fireBlurEvent: () => (/* binding */ fireBlurEvent),
/* harmony export */   fireClickEvent: () => (/* binding */ fireClickEvent),
/* harmony export */   fireEvent: () => (/* binding */ fireEvent),
/* harmony export */   fireFocusEvent: () => (/* binding */ fireFocusEvent),
/* harmony export */   fireKeyboardEvent: () => (/* binding */ fireKeyboardEvent),
/* harmony export */   getInputType: () => (/* binding */ getInputType),
/* harmony export */   isDownloading: () => (/* binding */ isDownloading),
/* harmony export */   isFocusEventOutside: () => (/* binding */ isFocusEventOutside),
/* harmony export */   isOpeningInNewTab: () => (/* binding */ isOpeningInNewTab),
/* harmony export */   isPortalEvent: () => (/* binding */ isPortalEvent),
/* harmony export */   isSelfTarget: () => (/* binding */ isSelfTarget),
/* harmony export */   queueBeforeEvent: () => (/* binding */ queueBeforeEvent)
/* harmony export */ });
/* harmony import */ var _chunks_O6E4ZWCP_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../__chunks/O6E4ZWCP.js */ "./node_modules/@ariakit/core/esm/__chunks/O6E4ZWCP.js");
/* harmony import */ var _chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../__chunks/37JWRFYW.js */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
"use client";



// src/utils/events.ts
function isPortalEvent(event) {
  return Boolean(
    event.currentTarget && !(0,_chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_1__.contains)(event.currentTarget, event.target)
  );
}
function isSelfTarget(event) {
  return event.target === event.currentTarget;
}
function isOpeningInNewTab(event) {
  const element = event.currentTarget;
  if (!element) return false;
  const isAppleDevice = (0,_chunks_O6E4ZWCP_js__WEBPACK_IMPORTED_MODULE_0__.isApple)();
  if (isAppleDevice && !event.metaKey) return false;
  if (!isAppleDevice && !event.ctrlKey) return false;
  const tagName = element.tagName.toLowerCase();
  if (tagName === "a") return true;
  if (tagName === "button" && element.type === "submit") return true;
  if (tagName === "input" && element.type === "submit") return true;
  return false;
}
function isDownloading(event) {
  const element = event.currentTarget;
  if (!element) return false;
  const tagName = element.tagName.toLowerCase();
  if (!event.altKey) return false;
  if (tagName === "a") return true;
  if (tagName === "button" && element.type === "submit") return true;
  if (tagName === "input" && element.type === "submit") return true;
  return false;
}
function fireEvent(element, type, eventInit) {
  const event = new Event(type, eventInit);
  return element.dispatchEvent(event);
}
function fireBlurEvent(element, eventInit) {
  const event = new FocusEvent("blur", eventInit);
  const defaultAllowed = element.dispatchEvent(event);
  const bubbleInit = { ...eventInit, bubbles: true };
  element.dispatchEvent(new FocusEvent("focusout", bubbleInit));
  return defaultAllowed;
}
function fireFocusEvent(element, eventInit) {
  const event = new FocusEvent("focus", eventInit);
  const defaultAllowed = element.dispatchEvent(event);
  const bubbleInit = { ...eventInit, bubbles: true };
  element.dispatchEvent(new FocusEvent("focusin", bubbleInit));
  return defaultAllowed;
}
function fireKeyboardEvent(element, type, eventInit) {
  const event = new KeyboardEvent(type, eventInit);
  return element.dispatchEvent(event);
}
function fireClickEvent(element, eventInit) {
  const event = new MouseEvent("click", eventInit);
  return element.dispatchEvent(event);
}
function isFocusEventOutside(event, container) {
  const containerElement = container || event.currentTarget;
  const relatedTarget = event.relatedTarget;
  return !relatedTarget || !(0,_chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_1__.contains)(containerElement, relatedTarget);
}
function getInputType(event) {
  const nativeEvent = "nativeEvent" in event ? event.nativeEvent : event;
  if (!nativeEvent) return;
  if (!("inputType" in nativeEvent)) return;
  if (typeof nativeEvent.inputType !== "string") return;
  return nativeEvent.inputType;
}
function queueBeforeEvent(element, type, callback, timeout) {
  const createTimer = (callback2) => {
    if (timeout) {
      const timerId2 = setTimeout(callback2, timeout);
      return () => clearTimeout(timerId2);
    }
    const timerId = requestAnimationFrame(callback2);
    return () => cancelAnimationFrame(timerId);
  };
  const cancelTimer = createTimer(() => {
    element.removeEventListener(type, callSync, true);
    callback();
  });
  const callSync = () => {
    cancelTimer();
    callback();
  };
  element.addEventListener(type, callSync, { once: true, capture: true });
  return cancelTimer;
}
function addGlobalEventListener(type, listener, options, scope = window) {
  const children = [];
  try {
    scope.document.addEventListener(type, listener, options);
    for (const frame of Array.from(scope.frames)) {
      children.push(addGlobalEventListener(type, listener, options, frame));
    }
  } catch (e) {
  }
  const removeEventListener = () => {
    try {
      scope.document.removeEventListener(type, listener, options);
    } catch (e) {
    }
    for (const remove of children) {
      remove();
    }
  };
  return removeEventListener;
}



/***/ }),

/***/ "./node_modules/@ariakit/core/esm/utils/focus.js":
/*!*******************************************************!*\
  !*** ./node_modules/@ariakit/core/esm/utils/focus.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableFocus: () => (/* binding */ disableFocus),
/* harmony export */   disableFocusIn: () => (/* binding */ disableFocusIn),
/* harmony export */   focusIfNeeded: () => (/* binding */ focusIfNeeded),
/* harmony export */   focusIntoView: () => (/* binding */ focusIntoView),
/* harmony export */   getAllFocusable: () => (/* binding */ getAllFocusable),
/* harmony export */   getAllFocusableIn: () => (/* binding */ getAllFocusableIn),
/* harmony export */   getAllTabbable: () => (/* binding */ getAllTabbable),
/* harmony export */   getAllTabbableIn: () => (/* binding */ getAllTabbableIn),
/* harmony export */   getClosestFocusable: () => (/* binding */ getClosestFocusable),
/* harmony export */   getFirstFocusable: () => (/* binding */ getFirstFocusable),
/* harmony export */   getFirstFocusableIn: () => (/* binding */ getFirstFocusableIn),
/* harmony export */   getFirstTabbable: () => (/* binding */ getFirstTabbable),
/* harmony export */   getFirstTabbableIn: () => (/* binding */ getFirstTabbableIn),
/* harmony export */   getLastTabbable: () => (/* binding */ getLastTabbable),
/* harmony export */   getLastTabbableIn: () => (/* binding */ getLastTabbableIn),
/* harmony export */   getNextTabbable: () => (/* binding */ getNextTabbable),
/* harmony export */   getNextTabbableIn: () => (/* binding */ getNextTabbableIn),
/* harmony export */   getPreviousTabbable: () => (/* binding */ getPreviousTabbable),
/* harmony export */   getPreviousTabbableIn: () => (/* binding */ getPreviousTabbableIn),
/* harmony export */   hasFocus: () => (/* binding */ hasFocus),
/* harmony export */   hasFocusWithin: () => (/* binding */ hasFocusWithin),
/* harmony export */   isFocusable: () => (/* binding */ isFocusable),
/* harmony export */   isTabbable: () => (/* binding */ isTabbable),
/* harmony export */   restoreFocusIn: () => (/* binding */ restoreFocusIn)
/* harmony export */ });
/* harmony import */ var _chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../__chunks/37JWRFYW.js */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
"use client";


// src/utils/focus.ts
var selector = "input:not([type='hidden']):not([disabled]), select:not([disabled]), textarea:not([disabled]), a[href], button:not([disabled]), [tabindex], summary, iframe, object, embed, area[href], audio[controls], video[controls], [contenteditable]:not([contenteditable='false'])";
function hasNegativeTabIndex(element) {
  const tabIndex = Number.parseInt(element.getAttribute("tabindex") || "0", 10);
  return tabIndex < 0;
}
function isFocusable(element) {
  if (!element.matches(selector)) return false;
  if (!(0,_chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.isVisible)(element)) return false;
  if (element.closest("[inert]")) return false;
  return true;
}
function isTabbable(element) {
  if (!isFocusable(element)) return false;
  if (hasNegativeTabIndex(element)) return false;
  if (!("form" in element)) return true;
  if (!element.form) return true;
  if (element.checked) return true;
  if (element.type !== "radio") return true;
  const radioGroup = element.form.elements.namedItem(element.name);
  if (!radioGroup) return true;
  if (!("length" in radioGroup)) return true;
  const activeElement = (0,_chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.getActiveElement)(element);
  if (!activeElement) return true;
  if (activeElement === element) return true;
  if (!("form" in activeElement)) return true;
  if (activeElement.form !== element.form) return true;
  if (activeElement.name !== element.name) return true;
  return false;
}
function getAllFocusableIn(container, includeContainer) {
  const elements = Array.from(
    container.querySelectorAll(selector)
  );
  if (includeContainer) {
    elements.unshift(container);
  }
  const focusableElements = elements.filter(isFocusable);
  focusableElements.forEach((element, i) => {
    if ((0,_chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.isFrame)(element) && element.contentDocument) {
      const frameBody = element.contentDocument.body;
      focusableElements.splice(i, 1, ...getAllFocusableIn(frameBody));
    }
  });
  return focusableElements;
}
function getAllFocusable(includeBody) {
  return getAllFocusableIn(document.body, includeBody);
}
function getFirstFocusableIn(container, includeContainer) {
  const [first] = getAllFocusableIn(container, includeContainer);
  return first || null;
}
function getFirstFocusable(includeBody) {
  return getFirstFocusableIn(document.body, includeBody);
}
function getAllTabbableIn(container, includeContainer, fallbackToFocusable) {
  const elements = Array.from(
    container.querySelectorAll(selector)
  );
  const tabbableElements = elements.filter(isTabbable);
  if (includeContainer && isTabbable(container)) {
    tabbableElements.unshift(container);
  }
  tabbableElements.forEach((element, i) => {
    if ((0,_chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.isFrame)(element) && element.contentDocument) {
      const frameBody = element.contentDocument.body;
      const allFrameTabbable = getAllTabbableIn(
        frameBody,
        false,
        fallbackToFocusable
      );
      tabbableElements.splice(i, 1, ...allFrameTabbable);
    }
  });
  if (!tabbableElements.length && fallbackToFocusable) {
    return elements;
  }
  return tabbableElements;
}
function getAllTabbable(fallbackToFocusable) {
  return getAllTabbableIn(document.body, false, fallbackToFocusable);
}
function getFirstTabbableIn(container, includeContainer, fallbackToFocusable) {
  const [first] = getAllTabbableIn(
    container,
    includeContainer,
    fallbackToFocusable
  );
  return first || null;
}
function getFirstTabbable(fallbackToFocusable) {
  return getFirstTabbableIn(document.body, false, fallbackToFocusable);
}
function getLastTabbableIn(container, includeContainer, fallbackToFocusable) {
  const allTabbable = getAllTabbableIn(
    container,
    includeContainer,
    fallbackToFocusable
  );
  return allTabbable[allTabbable.length - 1] || null;
}
function getLastTabbable(fallbackToFocusable) {
  return getLastTabbableIn(document.body, false, fallbackToFocusable);
}
function getNextTabbableIn(container, includeContainer, fallbackToFirst, fallbackToFocusable) {
  const activeElement = (0,_chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.getActiveElement)(container);
  const allFocusable = getAllFocusableIn(container, includeContainer);
  const activeIndex = allFocusable.indexOf(activeElement);
  const nextFocusableElements = allFocusable.slice(activeIndex + 1);
  return nextFocusableElements.find(isTabbable) || (fallbackToFirst ? allFocusable.find(isTabbable) : null) || (fallbackToFocusable ? nextFocusableElements[0] : null) || null;
}
function getNextTabbable(fallbackToFirst, fallbackToFocusable) {
  return getNextTabbableIn(
    document.body,
    false,
    fallbackToFirst,
    fallbackToFocusable
  );
}
function getPreviousTabbableIn(container, includeContainer, fallbackToLast, fallbackToFocusable) {
  const activeElement = (0,_chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.getActiveElement)(container);
  const allFocusable = getAllFocusableIn(container, includeContainer).reverse();
  const activeIndex = allFocusable.indexOf(activeElement);
  const previousFocusableElements = allFocusable.slice(activeIndex + 1);
  return previousFocusableElements.find(isTabbable) || (fallbackToLast ? allFocusable.find(isTabbable) : null) || (fallbackToFocusable ? previousFocusableElements[0] : null) || null;
}
function getPreviousTabbable(fallbackToFirst, fallbackToFocusable) {
  return getPreviousTabbableIn(
    document.body,
    false,
    fallbackToFirst,
    fallbackToFocusable
  );
}
function getClosestFocusable(element) {
  while (element && !isFocusable(element)) {
    element = element.closest(selector);
  }
  return element || null;
}
function hasFocus(element) {
  const activeElement = (0,_chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.getActiveElement)(element);
  if (!activeElement) return false;
  if (activeElement === element) return true;
  const activeDescendant = activeElement.getAttribute("aria-activedescendant");
  if (!activeDescendant) return false;
  return activeDescendant === element.id;
}
function hasFocusWithin(element) {
  const activeElement = (0,_chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.getActiveElement)(element);
  if (!activeElement) return false;
  if ((0,_chunks_37JWRFYW_js__WEBPACK_IMPORTED_MODULE_0__.contains)(element, activeElement)) return true;
  const activeDescendant = activeElement.getAttribute("aria-activedescendant");
  if (!activeDescendant) return false;
  if (!("id" in element)) return false;
  if (activeDescendant === element.id) return true;
  return !!element.querySelector(`#${CSS.escape(activeDescendant)}`);
}
function focusIfNeeded(element) {
  if (!hasFocusWithin(element) && isFocusable(element)) {
    element.focus();
  }
}
function disableFocus(element) {
  var _a;
  const currentTabindex = (_a = element.getAttribute("tabindex")) != null ? _a : "";
  element.setAttribute("data-tabindex", currentTabindex);
  element.setAttribute("tabindex", "-1");
}
function disableFocusIn(container, includeContainer) {
  const tabbableElements = getAllTabbableIn(container, includeContainer);
  for (const element of tabbableElements) {
    disableFocus(element);
  }
}
function restoreFocusIn(container) {
  const elements = container.querySelectorAll("[data-tabindex]");
  const restoreTabIndex = (element) => {
    const tabindex = element.getAttribute("data-tabindex");
    element.removeAttribute("data-tabindex");
    if (tabindex) {
      element.setAttribute("tabindex", tabindex);
    } else {
      element.removeAttribute("tabindex");
    }
  };
  if (container.hasAttribute("data-tabindex")) {
    restoreTabIndex(container);
  }
  for (const element of elements) {
    restoreTabIndex(element);
  }
}
function focusIntoView(element, options) {
  if (!("scrollIntoView" in element)) {
    element.focus();
  } else {
    element.focus({ preventScroll: true });
    element.scrollIntoView({ block: "nearest", inline: "nearest", ...options });
  }
}



/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/2S4Q4M35.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/2S4Q4M35.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Dialog: () => (/* binding */ Dialog),
/* harmony export */   createDialogComponent: () => (/* binding */ createDialogComponent),
/* harmony export */   useDialog: () => (/* binding */ useDialog)
/* harmony export */ });
/* harmony import */ var _SWBQ42SL_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SWBQ42SL.js */ "./node_modules/@ariakit/react-core/esm/__chunks/SWBQ42SL.js");
/* harmony import */ var _5M6RIVE2_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./5M6RIVE2.js */ "./node_modules/@ariakit/react-core/esm/__chunks/5M6RIVE2.js");
/* harmony import */ var _UG4JNWMY_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./UG4JNWMY.js */ "./node_modules/@ariakit/react-core/esm/__chunks/UG4JNWMY.js");
/* harmony import */ var _6GXEOXGT_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./6GXEOXGT.js */ "./node_modules/@ariakit/react-core/esm/__chunks/6GXEOXGT.js");
/* harmony import */ var _Y7OMCS5T_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Y7OMCS5T.js */ "./node_modules/@ariakit/react-core/esm/__chunks/Y7OMCS5T.js");
/* harmony import */ var _DJAL6CN3_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DJAL6CN3.js */ "./node_modules/@ariakit/react-core/esm/__chunks/DJAL6CN3.js");
/* harmony import */ var _NQXOL4RD_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./NQXOL4RD.js */ "./node_modules/@ariakit/react-core/esm/__chunks/NQXOL4RD.js");
/* harmony import */ var _Z5GCVBAY_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Z5GCVBAY.js */ "./node_modules/@ariakit/react-core/esm/__chunks/Z5GCVBAY.js");
/* harmony import */ var _677M2CI3_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./677M2CI3.js */ "./node_modules/@ariakit/react-core/esm/__chunks/677M2CI3.js");
/* harmony import */ var _LVVSG7VH_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./LVVSG7VH.js */ "./node_modules/@ariakit/react-core/esm/__chunks/LVVSG7VH.js");
/* harmony import */ var _3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./3NDVDEB4.js */ "./node_modules/@ariakit/react-core/esm/__chunks/3NDVDEB4.js");
/* harmony import */ var _AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./AOUGVQZ3.js */ "./node_modules/@ariakit/react-core/esm/__chunks/AOUGVQZ3.js");
/* harmony import */ var _HAX24JB7_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./HAX24JB7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/HAX24JB7.js");
/* harmony import */ var _5NIUVND5_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./5NIUVND5.js */ "./node_modules/@ariakit/react-core/esm/__chunks/5NIUVND5.js");
/* harmony import */ var _63N3TCQX_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./63N3TCQX.js */ "./node_modules/@ariakit/react-core/esm/__chunks/63N3TCQX.js");
/* harmony import */ var _US3TW2XI_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./US3TW2XI.js */ "./node_modules/@ariakit/react-core/esm/__chunks/US3TW2XI.js");
/* harmony import */ var _Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Q3KUZPD7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/Q3KUZPD7.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var _ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @ariakit/core/utils/focus */ "./node_modules/@ariakit/core/esm/utils/focus.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
/* harmony import */ var _ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @ariakit/core/utils/platform */ "./node_modules/@ariakit/core/esm/__chunks/O6E4ZWCP.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
"use client";




















// src/dialog/dialog.tsx







var TagName = "div";
var isSafariBrowser = (0,_ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_23__.isSafari)();
function isAlreadyFocusingAnotherElement(dialog) {
  const activeElement = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_19__.getActiveElement)();
  if (!activeElement) return false;
  if (dialog && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_19__.contains)(dialog, activeElement)) return false;
  if ((0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_21__.isFocusable)(activeElement)) return true;
  return false;
}
function getElementFromProp(prop, focusable = false) {
  if (!prop) return null;
  const element = "current" in prop ? prop.current : prop;
  if (!element) return null;
  if (focusable) return (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_21__.isFocusable)(element) ? element : null;
  return element;
}
var useDialog = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_17__.createHook)(function useDialog2({
  store: storeProp,
  open: openProp,
  onClose,
  focusable = true,
  modal = true,
  portal = !!modal,
  backdrop = !!modal,
  hideOnEscape = true,
  hideOnInteractOutside = true,
  getPersistentElements,
  preventBodyScroll = !!modal,
  autoFocusOnShow = true,
  autoFocusOnHide = true,
  initialFocus,
  finalFocus,
  unmountOnHide,
  unstable_treeSnapshotKey,
  ...props
}) {
  const context = (0,_63N3TCQX_js__WEBPACK_IMPORTED_MODULE_14__.useDialogProviderContext)();
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_24__.useRef)(null);
  const store = (0,_5NIUVND5_js__WEBPACK_IMPORTED_MODULE_13__.useDialogStore)({
    store: storeProp || context,
    open: openProp,
    setOpen(open2) {
      if (open2) return;
      const dialog = ref.current;
      if (!dialog) return;
      const event = new Event("close", { bubbles: false, cancelable: true });
      if (onClose) {
        dialog.addEventListener("close", onClose, { once: true });
      }
      dialog.dispatchEvent(event);
      if (!event.defaultPrevented) return;
      store.setOpen(true);
    }
  });
  const { portalRef, domReady } = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.usePortalRef)(portal, props.portalRef);
  const preserveTabOrderProp = props.preserveTabOrder;
  const preserveTabOrder = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_16__.useStoreState)(
    store,
    (state) => preserveTabOrderProp && !modal && state.mounted
  );
  const id = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useId)(props.id);
  const open = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_16__.useStoreState)(store, "open");
  const mounted = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_16__.useStoreState)(store, "mounted");
  const contentElement = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_16__.useStoreState)(store, "contentElement");
  const hidden = (0,_HAX24JB7_js__WEBPACK_IMPORTED_MODULE_12__.isHidden)(mounted, props.hidden, props.alwaysVisible);
  (0,_NQXOL4RD_js__WEBPACK_IMPORTED_MODULE_6__.usePreventBodyScroll)(contentElement, id, preventBodyScroll && !hidden);
  (0,_Y7OMCS5T_js__WEBPACK_IMPORTED_MODULE_4__.useHideOnInteractOutside)(store, hideOnInteractOutside, domReady);
  const { wrapElement, nestedDialogs } = (0,_DJAL6CN3_js__WEBPACK_IMPORTED_MODULE_5__.useNestedDialogs)(store);
  props = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useWrapElement)(props, wrapElement, [wrapElement]);
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useSafeLayoutEffect)(() => {
    if (!open) return;
    const dialog = ref.current;
    const activeElement = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_19__.getActiveElement)(dialog, true);
    if (!activeElement) return;
    if (activeElement.tagName === "BODY") return;
    if (dialog && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_19__.contains)(dialog, activeElement)) return;
    store.setDisclosureElement(activeElement);
  }, [store, open]);
  if (isSafariBrowser) {
    (0,react__WEBPACK_IMPORTED_MODULE_24__.useEffect)(() => {
      if (!mounted) return;
      const { disclosureElement } = store.getState();
      if (!disclosureElement) return;
      if (!(0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_19__.isButton)(disclosureElement)) return;
      const onMouseDown = () => {
        let receivedFocus = false;
        const onFocus = () => {
          receivedFocus = true;
        };
        const options = { capture: true, once: true };
        disclosureElement.addEventListener("focusin", onFocus, options);
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_20__.queueBeforeEvent)(disclosureElement, "mouseup", () => {
          disclosureElement.removeEventListener("focusin", onFocus, true);
          if (receivedFocus) return;
          (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_21__.focusIfNeeded)(disclosureElement);
        });
      };
      disclosureElement.addEventListener("mousedown", onMouseDown);
      return () => {
        disclosureElement.removeEventListener("mousedown", onMouseDown);
      };
    }, [store, mounted]);
  }
  (0,react__WEBPACK_IMPORTED_MODULE_24__.useEffect)(() => {
    if (!mounted) return;
    if (!domReady) return;
    const dialog = ref.current;
    if (!dialog) return;
    const win = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_19__.getWindow)(dialog);
    const viewport = win.visualViewport || win;
    const setViewportHeight = () => {
      var _a, _b;
      const height = (_b = (_a = win.visualViewport) == null ? void 0 : _a.height) != null ? _b : win.innerHeight;
      dialog.style.setProperty("--dialog-viewport-height", `${height}px`);
    };
    setViewportHeight();
    viewport.addEventListener("resize", setViewportHeight);
    return () => {
      viewport.removeEventListener("resize", setViewportHeight);
    };
  }, [mounted, domReady]);
  (0,react__WEBPACK_IMPORTED_MODULE_24__.useEffect)(() => {
    if (!modal) return;
    if (!mounted) return;
    if (!domReady) return;
    const dialog = ref.current;
    if (!dialog) return;
    const existingDismiss = dialog.querySelector("[data-dialog-dismiss]");
    if (existingDismiss) return;
    return (0,_6GXEOXGT_js__WEBPACK_IMPORTED_MODULE_3__.prependHiddenDismiss)(dialog, store.hide);
  }, [store, modal, mounted, domReady]);
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useSafeLayoutEffect)(() => {
    if (!(0,_677M2CI3_js__WEBPACK_IMPORTED_MODULE_8__.supportsInert)()) return;
    if (open) return;
    if (!mounted) return;
    if (!domReady) return;
    const dialog = ref.current;
    if (!dialog) return;
    return (0,_Z5GCVBAY_js__WEBPACK_IMPORTED_MODULE_7__.disableTree)(dialog);
  }, [open, mounted, domReady]);
  const canTakeTreeSnapshot = open && domReady;
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useSafeLayoutEffect)(() => {
    if (!id) return;
    if (!canTakeTreeSnapshot) return;
    const dialog = ref.current;
    return (0,_AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_11__.createWalkTreeSnapshot)(id, [dialog]);
  }, [id, canTakeTreeSnapshot, unstable_treeSnapshotKey]);
  const getPersistentElementsProp = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useEvent)(getPersistentElements);
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useSafeLayoutEffect)(() => {
    if (!id) return;
    if (!canTakeTreeSnapshot) return;
    const { disclosureElement } = store.getState();
    const dialog = ref.current;
    const persistentElements = getPersistentElementsProp() || [];
    const allElements = [
      dialog,
      ...persistentElements,
      ...nestedDialogs.map((dialog2) => dialog2.getState().contentElement)
    ];
    if (modal) {
      return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_22__.chain)(
        (0,_3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_10__.markTreeOutside)(id, allElements),
        (0,_Z5GCVBAY_js__WEBPACK_IMPORTED_MODULE_7__.disableTreeOutside)(id, allElements)
      );
    }
    return (0,_3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_10__.markTreeOutside)(id, [disclosureElement, ...allElements]);
  }, [
    id,
    store,
    canTakeTreeSnapshot,
    getPersistentElementsProp,
    nestedDialogs,
    modal,
    unstable_treeSnapshotKey
  ]);
  const mayAutoFocusOnShow = !!autoFocusOnShow;
  const autoFocusOnShowProp = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useBooleanEvent)(autoFocusOnShow);
  const [autoFocusEnabled, setAutoFocusEnabled] = (0,react__WEBPACK_IMPORTED_MODULE_24__.useState)(false);
  (0,react__WEBPACK_IMPORTED_MODULE_24__.useEffect)(() => {
    if (!open) return;
    if (!mayAutoFocusOnShow) return;
    if (!domReady) return;
    if (!(contentElement == null ? void 0 : contentElement.isConnected)) return;
    const element = getElementFromProp(initialFocus, true) || // If no initial focus is specified, we try to focus the first element
    // with the autofocus attribute. If it's an Ariakit component, the
    // Focusable component will consume the autoFocus prop and add the
    // data-autofocus attribute to the element instead.
    contentElement.querySelector(
      "[data-autofocus=true],[autofocus]"
    ) || // We have to fallback to the first focusable element otherwise portaled
    // dialogs with preserveTabOrder set to true will not receive focus
    // properly because the elements aren't tabbable until the dialog receives
    // focus.
    (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_21__.getFirstTabbableIn)(contentElement, true, portal && preserveTabOrder) || // Finally, we fallback to the dialog element itself.
    contentElement;
    const isElementFocusable = (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_21__.isFocusable)(element);
    if (!autoFocusOnShowProp(isElementFocusable ? element : null)) return;
    setAutoFocusEnabled(true);
    queueMicrotask(() => {
      element.focus();
      if (!isSafariBrowser) return;
      if (!isElementFocusable) return;
      element.scrollIntoView({ block: "nearest", inline: "nearest" });
    });
  }, [
    open,
    mayAutoFocusOnShow,
    domReady,
    contentElement,
    initialFocus,
    portal,
    preserveTabOrder,
    autoFocusOnShowProp
  ]);
  const mayAutoFocusOnHide = !!autoFocusOnHide;
  const autoFocusOnHideProp = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useBooleanEvent)(autoFocusOnHide);
  const [hasOpened, setHasOpened] = (0,react__WEBPACK_IMPORTED_MODULE_24__.useState)(false);
  (0,react__WEBPACK_IMPORTED_MODULE_24__.useEffect)(() => {
    if (!open) return;
    setHasOpened(true);
    return () => setHasOpened(false);
  }, [open]);
  const focusOnHide = (0,react__WEBPACK_IMPORTED_MODULE_24__.useCallback)(
    (dialog, retry = true) => {
      const { disclosureElement } = store.getState();
      if (isAlreadyFocusingAnotherElement(dialog)) return;
      let element = getElementFromProp(finalFocus) || disclosureElement;
      if (element == null ? void 0 : element.id) {
        const doc = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_19__.getDocument)(element);
        const selector = `[aria-activedescendant="${element.id}"]`;
        const composite = doc.querySelector(selector);
        if (composite) {
          element = composite;
        }
      }
      if (element && !(0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_21__.isFocusable)(element)) {
        const maybeParentDialog = element.closest("[data-dialog]");
        if (maybeParentDialog == null ? void 0 : maybeParentDialog.id) {
          const doc = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_19__.getDocument)(maybeParentDialog);
          const selector = `[aria-controls~="${maybeParentDialog.id}"]`;
          const control = doc.querySelector(selector);
          if (control) {
            element = control;
          }
        }
      }
      const isElementFocusable = element && (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_21__.isFocusable)(element);
      if (!isElementFocusable && retry) {
        requestAnimationFrame(() => focusOnHide(dialog, false));
        return;
      }
      if (!autoFocusOnHideProp(isElementFocusable ? element : null)) return;
      if (!isElementFocusable) return;
      element == null ? void 0 : element.focus({ preventScroll: true });
    },
    [store, finalFocus, autoFocusOnHideProp]
  );
  const focusedOnHideRef = (0,react__WEBPACK_IMPORTED_MODULE_24__.useRef)(false);
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useSafeLayoutEffect)(() => {
    if (open) return;
    if (!hasOpened) return;
    if (!mayAutoFocusOnHide) return;
    const dialog = ref.current;
    focusedOnHideRef.current = true;
    focusOnHide(dialog);
  }, [open, hasOpened, domReady, mayAutoFocusOnHide, focusOnHide]);
  (0,react__WEBPACK_IMPORTED_MODULE_24__.useEffect)(() => {
    if (!hasOpened) return;
    if (!mayAutoFocusOnHide) return;
    const dialog = ref.current;
    return () => {
      if (focusedOnHideRef.current) {
        focusedOnHideRef.current = false;
        return;
      }
      focusOnHide(dialog);
    };
  }, [hasOpened, mayAutoFocusOnHide, focusOnHide]);
  const hideOnEscapeProp = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useBooleanEvent)(hideOnEscape);
  (0,react__WEBPACK_IMPORTED_MODULE_24__.useEffect)(() => {
    if (!domReady) return;
    if (!mounted) return;
    const onKeyDown = (event) => {
      if (event.key !== "Escape") return;
      if (event.defaultPrevented) return;
      const dialog = ref.current;
      if (!dialog) return;
      if ((0,_3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_10__.isElementMarked)(dialog)) return;
      const target = event.target;
      if (!target) return;
      const { disclosureElement } = store.getState();
      const isValidTarget = () => {
        if (target.tagName === "BODY") return true;
        if ((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_19__.contains)(dialog, target)) return true;
        if (!disclosureElement) return true;
        if ((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_19__.contains)(disclosureElement, target)) return true;
        return false;
      };
      if (!isValidTarget()) return;
      if (!hideOnEscapeProp(event)) return;
      store.hide();
    };
    return (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_20__.addGlobalEventListener)("keydown", onKeyDown, true);
  }, [store, domReady, mounted, hideOnEscapeProp]);
  props = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useWrapElement)(
    props,
    (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_5M6RIVE2_js__WEBPACK_IMPORTED_MODULE_1__.HeadingLevel, { level: modal ? 1 : void 0, children: element }),
    [modal]
  );
  const hiddenProp = props.hidden;
  const alwaysVisible = props.alwaysVisible;
  props = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useWrapElement)(
    props,
    (element) => {
      if (!backdrop) return element;
      return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.Fragment, { children: [
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(
          _LVVSG7VH_js__WEBPACK_IMPORTED_MODULE_9__.DialogBackdrop,
          {
            store,
            backdrop,
            hidden: hiddenProp,
            alwaysVisible
          }
        ),
        element
      ] });
    },
    [store, backdrop, hiddenProp, alwaysVisible]
  );
  const [headingId, setHeadingId] = (0,react__WEBPACK_IMPORTED_MODULE_24__.useState)();
  const [descriptionId, setDescriptionId] = (0,react__WEBPACK_IMPORTED_MODULE_24__.useState)();
  props = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useWrapElement)(
    props,
    (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_63N3TCQX_js__WEBPACK_IMPORTED_MODULE_14__.DialogScopedContextProvider, { value: store, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_63N3TCQX_js__WEBPACK_IMPORTED_MODULE_14__.DialogHeadingContext.Provider, { value: setHeadingId, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_63N3TCQX_js__WEBPACK_IMPORTED_MODULE_14__.DialogDescriptionContext.Provider, { value: setDescriptionId, children: element }) }) }),
    [store]
  );
  props = {
    id,
    "data-dialog": "",
    role: "dialog",
    tabIndex: focusable ? -1 : void 0,
    "aria-labelledby": headingId,
    "aria-describedby": descriptionId,
    ...props,
    ref: (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_18__.useMergeRefs)(ref, props.ref)
  };
  props = (0,_UG4JNWMY_js__WEBPACK_IMPORTED_MODULE_2__.useFocusableContainer)({
    ...props,
    autoFocusOnShow: autoFocusEnabled
  });
  props = (0,_HAX24JB7_js__WEBPACK_IMPORTED_MODULE_12__.useDisclosureContent)({ store, ...props });
  props = (0,_US3TW2XI_js__WEBPACK_IMPORTED_MODULE_15__.useFocusable)({ ...props, focusable });
  props = (0,_SWBQ42SL_js__WEBPACK_IMPORTED_MODULE_0__.usePortal)({ portal, ...props, portalRef, preserveTabOrder });
  return props;
});
function createDialogComponent(Component, useProviderContext = _63N3TCQX_js__WEBPACK_IMPORTED_MODULE_14__.useDialogProviderContext) {
  return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_17__.forwardRef)(function DialogComponent(props) {
    const context = useProviderContext();
    const store = props.store || context;
    const mounted = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_16__.useStoreState)(
      store,
      (state) => !props.unmountOnHide || (state == null ? void 0 : state.mounted) || !!props.open
    );
    if (!mounted) return null;
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(Component, { ...props });
  });
}
var Dialog = createDialogComponent(
  (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_17__.forwardRef)(function Dialog2(props) {
    const htmlProps = useDialog(props);
    return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_17__.createElement)(TagName, htmlProps);
  }),
  _63N3TCQX_js__WEBPACK_IMPORTED_MODULE_14__.useDialogProviderContext
);




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/2WDBOH5E.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/2WDBOH5E.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HovercardContextProvider: () => (/* binding */ HovercardContextProvider),
/* harmony export */   HovercardScopedContextProvider: () => (/* binding */ HovercardScopedContextProvider),
/* harmony export */   useHovercardContext: () => (/* binding */ useHovercardContext),
/* harmony export */   useHovercardProviderContext: () => (/* binding */ useHovercardProviderContext),
/* harmony export */   useHovercardScopedContext: () => (/* binding */ useHovercardScopedContext)
/* harmony export */ });
/* harmony import */ var _MWF5B7KS_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MWF5B7KS.js */ "./node_modules/@ariakit/react-core/esm/__chunks/MWF5B7KS.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
"use client";



// src/hovercard/hovercard-context.tsx
var ctx = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.createStoreContext)(
  [_MWF5B7KS_js__WEBPACK_IMPORTED_MODULE_0__.PopoverContextProvider],
  [_MWF5B7KS_js__WEBPACK_IMPORTED_MODULE_0__.PopoverScopedContextProvider]
);
var useHovercardContext = ctx.useContext;
var useHovercardScopedContext = ctx.useScopedContext;
var useHovercardProviderContext = ctx.useProviderContext;
var HovercardContextProvider = ctx.ContextProvider;
var HovercardScopedContextProvider = ctx.ScopedContextProvider;




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/33YRLYNQ.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/33YRLYNQ.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDisclosureStore: () => (/* binding */ useDisclosureStore),
/* harmony export */   useDisclosureStoreProps: () => (/* binding */ useDisclosureStoreProps)
/* harmony export */ });
/* harmony import */ var _Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Q3KUZPD7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/Q3KUZPD7.js");
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_disclosure_disclosure_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/disclosure/disclosure-store */ "./node_modules/@ariakit/core/esm/__chunks/75BJEVSH.js");
"use client";



// src/disclosure/disclosure-store.ts

function useDisclosureStoreProps(store, update, props) {
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_1__.useUpdateEffect)(update, [props.store, props.disclosure]);
  (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_0__.useStoreProps)(store, props, "open", "setOpen");
  (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_0__.useStoreProps)(store, props, "mounted", "setMounted");
  (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_0__.useStoreProps)(store, props, "animated");
  return Object.assign(store, { disclosure: props.disclosure });
}
function useDisclosureStore(props = {}) {
  const [store, update] = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_0__.useStore)(_ariakit_core_disclosure_disclosure_store__WEBPACK_IMPORTED_MODULE_2__.createDisclosureStore, props);
  return useDisclosureStoreProps(store, update, props);
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/3NDVDEB4.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/3NDVDEB4.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isElementMarked: () => (/* binding */ isElementMarked),
/* harmony export */   markAncestor: () => (/* binding */ markAncestor),
/* harmony export */   markElement: () => (/* binding */ markElement),
/* harmony export */   markTreeOutside: () => (/* binding */ markTreeOutside)
/* harmony export */ });
/* harmony import */ var _AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AOUGVQZ3.js */ "./node_modules/@ariakit/react-core/esm/__chunks/AOUGVQZ3.js");
/* harmony import */ var _K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./K2ZF5NU7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js");
/* harmony import */ var _63XF7ACK_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./63XF7ACK.js */ "./node_modules/@ariakit/react-core/esm/__chunks/63XF7ACK.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
"use client";




// src/dialog/utils/mark-tree-outside.ts

function getPropertyName(id = "", ancestor = false) {
  return `__ariakit-dialog-${ancestor ? "ancestor" : "outside"}${id ? `-${id}` : ""}`;
}
function markElement(element, id = "") {
  return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_3__.chain)(
    (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.setProperty)(element, getPropertyName(), true),
    (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.setProperty)(element, getPropertyName(id), true)
  );
}
function markAncestor(element, id = "") {
  return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_3__.chain)(
    (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.setProperty)(element, getPropertyName("", true), true),
    (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.setProperty)(element, getPropertyName(id, true), true)
  );
}
function isElementMarked(element, id) {
  const ancestorProperty = getPropertyName(id, true);
  if (element[ancestorProperty]) return true;
  const elementProperty = getPropertyName(id);
  do {
    if (element[elementProperty]) return true;
    if (!element.parentElement) return false;
    element = element.parentElement;
  } while (true);
}
function markTreeOutside(id, elements) {
  const cleanups = [];
  const ids = elements.map((el) => el == null ? void 0 : el.id);
  (0,_AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_0__.walkTreeOutside)(
    id,
    elements,
    (element) => {
      if ((0,_63XF7ACK_js__WEBPACK_IMPORTED_MODULE_2__.isBackdrop)(element, ...ids)) return;
      cleanups.unshift(markElement(element, id));
    },
    (ancestor, element) => {
      const isAnotherDialogAncestor = element.hasAttribute("data-dialog") && element.id !== id;
      if (isAnotherDialogAncestor) return;
      cleanups.unshift(markAncestor(ancestor, id));
    }
  );
  const restoreAccessibilityTree = () => {
    for (const cleanup of cleanups) {
      cleanup();
    }
  };
  return restoreAccessibilityTree;
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/4Z6JSVUY.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/4Z6JSVUY.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Popover: () => (/* binding */ Popover),
/* harmony export */   usePopover: () => (/* binding */ usePopover)
/* harmony export */ });
/* harmony import */ var _2S4Q4M35_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./2S4Q4M35.js */ "./node_modules/@ariakit/react-core/esm/__chunks/2S4Q4M35.js");
/* harmony import */ var _MWF5B7KS_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./MWF5B7KS.js */ "./node_modules/@ariakit/react-core/esm/__chunks/MWF5B7KS.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
/* harmony import */ var _floating_ui_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @floating-ui/dom */ "./node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
"use client";





// src/popover/popover.tsx




var TagName = "div";
function createDOMRect(x = 0, y = 0, width = 0, height = 0) {
  if (typeof DOMRect === "function") {
    return new DOMRect(x, y, width, height);
  }
  const rect = {
    x,
    y,
    width,
    height,
    top: y,
    right: x + width,
    bottom: y + height,
    left: x
  };
  return { ...rect, toJSON: () => rect };
}
function getDOMRect(anchorRect) {
  if (!anchorRect) return createDOMRect();
  const { x, y, width, height } = anchorRect;
  return createDOMRect(x, y, width, height);
}
function getAnchorElement(anchorElement, getAnchorRect) {
  const contextElement = anchorElement || void 0;
  return {
    contextElement,
    getBoundingClientRect: () => {
      const anchor = anchorElement;
      const anchorRect = getAnchorRect == null ? void 0 : getAnchorRect(anchor);
      if (anchorRect || !anchor) {
        return getDOMRect(anchorRect);
      }
      return anchor.getBoundingClientRect();
    }
  };
}
function isValidPlacement(flip2) {
  return /^(?:top|bottom|left|right)(?:-(?:start|end))?$/.test(flip2);
}
function roundByDPR(value) {
  const dpr = window.devicePixelRatio || 1;
  return Math.round(value * dpr) / dpr;
}
function getOffsetMiddleware(arrowElement, props) {
  return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_5__.offset)(({ placement }) => {
    var _a;
    const arrowOffset = ((arrowElement == null ? void 0 : arrowElement.clientHeight) || 0) / 2;
    const finalGutter = typeof props.gutter === "number" ? props.gutter + arrowOffset : (_a = props.gutter) != null ? _a : arrowOffset;
    const hasAlignment = !!placement.split("-")[1];
    return {
      crossAxis: !hasAlignment ? props.shift : void 0,
      mainAxis: finalGutter,
      alignmentAxis: props.shift
    };
  });
}
function getFlipMiddleware(props) {
  if (props.flip === false) return;
  const fallbackPlacements = typeof props.flip === "string" ? props.flip.split(" ") : void 0;
  (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__.invariant)(
    !fallbackPlacements || fallbackPlacements.every(isValidPlacement),
     true && "`flip` expects a spaced-delimited list of placements"
  );
  return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_5__.flip)({
    padding: props.overflowPadding,
    fallbackPlacements
  });
}
function getShiftMiddleware(props) {
  if (!props.slide && !props.overlap) return;
  return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_5__.shift)({
    mainAxis: props.slide,
    crossAxis: props.overlap,
    padding: props.overflowPadding,
    limiter: (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_5__.limitShift)()
  });
}
function getSizeMiddleware(props) {
  return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_5__.size)({
    padding: props.overflowPadding,
    apply({ elements, availableWidth, availableHeight, rects }) {
      const wrapper = elements.floating;
      const referenceWidth = Math.round(rects.reference.width);
      availableWidth = Math.floor(availableWidth);
      availableHeight = Math.floor(availableHeight);
      wrapper.style.setProperty(
        "--popover-anchor-width",
        `${referenceWidth}px`
      );
      wrapper.style.setProperty(
        "--popover-available-width",
        `${availableWidth}px`
      );
      wrapper.style.setProperty(
        "--popover-available-height",
        `${availableHeight}px`
      );
      if (props.sameWidth) {
        wrapper.style.width = `${referenceWidth}px`;
      }
      if (props.fitViewport) {
        wrapper.style.maxWidth = `${availableWidth}px`;
        wrapper.style.maxHeight = `${availableHeight}px`;
      }
    }
  });
}
function getArrowMiddleware(arrowElement, props) {
  if (!arrowElement) return;
  return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_5__.arrow)({
    element: arrowElement,
    padding: props.arrowPadding
  });
}
var usePopover = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__.createHook)(
  function usePopover2({
    store,
    modal = false,
    portal = !!modal,
    preserveTabOrder = true,
    autoFocusOnShow = true,
    wrapperProps,
    fixed = false,
    flip: flip2 = true,
    shift: shift2 = 0,
    slide = true,
    overlap = false,
    sameWidth = false,
    fitViewport = false,
    gutter,
    arrowPadding = 4,
    overflowPadding = 8,
    getAnchorRect,
    updatePosition,
    ...props
  }) {
    const context = (0,_MWF5B7KS_js__WEBPACK_IMPORTED_MODULE_1__.usePopoverProviderContext)();
    store = store || context;
    (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__.invariant)(
      store,
       true && "Popover must receive a `store` prop or be wrapped in a PopoverProvider component."
    );
    const arrowElement = store.useState("arrowElement");
    const anchorElement = store.useState("anchorElement");
    const disclosureElement = store.useState("disclosureElement");
    const popoverElement = store.useState("popoverElement");
    const contentElement = store.useState("contentElement");
    const placement = store.useState("placement");
    const mounted = store.useState("mounted");
    const rendered = store.useState("rendered");
    const defaultArrowElementRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(null);
    const [positioned, setPositioned] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const { portalRef, domReady } = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.usePortalRef)(portal, props.portalRef);
    const getAnchorRectProp = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useEvent)(getAnchorRect);
    const updatePositionProp = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useEvent)(updatePosition);
    const hasCustomUpdatePosition = !!updatePosition;
    (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useSafeLayoutEffect)(() => {
      if (!(popoverElement == null ? void 0 : popoverElement.isConnected)) return;
      popoverElement.style.setProperty(
        "--popover-overflow-padding",
        `${overflowPadding}px`
      );
      const anchor = getAnchorElement(anchorElement, getAnchorRectProp);
      const updatePosition2 = async () => {
        if (!mounted) return;
        if (!arrowElement) {
          defaultArrowElementRef.current = defaultArrowElementRef.current || document.createElement("div");
        }
        const arrow2 = arrowElement || defaultArrowElementRef.current;
        const middleware = [
          getOffsetMiddleware(arrow2, { gutter, shift: shift2 }),
          getFlipMiddleware({ flip: flip2, overflowPadding }),
          getShiftMiddleware({ slide, shift: shift2, overlap, overflowPadding }),
          getArrowMiddleware(arrow2, { arrowPadding }),
          getSizeMiddleware({
            sameWidth,
            fitViewport,
            overflowPadding
          })
        ];
        const pos = await (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_5__.computePosition)(anchor, popoverElement, {
          placement,
          strategy: fixed ? "fixed" : "absolute",
          middleware
        });
        store == null ? void 0 : store.setState("currentPlacement", pos.placement);
        setPositioned(true);
        const x = roundByDPR(pos.x);
        const y = roundByDPR(pos.y);
        Object.assign(popoverElement.style, {
          top: "0",
          left: "0",
          transform: `translate3d(${x}px,${y}px,0)`
        });
        if (arrow2 && pos.middlewareData.arrow) {
          const { x: arrowX, y: arrowY } = pos.middlewareData.arrow;
          const side = pos.placement.split("-")[0];
          const centerX = arrow2.clientWidth / 2;
          const centerY = arrow2.clientHeight / 2;
          const originX = arrowX != null ? arrowX + centerX : -centerX;
          const originY = arrowY != null ? arrowY + centerY : -centerY;
          popoverElement.style.setProperty(
            "--popover-transform-origin",
            {
              top: `${originX}px calc(100% + ${centerY}px)`,
              bottom: `${originX}px ${-centerY}px`,
              left: `calc(100% + ${centerX}px) ${originY}px`,
              right: `${-centerX}px ${originY}px`
            }[side]
          );
          Object.assign(arrow2.style, {
            left: arrowX != null ? `${arrowX}px` : "",
            top: arrowY != null ? `${arrowY}px` : "",
            [side]: "100%"
          });
        }
      };
      const update = async () => {
        if (hasCustomUpdatePosition) {
          await updatePositionProp({ updatePosition: updatePosition2 });
          setPositioned(true);
        } else {
          await updatePosition2();
        }
      };
      const cancelAutoUpdate = (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_5__.autoUpdate)(anchor, popoverElement, update, {
        // JSDOM doesn't support ResizeObserver
        elementResize: typeof ResizeObserver === "function"
      });
      return () => {
        setPositioned(false);
        cancelAutoUpdate();
      };
    }, [
      store,
      rendered,
      popoverElement,
      arrowElement,
      anchorElement,
      popoverElement,
      placement,
      mounted,
      domReady,
      fixed,
      flip2,
      shift2,
      slide,
      overlap,
      sameWidth,
      fitViewport,
      gutter,
      arrowPadding,
      overflowPadding,
      getAnchorRectProp,
      hasCustomUpdatePosition,
      updatePositionProp
    ]);
    (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useSafeLayoutEffect)(() => {
      if (!mounted) return;
      if (!domReady) return;
      if (!(popoverElement == null ? void 0 : popoverElement.isConnected)) return;
      if (!(contentElement == null ? void 0 : contentElement.isConnected)) return;
      const applyZIndex = () => {
        popoverElement.style.zIndex = getComputedStyle(contentElement).zIndex;
      };
      applyZIndex();
      let raf = requestAnimationFrame(() => {
        raf = requestAnimationFrame(applyZIndex);
      });
      return () => cancelAnimationFrame(raf);
    }, [mounted, domReady, popoverElement, contentElement]);
    const position = fixed ? "fixed" : "absolute";
    props = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useWrapElement)(
      props,
      (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(
        "div",
        {
          ...wrapperProps,
          style: {
            // https://floating-ui.com/docs/computeposition#initial-layout
            position,
            top: 0,
            left: 0,
            width: "max-content",
            ...wrapperProps == null ? void 0 : wrapperProps.style
          },
          ref: store == null ? void 0 : store.setPopoverElement,
          children: element
        }
      ),
      [store, position, wrapperProps]
    );
    props = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useWrapElement)(
      props,
      (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_MWF5B7KS_js__WEBPACK_IMPORTED_MODULE_1__.PopoverScopedContextProvider, { value: store, children: element }),
      [store]
    );
    props = {
      // data-placing is not part of the public API. We're setting this here so
      // we can wait for the popover to be positioned before other components
      // move focus into it. For example, this attribute is observed by the
      // Combobox component with the autoSelect behavior.
      "data-placing": !positioned || void 0,
      ...props,
      style: {
        position: "relative",
        ...props.style
      }
    };
    props = (0,_2S4Q4M35_js__WEBPACK_IMPORTED_MODULE_0__.useDialog)({
      store,
      modal,
      portal,
      preserveTabOrder,
      preserveTabOrderAnchor: disclosureElement || anchorElement,
      autoFocusOnShow: positioned && autoFocusOnShow,
      ...props,
      portalRef
    });
    return props;
  }
);
var Popover = (0,_2S4Q4M35_js__WEBPACK_IMPORTED_MODULE_0__.createDialogComponent)(
  (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function Popover2(props) {
    const htmlProps = usePopover(props);
    return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__.createElement)(TagName, htmlProps);
  }),
  _MWF5B7KS_js__WEBPACK_IMPORTED_MODULE_1__.usePopoverProviderContext
);




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/5M6RIVE2.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/5M6RIVE2.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HeadingLevel: () => (/* binding */ HeadingLevel)
/* harmony export */ });
/* harmony import */ var _CZ4GFWYL_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CZ4GFWYL.js */ "./node_modules/@ariakit/react-core/esm/__chunks/CZ4GFWYL.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
"use client";


// src/heading/heading-level.tsx


function HeadingLevel({ level, children }) {
  const contextLevel = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(_CZ4GFWYL_js__WEBPACK_IMPORTED_MODULE_0__.HeadingContext);
  const nextLevel = Math.max(
    Math.min(level || contextLevel + 1, 6),
    1
  );
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_CZ4GFWYL_js__WEBPACK_IMPORTED_MODULE_0__.HeadingContext.Provider, { value: nextLevel, children });
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/5NIUVND5.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/5NIUVND5.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDialogStore: () => (/* binding */ useDialogStore),
/* harmony export */   useDialogStoreProps: () => (/* binding */ useDialogStoreProps)
/* harmony export */ });
/* harmony import */ var _33YRLYNQ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./33YRLYNQ.js */ "./node_modules/@ariakit/react-core/esm/__chunks/33YRLYNQ.js");
/* harmony import */ var _Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Q3KUZPD7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/Q3KUZPD7.js");
/* harmony import */ var _ariakit_core_dialog_dialog_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/dialog/dialog-store */ "./node_modules/@ariakit/core/esm/__chunks/KMAUV3TY.js");
"use client";



// src/dialog/dialog-store.ts

function useDialogStoreProps(store, update, props) {
  return (0,_33YRLYNQ_js__WEBPACK_IMPORTED_MODULE_0__.useDisclosureStoreProps)(store, update, props);
}
function useDialogStore(props = {}) {
  const [store, update] = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__.useStore)(_ariakit_core_dialog_dialog_store__WEBPACK_IMPORTED_MODULE_2__.createDialogStore, props);
  return useDialogStoreProps(store, update, props);
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/63N3TCQX.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/63N3TCQX.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DialogContextProvider: () => (/* binding */ DialogContextProvider),
/* harmony export */   DialogDescriptionContext: () => (/* binding */ DialogDescriptionContext),
/* harmony export */   DialogHeadingContext: () => (/* binding */ DialogHeadingContext),
/* harmony export */   DialogScopedContextProvider: () => (/* binding */ DialogScopedContextProvider),
/* harmony export */   useDialogContext: () => (/* binding */ useDialogContext),
/* harmony export */   useDialogProviderContext: () => (/* binding */ useDialogProviderContext),
/* harmony export */   useDialogScopedContext: () => (/* binding */ useDialogScopedContext)
/* harmony export */ });
/* harmony import */ var _FFSBKSAM_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FFSBKSAM.js */ "./node_modules/@ariakit/react-core/esm/__chunks/FFSBKSAM.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
"use client";



// src/dialog/dialog-context.tsx

var ctx = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.createStoreContext)(
  [_FFSBKSAM_js__WEBPACK_IMPORTED_MODULE_0__.DisclosureContextProvider],
  [_FFSBKSAM_js__WEBPACK_IMPORTED_MODULE_0__.DisclosureScopedContextProvider]
);
var useDialogContext = ctx.useContext;
var useDialogScopedContext = ctx.useScopedContext;
var useDialogProviderContext = ctx.useProviderContext;
var DialogContextProvider = ctx.ContextProvider;
var DialogScopedContextProvider = ctx.ScopedContextProvider;
var DialogHeadingContext = (0,react__WEBPACK_IMPORTED_MODULE_2__.createContext)(void 0);
var DialogDescriptionContext = (0,react__WEBPACK_IMPORTED_MODULE_2__.createContext)(void 0);




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/63XF7ACK.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/63XF7ACK.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isBackdrop: () => (/* binding */ isBackdrop)
/* harmony export */ });
"use client";

// src/dialog/utils/is-backdrop.ts
function isBackdrop(element, ...ids) {
  if (!element) return false;
  const backdrop = element.getAttribute("data-backdrop");
  if (backdrop == null) return false;
  if (backdrop === "") return true;
  if (backdrop === "true") return true;
  if (!ids.length) return true;
  return ids.some((id) => backdrop === id);
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/677M2CI3.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/677M2CI3.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   supportsInert: () => (/* binding */ supportsInert)
/* harmony export */ });
"use client";

// src/dialog/utils/supports-inert.ts
function supportsInert() {
  return "inert" in HTMLElement.prototype;
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/6GXEOXGT.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/6GXEOXGT.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   prependHiddenDismiss: () => (/* binding */ prependHiddenDismiss)
/* harmony export */ });
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
"use client";

// src/dialog/utils/prepend-hidden-dismiss.ts

function prependHiddenDismiss(container, onClick) {
  const document = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocument)(container);
  const button = document.createElement("button");
  button.type = "button";
  button.tabIndex = -1;
  button.textContent = "Dismiss popup";
  Object.assign(button.style, {
    border: "0px",
    clip: "rect(0 0 0 0)",
    height: "1px",
    margin: "-1px",
    overflow: "hidden",
    padding: "0px",
    position: "absolute",
    whiteSpace: "nowrap",
    width: "1px"
  });
  button.addEventListener("click", onClick);
  container.prepend(button);
  const removeHiddenDismiss = () => {
    button.removeEventListener("click", onClick);
    button.remove();
  };
  return removeHiddenDismiss;
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/6RB43CMC.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/6RB43CMC.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   usePopoverStore: () => (/* binding */ usePopoverStore),
/* harmony export */   usePopoverStoreProps: () => (/* binding */ usePopoverStoreProps)
/* harmony export */ });
/* harmony import */ var _5NIUVND5_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./5NIUVND5.js */ "./node_modules/@ariakit/react-core/esm/__chunks/5NIUVND5.js");
/* harmony import */ var _Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Q3KUZPD7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/Q3KUZPD7.js");
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_popover_popover_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ariakit/core/popover/popover-store */ "./node_modules/@ariakit/core/esm/__chunks/BFGNM53A.js");
"use client";




// src/popover/popover-store.ts

function usePopoverStoreProps(store, update, props) {
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__.useUpdateEffect)(update, [props.popover]);
  (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__.useStoreProps)(store, props, "placement");
  return (0,_5NIUVND5_js__WEBPACK_IMPORTED_MODULE_0__.useDialogStoreProps)(store, update, props);
}
function usePopoverStore(props = {}) {
  const [store, update] = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__.useStore)(_ariakit_core_popover_popover_store__WEBPACK_IMPORTED_MODULE_3__.createPopoverStore, props);
  return usePopoverStoreProps(store, update, props);
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/7QZRSZWP.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/7QZRSZWP.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Hovercard: () => (/* binding */ Hovercard),
/* harmony export */   useHovercard: () => (/* binding */ useHovercard)
/* harmony export */ });
/* harmony import */ var _X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./X7QOZUD3.js */ "./node_modules/@ariakit/react-core/esm/__chunks/X7QOZUD3.js");
/* harmony import */ var _2WDBOH5E_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./2WDBOH5E.js */ "./node_modules/@ariakit/react-core/esm/__chunks/2WDBOH5E.js");
/* harmony import */ var _4Z6JSVUY_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./4Z6JSVUY.js */ "./node_modules/@ariakit/react-core/esm/__chunks/4Z6JSVUY.js");
/* harmony import */ var _2S4Q4M35_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./2S4Q4M35.js */ "./node_modules/@ariakit/react-core/esm/__chunks/2S4Q4M35.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var _ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ariakit/core/utils/focus */ "./node_modules/@ariakit/core/esm/utils/focus.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
/* harmony import */ var _ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ariakit/core/utils/store */ "./node_modules/@ariakit/core/esm/__chunks/SXKM4CGU.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
"use client";







// src/hovercard/hovercard.tsx







var TagName = "div";
function isMovingOnHovercard(target, card, anchor, nested) {
  if ((0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_8__.hasFocusWithin)(card)) return true;
  if (!target) return false;
  if ((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_6__.contains)(card, target)) return true;
  if (anchor && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_6__.contains)(anchor, target)) return true;
  if (nested == null ? void 0 : nested.some((card2) => isMovingOnHovercard(target, card2, anchor))) {
    return true;
  }
  return false;
}
function useAutoFocusOnHide({
  store,
  ...props
}) {
  const [autoFocusOnHide, setAutoFocusOnHide] = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)(false);
  const mounted = store.useState("mounted");
  (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
    if (!mounted) {
      setAutoFocusOnHide(false);
    }
  }, [mounted]);
  const onFocusProp = props.onFocus;
  const onFocus = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_5__.useEvent)((event) => {
    onFocusProp == null ? void 0 : onFocusProp(event);
    if (event.defaultPrevented) return;
    setAutoFocusOnHide(true);
  });
  const finalFocusRef = (0,react__WEBPACK_IMPORTED_MODULE_11__.useRef)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
    return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_10__.sync)(store, ["anchorElement"], (state) => {
      finalFocusRef.current = state.anchorElement;
    });
  }, []);
  props = {
    autoFocusOnHide,
    finalFocus: finalFocusRef,
    ...props,
    onFocus
  };
  return props;
}
var NestedHovercardContext = (0,react__WEBPACK_IMPORTED_MODULE_11__.createContext)(null);
var useHovercard = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_4__.createHook)(
  function useHovercard2({
    store,
    modal = false,
    portal = !!modal,
    hideOnEscape = true,
    hideOnHoverOutside = true,
    disablePointerEventsOnApproach = !!hideOnHoverOutside,
    ...props
  }) {
    const context = (0,_2WDBOH5E_js__WEBPACK_IMPORTED_MODULE_1__.useHovercardProviderContext)();
    store = store || context;
    (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_9__.invariant)(
      store,
       true && "Hovercard must receive a `store` prop or be wrapped in a HovercardProvider component."
    );
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_11__.useRef)(null);
    const [nestedHovercards, setNestedHovercards] = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)([]);
    const hideTimeoutRef = (0,react__WEBPACK_IMPORTED_MODULE_11__.useRef)(0);
    const enterPointRef = (0,react__WEBPACK_IMPORTED_MODULE_11__.useRef)(null);
    const { portalRef, domReady } = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_5__.usePortalRef)(portal, props.portalRef);
    const isMouseMoving = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_5__.useIsMouseMoving)();
    const mayHideOnHoverOutside = !!hideOnHoverOutside;
    const hideOnHoverOutsideProp = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_5__.useBooleanEvent)(hideOnHoverOutside);
    const mayDisablePointerEvents = !!disablePointerEventsOnApproach;
    const disablePointerEventsProp = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_5__.useBooleanEvent)(
      disablePointerEventsOnApproach
    );
    const open = store.useState("open");
    const mounted = store.useState("mounted");
    (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
      if (!domReady) return;
      if (!mounted) return;
      if (!mayHideOnHoverOutside && !mayDisablePointerEvents) return;
      const element = ref.current;
      if (!element) return;
      const onMouseMove = (event) => {
        if (!store) return;
        if (!isMouseMoving()) return;
        const { anchorElement, hideTimeout, timeout } = store.getState();
        const enterPoint = enterPointRef.current;
        const [target] = event.composedPath();
        const anchor = anchorElement;
        if (isMovingOnHovercard(target, element, anchor, nestedHovercards)) {
          enterPointRef.current = target && anchor && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_6__.contains)(anchor, target) ? (0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_0__.getEventPoint)(event) : null;
          window.clearTimeout(hideTimeoutRef.current);
          hideTimeoutRef.current = 0;
          return;
        }
        if (hideTimeoutRef.current) return;
        if (enterPoint) {
          const currentPoint = (0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_0__.getEventPoint)(event);
          const polygon = (0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_0__.getElementPolygon)(element, enterPoint);
          if ((0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_0__.isPointInPolygon)(currentPoint, polygon)) {
            enterPointRef.current = currentPoint;
            if (!disablePointerEventsProp(event)) return;
            event.preventDefault();
            event.stopPropagation();
            return;
          }
        }
        if (!hideOnHoverOutsideProp(event)) return;
        hideTimeoutRef.current = window.setTimeout(() => {
          hideTimeoutRef.current = 0;
          store == null ? void 0 : store.hide();
        }, hideTimeout != null ? hideTimeout : timeout);
      };
      return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_9__.chain)(
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_7__.addGlobalEventListener)("mousemove", onMouseMove, true),
        () => clearTimeout(hideTimeoutRef.current)
      );
    }, [
      store,
      isMouseMoving,
      domReady,
      mounted,
      mayHideOnHoverOutside,
      mayDisablePointerEvents,
      nestedHovercards,
      disablePointerEventsProp,
      hideOnHoverOutsideProp
    ]);
    (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
      if (!domReady) return;
      if (!mounted) return;
      if (!mayDisablePointerEvents) return;
      const disableEvent = (event) => {
        const element = ref.current;
        if (!element) return;
        const enterPoint = enterPointRef.current;
        if (!enterPoint) return;
        const polygon = (0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_0__.getElementPolygon)(element, enterPoint);
        if ((0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_0__.isPointInPolygon)((0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_0__.getEventPoint)(event), polygon)) {
          if (!disablePointerEventsProp(event)) return;
          event.preventDefault();
          event.stopPropagation();
        }
      };
      return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_9__.chain)(
        // Note: we may need to add pointer events here in the future.
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_7__.addGlobalEventListener)("mouseenter", disableEvent, true),
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_7__.addGlobalEventListener)("mouseover", disableEvent, true),
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_7__.addGlobalEventListener)("mouseout", disableEvent, true),
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_7__.addGlobalEventListener)("mouseleave", disableEvent, true)
      );
    }, [domReady, mounted, mayDisablePointerEvents, disablePointerEventsProp]);
    (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
      if (!domReady) return;
      if (open) return;
      store == null ? void 0 : store.setAutoFocusOnShow(false);
    }, [store, domReady, open]);
    const openRef = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_5__.useLiveRef)(open);
    (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
      if (!domReady) return;
      return () => {
        if (!openRef.current) {
          store == null ? void 0 : store.setAutoFocusOnShow(false);
        }
      };
    }, [store, domReady]);
    const registerOnParent = (0,react__WEBPACK_IMPORTED_MODULE_11__.useContext)(NestedHovercardContext);
    (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_5__.useSafeLayoutEffect)(() => {
      if (modal) return;
      if (!portal) return;
      if (!mounted) return;
      if (!domReady) return;
      const element = ref.current;
      if (!element) return;
      return registerOnParent == null ? void 0 : registerOnParent(element);
    }, [modal, portal, mounted, domReady]);
    const registerNestedHovercard = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)(
      (element) => {
        setNestedHovercards((prevElements) => [...prevElements, element]);
        const parentUnregister = registerOnParent == null ? void 0 : registerOnParent(element);
        return () => {
          setNestedHovercards(
            (prevElements) => prevElements.filter((item) => item !== element)
          );
          parentUnregister == null ? void 0 : parentUnregister();
        };
      },
      [registerOnParent]
    );
    props = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_5__.useWrapElement)(
      props,
      (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_2WDBOH5E_js__WEBPACK_IMPORTED_MODULE_1__.HovercardScopedContextProvider, { value: store, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(NestedHovercardContext.Provider, { value: registerNestedHovercard, children: element }) }),
      [store, registerNestedHovercard]
    );
    props = {
      ...props,
      ref: (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_5__.useMergeRefs)(ref, props.ref)
    };
    props = useAutoFocusOnHide({ store, ...props });
    const autoFocusOnShow = store.useState(
      (state) => modal || state.autoFocusOnShow
    );
    props = (0,_4Z6JSVUY_js__WEBPACK_IMPORTED_MODULE_2__.usePopover)({
      store,
      modal,
      portal,
      autoFocusOnShow,
      ...props,
      portalRef,
      hideOnEscape(event) {
        if ((0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_9__.isFalsyBooleanCallback)(hideOnEscape, event)) return false;
        requestAnimationFrame(() => {
          requestAnimationFrame(() => {
            store == null ? void 0 : store.hide();
          });
        });
        return true;
      }
    });
    return props;
  }
);
var Hovercard = (0,_2S4Q4M35_js__WEBPACK_IMPORTED_MODULE_3__.createDialogComponent)(
  (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_4__.forwardRef)(function Hovercard2(props) {
    const htmlProps = useHovercard(props);
    return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_4__.createElement)(TagName, htmlProps);
  }),
  _2WDBOH5E_js__WEBPACK_IMPORTED_MODULE_1__.useHovercardProviderContext
);




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/AOQQTIBO.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/AOQQTIBO.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PortalContext: () => (/* binding */ PortalContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
"use client";

// src/portal/portal-context.tsx

var PortalContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/AOUGVQZ3.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/AOUGVQZ3.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createWalkTreeSnapshot: () => (/* binding */ createWalkTreeSnapshot),
/* harmony export */   isValidElement: () => (/* binding */ isValidElement),
/* harmony export */   walkTreeOutside: () => (/* binding */ walkTreeOutside)
/* harmony export */ });
/* harmony import */ var _K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./K2ZF5NU7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
"use client";


// src/dialog/utils/walk-tree-outside.ts


var ignoreTags = ["SCRIPT", "STYLE"];
function getSnapshotPropertyName(id) {
  return `__ariakit-dialog-snapshot-${id}`;
}
function inSnapshot(id, element) {
  const doc = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.getDocument)(element);
  const propertyName = getSnapshotPropertyName(id);
  if (!doc.body[propertyName]) return true;
  do {
    if (element === doc.body) return false;
    if (element[propertyName]) return true;
    if (!element.parentElement) return false;
    element = element.parentElement;
  } while (true);
}
function isValidElement(id, element, ignoredElements) {
  if (ignoreTags.includes(element.tagName)) return false;
  if (!inSnapshot(id, element)) return false;
  return !ignoredElements.some(
    (enabledElement) => enabledElement && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.contains)(element, enabledElement)
  );
}
function walkTreeOutside(id, elements, callback, ancestorCallback) {
  for (let element of elements) {
    if (!(element == null ? void 0 : element.isConnected)) continue;
    const hasAncestorAlready = elements.some((maybeAncestor) => {
      if (!maybeAncestor) return false;
      if (maybeAncestor === element) return false;
      return maybeAncestor.contains(element);
    });
    const doc = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.getDocument)(element);
    const originalElement = element;
    while (element.parentElement && element !== doc.body) {
      ancestorCallback == null ? void 0 : ancestorCallback(element.parentElement, originalElement);
      if (!hasAncestorAlready) {
        for (const child of element.parentElement.children) {
          if (isValidElement(id, child, elements)) {
            callback(child, originalElement);
          }
        }
      }
      element = element.parentElement;
    }
  }
}
function createWalkTreeSnapshot(id, elements) {
  const { body } = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.getDocument)(elements[0]);
  const cleanups = [];
  const markElement = (element) => {
    cleanups.push((0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_0__.setProperty)(element, getSnapshotPropertyName(id), true));
  };
  walkTreeOutside(id, elements, markElement);
  return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__.chain)((0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_0__.setProperty)(body, getSnapshotPropertyName(id), true), () => {
    for (const cleanup of cleanups) {
      cleanup();
    }
  });
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/BVSK4LBK.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/BVSK4LBK.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HovercardAnchor: () => (/* binding */ HovercardAnchor),
/* harmony export */   useHovercardAnchor: () => (/* binding */ useHovercardAnchor)
/* harmony export */ });
/* harmony import */ var _2WDBOH5E_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./2WDBOH5E.js */ "./node_modules/@ariakit/react-core/esm/__chunks/2WDBOH5E.js");
/* harmony import */ var _US3TW2XI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./US3TW2XI.js */ "./node_modules/@ariakit/react-core/esm/__chunks/US3TW2XI.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
"use client";





// src/hovercard/hovercard-anchor.tsx



var TagName = "a";
var useHovercardAnchor = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__.createHook)(
  function useHovercardAnchor2({ store, showOnHover = true, ...props }) {
    const context = (0,_2WDBOH5E_js__WEBPACK_IMPORTED_MODULE_0__.useHovercardProviderContext)();
    store = store || context;
    (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_5__.invariant)(
      store,
       true && "HovercardAnchor must receive a `store` prop or be wrapped in a HovercardProvider component."
    );
    const disabled = (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_5__.disabledFromProps)(props);
    const showTimeoutRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(0);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => () => window.clearTimeout(showTimeoutRef.current), []);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      const onMouseLeave = (event) => {
        if (!store) return;
        const { anchorElement } = store.getState();
        if (!anchorElement) return;
        if (event.target !== anchorElement) return;
        window.clearTimeout(showTimeoutRef.current);
        showTimeoutRef.current = 0;
      };
      return (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.addGlobalEventListener)("mouseleave", onMouseLeave, true);
    }, [store]);
    const onMouseMoveProp = props.onMouseMove;
    const showOnHoverProp = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useBooleanEvent)(showOnHover);
    const isMouseMoving = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useIsMouseMoving)();
    const onMouseMove = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useEvent)((event) => {
      onMouseMoveProp == null ? void 0 : onMouseMoveProp(event);
      if (disabled) return;
      if (!store) return;
      if (event.defaultPrevented) return;
      if (showTimeoutRef.current) return;
      if (!isMouseMoving()) return;
      if (!showOnHoverProp(event)) return;
      const element = event.currentTarget;
      store.setAnchorElement(element);
      store.setDisclosureElement(element);
      const { showTimeout, timeout } = store.getState();
      const showHovercard = () => {
        showTimeoutRef.current = 0;
        if (!isMouseMoving()) return;
        store == null ? void 0 : store.setAnchorElement(element);
        store == null ? void 0 : store.show();
        queueMicrotask(() => {
          store == null ? void 0 : store.setDisclosureElement(element);
        });
      };
      const timeoutMs = showTimeout != null ? showTimeout : timeout;
      if (timeoutMs === 0) {
        showHovercard();
      } else {
        showTimeoutRef.current = window.setTimeout(showHovercard, timeoutMs);
      }
    });
    const onClickProp = props.onClick;
    const onClick = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useEvent)((event) => {
      onClickProp == null ? void 0 : onClickProp(event);
      if (!store) return;
      window.clearTimeout(showTimeoutRef.current);
      showTimeoutRef.current = 0;
    });
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(
      (element) => {
        if (!store) return;
        const { anchorElement } = store.getState();
        if (anchorElement == null ? void 0 : anchorElement.isConnected) return;
        store.setAnchorElement(element);
      },
      [store]
    );
    props = {
      ...props,
      ref: (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useMergeRefs)(ref, props.ref),
      onMouseMove,
      onClick
    };
    props = (0,_US3TW2XI_js__WEBPACK_IMPORTED_MODULE_1__.useFocusable)(props);
    return props;
  }
);
var HovercardAnchor = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function HovercardAnchor2(props) {
  const htmlProps = useHovercardAnchor(props);
  return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__.createElement)(TagName, htmlProps);
});




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/CZ4GFWYL.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/CZ4GFWYL.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HeadingContext: () => (/* binding */ HeadingContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
"use client";

// src/heading/heading-context.tsx

var HeadingContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(0);




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/DJAL6CN3.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/DJAL6CN3.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useNestedDialogs: () => (/* binding */ useNestedDialogs)
/* harmony export */ });
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
/* harmony import */ var _ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/store */ "./node_modules/@ariakit/core/esm/__chunks/SXKM4CGU.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
"use client";


// src/dialog/utils/use-nested-dialogs.tsx




var NestedDialogsContext = (0,react__WEBPACK_IMPORTED_MODULE_3__.createContext)({});
function useNestedDialogs(store) {
  const context = (0,react__WEBPACK_IMPORTED_MODULE_3__.useContext)(NestedDialogsContext);
  const [dialogs, setDialogs] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)([]);
  const add = (0,react__WEBPACK_IMPORTED_MODULE_3__.useCallback)(
    (dialog) => {
      var _a;
      setDialogs((dialogs2) => [...dialogs2, dialog]);
      return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_1__.chain)((_a = context.add) == null ? void 0 : _a.call(context, dialog), () => {
        setDialogs((dialogs2) => dialogs2.filter((d) => d !== dialog));
      });
    },
    [context]
  );
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_0__.useSafeLayoutEffect)(() => {
    return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_2__.sync)(store, ["open", "contentElement"], (state) => {
      var _a;
      if (!state.open) return;
      if (!state.contentElement) return;
      return (_a = context.add) == null ? void 0 : _a.call(context, store);
    });
  }, [store, context]);
  const providerValue = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => ({ store, add }), [store, add]);
  const wrapElement = (0,react__WEBPACK_IMPORTED_MODULE_3__.useCallback)(
    (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(NestedDialogsContext.Provider, { value: providerValue, children: element }),
    [providerValue]
  );
  return { wrapElement, nestedDialogs: dialogs };
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/FFSBKSAM.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/FFSBKSAM.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DisclosureContextProvider: () => (/* binding */ DisclosureContextProvider),
/* harmony export */   DisclosureScopedContextProvider: () => (/* binding */ DisclosureScopedContextProvider),
/* harmony export */   useDisclosureContext: () => (/* binding */ useDisclosureContext),
/* harmony export */   useDisclosureProviderContext: () => (/* binding */ useDisclosureProviderContext),
/* harmony export */   useDisclosureScopedContext: () => (/* binding */ useDisclosureScopedContext)
/* harmony export */ });
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
"use client";


// src/disclosure/disclosure-context.tsx
var ctx = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_0__.createStoreContext)();
var useDisclosureContext = ctx.useContext;
var useDisclosureScopedContext = ctx.useScopedContext;
var useDisclosureProviderContext = ctx.useProviderContext;
var DisclosureContextProvider = ctx.ContextProvider;
var DisclosureScopedContextProvider = ctx.ScopedContextProvider;




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/HAX24JB7.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/HAX24JB7.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DisclosureContent: () => (/* binding */ DisclosureContent),
/* harmony export */   isHidden: () => (/* binding */ isHidden),
/* harmony export */   useDisclosureContent: () => (/* binding */ useDisclosureContent)
/* harmony export */ });
/* harmony import */ var _63N3TCQX_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./63N3TCQX.js */ "./node_modules/@ariakit/react-core/esm/__chunks/63N3TCQX.js");
/* harmony import */ var _FFSBKSAM_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FFSBKSAM.js */ "./node_modules/@ariakit/react-core/esm/__chunks/FFSBKSAM.js");
/* harmony import */ var _Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Q3KUZPD7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/Q3KUZPD7.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
"use client";






// src/disclosure/disclosure-content.tsx




var TagName = "div";
function afterTimeout(timeoutMs, cb) {
  const timeoutId = setTimeout(cb, timeoutMs);
  return () => clearTimeout(timeoutId);
}
function afterPaint(cb) {
  let raf = requestAnimationFrame(() => {
    raf = requestAnimationFrame(cb);
  });
  return () => cancelAnimationFrame(raf);
}
function parseCSSTime(...times) {
  return times.join(", ").split(", ").reduce((longestTime, currentTimeString) => {
    const multiplier = currentTimeString.endsWith("ms") ? 1 : 1e3;
    const currentTime = Number.parseFloat(currentTimeString || "0s") * multiplier;
    if (currentTime > longestTime) return currentTime;
    return longestTime;
  }, 0);
}
function isHidden(mounted, hidden, alwaysVisible) {
  return !alwaysVisible && hidden !== false && (!mounted || !!hidden);
}
var useDisclosureContent = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_3__.createHook)(function useDisclosureContent2({ store, alwaysVisible, ...props }) {
  const context = (0,_FFSBKSAM_js__WEBPACK_IMPORTED_MODULE_1__.useDisclosureProviderContext)();
  store = store || context;
  (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_5__.invariant)(
    store,
     true && "DisclosureContent must receive a `store` prop or be wrapped in a DisclosureProvider component."
  );
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(null);
  const id = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__.useId)(props.id);
  const [transition, setTransition] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(null);
  const open = store.useState("open");
  const mounted = store.useState("mounted");
  const animated = store.useState("animated");
  const contentElement = store.useState("contentElement");
  const otherElement = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_2__.useStoreState)(store.disclosure, "contentElement");
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__.useSafeLayoutEffect)(() => {
    if (!ref.current) return;
    store == null ? void 0 : store.setContentElement(ref.current);
  }, [store]);
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__.useSafeLayoutEffect)(() => {
    let previousAnimated;
    store == null ? void 0 : store.setState("animated", (animated2) => {
      previousAnimated = animated2;
      return true;
    });
    return () => {
      if (previousAnimated === void 0) return;
      store == null ? void 0 : store.setState("animated", previousAnimated);
    };
  }, [store]);
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__.useSafeLayoutEffect)(() => {
    if (!animated) return;
    if (!(contentElement == null ? void 0 : contentElement.isConnected)) {
      setTransition(null);
      return;
    }
    return afterPaint(() => {
      setTransition(open ? "enter" : mounted ? "leave" : null);
    });
  }, [animated, contentElement, open, mounted]);
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__.useSafeLayoutEffect)(() => {
    if (!store) return;
    if (!animated) return;
    if (!transition) return;
    if (!contentElement) return;
    const stopAnimation = () => store == null ? void 0 : store.setState("animating", false);
    const stopAnimationSync = () => (0,react_dom__WEBPACK_IMPORTED_MODULE_7__.flushSync)(stopAnimation);
    if (transition === "leave" && open) return;
    if (transition === "enter" && !open) return;
    if (typeof animated === "number") {
      const timeout2 = animated;
      return afterTimeout(timeout2, stopAnimationSync);
    }
    const {
      transitionDuration,
      animationDuration,
      transitionDelay,
      animationDelay
    } = getComputedStyle(contentElement);
    const {
      transitionDuration: transitionDuration2 = "0",
      animationDuration: animationDuration2 = "0",
      transitionDelay: transitionDelay2 = "0",
      animationDelay: animationDelay2 = "0"
    } = otherElement ? getComputedStyle(otherElement) : {};
    const delay = parseCSSTime(
      transitionDelay,
      animationDelay,
      transitionDelay2,
      animationDelay2
    );
    const duration = parseCSSTime(
      transitionDuration,
      animationDuration,
      transitionDuration2,
      animationDuration2
    );
    const timeout = delay + duration;
    if (!timeout) {
      if (transition === "enter") {
        store.setState("animated", false);
      }
      stopAnimation();
      return;
    }
    const frameRate = 1e3 / 60;
    const maxTimeout = Math.max(timeout - frameRate, 0);
    return afterTimeout(maxTimeout, stopAnimationSync);
  }, [store, animated, contentElement, otherElement, open, transition]);
  props = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__.useWrapElement)(
    props,
    (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_63N3TCQX_js__WEBPACK_IMPORTED_MODULE_0__.DialogScopedContextProvider, { value: store, children: element }),
    [store]
  );
  const hidden = isHidden(mounted, props.hidden, alwaysVisible);
  const styleProp = props.style;
  const style = (0,react__WEBPACK_IMPORTED_MODULE_6__.useMemo)(() => {
    if (hidden) {
      return { ...styleProp, display: "none" };
    }
    return styleProp;
  }, [hidden, styleProp]);
  props = {
    id,
    "data-open": open || void 0,
    "data-enter": transition === "enter" || void 0,
    "data-leave": transition === "leave" || void 0,
    hidden,
    ...props,
    ref: (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__.useMergeRefs)(id ? store.setContentElement : null, ref, props.ref),
    style
  };
  return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_5__.removeUndefinedValues)(props);
});
var DisclosureContentImpl = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_3__.forwardRef)(function DisclosureContentImpl2(props) {
  const htmlProps = useDisclosureContent(props);
  return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_3__.createElement)(TagName, htmlProps);
});
var DisclosureContent = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_3__.forwardRef)(function DisclosureContent2({
  unmountOnHide,
  ...props
}) {
  const context = (0,_FFSBKSAM_js__WEBPACK_IMPORTED_MODULE_1__.useDisclosureProviderContext)();
  const store = props.store || context;
  const mounted = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_2__.useStoreState)(
    store,
    (state) => !unmountOnHide || (state == null ? void 0 : state.mounted)
  );
  if (mounted === false) return null;
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(DisclosureContentImpl, { ...props });
});




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/HIN2NSI2.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/HIN2NSI2.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Role: () => (/* binding */ Role),
/* harmony export */   useRole: () => (/* binding */ useRole)
/* harmony export */ });
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
"use client";


// src/role/role.tsx
var TagName = "div";
var elements = [
  "a",
  "button",
  "details",
  "dialog",
  "div",
  "form",
  "h1",
  "h2",
  "h3",
  "h4",
  "h5",
  "h6",
  "header",
  "img",
  "input",
  "label",
  "li",
  "nav",
  "ol",
  "p",
  "section",
  "select",
  "span",
  "summary",
  "textarea",
  "ul",
  "svg"
];
var useRole = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_0__.createHook)(
  function useRole2(props) {
    return props;
  }
);
var Role = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(
  // @ts-expect-error
  function Role2(props) {
    return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_0__.createElement)(TagName, props);
  }
);
Object.assign(
  Role,
  elements.reduce((acc, element) => {
    acc[element] = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function Role3(props) {
      return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_0__.createElement)(element, props);
    });
    return acc;
  }, {})
);




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/HLTQOHKZ.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/HLTQOHKZ.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   usePreviousMouseDownRef: () => (/* binding */ usePreviousMouseDownRef)
/* harmony export */ });
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
"use client";

// src/dialog/utils/use-previous-mouse-down-ref.ts


function usePreviousMouseDownRef(enabled) {
  const previousMouseDownRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (!enabled) {
      previousMouseDownRef.current = null;
      return;
    }
    const onMouseDown = (event) => {
      previousMouseDownRef.current = event.target;
    };
    return (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_0__.addGlobalEventListener)("mousedown", onMouseDown, true);
  }, [enabled]);
  return previousMouseDownRef;
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/IAC2O6VC.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/IAC2O6VC.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useHovercardStore: () => (/* binding */ useHovercardStore),
/* harmony export */   useHovercardStoreProps: () => (/* binding */ useHovercardStoreProps)
/* harmony export */ });
/* harmony import */ var _6RB43CMC_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./6RB43CMC.js */ "./node_modules/@ariakit/react-core/esm/__chunks/6RB43CMC.js");
/* harmony import */ var _Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Q3KUZPD7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/Q3KUZPD7.js");
/* harmony import */ var _ariakit_core_hovercard_hovercard_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/hovercard/hovercard-store */ "./node_modules/@ariakit/core/esm/__chunks/TIQDSBWP.js");
"use client";



// src/hovercard/hovercard-store.ts

function useHovercardStoreProps(store, update, props) {
  (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__.useStoreProps)(store, props, "timeout");
  (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__.useStoreProps)(store, props, "showTimeout");
  (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__.useStoreProps)(store, props, "hideTimeout");
  return (0,_6RB43CMC_js__WEBPACK_IMPORTED_MODULE_0__.usePopoverStoreProps)(store, update, props);
}
function useHovercardStore(props = {}) {
  const [store, update] = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__.useStore)(_ariakit_core_hovercard_hovercard_store__WEBPACK_IMPORTED_MODULE_2__.createHovercardStore, props);
  return useHovercardStoreProps(store, update, props);
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/IEBFIEPB.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/IEBFIEPB.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FocusTrap: () => (/* binding */ FocusTrap),
/* harmony export */   useFocusTrap: () => (/* binding */ useFocusTrap)
/* harmony export */ });
/* harmony import */ var _RBTTLCIN_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RBTTLCIN.js */ "./node_modules/@ariakit/react-core/esm/__chunks/RBTTLCIN.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
"use client";



// src/focus-trap/focus-trap.tsx
var TagName = "span";
var useFocusTrap = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.createHook)(
  function useFocusTrap2(props) {
    props = {
      "data-focus-trap": "",
      tabIndex: 0,
      "aria-hidden": true,
      ...props,
      style: {
        // Prevents unintended scroll jumps.
        position: "fixed",
        top: 0,
        left: 0,
        ...props.style
      }
    };
    props = (0,_RBTTLCIN_js__WEBPACK_IMPORTED_MODULE_0__.useVisuallyHidden)(props);
    return props;
  }
);
var FocusTrap = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function FocusTrap2(props) {
  const htmlProps = useFocusTrap(props);
  return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.createElement)(TagName, htmlProps);
});




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/IGR4SXG2.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/IGR4SXG2.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isFocusTrap: () => (/* binding */ isFocusTrap)
/* harmony export */ });
"use client";

// src/dialog/utils/is-focus-trap.ts
function isFocusTrap(element, ...ids) {
  if (!element) return false;
  const attr = element.getAttribute("data-focus-trap");
  if (attr == null) return false;
  if (!ids.length) return true;
  if (attr === "") return false;
  return ids.some((id) => attr === id);
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createElement: () => (/* binding */ createElement),
/* harmony export */   createHook: () => (/* binding */ createHook),
/* harmony export */   createStoreContext: () => (/* binding */ createStoreContext),
/* harmony export */   forwardRef: () => (/* binding */ forwardRef2),
/* harmony export */   memo: () => (/* binding */ memo2)
/* harmony export */ });
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _YXGXYGQX_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./YXGXYGQX.js */ "./node_modules/@ariakit/react-core/esm/__chunks/YXGXYGQX.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
"use client";



// src/utils/system.tsx


function forwardRef2(render) {
  const Role = react__WEBPACK_IMPORTED_MODULE_2__.forwardRef((props, ref) => render({ ...props, ref }));
  Role.displayName = render.displayName || render.name;
  return Role;
}
function memo2(Component, propsAreEqual) {
  return react__WEBPACK_IMPORTED_MODULE_2__.memo(Component, propsAreEqual);
}
function createElement(Type, props) {
  const { wrapElement, render, ...rest } = props;
  const mergedRef = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_0__.useMergeRefs)(props.ref, (0,_YXGXYGQX_js__WEBPACK_IMPORTED_MODULE_1__.getRefProperty)(render));
  let element;
  if (react__WEBPACK_IMPORTED_MODULE_2__.isValidElement(render)) {
    const renderProps = { ...render.props, ref: mergedRef };
    element = react__WEBPACK_IMPORTED_MODULE_2__.cloneElement(render, (0,_YXGXYGQX_js__WEBPACK_IMPORTED_MODULE_1__.mergeProps)(rest, renderProps));
  } else if (render) {
    element = render(rest);
  } else {
    element = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Type, { ...rest });
  }
  if (wrapElement) {
    return wrapElement(element);
  }
  return element;
}
function createHook(useProps) {
  const useRole = (props = {}) => {
    return useProps(props);
  };
  useRole.displayName = useProps.name;
  return useRole;
}
function createStoreContext(providers = [], scopedProviders = []) {
  const context = react__WEBPACK_IMPORTED_MODULE_2__.createContext(void 0);
  const scopedContext = react__WEBPACK_IMPORTED_MODULE_2__.createContext(void 0);
  const useContext2 = () => react__WEBPACK_IMPORTED_MODULE_2__.useContext(context);
  const useScopedContext = (onlyScoped = false) => {
    const scoped = react__WEBPACK_IMPORTED_MODULE_2__.useContext(scopedContext);
    const store = useContext2();
    if (onlyScoped) return scoped;
    return scoped || store;
  };
  const useProviderContext = () => {
    const scoped = react__WEBPACK_IMPORTED_MODULE_2__.useContext(scopedContext);
    const store = useContext2();
    if (scoped && scoped === store) return;
    return store;
  };
  const ContextProvider = (props) => {
    return providers.reduceRight(
      (children, Provider) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Provider, { ...props, children }),
      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(context.Provider, { ...props })
    );
  };
  const ScopedContextProvider = (props) => {
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(ContextProvider, { ...props, children: scopedProviders.reduceRight(
      (children, Provider) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Provider, { ...props, children }),
      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(scopedContext.Provider, { ...props })
    ) });
  };
  return {
    context,
    scopedContext,
    useContext: useContext2,
    useScopedContext,
    useProviderContext,
    ContextProvider,
    ScopedContextProvider
  };
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
var react__WEBPACK_IMPORTED_MODULE_3___namespace_cache;
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useAttribute: () => (/* binding */ useAttribute),
/* harmony export */   useBooleanEvent: () => (/* binding */ useBooleanEvent),
/* harmony export */   useDeferredValue: () => (/* binding */ useDeferredValue),
/* harmony export */   useEvent: () => (/* binding */ useEvent),
/* harmony export */   useForceUpdate: () => (/* binding */ useForceUpdate),
/* harmony export */   useId: () => (/* binding */ useId),
/* harmony export */   useInitialValue: () => (/* binding */ useInitialValue),
/* harmony export */   useIsMouseMoving: () => (/* binding */ useIsMouseMoving),
/* harmony export */   useLazyValue: () => (/* binding */ useLazyValue),
/* harmony export */   useLiveRef: () => (/* binding */ useLiveRef),
/* harmony export */   useMergeRefs: () => (/* binding */ useMergeRefs),
/* harmony export */   useMetadataProps: () => (/* binding */ useMetadataProps),
/* harmony export */   usePortalRef: () => (/* binding */ usePortalRef),
/* harmony export */   usePreviousValue: () => (/* binding */ usePreviousValue),
/* harmony export */   useSafeLayoutEffect: () => (/* binding */ useSafeLayoutEffect),
/* harmony export */   useTagName: () => (/* binding */ useTagName),
/* harmony export */   useTransactionState: () => (/* binding */ useTransactionState),
/* harmony export */   useUpdateEffect: () => (/* binding */ useUpdateEffect),
/* harmony export */   useUpdateLayoutEffect: () => (/* binding */ useUpdateLayoutEffect),
/* harmony export */   useWrapElement: () => (/* binding */ useWrapElement)
/* harmony export */ });
/* harmony import */ var _YXGXYGQX_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./YXGXYGQX.js */ "./node_modules/@ariakit/react-core/esm/__chunks/YXGXYGQX.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
"use client";


// src/utils/hooks.ts




var _React = { .../*#__PURE__*/ (react__WEBPACK_IMPORTED_MODULE_3___namespace_cache || (react__WEBPACK_IMPORTED_MODULE_3___namespace_cache = __webpack_require__.t(react__WEBPACK_IMPORTED_MODULE_3__, 2))) };
var useReactId = _React.useId;
var useReactDeferredValue = _React.useDeferredValue;
var useReactInsertionEffect = _React.useInsertionEffect;
var useSafeLayoutEffect = _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.canUseDOM ? react__WEBPACK_IMPORTED_MODULE_3__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_3__.useEffect;
function useInitialValue(value) {
  const [initialValue] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(value);
  return initialValue;
}
function useLazyValue(init) {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_3__.useRef)();
  if (ref.current === void 0) {
    ref.current = init();
  }
  return ref.current;
}
function useLiveRef(value) {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_3__.useRef)(value);
  useSafeLayoutEffect(() => {
    ref.current = value;
  });
  return ref;
}
function usePreviousValue(value) {
  const [previousValue, setPreviousValue] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(value);
  if (value !== previousValue) {
    setPreviousValue(value);
  }
  return previousValue;
}
function useEvent(callback) {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_3__.useRef)(() => {
    throw new Error("Cannot call an event handler while rendering.");
  });
  if (useReactInsertionEffect) {
    useReactInsertionEffect(() => {
      ref.current = callback;
    });
  } else {
    ref.current = callback;
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_3__.useCallback)((...args) => {
    var _a;
    return (_a = ref.current) == null ? void 0 : _a.call(ref, ...args);
  }, []);
}
function useTransactionState(callback) {
  const [state, setState] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
  useSafeLayoutEffect(() => {
    if (state == null) return;
    if (!callback) return;
    let prevState = null;
    callback((prev) => {
      prevState = prev;
      return state;
    });
    return () => {
      callback(prevState);
    };
  }, [state, callback]);
  return [state, setState];
}
function useMergeRefs(...refs) {
  return (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
    if (!refs.some(Boolean)) return;
    return (value) => {
      for (const ref of refs) {
        (0,_YXGXYGQX_js__WEBPACK_IMPORTED_MODULE_0__.setRef)(ref, value);
      }
    };
  }, refs);
}
function useId(defaultId) {
  if (useReactId) {
    const reactId = useReactId();
    if (defaultId) return defaultId;
    return reactId;
  }
  const [id, setId] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(defaultId);
  useSafeLayoutEffect(() => {
    if (defaultId || id) return;
    const random = Math.random().toString(36).slice(2, 8);
    setId(`id-${random}`);
  }, [defaultId, id]);
  return defaultId || id;
}
function useDeferredValue(value) {
  if (useReactDeferredValue) {
    return useReactDeferredValue(value);
  }
  const [deferredValue, setDeferredValue] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(value);
  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    const raf = requestAnimationFrame(() => setDeferredValue(value));
    return () => cancelAnimationFrame(raf);
  }, [value]);
  return deferredValue;
}
function useTagName(refOrElement, type) {
  const stringOrUndefined = (type2) => {
    if (typeof type2 !== "string") return;
    return type2;
  };
  const [tagName, setTagName] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(() => stringOrUndefined(type));
  useSafeLayoutEffect(() => {
    const element = refOrElement && "current" in refOrElement ? refOrElement.current : refOrElement;
    setTagName((element == null ? void 0 : element.tagName.toLowerCase()) || stringOrUndefined(type));
  }, [refOrElement, type]);
  return tagName;
}
function useAttribute(refOrElement, attributeName, defaultValue) {
  const initialValue = useInitialValue(defaultValue);
  const [attribute, setAttribute] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(initialValue);
  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    const element = refOrElement && "current" in refOrElement ? refOrElement.current : refOrElement;
    if (!element) return;
    const callback = () => {
      const value = element.getAttribute(attributeName);
      setAttribute(value == null ? initialValue : value);
    };
    const observer = new MutationObserver(callback);
    observer.observe(element, { attributeFilter: [attributeName] });
    callback();
    return () => observer.disconnect();
  }, [refOrElement, attributeName, initialValue]);
  return attribute;
}
function useUpdateEffect(effect, deps) {
  const mounted = (0,react__WEBPACK_IMPORTED_MODULE_3__.useRef)(false);
  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (mounted.current) {
      return effect();
    }
    mounted.current = true;
  }, deps);
  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(
    () => () => {
      mounted.current = false;
    },
    []
  );
}
function useUpdateLayoutEffect(effect, deps) {
  const mounted = (0,react__WEBPACK_IMPORTED_MODULE_3__.useRef)(false);
  useSafeLayoutEffect(() => {
    if (mounted.current) {
      return effect();
    }
    mounted.current = true;
  }, deps);
  useSafeLayoutEffect(
    () => () => {
      mounted.current = false;
    },
    []
  );
}
function useForceUpdate() {
  return (0,react__WEBPACK_IMPORTED_MODULE_3__.useReducer)(() => [], []);
}
function useBooleanEvent(booleanOrCallback) {
  return useEvent(
    typeof booleanOrCallback === "function" ? booleanOrCallback : () => booleanOrCallback
  );
}
function useWrapElement(props, callback, deps = []) {
  const wrapElement = (0,react__WEBPACK_IMPORTED_MODULE_3__.useCallback)(
    (element) => {
      if (props.wrapElement) {
        element = props.wrapElement(element);
      }
      return callback(element);
    },
    [...deps, props.wrapElement]
  );
  return { ...props, wrapElement };
}
function usePortalRef(portalProp = false, portalRefProp) {
  const [portalNode, setPortalNode] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
  const portalRef = useMergeRefs(setPortalNode, portalRefProp);
  const domReady = !portalProp || portalNode;
  return { portalRef, portalNode, domReady };
}
function useMetadataProps(props, key, value) {
  const parent = props.onLoadedMetadataCapture;
  const onLoadedMetadataCapture = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
    return Object.assign(() => {
    }, { ...parent, [key]: value });
  }, [parent, key, value]);
  return [parent == null ? void 0 : parent[key], { onLoadedMetadataCapture }];
}
var hasInstalledGlobalEventListeners = false;
function useIsMouseMoving() {
  (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (hasInstalledGlobalEventListeners) return;
    (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_2__.addGlobalEventListener)("mousemove", setMouseMoving, true);
    (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_2__.addGlobalEventListener)("mousedown", resetMouseMoving, true);
    (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_2__.addGlobalEventListener)("mouseup", resetMouseMoving, true);
    (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_2__.addGlobalEventListener)("keydown", resetMouseMoving, true);
    (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_2__.addGlobalEventListener)("scroll", resetMouseMoving, true);
    hasInstalledGlobalEventListeners = true;
  }, []);
  const isMouseMoving = useEvent(() => mouseMoving);
  return isMouseMoving;
}
var mouseMoving = false;
var previousScreenX = 0;
var previousScreenY = 0;
function hasMouseMovement(event) {
  const movementX = event.movementX || event.screenX - previousScreenX;
  const movementY = event.movementY || event.screenY - previousScreenY;
  previousScreenX = event.screenX;
  previousScreenY = event.screenY;
  return movementX || movementY || "development" === "test";
}
function setMouseMoving(event) {
  if (!hasMouseMovement(event)) return;
  mouseMoving = true;
}
function resetMouseMoving() {
  mouseMoving = false;
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   assignStyle: () => (/* binding */ assignStyle),
/* harmony export */   orchestrate: () => (/* binding */ orchestrate),
/* harmony export */   setAttribute: () => (/* binding */ setAttribute),
/* harmony export */   setCSSProperty: () => (/* binding */ setCSSProperty),
/* harmony export */   setProperty: () => (/* binding */ setProperty)
/* harmony export */ });
"use client";

// src/dialog/utils/orchestrate.ts
var cleanups = /* @__PURE__ */ new WeakMap();
function orchestrate(element, key, setup) {
  if (!cleanups.has(element)) {
    cleanups.set(element, /* @__PURE__ */ new Map());
  }
  const elementCleanups = cleanups.get(element);
  const prevCleanup = elementCleanups.get(key);
  if (!prevCleanup) {
    elementCleanups.set(key, setup());
    return () => {
      var _a;
      (_a = elementCleanups.get(key)) == null ? void 0 : _a();
      elementCleanups.delete(key);
    };
  }
  const cleanup = setup();
  const nextCleanup = () => {
    cleanup();
    prevCleanup();
    elementCleanups.delete(key);
  };
  elementCleanups.set(key, nextCleanup);
  return () => {
    const isCurrent = elementCleanups.get(key) === nextCleanup;
    if (!isCurrent) return;
    cleanup();
    elementCleanups.set(key, prevCleanup);
  };
}
function setAttribute(element, attr, value) {
  const setup = () => {
    const previousValue = element.getAttribute(attr);
    element.setAttribute(attr, value);
    return () => {
      if (previousValue == null) {
        element.removeAttribute(attr);
      } else {
        element.setAttribute(attr, previousValue);
      }
    };
  };
  return orchestrate(element, attr, setup);
}
function setProperty(element, property, value) {
  const setup = () => {
    const exists = property in element;
    const previousValue = element[property];
    element[property] = value;
    return () => {
      if (!exists) {
        delete element[property];
      } else {
        element[property] = previousValue;
      }
    };
  };
  return orchestrate(element, property, setup);
}
function assignStyle(element, style) {
  if (!element) return () => {
  };
  const setup = () => {
    const prevStyle = element.style.cssText;
    Object.assign(element.style, style);
    return () => {
      element.style.cssText = prevStyle;
    };
  };
  return orchestrate(element, "style", setup);
}
function setCSSProperty(element, property, value) {
  if (!element) return () => {
  };
  const setup = () => {
    const previousValue = element.style.getPropertyValue(property);
    element.style.setProperty(property, value);
    return () => {
      if (previousValue) {
        element.style.setProperty(property, previousValue);
      } else {
        element.style.removeProperty(property);
      }
    };
  };
  return orchestrate(element, property, setup);
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/LVVSG7VH.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/LVVSG7VH.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DialogBackdrop: () => (/* binding */ DialogBackdrop)
/* harmony export */ });
/* harmony import */ var _3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./3NDVDEB4.js */ "./node_modules/@ariakit/react-core/esm/__chunks/3NDVDEB4.js");
/* harmony import */ var _HAX24JB7_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./HAX24JB7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/HAX24JB7.js");
/* harmony import */ var _33YRLYNQ_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./33YRLYNQ.js */ "./node_modules/@ariakit/react-core/esm/__chunks/33YRLYNQ.js");
/* harmony import */ var _HIN2NSI2_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./HIN2NSI2.js */ "./node_modules/@ariakit/react-core/esm/__chunks/HIN2NSI2.js");
/* harmony import */ var _Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Q3KUZPD7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/Q3KUZPD7.js");
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
"use client";







// src/dialog/dialog-backdrop.tsx


function DialogBackdrop({
  store,
  backdrop,
  alwaysVisible,
  hidden
}) {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(null);
  const disclosure = (0,_33YRLYNQ_js__WEBPACK_IMPORTED_MODULE_2__.useDisclosureStore)({ disclosure: store });
  const contentElement = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_4__.useStoreState)(store, "contentElement");
  (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    const backdrop2 = ref.current;
    const dialog = contentElement;
    if (!backdrop2) return;
    if (!dialog) return;
    backdrop2.style.zIndex = getComputedStyle(dialog).zIndex;
  }, [contentElement]);
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_5__.useSafeLayoutEffect)(() => {
    const id = contentElement == null ? void 0 : contentElement.id;
    if (!id) return;
    const backdrop2 = ref.current;
    if (!backdrop2) return;
    return (0,_3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_0__.markAncestor)(backdrop2, id);
  }, [contentElement]);
  const props = (0,_HAX24JB7_js__WEBPACK_IMPORTED_MODULE_1__.useDisclosureContent)({
    ref,
    store: disclosure,
    role: "presentation",
    "data-backdrop": (contentElement == null ? void 0 : contentElement.id) || "",
    alwaysVisible,
    hidden: hidden != null ? hidden : void 0,
    style: {
      position: "fixed",
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    }
  });
  if (!backdrop) return null;
  if ((0,react__WEBPACK_IMPORTED_MODULE_6__.isValidElement)(backdrop)) {
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_HIN2NSI2_js__WEBPACK_IMPORTED_MODULE_3__.Role, { ...props, render: backdrop });
  }
  const Component = typeof backdrop !== "boolean" ? backdrop : "div";
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_HIN2NSI2_js__WEBPACK_IMPORTED_MODULE_3__.Role, { ...props, render: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(Component, {}) });
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/MWF5B7KS.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/MWF5B7KS.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PopoverContextProvider: () => (/* binding */ PopoverContextProvider),
/* harmony export */   PopoverScopedContextProvider: () => (/* binding */ PopoverScopedContextProvider),
/* harmony export */   usePopoverContext: () => (/* binding */ usePopoverContext),
/* harmony export */   usePopoverProviderContext: () => (/* binding */ usePopoverProviderContext),
/* harmony export */   usePopoverScopedContext: () => (/* binding */ usePopoverScopedContext)
/* harmony export */ });
/* harmony import */ var _63N3TCQX_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./63N3TCQX.js */ "./node_modules/@ariakit/react-core/esm/__chunks/63N3TCQX.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
"use client";



// src/popover/popover-context.tsx
var ctx = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.createStoreContext)(
  [_63N3TCQX_js__WEBPACK_IMPORTED_MODULE_0__.DialogContextProvider],
  [_63N3TCQX_js__WEBPACK_IMPORTED_MODULE_0__.DialogScopedContextProvider]
);
var usePopoverContext = ctx.useContext;
var usePopoverScopedContext = ctx.useScopedContext;
var usePopoverProviderContext = ctx.useProviderContext;
var PopoverContextProvider = ctx.ContextProvider;
var PopoverScopedContextProvider = ctx.ScopedContextProvider;




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/NE2XEEQN.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/NE2XEEQN.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useRootDialog: () => (/* binding */ useRootDialog)
/* harmony export */ });
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
"use client";


// src/dialog/utils/use-root-dialog.ts



function useRootDialog({
  attribute,
  contentId,
  contentElement,
  enabled
}) {
  const [updated, retry] = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_0__.useForceUpdate)();
  const isRootDialog = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => {
    if (!enabled) return false;
    if (!contentElement) return false;
    const { body } = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.getDocument)(contentElement);
    const id = body.getAttribute(attribute);
    return !id || id === contentId;
  }, [updated, enabled, contentElement, attribute, contentId]);
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (!enabled) return;
    if (!contentId) return;
    if (!contentElement) return;
    const { body } = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.getDocument)(contentElement);
    if (isRootDialog()) {
      body.setAttribute(attribute, contentId);
      return () => body.removeAttribute(attribute);
    }
    const observer = new MutationObserver(() => (0,react_dom__WEBPACK_IMPORTED_MODULE_3__.flushSync)(retry));
    observer.observe(body, { attributeFilter: [attribute] });
    return () => observer.disconnect();
  }, [updated, enabled, contentId, contentElement, isRootDialog, attribute]);
  return isRootDialog;
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/NQXOL4RD.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/NQXOL4RD.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   usePreventBodyScroll: () => (/* binding */ usePreventBodyScroll)
/* harmony export */ });
/* harmony import */ var _NE2XEEQN_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./NE2XEEQN.js */ "./node_modules/@ariakit/react-core/esm/__chunks/NE2XEEQN.js");
/* harmony import */ var _K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./K2ZF5NU7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
/* harmony import */ var _ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/platform */ "./node_modules/@ariakit/core/esm/__chunks/O6E4ZWCP.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
"use client";



// src/dialog/utils/use-prevent-body-scroll.ts




function getPaddingProperty(documentElement) {
  const documentLeft = documentElement.getBoundingClientRect().left;
  const scrollbarX = Math.round(documentLeft) + documentElement.scrollLeft;
  return scrollbarX ? "paddingLeft" : "paddingRight";
}
function usePreventBodyScroll(contentElement, contentId, enabled) {
  const isRootDialog = (0,_NE2XEEQN_js__WEBPACK_IMPORTED_MODULE_0__.useRootDialog)({
    attribute: "data-dialog-prevent-body-scroll",
    contentElement,
    contentId,
    enabled
  });
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (!isRootDialog()) return;
    if (!contentElement) return;
    const doc = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocument)(contentElement);
    const win = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(contentElement);
    const { documentElement, body } = doc;
    const cssScrollbarWidth = documentElement.style.getPropertyValue("--scrollbar-width");
    const scrollbarWidth = cssScrollbarWidth ? Number.parseInt(cssScrollbarWidth, 10) : win.innerWidth - documentElement.clientWidth;
    const setScrollbarWidthProperty = () => (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.setCSSProperty)(
      documentElement,
      "--scrollbar-width",
      `${scrollbarWidth}px`
    );
    const paddingProperty = getPaddingProperty(documentElement);
    const setStyle = () => (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.assignStyle)(body, {
      overflow: "hidden",
      [paddingProperty]: `${scrollbarWidth}px`
    });
    const setIOSStyle = () => {
      var _a, _b;
      const { scrollX, scrollY, visualViewport } = win;
      const offsetLeft = (_a = visualViewport == null ? void 0 : visualViewport.offsetLeft) != null ? _a : 0;
      const offsetTop = (_b = visualViewport == null ? void 0 : visualViewport.offsetTop) != null ? _b : 0;
      const restoreStyle = (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.assignStyle)(body, {
        position: "fixed",
        overflow: "hidden",
        top: `${-(scrollY - Math.floor(offsetTop))}px`,
        left: `${-(scrollX - Math.floor(offsetLeft))}px`,
        right: "0",
        [paddingProperty]: `${scrollbarWidth}px`
      });
      return () => {
        restoreStyle();
        if (true) {
          win.scrollTo({ left: scrollX, top: scrollY, behavior: "instant" });
        }
      };
    };
    const isIOS = (0,_ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_4__.isApple)() && !(0,_ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_4__.isMac)();
    return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_3__.chain)(
      setScrollbarWidthProperty(),
      isIOS ? setIOSStyle() : setStyle()
    );
  }, [isRootDialog, contentElement]);
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/Q3KUZPD7.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/Q3KUZPD7.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useStore: () => (/* binding */ useStore),
/* harmony export */   useStoreProps: () => (/* binding */ useStoreProps),
/* harmony export */   useStoreState: () => (/* binding */ useStoreState),
/* harmony export */   useStoreStateObject: () => (/* binding */ useStoreStateObject)
/* harmony export */ });
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
/* harmony import */ var _ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/store */ "./node_modules/@ariakit/core/esm/__chunks/SXKM4CGU.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var use_sync_external_store_shim_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! use-sync-external-store/shim/index.js */ "./node_modules/use-sync-external-store/shim/index.js");
"use client";


// src/utils/store.tsx




var { useSyncExternalStore } = use_sync_external_store_shim_index_js__WEBPACK_IMPORTED_MODULE_4__;
var noopSubscribe = () => () => {
};
function useStoreState(store, keyOrSelector = _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_1__.identity) {
  const storeSubscribe = react__WEBPACK_IMPORTED_MODULE_3__.useCallback(
    (callback) => {
      if (!store) return noopSubscribe();
      return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_2__.subscribe)(store, null, callback);
    },
    [store]
  );
  const getSnapshot = () => {
    const key = typeof keyOrSelector === "string" ? keyOrSelector : null;
    const selector = typeof keyOrSelector === "function" ? keyOrSelector : null;
    const state = store == null ? void 0 : store.getState();
    if (selector) return selector(state);
    if (!state) return;
    if (!key) return;
    if (!(0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_1__.hasOwnProperty)(state, key)) return;
    return state[key];
  };
  return useSyncExternalStore(storeSubscribe, getSnapshot, getSnapshot);
}
function useStoreStateObject(store, object) {
  const objRef = react__WEBPACK_IMPORTED_MODULE_3__.useRef(
    {}
  );
  const storeSubscribe = react__WEBPACK_IMPORTED_MODULE_3__.useCallback(
    (callback) => {
      if (!store) return noopSubscribe();
      return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_2__.subscribe)(store, null, callback);
    },
    [store]
  );
  const getSnapshot = () => {
    const state = store == null ? void 0 : store.getState();
    let updated = false;
    const obj = objRef.current;
    for (const prop in object) {
      const keyOrSelector = object[prop];
      if (typeof keyOrSelector === "function") {
        const value = keyOrSelector(state);
        if (value !== obj[prop]) {
          obj[prop] = value;
          updated = true;
        }
      }
      if (typeof keyOrSelector === "string") {
        if (!state) continue;
        if (!(0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_1__.hasOwnProperty)(state, keyOrSelector)) continue;
        const value = state[keyOrSelector];
        if (value !== obj[prop]) {
          obj[prop] = value;
          updated = true;
        }
      }
    }
    if (updated) {
      objRef.current = { ...obj };
    }
    return objRef.current;
  };
  return useSyncExternalStore(storeSubscribe, getSnapshot, getSnapshot);
}
function useStoreProps(store, props, key, setKey) {
  const value = (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_1__.hasOwnProperty)(props, key) ? props[key] : void 0;
  const setValue = setKey ? props[setKey] : void 0;
  const propsRef = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_0__.useLiveRef)({ value, setValue });
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_0__.useSafeLayoutEffect)(() => {
    return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_2__.sync)(store, [key], (state, prev) => {
      const { value: value2, setValue: setValue2 } = propsRef.current;
      if (!setValue2) return;
      if (state[key] === prev[key]) return;
      if (state[key] === value2) return;
      setValue2(state[key]);
    });
  }, [store, key]);
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_0__.useSafeLayoutEffect)(() => {
    if (value === void 0) return;
    store.setState(key, value);
    return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_2__.batch)(store, [key], () => {
      if (value === void 0) return;
      store.setState(key, value);
    });
  });
}
function useStore(createStore, props) {
  const [store, setStore] = react__WEBPACK_IMPORTED_MODULE_3__.useState(() => createStore(props));
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_0__.useSafeLayoutEffect)(() => (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_2__.init)(store), [store]);
  const useState2 = react__WEBPACK_IMPORTED_MODULE_3__.useCallback(
    (keyOrSelector) => useStoreState(store, keyOrSelector),
    [store]
  );
  const memoizedStore = react__WEBPACK_IMPORTED_MODULE_3__.useMemo(
    () => ({ ...store, useState: useState2 }),
    [store, useState2]
  );
  const updateStore = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_0__.useEvent)(() => {
    setStore((store2) => createStore({ ...props, ...store2.getState() }));
  });
  return [memoizedStore, updateStore];
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/QHA3XIQA.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/QHA3XIQA.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useTooltipStore: () => (/* binding */ useTooltipStore),
/* harmony export */   useTooltipStoreProps: () => (/* binding */ useTooltipStoreProps)
/* harmony export */ });
/* harmony import */ var _IAC2O6VC_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./IAC2O6VC.js */ "./node_modules/@ariakit/react-core/esm/__chunks/IAC2O6VC.js");
/* harmony import */ var _Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Q3KUZPD7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/Q3KUZPD7.js");
/* harmony import */ var _ariakit_core_tooltip_tooltip_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/tooltip/tooltip-store */ "./node_modules/@ariakit/core/esm/tooltip/tooltip-store.js");
"use client";



// src/tooltip/tooltip-store.ts

function useTooltipStoreProps(store, update, props) {
  (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__.useStoreProps)(store, props, "type");
  (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__.useStoreProps)(store, props, "skipTimeout");
  return (0,_IAC2O6VC_js__WEBPACK_IMPORTED_MODULE_0__.useHovercardStoreProps)(store, update, props);
}
function useTooltipStore(props = {}) {
  const [store, update] = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_1__.useStore)(_ariakit_core_tooltip_tooltip_store__WEBPACK_IMPORTED_MODULE_2__.createTooltipStore, props);
  return useTooltipStoreProps(store, update, props);
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/RBTTLCIN.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/RBTTLCIN.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   VisuallyHidden: () => (/* binding */ VisuallyHidden),
/* harmony export */   useVisuallyHidden: () => (/* binding */ useVisuallyHidden)
/* harmony export */ });
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
"use client";


// src/visually-hidden/visually-hidden.tsx
var TagName = "span";
var useVisuallyHidden = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_0__.createHook)(
  function useVisuallyHidden2(props) {
    props = {
      ...props,
      style: {
        border: 0,
        clip: "rect(0 0 0 0)",
        height: "1px",
        margin: "-1px",
        overflow: "hidden",
        padding: 0,
        position: "absolute",
        whiteSpace: "nowrap",
        width: "1px",
        ...props.style
      }
    };
    return props;
  }
);
var VisuallyHidden = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function VisuallyHidden2(props) {
  const htmlProps = useVisuallyHidden(props);
  return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_0__.createElement)(TagName, htmlProps);
});




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/S7U6BLGA.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/S7U6BLGA.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableAccessibilityTreeOutside: () => (/* binding */ disableAccessibilityTreeOutside),
/* harmony export */   hideElementFromAccessibilityTree: () => (/* binding */ hideElementFromAccessibilityTree)
/* harmony export */ });
/* harmony import */ var _AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AOUGVQZ3.js */ "./node_modules/@ariakit/react-core/esm/__chunks/AOUGVQZ3.js");
/* harmony import */ var _K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./K2ZF5NU7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js");
/* harmony import */ var _63XF7ACK_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./63XF7ACK.js */ "./node_modules/@ariakit/react-core/esm/__chunks/63XF7ACK.js");
"use client";




// src/dialog/utils/disable-accessibility-tree-outside.ts
function hideElementFromAccessibilityTree(element) {
  return (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.setAttribute)(element, "aria-hidden", "true");
}
function disableAccessibilityTreeOutside(id, elements) {
  const cleanups = [];
  const ids = elements.map((el) => el == null ? void 0 : el.id);
  (0,_AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_0__.walkTreeOutside)(id, elements, (element) => {
    if ((0,_63XF7ACK_js__WEBPACK_IMPORTED_MODULE_2__.isBackdrop)(element, ...ids)) return;
    cleanups.unshift(hideElementFromAccessibilityTree(element));
  });
  const restoreAccessibilityTree = () => {
    for (const cleanup of cleanups) {
      cleanup();
    }
  };
  return restoreAccessibilityTree;
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/SWBQ42SL.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/SWBQ42SL.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Portal: () => (/* binding */ Portal),
/* harmony export */   usePortal: () => (/* binding */ usePortal)
/* harmony export */ });
/* harmony import */ var _AOQQTIBO_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AOQQTIBO.js */ "./node_modules/@ariakit/react-core/esm/__chunks/AOQQTIBO.js");
/* harmony import */ var _IEBFIEPB_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./IEBFIEPB.js */ "./node_modules/@ariakit/react-core/esm/__chunks/IEBFIEPB.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _YXGXYGQX_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./YXGXYGQX.js */ "./node_modules/@ariakit/react-core/esm/__chunks/YXGXYGQX.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var _ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ariakit/core/utils/focus */ "./node_modules/@ariakit/core/esm/utils/focus.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
"use client";






// src/portal/portal.tsx






var TagName = "div";
function getRootElement(element) {
  return (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__.getDocument)(element).body;
}
function getPortalElement(element, portalElement) {
  if (!portalElement) {
    return (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__.getDocument)(element).createElement("div");
  }
  if (typeof portalElement === "function") {
    return portalElement(element);
  }
  return portalElement;
}
function getRandomId(prefix = "id") {
  return `${prefix ? `${prefix}-` : ""}${Math.random().toString(36).slice(2, 8)}`;
}
function queueFocus(element) {
  queueMicrotask(() => {
    element == null ? void 0 : element.focus();
  });
}
var usePortal = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__.createHook)(function usePortal2({
  preserveTabOrder,
  preserveTabOrderAnchor,
  portalElement,
  portalRef,
  portal = true,
  ...props
}) {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_8__.useRef)(null);
  const refProp = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useMergeRefs)(ref, props.ref);
  const context = (0,react__WEBPACK_IMPORTED_MODULE_8__.useContext)(_AOQQTIBO_js__WEBPACK_IMPORTED_MODULE_0__.PortalContext);
  const [portalNode, setPortalNode] = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(null);
  const [anchorPortalNode, setAnchorPortalNode] = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(
    null
  );
  const outerBeforeRef = (0,react__WEBPACK_IMPORTED_MODULE_8__.useRef)(null);
  const innerBeforeRef = (0,react__WEBPACK_IMPORTED_MODULE_8__.useRef)(null);
  const innerAfterRef = (0,react__WEBPACK_IMPORTED_MODULE_8__.useRef)(null);
  const outerAfterRef = (0,react__WEBPACK_IMPORTED_MODULE_8__.useRef)(null);
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useSafeLayoutEffect)(() => {
    const element = ref.current;
    if (!element || !portal) {
      setPortalNode(null);
      return;
    }
    const portalEl = getPortalElement(element, portalElement);
    if (!portalEl) {
      setPortalNode(null);
      return;
    }
    const isPortalInDocument = portalEl.isConnected;
    if (!isPortalInDocument) {
      const rootElement = context || getRootElement(element);
      rootElement.appendChild(portalEl);
    }
    if (!portalEl.id) {
      portalEl.id = element.id ? `portal/${element.id}` : getRandomId();
    }
    setPortalNode(portalEl);
    (0,_YXGXYGQX_js__WEBPACK_IMPORTED_MODULE_4__.setRef)(portalRef, portalEl);
    if (isPortalInDocument) return;
    return () => {
      portalEl.remove();
      (0,_YXGXYGQX_js__WEBPACK_IMPORTED_MODULE_4__.setRef)(portalRef, null);
    };
  }, [portal, portalElement, context, portalRef]);
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useSafeLayoutEffect)(() => {
    if (!portal) return;
    if (!preserveTabOrder) return;
    if (!preserveTabOrderAnchor) return;
    const doc = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__.getDocument)(preserveTabOrderAnchor);
    const element = doc.createElement("span");
    element.style.position = "fixed";
    preserveTabOrderAnchor.insertAdjacentElement("afterend", element);
    setAnchorPortalNode(element);
    return () => {
      element.remove();
      setAnchorPortalNode(null);
    };
  }, [portal, preserveTabOrder, preserveTabOrderAnchor]);
  (0,react__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    if (!portalNode) return;
    if (!preserveTabOrder) return;
    let raf = 0;
    const onFocus = (event) => {
      if (!(0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_6__.isFocusEventOutside)(event)) return;
      const focusing = event.type === "focusin";
      cancelAnimationFrame(raf);
      if (focusing) {
        return (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.restoreFocusIn)(portalNode);
      }
      raf = requestAnimationFrame(() => {
        (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.disableFocusIn)(portalNode, true);
      });
    };
    portalNode.addEventListener("focusin", onFocus, true);
    portalNode.addEventListener("focusout", onFocus, true);
    return () => {
      cancelAnimationFrame(raf);
      portalNode.removeEventListener("focusin", onFocus, true);
      portalNode.removeEventListener("focusout", onFocus, true);
    };
  }, [portalNode, preserveTabOrder]);
  props = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useWrapElement)(
    props,
    (element) => {
      element = // While the portal node is not in the DOM, we need to pass the
      // current context to the portal context, otherwise it's going to
      // reset to the body element on nested portals.
      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_AOQQTIBO_js__WEBPACK_IMPORTED_MODULE_0__.PortalContext.Provider, { value: portalNode || context, children: element });
      if (!portal) return element;
      if (!portalNode) {
        return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(
          "span",
          {
            ref: refProp,
            id: props.id,
            style: { position: "fixed" },
            hidden: true
          }
        );
      }
      element = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.Fragment, { children: [
        preserveTabOrder && portalNode && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(
          _IEBFIEPB_js__WEBPACK_IMPORTED_MODULE_1__.FocusTrap,
          {
            ref: innerBeforeRef,
            "data-focus-trap": props.id,
            className: "__focus-trap-inner-before",
            onFocus: (event) => {
              if ((0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_6__.isFocusEventOutside)(event, portalNode)) {
                queueFocus((0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.getNextTabbable)());
              } else {
                queueFocus(outerBeforeRef.current);
              }
            }
          }
        ),
        element,
        preserveTabOrder && portalNode && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(
          _IEBFIEPB_js__WEBPACK_IMPORTED_MODULE_1__.FocusTrap,
          {
            ref: innerAfterRef,
            "data-focus-trap": props.id,
            className: "__focus-trap-inner-after",
            onFocus: (event) => {
              if ((0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_6__.isFocusEventOutside)(event, portalNode)) {
                queueFocus((0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.getPreviousTabbable)());
              } else {
                queueFocus(outerAfterRef.current);
              }
            }
          }
        )
      ] });
      if (portalNode) {
        element = (0,react_dom__WEBPACK_IMPORTED_MODULE_9__.createPortal)(element, portalNode);
      }
      let preserveTabOrderElement = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.Fragment, { children: [
        preserveTabOrder && portalNode && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(
          _IEBFIEPB_js__WEBPACK_IMPORTED_MODULE_1__.FocusTrap,
          {
            ref: outerBeforeRef,
            "data-focus-trap": props.id,
            className: "__focus-trap-outer-before",
            onFocus: (event) => {
              const fromOuter = event.relatedTarget === outerAfterRef.current;
              if (!fromOuter && (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_6__.isFocusEventOutside)(event, portalNode)) {
                queueFocus(innerBeforeRef.current);
              } else {
                queueFocus((0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.getPreviousTabbable)());
              }
            }
          }
        ),
        preserveTabOrder && // We're using position: fixed here so that the browser doesn't
        // add margin to the element when setting gap on a parent element.
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("span", { "aria-owns": portalNode == null ? void 0 : portalNode.id, style: { position: "fixed" } }),
        preserveTabOrder && portalNode && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(
          _IEBFIEPB_js__WEBPACK_IMPORTED_MODULE_1__.FocusTrap,
          {
            ref: outerAfterRef,
            "data-focus-trap": props.id,
            className: "__focus-trap-outer-after",
            onFocus: (event) => {
              if ((0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_6__.isFocusEventOutside)(event, portalNode)) {
                queueFocus(innerAfterRef.current);
              } else {
                const nextTabbable = (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.getNextTabbable)();
                if (nextTabbable === innerBeforeRef.current) {
                  requestAnimationFrame(() => {
                    var _a;
                    return (_a = (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.getNextTabbable)()) == null ? void 0 : _a.focus();
                  });
                  return;
                }
                queueFocus(nextTabbable);
              }
            }
          }
        )
      ] });
      if (anchorPortalNode && preserveTabOrder) {
        preserveTabOrderElement = (0,react_dom__WEBPACK_IMPORTED_MODULE_9__.createPortal)(
          preserveTabOrderElement,
          anchorPortalNode
        );
      }
      return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.Fragment, { children: [
        preserveTabOrderElement,
        element
      ] });
    },
    [portalNode, context, portal, props.id, preserveTabOrder, anchorPortalNode]
  );
  props = {
    ...props,
    ref: refProp
  };
  return props;
});
var Portal = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function Portal2(props) {
  const htmlProps = usePortal(props);
  return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__.createElement)(TagName, htmlProps);
});




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/SWN3JYXT.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/SWN3JYXT.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FocusableContext: () => (/* binding */ FocusableContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
"use client";

// src/focusable/focusable-context.tsx

var FocusableContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(true);




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/UG4JNWMY.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/UG4JNWMY.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FocusableContainer: () => (/* binding */ FocusableContainer),
/* harmony export */   useFocusableContainer: () => (/* binding */ useFocusableContainer)
/* harmony export */ });
/* harmony import */ var _SWN3JYXT_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SWN3JYXT.js */ "./node_modules/@ariakit/react-core/esm/__chunks/SWN3JYXT.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
"use client";




// src/focusable/focusable-container.tsx

var TagName = "div";
var useFocusableContainer = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.createHook)(function useFocusableContainer2({ autoFocusOnShow = true, ...props }) {
  props = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__.useWrapElement)(
    props,
    (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_SWN3JYXT_js__WEBPACK_IMPORTED_MODULE_0__.FocusableContext.Provider, { value: autoFocusOnShow, children: element }),
    [autoFocusOnShow]
  );
  return props;
});
var FocusableContainer = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function FocusableContainer2(props) {
  const htmlProps = useFocusableContainer(props);
  return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.createElement)(TagName, htmlProps);
});




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/US3TW2XI.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/US3TW2XI.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Focusable: () => (/* binding */ Focusable),
/* harmony export */   isSafariFocusAncestor: () => (/* binding */ isSafariFocusAncestor),
/* harmony export */   useFocusable: () => (/* binding */ useFocusable)
/* harmony export */ });
/* harmony import */ var _SWN3JYXT_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SWN3JYXT.js */ "./node_modules/@ariakit/react-core/esm/__chunks/SWN3JYXT.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var _ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ariakit/core/utils/focus */ "./node_modules/@ariakit/core/esm/utils/focus.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
/* harmony import */ var _ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ariakit/core/utils/platform */ "./node_modules/@ariakit/core/esm/__chunks/O6E4ZWCP.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
"use client";




// src/focusable/focusable.tsx






var TagName = "div";
var isSafariBrowser = (0,_ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_7__.isSafari)();
var alwaysFocusVisibleInputTypes = [
  "text",
  "search",
  "url",
  "tel",
  "email",
  "password",
  "number",
  "date",
  "month",
  "week",
  "time",
  "datetime",
  "datetime-local"
];
var safariFocusAncestorSymbol = Symbol("safariFocusAncestor");
function isSafariFocusAncestor(element) {
  if (!element) return false;
  return !!element[safariFocusAncestorSymbol];
}
function markSafariFocusAncestor(element, value) {
  if (!element) return;
  element[safariFocusAncestorSymbol] = value;
}
function isAlwaysFocusVisible(element) {
  const { tagName, readOnly, type } = element;
  if (tagName === "TEXTAREA" && !readOnly) return true;
  if (tagName === "SELECT" && !readOnly) return true;
  if (tagName === "INPUT" && !readOnly) {
    return alwaysFocusVisibleInputTypes.includes(type);
  }
  if (element.isContentEditable) return true;
  const role = element.getAttribute("role");
  if (role === "combobox" && element.dataset.name) {
    return true;
  }
  return false;
}
function getLabels(element) {
  if ("labels" in element) {
    return element.labels;
  }
  return null;
}
function isNativeCheckboxOrRadio(element) {
  const tagName = element.tagName.toLowerCase();
  if (tagName === "input" && element.type) {
    return element.type === "radio" || element.type === "checkbox";
  }
  return false;
}
function isNativeTabbable(tagName) {
  if (!tagName) return true;
  return tagName === "button" || tagName === "summary" || tagName === "input" || tagName === "select" || tagName === "textarea" || tagName === "a";
}
function supportsDisabledAttribute(tagName) {
  if (!tagName) return true;
  return tagName === "button" || tagName === "input" || tagName === "select" || tagName === "textarea";
}
function getTabIndex(focusable, trulyDisabled, nativeTabbable, supportsDisabled, tabIndexProp) {
  if (!focusable) {
    return tabIndexProp;
  }
  if (trulyDisabled) {
    if (nativeTabbable && !supportsDisabled) {
      return -1;
    }
    return;
  }
  if (nativeTabbable) {
    return tabIndexProp;
  }
  return tabIndexProp || 0;
}
function useDisableEvent(onEvent, disabled) {
  return (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)((event) => {
    onEvent == null ? void 0 : onEvent(event);
    if (event.defaultPrevented) return;
    if (disabled) {
      event.stopPropagation();
      event.preventDefault();
    }
  });
}
var hasInstalledGlobalEventListeners = false;
var isKeyboardModality = true;
function onGlobalMouseDown(event) {
  const target = event.target;
  if (target && "hasAttribute" in target) {
    if (!target.hasAttribute("data-focus-visible")) {
      isKeyboardModality = false;
    }
  }
}
function onGlobalKeyDown(event) {
  if (event.metaKey) return;
  if (event.ctrlKey) return;
  if (event.altKey) return;
  isKeyboardModality = true;
}
var useFocusable = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.createHook)(
  function useFocusable2({
    focusable = true,
    accessibleWhenDisabled,
    autoFocus,
    onFocusVisible,
    ...props
  }) {
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_8__.useRef)(null);
    (0,react__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
      if (!focusable) return;
      if (hasInstalledGlobalEventListeners) return;
      (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.addGlobalEventListener)("mousedown", onGlobalMouseDown, true);
      (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.addGlobalEventListener)("keydown", onGlobalKeyDown, true);
      hasInstalledGlobalEventListeners = true;
    }, [focusable]);
    if (isSafariBrowser) {
      (0,react__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
        if (!focusable) return;
        const element = ref.current;
        if (!element) return;
        if (!isNativeCheckboxOrRadio(element)) return;
        const labels = getLabels(element);
        if (!labels) return;
        const onMouseUp = () => queueMicrotask(() => element.focus());
        for (const label of labels) {
          label.addEventListener("mouseup", onMouseUp);
        }
        return () => {
          for (const label of labels) {
            label.removeEventListener("mouseup", onMouseUp);
          }
        };
      }, [focusable]);
    }
    const disabled = focusable && (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__.disabledFromProps)(props);
    const trulyDisabled = !!disabled && !accessibleWhenDisabled;
    const [focusVisible, setFocusVisible] = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
    (0,react__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
      if (!focusable) return;
      if (trulyDisabled && focusVisible) {
        setFocusVisible(false);
      }
    }, [focusable, trulyDisabled, focusVisible]);
    (0,react__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
      if (!focusable) return;
      if (!focusVisible) return;
      const element = ref.current;
      if (!element) return;
      if (typeof IntersectionObserver === "undefined") return;
      const observer = new IntersectionObserver(() => {
        if (!(0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_5__.isFocusable)(element)) {
          setFocusVisible(false);
        }
      });
      observer.observe(element);
      return () => observer.disconnect();
    }, [focusable, focusVisible]);
    const onKeyPressCapture = useDisableEvent(
      props.onKeyPressCapture,
      disabled
    );
    const onMouseDownCapture = useDisableEvent(
      props.onMouseDownCapture,
      disabled
    );
    const onClickCapture = useDisableEvent(props.onClickCapture, disabled);
    const onMouseDownProp = props.onMouseDown;
    const onMouseDown = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)((event) => {
      onMouseDownProp == null ? void 0 : onMouseDownProp(event);
      if (event.defaultPrevented) return;
      if (!focusable) return;
      const element = event.currentTarget;
      if (!isSafariBrowser) return;
      if ((0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.isPortalEvent)(event)) return;
      if (!(0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.isButton)(element) && !isNativeCheckboxOrRadio(element)) return;
      let receivedFocus = false;
      const onFocus = () => {
        receivedFocus = true;
      };
      const options = { capture: true, once: true };
      element.addEventListener("focusin", onFocus, options);
      const focusableContainer = (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_5__.getClosestFocusable)(element.parentElement);
      markSafariFocusAncestor(focusableContainer, true);
      (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.queueBeforeEvent)(element, "mouseup", () => {
        element.removeEventListener("focusin", onFocus, true);
        markSafariFocusAncestor(focusableContainer, false);
        if (receivedFocus) return;
        (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_5__.focusIfNeeded)(element);
      });
    });
    const handleFocusVisible = (event, currentTarget) => {
      if (currentTarget) {
        event.currentTarget = currentTarget;
      }
      if (!focusable) return;
      const element = event.currentTarget;
      if (!element) return;
      if (!(0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_5__.hasFocus)(element)) return;
      onFocusVisible == null ? void 0 : onFocusVisible(event);
      if (event.defaultPrevented) return;
      element.dataset.focusVisible = "true";
      setFocusVisible(true);
    };
    const onKeyDownCaptureProp = props.onKeyDownCapture;
    const onKeyDownCapture = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)((event) => {
      onKeyDownCaptureProp == null ? void 0 : onKeyDownCaptureProp(event);
      if (event.defaultPrevented) return;
      if (!focusable) return;
      if (focusVisible) return;
      if (event.metaKey) return;
      if (event.altKey) return;
      if (event.ctrlKey) return;
      if (!(0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.isSelfTarget)(event)) return;
      const element = event.currentTarget;
      const applyFocusVisible = () => handleFocusVisible(event, element);
      (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.queueBeforeEvent)(element, "focusout", applyFocusVisible);
    });
    const onFocusCaptureProp = props.onFocusCapture;
    const onFocusCapture = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)((event) => {
      onFocusCaptureProp == null ? void 0 : onFocusCaptureProp(event);
      if (event.defaultPrevented) return;
      if (!focusable) return;
      if (!(0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.isSelfTarget)(event)) {
        setFocusVisible(false);
        return;
      }
      const element = event.currentTarget;
      const applyFocusVisible = () => handleFocusVisible(event, element);
      if (isKeyboardModality || isAlwaysFocusVisible(event.target)) {
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.queueBeforeEvent)(event.target, "focusout", applyFocusVisible);
      } else {
        setFocusVisible(false);
      }
    });
    const onBlurProp = props.onBlur;
    const onBlur = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)((event) => {
      onBlurProp == null ? void 0 : onBlurProp(event);
      if (!focusable) return;
      if (!(0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.isFocusEventOutside)(event)) return;
      event.currentTarget.removeAttribute("data-focus-visible");
      setFocusVisible(false);
    });
    const autoFocusOnShow = (0,react__WEBPACK_IMPORTED_MODULE_8__.useContext)(_SWN3JYXT_js__WEBPACK_IMPORTED_MODULE_0__.FocusableContext);
    const autoFocusRef = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)((element) => {
      if (!focusable) return;
      if (!autoFocus) return;
      if (!element) return;
      if (!autoFocusOnShow) return;
      queueMicrotask(() => {
        if ((0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_5__.hasFocus)(element)) return;
        if (!(0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_5__.isFocusable)(element)) return;
        element.focus();
      });
    });
    const tagName = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__.useTagName)(ref);
    const nativeTabbable = focusable && isNativeTabbable(tagName);
    const supportsDisabled = focusable && supportsDisabledAttribute(tagName);
    const styleProp = props.style;
    const style = (0,react__WEBPACK_IMPORTED_MODULE_8__.useMemo)(() => {
      if (trulyDisabled) {
        return { pointerEvents: "none", ...styleProp };
      }
      return styleProp;
    }, [trulyDisabled, styleProp]);
    props = {
      "data-focus-visible": focusable && focusVisible || void 0,
      "data-autofocus": autoFocus || void 0,
      "aria-disabled": disabled || void 0,
      ...props,
      ref: (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_2__.useMergeRefs)(ref, autoFocusRef, props.ref),
      style,
      tabIndex: getTabIndex(
        focusable,
        trulyDisabled,
        nativeTabbable,
        supportsDisabled,
        props.tabIndex
      ),
      disabled: supportsDisabled && trulyDisabled ? true : void 0,
      // TODO: Test Focusable contentEditable.
      contentEditable: disabled ? void 0 : props.contentEditable,
      onKeyPressCapture,
      onClickCapture,
      onMouseDownCapture,
      onMouseDown,
      onKeyDownCapture,
      onFocusCapture,
      onBlur
    };
    return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__.removeUndefinedValues)(props);
  }
);
var Focusable = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Focusable2(props) {
  const htmlProps = useFocusable(props);
  return (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.createElement)(TagName, htmlProps);
});




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/WVT277Z4.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/WVT277Z4.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TooltipContextProvider: () => (/* binding */ TooltipContextProvider),
/* harmony export */   TooltipScopedContextProvider: () => (/* binding */ TooltipScopedContextProvider),
/* harmony export */   useTooltipContext: () => (/* binding */ useTooltipContext),
/* harmony export */   useTooltipProviderContext: () => (/* binding */ useTooltipProviderContext),
/* harmony export */   useTooltipScopedContext: () => (/* binding */ useTooltipScopedContext)
/* harmony export */ });
/* harmony import */ var _2WDBOH5E_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./2WDBOH5E.js */ "./node_modules/@ariakit/react-core/esm/__chunks/2WDBOH5E.js");
/* harmony import */ var _ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
"use client";



// src/tooltip/tooltip-context.tsx
var ctx = (0,_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_1__.createStoreContext)(
  [_2WDBOH5E_js__WEBPACK_IMPORTED_MODULE_0__.HovercardContextProvider],
  [_2WDBOH5E_js__WEBPACK_IMPORTED_MODULE_0__.HovercardScopedContextProvider]
);
var useTooltipContext = ctx.useContext;
var useTooltipScopedContext = ctx.useScopedContext;
var useTooltipProviderContext = ctx.useProviderContext;
var TooltipContextProvider = ctx.ContextProvider;
var TooltipScopedContextProvider = ctx.ScopedContextProvider;




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/X7QOZUD3.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/X7QOZUD3.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getElementPolygon: () => (/* binding */ getElementPolygon),
/* harmony export */   getEventPoint: () => (/* binding */ getEventPoint),
/* harmony export */   isPointInPolygon: () => (/* binding */ isPointInPolygon)
/* harmony export */ });
"use client";

// src/hovercard/utils/polygon.ts
function getEventPoint(event) {
  return [event.clientX, event.clientY];
}
function isPointInPolygon(point, polygon) {
  const [x, y] = point;
  let inside = false;
  const length = polygon.length;
  for (let l = length, i = 0, j = l - 1; i < l; j = i++) {
    const [xi, yi] = polygon[i];
    const [xj, yj] = polygon[j];
    const [, vy] = polygon[j === 0 ? l - 1 : j - 1] || [0, 0];
    const where = (yi - yj) * (x - xi) - (xi - xj) * (y - yi);
    if (yj < yi) {
      if (y >= yj && y < yi) {
        if (where === 0) return true;
        if (where > 0) {
          if (y === yj) {
            if (y > vy) {
              inside = !inside;
            }
          } else {
            inside = !inside;
          }
        }
      }
    } else if (yi < yj) {
      if (y > yi && y <= yj) {
        if (where === 0) return true;
        if (where < 0) {
          if (y === yj) {
            if (y < vy) {
              inside = !inside;
            }
          } else {
            inside = !inside;
          }
        }
      }
    } else if (y === yi && (x >= xj && x <= xi || x >= xi && x <= xj)) {
      return true;
    }
  }
  return inside;
}
function getEnterPointPlacement(enterPoint, rect) {
  const { top, right, bottom, left } = rect;
  const [x, y] = enterPoint;
  const placementX = x < left ? "left" : x > right ? "right" : null;
  const placementY = y < top ? "top" : y > bottom ? "bottom" : null;
  return [placementX, placementY];
}
function getElementPolygon(element, enterPoint) {
  const rect = element.getBoundingClientRect();
  const { top, right, bottom, left } = rect;
  const [x, y] = getEnterPointPlacement(enterPoint, rect);
  const polygon = [enterPoint];
  if (x) {
    if (y !== "top") {
      polygon.push([x === "left" ? left : right, top]);
    }
    polygon.push([x === "left" ? right : left, top]);
    polygon.push([x === "left" ? right : left, bottom]);
    if (y !== "bottom") {
      polygon.push([x === "left" ? left : right, bottom]);
    }
  } else if (y === "top") {
    polygon.push([left, top]);
    polygon.push([left, bottom]);
    polygon.push([right, bottom]);
    polygon.push([right, top]);
  } else {
    polygon.push([left, bottom]);
    polygon.push([left, top]);
    polygon.push([right, top]);
    polygon.push([right, bottom]);
  }
  return polygon;
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/Y7OMCS5T.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/Y7OMCS5T.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useHideOnInteractOutside: () => (/* binding */ useHideOnInteractOutside)
/* harmony export */ });
/* harmony import */ var _HLTQOHKZ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./HLTQOHKZ.js */ "./node_modules/@ariakit/react-core/esm/__chunks/HLTQOHKZ.js");
/* harmony import */ var _3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./3NDVDEB4.js */ "./node_modules/@ariakit/react-core/esm/__chunks/3NDVDEB4.js");
/* harmony import */ var _US3TW2XI_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./US3TW2XI.js */ "./node_modules/@ariakit/react-core/esm/__chunks/US3TW2XI.js");
/* harmony import */ var _Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Q3KUZPD7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/Q3KUZPD7.js");
/* harmony import */ var _K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
"use client";






// src/dialog/utils/use-hide-on-interact-outside.ts



function isInDocument(target) {
  if (target.tagName === "HTML") return true;
  return (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__.contains)((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__.getDocument)(target).body, target);
}
function isDisclosure(disclosure, target) {
  if (!disclosure) return false;
  if ((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__.contains)(disclosure, target)) return true;
  const activeId = target.getAttribute("aria-activedescendant");
  if (activeId) {
    const activeElement = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__.getDocument)(disclosure).getElementById(activeId);
    if (activeElement) {
      return (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__.contains)(disclosure, activeElement);
    }
  }
  return false;
}
function isMouseEventOnDialog(event, dialog) {
  if (!("clientY" in event)) return false;
  const rect = dialog.getBoundingClientRect();
  if (rect.width === 0 || rect.height === 0) return false;
  return rect.top <= event.clientY && event.clientY <= rect.top + rect.height && rect.left <= event.clientX && event.clientX <= rect.left + rect.width;
}
function useEventOutside({
  store,
  type,
  listener,
  capture,
  domReady
}) {
  const callListener = (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__.useEvent)(listener);
  const open = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_3__.useStoreState)(store, "open");
  const focusedRef = (0,react__WEBPACK_IMPORTED_MODULE_7__.useRef)(false);
  (0,_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__.useSafeLayoutEffect)(() => {
    if (!open) return;
    if (!domReady) return;
    const { contentElement } = store.getState();
    if (!contentElement) return;
    const onFocus = () => {
      focusedRef.current = true;
    };
    contentElement.addEventListener("focusin", onFocus, true);
    return () => contentElement.removeEventListener("focusin", onFocus, true);
  }, [store, open, domReady]);
  (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
    if (!open) return;
    const onEvent = (event) => {
      const { contentElement, disclosureElement } = store.getState();
      const target = event.target;
      if (!contentElement) return;
      if (!target) return;
      if (!isInDocument(target)) return;
      if ((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__.contains)(contentElement, target)) return;
      if (isDisclosure(disclosureElement, target)) return;
      if (target.hasAttribute("data-focus-trap")) return;
      if (isMouseEventOnDialog(event, contentElement)) return;
      const focused = focusedRef.current;
      if (focused && !(0,_3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_1__.isElementMarked)(target, contentElement.id)) return;
      if ((0,_US3TW2XI_js__WEBPACK_IMPORTED_MODULE_2__.isSafariFocusAncestor)(target)) return;
      callListener(event);
    };
    return (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_6__.addGlobalEventListener)(type, onEvent, capture);
  }, [open, capture]);
}
function shouldHideOnInteractOutside(hideOnInteractOutside, event) {
  if (typeof hideOnInteractOutside === "function") {
    return hideOnInteractOutside(event);
  }
  return !!hideOnInteractOutside;
}
function useHideOnInteractOutside(store, hideOnInteractOutside, domReady) {
  const open = (0,_Q3KUZPD7_js__WEBPACK_IMPORTED_MODULE_3__.useStoreState)(store, "open");
  const previousMouseDownRef = (0,_HLTQOHKZ_js__WEBPACK_IMPORTED_MODULE_0__.usePreviousMouseDownRef)(open);
  const props = { store, domReady, capture: true };
  useEventOutside({
    ...props,
    type: "click",
    listener: (event) => {
      const { contentElement } = store.getState();
      const previousMouseDown = previousMouseDownRef.current;
      if (!previousMouseDown) return;
      if (!(0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__.isVisible)(previousMouseDown)) return;
      if (!(0,_3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_1__.isElementMarked)(previousMouseDown, contentElement == null ? void 0 : contentElement.id)) return;
      if (!shouldHideOnInteractOutside(hideOnInteractOutside, event)) return;
      store.hide();
    }
  });
  useEventOutside({
    ...props,
    type: "focusin",
    listener: (event) => {
      const { contentElement } = store.getState();
      if (!contentElement) return;
      if (event.target === (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__.getDocument)(contentElement)) return;
      if (!shouldHideOnInteractOutside(hideOnInteractOutside, event)) return;
      store.hide();
    }
  });
  useEventOutside({
    ...props,
    type: "contextmenu",
    listener: (event) => {
      if (!shouldHideOnInteractOutside(hideOnInteractOutside, event)) return;
      store.hide();
    }
  });
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/YXGXYGQX.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/YXGXYGQX.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getRefProperty: () => (/* binding */ getRefProperty),
/* harmony export */   isValidElementWithRef: () => (/* binding */ isValidElementWithRef),
/* harmony export */   mergeProps: () => (/* binding */ mergeProps),
/* harmony export */   setRef: () => (/* binding */ setRef)
/* harmony export */ });
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
"use client";

// src/utils/misc.ts


function setRef(ref, value) {
  if (typeof ref === "function") {
    ref(value);
  } else if (ref) {
    ref.current = value;
  }
}
function isValidElementWithRef(element) {
  if (!element) return false;
  if (!(0,react__WEBPACK_IMPORTED_MODULE_1__.isValidElement)(element)) return false;
  if ("ref" in element.props) return true;
  if ("ref" in element) return true;
  return false;
}
function getRefProperty(element) {
  if (!isValidElementWithRef(element)) return null;
  const props = { ...element.props };
  return props.ref || element.ref;
}
function mergeProps(base, overrides) {
  const props = { ...base };
  for (const key in overrides) {
    if (!(0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_0__.hasOwnProperty)(overrides, key)) continue;
    if (key === "className") {
      const prop = "className";
      props[prop] = base[prop] ? `${base[prop]} ${overrides[prop]}` : overrides[prop];
      continue;
    }
    if (key === "style") {
      const prop = "style";
      props[prop] = base[prop] ? { ...base[prop], ...overrides[prop] } : overrides[prop];
      continue;
    }
    const overrideValue = overrides[key];
    if (typeof overrideValue === "function" && key.startsWith("on")) {
      const baseValue = base[key];
      if (typeof baseValue === "function") {
        props[key] = (...args) => {
          overrideValue(...args);
          baseValue(...args);
        };
        continue;
      }
    }
    props[key] = overrideValue;
  }
  return props;
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/__chunks/Z5GCVBAY.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/__chunks/Z5GCVBAY.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableTree: () => (/* binding */ disableTree),
/* harmony export */   disableTreeOutside: () => (/* binding */ disableTreeOutside)
/* harmony export */ });
/* harmony import */ var _IGR4SXG2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./IGR4SXG2.js */ "./node_modules/@ariakit/react-core/esm/__chunks/IGR4SXG2.js");
/* harmony import */ var _677M2CI3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./677M2CI3.js */ "./node_modules/@ariakit/react-core/esm/__chunks/677M2CI3.js");
/* harmony import */ var _S7U6BLGA_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./S7U6BLGA.js */ "./node_modules/@ariakit/react-core/esm/__chunks/S7U6BLGA.js");
/* harmony import */ var _AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AOUGVQZ3.js */ "./node_modules/@ariakit/react-core/esm/__chunks/AOUGVQZ3.js");
/* harmony import */ var _K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./K2ZF5NU7.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js");
/* harmony import */ var _63XF7ACK_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./63XF7ACK.js */ "./node_modules/@ariakit/react-core/esm/__chunks/63XF7ACK.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
/* harmony import */ var _ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ariakit/core/utils/focus */ "./node_modules/@ariakit/core/esm/utils/focus.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
"use client";







// src/dialog/utils/disable-tree.ts



function disableTree(element, ignoredElements) {
  if (!("style" in element)) return _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_8__.noop;
  if ((0,_677M2CI3_js__WEBPACK_IMPORTED_MODULE_1__.supportsInert)()) {
    return (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_4__.setProperty)(element, "inert", true);
  }
  const tabbableElements = (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.getAllTabbableIn)(element, true);
  const enableElements = tabbableElements.map((element2) => {
    if (ignoredElements == null ? void 0 : ignoredElements.some((el) => el && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_6__.contains)(el, element2))) return _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_8__.noop;
    const restoreFocusMethod = (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_4__.orchestrate)(element2, "focus", () => {
      element2.focus = _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_8__.noop;
      return () => {
        delete element2.focus;
      };
    });
    return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_8__.chain)((0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_4__.setAttribute)(element2, "tabindex", "-1"), restoreFocusMethod);
  });
  return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_8__.chain)(
    ...enableElements,
    (0,_S7U6BLGA_js__WEBPACK_IMPORTED_MODULE_2__.hideElementFromAccessibilityTree)(element),
    (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_4__.assignStyle)(element, {
      pointerEvents: "none",
      userSelect: "none",
      cursor: "default"
    })
  );
}
function disableTreeOutside(id, elements) {
  const cleanups = [];
  const ids = elements.map((el) => el == null ? void 0 : el.id);
  (0,_AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_3__.walkTreeOutside)(
    id,
    elements,
    (element) => {
      if ((0,_63XF7ACK_js__WEBPACK_IMPORTED_MODULE_5__.isBackdrop)(element, ...ids)) return;
      if ((0,_IGR4SXG2_js__WEBPACK_IMPORTED_MODULE_0__.isFocusTrap)(element, ...ids)) return;
      cleanups.unshift(disableTree(element, elements));
    },
    (element) => {
      if (!element.hasAttribute("role")) return;
      if (elements.some((el) => el && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_6__.contains)(el, element))) return;
      cleanups.unshift((0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_4__.setAttribute)(element, "role", "none"));
    }
  );
  const restoreTreeOutside = () => {
    for (const cleanup of cleanups) {
      cleanup();
    }
  };
  return restoreTreeOutside;
}




/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/tooltip/tooltip-anchor.js":
/*!************************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/tooltip/tooltip-anchor.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TooltipAnchor: () => (/* binding */ TooltipAnchor),
/* harmony export */   useTooltipAnchor: () => (/* binding */ useTooltipAnchor)
/* harmony export */ });
/* harmony import */ var _chunks_WVT277Z4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../__chunks/WVT277Z4.js */ "./node_modules/@ariakit/react-core/esm/__chunks/WVT277Z4.js");
/* harmony import */ var _chunks_BVSK4LBK_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../__chunks/BVSK4LBK.js */ "./node_modules/@ariakit/react-core/esm/__chunks/BVSK4LBK.js");
/* harmony import */ var _chunks_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../__chunks/ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
/* harmony import */ var _chunks_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../__chunks/K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
/* harmony import */ var _ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ariakit/core/utils/store */ "./node_modules/@ariakit/core/esm/__chunks/SXKM4CGU.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
"use client";












// src/tooltip/tooltip-anchor.tsx



var TagName = "div";
var globalStore = (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_5__.createStore)({
  activeStore: null
});
function createRemoveStoreCallback(store) {
  return () => {
    const { activeStore } = globalStore.getState();
    if (activeStore !== store) return;
    globalStore.setState("activeStore", null);
  };
}
var useTooltipAnchor = (0,_chunks_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__.createHook)(
  function useTooltipAnchor2({ store, showOnHover = true, ...props }) {
    const context = (0,_chunks_WVT277Z4_js__WEBPACK_IMPORTED_MODULE_0__.useTooltipProviderContext)();
    store = store || context;
    (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__.invariant)(
      store,
       true && "TooltipAnchor must receive a `store` prop or be wrapped in a TooltipProvider component."
    );
    const canShowOnHoverRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(false);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_5__.sync)(store, ["mounted"], (state) => {
        if (state.mounted) return;
        canShowOnHoverRef.current = false;
      });
    }, [store]);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
      if (!store) return;
      return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__.chain)(
        // Immediately remove the current store from the global store when
        // the component unmounts. This is useful, for example, to avoid
        // showing tooltips immediately on serial tests.
        createRemoveStoreCallback(store),
        (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_5__.sync)(store, ["mounted", "skipTimeout"], (state) => {
          if (!store) return;
          if (state.mounted) {
            const { activeStore } = globalStore.getState();
            if (activeStore !== store) {
              activeStore == null ? void 0 : activeStore.hide();
            }
            return globalStore.setState("activeStore", store);
          }
          const id = setTimeout(
            createRemoveStoreCallback(store),
            state.skipTimeout
          );
          return () => clearTimeout(id);
        })
      );
    }, [store]);
    const onMouseEnterProp = props.onMouseEnter;
    const onMouseEnter = (0,_chunks_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useEvent)((event) => {
      onMouseEnterProp == null ? void 0 : onMouseEnterProp(event);
      canShowOnHoverRef.current = true;
    });
    const onFocusVisibleProp = props.onFocusVisible;
    const onFocusVisible = (0,_chunks_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useEvent)((event) => {
      onFocusVisibleProp == null ? void 0 : onFocusVisibleProp(event);
      if (event.defaultPrevented) return;
      store == null ? void 0 : store.setAnchorElement(event.currentTarget);
      store == null ? void 0 : store.show();
    });
    const onBlurProp = props.onBlur;
    const onBlur = (0,_chunks_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_3__.useEvent)((event) => {
      onBlurProp == null ? void 0 : onBlurProp(event);
      if (event.defaultPrevented) return;
      const { activeStore } = globalStore.getState();
      canShowOnHoverRef.current = false;
      if (activeStore === store) {
        globalStore.setState("activeStore", null);
      }
    });
    const type = store.useState("type");
    const contentId = store.useState((state) => {
      var _a;
      return (_a = state.contentElement) == null ? void 0 : _a.id;
    });
    props = {
      "aria-labelledby": type === "label" ? contentId : void 0,
      ...props,
      onMouseEnter,
      onFocusVisible,
      onBlur
    };
    props = (0,_chunks_BVSK4LBK_js__WEBPACK_IMPORTED_MODULE_1__.useHovercardAnchor)({
      store,
      showOnHover(event) {
        if (!canShowOnHoverRef.current) return false;
        if ((0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__.isFalsyBooleanCallback)(showOnHover, event)) return false;
        const { activeStore } = globalStore.getState();
        if (!activeStore) return true;
        store == null ? void 0 : store.show();
        return false;
      },
      ...props
    });
    return props;
  }
);
var TooltipAnchor = (0,_chunks_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function TooltipAnchor2(props) {
  const htmlProps = useTooltipAnchor(props);
  return (0,_chunks_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_2__.createElement)(TagName, htmlProps);
});



/***/ }),

/***/ "./node_modules/@ariakit/react-core/esm/tooltip/tooltip.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@ariakit/react-core/esm/tooltip/tooltip.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Tooltip: () => (/* binding */ Tooltip),
/* harmony export */   useTooltip: () => (/* binding */ useTooltip)
/* harmony export */ });
/* harmony import */ var _chunks_WVT277Z4_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../__chunks/WVT277Z4.js */ "./node_modules/@ariakit/react-core/esm/__chunks/WVT277Z4.js");
/* harmony import */ var _chunks_7QZRSZWP_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../__chunks/7QZRSZWP.js */ "./node_modules/@ariakit/react-core/esm/__chunks/7QZRSZWP.js");
/* harmony import */ var _chunks_2S4Q4M35_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../__chunks/2S4Q4M35.js */ "./node_modules/@ariakit/react-core/esm/__chunks/2S4Q4M35.js");
/* harmony import */ var _chunks_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../__chunks/ILRXHV7V.js */ "./node_modules/@ariakit/react-core/esm/__chunks/ILRXHV7V.js");
/* harmony import */ var _chunks_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../__chunks/K2XTQB3X.js */ "./node_modules/@ariakit/react-core/esm/__chunks/K2XTQB3X.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/@ariakit/core/esm/__chunks/37JWRFYW.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/@ariakit/core/esm/__chunks/XMCVU3LR.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
"use client";










































// src/tooltip/tooltip.tsx



var TagName = "div";
var useTooltip = (0,_chunks_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_3__.createHook)(
  function useTooltip2({
    store,
    portal = true,
    gutter = 8,
    preserveTabOrder = false,
    hideOnHoverOutside = true,
    hideOnInteractOutside = true,
    ...props
  }) {
    const context = (0,_chunks_WVT277Z4_js__WEBPACK_IMPORTED_MODULE_0__.useTooltipProviderContext)();
    store = store || context;
    (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__.invariant)(
      store,
       true && "Tooltip must receive a `store` prop or be wrapped in a TooltipProvider component."
    );
    props = (0,_chunks_K2XTQB3X_js__WEBPACK_IMPORTED_MODULE_4__.useWrapElement)(
      props,
      (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_chunks_WVT277Z4_js__WEBPACK_IMPORTED_MODULE_0__.TooltipScopedContextProvider, { value: store, children: element }),
      [store]
    );
    const role = store.useState(
      (state) => state.type === "description" ? "tooltip" : "none"
    );
    props = { role, ...props };
    props = (0,_chunks_7QZRSZWP_js__WEBPACK_IMPORTED_MODULE_1__.useHovercard)({
      ...props,
      store,
      portal,
      gutter,
      preserveTabOrder,
      hideOnHoverOutside(event) {
        if ((0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__.isFalsyBooleanCallback)(hideOnHoverOutside, event)) return false;
        const anchorElement = store == null ? void 0 : store.getState().anchorElement;
        if (!anchorElement) return true;
        if ("focusVisible" in anchorElement.dataset) return false;
        return true;
      },
      hideOnInteractOutside: (event) => {
        if ((0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__.isFalsyBooleanCallback)(hideOnInteractOutside, event)) return false;
        const anchorElement = store == null ? void 0 : store.getState().anchorElement;
        if (!anchorElement) return true;
        if ((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_5__.contains)(anchorElement, event.target)) return false;
        return true;
      }
    });
    return props;
  }
);
var Tooltip = (0,_chunks_2S4Q4M35_js__WEBPACK_IMPORTED_MODULE_2__.createDialogComponent)(
  (0,_chunks_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_3__.forwardRef)(function Tooltip2(props) {
    const htmlProps = useTooltip(props);
    return (0,_chunks_ILRXHV7V_js__WEBPACK_IMPORTED_MODULE_3__.createElement)(TagName, htmlProps);
  }),
  _chunks_WVT277Z4_js__WEBPACK_IMPORTED_MODULE_0__.useTooltipProviderContext
);



/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/extends.js":
/*!************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/extends.js ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _extends)
/* harmony export */ });
function _extends() {
  return _extends = Object.assign ? Object.assign.bind() : function (n) {
    for (var e = 1; e < arguments.length; e++) {
      var t = arguments[e];
      for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]);
    }
    return n;
  }, _extends.apply(null, arguments);
}


/***/ }),

/***/ "./node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createCache)
/* harmony export */ });
/* harmony import */ var _emotion_sheet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/sheet */ "./node_modules/@emotion/sheet/dist/emotion-sheet.development.esm.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! stylis */ "./node_modules/stylis/src/Enum.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! stylis */ "./node_modules/stylis/src/Utility.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! stylis */ "./node_modules/stylis/src/Parser.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! stylis */ "./node_modules/stylis/src/Tokenizer.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! stylis */ "./node_modules/stylis/src/Serializer.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! stylis */ "./node_modules/stylis/src/Middleware.js");
/* harmony import */ var _emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @emotion/weak-memoize */ "./node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js");
/* harmony import */ var _emotion_memoize__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @emotion/memoize */ "./node_modules/@emotion/memoize/dist/emotion-memoize.esm.js");





var identifierWithPointTracking = function identifierWithPointTracking(begin, points, index) {
  var previous = 0;
  var character = 0;

  while (true) {
    previous = character;
    character = (0,stylis__WEBPACK_IMPORTED_MODULE_4__.peek)(); // &\f

    if (previous === 38 && character === 12) {
      points[index] = 1;
    }

    if ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.token)(character)) {
      break;
    }

    (0,stylis__WEBPACK_IMPORTED_MODULE_4__.next)();
  }

  return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.slice)(begin, stylis__WEBPACK_IMPORTED_MODULE_4__.position);
};

var toRules = function toRules(parsed, points) {
  // pretend we've started with a comma
  var index = -1;
  var character = 44;

  do {
    switch ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.token)(character)) {
      case 0:
        // &\f
        if (character === 38 && (0,stylis__WEBPACK_IMPORTED_MODULE_4__.peek)() === 12) {
          // this is not 100% correct, we don't account for literal sequences here - like for example quoted strings
          // stylis inserts \f after & to know when & where it should replace this sequence with the context selector
          // and when it should just concatenate the outer and inner selectors
          // it's very unlikely for this sequence to actually appear in a different context, so we just leverage this fact here
          points[index] = 1;
        }

        parsed[index] += identifierWithPointTracking(stylis__WEBPACK_IMPORTED_MODULE_4__.position - 1, points, index);
        break;

      case 2:
        parsed[index] += (0,stylis__WEBPACK_IMPORTED_MODULE_4__.delimit)(character);
        break;

      case 4:
        // comma
        if (character === 44) {
          // colon
          parsed[++index] = (0,stylis__WEBPACK_IMPORTED_MODULE_4__.peek)() === 58 ? '&\f' : '';
          points[index] = parsed[index].length;
          break;
        }

      // fallthrough

      default:
        parsed[index] += (0,stylis__WEBPACK_IMPORTED_MODULE_2__.from)(character);
    }
  } while (character = (0,stylis__WEBPACK_IMPORTED_MODULE_4__.next)());

  return parsed;
};

var getRules = function getRules(value, points) {
  return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.dealloc)(toRules((0,stylis__WEBPACK_IMPORTED_MODULE_4__.alloc)(value), points));
}; // WeakSet would be more appropriate, but only WeakMap is supported in IE11


var fixedElements = /* #__PURE__ */new WeakMap();
var compat = function compat(element) {
  if (element.type !== 'rule' || !element.parent || // positive .length indicates that this rule contains pseudo
  // negative .length indicates that this rule has been already prefixed
  element.length < 1) {
    return;
  }

  var value = element.value;
  var parent = element.parent;
  var isImplicitRule = element.column === parent.column && element.line === parent.line;

  while (parent.type !== 'rule') {
    parent = parent.parent;
    if (!parent) return;
  } // short-circuit for the simplest case


  if (element.props.length === 1 && value.charCodeAt(0) !== 58
  /* colon */
  && !fixedElements.get(parent)) {
    return;
  } // if this is an implicitly inserted rule (the one eagerly inserted at the each new nested level)
  // then the props has already been manipulated beforehand as they that array is shared between it and its "rule parent"


  if (isImplicitRule) {
    return;
  }

  fixedElements.set(element, true);
  var points = [];
  var rules = getRules(value, points);
  var parentRules = parent.props;

  for (var i = 0, k = 0; i < rules.length; i++) {
    for (var j = 0; j < parentRules.length; j++, k++) {
      element.props[k] = points[i] ? rules[i].replace(/&\f/g, parentRules[j]) : parentRules[j] + " " + rules[i];
    }
  }
};
var removeLabel = function removeLabel(element) {
  if (element.type === 'decl') {
    var value = element.value;

    if ( // charcode for l
    value.charCodeAt(0) === 108 && // charcode for b
    value.charCodeAt(2) === 98) {
      // this ignores label
      element["return"] = '';
      element.value = '';
    }
  }
};
var ignoreFlag = 'emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason';

var isIgnoringComment = function isIgnoringComment(element) {
  return element.type === 'comm' && element.children.indexOf(ignoreFlag) > -1;
};

var createUnsafeSelectorsAlarm = function createUnsafeSelectorsAlarm(cache) {
  return function (element, index, children) {
    if (element.type !== 'rule' || cache.compat) return;
    var unsafePseudoClasses = element.value.match(/(:first|:nth|:nth-last)-child/g);

    if (unsafePseudoClasses) {
      var isNested = !!element.parent; // in nested rules comments become children of the "auto-inserted" rule and that's always the `element.parent`
      //
      // considering this input:
      // .a {
      //   .b /* comm */ {}
      //   color: hotpink;
      // }
      // we get output corresponding to this:
      // .a {
      //   & {
      //     /* comm */
      //     color: hotpink;
      //   }
      //   .b {}
      // }

      var commentContainer = isNested ? element.parent.children : // global rule at the root level
      children;

      for (var i = commentContainer.length - 1; i >= 0; i--) {
        var node = commentContainer[i];

        if (node.line < element.line) {
          break;
        } // it is quite weird but comments are *usually* put at `column: element.column - 1`
        // so we seek *from the end* for the node that is earlier than the rule's `element` and check that
        // this will also match inputs like this:
        // .a {
        //   /* comm */
        //   .b {}
        // }
        //
        // but that is fine
        //
        // it would be the easiest to change the placement of the comment to be the first child of the rule:
        // .a {
        //   .b { /* comm */ }
        // }
        // with such inputs we wouldn't have to search for the comment at all
        // TODO: consider changing this comment placement in the next major version


        if (node.column < element.column) {
          if (isIgnoringComment(node)) {
            return;
          }

          break;
        }
      }

      unsafePseudoClasses.forEach(function (unsafePseudoClass) {
        console.error("The pseudo class \"" + unsafePseudoClass + "\" is potentially unsafe when doing server-side rendering. Try changing it to \"" + unsafePseudoClass.split('-child')[0] + "-of-type\".");
      });
    }
  };
};

var isImportRule = function isImportRule(element) {
  return element.type.charCodeAt(1) === 105 && element.type.charCodeAt(0) === 64;
};

var isPrependedWithRegularRules = function isPrependedWithRegularRules(index, children) {
  for (var i = index - 1; i >= 0; i--) {
    if (!isImportRule(children[i])) {
      return true;
    }
  }

  return false;
}; // use this to remove incorrect elements from further processing
// so they don't get handed to the `sheet` (or anything else)
// as that could potentially lead to additional logs which in turn could be overhelming to the user


var nullifyElement = function nullifyElement(element) {
  element.type = '';
  element.value = '';
  element["return"] = '';
  element.children = '';
  element.props = '';
};

var incorrectImportAlarm = function incorrectImportAlarm(element, index, children) {
  if (!isImportRule(element)) {
    return;
  }

  if (element.parent) {
    console.error("`@import` rules can't be nested inside other rules. Please move it to the top level and put it before regular rules. Keep in mind that they can only be used within global styles.");
    nullifyElement(element);
  } else if (isPrependedWithRegularRules(index, children)) {
    console.error("`@import` rules can't be after other rules. Please put your `@import` rules before your other rules.");
    nullifyElement(element);
  }
};

/* eslint-disable no-fallthrough */

function prefix(value, length) {
  switch ((0,stylis__WEBPACK_IMPORTED_MODULE_2__.hash)(value, length)) {
    // color-adjust
    case 5103:
      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + 'print-' + value + value;
    // animation, animation-(delay|direction|duration|fill-mode|iteration-count|name|play-state|timing-function)

    case 5737:
    case 4201:
    case 3177:
    case 3433:
    case 1641:
    case 4457:
    case 2921: // text-decoration, filter, clip-path, backface-visibility, column, box-decoration-break

    case 5572:
    case 6356:
    case 5844:
    case 3191:
    case 6645:
    case 3005: // mask, mask-image, mask-(mode|clip|size), mask-(repeat|origin), mask-position, mask-composite,

    case 6391:
    case 5879:
    case 5623:
    case 6135:
    case 4599:
    case 4855: // background-clip, columns, column-(count|fill|gap|rule|rule-color|rule-style|rule-width|span|width)

    case 4215:
    case 6389:
    case 5109:
    case 5365:
    case 5621:
    case 3829:
      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + value;
    // appearance, user-select, transform, hyphens, text-size-adjust

    case 5349:
    case 4246:
    case 4810:
    case 6968:
    case 2756:
      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MOZ + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + value + value;
    // flex, flex-direction

    case 6828:
    case 4268:
      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + value + value;
    // order

    case 6165:
      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + 'flex-' + value + value;
    // align-items

    case 5187:
      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /(\w+).+(:[^]+)/, stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + 'box-$1$2' + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + 'flex-$1$2') + value;
    // align-self

    case 5443:
      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + 'flex-item-' + (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /flex-|-self/, '') + value;
    // align-content

    case 4675:
      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + 'flex-line-pack' + (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /align-content|flex-|-self/, '') + value;
    // flex-shrink

    case 5548:
      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, 'shrink', 'negative') + value;
    // flex-basis

    case 5292:
      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, 'basis', 'preferred-size') + value;
    // flex-grow

    case 6060:
      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + 'box-' + (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, '-grow', '') + stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, 'grow', 'positive') + value;
    // transition

    case 4554:
      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /([^-])(transform)/g, '$1' + stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + '$2') + value;
    // cursor

    case 6187:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)((0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)((0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /(zoom-|grab)/, stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + '$1'), /(image-set)/, stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + '$1'), value, '') + value;
    // background, background-image

    case 5495:
    case 3959:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /(image-set\([^]*)/, stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + '$1' + '$`$1');
    // justify-content

    case 4968:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)((0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /(.+:)(flex-)?(.*)/, stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + 'box-pack:$3' + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + 'flex-pack:$3'), /s.+-b[^;]+/, 'justify') + stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + value;
    // (margin|padding)-inline-(start|end)

    case 4095:
    case 3583:
    case 4068:
    case 2532:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /(.+)-inline(.+)/, stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + '$1$2') + value;
    // (min|max)?(width|height|inline-size|block-size)

    case 8116:
    case 7059:
    case 5753:
    case 5535:
    case 5445:
    case 5701:
    case 4933:
    case 4677:
    case 5533:
    case 5789:
    case 5021:
    case 4765:
      // stretch, max-content, min-content, fill-available
      if ((0,stylis__WEBPACK_IMPORTED_MODULE_2__.strlen)(value) - 1 - length > 6) switch ((0,stylis__WEBPACK_IMPORTED_MODULE_2__.charat)(value, length + 1)) {
        // (m)ax-content, (m)in-content
        case 109:
          // -
          if ((0,stylis__WEBPACK_IMPORTED_MODULE_2__.charat)(value, length + 4) !== 45) break;
        // (f)ill-available, (f)it-content

        case 102:
          return (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /(.+:)(.+)-([^]+)/, '$1' + stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + '$2-$3' + '$1' + stylis__WEBPACK_IMPORTED_MODULE_1__.MOZ + ((0,stylis__WEBPACK_IMPORTED_MODULE_2__.charat)(value, length + 3) == 108 ? '$3' : '$2-$3')) + value;
        // (s)tretch

        case 115:
          return ~(0,stylis__WEBPACK_IMPORTED_MODULE_2__.indexof)(value, 'stretch') ? prefix((0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, 'stretch', 'fill-available'), length) + value : value;
      }
      break;
    // position: sticky

    case 4949:
      // (s)ticky?
      if ((0,stylis__WEBPACK_IMPORTED_MODULE_2__.charat)(value, length + 1) !== 115) break;
    // display: (flex|inline-flex)

    case 6444:
      switch ((0,stylis__WEBPACK_IMPORTED_MODULE_2__.charat)(value, (0,stylis__WEBPACK_IMPORTED_MODULE_2__.strlen)(value) - 3 - (~(0,stylis__WEBPACK_IMPORTED_MODULE_2__.indexof)(value, '!important') && 10))) {
        // stic(k)y
        case 107:
          return (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, ':', ':' + stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT) + value;
        // (inline-)?fl(e)x

        case 101:
          return (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /(.+:)([^;!]+)(;|!.+)?/, '$1' + stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + ((0,stylis__WEBPACK_IMPORTED_MODULE_2__.charat)(value, 14) === 45 ? 'inline-' : '') + 'box$3' + '$1' + stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + '$2$3' + '$1' + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + '$2box$3') + value;
      }

      break;
    // writing-mode

    case 5936:
      switch ((0,stylis__WEBPACK_IMPORTED_MODULE_2__.charat)(value, length + 11)) {
        // vertical-l(r)
        case 114:
          return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /[svh]\w+-[tblr]{2}/, 'tb') + value;
        // vertical-r(l)

        case 108:
          return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /[svh]\w+-[tblr]{2}/, 'tb-rl') + value;
        // horizontal(-)tb

        case 45:
          return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /[svh]\w+-[tblr]{2}/, 'lr') + value;
      }

      return stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_1__.MS + value + value;
  }

  return value;
}

var prefixer = function prefixer(element, index, children, callback) {
  if (element.length > -1) if (!element["return"]) switch (element.type) {
    case stylis__WEBPACK_IMPORTED_MODULE_1__.DECLARATION:
      element["return"] = prefix(element.value, element.length);
      break;

    case stylis__WEBPACK_IMPORTED_MODULE_1__.KEYFRAMES:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_5__.serialize)([(0,stylis__WEBPACK_IMPORTED_MODULE_4__.copy)(element, {
        value: (0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(element.value, '@', '@' + stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT)
      })], callback);

    case stylis__WEBPACK_IMPORTED_MODULE_1__.RULESET:
      if (element.length) return (0,stylis__WEBPACK_IMPORTED_MODULE_2__.combine)(element.props, function (value) {
        switch ((0,stylis__WEBPACK_IMPORTED_MODULE_2__.match)(value, /(::plac\w+|:read-\w+)/)) {
          // :read-(only|write)
          case ':read-only':
          case ':read-write':
            return (0,stylis__WEBPACK_IMPORTED_MODULE_5__.serialize)([(0,stylis__WEBPACK_IMPORTED_MODULE_4__.copy)(element, {
              props: [(0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /:(read-\w+)/, ':' + stylis__WEBPACK_IMPORTED_MODULE_1__.MOZ + '$1')]
            })], callback);
          // :placeholder

          case '::placeholder':
            return (0,stylis__WEBPACK_IMPORTED_MODULE_5__.serialize)([(0,stylis__WEBPACK_IMPORTED_MODULE_4__.copy)(element, {
              props: [(0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /:(plac\w+)/, ':' + stylis__WEBPACK_IMPORTED_MODULE_1__.WEBKIT + 'input-$1')]
            }), (0,stylis__WEBPACK_IMPORTED_MODULE_4__.copy)(element, {
              props: [(0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /:(plac\w+)/, ':' + stylis__WEBPACK_IMPORTED_MODULE_1__.MOZ + '$1')]
            }), (0,stylis__WEBPACK_IMPORTED_MODULE_4__.copy)(element, {
              props: [(0,stylis__WEBPACK_IMPORTED_MODULE_2__.replace)(value, /:(plac\w+)/, stylis__WEBPACK_IMPORTED_MODULE_1__.MS + 'input-$1')]
            })], callback);
        }

        return '';
      });
  }
};

var defaultStylisPlugins = [prefixer];
var getSourceMap;

{
  var sourceMapPattern = /\/\*#\ssourceMappingURL=data:application\/json;\S+\s+\*\//g;

  getSourceMap = function getSourceMap(styles) {
    var matches = styles.match(sourceMapPattern);
    if (!matches) return;
    return matches[matches.length - 1];
  };
}

var createCache = function createCache(options) {
  var key = options.key;

  if (!key) {
    throw new Error("You have to configure `key` for your cache. Please make sure it's unique (and not equal to 'css') as it's used for linking styles to your cache.\n" + "If multiple caches share the same key they might \"fight\" for each other's style elements.");
  }

  if (key === 'css') {
    var ssrStyles = document.querySelectorAll("style[data-emotion]:not([data-s])"); // get SSRed styles out of the way of React's hydration
    // document.head is a safe place to move them to(though note document.head is not necessarily the last place they will be)
    // note this very very intentionally targets all style elements regardless of the key to ensure
    // that creating a cache works inside of render of a React component

    Array.prototype.forEach.call(ssrStyles, function (node) {
      // we want to only move elements which have a space in the data-emotion attribute value
      // because that indicates that it is an Emotion 11 server-side rendered style elements
      // while we will already ignore Emotion 11 client-side inserted styles because of the :not([data-s]) part in the selector
      // Emotion 10 client-side inserted styles did not have data-s (but importantly did not have a space in their data-emotion attributes)
      // so checking for the space ensures that loading Emotion 11 after Emotion 10 has inserted some styles
      // will not result in the Emotion 10 styles being destroyed
      var dataEmotionAttribute = node.getAttribute('data-emotion');

      if (dataEmotionAttribute.indexOf(' ') === -1) {
        return;
      }

      document.head.appendChild(node);
      node.setAttribute('data-s', '');
    });
  }

  var stylisPlugins = options.stylisPlugins || defaultStylisPlugins;

  {
    if (/[^a-z-]/.test(key)) {
      throw new Error("Emotion key must only contain lower case alphabetical characters and - but \"" + key + "\" was passed");
    }
  }

  var inserted = {};
  var container;
  var nodesToHydrate = [];

  {
    container = options.container || document.head;
    Array.prototype.forEach.call( // this means we will ignore elements which don't have a space in them which
    // means that the style elements we're looking at are only Emotion 11 server-rendered style elements
    document.querySelectorAll("style[data-emotion^=\"" + key + " \"]"), function (node) {
      var attrib = node.getAttribute("data-emotion").split(' ');

      for (var i = 1; i < attrib.length; i++) {
        inserted[attrib[i]] = true;
      }

      nodesToHydrate.push(node);
    });
  }

  var _insert;

  var omnipresentPlugins = [compat, removeLabel];

  {
    omnipresentPlugins.push(createUnsafeSelectorsAlarm({
      get compat() {
        return cache.compat;
      }

    }), incorrectImportAlarm);
  }

  {
    var currentSheet;
    var finalizingPlugins = [stylis__WEBPACK_IMPORTED_MODULE_5__.stringify, function (element) {
      if (!element.root) {
        if (element["return"]) {
          currentSheet.insert(element["return"]);
        } else if (element.value && element.type !== stylis__WEBPACK_IMPORTED_MODULE_1__.COMMENT) {
          // insert empty rule in non-production environments
          // so @emotion/jest can grab `key` from the (JS)DOM for caches without any rules inserted yet
          currentSheet.insert(element.value + "{}");
        }
      }
    } ];
    var serializer = (0,stylis__WEBPACK_IMPORTED_MODULE_6__.middleware)(omnipresentPlugins.concat(stylisPlugins, finalizingPlugins));

    var stylis = function stylis(styles) {
      return (0,stylis__WEBPACK_IMPORTED_MODULE_5__.serialize)((0,stylis__WEBPACK_IMPORTED_MODULE_3__.compile)(styles), serializer);
    };

    _insert = function insert(selector, serialized, sheet, shouldCache) {
      currentSheet = sheet;

      if (getSourceMap) {
        var sourceMap = getSourceMap(serialized.styles);

        if (sourceMap) {
          currentSheet = {
            insert: function insert(rule) {
              sheet.insert(rule + sourceMap);
            }
          };
        }
      }

      stylis(selector ? selector + "{" + serialized.styles + "}" : serialized.styles);

      if (shouldCache) {
        cache.inserted[serialized.name] = true;
      }
    };
  }

  var cache = {
    key: key,
    sheet: new _emotion_sheet__WEBPACK_IMPORTED_MODULE_0__.StyleSheet({
      key: key,
      container: container,
      nonce: options.nonce,
      speedy: options.speedy,
      prepend: options.prepend,
      insertionPoint: options.insertionPoint
    }),
    nonce: options.nonce,
    inserted: inserted,
    registered: {},
    insert: _insert
  };
  cache.sheet.hydrate(nodesToHydrate);
  return cache;
};




/***/ }),

/***/ "./node_modules/@emotion/css/create-instance/dist/emotion-css-create-instance.development.esm.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@emotion/css/create-instance/dist/emotion-css-create-instance.development.esm.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createEmotion)
/* harmony export */ });
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/cache */ "./node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js");
/* harmony import */ var _emotion_serialize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/serialize */ "./node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js");
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");




function insertWithoutScoping(cache, serialized) {
  if (cache.inserted[serialized.name] === undefined) {
    return cache.insert('', serialized, cache.sheet, true);
  }
}

function merge(registered, css, className) {
  var registeredStyles = [];
  var rawClassName = (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.getRegisteredStyles)(registered, registeredStyles, className);

  if (registeredStyles.length < 2) {
    return className;
  }

  return rawClassName + css(registeredStyles);
}

var createEmotion = function createEmotion(options) {
  var cache = (0,_emotion_cache__WEBPACK_IMPORTED_MODULE_0__["default"])(options);

  cache.sheet.speedy = function (value) {
    if (this.ctr !== 0) {
      throw new Error('speedy must be changed before any rules are inserted');
    }

    this.isSpeedy = value;
  };

  cache.compat = true;

  var css = function css() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_1__.serializeStyles)(args, cache.registered, undefined);
    (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.insertStyles)(cache, serialized, false);
    return cache.key + "-" + serialized.name;
  };

  var keyframes = function keyframes() {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_1__.serializeStyles)(args, cache.registered);
    var animation = "animation-" + serialized.name;
    insertWithoutScoping(cache, {
      name: serialized.name,
      styles: "@keyframes " + animation + "{" + serialized.styles + "}"
    });
    return animation;
  };

  var injectGlobal = function injectGlobal() {
    for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_1__.serializeStyles)(args, cache.registered);
    insertWithoutScoping(cache, serialized);
  };

  var cx = function cx() {
    for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    return merge(cache.registered, css, classnames(args));
  };

  return {
    css: css,
    cx: cx,
    injectGlobal: injectGlobal,
    keyframes: keyframes,
    hydrate: function hydrate(ids) {
      ids.forEach(function (key) {
        cache.inserted[key] = true;
      });
    },
    flush: function flush() {
      cache.registered = {};
      cache.inserted = {};
      cache.sheet.flush();
    },
    sheet: cache.sheet,
    cache: cache,
    getRegisteredStyles: _emotion_utils__WEBPACK_IMPORTED_MODULE_2__.getRegisteredStyles.bind(null, cache.registered),
    merge: merge.bind(null, cache.registered, css)
  };
};

var classnames = function classnames(args) {
  var cls = '';

  for (var i = 0; i < args.length; i++) {
    var arg = args[i];
    if (arg == null) continue;
    var toAdd = void 0;

    switch (typeof arg) {
      case 'boolean':
        break;

      case 'object':
        {
          if (Array.isArray(arg)) {
            toAdd = classnames(arg);
          } else {
            toAdd = '';

            for (var k in arg) {
              if (arg[k] && k) {
                toAdd && (toAdd += ' ');
                toAdd += k;
              }
            }
          }

          break;
        }

      default:
        {
          toAdd = arg;
        }
    }

    if (toAdd) {
      cls && (cls += ' ');
      cls += toAdd;
    }
  }

  return cls;
};




/***/ }),

/***/ "./node_modules/@emotion/css/dist/emotion-css.development.esm.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@emotion/css/dist/emotion-css.development.esm.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cache: () => (/* binding */ cache),
/* harmony export */   css: () => (/* binding */ css),
/* harmony export */   cx: () => (/* binding */ cx),
/* harmony export */   flush: () => (/* binding */ flush),
/* harmony export */   getRegisteredStyles: () => (/* binding */ getRegisteredStyles),
/* harmony export */   hydrate: () => (/* binding */ hydrate),
/* harmony export */   injectGlobal: () => (/* binding */ injectGlobal),
/* harmony export */   keyframes: () => (/* binding */ keyframes),
/* harmony export */   merge: () => (/* binding */ merge),
/* harmony export */   sheet: () => (/* binding */ sheet)
/* harmony export */ });
/* harmony import */ var _create_instance_dist_emotion_css_create_instance_development_esm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../create-instance/dist/emotion-css-create-instance.development.esm.js */ "./node_modules/@emotion/css/create-instance/dist/emotion-css-create-instance.development.esm.js");
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/cache */ "./node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js");
/* harmony import */ var _emotion_serialize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/serialize */ "./node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js");
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");





var _createEmotion = (0,_create_instance_dist_emotion_css_create_instance_development_esm_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
  key: 'css'
}),
    flush = _createEmotion.flush,
    hydrate = _createEmotion.hydrate,
    cx = _createEmotion.cx,
    merge = _createEmotion.merge,
    getRegisteredStyles = _createEmotion.getRegisteredStyles,
    injectGlobal = _createEmotion.injectGlobal,
    keyframes = _createEmotion.keyframes,
    css = _createEmotion.css,
    sheet = _createEmotion.sheet,
    cache = _createEmotion.cache;




/***/ }),

/***/ "./node_modules/@emotion/hash/dist/emotion-hash.esm.js":
/*!*************************************************************!*\
  !*** ./node_modules/@emotion/hash/dist/emotion-hash.esm.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ murmur2)
/* harmony export */ });
/* eslint-disable */
// Inspired by https://github.com/garycourt/murmurhash-js
// Ported from https://github.com/aappleby/smhasher/blob/61a0530f28277f2e850bfc39600ce61d02b518de/src/MurmurHash2.cpp#L37-L86
function murmur2(str) {
  // 'm' and 'r' are mixing constants generated offline.
  // They're not really 'magic', they just happen to work well.
  // const m = 0x5bd1e995;
  // const r = 24;
  // Initialize the hash
  var h = 0; // Mix 4 bytes at a time into the hash

  var k,
      i = 0,
      len = str.length;

  for (; len >= 4; ++i, len -= 4) {
    k = str.charCodeAt(i) & 0xff | (str.charCodeAt(++i) & 0xff) << 8 | (str.charCodeAt(++i) & 0xff) << 16 | (str.charCodeAt(++i) & 0xff) << 24;
    k =
    /* Math.imul(k, m): */
    (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16);
    k ^=
    /* k >>> r: */
    k >>> 24;
    h =
    /* Math.imul(k, m): */
    (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16) ^
    /* Math.imul(h, m): */
    (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  } // Handle the last few bytes of the input array


  switch (len) {
    case 3:
      h ^= (str.charCodeAt(i + 2) & 0xff) << 16;

    case 2:
      h ^= (str.charCodeAt(i + 1) & 0xff) << 8;

    case 1:
      h ^= str.charCodeAt(i) & 0xff;
      h =
      /* Math.imul(h, m): */
      (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  } // Do a few final mixes of the hash to ensure the last few
  // bytes are well-incorporated.


  h ^= h >>> 13;
  h =
  /* Math.imul(h, m): */
  (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  return ((h ^ h >>> 15) >>> 0).toString(36);
}




/***/ }),

/***/ "./node_modules/@emotion/is-prop-valid/dist/emotion-is-prop-valid.esm.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@emotion/is-prop-valid/dist/emotion-is-prop-valid.esm.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isPropValid)
/* harmony export */ });
/* harmony import */ var _emotion_memoize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/memoize */ "./node_modules/@emotion/memoize/dist/emotion-memoize.esm.js");


// eslint-disable-next-line no-undef
var reactPropsRegex = /^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|abbr|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|decoding|default|defer|dir|disabled|disablePictureInPicture|disableRemotePlayback|download|draggable|encType|enterKeyHint|fetchpriority|fetchPriority|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loading|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|popover|popoverTarget|popoverTargetAction|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|translate|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|incremental|fallback|inert|itemProp|itemScope|itemType|itemID|itemRef|on|option|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/; // https://esbench.com/bench/5bfee68a4cd7e6009ef61d23

var isPropValid = /* #__PURE__ */(0,_emotion_memoize__WEBPACK_IMPORTED_MODULE_0__["default"])(function (prop) {
  return reactPropsRegex.test(prop) || prop.charCodeAt(0) === 111
  /* o */
  && prop.charCodeAt(1) === 110
  /* n */
  && prop.charCodeAt(2) < 91;
}
/* Z+1 */
);




/***/ }),

/***/ "./node_modules/@emotion/memoize/dist/emotion-memoize.esm.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@emotion/memoize/dist/emotion-memoize.esm.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ memoize)
/* harmony export */ });
function memoize(fn) {
  var cache = Object.create(null);
  return function (arg) {
    if (cache[arg] === undefined) cache[arg] = fn(arg);
    return cache[arg];
  };
}




/***/ }),

/***/ "./node_modules/@emotion/react/_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.esm.js":
/*!*****************************************************************************************************************!*\
  !*** ./node_modules/@emotion/react/_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.esm.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ hoistNonReactStatics)
/* harmony export */ });
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! hoist-non-react-statics */ "./node_modules/hoist-non-react-statics/dist/hoist-non-react-statics.cjs.js");
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_0__);


// this file isolates this package that is not tree-shakeable
// and if this module doesn't actually contain any logic of its own
// then Rollup just use 'hoist-non-react-statics' directly in other chunks

var hoistNonReactStatics = (function (targetComponent, sourceComponent) {
  return hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_0___default()(targetComponent, sourceComponent);
});




/***/ }),

/***/ "./node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: () => (/* binding */ CacheProvider),
/* harmony export */   E: () => (/* binding */ Emotion$1),
/* harmony export */   T: () => (/* binding */ ThemeContext),
/* harmony export */   _: () => (/* binding */ __unsafe_useEmotionCache),
/* harmony export */   a: () => (/* binding */ ThemeProvider),
/* harmony export */   b: () => (/* binding */ withTheme),
/* harmony export */   c: () => (/* binding */ createEmotionProps),
/* harmony export */   h: () => (/* binding */ hasOwn),
/* harmony export */   u: () => (/* binding */ useTheme),
/* harmony export */   w: () => (/* binding */ withEmotionCache)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/cache */ "./node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js");
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/weak-memoize */ "./node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js");
/* harmony import */ var _isolated_hnrs_dist_emotion_react_isolated_hnrs_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.esm.js */ "./node_modules/@emotion/react/_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.esm.js");
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");
/* harmony import */ var _emotion_serialize__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @emotion/serialize */ "./node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js");
/* harmony import */ var _emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @emotion/use-insertion-effect-with-fallbacks */ "./node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js");










var EmotionCacheContext = /* #__PURE__ */react__WEBPACK_IMPORTED_MODULE_0__.createContext( // we're doing this to avoid preconstruct's dead code elimination in this one case
// because this module is primarily intended for the browser and node
// but it's also required in react native and similar environments sometimes
// and we could have a special build just for that
// but this is much easier and the native packages
// might use a different theme context in the future anyway
typeof HTMLElement !== 'undefined' ? /* #__PURE__ */(0,_emotion_cache__WEBPACK_IMPORTED_MODULE_1__["default"])({
  key: 'css'
}) : null);

{
  EmotionCacheContext.displayName = 'EmotionCacheContext';
}

var CacheProvider = EmotionCacheContext.Provider;
var __unsafe_useEmotionCache = function useEmotionCache() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(EmotionCacheContext);
};

var withEmotionCache = function withEmotionCache(func) {
  return /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function (props, ref) {
    // the cache will never be null in the browser
    var cache = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(EmotionCacheContext);
    return func(props, cache, ref);
  });
};

var ThemeContext = /* #__PURE__ */react__WEBPACK_IMPORTED_MODULE_0__.createContext({});

{
  ThemeContext.displayName = 'EmotionThemeContext';
}

var useTheme = function useTheme() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(ThemeContext);
};

var getTheme = function getTheme(outerTheme, theme) {
  if (typeof theme === 'function') {
    var mergedTheme = theme(outerTheme);

    if ((mergedTheme == null || typeof mergedTheme !== 'object' || Array.isArray(mergedTheme))) {
      throw new Error('[ThemeProvider] Please return an object from your theme function, i.e. theme={() => ({})}!');
    }

    return mergedTheme;
  }

  if ((theme == null || typeof theme !== 'object' || Array.isArray(theme))) {
    throw new Error('[ThemeProvider] Please make your theme prop a plain object');
  }

  return (0,_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_2__["default"])({}, outerTheme, theme);
};

var createCacheWithTheme = /* #__PURE__ */(0,_emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_3__["default"])(function (outerTheme) {
  return (0,_emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_3__["default"])(function (theme) {
    return getTheme(outerTheme, theme);
  });
});
var ThemeProvider = function ThemeProvider(props) {
  var theme = react__WEBPACK_IMPORTED_MODULE_0__.useContext(ThemeContext);

  if (props.theme !== theme) {
    theme = createCacheWithTheme(theme)(props.theme);
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(ThemeContext.Provider, {
    value: theme
  }, props.children);
};
function withTheme(Component) {
  var componentName = Component.displayName || Component.name || 'Component';
  var WithTheme = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function render(props, ref) {
    var theme = react__WEBPACK_IMPORTED_MODULE_0__.useContext(ThemeContext);
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, (0,_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_2__["default"])({
      theme: theme,
      ref: ref
    }, props));
  });
  WithTheme.displayName = "WithTheme(" + componentName + ")";
  return (0,_isolated_hnrs_dist_emotion_react_isolated_hnrs_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_4__["default"])(WithTheme, Component);
}

var hasOwn = {}.hasOwnProperty;

var getLastPart = function getLastPart(functionName) {
  // The match may be something like 'Object.createEmotionProps' or
  // 'Loader.prototype.render'
  var parts = functionName.split('.');
  return parts[parts.length - 1];
};

var getFunctionNameFromStackTraceLine = function getFunctionNameFromStackTraceLine(line) {
  // V8
  var match = /^\s+at\s+([A-Za-z0-9$.]+)\s/.exec(line);
  if (match) return getLastPart(match[1]); // Safari / Firefox

  match = /^([A-Za-z0-9$.]+)@/.exec(line);
  if (match) return getLastPart(match[1]);
  return undefined;
};

var internalReactFunctionNames = /* #__PURE__ */new Set(['renderWithHooks', 'processChild', 'finishClassComponent', 'renderToString']); // These identifiers come from error stacks, so they have to be valid JS
// identifiers, thus we only need to replace what is a valid character for JS,
// but not for CSS.

var sanitizeIdentifier = function sanitizeIdentifier(identifier) {
  return identifier.replace(/\$/g, '-');
};

var getLabelFromStackTrace = function getLabelFromStackTrace(stackTrace) {
  if (!stackTrace) return undefined;
  var lines = stackTrace.split('\n');

  for (var i = 0; i < lines.length; i++) {
    var functionName = getFunctionNameFromStackTraceLine(lines[i]); // The first line of V8 stack traces is just "Error"

    if (!functionName) continue; // If we reach one of these, we have gone too far and should quit

    if (internalReactFunctionNames.has(functionName)) break; // The component name is the first function in the stack that starts with an
    // uppercase letter

    if (/^[A-Z]/.test(functionName)) return sanitizeIdentifier(functionName);
  }

  return undefined;
};

var typePropName = '__EMOTION_TYPE_PLEASE_DO_NOT_USE__';
var labelPropName = '__EMOTION_LABEL_PLEASE_DO_NOT_USE__';
var createEmotionProps = function createEmotionProps(type, props) {
  if (typeof props.css === 'string' && // check if there is a css declaration
  props.css.indexOf(':') !== -1) {
    throw new Error("Strings are not allowed as css prop values, please wrap it in a css template literal from '@emotion/react' like this: css`" + props.css + "`");
  }

  var newProps = {};

  for (var _key in props) {
    if (hasOwn.call(props, _key)) {
      newProps[_key] = props[_key];
    }
  }

  newProps[typePropName] = type; // Runtime labeling is an opt-in feature because:
  // - It causes hydration warnings when using Safari and SSR
  // - It can degrade performance if there are a huge number of elements
  //
  // Even if the flag is set, we still don't compute the label if it has already
  // been determined by the Babel plugin.

  if (typeof globalThis !== 'undefined' && !!globalThis.EMOTION_RUNTIME_AUTO_LABEL && !!props.css && (typeof props.css !== 'object' || !('name' in props.css) || typeof props.css.name !== 'string' || props.css.name.indexOf('-') === -1)) {
    var label = getLabelFromStackTrace(new Error().stack);
    if (label) newProps[labelPropName] = label;
  }

  return newProps;
};

var Insertion = function Insertion(_ref) {
  var cache = _ref.cache,
      serialized = _ref.serialized,
      isStringTag = _ref.isStringTag;
  (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_5__.registerStyles)(cache, serialized, isStringTag);
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_7__.useInsertionEffectAlwaysWithSyncFallback)(function () {
    return (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_5__.insertStyles)(cache, serialized, isStringTag);
  });

  return null;
};

var Emotion = /* #__PURE__ */withEmotionCache(function (props, cache, ref) {
  var cssProp = props.css; // so that using `css` from `emotion` and passing the result to the css prop works
  // not passing the registered cache to serializeStyles because it would
  // make certain babel optimisations not possible

  if (typeof cssProp === 'string' && cache.registered[cssProp] !== undefined) {
    cssProp = cache.registered[cssProp];
  }

  var WrappedComponent = props[typePropName];
  var registeredStyles = [cssProp];
  var className = '';

  if (typeof props.className === 'string') {
    className = (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_5__.getRegisteredStyles)(cache.registered, registeredStyles, props.className);
  } else if (props.className != null) {
    className = props.className + " ";
  }

  var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_6__.serializeStyles)(registeredStyles, undefined, react__WEBPACK_IMPORTED_MODULE_0__.useContext(ThemeContext));

  if (serialized.name.indexOf('-') === -1) {
    var labelFromStack = props[labelPropName];

    if (labelFromStack) {
      serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_6__.serializeStyles)([serialized, 'label:' + labelFromStack + ';']);
    }
  }

  className += cache.key + "-" + serialized.name;
  var newProps = {};

  for (var _key2 in props) {
    if (hasOwn.call(props, _key2) && _key2 !== 'css' && _key2 !== typePropName && (_key2 !== labelPropName)) {
      newProps[_key2] = props[_key2];
    }
  }

  newProps.className = className;

  if (ref) {
    newProps.ref = ref;
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Insertion, {
    cache: cache,
    serialized: serialized,
    isStringTag: typeof WrappedComponent === 'string'
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(WrappedComponent, newProps));
});

{
  Emotion.displayName = 'EmotionCssPropInternal';
}

var Emotion$1 = Emotion;




/***/ }),

/***/ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CacheProvider: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.C),
/* harmony export */   ClassNames: () => (/* binding */ ClassNames),
/* harmony export */   Global: () => (/* binding */ Global),
/* harmony export */   ThemeContext: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.T),
/* harmony export */   ThemeProvider: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.a),
/* harmony export */   __unsafe_useEmotionCache: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__._),
/* harmony export */   createElement: () => (/* binding */ jsx),
/* harmony export */   css: () => (/* binding */ css),
/* harmony export */   jsx: () => (/* binding */ jsx),
/* harmony export */   keyframes: () => (/* binding */ keyframes),
/* harmony export */   useTheme: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.u),
/* harmony export */   withEmotionCache: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.w),
/* harmony export */   withTheme: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.b)
/* harmony export */ });
/* harmony import */ var _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./emotion-element-489459f2.browser.development.esm.js */ "./node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");
/* harmony import */ var _emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/use-insertion-effect-with-fallbacks */ "./node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js");
/* harmony import */ var _emotion_serialize__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @emotion/serialize */ "./node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js");
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @emotion/cache */ "./node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @emotion/weak-memoize */ "./node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js");
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! hoist-non-react-statics */ "./node_modules/hoist-non-react-statics/dist/hoist-non-react-statics.cjs.js");
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_8__);












var isDevelopment = true;

var pkg = {
	name: "@emotion/react",
	version: "11.14.0",
	main: "dist/emotion-react.cjs.js",
	module: "dist/emotion-react.esm.js",
	types: "dist/emotion-react.cjs.d.ts",
	exports: {
		".": {
			types: {
				"import": "./dist/emotion-react.cjs.mjs",
				"default": "./dist/emotion-react.cjs.js"
			},
			development: {
				"edge-light": {
					module: "./dist/emotion-react.development.edge-light.esm.js",
					"import": "./dist/emotion-react.development.edge-light.cjs.mjs",
					"default": "./dist/emotion-react.development.edge-light.cjs.js"
				},
				worker: {
					module: "./dist/emotion-react.development.edge-light.esm.js",
					"import": "./dist/emotion-react.development.edge-light.cjs.mjs",
					"default": "./dist/emotion-react.development.edge-light.cjs.js"
				},
				workerd: {
					module: "./dist/emotion-react.development.edge-light.esm.js",
					"import": "./dist/emotion-react.development.edge-light.cjs.mjs",
					"default": "./dist/emotion-react.development.edge-light.cjs.js"
				},
				browser: {
					module: "./dist/emotion-react.browser.development.esm.js",
					"import": "./dist/emotion-react.browser.development.cjs.mjs",
					"default": "./dist/emotion-react.browser.development.cjs.js"
				},
				module: "./dist/emotion-react.development.esm.js",
				"import": "./dist/emotion-react.development.cjs.mjs",
				"default": "./dist/emotion-react.development.cjs.js"
			},
			"edge-light": {
				module: "./dist/emotion-react.edge-light.esm.js",
				"import": "./dist/emotion-react.edge-light.cjs.mjs",
				"default": "./dist/emotion-react.edge-light.cjs.js"
			},
			worker: {
				module: "./dist/emotion-react.edge-light.esm.js",
				"import": "./dist/emotion-react.edge-light.cjs.mjs",
				"default": "./dist/emotion-react.edge-light.cjs.js"
			},
			workerd: {
				module: "./dist/emotion-react.edge-light.esm.js",
				"import": "./dist/emotion-react.edge-light.cjs.mjs",
				"default": "./dist/emotion-react.edge-light.cjs.js"
			},
			browser: {
				module: "./dist/emotion-react.browser.esm.js",
				"import": "./dist/emotion-react.browser.cjs.mjs",
				"default": "./dist/emotion-react.browser.cjs.js"
			},
			module: "./dist/emotion-react.esm.js",
			"import": "./dist/emotion-react.cjs.mjs",
			"default": "./dist/emotion-react.cjs.js"
		},
		"./jsx-runtime": {
			types: {
				"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.mjs",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.js"
			},
			development: {
				"edge-light": {
					module: "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.esm.js",
					"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.cjs.mjs",
					"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.cjs.js"
				},
				worker: {
					module: "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.esm.js",
					"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.cjs.mjs",
					"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.cjs.js"
				},
				workerd: {
					module: "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.esm.js",
					"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.cjs.mjs",
					"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.cjs.js"
				},
				browser: {
					module: "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.development.esm.js",
					"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.development.cjs.mjs",
					"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.development.cjs.js"
				},
				module: "./jsx-runtime/dist/emotion-react-jsx-runtime.development.esm.js",
				"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.cjs.mjs",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.cjs.js"
			},
			"edge-light": {
				module: "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.esm.js",
				"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.cjs.mjs",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.cjs.js"
			},
			worker: {
				module: "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.esm.js",
				"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.cjs.mjs",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.cjs.js"
			},
			workerd: {
				module: "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.esm.js",
				"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.cjs.mjs",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.cjs.js"
			},
			browser: {
				module: "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.esm.js",
				"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.cjs.mjs",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.cjs.js"
			},
			module: "./jsx-runtime/dist/emotion-react-jsx-runtime.esm.js",
			"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.mjs",
			"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.js"
		},
		"./_isolated-hnrs": {
			types: {
				"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.mjs",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.js"
			},
			development: {
				"edge-light": {
					module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.esm.js",
					"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.cjs.mjs",
					"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.cjs.js"
				},
				worker: {
					module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.esm.js",
					"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.cjs.mjs",
					"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.cjs.js"
				},
				workerd: {
					module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.esm.js",
					"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.cjs.mjs",
					"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.cjs.js"
				},
				browser: {
					module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.esm.js",
					"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.cjs.mjs",
					"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.cjs.js"
				},
				module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.esm.js",
				"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.cjs.mjs",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.cjs.js"
			},
			"edge-light": {
				module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.esm.js",
				"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.cjs.mjs",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.cjs.js"
			},
			worker: {
				module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.esm.js",
				"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.cjs.mjs",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.cjs.js"
			},
			workerd: {
				module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.esm.js",
				"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.cjs.mjs",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.cjs.js"
			},
			browser: {
				module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.esm.js",
				"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.cjs.mjs",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.cjs.js"
			},
			module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.esm.js",
			"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.mjs",
			"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.js"
		},
		"./jsx-dev-runtime": {
			types: {
				"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.mjs",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.js"
			},
			development: {
				"edge-light": {
					module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.esm.js",
					"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.cjs.mjs",
					"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.cjs.js"
				},
				worker: {
					module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.esm.js",
					"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.cjs.mjs",
					"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.cjs.js"
				},
				workerd: {
					module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.esm.js",
					"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.cjs.mjs",
					"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.cjs.js"
				},
				browser: {
					module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.development.esm.js",
					"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.development.cjs.mjs",
					"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.development.cjs.js"
				},
				module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.esm.js",
				"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.cjs.mjs",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.cjs.js"
			},
			"edge-light": {
				module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.esm.js",
				"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.cjs.mjs",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.cjs.js"
			},
			worker: {
				module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.esm.js",
				"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.cjs.mjs",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.cjs.js"
			},
			workerd: {
				module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.esm.js",
				"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.cjs.mjs",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.cjs.js"
			},
			browser: {
				module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.esm.js",
				"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.cjs.mjs",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.cjs.js"
			},
			module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.esm.js",
			"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.mjs",
			"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.js"
		},
		"./package.json": "./package.json",
		"./types/css-prop": "./types/css-prop.d.ts",
		"./macro": {
			types: {
				"import": "./macro.d.mts",
				"default": "./macro.d.ts"
			},
			"default": "./macro.js"
		}
	},
	imports: {
		"#is-development": {
			development: "./src/conditions/true.ts",
			"default": "./src/conditions/false.ts"
		},
		"#is-browser": {
			"edge-light": "./src/conditions/false.ts",
			workerd: "./src/conditions/false.ts",
			worker: "./src/conditions/false.ts",
			browser: "./src/conditions/true.ts",
			"default": "./src/conditions/is-browser.ts"
		}
	},
	files: [
		"src",
		"dist",
		"jsx-runtime",
		"jsx-dev-runtime",
		"_isolated-hnrs",
		"types/css-prop.d.ts",
		"macro.*"
	],
	sideEffects: false,
	author: "Emotion Contributors",
	license: "MIT",
	scripts: {
		"test:typescript": "dtslint types"
	},
	dependencies: {
		"@babel/runtime": "^7.18.3",
		"@emotion/babel-plugin": "^11.13.5",
		"@emotion/cache": "^11.14.0",
		"@emotion/serialize": "^1.3.3",
		"@emotion/use-insertion-effect-with-fallbacks": "^1.2.0",
		"@emotion/utils": "^1.4.2",
		"@emotion/weak-memoize": "^0.4.0",
		"hoist-non-react-statics": "^3.3.1"
	},
	peerDependencies: {
		react: ">=16.8.0"
	},
	peerDependenciesMeta: {
		"@types/react": {
			optional: true
		}
	},
	devDependencies: {
		"@definitelytyped/dtslint": "0.0.112",
		"@emotion/css": "11.13.5",
		"@emotion/css-prettifier": "1.2.0",
		"@emotion/server": "11.11.0",
		"@emotion/styled": "11.14.0",
		"@types/hoist-non-react-statics": "^3.3.5",
		"html-tag-names": "^1.1.2",
		react: "16.14.0",
		"svg-tag-names": "^1.1.1",
		typescript: "^5.4.5"
	},
	repository: "https://github.com/emotion-js/emotion/tree/main/packages/react",
	publishConfig: {
		access: "public"
	},
	"umd:main": "dist/emotion-react.umd.min.js",
	preconstruct: {
		entrypoints: [
			"./index.ts",
			"./jsx-runtime.ts",
			"./jsx-dev-runtime.ts",
			"./_isolated-hnrs.ts"
		],
		umdName: "emotionReact",
		exports: {
			extra: {
				"./types/css-prop": "./types/css-prop.d.ts",
				"./macro": {
					types: {
						"import": "./macro.d.mts",
						"default": "./macro.d.ts"
					},
					"default": "./macro.js"
				}
			}
		}
	}
};

var jsx = function jsx(type, props) {
  // eslint-disable-next-line prefer-rest-params
  var args = arguments;

  if (props == null || !_emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.h.call(props, 'css')) {
    return react__WEBPACK_IMPORTED_MODULE_1__.createElement.apply(undefined, args);
  }

  var argsLength = args.length;
  var createElementArgArray = new Array(argsLength);
  createElementArgArray[0] = _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.E;
  createElementArgArray[1] = (0,_emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.c)(type, props);

  for (var i = 2; i < argsLength; i++) {
    createElementArgArray[i] = args[i];
  }

  return react__WEBPACK_IMPORTED_MODULE_1__.createElement.apply(null, createElementArgArray);
};

(function (_jsx) {
  var JSX;

  (function (_JSX) {})(JSX || (JSX = _jsx.JSX || (_jsx.JSX = {})));
})(jsx || (jsx = {}));

var warnedAboutCssPropForGlobal = false; // maintain place over rerenders.
// initial render from browser, insertBefore context.sheet.tags[0] or if a style hasn't been inserted there yet, appendChild
// initial client-side render from SSR, use place of hydrating tag

var Global = /* #__PURE__ */(0,_emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.w)(function (props, cache) {
  if (!warnedAboutCssPropForGlobal && ( // check for className as well since the user is
  // probably using the custom createElement which
  // means it will be turned into a className prop
  // I don't really want to add it to the type since it shouldn't be used
  'className' in props && props.className || 'css' in props && props.css)) {
    console.error("It looks like you're using the css prop on Global, did you mean to use the styles prop instead?");
    warnedAboutCssPropForGlobal = true;
  }

  var styles = props.styles;
  var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_4__.serializeStyles)([styles], undefined, react__WEBPACK_IMPORTED_MODULE_1__.useContext(_emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.T));
  // but it is based on a constant that will never change at runtime
  // it's effectively like having two implementations and switching them out
  // so it's not actually breaking anything


  var sheetRef = react__WEBPACK_IMPORTED_MODULE_1__.useRef();
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__.useInsertionEffectWithLayoutFallback)(function () {
    var key = cache.key + "-global"; // use case of https://github.com/emotion-js/emotion/issues/2675

    var sheet = new cache.sheet.constructor({
      key: key,
      nonce: cache.sheet.nonce,
      container: cache.sheet.container,
      speedy: cache.sheet.isSpeedy
    });
    var rehydrating = false;
    var node = document.querySelector("style[data-emotion=\"" + key + " " + serialized.name + "\"]");

    if (cache.sheet.tags.length) {
      sheet.before = cache.sheet.tags[0];
    }

    if (node !== null) {
      rehydrating = true; // clear the hash so this node won't be recognizable as rehydratable by other <Global/>s

      node.setAttribute('data-emotion', key);
      sheet.hydrate([node]);
    }

    sheetRef.current = [sheet, rehydrating];
    return function () {
      sheet.flush();
    };
  }, [cache]);
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__.useInsertionEffectWithLayoutFallback)(function () {
    var sheetRefCurrent = sheetRef.current;
    var sheet = sheetRefCurrent[0],
        rehydrating = sheetRefCurrent[1];

    if (rehydrating) {
      sheetRefCurrent[1] = false;
      return;
    }

    if (serialized.next !== undefined) {
      // insert keyframes
      (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.insertStyles)(cache, serialized.next, true);
    }

    if (sheet.tags.length) {
      // if this doesn't exist then it will be null so the style element will be appended
      var element = sheet.tags[sheet.tags.length - 1].nextElementSibling;
      sheet.before = element;
      sheet.flush();
    }

    cache.insert("", serialized, sheet, false);
  }, [cache, serialized.name]);
  return null;
});

{
  Global.displayName = 'EmotionGlobal';
}

function css() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_4__.serializeStyles)(args);
}

function keyframes() {
  var insertable = css.apply(void 0, arguments);
  var name = "animation-" + insertable.name;
  return {
    name: name,
    styles: "@keyframes " + name + "{" + insertable.styles + "}",
    anim: 1,
    toString: function toString() {
      return "_EMO_" + this.name + "_" + this.styles + "_EMO_";
    }
  };
}

var classnames = function classnames(args) {
  var len = args.length;
  var i = 0;
  var cls = '';

  for (; i < len; i++) {
    var arg = args[i];
    if (arg == null) continue;
    var toAdd = void 0;

    switch (typeof arg) {
      case 'boolean':
        break;

      case 'object':
        {
          if (Array.isArray(arg)) {
            toAdd = classnames(arg);
          } else {
            if (arg.styles !== undefined && arg.name !== undefined) {
              console.error('You have passed styles created with `css` from `@emotion/react` package to the `cx`.\n' + '`cx` is meant to compose class names (strings) so you should convert those styles to a class name by passing them to the `css` received from <ClassNames/> component.');
            }

            toAdd = '';

            for (var k in arg) {
              if (arg[k] && k) {
                toAdd && (toAdd += ' ');
                toAdd += k;
              }
            }
          }

          break;
        }

      default:
        {
          toAdd = arg;
        }
    }

    if (toAdd) {
      cls && (cls += ' ');
      cls += toAdd;
    }
  }

  return cls;
};

function merge(registered, css, className) {
  var registeredStyles = [];
  var rawClassName = (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.getRegisteredStyles)(registered, registeredStyles, className);

  if (registeredStyles.length < 2) {
    return className;
  }

  return rawClassName + css(registeredStyles);
}

var Insertion = function Insertion(_ref) {
  var cache = _ref.cache,
      serializedArr = _ref.serializedArr;
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__.useInsertionEffectAlwaysWithSyncFallback)(function () {

    for (var i = 0; i < serializedArr.length; i++) {
      (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.insertStyles)(cache, serializedArr[i], false);
    }
  });

  return null;
};

var ClassNames = /* #__PURE__ */(0,_emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.w)(function (props, cache) {
  var hasRendered = false;
  var serializedArr = [];

  var css = function css() {
    if (hasRendered && isDevelopment) {
      throw new Error('css can only be used during render');
    }

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_4__.serializeStyles)(args, cache.registered);
    serializedArr.push(serialized); // registration has to happen here as the result of this might get consumed by `cx`

    (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.registerStyles)(cache, serialized, false);
    return cache.key + "-" + serialized.name;
  };

  var cx = function cx() {
    if (hasRendered && isDevelopment) {
      throw new Error('cx can only be used during render');
    }

    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return merge(cache.registered, css, classnames(args));
  };

  var content = {
    css: css,
    cx: cx,
    theme: react__WEBPACK_IMPORTED_MODULE_1__.useContext(_emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.T)
  };
  var ele = props.children(content);
  hasRendered = true;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(Insertion, {
    cache: cache,
    serializedArr: serializedArr
  }), ele);
});

{
  ClassNames.displayName = 'EmotionClassNames';
}

{
  var isBrowser = typeof document !== 'undefined'; // #1727, #2905 for some reason Jest and Vitest evaluate modules twice if some consuming module gets mocked

  var isTestEnv = typeof jest !== 'undefined' || typeof vi !== 'undefined';

  if (isBrowser && !isTestEnv) {
    // globalThis has wide browser support - https://caniuse.com/?search=globalThis, Node.js 12 and later
    var globalContext = typeof globalThis !== 'undefined' ? globalThis // eslint-disable-line no-undef
    : isBrowser ? window : __webpack_require__.g;
    var globalKey = "__EMOTION_REACT_" + pkg.version.split('.')[0] + "__";

    if (globalContext[globalKey]) {
      console.warn('You are loading @emotion/react when it is already loaded. Running ' + 'multiple instances may cause problems. This can happen if multiple ' + 'versions are used, or if multiple builds of the same version are ' + 'used.');
    }

    globalContext[globalKey] = true;
  }
}




/***/ }),

/***/ "./node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeStyles: () => (/* binding */ serializeStyles)
/* harmony export */ });
/* harmony import */ var _emotion_hash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/hash */ "./node_modules/@emotion/hash/dist/emotion-hash.esm.js");
/* harmony import */ var _emotion_unitless__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/unitless */ "./node_modules/@emotion/unitless/dist/emotion-unitless.esm.js");
/* harmony import */ var _emotion_memoize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/memoize */ "./node_modules/@emotion/memoize/dist/emotion-memoize.esm.js");




var isDevelopment = true;

var ILLEGAL_ESCAPE_SEQUENCE_ERROR = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";
var UNDEFINED_AS_OBJECT_KEY_ERROR = "You have passed in falsy value as style object's key (can happen when in example you pass unexported component as computed key).";
var hyphenateRegex = /[A-Z]|^ms/g;
var animationRegex = /_EMO_([^_]+?)_([^]*?)_EMO_/g;

var isCustomProperty = function isCustomProperty(property) {
  return property.charCodeAt(1) === 45;
};

var isProcessableValue = function isProcessableValue(value) {
  return value != null && typeof value !== 'boolean';
};

var processStyleName = /* #__PURE__ */(0,_emotion_memoize__WEBPACK_IMPORTED_MODULE_2__["default"])(function (styleName) {
  return isCustomProperty(styleName) ? styleName : styleName.replace(hyphenateRegex, '-$&').toLowerCase();
});

var processStyleValue = function processStyleValue(key, value) {
  switch (key) {
    case 'animation':
    case 'animationName':
      {
        if (typeof value === 'string') {
          return value.replace(animationRegex, function (match, p1, p2) {
            cursor = {
              name: p1,
              styles: p2,
              next: cursor
            };
            return p1;
          });
        }
      }
  }

  if (_emotion_unitless__WEBPACK_IMPORTED_MODULE_1__["default"][key] !== 1 && !isCustomProperty(key) && typeof value === 'number' && value !== 0) {
    return value + 'px';
  }

  return value;
};

{
  var contentValuePattern = /(var|attr|counters?|url|element|(((repeating-)?(linear|radial))|conic)-gradient)\(|(no-)?(open|close)-quote/;
  var contentValues = ['normal', 'none', 'initial', 'inherit', 'unset'];
  var oldProcessStyleValue = processStyleValue;
  var msPattern = /^-ms-/;
  var hyphenPattern = /-(.)/g;
  var hyphenatedCache = {};

  processStyleValue = function processStyleValue(key, value) {
    if (key === 'content') {
      if (typeof value !== 'string' || contentValues.indexOf(value) === -1 && !contentValuePattern.test(value) && (value.charAt(0) !== value.charAt(value.length - 1) || value.charAt(0) !== '"' && value.charAt(0) !== "'")) {
        throw new Error("You seem to be using a value for 'content' without quotes, try replacing it with `content: '\"" + value + "\"'`");
      }
    }

    var processed = oldProcessStyleValue(key, value);

    if (processed !== '' && !isCustomProperty(key) && key.indexOf('-') !== -1 && hyphenatedCache[key] === undefined) {
      hyphenatedCache[key] = true;
      console.error("Using kebab-case for css properties in objects is not supported. Did you mean " + key.replace(msPattern, 'ms-').replace(hyphenPattern, function (str, _char) {
        return _char.toUpperCase();
      }) + "?");
    }

    return processed;
  };
}

var noComponentSelectorMessage = 'Component selectors can only be used in conjunction with ' + '@emotion/babel-plugin, the swc Emotion plugin, or another Emotion-aware ' + 'compiler transform.';

function handleInterpolation(mergedProps, registered, interpolation) {
  if (interpolation == null) {
    return '';
  }

  var componentSelector = interpolation;

  if (componentSelector.__emotion_styles !== undefined) {
    if (String(componentSelector) === 'NO_COMPONENT_SELECTOR') {
      throw new Error(noComponentSelectorMessage);
    }

    return componentSelector;
  }

  switch (typeof interpolation) {
    case 'boolean':
      {
        return '';
      }

    case 'object':
      {
        var keyframes = interpolation;

        if (keyframes.anim === 1) {
          cursor = {
            name: keyframes.name,
            styles: keyframes.styles,
            next: cursor
          };
          return keyframes.name;
        }

        var serializedStyles = interpolation;

        if (serializedStyles.styles !== undefined) {
          var next = serializedStyles.next;

          if (next !== undefined) {
            // not the most efficient thing ever but this is a pretty rare case
            // and there will be very few iterations of this generally
            while (next !== undefined) {
              cursor = {
                name: next.name,
                styles: next.styles,
                next: cursor
              };
              next = next.next;
            }
          }

          var styles = serializedStyles.styles + ";";
          return styles;
        }

        return createStringFromObject(mergedProps, registered, interpolation);
      }

    case 'function':
      {
        if (mergedProps !== undefined) {
          var previousCursor = cursor;
          var result = interpolation(mergedProps);
          cursor = previousCursor;
          return handleInterpolation(mergedProps, registered, result);
        } else {
          console.error('Functions that are interpolated in css calls will be stringified.\n' + 'If you want to have a css call based on props, create a function that returns a css call like this\n' + 'let dynamicStyle = (props) => css`color: ${props.color}`\n' + 'It can be called directly with props or interpolated in a styled call like this\n' + "let SomeComponent = styled('div')`${dynamicStyle}`");
        }

        break;
      }

    case 'string':
      {
        var matched = [];
        var replaced = interpolation.replace(animationRegex, function (_match, _p1, p2) {
          var fakeVarName = "animation" + matched.length;
          matched.push("const " + fakeVarName + " = keyframes`" + p2.replace(/^@keyframes animation-\w+/, '') + "`");
          return "${" + fakeVarName + "}";
        });

        if (matched.length) {
          console.error("`keyframes` output got interpolated into plain string, please wrap it with `css`.\n\nInstead of doing this:\n\n" + [].concat(matched, ["`" + replaced + "`"]).join('\n') + "\n\nYou should wrap it with `css` like this:\n\ncss`" + replaced + "`");
        }
      }

      break;
  } // finalize string values (regular strings and functions interpolated into css calls)


  var asString = interpolation;

  if (registered == null) {
    return asString;
  }

  var cached = registered[asString];
  return cached !== undefined ? cached : asString;
}

function createStringFromObject(mergedProps, registered, obj) {
  var string = '';

  if (Array.isArray(obj)) {
    for (var i = 0; i < obj.length; i++) {
      string += handleInterpolation(mergedProps, registered, obj[i]) + ";";
    }
  } else {
    for (var key in obj) {
      var value = obj[key];

      if (typeof value !== 'object') {
        var asString = value;

        if (registered != null && registered[asString] !== undefined) {
          string += key + "{" + registered[asString] + "}";
        } else if (isProcessableValue(asString)) {
          string += processStyleName(key) + ":" + processStyleValue(key, asString) + ";";
        }
      } else {
        if (key === 'NO_COMPONENT_SELECTOR' && isDevelopment) {
          throw new Error(noComponentSelectorMessage);
        }

        if (Array.isArray(value) && typeof value[0] === 'string' && (registered == null || registered[value[0]] === undefined)) {
          for (var _i = 0; _i < value.length; _i++) {
            if (isProcessableValue(value[_i])) {
              string += processStyleName(key) + ":" + processStyleValue(key, value[_i]) + ";";
            }
          }
        } else {
          var interpolated = handleInterpolation(mergedProps, registered, value);

          switch (key) {
            case 'animation':
            case 'animationName':
              {
                string += processStyleName(key) + ":" + interpolated + ";";
                break;
              }

            default:
              {
                if (key === 'undefined') {
                  console.error(UNDEFINED_AS_OBJECT_KEY_ERROR);
                }

                string += key + "{" + interpolated + "}";
              }
          }
        }
      }
    }
  }

  return string;
}

var labelPattern = /label:\s*([^\s;{]+)\s*(;|$)/g; // this is the cursor for keyframes
// keyframes are stored on the SerializedStyles object as a linked list

var cursor;
function serializeStyles(args, registered, mergedProps) {
  if (args.length === 1 && typeof args[0] === 'object' && args[0] !== null && args[0].styles !== undefined) {
    return args[0];
  }

  var stringMode = true;
  var styles = '';
  cursor = undefined;
  var strings = args[0];

  if (strings == null || strings.raw === undefined) {
    stringMode = false;
    styles += handleInterpolation(mergedProps, registered, strings);
  } else {
    var asTemplateStringsArr = strings;

    if (asTemplateStringsArr[0] === undefined) {
      console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
    }

    styles += asTemplateStringsArr[0];
  } // we start at 1 since we've already handled the first arg


  for (var i = 1; i < args.length; i++) {
    styles += handleInterpolation(mergedProps, registered, args[i]);

    if (stringMode) {
      var templateStringsArr = strings;

      if (templateStringsArr[i] === undefined) {
        console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
      }

      styles += templateStringsArr[i];
    }
  } // using a global regex with .exec is stateful so lastIndex has to be reset each time


  labelPattern.lastIndex = 0;
  var identifierName = '';
  var match; // https://esbench.com/bench/5b809c2cf2949800a0f61fb5

  while ((match = labelPattern.exec(styles)) !== null) {
    identifierName += '-' + match[1];
  }

  var name = (0,_emotion_hash__WEBPACK_IMPORTED_MODULE_0__["default"])(styles) + identifierName;

  {
    var devStyles = {
      name: name,
      styles: styles,
      next: cursor,
      toString: function toString() {
        return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
      }
    };
    return devStyles;
  }
}




/***/ }),

/***/ "./node_modules/@emotion/sheet/dist/emotion-sheet.development.esm.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@emotion/sheet/dist/emotion-sheet.development.esm.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StyleSheet: () => (/* binding */ StyleSheet)
/* harmony export */ });
var isDevelopment = true;

/*

Based off glamor's StyleSheet, thanks Sunil ❤️

high performance StyleSheet for css-in-js systems

- uses multiple style tags behind the scenes for millions of rules
- uses `insertRule` for appending in production for *much* faster performance

// usage

import { StyleSheet } from '@emotion/sheet'

let styleSheet = new StyleSheet({ key: '', container: document.head })

styleSheet.insert('#box { border: 1px solid red; }')
- appends a css rule into the stylesheet

styleSheet.flush()
- empties the stylesheet of all its contents

*/

function sheetForTag(tag) {
  if (tag.sheet) {
    return tag.sheet;
  } // this weirdness brought to you by firefox

  /* istanbul ignore next */


  for (var i = 0; i < document.styleSheets.length; i++) {
    if (document.styleSheets[i].ownerNode === tag) {
      return document.styleSheets[i];
    }
  } // this function should always return with a value
  // TS can't understand it though so we make it stop complaining here


  return undefined;
}

function createStyleElement(options) {
  var tag = document.createElement('style');
  tag.setAttribute('data-emotion', options.key);

  if (options.nonce !== undefined) {
    tag.setAttribute('nonce', options.nonce);
  }

  tag.appendChild(document.createTextNode(''));
  tag.setAttribute('data-s', '');
  return tag;
}

var StyleSheet = /*#__PURE__*/function () {
  // Using Node instead of HTMLElement since container may be a ShadowRoot
  function StyleSheet(options) {
    var _this = this;

    this._insertTag = function (tag) {
      var before;

      if (_this.tags.length === 0) {
        if (_this.insertionPoint) {
          before = _this.insertionPoint.nextSibling;
        } else if (_this.prepend) {
          before = _this.container.firstChild;
        } else {
          before = _this.before;
        }
      } else {
        before = _this.tags[_this.tags.length - 1].nextSibling;
      }

      _this.container.insertBefore(tag, before);

      _this.tags.push(tag);
    };

    this.isSpeedy = options.speedy === undefined ? !isDevelopment : options.speedy;
    this.tags = [];
    this.ctr = 0;
    this.nonce = options.nonce; // key is the value of the data-emotion attribute, it's used to identify different sheets

    this.key = options.key;
    this.container = options.container;
    this.prepend = options.prepend;
    this.insertionPoint = options.insertionPoint;
    this.before = null;
  }

  var _proto = StyleSheet.prototype;

  _proto.hydrate = function hydrate(nodes) {
    nodes.forEach(this._insertTag);
  };

  _proto.insert = function insert(rule) {
    // the max length is how many rules we have per style tag, it's 65000 in speedy mode
    // it's 1 in dev because we insert source maps that map a single rule to a location
    // and you can only have one source map per style tag
    if (this.ctr % (this.isSpeedy ? 65000 : 1) === 0) {
      this._insertTag(createStyleElement(this));
    }

    var tag = this.tags[this.tags.length - 1];

    {
      var isImportRule = rule.charCodeAt(0) === 64 && rule.charCodeAt(1) === 105;

      if (isImportRule && this._alreadyInsertedOrderInsensitiveRule) {
        // this would only cause problem in speedy mode
        // but we don't want enabling speedy to affect the observable behavior
        // so we report this error at all times
        console.error("You're attempting to insert the following rule:\n" + rule + '\n\n`@import` rules must be before all other types of rules in a stylesheet but other rules have already been inserted. Please ensure that `@import` rules are before all other rules.');
      }

      this._alreadyInsertedOrderInsensitiveRule = this._alreadyInsertedOrderInsensitiveRule || !isImportRule;
    }

    if (this.isSpeedy) {
      var sheet = sheetForTag(tag);

      try {
        // this is the ultrafast version, works across browsers
        // the big drawback is that the css won't be editable in devtools
        sheet.insertRule(rule, sheet.cssRules.length);
      } catch (e) {
        if (!/:(-moz-placeholder|-moz-focus-inner|-moz-focusring|-ms-input-placeholder|-moz-read-write|-moz-read-only|-ms-clear|-ms-expand|-ms-reveal){/.test(rule)) {
          console.error("There was a problem inserting the following rule: \"" + rule + "\"", e);
        }
      }
    } else {
      tag.appendChild(document.createTextNode(rule));
    }

    this.ctr++;
  };

  _proto.flush = function flush() {
    this.tags.forEach(function (tag) {
      var _tag$parentNode;

      return (_tag$parentNode = tag.parentNode) == null ? void 0 : _tag$parentNode.removeChild(tag);
    });
    this.tags = [];
    this.ctr = 0;

    {
      this._alreadyInsertedOrderInsensitiveRule = false;
    }
  };

  return StyleSheet;
}();




/***/ }),

/***/ "./node_modules/@emotion/styled/base/dist/emotion-styled-base.browser.development.esm.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@emotion/styled/base/dist/emotion-styled-base.browser.development.esm.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createStyled)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js");
/* harmony import */ var _emotion_serialize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/serialize */ "./node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js");
/* harmony import */ var _emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/use-insertion-effect-with-fallbacks */ "./node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js");
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _emotion_is_prop_valid__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @emotion/is-prop-valid */ "./node_modules/@emotion/is-prop-valid/dist/emotion-is-prop-valid.esm.js");








var isDevelopment = true;

var testOmitPropsOnStringTag = _emotion_is_prop_valid__WEBPACK_IMPORTED_MODULE_6__["default"];

var testOmitPropsOnComponent = function testOmitPropsOnComponent(key) {
  return key !== 'theme';
};

var getDefaultShouldForwardProp = function getDefaultShouldForwardProp(tag) {
  return typeof tag === 'string' && // 96 is one less than the char code
  // for "a" so this is checking that
  // it's a lowercase character
  tag.charCodeAt(0) > 96 ? testOmitPropsOnStringTag : testOmitPropsOnComponent;
};
var composeShouldForwardProps = function composeShouldForwardProps(tag, options, isReal) {
  var shouldForwardProp;

  if (options) {
    var optionsShouldForwardProp = options.shouldForwardProp;
    shouldForwardProp = tag.__emotion_forwardProp && optionsShouldForwardProp ? function (propName) {
      return tag.__emotion_forwardProp(propName) && optionsShouldForwardProp(propName);
    } : optionsShouldForwardProp;
  }

  if (typeof shouldForwardProp !== 'function' && isReal) {
    shouldForwardProp = tag.__emotion_forwardProp;
  }

  return shouldForwardProp;
};

var ILLEGAL_ESCAPE_SEQUENCE_ERROR = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";

var Insertion = function Insertion(_ref) {
  var cache = _ref.cache,
      serialized = _ref.serialized,
      isStringTag = _ref.isStringTag;
  (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_4__.registerStyles)(cache, serialized, isStringTag);
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__.useInsertionEffectAlwaysWithSyncFallback)(function () {
    return (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_4__.insertStyles)(cache, serialized, isStringTag);
  });

  return null;
};

var createStyled = function createStyled(tag, options) {
  {
    if (tag === undefined) {
      throw new Error('You are trying to create a styled element with an undefined component.\nYou may have forgotten to import it.');
    }
  }

  var isReal = tag.__emotion_real === tag;
  var baseTag = isReal && tag.__emotion_base || tag;
  var identifierName;
  var targetClassName;

  if (options !== undefined) {
    identifierName = options.label;
    targetClassName = options.target;
  }

  var shouldForwardProp = composeShouldForwardProps(tag, options, isReal);
  var defaultShouldForwardProp = shouldForwardProp || getDefaultShouldForwardProp(baseTag);
  var shouldUseAs = !defaultShouldForwardProp('as');
  return function () {
    // eslint-disable-next-line prefer-rest-params
    var args = arguments;
    var styles = isReal && tag.__emotion_styles !== undefined ? tag.__emotion_styles.slice(0) : [];

    if (identifierName !== undefined) {
      styles.push("label:" + identifierName + ";");
    }

    if (args[0] == null || args[0].raw === undefined) {
      // eslint-disable-next-line prefer-spread
      styles.push.apply(styles, args);
    } else {
      var templateStringsArr = args[0];

      if (templateStringsArr[0] === undefined) {
        console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
      }

      styles.push(templateStringsArr[0]);
      var len = args.length;
      var i = 1;

      for (; i < len; i++) {
        if (templateStringsArr[i] === undefined) {
          console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
        }

        styles.push(args[i], templateStringsArr[i]);
      }
    }

    var Styled = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.w)(function (props, cache, ref) {
      var FinalTag = shouldUseAs && props.as || baseTag;
      var className = '';
      var classInterpolations = [];
      var mergedProps = props;

      if (props.theme == null) {
        mergedProps = {};

        for (var key in props) {
          mergedProps[key] = props[key];
        }

        mergedProps.theme = react__WEBPACK_IMPORTED_MODULE_5__.useContext(_emotion_react__WEBPACK_IMPORTED_MODULE_1__.T);
      }

      if (typeof props.className === 'string') {
        className = (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_4__.getRegisteredStyles)(cache.registered, classInterpolations, props.className);
      } else if (props.className != null) {
        className = props.className + " ";
      }

      var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_2__.serializeStyles)(styles.concat(classInterpolations), cache.registered, mergedProps);
      className += cache.key + "-" + serialized.name;

      if (targetClassName !== undefined) {
        className += " " + targetClassName;
      }

      var finalShouldForwardProp = shouldUseAs && shouldForwardProp === undefined ? getDefaultShouldForwardProp(FinalTag) : defaultShouldForwardProp;
      var newProps = {};

      for (var _key in props) {
        if (shouldUseAs && _key === 'as') continue;

        if (finalShouldForwardProp(_key)) {
          newProps[_key] = props[_key];
        }
      }

      newProps.className = className;

      if (ref) {
        newProps.ref = ref;
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5__.createElement(react__WEBPACK_IMPORTED_MODULE_5__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5__.createElement(Insertion, {
        cache: cache,
        serialized: serialized,
        isStringTag: typeof FinalTag === 'string'
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5__.createElement(FinalTag, newProps));
    });
    Styled.displayName = identifierName !== undefined ? identifierName : "Styled(" + (typeof baseTag === 'string' ? baseTag : baseTag.displayName || baseTag.name || 'Component') + ")";
    Styled.defaultProps = tag.defaultProps;
    Styled.__emotion_real = Styled;
    Styled.__emotion_base = baseTag;
    Styled.__emotion_styles = styles;
    Styled.__emotion_forwardProp = shouldForwardProp;
    Object.defineProperty(Styled, 'toString', {
      value: function value() {
        if (targetClassName === undefined && isDevelopment) {
          return 'NO_COMPONENT_SELECTOR';
        }

        return "." + targetClassName;
      }
    });

    Styled.withComponent = function (nextTag, nextOptions) {
      var newStyled = createStyled(nextTag, (0,_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, options, nextOptions, {
        shouldForwardProp: composeShouldForwardProps(Styled, nextOptions, true)
      }));
      return newStyled.apply(void 0, styles);
    };

    return Styled;
  };
};




/***/ }),

/***/ "./node_modules/@emotion/unitless/dist/emotion-unitless.esm.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@emotion/unitless/dist/emotion-unitless.esm.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ unitlessKeys)
/* harmony export */ });
var unitlessKeys = {
  animationIterationCount: 1,
  aspectRatio: 1,
  borderImageOutset: 1,
  borderImageSlice: 1,
  borderImageWidth: 1,
  boxFlex: 1,
  boxFlexGroup: 1,
  boxOrdinalGroup: 1,
  columnCount: 1,
  columns: 1,
  flex: 1,
  flexGrow: 1,
  flexPositive: 1,
  flexShrink: 1,
  flexNegative: 1,
  flexOrder: 1,
  gridRow: 1,
  gridRowEnd: 1,
  gridRowSpan: 1,
  gridRowStart: 1,
  gridColumn: 1,
  gridColumnEnd: 1,
  gridColumnSpan: 1,
  gridColumnStart: 1,
  msGridRow: 1,
  msGridRowSpan: 1,
  msGridColumn: 1,
  msGridColumnSpan: 1,
  fontWeight: 1,
  lineHeight: 1,
  opacity: 1,
  order: 1,
  orphans: 1,
  scale: 1,
  tabSize: 1,
  widows: 1,
  zIndex: 1,
  zoom: 1,
  WebkitLineClamp: 1,
  // SVG-related properties
  fillOpacity: 1,
  floodOpacity: 1,
  stopOpacity: 1,
  strokeDasharray: 1,
  strokeDashoffset: 1,
  strokeMiterlimit: 1,
  strokeOpacity: 1,
  strokeWidth: 1
};




/***/ }),

/***/ "./node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js":
/*!***********************************************************************************************************************************!*\
  !*** ./node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js ***!
  \***********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useInsertionEffectAlwaysWithSyncFallback: () => (/* binding */ useInsertionEffectAlwaysWithSyncFallback),
/* harmony export */   useInsertionEffectWithLayoutFallback: () => (/* binding */ useInsertionEffectWithLayoutFallback)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var syncFallback = function syncFallback(create) {
  return create();
};

var useInsertionEffect = react__WEBPACK_IMPORTED_MODULE_0__['useInsertion' + 'Effect'] ? react__WEBPACK_IMPORTED_MODULE_0__['useInsertion' + 'Effect'] : false;
var useInsertionEffectAlwaysWithSyncFallback = useInsertionEffect || syncFallback;
var useInsertionEffectWithLayoutFallback = useInsertionEffect || react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect;




/***/ }),

/***/ "./node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getRegisteredStyles: () => (/* binding */ getRegisteredStyles),
/* harmony export */   insertStyles: () => (/* binding */ insertStyles),
/* harmony export */   registerStyles: () => (/* binding */ registerStyles)
/* harmony export */ });
var isBrowser = true;

function getRegisteredStyles(registered, registeredStyles, classNames) {
  var rawClassName = '';
  classNames.split(' ').forEach(function (className) {
    if (registered[className] !== undefined) {
      registeredStyles.push(registered[className] + ";");
    } else if (className) {
      rawClassName += className + " ";
    }
  });
  return rawClassName;
}
var registerStyles = function registerStyles(cache, serialized, isStringTag) {
  var className = cache.key + "-" + serialized.name;

  if ( // we only need to add the styles to the registered cache if the
  // class name could be used further down
  // the tree but if it's a string tag, we know it won't
  // so we don't have to add it to registered cache.
  // this improves memory usage since we can avoid storing the whole style string
  (isStringTag === false || // we need to always store it if we're in compat mode and
  // in node since emotion-server relies on whether a style is in
  // the registered cache to know whether a style is global or not
  // also, note that this check will be dead code eliminated in the browser
  isBrowser === false ) && cache.registered[className] === undefined) {
    cache.registered[className] = serialized.styles;
  }
};
var insertStyles = function insertStyles(cache, serialized, isStringTag) {
  registerStyles(cache, serialized, isStringTag);
  var className = cache.key + "-" + serialized.name;

  if (cache.inserted[serialized.name] === undefined) {
    var current = serialized;

    do {
      cache.insert(serialized === current ? "." + className : '', current, cache.sheet, true);

      current = current.next;
    } while (current !== undefined);
  }
};




/***/ }),

/***/ "./node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ weakMemoize)
/* harmony export */ });
var weakMemoize = function weakMemoize(func) {
  var cache = new WeakMap();
  return function (arg) {
    if (cache.has(arg)) {
      // Use non-null assertion because we just checked that the cache `has` it
      // This allows us to remove `undefined` from the return value
      return cache.get(arg);
    }

    var ret = func(arg);
    cache.set(arg, ret);
    return ret;
  };
};




/***/ }),

/***/ "./node_modules/@floating-ui/core/dist/floating-ui.core.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/@floating-ui/core/dist/floating-ui.core.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrow: () => (/* binding */ arrow),
/* harmony export */   autoPlacement: () => (/* binding */ autoPlacement),
/* harmony export */   computePosition: () => (/* binding */ computePosition),
/* harmony export */   detectOverflow: () => (/* binding */ detectOverflow),
/* harmony export */   flip: () => (/* binding */ flip),
/* harmony export */   hide: () => (/* binding */ hide),
/* harmony export */   inline: () => (/* binding */ inline),
/* harmony export */   limitShift: () => (/* binding */ limitShift),
/* harmony export */   offset: () => (/* binding */ offset),
/* harmony export */   rectToClientRect: () => (/* reexport safe */ _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect),
/* harmony export */   shift: () => (/* binding */ shift),
/* harmony export */   size: () => (/* binding */ size)
/* harmony export */ });
/* harmony import */ var _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/utils */ "./node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs");



function computeCoordsFromPlacement(_ref, placement, rtl) {
  let {
    reference,
    floating
  } = _ref;
  const sideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement);
  const alignmentAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentAxis)(placement);
  const alignLength = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAxisLength)(alignmentAxis);
  const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);
  const isVertical = sideAxis === 'y';
  const commonX = reference.x + reference.width / 2 - floating.width / 2;
  const commonY = reference.y + reference.height / 2 - floating.height / 2;
  const commonAlign = reference[alignLength] / 2 - floating[alignLength] / 2;
  let coords;
  switch (side) {
    case 'top':
      coords = {
        x: commonX,
        y: reference.y - floating.height
      };
      break;
    case 'bottom':
      coords = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;
    case 'right':
      coords = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;
    case 'left':
      coords = {
        x: reference.x - floating.width,
        y: commonY
      };
      break;
    default:
      coords = {
        x: reference.x,
        y: reference.y
      };
  }
  switch ((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement)) {
    case 'start':
      coords[alignmentAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);
      break;
    case 'end':
      coords[alignmentAxis] += commonAlign * (rtl && isVertical ? -1 : 1);
      break;
  }
  return coords;
}

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a given reference element.
 *
 * This export does not have any `platform` interface logic. You will need to
 * write one for the platform you are using Floating UI with.
 */
const computePosition = async (reference, floating, config) => {
  const {
    placement = 'bottom',
    strategy = 'absolute',
    middleware = [],
    platform
  } = config;
  const validMiddleware = middleware.filter(Boolean);
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(floating));
  let rects = await platform.getElementRects({
    reference,
    floating,
    strategy
  });
  let {
    x,
    y
  } = computeCoordsFromPlacement(rects, placement, rtl);
  let statefulPlacement = placement;
  let middlewareData = {};
  let resetCount = 0;
  for (let i = 0; i < validMiddleware.length; i++) {
    const {
      name,
      fn
    } = validMiddleware[i];
    const {
      x: nextX,
      y: nextY,
      data,
      reset
    } = await fn({
      x,
      y,
      initialPlacement: placement,
      placement: statefulPlacement,
      strategy,
      middlewareData,
      rects,
      platform,
      elements: {
        reference,
        floating
      }
    });
    x = nextX != null ? nextX : x;
    y = nextY != null ? nextY : y;
    middlewareData = {
      ...middlewareData,
      [name]: {
        ...middlewareData[name],
        ...data
      }
    };
    if (reset && resetCount <= 50) {
      resetCount++;
      if (typeof reset === 'object') {
        if (reset.placement) {
          statefulPlacement = reset.placement;
        }
        if (reset.rects) {
          rects = reset.rects === true ? await platform.getElementRects({
            reference,
            floating,
            strategy
          }) : reset.rects;
        }
        ({
          x,
          y
        } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));
      }
      i = -1;
    }
  }
  return {
    x,
    y,
    placement: statefulPlacement,
    strategy,
    middlewareData
  };
};

/**
 * Resolves with an object of overflow side offsets that determine how much the
 * element is overflowing a given clipping boundary on each side.
 * - positive = overflowing the boundary by that number of pixels
 * - negative = how many pixels left before it will overflow
 * - 0 = lies flush with the boundary
 * @see https://floating-ui.com/docs/detectOverflow
 */
async function detectOverflow(state, options) {
  var _await$platform$isEle;
  if (options === void 0) {
    options = {};
  }
  const {
    x,
    y,
    platform,
    rects,
    elements,
    strategy
  } = state;
  const {
    boundary = 'clippingAncestors',
    rootBoundary = 'viewport',
    elementContext = 'floating',
    altBoundary = false,
    padding = 0
  } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
  const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);
  const altContext = elementContext === 'floating' ? 'reference' : 'floating';
  const element = elements[altBoundary ? altContext : elementContext];
  const clippingClientRect = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(await platform.getClippingRect({
    element: ((_await$platform$isEle = await (platform.isElement == null ? void 0 : platform.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || (await (platform.getDocumentElement == null ? void 0 : platform.getDocumentElement(elements.floating))),
    boundary,
    rootBoundary,
    strategy
  }));
  const rect = elementContext === 'floating' ? {
    x,
    y,
    width: rects.floating.width,
    height: rects.floating.height
  } : rects.reference;
  const offsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(elements.floating));
  const offsetScale = (await (platform.isElement == null ? void 0 : platform.isElement(offsetParent))) ? (await (platform.getScale == null ? void 0 : platform.getScale(offsetParent))) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  };
  const elementClientRect = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(platform.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform.convertOffsetParentRelativeRectToViewportRelativeRect({
    elements,
    rect,
    offsetParent,
    strategy
  }) : rect);
  return {
    top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,
    bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,
    left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,
    right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x
  };
}

/**
 * Provides data to position an inner element of the floating element so that it
 * appears centered to the reference element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow = options => ({
  name: 'arrow',
  options,
  async fn(state) {
    const {
      x,
      y,
      placement,
      rects,
      platform,
      elements,
      middlewareData
    } = state;
    // Since `element` is required, we don't Partial<> the type.
    const {
      element,
      padding = 0
    } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state) || {};
    if (element == null) {
      return {};
    }
    const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);
    const coords = {
      x,
      y
    };
    const axis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentAxis)(placement);
    const length = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAxisLength)(axis);
    const arrowDimensions = await platform.getDimensions(element);
    const isYAxis = axis === 'y';
    const minProp = isYAxis ? 'top' : 'left';
    const maxProp = isYAxis ? 'bottom' : 'right';
    const clientProp = isYAxis ? 'clientHeight' : 'clientWidth';
    const endDiff = rects.reference[length] + rects.reference[axis] - coords[axis] - rects.floating[length];
    const startDiff = coords[axis] - rects.reference[axis];
    const arrowOffsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(element));
    let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;

    // DOM platform can return `window` as the `offsetParent`.
    if (!clientSize || !(await (platform.isElement == null ? void 0 : platform.isElement(arrowOffsetParent)))) {
      clientSize = elements.floating[clientProp] || rects.floating[length];
    }
    const centerToReference = endDiff / 2 - startDiff / 2;

    // If the padding is large enough that it causes the arrow to no longer be
    // centered, modify the padding so that it is centered.
    const largestPossiblePadding = clientSize / 2 - arrowDimensions[length] / 2 - 1;
    const minPadding = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(paddingObject[minProp], largestPossiblePadding);
    const maxPadding = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(paddingObject[maxProp], largestPossiblePadding);

    // Make sure the arrow doesn't overflow the floating element if the center
    // point is outside the floating element's bounds.
    const min$1 = minPadding;
    const max = clientSize - arrowDimensions[length] - maxPadding;
    const center = clientSize / 2 - arrowDimensions[length] / 2 + centerToReference;
    const offset = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min$1, center, max);

    // If the reference is small enough that the arrow's padding causes it to
    // to point to nothing for an aligned placement, adjust the offset of the
    // floating element itself. To ensure `shift()` continues to take action,
    // a single reset is performed when this is true.
    const shouldAddOffset = !middlewareData.arrow && (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) != null && center !== offset && rects.reference[length] / 2 - (center < min$1 ? minPadding : maxPadding) - arrowDimensions[length] / 2 < 0;
    const alignmentOffset = shouldAddOffset ? center < min$1 ? center - min$1 : center - max : 0;
    return {
      [axis]: coords[axis] + alignmentOffset,
      data: {
        [axis]: offset,
        centerOffset: center - offset - alignmentOffset,
        ...(shouldAddOffset && {
          alignmentOffset
        })
      },
      reset: shouldAddOffset
    };
  }
});

function getPlacementList(alignment, autoAlignment, allowedPlacements) {
  const allowedPlacementsSortedByAlignment = alignment ? [...allowedPlacements.filter(placement => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) === alignment), ...allowedPlacements.filter(placement => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) !== alignment)] : allowedPlacements.filter(placement => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === placement);
  return allowedPlacementsSortedByAlignment.filter(placement => {
    if (alignment) {
      return (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) === alignment || (autoAlignment ? (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAlignmentPlacement)(placement) !== placement : false);
    }
    return true;
  });
}
/**
 * Optimizes the visibility of the floating element by choosing the placement
 * that has the most space available automatically, without needing to specify a
 * preferred placement. Alternative to `flip`.
 * @see https://floating-ui.com/docs/autoPlacement
 */
const autoPlacement = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'autoPlacement',
    options,
    async fn(state) {
      var _middlewareData$autoP, _middlewareData$autoP2, _placementsThatFitOnE;
      const {
        rects,
        middlewareData,
        placement,
        platform,
        elements
      } = state;
      const {
        crossAxis = false,
        alignment,
        allowedPlacements = _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.placements,
        autoAlignment = true,
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const placements$1 = alignment !== undefined || allowedPlacements === _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.placements ? getPlacementList(alignment || null, autoAlignment, allowedPlacements) : allowedPlacements;
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const currentIndex = ((_middlewareData$autoP = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP.index) || 0;
      const currentPlacement = placements$1[currentIndex];
      if (currentPlacement == null) {
        return {};
      }
      const alignmentSides = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentSides)(currentPlacement, rects, await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating)));

      // Make `computeCoords` start from the right place.
      if (placement !== currentPlacement) {
        return {
          reset: {
            placement: placements$1[0]
          }
        };
      }
      const currentOverflows = [overflow[(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(currentPlacement)], overflow[alignmentSides[0]], overflow[alignmentSides[1]]];
      const allOverflows = [...(((_middlewareData$autoP2 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP2.overflows) || []), {
        placement: currentPlacement,
        overflows: currentOverflows
      }];
      const nextPlacement = placements$1[currentIndex + 1];

      // There are more placements to check.
      if (nextPlacement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: nextPlacement
          }
        };
      }
      const placementsSortedByMostSpace = allOverflows.map(d => {
        const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(d.placement);
        return [d.placement, alignment && crossAxis ?
        // Check along the mainAxis and main crossAxis side.
        d.overflows.slice(0, 2).reduce((acc, v) => acc + v, 0) :
        // Check only the mainAxis.
        d.overflows[0], d.overflows];
      }).sort((a, b) => a[1] - b[1]);
      const placementsThatFitOnEachSide = placementsSortedByMostSpace.filter(d => d[2].slice(0,
      // Aligned placements should not check their opposite crossAxis
      // side.
      (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(d[0]) ? 2 : 3).every(v => v <= 0));
      const resetPlacement = ((_placementsThatFitOnE = placementsThatFitOnEachSide[0]) == null ? void 0 : _placementsThatFitOnE[0]) || placementsSortedByMostSpace[0][0];
      if (resetPlacement !== placement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: resetPlacement
          }
        };
      }
      return {};
    }
  };
};

/**
 * Optimizes the visibility of the floating element by flipping the `placement`
 * in order to keep it in view when the preferred placement(s) will overflow the
 * clipping boundary. Alternative to `autoPlacement`.
 * @see https://floating-ui.com/docs/flip
 */
const flip = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'flip',
    options,
    async fn(state) {
      var _middlewareData$arrow, _middlewareData$flip;
      const {
        placement,
        middlewareData,
        rects,
        initialPlacement,
        platform,
        elements
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true,
        fallbackPlacements: specifiedFallbackPlacements,
        fallbackStrategy = 'bestFit',
        fallbackAxisSideDirection = 'none',
        flipAlignment = true,
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);

      // If a reset by the arrow was caused due to an alignment offset being
      // added, we should skip any logic now since `flip()` has already done its
      // work.
      // https://github.com/floating-ui/floating-ui/issues/2549#issuecomment-1719601643
      if ((_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);
      const initialSideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(initialPlacement);
      const isBasePlacement = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(initialPlacement) === initialPlacement;
      const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
      const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositePlacement)(initialPlacement)] : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getExpandedPlacements)(initialPlacement));
      const hasFallbackAxisSideDirection = fallbackAxisSideDirection !== 'none';
      if (!specifiedFallbackPlacements && hasFallbackAxisSideDirection) {
        fallbackPlacements.push(...(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxisPlacements)(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));
      }
      const placements = [initialPlacement, ...fallbackPlacements];
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const overflows = [];
      let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];
      if (checkMainAxis) {
        overflows.push(overflow[side]);
      }
      if (checkCrossAxis) {
        const sides = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentSides)(placement, rects, rtl);
        overflows.push(overflow[sides[0]], overflow[sides[1]]);
      }
      overflowsData = [...overflowsData, {
        placement,
        overflows
      }];

      // One or more sides is overflowing.
      if (!overflows.every(side => side <= 0)) {
        var _middlewareData$flip2, _overflowsData$filter;
        const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;
        const nextPlacement = placements[nextIndex];
        if (nextPlacement) {
          const ignoreCrossAxisOverflow = checkCrossAxis === 'alignment' ? initialSideAxis !== (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(nextPlacement) : false;
          if (!ignoreCrossAxisOverflow ||
          // We leave the current main axis only if every placement on that axis
          // overflows the main axis.
          overflowsData.every(d => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(d.placement) === initialSideAxis ? d.overflows[0] > 0 : true)) {
            // Try next placement and re-run the lifecycle.
            return {
              data: {
                index: nextIndex,
                overflows: overflowsData
              },
              reset: {
                placement: nextPlacement
              }
            };
          }
        }

        // First, find the candidates that fit on the mainAxis side of overflow,
        // then find the placement that fits the best on the main crossAxis side.
        let resetPlacement = (_overflowsData$filter = overflowsData.filter(d => d.overflows[0] <= 0).sort((a, b) => a.overflows[1] - b.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;

        // Otherwise fallback.
        if (!resetPlacement) {
          switch (fallbackStrategy) {
            case 'bestFit':
              {
                var _overflowsData$filter2;
                const placement = (_overflowsData$filter2 = overflowsData.filter(d => {
                  if (hasFallbackAxisSideDirection) {
                    const currentSideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(d.placement);
                    return currentSideAxis === initialSideAxis ||
                    // Create a bias to the `y` side axis due to horizontal
                    // reading directions favoring greater width.
                    currentSideAxis === 'y';
                  }
                  return true;
                }).map(d => [d.placement, d.overflows.filter(overflow => overflow > 0).reduce((acc, overflow) => acc + overflow, 0)]).sort((a, b) => a[1] - b[1])[0]) == null ? void 0 : _overflowsData$filter2[0];
                if (placement) {
                  resetPlacement = placement;
                }
                break;
              }
            case 'initialPlacement':
              resetPlacement = initialPlacement;
              break;
          }
        }
        if (placement !== resetPlacement) {
          return {
            reset: {
              placement: resetPlacement
            }
          };
        }
      }
      return {};
    }
  };
};

function getSideOffsets(overflow, rect) {
  return {
    top: overflow.top - rect.height,
    right: overflow.right - rect.width,
    bottom: overflow.bottom - rect.height,
    left: overflow.left - rect.width
  };
}
function isAnySideFullyClipped(overflow) {
  return _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.sides.some(side => overflow[side] >= 0);
}
/**
 * Provides data to hide the floating element in applicable situations, such as
 * when it is not in the same clipping context as the reference element.
 * @see https://floating-ui.com/docs/hide
 */
const hide = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'hide',
    options,
    async fn(state) {
      const {
        rects
      } = state;
      const {
        strategy = 'referenceHidden',
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      switch (strategy) {
        case 'referenceHidden':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              elementContext: 'reference'
            });
            const offsets = getSideOffsets(overflow, rects.reference);
            return {
              data: {
                referenceHiddenOffsets: offsets,
                referenceHidden: isAnySideFullyClipped(offsets)
              }
            };
          }
        case 'escaped':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              altBoundary: true
            });
            const offsets = getSideOffsets(overflow, rects.floating);
            return {
              data: {
                escapedOffsets: offsets,
                escaped: isAnySideFullyClipped(offsets)
              }
            };
          }
        default:
          {
            return {};
          }
      }
    }
  };
};

function getBoundingRect(rects) {
  const minX = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...rects.map(rect => rect.left));
  const minY = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...rects.map(rect => rect.top));
  const maxX = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...rects.map(rect => rect.right));
  const maxY = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...rects.map(rect => rect.bottom));
  return {
    x: minX,
    y: minY,
    width: maxX - minX,
    height: maxY - minY
  };
}
function getRectsByLine(rects) {
  const sortedRects = rects.slice().sort((a, b) => a.y - b.y);
  const groups = [];
  let prevRect = null;
  for (let i = 0; i < sortedRects.length; i++) {
    const rect = sortedRects[i];
    if (!prevRect || rect.y - prevRect.y > prevRect.height / 2) {
      groups.push([rect]);
    } else {
      groups[groups.length - 1].push(rect);
    }
    prevRect = rect;
  }
  return groups.map(rect => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(getBoundingRect(rect)));
}
/**
 * Provides improved positioning for inline reference elements that can span
 * over multiple lines, such as hyperlinks or range selections.
 * @see https://floating-ui.com/docs/inline
 */
const inline = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'inline',
    options,
    async fn(state) {
      const {
        placement,
        elements,
        rects,
        platform,
        strategy
      } = state;
      // A MouseEvent's client{X,Y} coords can be up to 2 pixels off a
      // ClientRect's bounds, despite the event listener being triggered. A
      // padding of 2 seems to handle this issue.
      const {
        padding = 2,
        x,
        y
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const nativeClientRects = Array.from((await (platform.getClientRects == null ? void 0 : platform.getClientRects(elements.reference))) || []);
      const clientRects = getRectsByLine(nativeClientRects);
      const fallback = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(getBoundingRect(nativeClientRects));
      const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);
      function getBoundingClientRect() {
        // There are two rects and they are disjoined.
        if (clientRects.length === 2 && clientRects[0].left > clientRects[1].right && x != null && y != null) {
          // Find the first rect in which the point is fully inside.
          return clientRects.find(rect => x > rect.left - paddingObject.left && x < rect.right + paddingObject.right && y > rect.top - paddingObject.top && y < rect.bottom + paddingObject.bottom) || fallback;
        }

        // There are 2 or more connected rects.
        if (clientRects.length >= 2) {
          if ((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === 'y') {
            const firstRect = clientRects[0];
            const lastRect = clientRects[clientRects.length - 1];
            const isTop = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === 'top';
            const top = firstRect.top;
            const bottom = lastRect.bottom;
            const left = isTop ? firstRect.left : lastRect.left;
            const right = isTop ? firstRect.right : lastRect.right;
            const width = right - left;
            const height = bottom - top;
            return {
              top,
              bottom,
              left,
              right,
              width,
              height,
              x: left,
              y: top
            };
          }
          const isLeftSide = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === 'left';
          const maxRight = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...clientRects.map(rect => rect.right));
          const minLeft = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...clientRects.map(rect => rect.left));
          const measureRects = clientRects.filter(rect => isLeftSide ? rect.left === minLeft : rect.right === maxRight);
          const top = measureRects[0].top;
          const bottom = measureRects[measureRects.length - 1].bottom;
          const left = minLeft;
          const right = maxRight;
          const width = right - left;
          const height = bottom - top;
          return {
            top,
            bottom,
            left,
            right,
            width,
            height,
            x: left,
            y: top
          };
        }
        return fallback;
      }
      const resetRects = await platform.getElementRects({
        reference: {
          getBoundingClientRect
        },
        floating: elements.floating,
        strategy
      });
      if (rects.reference.x !== resetRects.reference.x || rects.reference.y !== resetRects.reference.y || rects.reference.width !== resetRects.reference.width || rects.reference.height !== resetRects.reference.height) {
        return {
          reset: {
            rects: resetRects
          }
        };
      }
      return {};
    }
  };
};

const originSides = /*#__PURE__*/new Set(['left', 'top']);

// For type backwards-compatibility, the `OffsetOptions` type was also
// Derivable.

async function convertValueToCoords(state, options) {
  const {
    placement,
    platform,
    elements
  } = state;
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
  const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);
  const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement);
  const isVertical = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === 'y';
  const mainAxisMulti = originSides.has(side) ? -1 : 1;
  const crossAxisMulti = rtl && isVertical ? -1 : 1;
  const rawValue = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);

  // eslint-disable-next-line prefer-const
  let {
    mainAxis,
    crossAxis,
    alignmentAxis
  } = typeof rawValue === 'number' ? {
    mainAxis: rawValue,
    crossAxis: 0,
    alignmentAxis: null
  } : {
    mainAxis: rawValue.mainAxis || 0,
    crossAxis: rawValue.crossAxis || 0,
    alignmentAxis: rawValue.alignmentAxis
  };
  if (alignment && typeof alignmentAxis === 'number') {
    crossAxis = alignment === 'end' ? alignmentAxis * -1 : alignmentAxis;
  }
  return isVertical ? {
    x: crossAxis * crossAxisMulti,
    y: mainAxis * mainAxisMulti
  } : {
    x: mainAxis * mainAxisMulti,
    y: crossAxis * crossAxisMulti
  };
}

/**
 * Modifies the placement by translating the floating element along the
 * specified axes.
 * A number (shorthand for `mainAxis` or distance), or an axes configuration
 * object may be passed.
 * @see https://floating-ui.com/docs/offset
 */
const offset = function (options) {
  if (options === void 0) {
    options = 0;
  }
  return {
    name: 'offset',
    options,
    async fn(state) {
      var _middlewareData$offse, _middlewareData$arrow;
      const {
        x,
        y,
        placement,
        middlewareData
      } = state;
      const diffCoords = await convertValueToCoords(state, options);

      // If the placement is the same and the arrow caused an alignment offset
      // then we don't need to change the positioning coordinates.
      if (placement === ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse.placement) && (_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      return {
        x: x + diffCoords.x,
        y: y + diffCoords.y,
        data: {
          ...diffCoords,
          placement
        }
      };
    }
  };
};

/**
 * Optimizes the visibility of the floating element by shifting it in order to
 * keep it in view when it will overflow the clipping boundary.
 * @see https://floating-ui.com/docs/shift
 */
const shift = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'shift',
    options,
    async fn(state) {
      const {
        x,
        y,
        placement
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = false,
        limiter = {
          fn: _ref => {
            let {
              x,
              y
            } = _ref;
            return {
              x,
              y
            };
          }
        },
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const coords = {
        x,
        y
      };
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const crossAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement));
      const mainAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxis)(crossAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      if (checkMainAxis) {
        const minSide = mainAxis === 'y' ? 'top' : 'left';
        const maxSide = mainAxis === 'y' ? 'bottom' : 'right';
        const min = mainAxisCoord + overflow[minSide];
        const max = mainAxisCoord - overflow[maxSide];
        mainAxisCoord = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min, mainAxisCoord, max);
      }
      if (checkCrossAxis) {
        const minSide = crossAxis === 'y' ? 'top' : 'left';
        const maxSide = crossAxis === 'y' ? 'bottom' : 'right';
        const min = crossAxisCoord + overflow[minSide];
        const max = crossAxisCoord - overflow[maxSide];
        crossAxisCoord = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min, crossAxisCoord, max);
      }
      const limitedCoords = limiter.fn({
        ...state,
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      });
      return {
        ...limitedCoords,
        data: {
          x: limitedCoords.x - x,
          y: limitedCoords.y - y,
          enabled: {
            [mainAxis]: checkMainAxis,
            [crossAxis]: checkCrossAxis
          }
        }
      };
    }
  };
};
/**
 * Built-in `limiter` that will stop `shift()` at a certain point.
 */
const limitShift = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    options,
    fn(state) {
      const {
        x,
        y,
        placement,
        rects,
        middlewareData
      } = state;
      const {
        offset = 0,
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const coords = {
        x,
        y
      };
      const crossAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement);
      const mainAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxis)(crossAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      const rawOffset = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(offset, state);
      const computedOffset = typeof rawOffset === 'number' ? {
        mainAxis: rawOffset,
        crossAxis: 0
      } : {
        mainAxis: 0,
        crossAxis: 0,
        ...rawOffset
      };
      if (checkMainAxis) {
        const len = mainAxis === 'y' ? 'height' : 'width';
        const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;
        const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;
        if (mainAxisCoord < limitMin) {
          mainAxisCoord = limitMin;
        } else if (mainAxisCoord > limitMax) {
          mainAxisCoord = limitMax;
        }
      }
      if (checkCrossAxis) {
        var _middlewareData$offse, _middlewareData$offse2;
        const len = mainAxis === 'y' ? 'width' : 'height';
        const isOriginSide = originSides.has((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement));
        const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);
        const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);
        if (crossAxisCoord < limitMin) {
          crossAxisCoord = limitMin;
        } else if (crossAxisCoord > limitMax) {
          crossAxisCoord = limitMax;
        }
      }
      return {
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      };
    }
  };
};

/**
 * Provides data that allows you to change the size of the floating element —
 * for instance, prevent it from overflowing the clipping boundary or match the
 * width of the reference element.
 * @see https://floating-ui.com/docs/size
 */
const size = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'size',
    options,
    async fn(state) {
      var _state$middlewareData, _state$middlewareData2;
      const {
        placement,
        rects,
        platform,
        elements
      } = state;
      const {
        apply = () => {},
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);
      const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement);
      const isYAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === 'y';
      const {
        width,
        height
      } = rects.floating;
      let heightSide;
      let widthSide;
      if (side === 'top' || side === 'bottom') {
        heightSide = side;
        widthSide = alignment === ((await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating))) ? 'start' : 'end') ? 'left' : 'right';
      } else {
        widthSide = side;
        heightSide = alignment === 'end' ? 'top' : 'bottom';
      }
      const maximumClippingHeight = height - overflow.top - overflow.bottom;
      const maximumClippingWidth = width - overflow.left - overflow.right;
      const overflowAvailableHeight = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(height - overflow[heightSide], maximumClippingHeight);
      const overflowAvailableWidth = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(width - overflow[widthSide], maximumClippingWidth);
      const noShift = !state.middlewareData.shift;
      let availableHeight = overflowAvailableHeight;
      let availableWidth = overflowAvailableWidth;
      if ((_state$middlewareData = state.middlewareData.shift) != null && _state$middlewareData.enabled.x) {
        availableWidth = maximumClippingWidth;
      }
      if ((_state$middlewareData2 = state.middlewareData.shift) != null && _state$middlewareData2.enabled.y) {
        availableHeight = maximumClippingHeight;
      }
      if (noShift && !alignment) {
        const xMin = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.left, 0);
        const xMax = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.right, 0);
        const yMin = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.top, 0);
        const yMax = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.bottom, 0);
        if (isYAxis) {
          availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.left, overflow.right));
        } else {
          availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.top, overflow.bottom));
        }
      }
      await apply({
        ...state,
        availableWidth,
        availableHeight
      });
      const nextDimensions = await platform.getDimensions(elements.floating);
      if (width !== nextDimensions.width || height !== nextDimensions.height) {
        return {
          reset: {
            rects: true
          }
        };
      }
      return {};
    }
  };
};




/***/ }),

/***/ "./node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrow: () => (/* binding */ arrow),
/* harmony export */   autoPlacement: () => (/* binding */ autoPlacement),
/* harmony export */   autoUpdate: () => (/* binding */ autoUpdate),
/* harmony export */   computePosition: () => (/* binding */ computePosition),
/* harmony export */   detectOverflow: () => (/* binding */ detectOverflow),
/* harmony export */   flip: () => (/* binding */ flip),
/* harmony export */   getOverflowAncestors: () => (/* reexport safe */ _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getOverflowAncestors),
/* harmony export */   hide: () => (/* binding */ hide),
/* harmony export */   inline: () => (/* binding */ inline),
/* harmony export */   limitShift: () => (/* binding */ limitShift),
/* harmony export */   offset: () => (/* binding */ offset),
/* harmony export */   platform: () => (/* binding */ platform),
/* harmony export */   shift: () => (/* binding */ shift),
/* harmony export */   size: () => (/* binding */ size)
/* harmony export */ });
/* harmony import */ var _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/utils */ "./node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs");
/* harmony import */ var _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @floating-ui/core */ "./node_modules/@floating-ui/core/dist/floating-ui.core.mjs");
/* harmony import */ var _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @floating-ui/utils/dom */ "./node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs");





function getCssDimensions(element) {
  const css = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element);
  // In testing environments, the `width` and `height` properties are empty
  // strings for SVG elements, returning NaN. Fallback to `0` in this case.
  let width = parseFloat(css.width) || 0;
  let height = parseFloat(css.height) || 0;
  const hasOffset = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(element);
  const offsetWidth = hasOffset ? element.offsetWidth : width;
  const offsetHeight = hasOffset ? element.offsetHeight : height;
  const shouldFallback = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.round)(width) !== offsetWidth || (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.round)(height) !== offsetHeight;
  if (shouldFallback) {
    width = offsetWidth;
    height = offsetHeight;
  }
  return {
    width,
    height,
    $: shouldFallback
  };
}

function unwrapElement(element) {
  return !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(element) ? element.contextElement : element;
}

function getScale(element) {
  const domElement = unwrapElement(element);
  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(domElement)) {
    return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(1);
  }
  const rect = domElement.getBoundingClientRect();
  const {
    width,
    height,
    $
  } = getCssDimensions(domElement);
  let x = ($ ? (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.round)(rect.width) : rect.width) / width;
  let y = ($ ? (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.round)(rect.height) : rect.height) / height;

  // 0, NaN, or Infinity should always fallback to 1.

  if (!x || !Number.isFinite(x)) {
    x = 1;
  }
  if (!y || !Number.isFinite(y)) {
    y = 1;
  }
  return {
    x,
    y
  };
}

const noOffsets = /*#__PURE__*/(0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);
function getVisualOffsets(element) {
  const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(element);
  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isWebKit)() || !win.visualViewport) {
    return noOffsets;
  }
  return {
    x: win.visualViewport.offsetLeft,
    y: win.visualViewport.offsetTop
  };
}
function shouldAddVisualOffsets(element, isFixed, floatingOffsetParent) {
  if (isFixed === void 0) {
    isFixed = false;
  }
  if (!floatingOffsetParent || isFixed && floatingOffsetParent !== (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(element)) {
    return false;
  }
  return isFixed;
}

function getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {
  if (includeScale === void 0) {
    includeScale = false;
  }
  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }
  const clientRect = element.getBoundingClientRect();
  const domElement = unwrapElement(element);
  let scale = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(1);
  if (includeScale) {
    if (offsetParent) {
      if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(offsetParent)) {
        scale = getScale(offsetParent);
      }
    } else {
      scale = getScale(element);
    }
  }
  const visualOffsets = shouldAddVisualOffsets(domElement, isFixedStrategy, offsetParent) ? getVisualOffsets(domElement) : (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);
  let x = (clientRect.left + visualOffsets.x) / scale.x;
  let y = (clientRect.top + visualOffsets.y) / scale.y;
  let width = clientRect.width / scale.x;
  let height = clientRect.height / scale.y;
  if (domElement) {
    const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(domElement);
    const offsetWin = offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(offsetParent) ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(offsetParent) : offsetParent;
    let currentWin = win;
    let currentIFrame = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getFrameElement)(currentWin);
    while (currentIFrame && offsetParent && offsetWin !== currentWin) {
      const iframeScale = getScale(currentIFrame);
      const iframeRect = currentIFrame.getBoundingClientRect();
      const css = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(currentIFrame);
      const left = iframeRect.left + (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;
      const top = iframeRect.top + (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;
      x *= iframeScale.x;
      y *= iframeScale.y;
      width *= iframeScale.x;
      height *= iframeScale.y;
      x += left;
      y += top;
      currentWin = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(currentIFrame);
      currentIFrame = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getFrameElement)(currentWin);
    }
  }
  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)({
    width,
    height,
    x,
    y
  });
}

// If <html> has a CSS width greater than the viewport, then this will be
// incorrect for RTL.
function getWindowScrollBarX(element, rect) {
  const leftScroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeScroll)(element).scrollLeft;
  if (!rect) {
    return getBoundingClientRect((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element)).left + leftScroll;
  }
  return rect.left + leftScroll;
}

function getHTMLOffset(documentElement, scroll) {
  const htmlRect = documentElement.getBoundingClientRect();
  const x = htmlRect.left + scroll.scrollLeft - getWindowScrollBarX(documentElement, htmlRect);
  const y = htmlRect.top + scroll.scrollTop;
  return {
    x,
    y
  };
}

function convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {
  let {
    elements,
    rect,
    offsetParent,
    strategy
  } = _ref;
  const isFixed = strategy === 'fixed';
  const documentElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(offsetParent);
  const topLayer = elements ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isTopLayer)(elements.floating) : false;
  if (offsetParent === documentElement || topLayer && isFixed) {
    return rect;
  }
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  let scale = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(1);
  const offsets = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);
  const isOffsetParentAnElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(offsetParent);
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeName)(offsetParent) !== 'body' || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isOverflowElement)(documentElement)) {
      scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeScroll)(offsetParent);
    }
    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(offsetParent)) {
      const offsetRect = getBoundingClientRect(offsetParent);
      scale = getScale(offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    }
  }
  const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll) : (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);
  return {
    width: rect.width * scale.x,
    height: rect.height * scale.y,
    x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x + htmlOffset.x,
    y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y + htmlOffset.y
  };
}

function getClientRects(element) {
  return Array.from(element.getClientRects());
}

// Gets the entire size of the scrollable document area, even extending outside
// of the `<html>` and `<body>` rect bounds if horizontally scrollable.
function getDocumentRect(element) {
  const html = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element);
  const scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeScroll)(element);
  const body = element.ownerDocument.body;
  const width = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);
  const height = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);
  let x = -scroll.scrollLeft + getWindowScrollBarX(element);
  const y = -scroll.scrollTop;
  if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(body).direction === 'rtl') {
    x += (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(html.clientWidth, body.clientWidth) - width;
  }
  return {
    width,
    height,
    x,
    y
  };
}

// Safety check: ensure the scrollbar space is reasonable in case this
// calculation is affected by unusual styles.
// Most scrollbars leave 15-18px of space.
const SCROLLBAR_MAX = 25;
function getViewportRect(element, strategy) {
  const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(element);
  const html = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element);
  const visualViewport = win.visualViewport;
  let width = html.clientWidth;
  let height = html.clientHeight;
  let x = 0;
  let y = 0;
  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    const visualViewportBased = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isWebKit)();
    if (!visualViewportBased || visualViewportBased && strategy === 'fixed') {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }
  const windowScrollbarX = getWindowScrollBarX(html);
  // <html> `overflow: hidden` + `scrollbar-gutter: stable` reduces the
  // visual width of the <html> but this is not considered in the size
  // of `html.clientWidth`.
  if (windowScrollbarX <= 0) {
    const doc = html.ownerDocument;
    const body = doc.body;
    const bodyStyles = getComputedStyle(body);
    const bodyMarginInline = doc.compatMode === 'CSS1Compat' ? parseFloat(bodyStyles.marginLeft) + parseFloat(bodyStyles.marginRight) || 0 : 0;
    const clippingStableScrollbarWidth = Math.abs(html.clientWidth - body.clientWidth - bodyMarginInline);
    if (clippingStableScrollbarWidth <= SCROLLBAR_MAX) {
      width -= clippingStableScrollbarWidth;
    }
  } else if (windowScrollbarX <= SCROLLBAR_MAX) {
    // If the <body> scrollbar is on the left, the width needs to be extended
    // by the scrollbar amount so there isn't extra space on the right.
    width += windowScrollbarX;
  }
  return {
    width,
    height,
    x,
    y
  };
}

const absoluteOrFixed = /*#__PURE__*/new Set(['absolute', 'fixed']);
// Returns the inner client rect, subtracting scrollbars if present.
function getInnerBoundingClientRect(element, strategy) {
  const clientRect = getBoundingClientRect(element, true, strategy === 'fixed');
  const top = clientRect.top + element.clientTop;
  const left = clientRect.left + element.clientLeft;
  const scale = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(element) ? getScale(element) : (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(1);
  const width = element.clientWidth * scale.x;
  const height = element.clientHeight * scale.y;
  const x = left * scale.x;
  const y = top * scale.y;
  return {
    width,
    height,
    x,
    y
  };
}
function getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {
  let rect;
  if (clippingAncestor === 'viewport') {
    rect = getViewportRect(element, strategy);
  } else if (clippingAncestor === 'document') {
    rect = getDocumentRect((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element));
  } else if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(clippingAncestor)) {
    rect = getInnerBoundingClientRect(clippingAncestor, strategy);
  } else {
    const visualOffsets = getVisualOffsets(element);
    rect = {
      x: clippingAncestor.x - visualOffsets.x,
      y: clippingAncestor.y - visualOffsets.y,
      width: clippingAncestor.width,
      height: clippingAncestor.height
    };
  }
  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(rect);
}
function hasFixedPositionAncestor(element, stopNode) {
  const parentNode = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(element);
  if (parentNode === stopNode || !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(parentNode) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isLastTraversableNode)(parentNode)) {
    return false;
  }
  return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(parentNode).position === 'fixed' || hasFixedPositionAncestor(parentNode, stopNode);
}

// A "clipping ancestor" is an `overflow` element with the characteristic of
// clipping (or hiding) child elements. This returns all clipping ancestors
// of the given element up the tree.
function getClippingElementAncestors(element, cache) {
  const cachedResult = cache.get(element);
  if (cachedResult) {
    return cachedResult;
  }
  let result = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getOverflowAncestors)(element, [], false).filter(el => (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(el) && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeName)(el) !== 'body');
  let currentContainingBlockComputedStyle = null;
  const elementIsFixed = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element).position === 'fixed';
  let currentNode = elementIsFixed ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(element) : element;

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  while ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(currentNode) && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isLastTraversableNode)(currentNode)) {
    const computedStyle = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(currentNode);
    const currentNodeIsContaining = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isContainingBlock)(currentNode);
    if (!currentNodeIsContaining && computedStyle.position === 'fixed') {
      currentContainingBlockComputedStyle = null;
    }
    const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === 'static' && !!currentContainingBlockComputedStyle && absoluteOrFixed.has(currentContainingBlockComputedStyle.position) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isOverflowElement)(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode);
    if (shouldDropCurrentNode) {
      // Drop non-containing blocks.
      result = result.filter(ancestor => ancestor !== currentNode);
    } else {
      // Record last containing block for next iteration.
      currentContainingBlockComputedStyle = computedStyle;
    }
    currentNode = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(currentNode);
  }
  cache.set(element, result);
  return result;
}

// Gets the maximum area that the element is visible in due to any number of
// clipping ancestors.
function getClippingRect(_ref) {
  let {
    element,
    boundary,
    rootBoundary,
    strategy
  } = _ref;
  const elementClippingAncestors = boundary === 'clippingAncestors' ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isTopLayer)(element) ? [] : getClippingElementAncestors(element, this._c) : [].concat(boundary);
  const clippingAncestors = [...elementClippingAncestors, rootBoundary];
  const firstClippingAncestor = clippingAncestors[0];
  const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {
    const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);
    accRect.top = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(rect.top, accRect.top);
    accRect.right = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.min)(rect.right, accRect.right);
    accRect.bottom = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.min)(rect.bottom, accRect.bottom);
    accRect.left = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));
  return {
    width: clippingRect.right - clippingRect.left,
    height: clippingRect.bottom - clippingRect.top,
    x: clippingRect.left,
    y: clippingRect.top
  };
}

function getDimensions(element) {
  const {
    width,
    height
  } = getCssDimensions(element);
  return {
    width,
    height
  };
}

function getRectRelativeToOffsetParent(element, offsetParent, strategy) {
  const isOffsetParentAnElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(offsetParent);
  const documentElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(offsetParent);
  const isFixed = strategy === 'fixed';
  const rect = getBoundingClientRect(element, true, isFixed, offsetParent);
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const offsets = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);

  // If the <body> scrollbar appears on the left (e.g. RTL systems). Use
  // Firefox with layout.scrollbar.side = 3 in about:config to test this.
  function setLeftRTLScrollbarOffset() {
    offsets.x = getWindowScrollBarX(documentElement);
  }
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeName)(offsetParent) !== 'body' || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isOverflowElement)(documentElement)) {
      scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeScroll)(offsetParent);
    }
    if (isOffsetParentAnElement) {
      const offsetRect = getBoundingClientRect(offsetParent, true, isFixed, offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    } else if (documentElement) {
      setLeftRTLScrollbarOffset();
    }
  }
  if (isFixed && !isOffsetParentAnElement && documentElement) {
    setLeftRTLScrollbarOffset();
  }
  const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll) : (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);
  const x = rect.left + scroll.scrollLeft - offsets.x - htmlOffset.x;
  const y = rect.top + scroll.scrollTop - offsets.y - htmlOffset.y;
  return {
    x,
    y,
    width: rect.width,
    height: rect.height
  };
}

function isStaticPositioned(element) {
  return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element).position === 'static';
}

function getTrueOffsetParent(element, polyfill) {
  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(element) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element).position === 'fixed') {
    return null;
  }
  if (polyfill) {
    return polyfill(element);
  }
  let rawOffsetParent = element.offsetParent;

  // Firefox returns the <html> element as the offsetParent if it's non-static,
  // while Chrome and Safari return the <body> element. The <body> element must
  // be used to perform the correct calculations even if the <html> element is
  // non-static.
  if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element) === rawOffsetParent) {
    rawOffsetParent = rawOffsetParent.ownerDocument.body;
  }
  return rawOffsetParent;
}

// Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.
function getOffsetParent(element, polyfill) {
  const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(element);
  if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isTopLayer)(element)) {
    return win;
  }
  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(element)) {
    let svgOffsetParent = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(element);
    while (svgOffsetParent && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isLastTraversableNode)(svgOffsetParent)) {
      if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(svgOffsetParent) && !isStaticPositioned(svgOffsetParent)) {
        return svgOffsetParent;
      }
      svgOffsetParent = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(svgOffsetParent);
    }
    return win;
  }
  let offsetParent = getTrueOffsetParent(element, polyfill);
  while (offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isTableElement)(offsetParent) && isStaticPositioned(offsetParent)) {
    offsetParent = getTrueOffsetParent(offsetParent, polyfill);
  }
  if (offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isLastTraversableNode)(offsetParent) && isStaticPositioned(offsetParent) && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isContainingBlock)(offsetParent)) {
    return win;
  }
  return offsetParent || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getContainingBlock)(element) || win;
}

const getElementRects = async function (data) {
  const getOffsetParentFn = this.getOffsetParent || getOffsetParent;
  const getDimensionsFn = this.getDimensions;
  const floatingDimensions = await getDimensionsFn(data.floating);
  return {
    reference: getRectRelativeToOffsetParent(data.reference, await getOffsetParentFn(data.floating), data.strategy),
    floating: {
      x: 0,
      y: 0,
      width: floatingDimensions.width,
      height: floatingDimensions.height
    }
  };
};

function isRTL(element) {
  return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element).direction === 'rtl';
}

const platform = {
  convertOffsetParentRelativeRectToViewportRelativeRect,
  getDocumentElement: _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement,
  getClippingRect,
  getOffsetParent,
  getElementRects,
  getClientRects,
  getDimensions,
  getScale,
  isElement: _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement,
  isRTL
};

function rectsAreEqual(a, b) {
  return a.x === b.x && a.y === b.y && a.width === b.width && a.height === b.height;
}

// https://samthor.au/2021/observing-dom/
function observeMove(element, onMove) {
  let io = null;
  let timeoutId;
  const root = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element);
  function cleanup() {
    var _io;
    clearTimeout(timeoutId);
    (_io = io) == null || _io.disconnect();
    io = null;
  }
  function refresh(skip, threshold) {
    if (skip === void 0) {
      skip = false;
    }
    if (threshold === void 0) {
      threshold = 1;
    }
    cleanup();
    const elementRectForRootMargin = element.getBoundingClientRect();
    const {
      left,
      top,
      width,
      height
    } = elementRectForRootMargin;
    if (!skip) {
      onMove();
    }
    if (!width || !height) {
      return;
    }
    const insetTop = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.floor)(top);
    const insetRight = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.floor)(root.clientWidth - (left + width));
    const insetBottom = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.floor)(root.clientHeight - (top + height));
    const insetLeft = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.floor)(left);
    const rootMargin = -insetTop + "px " + -insetRight + "px " + -insetBottom + "px " + -insetLeft + "px";
    const options = {
      rootMargin,
      threshold: (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(0, (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.min)(1, threshold)) || 1
    };
    let isFirstUpdate = true;
    function handleObserve(entries) {
      const ratio = entries[0].intersectionRatio;
      if (ratio !== threshold) {
        if (!isFirstUpdate) {
          return refresh();
        }
        if (!ratio) {
          // If the reference is clipped, the ratio is 0. Throttle the refresh
          // to prevent an infinite loop of updates.
          timeoutId = setTimeout(() => {
            refresh(false, 1e-7);
          }, 1000);
        } else {
          refresh(false, ratio);
        }
      }
      if (ratio === 1 && !rectsAreEqual(elementRectForRootMargin, element.getBoundingClientRect())) {
        // It's possible that even though the ratio is reported as 1, the
        // element is not actually fully within the IntersectionObserver's root
        // area anymore. This can happen under performance constraints. This may
        // be a bug in the browser's IntersectionObserver implementation. To
        // work around this, we compare the element's bounding rect now with
        // what it was at the time we created the IntersectionObserver. If they
        // are not equal then the element moved, so we refresh.
        refresh();
      }
      isFirstUpdate = false;
    }

    // Older browsers don't support a `document` as the root and will throw an
    // error.
    try {
      io = new IntersectionObserver(handleObserve, {
        ...options,
        // Handle <iframe>s
        root: root.ownerDocument
      });
    } catch (_e) {
      io = new IntersectionObserver(handleObserve, options);
    }
    io.observe(element);
  }
  refresh(true);
  return cleanup;
}

/**
 * Automatically updates the position of the floating element when necessary.
 * Should only be called when the floating element is mounted on the DOM or
 * visible on the screen.
 * @returns cleanup function that should be invoked when the floating element is
 * removed from the DOM or hidden from the screen.
 * @see https://floating-ui.com/docs/autoUpdate
 */
function autoUpdate(reference, floating, update, options) {
  if (options === void 0) {
    options = {};
  }
  const {
    ancestorScroll = true,
    ancestorResize = true,
    elementResize = typeof ResizeObserver === 'function',
    layoutShift = typeof IntersectionObserver === 'function',
    animationFrame = false
  } = options;
  const referenceEl = unwrapElement(reference);
  const ancestors = ancestorScroll || ancestorResize ? [...(referenceEl ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getOverflowAncestors)(referenceEl) : []), ...(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getOverflowAncestors)(floating)] : [];
  ancestors.forEach(ancestor => {
    ancestorScroll && ancestor.addEventListener('scroll', update, {
      passive: true
    });
    ancestorResize && ancestor.addEventListener('resize', update);
  });
  const cleanupIo = referenceEl && layoutShift ? observeMove(referenceEl, update) : null;
  let reobserveFrame = -1;
  let resizeObserver = null;
  if (elementResize) {
    resizeObserver = new ResizeObserver(_ref => {
      let [firstEntry] = _ref;
      if (firstEntry && firstEntry.target === referenceEl && resizeObserver) {
        // Prevent update loops when using the `size` middleware.
        // https://github.com/floating-ui/floating-ui/issues/1740
        resizeObserver.unobserve(floating);
        cancelAnimationFrame(reobserveFrame);
        reobserveFrame = requestAnimationFrame(() => {
          var _resizeObserver;
          (_resizeObserver = resizeObserver) == null || _resizeObserver.observe(floating);
        });
      }
      update();
    });
    if (referenceEl && !animationFrame) {
      resizeObserver.observe(referenceEl);
    }
    resizeObserver.observe(floating);
  }
  let frameId;
  let prevRefRect = animationFrame ? getBoundingClientRect(reference) : null;
  if (animationFrame) {
    frameLoop();
  }
  function frameLoop() {
    const nextRefRect = getBoundingClientRect(reference);
    if (prevRefRect && !rectsAreEqual(prevRefRect, nextRefRect)) {
      update();
    }
    prevRefRect = nextRefRect;
    frameId = requestAnimationFrame(frameLoop);
  }
  update();
  return () => {
    var _resizeObserver2;
    ancestors.forEach(ancestor => {
      ancestorScroll && ancestor.removeEventListener('scroll', update);
      ancestorResize && ancestor.removeEventListener('resize', update);
    });
    cleanupIo == null || cleanupIo();
    (_resizeObserver2 = resizeObserver) == null || _resizeObserver2.disconnect();
    resizeObserver = null;
    if (animationFrame) {
      cancelAnimationFrame(frameId);
    }
  };
}

/**
 * Resolves with an object of overflow side offsets that determine how much the
 * element is overflowing a given clipping boundary on each side.
 * - positive = overflowing the boundary by that number of pixels
 * - negative = how many pixels left before it will overflow
 * - 0 = lies flush with the boundary
 * @see https://floating-ui.com/docs/detectOverflow
 */
const detectOverflow = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.detectOverflow;

/**
 * Modifies the placement by translating the floating element along the
 * specified axes.
 * A number (shorthand for `mainAxis` or distance), or an axes configuration
 * object may be passed.
 * @see https://floating-ui.com/docs/offset
 */
const offset = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.offset;

/**
 * Optimizes the visibility of the floating element by choosing the placement
 * that has the most space available automatically, without needing to specify a
 * preferred placement. Alternative to `flip`.
 * @see https://floating-ui.com/docs/autoPlacement
 */
const autoPlacement = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.autoPlacement;

/**
 * Optimizes the visibility of the floating element by shifting it in order to
 * keep it in view when it will overflow the clipping boundary.
 * @see https://floating-ui.com/docs/shift
 */
const shift = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.shift;

/**
 * Optimizes the visibility of the floating element by flipping the `placement`
 * in order to keep it in view when the preferred placement(s) will overflow the
 * clipping boundary. Alternative to `autoPlacement`.
 * @see https://floating-ui.com/docs/flip
 */
const flip = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.flip;

/**
 * Provides data that allows you to change the size of the floating element —
 * for instance, prevent it from overflowing the clipping boundary or match the
 * width of the reference element.
 * @see https://floating-ui.com/docs/size
 */
const size = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.size;

/**
 * Provides data to hide the floating element in applicable situations, such as
 * when it is not in the same clipping context as the reference element.
 * @see https://floating-ui.com/docs/hide
 */
const hide = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.hide;

/**
 * Provides data to position an inner element of the floating element so that it
 * appears centered to the reference element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.arrow;

/**
 * Provides improved positioning for inline reference elements that can span
 * over multiple lines, such as hyperlinks or range selections.
 * @see https://floating-ui.com/docs/inline
 */
const inline = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.inline;

/**
 * Built-in `limiter` that will stop `shift()` at a certain point.
 */
const limitShift = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.limitShift;

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a given reference element.
 */
const computePosition = (reference, floating, options) => {
  // This caches the expensive `getClippingElementAncestors` function so that
  // multiple lifecycle resets re-use the same result. It only lives for a
  // single call. If other functions become expensive, we can add them as well.
  const cache = new Map();
  const mergedOptions = {
    platform,
    ...options
  };
  const platformWithCache = {
    ...mergedOptions.platform,
    _c: cache
  };
  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.computePosition)(reference, floating, {
    ...mergedOptions,
    platform: platformWithCache
  });
};




/***/ }),

/***/ "./node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs":
/*!************************************************************************!*\
  !*** ./node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getComputedStyle: () => (/* binding */ getComputedStyle),
/* harmony export */   getContainingBlock: () => (/* binding */ getContainingBlock),
/* harmony export */   getDocumentElement: () => (/* binding */ getDocumentElement),
/* harmony export */   getFrameElement: () => (/* binding */ getFrameElement),
/* harmony export */   getNearestOverflowAncestor: () => (/* binding */ getNearestOverflowAncestor),
/* harmony export */   getNodeName: () => (/* binding */ getNodeName),
/* harmony export */   getNodeScroll: () => (/* binding */ getNodeScroll),
/* harmony export */   getOverflowAncestors: () => (/* binding */ getOverflowAncestors),
/* harmony export */   getParentNode: () => (/* binding */ getParentNode),
/* harmony export */   getWindow: () => (/* binding */ getWindow),
/* harmony export */   isContainingBlock: () => (/* binding */ isContainingBlock),
/* harmony export */   isElement: () => (/* binding */ isElement),
/* harmony export */   isHTMLElement: () => (/* binding */ isHTMLElement),
/* harmony export */   isLastTraversableNode: () => (/* binding */ isLastTraversableNode),
/* harmony export */   isNode: () => (/* binding */ isNode),
/* harmony export */   isOverflowElement: () => (/* binding */ isOverflowElement),
/* harmony export */   isShadowRoot: () => (/* binding */ isShadowRoot),
/* harmony export */   isTableElement: () => (/* binding */ isTableElement),
/* harmony export */   isTopLayer: () => (/* binding */ isTopLayer),
/* harmony export */   isWebKit: () => (/* binding */ isWebKit)
/* harmony export */ });
function hasWindow() {
  return typeof window !== 'undefined';
}
function getNodeName(node) {
  if (isNode(node)) {
    return (node.nodeName || '').toLowerCase();
  }
  // Mocked nodes in testing environments may not be instances of Node. By
  // returning `#document` an infinite loop won't occur.
  // https://github.com/floating-ui/floating-ui/issues/2317
  return '#document';
}
function getWindow(node) {
  var _node$ownerDocument;
  return (node == null || (_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
}
function getDocumentElement(node) {
  var _ref;
  return (_ref = (isNode(node) ? node.ownerDocument : node.document) || window.document) == null ? void 0 : _ref.documentElement;
}
function isNode(value) {
  if (!hasWindow()) {
    return false;
  }
  return value instanceof Node || value instanceof getWindow(value).Node;
}
function isElement(value) {
  if (!hasWindow()) {
    return false;
  }
  return value instanceof Element || value instanceof getWindow(value).Element;
}
function isHTMLElement(value) {
  if (!hasWindow()) {
    return false;
  }
  return value instanceof HTMLElement || value instanceof getWindow(value).HTMLElement;
}
function isShadowRoot(value) {
  if (!hasWindow() || typeof ShadowRoot === 'undefined') {
    return false;
  }
  return value instanceof ShadowRoot || value instanceof getWindow(value).ShadowRoot;
}
const invalidOverflowDisplayValues = /*#__PURE__*/new Set(['inline', 'contents']);
function isOverflowElement(element) {
  const {
    overflow,
    overflowX,
    overflowY,
    display
  } = getComputedStyle(element);
  return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !invalidOverflowDisplayValues.has(display);
}
const tableElements = /*#__PURE__*/new Set(['table', 'td', 'th']);
function isTableElement(element) {
  return tableElements.has(getNodeName(element));
}
const topLayerSelectors = [':popover-open', ':modal'];
function isTopLayer(element) {
  return topLayerSelectors.some(selector => {
    try {
      return element.matches(selector);
    } catch (_e) {
      return false;
    }
  });
}
const transformProperties = ['transform', 'translate', 'scale', 'rotate', 'perspective'];
const willChangeValues = ['transform', 'translate', 'scale', 'rotate', 'perspective', 'filter'];
const containValues = ['paint', 'layout', 'strict', 'content'];
function isContainingBlock(elementOrCss) {
  const webkit = isWebKit();
  const css = isElement(elementOrCss) ? getComputedStyle(elementOrCss) : elementOrCss;

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  // https://drafts.csswg.org/css-transforms-2/#individual-transforms
  return transformProperties.some(value => css[value] ? css[value] !== 'none' : false) || (css.containerType ? css.containerType !== 'normal' : false) || !webkit && (css.backdropFilter ? css.backdropFilter !== 'none' : false) || !webkit && (css.filter ? css.filter !== 'none' : false) || willChangeValues.some(value => (css.willChange || '').includes(value)) || containValues.some(value => (css.contain || '').includes(value));
}
function getContainingBlock(element) {
  let currentNode = getParentNode(element);
  while (isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)) {
    if (isContainingBlock(currentNode)) {
      return currentNode;
    } else if (isTopLayer(currentNode)) {
      return null;
    }
    currentNode = getParentNode(currentNode);
  }
  return null;
}
function isWebKit() {
  if (typeof CSS === 'undefined' || !CSS.supports) return false;
  return CSS.supports('-webkit-backdrop-filter', 'none');
}
const lastTraversableNodeNames = /*#__PURE__*/new Set(['html', 'body', '#document']);
function isLastTraversableNode(node) {
  return lastTraversableNodeNames.has(getNodeName(node));
}
function getComputedStyle(element) {
  return getWindow(element).getComputedStyle(element);
}
function getNodeScroll(element) {
  if (isElement(element)) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }
  return {
    scrollLeft: element.scrollX,
    scrollTop: element.scrollY
  };
}
function getParentNode(node) {
  if (getNodeName(node) === 'html') {
    return node;
  }
  const result =
  // Step into the shadow DOM of the parent of a slotted node.
  node.assignedSlot ||
  // DOM Element detected.
  node.parentNode ||
  // ShadowRoot detected.
  isShadowRoot(node) && node.host ||
  // Fallback.
  getDocumentElement(node);
  return isShadowRoot(result) ? result.host : result;
}
function getNearestOverflowAncestor(node) {
  const parentNode = getParentNode(node);
  if (isLastTraversableNode(parentNode)) {
    return node.ownerDocument ? node.ownerDocument.body : node.body;
  }
  if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {
    return parentNode;
  }
  return getNearestOverflowAncestor(parentNode);
}
function getOverflowAncestors(node, list, traverseIframes) {
  var _node$ownerDocument2;
  if (list === void 0) {
    list = [];
  }
  if (traverseIframes === void 0) {
    traverseIframes = true;
  }
  const scrollableAncestor = getNearestOverflowAncestor(node);
  const isBody = scrollableAncestor === ((_node$ownerDocument2 = node.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);
  const win = getWindow(scrollableAncestor);
  if (isBody) {
    const frameElement = getFrameElement(win);
    return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], frameElement && traverseIframes ? getOverflowAncestors(frameElement) : []);
  }
  return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));
}
function getFrameElement(win) {
  return win.parent && Object.getPrototypeOf(win.parent) ? win.frameElement : null;
}




/***/ }),

/***/ "./node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs":
/*!********************************************************************!*\
  !*** ./node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   alignments: () => (/* binding */ alignments),
/* harmony export */   clamp: () => (/* binding */ clamp),
/* harmony export */   createCoords: () => (/* binding */ createCoords),
/* harmony export */   evaluate: () => (/* binding */ evaluate),
/* harmony export */   expandPaddingObject: () => (/* binding */ expandPaddingObject),
/* harmony export */   floor: () => (/* binding */ floor),
/* harmony export */   getAlignment: () => (/* binding */ getAlignment),
/* harmony export */   getAlignmentAxis: () => (/* binding */ getAlignmentAxis),
/* harmony export */   getAlignmentSides: () => (/* binding */ getAlignmentSides),
/* harmony export */   getAxisLength: () => (/* binding */ getAxisLength),
/* harmony export */   getExpandedPlacements: () => (/* binding */ getExpandedPlacements),
/* harmony export */   getOppositeAlignmentPlacement: () => (/* binding */ getOppositeAlignmentPlacement),
/* harmony export */   getOppositeAxis: () => (/* binding */ getOppositeAxis),
/* harmony export */   getOppositeAxisPlacements: () => (/* binding */ getOppositeAxisPlacements),
/* harmony export */   getOppositePlacement: () => (/* binding */ getOppositePlacement),
/* harmony export */   getPaddingObject: () => (/* binding */ getPaddingObject),
/* harmony export */   getSide: () => (/* binding */ getSide),
/* harmony export */   getSideAxis: () => (/* binding */ getSideAxis),
/* harmony export */   max: () => (/* binding */ max),
/* harmony export */   min: () => (/* binding */ min),
/* harmony export */   placements: () => (/* binding */ placements),
/* harmony export */   rectToClientRect: () => (/* binding */ rectToClientRect),
/* harmony export */   round: () => (/* binding */ round),
/* harmony export */   sides: () => (/* binding */ sides)
/* harmony export */ });
/**
 * Custom positioning reference element.
 * @see https://floating-ui.com/docs/virtual-elements
 */

const sides = ['top', 'right', 'bottom', 'left'];
const alignments = ['start', 'end'];
const placements = /*#__PURE__*/sides.reduce((acc, side) => acc.concat(side, side + "-" + alignments[0], side + "-" + alignments[1]), []);
const min = Math.min;
const max = Math.max;
const round = Math.round;
const floor = Math.floor;
const createCoords = v => ({
  x: v,
  y: v
});
const oppositeSideMap = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
const oppositeAlignmentMap = {
  start: 'end',
  end: 'start'
};
function clamp(start, value, end) {
  return max(start, min(value, end));
}
function evaluate(value, param) {
  return typeof value === 'function' ? value(param) : value;
}
function getSide(placement) {
  return placement.split('-')[0];
}
function getAlignment(placement) {
  return placement.split('-')[1];
}
function getOppositeAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}
function getAxisLength(axis) {
  return axis === 'y' ? 'height' : 'width';
}
const yAxisSides = /*#__PURE__*/new Set(['top', 'bottom']);
function getSideAxis(placement) {
  return yAxisSides.has(getSide(placement)) ? 'y' : 'x';
}
function getAlignmentAxis(placement) {
  return getOppositeAxis(getSideAxis(placement));
}
function getAlignmentSides(placement, rects, rtl) {
  if (rtl === void 0) {
    rtl = false;
  }
  const alignment = getAlignment(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const length = getAxisLength(alignmentAxis);
  let mainAlignmentSide = alignmentAxis === 'x' ? alignment === (rtl ? 'end' : 'start') ? 'right' : 'left' : alignment === 'start' ? 'bottom' : 'top';
  if (rects.reference[length] > rects.floating[length]) {
    mainAlignmentSide = getOppositePlacement(mainAlignmentSide);
  }
  return [mainAlignmentSide, getOppositePlacement(mainAlignmentSide)];
}
function getExpandedPlacements(placement) {
  const oppositePlacement = getOppositePlacement(placement);
  return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];
}
function getOppositeAlignmentPlacement(placement) {
  return placement.replace(/start|end/g, alignment => oppositeAlignmentMap[alignment]);
}
const lrPlacement = ['left', 'right'];
const rlPlacement = ['right', 'left'];
const tbPlacement = ['top', 'bottom'];
const btPlacement = ['bottom', 'top'];
function getSideList(side, isStart, rtl) {
  switch (side) {
    case 'top':
    case 'bottom':
      if (rtl) return isStart ? rlPlacement : lrPlacement;
      return isStart ? lrPlacement : rlPlacement;
    case 'left':
    case 'right':
      return isStart ? tbPlacement : btPlacement;
    default:
      return [];
  }
}
function getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {
  const alignment = getAlignment(placement);
  let list = getSideList(getSide(placement), direction === 'start', rtl);
  if (alignment) {
    list = list.map(side => side + "-" + alignment);
    if (flipAlignment) {
      list = list.concat(list.map(getOppositeAlignmentPlacement));
    }
  }
  return list;
}
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, side => oppositeSideMap[side]);
}
function expandPaddingObject(padding) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...padding
  };
}
function getPaddingObject(padding) {
  return typeof padding !== 'number' ? expandPaddingObject(padding) : {
    top: padding,
    right: padding,
    bottom: padding,
    left: padding
  };
}
function rectToClientRect(rect) {
  const {
    x,
    y,
    width,
    height
  } = rect;
  return {
    width,
    height,
    top: y,
    left: x,
    right: x + width,
    bottom: y + height,
    x,
    y
  };
}




/***/ }),

/***/ "./node_modules/@tannin/compile/index.js":
/*!***********************************************!*\
  !*** ./node_modules/@tannin/compile/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ compile)
/* harmony export */ });
/* harmony import */ var _tannin_postfix__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tannin/postfix */ "./node_modules/@tannin/postfix/index.js");
/* harmony import */ var _tannin_evaluate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @tannin/evaluate */ "./node_modules/@tannin/evaluate/index.js");



/**
 * Given a C expression, returns a function which can be called to evaluate its
 * result.
 *
 * @example
 *
 * ```js
 * import compile from '@tannin/compile';
 *
 * const evaluate = compile( 'n > 1' );
 *
 * evaluate( { n: 2 } );
 * // ⇒ true
 * ```
 *
 * @param {string} expression C expression.
 *
 * @return {(variables?:{[variable:string]:*})=>*} Compiled evaluator.
 */
function compile( expression ) {
	var terms = (0,_tannin_postfix__WEBPACK_IMPORTED_MODULE_0__["default"])( expression );

	return function( variables ) {
		return (0,_tannin_evaluate__WEBPACK_IMPORTED_MODULE_1__["default"])( terms, variables );
	};
}


/***/ }),

/***/ "./node_modules/@tannin/evaluate/index.js":
/*!************************************************!*\
  !*** ./node_modules/@tannin/evaluate/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ evaluate)
/* harmony export */ });
/**
 * Operator callback functions.
 *
 * @type {Object}
 */
var OPERATORS = {
	'!': function( a ) {
		return ! a;
	},
	'*': function( a, b ) {
		return a * b;
	},
	'/': function( a, b ) {
		return a / b;
	},
	'%': function( a, b ) {
		return a % b;
	},
	'+': function( a, b ) {
		return a + b;
	},
	'-': function( a, b ) {
		return a - b;
	},
	'<': function( a, b ) {
		return a < b;
	},
	'<=': function( a, b ) {
		return a <= b;
	},
	'>': function( a, b ) {
		return a > b;
	},
	'>=': function( a, b ) {
		return a >= b;
	},
	'==': function( a, b ) {
		return a === b;
	},
	'!=': function( a, b ) {
		return a !== b;
	},
	'&&': function( a, b ) {
		return a && b;
	},
	'||': function( a, b ) {
		return a || b;
	},
	'?:': function( a, b, c ) {
		if ( a ) {
			throw b;
		}

		return c;
	},
};

/**
 * Given an array of postfix terms and operand variables, returns the result of
 * the postfix evaluation.
 *
 * @example
 *
 * ```js
 * import evaluate from '@tannin/evaluate';
 *
 * // 3 + 4 * 5 / 6 ⇒ '3 4 5 * 6 / +'
 * const terms = [ '3', '4', '5', '*', '6', '/', '+' ];
 *
 * evaluate( terms, {} );
 * // ⇒ 6.333333333333334
 * ```
 *
 * @param {string[]} postfix   Postfix terms.
 * @param {Object}   variables Operand variables.
 *
 * @return {*} Result of evaluation.
 */
function evaluate( postfix, variables ) {
	var stack = [],
		i, j, args, getOperatorResult, term, value;

	for ( i = 0; i < postfix.length; i++ ) {
		term = postfix[ i ];

		getOperatorResult = OPERATORS[ term ];
		if ( getOperatorResult ) {
			// Pop from stack by number of function arguments.
			j = getOperatorResult.length;
			args = Array( j );
			while ( j-- ) {
				args[ j ] = stack.pop();
			}

			try {
				value = getOperatorResult.apply( null, args );
			} catch ( earlyReturn ) {
				return earlyReturn;
			}
		} else if ( variables.hasOwnProperty( term ) ) {
			value = variables[ term ];
		} else {
			value = +term;
		}

		stack.push( value );
	}

	return stack[ 0 ];
}


/***/ }),

/***/ "./node_modules/@tannin/plural-forms/index.js":
/*!****************************************************!*\
  !*** ./node_modules/@tannin/plural-forms/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ pluralForms)
/* harmony export */ });
/* harmony import */ var _tannin_compile__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tannin/compile */ "./node_modules/@tannin/compile/index.js");


/**
 * Given a C expression, returns a function which, when called with a value,
 * evaluates the result with the value assumed to be the "n" variable of the
 * expression. The result will be coerced to its numeric equivalent.
 *
 * @param {string} expression C expression.
 *
 * @return {Function} Evaluator function.
 */
function pluralForms( expression ) {
	var evaluate = (0,_tannin_compile__WEBPACK_IMPORTED_MODULE_0__["default"])( expression );

	return function( n ) {
		return +evaluate( { n: n } );
	};
}


/***/ }),

/***/ "./node_modules/@tannin/postfix/index.js":
/*!***********************************************!*\
  !*** ./node_modules/@tannin/postfix/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ postfix)
/* harmony export */ });
var PRECEDENCE, OPENERS, TERMINATORS, PATTERN;

/**
 * Operator precedence mapping.
 *
 * @type {Object}
 */
PRECEDENCE = {
	'(': 9,
	'!': 8,
	'*': 7,
	'/': 7,
	'%': 7,
	'+': 6,
	'-': 6,
	'<': 5,
	'<=': 5,
	'>': 5,
	'>=': 5,
	'==': 4,
	'!=': 4,
	'&&': 3,
	'||': 2,
	'?': 1,
	'?:': 1,
};

/**
 * Characters which signal pair opening, to be terminated by terminators.
 *
 * @type {string[]}
 */
OPENERS = [ '(', '?' ];

/**
 * Characters which signal pair termination, the value an array with the
 * opener as its first member. The second member is an optional operator
 * replacement to push to the stack.
 *
 * @type {string[]}
 */
TERMINATORS = {
	')': [ '(' ],
	':': [ '?', '?:' ],
};

/**
 * Pattern matching operators and openers.
 *
 * @type {RegExp}
 */
PATTERN = /<=|>=|==|!=|&&|\|\||\?:|\(|!|\*|\/|%|\+|-|<|>|\?|\)|:/;

/**
 * Given a C expression, returns the equivalent postfix (Reverse Polish)
 * notation terms as an array.
 *
 * If a postfix string is desired, simply `.join( ' ' )` the result.
 *
 * @example
 *
 * ```js
 * import postfix from '@tannin/postfix';
 *
 * postfix( 'n > 1' );
 * // ⇒ [ 'n', '1', '>' ]
 * ```
 *
 * @param {string} expression C expression.
 *
 * @return {string[]} Postfix terms.
 */
function postfix( expression ) {
	var terms = [],
		stack = [],
		match, operator, term, element;

	while ( ( match = expression.match( PATTERN ) ) ) {
		operator = match[ 0 ];

		// Term is the string preceding the operator match. It may contain
		// whitespace, and may be empty (if operator is at beginning).
		term = expression.substr( 0, match.index ).trim();
		if ( term ) {
			terms.push( term );
		}

		while ( ( element = stack.pop() ) ) {
			if ( TERMINATORS[ operator ] ) {
				if ( TERMINATORS[ operator ][ 0 ] === element ) {
					// Substitution works here under assumption that because
					// the assigned operator will no longer be a terminator, it
					// will be pushed to the stack during the condition below.
					operator = TERMINATORS[ operator ][ 1 ] || operator;
					break;
				}
			} else if ( OPENERS.indexOf( element ) >= 0 || PRECEDENCE[ element ] < PRECEDENCE[ operator ] ) {
				// Push to stack if either an opener or when pop reveals an
				// element of lower precedence.
				stack.push( element );
				break;
			}

			// For each popped from stack, push to terms.
			terms.push( element );
		}

		if ( ! TERMINATORS[ operator ] ) {
			stack.push( operator );
		}

		// Slice matched fragment from expression to continue match.
		expression = expression.substr( match.index + operator.length );
	}

	// Push remainder of operand, if exists, to terms.
	expression = expression.trim();
	if ( expression ) {
		terms.push( expression );
	}

	// Pop remaining items from stack into terms.
	return terms.concat( stack.reverse() );
}


/***/ }),

/***/ "./node_modules/@tannin/sprintf/src/index.js":
/*!***************************************************!*\
  !*** ./node_modules/@tannin/sprintf/src/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ sprintf)
/* harmony export */ });
/**
 * Regular expression matching format placeholder syntax.
 *
 * The pattern for matching named arguments is a naive and incomplete matcher
 * against valid JavaScript identifier names.
 *
 * via Mathias Bynens:
 *
 * >An identifier must start with $, _, or any character in the Unicode
 * >categories “Uppercase letter (Lu)”, “Lowercase letter (Ll)”, “Titlecase
 * >letter (Lt)”, “Modifier letter (Lm)”, “Other letter (Lo)”, or “Letter
 * >number (Nl)”.
 * >
 * >The rest of the string can contain the same characters, plus any U+200C zero
 * >width non-joiner characters, U+200D zero width joiner characters, and
 * >characters in the Unicode categories “Non-spacing mark (Mn)”, “Spacing
 * >combining mark (Mc)”, “Decimal digit number (Nd)”, or “Connector
 * >punctuation (Pc)”.
 *
 * If browser support is constrained to those supporting ES2015, this could be
 * made more accurate using the `u` flag:
 *
 * ```
 * /^[$_\p{L}\p{Nl}][$_\p{L}\p{Nl}\u200C\u200D\p{Mn}\p{Mc}\p{Nd}\p{Pc}]*$/u;
 * ```
 *
 * @see http://www.pixelbeat.org/programming/gcc/format_specs.html
 * @see https://mathiasbynens.be/notes/javascript-identifiers#valid-identifier-names
 *
 * @type {RegExp}
 */
var PATTERN =
	/%(((\d+)\$)|(\(([$_a-zA-Z][$_a-zA-Z0-9]*)\)))?[ +0#-]*\d*(\.(\d+|\*))?(ll|[lhqL])?([cduxXefgsp%])/g;
//               ▲         ▲                    ▲       ▲  ▲            ▲           ▲ type
//               │         │                    │       │  │            └ Length (unsupported)
//               │         │                    │       │  └ Precision / max width
//               │         │                    │       └ Min width (unsupported)
//               │         │                    └ Flags (unsupported)
//               └ Index   └ Name (for named arguments)
/**
 * Given a format string, returns string with arguments interpolatation.
 * Arguments can either be provided directly via function arguments spread, or
 * with an array as the second argument.
 *
 * @see https://en.wikipedia.org/wiki/Printf_format_string
 *
 * @example
 *
 * ```js
 * import sprintf from '@tannin/sprintf';
 *
 * sprintf( 'Hello %s!', 'world' );
 * // ⇒ 'Hello world!'
 * ```
 * @template {string} T
 * @overload
 * @param {T} string - string printf format string
 * @param {...import('../types').SprintfArgs<T>} args - arguments to interpolate
 *
 * @return {string} Formatted string.
 */

/**
 * Given a format string, returns string with arguments interpolatation.
 * Arguments can either be provided directly via function arguments spread, or
 * with an array as the second argument.
 *
 * @see https://en.wikipedia.org/wiki/Printf_format_string
 *
 * @example
 *
 * ```js
 * import sprintf from '@tannin/sprintf';
 *
 * sprintf( 'Hello %s!', 'world' );
 * // ⇒ 'Hello world!'
 * ```
 * @template {string} T
 * @overload
 * @param {T} string - string printf format string
 * @param {import('../types').SprintfArgs<T>} args - arguments to interpolate
 *
 * @return {string} Formatted string.
 */

/**
 * Given a format string, returns string with arguments interpolatation.
 * Arguments can either be provided directly via function arguments spread, or
 * with an array as the second argument.
 *
 * @see https://en.wikipedia.org/wiki/Printf_format_string
 *
 * @example
 *
 * ```js
 * import sprintf from '@tannin/sprintf';
 *
 * sprintf( 'Hello %s!', 'world' );
 * // ⇒ 'Hello world!'
 * ```
 * @template {string} T
 * @param {T} string - string printf format string
 * @param {...import('../types').SprintfArgs<T>} args - arguments to interpolate
 *
 * @return {string} Formatted string.
 */
function sprintf(string, ...args) {
	var i = 0;
	if (Array.isArray(args[0])) {
		args = /** @type {import('../types').SprintfArgs<T>[]} */ (
			/** @type {unknown} */ args[0]
		);
	}

	return string.replace(PATTERN, function () {
		var index,
			// name needs to be documented as `string | undefined` else value will have tpye unknown.
			/**
			 * Name of the argument to substitute, if any.
			 *
			 * @type {string | undefined}
			 */
			name,
			precision,
			type,
			value;

		index = arguments[3];
		name = arguments[5];
		precision = arguments[7];
		type = arguments[9];

		// There's no placeholder substitution in the explicit "%", meaning it
		// is not necessary to increment argument index.
		if (type === '%') {
			return '%';
		}

		// Asterisk precision determined by peeking / shifting next argument.
		if (precision === '*') {
			precision = args[i];
			i++;
		}

		if (name === undefined) {
			// If not a positional argument, use counter value.
			if (index === undefined) {
				index = i + 1;
			}

			i++;

			// Positional argument.
			value = args[index - 1];
		} else if (
			args[0] &&
			typeof args[0] === 'object' &&
			args[0].hasOwnProperty(name)
		) {
			// If it's a named argument, use name.
			value = args[0][name];
		}

		// Parse as type.
		if (type === 'f') {
			value = parseFloat(value) || 0;
		} else if (type === 'd') {
			value = parseInt(value) || 0;
		}

		// Apply precision.
		if (precision !== undefined) {
			if (type === 'f') {
				value = value.toFixed(precision);
			} else if (type === 's') {
				value = value.substr(0, precision);
			}
		}

		// To avoid "undefined" concatenation, return empty string if no
		// placeholder substitution can be performed.
		return value !== undefined && value !== null ? value : '';
	});
}


/***/ }),

/***/ "./node_modules/@use-gesture/core/actions/dist/use-gesture-core-actions.esm.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@use-gesture/core/actions/dist/use-gesture-core-actions.esm.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConfigResolverMap: () => (/* reexport safe */ _dist_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.C),
/* harmony export */   EngineMap: () => (/* reexport safe */ _dist_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.E),
/* harmony export */   dragAction: () => (/* reexport safe */ _dist_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.e),
/* harmony export */   hoverAction: () => (/* reexport safe */ _dist_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.h),
/* harmony export */   moveAction: () => (/* reexport safe */ _dist_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.m),
/* harmony export */   pinchAction: () => (/* reexport safe */ _dist_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.f),
/* harmony export */   registerAction: () => (/* reexport safe */ _dist_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.r),
/* harmony export */   scrollAction: () => (/* reexport safe */ _dist_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.s),
/* harmony export */   wheelAction: () => (/* reexport safe */ _dist_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.w)
/* harmony export */ });
/* harmony import */ var _dist_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../dist/actions-fe213e88.esm.js */ "./node_modules/@use-gesture/core/dist/actions-fe213e88.esm.js");




/***/ }),

/***/ "./node_modules/@use-gesture/core/dist/actions-fe213e88.esm.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@use-gesture/core/dist/actions-fe213e88.esm.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: () => (/* binding */ ConfigResolverMap),
/* harmony export */   E: () => (/* binding */ EngineMap),
/* harmony export */   S: () => (/* binding */ SUPPORT),
/* harmony export */   _: () => (/* binding */ _objectSpread2),
/* harmony export */   a: () => (/* binding */ _defineProperty),
/* harmony export */   b: () => (/* binding */ touchIds),
/* harmony export */   c: () => (/* binding */ chain),
/* harmony export */   d: () => (/* binding */ toHandlerProp),
/* harmony export */   e: () => (/* binding */ dragAction),
/* harmony export */   f: () => (/* binding */ pinchAction),
/* harmony export */   h: () => (/* binding */ hoverAction),
/* harmony export */   i: () => (/* binding */ isTouch),
/* harmony export */   m: () => (/* binding */ moveAction),
/* harmony export */   p: () => (/* binding */ parseProp),
/* harmony export */   r: () => (/* binding */ registerAction),
/* harmony export */   s: () => (/* binding */ scrollAction),
/* harmony export */   t: () => (/* binding */ toDomEventType),
/* harmony export */   w: () => (/* binding */ wheelAction)
/* harmony export */ });
/* harmony import */ var _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./maths-0ab39ae9.esm.js */ "./node_modules/@use-gesture/core/dist/maths-0ab39ae9.esm.js");


function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}

function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}

function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}

function ownKeys(e, r) {
  var t = Object.keys(e);
  if (Object.getOwnPropertySymbols) {
    var o = Object.getOwnPropertySymbols(e);
    r && (o = o.filter(function (r) {
      return Object.getOwnPropertyDescriptor(e, r).enumerable;
    })), t.push.apply(t, o);
  }
  return t;
}
function _objectSpread2(e) {
  for (var r = 1; r < arguments.length; r++) {
    var t = null != arguments[r] ? arguments[r] : {};
    r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
      _defineProperty(e, r, t[r]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
      Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
    });
  }
  return e;
}

const EVENT_TYPE_MAP = {
  pointer: {
    start: 'down',
    change: 'move',
    end: 'up'
  },
  mouse: {
    start: 'down',
    change: 'move',
    end: 'up'
  },
  touch: {
    start: 'start',
    change: 'move',
    end: 'end'
  },
  gesture: {
    start: 'start',
    change: 'change',
    end: 'end'
  }
};
function capitalize(string) {
  if (!string) return '';
  return string[0].toUpperCase() + string.slice(1);
}
const actionsWithoutCaptureSupported = ['enter', 'leave'];
function hasCapture(capture = false, actionKey) {
  return capture && !actionsWithoutCaptureSupported.includes(actionKey);
}
function toHandlerProp(device, action = '', capture = false) {
  const deviceProps = EVENT_TYPE_MAP[device];
  const actionKey = deviceProps ? deviceProps[action] || action : action;
  return 'on' + capitalize(device) + capitalize(actionKey) + (hasCapture(capture, actionKey) ? 'Capture' : '');
}
const pointerCaptureEvents = ['gotpointercapture', 'lostpointercapture'];
function parseProp(prop) {
  let eventKey = prop.substring(2).toLowerCase();
  const passive = !!~eventKey.indexOf('passive');
  if (passive) eventKey = eventKey.replace('passive', '');
  const captureKey = pointerCaptureEvents.includes(eventKey) ? 'capturecapture' : 'capture';
  const capture = !!~eventKey.indexOf(captureKey);
  if (capture) eventKey = eventKey.replace('capture', '');
  return {
    device: eventKey,
    capture,
    passive
  };
}
function toDomEventType(device, action = '') {
  const deviceProps = EVENT_TYPE_MAP[device];
  const actionKey = deviceProps ? deviceProps[action] || action : action;
  return device + actionKey;
}
function isTouch(event) {
  return 'touches' in event;
}
function getPointerType(event) {
  if (isTouch(event)) return 'touch';
  if ('pointerType' in event) return event.pointerType;
  return 'mouse';
}
function getCurrentTargetTouchList(event) {
  return Array.from(event.touches).filter(e => {
    var _event$currentTarget, _event$currentTarget$;
    return e.target === event.currentTarget || ((_event$currentTarget = event.currentTarget) === null || _event$currentTarget === void 0 || (_event$currentTarget$ = _event$currentTarget.contains) === null || _event$currentTarget$ === void 0 ? void 0 : _event$currentTarget$.call(_event$currentTarget, e.target));
  });
}
function getTouchList(event) {
  return event.type === 'touchend' || event.type === 'touchcancel' ? event.changedTouches : event.targetTouches;
}
function getValueEvent(event) {
  return isTouch(event) ? getTouchList(event)[0] : event;
}
function distanceAngle(P1, P2) {
  try {
    const dx = P2.clientX - P1.clientX;
    const dy = P2.clientY - P1.clientY;
    const cx = (P2.clientX + P1.clientX) / 2;
    const cy = (P2.clientY + P1.clientY) / 2;
    const distance = Math.hypot(dx, dy);
    const angle = -(Math.atan2(dx, dy) * 180) / Math.PI;
    const origin = [cx, cy];
    return {
      angle,
      distance,
      origin
    };
  } catch (_unused) {}
  return null;
}
function touchIds(event) {
  return getCurrentTargetTouchList(event).map(touch => touch.identifier);
}
function touchDistanceAngle(event, ids) {
  const [P1, P2] = Array.from(event.touches).filter(touch => ids.includes(touch.identifier));
  return distanceAngle(P1, P2);
}
function pointerId(event) {
  const valueEvent = getValueEvent(event);
  return isTouch(event) ? valueEvent.identifier : valueEvent.pointerId;
}
function pointerValues(event) {
  const valueEvent = getValueEvent(event);
  return [valueEvent.clientX, valueEvent.clientY];
}
const LINE_HEIGHT = 40;
const PAGE_HEIGHT = 800;
function wheelValues(event) {
  let {
    deltaX,
    deltaY,
    deltaMode
  } = event;
  if (deltaMode === 1) {
    deltaX *= LINE_HEIGHT;
    deltaY *= LINE_HEIGHT;
  } else if (deltaMode === 2) {
    deltaX *= PAGE_HEIGHT;
    deltaY *= PAGE_HEIGHT;
  }
  return [deltaX, deltaY];
}
function scrollValues(event) {
  var _ref, _ref2;
  const {
    scrollX,
    scrollY,
    scrollLeft,
    scrollTop
  } = event.currentTarget;
  return [(_ref = scrollX !== null && scrollX !== void 0 ? scrollX : scrollLeft) !== null && _ref !== void 0 ? _ref : 0, (_ref2 = scrollY !== null && scrollY !== void 0 ? scrollY : scrollTop) !== null && _ref2 !== void 0 ? _ref2 : 0];
}
function getEventDetails(event) {
  const payload = {};
  if ('buttons' in event) payload.buttons = event.buttons;
  if ('shiftKey' in event) {
    const {
      shiftKey,
      altKey,
      metaKey,
      ctrlKey
    } = event;
    Object.assign(payload, {
      shiftKey,
      altKey,
      metaKey,
      ctrlKey
    });
  }
  return payload;
}

function call(v, ...args) {
  if (typeof v === 'function') {
    return v(...args);
  } else {
    return v;
  }
}
function noop() {}
function chain(...fns) {
  if (fns.length === 0) return noop;
  if (fns.length === 1) return fns[0];
  return function () {
    let result;
    for (const fn of fns) {
      result = fn.apply(this, arguments) || result;
    }
    return result;
  };
}
function assignDefault(value, fallback) {
  return Object.assign({}, fallback, value || {});
}

const BEFORE_LAST_KINEMATICS_DELAY = 32;
class Engine {
  constructor(ctrl, args, key) {
    this.ctrl = ctrl;
    this.args = args;
    this.key = key;
    if (!this.state) {
      this.state = {};
      this.computeValues([0, 0]);
      this.computeInitial();
      if (this.init) this.init();
      this.reset();
    }
  }
  get state() {
    return this.ctrl.state[this.key];
  }
  set state(state) {
    this.ctrl.state[this.key] = state;
  }
  get shared() {
    return this.ctrl.state.shared;
  }
  get eventStore() {
    return this.ctrl.gestureEventStores[this.key];
  }
  get timeoutStore() {
    return this.ctrl.gestureTimeoutStores[this.key];
  }
  get config() {
    return this.ctrl.config[this.key];
  }
  get sharedConfig() {
    return this.ctrl.config.shared;
  }
  get handler() {
    return this.ctrl.handlers[this.key];
  }
  reset() {
    const {
      state,
      shared,
      ingKey,
      args
    } = this;
    shared[ingKey] = state._active = state.active = state._blocked = state._force = false;
    state._step = [false, false];
    state.intentional = false;
    state._movement = [0, 0];
    state._distance = [0, 0];
    state._direction = [0, 0];
    state._delta = [0, 0];
    state._bounds = [[-Infinity, Infinity], [-Infinity, Infinity]];
    state.args = args;
    state.axis = undefined;
    state.memo = undefined;
    state.elapsedTime = state.timeDelta = 0;
    state.direction = [0, 0];
    state.distance = [0, 0];
    state.overflow = [0, 0];
    state._movementBound = [false, false];
    state.velocity = [0, 0];
    state.movement = [0, 0];
    state.delta = [0, 0];
    state.timeStamp = 0;
  }
  start(event) {
    const state = this.state;
    const config = this.config;
    if (!state._active) {
      this.reset();
      this.computeInitial();
      state._active = true;
      state.target = event.target;
      state.currentTarget = event.currentTarget;
      state.lastOffset = config.from ? call(config.from, state) : state.offset;
      state.offset = state.lastOffset;
      state.startTime = state.timeStamp = event.timeStamp;
    }
  }
  computeValues(values) {
    const state = this.state;
    state._values = values;
    state.values = this.config.transform(values);
  }
  computeInitial() {
    const state = this.state;
    state._initial = state._values;
    state.initial = state.values;
  }
  compute(event) {
    const {
      state,
      config,
      shared
    } = this;
    state.args = this.args;
    let dt = 0;
    if (event) {
      state.event = event;
      if (config.preventDefault && event.cancelable) state.event.preventDefault();
      state.type = event.type;
      shared.touches = this.ctrl.pointerIds.size || this.ctrl.touchIds.size;
      shared.locked = !!document.pointerLockElement;
      Object.assign(shared, getEventDetails(event));
      shared.down = shared.pressed = shared.buttons % 2 === 1 || shared.touches > 0;
      dt = event.timeStamp - state.timeStamp;
      state.timeStamp = event.timeStamp;
      state.elapsedTime = state.timeStamp - state.startTime;
    }
    if (state._active) {
      const _absoluteDelta = state._delta.map(Math.abs);
      _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.addTo(state._distance, _absoluteDelta);
    }
    if (this.axisIntent) this.axisIntent(event);
    const [_m0, _m1] = state._movement;
    const [t0, t1] = config.threshold;
    const {
      _step,
      values
    } = state;
    if (config.hasCustomTransform) {
      if (_step[0] === false) _step[0] = Math.abs(_m0) >= t0 && values[0];
      if (_step[1] === false) _step[1] = Math.abs(_m1) >= t1 && values[1];
    } else {
      if (_step[0] === false) _step[0] = Math.abs(_m0) >= t0 && Math.sign(_m0) * t0;
      if (_step[1] === false) _step[1] = Math.abs(_m1) >= t1 && Math.sign(_m1) * t1;
    }
    state.intentional = _step[0] !== false || _step[1] !== false;
    if (!state.intentional) return;
    const movement = [0, 0];
    if (config.hasCustomTransform) {
      const [v0, v1] = values;
      movement[0] = _step[0] !== false ? v0 - _step[0] : 0;
      movement[1] = _step[1] !== false ? v1 - _step[1] : 0;
    } else {
      movement[0] = _step[0] !== false ? _m0 - _step[0] : 0;
      movement[1] = _step[1] !== false ? _m1 - _step[1] : 0;
    }
    if (this.restrictToAxis && !state._blocked) this.restrictToAxis(movement);
    const previousOffset = state.offset;
    const gestureIsActive = state._active && !state._blocked || state.active;
    if (gestureIsActive) {
      state.first = state._active && !state.active;
      state.last = !state._active && state.active;
      state.active = shared[this.ingKey] = state._active;
      if (event) {
        if (state.first) {
          if ('bounds' in config) state._bounds = call(config.bounds, state);
          if (this.setup) this.setup();
        }
        state.movement = movement;
        this.computeOffset();
      }
    }
    const [ox, oy] = state.offset;
    const [[x0, x1], [y0, y1]] = state._bounds;
    state.overflow = [ox < x0 ? -1 : ox > x1 ? 1 : 0, oy < y0 ? -1 : oy > y1 ? 1 : 0];
    state._movementBound[0] = state.overflow[0] ? state._movementBound[0] === false ? state._movement[0] : state._movementBound[0] : false;
    state._movementBound[1] = state.overflow[1] ? state._movementBound[1] === false ? state._movement[1] : state._movementBound[1] : false;
    const rubberband = state._active ? config.rubberband || [0, 0] : [0, 0];
    state.offset = (0,_maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.c)(state._bounds, state.offset, rubberband);
    state.delta = _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.sub(state.offset, previousOffset);
    this.computeMovement();
    if (gestureIsActive && (!state.last || dt > BEFORE_LAST_KINEMATICS_DELAY)) {
      state.delta = _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.sub(state.offset, previousOffset);
      const absoluteDelta = state.delta.map(Math.abs);
      _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.addTo(state.distance, absoluteDelta);
      state.direction = state.delta.map(Math.sign);
      state._direction = state._delta.map(Math.sign);
      if (!state.first && dt > 0) {
        state.velocity = [absoluteDelta[0] / dt, absoluteDelta[1] / dt];
        state.timeDelta = dt;
      }
    }
  }
  emit() {
    const state = this.state;
    const shared = this.shared;
    const config = this.config;
    if (!state._active) this.clean();
    if ((state._blocked || !state.intentional) && !state._force && !config.triggerAllEvents) return;
    const memo = this.handler(_objectSpread2(_objectSpread2(_objectSpread2({}, shared), state), {}, {
      [this.aliasKey]: state.values
    }));
    if (memo !== undefined) state.memo = memo;
  }
  clean() {
    this.eventStore.clean();
    this.timeoutStore.clean();
  }
}

function selectAxis([dx, dy], threshold) {
  const absDx = Math.abs(dx);
  const absDy = Math.abs(dy);
  if (absDx > absDy && absDx > threshold) {
    return 'x';
  }
  if (absDy > absDx && absDy > threshold) {
    return 'y';
  }
  return undefined;
}
class CoordinatesEngine extends Engine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "aliasKey", 'xy');
  }
  reset() {
    super.reset();
    this.state.axis = undefined;
  }
  init() {
    this.state.offset = [0, 0];
    this.state.lastOffset = [0, 0];
  }
  computeOffset() {
    this.state.offset = _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.add(this.state.lastOffset, this.state.movement);
  }
  computeMovement() {
    this.state.movement = _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.sub(this.state.offset, this.state.lastOffset);
  }
  axisIntent(event) {
    const state = this.state;
    const config = this.config;
    if (!state.axis && event) {
      const threshold = typeof config.axisThreshold === 'object' ? config.axisThreshold[getPointerType(event)] : config.axisThreshold;
      state.axis = selectAxis(state._movement, threshold);
    }
    state._blocked = (config.lockDirection || !!config.axis) && !state.axis || !!config.axis && config.axis !== state.axis;
  }
  restrictToAxis(v) {
    if (this.config.axis || this.config.lockDirection) {
      switch (this.state.axis) {
        case 'x':
          v[1] = 0;
          break;
        case 'y':
          v[0] = 0;
          break;
      }
    }
  }
}

const identity = v => v;
const DEFAULT_RUBBERBAND = 0.15;
const commonConfigResolver = {
  enabled(value = true) {
    return value;
  },
  eventOptions(value, _k, config) {
    return _objectSpread2(_objectSpread2({}, config.shared.eventOptions), value);
  },
  preventDefault(value = false) {
    return value;
  },
  triggerAllEvents(value = false) {
    return value;
  },
  rubberband(value = 0) {
    switch (value) {
      case true:
        return [DEFAULT_RUBBERBAND, DEFAULT_RUBBERBAND];
      case false:
        return [0, 0];
      default:
        return _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.toVector(value);
    }
  },
  from(value) {
    if (typeof value === 'function') return value;
    if (value != null) return _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.toVector(value);
  },
  transform(value, _k, config) {
    const transform = value || config.shared.transform;
    this.hasCustomTransform = !!transform;
    if (true) {
      const originalTransform = transform || identity;
      return v => {
        const r = originalTransform(v);
        if (!isFinite(r[0]) || !isFinite(r[1])) {
          console.warn(`[@use-gesture]: config.transform() must produce a valid result, but it was: [${r[0]},${[1]}]`);
        }
        return r;
      };
    }
    // removed by dead control flow

  },
  threshold(value) {
    return _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.toVector(value, 0);
  }
};
if (true) {
  Object.assign(commonConfigResolver, {
    domTarget(value) {
      if (value !== undefined) {
        throw Error(`[@use-gesture]: \`domTarget\` option has been renamed to \`target\`.`);
      }
      return NaN;
    },
    lockDirection(value) {
      if (value !== undefined) {
        throw Error(`[@use-gesture]: \`lockDirection\` option has been merged with \`axis\`. Use it as in \`{ axis: 'lock' }\``);
      }
      return NaN;
    },
    initial(value) {
      if (value !== undefined) {
        throw Error(`[@use-gesture]: \`initial\` option has been renamed to \`from\`.`);
      }
      return NaN;
    }
  });
}

const DEFAULT_AXIS_THRESHOLD = 0;
const coordinatesConfigResolver = _objectSpread2(_objectSpread2({}, commonConfigResolver), {}, {
  axis(_v, _k, {
    axis
  }) {
    this.lockDirection = axis === 'lock';
    if (!this.lockDirection) return axis;
  },
  axisThreshold(value = DEFAULT_AXIS_THRESHOLD) {
    return value;
  },
  bounds(value = {}) {
    if (typeof value === 'function') {
      return state => coordinatesConfigResolver.bounds(value(state));
    }
    if ('current' in value) {
      return () => value.current;
    }
    if (typeof HTMLElement === 'function' && value instanceof HTMLElement) {
      return value;
    }
    const {
      left = -Infinity,
      right = Infinity,
      top = -Infinity,
      bottom = Infinity
    } = value;
    return [[left, right], [top, bottom]];
  }
});

const KEYS_DELTA_MAP = {
  ArrowRight: (displacement, factor = 1) => [displacement * factor, 0],
  ArrowLeft: (displacement, factor = 1) => [-1 * displacement * factor, 0],
  ArrowUp: (displacement, factor = 1) => [0, -1 * displacement * factor],
  ArrowDown: (displacement, factor = 1) => [0, displacement * factor]
};
class DragEngine extends CoordinatesEngine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "ingKey", 'dragging');
  }
  reset() {
    super.reset();
    const state = this.state;
    state._pointerId = undefined;
    state._pointerActive = false;
    state._keyboardActive = false;
    state._preventScroll = false;
    state._delayed = false;
    state.swipe = [0, 0];
    state.tap = false;
    state.canceled = false;
    state.cancel = this.cancel.bind(this);
  }
  setup() {
    const state = this.state;
    if (state._bounds instanceof HTMLElement) {
      const boundRect = state._bounds.getBoundingClientRect();
      const targetRect = state.currentTarget.getBoundingClientRect();
      const _bounds = {
        left: boundRect.left - targetRect.left + state.offset[0],
        right: boundRect.right - targetRect.right + state.offset[0],
        top: boundRect.top - targetRect.top + state.offset[1],
        bottom: boundRect.bottom - targetRect.bottom + state.offset[1]
      };
      state._bounds = coordinatesConfigResolver.bounds(_bounds);
    }
  }
  cancel() {
    const state = this.state;
    if (state.canceled) return;
    state.canceled = true;
    state._active = false;
    setTimeout(() => {
      this.compute();
      this.emit();
    }, 0);
  }
  setActive() {
    this.state._active = this.state._pointerActive || this.state._keyboardActive;
  }
  clean() {
    this.pointerClean();
    this.state._pointerActive = false;
    this.state._keyboardActive = false;
    super.clean();
  }
  pointerDown(event) {
    const config = this.config;
    const state = this.state;
    if (event.buttons != null && (Array.isArray(config.pointerButtons) ? !config.pointerButtons.includes(event.buttons) : config.pointerButtons !== -1 && config.pointerButtons !== event.buttons)) return;
    const ctrlIds = this.ctrl.setEventIds(event);
    if (config.pointerCapture) {
      event.target.setPointerCapture(event.pointerId);
    }
    if (ctrlIds && ctrlIds.size > 1 && state._pointerActive) return;
    this.start(event);
    this.setupPointer(event);
    state._pointerId = pointerId(event);
    state._pointerActive = true;
    this.computeValues(pointerValues(event));
    this.computeInitial();
    if (config.preventScrollAxis && getPointerType(event) !== 'mouse') {
      state._active = false;
      this.setupScrollPrevention(event);
    } else if (config.delay > 0) {
      this.setupDelayTrigger(event);
      if (config.triggerAllEvents) {
        this.compute(event);
        this.emit();
      }
    } else {
      this.startPointerDrag(event);
    }
  }
  startPointerDrag(event) {
    const state = this.state;
    state._active = true;
    state._preventScroll = true;
    state._delayed = false;
    this.compute(event);
    this.emit();
  }
  pointerMove(event) {
    const state = this.state;
    const config = this.config;
    if (!state._pointerActive) return;
    const id = pointerId(event);
    if (state._pointerId !== undefined && id !== state._pointerId) return;
    const _values = pointerValues(event);
    if (document.pointerLockElement === event.target) {
      state._delta = [event.movementX, event.movementY];
    } else {
      state._delta = _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.sub(_values, state._values);
      this.computeValues(_values);
    }
    _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.addTo(state._movement, state._delta);
    this.compute(event);
    if (state._delayed && state.intentional) {
      this.timeoutStore.remove('dragDelay');
      state.active = false;
      this.startPointerDrag(event);
      return;
    }
    if (config.preventScrollAxis && !state._preventScroll) {
      if (state.axis) {
        if (state.axis === config.preventScrollAxis || config.preventScrollAxis === 'xy') {
          state._active = false;
          this.clean();
          return;
        } else {
          this.timeoutStore.remove('startPointerDrag');
          this.startPointerDrag(event);
          return;
        }
      } else {
        return;
      }
    }
    this.emit();
  }
  pointerUp(event) {
    this.ctrl.setEventIds(event);
    try {
      if (this.config.pointerCapture && event.target.hasPointerCapture(event.pointerId)) {
        ;
        event.target.releasePointerCapture(event.pointerId);
      }
    } catch (_unused) {
      if (true) {
        console.warn(`[@use-gesture]: If you see this message, it's likely that you're using an outdated version of \`@react-three/fiber\`. \n\nPlease upgrade to the latest version.`);
      }
    }
    const state = this.state;
    const config = this.config;
    if (!state._active || !state._pointerActive) return;
    const id = pointerId(event);
    if (state._pointerId !== undefined && id !== state._pointerId) return;
    this.state._pointerActive = false;
    this.setActive();
    this.compute(event);
    const [dx, dy] = state._distance;
    state.tap = dx <= config.tapsThreshold && dy <= config.tapsThreshold;
    if (state.tap && config.filterTaps) {
      state._force = true;
    } else {
      const [_dx, _dy] = state._delta;
      const [_mx, _my] = state._movement;
      const [svx, svy] = config.swipe.velocity;
      const [sx, sy] = config.swipe.distance;
      const sdt = config.swipe.duration;
      if (state.elapsedTime < sdt) {
        const _vx = Math.abs(_dx / state.timeDelta);
        const _vy = Math.abs(_dy / state.timeDelta);
        if (_vx > svx && Math.abs(_mx) > sx) state.swipe[0] = Math.sign(_dx);
        if (_vy > svy && Math.abs(_my) > sy) state.swipe[1] = Math.sign(_dy);
      }
    }
    this.emit();
  }
  pointerClick(event) {
    if (!this.state.tap && event.detail > 0) {
      event.preventDefault();
      event.stopPropagation();
    }
  }
  setupPointer(event) {
    const config = this.config;
    const device = config.device;
    if (true) {
      try {
        if (device === 'pointer' && config.preventScrollDelay === undefined) {
          const currentTarget = 'uv' in event ? event.sourceEvent.currentTarget : event.currentTarget;
          const style = window.getComputedStyle(currentTarget);
          if (style.touchAction === 'auto') {
            console.warn(`[@use-gesture]: The drag target has its \`touch-action\` style property set to \`auto\`. It is recommended to add \`touch-action: 'none'\` so that the drag gesture behaves correctly on touch-enabled devices. For more information read this: https://use-gesture.netlify.app/docs/extras/#touch-action.\n\nThis message will only show in development mode. It won't appear in production. If this is intended, you can ignore it.`, currentTarget);
          }
        }
      } catch (_unused2) {}
    }
    if (config.pointerLock) {
      event.currentTarget.requestPointerLock();
    }
    if (!config.pointerCapture) {
      this.eventStore.add(this.sharedConfig.window, device, 'change', this.pointerMove.bind(this));
      this.eventStore.add(this.sharedConfig.window, device, 'end', this.pointerUp.bind(this));
      this.eventStore.add(this.sharedConfig.window, device, 'cancel', this.pointerUp.bind(this));
    }
  }
  pointerClean() {
    if (this.config.pointerLock && document.pointerLockElement === this.state.currentTarget) {
      document.exitPointerLock();
    }
  }
  preventScroll(event) {
    if (this.state._preventScroll && event.cancelable) {
      event.preventDefault();
    }
  }
  setupScrollPrevention(event) {
    this.state._preventScroll = false;
    persistEvent(event);
    const remove = this.eventStore.add(this.sharedConfig.window, 'touch', 'change', this.preventScroll.bind(this), {
      passive: false
    });
    this.eventStore.add(this.sharedConfig.window, 'touch', 'end', remove);
    this.eventStore.add(this.sharedConfig.window, 'touch', 'cancel', remove);
    this.timeoutStore.add('startPointerDrag', this.startPointerDrag.bind(this), this.config.preventScrollDelay, event);
  }
  setupDelayTrigger(event) {
    this.state._delayed = true;
    this.timeoutStore.add('dragDelay', () => {
      this.state._step = [0, 0];
      this.startPointerDrag(event);
    }, this.config.delay);
  }
  keyDown(event) {
    const deltaFn = KEYS_DELTA_MAP[event.key];
    if (deltaFn) {
      const state = this.state;
      const factor = event.shiftKey ? 10 : event.altKey ? 0.1 : 1;
      this.start(event);
      state._delta = deltaFn(this.config.keyboardDisplacement, factor);
      state._keyboardActive = true;
      _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.addTo(state._movement, state._delta);
      this.compute(event);
      this.emit();
    }
  }
  keyUp(event) {
    if (!(event.key in KEYS_DELTA_MAP)) return;
    this.state._keyboardActive = false;
    this.setActive();
    this.compute(event);
    this.emit();
  }
  bind(bindFunction) {
    const device = this.config.device;
    bindFunction(device, 'start', this.pointerDown.bind(this));
    if (this.config.pointerCapture) {
      bindFunction(device, 'change', this.pointerMove.bind(this));
      bindFunction(device, 'end', this.pointerUp.bind(this));
      bindFunction(device, 'cancel', this.pointerUp.bind(this));
      bindFunction('lostPointerCapture', '', this.pointerUp.bind(this));
    }
    if (this.config.keys) {
      bindFunction('key', 'down', this.keyDown.bind(this));
      bindFunction('key', 'up', this.keyUp.bind(this));
    }
    if (this.config.filterTaps) {
      bindFunction('click', '', this.pointerClick.bind(this), {
        capture: true,
        passive: false
      });
    }
  }
}
function persistEvent(event) {
  'persist' in event && typeof event.persist === 'function' && event.persist();
}

const isBrowser = typeof window !== 'undefined' && window.document && window.document.createElement;
function supportsTouchEvents() {
  return isBrowser && 'ontouchstart' in window;
}
function isTouchScreen() {
  return supportsTouchEvents() || isBrowser && window.navigator.maxTouchPoints > 1;
}
function supportsPointerEvents() {
  return isBrowser && 'onpointerdown' in window;
}
function supportsPointerLock() {
  return isBrowser && 'exitPointerLock' in window.document;
}
function supportsGestureEvents() {
  try {
    return 'constructor' in GestureEvent;
  } catch (e) {
    return false;
  }
}
const SUPPORT = {
  isBrowser,
  gesture: supportsGestureEvents(),
  touch: supportsTouchEvents(),
  touchscreen: isTouchScreen(),
  pointer: supportsPointerEvents(),
  pointerLock: supportsPointerLock()
};

const DEFAULT_PREVENT_SCROLL_DELAY = 250;
const DEFAULT_DRAG_DELAY = 180;
const DEFAULT_SWIPE_VELOCITY = 0.5;
const DEFAULT_SWIPE_DISTANCE = 50;
const DEFAULT_SWIPE_DURATION = 250;
const DEFAULT_KEYBOARD_DISPLACEMENT = 10;
const DEFAULT_DRAG_AXIS_THRESHOLD = {
  mouse: 0,
  touch: 0,
  pen: 8
};
const dragConfigResolver = _objectSpread2(_objectSpread2({}, coordinatesConfigResolver), {}, {
  device(_v, _k, {
    pointer: {
      touch = false,
      lock = false,
      mouse = false
    } = {}
  }) {
    this.pointerLock = lock && SUPPORT.pointerLock;
    if (SUPPORT.touch && touch) return 'touch';
    if (this.pointerLock) return 'mouse';
    if (SUPPORT.pointer && !mouse) return 'pointer';
    if (SUPPORT.touch) return 'touch';
    return 'mouse';
  },
  preventScrollAxis(value, _k, {
    preventScroll
  }) {
    this.preventScrollDelay = typeof preventScroll === 'number' ? preventScroll : preventScroll || preventScroll === undefined && value ? DEFAULT_PREVENT_SCROLL_DELAY : undefined;
    if (!SUPPORT.touchscreen || preventScroll === false) return undefined;
    return value ? value : preventScroll !== undefined ? 'y' : undefined;
  },
  pointerCapture(_v, _k, {
    pointer: {
      capture = true,
      buttons = 1,
      keys = true
    } = {}
  }) {
    this.pointerButtons = buttons;
    this.keys = keys;
    return !this.pointerLock && this.device === 'pointer' && capture;
  },
  threshold(value, _k, {
    filterTaps = false,
    tapsThreshold = 3,
    axis = undefined
  }) {
    const threshold = _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.toVector(value, filterTaps ? tapsThreshold : axis ? 1 : 0);
    this.filterTaps = filterTaps;
    this.tapsThreshold = tapsThreshold;
    return threshold;
  },
  swipe({
    velocity = DEFAULT_SWIPE_VELOCITY,
    distance = DEFAULT_SWIPE_DISTANCE,
    duration = DEFAULT_SWIPE_DURATION
  } = {}) {
    return {
      velocity: this.transform(_maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.toVector(velocity)),
      distance: this.transform(_maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.toVector(distance)),
      duration
    };
  },
  delay(value = 0) {
    switch (value) {
      case true:
        return DEFAULT_DRAG_DELAY;
      case false:
        return 0;
      default:
        return value;
    }
  },
  axisThreshold(value) {
    if (!value) return DEFAULT_DRAG_AXIS_THRESHOLD;
    return _objectSpread2(_objectSpread2({}, DEFAULT_DRAG_AXIS_THRESHOLD), value);
  },
  keyboardDisplacement(value = DEFAULT_KEYBOARD_DISPLACEMENT) {
    return value;
  }
});
if (true) {
  Object.assign(dragConfigResolver, {
    useTouch(value) {
      if (value !== undefined) {
        throw Error(`[@use-gesture]: \`useTouch\` option has been renamed to \`pointer.touch\`. Use it as in \`{ pointer: { touch: true } }\`.`);
      }
      return NaN;
    },
    experimental_preventWindowScrollY(value) {
      if (value !== undefined) {
        throw Error(`[@use-gesture]: \`experimental_preventWindowScrollY\` option has been renamed to \`preventScroll\`.`);
      }
      return NaN;
    },
    swipeVelocity(value) {
      if (value !== undefined) {
        throw Error(`[@use-gesture]: \`swipeVelocity\` option has been renamed to \`swipe.velocity\`. Use it as in \`{ swipe: { velocity: 0.5 } }\`.`);
      }
      return NaN;
    },
    swipeDistance(value) {
      if (value !== undefined) {
        throw Error(`[@use-gesture]: \`swipeDistance\` option has been renamed to \`swipe.distance\`. Use it as in \`{ swipe: { distance: 50 } }\`.`);
      }
      return NaN;
    },
    swipeDuration(value) {
      if (value !== undefined) {
        throw Error(`[@use-gesture]: \`swipeDuration\` option has been renamed to \`swipe.duration\`. Use it as in \`{ swipe: { duration: 250 } }\`.`);
      }
      return NaN;
    }
  });
}

function clampStateInternalMovementToBounds(state) {
  const [ox, oy] = state.overflow;
  const [dx, dy] = state._delta;
  const [dirx, diry] = state._direction;
  if (ox < 0 && dx > 0 && dirx < 0 || ox > 0 && dx < 0 && dirx > 0) {
    state._movement[0] = state._movementBound[0];
  }
  if (oy < 0 && dy > 0 && diry < 0 || oy > 0 && dy < 0 && diry > 0) {
    state._movement[1] = state._movementBound[1];
  }
}

const SCALE_ANGLE_RATIO_INTENT_DEG = 30;
const PINCH_WHEEL_RATIO = 100;
class PinchEngine extends Engine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "ingKey", 'pinching');
    _defineProperty(this, "aliasKey", 'da');
  }
  init() {
    this.state.offset = [1, 0];
    this.state.lastOffset = [1, 0];
    this.state._pointerEvents = new Map();
  }
  reset() {
    super.reset();
    const state = this.state;
    state._touchIds = [];
    state.canceled = false;
    state.cancel = this.cancel.bind(this);
    state.turns = 0;
  }
  computeOffset() {
    const {
      type,
      movement,
      lastOffset
    } = this.state;
    if (type === 'wheel') {
      this.state.offset = _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.add(movement, lastOffset);
    } else {
      this.state.offset = [(1 + movement[0]) * lastOffset[0], movement[1] + lastOffset[1]];
    }
  }
  computeMovement() {
    const {
      offset,
      lastOffset
    } = this.state;
    this.state.movement = [offset[0] / lastOffset[0], offset[1] - lastOffset[1]];
  }
  axisIntent() {
    const state = this.state;
    const [_m0, _m1] = state._movement;
    if (!state.axis) {
      const axisMovementDifference = Math.abs(_m0) * SCALE_ANGLE_RATIO_INTENT_DEG - Math.abs(_m1);
      if (axisMovementDifference < 0) state.axis = 'angle';else if (axisMovementDifference > 0) state.axis = 'scale';
    }
  }
  restrictToAxis(v) {
    if (this.config.lockDirection) {
      if (this.state.axis === 'scale') v[1] = 0;else if (this.state.axis === 'angle') v[0] = 0;
    }
  }
  cancel() {
    const state = this.state;
    if (state.canceled) return;
    setTimeout(() => {
      state.canceled = true;
      state._active = false;
      this.compute();
      this.emit();
    }, 0);
  }
  touchStart(event) {
    this.ctrl.setEventIds(event);
    const state = this.state;
    const ctrlTouchIds = this.ctrl.touchIds;
    if (state._active) {
      if (state._touchIds.every(id => ctrlTouchIds.has(id))) return;
    }
    if (ctrlTouchIds.size < 2) return;
    this.start(event);
    state._touchIds = Array.from(ctrlTouchIds).slice(0, 2);
    const payload = touchDistanceAngle(event, state._touchIds);
    if (!payload) return;
    this.pinchStart(event, payload);
  }
  pointerStart(event) {
    if (event.buttons != null && event.buttons % 2 !== 1) return;
    this.ctrl.setEventIds(event);
    event.target.setPointerCapture(event.pointerId);
    const state = this.state;
    const _pointerEvents = state._pointerEvents;
    const ctrlPointerIds = this.ctrl.pointerIds;
    if (state._active) {
      if (Array.from(_pointerEvents.keys()).every(id => ctrlPointerIds.has(id))) return;
    }
    if (_pointerEvents.size < 2) {
      _pointerEvents.set(event.pointerId, event);
    }
    if (state._pointerEvents.size < 2) return;
    this.start(event);
    const payload = distanceAngle(...Array.from(_pointerEvents.values()));
    if (!payload) return;
    this.pinchStart(event, payload);
  }
  pinchStart(event, payload) {
    const state = this.state;
    state.origin = payload.origin;
    this.computeValues([payload.distance, payload.angle]);
    this.computeInitial();
    this.compute(event);
    this.emit();
  }
  touchMove(event) {
    if (!this.state._active) return;
    const payload = touchDistanceAngle(event, this.state._touchIds);
    if (!payload) return;
    this.pinchMove(event, payload);
  }
  pointerMove(event) {
    const _pointerEvents = this.state._pointerEvents;
    if (_pointerEvents.has(event.pointerId)) {
      _pointerEvents.set(event.pointerId, event);
    }
    if (!this.state._active) return;
    const payload = distanceAngle(...Array.from(_pointerEvents.values()));
    if (!payload) return;
    this.pinchMove(event, payload);
  }
  pinchMove(event, payload) {
    const state = this.state;
    const prev_a = state._values[1];
    const delta_a = payload.angle - prev_a;
    let delta_turns = 0;
    if (Math.abs(delta_a) > 270) delta_turns += Math.sign(delta_a);
    this.computeValues([payload.distance, payload.angle - 360 * delta_turns]);
    state.origin = payload.origin;
    state.turns = delta_turns;
    state._movement = [state._values[0] / state._initial[0] - 1, state._values[1] - state._initial[1]];
    this.compute(event);
    this.emit();
  }
  touchEnd(event) {
    this.ctrl.setEventIds(event);
    if (!this.state._active) return;
    if (this.state._touchIds.some(id => !this.ctrl.touchIds.has(id))) {
      this.state._active = false;
      this.compute(event);
      this.emit();
    }
  }
  pointerEnd(event) {
    const state = this.state;
    this.ctrl.setEventIds(event);
    try {
      event.target.releasePointerCapture(event.pointerId);
    } catch (_unused) {}
    if (state._pointerEvents.has(event.pointerId)) {
      state._pointerEvents.delete(event.pointerId);
    }
    if (!state._active) return;
    if (state._pointerEvents.size < 2) {
      state._active = false;
      this.compute(event);
      this.emit();
    }
  }
  gestureStart(event) {
    if (event.cancelable) event.preventDefault();
    const state = this.state;
    if (state._active) return;
    this.start(event);
    this.computeValues([event.scale, event.rotation]);
    state.origin = [event.clientX, event.clientY];
    this.compute(event);
    this.emit();
  }
  gestureMove(event) {
    if (event.cancelable) event.preventDefault();
    if (!this.state._active) return;
    const state = this.state;
    this.computeValues([event.scale, event.rotation]);
    state.origin = [event.clientX, event.clientY];
    const _previousMovement = state._movement;
    state._movement = [event.scale - 1, event.rotation];
    state._delta = _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.sub(state._movement, _previousMovement);
    this.compute(event);
    this.emit();
  }
  gestureEnd(event) {
    if (!this.state._active) return;
    this.state._active = false;
    this.compute(event);
    this.emit();
  }
  wheel(event) {
    const modifierKey = this.config.modifierKey;
    if (modifierKey && (Array.isArray(modifierKey) ? !modifierKey.find(k => event[k]) : !event[modifierKey])) return;
    if (!this.state._active) this.wheelStart(event);else this.wheelChange(event);
    this.timeoutStore.add('wheelEnd', this.wheelEnd.bind(this));
  }
  wheelStart(event) {
    this.start(event);
    this.wheelChange(event);
  }
  wheelChange(event) {
    const isR3f = ('uv' in event);
    if (!isR3f) {
      if (event.cancelable) {
        event.preventDefault();
      }
      if ( true && !event.defaultPrevented) {
        console.warn(`[@use-gesture]: To properly support zoom on trackpads, try using the \`target\` option.\n\nThis message will only appear in development mode.`);
      }
    }
    const state = this.state;
    state._delta = [-wheelValues(event)[1] / PINCH_WHEEL_RATIO * state.offset[0], 0];
    _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.addTo(state._movement, state._delta);
    clampStateInternalMovementToBounds(state);
    this.state.origin = [event.clientX, event.clientY];
    this.compute(event);
    this.emit();
  }
  wheelEnd() {
    if (!this.state._active) return;
    this.state._active = false;
    this.compute();
    this.emit();
  }
  bind(bindFunction) {
    const device = this.config.device;
    if (!!device) {
      bindFunction(device, 'start', this[device + 'Start'].bind(this));
      bindFunction(device, 'change', this[device + 'Move'].bind(this));
      bindFunction(device, 'end', this[device + 'End'].bind(this));
      bindFunction(device, 'cancel', this[device + 'End'].bind(this));
      bindFunction('lostPointerCapture', '', this[device + 'End'].bind(this));
    }
    if (this.config.pinchOnWheel) {
      bindFunction('wheel', '', this.wheel.bind(this), {
        passive: false
      });
    }
  }
}

const pinchConfigResolver = _objectSpread2(_objectSpread2({}, commonConfigResolver), {}, {
  device(_v, _k, {
    shared,
    pointer: {
      touch = false
    } = {}
  }) {
    const sharedConfig = shared;
    if (sharedConfig.target && !SUPPORT.touch && SUPPORT.gesture) return 'gesture';
    if (SUPPORT.touch && touch) return 'touch';
    if (SUPPORT.touchscreen) {
      if (SUPPORT.pointer) return 'pointer';
      if (SUPPORT.touch) return 'touch';
    }
  },
  bounds(_v, _k, {
    scaleBounds = {},
    angleBounds = {}
  }) {
    const _scaleBounds = state => {
      const D = assignDefault(call(scaleBounds, state), {
        min: -Infinity,
        max: Infinity
      });
      return [D.min, D.max];
    };
    const _angleBounds = state => {
      const A = assignDefault(call(angleBounds, state), {
        min: -Infinity,
        max: Infinity
      });
      return [A.min, A.max];
    };
    if (typeof scaleBounds !== 'function' && typeof angleBounds !== 'function') return [_scaleBounds(), _angleBounds()];
    return state => [_scaleBounds(state), _angleBounds(state)];
  },
  threshold(value, _k, config) {
    this.lockDirection = config.axis === 'lock';
    const threshold = _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.toVector(value, this.lockDirection ? [0.1, 3] : 0);
    return threshold;
  },
  modifierKey(value) {
    if (value === undefined) return 'ctrlKey';
    return value;
  },
  pinchOnWheel(value = true) {
    return value;
  }
});

class MoveEngine extends CoordinatesEngine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "ingKey", 'moving');
  }
  move(event) {
    if (this.config.mouseOnly && event.pointerType !== 'mouse') return;
    if (!this.state._active) this.moveStart(event);else this.moveChange(event);
    this.timeoutStore.add('moveEnd', this.moveEnd.bind(this));
  }
  moveStart(event) {
    this.start(event);
    this.computeValues(pointerValues(event));
    this.compute(event);
    this.computeInitial();
    this.emit();
  }
  moveChange(event) {
    if (!this.state._active) return;
    const values = pointerValues(event);
    const state = this.state;
    state._delta = _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.sub(values, state._values);
    _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.addTo(state._movement, state._delta);
    this.computeValues(values);
    this.compute(event);
    this.emit();
  }
  moveEnd(event) {
    if (!this.state._active) return;
    this.state._active = false;
    this.compute(event);
    this.emit();
  }
  bind(bindFunction) {
    bindFunction('pointer', 'change', this.move.bind(this));
    bindFunction('pointer', 'leave', this.moveEnd.bind(this));
  }
}

const moveConfigResolver = _objectSpread2(_objectSpread2({}, coordinatesConfigResolver), {}, {
  mouseOnly: (value = true) => value
});

class ScrollEngine extends CoordinatesEngine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "ingKey", 'scrolling');
  }
  scroll(event) {
    if (!this.state._active) this.start(event);
    this.scrollChange(event);
    this.timeoutStore.add('scrollEnd', this.scrollEnd.bind(this));
  }
  scrollChange(event) {
    if (event.cancelable) event.preventDefault();
    const state = this.state;
    const values = scrollValues(event);
    state._delta = _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.sub(values, state._values);
    _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.addTo(state._movement, state._delta);
    this.computeValues(values);
    this.compute(event);
    this.emit();
  }
  scrollEnd() {
    if (!this.state._active) return;
    this.state._active = false;
    this.compute();
    this.emit();
  }
  bind(bindFunction) {
    bindFunction('scroll', '', this.scroll.bind(this));
  }
}

const scrollConfigResolver = coordinatesConfigResolver;

class WheelEngine extends CoordinatesEngine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "ingKey", 'wheeling');
  }
  wheel(event) {
    if (!this.state._active) this.start(event);
    this.wheelChange(event);
    this.timeoutStore.add('wheelEnd', this.wheelEnd.bind(this));
  }
  wheelChange(event) {
    const state = this.state;
    state._delta = wheelValues(event);
    _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.addTo(state._movement, state._delta);
    clampStateInternalMovementToBounds(state);
    this.compute(event);
    this.emit();
  }
  wheelEnd() {
    if (!this.state._active) return;
    this.state._active = false;
    this.compute();
    this.emit();
  }
  bind(bindFunction) {
    bindFunction('wheel', '', this.wheel.bind(this));
  }
}

const wheelConfigResolver = coordinatesConfigResolver;

class HoverEngine extends CoordinatesEngine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "ingKey", 'hovering');
  }
  enter(event) {
    if (this.config.mouseOnly && event.pointerType !== 'mouse') return;
    this.start(event);
    this.computeValues(pointerValues(event));
    this.compute(event);
    this.emit();
  }
  leave(event) {
    if (this.config.mouseOnly && event.pointerType !== 'mouse') return;
    const state = this.state;
    if (!state._active) return;
    state._active = false;
    const values = pointerValues(event);
    state._movement = state._delta = _maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.V.sub(values, state._values);
    this.computeValues(values);
    this.compute(event);
    state.delta = state.movement;
    this.emit();
  }
  bind(bindFunction) {
    bindFunction('pointer', 'enter', this.enter.bind(this));
    bindFunction('pointer', 'leave', this.leave.bind(this));
  }
}

const hoverConfigResolver = _objectSpread2(_objectSpread2({}, coordinatesConfigResolver), {}, {
  mouseOnly: (value = true) => value
});

const EngineMap = new Map();
const ConfigResolverMap = new Map();
function registerAction(action) {
  EngineMap.set(action.key, action.engine);
  ConfigResolverMap.set(action.key, action.resolver);
}
const dragAction = {
  key: 'drag',
  engine: DragEngine,
  resolver: dragConfigResolver
};
const hoverAction = {
  key: 'hover',
  engine: HoverEngine,
  resolver: hoverConfigResolver
};
const moveAction = {
  key: 'move',
  engine: MoveEngine,
  resolver: moveConfigResolver
};
const pinchAction = {
  key: 'pinch',
  engine: PinchEngine,
  resolver: pinchConfigResolver
};
const scrollAction = {
  key: 'scroll',
  engine: ScrollEngine,
  resolver: scrollConfigResolver
};
const wheelAction = {
  key: 'wheel',
  engine: WheelEngine,
  resolver: wheelConfigResolver
};




/***/ }),

/***/ "./node_modules/@use-gesture/core/dist/maths-0ab39ae9.esm.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@use-gesture/core/dist/maths-0ab39ae9.esm.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: () => (/* binding */ V),
/* harmony export */   c: () => (/* binding */ computeRubberband),
/* harmony export */   r: () => (/* binding */ rubberbandIfOutOfBounds)
/* harmony export */ });
function clamp(v, min, max) {
  return Math.max(min, Math.min(v, max));
}
const V = {
  toVector(v, fallback) {
    if (v === undefined) v = fallback;
    return Array.isArray(v) ? v : [v, v];
  },
  add(v1, v2) {
    return [v1[0] + v2[0], v1[1] + v2[1]];
  },
  sub(v1, v2) {
    return [v1[0] - v2[0], v1[1] - v2[1]];
  },
  addTo(v1, v2) {
    v1[0] += v2[0];
    v1[1] += v2[1];
  },
  subTo(v1, v2) {
    v1[0] -= v2[0];
    v1[1] -= v2[1];
  }
};
function rubberband(distance, dimension, constant) {
  if (dimension === 0 || Math.abs(dimension) === Infinity) return Math.pow(distance, constant * 5);
  return distance * dimension * constant / (dimension + constant * distance);
}
function rubberbandIfOutOfBounds(position, min, max, constant = 0.15) {
  if (constant === 0) return clamp(position, min, max);
  if (position < min) return -rubberband(min - position, max - min, constant) + min;
  if (position > max) return +rubberband(position - max, max - min, constant) + max;
  return position;
}
function computeRubberband(bounds, [Vx, Vy], [Rx, Ry]) {
  const [[X0, X1], [Y0, Y1]] = bounds;
  return [rubberbandIfOutOfBounds(Vx, X0, X1, Rx), rubberbandIfOutOfBounds(Vy, Y0, Y1, Ry)];
}




/***/ }),

/***/ "./node_modules/@use-gesture/core/dist/use-gesture-core.esm.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@use-gesture/core/dist/use-gesture-core.esm.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Controller: () => (/* binding */ Controller),
/* harmony export */   parseMergedHandlers: () => (/* binding */ parseMergedHandlers)
/* harmony export */ });
/* harmony import */ var _actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./actions-fe213e88.esm.js */ "./node_modules/@use-gesture/core/dist/actions-fe213e88.esm.js");



function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}

function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose(source, excluded);
  var key, i;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}

const sharedConfigResolver = {
  target(value) {
    if (value) {
      return () => 'current' in value ? value.current : value;
    }
    return undefined;
  },
  enabled(value = true) {
    return value;
  },
  window(value = _actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.S.isBrowser ? window : undefined) {
    return value;
  },
  eventOptions({
    passive = true,
    capture = false
  } = {}) {
    return {
      passive,
      capture
    };
  },
  transform(value) {
    return value;
  }
};

const _excluded = ["target", "eventOptions", "window", "enabled", "transform"];
function resolveWith(config = {}, resolvers) {
  const result = {};
  for (const [key, resolver] of Object.entries(resolvers)) {
    switch (typeof resolver) {
      case 'function':
        if (true) {
          const r = resolver.call(result, config[key], key, config);
          if (!Number.isNaN(r)) result[key] = r;
        } else // removed by dead control flow
{}
        break;
      case 'object':
        result[key] = resolveWith(config[key], resolver);
        break;
      case 'boolean':
        if (resolver) result[key] = config[key];
        break;
    }
  }
  return result;
}
function parse(newConfig, gestureKey, _config = {}) {
  const _ref = newConfig,
    {
      target,
      eventOptions,
      window,
      enabled,
      transform
    } = _ref,
    rest = _objectWithoutProperties(_ref, _excluded);
  _config.shared = resolveWith({
    target,
    eventOptions,
    window,
    enabled,
    transform
  }, sharedConfigResolver);
  if (gestureKey) {
    const resolver = _actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.C.get(gestureKey);
    _config[gestureKey] = resolveWith((0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__._)({
      shared: _config.shared
    }, rest), resolver);
  } else {
    for (const key in rest) {
      const resolver = _actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.C.get(key);
      if (resolver) {
        _config[key] = resolveWith((0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__._)({
          shared: _config.shared
        }, rest[key]), resolver);
      } else if (true) {
        if (!['drag', 'pinch', 'scroll', 'wheel', 'move', 'hover'].includes(key)) {
          if (key === 'domTarget') {
            throw Error(`[@use-gesture]: \`domTarget\` option has been renamed to \`target\`.`);
          }
          console.warn(`[@use-gesture]: Unknown config key \`${key}\` was used. Please read the documentation for further information.`);
        }
      }
    }
  }
  return _config;
}

class EventStore {
  constructor(ctrl, gestureKey) {
    (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.a)(this, "_listeners", new Set());
    this._ctrl = ctrl;
    this._gestureKey = gestureKey;
  }
  add(element, device, action, handler, options) {
    const listeners = this._listeners;
    const type = (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.t)(device, action);
    const _options = this._gestureKey ? this._ctrl.config[this._gestureKey].eventOptions : {};
    const eventOptions = (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__._)((0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__._)({}, _options), options);
    element.addEventListener(type, handler, eventOptions);
    const remove = () => {
      element.removeEventListener(type, handler, eventOptions);
      listeners.delete(remove);
    };
    listeners.add(remove);
    return remove;
  }
  clean() {
    this._listeners.forEach(remove => remove());
    this._listeners.clear();
  }
}

class TimeoutStore {
  constructor() {
    (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.a)(this, "_timeouts", new Map());
  }
  add(key, callback, ms = 140, ...args) {
    this.remove(key);
    this._timeouts.set(key, window.setTimeout(callback, ms, ...args));
  }
  remove(key) {
    const timeout = this._timeouts.get(key);
    if (timeout) window.clearTimeout(timeout);
  }
  clean() {
    this._timeouts.forEach(timeout => void window.clearTimeout(timeout));
    this._timeouts.clear();
  }
}

class Controller {
  constructor(handlers) {
    (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.a)(this, "gestures", new Set());
    (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.a)(this, "_targetEventStore", new EventStore(this));
    (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.a)(this, "gestureEventStores", {});
    (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.a)(this, "gestureTimeoutStores", {});
    (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.a)(this, "handlers", {});
    (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.a)(this, "config", {});
    (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.a)(this, "pointerIds", new Set());
    (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.a)(this, "touchIds", new Set());
    (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.a)(this, "state", {
      shared: {
        shiftKey: false,
        metaKey: false,
        ctrlKey: false,
        altKey: false
      }
    });
    resolveGestures(this, handlers);
  }
  setEventIds(event) {
    if ((0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.i)(event)) {
      this.touchIds = new Set((0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.b)(event));
      return this.touchIds;
    } else if ('pointerId' in event) {
      if (event.type === 'pointerup' || event.type === 'pointercancel') this.pointerIds.delete(event.pointerId);else if (event.type === 'pointerdown') this.pointerIds.add(event.pointerId);
      return this.pointerIds;
    }
  }
  applyHandlers(handlers, nativeHandlers) {
    this.handlers = handlers;
    this.nativeHandlers = nativeHandlers;
  }
  applyConfig(config, gestureKey) {
    this.config = parse(config, gestureKey, this.config);
  }
  clean() {
    this._targetEventStore.clean();
    for (const key of this.gestures) {
      this.gestureEventStores[key].clean();
      this.gestureTimeoutStores[key].clean();
    }
  }
  effect() {
    if (this.config.shared.target) this.bind();
    return () => this._targetEventStore.clean();
  }
  bind(...args) {
    const sharedConfig = this.config.shared;
    const props = {};
    let target;
    if (sharedConfig.target) {
      target = sharedConfig.target();
      if (!target) return;
    }
    if (sharedConfig.enabled) {
      for (const gestureKey of this.gestures) {
        const gestureConfig = this.config[gestureKey];
        const bindFunction = bindToProps(props, gestureConfig.eventOptions, !!target);
        if (gestureConfig.enabled) {
          const Engine = _actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.E.get(gestureKey);
          new Engine(this, args, gestureKey).bind(bindFunction);
        }
      }
      const nativeBindFunction = bindToProps(props, sharedConfig.eventOptions, !!target);
      for (const eventKey in this.nativeHandlers) {
        nativeBindFunction(eventKey, '', event => this.nativeHandlers[eventKey]((0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__._)((0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__._)({}, this.state.shared), {}, {
          event,
          args
        })), undefined, true);
      }
    }
    for (const handlerProp in props) {
      props[handlerProp] = (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.c)(...props[handlerProp]);
    }
    if (!target) return props;
    for (const handlerProp in props) {
      const {
        device,
        capture,
        passive
      } = (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.p)(handlerProp);
      this._targetEventStore.add(target, device, '', props[handlerProp], {
        capture,
        passive
      });
    }
  }
}
function setupGesture(ctrl, gestureKey) {
  ctrl.gestures.add(gestureKey);
  ctrl.gestureEventStores[gestureKey] = new EventStore(ctrl, gestureKey);
  ctrl.gestureTimeoutStores[gestureKey] = new TimeoutStore();
}
function resolveGestures(ctrl, internalHandlers) {
  if (internalHandlers.drag) setupGesture(ctrl, 'drag');
  if (internalHandlers.wheel) setupGesture(ctrl, 'wheel');
  if (internalHandlers.scroll) setupGesture(ctrl, 'scroll');
  if (internalHandlers.move) setupGesture(ctrl, 'move');
  if (internalHandlers.pinch) setupGesture(ctrl, 'pinch');
  if (internalHandlers.hover) setupGesture(ctrl, 'hover');
}
const bindToProps = (props, eventOptions, withPassiveOption) => (device, action, handler, options = {}, isNative = false) => {
  var _options$capture, _options$passive;
  const capture = (_options$capture = options.capture) !== null && _options$capture !== void 0 ? _options$capture : eventOptions.capture;
  const passive = (_options$passive = options.passive) !== null && _options$passive !== void 0 ? _options$passive : eventOptions.passive;
  let handlerProp = isNative ? device : (0,_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.d)(device, action, capture);
  if (withPassiveOption && passive) handlerProp += 'Passive';
  props[handlerProp] = props[handlerProp] || [];
  props[handlerProp].push(handler);
};

const RE_NOT_NATIVE = /^on(Drag|Wheel|Scroll|Move|Pinch|Hover)/;
function sortHandlers(_handlers) {
  const native = {};
  const handlers = {};
  const actions = new Set();
  for (let key in _handlers) {
    if (RE_NOT_NATIVE.test(key)) {
      actions.add(RegExp.lastMatch);
      handlers[key] = _handlers[key];
    } else {
      native[key] = _handlers[key];
    }
  }
  return [handlers, native, actions];
}
function registerGesture(actions, handlers, handlerKey, key, internalHandlers, config) {
  if (!actions.has(handlerKey)) return;
  if (!_actions_fe213e88_esm_js__WEBPACK_IMPORTED_MODULE_0__.E.has(key)) {
    if (true) {
      console.warn(`[@use-gesture]: You've created a custom handler that that uses the \`${key}\` gesture but isn't properly configured.\n\nPlease add \`${key}Action\` when creating your handler.`);
    }
    return;
  }
  const startKey = handlerKey + 'Start';
  const endKey = handlerKey + 'End';
  const fn = state => {
    let memo = undefined;
    if (state.first && startKey in handlers) handlers[startKey](state);
    if (handlerKey in handlers) memo = handlers[handlerKey](state);
    if (state.last && endKey in handlers) handlers[endKey](state);
    return memo;
  };
  internalHandlers[key] = fn;
  config[key] = config[key] || {};
}
function parseMergedHandlers(mergedHandlers, mergedConfig) {
  const [handlers, nativeHandlers, actions] = sortHandlers(mergedHandlers);
  const internalHandlers = {};
  registerGesture(actions, handlers, 'onDrag', 'drag', internalHandlers, mergedConfig);
  registerGesture(actions, handlers, 'onWheel', 'wheel', internalHandlers, mergedConfig);
  registerGesture(actions, handlers, 'onScroll', 'scroll', internalHandlers, mergedConfig);
  registerGesture(actions, handlers, 'onPinch', 'pinch', internalHandlers, mergedConfig);
  registerGesture(actions, handlers, 'onMove', 'move', internalHandlers, mergedConfig);
  registerGesture(actions, handlers, 'onHover', 'hover', internalHandlers, mergedConfig);
  return {
    handlers: internalHandlers,
    config: mergedConfig,
    nativeHandlers
  };
}




/***/ }),

/***/ "./node_modules/@use-gesture/core/types/dist/use-gesture-core-types.esm.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@use-gesture/core/types/dist/use-gesture-core-types.esm.js ***!
  \*********************************************************************************/
/***/ (() => {




/***/ }),

/***/ "./node_modules/@use-gesture/core/utils/dist/use-gesture-core-utils.esm.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@use-gesture/core/utils/dist/use-gesture-core-utils.esm.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   rubberbandIfOutOfBounds: () => (/* reexport safe */ _dist_maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__.r)
/* harmony export */ });
/* harmony import */ var _dist_maths_0ab39ae9_esm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../dist/maths-0ab39ae9.esm.js */ "./node_modules/@use-gesture/core/dist/maths-0ab39ae9.esm.js");



/***/ }),

/***/ "./node_modules/@use-gesture/react/dist/use-gesture-react.esm.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@use-gesture/react/dist/use-gesture-react.esm.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConfigResolverMap: () => (/* reexport safe */ _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.ConfigResolverMap),
/* harmony export */   EngineMap: () => (/* reexport safe */ _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.EngineMap),
/* harmony export */   createUseGesture: () => (/* binding */ createUseGesture),
/* harmony export */   dragAction: () => (/* reexport safe */ _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.dragAction),
/* harmony export */   hoverAction: () => (/* reexport safe */ _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.hoverAction),
/* harmony export */   moveAction: () => (/* reexport safe */ _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.moveAction),
/* harmony export */   pinchAction: () => (/* reexport safe */ _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.pinchAction),
/* harmony export */   registerAction: () => (/* reexport safe */ _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.registerAction),
/* harmony export */   rubberbandIfOutOfBounds: () => (/* reexport safe */ _use_gesture_core_utils__WEBPACK_IMPORTED_MODULE_3__.rubberbandIfOutOfBounds),
/* harmony export */   scrollAction: () => (/* reexport safe */ _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.scrollAction),
/* harmony export */   useDrag: () => (/* binding */ useDrag),
/* harmony export */   useGesture: () => (/* binding */ useGesture),
/* harmony export */   useHover: () => (/* binding */ useHover),
/* harmony export */   useMove: () => (/* binding */ useMove),
/* harmony export */   usePinch: () => (/* binding */ usePinch),
/* harmony export */   useScroll: () => (/* binding */ useScroll),
/* harmony export */   useWheel: () => (/* binding */ useWheel),
/* harmony export */   wheelAction: () => (/* reexport safe */ _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.wheelAction)
/* harmony export */ });
/* harmony import */ var _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @use-gesture/core/actions */ "./node_modules/@use-gesture/core/actions/dist/use-gesture-core-actions.esm.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _use_gesture_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @use-gesture/core */ "./node_modules/@use-gesture/core/dist/use-gesture-core.esm.js");
/* harmony import */ var _use_gesture_core_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @use-gesture/core/utils */ "./node_modules/@use-gesture/core/utils/dist/use-gesture-core-utils.esm.js");
/* harmony import */ var _use_gesture_core_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @use-gesture/core/types */ "./node_modules/@use-gesture/core/types/dist/use-gesture-core-types.esm.js");
/* harmony import */ var _use_gesture_core_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_use_gesture_core_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony reexport (unknown) */ var __WEBPACK_REEXPORT_OBJECT__ = {};
/* harmony reexport (unknown) */ for(const __WEBPACK_IMPORT_KEY__ in _use_gesture_core_types__WEBPACK_IMPORTED_MODULE_4__) if(["default","createUseGesture","useDrag","useGesture","useHover","useMove","usePinch","useScroll","useWheel","ConfigResolverMap","EngineMap","dragAction","hoverAction","moveAction","pinchAction","registerAction","scrollAction","wheelAction","rubberbandIfOutOfBounds"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) __WEBPACK_REEXPORT_OBJECT__[__WEBPACK_IMPORT_KEY__] = () => _use_gesture_core_types__WEBPACK_IMPORTED_MODULE_4__[__WEBPACK_IMPORT_KEY__]
/* harmony reexport (unknown) */ __webpack_require__.d(__webpack_exports__, __WEBPACK_REEXPORT_OBJECT__);







function useRecognizers(handlers, config = {}, gestureKey, nativeHandlers) {
  const ctrl = react__WEBPACK_IMPORTED_MODULE_1___default().useMemo(() => new _use_gesture_core__WEBPACK_IMPORTED_MODULE_2__.Controller(handlers), []);
  ctrl.applyHandlers(handlers, nativeHandlers);
  ctrl.applyConfig(config, gestureKey);
  react__WEBPACK_IMPORTED_MODULE_1___default().useEffect(ctrl.effect.bind(ctrl));
  react__WEBPACK_IMPORTED_MODULE_1___default().useEffect(() => {
    return ctrl.clean.bind(ctrl);
  }, []);
  if (config.target === undefined) {
    return ctrl.bind.bind(ctrl);
  }
  return undefined;
}

function useDrag(handler, config) {
  (0,_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.registerAction)(_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.dragAction);
  return useRecognizers({
    drag: handler
  }, config || {}, 'drag');
}

function usePinch(handler, config) {
  (0,_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.registerAction)(_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.pinchAction);
  return useRecognizers({
    pinch: handler
  }, config || {}, 'pinch');
}

function useWheel(handler, config) {
  (0,_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.registerAction)(_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.wheelAction);
  return useRecognizers({
    wheel: handler
  }, config || {}, 'wheel');
}

function useScroll(handler, config) {
  (0,_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.registerAction)(_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.scrollAction);
  return useRecognizers({
    scroll: handler
  }, config || {}, 'scroll');
}

function useMove(handler, config) {
  (0,_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.registerAction)(_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.moveAction);
  return useRecognizers({
    move: handler
  }, config || {}, 'move');
}

function useHover(handler, config) {
  (0,_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.registerAction)(_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.hoverAction);
  return useRecognizers({
    hover: handler
  }, config || {}, 'hover');
}

function createUseGesture(actions) {
  actions.forEach(_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.registerAction);
  return function useGesture(_handlers, _config) {
    const {
      handlers,
      nativeHandlers,
      config
    } = (0,_use_gesture_core__WEBPACK_IMPORTED_MODULE_2__.parseMergedHandlers)(_handlers, _config || {});
    return useRecognizers(handlers, config, undefined, nativeHandlers);
  };
}

function useGesture(handlers, config) {
  const hook = createUseGesture([_use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.dragAction, _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.pinchAction, _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.scrollAction, _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.wheelAction, _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.moveAction, _use_gesture_core_actions__WEBPACK_IMPORTED_MODULE_0__.hoverAction]);
  return hook(handlers, config || {});
}




/***/ }),

/***/ "./node_modules/@wordpress/a11y/build-module/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@wordpress/a11y/build-module/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   setup: () => (/* binding */ setup),
/* harmony export */   speak: () => (/* reexport safe */ _shared_index__WEBPACK_IMPORTED_MODULE_3__.speak)
/* harmony export */ });
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/dom-ready */ "./node_modules/@wordpress/dom-ready/build-module/index.js");
/* harmony import */ var _script_add_container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./script/add-container */ "./node_modules/@wordpress/a11y/build-module/script/add-container.js");
/* harmony import */ var _script_add_intro_text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./script/add-intro-text */ "./node_modules/@wordpress/a11y/build-module/script/add-intro-text.js");
/* harmony import */ var _shared_index__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/index */ "./node_modules/@wordpress/a11y/build-module/shared/index.js");
// packages/a11y/src/index.js




function setup() {
  const introText = document.getElementById("a11y-speak-intro-text");
  const containerAssertive = document.getElementById(
    "a11y-speak-assertive"
  );
  const containerPolite = document.getElementById("a11y-speak-polite");
  if (introText === null) {
    (0,_script_add_intro_text__WEBPACK_IMPORTED_MODULE_2__["default"])();
  }
  if (containerAssertive === null) {
    (0,_script_add_container__WEBPACK_IMPORTED_MODULE_1__["default"])("assertive");
  }
  if (containerPolite === null) {
    (0,_script_add_container__WEBPACK_IMPORTED_MODULE_1__["default"])("polite");
  }
}
(0,_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_0__["default"])(setup);

//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/@wordpress/a11y/build-module/script/add-container.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/a11y/build-module/script/add-container.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ addContainer)
/* harmony export */ });
// packages/a11y/src/script/add-container.js
function addContainer(ariaLive = "polite") {
  const container = document.createElement("div");
  container.id = `a11y-speak-${ariaLive}`;
  container.className = "a11y-speak-region";
  container.setAttribute(
    "style",
    "position:absolute;margin:-1px;padding:0;height:1px;width:1px;overflow:hidden;clip-path:inset(50%);border:0;word-wrap:normal !important;"
  );
  container.setAttribute("aria-live", ariaLive);
  container.setAttribute("aria-relevant", "additions text");
  container.setAttribute("aria-atomic", "true");
  const { body } = document;
  if (body) {
    body.appendChild(container);
  }
  return container;
}

//# sourceMappingURL=add-container.js.map


/***/ }),

/***/ "./node_modules/@wordpress/a11y/build-module/script/add-intro-text.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wordpress/a11y/build-module/script/add-intro-text.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ addIntroText)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/index.js");
// packages/a11y/src/script/add-intro-text.ts

function addIntroText() {
  const introText = document.createElement("p");
  introText.id = "a11y-speak-intro-text";
  introText.className = "a11y-speak-intro-text";
  introText.textContent = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Notifications");
  introText.setAttribute(
    "style",
    "position:absolute;margin:-1px;padding:0;height:1px;width:1px;overflow:hidden;clip-path:inset(50%);border:0;word-wrap:normal !important;"
  );
  introText.setAttribute("hidden", "");
  const { body } = document;
  if (body) {
    body.appendChild(introText);
  }
  return introText;
}

//# sourceMappingURL=add-intro-text.js.map


/***/ }),

/***/ "./node_modules/@wordpress/a11y/build-module/shared/clear.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@wordpress/a11y/build-module/shared/clear.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ clear)
/* harmony export */ });
// packages/a11y/src/shared/clear.js
function clear() {
  const regions = document.getElementsByClassName("a11y-speak-region");
  const introText = document.getElementById("a11y-speak-intro-text");
  for (let i = 0; i < regions.length; i++) {
    regions[i].textContent = "";
  }
  if (introText) {
    introText.setAttribute("hidden", "hidden");
  }
}

//# sourceMappingURL=clear.js.map


/***/ }),

/***/ "./node_modules/@wordpress/a11y/build-module/shared/filter-message.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wordpress/a11y/build-module/shared/filter-message.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ filterMessage)
/* harmony export */ });
// packages/a11y/src/shared/filter-message.js
var previousMessage = "";
function filterMessage(message) {
  message = message.replace(/<[^<>]+>/g, " ");
  if (previousMessage === message) {
    message += "\xA0";
  }
  previousMessage = message;
  return message;
}

//# sourceMappingURL=filter-message.js.map


/***/ }),

/***/ "./node_modules/@wordpress/a11y/build-module/shared/index.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@wordpress/a11y/build-module/shared/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   speak: () => (/* binding */ speak)
/* harmony export */ });
/* harmony import */ var _clear__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./clear */ "./node_modules/@wordpress/a11y/build-module/shared/clear.js");
/* harmony import */ var _filter_message__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./filter-message */ "./node_modules/@wordpress/a11y/build-module/shared/filter-message.js");
// packages/a11y/src/shared/index.js


function speak(message, ariaLive) {
  (0,_clear__WEBPACK_IMPORTED_MODULE_0__["default"])();
  message = (0,_filter_message__WEBPACK_IMPORTED_MODULE_1__["default"])(message);
  const introText = document.getElementById("a11y-speak-intro-text");
  const containerAssertive = document.getElementById(
    "a11y-speak-assertive"
  );
  const containerPolite = document.getElementById("a11y-speak-polite");
  if (containerAssertive && ariaLive === "assertive") {
    containerAssertive.textContent = message;
  } else if (containerPolite) {
    containerPolite.textContent = message;
  }
  if (introText) {
    introText.removeAttribute("hidden");
  }
}

//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/create-i18n.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/create-i18n.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createI18n: () => (/* binding */ createI18n)
/* harmony export */ });
/* harmony import */ var tannin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tannin */ "./node_modules/tannin/index.js");
// packages/i18n/src/create-i18n.ts

var DEFAULT_LOCALE_DATA = {
  "": {
    plural_forms(n) {
      return n === 1 ? 0 : 1;
    }
  }
};
var I18N_HOOK_REGEXP = /^i18n\.(n?gettext|has_translation)(_|$)/;
var createI18n = (initialData, initialDomain, hooks) => {
  const tannin = new tannin__WEBPACK_IMPORTED_MODULE_0__["default"]({});
  const listeners = /* @__PURE__ */ new Set();
  const notifyListeners = () => {
    listeners.forEach((listener) => listener());
  };
  const subscribe = (callback) => {
    listeners.add(callback);
    return () => listeners.delete(callback);
  };
  const getLocaleData = (domain = "default") => tannin.data[domain];
  const doSetLocaleData = (data, domain = "default") => {
    tannin.data[domain] = {
      ...tannin.data[domain],
      ...data
    };
    tannin.data[domain][""] = {
      ...DEFAULT_LOCALE_DATA[""],
      ...tannin.data[domain]?.[""]
    };
    delete tannin.pluralForms[domain];
  };
  const setLocaleData = (data, domain) => {
    doSetLocaleData(data, domain);
    notifyListeners();
  };
  const addLocaleData = (data, domain = "default") => {
    tannin.data[domain] = {
      ...tannin.data[domain],
      ...data,
      // Populate default domain configuration (supported locale date which omits
      // a plural forms expression).
      "": {
        ...DEFAULT_LOCALE_DATA[""],
        ...tannin.data[domain]?.[""],
        ...data?.[""]
      }
    };
    delete tannin.pluralForms[domain];
    notifyListeners();
  };
  const resetLocaleData = (data, domain) => {
    tannin.data = {};
    tannin.pluralForms = {};
    setLocaleData(data, domain);
  };
  const dcnpgettext = (domain = "default", context, single, plural, number) => {
    if (!tannin.data[domain]) {
      doSetLocaleData(void 0, domain);
    }
    return tannin.dcnpgettext(domain, context, single, plural, number);
  };
  const getFilterDomain = (domain) => domain || "default";
  const __ = (text, domain) => {
    let translation = dcnpgettext(domain, void 0, text);
    if (!hooks) {
      return translation;
    }
    translation = hooks.applyFilters(
      "i18n.gettext",
      translation,
      text,
      domain
    );
    return hooks.applyFilters(
      "i18n.gettext_" + getFilterDomain(domain),
      translation,
      text,
      domain
    );
  };
  const _x = (text, context, domain) => {
    let translation = dcnpgettext(domain, context, text);
    if (!hooks) {
      return translation;
    }
    translation = hooks.applyFilters(
      "i18n.gettext_with_context",
      translation,
      text,
      context,
      domain
    );
    return hooks.applyFilters(
      "i18n.gettext_with_context_" + getFilterDomain(domain),
      translation,
      text,
      context,
      domain
    );
  };
  const _n = (single, plural, number, domain) => {
    let translation = dcnpgettext(
      domain,
      void 0,
      single,
      plural,
      number
    );
    if (!hooks) {
      return translation;
    }
    translation = hooks.applyFilters(
      "i18n.ngettext",
      translation,
      single,
      plural,
      number,
      domain
    );
    return hooks.applyFilters(
      "i18n.ngettext_" + getFilterDomain(domain),
      translation,
      single,
      plural,
      number,
      domain
    );
  };
  const _nx = (single, plural, number, context, domain) => {
    let translation = dcnpgettext(
      domain,
      context,
      single,
      plural,
      number
    );
    if (!hooks) {
      return translation;
    }
    translation = hooks.applyFilters(
      "i18n.ngettext_with_context",
      translation,
      single,
      plural,
      number,
      context,
      domain
    );
    return hooks.applyFilters(
      "i18n.ngettext_with_context_" + getFilterDomain(domain),
      translation,
      single,
      plural,
      number,
      context,
      domain
    );
  };
  const isRTL = () => {
    return "rtl" === _x("ltr", "text direction");
  };
  const hasTranslation = (single, context, domain) => {
    const key = context ? context + "" + single : single;
    let result = !!tannin.data?.[domain ?? "default"]?.[key];
    if (hooks) {
      result = hooks.applyFilters(
        "i18n.has_translation",
        result,
        single,
        context,
        domain
      );
      result = hooks.applyFilters(
        "i18n.has_translation_" + getFilterDomain(domain),
        result,
        single,
        context,
        domain
      );
    }
    return result;
  };
  if (initialData) {
    setLocaleData(initialData, initialDomain);
  }
  if (hooks) {
    const onHookAddedOrRemoved = (hookName) => {
      if (I18N_HOOK_REGEXP.test(hookName)) {
        notifyListeners();
      }
    };
    hooks.addAction("hookAdded", "core/i18n", onHookAddedOrRemoved);
    hooks.addAction("hookRemoved", "core/i18n", onHookAddedOrRemoved);
  }
  return {
    getLocaleData,
    setLocaleData,
    addLocaleData,
    resetLocaleData,
    subscribe,
    __,
    _x,
    _n,
    _nx,
    isRTL,
    hasTranslation
  };
};

//# sourceMappingURL=create-i18n.js.map


/***/ }),

/***/ "./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/default-i18n.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/default-i18n.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __: () => (/* binding */ __),
/* harmony export */   _n: () => (/* binding */ _n),
/* harmony export */   _nx: () => (/* binding */ _nx),
/* harmony export */   _x: () => (/* binding */ _x),
/* harmony export */   "default": () => (/* binding */ default_i18n_default),
/* harmony export */   getLocaleData: () => (/* binding */ getLocaleData),
/* harmony export */   hasTranslation: () => (/* binding */ hasTranslation),
/* harmony export */   isRTL: () => (/* binding */ isRTL),
/* harmony export */   resetLocaleData: () => (/* binding */ resetLocaleData),
/* harmony export */   setLocaleData: () => (/* binding */ setLocaleData),
/* harmony export */   subscribe: () => (/* binding */ subscribe)
/* harmony export */ });
/* harmony import */ var _create_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./create-i18n */ "./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/create-i18n.js");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/hooks */ "./node_modules/@wordpress/hooks/build-module/index.js");
// packages/i18n/src/default-i18n.ts


var i18n = (0,_create_i18n__WEBPACK_IMPORTED_MODULE_0__.createI18n)(void 0, void 0, _wordpress_hooks__WEBPACK_IMPORTED_MODULE_1__.defaultHooks);
var default_i18n_default = i18n;
var getLocaleData = i18n.getLocaleData.bind(i18n);
var setLocaleData = i18n.setLocaleData.bind(i18n);
var resetLocaleData = i18n.resetLocaleData.bind(i18n);
var subscribe = i18n.subscribe.bind(i18n);
var __ = i18n.__.bind(i18n);
var _x = i18n._x.bind(i18n);
var _n = i18n._n.bind(i18n);
var _nx = i18n._nx.bind(i18n);
var isRTL = i18n.isRTL.bind(i18n);
var hasTranslation = i18n.hasTranslation.bind(i18n);

//# sourceMappingURL=default-i18n.js.map


/***/ }),

/***/ "./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/index.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/index.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __: () => (/* reexport safe */ _default_i18n__WEBPACK_IMPORTED_MODULE_2__.__),
/* harmony export */   _n: () => (/* reexport safe */ _default_i18n__WEBPACK_IMPORTED_MODULE_2__._n),
/* harmony export */   _nx: () => (/* reexport safe */ _default_i18n__WEBPACK_IMPORTED_MODULE_2__._nx),
/* harmony export */   _x: () => (/* reexport safe */ _default_i18n__WEBPACK_IMPORTED_MODULE_2__._x),
/* harmony export */   createI18n: () => (/* reexport safe */ _create_i18n__WEBPACK_IMPORTED_MODULE_1__.createI18n),
/* harmony export */   defaultI18n: () => (/* reexport safe */ _default_i18n__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   getLocaleData: () => (/* reexport safe */ _default_i18n__WEBPACK_IMPORTED_MODULE_2__.getLocaleData),
/* harmony export */   hasTranslation: () => (/* reexport safe */ _default_i18n__WEBPACK_IMPORTED_MODULE_2__.hasTranslation),
/* harmony export */   isRTL: () => (/* reexport safe */ _default_i18n__WEBPACK_IMPORTED_MODULE_2__.isRTL),
/* harmony export */   resetLocaleData: () => (/* reexport safe */ _default_i18n__WEBPACK_IMPORTED_MODULE_2__.resetLocaleData),
/* harmony export */   setLocaleData: () => (/* reexport safe */ _default_i18n__WEBPACK_IMPORTED_MODULE_2__.setLocaleData),
/* harmony export */   sprintf: () => (/* reexport safe */ _sprintf__WEBPACK_IMPORTED_MODULE_0__.sprintf),
/* harmony export */   subscribe: () => (/* reexport safe */ _default_i18n__WEBPACK_IMPORTED_MODULE_2__.subscribe)
/* harmony export */ });
/* harmony import */ var _sprintf__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sprintf */ "./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/sprintf.js");
/* harmony import */ var _create_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./create-i18n */ "./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/create-i18n.js");
/* harmony import */ var _default_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./default-i18n */ "./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/default-i18n.js");
// packages/i18n/src/index.ts




//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/sprintf.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@wordpress/a11y/node_modules/@wordpress/i18n/build-module/sprintf.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sprintf: () => (/* binding */ sprintf)
/* harmony export */ });
/* harmony import */ var _tannin_sprintf__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tannin/sprintf */ "./node_modules/@tannin/sprintf/src/index.js");
// packages/i18n/src/sprintf.ts

function sprintf(format, ...args) {
  return (0,_tannin_sprintf__WEBPACK_IMPORTED_MODULE_0__["default"])(format, ...args);
}

//# sourceMappingURL=sprintf.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _middlewares_nonce__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./middlewares/nonce */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/nonce.js");
/* harmony import */ var _middlewares_root_url__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./middlewares/root-url */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/root-url.js");
/* harmony import */ var _middlewares_preloading__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./middlewares/preloading */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/preloading.js");
/* harmony import */ var _middlewares_fetch_all_middleware__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./middlewares/fetch-all-middleware */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/fetch-all-middleware.js");
/* harmony import */ var _middlewares_namespace_endpoint__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./middlewares/namespace-endpoint */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/namespace-endpoint.js");
/* harmony import */ var _middlewares_http_v1__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./middlewares/http-v1 */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/http-v1.js");
/* harmony import */ var _middlewares_user_locale__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./middlewares/user-locale */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/user-locale.js");
/* harmony import */ var _middlewares_media_upload__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./middlewares/media-upload */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/media-upload.js");
/* harmony import */ var _middlewares_theme_preview__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./middlewares/theme-preview */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/theme-preview.js");
/* harmony import */ var _utils_response__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./utils/response */ "./node_modules/@wordpress/api-fetch/build-module/utils/response.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











/**
 * Default set of header values which should be sent with every request unless
 * explicitly provided through apiFetch options.
 *
 * @type {Record<string, string>}
 */
const DEFAULT_HEADERS = {
  // The backend uses the Accept header as a condition for considering an
  // incoming request as a REST request.
  //
  // See: https://core.trac.wordpress.org/ticket/44534
  Accept: 'application/json, */*;q=0.1'
};

/**
 * Default set of fetch option values which should be sent with every request
 * unless explicitly provided through apiFetch options.
 *
 * @type {Object}
 */
const DEFAULT_OPTIONS = {
  credentials: 'include'
};

/** @typedef {import('./types').APIFetchMiddleware} APIFetchMiddleware */
/** @typedef {import('./types').APIFetchOptions} APIFetchOptions */

/**
 * @type {import('./types').APIFetchMiddleware[]}
 */
const middlewares = [_middlewares_user_locale__WEBPACK_IMPORTED_MODULE_7__["default"], _middlewares_namespace_endpoint__WEBPACK_IMPORTED_MODULE_5__["default"], _middlewares_http_v1__WEBPACK_IMPORTED_MODULE_6__["default"], _middlewares_fetch_all_middleware__WEBPACK_IMPORTED_MODULE_4__["default"]];

/**
 * Register a middleware
 *
 * @param {import('./types').APIFetchMiddleware} middleware
 */
function registerMiddleware(middleware) {
  middlewares.unshift(middleware);
}

/**
 * Checks the status of a response, throwing the Response as an error if
 * it is outside the 200 range.
 *
 * @param {Response} response
 * @return {Response} The response if the status is in the 200 range.
 */
const checkStatus = response => {
  if (response.status >= 200 && response.status < 300) {
    return response;
  }
  throw response;
};

/** @typedef {(options: import('./types').APIFetchOptions) => Promise<any>} FetchHandler*/

/**
 * @type {FetchHandler}
 */
const defaultFetchHandler = nextOptions => {
  const {
    url,
    path,
    data,
    parse = true,
    ...remainingOptions
  } = nextOptions;
  let {
    body,
    headers
  } = nextOptions;

  // Merge explicitly-provided headers with default values.
  headers = {
    ...DEFAULT_HEADERS,
    ...headers
  };

  // The `data` property is a shorthand for sending a JSON body.
  if (data) {
    body = JSON.stringify(data);
    headers['Content-Type'] = 'application/json';
  }
  const responsePromise = window.fetch(
  // Fall back to explicitly passing `window.location` which is the behavior if `undefined` is passed.
  url || path || window.location.href, {
    ...DEFAULT_OPTIONS,
    ...remainingOptions,
    body,
    headers
  });
  return responsePromise.then(value => Promise.resolve(value).then(checkStatus).catch(response => (0,_utils_response__WEBPACK_IMPORTED_MODULE_10__.parseAndThrowError)(response, parse)).then(response => (0,_utils_response__WEBPACK_IMPORTED_MODULE_10__.parseResponseAndNormalizeError)(response, parse)), err => {
    // Re-throw AbortError for the users to handle it themselves.
    if (err && err.name === 'AbortError') {
      throw err;
    }

    // Otherwise, there is most likely no network connection.
    // Unfortunately the message might depend on the browser.
    throw {
      code: 'fetch_error',
      message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You are probably offline.')
    };
  });
};

/** @type {FetchHandler} */
let fetchHandler = defaultFetchHandler;

/**
 * Defines a custom fetch handler for making the requests that will override
 * the default one using window.fetch
 *
 * @param {FetchHandler} newFetchHandler The new fetch handler
 */
function setFetchHandler(newFetchHandler) {
  fetchHandler = newFetchHandler;
}

/**
 * @template T
 * @param {import('./types').APIFetchOptions} options
 * @return {Promise<T>} A promise representing the request processed via the registered middlewares.
 */
function apiFetch(options) {
  // creates a nested function chain that calls all middlewares and finally the `fetchHandler`,
  // converting `middlewares = [ m1, m2, m3 ]` into:
  // ```
  // opts1 => m1( opts1, opts2 => m2( opts2, opts3 => m3( opts3, fetchHandler ) ) );
  // ```
  const enhancedHandler = middlewares.reduceRight(( /** @type {FetchHandler} */next, middleware) => {
    return workingOptions => middleware(workingOptions, next);
  }, fetchHandler);
  return enhancedHandler(options).catch(error => {
    if (error.code !== 'rest_cookie_invalid_nonce') {
      return Promise.reject(error);
    }

    // If the nonce is invalid, refresh it and try again.
    return window
    // @ts-ignore
    .fetch(apiFetch.nonceEndpoint).then(checkStatus).then(data => data.text()).then(text => {
      // @ts-ignore
      apiFetch.nonceMiddleware.nonce = text;
      return apiFetch(options);
    });
  });
}
apiFetch.use = registerMiddleware;
apiFetch.setFetchHandler = setFetchHandler;
apiFetch.createNonceMiddleware = _middlewares_nonce__WEBPACK_IMPORTED_MODULE_1__["default"];
apiFetch.createPreloadingMiddleware = _middlewares_preloading__WEBPACK_IMPORTED_MODULE_3__["default"];
apiFetch.createRootURLMiddleware = _middlewares_root_url__WEBPACK_IMPORTED_MODULE_2__["default"];
apiFetch.fetchAllMiddleware = _middlewares_fetch_all_middleware__WEBPACK_IMPORTED_MODULE_4__["default"];
apiFetch.mediaUploadMiddleware = _middlewares_media_upload__WEBPACK_IMPORTED_MODULE_8__["default"];
apiFetch.createThemePreviewMiddleware = _middlewares_theme_preview__WEBPACK_IMPORTED_MODULE_9__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (apiFetch);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/fetch-all-middleware.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/fetch-all-middleware.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./node_modules/@wordpress/api-fetch/build-module/index.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Apply query arguments to both URL and Path, whichever is present.
 *
 * @param {import('../types').APIFetchOptions} props
 * @param {Record<string, string | number>}    queryArgs
 * @return {import('../types').APIFetchOptions} The request with the modified query args
 */
const modifyQuery = ({
  path,
  url,
  ...options
}, queryArgs) => ({
  ...options,
  url: url && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(url, queryArgs),
  path: path && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(path, queryArgs)
});

/**
 * Duplicates parsing functionality from apiFetch.
 *
 * @param {Response} response
 * @return {Promise<any>} Parsed response json.
 */
const parseResponse = response => response.json ? response.json() : Promise.reject(response);

/**
 * @param {string | null} linkHeader
 * @return {{ next?: string }} The parsed link header.
 */
const parseLinkHeader = linkHeader => {
  if (!linkHeader) {
    return {};
  }
  const match = linkHeader.match(/<([^>]+)>; rel="next"/);
  return match ? {
    next: match[1]
  } : {};
};

/**
 * @param {Response} response
 * @return {string | undefined} The next page URL.
 */
const getNextPageUrl = response => {
  const {
    next
  } = parseLinkHeader(response.headers.get('link'));
  return next;
};

/**
 * @param {import('../types').APIFetchOptions} options
 * @return {boolean} True if the request contains an unbounded query.
 */
const requestContainsUnboundedQuery = options => {
  const pathIsUnbounded = !!options.path && options.path.indexOf('per_page=-1') !== -1;
  const urlIsUnbounded = !!options.url && options.url.indexOf('per_page=-1') !== -1;
  return pathIsUnbounded || urlIsUnbounded;
};

/**
 * The REST API enforces an upper limit on the per_page option. To handle large
 * collections, apiFetch consumers can pass `per_page=-1`; this middleware will
 * then recursively assemble a full response array from all available pages.
 *
 * @type {import('../types').APIFetchMiddleware}
 */
const fetchAllMiddleware = async (options, next) => {
  if (options.parse === false) {
    // If a consumer has opted out of parsing, do not apply middleware.
    return next(options);
  }
  if (!requestContainsUnboundedQuery(options)) {
    // If neither url nor path is requesting all items, do not apply middleware.
    return next(options);
  }

  // Retrieve requested page of results.
  const response = await (0,___WEBPACK_IMPORTED_MODULE_1__["default"])({
    ...modifyQuery(options, {
      per_page: 100
    }),
    // Ensure headers are returned for page 1.
    parse: false
  });
  const results = await parseResponse(response);
  if (!Array.isArray(results)) {
    // We have no reliable way of merging non-array results.
    return results;
  }
  let nextPage = getNextPageUrl(response);
  if (!nextPage) {
    // There are no further pages to request.
    return results;
  }

  // Iteratively fetch all remaining pages until no "next" header is found.
  let mergedResults = /** @type {any[]} */[].concat(results);
  while (nextPage) {
    const nextResponse = await (0,___WEBPACK_IMPORTED_MODULE_1__["default"])({
      ...options,
      // Ensure the URL for the next page is used instead of any provided path.
      path: undefined,
      url: nextPage,
      // Ensure we still get headers so we can identify the next page.
      parse: false
    });
    const nextResults = await parseResponse(nextResponse);
    mergedResults = mergedResults.concat(nextResults);
    nextPage = getNextPageUrl(nextResponse);
  }
  return mergedResults;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (fetchAllMiddleware);
//# sourceMappingURL=fetch-all-middleware.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/http-v1.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/http-v1.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Set of HTTP methods which are eligible to be overridden.
 *
 * @type {Set<string>}
 */
const OVERRIDE_METHODS = new Set(['PATCH', 'PUT', 'DELETE']);

/**
 * Default request method.
 *
 * "A request has an associated method (a method). Unless stated otherwise it
 * is `GET`."
 *
 * @see  https://fetch.spec.whatwg.org/#requests
 *
 * @type {string}
 */
const DEFAULT_METHOD = 'GET';

/**
 * API Fetch middleware which overrides the request method for HTTP v1
 * compatibility leveraging the REST API X-HTTP-Method-Override header.
 *
 * @type {import('../types').APIFetchMiddleware}
 */
const httpV1Middleware = (options, next) => {
  const {
    method = DEFAULT_METHOD
  } = options;
  if (OVERRIDE_METHODS.has(method.toUpperCase())) {
    options = {
      ...options,
      headers: {
        ...options.headers,
        'X-HTTP-Method-Override': method,
        'Content-Type': 'application/json'
      },
      method: 'POST'
    };
  }
  return next(options);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (httpV1Middleware);
//# sourceMappingURL=http-v1.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/media-upload.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/media-upload.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _utils_response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/response */ "./node_modules/@wordpress/api-fetch/build-module/utils/response.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * @param {import('../types').APIFetchOptions} options
 * @return {boolean} True if the request is for media upload.
 */
function isMediaUploadRequest(options) {
  const isCreateMethod = !!options.method && options.method === 'POST';
  const isMediaEndpoint = !!options.path && options.path.indexOf('/wp/v2/media') !== -1 || !!options.url && options.url.indexOf('/wp/v2/media') !== -1;
  return isMediaEndpoint && isCreateMethod;
}

/**
 * Middleware handling media upload failures and retries.
 *
 * @type {import('../types').APIFetchMiddleware}
 */
const mediaUploadMiddleware = (options, next) => {
  if (!isMediaUploadRequest(options)) {
    return next(options);
  }
  let retries = 0;
  const maxRetries = 5;

  /**
   * @param {string} attachmentId
   * @return {Promise<any>} Processed post response.
   */
  const postProcess = attachmentId => {
    retries++;
    return next({
      path: `/wp/v2/media/${attachmentId}/post-process`,
      method: 'POST',
      data: {
        action: 'create-image-subsizes'
      },
      parse: false
    }).catch(() => {
      if (retries < maxRetries) {
        return postProcess(attachmentId);
      }
      next({
        path: `/wp/v2/media/${attachmentId}?force=true`,
        method: 'DELETE'
      });
      return Promise.reject();
    });
  };
  return next({
    ...options,
    parse: false
  }).catch(response => {
    const attachmentId = response.headers.get('x-wp-upload-attachment-id');
    if (response.status >= 500 && response.status < 600 && attachmentId) {
      return postProcess(attachmentId).catch(() => {
        if (options.parse !== false) {
          return Promise.reject({
            code: 'post_process',
            message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Media upload failed. If this is a photo or a large image, please scale it down and try again.')
          });
        }
        return Promise.reject(response);
      });
    }
    return (0,_utils_response__WEBPACK_IMPORTED_MODULE_1__.parseAndThrowError)(response, options.parse);
  }).then(response => (0,_utils_response__WEBPACK_IMPORTED_MODULE_1__.parseResponseAndNormalizeError)(response, options.parse));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mediaUploadMiddleware);
//# sourceMappingURL=media-upload.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/namespace-endpoint.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/namespace-endpoint.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @type {import('../types').APIFetchMiddleware}
 */
const namespaceAndEndpointMiddleware = (options, next) => {
  let path = options.path;
  let namespaceTrimmed, endpointTrimmed;
  if (typeof options.namespace === 'string' && typeof options.endpoint === 'string') {
    namespaceTrimmed = options.namespace.replace(/^\/|\/$/g, '');
    endpointTrimmed = options.endpoint.replace(/^\//, '');
    if (endpointTrimmed) {
      path = namespaceTrimmed + '/' + endpointTrimmed;
    } else {
      path = namespaceTrimmed;
    }
  }
  delete options.namespace;
  delete options.endpoint;
  return next({
    ...options,
    path
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (namespaceAndEndpointMiddleware);
//# sourceMappingURL=namespace-endpoint.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/nonce.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/nonce.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @param {string} nonce
 * @return {import('../types').APIFetchMiddleware & { nonce: string }} A middleware to enhance a request with a nonce.
 */
function createNonceMiddleware(nonce) {
  /**
   * @type {import('../types').APIFetchMiddleware & { nonce: string }}
   */
  const middleware = (options, next) => {
    const {
      headers = {}
    } = options;

    // If an 'X-WP-Nonce' header (or any case-insensitive variation
    // thereof) was specified, no need to add a nonce header.
    for (const headerName in headers) {
      if (headerName.toLowerCase() === 'x-wp-nonce' && headers[headerName] === middleware.nonce) {
        return next(options);
      }
    }
    return next({
      ...options,
      headers: {
        ...headers,
        'X-WP-Nonce': middleware.nonce
      }
    });
  };
  middleware.nonce = nonce;
  return middleware;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createNonceMiddleware);
//# sourceMappingURL=nonce.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/preloading.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/preloading.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/url/build-module/get-query-args.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/url/build-module/normalize-path.js");
/**
 * WordPress dependencies
 */


/**
 * @param {Record<string, any>} preloadedData
 * @return {import('../types').APIFetchMiddleware} Preloading middleware.
 */
function createPreloadingMiddleware(preloadedData) {
  const cache = Object.fromEntries(Object.entries(preloadedData).map(([path, data]) => [(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_2__.normalizePath)(path), data]));
  return (options, next) => {
    const {
      parse = true
    } = options;
    /** @type {string | void} */
    let rawPath = options.path;
    if (!rawPath && options.url) {
      const {
        rest_route: pathFromQuery,
        ...queryArgs
      } = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_1__.getQueryArgs)(options.url);
      if (typeof pathFromQuery === 'string') {
        rawPath = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(pathFromQuery, queryArgs);
      }
    }
    if (typeof rawPath !== 'string') {
      return next(options);
    }
    const method = options.method || 'GET';
    const path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_2__.normalizePath)(rawPath);
    if ('GET' === method && cache[path]) {
      const cacheData = cache[path];

      // Unsetting the cache key ensures that the data is only used a single time.
      delete cache[path];
      return prepareResponse(cacheData, !!parse);
    } else if ('OPTIONS' === method && cache[method] && cache[method][path]) {
      const cacheData = cache[method][path];

      // Unsetting the cache key ensures that the data is only used a single time.
      delete cache[method][path];
      return prepareResponse(cacheData, !!parse);
    }
    return next(options);
  };
}

/**
 * This is a helper function that sends a success response.
 *
 * @param {Record<string, any>} responseData
 * @param {boolean}             parse
 * @return {Promise<any>} Promise with the response.
 */
function prepareResponse(responseData, parse) {
  return Promise.resolve(parse ? responseData.body : new window.Response(JSON.stringify(responseData.body), {
    status: 200,
    statusText: 'OK',
    headers: responseData.headers
  }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createPreloadingMiddleware);
//# sourceMappingURL=preloading.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/root-url.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/root-url.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _namespace_endpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./namespace-endpoint */ "./node_modules/@wordpress/api-fetch/build-module/middlewares/namespace-endpoint.js");
/**
 * Internal dependencies
 */


/**
 * @param {string} rootURL
 * @return {import('../types').APIFetchMiddleware} Root URL middleware.
 */
const createRootURLMiddleware = rootURL => (options, next) => {
  return (0,_namespace_endpoint__WEBPACK_IMPORTED_MODULE_0__["default"])(options, optionsWithPath => {
    let url = optionsWithPath.url;
    let path = optionsWithPath.path;
    let apiRoot;
    if (typeof path === 'string') {
      apiRoot = rootURL;
      if (-1 !== rootURL.indexOf('?')) {
        path = path.replace('?', '&');
      }
      path = path.replace(/^\//, '');

      // API root may already include query parameter prefix if site is
      // configured to use plain permalinks.
      if ('string' === typeof apiRoot && -1 !== apiRoot.indexOf('?')) {
        path = path.replace('?', '&');
      }
      url = apiRoot + path;
    }
    return next({
      ...optionsWithPath,
      url
    });
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createRootURLMiddleware);
//# sourceMappingURL=root-url.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/theme-preview.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/theme-preview.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/url/build-module/get-query-arg.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/url/build-module/remove-query-args.js");
/**
 * WordPress dependencies
 */


/**
 * This appends a `wp_theme_preview` parameter to the REST API request URL if
 * the admin URL contains a `theme` GET parameter.
 *
 * If the REST API request URL has contained the `wp_theme_preview` parameter as `''`,
 * then bypass this middleware.
 *
 * @param {Record<string, any>} themePath
 * @return {import('../types').APIFetchMiddleware} Preloading middleware.
 */
const createThemePreviewMiddleware = themePath => (options, next) => {
  if (typeof options.url === 'string') {
    const wpThemePreview = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_1__.getQueryArg)(options.url, 'wp_theme_preview');
    if (wpThemePreview === undefined) {
      options.url = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(options.url, {
        wp_theme_preview: themePath
      });
    } else if (wpThemePreview === '') {
      options.url = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_2__.removeQueryArgs)(options.url, 'wp_theme_preview');
    }
  }
  if (typeof options.path === 'string') {
    const wpThemePreview = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_1__.getQueryArg)(options.path, 'wp_theme_preview');
    if (wpThemePreview === undefined) {
      options.path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(options.path, {
        wp_theme_preview: themePath
      });
    } else if (wpThemePreview === '') {
      options.path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_2__.removeQueryArgs)(options.path, 'wp_theme_preview');
    }
  }
  return next(options);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createThemePreviewMiddleware);
//# sourceMappingURL=theme-preview.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/middlewares/user-locale.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/middlewares/user-locale.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/url/build-module/has-query-arg.js");
/**
 * WordPress dependencies
 */


/**
 * @type {import('../types').APIFetchMiddleware}
 */
const userLocaleMiddleware = (options, next) => {
  if (typeof options.url === 'string' && !(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_1__.hasQueryArg)(options.url, '_locale')) {
    options.url = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(options.url, {
      _locale: 'user'
    });
  }
  if (typeof options.path === 'string' && !(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_1__.hasQueryArg)(options.path, '_locale')) {
    options.path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.addQueryArgs)(options.path, {
      _locale: 'user'
    });
  }
  return next(options);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (userLocaleMiddleware);
//# sourceMappingURL=user-locale.js.map

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build-module/utils/response.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build-module/utils/response.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseAndThrowError: () => (/* binding */ parseAndThrowError),
/* harmony export */   parseResponseAndNormalizeError: () => (/* binding */ parseResponseAndNormalizeError)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/i18n/build-module/index.js");
/**
 * WordPress dependencies
 */


/**
 * Parses the apiFetch response.
 *
 * @param {Response} response
 * @param {boolean}  shouldParseResponse
 *
 * @return {Promise<any> | null | Response} Parsed response.
 */
const parseResponse = (response, shouldParseResponse = true) => {
  if (shouldParseResponse) {
    if (response.status === 204) {
      return null;
    }
    return response.json ? response.json() : Promise.reject(response);
  }
  return response;
};

/**
 * Calls the `json` function on the Response, throwing an error if the response
 * doesn't have a json function or if parsing the json itself fails.
 *
 * @param {Response} response
 * @return {Promise<any>} Parsed response.
 */
const parseJsonAndNormalizeError = response => {
  const invalidJsonError = {
    code: 'invalid_json',
    message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The response is not a valid JSON response.')
  };
  if (!response || !response.json) {
    throw invalidJsonError;
  }
  return response.json().catch(() => {
    throw invalidJsonError;
  });
};

/**
 * Parses the apiFetch response properly and normalize response errors.
 *
 * @param {Response} response
 * @param {boolean}  shouldParseResponse
 *
 * @return {Promise<any>} Parsed response.
 */
const parseResponseAndNormalizeError = (response, shouldParseResponse = true) => {
  return Promise.resolve(parseResponse(response, shouldParseResponse)).catch(res => parseAndThrowError(res, shouldParseResponse));
};

/**
 * Parses a response, throwing an error if parsing the response fails.
 *
 * @param {Response} response
 * @param {boolean}  shouldParseResponse
 * @return {Promise<any>} Parsed response.
 */
function parseAndThrowError(response, shouldParseResponse = true) {
  if (!shouldParseResponse) {
    throw response;
  }
  return parseJsonAndNormalizeError(response).then(error => {
    const unknownError = {
      code: 'unknown_error',
      message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('An unknown error occurred.')
    };
    throw error || unknownError;
  });
}
//# sourceMappingURL=response.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/base-control/hooks.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/base-control/hooks.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useBaseControlProps: () => (/* binding */ useBaseControlProps)
/* harmony export */ });
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! . */ "./node_modules/@wordpress/components/build-module/base-control/index.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

/**
 * Generate props for the `BaseControl` and the inner control itself.
 *
 * Namely, it takes care of generating a unique `id`, properly associating it with the `label` and `help` elements.
 *
 * @param props
 */
function useBaseControlProps(props) {
  const {
    help,
    id: preferredId,
    ...restProps
  } = props;
  const uniqueId = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_0__["default"])(___WEBPACK_IMPORTED_MODULE_1__["default"], 'wp-components-base-control', preferredId);
  return {
    baseControlProps: {
      id: uniqueId,
      help,
      ...restProps
    },
    controlProps: {
      id: uniqueId,
      ...(!!help ? {
        'aria-describedby': `${uniqueId}__help`
      } : {})
    }
  };
}
//# sourceMappingURL=hooks.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/base-control/index.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/base-control/index.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseControl: () => (/* binding */ BaseControl),
/* harmony export */   VisualLabel: () => (/* binding */ VisualLabel),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   useBaseControlProps: () => (/* reexport safe */ _hooks__WEBPACK_IMPORTED_MODULE_8__.useBaseControlProps)
/* harmony export */ });
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.mjs");
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/deprecated */ "./node_modules/@wordpress/deprecated/build-module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _visually_hidden__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../visually-hidden */ "./node_modules/@wordpress/components/build-module/visually-hidden/component.js");
/* harmony import */ var _styles_base_control_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles/base-control-styles */ "./node_modules/@wordpress/components/build-module/base-control/styles/base-control-styles.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../context */ "./node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../context */ "./node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _hooks__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./hooks */ "./node_modules/@wordpress/components/build-module/base-control/hooks.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





const UnconnectedBaseControl = props => {
  const {
    __nextHasNoMarginBottom = false,
    __associatedWPComponentName = 'BaseControl',
    id,
    label,
    hideLabelFromVision = false,
    help,
    className,
    children
  } = (0,_context__WEBPACK_IMPORTED_MODULE_6__.useContextSystem)(props, 'BaseControl');
  if (!__nextHasNoMarginBottom) {
    (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_1__["default"])(`Bottom margin styles for wp.components.${__associatedWPComponentName}`, {
      since: '6.7',
      version: '7.0',
      hint: 'Set the `__nextHasNoMarginBottom` prop to true to start opting into the new styles, which will become the default in a future version.'
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_styles_base_control_styles__WEBPACK_IMPORTED_MODULE_4__.Wrapper, {
    className: className,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_styles_base_control_styles__WEBPACK_IMPORTED_MODULE_4__.StyledField, {
      className: "components-base-control__field"
      // TODO: Official deprecation for this should start after all internal usages have been migrated
      ,
      __nextHasNoMarginBottom: __nextHasNoMarginBottom,
      children: [label && id && (hideLabelFromVision ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_visually_hidden__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "label",
        htmlFor: id,
        children: label
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_styles_base_control_styles__WEBPACK_IMPORTED_MODULE_4__.StyledLabel, {
        className: "components-base-control__label",
        htmlFor: id,
        children: label
      })), label && !id && (hideLabelFromVision ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_visually_hidden__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "label",
        children: label
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(VisualLabel, {
        children: label
      })), children]
    }), !!help && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_styles_base_control_styles__WEBPACK_IMPORTED_MODULE_4__.StyledHelp, {
      id: id ? id + '__help' : undefined,
      className: "components-base-control__help",
      __nextHasNoMarginBottom: __nextHasNoMarginBottom,
      children: help
    })]
  });
};
const UnforwardedVisualLabel = (props, ref) => {
  const {
    className,
    children,
    ...restProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_styles_base_control_styles__WEBPACK_IMPORTED_MODULE_4__.StyledVisualLabel, {
    ref: ref,
    ...restProps,
    className: (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-base-control__label', className),
    children: children
  });
};
const VisualLabel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(UnforwardedVisualLabel);

/**
 * `BaseControl` is a component used to generate labels and help text for components handling user inputs.
 *
 * ```jsx
 * import { BaseControl, useBaseControlProps } from '@wordpress/components';
 *
 * // Render a `BaseControl` for a textarea input
 * const MyCustomTextareaControl = ({ children, ...baseProps }) => (
 * 	// `useBaseControlProps` is a convenience hook to get the props for the `BaseControl`
 * 	// and the inner control itself. Namely, it takes care of generating a unique `id`,
 * 	// properly associating it with the `label` and `help` elements.
 * 	const { baseControlProps, controlProps } = useBaseControlProps( baseProps );
 *
 * 	return (
 * 		<BaseControl { ...baseControlProps } __nextHasNoMarginBottom>
 * 			<textarea { ...controlProps }>
 * 			  { children }
 * 			</textarea>
 * 		</BaseControl>
 * 	);
 * );
 * ```
 */
const BaseControl = Object.assign((0,_context__WEBPACK_IMPORTED_MODULE_5__.contextConnectWithoutRef)(UnconnectedBaseControl, 'BaseControl'), {
  /**
   * `BaseControl.VisualLabel` is used to render a purely visual label inside a `BaseControl` component.
   *
   * It should only be used in cases where the children being rendered inside `BaseControl` are already accessibly labeled,
   * e.g., a button, but we want an additional visual label for that section equivalent to the labels `BaseControl` would
   * otherwise use if the `label` prop was passed.
   *
   * ```jsx
   * import { BaseControl } from '@wordpress/components';
   *
   * const MyBaseControl = () => (
   * 	<BaseControl
   * 		__nextHasNoMarginBottom
   * 		help="This button is already accessibly labeled."
   * 	>
   * 		<BaseControl.VisualLabel>Author</BaseControl.VisualLabel>
   * 		<Button>Select an author</Button>
   * 	</BaseControl>
   * );
   * ```
   */
  VisualLabel
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseControl);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/base-control/styles/base-control-styles.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/base-control/styles/base-control-styles.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StyledField: () => (/* binding */ StyledField),
/* harmony export */   StyledHelp: () => (/* binding */ StyledHelp),
/* harmony export */   StyledLabel: () => (/* binding */ StyledLabel),
/* harmony export */   StyledVisualLabel: () => (/* binding */ StyledVisualLabel),
/* harmony export */   Wrapper: () => (/* binding */ Wrapper)
/* harmony export */ });
/* harmony import */ var _emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/styled/base */ "./node_modules/@emotion/styled/base/dist/emotion-styled-base.browser.development.esm.js");
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils */ "./node_modules/@wordpress/components/build-module/utils/box-sizing.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils */ "./node_modules/@wordpress/components/build-module/utils/font.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils */ "./node_modules/@wordpress/components/build-module/utils/colors-values.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils */ "./node_modules/@wordpress/components/build-module/utils/base-label.js");
/* harmony import */ var _utils_space__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/space */ "./node_modules/@wordpress/components/build-module/utils/space.js");

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


const Wrapper = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("div",  false ? 0 : {
  target: "ej5x27r4",
  label: "Wrapper"
})("font-family:", (0,_utils__WEBPACK_IMPORTED_MODULE_3__.font)('default.fontFamily'), ";font-size:", (0,_utils__WEBPACK_IMPORTED_MODULE_3__.font)('default.fontSize'), ";", _utils__WEBPACK_IMPORTED_MODULE_2__.boxSizingReset, ";" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
const deprecatedMarginField = ({
  __nextHasNoMarginBottom = false
}) => {
  return !__nextHasNoMarginBottom && /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)("margin-bottom:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_6__.space)(2), ";" + ( false ? 0 : ";label:deprecatedMarginField;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
};
const StyledField = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("div",  false ? 0 : {
  target: "ej5x27r3",
  label: "StyledField"
})(deprecatedMarginField, " .components-panel__row &{margin-bottom:inherit;}" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
const labelStyles = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)(_utils__WEBPACK_IMPORTED_MODULE_5__.baseLabelTypography, ";display:block;margin-bottom:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_6__.space)(2), ";padding:0;" + ( false ? 0 : ";label:labelStyles;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvYmFzZS1jb250cm9sL3N0eWxlcy9iYXNlLWNvbnRyb2wtc3R5bGVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQW9DdUIiLCJmaWxlIjoiQHdvcmRwcmVzcy9jb21wb25lbnRzL3NyYy9iYXNlLWNvbnRyb2wvc3R5bGVzL2Jhc2UtY29udHJvbC1zdHlsZXMudHMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEV4dGVybmFsIGRlcGVuZGVuY2llc1xuICovXG5pbXBvcnQgc3R5bGVkIGZyb20gJ0BlbW90aW9uL3N0eWxlZCc7XG5pbXBvcnQgeyBjc3MgfSBmcm9tICdAZW1vdGlvbi9yZWFjdCc7XG5cbi8qKlxuICogSW50ZXJuYWwgZGVwZW5kZW5jaWVzXG4gKi9cbmltcG9ydCB7IGJhc2VMYWJlbFR5cG9ncmFwaHksIGJveFNpemluZ1Jlc2V0LCBmb250LCBDT0xPUlMgfSBmcm9tICcuLi8uLi91dGlscyc7XG5pbXBvcnQgeyBzcGFjZSB9IGZyb20gJy4uLy4uL3V0aWxzL3NwYWNlJztcblxuZXhwb3J0IGNvbnN0IFdyYXBwZXIgPSBzdHlsZWQuZGl2YFxuXHRmb250LWZhbWlseTogJHsgZm9udCggJ2RlZmF1bHQuZm9udEZhbWlseScgKSB9O1xuXHRmb250LXNpemU6ICR7IGZvbnQoICdkZWZhdWx0LmZvbnRTaXplJyApIH07XG5cblx0JHsgYm94U2l6aW5nUmVzZXQgfVxuYDtcblxuY29uc3QgZGVwcmVjYXRlZE1hcmdpbkZpZWxkID0gKCB7IF9fbmV4dEhhc05vTWFyZ2luQm90dG9tID0gZmFsc2UgfSApID0+IHtcblx0cmV0dXJuIChcblx0XHQhIF9fbmV4dEhhc05vTWFyZ2luQm90dG9tICYmXG5cdFx0Y3NzYFxuXHRcdFx0bWFyZ2luLWJvdHRvbTogJHsgc3BhY2UoIDIgKSB9O1xuXHRcdGBcblx0KTtcbn07XG5cbmV4cG9ydCBjb25zdCBTdHlsZWRGaWVsZCA9IHN0eWxlZC5kaXZgXG5cdCR7IGRlcHJlY2F0ZWRNYXJnaW5GaWVsZCB9XG5cblx0LmNvbXBvbmVudHMtcGFuZWxfX3JvdyAmIHtcblx0XHRtYXJnaW4tYm90dG9tOiBpbmhlcml0O1xuXHR9XG5gO1xuXG5jb25zdCBsYWJlbFN0eWxlcyA9IGNzc2Bcblx0JHsgYmFzZUxhYmVsVHlwb2dyYXBoeSB9O1xuXG5cdGRpc3BsYXk6IGJsb2NrO1xuXHRtYXJnaW4tYm90dG9tOiAkeyBzcGFjZSggMiApIH07XG5cdC8qKlxuXHQgKiBSZW1vdmVzIENocm9tZS9TYWZhcmkvRmlyZWZveCB1c2VyIGFnZW50IHN0eWxlc2hlZXQgcGFkZGluZyBmcm9tXG5cdCAqIFN0eWxlZExhYmVsIHdoZW4gaXQgaXMgcmVuZGVyZWQgYXMgYSBsZWdlbmQuXG5cdCAqL1xuXHRwYWRkaW5nOiAwO1xuYDtcblxuZXhwb3J0IGNvbnN0IFN0eWxlZExhYmVsID0gc3R5bGVkLmxhYmVsYFxuXHQkeyBsYWJlbFN0eWxlcyB9XG5gO1xuXG5jb25zdCBkZXByZWNhdGVkTWFyZ2luSGVscCA9ICggeyBfX25leHRIYXNOb01hcmdpbkJvdHRvbSA9IGZhbHNlIH0gKSA9PiB7XG5cdHJldHVybiAoXG5cdFx0ISBfX25leHRIYXNOb01hcmdpbkJvdHRvbSAmJlxuXHRcdGNzc2Bcblx0XHRcdG1hcmdpbi1ib3R0b206IHJldmVydDtcblx0XHRgXG5cdCk7XG59O1xuXG5leHBvcnQgY29uc3QgU3R5bGVkSGVscCA9IHN0eWxlZC5wYFxuXHRtYXJnaW4tdG9wOiAkeyBzcGFjZSggMiApIH07XG5cdG1hcmdpbi1ib3R0b206IDA7XG5cdGZvbnQtc2l6ZTogJHsgZm9udCggJ2hlbHBUZXh0LmZvbnRTaXplJyApIH07XG5cdGZvbnQtc3R5bGU6IG5vcm1hbDtcblx0Y29sb3I6ICR7IENPTE9SUy5ncmF5WyA3MDAgXSB9O1xuXG5cdCR7IGRlcHJlY2F0ZWRNYXJnaW5IZWxwIH1cbmA7XG5cbmV4cG9ydCBjb25zdCBTdHlsZWRWaXN1YWxMYWJlbCA9IHN0eWxlZC5zcGFuYFxuXHQkeyBsYWJlbFN0eWxlcyB9XG5gO1xuIl19 */");
const StyledLabel = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("label",  false ? 0 : {
  target: "ej5x27r2",
  label: "StyledLabel"
})(labelStyles, ";" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
var _ref =  false ? 0 : {
  name: "1xen9ob-deprecatedMarginHelp",
  styles: "margin-bottom:revert;label:deprecatedMarginHelp;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const deprecatedMarginHelp = ({
  __nextHasNoMarginBottom = false
}) => {
  return !__nextHasNoMarginBottom && _ref;
};
const StyledHelp = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("p",  false ? 0 : {
  target: "ej5x27r1",
  label: "StyledHelp"
})("margin-top:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_6__.space)(2), ";margin-bottom:0;font-size:", (0,_utils__WEBPACK_IMPORTED_MODULE_3__.font)('helpText.fontSize'), ";font-style:normal;color:", _utils__WEBPACK_IMPORTED_MODULE_4__.COLORS.gray[700], ";", deprecatedMarginHelp, ";" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
const StyledVisualLabel = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("span",  false ? 0 : {
  target: "ej5x27r0",
  label: "StyledVisualLabel"
})(labelStyles, ";" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
//# sourceMappingURL=base-control-styles.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/button/index.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/button/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Button: () => (/* binding */ Button),
/* harmony export */   UnforwardedButton: () => (/* binding */ UnforwardedButton),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.mjs");
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/deprecated */ "./node_modules/@wordpress/deprecated/build-module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _tooltip__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../tooltip */ "./node_modules/@wordpress/components/build-module/tooltip/index.js");
/* harmony import */ var _icon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../icon */ "./node_modules/@wordpress/components/build-module/icon/index.js");
/* harmony import */ var _visually_hidden__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../visually-hidden */ "./node_modules/@wordpress/components/build-module/visually-hidden/component.js");
/* harmony import */ var _popover_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../popover/utils */ "./node_modules/@wordpress/components/build-module/popover/utils.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





const disabledEventsOnDisabledButton = ['onMouseDown', 'onClick'];
function useDeprecatedProps({
  __experimentalIsFocusable,
  isDefault,
  isPrimary,
  isSecondary,
  isTertiary,
  isLink,
  isPressed,
  isSmall,
  size,
  variant,
  describedBy,
  ...otherProps
}) {
  let computedSize = size;
  let computedVariant = variant;
  const newProps = {
    accessibleWhenDisabled: __experimentalIsFocusable,
    // @todo Mark `isPressed` as deprecated
    'aria-pressed': isPressed,
    description: describedBy
  };
  if (isSmall) {
    var _computedSize;
    (_computedSize = computedSize) !== null && _computedSize !== void 0 ? _computedSize : computedSize = 'small';
  }
  if (isPrimary) {
    var _computedVariant;
    (_computedVariant = computedVariant) !== null && _computedVariant !== void 0 ? _computedVariant : computedVariant = 'primary';
  }
  if (isTertiary) {
    var _computedVariant2;
    (_computedVariant2 = computedVariant) !== null && _computedVariant2 !== void 0 ? _computedVariant2 : computedVariant = 'tertiary';
  }
  if (isSecondary) {
    var _computedVariant3;
    (_computedVariant3 = computedVariant) !== null && _computedVariant3 !== void 0 ? _computedVariant3 : computedVariant = 'secondary';
  }
  if (isDefault) {
    var _computedVariant4;
    (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_1__["default"])('wp.components.Button `isDefault` prop', {
      since: '5.4',
      alternative: 'variant="secondary"'
    });
    (_computedVariant4 = computedVariant) !== null && _computedVariant4 !== void 0 ? _computedVariant4 : computedVariant = 'secondary';
  }
  if (isLink) {
    var _computedVariant5;
    (_computedVariant5 = computedVariant) !== null && _computedVariant5 !== void 0 ? _computedVariant5 : computedVariant = 'link';
  }
  return {
    ...newProps,
    ...otherProps,
    size: computedSize,
    variant: computedVariant
  };
}
function UnforwardedButton(props, ref) {
  const {
    __next40pxDefaultSize,
    accessibleWhenDisabled,
    isBusy,
    isDestructive,
    className,
    disabled,
    icon,
    iconPosition = 'left',
    iconSize,
    showTooltip,
    tooltipPosition,
    shortcut,
    label,
    children,
    size = 'default',
    text,
    variant,
    description,
    ...buttonOrAnchorProps
  } = useDeprecatedProps(props);
  const {
    href,
    target,
    'aria-checked': ariaChecked,
    'aria-pressed': ariaPressed,
    'aria-selected': ariaSelected,
    ...additionalProps
  } = 'href' in buttonOrAnchorProps ? buttonOrAnchorProps : {
    href: undefined,
    target: undefined,
    ...buttonOrAnchorProps
  };
  const instanceId = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__["default"])(Button, 'components-button__description');
  const hasChildren = 'string' === typeof children && !!children || Array.isArray(children) && children?.[0] && children[0] !== null &&
  // Tooltip should not considered as a child
  children?.[0]?.props?.className !== 'components-tooltip';
  const truthyAriaPressedValues = [true, 'true', 'mixed'];
  const classes = (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-button', className, {
    'is-next-40px-default-size': __next40pxDefaultSize,
    'is-secondary': variant === 'secondary',
    'is-primary': variant === 'primary',
    'is-small': size === 'small',
    'is-compact': size === 'compact',
    'is-tertiary': variant === 'tertiary',
    'is-pressed': truthyAriaPressedValues.includes(ariaPressed),
    'is-pressed-mixed': ariaPressed === 'mixed',
    'is-busy': isBusy,
    'is-link': variant === 'link',
    'is-destructive': isDestructive,
    'has-text': !!icon && (hasChildren || text),
    'has-icon': !!icon
  });
  const trulyDisabled = disabled && !accessibleWhenDisabled;
  const Tag = href !== undefined && !disabled ? 'a' : 'button';
  const buttonProps = Tag === 'button' ? {
    type: 'button',
    disabled: trulyDisabled,
    'aria-checked': ariaChecked,
    'aria-pressed': ariaPressed,
    'aria-selected': ariaSelected
  } : {};
  const anchorProps = Tag === 'a' ? {
    href,
    target
  } : {};
  const disableEventProps = {};
  if (disabled && accessibleWhenDisabled) {
    // In this case, the button will be disabled, but still focusable and
    // perceivable by screen reader users.
    buttonProps['aria-disabled'] = true;
    anchorProps['aria-disabled'] = true;
    for (const disabledEvent of disabledEventsOnDisabledButton) {
      disableEventProps[disabledEvent] = event => {
        if (event) {
          event.stopPropagation();
          event.preventDefault();
        }
      };
    }
  }

  // Should show the tooltip if...
  const shouldShowTooltip = !trulyDisabled && (
  // An explicit tooltip is passed or...
  showTooltip && !!label ||
  // There's a shortcut or...
  !!shortcut ||
  // There's a label and...
  !!label &&
  // The children are empty and...
  !children?.length &&
  // The tooltip is not explicitly disabled.
  false !== showTooltip);
  const descriptionId = description ? instanceId : undefined;
  const describedById = additionalProps['aria-describedby'] || descriptionId;
  const commonProps = {
    className: classes,
    'aria-label': additionalProps['aria-label'] || label,
    'aria-describedby': describedById,
    ref
  };
  const elementChildren = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
    children: [icon && iconPosition === 'left' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_icon__WEBPACK_IMPORTED_MODULE_5__["default"], {
      icon: icon,
      size: iconSize
    }), text && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
      children: text
    }), children, icon && iconPosition === 'right' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_icon__WEBPACK_IMPORTED_MODULE_5__["default"], {
      icon: icon,
      size: iconSize
    })]
  });
  const element = Tag === 'a' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("a", {
    ...anchorProps,
    ...additionalProps,
    ...disableEventProps,
    ...commonProps,
    children: elementChildren
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("button", {
    ...buttonProps,
    ...additionalProps,
    ...disableEventProps,
    ...commonProps,
    children: elementChildren
  });

  // In order to avoid some React reconciliation issues, we are always rendering
  // the `Tooltip` component even when `shouldShowTooltip` is `false`.
  // In order to make sure that the tooltip doesn't show when it shouldn't,
  // we don't pass the props to the `Tooltip` component.
  const tooltipProps = shouldShowTooltip ? {
    text: children?.length && description ? description : label,
    shortcut,
    placement: tooltipPosition &&
    // Convert legacy `position` values to be used with the new `placement` prop
    (0,_popover_utils__WEBPACK_IMPORTED_MODULE_7__.positionToPlacement)(tooltipPosition)
  } : {};
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_tooltip__WEBPACK_IMPORTED_MODULE_4__["default"], {
      ...tooltipProps,
      children: element
    }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_visually_hidden__WEBPACK_IMPORTED_MODULE_6__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
        id: descriptionId,
        children: description
      })
    })]
  });
}

/**
 * Lets users take actions and make choices with a single click or tap.
 *
 * ```jsx
 * import { Button } from '@wordpress/components';
 * const Mybutton = () => (
 *   <Button
 *     variant="primary"
 *     onClick={ handleClick }
 *   >
 *     Click here
 *   </Button>
 * );
 * ```
 */
const Button = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(UnforwardedButton);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Button);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/context/constants.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/context/constants.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   COMPONENT_NAMESPACE: () => (/* binding */ COMPONENT_NAMESPACE),
/* harmony export */   CONNECTED_NAMESPACE: () => (/* binding */ CONNECTED_NAMESPACE),
/* harmony export */   CONNECT_STATIC_NAMESPACE: () => (/* binding */ CONNECT_STATIC_NAMESPACE)
/* harmony export */ });
const COMPONENT_NAMESPACE = 'data-wp-component';
const CONNECTED_NAMESPACE = 'data-wp-c16t';

/**
 * Special key where the connected namespaces are stored.
 * This is attached to Context connected components as a static property.
 */
const CONNECT_STATIC_NAMESPACE = '__contextSystemKey__';
//# sourceMappingURL=constants.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/context/context-connect.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/context/context-connect.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   contextConnect: () => (/* binding */ contextConnect),
/* harmony export */   contextConnectWithoutRef: () => (/* binding */ contextConnectWithoutRef),
/* harmony export */   getConnectNamespace: () => (/* binding */ getConnectNamespace),
/* harmony export */   hasConnectNamespace: () => (/* binding */ hasConnectNamespace)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_warning__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/warning */ "./node_modules/@wordpress/warning/build-module/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./node_modules/@wordpress/components/build-module/context/constants.js");
/* harmony import */ var _get_styled_class_name_from_key__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./get-styled-class-name-from-key */ "./node_modules/@wordpress/components/build-module/context/get-styled-class-name-from-key.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Forwards ref (React.ForwardRef) and "Connects" (or registers) a component
 * within the Context system under a specified namespace.
 *
 * @param Component The component to register into the Context system.
 * @param namespace The namespace to register the component under.
 * @return The connected WordPressComponent
 */
function contextConnect(Component, namespace) {
  return _contextConnect(Component, namespace, {
    forwardsRef: true
  });
}

/**
 * "Connects" (or registers) a component within the Context system under a specified namespace.
 * Does not forward a ref.
 *
 * @param Component The component to register into the Context system.
 * @param namespace The namespace to register the component under.
 * @return The connected WordPressComponent
 */
function contextConnectWithoutRef(Component, namespace) {
  return _contextConnect(Component, namespace);
}

// This is an (experimental) evolution of the initial connect() HOC.
// The hope is that we can improve render performance by removing functional
// component wrappers.
function _contextConnect(Component, namespace, options) {
  const WrappedComponent = options?.forwardsRef ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(Component) : Component;
  if (typeof namespace === 'undefined') {
    globalThis.SCRIPT_DEBUG === true ? (0,_wordpress_warning__WEBPACK_IMPORTED_MODULE_1__["default"])('contextConnect: Please provide a namespace') : void 0;
  }

  // @ts-expect-error internal property
  let mergedNamespace = WrappedComponent[_constants__WEBPACK_IMPORTED_MODULE_2__.CONNECT_STATIC_NAMESPACE] || [namespace];

  /**
   * Consolidate (merge) namespaces before attaching it to the WrappedComponent.
   */
  if (Array.isArray(namespace)) {
    mergedNamespace = [...mergedNamespace, ...namespace];
  }
  if (typeof namespace === 'string') {
    mergedNamespace = [...mergedNamespace, namespace];
  }

  // @ts-expect-error We can't rely on inferred types here because of the
  // `as` prop polymorphism we're handling in https://github.com/WordPress/gutenberg/blob/4f3a11243c365f94892e479bff0b922ccc4ccda3/packages/components/src/context/wordpress-component.ts#L32-L33
  return Object.assign(WrappedComponent, {
    [_constants__WEBPACK_IMPORTED_MODULE_2__.CONNECT_STATIC_NAMESPACE]: [...new Set(mergedNamespace)],
    displayName: namespace,
    selector: `.${(0,_get_styled_class_name_from_key__WEBPACK_IMPORTED_MODULE_3__.getStyledClassNameFromKey)(namespace)}`
  });
}

/**
 * Attempts to retrieve the connected namespace from a component.
 *
 * @param Component The component to retrieve a namespace from.
 * @return The connected namespaces.
 */
function getConnectNamespace(Component) {
  if (!Component) {
    return [];
  }
  let namespaces = [];

  // @ts-ignore internal property
  if (Component[_constants__WEBPACK_IMPORTED_MODULE_2__.CONNECT_STATIC_NAMESPACE]) {
    // @ts-ignore internal property
    namespaces = Component[_constants__WEBPACK_IMPORTED_MODULE_2__.CONNECT_STATIC_NAMESPACE];
  }

  // @ts-ignore
  if (Component.type && Component.type[_constants__WEBPACK_IMPORTED_MODULE_2__.CONNECT_STATIC_NAMESPACE]) {
    // @ts-ignore
    namespaces = Component.type[_constants__WEBPACK_IMPORTED_MODULE_2__.CONNECT_STATIC_NAMESPACE];
  }
  return namespaces;
}

/**
 * Checks to see if a component is connected within the Context system.
 *
 * @param Component The component to retrieve a namespace from.
 * @param match     The namespace to check.
 */
function hasConnectNamespace(Component, match) {
  if (!Component) {
    return false;
  }
  if (typeof match === 'string') {
    return getConnectNamespace(Component).includes(match);
  }
  if (Array.isArray(match)) {
    return match.some(result => getConnectNamespace(Component).includes(result));
  }
  return false;
}
//# sourceMappingURL=context-connect.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/context/context-system-provider.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/context/context-system-provider.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ComponentsContext: () => (/* binding */ ComponentsContext),
/* harmony export */   ContextSystemProvider: () => (/* binding */ ContextSystemProvider),
/* harmony export */   useComponentsContext: () => (/* binding */ useComponentsContext)
/* harmony export */ });
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var fast_deep_equal_es6__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! fast-deep-equal/es6 */ "./node_modules/@wordpress/components/node_modules/fast-deep-equal/es6/index.js");
/* harmony import */ var fast_deep_equal_es6__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(fast_deep_equal_es6__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var is_plain_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! is-plain-object */ "./node_modules/is-plain-object/dist/is-plain-object.mjs");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_warning__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/warning */ "./node_modules/@wordpress/warning/build-module/index.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils */ "./node_modules/@wordpress/components/build-module/utils/hooks/use-update-effect.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const ComponentsContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.createContext)(/** @type {Record<string, any>} */{});
const useComponentsContext = () => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useContext)(ComponentsContext);

/**
 * Consolidates incoming ContextSystem values with a (potential) parent ContextSystem value.
 *
 * Note: This function will warn if it detects an un-memoized `value`
 *
 * @param {Object}              props
 * @param {Record<string, any>} props.value
 * @return {Record<string, any>} The consolidated value.
 */
function useContextSystemBridge({
  value
}) {
  const parentContext = useComponentsContext();
  const valueRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)(value);
  (0,_utils__WEBPACK_IMPORTED_MODULE_5__["default"])(() => {
    if (
    // Objects are equivalent.
    fast_deep_equal_es6__WEBPACK_IMPORTED_MODULE_1___default()(valueRef.current, value) &&
    // But not the same reference.
    valueRef.current !== value) {
      globalThis.SCRIPT_DEBUG === true ? (0,_wordpress_warning__WEBPACK_IMPORTED_MODULE_4__["default"])(`Please memoize your context: ${JSON.stringify(value)}`) : void 0;
    }
  }, [value]);

  // `parentContext` will always be memoized (i.e., the result of this hook itself)
  // or the default value from when the `ComponentsContext` was originally
  // initialized (which will never change, it's a static variable)
  // so this memoization will prevent `deepmerge()` from rerunning unless
  // the references to `value` change OR the `parentContext` has an actual material change
  // (because again, it's guaranteed to be memoized or a static reference to the empty object
  // so we know that the only changes for `parentContext` are material ones... i.e., why we
  // don't have to warn in the `useUpdateEffect` hook above for `parentContext` and we only
  // need to bother with the `value`). The `useUpdateEffect` above will ensure that we are
  // correctly warning when the `value` isn't being properly memoized. All of that to say
  // that this should be super safe to assume that `useMemo` will only run on actual
  // changes to the two dependencies, therefore saving us calls to `deepmerge()`!
  const config = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
    // Deep clone `parentContext` to avoid mutating it later.
    return deepmerge__WEBPACK_IMPORTED_MODULE_0___default()(parentContext !== null && parentContext !== void 0 ? parentContext : {}, value !== null && value !== void 0 ? value : {}, {
      isMergeableObject: is_plain_object__WEBPACK_IMPORTED_MODULE_2__.isPlainObject
    });
  }, [parentContext, value]);
  return config;
}

/**
 * A Provider component that can modify props for connected components within
 * the Context system.
 *
 * @example
 * ```jsx
 * <ContextSystemProvider value={{ Button: { size: 'small' }}}>
 *   <Button>...</Button>
 * </ContextSystemProvider>
 * ```
 *
 * @template {Record<string, any>} T
 * @param {Object}                    options
 * @param {import('react').ReactNode} options.children Children to render.
 * @param {T}                         options.value    Props to render into connected components.
 * @return {JSX.Element} A Provider wrapped component.
 */
const BaseContextSystemProvider = ({
  children,
  value
}) => {
  const contextValue = useContextSystemBridge({
    value
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(ComponentsContext.Provider, {
    value: contextValue,
    children: children
  });
};
const ContextSystemProvider = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.memo)(BaseContextSystemProvider);
//# sourceMappingURL=context-system-provider.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/context/get-styled-class-name-from-key.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/context/get-styled-class-name-from-key.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStyledClassNameFromKey: () => (/* binding */ getStyledClassNameFromKey)
/* harmony export */ });
/* harmony import */ var change_case__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! change-case */ "./node_modules/param-case/dist.es2015/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "./node_modules/memize/dist/index.js");
/**
 * External dependencies
 */



/**
 * Generates the connected component CSS className based on the namespace.
 *
 * @param namespace The name of the connected component.
 * @return The generated CSS className.
 */
function getStyledClassName(namespace) {
  const kebab = (0,change_case__WEBPACK_IMPORTED_MODULE_0__.paramCase)(namespace);
  return `components-${kebab}`;
}
const getStyledClassNameFromKey = (0,memize__WEBPACK_IMPORTED_MODULE_1__["default"])(getStyledClassName);
//# sourceMappingURL=get-styled-class-name-from-key.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/context/use-context-system.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/context/use-context-system.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useContextSystem: () => (/* binding */ useContextSystem)
/* harmony export */ });
/* harmony import */ var _wordpress_warning__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/warning */ "./node_modules/@wordpress/warning/build-module/index.js");
/* harmony import */ var _context_system_provider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./context-system-provider */ "./node_modules/@wordpress/components/build-module/context/context-system-provider.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ "./node_modules/@wordpress/components/build-module/context/utils.js");
/* harmony import */ var _get_styled_class_name_from_key__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./get-styled-class-name-from-key */ "./node_modules/@wordpress/components/build-module/context/get-styled-class-name-from-key.js");
/* harmony import */ var _utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/hooks/use-cx */ "./node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





/**
 * @template TProps
 * @typedef {TProps & { className: string }} ConnectedProps
 */

/**
 * Custom hook that derives registered props from the Context system.
 * These derived props are then consolidated with incoming component props.
 *
 * @template {{ className?: string }} P
 * @param {P}      props     Incoming props from the component.
 * @param {string} namespace The namespace to register and to derive context props from.
 * @return {ConnectedProps<P>} The connected props.
 */
function useContextSystem(props, namespace) {
  const contextSystemProps = (0,_context_system_provider__WEBPACK_IMPORTED_MODULE_1__.useComponentsContext)();
  if (typeof namespace === 'undefined') {
    globalThis.SCRIPT_DEBUG === true ? (0,_wordpress_warning__WEBPACK_IMPORTED_MODULE_0__["default"])('useContextSystem: Please provide a namespace') : void 0;
  }
  const contextProps = contextSystemProps?.[namespace] || {};

  /* eslint-disable jsdoc/no-undefined-types */
  /** @type {ConnectedProps<P>} */
  // @ts-ignore We fill in the missing properties below
  const finalComponentProps = {
    ...(0,_utils__WEBPACK_IMPORTED_MODULE_2__.getConnectedNamespace)(),
    ...(0,_utils__WEBPACK_IMPORTED_MODULE_2__.getNamespace)(namespace)
  };
  /* eslint-enable jsdoc/no-undefined-types */

  const {
    _overrides: overrideProps,
    ...otherContextProps
  } = contextProps;
  const initialMergedProps = Object.entries(otherContextProps).length ? Object.assign({}, otherContextProps, props) : props;
  const cx = (0,_utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_4__.useCx)();
  const classes = cx((0,_get_styled_class_name_from_key__WEBPACK_IMPORTED_MODULE_3__.getStyledClassNameFromKey)(namespace), props.className);

  // Provides the ability to customize the render of the component.
  const rendered = typeof initialMergedProps.renderChildren === 'function' ? initialMergedProps.renderChildren(initialMergedProps) : initialMergedProps.children;
  for (const key in initialMergedProps) {
    // @ts-ignore filling in missing props
    finalComponentProps[key] = initialMergedProps[key];
  }
  for (const key in overrideProps) {
    // @ts-ignore filling in missing props
    finalComponentProps[key] = overrideProps[key];
  }

  // Setting an `undefined` explicitly can cause unintended overwrites
  // when a `cloneElement()` is involved.
  if (rendered !== undefined) {
    // @ts-ignore
    finalComponentProps.children = rendered;
  }
  finalComponentProps.className = classes;
  return finalComponentProps;
}
//# sourceMappingURL=use-context-system.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/context/utils.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/context/utils.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getConnectedNamespace: () => (/* binding */ getConnectedNamespace),
/* harmony export */   getNamespace: () => (/* binding */ getNamespace)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./node_modules/@wordpress/components/build-module/context/constants.js");
/**
 * Internal dependencies
 */


/**
 * Creates a dedicated context namespace HTML attribute for components.
 * ns is short for "namespace"
 *
 * @example
 * ```jsx
 * <div {...ns('Container')} />
 * ```
 *
 * @param {string} componentName The name for the component.
 * @return {Record<string, any>} A props object with the namespaced HTML attribute.
 */
function getNamespace(componentName) {
  return {
    [_constants__WEBPACK_IMPORTED_MODULE_0__.COMPONENT_NAMESPACE]: componentName
  };
}

/**
 * Creates a dedicated connected context namespace HTML attribute for components.
 * ns is short for "namespace"
 *
 * @example
 * ```jsx
 * <div {...cns()} />
 * ```
 *
 * @return {Record<string, any>} A props object with the namespaced HTML attribute.
 */
function getConnectedNamespace() {
  return {
    [_constants__WEBPACK_IMPORTED_MODULE_0__.CONNECTED_NAMESPACE]: true
  };
}
//# sourceMappingURL=utils.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/dashicon/index.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/dashicon/index.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");

/**
 * @typedef OwnProps
 *
 * @property {import('./types').IconKey} icon        Icon name
 * @property {string}                    [className] Class name
 * @property {number}                    [size]      Size of the icon
 */

/**
 * Internal dependencies
 */

function Dashicon({
  icon,
  className,
  size = 20,
  style = {},
  ...extraProps
}) {
  const iconClass = ['dashicon', 'dashicons', 'dashicons-' + icon, className].filter(Boolean).join(' ');

  // For retro-compatibility reasons (for example if people are overriding icon size with CSS), we add inline styles just if the size is different to the default
  const sizeStyles =
  // using `!=` to catch both 20 and "20"
  // eslint-disable-next-line eqeqeq
  20 != size ? {
    fontSize: `${size}px`,
    width: `${size}px`,
    height: `${size}px`
  } : {};
  const styles = {
    ...sizeStyles,
    ...style
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: iconClass,
    style: styles,
    ...extraProps
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Dashicon);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/external-link/index.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/external-link/index.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ExternalLink: () => (/* binding */ ExternalLink),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.mjs");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/@wordpress/components/node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

function UnforwardedExternalLink(props, ref) {
  const {
    href,
    children,
    className,
    rel = '',
    ...additionalProps
  } = props;
  const optimizedRel = [...new Set([...rel.split(' '), 'external', 'noreferrer', 'noopener'].filter(Boolean))].join(' ');
  const classes = (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-external-link', className);
  /* Anchor links are perceived as external links.
  This constant helps check for on page anchor links,
  to prevent them from being opened in the editor. */
  const isInternalAnchor = !!href?.startsWith('#');
  const onClickHandler = event => {
    if (isInternalAnchor) {
      event.preventDefault();
    }
    if (props.onClick) {
      props.onClick(event);
    }
  };
  return /*#__PURE__*/ /* eslint-disable react/jsx-no-target-blank */(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("a", {
    ...additionalProps,
    className: classes,
    href: href,
    onClick: onClickHandler,
    target: "_blank",
    rel: optimizedRel,
    ref: ref,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      className: "components-external-link__contents",
      children: children
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      className: "components-external-link__icon",
      "aria-label": /* translators: accessibility text */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('(opens in a new tab)'),
      children: "\u2197"
    })]
  })
  /* eslint-enable react/jsx-no-target-blank */;
}

/**
 * Link to an external resource.
 *
 * ```jsx
 * import { ExternalLink } from '@wordpress/components';
 *
 * const MyExternalLink = () => (
 *   <ExternalLink href="https://wordpress.org">WordPress.org</ExternalLink>
 * );
 * ```
 */
const ExternalLink = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(UnforwardedExternalLink);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExternalLink);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/flex/context.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/flex/context.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FlexContext: () => (/* binding */ FlexContext),
/* harmony export */   useFlexContext: () => (/* binding */ useFlexContext)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */

const FlexContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)({
  flexItemDisplay: undefined
});
const useFlexContext = () => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useContext)(FlexContext);
//# sourceMappingURL=context.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/flex/flex-block/component.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/flex/flex-block/component.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FlexBlock: () => (/* binding */ FlexBlock),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../context */ "./node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _view__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../view */ "./node_modules/@wordpress/components/build-module/view/component.js");
/* harmony import */ var _hook__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./hook */ "./node_modules/@wordpress/components/build-module/flex/flex-block/hook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */





function UnconnectedFlexBlock(props, forwardedRef) {
  const flexBlockProps = (0,_hook__WEBPACK_IMPORTED_MODULE_2__.useFlexBlock)(props);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_view__WEBPACK_IMPORTED_MODULE_1__["default"], {
    ...flexBlockProps,
    ref: forwardedRef
  });
}

/**
 * `FlexBlock` is a primitive layout component that adaptively resizes content
 * within layout containers like `Flex`.
 *
 * ```jsx
 * import { Flex, FlexBlock } from '@wordpress/components';
 *
 * function Example() {
 *   return (
 *     <Flex>
 *       <FlexBlock>...</FlexBlock>
 *     </Flex>
 *   );
 * }
 * ```
 */
const FlexBlock = (0,_context__WEBPACK_IMPORTED_MODULE_0__.contextConnect)(UnconnectedFlexBlock, 'FlexBlock');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FlexBlock);
//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/flex/flex-block/hook.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/flex/flex-block/hook.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useFlexBlock: () => (/* binding */ useFlexBlock)
/* harmony export */ });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../context */ "./node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _flex_item__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../flex-item */ "./node_modules/@wordpress/components/build-module/flex/flex-item/hook.js");
/**
 * Internal dependencies
 */



function useFlexBlock(props) {
  const otherProps = (0,_context__WEBPACK_IMPORTED_MODULE_0__.useContextSystem)(props, 'FlexBlock');
  const flexItemProps = (0,_flex_item__WEBPACK_IMPORTED_MODULE_1__.useFlexItem)({
    isBlock: true,
    ...otherProps
  });
  return flexItemProps;
}
//# sourceMappingURL=hook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/flex/flex-item/component.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/flex/flex-item/component.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FlexItem: () => (/* binding */ FlexItem),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../context */ "./node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _view__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../view */ "./node_modules/@wordpress/components/build-module/view/component.js");
/* harmony import */ var _hook__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./hook */ "./node_modules/@wordpress/components/build-module/flex/flex-item/hook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */





function UnconnectedFlexItem(props, forwardedRef) {
  const flexItemProps = (0,_hook__WEBPACK_IMPORTED_MODULE_2__.useFlexItem)(props);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_view__WEBPACK_IMPORTED_MODULE_1__["default"], {
    ...flexItemProps,
    ref: forwardedRef
  });
}

/**
 * `FlexItem` is a primitive layout component that aligns content within layout
 * containers like `Flex`.
 *
 * ```jsx
 * import { Flex, FlexItem } from '@wordpress/components';
 *
 * function Example() {
 *   return (
 *     <Flex>
 *       <FlexItem>...</FlexItem>
 *     </Flex>
 *   );
 * }
 * ```
 */
const FlexItem = (0,_context__WEBPACK_IMPORTED_MODULE_0__.contextConnect)(UnconnectedFlexItem, 'FlexItem');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FlexItem);
//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/flex/flex-item/hook.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/flex/flex-item/hook.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useFlexItem: () => (/* binding */ useFlexItem)
/* harmony export */ });
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../context */ "./node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../context */ "./node_modules/@wordpress/components/build-module/flex/context.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../styles */ "./node_modules/@wordpress/components/build-module/flex/styles.js");
/* harmony import */ var _utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/hooks/use-cx */ "./node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js");
/**
 * External dependencies
 */



/**
 * Internal dependencies
 */





function useFlexItem(props) {
  const {
    className,
    display: displayProp,
    isBlock = false,
    ...otherProps
  } = (0,_context__WEBPACK_IMPORTED_MODULE_1__.useContextSystem)(props, 'FlexItem');
  const sx = {};
  const contextDisplay = (0,_context__WEBPACK_IMPORTED_MODULE_2__.useFlexContext)().flexItemDisplay;
  sx.Base = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_0__.css)({
    display: displayProp || contextDisplay
  },  false ? 0 : ";label:sx-Base;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9mbGV4LWl0ZW0vaG9vay50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFnQ1ciLCJmaWxlIjoiQHdvcmRwcmVzcy9jb21wb25lbnRzL3NyYy9mbGV4L2ZsZXgtaXRlbS9ob29rLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHR5cGUgeyBTZXJpYWxpemVkU3R5bGVzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG4vKipcbiAqIEludGVybmFsIGRlcGVuZGVuY2llc1xuICovXG5pbXBvcnQgdHlwZSB7IFdvcmRQcmVzc0NvbXBvbmVudFByb3BzIH0gZnJvbSAnLi4vLi4vY29udGV4dCc7XG5pbXBvcnQgeyB1c2VDb250ZXh0U3lzdGVtIH0gZnJvbSAnLi4vLi4vY29udGV4dCc7XG5pbXBvcnQgeyB1c2VGbGV4Q29udGV4dCB9IGZyb20gJy4uL2NvbnRleHQnO1xuaW1wb3J0ICogYXMgc3R5bGVzIGZyb20gJy4uL3N0eWxlcyc7XG5pbXBvcnQgeyB1c2VDeCB9IGZyb20gJy4uLy4uL3V0aWxzL2hvb2tzL3VzZS1jeCc7XG5pbXBvcnQgdHlwZSB7IEZsZXhJdGVtUHJvcHMgfSBmcm9tICcuLi90eXBlcyc7XG5cbmV4cG9ydCBmdW5jdGlvbiB1c2VGbGV4SXRlbShcblx0cHJvcHM6IFdvcmRQcmVzc0NvbXBvbmVudFByb3BzPCBGbGV4SXRlbVByb3BzLCAnZGl2JyA+XG4pIHtcblx0Y29uc3Qge1xuXHRcdGNsYXNzTmFtZSxcblx0XHRkaXNwbGF5OiBkaXNwbGF5UHJvcCxcblx0XHRpc0Jsb2NrID0gZmFsc2UsXG5cdFx0Li4ub3RoZXJQcm9wc1xuXHR9ID0gdXNlQ29udGV4dFN5c3RlbSggcHJvcHMsICdGbGV4SXRlbScgKTtcblxuXHRjb25zdCBzeDoge1xuXHRcdEJhc2U/OiBTZXJpYWxpemVkU3R5bGVzO1xuXHR9ID0ge307XG5cblx0Y29uc3QgY29udGV4dERpc3BsYXkgPSB1c2VGbGV4Q29udGV4dCgpLmZsZXhJdGVtRGlzcGxheTtcblxuXHRzeC5CYXNlID0gY3NzKCB7XG5cdFx0ZGlzcGxheTogZGlzcGxheVByb3AgfHwgY29udGV4dERpc3BsYXksXG5cdH0gKTtcblxuXHRjb25zdCBjeCA9IHVzZUN4KCk7XG5cblx0Y29uc3QgY2xhc3NlcyA9IGN4KFxuXHRcdHN0eWxlcy5JdGVtLFxuXHRcdHN4LkJhc2UsXG5cdFx0aXNCbG9jayAmJiBzdHlsZXMuYmxvY2ssXG5cdFx0Y2xhc3NOYW1lXG5cdCk7XG5cblx0cmV0dXJuIHtcblx0XHQuLi5vdGhlclByb3BzLFxuXHRcdGNsYXNzTmFtZTogY2xhc3Nlcyxcblx0fTtcbn1cbiJdfQ== */");
  const cx = (0,_utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_4__.useCx)();
  const classes = cx(_styles__WEBPACK_IMPORTED_MODULE_3__.Item, sx.Base, isBlock && _styles__WEBPACK_IMPORTED_MODULE_3__.block, className);
  return {
    ...otherProps,
    className: classes
  };
}
//# sourceMappingURL=hook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/flex/flex/component.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/flex/flex/component.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Flex: () => (/* binding */ Flex),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../context */ "./node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _hook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./hook */ "./node_modules/@wordpress/components/build-module/flex/flex/hook.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./../context */ "./node_modules/@wordpress/components/build-module/flex/context.js");
/* harmony import */ var _view__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../view */ "./node_modules/@wordpress/components/build-module/view/component.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */






function UnconnectedFlex(props, forwardedRef) {
  const {
    children,
    isColumn,
    ...otherProps
  } = (0,_hook__WEBPACK_IMPORTED_MODULE_1__.useFlex)(props);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_context__WEBPACK_IMPORTED_MODULE_2__.FlexContext.Provider, {
    value: {
      flexItemDisplay: isColumn ? 'block' : undefined
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_view__WEBPACK_IMPORTED_MODULE_3__["default"], {
      ...otherProps,
      ref: forwardedRef,
      children: children
    })
  });
}

/**
 * `Flex` is a primitive layout component that adaptively aligns child content
 * horizontally or vertically. `Flex` powers components like `HStack` and
 * `VStack`.
 *
 * `Flex` is used with any of its two sub-components, `FlexItem` and
 * `FlexBlock`.
 *
 * ```jsx
 * import { Flex, FlexBlock, FlexItem } from '@wordpress/components';
 *
 * function Example() {
 *   return (
 *     <Flex>
 *       <FlexItem>
 *         <p>Code</p>
 *       </FlexItem>
 *       <FlexBlock>
 *         <p>Poetry</p>
 *       </FlexBlock>
 *     </Flex>
 *   );
 * }
 * ```
 */
const Flex = (0,_context__WEBPACK_IMPORTED_MODULE_0__.contextConnect)(UnconnectedFlex, 'Flex');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Flex);
//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/flex/flex/hook.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/flex/flex/hook.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useFlex: () => (/* binding */ useFlex)
/* harmony export */ });
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/deprecated */ "./node_modules/@wordpress/deprecated/build-module/index.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../context */ "./node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _utils_use_responsive_value__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/use-responsive-value */ "./node_modules/@wordpress/components/build-module/utils/use-responsive-value.js");
/* harmony import */ var _utils_space__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/space */ "./node_modules/@wordpress/components/build-module/utils/space.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../styles */ "./node_modules/@wordpress/components/build-module/flex/styles.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils */ "./node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js");
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function useDeprecatedProps(props) {
  const {
    isReversed,
    ...otherProps
  } = props;
  if (typeof isReversed !== 'undefined') {
    (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_2__["default"])('Flex isReversed', {
      alternative: 'Flex direction="row-reverse" or "column-reverse"',
      since: '5.9'
    });
    return {
      ...otherProps,
      direction: isReversed ? 'row-reverse' : 'row'
    };
  }
  return otherProps;
}
function useFlex(props) {
  const {
    align,
    className,
    direction: directionProp = 'row',
    expanded = true,
    gap = 2,
    justify = 'space-between',
    wrap = false,
    ...otherProps
  } = (0,_context__WEBPACK_IMPORTED_MODULE_3__.useContextSystem)(useDeprecatedProps(props), 'Flex');
  const directionAsArray = Array.isArray(directionProp) ? directionProp : [directionProp];
  const direction = (0,_utils_use_responsive_value__WEBPACK_IMPORTED_MODULE_4__.useResponsiveValue)(directionAsArray);
  const isColumn = typeof direction === 'string' && !!direction.includes('column');
  const cx = (0,_utils__WEBPACK_IMPORTED_MODULE_7__.useCx)();
  const classes = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    const base = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_0__.css)({
      alignItems: align !== null && align !== void 0 ? align : isColumn ? 'normal' : 'center',
      flexDirection: direction,
      flexWrap: wrap ? 'wrap' : undefined,
      gap: (0,_utils_space__WEBPACK_IMPORTED_MODULE_5__.space)(gap),
      justifyContent: justify,
      height: isColumn && expanded ? '100%' : undefined,
      width: !isColumn && expanded ? '100%' : undefined
    },  false ? 0 : ";label:base;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
    return cx(_styles__WEBPACK_IMPORTED_MODULE_6__.Flex, base, isColumn ? _styles__WEBPACK_IMPORTED_MODULE_6__.ItemsColumn : _styles__WEBPACK_IMPORTED_MODULE_6__.ItemsRow, className);
  }, [align, className, cx, direction, expanded, gap, isColumn, justify, wrap]);
  return {
    ...otherProps,
    className: classes,
    isColumn
  };
}
//# sourceMappingURL=hook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/flex/styles.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/flex/styles.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Flex: () => (/* binding */ Flex),
/* harmony export */   Item: () => (/* binding */ Item),
/* harmony export */   ItemsColumn: () => (/* binding */ ItemsColumn),
/* harmony export */   ItemsRow: () => (/* binding */ ItemsRow),
/* harmony export */   block: () => (/* binding */ block)
/* harmony export */ });
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/**
 * External dependencies
 */

const Flex =  false ? 0 : {
  name: "a57899-Flex",
  styles: "display:flex;label:Flex;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBS3VCIiwiZmlsZSI6IkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEV4dGVybmFsIGRlcGVuZGVuY2llc1xuICovXG5pbXBvcnQgeyBjc3MgfSBmcm9tICdAZW1vdGlvbi9yZWFjdCc7XG5cbmV4cG9ydCBjb25zdCBGbGV4ID0gY3NzYFxuXHRkaXNwbGF5OiBmbGV4O1xuYDtcblxuZXhwb3J0IGNvbnN0IEl0ZW0gPSBjc3NgXG5cdGRpc3BsYXk6IGJsb2NrO1xuXHRtYXgtaGVpZ2h0OiAxMDAlO1xuXHRtYXgtd2lkdGg6IDEwMCU7XG5cdG1pbi1oZWlnaHQ6IDA7XG5cdG1pbi13aWR0aDogMDtcbmA7XG5cbmV4cG9ydCBjb25zdCBibG9jayA9IGNzc2Bcblx0ZmxleDogMTtcbmA7XG5cbi8qKlxuICogV29ya2Fyb3VuZCB0byBvcHRpbWl6ZSBET00gcmVuZGVyaW5nLlxuICogV2UnbGwgZW5oYW5jZSBhbGlnbm1lbnQgd2l0aCBuYWl2ZSBwYXJlbnQgZmxleCBhc3N1bXB0aW9ucy5cbiAqXG4gKiBUcmFkZS1vZmY6XG4gKiBGYXIgbGVzcyBET00gbGVzcy4gSG93ZXZlciwgVUkgcmVuZGVyaW5nIGlzIG5vdCBhcyByZWxpYWJsZS5cbiAqL1xuXG4vKipcbiAqIEltcHJvdmVzIHN0YWJpbGl0eSBvZiB3aWR0aC9oZWlnaHQgcmVuZGVyaW5nLlxuICogaHR0cHM6Ly9naXRodWIuY29tL0l0c0pvblEvZzIvcHVsbC8xNDlcbiAqL1xuZXhwb3J0IGNvbnN0IEl0ZW1zQ29sdW1uID0gY3NzYFxuXHQ+ICoge1xuXHRcdG1pbi1oZWlnaHQ6IDA7XG5cdH1cbmA7XG5cbmV4cG9ydCBjb25zdCBJdGVtc1JvdyA9IGNzc2Bcblx0PiAqIHtcblx0XHRtaW4td2lkdGg6IDA7XG5cdH1cbmA7XG4iXX0= */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const Item =  false ? 0 : {
  name: "14ac8g8-Item",
  styles: "display:block;max-height:100%;max-width:100%;min-height:0;min-width:0;label:Item;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBU3VCIiwiZmlsZSI6IkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEV4dGVybmFsIGRlcGVuZGVuY2llc1xuICovXG5pbXBvcnQgeyBjc3MgfSBmcm9tICdAZW1vdGlvbi9yZWFjdCc7XG5cbmV4cG9ydCBjb25zdCBGbGV4ID0gY3NzYFxuXHRkaXNwbGF5OiBmbGV4O1xuYDtcblxuZXhwb3J0IGNvbnN0IEl0ZW0gPSBjc3NgXG5cdGRpc3BsYXk6IGJsb2NrO1xuXHRtYXgtaGVpZ2h0OiAxMDAlO1xuXHRtYXgtd2lkdGg6IDEwMCU7XG5cdG1pbi1oZWlnaHQ6IDA7XG5cdG1pbi13aWR0aDogMDtcbmA7XG5cbmV4cG9ydCBjb25zdCBibG9jayA9IGNzc2Bcblx0ZmxleDogMTtcbmA7XG5cbi8qKlxuICogV29ya2Fyb3VuZCB0byBvcHRpbWl6ZSBET00gcmVuZGVyaW5nLlxuICogV2UnbGwgZW5oYW5jZSBhbGlnbm1lbnQgd2l0aCBuYWl2ZSBwYXJlbnQgZmxleCBhc3N1bXB0aW9ucy5cbiAqXG4gKiBUcmFkZS1vZmY6XG4gKiBGYXIgbGVzcyBET00gbGVzcy4gSG93ZXZlciwgVUkgcmVuZGVyaW5nIGlzIG5vdCBhcyByZWxpYWJsZS5cbiAqL1xuXG4vKipcbiAqIEltcHJvdmVzIHN0YWJpbGl0eSBvZiB3aWR0aC9oZWlnaHQgcmVuZGVyaW5nLlxuICogaHR0cHM6Ly9naXRodWIuY29tL0l0c0pvblEvZzIvcHVsbC8xNDlcbiAqL1xuZXhwb3J0IGNvbnN0IEl0ZW1zQ29sdW1uID0gY3NzYFxuXHQ+ICoge1xuXHRcdG1pbi1oZWlnaHQ6IDA7XG5cdH1cbmA7XG5cbmV4cG9ydCBjb25zdCBJdGVtc1JvdyA9IGNzc2Bcblx0PiAqIHtcblx0XHRtaW4td2lkdGg6IDA7XG5cdH1cbmA7XG4iXX0= */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const block =  false ? 0 : {
  name: "1ya6i3g-block",
  styles: "flex:1;label:block;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBaUJ3QiIsImZpbGUiOiJAd29yZHByZXNzL2NvbXBvbmVudHMvc3JjL2ZsZXgvc3R5bGVzLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG5leHBvcnQgY29uc3QgRmxleCA9IGNzc2Bcblx0ZGlzcGxheTogZmxleDtcbmA7XG5cbmV4cG9ydCBjb25zdCBJdGVtID0gY3NzYFxuXHRkaXNwbGF5OiBibG9jaztcblx0bWF4LWhlaWdodDogMTAwJTtcblx0bWF4LXdpZHRoOiAxMDAlO1xuXHRtaW4taGVpZ2h0OiAwO1xuXHRtaW4td2lkdGg6IDA7XG5gO1xuXG5leHBvcnQgY29uc3QgYmxvY2sgPSBjc3NgXG5cdGZsZXg6IDE7XG5gO1xuXG4vKipcbiAqIFdvcmthcm91bmQgdG8gb3B0aW1pemUgRE9NIHJlbmRlcmluZy5cbiAqIFdlJ2xsIGVuaGFuY2UgYWxpZ25tZW50IHdpdGggbmFpdmUgcGFyZW50IGZsZXggYXNzdW1wdGlvbnMuXG4gKlxuICogVHJhZGUtb2ZmOlxuICogRmFyIGxlc3MgRE9NIGxlc3MuIEhvd2V2ZXIsIFVJIHJlbmRlcmluZyBpcyBub3QgYXMgcmVsaWFibGUuXG4gKi9cblxuLyoqXG4gKiBJbXByb3ZlcyBzdGFiaWxpdHkgb2Ygd2lkdGgvaGVpZ2h0IHJlbmRlcmluZy5cbiAqIGh0dHBzOi8vZ2l0aHViLmNvbS9JdHNKb25RL2cyL3B1bGwvMTQ5XG4gKi9cbmV4cG9ydCBjb25zdCBJdGVtc0NvbHVtbiA9IGNzc2Bcblx0PiAqIHtcblx0XHRtaW4taGVpZ2h0OiAwO1xuXHR9XG5gO1xuXG5leHBvcnQgY29uc3QgSXRlbXNSb3cgPSBjc3NgXG5cdD4gKiB7XG5cdFx0bWluLXdpZHRoOiAwO1xuXHR9XG5gO1xuIl19 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

/**
 * Workaround to optimize DOM rendering.
 * We'll enhance alignment with naive parent flex assumptions.
 *
 * Trade-off:
 * Far less DOM less. However, UI rendering is not as reliable.
 */

/**
 * Improves stability of width/height rendering.
 * https://github.com/ItsJonQ/g2/pull/149
 */
const ItemsColumn =  false ? 0 : {
  name: "9k4k7f-ItemsColumn",
  styles: ">*{min-height:0;};label:ItemsColumn;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBaUM4QiIsImZpbGUiOiJAd29yZHByZXNzL2NvbXBvbmVudHMvc3JjL2ZsZXgvc3R5bGVzLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG5leHBvcnQgY29uc3QgRmxleCA9IGNzc2Bcblx0ZGlzcGxheTogZmxleDtcbmA7XG5cbmV4cG9ydCBjb25zdCBJdGVtID0gY3NzYFxuXHRkaXNwbGF5OiBibG9jaztcblx0bWF4LWhlaWdodDogMTAwJTtcblx0bWF4LXdpZHRoOiAxMDAlO1xuXHRtaW4taGVpZ2h0OiAwO1xuXHRtaW4td2lkdGg6IDA7XG5gO1xuXG5leHBvcnQgY29uc3QgYmxvY2sgPSBjc3NgXG5cdGZsZXg6IDE7XG5gO1xuXG4vKipcbiAqIFdvcmthcm91bmQgdG8gb3B0aW1pemUgRE9NIHJlbmRlcmluZy5cbiAqIFdlJ2xsIGVuaGFuY2UgYWxpZ25tZW50IHdpdGggbmFpdmUgcGFyZW50IGZsZXggYXNzdW1wdGlvbnMuXG4gKlxuICogVHJhZGUtb2ZmOlxuICogRmFyIGxlc3MgRE9NIGxlc3MuIEhvd2V2ZXIsIFVJIHJlbmRlcmluZyBpcyBub3QgYXMgcmVsaWFibGUuXG4gKi9cblxuLyoqXG4gKiBJbXByb3ZlcyBzdGFiaWxpdHkgb2Ygd2lkdGgvaGVpZ2h0IHJlbmRlcmluZy5cbiAqIGh0dHBzOi8vZ2l0aHViLmNvbS9JdHNKb25RL2cyL3B1bGwvMTQ5XG4gKi9cbmV4cG9ydCBjb25zdCBJdGVtc0NvbHVtbiA9IGNzc2Bcblx0PiAqIHtcblx0XHRtaW4taGVpZ2h0OiAwO1xuXHR9XG5gO1xuXG5leHBvcnQgY29uc3QgSXRlbXNSb3cgPSBjc3NgXG5cdD4gKiB7XG5cdFx0bWluLXdpZHRoOiAwO1xuXHR9XG5gO1xuIl19 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const ItemsRow =  false ? 0 : {
  name: "1ozeagb-ItemsRow",
  styles: ">*{min-width:0;};label:ItemsRow;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBdUMyQiIsImZpbGUiOiJAd29yZHByZXNzL2NvbXBvbmVudHMvc3JjL2ZsZXgvc3R5bGVzLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG5leHBvcnQgY29uc3QgRmxleCA9IGNzc2Bcblx0ZGlzcGxheTogZmxleDtcbmA7XG5cbmV4cG9ydCBjb25zdCBJdGVtID0gY3NzYFxuXHRkaXNwbGF5OiBibG9jaztcblx0bWF4LWhlaWdodDogMTAwJTtcblx0bWF4LXdpZHRoOiAxMDAlO1xuXHRtaW4taGVpZ2h0OiAwO1xuXHRtaW4td2lkdGg6IDA7XG5gO1xuXG5leHBvcnQgY29uc3QgYmxvY2sgPSBjc3NgXG5cdGZsZXg6IDE7XG5gO1xuXG4vKipcbiAqIFdvcmthcm91bmQgdG8gb3B0aW1pemUgRE9NIHJlbmRlcmluZy5cbiAqIFdlJ2xsIGVuaGFuY2UgYWxpZ25tZW50IHdpdGggbmFpdmUgcGFyZW50IGZsZXggYXNzdW1wdGlvbnMuXG4gKlxuICogVHJhZGUtb2ZmOlxuICogRmFyIGxlc3MgRE9NIGxlc3MuIEhvd2V2ZXIsIFVJIHJlbmRlcmluZyBpcyBub3QgYXMgcmVsaWFibGUuXG4gKi9cblxuLyoqXG4gKiBJbXByb3ZlcyBzdGFiaWxpdHkgb2Ygd2lkdGgvaGVpZ2h0IHJlbmRlcmluZy5cbiAqIGh0dHBzOi8vZ2l0aHViLmNvbS9JdHNKb25RL2cyL3B1bGwvMTQ5XG4gKi9cbmV4cG9ydCBjb25zdCBJdGVtc0NvbHVtbiA9IGNzc2Bcblx0PiAqIHtcblx0XHRtaW4taGVpZ2h0OiAwO1xuXHR9XG5gO1xuXG5leHBvcnQgY29uc3QgSXRlbXNSb3cgPSBjc3NgXG5cdD4gKiB7XG5cdFx0bWluLXdpZHRoOiAwO1xuXHR9XG5gO1xuIl19 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
//# sourceMappingURL=styles.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/form-toggle/index.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/form-toggle/index.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormToggle: () => (/* binding */ FormToggle),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   noop: () => (/* binding */ noop)
/* harmony export */ });
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.mjs");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const noop = () => {};
function UnforwardedFormToggle(props, ref) {
  const {
    className,
    checked,
    id,
    disabled,
    onChange = noop,
    ...additionalProps
  } = props;
  const wrapperClasses = (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-form-toggle', className, {
    'is-checked': checked,
    'is-disabled': disabled
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
    className: wrapperClasses,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("input", {
      className: "components-form-toggle__input",
      id: id,
      type: "checkbox",
      checked: checked,
      onChange: onChange,
      disabled: disabled,
      ...additionalProps,
      ref: ref
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
      className: "components-form-toggle__track"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
      className: "components-form-toggle__thumb"
    })]
  });
}

/**
 * FormToggle switches a single setting on or off.
 *
 * ```jsx
 * import { FormToggle } from '@wordpress/components';
 * import { useState } from '@wordpress/element';
 *
 * const MyFormToggle = () => {
 *   const [ isChecked, setChecked ] = useState( true );
 *
 *   return (
 *     <FormToggle
 *       checked={ isChecked }
 *       onChange={ () => setChecked( ( state ) => ! state ) }
 *     />
 *   );
 * };
 * ```
 */
const FormToggle = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(UnforwardedFormToggle);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FormToggle);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/h-stack/component.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/h-stack/component.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HStack: () => (/* binding */ HStack),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../context */ "./node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _view__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../view */ "./node_modules/@wordpress/components/build-module/view/component.js");
/* harmony import */ var _hook__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./hook */ "./node_modules/@wordpress/components/build-module/h-stack/hook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * Internal dependencies
 */





function UnconnectedHStack(props, forwardedRef) {
  const hStackProps = (0,_hook__WEBPACK_IMPORTED_MODULE_2__.useHStack)(props);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_view__WEBPACK_IMPORTED_MODULE_1__["default"], {
    ...hStackProps,
    ref: forwardedRef
  });
}

/**
 * `HStack` (Horizontal Stack) arranges child elements in a horizontal line.
 *
 * `HStack` can render anything inside.
 *
 * ```jsx
 * import {
 * 	__experimentalHStack as HStack,
 * 	__experimentalText as Text,
 * } from `@wordpress/components`;
 *
 * function Example() {
 * 	return (
 * 		<HStack>
 * 			<Text>Code</Text>
 * 			<Text>is</Text>
 * 			<Text>Poetry</Text>
 * 		</HStack>
 * 	);
 * }
 * ```
 */
const HStack = (0,_context__WEBPACK_IMPORTED_MODULE_0__.contextConnect)(UnconnectedHStack, 'HStack');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HStack);
//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/h-stack/hook.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/h-stack/hook.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useHStack: () => (/* binding */ useHStack)
/* harmony export */ });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../context */ "./node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../context */ "./node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _flex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../flex */ "./node_modules/@wordpress/components/build-module/flex/flex-item/component.js");
/* harmony import */ var _flex__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../flex */ "./node_modules/@wordpress/components/build-module/flex/flex/hook.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ "./node_modules/@wordpress/components/build-module/h-stack/utils.js");
/* harmony import */ var _utils_get_valid_children__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/get-valid-children */ "./node_modules/@wordpress/components/build-module/utils/get-valid-children.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */






function useHStack(props) {
  const {
    alignment = 'edge',
    children,
    direction,
    spacing = 2,
    ...otherProps
  } = (0,_context__WEBPACK_IMPORTED_MODULE_1__.useContextSystem)(props, 'HStack');
  const align = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.getAlignmentProps)(alignment, direction);
  const validChildren = (0,_utils_get_valid_children__WEBPACK_IMPORTED_MODULE_5__.getValidChildren)(children);
  const clonedChildren = validChildren.map((child, index) => {
    const _isSpacer = (0,_context__WEBPACK_IMPORTED_MODULE_0__.hasConnectNamespace)(child, ['Spacer']);
    if (_isSpacer) {
      const childElement = child;
      const _key = childElement.key || `hstack-${index}`;
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_flex__WEBPACK_IMPORTED_MODULE_2__["default"], {
        isBlock: true,
        ...childElement.props
      }, _key);
    }
    return child;
  });
  const propsForFlex = {
    children: clonedChildren,
    direction,
    justify: 'center',
    ...align,
    ...otherProps,
    gap: spacing
  };

  // Omit `isColumn` because it's not used in HStack.
  const {
    isColumn,
    ...flexProps
  } = (0,_flex__WEBPACK_IMPORTED_MODULE_3__.useFlex)(propsForFlex);
  return flexProps;
}
//# sourceMappingURL=hook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/h-stack/utils.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/h-stack/utils.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getAlignmentProps: () => (/* binding */ getAlignmentProps)
/* harmony export */ });
/* harmony import */ var _utils_values__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/values */ "./node_modules/@wordpress/components/build-module/utils/values.js");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */


const H_ALIGNMENTS = {
  bottom: {
    align: 'flex-end',
    justify: 'center'
  },
  bottomLeft: {
    align: 'flex-end',
    justify: 'flex-start'
  },
  bottomRight: {
    align: 'flex-end',
    justify: 'flex-end'
  },
  center: {
    align: 'center',
    justify: 'center'
  },
  edge: {
    align: 'center',
    justify: 'space-between'
  },
  left: {
    align: 'center',
    justify: 'flex-start'
  },
  right: {
    align: 'center',
    justify: 'flex-end'
  },
  stretch: {
    align: 'stretch'
  },
  top: {
    align: 'flex-start',
    justify: 'center'
  },
  topLeft: {
    align: 'flex-start',
    justify: 'flex-start'
  },
  topRight: {
    align: 'flex-start',
    justify: 'flex-end'
  }
};
const V_ALIGNMENTS = {
  bottom: {
    justify: 'flex-end',
    align: 'center'
  },
  bottomLeft: {
    justify: 'flex-end',
    align: 'flex-start'
  },
  bottomRight: {
    justify: 'flex-end',
    align: 'flex-end'
  },
  center: {
    justify: 'center',
    align: 'center'
  },
  edge: {
    justify: 'space-between',
    align: 'center'
  },
  left: {
    justify: 'center',
    align: 'flex-start'
  },
  right: {
    justify: 'center',
    align: 'flex-end'
  },
  stretch: {
    align: 'stretch'
  },
  top: {
    justify: 'flex-start',
    align: 'center'
  },
  topLeft: {
    justify: 'flex-start',
    align: 'flex-start'
  },
  topRight: {
    justify: 'flex-start',
    align: 'flex-end'
  }
};
function getAlignmentProps(alignment, direction = 'row') {
  if (!(0,_utils_values__WEBPACK_IMPORTED_MODULE_0__.isValueDefined)(alignment)) {
    return {};
  }
  const isVertical = direction === 'column';
  const props = isVertical ? V_ALIGNMENTS : H_ALIGNMENTS;
  const alignmentProps = alignment in props ? props[alignment] : {
    align: alignment
  };
  return alignmentProps;
}
//# sourceMappingURL=utils.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/icon/index.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/icon/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "./node_modules/@wordpress/primitives/build-module/svg/index.js");
/* harmony import */ var _dashicon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dashicon */ "./node_modules/@wordpress/components/build-module/dashicon/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Renders a raw icon without any initial styling or wrappers.
 *
 * ```jsx
 * import { wordpress } from '@wordpress/icons';
 *
 * <Icon icon={ wordpress } />
 * ```
 */
function Icon({
  icon = null,
  size = 'string' === typeof icon ? 20 : 24,
  ...additionalProps
}) {
  if ('string' === typeof icon) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_dashicon__WEBPACK_IMPORTED_MODULE_2__["default"], {
      icon: icon,
      size: size,
      ...additionalProps
    });
  }
  if ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.isValidElement)(icon) && _dashicon__WEBPACK_IMPORTED_MODULE_2__["default"] === icon.type) {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(icon, {
      ...additionalProps
    });
  }
  if ('function' === typeof icon) {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(icon, {
      size,
      ...additionalProps
    });
  }
  if (icon && (icon.type === 'svg' || icon.type === _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG)) {
    const appliedProps = {
      ...icon.props,
      width: size,
      height: size,
      ...additionalProps
    };
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
      ...appliedProps
    });
  }
  if ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.isValidElement)(icon)) {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(icon, {
      // @ts-ignore Just forwarding the size prop along
      size,
      ...additionalProps
    });
  }
  return icon;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Icon);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/input-control/backdrop.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/input-control/backdrop.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _styles_input_control_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./styles/input-control-styles */ "./node_modules/@wordpress/components/build-module/input-control/styles/input-control-styles.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


function Backdrop({
  disabled = false,
  isBorderless = false
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_styles_input_control_styles__WEBPACK_IMPORTED_MODULE_1__.BackdropUI, {
    "aria-hidden": "true",
    className: "components-input-control__backdrop",
    disabled: disabled,
    isBorderless: isBorderless
  });
}
const MemoizedBackdrop = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.memo)(Backdrop);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MemoizedBackdrop);
//# sourceMappingURL=backdrop.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/input-control/index.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/input-control/index.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InputControl: () => (/* binding */ InputControl),
/* harmony export */   UnforwardedInputControl: () => (/* binding */ UnforwardedInputControl),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clsx */ "./node_modules/clsx/dist/clsx.mjs");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _input_base__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./input-base */ "./node_modules/@wordpress/components/build-module/input-control/input-base.js");
/* harmony import */ var _input_field__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./input-field */ "./node_modules/@wordpress/components/build-module/input-control/input-field.js");
/* harmony import */ var _utils_space__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/space */ "./node_modules/@wordpress/components/build-module/utils/space.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils */ "./node_modules/@wordpress/components/build-module/input-control/utils.js");
/* harmony import */ var _base_control__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../base-control */ "./node_modules/@wordpress/components/build-module/base-control/index.js");
/* harmony import */ var _utils_use_deprecated_props__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/use-deprecated-props */ "./node_modules/@wordpress/components/build-module/utils/use-deprecated-props.js");
/* harmony import */ var _utils_deprecated_36px_size__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/deprecated-36px-size */ "./node_modules/@wordpress/components/build-module/utils/deprecated-36px-size.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








const noop = () => {};
function useUniqueId(idProp) {
  const instanceId = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_1__["default"])(InputControl);
  const id = `inspector-input-control-${instanceId}`;
  return idProp || id;
}
function UnforwardedInputControl(props, ref) {
  const {
    __next40pxDefaultSize,
    __shouldNotWarnDeprecated36pxSize,
    __unstableStateReducer: stateReducer = state => state,
    __unstableInputWidth,
    className,
    disabled = false,
    help,
    hideLabelFromVision = false,
    id: idProp,
    isPressEnterToChange = false,
    label,
    labelPosition = 'top',
    onChange = noop,
    onValidate = noop,
    onKeyDown = noop,
    prefix,
    size = 'default',
    style,
    suffix,
    value,
    ...restProps
  } = (0,_utils_use_deprecated_props__WEBPACK_IMPORTED_MODULE_8__.useDeprecated36pxDefaultSizeProp)(props);
  const id = useUniqueId(idProp);
  const classes = (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-input-control', className);
  const draftHookProps = (0,_utils__WEBPACK_IMPORTED_MODULE_6__.useDraft)({
    value,
    onBlur: restProps.onBlur,
    onChange
  });
  const helpProp = !!help ? {
    'aria-describedby': `${id}__help`
  } : {};
  (0,_utils_deprecated_36px_size__WEBPACK_IMPORTED_MODULE_9__.maybeWarnDeprecated36pxSize)({
    componentName: 'InputControl',
    __next40pxDefaultSize,
    size,
    __shouldNotWarnDeprecated36pxSize
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_base_control__WEBPACK_IMPORTED_MODULE_7__["default"], {
    className: classes,
    help: help,
    id: id,
    __nextHasNoMarginBottom: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_input_base__WEBPACK_IMPORTED_MODULE_3__["default"], {
      __next40pxDefaultSize: __next40pxDefaultSize,
      __unstableInputWidth: __unstableInputWidth,
      disabled: disabled,
      gap: 3,
      hideLabelFromVision: hideLabelFromVision,
      id: id,
      justify: "left",
      label: label,
      labelPosition: labelPosition,
      prefix: prefix,
      size: size,
      style: style,
      suffix: suffix,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_input_field__WEBPACK_IMPORTED_MODULE_4__["default"], {
        ...restProps,
        ...helpProp,
        __next40pxDefaultSize: __next40pxDefaultSize,
        className: "components-input-control__input",
        disabled: disabled,
        id: id,
        isPressEnterToChange: isPressEnterToChange,
        onKeyDown: onKeyDown,
        onValidate: onValidate,
        paddingInlineStart: prefix ? (0,_utils_space__WEBPACK_IMPORTED_MODULE_5__.space)(1) : undefined,
        paddingInlineEnd: suffix ? (0,_utils_space__WEBPACK_IMPORTED_MODULE_5__.space)(1) : undefined,
        ref: ref,
        size: size,
        stateReducer: stateReducer,
        ...draftHookProps
      })
    })
  });
}

/**
 * InputControl components let users enter and edit text. This is an experimental component
 * intended to (in time) merge with or replace `TextControl`.
 *
 * ```jsx
 * import { __experimentalInputControl as InputControl } from '@wordpress/components';
 * import { useState } from 'react';
 *
 * const Example = () => {
 *   const [ value, setValue ] = useState( '' );
 *
 *   return (
 *  	<InputControl
 * 			__next40pxDefaultSize
 *  		value={ value }
 *  		onChange={ ( nextValue ) => setValue( nextValue ?? '' ) }
 *  	/>
 *   );
 * };
 * ```
 */
const InputControl = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(UnforwardedInputControl);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InputControl);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/input-control/input-base.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/input-control/input-base.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _backdrop__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./backdrop */ "./node_modules/@wordpress/components/build-module/input-control/backdrop.js");
/* harmony import */ var _label__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./label */ "./node_modules/@wordpress/components/build-module/input-control/label.js");
/* harmony import */ var _styles_input_control_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles/input-control-styles */ "./node_modules/@wordpress/components/build-module/input-control/styles/input-control-styles.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../context */ "./node_modules/@wordpress/components/build-module/context/context-system-provider.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../context */ "./node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../context */ "./node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _utils_use_deprecated_props__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/use-deprecated-props */ "./node_modules/@wordpress/components/build-module/utils/use-deprecated-props.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function useUniqueId(idProp) {
  const instanceId = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_0__["default"])(InputBase);
  const id = `input-base-control-${instanceId}`;
  return idProp || id;
}

// Adapter to map props for the new ui/flex component.
function getUIFlexProps(labelPosition) {
  const props = {};
  switch (labelPosition) {
    case 'top':
      props.direction = 'column';
      props.expanded = false;
      props.gap = 0;
      break;
    case 'bottom':
      props.direction = 'column-reverse';
      props.expanded = false;
      props.gap = 0;
      break;
    case 'edge':
      props.justify = 'space-between';
      break;
  }
  return props;
}
function InputBase(props, ref) {
  const {
    __next40pxDefaultSize,
    __unstableInputWidth,
    children,
    className,
    disabled = false,
    hideLabelFromVision = false,
    labelPosition,
    id: idProp,
    isBorderless = false,
    label,
    prefix,
    size = 'default',
    suffix,
    ...restProps
  } = (0,_utils_use_deprecated_props__WEBPACK_IMPORTED_MODULE_8__.useDeprecated36pxDefaultSizeProp)((0,_context__WEBPACK_IMPORTED_MODULE_7__.useContextSystem)(props, 'InputBase'));
  const id = useUniqueId(idProp);
  const hideLabel = hideLabelFromVision || !label;
  const prefixSuffixContextValue = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    return {
      InputControlPrefixWrapper: {
        __next40pxDefaultSize,
        size
      },
      InputControlSuffixWrapper: {
        __next40pxDefaultSize,
        size
      }
    };
  }, [__next40pxDefaultSize, size]);
  return (
    /*#__PURE__*/
    // @ts-expect-error The `direction` prop from Flex (FlexDirection) conflicts with legacy SVGAttributes `direction` (string) that come from React intrinsic prop definitions.
    (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_styles_input_control_styles__WEBPACK_IMPORTED_MODULE_4__.Root, {
      ...restProps,
      ...getUIFlexProps(labelPosition),
      className: className,
      gap: 2,
      ref: ref,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_label__WEBPACK_IMPORTED_MODULE_3__["default"], {
        className: "components-input-control__label",
        hideLabelFromVision: hideLabelFromVision,
        labelPosition: labelPosition,
        htmlFor: id,
        children: label
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_styles_input_control_styles__WEBPACK_IMPORTED_MODULE_4__.Container, {
        __unstableInputWidth: __unstableInputWidth,
        className: "components-input-control__container",
        disabled: disabled,
        hideLabel: hideLabel,
        labelPosition: labelPosition,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_context__WEBPACK_IMPORTED_MODULE_5__.ContextSystemProvider, {
          value: prefixSuffixContextValue,
          children: [prefix && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_styles_input_control_styles__WEBPACK_IMPORTED_MODULE_4__.Prefix, {
            className: "components-input-control__prefix",
            children: prefix
          }), children, suffix && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_styles_input_control_styles__WEBPACK_IMPORTED_MODULE_4__.Suffix, {
            className: "components-input-control__suffix",
            children: suffix
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_backdrop__WEBPACK_IMPORTED_MODULE_2__["default"], {
          disabled: disabled,
          isBorderless: isBorderless
        })]
      })]
    })
  );
}

/**
 * `InputBase` is an internal component used to style the standard borders for an input,
 * as well as handle the layout for prefix/suffix elements.
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_context__WEBPACK_IMPORTED_MODULE_6__.contextConnect)(InputBase, 'InputBase'));
//# sourceMappingURL=input-base.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/input-control/input-field.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/input-control/input-field.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _use_gesture_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @use-gesture/react */ "./node_modules/@use-gesture/react/dist/use-gesture-react.esm.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ "./node_modules/@wordpress/components/build-module/input-control/utils.js");
/* harmony import */ var _styles_input_control_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./styles/input-control-styles */ "./node_modules/@wordpress/components/build-module/input-control/styles/input-control-styles.js");
/* harmony import */ var _reducer_reducer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./reducer/reducer */ "./node_modules/@wordpress/components/build-module/input-control/reducer/reducer.js");
/* harmony import */ var _utils_with_ignore_ime_events__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/with-ignore-ime-events */ "./node_modules/@wordpress/components/build-module/utils/with-ignore-ime-events.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */






const noop = () => {};
function InputField({
  disabled = false,
  dragDirection = 'n',
  dragThreshold = 10,
  id,
  isDragEnabled = false,
  isPressEnterToChange = false,
  onBlur = noop,
  onChange = noop,
  onDrag = noop,
  onDragEnd = noop,
  onDragStart = noop,
  onKeyDown = noop,
  onValidate = noop,
  size = 'default',
  stateReducer = state => state,
  value: valueProp,
  type,
  ...props
}, ref) {
  const {
    // State.
    state,
    // Actions.
    change,
    commit,
    drag,
    dragEnd,
    dragStart,
    invalidate,
    pressDown,
    pressEnter,
    pressUp,
    reset
  } = (0,_reducer_reducer__WEBPACK_IMPORTED_MODULE_4__.useInputControlStateReducer)(stateReducer, {
    isDragEnabled,
    value: valueProp,
    isPressEnterToChange
  }, onChange);
  const {
    value,
    isDragging,
    isDirty
  } = state;
  const wasDirtyOnBlur = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useRef)(false);
  const dragCursor = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.useDragCursor)(isDragging, dragDirection);
  const handleOnBlur = event => {
    onBlur(event);

    /**
     * If isPressEnterToChange is set, this commits the value to
     * the onChange callback.
     */
    if (isDirty || !event.target.validity.valid) {
      wasDirtyOnBlur.current = true;
      handleOnCommit(event);
    }
  };
  const handleOnChange = event => {
    const nextValue = event.target.value;
    change(nextValue, event);
  };
  const handleOnCommit = event => {
    const nextValue = event.currentTarget.value;
    try {
      onValidate(nextValue);
      commit(nextValue, event);
    } catch (err) {
      invalidate(err, event);
    }
  };
  const handleOnKeyDown = event => {
    const {
      key
    } = event;
    onKeyDown(event);
    switch (key) {
      case 'ArrowUp':
        pressUp(event);
        break;
      case 'ArrowDown':
        pressDown(event);
        break;
      case 'Enter':
        pressEnter(event);
        if (isPressEnterToChange) {
          event.preventDefault();
          handleOnCommit(event);
        }
        break;
      case 'Escape':
        if (isPressEnterToChange && isDirty) {
          event.preventDefault();
          reset(valueProp, event);
        }
        break;
    }
  };
  const dragGestureProps = (0,_use_gesture_react__WEBPACK_IMPORTED_MODULE_0__.useDrag)(dragProps => {
    const {
      distance,
      dragging,
      event,
      target
    } = dragProps;

    // The `target` prop always references the `input` element while, by
    // default, the `dragProps.event.target` property would reference the real
    // event target (i.e. any DOM element that the pointer is hovering while
    // dragging). Ensuring that the `target` is always the `input` element
    // allows consumers of `InputControl` (or any higher-level control) to
    // check the input's validity by accessing `event.target.validity.valid`.
    dragProps.event = {
      ...dragProps.event,
      target
    };
    if (!distance) {
      return;
    }
    event.stopPropagation();

    /**
     * Quick return if no longer dragging.
     * This prevents unnecessary value calculations.
     */
    if (!dragging) {
      onDragEnd(dragProps);
      dragEnd(dragProps);
      return;
    }
    onDrag(dragProps);
    drag(dragProps);
    if (!isDragging) {
      onDragStart(dragProps);
      dragStart(dragProps);
    }
  }, {
    axis: dragDirection === 'e' || dragDirection === 'w' ? 'x' : 'y',
    threshold: dragThreshold,
    enabled: isDragEnabled,
    pointer: {
      capture: false
    }
  });
  const dragProps = isDragEnabled ? dragGestureProps() : {};
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_styles_input_control_styles__WEBPACK_IMPORTED_MODULE_3__.Input, {
    ...props,
    ...dragProps,
    className: "components-input-control__input",
    disabled: disabled,
    dragCursor: dragCursor,
    isDragging: isDragging,
    id: id,
    onBlur: handleOnBlur,
    onChange: handleOnChange,
    onKeyDown: (0,_utils_with_ignore_ime_events__WEBPACK_IMPORTED_MODULE_5__.withIgnoreIMEEvents)(handleOnKeyDown),
    ref: ref,
    inputSize: size
    // Fallback to `''` to avoid "uncontrolled to controlled" warning.
    // See https://github.com/WordPress/gutenberg/pull/47250 for details.
    ,
    value: value !== null && value !== void 0 ? value : '',
    type: type
  });
}
const ForwardedComponent = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(InputField);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ForwardedComponent);
//# sourceMappingURL=input-field.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/input-control/label.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/input-control/label.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Label)
/* harmony export */ });
/* harmony import */ var _visually_hidden__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../visually-hidden */ "./node_modules/@wordpress/components/build-module/visually-hidden/component.js");
/* harmony import */ var _styles_input_control_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./styles/input-control-styles */ "./node_modules/@wordpress/components/build-module/input-control/styles/input-control-styles.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/**
 * Internal dependencies
 */



function Label({
  children,
  hideLabelFromVision,
  htmlFor,
  ...props
}) {
  if (!children) {
    return null;
  }
  if (hideLabelFromVision) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_visually_hidden__WEBPACK_IMPORTED_MODULE_0__["default"], {
      as: "label",
      htmlFor: htmlFor,
      children: children
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_styles_input_control_styles__WEBPACK_IMPORTED_MODULE_1__.LabelWrapper, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_styles_input_control_styles__WEBPACK_IMPORTED_MODULE_1__.Label, {
      htmlFor: htmlFor,
      ...props,
      children: children
    })
  });
}
//# sourceMappingURL=label.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/input-control/reducer/actions.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/input-control/reducer/actions.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CHANGE: () => (/* binding */ CHANGE),
/* harmony export */   COMMIT: () => (/* binding */ COMMIT),
/* harmony export */   CONTROL: () => (/* binding */ CONTROL),
/* harmony export */   DRAG: () => (/* binding */ DRAG),
/* harmony export */   DRAG_END: () => (/* binding */ DRAG_END),
/* harmony export */   DRAG_START: () => (/* binding */ DRAG_START),
/* harmony export */   INVALIDATE: () => (/* binding */ INVALIDATE),
/* harmony export */   PRESS_DOWN: () => (/* binding */ PRESS_DOWN),
/* harmony export */   PRESS_ENTER: () => (/* binding */ PRESS_ENTER),
/* harmony export */   PRESS_UP: () => (/* binding */ PRESS_UP),
/* harmony export */   RESET: () => (/* binding */ RESET)
/* harmony export */ });
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */

const CHANGE = 'CHANGE';
const COMMIT = 'COMMIT';
const CONTROL = 'CONTROL';
const DRAG_END = 'DRAG_END';
const DRAG_START = 'DRAG_START';
const DRAG = 'DRAG';
const INVALIDATE = 'INVALIDATE';
const PRESS_DOWN = 'PRESS_DOWN';
const PRESS_ENTER = 'PRESS_ENTER';
const PRESS_UP = 'PRESS_UP';
const RESET = 'RESET';
//# sourceMappingURL=actions.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/input-control/reducer/reducer.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/input-control/reducer/reducer.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useInputControlStateReducer: () => (/* binding */ useInputControlStateReducer)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _state__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./state */ "./node_modules/@wordpress/components/build-module/input-control/reducer/state.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./actions */ "./node_modules/@wordpress/components/build-module/input-control/reducer/actions.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Prepares initialState for the reducer.
 *
 * @param initialState The initial state.
 * @return Prepared initialState for the reducer
 */
function mergeInitialState(initialState = _state__WEBPACK_IMPORTED_MODULE_1__.initialInputControlState) {
  const {
    value
  } = initialState;
  return {
    ..._state__WEBPACK_IMPORTED_MODULE_1__.initialInputControlState,
    ...initialState,
    initialValue: value
  };
}

/**
 * Creates the base reducer which may be coupled to a specializing reducer.
 * As its final step, for all actions other than CONTROL, the base reducer
 * passes the state and action on through the specializing reducer. The
 * exception for CONTROL actions is because they represent controlled updates
 * from props and no case has yet presented for their specialization.
 *
 * @param composedStateReducers A reducer to specialize state changes.
 * @return The reducer.
 */
function inputControlStateReducer(composedStateReducers) {
  return (state, action) => {
    const nextState = {
      ...state
    };
    switch (action.type) {
      /*
       * Controlled updates
       */
      case _actions__WEBPACK_IMPORTED_MODULE_2__.CONTROL:
        nextState.value = action.payload.value;
        nextState.isDirty = false;
        nextState._event = undefined;
        // Returns immediately to avoid invoking additional reducers.
        return nextState;

      /**
       * Keyboard events
       */
      case _actions__WEBPACK_IMPORTED_MODULE_2__.PRESS_UP:
        nextState.isDirty = false;
        break;
      case _actions__WEBPACK_IMPORTED_MODULE_2__.PRESS_DOWN:
        nextState.isDirty = false;
        break;

      /**
       * Drag events
       */
      case _actions__WEBPACK_IMPORTED_MODULE_2__.DRAG_START:
        nextState.isDragging = true;
        break;
      case _actions__WEBPACK_IMPORTED_MODULE_2__.DRAG_END:
        nextState.isDragging = false;
        break;

      /**
       * Input events
       */
      case _actions__WEBPACK_IMPORTED_MODULE_2__.CHANGE:
        nextState.error = null;
        nextState.value = action.payload.value;
        if (state.isPressEnterToChange) {
          nextState.isDirty = true;
        }
        break;
      case _actions__WEBPACK_IMPORTED_MODULE_2__.COMMIT:
        nextState.value = action.payload.value;
        nextState.isDirty = false;
        break;
      case _actions__WEBPACK_IMPORTED_MODULE_2__.RESET:
        nextState.error = null;
        nextState.isDirty = false;
        nextState.value = action.payload.value || state.initialValue;
        break;

      /**
       * Validation
       */
      case _actions__WEBPACK_IMPORTED_MODULE_2__.INVALIDATE:
        nextState.error = action.payload.error;
        break;
    }
    nextState._event = action.payload.event;

    /**
     * Send the nextState + action to the composedReducers via
     * this "bridge" mechanism. This allows external stateReducers
     * to hook into actions, and modify state if needed.
     */
    return composedStateReducers(nextState, action);
  };
}

/**
 * A custom hook that connects and external stateReducer with an internal
 * reducer. This hook manages the internal state of InputControl.
 * However, by connecting an external stateReducer function, other
 * components can react to actions as well as modify state before it is
 * applied.
 *
 * This technique uses the "stateReducer" design pattern:
 * https://kentcdodds.com/blog/the-state-reducer-pattern/
 *
 * @param stateReducer    An external state reducer.
 * @param initialState    The initial state for the reducer.
 * @param onChangeHandler A handler for the onChange event.
 * @return State, dispatch, and a collection of actions.
 */
function useInputControlStateReducer(stateReducer = _state__WEBPACK_IMPORTED_MODULE_1__.initialStateReducer, initialState = _state__WEBPACK_IMPORTED_MODULE_1__.initialInputControlState, onChangeHandler) {
  const [state, dispatch] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useReducer)(inputControlStateReducer(stateReducer), mergeInitialState(initialState));
  const createChangeEvent = type => (nextValue, event) => {
    dispatch({
      type,
      payload: {
        value: nextValue,
        event
      }
    });
  };
  const createKeyEvent = type => event => {
    dispatch({
      type,
      payload: {
        event
      }
    });
  };
  const createDragEvent = type => payload => {
    dispatch({
      type,
      payload
    });
  };

  /**
   * Actions for the reducer
   */
  const change = createChangeEvent(_actions__WEBPACK_IMPORTED_MODULE_2__.CHANGE);
  const invalidate = (error, event) => dispatch({
    type: _actions__WEBPACK_IMPORTED_MODULE_2__.INVALIDATE,
    payload: {
      error,
      event
    }
  });
  const reset = createChangeEvent(_actions__WEBPACK_IMPORTED_MODULE_2__.RESET);
  const commit = createChangeEvent(_actions__WEBPACK_IMPORTED_MODULE_2__.COMMIT);
  const dragStart = createDragEvent(_actions__WEBPACK_IMPORTED_MODULE_2__.DRAG_START);
  const drag = createDragEvent(_actions__WEBPACK_IMPORTED_MODULE_2__.DRAG);
  const dragEnd = createDragEvent(_actions__WEBPACK_IMPORTED_MODULE_2__.DRAG_END);
  const pressUp = createKeyEvent(_actions__WEBPACK_IMPORTED_MODULE_2__.PRESS_UP);
  const pressDown = createKeyEvent(_actions__WEBPACK_IMPORTED_MODULE_2__.PRESS_DOWN);
  const pressEnter = createKeyEvent(_actions__WEBPACK_IMPORTED_MODULE_2__.PRESS_ENTER);
  const currentStateRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useRef)(state);
  const refPropsRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useRef)({
    value: initialState.value,
    onChangeHandler
  });

  // Freshens refs to props and state so that subsequent effects have access
  // to their latest values without their changes causing effect runs.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect)(() => {
    currentStateRef.current = state;
    refPropsRef.current = {
      value: initialState.value,
      onChangeHandler
    };
  });

  // Propagates the latest state through onChange.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect)(() => {
    if (currentStateRef.current._event !== undefined && state.value !== refPropsRef.current.value && !state.isDirty) {
      var _state$value;
      refPropsRef.current.onChangeHandler((_state$value = state.value) !== null && _state$value !== void 0 ? _state$value : '', {
        event: currentStateRef.current._event
      });
    }
  }, [state.value, state.isDirty]);

  // Updates the state from props.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect)(() => {
    if (initialState.value !== currentStateRef.current.value && !currentStateRef.current.isDirty) {
      var _initialState$value;
      dispatch({
        type: _actions__WEBPACK_IMPORTED_MODULE_2__.CONTROL,
        payload: {
          value: (_initialState$value = initialState.value) !== null && _initialState$value !== void 0 ? _initialState$value : ''
        }
      });
    }
  }, [initialState.value]);
  return {
    change,
    commit,
    dispatch,
    drag,
    dragEnd,
    dragStart,
    invalidate,
    pressDown,
    pressEnter,
    pressUp,
    reset,
    state
  };
}
//# sourceMappingURL=reducer.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/input-control/reducer/state.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/input-control/reducer/state.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   initialInputControlState: () => (/* binding */ initialInputControlState),
/* harmony export */   initialStateReducer: () => (/* binding */ initialStateReducer)
/* harmony export */ });
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */

const initialStateReducer = state => state;
const initialInputControlState = {
  error: null,
  initialValue: '',
  isDirty: false,
  isDragEnabled: false,
  isDragging: false,
  isPressEnterToChange: false,
  value: ''
};
//# sourceMappingURL=state.js.map

/***/ }),

/***/ "./node_modules/@wordpress/components/build-module/input-control/styles/input-control-styles.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@wordpress/components/build-module/input-control/styles/input-control-styles.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BackdropUI: () => (/* binding */ BackdropUI),
/* harmony export */   Container: () => (/* binding */ Container),
/* harmony export */   Input: () => (/* binding */ Input),
/* harmony export */   Label: () => (/* binding */ Label),
/* harmony export */   LabelWrapper: () => (/* binding */ LabelWrapper),
/* harmony export */   Prefix: () => (/* binding */ Prefix),
/* harmony export */   PrefixSuffixWrapper: () => (/* binding */ PrefixSuffixWrapper),
/* harmony export */   Root: () => (/* binding */ Root),
/* harmony export */   Suffix: () => (/* binding */ Suffix),
/* harmony export */   fontSizeStyles: () => (/* binding */ fontSizeStyles),
/* harmony export */   getSizeConfig: () => (/* binding */ getSizeConfig)
/* harmony export */ });
/* harmony import */ var _emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/styled/base */ "./node_modules/@emotion/styled/base/dist/emotion-styled-base.browser.development.esm.js");
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _flex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../flex */ "./node_modules/@wordpress/components/build-module/flex/flex/component.js");
/* harmony import */ var _flex__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../flex */ "./node_modules/@wordpress/components/build-module/flex/flex-item/component.js");
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../text */ "./node_modules/@wordpress/components/build-module/text/component.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils */ "./node_modules/@wordpress/components/build-module/utils/rtl.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils */ "./node_modules/@wordpress/components/build-module/utils/config-values.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils */ "./node_modules/@wordpress/components/build-module/utils/colors-values.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils */ "./node_modules/@wordpress/components/build-module/utils/base-label.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





const Prefix = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("span",  false ? 0 : {
  target: "em5sgkm8",
  label: "Prefix"
})( false ? 0 : {
  name: "pvvbxf",
  styles: "box-sizing:border-box;display:block",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
});
const Suffix = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("span",  false ? 0 : {
  target: "em5sgkm7",
  label: "Suffix"
})( false ? 0 : {
  name: "jgf79h",
  styles: "align-items:center;align-self:stretch;box-sizing:border-box;display:flex",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
});
const backdropBorderColor = ({
  disabled,
  isBorderless
}) => {
  if (isBorderless) {
    return 'transparent';
  }
  if (disabled) {
    return _utils__WEBPACK_IMPORTED_MODULE_7__.COLORS.ui.borderDisabled;
  }
  return _utils__WEBPACK_IMPORTED_MODULE_7__.COLORS.ui.border;
};
const BackdropUI = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("div",  false ? 0 : {
  target: "em5sgkm6",
  label: "BackdropUI"
})("&&&{box-sizing:border-box;border-color:", backdropBorderColor, ";border-radius:inherit;border-style:solid;border-width:1px;bottom:0;left:0;margin:0;padding:0;pointer-events:none;position:absolute;right:0;top:0;", (0,_utils__WEBPACK_IMPORTED_MODULE_5__.rtl)({
  paddingLeft: 2
}), ";}" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
const Root = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])(_flex__WEBPACK_IMPORTED_MODULE_2__["default"],  false ? 0 : {
  target: "em5sgkm5",
  label: "Root"
})("box-sizing:border-box;position:relative;border-radius:", _utils__WEBPACK_IMPORTED_MODULE_6__["default"].radiusSmall, ";padding-top:0;&:focus-within:not( :has( :is( ", Prefix, ", ", Suffix, " ):focus-within ) ){", BackdropUI, "{border-color:", _utils__WEBPACK_IMPORTED_MODULE_7__.COLORS.ui.borderFocus, ";box-shadow:", _utils__WEBPACK_IMPORTED_MODULE_6__["default"].controlBoxShadowFocus, ";outline:2px solid transparent;outline-offset:-2px;}}" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvaW5wdXQtY29udHJvbC9zdHlsZXMvaW5wdXQtY29udHJvbC1zdHlsZXMudHN4Il0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQTRFa0MiLCJmaWxlIjoiQHdvcmRwcmVzcy9jb21wb25lbnRzL3NyYy9pbnB1dC1jb250cm9sL3N0eWxlcy9pbnB1dC1jb250cm9sLXN0eWxlcy50c3giLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEV4dGVybmFsIGRlcGVuZGVuY2llc1xuICovXG5pbXBvcnQgdHlwZSB7IFNlcmlhbGl6ZWRTdHlsZXMgfSBmcm9tICdAZW1vdGlvbi9yZWFjdCc7XG5pbXBvcnQgeyBjc3MgfSBmcm9tICdAZW1vdGlvbi9yZWFjdCc7XG5pbXBvcnQgc3R5bGVkIGZyb20gJ0BlbW90aW9uL3N0eWxlZCc7XG5pbXBvcnQgdHlwZSB7IENTU1Byb3BlcnRpZXMsIFJlYWN0Tm9kZSB9IGZyb20gJ3JlYWN0JztcblxuLyoqXG4gKiBJbnRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHR5cGUgeyBXb3JkUHJlc3NDb21wb25lbnRQcm9wcyB9IGZyb20gJy4uLy4uL2NvbnRleHQnO1xuaW1wb3J0IHsgRmxleCwgRmxleEl0ZW0gfSBmcm9tICcuLi8uLi9mbGV4JztcbmltcG9ydCB7IFRleHQgfSBmcm9tICcuLi8uLi90ZXh0JztcbmltcG9ydCB7IGJhc2VMYWJlbFR5cG9ncmFwaHksIENPTE9SUywgQ09ORklHLCBydGwgfSBmcm9tICcuLi8uLi91dGlscyc7XG5pbXBvcnQgdHlwZSB7IExhYmVsUG9zaXRpb24sIFNpemUsIFByZWZpeFN1ZmZpeFdyYXBwZXJQcm9wcyB9IGZyb20gJy4uL3R5cGVzJztcblxudHlwZSBDb250YWluZXJQcm9wcyA9IHtcblx0ZGlzYWJsZWQ/OiBib29sZWFuO1xuXHRoaWRlTGFiZWw/OiBib29sZWFuO1xuXHRfX3Vuc3RhYmxlSW5wdXRXaWR0aD86IENTU1Byb3BlcnRpZXNbICd3aWR0aCcgXTtcblx0bGFiZWxQb3NpdGlvbj86IExhYmVsUG9zaXRpb247XG59O1xuXG5leHBvcnQgY29uc3QgUHJlZml4ID0gc3R5bGVkLnNwYW5gXG5cdGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG5cdGRpc3BsYXk6IGJsb2NrO1xuYDtcblxuZXhwb3J0IGNvbnN0IFN1ZmZpeCA9IHN0eWxlZC5zcGFuYFxuXHRhbGlnbi1pdGVtczogY2VudGVyO1xuXHRhbGlnbi1zZWxmOiBzdHJldGNoO1xuXHRib3gtc2l6aW5nOiBib3JkZXItYm94O1xuXHRkaXNwbGF5OiBmbGV4O1xuYDtcblxudHlwZSBCYWNrZHJvcFByb3BzID0ge1xuXHRkaXNhYmxlZD86IGJvb2xlYW47XG5cdGlzQm9yZGVybGVzcz86IGJvb2xlYW47XG59O1xuXG5jb25zdCBiYWNrZHJvcEJvcmRlckNvbG9yID0gKCB7XG5cdGRpc2FibGVkLFxuXHRpc0JvcmRlcmxlc3MsXG59OiBCYWNrZHJvcFByb3BzICk6IENTU1Byb3BlcnRpZXNbICdib3JkZXJDb2xvcicgXSA9PiB7XG5cdGlmICggaXNCb3JkZXJsZXNzICkge1xuXHRcdHJldHVybiAndHJhbnNwYXJlbnQnO1xuXHR9XG5cblx0aWYgKCBkaXNhYmxlZCApIHtcblx0XHRyZXR1cm4gQ09MT1JTLnVpLmJvcmRlckRpc2FibGVkO1xuXHR9XG5cblx0cmV0dXJuIENPTE9SUy51aS5ib3JkZXI7XG59O1xuXG5leHBvcnQgY29uc3QgQmFja2Ryb3BVSSA9IHN0eWxlZC5kaXY8IEJhY2tkcm9wUHJvcHMgPmBcblx0JiYmIHtcblx0XHRib3gtc2l6aW5nOiBib3JkZXItYm94O1xuXHRcdGJvcmRlci1jb2xvcjogJHsgYmFja2Ryb3BCb3JkZXJDb2xvciB9O1xuXHRcdGJvcmRlci1yYWRpdXM6IGluaGVyaXQ7XG5cdFx0Ym9yZGVyLXN0eWxlOiBzb2xpZDtcblx0XHRib3JkZXItd2lkdGg6IDFweDtcblx0XHRib3R0b206IDA7XG5cdFx0bGVmdDogMDtcblx0XHRtYXJnaW46IDA7XG5cdFx0cGFkZGluZzogMDtcblx0XHRwb2ludGVyLWV2ZW50czogbm9uZTtcblx0XHRwb3NpdGlvbjogYWJzb2x1dGU7XG5cdFx0cmlnaHQ6IDA7XG5cdFx0dG9wOiAwO1xuXG5cdFx0JHsgcnRsKCB7IHBhZGRpbmdMZWZ0OiAyIH0gKSB9XG5cdH1cbmA7XG5cbmV4cG9ydCBjb25zdCBSb290ID0gc3R5bGVkKCBGbGV4IClgXG5cdGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG5cdHBvc2l0aW9uOiByZWxhdGl2ZTtcblx0Ym9yZGVyLXJhZGl1czogJHsgQ09ORklHLnJhZGl1c1NtYWxsIH07XG5cdHBhZGRpbmctdG9wOiAwO1xuXG5cdC8vIEZvY3VzIHdpdGhpbiwgZXhjbHVkaW5nIGNhc2VzIHdoZXJlIGF1eGlsaWFyeSBjb250cm9scyBpbiBwcmVmaXggb3Igc3VmZml4IGhhdmUgZm9jdXMuXG5cdCY6Zm9jdXMtd2l0aGluOm5vdCggOmhhcyggOmlzKCAkeyBQcmVmaXggfSwgJHsgU3VmZml4IH0gKTpmb2N1cy13aXRoaW4gKSApIHtcblx0XHQkeyBCYWNrZHJvcFVJIH0ge1xuXHRcdFx0Ym9yZGVyLWNvbG9yOiAkeyBDT0xPUlMudWkuYm9yZGVyRm9jdXMgfTtcblx0XHRcdGJveC1zaGFkb3c6ICR7IENPTkZJRy5jb250cm9sQm94U2hhZG93Rm9jdXMgfTtcblx0XHRcdC8vIFdpbmRvd3MgSGlnaCBDb250cmFzdCBtb2RlIHdpbGwgc2hvdyB0aGlzIG91dGxpbmUsIGJ1dCBub3QgdGhlIGJveC1zaGFkb3cuXG5cdFx0XHRvdXRsaW5lOiAycHggc29saWQgdHJhbnNwYXJlbnQ7XG5cdFx0XHRvdXRsaW5lLW9mZnNldDogLTJweDtcblx0XHR9XG5cdH1cbmA7XG5cbmNvbnN0IGNvbnRhaW5lckRpc2FibGVkU3R5bGVzID0gKCB7IGRpc2FibGVkIH06IENvbnRhaW5lclByb3BzICkgPT4ge1xuXHRjb25zdCBiYWNrZ3JvdW5kQ29sb3IgPSBkaXNhYmxlZFxuXHRcdD8gQ09MT1JTLnVpLmJhY2tncm91bmREaXNhYmxlZFxuXHRcdDogQ09MT1JTLnVpLmJhY2tncm91bmQ7XG5cblx0cmV0dXJuIGNzcyggeyBiYWNrZ3JvdW5kQ29sb3IgfSApO1xufTtcblxuY29uc3QgY29udGFpbmVyV2lkdGhTdHlsZXMgPSAoIHtcblx0X191bnN0YWJsZUlucHV0V2lkdGgsXG5cdGxhYmVsUG9zaXRpb24sXG59OiBDb250YWluZXJQcm9wcyApID0+IHtcblx0aWYgKCAhIF9fdW5zdGFibGVJbnB1dFdpZHRoICkge1xuXHRcdHJldHVybiBjc3MoIHsgd2lkdGg6ICcxMDAlJyB9ICk7XG5cdH1cblxuXHRpZiAoIGxhYmVsUG9zaXRpb24gPT09ICdzaWRlJyApIHtcblx0XHRyZXR1cm4gJyc7XG5cdH1cblxuXHRpZiAoIGxhYmVsUG9zaXRpb24gPT09ICdlZGdlJyApIHtcblx0XHRyZXR1cm4gY3NzKCB7XG5cdFx0XHRmbGV4OiBgMCAwICR7IF9fdW5zdGFibGVJbnB1dFdpZHRoIH1gLFxuXHRcdH0gKTtcblx0fVxuXG5cdHJldHVybiBjc3MoIHsgd2lkdGg6IF9fdW5zdGFibGVJbnB1dFdpZHRoIH0gKTtcbn07XG5cbmV4cG9ydCBjb25zdCBDb250YWluZXIgPSBzdHlsZWQuZGl2PCBDb250YWluZXJQcm9wcyA+YFxuXHRhbGlnbi1pdGVtczogY2VudGVyO1xuXHRib3gtc2l6aW5nOiBib3JkZXItYm94O1xuXHRib3JkZXItcmFkaXVzOiBpbmhlcml0O1xuXHRkaXNwbGF5OiBmbGV4O1xuXHRmbGV4OiAxO1xuXHRwb3NpdGlvbjogcmVsYXRpdmU7XG5cblx0JHsgY29udGFpbmVyRGlzYWJsZWRTdHlsZXMgfVxuXHQkeyBjb250YWluZXJXaWR0aFN0eWxlcyB9XG5gO1xuXG50eXBlIElucHV0UHJvcHMgPSB7XG5cdF9fbmV4dDQwcHhEZWZhdWx0U2l6ZT86IGJvb2xlYW47XG5cdGRpc2FibGVkPzogYm9vbGVhbjtcblx0aW5wdXRTaXplPzogU2l6ZTtcblx0aXNEcmFnZ2luZz86IGJvb2xlYW47XG5cdGRyYWdDdXJzb3I/OiBDU1NQcm9wZXJ0aWVzWyAnY3Vyc29yJyBdO1xuXHRwYWRkaW5nSW5saW5lU3RhcnQ/OiBDU1NQcm9wZXJ0aWVzWyAncGFkZGluZ0lubGluZVN0YXJ0JyBdO1xuXHRwYWRkaW5nSW5saW5lRW5kPzogQ1NTUHJvcGVydGllc1sgJ3BhZGRpbmdJbmxpbmVFbmQnIF07XG59O1xuXG5jb25zdCBkaXNhYmxlZFN0eWxlcyA9ICggeyBkaXNhYmxlZCB9OiBJbnB1dFByb3BzICkgPT4ge1xuXHRpZiAoICEgZGlzYWJsZWQgKSB7XG5cdFx0cmV0dXJuICcnO1xuXHR9XG5cblx0cmV0dXJuIGNzcygge1xuXHRcdGNvbG9yOiBDT0xPUlMudWkudGV4dERpc2FibGVkLFxuXHR9ICk7XG59O1xuXG5leHBvcnQgY29uc3QgZm9udFNpemVTdHlsZXMgPSAoIHsgaW5wdXRTaXplOiBzaXplIH06IElucHV0UHJvcHMgKSA9PiB7XG5cdGNvbnN0IHNpemVzID0ge1xuXHRcdGRlZmF1bHQ6ICcxM3B4Jyxcblx0XHRzbWFsbDogJzExcHgnLFxuXHRcdGNvbXBhY3Q6ICcxM3B4Jyxcblx0XHQnX191bnN0YWJsZS1sYXJnZSc6ICcxM3B4Jyxcblx0fTtcblxuXHRjb25zdCBmb250U2l6ZSA9IHNpemVzWyBzaXplIGFzIFNpemUgXSB8fCBzaXplcy5kZWZhdWx0O1xuXHRjb25zdCBmb250U2l6ZU1vYmlsZSA9ICcxNnB4JztcblxuXHRpZiAoICEgZm9udFNpemUgKSB7XG5cdFx0cmV0dXJuICcnO1xuXHR9XG5cblx0cmV0dXJuIGNzc2Bcblx0XHRmb250LXNpemU6ICR7IGZvbnRTaXplTW9iaWxlIH07XG5cblx0XHRAbWVkaWEgKCBtaW4td2lkdGg6IDYwMHB4ICkge1xuXHRcdFx0Zm9udC1zaXplOiAkeyBmb250U2l6ZSB9O1xuXHRcdH1cblx0YDtcbn07XG5cbmV4cG9ydCBjb25zdCBnZXRTaXplQ29uZmlnID0gKCB7XG5cdGlucHV0U2l6ZTogc2l6ZSxcblx0X19uZXh0NDBweERlZmF1bHRTaXplLFxufTogSW5wdXRQcm9wcyApID0+IHtcblx0Ly8gUGFkZGluZ3MgbWF5IGJlIG92ZXJyaWRkZW4gYnkgdGhlIGN1c3RvbSBwYWRkaW5ncyBwcm9wcy5cblx0Y29uc3Qgc2l6ZXMgPSB7XG5cdFx0ZGVmYXVsdDoge1xuXHRcdFx0aGVpZ2h0OiA0MCxcblx0XHRcdGxpbmVIZWlnaHQ6IDEsXG5cdFx0XHRtaW5IZWlnaHQ6IDQwLFxuXHRcdFx0cGFkZGluZ0xlZnQ6IENPTkZJRy5jb250cm9sUGFkZGluZ1gsXG5cdFx0XHRwYWRkaW5nUmlnaHQ6IENPTkZJRy5jb250cm9sUGFkZGluZ1gsXG5cdFx0fSxcblx0XHRzbWFsbDoge1xuXHRcdFx0aGVpZ2h0OiAyNCxcblx0XHRcdGxpbmVIZWlnaHQ6IDEsXG5cdFx0XHRtaW5IZWlnaHQ6IDI0LFxuXHRcdFx0cGFkZGluZ0xlZnQ6IENPTkZJRy5jb250cm9sUGFkZGluZ1hTbWFsbCxcblx0XHRcdHBhZGRpbmdSaWdodDogQ09ORklHLmNvbnRyb2xQYWRkaW5nWFNtYWxsLFxuXHRcdH0sXG5cdFx0Y29tcGFjdDoge1xuXHRcdFx0aGVpZ2h0OiAzMixcblx0XHRcdGxpbmVIZWlnaHQ6IDEsXG5cdFx0XHRtaW5IZWlnaHQ6IDMyLFxuXHRcdFx0cGFkZGluZ0xlZnQ6IENPTkZJRy5jb250cm9sUGFkZGluZ1hTbWFsbCxcblx0XHRcdHBhZGRpbmdSaWdodDogQ09ORklHLmNvbnRyb2xQYWRkaW5nWFNtYWxsLFxuXHRcdH0sXG5cdFx0J19fdW5zdGFibGUtbGFyZ2UnOiB7XG5cdFx0XHRoZWlnaHQ6IDQwLFxuXHRcdFx0bGluZUhlaWdodDogMSxcblx0XHRcdG1pbkhlaWdodDogNDAsXG5cdFx0XHRwYWRkaW5nTGVmdDogQ09ORklHLmNvbnRyb2xQYWRkaW5nWCxcblx0XHRcdHBhZGRpbmdSaWdodDogQ09ORklHLmNvbnRyb2xQYWRkaW5nWCxcblx0XHR9LFxuXHR9O1xuXG5cdGlmICggISBfX25leHQ0MHB4RGVmYXVsdFNpemUgKSB7XG5cdFx0c2l6ZXMuZGVmYXVsdCA9IHNpemVzLmNvbXBhY3Q7XG5cdH1cblxuXHRyZXR1cm4gc2l6ZXNbIHNpemUgYXMgU2l6ZSBdIHx8IHNpemVzLmRlZmF1bHQ7XG59O1xuXG5jb25zdCBzaXplU3R5bGVzID0gKCBwcm9wczogSW5wdXRQcm9wcyApID0+IHtcblx0cmV0dXJuIGNzcyggZ2V0U2l6ZUNvbmZpZyggcHJvcHMgKSApO1xufTtcblxuY29uc3QgY3VzdG9tUGFkZGluZ3MgPSAoIHtcblx0cGFkZGluZ0lubGluZVN0YXJ0LFxuXHRwYWRkaW5nSW5saW5lRW5kLFxufTogSW5wdXRQcm9wcyApID0+IHtcblx0cmV0dXJuIGNzcyggeyBwYWRkaW5nSW5saW5lU3RhcnQsIHBhZGRpbmdJbmxpbmVFbmQgfSApO1xufTtcblxuY29uc3QgZHJhZ1N0eWxlcyA9ICggeyBpc0RyYWdnaW5nLCBkcmFnQ3Vyc29yIH06IElucHV0UHJvcHMgKSA9PiB7XG5cdGxldCBkZWZhdWx0QXJyb3dTdHlsZXM6IFNlcmlhbGl6ZWRTdHlsZXMgfCB1bmRlZmluZWQ7XG5cdGxldCBhY3RpdmVEcmFnQ3Vyc29yU3R5bGVzOiBTZXJpYWxpemVkU3R5bGVzIHwgdW5kZWZpbmVkO1xuXG5cdGlmICggaXNEcmFnZ2luZyApIHtcblx0XHRkZWZhdWx0QXJyb3dTdHlsZXMgPSBjc3NgXG5cdFx0XHRjdXJzb3I6ICR7IGRyYWdDdXJzb3IgfTtcblx0XHRcdHVzZXItc2VsZWN0OiBub25lO1xuXG5cdFx0XHQmOjotd2Via2l0LW91dGVyLXNwaW4tYnV0dG9uLFxuXHRcdFx0Jjo6LXdlYmtpdC1pbm5lci1zcGluLWJ1dHRvbiB7XG5cdFx0XHRcdC13ZWJraXQtYXBwZWFyYW5jZTogbm9uZSAhaW1wb3J0YW50O1xuXHRcdFx0XHRtYXJnaW46IDAgIWltcG9ydGFudDtcblx0XHRcdH1cblx0XHRgO1xuXHR9XG5cblx0aWYgKCBpc0RyYWdnaW5nICYmIGRyYWdDdXJzb3IgKSB7XG5cdFx0YWN0aXZlRHJhZ0N1cnNvclN0eWxlcyA9IGNzc2Bcblx0XHRcdCY6YWN0aXZlIHtcblx0XHRcdFx0Y3Vyc29yOiAkeyBkcmFnQ3Vyc29yIH07XG5cdFx0XHR9XG5cdFx0YDtcblx0fVxuXG5cdHJldHVybiBjc3NgXG5cdFx0JHsgZGVmYXVsdEFycm93U3R5bGVzIH1cblx0XHQkeyBhY3RpdmVEcmFnQ3Vyc29yU3R5bGVzIH1cblx0YDtcbn07XG5cbi8vIFRPRE86IFJlc29sdmUgbmVlZCB0byB1c2UgJiYmIHRvIGluY3JlYXNlIHNwZWNpZmljaXR5XG4vLyBodHRwczovL2dpdGh1Yi5jb20vV29yZFByZXNzL2d1dGVuYmVyZy9pc3N1ZXMvMTg0ODNcblxuZXhwb3J0IGNvbnN0IElucHV0ID0gc3R5bGVkLmlucHV0PCBJbnB1dFByb3BzID5gXG5cdCYmJiB7XG5cdFx0YmFja2dyb3VuZC1jb2xvcjogdHJhbnNwYXJlbnQ7XG5cdFx0Ym94LXNpemluZzogYm9yZGVyLWJveDtcblx0XHRib3JkZXI6IG5vbmU7XG5cdFx0Ym94LXNoYWRvdzogbm9uZSAhaW1wb3J0YW50O1xuXHRcdGNvbG9yOiAkeyBDT0xPUlMudGhlbWUuZm9yZWdyb3VuZCB9O1xuXHRcdGRpc3BsYXk6IGJsb2NrO1xuXHRcdGZvbnQtZmFtaWx5OiBpbmhlcml0O1xuXHRcdG1hcmdpbjogMDtcblx0XHRvdXRsaW5lOiBub25lO1xuXHRcdHdpZHRoOiAxMDAlO1xuXG5cdFx0JHsgZHJhZ1N0eWxlcyB9XG5cdFx0JHsgZGlzYWJsZWRTdHlsZXMgfVxuXHRcdCR7IGZvbnRTaXplU3R5bGVzIH1cblx0XHQkeyBzaXplU3R5bGVzIH1cblx0XHQkeyBjdXN0b21QYWRkaW5ncyB9XG5cblx0XHQmOjotd2Via2l0LWlucHV0LXBsYWNlaG9sZGVyIHtcblx0XHRcdGNvbG9yOiAkeyBDT0xPUlMudWkuZGFya0dyYXlQbGFjZWhvbGRlciB9O1xuXHRcdH1cblxuXHRcdCY6Oi1tb3otcGxhY2Vob2xkZXIge1xuXHRcdFx0Y29sb3I6ICR7IENPTE9SUy51aS5kYXJrR3JheVBsYWNlaG9sZGVyIH07XG5cdFx0fVxuXG5cdFx0JjotbXMtaW5wdXQtcGxhY2Vob2xkZXIge1xuXHRcdFx0Y29sb3I6ICR7IENPTE9SUy51aS5kYXJrR3JheVBsYWNlaG9sZGVyIH07XG5cdFx0fVxuXG5cdFx0Jlt0eXBlPSdlbWFpbCddLFxuXHRcdCZbdHlwZT0ndXJsJ10ge1xuXHRcdFx0LyogcnRsOmlnbm9yZSAqL1xuXHRcdFx0ZGlyZWN0aW9uOiBsdHI7XG5cdFx0fVxuXHR9XG5gO1xuXG5jb25zdCBCYXNlTGFiZWwgPSBzdHlsZWQoIFRleHQgKTwgeyBsYWJlbFBvc2l0aW9uPzogTGFiZWxQb3NpdGlvbiB9ID5gXG5cdCYmJiB7XG5cdFx0JHsgYmFzZUxhYmVsVHlwb2dyYXBoeSB9O1xuXG5cdFx0Ym94LXNpemluZzogYm9yZGVyLWJveDtcblx0XHRkaXNwbGF5OiBibG9jaztcblx0XHRwYWRkaW5nLXRvcDogMDtcblx0XHRwYWRkaW5nLWJvdHRvbTogMDtcblx0XHRtYXgtd2lkdGg6IDEwMCU7XG5cdFx0ei1pbmRleDogMTtcblxuXHRcdG92ZXJmbG93OiBoaWRkZW47XG5cdFx0dGV4dC1vdmVyZmxvdzogZWxsaXBzaXM7XG5cdFx0d2hpdGUtc3BhY2U6IG5vd3JhcDtcblx0fVxuYDtcblxuZXhwb3J0IGNvbnN0IExhYmVsID0gKFxuXHRwcm9wczogV29yZFByZXNzQ29tcG9uZW50UHJvcHM8XG5cdFx0eyBsYWJlbFBvc2l0aW9uPzogTGFiZWxQb3NpdGlvbjsgY2hpbGRyZW46IFJlYWN0Tm9kZSB9LFxuXHRcdCdsYWJlbCcsXG5cdFx0ZmFsc2Vcblx0PlxuKSA9PiA8QmFzZUxhYmVsIHsgLi4ucHJvcHMgfSBhcz1cImxhYmVsXCIgLz47XG5cbmV4cG9ydCBjb25zdCBMYWJlbFdyYXBwZXIgPSBzdHlsZWQoIEZsZXhJdGVtIClgXG5cdG1heC13aWR0aDogY2FsYyggMTAwJSAtIDEwcHggKTtcbmA7XG5cbmNvbnN0IHByZWZpeFN1ZmZpeFdyYXBwZXJTdHlsZXMgPSAoIHtcblx0dmFyaWFudCA9ICdkZWZhdWx0Jyxcblx0c2l6ZSxcblx0X19uZXh0NDBweERlZmF1bHRTaXplLFxuXHRpc1ByZWZpeCxcbn06IFByZWZpeFN1ZmZpeFdyYXBwZXJQcm9wcyAmIHsgaXNQcmVmaXg/OiBib29sZWFuIH0gKSA9PiB7XG5cdGNvbnN0IHsgcGFkZGluZ0xlZnQ6IHBhZGRpbmcgfSA9IGdldFNpemVDb25maWcoIHtcblx0XHRpbnB1dFNpemU6IHNpemUsXG5cdFx0X19uZXh0NDBweERlZmF1bHRTaXplLFxuXHR9ICk7XG5cblx0Y29uc3QgcGFkZGluZ1Byb3BlcnR5ID0gaXNQcmVmaXhcblx0XHQ/ICdwYWRkaW5nSW5saW5lU3RhcnQnXG5cdFx0OiAncGFkZGluZ0lubGluZUVuZCc7XG5cblx0aWYgKCB2YXJpYW50ID09PSAnZGVmYXVsdCcgKSB7XG5cdFx0cmV0dXJuIGNzcygge1xuXHRcdFx0WyBwYWRkaW5nUHJvcGVydHkgXTogcGFkZGluZyxcblx0XHR9ICk7XG5cdH1cblxuXHQvLyBJZiB2YXJpYW50IGlzICdpY29uJyBvciAnY29udHJvbCdcblx0cmV0dXJuIGNzcygge1xuXHRcdGRpc3BsYXk6ICdmbGV4Jyxcblx0XHRbIHBhZGRpbmdQcm9wZXJ0eSBdOiBwYWRkaW5nIC0gNCxcblx0fSApO1xufTtcblxuZXhwb3J0IGNvbnN0IFByZWZpeFN1ZmZpeFdyYXBwZXIgPSBzdHlsZWQuZGl2YFxuXHQkeyBwcmVmaXhTdWZmaXhXcmFwcGVyU3R5bGVzIH1cbmA7XG4iXX0= */"));
const containerDisabledStyles = ({
  disabled
}) => {
  const backgroundColor = disabled ? _utils__WEBPACK_IMPORTED_MODULE_7__.COLORS.ui.backgroundDisabled : _utils__WEBPACK_IMPORTED_MODULE_7__.COLORS.ui.background;
  return /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)({
    backgroundColor
  },  false ? 0 : ";label:containerDisabledStyles;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
};
var _ref =  false ? 0 : {
  name: "uo2pd2-containerWidthStyles",
  styles: "width:100%;label:containerWidthStyles;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const containerWidthStyles = ({
  __unstableInputWidth,
  labelPosition
}) => {
  if (!__unstableInputWidth) {
    return _ref;
  }
  if (labelPosition === 'side') {
    return '';
  }
  if (labelPosition === 'edge') {
    return /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)({
      flex: `0 0 ${__unstableInputWidth}`
    },  false ? 0 : ";label:containerWidthStyles;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
  }
  return /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)({
    width: __unstableInputWidth
  },  false ? 0 : ";label:containerWidthStyles;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
};
const Container = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("div",  false ? 0 : {
  target: "em5sgkm4",
  label: "Container"
})("align-items:center;box-sizing:border-box;border-radius:inherit;display:flex;flex:1;position:relative;", containerDisabledStyles, " ", containerWidthStyles, ";" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
const disabledStyles = ({
  disabled
}) => {
  if (!disabled) {
    return '';
  }
  return /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)({
    color: _utils__WEBPACK_IMPORTED_MODULE_7__.COLORS.ui.textDisabled
  },  false ? 0 : ";label:disabledStyles;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
};
const fontSizeStyles = ({
  inputSize: size
}) => {
  const sizes = {
    default: '13px',
    small: '11px',
    compact: '13px',
    '__unstable-large': '13px'
  };
  const fontSize = sizes[size] || sizes.default;
  const fontSizeMobile = '16px';
  if (!fontSize) {
    return '';
  }
  return /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)("font-size:", fontSizeMobile, ";@media ( min-width: 600px ){font-size:", fontSize, ";}" + ( false ? 0 : ";label:fontSizeStyles;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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