<?php
/**
 * SVG icons used in aThemes Addons
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'aThemes_Addons_SVG_Icons' ) ) {
	/**
	 * Get a svg icon
	 */
	class aThemes_Addons_SVG_Icons {

		public static function get_svg_icon( $icon, $echo = true ) { // phpcs:ignore Universal.NamingConventions.NoReservedKeywordParameterNames.echoFound
			$icons = apply_filters( 'athemes_addons_svg_icons', self::$svg_icons );

			$svg_code = $icons[ $icon ];

			if ( !$echo ) {
				return $svg_code;
			}

			echo $svg_code; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		}

		public static $svg_icons = array(
			'icon-star'             => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="22" fill="none"><path fill-rule="evenodd" d="M12.908.581a1 1 0 0 0-1.816 0l-2.87 6.22-6.801.807a1 1 0 0 0-.562 1.727l5.03 4.65-1.335 6.72a1 1 0 0 0 1.469 1.067L12 18.426l5.977 3.346a1 1 0 0 0 1.47-1.068l-1.335-6.718 5.029-4.651a1 1 0 0 0-.562-1.727L15.777 6.8 12.907.581Z" clip-rule="evenodd"/></svg>',
			'icon-arrow-left'       => '<svg xmlns="http://www.w3.org/2000/svg" width="21" height="40" fill="none"><path d="M3.589 20 20.564 2.556a1.498 1.498 0 1 0-2.149-2.09L.425 18.954a1.5 1.5 0 0 0 0 2.09l17.99 18.49a1.5 1.5 0 1 0 2.149-2.091L3.587 20h.002Z"/></svg>',
			'icon-arrow-right'      => '<svg xmlns="http://www.w3.org/2000/svg" width="21" height="40" fill="none"><path d="M17.411 20 .436 2.556A1.5 1.5 0 1 1 2.585.466l17.99 18.489a1.5 1.5 0 0 1 0 2.09l-17.99 18.49a1.498 1.498 0 1 1-2.149-2.091L17.413 20h-.002Z"/></svg>',
			'icon-vertical-scroll'  => '<svg width="77" height="220" viewBox="0 0 77 220" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M74.2398 177.76C75.3634 178.885 75.9945 180.41 75.9945 182C75.9945 183.59 75.3634 185.115 74.2398 186.24L42.2398 218.24C41.1148 219.364 39.5898 219.995 37.9998 219.995C36.4097 219.995 34.8848 219.364 33.7598 218.24L1.75975 186.24C0.699914 185.103 0.122923 183.598 0.150349 182.044C0.177775 180.489 0.807476 179.006 1.90678 177.907C3.00608 176.808 4.48917 176.178 6.04358 176.151C7.59798 176.123 9.10235 176.7 10.2397 177.76L31.9998 199.51V20.51L10.2397 42.24C9.10235 43.2998 7.59798 43.8768 6.04358 43.8494C4.48917 43.8219 3.00608 43.1922 1.90678 42.0929C0.807476 40.9936 0.177775 39.5106 0.150349 37.9562C0.122923 36.4017 0.699914 34.8974 1.75975 33.76L33.7598 1.75997C34.8848 0.636366 36.4097 0.00524902 37.9998 0.00524902C39.5898 0.00524902 41.1148 0.636366 42.2398 1.75997L74.2398 33.76C74.8293 34.3093 75.3021 34.9717 75.63 35.7077C75.9579 36.4437 76.1343 37.2382 76.1485 38.0438C76.1627 38.8494 76.0145 39.6496 75.7127 40.3968C75.411 41.1439 74.9618 41.8225 74.3921 42.3923C73.8223 42.962 73.1436 43.4112 72.3965 43.713C71.6494 44.0147 70.8492 44.1629 70.0436 44.1487C69.238 44.1345 68.4434 43.9582 67.7074 43.6302C66.9714 43.3023 66.309 42.8295 65.7598 42.24L43.9998 20.49V199.49L65.7598 177.74C66.8874 176.619 68.4139 175.991 70.0039 175.995C71.5939 175.999 73.1174 176.634 74.2398 177.76Z"/></svg>',
			'icon-quote'            => '<svg width="18" height="15" viewBox="0 0 18 15" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16.4169 1.679C17.4469 2.773 17.9999 4 17.9999 5.989C17.9999 9.489 15.5439 12.626 11.9699 14.177L11.0769 12.799C14.4119 10.995 15.0639 8.654 15.3249 7.178C14.7879 7.456 14.0849 7.553 13.3949 7.489C11.5909 7.322 10.1689 5.841 10.1689 4C10.1689 3.07174 10.5377 2.1815 11.194 1.52513C11.8504 0.868749 12.7407 0.5 13.6689 0.5C14.7419 0.5 15.7689 0.99 16.4169 1.679ZM6.41692 1.679C7.44692 2.773 7.99992 4 7.99992 5.989C7.99992 9.489 5.54392 12.626 1.96992 14.177L1.07692 12.799C4.41192 10.995 5.06392 8.654 5.32392 7.178C4.78692 7.456 4.08392 7.553 3.39492 7.489C1.59092 7.323 0.169922 5.842 0.169922 4C0.169922 3.07174 0.538671 2.1815 1.19505 1.52513C1.85143 0.868749 2.74166 0.5 3.66992 0.5C4.74292 0.5 5.76992 0.99 6.41792 1.679"/></svg>',
			'icon-loading'          => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10 1C8.21997 1 6.47991 1.52784 4.99987 2.51677C3.51983 3.50571 2.36628 4.91131 1.68509 6.55585C1.0039 8.20038 0.82567 10.01 1.17294 11.7558C1.5202 13.5016 2.37737 15.1053 3.63604 16.364C4.89472 17.6226 6.49836 18.4798 8.24419 18.8271C9.99002 19.1743 11.7996 18.9961 13.4442 18.3149C15.0887 17.6337 16.4943 16.4802 17.4832 15.0001C18.4722 13.5201 19 11.78 19 10" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
			'icon-cart'             => '<svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M13.334 15C13.776 15 14.1999 15.1756 14.5125 15.4882C14.8251 15.8007 15.0007 16.2246 15.0007 16.6667C15.0007 17.1087 14.8251 17.5326 14.5125 17.8452C14.1999 18.1577 13.776 18.3333 13.334 18.3333C12.892 18.3333 12.468 18.1577 12.1555 17.8452C11.8429 17.5326 11.6673 17.1087 11.6673 16.6667C11.6673 16.2246 11.8429 15.8007 12.1555 15.4882C12.468 15.1756 12.892 15 13.334 15ZM13.334 15.8333C13.113 15.8333 12.901 15.9211 12.7447 16.0774C12.5884 16.2337 12.5007 16.4457 12.5007 16.6667C12.5007 16.8877 12.5884 17.0996 12.7447 17.2559C12.901 17.4122 13.113 17.5 13.334 17.5C13.555 17.5 13.767 17.4122 13.9232 17.2559C14.0795 17.0996 14.1673 16.8877 14.1673 16.6667C14.1673 16.4457 14.0795 16.2337 13.9232 16.0774C13.767 15.9211 13.555 15.8333 13.334 15.8333ZM5.83398 15C6.27601 15 6.69993 15.1756 7.0125 15.4882C7.32506 15.8007 7.50065 16.2246 7.50065 16.6667C7.50065 17.1087 7.32506 17.5326 7.0125 17.8452C6.69993 18.1577 6.27601 18.3333 5.83398 18.3333C5.39196 18.3333 4.96803 18.1577 4.65547 17.8452C4.34291 17.5326 4.16732 17.1087 4.16732 16.6667C4.16732 16.2246 4.34291 15.8007 4.65547 15.4882C4.96803 15.1756 5.39196 15 5.83398 15ZM5.83398 15.8333C5.61297 15.8333 5.40101 15.9211 5.24473 16.0774C5.08845 16.2337 5.00065 16.4457 5.00065 16.6667C5.00065 16.8877 5.08845 17.0996 5.24473 17.2559C5.40101 17.4122 5.61297 17.5 5.83398 17.5C6.055 17.5 6.26696 17.4122 6.42324 17.2559C6.57952 17.0996 6.66732 16.8877 6.66732 16.6667C6.66732 16.4457 6.57952 16.2337 6.42324 16.0774C6.26696 15.9211 6.055 15.8333 5.83398 15.8333ZM15.0007 5H3.55898L5.68398 10H12.5007C12.7757 10 13.0173 9.86667 13.1673 9.66667L15.6673 6.33333C15.7757 6.19167 15.834 6.01667 15.834 5.83333C15.834 5.61232 15.7462 5.40036 15.5899 5.24408C15.4336 5.0878 15.2217 5 15.0007 5ZM12.5007 10.8333H5.72565L5.08398 12.1333L5.00065 12.5C5.00065 12.721 5.08845 12.933 5.24473 13.0893C5.40101 13.2455 5.61297 13.3333 5.83398 13.3333H15.0007V14.1667H5.83398C5.39196 14.1667 4.96803 13.9911 4.65547 13.6785C4.34291 13.3659 4.16732 12.942 4.16732 12.5C4.16707 12.2172 4.23876 11.9391 4.37565 11.6917L4.97565 10.4667L1.95065 3.33333H0.833984V2.5H2.50065L3.20898 4.16667H15.0007C15.4427 4.16667 15.8666 4.34226 16.1792 4.65482C16.4917 4.96738 16.6673 5.39131 16.6673 5.83333C16.6673 6.25 16.5257 6.6 16.2923 6.88333L13.8673 10.125C13.5673 10.55 13.0673 10.8333 12.5007 10.8333Z"/></svg>',
			'icon-cancel'           => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12.59 0L7 5.59L1.41 0L0 1.41L5.59 7L0 12.59L1.41 14L7 8.41L12.59 14L14 12.59L8.41 7L14 1.41L12.59 0Z"/></svg>',
			'icon-logout'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384.971 384.971" style="enable-background:new 0 0 384.971 384.971" xml:space="preserve"><path d="M180.455 360.91H24.061V24.061h156.394c6.641 0 12.03-5.39 12.03-12.03s-5.39-12.03-12.03-12.03H12.03C5.39.001 0 5.39 0 12.031V372.94c0 6.641 5.39 12.03 12.03 12.03h168.424c6.641 0 12.03-5.39 12.03-12.03.001-6.641-5.389-12.03-12.029-12.03z"/><path d="m381.481 184.088-83.009-84.2a11.942 11.942 0 0 0-17.011 0c-4.704 4.74-4.704 12.439 0 17.179l62.558 63.46H96.279c-6.641 0-12.03 5.438-12.03 12.151s5.39 12.151 12.03 12.151h247.74l-62.558 63.46c-4.704 4.752-4.704 12.439 0 17.179a11.931 11.931 0 0 0 17.011 0l82.997-84.2c4.644-4.68 4.692-12.512.012-17.18z"/></svg>',
			'icon-user'             => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M224 256c70.7 0 128-57.3 128-128S294.7 0 224 0 96 57.3 96 128s57.3 128 128 128zm89.6 32h-16.7c-22.2 10.2-46.9 16-72.9 16s-50.6-5.8-72.9-16h-16.7C60.2 288 0 348.2 0 422.4V464c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48v-41.6c0-74.2-60.2-134.4-134.4-134.4z"/></svg>',
			'icon-facebook'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z"/></svg>',
			'icon-twitter'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z"/></svg>',
			'icon-github'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"/></svg>',
			'icon-linkedin'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M416 32H31.9C14.3 32 0 46.5 0 64.3v383.4C0 465.5 14.3 480 31.9 480H416c17.6 0 32-14.5 32-32.3V64.3c0-17.8-14.4-32.3-32-32.3zM135.4 416H69V202.2h66.5V416zm-33.2-243c-21.3 0-38.5-17.3-38.5-38.5S80.9 96 102.2 96c21.2 0 38.5 17.3 38.5 38.5 0 21.3-17.2 38.5-38.5 38.5zm282.1 243h-66.4V312c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9V416h-66.4V202.2h63.7v29.2h.9c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9V416z"/></svg>',
			'icon-youtube'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z"/></svg>',
			'icon-xing'             => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M162.7 210c-1.8 3.3-25.2 44.4-70.1 123.5-4.9 8.3-10.8 12.5-17.7 12.5H9.8c-7.7 0-12.1-7.5-8.5-14.4l69-121.3c.2 0 .2-.1 0-.3l-43.9-75.6c-4.3-7.8.3-14.1 8.5-14.1H100c7.3 0 13.3 4.1 18 12.2l44.7 77.5zM382.6 46.1l-144 253v.3L330.2 466c3.9 7.1.2 14.1-8.5 14.1h-65.2c-7.6 0-13.6-4-18-12.2l-92.4-168.5c3.3-5.8 51.5-90.8 144.8-255.2 4.6-8.1 10.4-12.2 17.5-12.2h65.7c8 0 12.3 6.7 8.5 14.1z"/></svg>',
			'icon-instagram'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"/></svg>',
			'icon-flickr'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM144.5 319c-35.1 0-63.5-28.4-63.5-63.5s28.4-63.5 63.5-63.5 63.5 28.4 63.5 63.5-28.4 63.5-63.5 63.5zm159 0c-35.1 0-63.5-28.4-63.5-63.5s28.4-63.5 63.5-63.5 63.5 28.4 63.5 63.5-28.4 63.5-63.5 63.5z"/></svg>',
			'icon-dribbble'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 8C119.252 8 8 119.252 8 256s111.252 248 248 248 248-111.252 248-248S392.748 8 256 8zm163.97 114.366c29.503 36.046 47.369 81.957 47.835 131.955-6.984-1.477-77.018-15.682-147.502-6.818-5.752-14.041-11.181-26.393-18.617-41.614 78.321-31.977 113.818-77.482 118.284-83.523zM396.421 97.87c-3.81 5.427-35.697 48.286-111.021 76.519-34.712-63.776-73.185-116.168-79.04-124.008 67.176-16.193 137.966 1.27 190.061 47.489zm-230.48-33.25c5.585 7.659 43.438 60.116 78.537 122.509-99.087 26.313-186.36 25.934-195.834 25.809C62.38 147.205 106.678 92.573 165.941 64.62zM44.17 256.323c0-2.166.043-4.322.108-6.473 9.268.19 111.92 1.513 217.706-30.146 6.064 11.868 11.857 23.915 17.174 35.949-76.599 21.575-146.194 83.527-180.531 142.306C64.794 360.405 44.17 310.73 44.17 256.323zm81.807 167.113c22.127-45.233 82.178-103.622 167.579-132.756 29.74 77.283 42.039 142.053 45.189 160.638-68.112 29.013-150.015 21.053-212.768-27.882zm248.38 8.489c-2.171-12.886-13.446-74.897-41.152-151.033 66.38-10.626 124.7 6.768 131.947 9.055-9.442 58.941-43.273 109.844-90.795 141.978z"/></svg>',
			'icon-vk'               => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M545 117.7c3.7-12.5 0-21.7-17.8-21.7h-58.9c-15 0-21.9 7.9-25.6 16.7 0 0-30 73.1-72.4 120.5-13.7 13.7-20 18.1-27.5 18.1-3.7 0-9.4-4.4-9.4-16.9V117.7c0-15-4.2-21.7-16.6-21.7h-92.6c-9.4 0-15 7-15 13.5 0 14.2 21.2 17.5 23.4 57.5v86.8c0 19-3.4 22.5-10.9 22.5-20 0-68.6-73.4-97.4-157.4-5.8-16.3-11.5-22.9-26.6-22.9H38.8c-16.8 0-20.2 7.9-20.2 16.7 0 15.6 20 93.1 93.1 195.5C160.4 378.1 229 416 291.4 416c37.5 0 42.1-8.4 42.1-22.9 0-66.8-3.4-73.1 15.4-73.1 8.7 0 23.7 4.4 58.7 38.1 40 40 46.6 57.9 69 57.9h58.9c16.8 0 25.3-8.4 20.4-25-11.2-34.9-86.9-106.7-90.3-111.5-8.7-11.2-6.2-16.2 0-26.2.1-.1 72-101.3 79.4-135.6z"/></svg>',
			'icon-weibo'            => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M407 177.6c7.6-24-13.4-46.8-37.4-41.7-22 4.8-28.8-28.1-7.1-32.8 50.1-10.9 92.3 37.1 76.5 84.8-6.8 21.2-38.8 10.8-32-10.3zM214.8 446.7C108.5 446.7 0 395.3 0 310.4c0-44.3 28-95.4 76.3-143.7C176 67 279.5 65.8 249.9 161c-4 13.1 12.3 5.7 12.3 6 79.5-33.6 140.5-16.8 114 51.4-3.7 9.4 1.1 10.9 8.3 13.1 135.7 42.3 34.8 215.2-169.7 215.2zm143.7-146.3c-5.4-55.7-78.5-94-163.4-85.7-84.8 8.6-148.8 60.3-143.4 116s78.5 94 163.4 85.7c84.8-8.6 148.8-60.3 143.4-116zM347.9 35.1c-25.9 5.6-16.8 43.7 8.3 38.3 72.3-15.2 134.8 52.8 111.7 124-7.4 24.2 29.1 37 37.4 12 31.9-99.8-55.1-195.9-157.4-174.3zm-78.5 311c-17.1 38.8-66.8 60-109.1 46.3-40.8-13.1-58-53.4-40.3-89.7 17.7-35.4 63.1-55.4 103.4-45.1 42 10.8 63.1 50.2 46 88.5zm-86.3-30c-12.9-5.4-30 .3-38 12.9-8.3 12.9-4.3 28 8.6 34 13.1 6 30.8.3 39.1-12.9 8-13.1 3.7-28.3-9.7-34zm32.6-13.4c-5.1-1.7-11.4.6-14.3 5.4-2.9 5.1-1.4 10.6 3.7 12.9 5.1 2 11.7-.3 14.6-5.4 2.8-5.2 1.1-10.9-4-12.9z"/></svg>',
			'icon-vimeo'            => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M403.2 32H44.8C20.1 32 0 52.1 0 76.8v358.4C0 459.9 20.1 480 44.8 480h358.4c24.7 0 44.8-20.1 44.8-44.8V76.8c0-24.7-20.1-44.8-44.8-44.8zM377 180.8c-1.4 31.5-23.4 74.7-66 129.4-44 57.2-81.3 85.8-111.7 85.8-18.9 0-34.8-17.4-47.9-52.3-25.5-93.3-36.4-148-57.4-148-2.4 0-10.9 5.1-25.4 15.2l-15.2-19.6c37.3-32.8 72.9-69.2 95.2-71.2 25.2-2.4 40.7 14.8 46.5 51.7 20.7 131.2 29.9 151 67.6 91.6 13.5-21.4 20.8-37.7 21.8-48.9 3.5-33.2-25.9-30.9-45.8-22.4 15.9-52.1 46.3-77.4 91.2-76 33.3.9 49 22.5 47.1 64.7z"/></svg',
			'icon-mix'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 64v348.9c0 56.2 88 58.1 88 0V174.3c7.9-52.9 88-50.4 88 6.5v175.3c0 57.9 96 58 96 0V240c5.3-54.7 88-52.5 88 4.3v23.8c0 59.9 88 56.6 88 0V64H0z"/></svg>',
			'icon-behance'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M232 237.2c31.8-15.2 48.4-38.2 48.4-74 0-70.6-52.6-87.8-113.3-87.8H0v354.4h171.8c64.4 0 124.9-30.9 124.9-102.9 0-44.5-21.1-77.4-64.7-89.7zM77.9 135.9H151c28.1 0 53.4 7.9 53.4 40.5 0 30.1-19.7 42.2-47.5 42.2h-79v-82.7zm83.3 233.7H77.9V272h84.9c34.3 0 56 14.3 56 50.6 0 35.8-25.9 47-57.6 47zm358.5-240.7H376V94h143.7v34.9zM576 305.2c0-75.9-44.4-139.2-124.9-139.2-78.2 0-131.3 58.8-131.3 135.8 0 79.9 50.3 134.7 131.3 134.7 61.3 0 101-27.6 120.1-86.3H509c-6.7 21.9-34.3 33.5-55.7 33.5-41.3 0-63-24.2-63-65.3h185.1c.3-4.2.6-8.7.6-13.2zM390.4 274c2.3-33.7 24.7-54.8 58.5-54.8 35.4 0 53.2 20.8 56.2 54.8H390.4z"/></svg>',
			'icon-spotify'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M248 8C111.1 8 0 119.1 0 256s111.1 248 248 248 248-111.1 248-248S384.9 8 248 8zm100.7 364.9c-4.2 0-6.8-1.3-10.7-3.6-62.4-37.6-135-39.2-206.7-24.5-3.9 1-9 2.6-11.9 2.6-9.7 0-15.8-7.7-15.8-15.8 0-10.3 6.1-15.2 13.6-16.8 81.9-18.1 165.6-16.5 237 26.2 6.1 3.9 9.7 7.4 9.7 16.5s-7.1 15.4-15.2 15.4zm26.9-65.6c-5.2 0-8.7-2.3-12.3-4.2-62.5-37-155.7-51.9-238.6-29.4-4.8 1.3-7.4 2.6-11.9 2.6-10.7 0-19.4-8.7-19.4-19.4s5.2-17.8 15.5-20.7c27.8-7.8 56.2-13.6 97.8-13.6 64.9 0 127.6 16.1 177 45.5 8.1 4.8 11.3 11 11.3 19.7-.1 10.8-8.5 19.5-19.4 19.5zm31-76.2c-5.2 0-8.4-1.3-12.9-3.9-71.2-42.5-198.5-52.7-280.9-29.7-3.6 1-8.1 2.6-12.9 2.6-13.2 0-23.3-10.3-23.3-23.6 0-13.6 8.4-21.3 17.4-23.9 35.2-10.3 74.6-15.2 117.5-15.2 73 0 149.5 15.2 205.4 47.8 7.8 4.5 12.9 10.7 12.9 22.6 0 13.6-11 23.3-23.2 23.3z"/></svg>',
			'icon-soundcloud'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M111.4 256.3l5.8 65-5.8 68.3c-.3 2.5-2.2 4.4-4.4 4.4s-4.2-1.9-4.2-4.4l-5.6-68.3 5.6-65c0-2.2 1.9-4.2 4.2-4.2 2.2 0 4.1 2 4.4 4.2zm21.4-45.6c-2.8 0-4.7 2.2-5 5l-5 105.6 5 68.3c.3 2.8 2.2 5 5 5 2.5 0 4.7-2.2 4.7-5l5.8-68.3-5.8-105.6c0-2.8-2.2-5-4.7-5zm25.5-24.1c-3.1 0-5.3 2.2-5.6 5.3l-4.4 130 4.4 67.8c.3 3.1 2.5 5.3 5.6 5.3 2.8 0 5.3-2.2 5.3-5.3l5.3-67.8-5.3-130c0-3.1-2.5-5.3-5.3-5.3zM7.2 283.2c-1.4 0-2.2 1.1-2.5 2.5L0 321.3l4.7 35c.3 1.4 1.1 2.5 2.5 2.5s2.2-1.1 2.5-2.5l5.6-35-5.6-35.6c-.3-1.4-1.1-2.5-2.5-2.5zm23.6-21.9c-1.4 0-2.5 1.1-2.5 2.5l-6.4 57.5 6.4 56.1c0 1.7 1.1 2.8 2.5 2.8s2.5-1.1 2.8-2.5l7.2-56.4-7.2-57.5c-.3-1.4-1.4-2.5-2.8-2.5zm25.3-11.4c-1.7 0-3.1 1.4-3.3 3.3L47 321.3l5.8 65.8c.3 1.7 1.7 3.1 3.3 3.1 1.7 0 3.1-1.4 3.1-3.1l6.9-65.8-6.9-68.1c0-1.9-1.4-3.3-3.1-3.3zm25.3-2.2c-1.9 0-3.6 1.4-3.6 3.6l-5.8 70 5.8 67.8c0 2.2 1.7 3.6 3.6 3.6s3.6-1.4 3.9-3.6l6.4-67.8-6.4-70c-.3-2.2-2-3.6-3.9-3.6zm241.4-110.9c-1.1-.8-2.8-1.4-4.2-1.4-2.2 0-4.2.8-5.6 1.9-1.9 1.7-3.1 4.2-3.3 6.7v.8l-3.3 176.7 1.7 32.5 1.7 31.7c.3 4.7 4.2 8.6 8.9 8.6s8.6-3.9 8.6-8.6l3.9-64.2-3.9-177.5c-.4-3-2-5.8-4.5-7.2zm-26.7 15.3c-1.4-.8-2.8-1.4-4.4-1.4s-3.1.6-4.4 1.4c-2.2 1.4-3.6 3.9-3.6 6.7l-.3 1.7-2.8 160.8s0 .3 3.1 65.6v.3c0 1.7.6 3.3 1.7 4.7 1.7 1.9 3.9 3.1 6.4 3.1 2.2 0 4.2-1.1 5.6-2.5 1.7-1.4 2.5-3.3 2.5-5.6l.3-6.7 3.1-58.6-3.3-162.8c-.3-2.8-1.7-5.3-3.9-6.7zm-111.4 22.5c-3.1 0-5.8 2.8-5.8 6.1l-4.4 140.6 4.4 67.2c.3 3.3 2.8 5.8 5.8 5.8 3.3 0 5.8-2.5 6.1-5.8l5-67.2-5-140.6c-.2-3.3-2.7-6.1-6.1-6.1zm376.7 62.8c-10.8 0-21.1 2.2-30.6 6.1-6.4-70.8-65.8-126.4-138.3-126.4-17.8 0-35 3.3-50.3 9.4-6.1 2.2-7.8 4.4-7.8 9.2v249.7c0 5 3.9 8.6 8.6 9.2h218.3c43.3 0 78.6-35 78.6-78.3.1-43.6-35.2-78.9-78.5-78.9zm-296.7-60.3c-4.2 0-7.5 3.3-7.8 7.8l-3.3 136.7 3.3 65.6c.3 4.2 3.6 7.5 7.8 7.5 4.2 0 7.5-3.3 7.5-7.5l3.9-65.6-3.9-136.7c-.3-4.5-3.3-7.8-7.5-7.8zm-53.6-7.8c-3.3 0-6.4 3.1-6.4 6.7l-3.9 145.3 3.9 66.9c.3 3.6 3.1 6.4 6.4 6.4 3.6 0 6.4-2.8 6.7-6.4l4.4-66.9-4.4-145.3c-.3-3.6-3.1-6.7-6.7-6.7zm26.7 3.4c-3.9 0-6.9 3.1-6.9 6.9L227 321.3l3.9 66.4c.3 3.9 3.1 6.9 6.9 6.9s6.9-3.1 6.9-6.9l4.2-66.4-4.2-141.7c0-3.9-3-6.9-6.9-6.9z"/></svg>',
			'icon-twitch'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M391.17,103.47H352.54v109.7h38.63ZM285,103H246.37V212.75H285ZM120.83,0,24.31,91.42V420.58H140.14V512l96.53-91.42h77.25L487.69,256V0ZM449.07,237.75l-77.22,73.12H294.61l-67.6,64v-64H140.14V36.58H449.07Z"/></svg>',
			'icon-bandcamp'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256,8C119,8,8,119,8,256S119,504,256,504,504,393,504,256,393,8,256,8Zm48.2,326.1h-181L207.9,178h181Z"/></svg>',
			'icon-etsy'             => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M384 348c-1.75 10.75-13.75 110-15.5 132-117.879-4.299-219.895-4.743-368.5 0v-25.5c45.457-8.948 60.627-8.019 61-35.25 1.793-72.322 3.524-244.143 0-322-1.029-28.46-12.13-26.765-61-36v-25.5c73.886 2.358 255.933 8.551 362.999-3.75-3.5 38.25-7.75 126.5-7.75 126.5H332C320.947 115.665 313.241 68 277.25 68h-137c-10.25 0-10.75 3.5-10.75 9.75V241.5c58 .5 88.5-2.5 88.5-2.5 29.77-.951 27.56-8.502 40.75-65.251h25.75c-4.407 101.351-3.91 61.829-1.75 160.25H257c-9.155-40.086-9.065-61.045-39.501-61.5 0 0-21.5-2-88-2v139c0 26 14.25 38.25 44.25 38.25H263c63.636 0 66.564-24.996 98.751-99.75H384z"/></svg>',
			'icon-pinterest'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M496 256c0 137-111 248-248 248-25.6 0-50.2-3.9-73.4-11.1 10.1-16.5 25.2-43.5 30.8-65 3-11.6 15.4-59 15.4-59 8.1 15.4 31.7 28.5 56.8 28.5 74.8 0 128.7-68.8 128.7-154.3 0-81.9-66.9-143.2-152.9-143.2-107 0-163.9 71.8-163.9 150.1 0 36.4 19.4 81.7 50.3 96.1 4.7 2.2 7.2 1.2 8.3-3.3.8-3.4 5-20.3 6.9-28.1.6-2.5.3-4.7-1.7-7.1-10.1-12.5-18.3-35.3-18.3-56.6 0-54.7 41.4-107.6 112-107.6 60.9 0 103.6 41.5 103.6 100.9 0 67.1-33.9 113.6-78 113.6-24.3 0-42.6-20.1-36.7-44.8 7-29.5 20.5-61.3 20.5-82.6 0-19-10.2-34.9-31.4-34.9-24.9 0-44.9 25.7-44.9 60.2 0 22 7.4 36.8 7.4 36.8s-24.5 103.8-29 123.2c-5 21.4-3 51.6-.9 71.2C65.4 450.9 0 361.1 0 256 0 119 111 8 248 8s248 111 248 248z"/></svg>',        
			'icon-amazon'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M257.2 162.7c-48.7 1.8-169.5 15.5-169.5 117.5 0 109.5 138.3 114 183.5 43.2 6.5 10.2 35.4 37.5 45.3 46.8l56.8-56S341 288.9 341 261.4V114.3C341 89 316.5 32 228.7 32 140.7 32 94 87 94 136.3l73.5 6.8c16.3-49.5 54.2-49.5 54.2-49.5 40.7-.1 35.5 29.8 35.5 69.1zm0 86.8c0 80-84.2 68-84.2 17.2 0-47.2 50.5-56.7 84.2-57.8v40.6zm136 163.5c-7.7 10-70 67-174.5 67S34.2 408.5 9.7 379c-6.8-7.7 1-11.3 5.5-8.3C88.5 415.2 203 488.5 387.7 401c7.5-3.7 13.3 2 5.5 12zm39.8 2.2c-6.5 15.8-16 26.8-21.2 31-5.5 4.5-9.5 2.7-6.5-3.8s19.3-46.5 12.7-55c-6.5-8.3-37-4.3-48-3.2-10.8 1-13 2-14-.3-2.3-5.7 21.7-15.5 37.5-17.5 15.7-1.8 41-.8 46 5.7 3.7 5.1 0 27.1-6.5 43.1z"/></svg>',
			'icon-tiktok'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M448,209.91a210.06,210.06,0,0,1-122.77-39.25V349.38A162.55,162.55,0,1,1,185,188.31V278.2a74.62,74.62,0,1,0,52.23,71.18V0l88,0a121.18,121.18,0,0,0,1.86,22.17h0A122.18,122.18,0,0,0,381,102.39a121.43,121.43,0,0,0,67,20.14Z"/></svg>',
			'icon-whatsapp'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg>',
			'icon-wa.me'            => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg>',
			'icon-telegram'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M248,8C111.033,8,0,119.033,0,256S111.033,504,248,504,496,392.967,496,256,384.967,8,248,8ZM362.952,176.66c-3.732,39.215-19.881,134.378-28.1,178.3-3.476,18.584-10.322,24.816-16.948,25.425-14.4,1.326-25.338-9.517-39.287-18.661-21.827-14.308-34.158-23.215-55.346-37.177-24.485-16.135-8.612-25,5.342-39.5,3.652-3.793,67.107-61.51,68.335-66.746.153-.655.3-3.1-1.154-4.384s-3.59-.849-5.135-.5q-3.283.746-104.608,69.142-14.845,10.194-26.894,9.934c-8.855-.191-25.888-5.006-38.551-9.123-15.531-5.048-27.875-7.717-26.8-16.291q.84-6.7,18.45-13.7,108.446-47.248,144.628-62.3c68.872-28.647,83.183-33.623,92.511-33.789,2.052-.034,6.639.474,9.61,2.885a10.452,10.452,0,0,1,3.53,6.716A43.765,43.765,0,0,1,362.952,176.66Z"/></svg>',
			'icon-t.me'             => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M248,8C111.033,8,0,119.033,0,256S111.033,504,248,504,496,392.967,496,256,384.967,8,248,8ZM362.952,176.66c-3.732,39.215-19.881,134.378-28.1,178.3-3.476,18.584-10.322,24.816-16.948,25.425-14.4,1.326-25.338-9.517-39.287-18.661-21.827-14.308-34.158-23.215-55.346-37.177-24.485-16.135-8.612-25,5.342-39.5,3.652-3.793,67.107-61.51,68.335-66.746.153-.655.3-3.1-1.154-4.384s-3.59-.849-5.135-.5q-3.283.746-104.608,69.142-14.845,10.194-26.894,9.934c-8.855-.191-25.888-5.006-38.551-9.123-15.531-5.048-27.875-7.717-26.8-16.291q.84-6.7,18.45-13.7,108.446-47.248,144.628-62.3c68.872-28.647,83.183-33.623,92.511-33.789,2.052-.034,6.639.474,9.61,2.885a10.452,10.452,0,0,1,3.53,6.716A43.765,43.765,0,0,1,362.952,176.66Z"/></svg>',
			'icon-reddit'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M201.5 305.5c-13.8 0-24.9-11.1-24.9-24.6 0-13.8 11.1-24.9 24.9-24.9 13.6 0 24.6 11.1 24.6 24.9 0 13.6-11.1 24.6-24.6 24.6zM504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zm-132.3-41.2c-9.4 0-17.7 3.9-23.8 10-22.4-15.5-52.6-25.5-86.1-26.6l17.4-78.3 55.4 12.5c0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.3 24.9-24.9s-11.1-24.9-24.9-24.9c-9.7 0-18 5.8-22.1 13.8l-61.2-13.6c-3-.8-6.1 1.4-6.9 4.4l-19.1 86.4c-33.2 1.4-63.1 11.3-85.5 26.8-6.1-6.4-14.7-10.2-24.1-10.2-34.9 0-46.3 46.9-14.4 62.8-1.1 5-1.7 10.2-1.7 15.5 0 52.6 59.2 95.2 132 95.2 73.1 0 132.3-42.6 132.3-95.2 0-5.3-.6-10.8-1.9-15.8 31.3-16 19.8-62.5-14.9-62.5zM302.8 331c-18.2 18.2-76.1 17.9-93.6 0-2.2-2.2-6.1-2.2-8.3 0-2.5 2.5-2.5 6.4 0 8.6 22.8 22.8 87.3 22.8 110.2 0 2.5-2.2 2.5-6.1 0-8.6-2.2-2.2-6.1-2.2-8.3 0zm7.7-75c-13.6 0-24.6 11.1-24.6 24.9 0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.1 24.9-24.6 0-13.8-11-24.9-24.9-24.9z"/></svg>',
			'icon-ok'               => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1024 1024"><path d="M1024 512c0 512 0 512-512 512S0 1024 0 512 0 0 512 0s512 0 512 512z"/><path d="M592.2 686.1c40.4-9.2 79.3-25.2 115.101-47.7 27.1-17.1 35.3-52.899 18.199-80.1-17.1-27.2-52.899-35.4-80.1-18.3-81.2 51.1-185.7 51-266.9 0-27.199-17.1-63-8.9-80.1 18.3-17.1 27.1-8.9 63 18.2 80.1 35.8 22.5 74.7 38.5 115.1 47.7L321 796.9c-22.699 22.699-22.699 59.399 0 82.1 11.4 11.3 26.2 17 41 17 14.9 0 29.7-5.7 41.101-17L512 770.1 620.9 879c22.7 22.7 59.4 22.7 82.1 0 22.7-22.7 22.7-59.5 0-82.1L592.2 686.1M512 244.2c45.301 0 82.101 36.8 82.101 82.1 0 45.2-36.8 82-82.101 82-45.199 0-82.1-36.8-82.1-82 0-45.3 36.901-82.1 82.1-82.1zm0 280.2c109.301 0 198.2-88.9 198.2-198.101C710.2 216.9 621.301 128 512 128c-109.3 0-198.199 88.9-198.199 198.2 0 109.3 88.899 198.2 198.199 198.2z" fill="#fff"/></svg>',       
			'icon-mail'             => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M502.3 190.8c3.9-3.1 9.7-.2 9.7 4.7V400c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V195.6c0-5 5.7-7.8 9.7-4.7 22.4 17.4 52.1 39.5 154.1 113.6 21.1 15.4 56.7 47.8 92.2 47.6 35.7.3 72-32.8 92.3-47.6 102-74.1 131.6-96.3 154-113.7zM256 320c23.2.4 56.6-29.2 73.4-41.4 132.7-96.3 142.8-104.7 173.4-128.7 5.8-4.5 9.2-11.5 9.2-18.9v-19c0-26.5-21.5-48-48-48H48C21.5 64 0 85.5 0 112v19c0 7.4 3.4 14.3 9.2 18.9 30.6 23.9 40.7 32.4 173.4 128.7 16.8 12.2 50.2 41.8 73.4 41.4z"/></svg>',      
			'icon-mobile1'          =>  '<svg width="16" height="7" viewBox="0 0 16 7" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="16" height="1"/><rect y="6" width="16" height="1"/></svg>',
			'icon-mobile2'          =>  '<svg width="16" height="11" viewBox="0 0 16 11" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="16" height="1"/><rect y="5" width="16" height="1"/><rect y="10" width="16" height="1"/></svg>',
			'icon-mobile3'          =>  '<svg width="16" height="11" viewBox="0 0 16 11" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="16" height="1"/><rect y="5" width="10" height="1"/><rect y="10" width="16" height="1"/></svg>',
			'icon-mobile4'          =>  '<svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg"><rect y="7" width="14" height="1"/><rect x="7.5" y="0.5" width="14" height="1" transform="rotate(90 7.5 0.5)"/></svg>',     
			'icon-down'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512.011 512.011"><path d="M505.755 123.592c-8.341-8.341-21.824-8.341-30.165 0L256.005 343.176 36.421 123.592c-8.341-8.341-21.824-8.341-30.165 0s-8.341 21.824 0 30.165l234.667 234.667a21.275 21.275 0 0015.083 6.251 21.275 21.275 0 0015.083-6.251l234.667-234.667c8.34-8.341 8.34-21.824-.001-30.165z"/></svg>',
			'icon-caret-down'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="m310.6 246.6-127.1 128c-7.1 6.3-15.3 9.4-23.5 9.4s-16.38-3.125-22.63-9.375l-127.1-128C.224 237.5-2.516 223.7 2.438 211.8S19.07 192 32 192h255.1c12.94 0 24.62 7.781 29.58 19.75s3.12 25.75-6.08 34.85z"/></svg>',
			'icon-plus'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M432 256c0 17.69-14.33 32.01-32 32.01H256v144c0 17.69-14.33 31.99-32 31.99s-32-14.3-32-31.99v-144H48c-17.67 0-32-14.32-32-32.01s14.33-31.99 32-31.99H192v-144c0-17.69 14.33-32.01 32-32.01s32 14.32 32 32.01v144h144C417.7 224 432 238.3 432 256z"/></svg>',     
			'icon-curly-arrow1'       => '<svg width="44" height="46" viewBox="0 0 44 46" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M22.3721 42.3504C22.1755 42.3784 21.9983 42.4411 21.8506 42.5349C21.7029 42.6288 21.5877 42.7519 21.5115 42.8973C21.4352 43.0427 21.3995 43.2075 21.4063 43.3823C21.4131 43.5572 21.4623 43.7386 21.5511 43.9162C21.6399 44.0938 21.7666 44.2642 21.9239 44.4176C22.0812 44.571 22.266 44.7044 22.4678 44.8103C22.6697 44.9161 22.8845 44.9922 23.1002 45.0343C23.3158 45.0764 23.528 45.0837 23.7246 45.0557L42.3548 42.4029C42.5514 42.375 42.7286 42.3123 42.8763 42.2184C43.024 42.1246 43.1392 42.0015 43.2155 41.8561C43.2917 41.7107 43.3274 41.5458 43.3206 41.371C43.3138 41.1961 43.2645 41.0147 43.1757 40.8371L34.7608 24.0053C34.672 23.8276 34.5453 23.6573 34.388 23.5039C34.2307 23.3505 34.0459 23.217 33.8441 23.1112C33.6423 23.0054 33.4274 22.9293 33.2118 22.8872C32.9961 22.8451 32.7839 22.8378 32.5873 22.8658C32.3907 22.8938 32.2135 22.9565 32.0659 23.0503C31.9182 23.1442 31.803 23.2673 31.7267 23.4127C31.6505 23.5581 31.6148 23.7229 31.6216 23.8978C31.6284 24.0726 31.6776 24.254 31.7664 24.4316L38.5488 37.9981L17.6725 27.0531C6.63927 21.2687 1.07394 10.1368 5.24131 2.18795C5.39524 1.89433 5.38098 1.52787 5.20165 1.16916C5.02232 0.810462 4.69261 0.488909 4.28507 0.275243C3.87752 0.0615769 3.42551 -0.0267011 3.02849 0.0298315C2.63146 0.086364 2.32193 0.283075 2.168 0.57669C-2.64014 9.74772 3.78198 22.5935 16.5116 29.2673L37.388 40.2122L22.3721 42.3504Z" fill="black"/></svg>',
			'icon-curly-arrow2'     => '<svg width="45" height="41" viewBox="0 0 45 41" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M21.5583 18.7688L21.5466 18.775C21.3584 18.4201 21.1507 18.0742 20.9854 17.7089C19.9058 15.3245 19.4879 12.8701 20.3263 10.3225C20.9551 8.41207 22.0364 6.86441 23.9476 6.00229C24.4789 5.76317 24.8632 5.85709 25.2732 6.217C26.3409 7.15222 26.7779 8.37642 26.9084 9.73642C27.0746 11.479 26.6959 13.1441 26.1071 14.7657C25.3898 16.7411 24.3347 18.5152 22.9034 20.0656C22.5663 20.4314 22.3912 20.3609 22.1945 19.9727C21.99 19.5682 21.771 19.1697 21.5583 18.7688ZM38.3986 38.9157C34.3139 39.0346 30.3554 38.2321 26.4391 39.1758C26.7141 39.5423 27.1039 39.4995 27.3972 39.4254C28.0242 39.2663 28.6455 39.2967 29.2658 39.3415C32.5469 39.5791 35.8357 39.6448 39.1204 39.8127C39.7078 39.8422 40.2432 39.9814 40.7607 40.2801C41.5433 40.732 42.3964 40.9949 43.3139 40.9315C43.9028 40.8897 43.9702 40.7761 43.7843 40.221C43.701 39.9725 43.8955 40.0107 44.0037 39.9698C44.7429 39.6884 44.7639 39.6728 44.356 38.9829C43.1854 37.0017 42.4644 34.813 41.4589 32.7571C40.5372 30.8708 39.7558 28.921 38.8093 27.0474C38.4692 26.375 38.0551 25.7475 37.5706 25.1687C37.3994 24.9648 37.2276 24.7696 36.9125 24.8419C36.5565 24.9228 36.5266 25.2149 36.4879 25.4889C36.3945 26.1408 36.4846 26.7879 36.6686 27.4082C37.6008 30.5534 38.1383 33.8236 39.626 36.7935C39.6394 36.8199 39.628 36.8579 39.6283 36.9378C39.3086 36.849 39.0926 36.6204 38.85 36.4485C34.5855 33.4341 30.5292 30.1766 27.0226 26.2806C25.9464 25.0845 24.9 23.8645 23.9631 22.5539C23.8196 22.3523 23.7513 22.233 24.0108 22.0588C26.9637 20.0776 28.6067 17.1926 29.6009 13.8744C30.0055 12.5236 30.2134 11.143 30.0609 9.72891C29.8075 7.38341 28.4084 5.8069 26.1173 5.2598C25.0893 5.01439 24.0467 4.87983 22.9944 4.96342C20.2868 5.17886 18.5981 6.78237 17.547 9.13752C16.3198 11.8871 16.5324 14.6551 17.6242 17.3989C18.2289 18.9178 19.0244 20.3358 19.9482 21.6793C20.181 22.0175 20.1055 22.1495 19.7729 22.2866C18.3791 22.8637 16.9553 23.0816 15.4652 22.7172C12.0645 21.8848 9.38275 19.9565 7.1996 17.2821C4.89068 14.4531 3.81235 11.1223 3.31825 7.56636C3.08868 5.91546 3.00845 4.25812 3.31421 2.60377C3.4263 1.99824 3.59483 1.41295 3.89973 0.872428C4.00363 0.688821 4.10401 0.546943 4.33798 0.720586C4.44185 0.798192 4.6052 0.916458 4.69158 0.737127C4.77123 0.571398 4.61512 0.419467 4.48542 0.354158C3.71361 -0.0357581 2.93762 -0.218015 2.23682 0.545274C1.58552 1.25472 1.30476 2.13145 1.1481 3.06084C0.901635 4.52318 0.968326 5.98783 1.11481 7.45365C1.47375 11.0427 2.51601 14.3944 4.79499 17.2385C8.90869 22.3717 14.3067 24.2963 20.7602 23.3951C21.2167 23.3323 21.3063 23.628 21.4761 23.8499C23.0307 25.88 24.6889 27.8158 26.5203 29.6035C29.6861 32.691 33.2115 35.3288 36.8433 37.8332C37.3278 38.167 37.8098 38.5051 38.3986 38.9157Z" fill="black"/></svg>',
			'icon-curly-arrow3'     => '<svg width="45" height="48" viewBox="0 0 45 48" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.89273 18.532C9.81784 18.5956 9.73961 18.6566 9.66753 18.7239C9.36251 19.0086 9.37205 19.0695 9.76486 19.2129C10.7777 19.5839 11.8095 19.8919 12.8907 19.971C13.6153 20.0241 14.3453 20.0146 15.0092 19.6517C15.4909 19.3887 15.5284 18.9825 15.1184 18.6175C14.87 18.3965 14.5827 18.2346 14.2666 18.1305C13.152 17.7621 12.0264 17.7282 10.8955 18.0473C10.535 18.1493 10.1922 18.2979 9.89273 18.532ZM38.3273 44.7728C38.1492 44.6716 37.9716 44.5687 37.7924 44.4693C34.0255 42.3778 30.2944 40.225 26.5872 38.0299C23.9767 36.4839 21.3766 34.9217 18.8608 33.2256C16.0404 31.324 13.3177 29.296 10.9512 26.8356C9.88861 25.7309 8.94253 24.5349 8.33351 23.1038C7.89322 22.0695 7.69108 21.0046 7.84588 19.8856C7.87535 19.6725 7.81028 19.5726 7.62591 19.4761C5.59667 18.4114 3.81507 17.0274 2.37717 15.2392C0.96935 13.4897 0.0988026 11.5178 0.118073 9.22085C0.134753 7.26036 0.958398 5.68944 2.39846 4.39818C3.43575 3.4674 4.59463 2.71622 5.78279 2.00235C6.68647 1.45952 7.58823 0.912832 8.49301 0.370711C8.58605 0.314517 8.68718 0.265372 8.79158 0.236144C8.95167 0.192161 9.1039 0.223364 9.19614 0.375758C9.28094 0.515878 9.24035 0.658046 9.14236 0.773237C8.98527 0.957627 8.80316 1.11631 8.60583 1.25886C7.43911 2.10434 6.18737 2.82085 4.99962 3.63425C4.2378 4.15594 3.50773 4.71442 2.84303 5.36403C1.29756 6.87526 0.905278 8.70451 1.31631 10.7548C1.70622 12.7016 2.77523 14.2645 4.16416 15.6353C5.29102 16.7477 6.5717 17.6491 7.95365 18.4151C8.18628 18.5439 8.32284 18.5383 8.49328 18.3028C9.02435 17.5661 9.7819 17.1514 10.644 16.9277C12.0101 16.5735 13.3726 16.6072 14.7005 17.0888C15.412 17.3467 16.0562 17.7294 16.3843 18.4749C16.6789 19.1444 16.5161 19.8441 15.9641 20.3259C15.3977 20.8197 14.7136 20.9905 13.992 21.0666C12.8215 21.1892 11.6927 20.9603 10.5775 20.6452C10.1552 20.5255 9.74173 20.3732 9.32765 20.2266C9.00144 20.1111 8.9865 20.1144 8.97592 20.4773C8.94337 21.5475 9.3028 22.5097 9.8244 23.4167C10.6389 24.834 11.7578 26.0002 12.9472 27.1001C14.4909 28.5269 16.1463 29.8165 17.861 31.0312C21.2901 33.4615 24.9039 35.5982 28.522 37.7278C31.9787 39.7626 35.4445 41.7826 38.8598 43.887C39.5059 44.2852 40.11 44.7437 40.7054 45.2137C40.8114 45.2977 40.9041 45.4149 41.1311 45.4281C40.6353 45.0214 40.1906 44.6513 39.74 44.289C37.9134 42.8197 36.2544 41.1645 34.5301 39.5824C33.4618 38.6008 32.4009 37.611 31.4115 36.5484C31.1949 36.3159 30.9884 36.071 30.8031 35.8133C30.6488 35.5974 30.562 35.3396 30.8091 35.1313C31.0416 34.935 31.2624 35.0641 31.4591 35.2273C32.5092 36.0974 33.475 37.0604 34.4899 37.9697C36.8305 40.0669 39.0638 42.2838 41.5484 44.2181C42.2854 44.7919 43.0152 45.3755 43.7476 45.9555C43.8953 46.0724 44.0267 46.2059 44.0898 46.3897C44.2578 46.8776 43.8483 47.3101 43.2736 47.2078C42.56 47.0815 41.8506 46.9248 41.1454 46.7559C38.3651 46.0912 35.5516 45.5877 32.7498 45.0297C31.5103 44.7828 30.2776 44.5061 29.0529 44.1919C28.6482 44.0878 28.2486 43.9595 27.9029 43.712C27.7679 43.6161 27.63 43.5011 27.6805 43.3078C27.7319 43.111 27.9088 43.0893 28.0762 43.0753C28.7784 43.016 29.4508 43.2105 30.1306 43.3308C32.7817 43.7998 35.434 44.2659 38.0691 44.8195C38.1425 44.8347 38.2187 44.8381 38.2936 44.8473L38.3273 44.7728Z" fill="black"/></svg>',
			'icon-curly-arrow4'     => '<svg width="40" height="59" viewBox="0 0 40 59" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M33.6377 56.7321C32.8768 56.796 32.1145 56.8479 31.3549 56.9259C29.8936 57.0764 28.4334 57.2406 26.9727 57.4013C26.4178 57.4627 25.8956 57.63 25.4125 57.9116C25.3294 57.96 25.2012 57.9918 25.222 58.1165C25.2407 58.2242 25.3614 58.1642 25.4325 58.1922C26.3966 58.5718 27.3899 58.3856 28.3721 58.325C31.1624 58.1524 33.9409 57.8028 36.7381 57.7268C37.1867 57.7146 37.6359 57.7404 38.0845 57.7494C38.1967 57.7518 38.3091 57.7666 38.4204 57.7594C38.6962 57.7419 38.9185 57.6315 39.0066 57.3505C39.0897 57.0845 38.9897 56.8647 38.7834 56.6986C38.6103 56.559 38.4402 56.4191 38.2486 56.2963C37.475 55.8005 36.7317 55.256 36.0599 54.6277C34.2344 52.9194 32.2975 51.3328 30.5382 49.5526C30.4742 49.4879 30.3994 49.4312 30.3226 49.3823C30.1733 49.2867 30.0141 49.2683 29.8647 49.379C29.7171 49.488 29.6794 49.6453 29.7193 49.817C29.7769 50.0633 29.9338 50.2546 30.0923 50.4419C30.8649 51.3563 31.728 52.1811 32.6195 52.9766C33.8756 54.0969 35.0589 55.2991 36.3837 56.3424C36.3967 56.3525 36.398 56.3766 36.4165 56.4221C36.1299 56.4176 35.8711 56.3333 35.6146 56.2623C31.8077 55.2112 27.9706 54.2732 24.1733 53.1857C20.7688 52.2111 17.3831 51.1755 14.0058 50.1104C11.6699 49.3737 9.31772 48.6953 6.91526 48.1981C5.2869 47.8609 3.65966 47.5102 2.06556 47.0304C1.41231 46.8339 1.40188 46.8081 1.63205 46.1578C2.20465 44.5419 2.80138 42.9346 3.37418 41.319C4.16531 39.0866 4.84576 36.8187 5.52184 34.5492C6.22986 32.1724 6.89734 29.7841 7.50978 27.3814C8.37354 23.9895 9.25753 20.6007 9.81802 17.141C10.2495 14.4803 10.5419 11.8019 10.7871 9.11841C10.9843 6.96375 11.187 4.81029 11.3794 2.65503C11.4256 2.13769 11.4828 1.61911 11.4527 1.09724C11.4492 1.03627 11.4515 0.974407 11.4402 0.914645C11.41 0.753522 11.3873 0.565473 11.1895 0.535899C10.97 0.503399 10.9226 0.706918 10.8829 0.854013C10.6666 1.65313 10.5259 2.46813 10.4156 3.28743C9.89078 7.18154 9.59225 11.1014 9.04804 14.9935C8.68573 17.5838 8.16235 20.1415 7.542 22.6815C7.07731 24.5851 6.60947 26.4874 6.11029 28.3823C5.4292 30.9679 4.71326 33.544 3.94555 36.1056C3.43614 37.8064 2.9236 39.507 2.33051 41.1812C1.77877 42.739 1.19981 44.2873 0.63955 45.8421C0.542913 46.1105 0.46977 46.3881 0.405621 46.666C0.294427 47.1493 0.428748 47.4627 0.864548 47.7253C1.44907 48.0774 2.10586 48.234 2.75709 48.4091C5.25124 49.0805 7.80729 49.4916 10.2901 50.2055C12.4871 50.8373 14.6622 51.5405 16.842 52.2282C19.5576 53.0849 22.2915 53.8823 25.0435 54.6134C27.6968 55.3185 30.3445 56.0452 33.0441 56.5604C33.2431 56.5984 33.442 56.6374 33.6413 56.6758C33.6399 56.6946 33.6388 56.7134 33.6377 56.7321Z" fill="black"/></svg>',
			'icon-arrow-right1'      => '<svg width="22" height="20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 10c0-.331.129-.65.358-.884.23-.234.54-.366.864-.366h16.604l-6.47-6.614a1.253 1.253 0 0 1-.359-.885 1.276 1.276 0 0 1 .359-.884A1.222 1.222 0 0 1 12.22 0a1.2 1.2 0 0 1 .865.367l8.555 8.748A1.252 1.252 0 0 1 22 10a1.274 1.274 0 0 1-.359.885l-8.555 8.749a1.21 1.21 0 0 1-.865.366 1.21 1.21 0 0 1-.865-.366 1.266 1.266 0 0 1-.359-.885c0-.332.13-.65.359-.885l6.47-6.614H1.222c-.324 0-.635-.132-.864-.366A1.264 1.264 0 0 1 0 10Z"/></svg>',
			'icon-arrow-right2'     => '<svg width="39" height="14" viewBox="0 0 39 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M38.601 7.59494C38.933 7.26299 38.933 6.7248 38.601 6.39286L33.1917 0.983489C32.8597 0.651543 32.3215 0.651543 31.9896 0.983489C31.6576 1.31543 31.6576 1.85362 31.9896 2.18557L36.7979 6.9939L31.9896 11.8022C31.6576 12.1342 31.6576 12.6724 31.9896 13.0043C32.3215 13.3362 32.8597 13.3362 33.1917 13.0043L38.601 7.59494ZM0 7.8439H38V6.1439H0V7.8439Z"/></svg>',
			'icon-play-video'   => '<svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" fill="none"><path d="m22.5 43.5 21-13.5-21-13.5v27ZM30 60c-4.15 0-8.05-.788-11.7-2.364-3.65-1.574-6.825-3.711-9.525-6.411-2.7-2.7-4.837-5.875-6.411-9.525C.788 38.05 0 34.15 0 30c0-4.15.788-8.05 2.364-11.7 1.574-3.65 3.711-6.825 6.411-9.525 2.7-2.7 5.875-4.838 9.525-6.414C21.95.787 25.85 0 30 0c4.15 0 8.05.787 11.7 2.361 3.65 1.576 6.825 3.714 9.525 6.414 2.7 2.7 4.837 5.875 6.411 9.525C59.212 21.95 60 25.85 60 30c0 4.15-.788 8.05-2.364 11.7-1.574 3.65-3.711 6.825-6.411 9.525-2.7 2.7-5.875 4.837-9.525 6.411C38.05 59.212 34.15 60 30 60Z"/></svg>',
		);
	}
}