<?php if (__FILE__ == $_SERVER['SCRIPT_FILENAME']) { exit; }

function lum($hex, $percent) {
	// validate hex string
	$hex = preg_replace( '/[^0-9a-f]/i', '', $hex );
	$new_hex = '#';
	
	if (strlen( $hex ) < 6) {
		$hex = $hex[0] + $hex[0] + $hex[1] + $hex[1] + $hex[2] + $hex[2];
	}
	
	// convert to decimal and change luminosity
	for ($i = 0; $i < 3; $i++) {
		$dec = hexdec(substr($hex, $i*2, 2));
		$dec = min(max(0, $dec + $dec * $percent), 255); 
		$new_hex .= str_pad(dechex($dec), 2, 0, STR_PAD_LEFT);
	}		
	
	return $new_hex;
}
