<?php
/**
 * Plugin info.
 * @package    AppMySite
 * @author     AppMySite <support@appmysite.com>
 * @copyright  Copyright (c) 2022 - 2023, AppMySite
 * @link       https://appmysite.com
 * @license    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?> 
<div class="ams-wrap">
    <div class="ams-plugin-ui">
        
        <div class="ams-plugin-head">

            <a href="https://www.appmysite.com/">
                <svg width="160" height="30" viewBox="0 0 160 30">
        <defs>
        <clipPath id="clip-path">
        <rect id="Rectangle_8200" data-name="Rectangle 8200" width="160" height="30" transform="translate(420 25)" fill="#fff"></rect>
        </clipPath>
        <clipPath id="clip-path-2">
        <rect id="Rectangle_7330" data-name="Rectangle 7330" width="159.961" height="29.409" fill="none"></rect>
        </clipPath>
        </defs>
        <g id="Mask_Group_202" data-name="Mask Group 202" transform="translate(-420 -25)" clip-path="url(#clip-path)">
        <g id="Group_7557" data-name="Group 7557" transform="translate(420 25)">
        <g id="Group_96" data-name="Group 96" clip-path="url(#clip-path-2)">
        <path id="Path_115" data-name="Path 115" d="M14.084,58.114v1.932a6.185,6.185,0,0,0-5.352-2.718C3.839,57.293,0,60.318,0,66.093c0,5.876,3.671,8.935,8.631,8.9,1.867-.034,4.5-.986,5.453-2.957v2.549l4.1-.435V57.677ZM9.107,71.189h0a5.081,5.081,0,0,1,0-10.158c6.523,0,6.523,10.158,0,10.158" transform="translate(0 -52.015)" fill="#3064f9"></path>
        <path id="Path_116" data-name="Path 116" d="M220.423,57.7a6.662,6.662,0,0,0-5.382,2.61V58.016l-4.1.435V81.758l4.1-.435V72.93c1.208,1.771,3.776,2.3,5.517,2.3,5.369,0,8.46-3.872,8.46-8.764,0-4.926-3.431-8.766-8.6-8.766m-.306,13.522a4.643,4.643,0,0,1-4.756-4.757,4.756,4.756,0,0,1,9.513,0,4.644,4.644,0,0,1-4.757,4.757" transform="translate(-191.396 -52.354)" fill="#3064f9"></path>
        <path id="Path_117" data-name="Path 117" d="M430.726,57.7h0a6.651,6.651,0,0,0-5.427,2.672V58.013h0l-4.1.435V81.758l4.1-.435V72.865c1.191,1.822,3.8,2.365,5.561,2.365,5.369,0,8.46-3.872,8.46-8.764,0-4.927-3.431-8.766-8.6-8.766m-.3,13.521a4.643,4.643,0,0,1-4.756-4.757,4.756,4.756,0,0,1,9.513,0,4.644,4.644,0,0,1-4.757,4.757" transform="translate(-382.175 -52.354)" fill="#3064f9"></path>
        <path id="Path_118" data-name="Path 118" d="M1182.5,63.525c-2.139-.135-3.125-.747-3.125-1.833,0-1.054,1.087-1.664,3.059-1.664a5.647,5.647,0,0,1,4.144,1.493l2.31-2.717a8.993,8.993,0,0,0-6.522-2.209c-3.059,0-7.067,1.36-7.067,5.232,0,3.8,3.771,4.96,6.931,5.2,2.379.137,3.33.612,3.33,1.767,0,1.223-1.461,2.039-3.024,2a9.189,9.189,0,0,1-5.776-2.344l-2.038,2.956a9.8,9.8,0,0,0,7.746,2.99c4.791,0,7.2-2.548,7.2-5.5,0-4.451-4.009-5.164-7.168-5.369Z" transform="translate(-1065.881 -51.35)" fill="#3064f9"></path>
        <path id="Path_119" data-name="Path 119" d="M1355.016,61V77.473l-4.146.441V61.439l4.115-.439Z" transform="translate(-1225.71 -55.348)" fill="#3064f9"></path>
        <path id="Path_120" data-name="Path 120" d="M1355.016,0V3.594l-4.146.441V.439Z" transform="translate(-1225.71)" fill="#3064f9"></path>
        <path id="Path_121" data-name="Path 121" d="M1422.3,32.125a9.249,9.249,0,0,1-3.431.714c-3.637.137-6.015-1.936-6.015-6.116V19.209h-3.125l1.708-3.566h1.417v-4.2L1417,11v4.643h2.912v3.566h-2.946v7.514a2.08,2.08,0,0,0,2.175,2.379,4.749,4.749,0,0,0,2.005-.51Z" transform="translate(-1279.116 -9.981)" fill="#3064f9"></path>
        <path id="Path_122" data-name="Path 122" d="M1547.2,56.24c-5.436,0-8.9,3.669-8.9,8.765,0,5.365,3.432,8.934,9.207,8.934a10.293,10.293,0,0,0,7.2-2.717l-2.651-2.616a6.92,6.92,0,0,1-4.485,1.561c-2.92,0-4.722-1.5-4.993-3.566h13.078c.647-6.9-2.854-10.361-8.457-10.361m-4.552,6.932a4.509,4.509,0,0,1,4.687-3.262c2.378,0,4.077,1.087,4.348,3.262Z" transform="translate(-1395.774 -51.029)" fill="#3064f9"></path>
        <path id="Path_123" data-name="Path 123" d="M692.448,66.457v8.691l-4.146.441V66.457c0-2.208-.918-4.077-3.159-4.077s-3.635,1.935-3.635,4.146v8.622l-4.146.441V66.526c0-2.21-1.155-4.214-3.431-4.214-2.151,0-3.461,1.847-3.562,3.949v8.9l-4.1.435V59.116l4.056-.432h.044v2.053a4.853,4.853,0,0,1,4.41-2.3,5.019,5.019,0,0,1,4.961,3.125,6.062,6.062,0,0,1,5.6-3.057c4.757,0,7.1,2.92,7.1,7.95" transform="translate(-604.539 -53.025)" fill="#3064f9"></path>
        <path id="Path_124" data-name="Path 124" d="M966.816,60.87l-.034.081-.3.69L956.8,84.132l-4.771.507,3.1-7.212-6.519-16.05,4.627-.491.02.056,0,.009,4.212,11.387,4.546-10.958Z" transform="translate(-860.72 -55.23)" fill="#3064f9"></path>
        </g>
        </g>
        </g>
    </svg>
            </a> 

            <a target="_blank" href="https://app.appmysite.com/signup/"><svg width="14" height="14.003" viewBox="0 0 14 14.003">
              <path id="_9110810_external_link_icon" data-name="9110810_external_link_icon" d="M13.127,8.752v3.5A1.75,1.75,0,0,1,11.377,14H1.75A1.75,1.75,0,0,1,0,12.252V2.625A1.75,1.75,0,0,1,1.75.875h3.5v1.75H1.75v9.627h9.627v-3.5ZM12.25,2.988,6.742,8.5,5.5,7.258,11.012,1.75H7.874V0H14V6.126H12.25Z" fill="#5f6578" fill-rule="evenodd"/>
            </svg> Go to Portal</a>
        </div>
        
        <div class="ams-tabbed">
            <input type="radio" id="ams-tab1" name="css-tabs" checked>
            <input type="radio" id="ams-tab2" name="css-tabs">
            <input type="radio" id="ams-tab3" name="css-tabs">
            <input type="radio" id="ams-tab4" name="css-tabs">

            <ul class="ams-tabs">
                <li class="ams-tab"><label for="ams-tab1">Dashboard</label></li>
                <li class="ams-tab"><label for="ams-tab2">Health</label></li>
				<li class="ams-tab"><label for="ams-tab3">Safe Mode</label></li> 
                <!--<li class="ams-tab"><label for="ams-tab4">Grant Access</label></li>-->
                
            </ul>

            <div class="ams-tab-content">
                <div class="ams-plugin-tab-1">
                    <div>
                        <h1>Discover the AppMySite WordPress plugin</h1>
                        <p>AppMySite makes app development easy. Build premium native mobile apps for both Android & iOS without writing a single line of code.</p>
						<p>Our plugin is essential for seamless connectivity between your WordPress website and your mobile app. It also helps troubleshoot and resolve connectivity issues.</p>
                        <div class="amsflex">
                            <a target="_blank" class="homebannerbtn" href="https://www.appmysite.com/">Get started</a>
                            <a class="demobtn" id="ams-button" href="javascript:void(0)">
                                <svg class="mr-2" width="13.222" height="17" viewBox="0 0 13.222 17">
                                <path id="Polygon_49" data-name="Polygon 49" d="M7.659,1.308a1,1,0,0,1,1.682,0L16.01,11.681a1,1,0,0,1-.841,1.541H1.832A1,1,0,0,1,.99,11.681Z" transform="translate(13.222) rotate(90)" fill="#7782a1"></path>
                                </svg>
                            How it works</a>
                        </div>
                    </div>
                    <div>
                        <a id="sam-youtube-link" href="javascript:void(0)"></a>
                    </div>
                </div>
                
				<div class="ams-Verify-license">
                    <div class="ams-Verify-license-head">
                        <div>
                            <h3>License key<div class="ams-tooltip"><svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14">
							  <g id="Group_37563" data-name="Group 37563" transform="translate(-1727 -19.132)">
								<g id="Ellipse_7706" data-name="Ellipse 7706" transform="translate(1727 19.132)" fill="#fff" stroke="#bcc1ce" stroke-width="1.2">
								  <circle cx="7" cy="7" r="7" stroke="none"/>
								  <circle cx="7" cy="7" r="6.4" fill="none"/>
								</g>
								<path id="Path_98061" data-name="Path 98061" d="M7,6.621A1.923,1.923,0,1,1,9.636,8.407a1.076,1.076,0,0,0-.713.985v1.074" transform="translate(1725.126 17.539)" fill="none" stroke="#bcc1ce" stroke-miterlimit="10" stroke-width="1.2"/>
								<line id="Line_343" data-name="Line 343" y2="1.2" transform="translate(1734 29.132)" fill="none" stroke="#bcc1ce" stroke-miterlimit="10" stroke-width="1.2"/>
							  </g>
							</svg>
							<p class="ams-tooltipsubheader">Unlock advanced features and enhanced connection visibility by entering your license key.</p></div></h3>

                            <h6>Enter your license key to unlock enhanced connection visibility. This is optional. </h6>
                        </div>
                        <div>
                            <a class="ams-go-site" target="_blank" href="https://appmysite.com">Get my key <svg xmlns="http://www.w3.org/2000/svg" width="11.2" height="11.2" viewBox="0 0 11.2 11.2">
                              <g id="Group_9162" data-name="Group 9162" transform="translate(0.6 0.598)">
                                <path id="Path_10239" data-name="Path 10239" d="M4,1H1A1,1,0,0,0,0,2V9a1,1,0,0,0,1,1H8A1,1,0,0,0,9,9V6" transform="translate(0 0.002)" fill="none" stroke="#c8cedb" stroke-width="1.2"/>
                                <path id="Path_10240" data-name="Path 10240" d="M4,4V0H0" transform="translate(6 0.002)" fill="none" stroke="#c8cedb" stroke-width="1.2"/>
                                <path id="Path_10241" data-name="Path 10241" d="M2144-23303l-6,6" transform="translate(-2134 23303.002)" fill="none" stroke="#c8cedb" stroke-width="1.2"/>
                              </g>
                            </svg>
                            </a>
                            
                        </div>
                    </div>
                    <form  class="ams-secret-token-form"  method="POST">
                    <div class="ams-apply-license">
                        
						
							
						<!--<label for="ams_insert_footer_priority"><?php _e('AppMySite App Secret Token'); ?></label>-->
						<div class="ams-apply-input">
						<input type="text" value="<?php if(defined('AMS_LICENSE_KEY')) {echo(AMS_LICENSE_KEY);} ?>" name="ams_license_key" id="ams_license_key" placeholder="XXXXX-XXXXX-XXXXX-XXXXX-XXXX" />
							
							<?php if(defined('AMS_LICENSE_STATUS')){ if(AMS_LICENSE_STATUS =="Verified"){
								echo( '<p id="ams_verify_license_status" class="ams-verify-license-status license-status-green">Verified</p>' );
							}else{
								echo( '<p id="ams_verify_license_status" class="ams-verify-license-status license-status-red">Unverified</p>' );
							}} ?> 
						</div>
						
						<button type="button" class="ams-Verify-license-mob-button" id="ams-app-secret-token-form-submit-button"><div id="ams-license-submit-loader"></div><span id="ams-license-submit-text">Submit</span></button>	
						
                    </div>
						<h5 id ="ams_license_validation_error">
                        </h5>
                    </form>
                </div>
				
				
                <div class="ams-supportlinks">
                  <div class="supportweb">
                    <a href="https://updates.appmysite.com/en/" target="_blank"></a>
                    <img src="<?php echo plugins_url().'/appmysite/assets/images/website-link1.png'; ?>" alt="knowledge-base">
                    <div class="">
                      <h6>What's New</h6>
                      <p>Stay up to date with what’s keeping us busy.</p>
                    </div>
                  </div>
                  <div class="supportweb">
                    <a href="https://updates.appmysite.com/roadmap/en/" target="_blank"></a>
                    <img src="<?php echo plugins_url().'/appmysite/assets/images/website-link2.png'; ?>" alt="roadmap">
                    <div class="">
                      <h6>Knowledge base</h6>
                      <p>Find articles that answer your questions.</p>
                    </div>
                  </div>
                  <div class="supportweb">
                    <a href="https://community.appmysite.com/" target="_blank"></a>
                    <img src="<?php echo plugins_url().'/appmysite/assets/images/website-link3.png'; ?>" alt="support-base">
                    <div class="">
                      <h6>Community</h6>
                      <p>Engage with other app builders like yourself.</p>
                    </div>
                  </div>
                  <div class="supportweb">
                    <a target="_blank" href="https://app.appmysite.com/email-support/"></a>
                    <img src="<?php echo plugins_url().'/appmysite/assets/images/website-link4.png'; ?>" alt="community-icon">
                    <div class="">
                      <h6>Email support</h6>
                      <p>Submit a request and get help from experts.</p>
                    </div>
                  </div>
                </div>
                
				<div id="ams-modal-1" class="modal">

				  <!-- Modal content -->
				  <div class="modal-content">
					<span class="modalclose">&times;</span>
					<iframe id="ams-youtube-video-1" width="800px" height="450px" title="YouTube video player" frameborder="0"  allowfullscreen></iframe>
				  </div>

				</div>
				  
				<div id="ams-modal-2" class="modal">

				  <!-- Modal content -->
				  <div class="modal-content">
					<span class="modalclose sam-youtube-modal-close">&times;</span>
					<iframe id="ams-youtube-video-2" width="800px" height="450px" title="YouTube video player" frameborder="0"  allowfullscreen></iframe>
				  </div>

				</div> 
                
            </div>
			
			<div class="ams-tab-content">
                <div class="ams-connectivity-tab">
					<p id="ams-health-error" style="color:red; text-align:left; margin:0px 30px 0px 30px; padding-top:20px;"> </p>
                    <div class="ams-connectivity-head">
                        <div>
                            <h1>Connectivity</h1>
                            <p>Troubleshoot connectivity between your website and app.</p>
                        </div>
                        <div>
							<?php 
								if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
									// Yes, WooCommerce is enabled
									$ams_is_site_woocommerce = 1;
								} else {
									// WooCommerce is NOT enabled!
									$ams_is_site_woocommerce = 0;
								}

							?>
                            <button id="ams_check_button" value="<?php echo plugins_url();?>"><div id="ams-health-check-btn-loader"></div><span id="ams-health-check-btn-text">Check</span></button>
							<input type="hidden" id="ams_site_url" name="ams_site_url" value="<?php echo esc_url(site_url());?>">
							<input type="hidden" id="ams_is_site_woocommerce" name="ams_is_site_woocommerce" value="<?php echo $ams_is_site_woocommerce;?>">
							<input type="hidden" name="ams_license_key" id="input_ams_license_key" value="<?php if(defined('AMS_LICENSE_KEY')) {echo(AMS_LICENSE_KEY);} ?>" />
							<input type="hidden" name="ams_license_status" id="input_ams_license_status" value="<?php if(defined('AMS_LICENSE_STATUS')) {echo(AMS_LICENSE_STATUS);} ?>" />
                        </div>
                    </div>
                    
                    <div class="ams-connectivity-steps">
                        <div class="ams-connectivity-table" style="display:none;" >
                            
                            
                            <?php 
								$WP_Site_Health = new WP_Site_Health();
								$test_http_requests =	$WP_Site_Health->get_test_http_requests();
								$test_rest_availability =  $WP_Site_Health->get_test_rest_availability();
							?>
                            
                            <div class="ams-connectivity-column">
                                
                                <div class="ams-connectivity-row-1">
                                    <div>
                                        <div class="ams-loader ams-hide " ></div>
										<?php 
											if($test_http_requests['status']=='good'){echo "<img class='ams-loader-image' style='display: none;' src=".plugins_url()."/appmysite/assets/images/approved.png alt=approved>";}
											else{echo "<img class='ams-loader-image' style='display: none;' src=".plugins_url()."/appmysite/assets/images/rejected.png alt=rejected>";}
										?>
                                    </div>
                                    <div>
                                        
                                        <h5>Accessibility</h5>
										<p>A simple HTTP test to determine accessibility of your website over the web. <?php //echo $test_http_requests['description'];  ?></p>
                                        
                                    </div>
                                </div>
                                
                                <!--<div class="ams-connectivity-row-2">
                                    <div>
                                        <h4 class="ams-hide">-</h4>
                                        <h5>0.20s</h5>
                                    </div>
                                </div>-->
                                
                                <div class="ams-connectivity-row-3">
                                    <div>
                                        <h4 class="ams-testing-text" style="display:none;">Testing...</h4>
                                        <?php echo ($test_http_requests['status']=='good') ? __( '<h5 style="display:none;" class="greenstatus">Success</h5>' ) : __( '<h5 style="display:none;" class="redstatus">Failed</h5>' ); ?>
                                    </div>
                                </div>
								
								<div class="ams-connectivity-row-2">
								<p class="ams-test-result-label" style="display:none;"><?php echo ($test_http_requests['status']=='good') ? __( 'Your website is accessible over HTTP.' ) : __( 'Your website is not accessible over HTTP.' ); //echo $test_http_requests['label'];  ?></p>
								</div>
                                
                            </div>
                            
                            
                            <div class="ams-connectivity-column">
                                
                                <div class="ams-connectivity-row-1">
                                    <div>
                                        <div class="ams-loader ams-hide"></div>
										<?php 
											if($test_rest_availability['status']=='good'){echo "<img class='ams-loader-image' style='display: none;' src=".plugins_url()."/appmysite/assets/images/approved.png alt=approved>";}
											else{echo "<img class='ams-loader-image' style='display: none;' src=".plugins_url()."/appmysite/assets/images/rejected.png alt=rejected>";}
										?>
                                    </div>
                                    <div>
                                        <h5>WordPress API connectivity</h5>
                                        <p>The REST API facilitates communication between WordPress and the outside world.<?php //echo $test_rest_availability['description'];  ?></p>
                                    </div>
                                </div>
                                
                                <!--<div class="ams-connectivity-row-2">
                                    <div>
                                        <h4 class="ams-hide">-</h4>
                                        <h5>0.15s</h5>
                                    </div>
                                </div>-->
                                
                                <div class="ams-connectivity-row-3">
                                    <div>
                                        <h4 class="ams-testing-text" style="display:none;">Testing...</h4>
                                        <?php echo ($test_rest_availability['status']=='good') ? __( '<h5 style="display:none;" class="greenstatus">Success</h5>' ) : __( '<h5 style="display:none;" class="redstatus">Failed</h5>' ); ?>
                                    </div>
                                </div>
								
								<div class="ams-connectivity-row-2">
								<p class="ams-test-result-label" style="display:none;"><?php echo ($test_rest_availability['status']=='good') ? __( 'REST API connection established.' ) : __( 'REST API connection not established. Disable all plugins (except this one), use the default theme, and try again.' ); //echo $test_rest_availability['label'];  ?></p>
								</div>
                                
                            </div>
                            
                            
                            <div class="ams-connectivity-column">
                                
                                <div class="ams-connectivity-row-1">
                                    <div>
                                        <div class="ams-loader ams-hide"></div>
                                        <?php 
											if(get_option( 'permalink_structure' )){echo "<img class='ams-loader-image' style='display: none;' src=".plugins_url()."/appmysite/assets/images/approved.png alt=approved>";}
											else{echo "<img class='ams-loader-image' style='display: none;' src=".plugins_url()."/appmysite/assets/images/rejected.png alt=rejected>";}
										?>
                                    </div>
                                    <div>
                                        <h5>Pretty links</h5>
										<p>An easy-to-read permalink structure for REST API compatibility.</p>
                                        
                                    </div>
                                </div>
                                
                                <!--<div class="ams-connectivity-row-2">
                                    <div>
                                        <h4 class="ams-hide">-</h4>
                                        <h5 class="redtime">0.15s</h5>
                                    </div>
                                </div>-->
                                
                                <div class="ams-connectivity-row-3">
                                    <div>
                                        <h4 class="ams-testing-text" style="display:none;">Testing...</h4>
                                        <?php echo got_url_rewrite() ? __( '<h5 style="display:none;" class="greenstatus">Success</h5>' ) : __( '<h5 style="display:none;" class="redstatus">Failed</h5>' ); ?>
                                        <!-- <a href="">See error</a>-->
                                    </div>
                                </div>
								<div class="ams-connectivity-row-3">
									<p class="ams-test-result-label" style="display:none;" > <?php $permalink_structure = got_url_rewrite(); echo $permalink_structure ? __('Permalink structure set correctly.') : __( 'Permalink structure incorrect. Please ensure it is not set to the default ‘Plain’ permalink (?p=123).' ) ?></p>
								</div>
                                
                            </div>
                            
                            
                            <!--<div class="ams-connectivity-column">
                                
                                <div class="ams-connectivity-row-1">
                                    <div>
                                        <div class="ams-loader ams-hide"></div>
										<?php 
											if(got_url_rewrite()){echo "<img class='ams-loader-image' style='display: none;' src=".plugins_url()."/appmysite/assets/images/approved.png alt=approved>";}
											else{echo "<img class='ams-loader-image' style='display: none;' src=".plugins_url()."/appmysite/assets/images/rejected.png alt=rejected>";}
										?>
                                    </div>
                                    <div>
                                        <h4 class="ams-hide">Pretty permalinks</h4>
                                        <h5>Pretty permalinks</h5>
										<p>To use the latest version of the REST API you must be using pretty permalinks in Settings, so that the custom endpoints are supported. Default permalinks will not work.</p>
                                       
                                    </div>
                                </div>
                                
                                <!--<div class="ams-connectivity-row-2">
                                    <div>
                                        <h4 class="ams-hide">-</h4>
                                        <h5>0.15s</h5>
                                    </div>
                                </div>->
                                
                                <div class="ams-connectivity-row-3">
                                    <div>
                                        <h4 class="ams-testing-text" style="display:none;">Testing...</h4>
										<?php echo got_url_rewrite() ? __( '<h5 style="display:none;" class="greenstatus">Success</h5>' ) : __( '<h5 style="display:none;" class="redstatus">Failed</h5>' ); ?>
                                        <!--<a href="">See error</a> ->
                                    </div>
                                </div>
								
								<div class="ams-connectivity-row-2">
									<p class="ams-test-result-label" style="display:none;"> <?php  echo got_url_rewrite() ? __('Pretty permalinks are supported.') : __( 'Pretty permalinks are not supported.' ) ?></p>
								</div>
                                
                            </div>-->
                            
                            
                            <div class="ams-connectivity-column">
                                
                                <div class="ams-connectivity-row-1">
                                    <div>
										<div class="ams-loader ams-hide"></div>
                                        <?php 
											if(get_option( 'users_can_register' )){echo "<img class='ams-loader-image' style='display: none;' src=".plugins_url()."/appmysite/assets/images/approved.png alt=approved>";}
											else{echo "<img class='ams-loader-image' style='display: none;' src=".plugins_url()."/appmysite/assets/images/rejected.png alt=rejected>";}
										?>
                                    </div>
                                    <div>
                                        <h5>User registration</h5>
                                        <p>The ability to register users on your app.</p>
                                    </div>
                                </div>
                                
                                <!--<div class="ams-connectivity-row-2">
                                    <div>
                                        <h4 class="ams-hide">-</h4>
                                        <h5>0.15s</h5>
                                    </div>
                                </div>-->
                                
                                <div class="ams-connectivity-row-3">
                                    <div>
                                        <h4 class="ams-testing-text" style="display:none;">Testing...</h4>
										<?php echo get_option( 'users_can_register' ) ? __( '<h5 style="display:none;" class="greenstatus">Success</h5>' ) : __( '<h5 style="display:none;" class="redstatus">Failed</h5>' ); ?>
                                    </div>
                                </div>
								<div class="ams-connectivity-row-2">
									<p class="ams-test-result-label" style="display:none;"><?php $users_can_register = get_option( 'users_can_register' ); echo $users_can_register ? __( 'Users will be able to register on your app.' ) : __( 'Users will not be able to register on your app. Enable user registration.' ); ?></p>
								</div>
                                
                            </div>
                            
                            <div class="ams-connectivity-column">
                                
                                <div class="ams-connectivity-row-1">
                                    <div>
                                        <div class="ams-loader ams-hide"></div>
										<?php 
											if(is_ssl()){echo "<img class='ams-loader-image' style='display: none;' src=".plugins_url()."/appmysite/assets/images/approved.png alt=approved>";}
											else{echo "<img class='ams-loader-image' style='display: none;' src=".plugins_url()."/appmysite/assets/images/rejected.png alt=rejected>";}
										?>
										
                                    </div>
                                    <div>
                                        <h5>Secure connectivity</h5>
										<p>An SSL certificate ensures secure communication between your website and the outside world.</p>
                                        
                                    </div>
                                </div>
                                
                                
                                <div class="ams-connectivity-row-3">
                                    <div>
                                        <h4 class="ams-testing-text" style="display:none;">Testing...</h4>
										<?php $is_ssl = is_ssl(); echo $is_ssl ? __( '<h5 style="display:none;" class="greenstatus">Success</h5>' ) : __( '<h5 style="display:none;" class="redstatus">Failed</h5>' ); ?>
                                    </div>
                                </div>
								
								<div class="ams-connectivity-row-2">
									<p class="ams-test-result-label" style="display:none;"><?php echo is_ssl() ? __( 'Your website is securely accessible via HTTPS.' ) : __( 'Insecure connection detected. Install a valid SSL certificate.' ); ?></p>
								</div>
                                
                            </div>
							
							<!--<div class="ams-connectivity-column">                                
                                <div class="ams-connectivity-row-1">
                                    <div>
                                        <div class="ams-loader ams-hide"></div>
										<img class='ams-loader-image' style='display: none;' src="<?php echo plugins_url().'/appmysite/assets/images/approved.png'; ?>" alt="approved">
                                    </div>
                                    <div>
                                        <h4 class="ams-hide">Wordpress Test 1</h4>
										<h5>Wordpress Test 1</h5>
                                        <p>Blogs of website should be public.</p>
                                    </div>
                                </div>                                
                                <div class="ams-connectivity-row-3">
                                    <div>
                                        <h4 class="ams-testing-text" style="display:none;">Testing...</h4>
										<h5 style="display:none;" class="greenstatus">Success</h5>
                                    </div>
                                </div>								
								<div class="ams-connectivity-row-2">
									    <p class="ams-test-result-label" style="display:none;">Result</p>                                    
								</div>                                
                            </div>-->
                            
                        </div>
                    </div>
                    
                    <!--<div class="ams-connectivity-troubleshoot">
                        <img src="<?php echo plugins_url().'/appmysite/assets/images/connectivity-troubleshoot.png'; ?>" alt="connectivity-troubleshoot">
                    </div>-->
                    
                    
                </div>
            </div>
	
			<div class="ams-tab-content">
                <div class="ams-safe-tab">
                    <p id="ams-health-error" style="color:red; text-align:left; margin:0px 30px 0px 30px; padding-top:20px;"> </p>
                    <div class="ams-safe-head">
                        <div>
                            <h1>Safe Mode</h1>
                            <p>Diagnose and identify if your themes and plugins are interfering with your website to app connectivity.</p>
                        </div>
							<form class="ams-safe-mode-form"  method="POST">
							<?php  if(!defined('AMS_SAFE_MODE')){define(	'AMS_SAFE_MODE', 'off' );} ?>
							<div class="ams_safe_mode <?php if(AMS_SAFE_MODE =="on"){ echo('safemode-disabled'); }else{echo('safemode-enabled');}?>" id="ams_safe_mode_div"> 
								<input type="text" name="ams_safe_mode" id= "ams_safe_mode" value = "<?php if(AMS_SAFE_MODE =="on"){ echo('Currently enabled'); }else{echo('Currently disabled');}?>" readonly />
								<button type="button" class="ams-safe-mode-mob-button" id="ams-safe-mode-form-submit-button" ><div id="ams-safe-mode-btn-loader"></div><?php if(AMS_SAFE_MODE =="on"){ echo('Disable'); }else{echo('Enable');}?></button> 
							</div>
							</form>
                    </div>
                    
                    <div class="ams-safe-toggle">
                        <h4>Enable Safe Mode</h4>
                        <p>Enable safe mode to identify connectivity issues between your app and website. Safe mode will temporarily disable your plugins and themes for incoming API connections only. Enabling Safe mode is unlikely to impact the visual appearance of your website. </p>
                        
                        <h5>Use it selectively to identify issues, but we recommend not leaving it on for an extended period.</h5>
                        
                        
                    </div>
                </div>
            
			<!--  AMS validation popup -->
			<script>
			function ams_close_popup(e) {
			  jQuery('#ams-safemode-validation-popup').removeClass("ams-show-popup");
			}
			</script>

                    <div id="ams-safemode-validation-popup" class="ams-popup-overlay ">
                        <div class="ams-popup">
                            <a class="ams-popup-close" href="javascript:ams_close_popup();">&times;</a>	
                            <div class="ams-popup-content">
                                <h2 id="ams-sfmd-valiation-msg-heading"></h2>
                                <p id="ams-sfmd-valiation-msg" ></p>
                                <a href="javascript:ams_close_popup();">Okay</a>
                            </div>
                        </div>
                    </div>
			
			<!--  End AMS Validation pop-up  -->
			</div>
<!--   Future Provision
            
 -->           
        </div>
        
    </div>    
</div>
