<?php
/**
 * Map of characters to be replaces to transliterate in case intl extension is not available.
 * @since 0.0.70
 */
return [
	'À'  => 'A',
	'Á'  => 'A',
	'Â'  => 'A',
	'Ã'  => 'A',
	'Ä'  => 'A',
	'Å'  => 'A',
	'Æ'  => 'AE',
	'Ç'  => 'C',
	'È'  => 'E',
	'É'  => 'E',
	'Ê'  => 'E',
	'Ë'  => 'E',
	'Ì'  => 'I',
	'Í'  => 'I',
	'Î'  => 'I',
	'Ï'  => 'I',
	'Ð'  => 'D',
	'Ñ'  => 'N',
	'Ò'  => 'O',
	'Ó'  => 'O',
	'Ô'  => 'O',
	'Õ'  => 'O',
	'Ö'  => 'O',
	'Ő'  => 'O',
	'Ø'  => 'O',
	'Ù'  => 'U',
	'Ú'  => 'U',
	'Û'  => 'U',
	'Ü'  => 'U',
	'Ű'  => 'U',
	'Ý'  => 'Y',
	'Þ'  => 'TH',
	'ß'  => 'ss',
	'à'  => 'a',
	'á'  => 'a',
	'â'  => 'a',
	'ã'  => 'a',
	'ä'  => 'a',
	'å'  => 'a',
	'æ'  => 'ae',
	'ç'  => 'c',
	'è'  => 'e',
	'é'  => 'e',
	'ê'  => 'e',
	'ë'  => 'e',
	'ì'  => 'i',
	'í'  => 'i',
	'î'  => 'i',
	'ï'  => 'i',
	'ð'  => 'd',
	'ñ'  => 'n',
	'ò'  => 'o',
	'ó'  => 'o',
	'ô'  => 'o',
	'õ'  => 'o',
	'ö'  => 'o',
	'ő'  => 'o',
	'ø'  => 'o',
	'ù'  => 'u',
	'ú'  => 'u',
	'û'  => 'u',
	'ü'  => 'u',
	'ű'  => 'u',
	'ý'  => 'y',
	'þ'  => 'th',
	'ÿ'  => 'y',
	'Ґ'  => 'G',
	'ґ'  => 'g',
	'І'  => 'I',
	'і'  => 'i',
	'Ї'  => 'I',
	'ї'  => 'i',
	'Ї' => 'i',
	'ї' => 'i',
	'Ё' => 'Jo',
	'ё' => 'jo',
	'й' => 'i',
	'Й' => 'I',
	'А'  => 'A',
	'а'  => 'a',
	'Б'  => 'B',
	'б'  => 'b',
	'В'  => 'V',
	'в'  => 'v',
	'Г'  => 'G',
	'г'  => 'g',
	'Д'  => 'D',
	'д'  => 'd',
	'Е'  => 'E',
	'е'  => 'e',
	'Ё'  => 'Jo',
	'ё'  => 'jo',
	'Ж'  => 'Zh',
	'ж'  => 'zh',
	'З'  => 'Z',
	'з'  => 'z',
	'И'  => 'I',
	'и'  => 'i',
	'Й'  => 'J',
	'й'  => 'j',
	'К'  => 'K',
	'к'  => 'k',
	'Л'  => 'L',
	'л'  => 'l',
	'М'  => 'M',
	'м'  => 'm',
	'Н'  => 'N',
	'н'  => 'n',
	'О'  => 'O',
	'о'  => 'o',
	'П'  => 'P',
	'п'  => 'p',
	'Р'  => 'R',
	'р'  => 'r',
	'С'  => 'S',
	'с'  => 's',
	'Т'  => 'T',
	'т'  => 't',
	'У'  => 'U',
	'у'  => 'u',
	'Ф'  => 'F',
	'ф'  => 'f',
	'Х'  => 'H',
	'х'  => 'h',
	'Ц'  => 'C',
	'ц'  => 'c',
	'Ч'  => 'Ch',
	'ч'  => 'ch',
	'Ш'  => 'Sh',
	'ш'  => 'sh',
	'Щ'  => 'Shh',
	'щ'  => 'shh',
	'Ъ'  => '',
	'ъ'  => '',
	'Ы'  => 'Y',
	'ы'  => 'y',
	'Ь'  => '',
	'ь'  => '',
	'Э'  => 'Je',
	'э'  => 'je',
	'Ю'  => 'Ju',
	'ю'  => 'ju',
	'Я'  => 'Ja',
	'я'  => 'ja',

	// Georgian
	'ა'  => 'a',
	'ბ'  => 'b',
	'გ'  => 'g',
	'დ'  => 'd',
	'ე'  => 'e',
	'ვ'  => 'v',
	'ზ'  => 'z',
	'თ'  => 'th',
	'ი'  => 'i',
	'კ'  => 'k',
	'ლ'  => 'l',
	'მ'  => 'm',
	'ნ'  => 'n',
	'ო'  => 'o',
	'პ'  => 'p',
	'ჟ'  => 'zh',
	'რ'  => 'r',
	'ს'  => 's',
	'ტ'  => 't',
	'უ'  => 'u',
	'ფ'  => 'ph',
	'ქ'  => 'q',
	'ღ'  => 'gh',
	'ყ'  => 'qh',
	'შ'  => 'sh',
	'ჩ'  => 'ch',
	'ც'  => 'ts',
	'ძ'  => 'dz',
	'წ'  => 'ts',
	'ჭ'  => 'tch',
	'ხ'  => 'kh',
	'ჯ'  => 'j',
	'ჰ'  => 'h',

	// Greek
	'α'  => 'a',
	'β'  => 'v',
	'γ'  => 'g',
	'δ'  => 'd',
	'ε'  => 'e',
	'ζ'  => 'z',
	'η'  => 'h',
	'θ'  => 'th',
	'ι'  => 'i',
	'κ'  => 'k',
	'λ'  => 'l',
	'μ'  => 'm',
	'ν'  => 'n',
	'ξ'  => 'x',
	'ο'  => 'o',
	'π'  => 'p',
	'ρ'  => 'r',
	'σ'  => 's',
	'ς'  => 's',
	'τ'  => 't',
	'υ'  => 'u',
	'φ'  => 'f',
	'χ'  => 'ch',
	'ψ'  => 'ps',
	'ω'  => 'o',
	'Α'  => 'A',
	'Β'  => 'V',
	'Γ'  => 'G',
	'Δ'  => 'D',
	'Ε'  => 'E',
	'Ζ'  => 'Z',
	'Η'  => 'H',
	'Θ'  => 'TH',
	'Ι'  => 'I',
	'Κ'  => 'K',
	'Λ'  => 'L',
	'Μ'  => 'M',
	'Ν'  => 'N',
	'Ξ'  => 'X',
	'Ο'  => 'O',
	'Π'  => 'P',
	'Ρ'  => 'R',
	'Σ'  => 'S',
	'Τ'  => 'T',
	'Υ'  => 'U',
	'Φ'  => 'F',
	'Χ'  => 'CH',
	'Ψ'  => 'PS',
	'Ω'  => 'O',
	'ά'  => 'a',
	'έ'  => 'e',
	'ή'  => 'h',
	'ί'  => 'i',
	'ό'  => 'o',
	'ύ'  => 'u',
	'ώ'  => 'o',
	'Ά'  => 'A',
	'Έ'  => 'E',
	'Ή'  => 'H',
	'Ί'  => 'I',
	'Ό'  => 'O',
	'Ύ'  => 'U',
	'Ώ'  => 'O',
	'ϊ'  => 'i',
	'ΐ'  => 'i',
	'ΰ'  => 'u',
	'ϋ'  => 'u',
	'Ϊ'  => 'I',
	'Ϋ'  => 'U'
];