<?php

/**
 * SCSSPHP
 *
 * @copyright 2012-2020 Leaf Corcoran
 *
 * @license http://opensource.org/licenses/MIT MIT
 *
 * @link http://scssphp.github.io/scssphp
 */

namespace ABB\ScssPhp\ScssPhp;

/**
 * Block
 *
 * @author Anthon Pang <anthon.pang@gmail.com>
 *
 * @internal
 */
class Block
{
    /**
     * @var string
     */
    public $type;

    /**
     * @var \ABB\ScssPhp\ScssPhp\Block
     */
    public $parent;

    /**
     * @var string
     */
    public $sourceName;

    /**
     * @var integer
     */
    public $sourceIndex;

    /**
     * @var integer
     */
    public $sourceLine;

    /**
     * @var integer
     */
    public $sourceColumn;

    /**
     * @var array|null
     */
    public $selectors;

    /**
     * @var array
     */
    public $comments;

    /**
     * @var array
     */
    public $children;

    /**
     * @var \ABB\ScssPhp\ScssPhp\Block|null
     */
    public $selfParent;

    public $cond;

    public $cases;

    public $name;

    public $args;

    public $vars;

    public $var;

    public $list;

    public $dontAppend;

    public $parentEnv;

    public $queryList;

    public $child;

    public $start;

    public $end;

    public $until;

    public $scope;

    public $value;
}
