<?php
use AliNext_Lite\AbstractController;
use AliNext_Lite\CommonSettingService;
use AliNext_Lite\Settings;
use function AliNext_Lite\get_setting;
// phpcs:ignoreFile WordPress.Security.EscapeOutput.OutputNotEscaped

/**
 * @var array $languages
 * @var array $aliexpressRegions
 * @var string $aliexpressRegion
 *
 * @var bool $isShopManagerAllowed
 * @var array $hiddenPages
 * @var array $menuPages
 */
?>

<form method="post">
<?php wp_nonce_field(AbstractController::PAGE_NONCE_ACTION, AbstractController::NONCE); ?>
<input type="hidden" name="setting_form" value="1"/>

<div class="panel panel-primary">
    <div class="panel-heading">
        <h3 class="display-inline"><?php _ex('Purchase Settings', 'Setting title', 'ali2woo'); ?></h3>
    </div>
    <div class="panel-body">
        
        <div class="a2wl_purchase_code_info" style="display:none">
            <div class="field field_inline">
                <div class="field__label">
                    <strong><?php  esc_html_e('Package', 'ali2woo');?></strong>
                    <div class="info-box" data-toggle="tooltip" data-title='<?php  esc_html_e('Information about the current package.', 'ali2woo');?>'></div>
                </div>
                <div class="field__input-wrap">
                    <div class="form-group input-block no-margin">
                        "<span class="tariff_name"></span>" package, <a href="<?php echo $upgradeTariffUrl; ?>" target="_blank"><?php  esc_html_e('change package.', 'ali2woo');?></a>
                    </div>
                    <div class="daily_limits form-group input-block no-margin"></div>
                    <div class="info-box" data-toggle="tooltip" data-title="<?php  esc_html_e('It shows the daily usage quota. It`s reset every day.', 'ali2woo');?>"></div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="panel panel-primary">
    <div class="panel-heading">
        <h3 class="display-inline"><?php _ex('Import Settings', 'Setting title', 'ali2woo'); ?></h3>
    </div>
    <div class="panel-body">

        <?php if (A2WL()->isAnPlugin()): ?>
            <div class="_a2wfo a2wl-info"><div>This feature is available in full version of the plugin.</div><a href="https://ali2woo.com/pricing/?utm_source=lite&utm_medium=lite_banner&utm_campaign=alinext-lite" target="_blank" class="btn">GET FULL VERSION</a></div>
            <div class="field field_inline _a2wfv">
                <div class="field__label">
                    <label>
                        <strong><?php _ex('Aliexpress region', 'Setting title', 'ali2woo'); ?></strong>
                    </label>
                    <div class="info-box"
                         data-toggle="tooltip"
                         data-title="<?php _ex("This feature enables you to select the AliExpress region for your website. It automatically adjusts the imported prices, stock levels, and shipping information based on the chosen region.", 'setting description', 'ali2woo'); ?>"
                    ></div>
                </div>
                <div class="field__input-wrap">
                    <select name="a2wl_aliexpress_region" id="a2wl_aliexpress_region" class="field__input form-control small-input">
                        <?php foreach ($aliexpressRegions as $regionCode => $text): ?>
                            <option value="<?php echo $regionCode; ?>" <?php if ($aliexpressRegion == $regionCode): ?>selected="selected"<?php endif;?>><?php echo $text; ?></option>
                        <?php endforeach;?>
                    </select>
                </div>
            </div>
        <?php endif; ?>

        <div class="field field_inline">
            <div class="field__label">
                <label>
                    <strong><?php _ex('Language', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex("It's applied to Product title, description, attributes and reviews", 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                <?php $cur_language = get_setting('import_language');?>
                <select name="a2w_import_language" id="a2w_import_language" class="field__input form-control small-input">
                <?php foreach ($languages as $code => $text): ?>
                    <option value="<?php echo $code; ?>" <?php if ($cur_language == $code): ?>selected="selected"<?php endif;?>><?php echo $text; ?></option>
                 <?php endforeach;?>
                </select>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label>
                    <strong><?php _ex('Currency', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex("Default currency that used on a product import", 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                    <?php $cur_a2w_local_currency = strtoupper(get_setting('local_currency'));?>
                    <select name="a2w_local_currency" id="a2w_local_currency" class="field__input form-control small-input">
                        <?php foreach ($currencies as $code => $name): ?><option value="<?php echo $code; ?>" <?php if ($cur_a2w_local_currency == $code): ?>selected="selected"<?php endif;?>><?php echo $name; ?></option><?php endforeach;?>
                        <?php if (!empty($custom_currencies)): ?>
                        <?php foreach ($custom_currencies as $code => $name): ?><option value="<?php echo $code; ?>" <?php if ($cur_a2w_local_currency == $code): ?>selected="selected"<?php endif;?>><?php echo $name; ?></option><?php endforeach;?>
                        <?php endif;?>
                    </select>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_default_product_type">
                    <strong><?php _ex('Default product type', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex("Default product type", 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                    <?php $default_product_type = get_setting('default_product_type');?>
                    <select name="a2wl_default_product_type" id="a2wl_default_product_type" class="field__input form-control small-input">
                        <option value="simple" <?php if ($default_product_type == "simple"): ?>selected="selected"<?php endif;?>><?php _ex('Simple/Variable Product', 'Setting option', 'ali2woo'); ?></option>
                        <option value="external" <?php if ($default_product_type == "external"): ?>selected="selected"<?php endif;?>><?php _ex('External/Affiliate Product', 'Setting option', 'ali2woo'); ?></option>
                    </select>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_default_product_status">
                    <strong><?php _ex('Default product status', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex("Default product type", 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                    <?php $default_product_status = get_setting('default_product_status');?>
                    <select name="a2wl_default_product_status" id="a2wl_default_product_status" class="field__input form-control small-input">
                        <option value="publish" <?php if ($default_product_status == "publish"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Publish');?></option>
                        <option value="draft" <?php if ($default_product_status == "draft"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Draft');?></option>
                    </select>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_not_import_attributes">
                    <strong><?php  esc_html_e('Not import specifications', 'ali2woo');?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php  esc_html_e('Not import specifications', 'ali2woo');?>"></div>
            </div>
            <div class="field__input-wrap">
                    <input type="checkbox" class="field__input form-control" id="a2wl_not_import_attributes" name="a2wl_not_import_attributes" value="yes" <?php if (get_setting('not_import_attributes')): ?>checked<?php endif;?>/>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_not_import_description">
                    <strong><?php  esc_html_e('Not import description', 'ali2woo');?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php  esc_html_e('Not import description', 'ali2woo');?>"></div>
            </div>
            <div class="field__input-wrap">
                    <input type="checkbox" class="field__input form-control" id="a2wl_not_import_description" name="a2wl_not_import_description" value="yes" <?php if (get_setting('not_import_description')): ?>checked<?php endif;?>/>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_not_import_description_images">
                    <strong><?php  esc_html_e("Don't import images from the description", 'ali2woo');?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php  esc_html_e("Don't import images from the description", 'ali2woo');?>"></div>
            </div>
            <div class="field__input-wrap">
                    <input type="checkbox" class="field__input form-control" id="a2wl_not_import_description_images" name="a2wl_not_import_description_images" value="yes" <?php if (get_setting('not_import_description_images')): ?>checked<?php endif;?>/>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_use_external_image_urls">
                    <strong><?php _ex('Use external image urls', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('Use external image urls', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                <div class="form-group input-block no-margin">
                    <input type="checkbox" class="field__input form-control" id="a2wl_use_external_image_urls" name="a2wl_use_external_image_urls" value="yes" <?php if (get_setting('use_external_image_urls')): ?>checked<?php endif;?>/>
                </div>
                <div id="a2wl_load_external_image_block" class="form-group input-block no-margin" <?php if (get_setting('use_external_image_urls')): ?>style="display: none;"<?php endif;?>>
                    <input class="btn btn-default load-images" disabled="disabled" type="button" value="<?php  esc_html_e('Load images', 'ali2woo');?>"/>
                    <div id="a2wl_load_external_image_progress"></div>
                </div>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_use_random_stock">
                    <strong><?php _ex('Use random stock value', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('Use random stock value', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                <div class="form-group input-block no-margin">
                    <input type="checkbox" class="field__input form-control" id="a2wl_use_random_stock" name="a2wl_use_random_stock" value="yes" <?php if (get_setting('use_random_stock')): ?>checked<?php endif;?>/>
                </div>
                <div id="a2wl_use_random_stock_block" class="field__fill form-group input-block no-margin" <?php if (!get_setting('use_random_stock')): ?>style="display: none;"<?php endif;?>>
                    <?php  esc_html_e('From', 'ali2woo');?> <input type="text" style="max-width: 60px;" class="field__input form-control" id="a2wl_use_random_stock_min" name="a2wl_use_random_stock_min" value="<?php echo esc_attr(get_setting('use_random_stock_min')); ?>">
                    <?php  esc_html_e('To', 'ali2woo');?> <input type="text" style="max-width: 60px;" class="field__input form-control" id="a2wl_use_random_stock_max" name="a2wl_use_random_stock_max" value="<?php echo esc_attr(get_setting('use_random_stock_max')); ?>">
                </div>
            </div>
        </div>
        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_background_import">
                    <strong><?php _ex('Import in the background', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('Products will be imported in the background mode, make sure you CRON is enabled.', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                <input type="checkbox" class="field__input form-control" id="a2wl_background_import" name="a2wl_background_import" value="yes" <?php if (get_setting('background_import')): ?>checked<?php endif;?>/>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_allow_product_duplication">
                    <strong><?php _ex('Allow product duplication', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('Allow the import of an already imported product. This can be useful when you want to overload a product with the same product.', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                    <input type="checkbox" class="field__input form-control" id="a2wl_allow_product_duplication" name="a2wl_allow_product_duplication" value="yes" <?php if (get_setting('allow_product_duplication')): ?>checked<?php endif;?>/>
            </div>
        </div>



        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_convert_attr_case">
                    <strong><?php _ex('Convert case of attributes and their values', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('Products may come with different text case of attributes and their values. ', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                <div class="form-group input-block no-margin">
                    <?php $convert_attr_case = get_setting('convert_attr_case');?>
                    <select name="a2wl_convert_attr_case" id="a2wl_convert_attr_case" class="field__input form-control small-input">
                        <option value="original" <?php if ($convert_attr_case == "original"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Keep original case');?></option>
                        <option value="lower" <?php if ($convert_attr_case == "lower"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Lower case');?></option>
                        <option value="sentence" <?php if ($convert_attr_case == "sentence"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Sentence case');?></option>
                    </select>
                </div>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_remove_ship_from">
                    <strong><?php _ex('Remove "Ship From" attribute', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('Remove Ship from attribute during product import.', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                <div class="form-group input-block no-margin">
                    <input type="checkbox" class="field__input form-control" id="a2wl_remove_ship_from" name="a2wl_remove_ship_from" value="yes" <?php if (get_setting('remove_ship_from')): ?>checked<?php endif;?>/>
                </div>
            </div>
        </div>

        <div id="a2wl_remove_ship_from_block" class="field field_inline" <?php if (!get_setting('remove_ship_from')): ?>style="display: none;"<?php endif;?>>
            <div class="field__label">
                <label for="a2wl_default_ship_from">
                    <strong><?php _ex('Default "Ship From" country', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('Only product variations that contain Ship from selected country will be imported.', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">

                    <?php $cur_a2wl_default_ship_from = get_setting('default_ship_from');?>
                    <select name="a2wl_default_ship_from" id="a2wl_default_ship_from" class="field__input form-control small-input country_list">
                        <option value=""><?php  esc_html_e('N/A', 'ali2woo');?></option>
                        <?php foreach ($shipping_countries as $code => $country): ?>
                            <option value="<?php echo $code; ?>"<?php if ($cur_a2wl_default_ship_from == $code): ?> selected<?php endif;?>>
                                <?php echo $country; ?>
                            </option>
                        <?php endforeach;?>
                    </select>
                    <div class="field__fill input-block"><?php _ex('Note! If the "Ship From" attribute does not contain the selected country, then China will be used as the "Ship from" country.', 'setting description', 'ali2woo'); ?></div>
            </div>
        </div>
    </div>
</div>

<div class="panel panel-primary">
    <div class="panel-heading">
        <h3 class="display-inline"><?php _ex('Order Fulfillment settings', 'Setting title', 'ali2woo'); ?></h3>
    </div>
    <div class="panel-body">
        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_delivered_order_status">
                    <strong><?php _ex('Delivered Order Status', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex("Change order status when all order items have been delivered.", 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                    <?php $delivered_order_status = get_setting('delivered_order_status');?>
                    <select name="a2wl_delivered_order_status" id="a2wl_delivered_order_status" class="field__input form-control small-input">
                        <option value=""><?php _ex('Do nothing', 'Setting option', 'ali2woo'); ?></option>
                        <?php foreach ($order_statuses as $os_key => $os_value): ?>
                        <option value="<?php echo $os_key; ?>" <?php if ($delivered_order_status == $os_key): ?>selected="selected"<?php endif;?>><?php echo $os_value; ?></option>
                        <?php endforeach;?>
                    </select>
            </div>
        </div>

          <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_tracking_code_order_status">
                    <strong><?php _ex('Shipped Order Status', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex("Change order status when all order items have been shipped.", 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                    <?php $tracking_code_order_status = get_setting('tracking_code_order_status');?>
                    <select name="a2wl_tracking_code_order_status" id="a2wl_tracking_code_order_status" class="field__input form-control small-input">
                        <option value=""><?php _ex('Do nothing', 'Setting option', 'ali2woo'); ?></option>
                        <?php foreach ($order_statuses as $os_key => $os_value): ?>
                        <option value="<?php echo $os_key; ?>" <?php if ($tracking_code_order_status == $os_key): ?>selected="selected"<?php endif;?>><?php echo $os_value; ?></option>
                        <?php endforeach;?>
                    </select>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_placed_order_status">
                    <strong><?php _ex('Placed Order Status', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex("Change order status when order is placed with the Chrome extension", 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                    <?php $placed_order_status = get_setting('placed_order_status');?>
                    <select name="a2wl_placed_order_status" id="a2wl_placed_order_status" class="field__input form-control small-input">
                        <option value=""><?php _ex('Do nothing', 'Setting option', 'ali2woo'); ?></option>
                        <?php foreach ($order_statuses as $os_key => $os_value): ?>
                        <option value="<?php echo $os_key; ?>" <?php if ($placed_order_status == $os_key): ?>selected="selected"<?php endif;?>><?php echo $os_value; ?></option>
                        <?php endforeach;?>
                    </select>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label>
                    <strong><?php _ex('Default shipping method', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('If the option is available, the plugin will automatically select this shipping method during the order fulfillment process. If not, it will either choose the shipping method selected by the user or the cheapest available option.', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                <?php $cur_a2w_fulfillment_prefship = get_setting('fulfillment_prefship', 'CAINIAO_PREMIUM');?>
                <select name="a2w_fulfillment_prefship" id="a2w_fulfillment_prefship" class="field__input form-control small-input" >
                    <option value="" <?php if ($cur_a2w_fulfillment_prefship === ""): ?>selected="selected"<?php endif;?>>Default (not override)</option>
                    <?php foreach ($shipping_options as $shipping_option): ?>
                        <option value="<?php echo $shipping_option['value'] ?>"<?php if ($cur_a2w_fulfillment_prefship === $shipping_option['value']): ?> selected<?php endif;?>>
                            <?php echo $shipping_option['label']; ?>
                        </option>
                    <?php endforeach;?>
                </select>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label>
                    <strong><?php _ex('Override phone number', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('This will be used instead of a customer phone number.', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                <div class="field__input form-group input-block no-margin">
                    <input type="text" placeholder="code" style="max-width: 60px;" class="field__input form-control" id="a2wl_fulfillment_phone_code" maxlength="5" name="a2wl_fulfillment_phone_code" value="<?php echo esc_attr(get_setting('fulfillment_phone_code')); ?>" />
                    <input type="text" placeholder="phone" class="field__input form-control small-input" id="a2wl_fulfillment_phone_number" maxlength="16" name="a2wl_fulfillment_phone_number" value="<?php echo esc_attr(get_setting('fulfillment_phone_number')); ?>" />
                </div>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label>
                    <strong><?php _ex('CPF meta field', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex("The order meta field that a 3rd party plugin uses to store customer's CPF field.This is used only for Customers from Brazil. If empty, billing company will be used as CPF when fulfilling AliExpress orders.", 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                    <input type="text" placeholder="" class="field__input form-control small-input" id="a2wl_fulfillment_cpf_meta_key" name="a2wl_fulfillment_cpf_meta_key" value="<?php echo esc_attr(get_setting('fulfillment_cpf_meta_key')); ?>" />
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label>
                    <strong><?php _ex('RUT meta field', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex("The order meta field that a 3rd party plugin uses to store customer's RUT number. RUT number is required when you fulfill orders of Customers from Chile.", 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                    <input type="text" placeholder="" class="field__input form-control small-input" id="a2wl_fulfillment_rut_meta_key" name="a2wl_fulfillment_rut_meta_key" value="<?php echo esc_attr(get_setting('fulfillment_rut_meta_key')); ?>" />
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label>
                    <strong><?php _ex('Custom note', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('A note to the supplier on the Aliexpress checkout page.', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                    <textarea placeholder="<?php  esc_html_e('note for aliexpress order', 'ali2woo');?>" maxlength="1000" rows="5" class="field__input form-control" id="a2wl_fulfillment_custom_note" name="a2wl_fulfillment_custom_note" cols="50"><?php echo esc_attr(get_setting('fulfillment_custom_note')); ?></textarea>
            </div>
        </div>

        <?php $a2wl_order_translitirate = get_setting('order_translitirate');?>
        <div class="field field_inline">
            <div class="field__label">
                <label>
                    <strong><?php _ex('Transliteration', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('Enable the auto-transliteration for AliExpress order details.', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                    <input type="checkbox" class="field__input form-control" id="a2wl_order_translitirate" name="a2wl_order_translitirate" value="yes" <?php if ($a2wl_order_translitirate): ?>checked<?php endif;?>/>
            </div>
        </div>
        <?php $a2wl_order_third_name = get_setting('order_third_name');?>
        <div class="field field_inline">
            <div class="field__label">
                <label>
                    <strong><?php _ex('Middle name field', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('Adds the Middle name field to WooCommerce checkout page and then uses it during an order-fulfillment process on AliExpress.', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                <input type="checkbox" class="field__input form-control" id="a2wl_order_third_name" name="a2wl_order_third_name" value="yes" <?php if ($a2wl_order_third_name): ?>checked<?php endif;?>/>
            </div>
        </div>
    </div>
</div>

<div class="panel panel-primary">
    <div class="panel-heading">
        <h3 class="display-inline"><?php _ex('Schedule settings', 'Setting title', 'ali2woo'); ?></h3>
    </div>
    <div class="_a2wfo a2wl-info"><div>This feature is available in full version of the plugin.</div><a href="https://ali2woo.com/pricing/?utm_source=lite&utm_medium=lite_banner&utm_campaign=alinext-lite" target="_blank" class="btn">GET FULL VERSION</a></div>
    <div class="panel-body _a2wfv">

        <?php $a2wl_auto_update = get_setting('auto_update');?>
        <div class="field field_inline">
            <div class="field__label">
                <label>
                    <strong><?php _ex('Aliexpress Sync', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('Enable auto-update features', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                <div class="form-group input-block no-margin">
                    <input type="checkbox" class="field__input form-control" id="a2wl_auto_update" name="a2wl_auto_update" value="yes" <?php if ($a2wl_auto_update): ?>checked<?php endif;?>/>
                </div>
            </div>
        </div>
        <?php if (A2WL()->isAnPlugin()): ?>
        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_auto_update_max_quota">
                    <strong><?php esc_html_e('Max Auto-Update Quota', 'ali2woo');?></strong>
                </label>
                <div class="info-box"
                     data-toggle="tooltip"
                     data-title="<?php esc_html_e('This setting allows you to define the maximum percentage of your daily operation limit that can be allocated to the plugin`s auto-update processes.', 'ali2woo');?>"
                ></div>
            </div>
            <div class="field__input-wrap">
                <?php $autoUpdateMaxQuota = get_setting(Settings::SETTING_AUTO_UPDATE_MAX_QUOTA);?>
                <select class="field__input form-control small-input"
                        name="a2wl_auto_update_max_quota"
                        id="a2wl_auto_update_max_quota" <?php if (!$a2wl_auto_update): ?>disabled<?php endif;?>>

                    <option value="25" <?php if ($autoUpdateMaxQuota === 25): ?>selected="selected"<?php endif;?>>
                        <?php esc_html_e('Small portion - 25%', 'ali2woo');?>
                    </option>
                    <option value="50" <?php if ($autoUpdateMaxQuota === 50): ?>selected="selected"<?php endif;?>>
                        <?php esc_html_e('Half - 50%', 'ali2woo');?>
                    </option>
                    <option value="75" <?php if ($autoUpdateMaxQuota === 75): ?>selected="selected"<?php endif;?>>
                        <?php esc_html_e('Default - 75%', 'ali2woo');?>
                    </option>
                    <option value="100" <?php if ($autoUpdateMaxQuota === 100): ?>selected="selected"<?php endif;?>>
                        <?php esc_html_e('All - 100%', 'ali2woo');?>
                    </option>
                </select>
            </div>
        </div>
        <?php endif; ?>
        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_on_not_available_product">
                    <strong><?php esc_html_e('When product is no longer available', 'ali2woo');?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php  esc_html_e('Choose an action when one of your products is no longer available from Aliexpress. Applies to all existing products.', 'ali2woo');?>"></div>
            </div>
            <div class="field__input-wrap">
                    <?php $on_not_available_product = get_setting('on_not_available_product');?>
                    <select class="field__input form-control small-input" name="a2wl_on_not_available_product" id="a2wl_on_not_available_product" <?php if (!$a2wl_auto_update): ?>disabled<?php endif;?>>
                        <option value="nothing" <?php if ($on_not_available_product == "nothing"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Do Nothing', 'ali2woo');?></option>
                        <option value="trash" <?php if ($on_not_available_product == "trash"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Move to trash', 'ali2woo');?></option>
                        <option value="zero" <?php if ($on_not_available_product == "zero"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Set Quantity To Zero', 'ali2woo');?></option>
                    </select>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_on_not_available_variation">
                    <strong><?php esc_html_e('When variant is no longer available', 'ali2woo');?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php  esc_html_e('Choose an action when one of the product’s variants is no longer available from Aliexpress.', 'ali2woo');?>"></div>
            </div>
            <div class="field__input-wrap">
                    <?php $on_not_available_variation = get_setting('on_not_available_variation');?>
                    <select class="field__input form-control small-input" name="a2wl_on_not_available_variation" id="a2wl_on_not_available_variation" <?php if (!$a2wl_auto_update): ?>disabled<?php endif;?>>
                        <option value="nothing" <?php if ($on_not_available_variation == "nothing"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Do Nothing', 'ali2woo');?></option>
                        <option value="trash" <?php if ($on_not_available_variation == "trash"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Remove variant', 'ali2woo');?></option>
                        <option value="zero" <?php if ($on_not_available_variation == "zero"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Set Quantity To Zero', 'ali2woo');?></option>
                        <option value="zero_and_disable" <?php if ($on_not_available_variation == "zero_and_disable"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Set Quantity To Zero and Disable', 'ali2woo');?></option>
                    </select>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_on_new_variation_appearance">
                    <strong><?php esc_html_e('When a new variant has appeared', 'ali2woo');?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php esc_html_e('Choose an action when new of the product’s variants is an appearance on Aliexpress.', 'ali2woo');?>"></div>
            </div>
            <div class="field__input-wrap">
                    <?php $on_new_variation_appearance = get_setting('on_new_variation_appearance');?>
                    <select class="field__input form-control small-input" name="a2wl_on_new_variation_appearance" id="a2wl_on_new_variation_appearance" <?php if (!$a2wl_auto_update): ?>disabled<?php endif;?>>
                        <option value="nothing" <?php if ($on_new_variation_appearance == "nothing"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Do Nothing', 'ali2woo');?></option>
                        <option value="add" <?php if ($on_new_variation_appearance == "add"): ?>selected="selected"<?php endif;?>><?php  esc_html_e('Add variant', 'ali2woo');?></option>
                    </select>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_on_price_changes">
                    <strong><?php esc_html_e('When the price changes', 'ali2woo');?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php  esc_html_e('Choose an action when the price of your product changes.', 'ali2woo');?>"></div>
            </div>
            <div class="field__input-wrap">
                    <?php $on_price_changes = get_setting('on_price_changes');?>
                    <select class="field__input form-control small-input" name="a2wl_on_price_changes" id="a2wl_on_price_changes" <?php if (!$a2wl_auto_update): ?>disabled<?php endif;?>>
                        <option value="nothing" <?php if ($on_price_changes == "nothing"): ?>selected="selected"<?php endif;?>><?php esc_html_e('Do Nothing', 'ali2woo');?></option>
                        <option value="update" <?php if ($on_price_changes == "update"): ?>selected="selected"<?php endif;?>><?php esc_html_e('Update price', 'ali2woo');?></option>
                    </select>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label"> 
                <label for="a2wl_on_stock_changes">
                    <strong><?php esc_html_e('When inventory changes', 'ali2woo');?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php  esc_html_e('Choose an action when the inventory level of a particular product changes.', 'ali2woo');?>"></div>
            </div>
            <div class="field__input-wrap">
                    <?php $on_stock_changes = get_setting('on_stock_changes');?>
                    <select class="field__input form-control small-input" name="a2wl_on_stock_changes" id="a2wl_on_stock_changes" <?php if (!$a2wl_auto_update): ?>disabled<?php endif;?>>
                        <option value="nothing" <?php if ($on_stock_changes == "nothing"): ?>selected="selected"<?php endif;?>><?php esc_html_e('Do Nothing', 'ali2woo');?></option>
                        <option value="update" <?php if ($on_stock_changes == "update"): ?>selected="selected"<?php endif;?>><?php esc_html_e('Update automatically', 'ali2woo');?></option>
                    </select>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_untrash_product">
                    <strong><?php _ex('Restore products from the trash', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('Enable restore products from the trash during the sync process.', 'setting description', 'ali2woo'); ?>"></div>

            </div>
            <div class="field__input-wrap">
                    <?php $a2wl_untrash_product = get_setting('untrash_product');?>
                    <input type="checkbox" class="field__input form-control" id="a2wl_untrash_product" name="a2wl_untrash_product" value="yes" <?php if ($a2wl_untrash_product): ?>checked<?php endif;?> <?php if (!$a2wl_auto_update): ?>disabled<?php endif;?>/>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label for="a2wl_email_alerts">
                    <strong><?php _ex('Send email alerts', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title="<?php _ex('Enable email notifications about product changes (every 30 minutes). It watches for product price change, stock change, and monitors new product variant appearance. ', 'setting description', 'ali2woo'); ?>"></div>
            </div>
            <div class="field__input-wrap">
                    <?php $a2wl_email_alerts = get_setting('email_alerts');?>
                    <input type="checkbox" class="field__input form-control" id="a2wl_email_alerts" name="a2wl_email_alerts" value="yes" <?php if ($a2wl_email_alerts): ?>checked<?php endif;?> <?php if (!$a2wl_auto_update): ?>disabled<?php endif;?>/>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label>
                    <strong><?php _ex('Email address', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box" data-toggle="tooltip" data-title='Input the email address you want to receive the notification emails on.'></div>
            </div>
            <div class="field__input-wrap">
                    <input type="email" class="field__input form-control small-input" id="a2wl_email_alerts_email" name="a2wl_email_alerts_email" value="<?php echo esc_attr(get_setting('email_alerts_email')); ?>" required <?php if (!$a2wl_email_alerts): ?>disabled<?php endif;?> />
            </div>
        </div>

    </div>
</div>

<?php if (A2WL()->isAnPlugin()): ?>
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="display-inline"><?php echo esc_html_x('Access Control', 'setting section', 'ali2woo'); ?></h3>
    </div>
    <div class="_a2wfo a2wl-info"><div>This feature is available in full version of the plugin.</div><a href="https://ali2woo.com/pricing/?utm_source=lite&utm_medium=lite_banner&utm_campaign=alinext-lite" target="_blank" class="btn">GET FULL VERSION</a></div>
    <div class="panel-body _a2wfv">

        <div class="row">
            <div class="col-md-12">
                <div class="row-comments text-muted" style="margin-bottom: 20px;">
                    <i class="dashicons dashicons-lock" style="margin-right: 5px; vertical-align: middle;"></i>
                    <?php echo esc_html_x(
                        'By default, only Administrators can access the plugin. Use the options below to allow Shop Managers and control which sections are visible for that role.',
                        'access control panel description',
                        'ali2woo'
                    ); ?>
                </div>
            </div>
        </div>

        <div class="field field_inline">
            <div class="field__label">
                <label>
                    <strong><?php echo esc_html_x('Allow Shop Manager', 'Setting title', 'ali2woo'); ?></strong>
                </label>
                <div class="info-box"
                     data-toggle="tooltip"
                     data-title="<?php echo esc_html_x('Allow Shop Manager role to access AliNext (Lite version) plugin', 'setting description', 'ali2woo'); ?>">
                </div>
            </div>
            <div class="field__input-wrap">
                <div class="form-group input-block no-margin">
                    <input type="checkbox"
                           class="field__input form-control"
                           id="<?php echo esc_attr(CommonSettingService::PARAM_ALLOW_SHOP_MANAGER); ?>"
                           name="<?php echo esc_attr(CommonSettingService::PARAM_ALLOW_SHOP_MANAGER); ?>"
                           value="yes"
                        <?php checked($isShopManagerAllowed); ?> />
                </div>
            </div>
        </div>

        <div class="field field_default field_inline"
             data-a2wl-hidden-section
             style="margin-top: 30px;">
            <label class="field__label">
                <?php echo esc_html_x('Hidden Sections (non-admin)', 'Setting title', 'ali2woo'); ?>
                <div class="info-box"
                     data-toggle="tooltip"
                     data-title="<?php echo esc_html_x('Choose sections to hide from non-admin users (admins always see all).', 'setting description', 'ali2woo'); ?>">

                </div>
            </label>
            <div class="field__input-wrap">
                <div class="grid grid_3">
                    <?php foreach ($menuPages as $slug => $label): ?>
                        <div class="grid__col">
                            <label>
                                <input type="checkbox" class="field__input"
                                       name="<?php echo esc_attr(CommonSettingService::PARAM_HIDDEN_PAGES);?>[]"
                                       value="<?php echo esc_attr($slug); ?>"
                                    <?php checked(in_array($slug, $hiddenPages)); ?> />
                                <?php echo esc_html($label); ?>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

    </div>
</div>
<?php endif; ?>

<div class="container-fluid">
    <div class="row pt20 border-top">
        <div class="col-sm-12">
            <input class="btn btn-success js-main-submit" type="submit" value="<?php esc_html_e('Save settings', 'ali2woo');?>"/>
        </div>
    </div>
</div>

</form>

<script>
window.A2W = window.A2W || {};
A2W.AdminSettings = A2W.AdminSettings || {};

A2W.AdminSettings.toggleAccessControl = function () {
    const $checkbox = jQuery("#a2wl_allow_shop_manager");
    const $hiddenSection = jQuery("[data-a2wl-hidden-section]");
    const $inputs = $hiddenSection.find("input[name^='a2wl_hidden_pages']");

    const enabled = $checkbox.is(':checked');
    $inputs.prop('disabled', !enabled);
    $hiddenSection.toggleClass('a2wl-disabled', !enabled);
};

function a2wl_isInt(value) {
    return !isNaN(value) &&
            parseInt(Number(value)) == value &&
            !isNaN(parseInt(value, 10));
}

function handleAllowShopManagerLogic() {
    const $checkbox = $("#a2wl_allow_shop_manager");
    const $hiddenSection = $("[data-a2wl-hidden-section]");
    const $inputs = $hiddenSection.find("input[name^='a2wl_hidden_pages']");

    const enabled = $checkbox.is(':checked');
    $inputs.prop('disabled', !enabled);

    $hiddenSection.toggleClass('a2wl-disabled', !enabled);

    // Toggle title for hover tooltip
    if (!enabled) {
        $hiddenSection.attr('title', 'Access disabled until Shop Manager is allowed');
    } else {
        $hiddenSection.removeAttr('title');
    }
}

(function ($) {
    let ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
    let nonce_action = '<?php echo wp_create_nonce(AbstractController::AJAX_NONCE_ACTION); ?>';


    $(".a2wl-visible-switch").on("click", function () {
        let inputField = $("#a2wl_item_purchase_code");
        let toggleIcon = $(this);

        if (inputField.attr("type") === "password") {
            inputField.attr("type", "text");
            toggleIcon.removeClass("dashicons-hidden").addClass("dashicons-visibility");
        } else {
            inputField.attr("type", "password");
            toggleIcon.removeClass("dashicons-visibility").addClass("dashicons-hidden");
        }
    });


    $("#a2w_local_currency").select2();
    $("#a2w_import_language").select2();
    $("#a2w_fulfillment_prefship").select2();

    if($.fn.tooltip) { $('[data-toggle="tooltip"]').tooltip({"placement": "top"}); }

    jQuery("#a2wl_auto_update").on('change', function () {
        <?php if (A2WL()->isAnPlugin()): ?>
        jQuery("#a2wl_auto_update_max_quota").prop('disabled', !jQuery(this).is(':checked'));
        <?php endif; ?>
        jQuery("#a2wl_on_not_available_product").prop('disabled', !jQuery(this).is(':checked'));
        jQuery("#a2wl_on_not_available_variation").prop('disabled', !jQuery(this).is(':checked'));
        jQuery("#a2wl_on_new_variation_appearance").prop('disabled', !jQuery(this).is(':checked'));
        jQuery("#a2wl_on_price_changes").prop('disabled', !jQuery(this).is(':checked'));
        jQuery("#a2wl_on_stock_changes").prop('disabled', !jQuery(this).is(':checked'));
        jQuery("#a2wl_untrash_product").prop('disabled', !jQuery(this).is(':checked'));
        jQuery("#a2wl_email_alerts").prop('disabled', !jQuery(this).is(':checked'));
    });

    $("#a2wl_allow_shop_manager").on('change', function() {
        A2W.AdminSettings.toggleAccessControl();
    });
    A2W.AdminSettings.toggleAccessControl();


    jQuery("#a2wl_email_alerts").on('change', function () {
        jQuery("#a2wl_email_alerts_email").prop('disabled', !jQuery(this).is(':checked'));
    });

    jQuery("#a2wl_use_random_stock").on('change', function () {
        jQuery("#a2wl_use_random_stock_block").toggle();
    });

    jQuery("#a2wl_remove_ship_from").on('change', function () {
        jQuery("#a2wl_remove_ship_from_block").toggle();
    });

    var a2wl_import_product_images_limit_keyup_timer = false;

    $('#a2wl_import_product_images_limit').on('keyup', function () {
        if (a2wl_import_product_images_limit_keyup_timer) {
            clearTimeout(a2wl_import_product_images_limit_keyup_timer);
        }

        var this_el = $(this);

        this_el.parents('.form-group').removeClass('has-error');
        if (this_el.parents('.form-group').children('span').length > 0)
            this_el.parents('.form-group').children('span').remove();

        a2wl_import_product_images_limit_keyup_timer = setTimeout(function () {
            if (!a2wl_isInt(this_el.val()) || this_el.val() < 0) {
                this_el.after("<span class='help-block'><?php esc_html_e('Please enter a integer greater than or equal to 0', 'ali2woo');?></span>");
                this_el.parents('.form-group').addClass('has-error');
            }

        }, 1000);
    });

    var a2wl_fulfillment_phone_code_keyup_timer = false;

    $('#a2wl_fulfillment_phone_code').on('keyup', function () {

        if (a2wl_fulfillment_phone_code_keyup_timer) {
            clearTimeout(a2wl_fulfillment_phone_code_keyup_timer);
        }

        var this_el = $(this);

        this_el.removeClass('has-error');
        this_el.parents('.form-group').removeClass('has-error');
        if (this_el.parents('.form-group').children('span').length > 0)
            this_el.parents('.form-group').children('span').remove();

        a2wl_fulfillment_phone_code_keyup_timer = setTimeout(function () {
            if (this_el.val() != '' && (!a2wl_isInt(this_el.val()) || this_el.val().length < 1 || this_el.val().length > 5)) {
                this_el.parents('.form-group').append("<span class='help-block'><?php  esc_html_e('Please enter Numbers. Between 1 - 5 characters.', 'ali2woo');?></span>");
                this_el.addClass('has-error');
                this_el.parents('.form-group').addClass('has-error');
            }

        }, 1000);

        //$(this).removeClass('error_input');
    });

    var a2wl_fulfillment_phone_number_keyup_timer = false;

    $('#a2wl_fulfillment_phone_number').on('keyup', function () {

        if (a2wl_fulfillment_phone_number_keyup_timer) {
            clearTimeout(a2wl_fulfillment_phone_number_keyup_timer);
        }

        var this_el = $(this);

        this_el.removeClass('has-error');
        this_el.parents('.form-group').removeClass('has-error');
        if (this_el.parents('.form-group').children('span').length > 0)
            this_el.parents('.form-group').children('span').remove();

        a2wl_fulfillment_phone_number_keyup_timer = setTimeout(function () {
            if (this_el.val() != '' && (!a2wl_isInt(this_el.val()) || this_el.val().length < 5 || this_el.val().length > 16)) {
                this_el.parents('.form-group').append("<span class='help-block'><?php  esc_html_e('Please enter Numbers. Between 5 - 16 characters.', 'ali2woo');?></span>");
                this_el.addClass('has-error');
                this_el.parents('.form-group').addClass('has-error');
            }

        }, 1000);

        //$(this).removeClass('error_input');
    });

    //form submit
    $('.a2wl-content form').on('submit', function () {
        if ($(this).find('.has-error').length > 0)
            return false;
    })
    
        $.post(ajaxurl, {
            action: 'a2wl_purchase_code_info',
            ali2woo_nonce: nonce_action,
        }).done(function (response) {
            let json = JSON.parse(response);
            if (json.state !== 'ok') {
                console.log(json);
            } else {
                const pluginName = '<?php echo A2WL()->plugin_name; ?>';
                const reviews_count = json.count.reviews ? json.count.reviews : 0;
                const reviews_limit = json.limits.reviews ? json.limits.reviews : 0;
                const category_count = json.count.category ? json.count.category : 0;
                const category_limit = json.limits.category ? json.limits.category : 0;

                $('.a2wl_purchase_code_info .supported_until').text(json.supported_until);
                $('.a2wl_purchase_code_info .tariff_name').text(json.tariff_name);

                if (pluginName.includes('alinext-lite')) {
                    const product_count = json.count.product?json.count.product:0
                    const product_limit = json.limits.product?json.limits.product:0

                    const search_count = json.count.products?json.count.products:0
                    const search_limit = json.limits.products?json.limits.products:0

                    const description_count = json.count.description?json.count.description:0
                    const description_limit = json.limits.description?json.limits.description:0

                    const shipping_count = json.count.shipping?json.count.shipping:0
                    const shipping_limit = json.limits.shipping?json.limits.shipping:0

                    const orders_count = json.count.orders?json.count.orders:0
                    const orders_limit = json.limits.orders?json.limits.orders:0

                    const all_count = search_count + product_count + description_count + reviews_count + shipping_count + orders_count;
                    const all_limit = json.limits.all?json.limits.all:0
                    const remaining_limit = all_limit - all_count;

                    $('.a2wl_purchase_code_info .daily_limits').html('<?php  esc_html_e('Daily limits', 'ali2woo');?>: '+
                        '<span'+(all_count/all_limit > 0.9?' class="warn"':'')+'>total ('+all_count+'/'+all_limit+')</span>, '+
                        '<span'+(search_count/search_limit > 0.9?' class="warn"':'')+'>searches ('+search_count+'/'+remaining_limit+')</span>, '+
                        '<span'+(product_count/product_limit > 0.9?' class="warn"':'')+'>products ('+product_count+'/'+remaining_limit+')</span>, '+
                        '<span'+(description_count/description_limit > 0.9?' class="warn"':'')+'>descriptions ('+description_count+'/'+remaining_limit+')</span>, '+
                        '<span'+(reviews_count/reviews_limit > 0.9?' class="warn"':'')+'>reviews ('+reviews_count+'/'+reviews_limit+')</span>, '+
                        '<span'+(category_count/category_limit > 0.9?' class="warn"':'')+'>categories ('+category_count+'/'+category_limit+')</span>, '+
                        '<span'+(shipping_count/shipping_limit > 0.9?' class="warn"':'')+'>shipping ('+shipping_count+'/'+shipping_limit+')</span>, '+
                        '<span'+(orders_count/orders_limit > 0.9?' class="warn"':'')+'>orders ('+orders_count+'/'+orders_limit+')</span>'
                    )
                } else {
                    $('.a2wl_purchase_code_info .daily_limits').html('<?php  esc_html_e('Daily limits', 'ali2woo');?>: '+
                        '<span'+(reviews_count/reviews_limit > 0.9?' class="warn"':'')+'>reviews ('+reviews_count+'/'+reviews_limit+')</span>')
                }

                $('.a2wl_purchase_code_info').show()
            }
        }).fail(function (xhr, status, error) {
            console.log(error);
        });
        
})(jQuery);


</script>
