<?php
// phpcs:ignoreFile WordPress.Security.NonceVerification.Recommended
namespace AliNext_Lite;;

/*
Controller name: Core
Controller description: Basic introspection methods
 */

use Exception;

class JSON_API_Core_Controller
{

    protected GlobalSystemMessageService $GlobalSystemMessageService;
    protected ProductImport $ProductImportModel;
    protected Woocommerce $WoocommerceModel;
    protected ProductService $ProductService;
    protected Aliexpress $AliexpressModel;
    protected PriceFormulaService $PriceFormulaService;
    protected ProductImportTransactionService $ProductImportTransactionService;
    protected PurchaseCodeInfoService $PurchaseCodeInfoService;

    public function __construct(
        GlobalSystemMessageService $GlobalSystemMessageService,
        ProductImport $ProductImportModel,
        Woocommerce $WoocommerceModel,
        ProductService $ProductService,
        Aliexpress $AliexpressModel,
        PriceFormulaService $PriceFormulaService,
        ProductImportTransactionService $ProductImportTransactionService,
        PurchaseCodeInfoService $PurchaseCodeInfoService
    ) {

        $this->GlobalSystemMessageService = $GlobalSystemMessageService;
        $this->ProductImportModel = $ProductImportModel;
        $this->WoocommerceModel = $WoocommerceModel;
        $this->ProductService = $ProductService;
        $this->AliexpressModel = $AliexpressModel;
        $this->PriceFormulaService = $PriceFormulaService;
        $this->ProductImportTransactionService = $ProductImportTransactionService;
        $this->PurchaseCodeInfoService = $PurchaseCodeInfoService;

        //todo: perhaps it would be better to move this call to some other controller
        $this->GlobalSystemMessageService->clear();
    }

    public function permissions($method)
    {
        global $a2wl_json_api;
        $protected_methods = array('add_product', 'upd_product', 'del_product', 'get_products', 'get_products_info', 'upd_order', 'get_settings', 'get_orders', 'update_tracking_data');
        if (in_array($method, $protected_methods)) {
            $a2wl_key = $a2wl_json_api->query->get('a2w-key');
            if (!empty($a2wl_key)) {
                // new auth method
                return $a2wl_json_api->query->is_valid_api_key($a2wl_key);
            } else {
                // old auth method
                if ($a2wl_json_api->query->cookie && wp_validate_auth_cookie($a2wl_json_api->query->cookie, 'logged_in')) {
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public function info()
    {
        global $a2wl_json_api;
        if (!empty($a2wl_json_api->query->controller)) {
            return $a2wl_json_api->controller_info($a2wl_json_api->query->controller);
        } else {
            $active_controllers = explode(',', get_setting('json_api_controllers'));
            $controllers = array_intersect($a2wl_json_api->get_controllers(), $active_controllers);
            return array(
                'json_api_version' => A2WL_JSON_API_VERSION,
                'controllers' => array_values($controllers),
            );
        }
    }

    public function add_product()
    {
        /**
         * @var JSON_API $a2wl_json_api
         */
        global $a2wl_json_api;
        $result = [];


        $externalId = isset($_REQUEST['id']) ? sanitize_text_field($_REQUEST['id']) : null;

        if (!$externalId) {
            $a2wl_json_api->error("No ID specified. Include 'id' var in your request.");
        }

        $apdRaw = isset($_REQUEST['apd']) ? sanitize_text_field($_REQUEST['apd']) : '';

        $Product = [
            ImportedProductService::FIELD_EXTERNAL_PRODUCT_ID => $externalId
        ];

        $apd = !empty($apdRaw)
            ? ['data' => ['apd' => json_decode(stripslashes($apdRaw))]]
            : [];

        a2wl_init_error_handler();
        try {
            $result = $this->ProductImportTransactionService->executeWithProductData($Product, $apd);
            restore_error_handler();
        }
        catch (Exception $Exception) {
            $a2wl_json_api->error($Exception->getMessage());
        }


        return $result;
    }

    public function upd_product()
    {
        global $a2wl_json_api;

        $product_id = $_REQUEST['id'];
        if (empty($product_id)) {
            $a2wl_json_api->error("No ID specified. Include 'id' var in your request.");
        } else {

            $product = $this->ProductImportModel->get_product($product_id);
            if (!$product) {
                $product = array('id' => $product_id);
            }

            if (!empty($_REQUEST['url'])) {
                $product['url'] = $_REQUEST['url'];
            }
            if (!empty($_REQUEST['thumb'])) {
                $product['thumb'] = $_REQUEST['thumb'];
            }
            if (!empty($_REQUEST['price'])) {
                $product['price'] = str_replace(",", ".", $_REQUEST['price']);
            }
            if (!empty($_REQUEST['price_min'])) {
                $product['price_min'] = str_replace(",", ".", $_REQUEST['price_min']);
            }
            if (!empty($_REQUEST['price_max'])) {
                $product['price_max'] = str_replace(",", ".", $_REQUEST['price_max']);
            }
            if (!empty($_REQUEST['title'])) {
                $product['title'] = $_REQUEST['title'];
            }
            if (!empty($_REQUEST['currency'])) {
                $product['currency'] = $_REQUEST['currency'];
            }

            $this->ProductImportModel->upd_product($product);
        }

        return array();
    }

    public function del_product()
    {
        global $a2wl_json_api;

        $product_id = $_REQUEST['id'];
        if (empty($product_id)) {
            $a2wl_json_api->error("No ID specified. Include 'id' var in your request.");
        } else {
            $this->ProductImportModel->del_product($product_id);
        }
        return array();
    }

    public function get_products()
    {
        global $a2wl_json_api;

        $tmp_products = $this->ProductImportModel->get_product_list();

        if (isset($_REQUEST['html'])) {
            return array('products' => $tmp_products);
        } else {
            $result = array();
            foreach ($tmp_products as $id => $p) {
                $result[$id] = array('id' => $id);
            }
            return array('products' => $result);
        }
    }

    public function get_products_info()
    {
        global $a2wl_json_api;
        if (!empty($_REQUEST['id'])) {
            $products = array();
            $ids = array_map('trim', is_array($_REQUEST['id']) ? $_REQUEST['id'] : explode(",", $_REQUEST['id']));
            foreach ($ids as $id) {
                $product = array('id' => $id);
                $product['imported'] = !!$this->WoocommerceModel->get_product_id_by_external_id($id) ||
                !!$this->ProductImportModel->get_product($id);
                $products[] = $product;
            }
            return array('products' => $products);
        } else {
            $a2wl_json_api->error("You should pass products id.");
        }
    }

    public function upd_order()
    {
        global $a2wl_json_api;

        $order_id = $_REQUEST['id'];
        if (empty($order_id)) {
            $a2wl_json_api->error("No ID specified. Include 'id' var in your request.");
        } else {

            $order = wc_get_order($order_id);

            if ($order === false) {
                $a2wl_json_api->error("Did not find the appropriate Woocommerce order.");
            } else {
                if (isset($_REQUEST['match_orders']) && !empty($_REQUEST['match_orders'])) {
                    $matchOrders = $_REQUEST['match_orders'];

                    $order_items = $order->get_items();
                    if (count($order_items)) {
                        foreach ($matchOrders as $matchOrder) {
                            $external_order_id = $matchOrder['orderId'];
                            $orderTotal = $matchOrder['orderTotal'];
                            if ($orderTotal) {
                                //todo: we can save order total in a future plugin release
                            }
                            $matchProductIds = array_unique($matchOrder['matchProductIds']);
                            foreach ($order_items as $item_id => $item) {

                                $a2wl_order_item = new WooCommerceOrderItem($item);

                                $external_id = $a2wl_order_item->get_external_product_id();

                                if (in_array($external_id, $matchProductIds)) {

                                    //save external order id if payment is done
                                    //  if ( strtolower( trim( $matchOrder['orderStatus'] ) ) === 'wait_seller_send_goods' ) {
                                    $a2wl_order_item->update_external_order($external_order_id, true);
                                    // }

                                }
                            }
                        }
                    }

                } else if (!empty($_REQUEST['external_id'])) {

                    /* todo: $_REQUEST['external_id'] deprecated and it will be removed in a future versions of the chrome extension
                     * use $_REQUEST['match_orders'] instead
                     */
                    $data = $_REQUEST['external_id'];

                    $current_data = $order->get_meta(Constants::old_order_external_order_id(), false);

                    if (is_array($data)) {
                        foreach ($data as $code_value) {
                            if (in_array($code_value, $current_data)) {
                                continue;
                            }

                            $code_value = trim($code_value);
                            if (!empty($code_value)) {
                                $order->add_meta_data(Constants::old_order_external_order_id(), $code_value);
                            }
                        }
                    } else {
                        $code_value = $data;
                        if (!in_array($code_value, $current_data)) {
                            $order->add_meta_data(Constants::old_order_external_order_id(), $code_value);
                        }
                    }
                }

                $placed_order_status = get_setting('placed_order_status');
                if ($placed_order_status !== "") {
                    $order->update_status($placed_order_status);
                }

                $order->save();
            }
        }

        return [];
    }

    public function get_orders()
    {
        global $a2wl_json_api;

        $result = $this->WoocommerceModel->get_fulfilled_orders_data();

        return array('orders' => $result);

    }

    public function update_tracking_data()
    {
        global $a2wl_json_api;

        if (!isset($_REQUEST['order_array'])) {

            $a2wl_json_api->error("No orders array specified. Include 'orders' array var in your request.");

        } else {

            $orders = json_decode(stripslashes($_REQUEST['order_array']), true);

            foreach ($orders as $order) {

                $order_id = intval($order['order_id']);
                $ext_id = floatval($order['ext_order_id']);

                $tracking_codes = isset($order['tracking_data']['tracking_codes']) ? $order['tracking_data']['tracking_codes'] : array();
                $carrier_name = isset($order['tracking_data']['carrier_name']) ? $order['tracking_data']['carrier_name'] : '';
                $carrier_url = isset($order['tracking_data']['carrier_url']) ? $order['tracking_data']['carrier_url'] : '';
                $tracking_status = isset($order['tracking_data']['tracking_status']) ? $order['tracking_data']['tracking_status'] : '';

                $result = $this->WoocommerceModel->save_tracking_code($order_id, $ext_id, $tracking_codes, $carrier_name, $carrier_url, $tracking_status);
            }

        }

        return array();

    }

    public function get_settings(): array
    {
        global $a2wl_json_api;

        $localizator = AliexpressLocalizator::getInstance();

        $settings = [
            'a2w_fulfillment_prefship' => get_setting('fulfillment_prefship', 'ePacket'),
            'a2w_aliship_shipto' => get_setting('aliship_shipto', 'US'),
            'a2w_import_language' => $localizator->language,
            'a2w_import_locale' => $localizator->getLangCode(),
            'a2w_local_currency' => $localizator->currency,
            'a2wl_chrome_ext_import' => a2wl_check_defined('A2WL_CHROME_EXT_IMPORT'),
            'a2wl_premium' => false
        ];

        if (EditionHelper::isFull()) {
            $PurchaseCodeInfo = $this->PurchaseCodeInfoService->getFromCache();
            $supportedUntilTimestamp = $PurchaseCodeInfo->getSupportedUntilStamp();
            if ($supportedUntilTimestamp && $supportedUntilTimestamp >= time()) {
                $settings['a2wl_premium'] = true;
            }
        }

        return ['settings' => $settings];
    }

}
