<?php

/**
 * Description of SplitProductService
 *
 * @author Ali2Woo Team
 */

namespace AliNext_Lite;;

class SplitProductService
{
    private ProductImport $ProductImportModel;

    public function __construct(ProductImport $ProductImportModel) {
        $this->ProductImportModel = $ProductImportModel;
    }

    /**
     * @throws ServiceException
     */
    public function splitProductByAttribute(int $productId, int $attributeId): void
    {
        $product_import_model = $this->ProductImportModel;

        if ($product = $product_import_model->get_product($productId)) {
            $new_products = array();
            $attr_index = 0;
            $split_attr = array();
            foreach ($product['sku_products']['attributes'] as $k => $a) {
                if ($a['id'] == $attributeId) {
                    $split_attr = $a;
                    $attr_index = $k;
                }
            }

            foreach ($product['sku_products']['attributes'][$attr_index]['value'] as $aid => $av) {
                // if this original attr (not generated by update)
                if (!isset($av['original_id'])) {
                    $new_product = $product;
                    $new_product['disable_add_new_variants'] = true;
                    $new_product['skip_vars'] = [];
                    $new_product['skip_attr'] = [$split_attr['name']];
                    foreach ($new_product['sku_products']['variations'] as $v) {

                        $skip = true;
                        foreach ($v['attributes'] as $vva) {
                            $var_atr_val = $product['sku_products']['attributes'][$attr_index]['value'][$vva] ?? false;
                            if ($var_atr_val && ($var_atr_val['id'] === $av['id'] || (isset($var_atr_val['original_id']) && $var_atr_val['original_id'] === $av['id']))) {
                                $skip = false;
                            }
                        }

                        if ($skip) {
                            $new_product['skip_vars'][] = $v['id'];
                        } else if (!empty($v['image'])) {
                            $new_product['thumb'] = $v['image'];
                            $new_product['thumb_id'] = Utils::buildImageIdFromPath($v['image']);
                        }
                    }

                    $new_product = $this->updateProductSkipImages($new_product);
                    $new_products[$av['id']] = $new_product;
                }
            }

            $i = 0;
            foreach ($new_products as $k => &$new_product) {
                if ($i === 0) {
                    $product_import_model->upd_product($new_product);
                } else {
                    $new_product['import_id'] = $new_product[ImportedProductService::FIELD_EXTERNAL_PRODUCT_ID] . "-" . md5($k . microtime(true));
                    $product_import_model->add_product($new_product);
                }
                $i++;
            }
        } else {
            $message =  _x("Product not found",
                'error text', 'ali2woo');
            throw new ServiceException($message);
        }
    }

    /**
     * @throws ServiceException
     */
    public function splitProductBySelectedVariants(int $productId, array $variationIds): void
    {
        $product_import_model = $this->ProductImportModel;

        if ($product = $product_import_model->get_product($productId)) {

            if (count($variationIds) == count($product['sku_products']['variations'])) {
                //do nothing
                return;
            } else {
                $selected_vars = $variationIds;
                $rest_vars = $foo = array_values(array_filter(array_map(function ($v) {return $v['id'];}, $product['sku_products']['variations']),
                    function ($v) use ($selected_vars) {
                        return !in_array($v, $selected_vars);
                    }
                ));

                $product_thumb = false;
                $new_product_thumb = false;
                foreach ($product['sku_products']['variations'] as $v) {
                    if (!$product_thumb && !empty($v['image']) && in_array($v['id'], $selected_vars)) {
                        $product_thumb = $v['image'];
                    }

                    if (!$new_product_thumb && !empty($v['image']) && in_array($v['id'], $rest_vars)) {
                        $new_product_thumb = $v['image'];
                    }
                }

                $new_product = $product;

                $product['disable_add_new_variants'] = true;
                $product['skip_vars'] = $rest_vars;
                if ($product_thumb) {
                    $product['thumb'] = $product_thumb;
                    $product['thumb_id'] = Utils::buildImageIdFromPath($product_thumb);
                }

                $new_product = $product;
                $new_product['import_id'] = $new_product[ImportedProductService::FIELD_EXTERNAL_PRODUCT_ID] . "-" . md5('new_product' . microtime(true));
                $new_product['disable_add_new_variants'] = true;
                $new_product['skip_vars'] = $selected_vars;
                if ($new_product_thumb) {
                    $new_product['thumb'] = $new_product_thumb;
                    $new_product['thumb_id'] = Utils::buildImageIdFromPath($new_product_thumb);
                }

                $count_attributes = function ($p) {
                    $used_attribute_values = array();
                    $var_count = 0;
                    foreach ($p['sku_products']['variations'] as $var) {
                        if (in_array($var['id'], $p['skip_vars'])) {
                            continue;
                        }
                        $var_count++;
                        foreach ($var['attributes'] as $var_attr_id) {
                            foreach ($p['sku_products']['attributes'] as $attr) {
                                if (isset($attr['value'][$var_attr_id])) {
                                    if (!isset($used_attribute_values[$attr['id']])) {
                                        $used_attribute_values[$attr['id']] = array('name' => $attr['name'], 'values' => array());
                                    }
                                    $used_attribute_values[$attr['id']]['values'][$var_attr_id] = $var_attr_id;
                                }
                            }
                        }
                    }

                    if ($var_count > 1) {
                        return array_unique(array_values(
                            array_map(function ($a) {return $a['name'];},
                                array_filter($used_attribute_values, function ($a) {return count($a['values']) < 2;})
                            )));
                    } else {
                        return array();
                    }
                };

                $new_product['skip_attr'] = $count_attributes($new_product);
                $new_product = $this->updateProductSkipImages($new_product);

                $product['skip_attr'] = $count_attributes($product);
                $product = $this->updateProductSkipImages($product);

                $product_import_model->upd_product($product);
                $product_import_model->add_product($new_product);
            }

        } else {
            $message =  _x("Product not found",
                'error text', 'ali2woo');
            throw new ServiceException($message);
        }
    }

    private function updateProductSkipImages(array $product): array
    {
        $product['skip_vars'] = is_array($product['skip_vars']) ? $product['skip_vars'] : [];
        $product['skip_images'] = is_array($product['skip_images']) ? $product['skip_images'] : [];

        //skip images related to skipped variations
        if (!empty($product['sku_products']['variations'])) {
            foreach ($product['sku_products']['variations'] as $var) {
                if (isset($var['image'])) {
                    $img_id = Utils::buildImageIdFromPath($var['image']);
                    if (in_array($var['id'], $product['skip_vars'])) {
                        if (!in_array($img_id, $product['skip_images'])) {
                            $product['skip_images'][] = $img_id;
                        }
                    }
                }
            }
        }

        return $product;
    }
}
