jQuery(document).ready(function($){
 
    const a2wl_select_shipping_js = {
         init : function(){
            let shipping_wrap_node = $('.a2wl_shipping_wrap'),
            country_value = country_node.val();

            let item_id = shipping_wrap_node.find('.item_id').val();
            let variation_id = shipping_wrap_node.find('.variation_id').val() || null;
            let product_id = shipping_wrap_node.find(".product_id").val();
            let page = a2wl_select_shipping_js.is_product_page() ? 'product' : 'cart';

            let $quantity_node = '';
                    
            if (a2wl_select_shipping_js.is_product_page()) {
                $quantity_node = $('form.cart input[name="quantity"]');      
            } else {
                console.log('Quantity field is not found. This is not a product page.');
            }

             if (a2wl_select_shipping_js.is_product_page()) {
                 //prevent shipping load if not all variation selected
                 const variationsForm = document.querySelector('.variations_form');
                 if (variationsForm && !a2wl_select_shipping_js.check_all_variants_selected(variationsForm)) {
                    return;
                 }
             }

             shipping_wrap_node.block({
                 message: null,
                 overlayCSS: {background: '#fff', opacity: 0.6}
             });

            let $quantity = 1;

            if ($quantity_node.val() === undefined || $quantity_node.val() === 0){
                $quantity = 1;
            }  else {
                $quantity = $quantity_node.val();
            } 

            a2wl_select_shipping_js.a2wl_load_shipping_info(
                product_id, variation_id, country_value, $quantity,
                function (state, items, default_method, shipping_cost, shipping_info){

                if (state !== 'error') {
                    var shipping = items, 
                    shipping_select_node = shipping_wrap_node.find('.a2wl_shipping'),
                    shipping_select =  shipping_wrap_node.find('.a2wl_shipping select'),
                    shipping_info_node = shipping_wrap_node.find('.info'),
                    country_label = country_node.find('option:selected').text();

                    shipping_select.empty();

                    shipping_info = shipping_info.replaceAll('{country}', country_label );
                    
                    var a2wl_remove_cart_item = Number(shipping_wrap_node.find('.a2wl_remove_cart_item').val());
                    var a2wl_fake_method = shipping_wrap_node.find('.a2wl_fake_method').val();

                    if (shipping.length === 0 /*&& a2wl_remove_cart_item > 0*/){
                        
                        shipping_select_node.addClass('hidden');
                        shipping_select.append('<option value="'+a2wl_fake_method+'" selected="selected"></option>');    
                        
                        shipping_info_node.html(shipping_info);    
                        shipping_info_node.removeClass('hidden');

                        shipping_wrap_node.unblock();
                        return; 
                    }


                    jQuery.each(shipping, function (i, item) {

                        var decodedLabel = $("<div/>").html(item.label.replaceAll('{country}', country_label )).text();

                        shipping_select.append('<option value="' + item.serviceName + '">' + decodedLabel + '</option>');
                        
                    });

                    if (shipping.length > 0){
                        shipping_select_node.removeClass('hidden');
                        shipping_info_node.addClass('hidden');
                    } else {
                        shipping_select_node.addClass('hidden');
                        shipping_info_node.html(shipping_info);
                        shipping_info_node.removeClass('hidden');
                    }   
                    
                    shipping_wrap_node.unblock();

                } else {
                    shipping_wrap_node.unblock();

                    console.log('AliNext (Lite version) can`t get shipping info for product: ' + product_id + ', country: ' + country);
                    return false;
                }
            }, 'select', page);

         },
         get_country_node: function(){

            var country_node = false;

            if ($("#a2wl_to_country_field").length > 0){
                //product
                country_node = $("#a2wl_to_country_field");
            } else if ( $('#calc_shipping_country').length > 0  ){
                //cart
                country_node = $('#calc_shipping_country');
            } else if ( $('.shipping_address').length > 0 ){
                //checkout
                if ($('.shipping_address').css('display') == "none"){
                    country_node = $('#billing_country');
                } else {
                    country_node = $('#shipping_country');      
                }
                
            }  
            
            return country_node;

         },
         is_product_page: function(){
            return  $("#a2wl_to_country_field").length > 0 ? true : false;
          },
         check_all_variants_selected: function(variationsForm) {
             let allSelected = true;
             const variationSelects = variationsForm.querySelectorAll('select');
             variationSelects.forEach(select => {
                 // Check if the select has a value
                 if (!select.value) {
                     allSelected = false;
                 }
             });

             return allSelected;
         },
         ajax_update_shipping_method_in_cart_item : function(id, tariff_code, country){
            let data = {
                'action': 'a2wl_update_shipping_method_in_cart_item',
                'id':id,
                'value': tariff_code,
                'calc_shipping_country': country,
                'ali2woo_nonce': a2wl_ali_ship_data.nonce_action,
            };
           
               $.ajax({
                   url : a2wl_ali_ship_data.ajaxurl,
                   type : 'POST',
                   data : data,
                   tryCount : 0,
                   retryLimit : 3, 
                   success : function (response) {
                       if (response == ''){
                            this.tryCount++;
                            if (this.tryCount <= this.retryLimit) {
                                //try again
                                $.ajax(this);
                                return false;
                            }

                            console.log('Something is wrong with your server');            
                            return false;     
                       }
                                                  
                        let json = JSON.parse(response);
                        
                        if (json.state){
                       
                            if (json.state == "ok"){
                                //for cart
                                if ($('.woocommerce-shipping-calculator').length > 0)
                                    $('.woocommerce-shipping-calculator').submit(); 
                                else {
                                    //for checkout
                                    $( document.body ).trigger( 'update_checkout' );                           
                                }                                                       
                            }
                            
                            if (json.state == "error"){
                                //just reserved for error 
                            }
                        }
                   },                
                   error : function(xhr, textStatus, errorThrown ) {
                        if (textStatus == 'timeout') {
                            this.tryCount++;
                            if (this.tryCount <= this.retryLimit) {
                                //try again
                                $.ajax(this);
                                return false;
                            }            
                            return false;
                        }
                        if (xhr.status == 500) {
                            //handle error
                        } else {
                            //handle error
                        }
                   }
              });    
         },
         a2wl_load_shipping_info : function(product_id, variation_id = null, country, $quantity, callback = null, type = 'select', page = 'cart') {
            let data = {
                'action': 'a2wl_frontend_load_shipping_info',
                'id': product_id,
                'country': country,
                'quantity': $quantity,
                'type': type,
                'page': page,
                'ali2woo_nonce': a2wl_ali_ship_data.nonce_action,
            };

             if (variation_id) {
                 data['variation_id'] = variation_id;
             }
        
            jQuery.post(a2wl_ali_ship_data.ajaxurl, data).done(function (response) {
                let json = JSON.parse(response);
                if (json.state !== 'ok') {
                    console.log(json);
                    if (callback) { callback(json.state, [], '', '', []) }
                }
                if (json.state !== 'error' && callback) {
                    const product = json.products ? json.products : false;
                    const shipping_info = json.shipping_info;
                    callback(json.state, product ? product.items : [], product ? product.default_method : '', product ? product.shipping_cost : 0, shipping_info)
        
                    if (product && product.items.length > 0) {
                        jQuery.post(a2wl_ali_ship_data.ajaxurl, {
                            'action': 'a2wl_frontend_update_shipping_list',
                            items: product.items,
                            'ali2woo_nonce': a2wl_ali_ship_data.nonce_action
                        })
                    }
                }
        
            }).fail(function (xhr, status, error) {
                console.log(error);
            });
        },
    };

    const country_node = a2wl_select_shipping_js.get_country_node();

    if (!country_node) {
        //stop script if the country node is not available
        return;
    }


//in cart:

    //country change
    if (!a2wl_select_shipping_js.is_product_page()) {
        $(document.body).on(
            'change', 
            '.a2wl_shipping_wrap select', function() {
                let shipping_wrap_node = $(this).parents('.a2wl_shipping_wrap'),
                item_id = shipping_wrap_node.find('.item_id').val(), 
                method_value = $(this).val(),
                country_value = country_node.val();
                a2wl_select_shipping_js.ajax_update_shipping_method_in_cart_item(item_id, method_value, country_value);           
        }); 
    }

//on product page:

    //country change
    $(document).on('change', '#a2wl_to_country_field',function(){
        if (country_node.val() !== "") {
            a2wl_select_shipping_js.init();
        }
    });


    //quantity change
    $(document).on('change', 'form.cart input[name="quantity"]', function () {
        let $quantity = $(this), $form = $quantity.closest('form.cart');
        let shipping_wrap_node = $form.find('.a2wl_shipping_wrap');
        let variation_id = $form.find('input[name="variation_id"], input.variation_id').val();
        let cur_product_id = shipping_wrap_node.find(".item_id").val();

        if (variation_id && variation_id !== cur_product_id) {

            //if variable product & variant is changed, update product id
            shipping_wrap_node.find('.item_id').val(variation_id);

        } else {
            //update shipping if variant is not change or if this is a simple product
            a2wl_select_shipping_js.init();   
        }

    });

    //variation change
    $('.single_variation_wrap').on('show_variation', function (event, variation) {
        const shipping_wrap_node = $(this).find('.a2wl_shipping_wrap');
        if (variation.is_in_stock){
            shipping_wrap_node.removeClass('hidden');
            a2wl_select_shipping_js.init();
        } else {
            shipping_wrap_node.addClass('hidden');    
        }
    });

    const variationsFormNode =  $('.variations_form');

    if (variationsFormNode.length) {
        variationsFormNode.on('woocommerce_variation_has_changed', function (event) {
            //fire even when not all variations selected
            const shipping_wrap_node = $(this).find('.a2wl_shipping_wrap');

            if (!a2wl_select_shipping_js.check_all_variants_selected(this)) {
                shipping_wrap_node.addClass('hidden');
            } else {
                shipping_wrap_node.removeClass('hidden');
            }
        });
    } else {
        $(".a2wl_shipping_wrap").removeClass('hidden');
    }
})