# Algori Video and Image Slider

Contributors: [Kevin Bazira](http://kevinbazira.com)

Tags: gutenberg, block, block editor, slider, image slider, image gallery, image carousel, slideshow, video slider, photo slider, hero image, header slider, responsive slider

Requires at least: WP 5.0.0
* Tested up to: WP 6.0
* Stable tag: 1.0.6
* License: GNU General Public License v2 or later
* License URI: https://www.gnu.org/licenses/gpl-2.0.en.html

Algori Video and Image Slider is a Gutenberg Block Plugin that enables you easily add video and image sliders to your website.

<p align="center">
  <img src="http://kevinbazira.com/images/articles/algori-image-and-video-slider-pro-for-wordpress-gutenberg.jpg" alt="Algori Image Slider">
</p>

# Description 

Algori Video and Image Slider is a Gutenberg Block Plugin that enables you easily add video and image sliders to your website. 

Capture your site visitors' attention with compelling image slideshows, hero images/videos, header sliders and image carousels. **This will boost user engagement and increase revenue for your site**.

This free plugin has a lot to offer. Even more can be found in the Premium version of this Plugin, please see [all features of the Premium plugin here](http://www.kevinbazira.com/blog/article/algori-image-and-video-slider-pro-for-wordpress-gutenberg#features).

# Features of the free image slider

* Hide/Show Navigation Dots
* Hide/Show Navigation Arrows
* Enable/Disable Slideshow Autoplay
* 1 slider dot style
* 1 slider arrow style

# Features of the premium version

* 14 different slider dot styles
* 14 different slider arrow styles
* Add text with call to action button ontop of slider
* Hide/Show Navigation Dots
* Hide/Show Navigation Arrows
* Enable/Disable Slideshow Autoplay
* Hide/Show Pause Autoplay on Click
* Disable/Enable Right to Left Direction
* Enable/Disable Vertical Direction
* Enable/Disable Slide Fade
* Enable/Disable Lazy Load
* Enable/Disable Center Mode
* Disable/Enable Infinite Slider Loop
* Adjust Slider Animation Speed
* Adjust Slider Autoplay Speed
* Show multiple slides
* Scroll multiple slides
* Show slides in rows
* Adjust slider video settings ( autoplay, muted, controls, loop, and much more ... )
* Set left, right, center, wide and full width alignments for image slider.

Most of these features are enabled by default and can't be disabled or adjusted in the free version. We released a Premium Plugin with many more exciting features that will enable you to adjust all the slider settings as you wish.

Have a look at the [Premium Plugin here](https://codecanyon.net/item/algori-image-and-video-slider-pro-for-wordpress-gutenberg/22818690).

# Installation

* Download the plugin, unzip it and move the unzipped folder to the "wp-content/plugins" directory in your WordPress installation.
* In your admin panel, go to Plugins and you'll find "Algori Image & Video Slider" in the plugins section.
* Click on the "Activate" button to use your new plugin right away.
* Go [here for a guide on how to add video and image sliders to your WordPress site](http://www.kevinbazira.com/blog/article/algori-image-and-video-slider-pro-for-wordpress-gutenberg#documentation).
* Done :)
* PS: Remember to click the **Enable auto-updates** link for this plugin so that you don't miss cool new features as they come in.

# How to use 

* After installing and activating the "Algori Image and Video Slider" plugin in your WordPress website.
* Navigate to your blog post or page and use the Gutenberg editor to add an "Image & Video Slider" block.
* Use the "Image & Video Slider" block to upload images/videos or choose images/videos from the media library to create your image slider or image carousel.
  PS: In order to choose multiple images in the media library press keyboard button “Ctrl” on Windows or “Command” on Mac, then click on your images to select them.
* At this point, you can adjust your slider settings using the Gutenberg block inspector section.
	- Hide/Show Navigation Dots
	- Hide/Show Navigation Arrows
	- Enable/Disable Slideshow Autoplay
* Click "Publish" to view your new web page with an image slider.
* Congratulations :D

# Frequently Asked Questions

= Can I use this plugin with other page builders I am using? =

Nope. Algori Video and Image Slider only works with Gutenberg.

= What theme works with Algori Video and Image Slider? =

Most WordPress themes that are optimized for Gutenberg will work well with Algori Video and Image Slider. To get a full experience of the next-generation WordPress block editor, you’ll need a Gutenberg-ready WordPress theme, like [Algori Blogger](https://wordpress.org/themes/algori-blogger/) or [Algori Shop](https://wordpress.org/themes/algori-shop/).

= Why upgrade to Pro? =

* **More customization features:** The Premium version includes new features that will enable you to adjust the slider settings that are enabled by default and can't be disabled in the free version. It also has other cool features like adding text to your slider, changing slider dot and arrow styles to beautifully match your website and much more.
* **No Need to Register Anywhere:** You do not need to create an account at our website to use this plugin.
* **No Middle Layer:** Plugin runs totally on your website server without any communication to our servers.
* **Absolutely Simple:** Plugin configuration is kept dead simple. Customization options designed to be intuitive to setup without being a rocket scientist.
* **Optimized Loading time:** Loading time of image slider is optimized and if you compare with other plugins, you will find it less than that of all those plugins.
* **Lightweight Code:** Our developers follow best coding practices to ensure efficient loading and performance.
* **No Coding Skills Required:** Algori Video and Image Slider Plugin is easy to use and does almost everything for you without touching the code.
* We promise to provide **best quality** among other similar plugins. If you find our plugin lacking certain feature that you need, please feel free to email us and we will do our best to include that feature in our plugin as soon as possible.
* **Priority support:** Our support team is working 24/7 to answer your inquiries as fast as possible.

See more details here [Premium Plugin features](http://www.kevinbazira.com/blog/article/algori-image-and-video-slider-pro-for-wordpress-gutenberg)

# Changelog

= 1.0.6 - Aug 23 2020 =
* Added block preview using example metadata
* Updated Algori Video and Image Slider namespace
* Replaced block category 'common' with 'media'
* Added block.json for WP block directory

= 1.0.5 - June 22 2020 =
* Replaced deprecated wp.components.IconButton with wp.components.ToolbarButton.

= 1.0.4 - Jan 30 2020 =
* Upgraded cgb-scripts from 1.13.0 to 1.22.0
* Updated deprecated wp.editor.BlockControls to wp.blockEditor.BlockControls.
* Updated deprecated wp.editor.MediaPlaceholder to wp.blockEditor.MediaPlaceholder.
* Updated deprecated wp.editor.MediaUploadCheck to wp.blockEditor.MediaUploadCheck.
* Updated deprecated wp.editor.MediaUpload to wp.blockEditor.MediaUpload.

= 1.0.3 - May 09 2019 =
* Added dynamic video mime type detection for video slides
* Added message with video download link in case browser doesn't support the HTML5 video tag
* Added Spinner to show loading is in progress instead of blank slider

= 1.0.2 - May 04 2019 =
* Fixed media type verification bug on upload
* Upgraded cgb-scripts from 1.11.1 to 1.13.0
* Improved documentation to match WP standards
* Added MediaUploadCheck wrapper onto MediaUpload to make sure the current user has Upload permissions
* Added algori in the block keywords

= 1.0.1 - Nov 29 2018 =
* Removed 'wp-blocks' dependency from both external algori_image_video_slider-*-css
* Removed MediaPlaceholder labels name
* Added MediaPlaceholder labels instructions
* Changed all documentation from "Algori Image and Video Slider" to "Algori Video and Image Slider" for SEO purposes
* Added Social call to action into README.md

= 1.0.0 - Oct 30 2018 =
* Initial Release

Algori Video and Image Slider WordPress Plugin, Copyright 2022 Kevin Bazira<br/>
Algori Video and Image Slider is distributed under the terms of the GNU GPL<br/><br/>


_If you like this project, please 🌟 star it here_ [![GitHub stars](https://img.shields.io/github/stars/kevinbazira/algori-image-and-video-slider-lite.svg?label=Stars&style=social)](https://github.com/kevinbazira/algori-image-and-video-slider-lite)
<br/>
_Follow me 👋 on Twitter for more projects like this_ [![Tweet to say Hi](https://img.shields.io/twitter/follow/kevinbazira.svg?style=social&label=Tweet%20@kevinbazira)](https://twitter.com/kevinbazira/)


