<?php
/**
 * Docs tab
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	die();
}

?>
<h2>Plugin Shortcode</h2>
<h4>Description</h4>
<p>Affiliate Links plugin provides with shortcode for embedding affiliate links into the post content.</p>
<h4>Example</h4>
<code>[af_link href="http://affiliatelinkswp.com/go/download/" rel="nofollow" target="_blank" title="Link Title" class="btn-primary"]Click Here[/af_link]</code>
<h4>Parameters</h4>
<ul>
    <li><strong>href="..."</strong> - link URL (required)</li>
    <li><strong>rel="nofollow"</strong> - add nofollow attribute (optional)</li>
    <li><strong>target="_blank"</strong> - opens link in a new browser tab (optional)</li>
    <li><strong>title="..."</strong> - add title attribute (optional)</li>
    <li><strong>class="..."</strong> - add custom css class (optional)</li>
</ul>
<br>
<h2>Plugin Filters and Actions</h2>
<p>Hooks in WordPress core, plugins and themes essentially allow you to manipulate code without editing core files.
    <br>So you can change third-party plugin behaviour from your own theme or plugin and keep future updates as well.</p>
<h4>Plugin Filters</h4>
<ol>
    <li><strong>af_link_register_post_type</strong> - allows changing of the post type registration arguments.</li>
    <li><strong>af_link_register_taxonomy</strong> - allows changing of the taxonomy registration arguments.</li>
    <li><strong>af_link_nofollow_header</strong> - allows changing of the nofollow HTTP header before redirect is processed.</li>
    <li><strong>af_link_target_url</strong> - allows changing of the target link URL before redirect is processed.</li>
    <li><strong>af_link_redirect_type</strong> - allows changing of the redirection type(301, 302, 307 etc) before redirect is processed</li>
</ol>
<h4>Plugin Actions</h4>
<ul>
    <li><strong>af_link_before_redirect</strong> - allows you to insert custom code before the link will be redirected to the target URL, accepted args: $post_id, $target_url, $redirect_type</li>
</ul>
<h4>Example 1</h4>
<pre>
add_filter( 'af_link_target_url', 'my_target_url_filter' );

function my_target_url_filter( $target_url ){

    $aff_id_value = 'your_value'; //some php here

    $target_url = add_query_arg( array(
    'aff_id' =&gt; $aff_id_value
    ), $target_url );

    //var_dump($target_url); die();

    return $target_url;

}
</pre>
<p>This example shows how you can add custom variable to the target link URL dynamically generated by PHP.</p>
<h4>Example 2</h4>
<pre>
add_action( 'af_link_before_redirect', 'my_header_action', 10, 3 );

function my_header_action( $post_id, $target_url, $redirect_type ){
    header( 'X-Custom-Header: cool!', true );
}
</pre>
<p>This example shows how you can add custom HTTP headers when the affiliate link is redirected to the target URL.</p>
<hr>
<strong>For more information please visit plugin website - <a href="http://affiliatelinkswp.com/?utm_campaign=affiliate-links-in-site&utm_medium=settings-link&utm_source=user-website" target="_blank">AffiliateLinksWP.com</a></strong>