The format is based on [Keep a Changelog](http://keepachangelog.com/)
and this project adheres to [Semantic Versioning](http://semver.org/).

= 3.6.0 - 11 November 2025 =
  * Update: Add intro message to Block Usage screen, #1657
  * Update: Show how many block instances come from each plugin on Block Usage screen, #1492
  * Update: Make Block Usage "Post Types" filter a pro feature, #1658
  * Update: Update screens button to use WordPress primary/secondary buttons on all pages, #1650
  * Fixed: Tab Blocks not working properly when it is moved resulting in previous block been removed, #1584
  * Update: Lightbox not working for Gallery blocks, #1383
  * Update: Change promo tooltips to direct links, #1656
  * Update: Remove Month filter on Auto Insert Blocks, #1666
  * Fixed: Auto Insert Blocks results in duplicated author box on a single content, #1667
  * Update: Remove "Previous Paragraph" and "Following Paragraph" in Block styles preview, #1675
  * Update: Remove main Padding, Margin, Border etc from block styles, #1676
  * Fixed: PHP Warning, Undefined array key 0, #1674
  * Fixed: Incorrect link to changelog in readme.txt, #1678
  * Update: Blocks v3.5.2 ITALIAN-FRENCH-SPANISH Translation Updates, #1692

= 3.5.2 - 20 October 2025 =
  * Update: Move Style Builder features to the Free version, #1586
  * Update: Add more options (link, heading, hover etc) for Block Styles, #1592
  * Update: Make Block Controls preset rules and control sets collapsible, #1634
  * Update: Group Block styles fields and make each group fieldset collapsible, #1593
  * Update: Add a "Duplicate" link to Auto Insert Blocks, #1624
  * Changed: Move Block Styles Preview to the top, #1587
  * Removed: Remove Auto Insert Blocks "Enable this rule" option, #1627
  * Update: Add a "Save Permission for all Roles" button to Block Permissions, #1610
  * Fixed: Undefined array key HTTP_USER_AGENT in Block Controls, #1632
  * Update: Add additional "Add new style" button at the top of Block Styles list, #1585
  * Fixed: JS translations not working in Gutenberg Editor, #1408
  * Fixed: Pages and Term Archives Controls not showing in site editor, #1618
  * Update: Enable Block Styles for all block, #1588
  * Fixed: YouTube embeds not working when PublishPress Blocks is active, #1625
  * Update: Move block [pro] icon to the front of the title in Gutenberg editor sidebar, #1622
  * Fixed: Improve promo inside Block Controls, #1620
  * Update: Blocks ITALIAN and FRENCH Translation Updates_v3.5.1, #1642

= 3.5.1 - 23 September 2025 =
  * Fixed: Fatal error when "Block Styles" feature is disabled, #1613

= 3.5.0 - 23 September 2025 =
  * Feature: Add Presets to Block Control, #1581
  * Feature: Add Capabilities to Block Control, #1579
  * Feature: Add User Meta to Block Control, #1579
  * Feature: Add Post Meta to Block Control, #1579
  * Feature: Add Query strings to Block Control, #1579
  * Feature: Add Bot option to Device type in Block Control, #1579
  * Feature: Add Browser to Block Control, #1579
  * Feature: Add Operating System to Block Control, #1579
  * Feature: Add Cookie to Block Control, #1579
  * Fixed: Content Display Block is not fully translated using Loco Translate, #1583

= 3.4.0 - 20 August 2025 =
  * Feature: Add Advanced Custom Styles/Editor UI for Block Styles - [Pro feature], #775
  * Feature: Add Automatically insert blocks feature, #1525
  * Update: Allow user to change Date Format on Content Display Block - [Pro feature], #1559
  * Update: Allow user to set or remove separator for the items in info section of Content Display Block - [Pro feature], #1561
  * Update: Allow user to reorder Content Display Block Info Section(Author, Date, Comments) - [Pro feature], #1560
  * Update: Make the Content Display Block "Posted on" and "Updated on" date prefixes text editable - [Pro feature], #1562
  * Update: Rename "Synced Patterns" to "Reusable Blocks", #1555
  * Fixed: Sanitize Map Block title and description, #1566

= 3.3.4 - 21 July 2025 =
  * Update: Improved pro banner for blocks, #1544

= 3.3.3 - 10 July 2025 =
  * Fixed: Block permission screen not loading, #1537
  * Fixed: Pro Blocks not available inside editor if installed after free version installation, #1538

= 3.3.2 - 30 June 2025 =
  * Update: Allow use of post IDs in the "Display these posts only" box in Content Display Block, #1502
  * Update: Add "Dashboard", "Settings" and "Upgrade to Pro" links on Plugins screen, #1518
  * Update: Icon for collapse in Accordion block, #1248
  * Update: Set an “open state” and “close state” icon for Accordion Block, #129
  * Fixed: PDF Embedder content not rendering inside Tabs Block, #1532
  * Fixed: Implement proper validation for admin page tab parameter, #1523
  * Update: Update jquery.colorbox.min.js, #1521
  * Update: Upgrade device-detector to '^6.4'

= 3.3.1 - 03 June 2025 =
  * Fixed: Tab Block Active tab text color not working, #1504
  * Fixed: Tab Blocks Anchor not working, #1311
  * Fixed: Tab Block mobile tabs not scrolling to view after click, #1511
  * Fixed: Table Block Padding Slider Not Working, #1419
  * Fixed: Blocks using metadata.name on their registration trigger error on PublishPress-Blocks, #1366
  * Added: Add Loco.xml file for Pro version, #1506
  * Update: Remove "Enable Extend Supported Blocks" from dashboard and enable feature by default, #1489
  * Fixed: PHP Warning, #1503

= 3.3.0 - 20 May 2025 =
  * Fixed: PublishPress Block (Tabs) not showing on mobile display, #1483
  * Fixed: Switch div to img tag to support alt attribute on image block, #1271
  * Update: Indent the Device Type settings, #1474
  * Update: Ensure only public Post type is viewable on Recent Post, #1364
  * Feature: Add "Current Page" to "Login Blocks" redirect option, #1359
  * Update: Remove small extra space in Block Usage, #1465
  * Fixed: Table blocks arrow keys navigation focus not reflecting position, #1413
  * Fixed: New tabs block header order using first block tabs order, #1159
  * Fixed: Tabs Title Inline images rendering as html on Mobile, #1277
  * Fixed: PublishPress Block 3.2.6 and malware scanner, #1467

= 3.2.6 - 07 May 2025 =
  * Feature: Add new Block Usage Screen to scan posts where blocks is currently in use, #1245
  * Update: Add Block controls by device type (Desktop, Tablet, Mobile), #1238
  * Update: Add Block controls by device width (screen size), #1442
  * Feature: Add multiple schedules option for Block Controls, #1367
  * Fixed: Fixed Tabs Block adds undefined class and breaks some Gutenberg blocks, #1435
  * Fixed: Tabs Block Lack Accessibility, #1427
  * Feature: Add settings that allow users to disable all block adding for roles, #1425
  * Feature: Allow users to remove more block editor features(Pattern, Blocks and Openverse), #1424
  * Fixed: Issues with block controls when user has more than one role,  #1288
  * Update: Blocks Translation Updates v3.2.5, #1441

= 3.2.5 - 09 April 2025 =
  * FIX: Block Control Does not Work on Sunday, #1411
  * FIX: Slick css override rule bug, #1428
  * UPDATE: Make Video Height optional in Video Block for Auto Height, #1379
  * FIX: Content Display Bug, #1370
  * FIX: Accessiblity for Accordion block, #66
  * UPDATE: Reach accordion items with tab key, #776
  * FIX: Lightbox not working with webp images, #1309
  * UPDATE: Update WordPress Reviews library to 1.1.20, #1338
  * UPDATE: Brazil Translation,  #1421

= 3.2.4 - 05 Aug 2024 =
  * FIX: Calendar popup odd behavior in Block controls, #1261;
  * FIX: Weekdays design is wrong, #1388;
  * FIX: Empty columns inside tabs looks flat, #1264;
  * FIX: Stripes thumbnail doesn't have stripes design in Table block, #212;
  * ADD: Bahasa translation, #1340;
  * CHANGE: Remove social icons in footer, #1358;
  * CHANGE: Update to Babel 7, #1330;
  * CHANGE:  Update to Webpack 5, #1393;
  * CHANGE: Translations for Spanish, French and Italian, #1400;

= 3.2.3 - 29 Jul 2024 =
  * FIX: Blocks inserted as synced patterns freezes the Gutenberg editor, #1389;

= 3.2.2 - 13 May 2024 =
  * FIX: Tab titles, #1372;
  * FIX: Cannot use object of type WP_Error as array, #1354;

= 3.2.1 - 07 Nov 2023 =
  * FIX: Call to lodash methods, #1342, #1346;
  * FIX: Can't activate Blocks if Gutenberg plugin is active, #1345;
  * FIX: Series order when no series is selected error, #1335;

= 3.2.0 - 20 Sep 2023 =
  * FIX: register_activation_hook not executed, #1325;
  * FIX: Logic to check if a setting is enabled, #1319;
  * FIX: Undefined array key "enable_columns_visual_guide", #1321;
  * CHANGE: Internal vendor and new file structure, #1299, #1312;

= 3.1.6 - 10 Aug 2023 =
  * FIX: Undeclared $style_html variable
  * FIX: Add jQuery as dependency when enqueueing frontend.js in frontend for Testimonial block
  * CHANGE: "Reusable Blocks" admin submenu to "Synced Patterns"

= 3.1.5 - 25 Jul 2023 =
  * FIX: post-sidebar.js enqueue in post and page edit only
  * FIX: lightbox should apply to galleries when "Link to" is "media file"
  * FIX: Block permissions when user has more than one role bug
  * ADD: Allow to enable/disable Legacy Widget through Block permissions
  * CHANGE: Set WordPress 5.5 as minimum version
  * CHANGE: PHP and WP Minimum Version Configuration

= 3.1.4.3 - 16 May 2023 =
  * ADD: Support for new dynamic meta_key for Series in Content Display block

= 3.1.4.2 - 12 Apr 2023 =
  * FIX: Allowed block types for non-saved block types in post edit
  * FIX: Widget Group block type not saved as active
  * ADD: PHP 7.2.5 as minimum PHP version

= 3.1.4.1 - 29 Mar 2023 =
  * FIX: Blinking block inserter in WordPress 6.2
  * FIX: Toggle to open calendar popup in Block controls
  * FIX: Calendar popup UI in Block controls
  * FIX: Days of the week and between times UI elements from Schedule's Block controls missing CSS in Customizing > Widgets
  * FIX: Woo Products columns are incorrect in editor preview
  * FIX: Slider view in editor for Woo products block

= 3.1.4 - 13 Feb 2023 =
  * ADD: Unique class to Accordions block
  * ADD: Ad "Upgrade to Pro" in Schedule Timezone setting Block control
  * FIX: Stacked is selected but visually is not indicated in Tabs block

= 3.1.3 - 23 Jan 2023 =
  * ADD: List item block
  * ADD: Reordering items support to List block
  * ADD: Submenu for Reusable blocks
  * FIX: Transforms for List block
  * FIX: Selected PublishPress block icon contrast in List view
  * FIX: Default undefined "width" for single Column block
  * FIX: Columns width in editor
  * FIX: Vertical alignment in editor for PublishPress Columns block
  * FIX: All tabs content displayed at once

= 3.1.2 - 4 Jan 2023 =
  * ADD: Days of the week and time range settings to Schedule control
  * ADD: Term archives and pages control
  * ADD: Bring back map files
  * ADD: Display timezone below dates
  * ADD: Minify compiled JSX files
  * ADD: Support for Accordion items in Table of Contents block for Pro version
  * ADD: Hide from everyone option to User roles control
  * ADD: aria-label to overlay link for Images Slider block
  * FIX: For User role control, when no role is selected, the block is hidden to everyone
  * FIX: Hide widgets HTML wrapper when its block is not visible
  * FIX: Set autoload to 'no' for bigger size options
  * FIX: Load dashicons in frontend if blocks are using it
  * FIX: Optimize PublishPress blocks code to enqueue assets

= 3.1.1 - 16 Nov 2022 =
  * ADD: Base path constant
  * ADD: Reusable methods for FormTokenField
  * FIX: Vendor path constant
  * FIX: Undefined window._wpGutenbergDefaultPost in initializeEditor()
  * FIX: Make title and subtitle linkable for Image block custom URL
  * FIX: Reset icon moved to a new line when date is longer in Schedule block control
  * FIX: Padding for date picker popup
  * FIX: Can't select items from core List block
  * FIX: Forced 100% width for core Button block
  * FIX: Bring back Upgrade to Pro boxes in editor

= 3.1.0 - 26 Oct 2022 =
  * ADD: Block Controls admin page
  * ADD: User roles block control
  * ADD: Rename old accordions and tabs blocks as deprecated
  * ADD: Edit Block style title above the class name
  * ADD: Allow to dynamically exclude blocks when calling advgbGetBlocksFeature()
  * FIX: Server check to active Legacy widget block for Block Permissions
  * FIX: Adjust force active/inactive blocks javascript check in Block Permissions
  * FIX: Add each block control at the time and when enabled
  * FIX: Disabled menu features should be hidden always
  * REMOVE: Edit Block style title through the styles list

= 3.0.1 - 6 Oct 2022 =
  * FIX: Potential non load of version notices library
  * FIX: Don't add Blocks menu custom CSS classes if menu is not created
  * FIX: Settings panel title for Video block
  * FIX: Block styles label in editor dropdown
  * FIX: Links to settings from Login & Register, Map, Newsletter and Contact Form blocks
  * FIX: Wrong tab name returns a "not found" message

= 3.0.0 - 3 Oct 2022 =
  * ADD: Separated admin pages
  * ADD: Admin dashboard
  * ADD: PublishPress brand color as default icon color
  * ADD: New names for PublishPress blocks

= 2.14.2 - 25 Aug 2022 =
  * ADD: Extend supported blocks setting to support blocks not listed in Block access
  * FIX: Authors and Series order by from Content Display make some legacy widgets to disappear in frontend
  * FIX: Allow to enable Container block through Block access
  * FIX: Cropped read more link when having padding in Content Display block

= 2.14.1 - 3 Aug 2022 =
  * ADD: Pre-populate title and text with image properties from media library (title, alt, caption and description) for Images Slider block
  * FIX: Block Access support for third party plugins blocks
  * FIX: Block access for super admin in multisite child site
  * FIX: Custom styles conflict with Block controls class in editor preview
  * FIX: Images slider inside Advanced Tabs

= 2.14.0 - 25 Jul 2022 =
  * ADD: Block controls to schedule blocks visibility

= 2.13.3 - 6 Jul 2022 =
  * ADD: Blue color from WordPress core to unit elements (px, %) for Content Display block
  * ADD: Choose to display author, date, excerpt, read more, category, tags, comment counts and custom taxonomies for up to 5 first posts in Content Display block
  * ADD: Offset posts filter to Content Display block
  * ADD: Featured image color overlay and opacity for headline style to Content Display block
  * ADD: JSON translations for French, Danish and Norwegian
  * FIX: Center featured image when using default slider view for Content Display block
  * FIX: Don't output text after title and text before read more when empty in editor for Content Display block
  * FIX: Lost password link broken in Login/Register Form block
  * FIX: Slideshow view text in editor preview is cropped for Content Display block
  * FIX: Make email and password fields required for Login/Register Form block
  * REMOVE: PublishPress Series box from editor preview in Content Display block

= 2.13.2.1 - 21 Jun 2022 =
  * ADD: Exclude posts shared method for Content Display block
  * FIX: Limit request for post suggestions in Exclude for Content Display block

= 2.13.2 - 2 Jun 2022 =
  * ADD: Toggle to check/uncheck all blocks in Block Access screen
  * ADD: PublishPress Series order by option
  * ADD: Select posts by id
  * FIX: Edit title and text over the image for Images Slider block
  * FIX: Undefined postTitleVsIdMap error in Content Display block
  * FIX: Console error already registered WordPress 6.0 new core blocks
  * REMOVE: Select posts by title

= 2.13.1 - 17 May 2022 =
  * ADD: Plugin Instance Protection
  * ADD: PublishPress Series support to Content Display block
  * FIX: Don't display post info and categories/tags, taxonomies wrappers when empty for Content Display block
  * FIX: Reset categories attribute when changing post type
  * FIX: Duplicated padding/margin icons for Info Box block
  * FIX: Forced scroll to top issue in editor caused by masonry in Content Display block

= 2.13.0 - 26 Apr 2022 =
  * ADD: Target support to author link for Content Display block
  * FIX: Make responsive headings translatable
  * REMOVE: Deprecated profiles post type and its capabilities

= 2.12.0 - 30 Mar 2022 =
  * ADD: Ad to upgrade to Pro for Advanced List, Count Up, Testimonial and Advanced Image blocks
  * ADD: Updated translations for Spanish (ES), French, Norwegian and Danish
  * ADD: Spanish (MX) translations
  * ADD: Id attribute to Count Up block
  * ADD: Center alignment through CSS file for Count Up block
  * ADD: Block id as class to Content Display block
  * FIX: Check if category exists when outputting blocks in access screen
  * FIX: Text format for counter displayed as raw HTML in frontend for Count Up block
  * FIX: Duplicated id for Testimonial block
  * FIX: Title and subtitle output with RichText for Advanced Image block
  * FIX: Title and text output with RichText for Images Slider block
  * FIX: Tags attribute messing with CPT in frontend after switching from post to CPT
  * FIX: Load styles in frontend for Content Display block
  * REMOVE: Inline center alignment for Count Up block

= 2.11.6 - 10 Mar 2022 =
  * ADD: Improved design for Advanced Tabs remove and add settings
  * ADD: Ad to upgrade to Pro for Images Slider block
  * ADD: Missing Spanish translations
  * REMOVE: Manual block registration for Legacy Widget and Widget Area
  * FIX: Legacy Widget is always activated and can't be disabled
  * FIX: Local video cropped in mobile for Advanced Video block
  * FIX: Default text color for outlined styles in frontend for Advanced Button block
  * FIX: Check current user role exists as array in advgb_blocks_user_roles option
  * FIX: Get all the taxonomy values for CPT filters in Content Display block
  * FIX: Text format displayed as raw HTML in frontend for Count Up block
  * FIX: Handle editor javascript as separate file to load when Block Access is enabled

= 2.11.5 - 14 Feb 2022 =
  * ADD: Ad to upgrade to Pro for Advanced Tabs, Advanced Accordions and Content Display blocks

= 2.11.4 - 8 Feb 2022 =
  * ADD: Set Block Access as disabled for new installations
  * ADD: Disable Table of Contents in Site Editor
  * FIX: Include 0 on the left when hours or minutes are 0-9 for Newsletter and Contact Form blocks
  * FIX: Don't unregister widget blocks
  * FIX: Warning when missing Legacy widget in Block Access
  * FIX: Add a visual indicator the Tabs style is selected for Advanced Tabs block
  * FIX: Don't load post-sidebar.js in Site Editor screen
  * FIX: Load assets in frontend for pages generated through Site Editor
  * FIX: Load CSS in Site Editor
  * FIX: Adapt scripts enqueue from Pro to make it compatible with Site Editor
  * FIX: New block types already registered error in console
  * FIX: Login / Register Form design in Site Editor
  * FIX: Duplicated id for Info Box block
  * FIX: UI settings in Site Editor
  * FIX: Load Dashicons in Site Editor iframe
  * FIX: Padding Unit for Mobile in frontend for Columns Manager block
  * FIX: Include in Gutenberg Site Editor the blocks stored in advgb_blocks_list option but not detected by Block Access

= 2.11.3 - 17 Jan 2022 =
  * ADD: Sanitization cleanup
  * ADD: Improve escaping output
  * FIX: typeof function for block icons
  * FIX: Timeout when editing a cell for Advanced Table block
  * FIX: Change cell content onClick for Advanced Table block
  * FIX: Don't output CSS properties in frontend when values are empty for Advanced Button, Search Bar and Login / Register blocks

= 2.11.2 - 4 Jan 2022 =
  * ADD: Nonce to block forms
  * ADD: Add capability check for save method
  * ADD: Update form submit fields check
  * ADD: Custom Styles CSS field sanitization
  * ADD: Blocks arrays sanitization
  * ADD: Add redirection when Block Access role is not saved
  * ADD: Clearer "Block Access can't be saved" message
  * ADD: Check to load vendor just once
  * FIX: Top Pro banner Javascript resize conflict with WooCommerce in admin dashboard
  * FIX: "wp-editor" call notice in Widgets
  * FIX: Don't run Summary block code in Widgets
  * FIX: Check if we're in Widgets or Post edit screen to define some variables for Content Display block
  * FIX: Slow content refresh for Content Display block
  * FIX: Update to Reviews library v1.1.18
  * FIX: Use wp-customize-widgets dependency in customizer screen
  * FIX: Notice and warnings in Widgets when trying to update Block Access User Roles with possible missing block
  * FIX: Check the right nonce for Custom styles
  * FIX: Disable save form functionality when PublishPress blocks are disabled for Newsletter and Contact Form blocks

= 2.11.1 - 27 Oct 2021 =
  * ADD: Ask for review library through composer
  * FIX: Hide inserter for Advanced Tab item to avoid inserting automatically tabs inside tabs
  * FIX: One accordion item in new Advanced Accordion block insertions
  * FIX: Don't allow to insert Advanced Tabs and Tab items blocks inside Tabs

= 2.11.0 - 20 Oct 2021 =
  * ADD: New ask for review system
  * ADD: Design improvements for review system
  * ADD: Setting to disable blocks from PublishPress Blocks plugin
  * ADD: Order option by "oldest to newest" to Woo Products block
  * ADD: Support for incoming renewed Gallery Block to integrate with "Open galleries in lightbox"
  * ADD: Support for headings inside Cover and Group for Table of Contents block
  * REMOVE: developer_documentation.html
  * REMOVE: Google+ icon from Social Links block
  * FIX: Console warnings and errors when Custom Styles is disabled
  * FIX: Undefined variable $saved_settings when checking for Gallery block lightbox settings in frontend
  * FIX: Legacy widgets are not available from migrated default Profile to Block Access
  * FIX: Custom Styles javascript validation load
  * FIX: Featured image display in editor when post type is page for Content Display block
  * FIX: window._wpLoadGutenbergEditor is deprecated
  * FIX: Forced margin-bottom and margin-top when using Editor width different to inherit
  * FIX: Attribute in default configuration for Advanced List block
  * FIX: frontend.js text from Newsletter block support translations

= 2.10.5 - 14 Sep 2021 =
  * REMOVE: New ask for review system

= 2.10.4 - 14 Sep 2021 =
  * ADD: New ask for review system
  * ADD: Forced deactivation for Container block through Block Access screen
  * ADD: Completed Spanish translation
  * ADD: Unique JSON translation file to cover all the JS files that needs translation
  * ADD: Setting to disable Block Access
  * ADD: Setting to disable Custom Styles
  * REMOVE: Old custom_styles.css delete file process
  * REMOVE: JUFeedback system

= 2.10.3 - 23 Aug 2021 =
  * FIX: Other Block Access by User Roles being deleted when updating advgb_blocks_list

= 2.10.2 - 23 Aug 2021 =
  * ADD: Block Access by User Roles
  * REMOVE: Block Access Profiles
  * FIX: "Block is already registered" errors in console
  * FIX: Author filter for Products post type in Content Display block

= 2.10.1 - 17 Aug 2021 =
  * REMOVE: Block Access by User Roles
  * ADD: Block Access Profiles
  * REMOVE: Fix "Block is already registered" errors in console

= 2.10.0 - 16 Aug 2021 =
  * ADD: Block Access by User Roles
  * REMOVE: Block Access Profiles
  * FIX: "Block is already registered" errors in console

= 2.9.2 - 4 Aug 2021 =
 * ADD: Toggle to disable all the avatars for Testimonial block
 * ADD: Upgrade to Pro admin page
 * FIX: Label to reset avatar for Testimonial block
 * FIX: Text format displayed as raw HTML in frontend for Advanced Tabs block
 * FIX: Images Slider exponential width inside Columns Manager block
 * FIX: Use Global Columns Visual Guide class in Widgets
 * FIX: Text format displayed as raw HTML in frontend for Testimonial block
 * FIX: CSS conflicts in admin with third party plugins
 * FIX: Icon Selection button compatibility with Gutenberg 11 for Advanced Icon and Info Box blocks
 * FIX: Content Display block image width when inserting through Widgets area
 * REMOVE: Table of Contents block in Widgets area

= 2.9.1 - 20 Jul 2021 =
 * FIX: Legacy Widgets and Widget Area blocks support for profiles

= 2.9.0 - 19 Jul 2021 =
 * ADD: Support for PublishPress Blocks in widgets.php page
 * ADD: Support for Block Access to Widget areas
 * ADD: Assets loading in Widget areas in frontend
 * ADD: Custom styles support for widgets
 * ADD: Patch for Twenty Twenty-One theme, footer widgets columns in frontend for Slick
 * ADD: Back color format option to Advanced Accordion block
 * FIX: Adjust blocks preview CSS for Widgets area
 * FIX: Woo Products slideshow in frontend
 * FIX: Warning for profiles without assigned users in Block access list
 * FIX: Label to show posts from current user for Content Display block
 * FIX: Customizer preview for Content Display, Woo Products, Testimonial, Images Slider and Advanced Image blocks
 * FIX: Cropped blocks display in widgets customizer for Login/Register and Search Bar
 * REMOVE: Deprecated filter `block_categories`. Replaced with `block_categories_all`
 * REMOVE: Sidebar settings on widgets page and theme customizer

= 2.8.2 - 7 Jul 2021 =
 * ADD: Show only posts from current user setting for Content Display block
 * ADD: Custom styles support to Image block
 * ADD: Description to choose columns layout for Columns Manager block
 * FIX: Spacing between columns preview in editor for Columns Manager block
 * FIX: Load and resize triggers for Masonry view for Content Display block
 * FIX: Blocks spacing in editor
 * FIX: Focus for tabs in Advanced Tabs block in Twenty Twenty-One theme in frontend
 * FIX: Duplicated id for Advanced Tabs block
 * REMOVE: !important property for margin-bottom and margin-top for each block in editor

= 2.8.1 - 28 Jun 2021 =
  * ADD: Increase max padding and margin for Columns manager and Column blocks
  * ADD: Rename "Summary" block to "Table of Contents"
  * ADD: Translation support to javascript for block Settings popup
  * ADD: Setting to display images on the right for Content Display's block List view
  * ADD: Setting to not display placeholder featured image for Content Display block
  * FIX: Default color and background values when are empty in frontend for Advanced Button blocks
  * FIX: Default label for custom styles dropdown in editor
  * FIX: Spacing for Custom styles dropdown in editor
  * FIX: Enable Contributor and Subscriber in "All User Roles" profile
  * FIX: Block Settings popup spacing
  * FIX: Language support in Block Settings
  * FIX: Spacing for Content Display block in Grid and List views
  * FIX: Navigation dots margin for Slider view in Content Display block
  * FIX: Autoplay in frontend when loading more than once instance of Content Display's block with Slider view
  * FIX: Adjust Number of items when selecting a Newspaper layout for Content Display block
  * FIX: Timezone for date time in Content Display block
  * FIX: Advanced Accordion content overlay
  * FIX: Duplicated Blocks links in admin when having Free and Pro plugins activated
  * FIX: PublishPress Blocks category is listed twice in editor when having Free and Pro plugins activated
  * FIX: RTL support for Images Slider block

= 2.8.0 - 15 Jun 2021 =
  * ADD: Rename menu to "Blocks"
  * ADD: Ask for review popup after 1 week
  * ADD: Load only custom styles in use in frontend
  * ADD: Block Access layout improvements
  * ADD: Roles and Users to Block Access profiles list
  * ADD: Overlay image caption option for Gallery blocks
  * ADD: HTML tag options for the Header in Advanced Accordion Block
  * FIX: Fix long broken taxonomy display for Content Display block
  * FIX: Editor preview when changing number of items in Masonry view for Content Display block
  * FIX: Hook when plugin is activated
  * FIX: Advanced List transform can break the editor page after is converted into List block
  * REMOVE: Author and Date from Block Access profiles list

= 2.7.1 - 31 May 2021 =
  * ADD: Preview for custom styles in editor
  * ADD: Support for custom styles to heading, list, code, preformatted, table, columns and group blocks
  * ADD: Spacing optimization for Advanced List block
  * ADD: More icons to Advanced List block
  * FIX: Original editor width inherit theme's editor width
  * FIX: Filter product status as Featured for Woo Products block
  * FIX: Undefined HTTP_REFERER for Login / Register Form block
  * FIX: Duplicated ID when duplicating Advanced List block
  * FIX: Warning in frontend when switching to a different post type but keeping previous post type taxonomies
  * FIX: Warning for taxonomy loop

= 2.7.0 - 18 May 2021 =
  * ADD: Custom Post Type support for Content Display block
  * ADD: Autoplay control to Slider view for Content Display block
  * ADD: Top notice in admin with link to Pro version
  * ADD: Lighter color scheme for sidebar menu in admin
  * FIX: Default image load in editor for WooProducts block
  * FIX: Web Stories block by Google not available in editor
  * FIX: Multiple email addresses in Email settings

= 2.6.2 - 22 Apr 2021 =
  * ADD: CSS properties to images for Content Display block to avoid inherit styles from themes
  * REMOVE: Load block's CSS through wp_add_inline_style function

= 2.6.1 - 21 Apr 2021 =
  * ADD: Load PublishPress Blocks category as first in Gutenberg editor
  * ADD: "Content Display" as new name for Recent Posts block
  * ADD: "Posted on" and "Updated on" labels before modified date
  * ADD: Caption support to Content Display block
  * ADD: Exclusion support to Content Display block
  * ADD: Masonry view with responsive support to Content Display block
  * ADD: Filters panel to group category, tags, author and exclusion settings for Content Display block
  * ADD: Recursive method to load CSS for blocks in frontend
  * FIX: Load dynamic block's CSS through wp_add_inline_style function
  * FIX: Background for Frontapage view's Boxed style for Content Display block
  * FIX: Use rgba border color in Newspaper view for Content Display block
  * REMOVE: "ADVGB" from Content Display and WooProducts blocks when loading in editor

= 2.6.0 - 12 Apr 2021 =
  * ADD: Compressed CSS files only
  * ADD: Tags support to Recent Posts block
  * ADD: PublishPress Authors support to Recent Posts block
  * ADD: Frontpage view with responsive, styles and gap support to Recent Posts block
  * ADD: Page support to Recent Posts block
  * ADD: Exclude current post support to Recent Posts block
  * ADD: Post Time support to Recent Posts block
  * ADD: Display Categories and Tags to Recent Posts block
  * ADD: Better organization for Recent Posts block settings
  * ADD: Comment count support to Recent Posts block
  * ADD: AdvQueryControls component with customizations
  * ADD: Modified and Posted date with relative format support to Recent Posts block
  * ADD: Setting to display Featured Images for the first posts only to Recent Posts block
  * ADD: Allow custom text/HTML after post title and before Read more to Recent Posts block
  * ADD: Slider view styles support to Recent Posts block
  * ADD: More options for the order of posts to Recent Posts block: by author, modified date, ID and random
  * ADD: Newspaper view with multiple layouts support to Recent Posts block
  * ADD: Load Recent Posts CSS in frontend only when using Recent Posts blocks
  * ADD: Author filter to Recent Posts block
  * ADD: PublishPress Author support through author filter to Recent Posts block
  * ADD: File structure and validations to share with PublishPress Blocks Pro
  * FIX: Duplicated ID when duplicating Search Bar block
  * FIX: Formatting output for editable elements in frontend for Login/Register block
  * FIX: "Horizontal Alignment" label for Advanced Image default configuration
  * FIX: Email validation for Newsletter block
  * FIX: Hours and minutes time record for Newsletter block
  * FIX: Allowed formats for name and position fields in Testimonial block
  * FIX: Cyrillic text output in frontend for Recent Posts block
  * FIX: Broken Advanced Tabs block in frontend when using an HTML Anchor
  * FIX: Columns Manager and Columns blocks edit inside Advanced Tabs
  * FIX: Support for nested blocks until 11th level
  * REMOVE: Non production files such as SCSS, JSX, etc.
  * REMOVE: Not required formatting for editable elements for Login/Register block
  * REMOVE: Static font-size for post titles for Recent Posts block

= 2.5.7 - 8 Mar 2021 =
 * ADD: Separate pages for Settings and Default block settings
 * ADD: Multiple category support to Recent Posts block
 * FIX: Alt attribute for img tag in Images Slider block
 * FIX: Hide notification when asking for a review
 * FIX: Double border-top in editor for body in Advanced Accordion block
 * FIX: Notice when no featured image exists while editing/creating posts
 * FIX: Collapsed Order RTL in mobile for Columns Manager block
 * FIX: Full width alignment for Advanced Button block
 * FIX: Allowed formats support for Advanced Button block
 * FIX: UI text alignment in cell settings for Advanced Table block
 * FIX: Slick Theme CSS for WordPress 5.7
 * REMOVE: Obsolete Translations page
 * REMOVE: AdvQueryControls component
 * REMOVE: Wide width alignment option for Advanced Button block
 * REMOVE: Refresh option for Advanced Button block

= 2.5.6 - 23 Feb 2021 =
 * FIX: Bug in deprecation for Advanced Accordion block from v2.5.5
 * REMOVE: Full path in compiled JavaScript

= 2.5.5 - 17 Feb 2021 =
 * ADD: Bigger font-size for custom styles in new plugin installations
 * ADD: Newest version of Material Icons
 * FIX: Center alignment for Advanced Table block
 * FIX: Testimonial block breaking editor
 * FIX: Preview images styles for Advanced Button block
 * FIX: Advanced Image duplication id
 * FIX: Display symbol inline with number in Count Up block in editor
 * FIX: Deprecated code for Advanced Accordion block
 * FIX: Border width 0px for Advanced Accordion block
 * FIX: A language string for Columns Manager block
 * FIX: Columns Visual Guide and Editor Width notices while editing a post/page
 * FIX: Editor width change for individual pages/posts when "original" is set in Global configuration
 * FIX: Dashicons display in Profile edit
 * REMOVE: Unnecessary allowed formats for Advanced Accordion header
 * REMOVE: Format options for Advanced Image block

= 2.5.4 - 4 Feb 2021 =
 * FIX: Deprecated code for Advanced Button block
 * FIX: Deprecated code for Advanced Accordion block
 * FIX: Deprecated code for Advanced Image block
 * FIX: Deprecated code for Advanced List block
 * FIX: Deprecated code for Advanced Table block
 * FIX: Deprecated code for Advanced Video block
 * FIX: Deprecated code for Columns Manager block
 * FIX: Deprecated code for Images Slider block
 * FIX: Deprecated code for Login / Register block
 * FIX: Deprecated code for Recent Posts block
 * FIX: Deprecated code for Social Links block
 * FIX: Deprecated code for Summary block
 * FIX: Deprecated code for Woo Products block

= 2.5.3 - 21 Jan 2021 =
 * FIX: Advanced Button and Advanced Icon duplication id
 * FIX: Deprecated prop for Advanced Button block
 * FIX: Editor width and Columns visual guide settings in WordPress 5.6
 * ADD: Darker border color for Columns visual guide

= 2.5.2 - 14 Jan 2021 =
 * FIX: Summary block style and better CSS handling for margin-left
 * FIX: Ajax call to update the block list in db
 * FIX: Deprecated core/editor to core/block-editor Namespace
 * FIX: Introduced bug in 2.5.1 for gallery lightbox target
 * ADD: Better gallery lightbox target support

= 2.5.1 - 11 Jan 2021 =
 * ADD: Anchor support for all the blocks, except: Adv. Icons, Columns Manager, Info Box, Recent Posts and Testimonial
 * FIX: Fix gallery lightbox target to open a bigger version of the image (hughworm)
 * ADD: Better CSS selector for Advanced List block
 * FIX: Space between columns pushing content off in Columns Manager blocks
 * REMOVE: Old CSS approach for Columns Manager columns and layouts
 * FIX: Advanced Button center alignment in editor

= 2.5.0 - 9 Dec 2020 =
 * ADD: "PublishPress Blocks" as new plugin's name
 * ADD: New admin design
 * ADD: Support for javascript translations
 * ADD: More translation strings for Italian
 * ADD: More translation strings for Spanish (Spain)
 * FIX: Strings that are saved as static content

= 2.4.7 - 19 Oct 2020 =
 * FIX: Global columns visual guide
 * FIX: Deprecated isDefault replaced with isSecondary
 * FIX: Hidden text in selected button groups on content Gutenberg sidebar
 * FIX: Custom class support for Advanced Icon and Info Box blocks
 * FIX: Tooltips in configuration pages

= 2.4.6 - 16 Sep 2020 =
 * FIX: Support for nested blocks in 5th level

= 2.4.5 - 3 Sep 2020 =
 * FIX: Load Custom Styles in multisites
 * ADD: Optimize blocks style loading

= 2.4.4 - 24 Aug 2020 =
 * FIX: Recent Posts block, broken Category setting
 * ADD: AdvQueryControls component

= 2.4.3 - 17 Aug 2020 =
 * FIX: Load common CSS for nested blocks

= 2.4.2 - 14 Aug 2020 =
 * FIX: Styles not loading in frontend for nested blocks in WordPress 5.5

= 2.4.1 - 11 Aug 2020 =
 * FIX: Border width for Advanced Button Block
 * FIX: Missing Thickbox CSS loading

= 2.4.0 - 5 Aug 2020 =
 * REMOVE: JU Translation system
 * ADD: Native language files support
 * ADD: Support for language overrides created with version 2.3.11 and older
 * ADD: Support for more translations (Danish, German, Spanish, French, Italian, Japanese, Polish, Romanian and Chinese)
 * FIX: "Enable" option for columns visual guide setting while editing
 * FIX: Forward slash in tooltip in Map block
 * FIX: Broken strong and em HTML tags in Tabs block headers
 * FIX: Load reCaptcha in Login/register, Contact form and Newsletter blocks only when required in frontend
 * FIX: Load Google Maps API in Map block only when required in frontend

= 2.3.11 - 22 Jun 2020 =
 * FIX: Improve default background position for new Advanced image block

= 2.3.10 - 8 Jun 2020 =
 * FIX: Blocks spacing
 * FIX: Default background position for new Advanced image block

= 2.3.9 =
 * FIX: Wrong cell tag name in table head of Advanced Table block

= 2.3.8 =
 * FIX: Missing list content when convert the list block to advanced list block
 * FIX: Display the overlay and action on click in Image Slider block

= 2.3.7 =
 * FIX: Image Slider on rtl language
 * FIX: Columns block not display full width with 1 column layout

= 2.3.6 =
 * FIX: Icon block error invalid content
 * FIX: Editor width option not working

= 2.3.5 =
 * FIX: Tabs block error in version 2.3.3
 * FIX: Tabs block transform to Advanced Tabs block

= 2.3.4 =
 * ADD: Load Advanced Gutenberg resources (JS/CSS) only when a block is called
 * ADD: Gutenberg plugin 7.3 compatibility
 * FIX: Active tab color does not apply
 * FIX: Change way to load resource

= 2.3.3 =
 * FIX: Reusable Tabs block
 * FIX: Reusable Advanced Accordion block
 * FIX: Gutenberg 7.2 compatibility
 * FIX: Migration from old version of Tab block

= 2.3.2 =
 * FIX: Translation sharing issue in some browsers

= 2.3.1 =
 * ADD: Tab body border style change to NONE in (Tabs block)
 * FIX: Margin in Table block
 * FIX: HTML Anchor structure in Summary block
 * FIX: Keep href attribute if not set action on click in Image Slider block
 * FIX: Use a local path instead an http in icon blocks: Icon Block, Info Box Block
 * FIX: Fix column spacing in backend when working with plugin gutenberg in Columns Manager block;

= 2.3.0 =
 * ADD: New block: Advanced Icon block
 * ADD: New block: Info Box block
 * ADD: Advanced Video: add autoplay, loop, preloading
 * ADD: Better slug in Summary block
 * ADD: Upgrade jquery library for Count Up block
 * ADD: Update block preview images
 * FIX: Compatibility with Gutenberg version 7.1.0

= 2.2.2 =
 * FIX: Columns manager frontend grid
 * FIX: Recent Posts block return PHP error if don't have post
 * FIX: Cover block toolbar is hidden
 * FIX: Missing Add Block area of nested block inside Tabs block
 * FIX: Add spacing in backend block columns

= 2.2.1 =
 * FIX: Frontend testimonial block not working inside Columns block with 1 column layout
 * FIX: Missing padding units in columns block

= 2.2.0 =
 * ADD: Tabs block: Rework Tabs block, allow nested block in tabs
 * ADD: Tabs block: news design and new option for design
 * ADD: Testimonial block: Improve slider view, new option for slider effects
 * ADD: Testimonial block: add design options, add avatar position setting
 * ADD: Columns block: Add max height for each line
 * ADD: Adv Button block: Add margin settings
 * ADD: Accordions block: Show settings on all accordion levels
 * ADD: Maps block: Add settings to show marker tooltip by default
 * ADD: Adv Image block: Add focal point picker, block alignment, default opacity settings
 * ADD: Add a defulat svg image for test purpose when none is selected
 * ADD: Add back profile list

= 2.1.5 =
 * FIX: Material fonts missing

= 2.1.4 =
 * ADD: Add Opt In feedback on plugin first disabling & review message

= 2.1.3 =
 * FIX: Default editor width now apply the Gutenberg default width (750px)
 * FIX: HTML tag is rendered on accordions header

= 2.1.2 =
 * FIX: Count Up block: br tag is shown as text on front-end
 * FIX: Count Up block: check counter type to avoid render NaN

= 2.1.1 =
 * FIX: Error on login block with Gutenberg core

= 2.1.0 =
 * ADD: Login/Register Form block: Easy to create login and register form
 * ADD: New Search bar block: Create a search bar block
 * ADD: New Accordions Wrapper block: group accordions elements
 * ADD: Adv Button block: add predefined styles and hover opacity
 * FIX: Adv Table block: block error on headers in some cases
 * FIX: Cannot verify newsletter form captcha

= 2.0.7 =
 * FIX: Some blocks missing styles when using as Reusable blocks
 * FIX: Remove notice on Container block

= 2.0.6 =
 * ADD: Show Count Up symbol on editor
 * ADD: Allow nested Accordion blocks
 * ADD: Allow to change the html tag of the Container block
 * FIX: Bring back the Container block (can be enabled in profile)
 * FIX: Add missing classname for Count Up block on editor
 * FIX: Remove inline styles from Summary block

= 2.0.5 =
 * FIX: Compatible with Gutenberg v6.1.0

= 2.0.4 =
 * FIX: Prefix all Column Manager css class to avoid conflicts
 * FIX: Columns Visual Guide not activate on fresh install
 * FIX: Keep custom block class when transform Container block to Columns Manager block

= 2.0.3 =
 * FIX: Add back Container block and allow to convert it to Columns Manager block
 * FIX: Fix Jutranslation url

= 2.0.2 =
 * FIX: Blocks not loaded on WP version < 5.2 without Gutenberg plugin

= 2.0.1 =
 * FIX: Remove empty inline style tags
 * FIX: Remove unneeded styles to avoid conflict with theme styles

= 2.0.0 =
 * ADD: New block: Columns Manager with predefined sizes
 * ADD: Multiple responsive options on the column manager
 * ADD: New editor menu to choose editor width
 * ADD: New editor menu to display/hide column visual guides
 * ADD: Compatible with Gutenberg v5.9
 * ADD: Drop support for PHP version < 5.6.20
 * ADD: Remove Container block (replaced by column manager)
 * ADD: Remove custom columns and custom separator block settings
 * FIX: Map block not showing on IE
 * FIX: Recent Posts block: Compatible with WPML
 * FIX: Remove empty HTML element on Map block, Image Slider block, Adv Image block

= 1.10.12 =
 * ADD: Adv Table block: Add more border options on range selection
 * ADD: Adv Table block: Allow to enable table header and footer
 * ADD: Adv Table block: Add table predefined styles choosing
 * ADD: Adv Table block: Add option to enable cells fixed width and table border collapsed
 * FIX: Images Slider block: Replace drag and drop ordering by arrow button
 * FIX: Click on slider item of the block not focused on it

= 1.10.11 =
 * ADD: Notice incoming dropping support of PHP version < 5.6.20
 * FIX: Not disable wpautop function by default

= 1.10.10 =
 * ADD: Add option to disable wpautop (automatic paragraph)
 * FIX: Support RTL language in blocks
 * FIX: Lightbox with multi-galleries per page load group image only

= 1.10.9 =
 * ADD: Accordion block: allow to make all accordion collapsed by default
 * FIX: Improve compatibility with other plugins (slider revolution)

= 1.10.8 =
 * FIX: Adv Table block: bring back padding setting to cell
 * FIX: Adv Table block: Improve typing experience
 * FIX: Recent Posts block: post text as excerpt not displayed properly (frontend)

= 1.10.7 =
 * FIX: Reusable block not loaded properly on frontend
 * FIX: Testimonial block: cannot add columns

= 1.10.6 =
 * FIX: Paragraph block error
 * FIX: Adv Video block: custom width for remote video not work in some theme
 * FIX: Adv Video block: display error if fetching remote video fail
 * FIX: Adv Video block: video full width not working without lightbox
 * FIX: Testimonial block: odd behaviour if columns value is empty

= 1.10.5 =
 * ADD: Left panel responsive in plugin settings
 * ADD: Recent Posts block: add default post thumbnail
 * ADD: Recent Posts block: allow to custom read more label
 * FIX: Recent Posts block: slider view not loaded on frontend
 * FIX: Testimonial block: add responsive for slider view

= 1.10.4 =
 * FIX: Blocks validation error on multisite and author users

= 1.10.3 =
 * FIX: Compatibility with Wordpress 5.1.0
 * FIX: Summary block broken on post page reload
 * FIX: Group Advanced Gutenberg blocks to a dedicated category

= 1.10.2 =
 * FIX: Google recaptcha validation error

= 1.10.1 =
 * ADD: Posibility to edit link target type on Adv Image block
 * ADD: Make captcha above the submit button in Contact Form
 * FIX: Cannot save multi Recent Posts block
 * FIX: Make Testimonial and Count up block more responsive
 * FIX: When open image in lightbox the page shifted
 * FIX: Remove custom styles ajax saving, use Save Styles button instead

= 1.10.0 =
 * ADD: New container block - A block that contains other blocks
 * ADD: New block: newsletter optin, get and export newsletter emails
 * ADD: Integrate Google reCaptcha in Newsletter and Contact Form block
 * ADD: Custom error label for Newsletter and Contact Form block
 * ADD: Custom map color styles for Maps block
 * ADD: New Testimonial block style: slider view
 * FIX: Cannot use too small image as Map custom marker
 * FIX: Social icons block can not render properly in some rare cases
 * FIX: Testimonial block: Let br tag show correctly on front end
 * FIX: Products block: Cannot load show all products categories
 * FIX: Recent posts block extra classes prevent Gutenberg save
 * FIX: Tooltip icon to the label that has tooltip

= 1.9.2 =
 * FIX: Cannot save Recent Posts block inside Columns

= 1.9.1 =
 * FIX: Compatibility with 3rd party Gutenberg blocks (including Elementor)
 * FIX: Validation error on Table block
 * FIX: Add button to clear custom styles of Columns and Separator (before block removal)

= 1.9.0 =
 * ADD: New block: Contact Form, receive and download contact form data
 * ADD: Settings to define editor admin width: Default, large, Full width
 * ADD: Change default state of social icons align to center
 * FIX: Advanced Table block: Error while set cell color color in some cases
 * FIX: WooCommerce Products block: Error while load product without image
 * FIX: Social link block: add support for png and small size image
 * FIX: Remove Custom Separator block and Custom Columns block settings

= 1.8.2 =
 * FIX: Error on post page using WP 4.9

= 1.8.1 =
 * FIX: New blocks not loaded in WP 5.0
 * FIX: Php notice in Recent posts block

= 1.8.0 =
 * ADD: New Images Slider block: Show your images in slider view with various styles
 * FIX: Accordion block: Split block to separate accordion, allow to insert other blocks inside it
 * FIX: Compatibility with WP 5.0.0

= 1.7.6 =
 * ADD: Adv Table block: Reformat block structure and allow to style for multi cells, allow to transform from core Table block
 * FIX: Validation issue when clear color styles of some blocks
 * FIX: Compatibility with Gutenberg ver 4.5.0

= 1.7.5 =
 * FIX: Compatibility with Gutenberg ver 4.1.0

= 1.7.4 =
 * FIX: Category on Recent Posts block is not saved
 * FIX: Compatibility with Gutenberg ver 4.1 rc1

= 1.7.3 =
 * FIX: Compatibility with Gutenberg ver 4.0 rc1

= 1.7.2 =
 * FIX: Error when Woocommerce is not installed

= 1.7.1 =
 * FIX: Cannot show products with some filter on backend (WooCommerce Block)

= 1.7.0 =
 * ADD: New Recent Posts block with 3 layouts Grid, List and Slide
 * ADD: WooCommerce Products block with 2 layouts Normal and Slide
 * FIX: Cannot set styles for Header text (Tab blocks)
 * FIX: Error on Map block if no Google API provided
 * FIX: Add default select option on Blocks Config

= 1.6.7 =
 * FIX: Blocks not listed on first installation

= 1.6.6 =
 * ADD: List automatically new installed blocks in profiles and in edition modes
 * FIX: PHP Warning in block listing
 * FIX: Table block styling not rendered on frontend
 * FIX: Summary block not rendered inside Gutenberg column

= 1.6.5 =
 * FIX: Apply default color for block icon on first install
 * FIX: Cannot update blocks list on Gutenberg ver 3.8

= 1.6.4 =
 * FIX: Cannot change tab on front-end in some rare cases (Tabs block)

= 1.6.3 =
 * ADD: Adv Table block: Add ability to split merged cells to normal cells
 * ADD: Adv Table block: Add styles indicator for multi-selected cells
 * FIX: Adv Table block: Compatible with Gutenberg version 3.7.0
 * FIX: Adv Table block: No longer can transform from core Table block
 * FIX: Adv Table block: Add styles indicator for multi-selected cells
 * FIX: Remove top border in Advanced Tab block

= 1.6.2 =
 * FIX: Cannot change menu on Firefox
 * FIX: Cannot re-edit title and subtitle when its empty (Adv Image block)

= 1.6.1 =
 * FIX: PHP warning when install plugin for the first time
 * FIX: Blocks with custom category not showing in Profile
 * FIX: Poster not change after fetching video from remote host (Adv Video block)

= 1.6.0 =
 * ADD: New fresh designed backend UI/UX
 * ADD: Implement AJAX admin search engine in plugin settings
 * ADD: Default config for Advanced Gutenberg blocks
 * ADD: New option to define Advanced Gutenberg blocks icon color
 * ADD: New custom CSS style edition interface
 * ADD: Add a search engine to filter blocks in profile block attribution
 * ADD: Add a dedicated left menu for all the configuration named PublishPress Blocks
 * FIX: Compatibility with Gutenberg version 3.6.2
 * FIX: Compile all blocks styles to a single file for faster load

= 1.5.2 =
 * FIX: Compatibility with Gutenberg version 3.2.0

= 1.5.1 =
 * FIX: Add option to toggle blocks spacing setting
 * FIX: Blocks still show on Gutenberg even disabled from profile

= 1.5.0 =
 * ADD: New block: Accordion block
 * ADD: New block: Tabs block
 * ADD: New block: Social links block
 * ADD: Option to define default vertical spacing between blocks (frontend)
 * FIX: Advanced Video block: Not override poster after fetching video
 * FIX: Error while updating blocks list on profile

= 1.4.0 =
 * ADD: New block: Map block
 * ADD: New block: Advanced Video block
 * ADD: New block: Advanced Table block
 * ADD: New options to add margin & padding on Columns and Text Columns block
 * FIX: Update code format to match latest Gutenberg release

= 1.3.0 =
 * ADD: New block: Testimonial block
 * ADD: New block: Advanced Image block
 * ADD: New block: Counter (count up) with symbol
 * ADD: New options to customize Separator block
 * FIX: Make block icons in profile display properly like in Gutenberg

= 1.2.1 =
 * FIX: Improve code format and compatibility

= 1.2.0 =
 * ADD: New Advanced Button block: create button with more styles (hover, border, padding...)
 * ADD: New Advanced List block: create list with list icon, icon color...
 * ADD: Summary block: Allow to set anchor links color, block alignment and load summary in minimized
 * ADD: New summary block option: load the block minimized and define text
 * ADD: New style for summary block: align the block + font style and color options
 * FIX: Improve compatibility with other plugins

= 1.1.0 =
 * ADD: Create custom CSS styles and apply to paragraph blocks
 * ADD: Identify CSS property by: name, class and color
 * ADD: New Summary block: Insert Gutenberg summary based on content headers

= 1.0.1 =
 * FIX: Compatibility with Gutenberg version 2.2.0

= 1.0.0 =
 * ADD: Initial version
 * ADD: Blocks access: Define which editor blocks Users / User roles can use
 * ADD: Make gallery blocks images can be opened in a popup lightbox
 * ADD: Option to display alt text as caption when a gallery lightbox is opened
