<?php


namespace rednaowooextraproduct\core\Managers\SlateGenerator\Text;


use rednaowooextraproduct\core\Managers\SlateGenerator\Core\HtmlTagWrapper;
use rednaowooextraproduct\core\Managers\SlateGenerator\Core\NodeElementBase;
use rednaowooextraproduct\core\Managers\SlateGenerator\Core\SlateElementBase;

class Text extends NodeElementBase
{


    public function GetNodeName()
    {
        return 'div';
    }

    public function Process()
    {
        $this->Node->AddStyles(array('display'=>'inline'));
        parent::Process(); // TODO: Change the autogenerated stub
    }


    public function SetText($text)
    {
        /** @var Span $span */
        $span=$this->Children[0];

        if(!$span instanceof Span)
            return;

        $span->SetText($text);
    }

    /**
     * @return HtmlTagWrapper
     */
    public function CloneDomSpan()
    {
        /** @var Span $span */
        $span=$this->Children[0];

        if(!$span instanceof Span)
            return null;

        return $span->ConeDomSpan();

    }
}