<?php

namespace rednaowooextraproduct\core\Managers\EmailManager;

use PHPUnit\Framework\TestCase;
use rednaowooextraproduct\core\Managers\FormManager\FormBuilder;
use rednaowooextraproduct\tests\Utilities\ProductMocker;

class EmailManager_Test extends TestCase
{
    function testEmailCanBeProcessed(){
        $options=\json_decode('{"Rows":[{"Columns":[{"Field":{"Id":21,"Type":"slider","Label":"Slider","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"none","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","DefaultValue":0,"MaxValue":100,"MinValue":0,"Step":1,"ShowValueTooltip":true},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":20,"Type":"switch","Label":"Switch","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"none","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","Checked":false,"CheckedIcon":{"ImageType":"icon","Ref":{"prefix":"fas","iconName":"check","icon":[512,512,[],"f00c","M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z"]}},"UnCheckedIcon":{"ImageType":"icon","Ref":{"prefix":"fas","iconName":"times","icon":[352,512,[],"f00d","M242.72 256l100.07-100.07c12.28-12.28 12.28-32.19 0-44.48l-22.24-22.24c-12.28-12.28-32.19-12.28-44.48 0L176 189.28 75.93 89.21c-12.28-12.28-32.19-12.28-44.48 0L9.21 111.45c-12.28 12.28-12.28 32.19 0 44.48L109.28 256 9.21 356.07c-12.28 12.28-12.28 32.19 0 44.48l22.24 22.24c12.28 12.28 32.2 12.28 44.48 0L176 322.72l100.07 100.07c12.28 12.28 32.2 12.28 44.48 0l22.24-22.24c12.28-12.28 12.28-32.19 0-44.48L242.72 256z"]}},"CheckColor":"#080","UnCheckColor":"#888"},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":19,"Type":"signature","Label":"Signature","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"none","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","DefaultText":"","Placeholder":""},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":1,"Type":"text","Label":"Text box","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"fixed_amount","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","DefaultText":"","Placeholder":"","FreeCharOrWords":0,"IgnoreSpaces":false,"Icon":{"ImageType":"none","Ref":null}},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":2,"Type":"textarea","Label":"Text area","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"fixed_amount","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","DefaultText":"","Placeholder":"","FreeCharOrWords":0,"IgnoreSpaces":false,"Icon":{"ImageType":"none","Ref":null}},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":3,"Type":"dropdown","Label":"Dropdown","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"options","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","Options":[{"Label":"Option 1","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":1,"Selected":false,"URL":"","AdditionalOptionValue":[]},{"Label":"Option 2","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":2,"Selected":false,"URL":"","AdditionalOptionValue":[]},{"Label":"Option 3","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":3,"Selected":false,"URL":"","AdditionalOptionValue":[]}],"AdditionalOptionColumn":[],"Placeholder":"Please select a value","Icon":{"ImageType":"none","Ref":null}},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":4,"Type":"radio","Label":"Radio","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"options","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","Options":[{"Label":"Option 1","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":1,"Selected":false,"URL":"","AdditionalOptionValue":[]},{"Label":"Option 2","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":2,"Selected":false,"URL":"","AdditionalOptionValue":[]},{"Label":"Option 3","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":3,"Selected":false,"URL":"","AdditionalOptionValue":[]}],"AdditionalOptionColumn":[],"Placeholder":""},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":5,"Type":"checkbox","Label":"Checkbox","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"options","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","Options":[{"Label":"Option 1","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":1,"Selected":false,"URL":"","AdditionalOptionValue":[]},{"Label":"Option 2","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":2,"Selected":false,"URL":"","AdditionalOptionValue":[]},{"Label":"Option 3","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":3,"Selected":false,"URL":"","AdditionalOptionValue":[]}],"AdditionalOptionColumn":[],"Placeholder":"","MaximumNumberOfItems":0},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":6,"Type":"paragraph","Label":"Paragraph","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"Text":"<p>Paragraph field<\/p>"},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":7,"Type":"divider","Label":"","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"Style":"solid","Color":"#dfdfdf","Title":""},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":8,"Type":"datepicker","Label":"Datepicker","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"none","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","DefaultDate":"","Placeholder":"","Format":"dd\/MM\/yyyy","WeekStartOn":0,"Icon":{"ImageType":"none","Ref":null}},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":9,"Type":"masked","Label":"Mask","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"none","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","DefaultText":"","Placeholder":"","MaskType":"phone","Mask":"(999)99-999-999","MaskChar":"_","Icon":{"ImageType":"none","Ref":null}},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":10,"Type":"colorpicker","Label":"Color Picker","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"none","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","DefaultColor":"#ffffff","Placeholder":""},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":11,"Type":"list","Label":"List","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"none","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","EnableMultipleColumns":false,"Columns":[]},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":12,"Type":"fileupload","Label":"File","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"none","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","Value":"","AllowMultipleFiles":false,"AllowedExtensions":"","ButtonLabel":"Add File"},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":13,"Type":"hidden","Label":"","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"none","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","Value":""},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":14,"Type":"imagepicker","Label":"Image Picker","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"options","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","Options":[{"Label":"Option 1","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":1,"Selected":false,"URL":"","AdditionalOptionValue":[]},{"Label":"Option 2","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":2,"Selected":false,"URL":"","AdditionalOptionValue":[]},{"Label":"Option 3","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":3,"Selected":false,"URL":"","AdditionalOptionValue":[]}],"AdditionalOptionColumn":[],"Placeholder":"","ImageWidth":"100%","ImageHeight":"","AllowMultipleSelection":false},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":15,"Type":"repeater","Label":"List","Required":false,"RowId":0,"Conditions":[],"IsFieldContainer":true,"Formulas":[],"PriceType":"sum_of_fields_in_group","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","RowTemplates":[{"Columns":[{"Field":{"Id":0,"Type":"text","Label":"Text box","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"fixed_amount","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","DefaultText":"","Placeholder":"","FreeCharOrWords":0,"IgnoreSpaces":false,"Icon":{"ImageType":"none","Ref":null}},"WidthPercentage":100}]}],"ShowSubTotal":false,"SubTotalLabel":"Subtotal","RepeaterType":"add_remove_button","RepeatNumberOfTimes":1},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":16,"Type":"grouppanel","Label":"List","Required":false,"RowId":0,"Conditions":[],"IsFieldContainer":true,"Formulas":[],"PriceType":"none","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","Rows":[{"Columns":[{"Field":{"Id":18,"Type":"textarea","Label":"Text area","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"fixed_amount","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","DefaultText":"","Placeholder":"","FreeCharOrWords":0,"IgnoreSpaces":false,"Icon":{"ImageType":"none","Ref":null}},"WidthPercentage":100}]}],"ShowSubTotal":false,"SubTotalLabel":"Subtotal"},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":17,"Type":"daterange","Label":"","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"none","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","Format":"dd\/MM\/yyyy","Orientation":"horizontal","StartDate":{"DefaultDate":"","Placeholder":"","Label":"Start Date"},"EndDate":{"DefaultDate":"","Placeholder":"","Label":"End Date"}},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":24,"Type":"buttonselection","Label":"Button Selection","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"options","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","Options":[{"Label":"Option 1","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":1,"Selected":false,"URL":"","AdditionalOptionValue":[],"ImageType":"none","Ref":""},{"Label":"Option 2","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":2,"Selected":false,"URL":"","AdditionalOptionValue":[],"ImageType":"none","Ref":""},{"Label":"Option 3","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":3,"Selected":false,"URL":"","AdditionalOptionValue":[],"ImageType":"none","Ref":""}],"AdditionalOptionColumn":[],"ImagePosition":"left","AllowMultipleSelection":false,"NumberOfColumns":3,"ShowPriceInEachButton":true},"WidthPercentage":100}]},{"Columns":[{"Field":{"Id":25,"Type":"hidden","Label":"Hidden","Required":false,"RowId":0,"Conditions":[],"Formulas":[],"PriceType":"none","Price":"","SalePrice":"","HidePrice":true,"ShowQuantitySelector":false,"QuantityPosition":"bottom","QuantityMinimumValue":0,"QuantityMaximumValue":0,"QuantityDefaultValue":"","QuantityPlaceholder":"","QuantityLabel":"Quantity","Value":""},"WidthPercentage":100}]}],"Extensions":[],"DynamicFieldTypes":["FBSlider","FBSwitch","FBSignature","FBTextField","FBTextArea","FBDropDown","FBRadio","FBCheckBox","FBParagraph","FBDivider","FBDatePicker","FBMaskedField","FBColorPickerField","FBList","FBFile","FBHidden","FBImagePicker","FBRepeater","FBGroupPanel","FBDateRange","FBButtonSelection"],"Version":1,"Styles":"","MapsApiKey":"","Icons":[],"ExtensionsUsed":[]}');
        $entry=\json_decode('{"Fields":[{"Label":"Slider","Id":21,"Type":"slider","PriceType":"none","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":"56"},{"Label":"Switch","Id":20,"Type":"switch","PriceType":"none","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":true},{"Label":"Signature","Id":19,"Type":"signature","PriceType":"none","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":"data:image\/png;base64,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"},{"Label":"Text box","Id":1,"Type":"text","PriceType":"fixed_amount","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":"asdfasdf"},{"Label":"Text area","Id":2,"Type":"textarea","PriceType":"fixed_amount","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":"asdf"},{"Label":"Dropdown","Id":3,"Type":"dropdown","PriceType":"options","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"SelectedValues":[{"Label":"Dropdown","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":2,"Selected":false,"URL":"","AdditionalOptionValue":[],"UnitPrice":0,"Quantity":1,"Price":0,"Value":"Option 2"}]},{"Label":"Radio","Id":4,"Type":"radio","PriceType":"options","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"SelectedValues":[{"Label":"Radio","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":1,"Selected":false,"URL":"","AdditionalOptionValue":[],"Totals":{},"UnitPrice":0,"Quantity":1,"Price":0,"Value":"Option 1"}]},{"Label":"Checkbox","Id":5,"Type":"checkbox","PriceType":"options","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"SelectedValues":[{"Label":"Checkbox","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":3,"Selected":false,"URL":"","AdditionalOptionValue":[],"UnitPrice":0,"Quantity":1,"Price":0,"Value":"Option 3"}]},{"Label":"Datepicker","Id":8,"Type":"datepicker","PriceType":"none","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Unix":1581465600,"Value":"12\/02\/2020"},{"Label":"Mask","Id":9,"Type":"masked","PriceType":"none","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":"(333)33-333-333"},{"Label":"Color Picker","Id":10,"Type":"colorpicker","PriceType":"none","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":"#bc0000"},{"Label":"List","Id":11,"Type":"list","PriceType":"none","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":[["asdf"],["2323"]],"Columns":[]},{"Label":"File","Id":12,"Type":"fileupload","PriceType":"none","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":[{"Id":2,"Name":"repeater.gif","Path":"C:\/wamp64\/www\/smartforms\/wp-content\/uploads\/rednaowooextraproduct\/OrderFiles\/5e4fe7c48cc272.31832577.gif"}]},{"Label":"","Id":13,"Type":"hidden","PriceType":"none","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0},{"Label":"List","Id":15,"Type":"repeater","PriceType":"sum_of_fields_in_group","Price":null,"SalePrice":null,"Quantity":1,"UnitPrice":null,"Value":[[{"Label":"Text box","Id":0,"Type":"text","PriceType":"fixed_amount","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":"asdfasfd"}],[{"Label":"Text box","Id":0,"Type":"text","PriceType":"fixed_amount","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":"232332"}]]},{"Label":"List","Id":16,"Type":"grouppanel","PriceType":"none","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":[{"Label":"Text area","Id":18,"Type":"textarea","PriceType":"fixed_amount","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":"23234"}]},{"Label":"","Id":17,"Type":"daterange","PriceType":"none","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"Value":{"StartDateLabel":"Start Date","EndDateLabel":"End Date","StartUnix":1581465600,"EndUnix":1582329600,"StartValue":"12\/02\/2020","EndValue":"22\/02\/2020"}},{"Label":"Button Selection","Id":24,"Type":"buttonselection","PriceType":"options","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0,"SelectedValues":[{"Label":"Button Selection","RegularPrice":"","SalePrice":"","PriceType":"fixed_amount","Id":2,"Selected":false,"URL":"","AdditionalOptionValue":[],"ImageType":"none","Ref":"","UnitPrice":0,"Quantity":1,"Price":0,"Value":"Option 2"}]},{"Label":"Hidden","Id":25,"Type":"hidden","PriceType":"none","Price":0,"SalePrice":0,"Quantity":1,"UnitPrice":0}],"PreviousCartKey":"","Totals":{"ProductPrice":1,"OptionsTotal":0,"GrandTotal":1,"OptionsUnitPrice":0}}');
        $productMock=(new ProductMocker($this))->Generate();

        $formBuilder=new FormBuilder(null,$options,$entry,$productMock);
        $formBuilder->Initialize();

        $emailOptions=\json_decode('{"Id":1,"To":[{"IsDirty":false,"_fields":[],"_defaultValuesLoaded":true,"ValueChanged":{"Subscribers":[]},"Type":"Fixed","Value":"test@test.com"}],"ReplyTo":[],"CC":[],"BCC":[],"FromName":"","FromEmailAddress":"","Subject":"adfdsa","Content":{"object":"value","document":{"object":"document","data":{},"nodes":[{"object":"block","type":"paragraph","data":{},"nodes":[{"object":"text","leaves":[{"object":"leaf","text":"Hello World","marks":[]}]}]},{"object":"block","type":"paragraph","data":{},"nodes":[{"object":"text","leaves":[{"object":"leaf","text":"","marks":[]}]}]},{"object":"block","type":"paragraph","data":{"className":"image"},"nodes":[{"object":"text","leaves":[{"object":"leaf","text":"","marks":[]}]}]},{"object":"block","type":"template","data":{"TemplateName":"FieldSummary"},"nodes":[{"object":"text","leaves":[{"object":"leaf","text":"","marks":[]}]}]}]}},"EnableConditions":false,"Condition":{"Id":1,"Type":"ShowHide","ConditionGroups":[],"ElementsUsed":[],"SendWhenTrue":true}}');
        $emailManager=new EmailManager();
        $emailManager->Initialize($formBuilder,$emailOptions);
        $this->assertTrue($emailManager->Send());

    }


}
