# Add Code To Head #
**Contributors:** HBJitney LLC \
**Tags:** code, javascript, css, template \
**Requires at least:** 3.3.2 \
**Tested up to:** 6.7.1 \
**License:** GPLv3 \
**License URI:** http://www.gnu.org/licenses/gpl-3.0.html \
**Stable tag:** trunk

Add custom Javascript/HTML/CSS codes to the page head without editing the template.

## Description ##

Intended users: Template Designers, Developer

If you wish to add any custom HTML to the bottom of each page's head, then this plugin is for you. For example, you can add some custom CSS, a link to an external javascript file or something else.

The problem with editing the template directly is if you ever update the template, your changes will be lost. This plugin works around this issue.

## Installation ##
### Via your Blog’s install plugin option ###

* Click the big 'Install Plugin' button in the plugin description window

### Upload ###
If you have a single file (ending in ".zip"), then use this method.

1. From the plugins, add new, click on the **upload** button
1. Navigate to where the .zip file is located and select it
1. Make sure to *activate* the plugin once it is installed

### Files ###
If you have multiple files in a directory, use this method.

1. Upload the entire directory (not just the files) to the `/wp-content/plugins/` directory
1. Activate the plugin through the 'Plugins' menu in WordPress


## Frequently Asked Questions ##

### Q. Why aren't my codes being added to the absolute end of the head? ###

Another plugin or the theme is adding their own codes to the head _after_ this plugin runs.

### Q. I don't know HTML/Javascript/CSS; can I still use this plugin? ###

Yes, but you may easily get confused and mess up your whole site. It is better to learn the code first before you use this plugin.

### Q. [Wordfence][wf] says something like "A potentially unsafe operation has been detected in your request to this site."

If you try to add a script or some other potentially-dangerous code (even if it isn't), Wordfence might complain. Double check your code and if it is okay, mark it as a false positive in Wordfence.

### Q. Help! I messed up my whole site! ###

Disable the plugin. If your site is still messed up, then there's some other problem.

### Q. I disabled your plugin and the problem went away. Now what? ###

The problem lies in whatever you typed/pasted into this plugin's option screen. If you're really stuck, then try clearing out the code and starting over.

### Q. Help! I accidentally erased the code and I didn't mean to do that. ###

Similar to [how widgets work](https://codex.wordpress.org/WordPress_Widgets), that data is stored in your database. If you made a backup before you deleted the data, then you can restore it that way, otherwise it is gone.

### Q. How do I apply code to only a certain page or pages? ###

Right now you cannot. If there is sufficient demand, then we'll add it.

### Q. Can I ask for additional functionality? ###

Absolutely!

## Screenshots ##

### 1. Options screen ###
![1. Options screen](http://ps.w.org/add-code-to-head/assets/screenshot-1.png)


## Acknowledgements ##
Plugin Icon (CC BY 3.0) by [DeniShop](https://www.iconfinder.com/denir)

## Changelog ##
### 1.17 ###
* Tested compatibility up to WP 6.7.1
* Added note about Wordfence error that might be encountered

### 1.15 ###
* Tested compatibility up to WP 5.7.2
* Reformatted script: converted tabs to spaces

### 1.13 ###
* Tested compatibility up to WP 4.6.1

### 1.11 ###
* Name changed to (hopefully) reduce confusion.

### 1.10 ###
* Screenshot updated
* Compatibility with latest Wordpress

### 1.09 ###
* Readme file added

### 1.07 ###
* Original release

## Upgrade Notice ##

### 1.17 ###
* Verified Compatible with WP 6.7.1
* Added note about potential Wordfence issue to the readme
* No other changes

[wf]:https://www.wordfence.com
