<?php

namespace AcyMailing\Core;

abstract class AcymView extends AcymObject
{
    public string $name = '';
    protected array $steps = [];
    protected string $step = '';

    public array $tabs = [];

    public function __construct()
    {
        parent::__construct();

        $classname = get_class($this);
        $classname = substr($classname, strrpos($classname, '\\') + 1);
        $this->name = strtolower(substr($classname, 0, -4));
        $this->step = acym_getVar('string', 'nextstep', '');
        if (empty($this->step)) {
            $this->step = acym_getVar('string', 'step', '');
        }
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getLayout(): string
    {
        return acym_getVar('cmd', 'layout', acym_getVar('cmd', 'task', 'listing'));
    }

    public function display(object $controller, array $data = []): void
    {
        $name = $this->getName();
        $view = $this->getLayout();

        if (method_exists($this, $view)) $this->$view();

        $viewFolder = acym_isAdmin() ? ACYM_VIEW : ACYM_VIEW_FRONT;
        if (!file_exists($viewFolder.ucfirst($name).DS.'tmpl'.DS.$view.'.php')) {
            $view = 'listing';
        }
        $getCleanView = ($name !== 'archive' && $view !== 'listing') && ($name !== 'frontusers' || $view !== 'profile');
        if (ACYM_CMS === 'wordpress' && $getCleanView) {
            echo ob_get_clean();
        }

        if (
            ACYM_CMS !== 'wordpress'
            || ($name === 'frontusers' && ($view === 'unsubscribe' || $view === 'unsubscribepage'))
            || !defined('DOING_AJAX')
            || !DOING_AJAX
            || ($name === 'archive' && $view === 'view')
        ) {
            acym_loadAssets($name, $view);
            $controller->loadScripts($view);
        }

        if (!empty($_SESSION['acynotif'])) {
            echo implode('', $_SESSION['acynotif']);
            $_SESSION['acynotif'] = [];
        }

        $outsideForm = (strpos($name, 'mails') !== false && $view === 'edit') || (strpos($name, 'campaigns') !== false && $view === 'edit_email');
        if ($outsideForm) {
            echo '<form id="acym_form" action="'.acym_completeLink(
                    acym_getVar('cmd', 'ctrl')
                ).'" class="acym__form__mail__edit" method="post" name="acyForm" data-abide novalidate enctype="multipart/form-data">';
        }

        if (acym_getVar('cmd', 'task') !== 'ajaxEncoding') {
            echo '<div id="acym_wrapper" class="'.$name.'_'.$view.' cms_'.ACYM_CMS.' cms_v_'.substr(ACYM_CMSV, 0, 1).'">';
        }

        if (acym_isLeftMenuNecessary()) {
            echo acym_getLeftMenu($name).'<div id="acym_content">';
        }

        if (!empty($data['header'])) {
            echo $data['header'];
        }

        $remindme = json_decode($this->config->get('remindme', '[]'), true);
        if ($this->config->get('walk_through', 0) == 0) {
            if (acym_isAdmin()) {
                if (!in_array('multilingual', $remindme) && acym_level(ACYM_ESSENTIAL) && $this->config->get('multilingual', '0') === '0') {
                    if (count(acym_getLanguages(false, true)) > 1) {
                        $message = acym_translation('ACYM_MULTILINGUAL_OPTIONS_PROMPT');
                        $message .= ' <a id="acym__multilingual__reminder" href="'.acym_completeLink('configuration&task=multilingual').'">'.acym_translation('ACYM_YES').'</a>';
                        $message .= ' / <a href="#" title="multilingual" class="acym__do__not__remindme__multilingual">'.acym_translation('ACYM_NO').'</a>';
                        acym_display($message, 'info', false);
                    } else {
                        $remindme[] = 'multilingual';
                        $this->config->saveConfig(['remindme' => json_encode($remindme)]);
                    }
                }

                $maliciousScan = $this->config->get('malicious_scan', 0);
                if (!empty($maliciousScan)) {
                    $this->config->saveConfig(['malicious_scan' => 0]);
                    acym_display(acym_translation('ACYM_NEW_SECURITY_TOOL'), 'info');
                }
            }
        }

        acym_trigger('acym_displayTrackingMessage', [&$message], 'plgAcymWoocommerce');

        if (acym_isAdmin()) {
            acym_trigger('onAcymDisplayPage');
            acym_displayMessages();
        }

        include acym_getView($name, $view);

        if (acym_isLeftMenuNecessary()) {
            echo '</div>';
        }

        if (acym_getVar('cmd', 'task') !== 'ajaxEncoding') {
            echo '</div>';
        }

        if ($outsideForm) {
            echo '</form>';
        }

        if (ACYM_CMS !== 'wordpress' || !acym_isAdmin() || in_array($controller->name, ['dashboard', 'language', 'campaigns']) || acym_isAjax()) {
            return;
        }

        $remind = json_decode($this->config->get('remindme', '[]'));
        $installationDate = $this->config->get('install_date', time());
        $sevenDaysAgo = time() - 7 * 86400;

        if (!in_array('reviews', $remind) && $installationDate < $sevenDaysAgo) {
            echo '<div id="acym__reviews__footer" style="margin: 0 0 30px 30px;">';
            echo acym_translationSprintf(
                'ACYM_REVIEW_FOOTER',
                '<a title="reviews" id="acym__reviews__footer__link" target="_blank" href="https://wordpress.org/support/plugin/acymailing/reviews/?rate=5#new-post">
                '.str_repeat('<i class="acymicon-star"></i>', 5).'</a>'
            );
            echo '</div>';
        }
    }
}
