# Acme Fix Images - Regenerate Thumbnails

> Fix image sizes after you have changed image sizes from Media Settings. Ensure your images display consistently across your website.

## Description

Regenerate Thumbnails - Acme Fix Images is a handy WordPress plugin designed to resolve issues related to image thumbnail sizes. If you've recently adjusted image sizes in your Media Settings or encountered display problems due to improper thumbnail sizes, this plugin can help you ensure consistency and proper display of images across your website.

## Table of contents

- [Acme Fix Images](#acme-fix-images)
  - [Description](#description)
  - [Table of contents](#table-of-contents)
  - [Getting Started](#getting-started)
  - [Installation](#installation)
  - [Usage](#usage)
  - [Features](#features)
  - [Contributing](#contributing)
  - [Authors](#authors)
  - [Resources](#resources)
  - [License & Attribution](#license--attribution)

## Getting Started

Follow these instructions to install and set up the plugin:

## Installation

There are two ways to install the plugin:

1. Upload the plugin's zip file via Dashboard -> Plugins -> Add New -> "Upload Plugin".
2. Extract the plugin folder and place it in the "/wp-content/plugins/" directory.

After installation, activate the plugin through the 'Plugins' menu in WordPress.

## Usage

Now that you have the 'Regenerate Thumbnails - Acme Fix Images' plugin installed, you can use its features for:

- Log in to your WordPress admin panel.
- Navigate to Appearance => Acme Fix Images.
- Select the image sizes and options you wish to fix.
- Click "Fix All Images" to regenerate thumbnails according to your chosen sizes.

## Features

- **Fix Image Sizes:** Resolve issues related to image thumbnail sizes, especially after adjusting image sizes in the Media Settings.

- **WP React Plugin Boilerplate:** Developed using the [WP React Plugin Boilerplate](https://github.com/codersantosh/wp-react-plugin-boilerplate) for a structured and efficient development process.

- **Atrc Integration:** Incorporates [Atrc (atrc) - Atomic React Components](https://www.npmjs.com/package/atrc) for efficient React API, State and Component management, providing developers with a scalable and maintainable structure.

- **WordPress REST API Utilization:** Leverages the power of the WordPress REST API for seamless integration and data exchange.

- **Abundant Hooks for Customization:** Provides a rich set of hooks for developers to customize and extend the plugin's functionality according to specific project requirements.

- **Developer-Friendly:** Tailored with developers in mind, ensuring ease of use, readability, and flexibility in code.

- **Extensive Documentation:** Comprehensive documentation to assist developers in understanding and implementing various features and customizations on codes.

- **Optimized for Customization:** Encourages and supports plugin customization through well-documented hooks, making it suitable for diverse development needs.

## Contributing

Thank you for your interest in contributing to Project Coming Soon and Maintenance Mode Page. To submit your changes, please follow the steps outlined below.

1. **Fork the Repository:** Click on the "Fork" button on the top right corner of the repository page to create your fork.

2. **Clone your Fork:** Clone your forked repository to your local machine using the following command:

   ```sh
   git clone https://github.com/your-username/acme-fix-images.git
   ```

3. **Create a Feature Branch:** Create a new branch for your feature or bug fix:
   ```sh
   git checkout -b my-new-feature
   ```
4. **Make Changes:** Add your changes to the project. You can use the following command to stage all changes:

   ```sh
   git add .
   ```

5. **Commit Changes:** Commit your changes with a descriptive commit message:

   ```sh
   git commit -a m 'Add some feature'
   ```

6. **Push to your Branch:** Push your changes to the branch you created on your fork:
   ```sh
   git push origin my-new-feature
   ```
7. **Submit a Pull Request:** Go to the Pull Requests tab of the original repository and click on "New Pull Request." Provide a clear title and description for your changes, and submit the pull request.

Thank you for contributing to this project!

## Authors

- **Santosh Kunwar** - [codersantosh](https://twitter.com/codersantosh)

See also the list of [contributors](https://github.com/codersantosh/acme-fix-images/graphs/contributors) who participated in this project.

## Resources

- [WP React Plugin Boilerplate](https://github.com/codersantosh/wp-react-plugin-boilerplate)
- [Atrc (atrc) - Atomic React Components](https://www.npmjs.com/package/atrc)

## License & Attribution

- GPLv2 or later © [Santosh Kunwar](https://twitter.com/codersantosh).

The plugin is created using WP React Plugin Boilerplate and Atrc (atrc) - Atomic React Components, developed by the same author. For other libraries used, please view the respective page of the project.
