<?php

namespace Org\Wplake\Advanced_Views\Optional_Vendors\Illuminate\View;

class ViewName
{
    /**
     * Normalize the given view name.
     *
     * @param  string  $name
     * @return string
     */
    public static function normalize($name)
    {
        $delimiter = ViewFinderInterface::HINT_PATH_DELIMITER;
        if (!\str_contains($name, $delimiter)) {
            return \str_replace('/', '.', $name);
        }
        [$namespace, $name] = \explode($delimiter, $name);
        return $namespace . $delimiter . \str_replace('/', '.', $name);
    }
}
