<?php

namespace Org\Wplake\Advanced_Views\Optional_Vendors\Illuminate\View\Compilers\Concerns;

trait CompilesUseStatements
{
    /**
     * Compile the use statements into valid PHP.
     *
     * @param  string  $expression
     * @return string
     */
    protected function compileUse($expression)
    {
        $segments = \explode(',', \preg_replace("/[\\(\\)]/", '', $expression));
        $use = \ltrim(\trim($segments[0], " '\""), '\\');
        $as = isset($segments[1]) ? ' as ' . \trim($segments[1], " '\"") : '';
        return "<?php use \\{$use}{$as}; ?>";
    }
}
