/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Splide: () => (/* binding */ Splide2),
/* harmony export */   SplideSlide: () => (/* binding */ SplideSlide),
/* harmony export */   SplideTrack: () => (/* binding */ SplideTrack)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// node_modules/@splidejs/splide/dist/js/splide.esm.js
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", { writable: false });
  return Constructor;
}
var MEDIA_PREFERS_REDUCED_MOTION = "(prefers-reduced-motion: reduce)";
var CREATED = 1;
var MOUNTED = 2;
var IDLE = 3;
var MOVING = 4;
var SCROLLING = 5;
var DRAGGING = 6;
var DESTROYED = 7;
var STATES = {
  CREATED,
  MOUNTED,
  IDLE,
  MOVING,
  SCROLLING,
  DRAGGING,
  DESTROYED
};
function empty(array) {
  array.length = 0;
}
function slice(arrayLike, start, end) {
  return Array.prototype.slice.call(arrayLike, start, end);
}
function apply(func) {
  return func.bind.apply(func, [null].concat(slice(arguments, 1)));
}
var nextTick = setTimeout;
var noop = function noop2() {
};
function raf(func) {
  return requestAnimationFrame(func);
}
function typeOf(type, subject) {
  return typeof subject === type;
}
function isObject(subject) {
  return !isNull(subject) && typeOf("object", subject);
}
var isArray = Array.isArray;
var isFunction = apply(typeOf, "function");
var isString = apply(typeOf, "string");
var isUndefined = apply(typeOf, "undefined");
function isNull(subject) {
  return subject === null;
}
function isHTMLElement(subject) {
  try {
    return subject instanceof (subject.ownerDocument.defaultView || window).HTMLElement;
  } catch (e) {
    return false;
  }
}
function toArray(value) {
  return isArray(value) ? value : [value];
}
function forEach(values, iteratee) {
  toArray(values).forEach(iteratee);
}
function includes(array, value) {
  return array.indexOf(value) > -1;
}
function push(array, items) {
  array.push.apply(array, toArray(items));
  return array;
}
function toggleClass(elm, classes, add) {
  if (elm) {
    forEach(classes, function(name) {
      if (name) {
        elm.classList[add ? "add" : "remove"](name);
      }
    });
  }
}
function addClass(elm, classes) {
  toggleClass(elm, isString(classes) ? classes.split(" ") : classes, true);
}
function append(parent, children2) {
  forEach(children2, parent.appendChild.bind(parent));
}
function before(nodes, ref) {
  forEach(nodes, function(node) {
    var parent = (ref || node).parentNode;
    if (parent) {
      parent.insertBefore(node, ref);
    }
  });
}
function matches(elm, selector) {
  return isHTMLElement(elm) && (elm["msMatchesSelector"] || elm.matches).call(elm, selector);
}
function children(parent, selector) {
  var children2 = parent ? slice(parent.children) : [];
  return selector ? children2.filter(function(child2) {
    return matches(child2, selector);
  }) : children2;
}
function child(parent, selector) {
  return selector ? children(parent, selector)[0] : parent.firstElementChild;
}
var ownKeys = Object.keys;
function forOwn(object, iteratee, right) {
  if (object) {
    (right ? ownKeys(object).reverse() : ownKeys(object)).forEach(function(key) {
      key !== "__proto__" && iteratee(object[key], key);
    });
  }
  return object;
}
function assign(object) {
  slice(arguments, 1).forEach(function(source) {
    forOwn(source, function(value, key) {
      object[key] = source[key];
    });
  });
  return object;
}
function merge(object) {
  slice(arguments, 1).forEach(function(source) {
    forOwn(source, function(value, key) {
      if (isArray(value)) {
        object[key] = value.slice();
      } else if (isObject(value)) {
        object[key] = merge({}, isObject(object[key]) ? object[key] : {}, value);
      } else {
        object[key] = value;
      }
    });
  });
  return object;
}
function omit(object, keys) {
  forEach(keys || ownKeys(object), function(key) {
    delete object[key];
  });
}
function removeAttribute(elms, attrs) {
  forEach(elms, function(elm) {
    forEach(attrs, function(attr) {
      elm && elm.removeAttribute(attr);
    });
  });
}
function setAttribute(elms, attrs, value) {
  if (isObject(attrs)) {
    forOwn(attrs, function(value2, name) {
      setAttribute(elms, name, value2);
    });
  } else {
    forEach(elms, function(elm) {
      isNull(value) || value === "" ? removeAttribute(elm, attrs) : elm.setAttribute(attrs, String(value));
    });
  }
}
function create(tag, attrs, parent) {
  var elm = document.createElement(tag);
  if (attrs) {
    isString(attrs) ? addClass(elm, attrs) : setAttribute(elm, attrs);
  }
  parent && append(parent, elm);
  return elm;
}
function style(elm, prop, value) {
  if (isUndefined(value)) {
    return getComputedStyle(elm)[prop];
  }
  if (!isNull(value)) {
    elm.style[prop] = "" + value;
  }
}
function display(elm, display2) {
  style(elm, "display", display2);
}
function focus(elm) {
  elm["setActive"] && elm["setActive"]() || elm.focus({
    preventScroll: true
  });
}
function getAttribute(elm, attr) {
  return elm.getAttribute(attr);
}
function hasClass(elm, className) {
  return elm && elm.classList.contains(className);
}
function rect(target) {
  return target.getBoundingClientRect();
}
function remove(nodes) {
  forEach(nodes, function(node) {
    if (node && node.parentNode) {
      node.parentNode.removeChild(node);
    }
  });
}
function parseHtml(html) {
  return child(new DOMParser().parseFromString(html, "text/html").body);
}
function prevent(e, stopPropagation) {
  e.preventDefault();
  if (stopPropagation) {
    e.stopPropagation();
    e.stopImmediatePropagation();
  }
}
function query(parent, selector) {
  return parent && parent.querySelector(selector);
}
function queryAll(parent, selector) {
  return selector ? slice(parent.querySelectorAll(selector)) : [];
}
function removeClass(elm, classes) {
  toggleClass(elm, classes, false);
}
function timeOf(e) {
  return e.timeStamp;
}
function unit(value) {
  return isString(value) ? value : value ? value + "px" : "";
}
var PROJECT_CODE = "splide";
var DATA_ATTRIBUTE = "data-" + PROJECT_CODE;
function assert(condition, message) {
  if (!condition) {
    throw new Error("[" + PROJECT_CODE + "] " + (message || ""));
  }
}
var min = Math.min;
var max = Math.max;
var floor = Math.floor;
var ceil = Math.ceil;
var abs = Math.abs;
function approximatelyEqual(x, y, epsilon) {
  return abs(x - y) < epsilon;
}
function between(number, x, y, exclusive) {
  var minimum = min(x, y);
  var maximum = max(x, y);
  return exclusive ? minimum < number && number < maximum : minimum <= number && number <= maximum;
}
function clamp(number, x, y) {
  var minimum = min(x, y);
  var maximum = max(x, y);
  return min(max(minimum, number), maximum);
}
function sign(x) {
  return +(x > 0) - +(x < 0);
}
function format(string, replacements) {
  forEach(replacements, function(replacement) {
    string = string.replace("%s", "" + replacement);
  });
  return string;
}
function pad(number) {
  return number < 10 ? "0" + number : "" + number;
}
var ids = {};
function uniqueId(prefix) {
  return "" + prefix + pad(ids[prefix] = (ids[prefix] || 0) + 1);
}
function EventBinder() {
  var listeners = [];
  function bind(targets, events, callback, options) {
    forEachEvent(targets, events, function(target, event, namespace) {
      var isEventTarget = "addEventListener" in target;
      var remover = isEventTarget ? target.removeEventListener.bind(target, event, callback, options) : target["removeListener"].bind(target, callback);
      isEventTarget ? target.addEventListener(event, callback, options) : target["addListener"](callback);
      listeners.push([target, event, namespace, callback, remover]);
    });
  }
  function unbind(targets, events, callback) {
    forEachEvent(targets, events, function(target, event, namespace) {
      listeners = listeners.filter(function(listener) {
        if (listener[0] === target && listener[1] === event && listener[2] === namespace && (!callback || listener[3] === callback)) {
          listener[4]();
          return false;
        }
        return true;
      });
    });
  }
  function dispatch(target, type, detail) {
    var e;
    var bubbles = true;
    if (typeof CustomEvent === "function") {
      e = new CustomEvent(type, {
        bubbles,
        detail
      });
    } else {
      e = document.createEvent("CustomEvent");
      e.initCustomEvent(type, bubbles, false, detail);
    }
    target.dispatchEvent(e);
    return e;
  }
  function forEachEvent(targets, events, iteratee) {
    forEach(targets, function(target) {
      target && forEach(events, function(events2) {
        events2.split(" ").forEach(function(eventNS) {
          var fragment = eventNS.split(".");
          iteratee(target, fragment[0], fragment[1]);
        });
      });
    });
  }
  function destroy() {
    listeners.forEach(function(data) {
      data[4]();
    });
    empty(listeners);
  }
  return {
    bind,
    unbind,
    dispatch,
    destroy
  };
}
var EVENT_MOUNTED = "mounted";
var EVENT_READY = "ready";
var EVENT_MOVE = "move";
var EVENT_MOVED = "moved";
var EVENT_CLICK = "click";
var EVENT_ACTIVE = "active";
var EVENT_INACTIVE = "inactive";
var EVENT_VISIBLE = "visible";
var EVENT_HIDDEN = "hidden";
var EVENT_REFRESH = "refresh";
var EVENT_UPDATED = "updated";
var EVENT_RESIZE = "resize";
var EVENT_RESIZED = "resized";
var EVENT_DRAG = "drag";
var EVENT_DRAGGING = "dragging";
var EVENT_DRAGGED = "dragged";
var EVENT_SCROLL = "scroll";
var EVENT_SCROLLED = "scrolled";
var EVENT_OVERFLOW = "overflow";
var EVENT_DESTROY = "destroy";
var EVENT_ARROWS_MOUNTED = "arrows:mounted";
var EVENT_ARROWS_UPDATED = "arrows:updated";
var EVENT_PAGINATION_MOUNTED = "pagination:mounted";
var EVENT_PAGINATION_UPDATED = "pagination:updated";
var EVENT_NAVIGATION_MOUNTED = "navigation:mounted";
var EVENT_AUTOPLAY_PLAY = "autoplay:play";
var EVENT_AUTOPLAY_PLAYING = "autoplay:playing";
var EVENT_AUTOPLAY_PAUSE = "autoplay:pause";
var EVENT_LAZYLOAD_LOADED = "lazyload:loaded";
var EVENT_SLIDE_KEYDOWN = "sk";
var EVENT_SHIFTED = "sh";
var EVENT_END_INDEX_CHANGED = "ei";
function EventInterface(Splide22) {
  var bus = Splide22 ? Splide22.event.bus : document.createDocumentFragment();
  var binder = EventBinder();
  function on(events, callback) {
    binder.bind(bus, toArray(events).join(" "), function(e) {
      callback.apply(callback, isArray(e.detail) ? e.detail : []);
    });
  }
  function emit(event) {
    binder.dispatch(bus, event, slice(arguments, 1));
  }
  if (Splide22) {
    Splide22.event.on(EVENT_DESTROY, binder.destroy);
  }
  return assign(binder, {
    bus,
    on,
    off: apply(binder.unbind, bus),
    emit
  });
}
function RequestInterval(interval, onInterval, onUpdate, limit) {
  var now = Date.now;
  var startTime;
  var rate = 0;
  var id;
  var paused = true;
  var count = 0;
  function update() {
    if (!paused) {
      rate = interval ? min((now() - startTime) / interval, 1) : 1;
      onUpdate && onUpdate(rate);
      if (rate >= 1) {
        onInterval();
        startTime = now();
        if (limit && ++count >= limit) {
          return pause();
        }
      }
      id = raf(update);
    }
  }
  function start(resume) {
    resume || cancel();
    startTime = now() - (resume ? rate * interval : 0);
    paused = false;
    id = raf(update);
  }
  function pause() {
    paused = true;
  }
  function rewind() {
    startTime = now();
    rate = 0;
    if (onUpdate) {
      onUpdate(rate);
    }
  }
  function cancel() {
    id && cancelAnimationFrame(id);
    rate = 0;
    id = 0;
    paused = true;
  }
  function set(time) {
    interval = time;
  }
  function isPaused() {
    return paused;
  }
  return {
    start,
    rewind,
    pause,
    cancel,
    set,
    isPaused
  };
}
function State(initialState) {
  var state = initialState;
  function set(value) {
    state = value;
  }
  function is(states) {
    return includes(toArray(states), state);
  }
  return {
    set,
    is
  };
}
function Throttle(func, duration) {
  var interval = RequestInterval(duration || 0, func, null, 1);
  return function() {
    interval.isPaused() && interval.start();
  };
}
function Media(Splide22, Components2, options) {
  var state = Splide22.state;
  var breakpoints = options.breakpoints || {};
  var reducedMotion = options.reducedMotion || {};
  var binder = EventBinder();
  var queries = [];
  function setup() {
    var isMin = options.mediaQuery === "min";
    ownKeys(breakpoints).sort(function(n, m) {
      return isMin ? +n - +m : +m - +n;
    }).forEach(function(key) {
      register(breakpoints[key], "(" + (isMin ? "min" : "max") + "-width:" + key + "px)");
    });
    register(reducedMotion, MEDIA_PREFERS_REDUCED_MOTION);
    update();
  }
  function destroy(completely) {
    if (completely) {
      binder.destroy();
    }
  }
  function register(options2, query2) {
    var queryList = matchMedia(query2);
    binder.bind(queryList, "change", update);
    queries.push([options2, queryList]);
  }
  function update() {
    var destroyed = state.is(DESTROYED);
    var direction = options.direction;
    var merged = queries.reduce(function(merged2, entry) {
      return merge(merged2, entry[1].matches ? entry[0] : {});
    }, {});
    omit(options);
    set(merged);
    if (options.destroy) {
      Splide22.destroy(options.destroy === "completely");
    } else if (destroyed) {
      destroy(true);
      Splide22.mount();
    } else {
      direction !== options.direction && Splide22.refresh();
    }
  }
  function reduce(enable) {
    if (matchMedia(MEDIA_PREFERS_REDUCED_MOTION).matches) {
      enable ? merge(options, reducedMotion) : omit(options, ownKeys(reducedMotion));
    }
  }
  function set(opts, base, notify) {
    merge(options, opts);
    base && merge(Object.getPrototypeOf(options), opts);
    if (notify || !state.is(CREATED)) {
      Splide22.emit(EVENT_UPDATED, options);
    }
  }
  return {
    setup,
    destroy,
    reduce,
    set
  };
}
var ARROW = "Arrow";
var ARROW_LEFT = ARROW + "Left";
var ARROW_RIGHT = ARROW + "Right";
var ARROW_UP = ARROW + "Up";
var ARROW_DOWN = ARROW + "Down";
var RTL = "rtl";
var TTB = "ttb";
var ORIENTATION_MAP = {
  width: ["height"],
  left: ["top", "right"],
  right: ["bottom", "left"],
  x: ["y"],
  X: ["Y"],
  Y: ["X"],
  ArrowLeft: [ARROW_UP, ARROW_RIGHT],
  ArrowRight: [ARROW_DOWN, ARROW_LEFT]
};
function Direction(Splide22, Components2, options) {
  function resolve(prop, axisOnly, direction) {
    direction = direction || options.direction;
    var index = direction === RTL && !axisOnly ? 1 : direction === TTB ? 0 : -1;
    return ORIENTATION_MAP[prop] && ORIENTATION_MAP[prop][index] || prop.replace(/width|left|right/i, function(match, offset) {
      var replacement = ORIENTATION_MAP[match.toLowerCase()][index] || match;
      return offset > 0 ? replacement.charAt(0).toUpperCase() + replacement.slice(1) : replacement;
    });
  }
  function orient(value) {
    return value * (options.direction === RTL ? 1 : -1);
  }
  return {
    resolve,
    orient
  };
}
var ROLE = "role";
var TAB_INDEX = "tabindex";
var DISABLED = "disabled";
var ARIA_PREFIX = "aria-";
var ARIA_CONTROLS = ARIA_PREFIX + "controls";
var ARIA_CURRENT = ARIA_PREFIX + "current";
var ARIA_SELECTED = ARIA_PREFIX + "selected";
var ARIA_LABEL = ARIA_PREFIX + "label";
var ARIA_LABELLEDBY = ARIA_PREFIX + "labelledby";
var ARIA_HIDDEN = ARIA_PREFIX + "hidden";
var ARIA_ORIENTATION = ARIA_PREFIX + "orientation";
var ARIA_ROLEDESCRIPTION = ARIA_PREFIX + "roledescription";
var ARIA_LIVE = ARIA_PREFIX + "live";
var ARIA_BUSY = ARIA_PREFIX + "busy";
var ARIA_ATOMIC = ARIA_PREFIX + "atomic";
var ALL_ATTRIBUTES = [ROLE, TAB_INDEX, DISABLED, ARIA_CONTROLS, ARIA_CURRENT, ARIA_LABEL, ARIA_LABELLEDBY, ARIA_HIDDEN, ARIA_ORIENTATION, ARIA_ROLEDESCRIPTION];
var CLASS_PREFIX = PROJECT_CODE + "__";
var STATUS_CLASS_PREFIX = "is-";
var CLASS_ROOT = PROJECT_CODE;
var CLASS_TRACK = CLASS_PREFIX + "track";
var CLASS_LIST = CLASS_PREFIX + "list";
var CLASS_SLIDE = CLASS_PREFIX + "slide";
var CLASS_CLONE = CLASS_SLIDE + "--clone";
var CLASS_CONTAINER = CLASS_SLIDE + "__container";
var CLASS_ARROWS = CLASS_PREFIX + "arrows";
var CLASS_ARROW = CLASS_PREFIX + "arrow";
var CLASS_ARROW_PREV = CLASS_ARROW + "--prev";
var CLASS_ARROW_NEXT = CLASS_ARROW + "--next";
var CLASS_PAGINATION = CLASS_PREFIX + "pagination";
var CLASS_PAGINATION_PAGE = CLASS_PAGINATION + "__page";
var CLASS_PROGRESS = CLASS_PREFIX + "progress";
var CLASS_PROGRESS_BAR = CLASS_PROGRESS + "__bar";
var CLASS_TOGGLE = CLASS_PREFIX + "toggle";
var CLASS_TOGGLE_PLAY = CLASS_TOGGLE + "__play";
var CLASS_TOGGLE_PAUSE = CLASS_TOGGLE + "__pause";
var CLASS_SPINNER = CLASS_PREFIX + "spinner";
var CLASS_SR = CLASS_PREFIX + "sr";
var CLASS_INITIALIZED = STATUS_CLASS_PREFIX + "initialized";
var CLASS_ACTIVE = STATUS_CLASS_PREFIX + "active";
var CLASS_PREV = STATUS_CLASS_PREFIX + "prev";
var CLASS_NEXT = STATUS_CLASS_PREFIX + "next";
var CLASS_VISIBLE = STATUS_CLASS_PREFIX + "visible";
var CLASS_LOADING = STATUS_CLASS_PREFIX + "loading";
var CLASS_FOCUS_IN = STATUS_CLASS_PREFIX + "focus-in";
var CLASS_OVERFLOW = STATUS_CLASS_PREFIX + "overflow";
var STATUS_CLASSES = [CLASS_ACTIVE, CLASS_VISIBLE, CLASS_PREV, CLASS_NEXT, CLASS_LOADING, CLASS_FOCUS_IN, CLASS_OVERFLOW];
var CLASSES = {
  slide: CLASS_SLIDE,
  clone: CLASS_CLONE,
  arrows: CLASS_ARROWS,
  arrow: CLASS_ARROW,
  prev: CLASS_ARROW_PREV,
  next: CLASS_ARROW_NEXT,
  pagination: CLASS_PAGINATION,
  page: CLASS_PAGINATION_PAGE,
  spinner: CLASS_SPINNER
};
function closest(from, selector) {
  if (isFunction(from.closest)) {
    return from.closest(selector);
  }
  var elm = from;
  while (elm && elm.nodeType === 1) {
    if (matches(elm, selector)) {
      break;
    }
    elm = elm.parentElement;
  }
  return elm;
}
var FRICTION = 5;
var LOG_INTERVAL = 200;
var POINTER_DOWN_EVENTS = "touchstart mousedown";
var POINTER_MOVE_EVENTS = "touchmove mousemove";
var POINTER_UP_EVENTS = "touchend touchcancel mouseup click";
function Elements(Splide22, Components2, options) {
  var _EventInterface = EventInterface(Splide22), on = _EventInterface.on, bind = _EventInterface.bind;
  var root = Splide22.root;
  var i18n = options.i18n;
  var elements = {};
  var slides = [];
  var rootClasses = [];
  var trackClasses = [];
  var track;
  var list;
  var isUsingKey;
  function setup() {
    collect();
    init();
    update();
  }
  function mount() {
    on(EVENT_REFRESH, destroy);
    on(EVENT_REFRESH, setup);
    on(EVENT_UPDATED, update);
    bind(document, POINTER_DOWN_EVENTS + " keydown", function(e) {
      isUsingKey = e.type === "keydown";
    }, {
      capture: true
    });
    bind(root, "focusin", function() {
      toggleClass(root, CLASS_FOCUS_IN, !!isUsingKey);
    });
  }
  function destroy(completely) {
    var attrs = ALL_ATTRIBUTES.concat("style");
    empty(slides);
    removeClass(root, rootClasses);
    removeClass(track, trackClasses);
    removeAttribute([track, list], attrs);
    removeAttribute(root, completely ? attrs : ["style", ARIA_ROLEDESCRIPTION]);
  }
  function update() {
    removeClass(root, rootClasses);
    removeClass(track, trackClasses);
    rootClasses = getClasses(CLASS_ROOT);
    trackClasses = getClasses(CLASS_TRACK);
    addClass(root, rootClasses);
    addClass(track, trackClasses);
    setAttribute(root, ARIA_LABEL, options.label);
    setAttribute(root, ARIA_LABELLEDBY, options.labelledby);
  }
  function collect() {
    track = find("." + CLASS_TRACK);
    list = child(track, "." + CLASS_LIST);
    assert(track && list, "A track/list element is missing.");
    push(slides, children(list, "." + CLASS_SLIDE + ":not(." + CLASS_CLONE + ")"));
    forOwn({
      arrows: CLASS_ARROWS,
      pagination: CLASS_PAGINATION,
      prev: CLASS_ARROW_PREV,
      next: CLASS_ARROW_NEXT,
      bar: CLASS_PROGRESS_BAR,
      toggle: CLASS_TOGGLE
    }, function(className, key) {
      elements[key] = find("." + className);
    });
    assign(elements, {
      root,
      track,
      list,
      slides
    });
  }
  function init() {
    var id = root.id || uniqueId(PROJECT_CODE);
    var role = options.role;
    root.id = id;
    track.id = track.id || id + "-track";
    list.id = list.id || id + "-list";
    if (!getAttribute(root, ROLE) && root.tagName !== "SECTION" && role) {
      setAttribute(root, ROLE, role);
    }
    setAttribute(root, ARIA_ROLEDESCRIPTION, i18n.carousel);
    setAttribute(list, ROLE, "presentation");
  }
  function find(selector) {
    var elm = query(root, selector);
    return elm && closest(elm, "." + CLASS_ROOT) === root ? elm : void 0;
  }
  function getClasses(base) {
    return [base + "--" + options.type, base + "--" + options.direction, options.drag && base + "--draggable", options.isNavigation && base + "--nav", base === CLASS_ROOT && CLASS_ACTIVE];
  }
  return assign(elements, {
    setup,
    mount,
    destroy
  });
}
var SLIDE = "slide";
var LOOP = "loop";
var FADE = "fade";
function Slide$1(Splide22, index, slideIndex, slide) {
  var event = EventInterface(Splide22);
  var on = event.on, emit = event.emit, bind = event.bind;
  var Components = Splide22.Components, root = Splide22.root, options = Splide22.options;
  var isNavigation = options.isNavigation, updateOnMove = options.updateOnMove, i18n = options.i18n, pagination = options.pagination, slideFocus = options.slideFocus;
  var resolve = Components.Direction.resolve;
  var styles = getAttribute(slide, "style");
  var label = getAttribute(slide, ARIA_LABEL);
  var isClone = slideIndex > -1;
  var container = child(slide, "." + CLASS_CONTAINER);
  var destroyed;
  function mount() {
    if (!isClone) {
      slide.id = root.id + "-slide" + pad(index + 1);
      setAttribute(slide, ROLE, pagination ? "tabpanel" : "group");
      setAttribute(slide, ARIA_ROLEDESCRIPTION, i18n.slide);
      setAttribute(slide, ARIA_LABEL, label || format(i18n.slideLabel, [index + 1, Splide22.length]));
    }
    listen();
  }
  function listen() {
    bind(slide, "click", apply(emit, EVENT_CLICK, self));
    bind(slide, "keydown", apply(emit, EVENT_SLIDE_KEYDOWN, self));
    on([EVENT_MOVED, EVENT_SHIFTED, EVENT_SCROLLED], update);
    on(EVENT_NAVIGATION_MOUNTED, initNavigation);
    if (updateOnMove) {
      on(EVENT_MOVE, onMove);
    }
  }
  function destroy() {
    destroyed = true;
    event.destroy();
    removeClass(slide, STATUS_CLASSES);
    removeAttribute(slide, ALL_ATTRIBUTES);
    setAttribute(slide, "style", styles);
    setAttribute(slide, ARIA_LABEL, label || "");
  }
  function initNavigation() {
    var controls = Splide22.splides.map(function(target) {
      var Slide2 = target.splide.Components.Slides.getAt(index);
      return Slide2 ? Slide2.slide.id : "";
    }).join(" ");
    setAttribute(slide, ARIA_LABEL, format(i18n.slideX, (isClone ? slideIndex : index) + 1));
    setAttribute(slide, ARIA_CONTROLS, controls);
    setAttribute(slide, ROLE, slideFocus ? "button" : "");
    slideFocus && removeAttribute(slide, ARIA_ROLEDESCRIPTION);
  }
  function onMove() {
    if (!destroyed) {
      update();
    }
  }
  function update() {
    if (!destroyed) {
      var curr = Splide22.index;
      updateActivity();
      updateVisibility();
      toggleClass(slide, CLASS_PREV, index === curr - 1);
      toggleClass(slide, CLASS_NEXT, index === curr + 1);
    }
  }
  function updateActivity() {
    var active = isActive();
    if (active !== hasClass(slide, CLASS_ACTIVE)) {
      toggleClass(slide, CLASS_ACTIVE, active);
      setAttribute(slide, ARIA_CURRENT, isNavigation && active || "");
      emit(active ? EVENT_ACTIVE : EVENT_INACTIVE, self);
    }
  }
  function updateVisibility() {
    var visible = isVisible();
    var hidden = !visible && (!isActive() || isClone);
    if (!Splide22.state.is([MOVING, SCROLLING])) {
      setAttribute(slide, ARIA_HIDDEN, hidden || "");
    }
    setAttribute(queryAll(slide, options.focusableNodes || ""), TAB_INDEX, hidden ? -1 : "");
    if (slideFocus) {
      setAttribute(slide, TAB_INDEX, hidden ? -1 : 0);
    }
    if (visible !== hasClass(slide, CLASS_VISIBLE)) {
      toggleClass(slide, CLASS_VISIBLE, visible);
      emit(visible ? EVENT_VISIBLE : EVENT_HIDDEN, self);
    }
    if (!visible && document.activeElement === slide) {
      var Slide2 = Components.Slides.getAt(Splide22.index);
      Slide2 && focus(Slide2.slide);
    }
  }
  function style$1(prop, value, useContainer) {
    style(useContainer && container || slide, prop, value);
  }
  function isActive() {
    var curr = Splide22.index;
    return curr === index || options.cloneStatus && curr === slideIndex;
  }
  function isVisible() {
    if (Splide22.is(FADE)) {
      return isActive();
    }
    var trackRect = rect(Components.Elements.track);
    var slideRect = rect(slide);
    var left = resolve("left", true);
    var right = resolve("right", true);
    return floor(trackRect[left]) <= ceil(slideRect[left]) && floor(slideRect[right]) <= ceil(trackRect[right]);
  }
  function isWithin(from, distance) {
    var diff = abs(from - index);
    if (!isClone && (options.rewind || Splide22.is(LOOP))) {
      diff = min(diff, Splide22.length - diff);
    }
    return diff <= distance;
  }
  var self = {
    index,
    slideIndex,
    slide,
    container,
    isClone,
    mount,
    destroy,
    update,
    style: style$1,
    isWithin
  };
  return self;
}
function Slides(Splide22, Components2, options) {
  var _EventInterface2 = EventInterface(Splide22), on = _EventInterface2.on, emit = _EventInterface2.emit, bind = _EventInterface2.bind;
  var _Components2$Elements = Components2.Elements, slides = _Components2$Elements.slides, list = _Components2$Elements.list;
  var Slides2 = [];
  function mount() {
    init();
    on(EVENT_REFRESH, destroy);
    on(EVENT_REFRESH, init);
  }
  function init() {
    slides.forEach(function(slide, index) {
      register(slide, index, -1);
    });
  }
  function destroy() {
    forEach$1(function(Slide2) {
      Slide2.destroy();
    });
    empty(Slides2);
  }
  function update() {
    forEach$1(function(Slide2) {
      Slide2.update();
    });
  }
  function register(slide, index, slideIndex) {
    var object = Slide$1(Splide22, index, slideIndex, slide);
    object.mount();
    Slides2.push(object);
    Slides2.sort(function(Slide1, Slide2) {
      return Slide1.index - Slide2.index;
    });
  }
  function get(excludeClones) {
    return excludeClones ? filter(function(Slide2) {
      return !Slide2.isClone;
    }) : Slides2;
  }
  function getIn(page) {
    var Controller2 = Components2.Controller;
    var index = Controller2.toIndex(page);
    var max2 = Controller2.hasFocus() ? 1 : options.perPage;
    return filter(function(Slide2) {
      return between(Slide2.index, index, index + max2 - 1);
    });
  }
  function getAt(index) {
    return filter(index)[0];
  }
  function add(items, index) {
    forEach(items, function(slide) {
      if (isString(slide)) {
        slide = parseHtml(slide);
      }
      if (isHTMLElement(slide)) {
        var ref = slides[index];
        ref ? before(slide, ref) : append(list, slide);
        addClass(slide, options.classes.slide);
        observeImages(slide, apply(emit, EVENT_RESIZE));
      }
    });
    emit(EVENT_REFRESH);
  }
  function remove$1(matcher) {
    remove(filter(matcher).map(function(Slide2) {
      return Slide2.slide;
    }));
    emit(EVENT_REFRESH);
  }
  function forEach$1(iteratee, excludeClones) {
    get(excludeClones).forEach(iteratee);
  }
  function filter(matcher) {
    return Slides2.filter(isFunction(matcher) ? matcher : function(Slide2) {
      return isString(matcher) ? matches(Slide2.slide, matcher) : includes(toArray(matcher), Slide2.index);
    });
  }
  function style2(prop, value, useContainer) {
    forEach$1(function(Slide2) {
      Slide2.style(prop, value, useContainer);
    });
  }
  function observeImages(elm, callback) {
    var images = queryAll(elm, "img");
    var length = images.length;
    if (length) {
      images.forEach(function(img) {
        bind(img, "load error", function() {
          if (!--length) {
            callback();
          }
        });
      });
    } else {
      callback();
    }
  }
  function getLength(excludeClones) {
    return excludeClones ? slides.length : Slides2.length;
  }
  function isEnough() {
    return Slides2.length > options.perPage;
  }
  return {
    mount,
    destroy,
    update,
    register,
    get,
    getIn,
    getAt,
    add,
    remove: remove$1,
    forEach: forEach$1,
    filter,
    style: style2,
    getLength,
    isEnough
  };
}
function Layout(Splide22, Components2, options) {
  var _EventInterface3 = EventInterface(Splide22), on = _EventInterface3.on, bind = _EventInterface3.bind, emit = _EventInterface3.emit;
  var Slides2 = Components2.Slides;
  var resolve = Components2.Direction.resolve;
  var _Components2$Elements2 = Components2.Elements, root = _Components2$Elements2.root, track = _Components2$Elements2.track, list = _Components2$Elements2.list;
  var getAt = Slides2.getAt, styleSlides = Slides2.style;
  var vertical;
  var rootRect;
  var overflow;
  function mount() {
    init();
    bind(window, "resize load", Throttle(apply(emit, EVENT_RESIZE)));
    on([EVENT_UPDATED, EVENT_REFRESH], init);
    on(EVENT_RESIZE, resize);
  }
  function init() {
    vertical = options.direction === TTB;
    style(root, "maxWidth", unit(options.width));
    style(track, resolve("paddingLeft"), cssPadding(false));
    style(track, resolve("paddingRight"), cssPadding(true));
    resize(true);
  }
  function resize(force) {
    var newRect = rect(root);
    if (force || rootRect.width !== newRect.width || rootRect.height !== newRect.height) {
      style(track, "height", cssTrackHeight());
      styleSlides(resolve("marginRight"), unit(options.gap));
      styleSlides("width", cssSlideWidth());
      styleSlides("height", cssSlideHeight(), true);
      rootRect = newRect;
      emit(EVENT_RESIZED);
      if (overflow !== (overflow = isOverflow())) {
        toggleClass(root, CLASS_OVERFLOW, overflow);
        emit(EVENT_OVERFLOW, overflow);
      }
    }
  }
  function cssPadding(right) {
    var padding = options.padding;
    var prop = resolve(right ? "right" : "left");
    return padding && unit(padding[prop] || (isObject(padding) ? 0 : padding)) || "0px";
  }
  function cssTrackHeight() {
    var height = "";
    if (vertical) {
      height = cssHeight();
      assert(height, "height or heightRatio is missing.");
      height = "calc(" + height + " - " + cssPadding(false) + " - " + cssPadding(true) + ")";
    }
    return height;
  }
  function cssHeight() {
    return unit(options.height || rect(list).width * options.heightRatio);
  }
  function cssSlideWidth() {
    return options.autoWidth ? null : unit(options.fixedWidth) || (vertical ? "" : cssSlideSize());
  }
  function cssSlideHeight() {
    return unit(options.fixedHeight) || (vertical ? options.autoHeight ? null : cssSlideSize() : cssHeight());
  }
  function cssSlideSize() {
    var gap = unit(options.gap);
    return "calc((100%" + (gap && " + " + gap) + ")/" + (options.perPage || 1) + (gap && " - " + gap) + ")";
  }
  function listSize() {
    return rect(list)[resolve("width")];
  }
  function slideSize(index, withoutGap) {
    var Slide2 = getAt(index || 0);
    return Slide2 ? rect(Slide2.slide)[resolve("width")] + (withoutGap ? 0 : getGap()) : 0;
  }
  function totalSize(index, withoutGap) {
    var Slide2 = getAt(index);
    if (Slide2) {
      var right = rect(Slide2.slide)[resolve("right")];
      var left = rect(list)[resolve("left")];
      return abs(right - left) + (withoutGap ? 0 : getGap());
    }
    return 0;
  }
  function sliderSize(withoutGap) {
    return totalSize(Splide22.length - 1) - totalSize(0) + slideSize(0, withoutGap);
  }
  function getGap() {
    var Slide2 = getAt(0);
    return Slide2 && parseFloat(style(Slide2.slide, resolve("marginRight"))) || 0;
  }
  function getPadding(right) {
    return parseFloat(style(track, resolve("padding" + (right ? "Right" : "Left")))) || 0;
  }
  function isOverflow() {
    return Splide22.is(FADE) || sliderSize(true) > listSize();
  }
  return {
    mount,
    resize,
    listSize,
    slideSize,
    sliderSize,
    totalSize,
    getPadding,
    isOverflow
  };
}
var MULTIPLIER = 2;
function Clones(Splide22, Components2, options) {
  var event = EventInterface(Splide22);
  var on = event.on;
  var Elements2 = Components2.Elements, Slides2 = Components2.Slides;
  var resolve = Components2.Direction.resolve;
  var clones = [];
  var cloneCount;
  function mount() {
    on(EVENT_REFRESH, remount);
    on([EVENT_UPDATED, EVENT_RESIZE], observe);
    if (cloneCount = computeCloneCount()) {
      generate(cloneCount);
      Components2.Layout.resize(true);
    }
  }
  function remount() {
    destroy();
    mount();
  }
  function destroy() {
    remove(clones);
    empty(clones);
    event.destroy();
  }
  function observe() {
    var count = computeCloneCount();
    if (cloneCount !== count) {
      if (cloneCount < count || !count) {
        event.emit(EVENT_REFRESH);
      }
    }
  }
  function generate(count) {
    var slides = Slides2.get().slice();
    var length = slides.length;
    if (length) {
      while (slides.length < count) {
        push(slides, slides);
      }
      push(slides.slice(-count), slides.slice(0, count)).forEach(function(Slide2, index) {
        var isHead = index < count;
        var clone = cloneDeep(Slide2.slide, index);
        isHead ? before(clone, slides[0].slide) : append(Elements2.list, clone);
        push(clones, clone);
        Slides2.register(clone, index - count + (isHead ? 0 : length), Slide2.index);
      });
    }
  }
  function cloneDeep(elm, index) {
    var clone = elm.cloneNode(true);
    addClass(clone, options.classes.clone);
    clone.id = Splide22.root.id + "-clone" + pad(index + 1);
    return clone;
  }
  function computeCloneCount() {
    var clones2 = options.clones;
    if (!Splide22.is(LOOP)) {
      clones2 = 0;
    } else if (isUndefined(clones2)) {
      var fixedSize = options[resolve("fixedWidth")] && Components2.Layout.slideSize(0);
      var fixedCount = fixedSize && ceil(rect(Elements2.track)[resolve("width")] / fixedSize);
      clones2 = fixedCount || options[resolve("autoWidth")] && Splide22.length || options.perPage * MULTIPLIER;
    }
    return clones2;
  }
  return {
    mount,
    destroy
  };
}
function Move(Splide22, Components2, options) {
  var _EventInterface4 = EventInterface(Splide22), on = _EventInterface4.on, emit = _EventInterface4.emit;
  var set = Splide22.state.set;
  var _Components2$Layout = Components2.Layout, slideSize = _Components2$Layout.slideSize, getPadding = _Components2$Layout.getPadding, totalSize = _Components2$Layout.totalSize, listSize = _Components2$Layout.listSize, sliderSize = _Components2$Layout.sliderSize;
  var _Components2$Directio = Components2.Direction, resolve = _Components2$Directio.resolve, orient = _Components2$Directio.orient;
  var _Components2$Elements3 = Components2.Elements, list = _Components2$Elements3.list, track = _Components2$Elements3.track;
  var Transition;
  function mount() {
    Transition = Components2.Transition;
    on([EVENT_MOUNTED, EVENT_RESIZED, EVENT_UPDATED, EVENT_REFRESH], reposition);
  }
  function reposition() {
    if (!Components2.Controller.isBusy()) {
      Components2.Scroll.cancel();
      jump(Splide22.index);
      Components2.Slides.update();
    }
  }
  function move(dest, index, prev, callback) {
    if (dest !== index && canShift(dest > prev)) {
      cancel();
      translate(shift(getPosition(), dest > prev), true);
    }
    set(MOVING);
    emit(EVENT_MOVE, index, prev, dest);
    Transition.start(index, function() {
      set(IDLE);
      emit(EVENT_MOVED, index, prev, dest);
      callback && callback();
    });
  }
  function jump(index) {
    translate(toPosition(index, true));
  }
  function translate(position, preventLoop) {
    if (!Splide22.is(FADE)) {
      var destination = preventLoop ? position : loop(position);
      style(list, "transform", "translate" + resolve("X") + "(" + destination + "px)");
      position !== destination && emit(EVENT_SHIFTED);
    }
  }
  function loop(position) {
    if (Splide22.is(LOOP)) {
      var index = toIndex(position);
      var exceededMax = index > Components2.Controller.getEnd();
      var exceededMin = index < 0;
      if (exceededMin || exceededMax) {
        position = shift(position, exceededMax);
      }
    }
    return position;
  }
  function shift(position, backwards) {
    var excess = position - getLimit(backwards);
    var size = sliderSize();
    position -= orient(size * (ceil(abs(excess) / size) || 1)) * (backwards ? 1 : -1);
    return position;
  }
  function cancel() {
    translate(getPosition(), true);
    Transition.cancel();
  }
  function toIndex(position) {
    var Slides2 = Components2.Slides.get();
    var index = 0;
    var minDistance = Infinity;
    for (var i = 0; i < Slides2.length; i++) {
      var slideIndex = Slides2[i].index;
      var distance = abs(toPosition(slideIndex, true) - position);
      if (distance <= minDistance) {
        minDistance = distance;
        index = slideIndex;
      } else {
        break;
      }
    }
    return index;
  }
  function toPosition(index, trimming) {
    var position = orient(totalSize(index - 1) - offset(index));
    return trimming ? trim(position) : position;
  }
  function getPosition() {
    var left = resolve("left");
    return rect(list)[left] - rect(track)[left] + orient(getPadding(false));
  }
  function trim(position) {
    if (options.trimSpace && Splide22.is(SLIDE)) {
      position = clamp(position, 0, orient(sliderSize(true) - listSize()));
    }
    return position;
  }
  function offset(index) {
    var focus2 = options.focus;
    return focus2 === "center" ? (listSize() - slideSize(index, true)) / 2 : +focus2 * slideSize(index) || 0;
  }
  function getLimit(max2) {
    return toPosition(max2 ? Components2.Controller.getEnd() : 0, !!options.trimSpace);
  }
  function canShift(backwards) {
    var shifted = orient(shift(getPosition(), backwards));
    return backwards ? shifted >= 0 : shifted <= list[resolve("scrollWidth")] - rect(track)[resolve("width")];
  }
  function exceededLimit(max2, position) {
    position = isUndefined(position) ? getPosition() : position;
    var exceededMin = max2 !== true && orient(position) < orient(getLimit(false));
    var exceededMax = max2 !== false && orient(position) > orient(getLimit(true));
    return exceededMin || exceededMax;
  }
  return {
    mount,
    move,
    jump,
    translate,
    shift,
    cancel,
    toIndex,
    toPosition,
    getPosition,
    getLimit,
    exceededLimit,
    reposition
  };
}
function Controller(Splide22, Components2, options) {
  var _EventInterface5 = EventInterface(Splide22), on = _EventInterface5.on, emit = _EventInterface5.emit;
  var Move2 = Components2.Move;
  var getPosition = Move2.getPosition, getLimit = Move2.getLimit, toPosition = Move2.toPosition;
  var _Components2$Slides = Components2.Slides, isEnough = _Components2$Slides.isEnough, getLength = _Components2$Slides.getLength;
  var omitEnd = options.omitEnd;
  var isLoop = Splide22.is(LOOP);
  var isSlide = Splide22.is(SLIDE);
  var getNext = apply(getAdjacent, false);
  var getPrev = apply(getAdjacent, true);
  var currIndex = options.start || 0;
  var endIndex;
  var prevIndex = currIndex;
  var slideCount;
  var perMove;
  var perPage;
  function mount() {
    init();
    on([EVENT_UPDATED, EVENT_REFRESH, EVENT_END_INDEX_CHANGED], init);
    on(EVENT_RESIZED, onResized);
  }
  function init() {
    slideCount = getLength(true);
    perMove = options.perMove;
    perPage = options.perPage;
    endIndex = getEnd();
    var index = clamp(currIndex, 0, omitEnd ? endIndex : slideCount - 1);
    if (index !== currIndex) {
      currIndex = index;
      Move2.reposition();
    }
  }
  function onResized() {
    if (endIndex !== getEnd()) {
      emit(EVENT_END_INDEX_CHANGED);
    }
  }
  function go(control, allowSameIndex, callback) {
    if (!isBusy()) {
      var dest = parse(control);
      var index = loop(dest);
      if (index > -1 && (allowSameIndex || index !== currIndex)) {
        setIndex(index);
        Move2.move(dest, index, prevIndex, callback);
      }
    }
  }
  function scroll(destination, duration, snap, callback) {
    Components2.Scroll.scroll(destination, duration, snap, function() {
      var index = loop(Move2.toIndex(getPosition()));
      setIndex(omitEnd ? min(index, endIndex) : index);
      callback && callback();
    });
  }
  function parse(control) {
    var index = currIndex;
    if (isString(control)) {
      var _ref = control.match(/([+\-<>])(\d+)?/) || [], indicator = _ref[1], number = _ref[2];
      if (indicator === "+" || indicator === "-") {
        index = computeDestIndex(currIndex + +("" + indicator + (+number || 1)), currIndex);
      } else if (indicator === ">") {
        index = number ? toIndex(+number) : getNext(true);
      } else if (indicator === "<") {
        index = getPrev(true);
      }
    } else {
      index = isLoop ? control : clamp(control, 0, endIndex);
    }
    return index;
  }
  function getAdjacent(prev, destination) {
    var number = perMove || (hasFocus() ? 1 : perPage);
    var dest = computeDestIndex(currIndex + number * (prev ? -1 : 1), currIndex, !(perMove || hasFocus()));
    if (dest === -1 && isSlide) {
      if (!approximatelyEqual(getPosition(), getLimit(!prev), 1)) {
        return prev ? 0 : endIndex;
      }
    }
    return destination ? dest : loop(dest);
  }
  function computeDestIndex(dest, from, snapPage) {
    if (isEnough() || hasFocus()) {
      var index = computeMovableDestIndex(dest);
      if (index !== dest) {
        from = dest;
        dest = index;
        snapPage = false;
      }
      if (dest < 0 || dest > endIndex) {
        if (!perMove && (between(0, dest, from, true) || between(endIndex, from, dest, true))) {
          dest = toIndex(toPage(dest));
        } else {
          if (isLoop) {
            dest = snapPage ? dest < 0 ? -(slideCount % perPage || perPage) : slideCount : dest;
          } else if (options.rewind) {
            dest = dest < 0 ? endIndex : 0;
          } else {
            dest = -1;
          }
        }
      } else {
        if (snapPage && dest !== from) {
          dest = toIndex(toPage(from) + (dest < from ? -1 : 1));
        }
      }
    } else {
      dest = -1;
    }
    return dest;
  }
  function computeMovableDestIndex(dest) {
    if (isSlide && options.trimSpace === "move" && dest !== currIndex) {
      var position = getPosition();
      while (position === toPosition(dest, true) && between(dest, 0, Splide22.length - 1, !options.rewind)) {
        dest < currIndex ? --dest : ++dest;
      }
    }
    return dest;
  }
  function loop(index) {
    return isLoop ? (index + slideCount) % slideCount || 0 : index;
  }
  function getEnd() {
    var end = slideCount - (hasFocus() || isLoop && perMove ? 1 : perPage);
    while (omitEnd && end-- > 0) {
      if (toPosition(slideCount - 1, true) !== toPosition(end, true)) {
        end++;
        break;
      }
    }
    return clamp(end, 0, slideCount - 1);
  }
  function toIndex(page) {
    return clamp(hasFocus() ? page : perPage * page, 0, endIndex);
  }
  function toPage(index) {
    return hasFocus() ? min(index, endIndex) : floor((index >= endIndex ? slideCount - 1 : index) / perPage);
  }
  function toDest(destination) {
    var closest2 = Move2.toIndex(destination);
    return isSlide ? clamp(closest2, 0, endIndex) : closest2;
  }
  function setIndex(index) {
    if (index !== currIndex) {
      prevIndex = currIndex;
      currIndex = index;
    }
  }
  function getIndex(prev) {
    return prev ? prevIndex : currIndex;
  }
  function hasFocus() {
    return !isUndefined(options.focus) || options.isNavigation;
  }
  function isBusy() {
    return Splide22.state.is([MOVING, SCROLLING]) && !!options.waitForTransition;
  }
  return {
    mount,
    go,
    scroll,
    getNext,
    getPrev,
    getAdjacent,
    getEnd,
    setIndex,
    getIndex,
    toIndex,
    toPage,
    toDest,
    hasFocus,
    isBusy
  };
}
var XML_NAME_SPACE = "http://www.w3.org/2000/svg";
var PATH = "m15.5 0.932-4.3 4.38 14.5 14.6-14.5 14.5 4.3 4.4 14.6-14.6 4.4-4.3-4.4-4.4-14.6-14.6z";
var SIZE = 40;
function Arrows(Splide22, Components2, options) {
  var event = EventInterface(Splide22);
  var on = event.on, bind = event.bind, emit = event.emit;
  var classes = options.classes, i18n = options.i18n;
  var Elements2 = Components2.Elements, Controller2 = Components2.Controller;
  var placeholder = Elements2.arrows, track = Elements2.track;
  var wrapper = placeholder;
  var prev = Elements2.prev;
  var next = Elements2.next;
  var created;
  var wrapperClasses;
  var arrows = {};
  function mount() {
    init();
    on(EVENT_UPDATED, remount);
  }
  function remount() {
    destroy();
    mount();
  }
  function init() {
    var enabled = options.arrows;
    if (enabled && !(prev && next)) {
      createArrows();
    }
    if (prev && next) {
      assign(arrows, {
        prev,
        next
      });
      display(wrapper, enabled ? "" : "none");
      addClass(wrapper, wrapperClasses = CLASS_ARROWS + "--" + options.direction);
      if (enabled) {
        listen();
        update();
        setAttribute([prev, next], ARIA_CONTROLS, track.id);
        emit(EVENT_ARROWS_MOUNTED, prev, next);
      }
    }
  }
  function destroy() {
    event.destroy();
    removeClass(wrapper, wrapperClasses);
    if (created) {
      remove(placeholder ? [prev, next] : wrapper);
      prev = next = null;
    } else {
      removeAttribute([prev, next], ALL_ATTRIBUTES);
    }
  }
  function listen() {
    on([EVENT_MOUNTED, EVENT_MOVED, EVENT_REFRESH, EVENT_SCROLLED, EVENT_END_INDEX_CHANGED], update);
    bind(next, "click", apply(go, ">"));
    bind(prev, "click", apply(go, "<"));
  }
  function go(control) {
    Controller2.go(control, true);
  }
  function createArrows() {
    wrapper = placeholder || create("div", classes.arrows);
    prev = createArrow(true);
    next = createArrow(false);
    created = true;
    append(wrapper, [prev, next]);
    !placeholder && before(wrapper, track);
  }
  function createArrow(prev2) {
    var arrow = '<button class="' + classes.arrow + " " + (prev2 ? classes.prev : classes.next) + '" type="button"><svg xmlns="' + XML_NAME_SPACE + '" viewBox="0 0 ' + SIZE + " " + SIZE + '" width="' + SIZE + '" height="' + SIZE + '" focusable="false"><path d="' + (options.arrowPath || PATH) + '" />';
    return parseHtml(arrow);
  }
  function update() {
    if (prev && next) {
      var index = Splide22.index;
      var prevIndex = Controller2.getPrev();
      var nextIndex = Controller2.getNext();
      var prevLabel = prevIndex > -1 && index < prevIndex ? i18n.last : i18n.prev;
      var nextLabel = nextIndex > -1 && index > nextIndex ? i18n.first : i18n.next;
      prev.disabled = prevIndex < 0;
      next.disabled = nextIndex < 0;
      setAttribute(prev, ARIA_LABEL, prevLabel);
      setAttribute(next, ARIA_LABEL, nextLabel);
      emit(EVENT_ARROWS_UPDATED, prev, next, prevIndex, nextIndex);
    }
  }
  return {
    arrows,
    mount,
    destroy,
    update
  };
}
var INTERVAL_DATA_ATTRIBUTE = DATA_ATTRIBUTE + "-interval";
function Autoplay(Splide22, Components2, options) {
  var _EventInterface6 = EventInterface(Splide22), on = _EventInterface6.on, bind = _EventInterface6.bind, emit = _EventInterface6.emit;
  var interval = RequestInterval(options.interval, Splide22.go.bind(Splide22, ">"), onAnimationFrame);
  var isPaused = interval.isPaused;
  var Elements2 = Components2.Elements, _Components2$Elements4 = Components2.Elements, root = _Components2$Elements4.root, toggle = _Components2$Elements4.toggle;
  var autoplay = options.autoplay;
  var hovered;
  var focused;
  var stopped = autoplay === "pause";
  function mount() {
    if (autoplay) {
      listen();
      toggle && setAttribute(toggle, ARIA_CONTROLS, Elements2.track.id);
      stopped || play();
      update();
    }
  }
  function listen() {
    if (options.pauseOnHover) {
      bind(root, "mouseenter mouseleave", function(e) {
        hovered = e.type === "mouseenter";
        autoToggle();
      });
    }
    if (options.pauseOnFocus) {
      bind(root, "focusin focusout", function(e) {
        focused = e.type === "focusin";
        autoToggle();
      });
    }
    if (toggle) {
      bind(toggle, "click", function() {
        stopped ? play() : pause(true);
      });
    }
    on([EVENT_MOVE, EVENT_SCROLL, EVENT_REFRESH], interval.rewind);
    on(EVENT_MOVE, onMove);
  }
  function play() {
    if (isPaused() && Components2.Slides.isEnough()) {
      interval.start(!options.resetProgress);
      focused = hovered = stopped = false;
      update();
      emit(EVENT_AUTOPLAY_PLAY);
    }
  }
  function pause(stop) {
    if (stop === void 0) {
      stop = true;
    }
    stopped = !!stop;
    update();
    if (!isPaused()) {
      interval.pause();
      emit(EVENT_AUTOPLAY_PAUSE);
    }
  }
  function autoToggle() {
    if (!stopped) {
      hovered || focused ? pause(false) : play();
    }
  }
  function update() {
    if (toggle) {
      toggleClass(toggle, CLASS_ACTIVE, !stopped);
      setAttribute(toggle, ARIA_LABEL, options.i18n[stopped ? "play" : "pause"]);
    }
  }
  function onAnimationFrame(rate) {
    var bar = Elements2.bar;
    bar && style(bar, "width", rate * 100 + "%");
    emit(EVENT_AUTOPLAY_PLAYING, rate);
  }
  function onMove(index) {
    var Slide2 = Components2.Slides.getAt(index);
    interval.set(Slide2 && +getAttribute(Slide2.slide, INTERVAL_DATA_ATTRIBUTE) || options.interval);
  }
  return {
    mount,
    destroy: interval.cancel,
    play,
    pause,
    isPaused
  };
}
function Cover(Splide22, Components2, options) {
  var _EventInterface7 = EventInterface(Splide22), on = _EventInterface7.on;
  function mount() {
    if (options.cover) {
      on(EVENT_LAZYLOAD_LOADED, apply(toggle, true));
      on([EVENT_MOUNTED, EVENT_UPDATED, EVENT_REFRESH], apply(cover, true));
    }
  }
  function cover(cover2) {
    Components2.Slides.forEach(function(Slide2) {
      var img = child(Slide2.container || Slide2.slide, "img");
      if (img && img.src) {
        toggle(cover2, img, Slide2);
      }
    });
  }
  function toggle(cover2, img, Slide2) {
    Slide2.style("background", cover2 ? 'center/cover no-repeat url("' + img.src + '")' : "", true);
    display(img, cover2 ? "none" : "");
  }
  return {
    mount,
    destroy: apply(cover, false)
  };
}
var BOUNCE_DIFF_THRESHOLD = 10;
var BOUNCE_DURATION = 600;
var FRICTION_FACTOR = 0.6;
var BASE_VELOCITY = 1.5;
var MIN_DURATION = 800;
function Scroll(Splide22, Components2, options) {
  var _EventInterface8 = EventInterface(Splide22), on = _EventInterface8.on, emit = _EventInterface8.emit;
  var set = Splide22.state.set;
  var Move2 = Components2.Move;
  var getPosition = Move2.getPosition, getLimit = Move2.getLimit, exceededLimit = Move2.exceededLimit, translate = Move2.translate;
  var isSlide = Splide22.is(SLIDE);
  var interval;
  var callback;
  var friction = 1;
  function mount() {
    on(EVENT_MOVE, clear);
    on([EVENT_UPDATED, EVENT_REFRESH], cancel);
  }
  function scroll(destination, duration, snap, onScrolled, noConstrain) {
    var from = getPosition();
    clear();
    if (snap && (!isSlide || !exceededLimit())) {
      var size = Components2.Layout.sliderSize();
      var offset = sign(destination) * size * floor(abs(destination) / size) || 0;
      destination = Move2.toPosition(Components2.Controller.toDest(destination % size)) + offset;
    }
    var noDistance = approximatelyEqual(from, destination, 1);
    friction = 1;
    duration = noDistance ? 0 : duration || max(abs(destination - from) / BASE_VELOCITY, MIN_DURATION);
    callback = onScrolled;
    interval = RequestInterval(duration, onEnd, apply(update, from, destination, noConstrain), 1);
    set(SCROLLING);
    emit(EVENT_SCROLL);
    interval.start();
  }
  function onEnd() {
    set(IDLE);
    callback && callback();
    emit(EVENT_SCROLLED);
  }
  function update(from, to, noConstrain, rate) {
    var position = getPosition();
    var target = from + (to - from) * easing(rate);
    var diff = (target - position) * friction;
    translate(position + diff);
    if (isSlide && !noConstrain && exceededLimit()) {
      friction *= FRICTION_FACTOR;
      if (abs(diff) < BOUNCE_DIFF_THRESHOLD) {
        scroll(getLimit(exceededLimit(true)), BOUNCE_DURATION, false, callback, true);
      }
    }
  }
  function clear() {
    if (interval) {
      interval.cancel();
    }
  }
  function cancel() {
    if (interval && !interval.isPaused()) {
      clear();
      onEnd();
    }
  }
  function easing(t) {
    var easingFunc = options.easingFunc;
    return easingFunc ? easingFunc(t) : 1 - Math.pow(1 - t, 4);
  }
  return {
    mount,
    destroy: clear,
    scroll,
    cancel
  };
}
var SCROLL_LISTENER_OPTIONS = {
  passive: false,
  capture: true
};
function Drag(Splide22, Components2, options) {
  var _EventInterface9 = EventInterface(Splide22), on = _EventInterface9.on, emit = _EventInterface9.emit, bind = _EventInterface9.bind, unbind = _EventInterface9.unbind;
  var state = Splide22.state;
  var Move2 = Components2.Move, Scroll2 = Components2.Scroll, Controller2 = Components2.Controller, track = Components2.Elements.track, reduce = Components2.Media.reduce;
  var _Components2$Directio2 = Components2.Direction, resolve = _Components2$Directio2.resolve, orient = _Components2$Directio2.orient;
  var getPosition = Move2.getPosition, exceededLimit = Move2.exceededLimit;
  var basePosition;
  var baseEvent;
  var prevBaseEvent;
  var isFree;
  var dragging;
  var exceeded = false;
  var clickPrevented;
  var disabled;
  var target;
  function mount() {
    bind(track, POINTER_MOVE_EVENTS, noop, SCROLL_LISTENER_OPTIONS);
    bind(track, POINTER_UP_EVENTS, noop, SCROLL_LISTENER_OPTIONS);
    bind(track, POINTER_DOWN_EVENTS, onPointerDown, SCROLL_LISTENER_OPTIONS);
    bind(track, "click", onClick, {
      capture: true
    });
    bind(track, "dragstart", prevent);
    on([EVENT_MOUNTED, EVENT_UPDATED], init);
  }
  function init() {
    var drag = options.drag;
    disable(!drag);
    isFree = drag === "free";
  }
  function onPointerDown(e) {
    clickPrevented = false;
    if (!disabled) {
      var isTouch = isTouchEvent(e);
      if (isDraggable(e.target) && (isTouch || !e.button)) {
        if (!Controller2.isBusy()) {
          target = isTouch ? track : window;
          dragging = state.is([MOVING, SCROLLING]);
          prevBaseEvent = null;
          bind(target, POINTER_MOVE_EVENTS, onPointerMove, SCROLL_LISTENER_OPTIONS);
          bind(target, POINTER_UP_EVENTS, onPointerUp, SCROLL_LISTENER_OPTIONS);
          Move2.cancel();
          Scroll2.cancel();
          save(e);
        } else {
          prevent(e, true);
        }
      }
    }
  }
  function onPointerMove(e) {
    if (!state.is(DRAGGING)) {
      state.set(DRAGGING);
      emit(EVENT_DRAG);
    }
    if (e.cancelable) {
      if (dragging) {
        Move2.translate(basePosition + constrain(diffCoord(e)));
        var expired = diffTime(e) > LOG_INTERVAL;
        var hasExceeded = exceeded !== (exceeded = exceededLimit());
        if (expired || hasExceeded) {
          save(e);
        }
        clickPrevented = true;
        emit(EVENT_DRAGGING);
        prevent(e);
      } else if (isSliderDirection(e)) {
        dragging = shouldStart(e);
        prevent(e);
      }
    }
  }
  function onPointerUp(e) {
    if (state.is(DRAGGING)) {
      state.set(IDLE);
      emit(EVENT_DRAGGED);
    }
    if (dragging) {
      move(e);
      prevent(e);
    }
    unbind(target, POINTER_MOVE_EVENTS, onPointerMove);
    unbind(target, POINTER_UP_EVENTS, onPointerUp);
    dragging = false;
  }
  function onClick(e) {
    if (!disabled && clickPrevented) {
      prevent(e, true);
    }
  }
  function save(e) {
    prevBaseEvent = baseEvent;
    baseEvent = e;
    basePosition = getPosition();
  }
  function move(e) {
    var velocity = computeVelocity(e);
    var destination = computeDestination(velocity);
    var rewind = options.rewind && options.rewindByDrag;
    reduce(false);
    if (isFree) {
      Controller2.scroll(destination, 0, options.snap);
    } else if (Splide22.is(FADE)) {
      Controller2.go(orient(sign(velocity)) < 0 ? rewind ? "<" : "-" : rewind ? ">" : "+");
    } else if (Splide22.is(SLIDE) && exceeded && rewind) {
      Controller2.go(exceededLimit(true) ? ">" : "<");
    } else {
      Controller2.go(Controller2.toDest(destination), true);
    }
    reduce(true);
  }
  function shouldStart(e) {
    var thresholds = options.dragMinThreshold;
    var isObj = isObject(thresholds);
    var mouse = isObj && thresholds.mouse || 0;
    var touch = (isObj ? thresholds.touch : +thresholds) || 10;
    return abs(diffCoord(e)) > (isTouchEvent(e) ? touch : mouse);
  }
  function isSliderDirection(e) {
    return abs(diffCoord(e)) > abs(diffCoord(e, true));
  }
  function computeVelocity(e) {
    if (Splide22.is(LOOP) || !exceeded) {
      var time = diffTime(e);
      if (time && time < LOG_INTERVAL) {
        return diffCoord(e) / time;
      }
    }
    return 0;
  }
  function computeDestination(velocity) {
    return getPosition() + sign(velocity) * min(abs(velocity) * (options.flickPower || 600), isFree ? Infinity : Components2.Layout.listSize() * (options.flickMaxPages || 1));
  }
  function diffCoord(e, orthogonal) {
    return coordOf(e, orthogonal) - coordOf(getBaseEvent(e), orthogonal);
  }
  function diffTime(e) {
    return timeOf(e) - timeOf(getBaseEvent(e));
  }
  function getBaseEvent(e) {
    return baseEvent === e && prevBaseEvent || baseEvent;
  }
  function coordOf(e, orthogonal) {
    return (isTouchEvent(e) ? e.changedTouches[0] : e)["page" + resolve(orthogonal ? "Y" : "X")];
  }
  function constrain(diff) {
    return diff / (exceeded && Splide22.is(SLIDE) ? FRICTION : 1);
  }
  function isDraggable(target2) {
    var noDrag = options.noDrag;
    return !matches(target2, "." + CLASS_PAGINATION_PAGE + ", ." + CLASS_ARROW) && (!noDrag || !matches(target2, noDrag));
  }
  function isTouchEvent(e) {
    return typeof TouchEvent !== "undefined" && e instanceof TouchEvent;
  }
  function isDragging() {
    return dragging;
  }
  function disable(value) {
    disabled = value;
  }
  return {
    mount,
    disable,
    isDragging
  };
}
var NORMALIZATION_MAP = {
  Spacebar: " ",
  Right: ARROW_RIGHT,
  Left: ARROW_LEFT,
  Up: ARROW_UP,
  Down: ARROW_DOWN
};
function normalizeKey(key) {
  key = isString(key) ? key : key.key;
  return NORMALIZATION_MAP[key] || key;
}
var KEYBOARD_EVENT = "keydown";
function Keyboard(Splide22, Components2, options) {
  var _EventInterface10 = EventInterface(Splide22), on = _EventInterface10.on, bind = _EventInterface10.bind, unbind = _EventInterface10.unbind;
  var root = Splide22.root;
  var resolve = Components2.Direction.resolve;
  var target;
  var disabled;
  function mount() {
    init();
    on(EVENT_UPDATED, destroy);
    on(EVENT_UPDATED, init);
    on(EVENT_MOVE, onMove);
  }
  function init() {
    var keyboard = options.keyboard;
    if (keyboard) {
      target = keyboard === "global" ? window : root;
      bind(target, KEYBOARD_EVENT, onKeydown);
    }
  }
  function destroy() {
    unbind(target, KEYBOARD_EVENT);
  }
  function disable(value) {
    disabled = value;
  }
  function onMove() {
    var _disabled = disabled;
    disabled = true;
    nextTick(function() {
      disabled = _disabled;
    });
  }
  function onKeydown(e) {
    if (!disabled) {
      var key = normalizeKey(e);
      if (key === resolve(ARROW_LEFT)) {
        Splide22.go("<");
      } else if (key === resolve(ARROW_RIGHT)) {
        Splide22.go(">");
      }
    }
  }
  return {
    mount,
    destroy,
    disable
  };
}
var SRC_DATA_ATTRIBUTE = DATA_ATTRIBUTE + "-lazy";
var SRCSET_DATA_ATTRIBUTE = SRC_DATA_ATTRIBUTE + "-srcset";
var IMAGE_SELECTOR = "[" + SRC_DATA_ATTRIBUTE + "], [" + SRCSET_DATA_ATTRIBUTE + "]";
function LazyLoad(Splide22, Components2, options) {
  var _EventInterface11 = EventInterface(Splide22), on = _EventInterface11.on, off = _EventInterface11.off, bind = _EventInterface11.bind, emit = _EventInterface11.emit;
  var isSequential = options.lazyLoad === "sequential";
  var events = [EVENT_MOVED, EVENT_SCROLLED];
  var entries = [];
  function mount() {
    if (options.lazyLoad) {
      init();
      on(EVENT_REFRESH, init);
    }
  }
  function init() {
    empty(entries);
    register();
    if (isSequential) {
      loadNext();
    } else {
      off(events);
      on(events, check);
      check();
    }
  }
  function register() {
    Components2.Slides.forEach(function(Slide2) {
      queryAll(Slide2.slide, IMAGE_SELECTOR).forEach(function(img) {
        var src = getAttribute(img, SRC_DATA_ATTRIBUTE);
        var srcset = getAttribute(img, SRCSET_DATA_ATTRIBUTE);
        if (src !== img.src || srcset !== img.srcset) {
          var className = options.classes.spinner;
          var parent = img.parentElement;
          var spinner = child(parent, "." + className) || create("span", className, parent);
          entries.push([img, Slide2, spinner]);
          img.src || display(img, "none");
        }
      });
    });
  }
  function check() {
    entries = entries.filter(function(data) {
      var distance = options.perPage * ((options.preloadPages || 1) + 1) - 1;
      return data[1].isWithin(Splide22.index, distance) ? load(data) : true;
    });
    entries.length || off(events);
  }
  function load(data) {
    var img = data[0];
    addClass(data[1].slide, CLASS_LOADING);
    bind(img, "load error", apply(onLoad, data));
    setAttribute(img, "src", getAttribute(img, SRC_DATA_ATTRIBUTE));
    setAttribute(img, "srcset", getAttribute(img, SRCSET_DATA_ATTRIBUTE));
    removeAttribute(img, SRC_DATA_ATTRIBUTE);
    removeAttribute(img, SRCSET_DATA_ATTRIBUTE);
  }
  function onLoad(data, e) {
    var img = data[0], Slide2 = data[1];
    removeClass(Slide2.slide, CLASS_LOADING);
    if (e.type !== "error") {
      remove(data[2]);
      display(img, "");
      emit(EVENT_LAZYLOAD_LOADED, img, Slide2);
      emit(EVENT_RESIZE);
    }
    isSequential && loadNext();
  }
  function loadNext() {
    entries.length && load(entries.shift());
  }
  return {
    mount,
    destroy: apply(empty, entries),
    check
  };
}
function Pagination(Splide22, Components2, options) {
  var event = EventInterface(Splide22);
  var on = event.on, emit = event.emit, bind = event.bind;
  var Slides2 = Components2.Slides, Elements2 = Components2.Elements, Controller2 = Components2.Controller;
  var hasFocus = Controller2.hasFocus, getIndex = Controller2.getIndex, go = Controller2.go;
  var resolve = Components2.Direction.resolve;
  var placeholder = Elements2.pagination;
  var items = [];
  var list;
  var paginationClasses;
  function mount() {
    destroy();
    on([EVENT_UPDATED, EVENT_REFRESH, EVENT_END_INDEX_CHANGED], mount);
    var enabled = options.pagination;
    placeholder && display(placeholder, enabled ? "" : "none");
    if (enabled) {
      on([EVENT_MOVE, EVENT_SCROLL, EVENT_SCROLLED], update);
      createPagination();
      update();
      emit(EVENT_PAGINATION_MOUNTED, {
        list,
        items
      }, getAt(Splide22.index));
    }
  }
  function destroy() {
    if (list) {
      remove(placeholder ? slice(list.children) : list);
      removeClass(list, paginationClasses);
      empty(items);
      list = null;
    }
    event.destroy();
  }
  function createPagination() {
    var length = Splide22.length;
    var classes = options.classes, i18n = options.i18n, perPage = options.perPage;
    var max2 = hasFocus() ? Controller2.getEnd() + 1 : ceil(length / perPage);
    list = placeholder || create("ul", classes.pagination, Elements2.track.parentElement);
    addClass(list, paginationClasses = CLASS_PAGINATION + "--" + getDirection());
    setAttribute(list, ROLE, "tablist");
    setAttribute(list, ARIA_LABEL, i18n.select);
    setAttribute(list, ARIA_ORIENTATION, getDirection() === TTB ? "vertical" : "");
    for (var i = 0; i < max2; i++) {
      var li = create("li", null, list);
      var button = create("button", {
        class: classes.page,
        type: "button"
      }, li);
      var controls = Slides2.getIn(i).map(function(Slide2) {
        return Slide2.slide.id;
      });
      var text = !hasFocus() && perPage > 1 ? i18n.pageX : i18n.slideX;
      bind(button, "click", apply(onClick, i));
      if (options.paginationKeyboard) {
        bind(button, "keydown", apply(onKeydown, i));
      }
      setAttribute(li, ROLE, "presentation");
      setAttribute(button, ROLE, "tab");
      setAttribute(button, ARIA_CONTROLS, controls.join(" "));
      setAttribute(button, ARIA_LABEL, format(text, i + 1));
      setAttribute(button, TAB_INDEX, -1);
      items.push({
        li,
        button,
        page: i
      });
    }
  }
  function onClick(page) {
    go(">" + page, true);
  }
  function onKeydown(page, e) {
    var length = items.length;
    var key = normalizeKey(e);
    var dir = getDirection();
    var nextPage = -1;
    if (key === resolve(ARROW_RIGHT, false, dir)) {
      nextPage = ++page % length;
    } else if (key === resolve(ARROW_LEFT, false, dir)) {
      nextPage = (--page + length) % length;
    } else if (key === "Home") {
      nextPage = 0;
    } else if (key === "End") {
      nextPage = length - 1;
    }
    var item = items[nextPage];
    if (item) {
      focus(item.button);
      go(">" + nextPage);
      prevent(e, true);
    }
  }
  function getDirection() {
    return options.paginationDirection || options.direction;
  }
  function getAt(index) {
    return items[Controller2.toPage(index)];
  }
  function update() {
    var prev = getAt(getIndex(true));
    var curr = getAt(getIndex());
    if (prev) {
      var button = prev.button;
      removeClass(button, CLASS_ACTIVE);
      removeAttribute(button, ARIA_SELECTED);
      setAttribute(button, TAB_INDEX, -1);
    }
    if (curr) {
      var _button = curr.button;
      addClass(_button, CLASS_ACTIVE);
      setAttribute(_button, ARIA_SELECTED, true);
      setAttribute(_button, TAB_INDEX, "");
    }
    emit(EVENT_PAGINATION_UPDATED, {
      list,
      items
    }, prev, curr);
  }
  return {
    items,
    mount,
    destroy,
    getAt,
    update
  };
}
var TRIGGER_KEYS = [" ", "Enter"];
function Sync(Splide22, Components2, options) {
  var isNavigation = options.isNavigation, slideFocus = options.slideFocus;
  var events = [];
  function mount() {
    Splide22.splides.forEach(function(target) {
      if (!target.isParent) {
        sync(Splide22, target.splide);
        sync(target.splide, Splide22);
      }
    });
    if (isNavigation) {
      navigate();
    }
  }
  function destroy() {
    events.forEach(function(event) {
      event.destroy();
    });
    empty(events);
  }
  function remount() {
    destroy();
    mount();
  }
  function sync(splide, target) {
    var event = EventInterface(splide);
    event.on(EVENT_MOVE, function(index, prev, dest) {
      target.go(target.is(LOOP) ? dest : index);
    });
    events.push(event);
  }
  function navigate() {
    var event = EventInterface(Splide22);
    var on = event.on;
    on(EVENT_CLICK, onClick);
    on(EVENT_SLIDE_KEYDOWN, onKeydown);
    on([EVENT_MOUNTED, EVENT_UPDATED], update);
    events.push(event);
    event.emit(EVENT_NAVIGATION_MOUNTED, Splide22.splides);
  }
  function update() {
    setAttribute(Components2.Elements.list, ARIA_ORIENTATION, options.direction === TTB ? "vertical" : "");
  }
  function onClick(Slide2) {
    Splide22.go(Slide2.index);
  }
  function onKeydown(Slide2, e) {
    if (includes(TRIGGER_KEYS, normalizeKey(e))) {
      onClick(Slide2);
      prevent(e);
    }
  }
  return {
    setup: apply(Components2.Media.set, {
      slideFocus: isUndefined(slideFocus) ? isNavigation : slideFocus
    }, true),
    mount,
    destroy,
    remount
  };
}
function Wheel(Splide22, Components2, options) {
  var _EventInterface12 = EventInterface(Splide22), bind = _EventInterface12.bind;
  var lastTime = 0;
  function mount() {
    if (options.wheel) {
      bind(Components2.Elements.track, "wheel", onWheel, SCROLL_LISTENER_OPTIONS);
    }
  }
  function onWheel(e) {
    if (e.cancelable) {
      var deltaY = e.deltaY;
      var backwards = deltaY < 0;
      var timeStamp = timeOf(e);
      var _min = options.wheelMinThreshold || 0;
      var sleep = options.wheelSleep || 0;
      if (abs(deltaY) > _min && timeStamp - lastTime > sleep) {
        Splide22.go(backwards ? "<" : ">");
        lastTime = timeStamp;
      }
      shouldPrevent(backwards) && prevent(e);
    }
  }
  function shouldPrevent(backwards) {
    return !options.releaseWheel || Splide22.state.is(MOVING) || Components2.Controller.getAdjacent(backwards) !== -1;
  }
  return {
    mount
  };
}
var SR_REMOVAL_DELAY = 90;
function Live(Splide22, Components2, options) {
  var _EventInterface13 = EventInterface(Splide22), on = _EventInterface13.on;
  var track = Components2.Elements.track;
  var enabled = options.live && !options.isNavigation;
  var sr = create("span", CLASS_SR);
  var interval = RequestInterval(SR_REMOVAL_DELAY, apply(toggle, false));
  function mount() {
    if (enabled) {
      disable(!Components2.Autoplay.isPaused());
      setAttribute(track, ARIA_ATOMIC, true);
      sr.textContent = "\u2026";
      on(EVENT_AUTOPLAY_PLAY, apply(disable, true));
      on(EVENT_AUTOPLAY_PAUSE, apply(disable, false));
      on([EVENT_MOVED, EVENT_SCROLLED], apply(toggle, true));
    }
  }
  function toggle(active) {
    setAttribute(track, ARIA_BUSY, active);
    if (active) {
      append(track, sr);
      interval.start();
    } else {
      remove(sr);
      interval.cancel();
    }
  }
  function destroy() {
    removeAttribute(track, [ARIA_LIVE, ARIA_ATOMIC, ARIA_BUSY]);
    remove(sr);
  }
  function disable(disabled) {
    if (enabled) {
      setAttribute(track, ARIA_LIVE, disabled ? "off" : "polite");
    }
  }
  return {
    mount,
    disable,
    destroy
  };
}
var ComponentConstructors = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  Media,
  Direction,
  Elements,
  Slides,
  Layout,
  Clones,
  Move,
  Controller,
  Arrows,
  Autoplay,
  Cover,
  Scroll,
  Drag,
  Keyboard,
  LazyLoad,
  Pagination,
  Sync,
  Wheel,
  Live
});
var I18N = {
  prev: "Previous slide",
  next: "Next slide",
  first: "Go to first slide",
  last: "Go to last slide",
  slideX: "Go to slide %s",
  pageX: "Go to page %s",
  play: "Start autoplay",
  pause: "Pause autoplay",
  carousel: "carousel",
  slide: "slide",
  select: "Select a slide to show",
  slideLabel: "%s of %s"
};
var DEFAULTS = {
  type: "slide",
  role: "region",
  speed: 400,
  perPage: 1,
  cloneStatus: true,
  arrows: true,
  pagination: true,
  paginationKeyboard: true,
  interval: 5e3,
  pauseOnHover: true,
  pauseOnFocus: true,
  resetProgress: true,
  easing: "cubic-bezier(0.25, 1, 0.5, 1)",
  drag: true,
  direction: "ltr",
  trimSpace: true,
  focusableNodes: "a, button, textarea, input, select, iframe",
  live: true,
  classes: CLASSES,
  i18n: I18N,
  reducedMotion: {
    speed: 0,
    rewindSpeed: 0,
    autoplay: "pause"
  }
};
function Fade(Splide22, Components2, options) {
  var Slides2 = Components2.Slides;
  function mount() {
    EventInterface(Splide22).on([EVENT_MOUNTED, EVENT_REFRESH], init);
  }
  function init() {
    Slides2.forEach(function(Slide2) {
      Slide2.style("transform", "translateX(-" + 100 * Slide2.index + "%)");
    });
  }
  function start(index, done) {
    Slides2.style("transition", "opacity " + options.speed + "ms " + options.easing);
    nextTick(done);
  }
  return {
    mount,
    start,
    cancel: noop
  };
}
function Slide(Splide22, Components2, options) {
  var Move2 = Components2.Move, Controller2 = Components2.Controller, Scroll2 = Components2.Scroll;
  var list = Components2.Elements.list;
  var transition = apply(style, list, "transition");
  var endCallback;
  function mount() {
    EventInterface(Splide22).bind(list, "transitionend", function(e) {
      if (e.target === list && endCallback) {
        cancel();
        endCallback();
      }
    });
  }
  function start(index, done) {
    var destination = Move2.toPosition(index, true);
    var position = Move2.getPosition();
    var speed = getSpeed(index);
    if (abs(destination - position) >= 1 && speed >= 1) {
      if (options.useScroll) {
        Scroll2.scroll(destination, speed, false, done);
      } else {
        transition("transform " + speed + "ms " + options.easing);
        Move2.translate(destination, true);
        endCallback = done;
      }
    } else {
      Move2.jump(index);
      done();
    }
  }
  function cancel() {
    transition("");
    Scroll2.cancel();
  }
  function getSpeed(index) {
    var rewindSpeed = options.rewindSpeed;
    if (Splide22.is(SLIDE) && rewindSpeed) {
      var prev = Controller2.getIndex(true);
      var end = Controller2.getEnd();
      if (prev === 0 && index >= end || prev >= end && index === 0) {
        return rewindSpeed;
      }
    }
    return options.speed;
  }
  return {
    mount,
    start,
    cancel
  };
}
var _Splide = /* @__PURE__ */ function() {
  function _Splide2(target, options) {
    this.event = EventInterface();
    this.Components = {};
    this.state = State(CREATED);
    this.splides = [];
    this._o = {};
    this._E = {};
    var root = isString(target) ? query(document, target) : target;
    assert(root, root + " is invalid.");
    this.root = root;
    options = merge({
      label: getAttribute(root, ARIA_LABEL) || "",
      labelledby: getAttribute(root, ARIA_LABELLEDBY) || ""
    }, DEFAULTS, _Splide2.defaults, options || {});
    try {
      merge(options, JSON.parse(getAttribute(root, DATA_ATTRIBUTE)));
    } catch (e) {
      assert(false, "Invalid JSON");
    }
    this._o = Object.create(merge({}, options));
  }
  var _proto = _Splide2.prototype;
  _proto.mount = function mount(Extensions, Transition) {
    var _this = this;
    var state = this.state, Components2 = this.Components;
    assert(state.is([CREATED, DESTROYED]), "Already mounted!");
    state.set(CREATED);
    this._C = Components2;
    this._T = Transition || this._T || (this.is(FADE) ? Fade : Slide);
    this._E = Extensions || this._E;
    var Constructors = assign({}, ComponentConstructors, this._E, {
      Transition: this._T
    });
    forOwn(Constructors, function(Component, key) {
      var component = Component(_this, Components2, _this._o);
      Components2[key] = component;
      component.setup && component.setup();
    });
    forOwn(Components2, function(component) {
      component.mount && component.mount();
    });
    this.emit(EVENT_MOUNTED);
    addClass(this.root, CLASS_INITIALIZED);
    state.set(IDLE);
    this.emit(EVENT_READY);
    return this;
  };
  _proto.sync = function sync(splide) {
    this.splides.push({
      splide
    });
    splide.splides.push({
      splide: this,
      isParent: true
    });
    if (this.state.is(IDLE)) {
      this._C.Sync.remount();
      splide.Components.Sync.remount();
    }
    return this;
  };
  _proto.go = function go(control) {
    this._C.Controller.go(control);
    return this;
  };
  _proto.on = function on(events, callback) {
    this.event.on(events, callback);
    return this;
  };
  _proto.off = function off(events) {
    this.event.off(events);
    return this;
  };
  _proto.emit = function emit(event) {
    var _this$event;
    (_this$event = this.event).emit.apply(_this$event, [event].concat(slice(arguments, 1)));
    return this;
  };
  _proto.add = function add(slides, index) {
    this._C.Slides.add(slides, index);
    return this;
  };
  _proto.remove = function remove2(matcher) {
    this._C.Slides.remove(matcher);
    return this;
  };
  _proto.is = function is(type) {
    return this._o.type === type;
  };
  _proto.refresh = function refresh() {
    this.emit(EVENT_REFRESH);
    return this;
  };
  _proto.destroy = function destroy(completely) {
    if (completely === void 0) {
      completely = true;
    }
    var event = this.event, state = this.state;
    if (state.is(CREATED)) {
      EventInterface(this).on(EVENT_READY, this.destroy.bind(this, completely));
    } else {
      forOwn(this._C, function(component) {
        component.destroy && component.destroy(completely);
      }, true);
      event.emit(EVENT_DESTROY);
      event.destroy();
      completely && empty(this.splides);
      state.set(DESTROYED);
    }
    return this;
  };
  _createClass(_Splide2, [{
    key: "options",
    get: function get() {
      return this._o;
    },
    set: function set(options) {
      this._C.Media.set(options, true, true);
    }
  }, {
    key: "length",
    get: function get() {
      return this._C.Slides.getLength(true);
    }
  }, {
    key: "index",
    get: function get() {
      return this._C.Controller.getIndex();
    }
  }]);
  return _Splide2;
}();
var Splide = _Splide;
Splide.defaults = {};
Splide.STATES = STATES;

// src/js/components/Splide/Splide.tsx


// src/js/constants/events.ts
var EVENTS = [
  [EVENT_MOUNTED, "onMounted"],
  [EVENT_READY, "onReady"],
  [EVENT_MOVE, "onMove"],
  [EVENT_MOVED, "onMoved"],
  [EVENT_CLICK, "onClick"],
  [EVENT_ACTIVE, "onActive"],
  [EVENT_INACTIVE, "onInactive"],
  [EVENT_VISIBLE, "onVisible"],
  [EVENT_HIDDEN, "onHidden"],
  [EVENT_REFRESH, "onRefresh"],
  [EVENT_UPDATED, "onUpdated"],
  [EVENT_RESIZE, "onResize"],
  [EVENT_RESIZED, "onResized"],
  [EVENT_DRAG, "onDrag"],
  [EVENT_DRAGGING, "onDragging"],
  [EVENT_DRAGGED, "onDragged"],
  [EVENT_SCROLL, "onScroll"],
  [EVENT_SCROLLED, "onScrolled"],
  [EVENT_DESTROY, "onDestroy"],
  [EVENT_ARROWS_MOUNTED, "onArrowsMounted"],
  [EVENT_ARROWS_UPDATED, "onArrowsUpdated"],
  [EVENT_PAGINATION_MOUNTED, "onPaginationMounted"],
  [EVENT_PAGINATION_UPDATED, "onPaginationUpdated"],
  [EVENT_NAVIGATION_MOUNTED, "onNavigationMounted"],
  [EVENT_AUTOPLAY_PLAY, "onAutoplayPlay"],
  [EVENT_AUTOPLAY_PLAYING, "onAutoplayPlaying"],
  [EVENT_AUTOPLAY_PAUSE, "onAutoplayPause"],
  [EVENT_LAZYLOAD_LOADED, "onLazyLoadLoaded"]
];

// src/js/utils/classNames/classNames.ts
function classNames(...classes) {
  return classes.filter(Boolean).join(" ");
}

// src/js/utils/isObject/isObject.ts
function isObject2(subject) {
  return subject !== null && typeof subject === "object";
}

// src/js/utils/isEqualDeep/isEqualDeep.ts
function isEqualDeep(subject1, subject2) {
  if (Array.isArray(subject1) && Array.isArray(subject2)) {
    return subject1.length === subject2.length && !subject1.some((elm, index) => !isEqualDeep(elm, subject2[index]));
  }
  if (isObject2(subject1) && isObject2(subject2)) {
    const keys1 = Object.keys(subject1);
    const keys2 = Object.keys(subject2);
    return keys1.length === keys2.length && !keys1.some((key) => {
      return !Object.prototype.hasOwnProperty.call(subject2, key) || !isEqualDeep(subject1[key], subject2[key]);
    });
  }
  return subject1 === subject2;
}

// src/js/utils/isEqualShallow/isEqualShallow.ts
function isEqualShallow(array1, array2) {
  return array1.length === array2.length && !array1.some((elm, index) => elm !== array2[index]);
}

// src/js/utils/forOwn/forOwn.ts
function forOwn2(object, iteratee) {
  if (object) {
    const keys = Object.keys(object);
    for (let i = 0; i < keys.length; i++) {
      const key = keys[i];
      if (key !== "__proto__") {
        if (iteratee(object[key], key) === false) {
          break;
        }
      }
    }
  }
  return object;
}

// src/js/utils/merge/merge.ts
function merge2(object, source) {
  const merged = object;
  forOwn2(source, (value, key) => {
    if (Array.isArray(value)) {
      merged[key] = value.slice();
    } else if (isObject2(value)) {
      merged[key] = merge2(isObject2(merged[key]) ? merged[key] : {}, value);
    } else {
      merged[key] = value;
    }
  });
  return merged;
}

// src/js/components/SplideTrack/SplideTrack.tsx

var SplideTrack = ({ children: children2, className, ...props }) => {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classNames("splide__track", className),
    ...props
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", {
    className: "splide__list"
  }, children2));
};

// src/js/components/Splide/Splide.tsx
var Splide2 = class extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
  constructor() {
    super(...arguments);
    this.splideRef = react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
    this.slides = [];
  }
  componentDidMount() {
    const { options, extensions, transition } = this.props;
    const { current } = this.splideRef;
    if (current) {
      this.splide = new Splide(current, options);
      this.bind(this.splide);
      this.splide.mount(extensions, transition);
      this.options = merge2({}, options || {});
      this.slides = this.getSlides();
    }
  }
  componentWillUnmount() {
    if (this.splide) {
      this.splide.destroy();
      this.splide = void 0;
    }
    this.options = void 0;
    this.slides.length = 0;
  }
  componentDidUpdate() {
    if (!this.splide) {
      return;
    }
    const { options } = this.props;
    if (options && !isEqualDeep(this.options, options)) {
      this.splide.options = options;
      this.options = merge2({}, options);
    }
    const newSlides = this.getSlides();
    if (!isEqualShallow(this.slides, newSlides)) {
      this.splide.refresh();
      this.slides = newSlides;
    }
  }
  sync(splide) {
    var _a;
    (_a = this.splide) == null ? void 0 : _a.sync(splide);
  }
  go(control) {
    var _a;
    (_a = this.splide) == null ? void 0 : _a.go(control);
  }
  getSlides() {
    var _a;
    if (this.splide) {
      const children2 = (_a = this.splide.Components.Elements) == null ? void 0 : _a.list.children;
      return children2 && Array.prototype.slice.call(children2) || [];
    }
    return [];
  }
  bind(splide) {
    EVENTS.forEach(([event, name]) => {
      const handler = this.props[name];
      if (typeof handler === "function") {
        splide.on(event, (...args) => {
          handler(splide, ...args);
        });
      }
    });
  }
  omit(props, keys) {
    keys.forEach((key) => {
      if (Object.prototype.hasOwnProperty.call(props, key)) {
        delete props[key];
      }
    });
    return props;
  }
  render() {
    const { className, tag: Root = "div", hasTrack = true, children: children2, ...props } = this.props;
    return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Root, {
      className: classNames("splide", className),
      ref: this.splideRef,
      ...this.omit(props, ["options", ...EVENTS.map((event) => event[1])])
    }, hasTrack ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SplideTrack, null, children2) : children2);
  }
};

// src/js/components/SplideSlide/SplideSlide.tsx

var SplideSlide = ({ children: children2, className, ...props }) => {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", {
    className: classNames("splide__slide", className),
    ...props
  }, children2);
};

/*!
 * Splide.js
 * Version  : 4.1.3
 * License  : MIT
 * Copyright: 2022 Naotoshi Fujita
 */


/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/icon/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/icon/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */


/** @typedef {{icon: JSX.Element, size?: number} & import('@wordpress/primitives').SVGProps} IconProps */

/**
 * Return an SVG icon.
 *
 * @param {IconProps}                                 props icon is the SVG component to render
 *                                                          size is a number specifiying the icon size in pixels
 *                                                          Other props will be passed to wrapped SVG component
 * @param {import('react').ForwardedRef<HTMLElement>} ref   The forwarded ref to the SVG element.
 *
 * @return {JSX.Element}  Icon component
 */
function Icon({
  icon,
  size = 24,
  ...props
}, ref) {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(icon, {
    width: size,
    height: size,
    ...props,
    ref
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(Icon));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/add-card.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/add-card.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const addCard = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M18.5 5.5V8H20V5.5h2.5V4H20V1.5h-1.5V4H16v1.5h2.5zM12 4H6a2 2 0 00-2 2v12a2 2 0 002 2h12a2 2 0 002-2v-6h-1.5v6a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5h6V4z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (addCard);
//# sourceMappingURL=add-card.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/arrow-right.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/arrow-right.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const arrowRight = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m14.5 6.5-1 1 3.7 3.7H4v1.6h13.2l-3.7 3.7 1 1 5.6-5.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (arrowRight);
//# sourceMappingURL=arrow-right.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/brush.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/brush.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const brush = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M4 20h8v-1.5H4V20zM18.9 3.5c-.6-.6-1.5-.6-2.1 0l-7.2 7.2c-.4-.1-.7 0-1.1.1-.5.2-1.5.7-1.9 2.2-.4 1.7-.8 2.2-1.1 2.7-.1.1-.2.3-.3.4l-.6 1.1H6c2 0 3.4-.4 4.7-1.4.8-.6 1.2-1.4 1.3-2.3 0-.3 0-.5-.1-.7L19 5.7c.5-.6.5-1.6-.1-2.2zM9.7 14.7c-.7.5-1.5.8-2.4 1 .2-.5.5-1.2.8-2.3.2-.6.4-1 .8-1.1.5-.1 1 .1 1.3.3.2.2.3.5.2.8 0 .3-.1.9-.7 1.3z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (brush);
//# sourceMappingURL=brush.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/category.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/category.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const category = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M6 5.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5zM4 6a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2H6a2 2 0 01-2-2V6zm11-.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5h-3a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5zM13 6a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2h-3a2 2 0 01-2-2V6zm5 8.5h-3a.5.5 0 00-.5.5v3a.5.5 0 00.5.5h3a.5.5 0 00.5-.5v-3a.5.5 0 00-.5-.5zM15 13a2 2 0 00-2 2v3a2 2 0 002 2h3a2 2 0 002-2v-3a2 2 0 00-2-2h-3zm-9 1.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5v-3a.5.5 0 01.5-.5zM4 15a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2H6a2 2 0 01-2-2v-3z",
  fillRule: "evenodd",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (category);
//# sourceMappingURL=category.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/check.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/check.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const check = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M16.7 7.1l-6.3 8.5-3.3-2.5-.9 1.2 4.5 3.4L17.9 8z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (check);
//# sourceMappingURL=check.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/close-small.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/close-small.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const closeSmall = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 13.06l3.712 3.713 1.061-1.06L13.061 12l3.712-3.712-1.06-1.06L12 10.938 8.288 7.227l-1.061 1.06L10.939 12l-3.712 3.712 1.06 1.061L12 13.061z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (closeSmall);
//# sourceMappingURL=close-small.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/close.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/close.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const close = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M13 11.8l6.1-6.3-1-1-6.1 6.2-6.1-6.2-1 1 6.1 6.3-6.5 6.7 1 1 6.5-6.6 6.5 6.6 1-1z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (close);
//# sourceMappingURL=close.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/cog.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/cog.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const cog = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  d: "M10.289 4.836A1 1 0 0111.275 4h1.306a1 1 0 01.987.836l.244 1.466c.787.26 1.503.679 2.108 1.218l1.393-.522a1 1 0 011.216.437l.653 1.13a1 1 0 01-.23 1.273l-1.148.944a6.025 6.025 0 010 2.435l1.149.946a1 1 0 01.23 1.272l-.653 1.13a1 1 0 01-1.216.437l-1.394-.522c-.605.54-1.32.958-2.108 1.218l-.244 1.466a1 1 0 01-.987.836h-1.306a1 1 0 01-.986-.836l-.244-1.466a5.995 5.995 0 01-2.108-1.218l-1.394.522a1 1 0 01-1.217-.436l-.653-1.131a1 1 0 01.23-1.272l1.149-.946a6.026 6.026 0 010-2.435l-1.148-.944a1 1 0 01-.23-1.272l.653-1.131a1 1 0 011.217-.437l1.393.522a5.994 5.994 0 012.108-1.218l.244-1.466zM14.929 12a3 3 0 11-6 0 3 3 0 016 0z",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (cog);
//# sourceMappingURL=cog.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/columns.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/columns.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const columns = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M15 7.5h-5v10h5v-10Zm1.5 0v10H19a.5.5 0 0 0 .5-.5V8a.5.5 0 0 0-.5-.5h-2.5ZM6 7.5h2.5v10H6a.5.5 0 0 1-.5-.5V8a.5.5 0 0 1 .5-.5ZM6 6h13a2 2 0 0 1 2 2v9a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (columns);
//# sourceMappingURL=columns.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/copy-small.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/copy-small.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const copySmall = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M5.625 5.5h9.75c.069 0 .125.056.125.125v9.75a.125.125 0 0 1-.125.125h-9.75a.125.125 0 0 1-.125-.125v-9.75c0-.069.056-.125.125-.125ZM4 5.625C4 4.728 4.728 4 5.625 4h9.75C16.273 4 17 4.728 17 5.625v9.75c0 .898-.727 1.625-1.625 1.625h-9.75A1.625 1.625 0 0 1 4 15.375v-9.75Zm14.5 11.656v-9H20v9C20 18.8 18.77 20 17.251 20H6.25v-1.5h11.001c.69 0 1.249-.528 1.249-1.219Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (copySmall);
//# sourceMappingURL=copy-small.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/copy.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/copy.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const copy = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M5 4.5h11a.5.5 0 0 1 .5.5v11a.5.5 0 0 1-.5.5H5a.5.5 0 0 1-.5-.5V5a.5.5 0 0 1 .5-.5ZM3 5a2 2 0 0 1 2-2h11a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5Zm17 3v10.75c0 .69-.56 1.25-1.25 1.25H6v1.5h12.75a2.75 2.75 0 0 0 2.75-2.75V8H20Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (copy);
//# sourceMappingURL=copy.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/format-capitalize.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/format-capitalize.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const formatCapitalize = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M7.1 6.8L3.1 18h1.6l1.1-3h4.3l1.1 3h1.6l-4-11.2H7.1zm-.8 6.8L8 8.9l1.7 4.7H6.3zm14.5-1.5c-.3-.6-.7-1.1-1.2-1.5-.6-.4-1.2-.6-1.9-.6-.5 0-.9.1-1.4.3-.4.2-.8.5-1.1.8V6h-1.4v12h1.3l.2-1c.2.4.6.6 1 .8.4.2.9.3 1.4.3.7 0 1.2-.2 1.8-.5.5-.4 1-.9 1.3-1.5.3-.6.5-1.3.5-2.1-.1-.6-.2-1.3-.5-1.9zm-1.7 4c-.4.5-.9.8-1.6.8s-1.2-.2-1.7-.7c-.4-.5-.7-1.2-.7-2.1 0-.9.2-1.6.7-2.1.4-.5 1-.7 1.7-.7s1.2.3 1.6.8c.4.5.6 1.2.6 2 .1.8-.2 1.4-.6 2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatCapitalize);
//# sourceMappingURL=format-capitalize.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/format-lowercase.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/format-lowercase.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const formatLowercase = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M11 16.8c-.1-.1-.2-.3-.3-.5v-2.6c0-.9-.1-1.7-.3-2.2-.2-.5-.5-.9-.9-1.2-.4-.2-.9-.3-1.6-.3-.5 0-1 .1-1.5.2s-.9.3-1.2.6l.2 1.2c.4-.3.7-.4 1.1-.5.3-.1.7-.2 1-.2.6 0 1 .1 1.3.4.3.2.4.7.4 1.4-1.2 0-2.3.2-3.3.7s-1.4 1.1-1.4 2.1c0 .7.2 1.2.7 1.6.4.4 1 .6 1.8.6.9 0 1.7-.4 2.4-1.2.1.3.2.5.4.7.1.2.3.3.6.4.3.1.6.1 1.1.1h.1l.2-1.2h-.1c-.4.1-.6 0-.7-.1zM9.2 16c-.2.3-.5.6-.9.8-.3.1-.7.2-1.1.2-.4 0-.7-.1-.9-.3-.2-.2-.3-.5-.3-.9 0-.6.2-1 .7-1.3.5-.3 1.3-.4 2.5-.5v2zm10.6-3.9c-.3-.6-.7-1.1-1.2-1.5-.6-.4-1.2-.6-1.9-.6-.5 0-.9.1-1.4.3-.4.2-.8.5-1.1.8V6h-1.4v12h1.3l.2-1c.2.4.6.6 1 .8.4.2.9.3 1.4.3.7 0 1.2-.2 1.8-.5.5-.4 1-.9 1.3-1.5.3-.6.5-1.3.5-2.1-.1-.6-.2-1.3-.5-1.9zm-1.7 4c-.4.5-.9.8-1.6.8s-1.2-.2-1.7-.7c-.4-.5-.7-1.2-.7-2.1 0-.9.2-1.6.7-2.1.4-.5 1-.7 1.7-.7s1.2.3 1.6.8c.4.5.6 1.2.6 2s-.2 1.4-.6 2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatLowercase);
//# sourceMappingURL=format-lowercase.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/format-uppercase.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/format-uppercase.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const formatUppercase = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M6.1 6.8L2.1 18h1.6l1.1-3h4.3l1.1 3h1.6l-4-11.2H6.1zm-.8 6.8L7 8.9l1.7 4.7H5.3zm15.1-.7c-.4-.5-.9-.8-1.6-1 .4-.2.7-.5.8-.9.2-.4.3-.9.3-1.4 0-.9-.3-1.6-.8-2-.6-.5-1.3-.7-2.4-.7h-3.5V18h4.2c1.1 0 2-.3 2.6-.8.6-.6 1-1.4 1-2.4-.1-.8-.3-1.4-.6-1.9zm-5.7-4.7h1.8c.6 0 1.1.1 1.4.4.3.2.5.7.5 1.3 0 .6-.2 1.1-.5 1.3-.3.2-.8.4-1.4.4h-1.8V8.2zm4 8c-.4.3-.9.5-1.5.5h-2.6v-3.8h2.6c1.4 0 2 .6 2 1.9.1.6-.1 1-.5 1.4z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatUppercase);
//# sourceMappingURL=format-uppercase.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/gallery.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/gallery.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   gallery: () => (/* binding */ gallery)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const gallery = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M16.375 4.5H4.625a.125.125 0 0 0-.125.125v8.254l2.859-1.54a.75.75 0 0 1 .68-.016l2.384 1.142 2.89-2.074a.75.75 0 0 1 .874 0l2.313 1.66V4.625a.125.125 0 0 0-.125-.125Zm.125 9.398-2.75-1.975-2.813 2.02a.75.75 0 0 1-.76.067l-2.444-1.17L4.5 14.583v1.792c0 .069.056.125.125.125h11.75a.125.125 0 0 0 .125-.125v-2.477ZM4.625 3C3.728 3 3 3.728 3 4.625v11.75C3 17.273 3.728 18 4.625 18h11.75c.898 0 1.625-.727 1.625-1.625V4.625C18 3.728 17.273 3 16.375 3H4.625ZM20 8v11c0 .69-.31 1-.999 1H6v1.5h13.001c1.52 0 2.499-.982 2.499-2.5V8H20Z",
  fillRule: "evenodd",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (gallery);
//# sourceMappingURL=gallery.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/help.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/help.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const help = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 4.75a7.25 7.25 0 100 14.5 7.25 7.25 0 000-14.5zM3.25 12a8.75 8.75 0 1117.5 0 8.75 8.75 0 01-17.5 0zM12 8.75a1.5 1.5 0 01.167 2.99c-.465.052-.917.44-.917 1.01V14h1.5v-.845A3 3 0 109 10.25h1.5a1.5 1.5 0 011.5-1.5zM11.25 15v1.5h1.5V15h-1.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (help);
//# sourceMappingURL=help.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/link.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/link.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const link = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M10 17.389H8.444A5.194 5.194 0 1 1 8.444 7H10v1.5H8.444a3.694 3.694 0 0 0 0 7.389H10v1.5ZM14 7h1.556a5.194 5.194 0 0 1 0 10.39H14v-1.5h1.556a3.694 3.694 0 0 0 0-7.39H14V7Zm-4.5 6h5v-1.5h-5V13Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (link);
//# sourceMappingURL=link.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/menu.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/menu.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const menu = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M5 5v1.5h14V5H5zm0 7.8h14v-1.5H5v1.5zM5 19h14v-1.5H5V19z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (menu);
//# sourceMappingURL=menu.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/page.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/page.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const page = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M15.5 7.5h-7V9h7V7.5Zm-7 3.5h7v1.5h-7V11Zm7 3.5h-7V16h7v-1.5Z"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M17 4H7a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2ZM7 5.5h10a.5.5 0 0 1 .5.5v12a.5.5 0 0 1-.5.5H7a.5.5 0 0 1-.5-.5V6a.5.5 0 0 1 .5-.5Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (page);
//# sourceMappingURL=page.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/pages.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/pages.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const pages = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M14.5 5.5h-7V7h7V5.5ZM7.5 9h7v1.5h-7V9Zm7 3.5h-7V14h7v-1.5Z"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M16 2H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2ZM6 3.5h10a.5.5 0 0 1 .5.5v12a.5.5 0 0 1-.5.5H6a.5.5 0 0 1-.5-.5V4a.5.5 0 0 1 .5-.5Z"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M20 8v11c0 .69-.31 1-.999 1H6v1.5h13.001c1.52 0 2.499-.982 2.499-2.5V8H20Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (pages);
//# sourceMappingURL=pages.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/pencil.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/pencil.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const pencil = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m19 7-3-3-8.5 8.5-1 4 4-1L19 7Zm-7 11.5H5V20h7v-1.5Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (pencil);
//# sourceMappingURL=pencil.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/plus.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/plus.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const plus = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M11 12.5V17.5H12.5V12.5H17.5V11H12.5V6H11V11H6V12.5H11Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plus);
//# sourceMappingURL=plus.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/post-comments.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/post-comments.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const postComments = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M14 10.1V4c0-.6-.4-1-1-1H5c-.6 0-1 .4-1 1v8.3c0 .3.2.7.6.8.1.1.2.1.3.1.2 0 .5-.1.6-.3l1.8-1.8H13c.6 0 1-.4 1-1zm-1.5-.5H6.7l-1.2 1.2V4.5h7v5.1zM19 12h-8c-.6 0-1 .4-1 1v6.1c0 .6.4 1 1 1h5.7l1.8 1.8c.1.2.4.3.6.3.1 0 .2 0 .3-.1.4-.1.6-.5.6-.8V13c0-.6-.4-1-1-1zm-.5 7.8l-1.2-1.2h-5.8v-5.1h7v6.3z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (postComments);
//# sourceMappingURL=post-comments.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/settings.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/settings.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const settings = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m19 7.5h-7.628c-.3089-.87389-1.1423-1.5-2.122-1.5-.97966 0-1.81309.62611-2.12197 1.5h-2.12803v1.5h2.12803c.30888.87389 1.14231 1.5 2.12197 1.5.9797 0 1.8131-.62611 2.122-1.5h7.628z"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m19 15h-2.128c-.3089-.8739-1.1423-1.5-2.122-1.5s-1.8131.6261-2.122 1.5h-7.628v1.5h7.628c.3089.8739 1.1423 1.5 2.122 1.5s1.8131-.6261 2.122-1.5h2.128z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (settings);
//# sourceMappingURL=settings.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/store.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/store.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const store = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  d: "M19.75 11H21V8.667L19.875 4H4.125L3 8.667V11h1.25v8.75h15.5V11zm-1.5 0H5.75v7.25H10V13h4v5.25h4.25V11zm-5.5-5.5h2.067l.486 3.24.028.76H12.75v-4zm-3.567 0h2.067v4H8.669l.028-.76.486-3.24zm7.615 3.1l-.464-3.1h2.36l.806 3.345V9.5h-2.668l-.034-.9zM7.666 5.5h-2.36L4.5 8.845V9.5h2.668l.034-.9.464-3.1z",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);
//# sourceMappingURL=store.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/styles.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/styles.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   styles: () => (/* binding */ styles)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const styles = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 4c-4.4 0-8 3.6-8 8v.1c0 4.1 3.2 7.5 7.2 7.9h.8c4.4 0 8-3.6 8-8s-3.6-8-8-8zm0 15V5c3.9 0 7 3.1 7 7s-3.1 7-7 7z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (styles);
//# sourceMappingURL=styles.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/trash.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/trash.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const trash = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M12 5.5A2.25 2.25 0 0 0 9.878 7h4.244A2.251 2.251 0 0 0 12 5.5ZM12 4a3.751 3.751 0 0 0-3.675 3H5v1.5h1.27l.818 8.997a2.75 2.75 0 0 0 2.739 2.501h4.347a2.75 2.75 0 0 0 2.738-2.5L17.73 8.5H19V7h-3.325A3.751 3.751 0 0 0 12 4Zm4.224 4.5H7.776l.806 8.861a1.25 1.25 0 0 0 1.245 1.137h4.347a1.25 1.25 0 0 0 1.245-1.137l.805-8.861Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (trash);
//# sourceMappingURL=trash.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/update.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/update.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const update = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m11.3 17.2-5-5c-.1-.1-.1-.3 0-.4l2.3-2.3-1.1-1-2.3 2.3c-.7.7-.7 1.8 0 2.5l5 5H7.5v1.5h5.3v-5.2h-1.5v2.6zm7.5-6.4-5-5h2.7V4.2h-5.2v5.2h1.5V6.8l5 5c.1.1.1.3 0 .4l-2.3 2.3 1.1 1.1 2.3-2.3c.6-.7.6-1.9-.1-2.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (update);
//# sourceMappingURL=update.js.map

/***/ }),

/***/ "./src/breakpoints.js":
/*!****************************!*\
  !*** ./src/breakpoints.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const breakPoints = {
  Mobile: {
    name: "Mobile",
    id: "Mobile",
    icon: '<span class="dashicons dashicons-smartphone">',
    min: 0,
    max: 767
  },
  Tablet: {
    name: "Tablet",
    id: "Tablet",
    icon: '<span class="dashicons dashicons-tablet"></span>',
    min: 768,
    max: 991
  },
  Desktop: {
    name: "Desktop",
    id: "Desktop",
    icon: '<span class="dashicons dashicons-desktop"></span>',
    min: 992,
    max: 1280
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (breakPoints);

/***/ }),

/***/ "./src/colors-presets.js":
/*!*******************************!*\
  !*** ./src/colors-presets.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const colorsPresets = [{
  name: '9DD6DF',
  color: '#9DD6DF'
}, {
  name: '18978F',
  color: '#18978F'
}, {
  name: 'A084CF',
  color: '#A084CF'
}, {
  name: 'DFBB9D',
  color: '#DFBB9D'
}, {
  name: '774360',
  color: '#774360'
}, {
  name: '3AB0FF',
  color: '#3AB0FF'
}, {
  name: '51557E',
  color: '#51557E'
}];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (colorsPresets);

/***/ }),

/***/ "./src/components/BuilderView/index.js":
/*!*********************************************!*\
  !*** ./src/components/BuilderView/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _preview_accordions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./preview-accordions */ "./src/components/BuilderView/preview-accordions.js");
/* harmony import */ var _preview_tabs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./preview-tabs */ "./src/components/BuilderView/preview-tabs.js");
/* harmony import */ var _preview_image_accordion__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./preview-image-accordion */ "./src/components/BuilderView/preview-image-accordion.js");
/* harmony import */ var _preview_accordion_menu__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./preview-accordion-menu */ "./src/components/BuilderView/preview-accordion-menu.js");
/* harmony import */ var _preview_faq_grid__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./preview-faq-grid */ "./src/components/BuilderView/preview-faq-grid.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;













var myStore = wp.data.select("postgrid-shop");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var id = props.id;
  var appData = props.appData;
  var onChange = props.onChange;
  var addNotifications = props.addNotifications;
  var setHelp = props.setHelp;
  var isLoading = props.isLoading;
  var onUpdate = props.onUpdate;
  var pleaseUpdate = props.pleaseUpdate;
  if (props.postData.post_content == null) {
    return null;
  }
  var [pleaseUpdateX, setpleaseUpdateX] = useState(props.pleaseUpdate);
  var [postData, setpostData] = useState(props.postData);
  var [accordionData, setaccordionData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(accordionData.globalOptions);
  var [wrapper, setwrapper] = useState(accordionData.wrapper);
  var [items, setitems] = useState(accordionData.items);
  var [content, setcontent] = useState(accordionData.content);
  var [accOptions, setaccOptions] = useState(accordionData.accOptions);
  var [header, setheader] = useState(accordionData.header);
  var [headerActive, setheaderActive] = useState(accordionData.headerActive);
  var [headerLabel, setheaderLabel] = useState(accordionData.headerLabel);
  var [labelCounter, setlabelCounter] = useState(accordionData.labelCounter);
  var [labelIcon, setlabelIcon] = useState(accordionData.labelIcon);
  var [icon, seticon] = useState(accordionData.icon);
  var [iconToggle, seticonToggle] = useState(accordionData.iconToggle);
  var [searchInput, setsearchInput] = useState(accordionData.searchInput);
  var [expandCollapseAll, setexpandCollapseAll] = useState(accordionData.expandCollapseAll);
  const [toggled, setToggled] = useState(false);
  const [labelIconHtml, setlabelIconHtml] = useState("");
  const [iconHtml, seticonHtml] = useState("");
  const [iconToggleHtml, seticonToggleHtml] = useState("");
  const [iconExpandAllHtml, seticonExpandAllHtml] = useState("");
  const [iconCollapseAllHtml, seticonCollapseAllHtml] = useState("");
  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Copied to clipboard!",
        content: "Use the shortcode in page or post conent where you want to display.",
        type: "success"
      });
    }).catch(err => {});
  };
  useEffect(() => {
    setpostData(props.postData);
  }, [props.postData]);
  useEffect(() => {
    setaccordionData(postData.post_content);
    //setitems(postData.post_content.items);
  }, [postData]);
  useEffect(() => {
    setglobalOptions(accordionData.globalOptions);
    setwrapper(accordionData.wrapper);
    setitems(accordionData.items);
    setcontent(accordionData.content);
    setaccOptions(accordionData.accOptions);
    setheader(accordionData.header);
    setheaderActive(accordionData.headerActive);
    setheaderLabel(accordionData.headerLabel);
    setlabelCounter(accordionData.labelCounter);
    setlabelIcon(accordionData.labelIcon);
    seticon(accordionData.icon);
    seticonToggle(accordionData.iconToggle);
    setsearchInput(accordionData.searchInput);
    setexpandCollapseAll(accordionData.expandCollapseAll);
  }, [accordionData]);
  useEffect(() => {
    //var accordionDataX = { ...accordionData };
    //accordionDataX.items = items;
    //onChange(accordionDataX);
  }, [items]);
  useEffect(() => {
    setpleaseUpdateX(pleaseUpdate);
  }, [pleaseUpdate]);
  useEffect(() => {
    var iconSrc = iconToggle?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    seticonToggleHtml(iconHtml);
  }, [iconToggle?.options]);
  useEffect(() => {
    var iconSrc = icon?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    seticonHtml(iconHtml);
  }, [icon?.options]);
  useEffect(() => {
    var iconSrc = labelIcon?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    setlabelIconHtml(iconHtml);
  }, [labelIcon?.options]);
  useEffect(() => {
    var expandAllIconSrc = expandCollapseAll?.options?.expandAllIcon?.iconSrc;
    var collapseAllIconSrc = expandCollapseAll?.options?.collapseAllIcon?.iconSrc;
    var expandIconHtml = `<span class="${expandAllIconSrc}"></span>`;
    seticonExpandAllHtml(expandIconHtml);
    var collapseIconHtml = `<span class="${collapseAllIconSrc}"></span>`;
    seticonCollapseAllHtml(collapseIconHtml);
  }, [expandCollapseAll?.options]);
  var [active, setactive] = useState(9999);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    className: "ml-5",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "flex items-center justify-between align-middle bg-white p-5  mb-5",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "flex items-center gap-5",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
          className: "text-xl",
          children: postData?.post_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
            children: ["You are editing: ", postData.post_title]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "flex items-center align-middle gap-3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: "flex items-center align-middle gap-2",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
            className: "cursor-pointer",
            title: "Click to know more",
            onClick: () => {
              setHelp({
                id: "useShortcodes",
                enable: true
              });
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_12__["default"], {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_13__["default"]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("input", {
            type: "text",
            className: "w-72 !bg-slate-200 !rounded-none !border-2 !border-solid border-slate-400 text-sm !py-1 !px-2 font-mono",
            value: `[accordions_builder id="${id}"]`,
            onClick: () => {
              var str = `[accordions_builder id="${id}"]`;
              copyData(str);
            }
          })]
        }), pleaseUpdateX && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
          className: "bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600",
          onClick: ev => {
            onUpdate(true);
          },
          children: "Save"
        })]
      })]
    }), globalOptions?.viewType == "accordion" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_preview_accordions__WEBPACK_IMPORTED_MODULE_6__["default"], {
      isLoading: isLoading,
      postData: postData,
      id: id,
      onUpdate: onUpdate,
      pleaseUpdate: pleaseUpdate,
      onChange: onChange,
      addNotifications: addNotifications,
      setHelp: setHelp
    }), globalOptions?.viewType == "tabs" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_preview_tabs__WEBPACK_IMPORTED_MODULE_7__["default"], {
      isLoading: isLoading,
      postData: postData,
      id: id,
      onUpdate: onUpdate,
      pleaseUpdate: pleaseUpdate,
      onChange: onChange,
      addNotifications: addNotifications,
      setHelp: setHelp
    }), globalOptions?.viewType == "imageAccordion" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_preview_image_accordion__WEBPACK_IMPORTED_MODULE_8__["default"], {
      isLoading: isLoading,
      postData: postData,
      id: id,
      onUpdate: onUpdate,
      pleaseUpdate: pleaseUpdate,
      onChange: onChange,
      addNotifications: addNotifications,
      setHelp: setHelp
    }), globalOptions?.viewType == "accordionMenu" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_preview_accordion_menu__WEBPACK_IMPORTED_MODULE_9__["default"], {
      isLoading: isLoading,
      postData: postData,
      id: id,
      onUpdate: onUpdate,
      pleaseUpdate: pleaseUpdate,
      onChange: onChange,
      addNotifications: addNotifications,
      setHelp: setHelp
    }), globalOptions?.viewType == "faqGrid" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_preview_faq_grid__WEBPACK_IMPORTED_MODULE_10__["default"], {
      isLoading: isLoading,
      postData: postData,
      id: id,
      onUpdate: onUpdate,
      pleaseUpdate: pleaseUpdate,
      onChange: onChange,
      addNotifications: addNotifications,
      setHelp: setHelp
    })]
  });
}
class BuilderView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      appData,
      id,
      isLoading,
      onChange,
      pleaseUpdate,
      onUpdate,
      addNotifications,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(Html, {
      isLoading: isLoading,
      postData: postData,
      appData: appData,
      id: id,
      onUpdate: onUpdate,
      pleaseUpdate: pleaseUpdate,
      onChange: onChange,
      addNotifications: addNotifications,
      setHelp: setHelp,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BuilderView);

/***/ }),

/***/ "./src/components/BuilderView/preview-accordion-menu.js":
/*!**************************************************************!*\
  !*** ./src/components/BuilderView/preview-accordion-menu.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;








var myStore = wp.data.select("postgrid-shop");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var id = props.id;
  var onChange = props.onChange;
  var addNotifications = props.addNotifications;
  var setHelp = props.setHelp;
  var isLoading = props.isLoading;
  var onUpdate = props.onUpdate;
  var pleaseUpdate = props.pleaseUpdate;
  if (props.postData.post_content == null) {
    return null;
  }
  var [pleaseUpdateX, setpleaseUpdateX] = useState(props.pleaseUpdate);
  var [postData, setpostData] = useState(props.postData);
  var [accordionData, setaccordionData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(accordionData.globalOptions);
  var [wrapper, setwrapper] = useState(accordionData.wrapper);
  var [items, setitems] = useState(accordionData.items);
  var [content, setcontent] = useState(accordionData.content);
  var [accOptions, setaccOptions] = useState(accordionData.accOptions);
  var [header, setheader] = useState(accordionData.header);
  var [headerActive, setheaderActive] = useState(accordionData.headerActive);
  var [headerLabel, setheaderLabel] = useState(accordionData.headerLabel);
  var [labelCounter, setlabelCounter] = useState(accordionData.labelCounter);
  var [labelIcon, setlabelIcon] = useState(accordionData.labelIcon);
  var [icon, seticon] = useState(accordionData.icon);
  var [iconToggle, seticonToggle] = useState(accordionData.iconToggle);
  var [searchInput, setsearchInput] = useState(accordionData.searchInput);
  var [expandCollapseAll, setexpandCollapseAll] = useState(accordionData.expandCollapseAll);
  var [navsWrap, setnavsWrap] = useState(accordionData?.navsWrap);
  var [navItem, setnavItem] = useState(accordionData?.navItem);
  var [activeNavItem, setactiveNavItem] = useState(accordionData?.activeNavItem);
  var [navLabel, setnavLabel] = useState(accordionData?.navLabel);
  var [panelWrap, setpanelWrap] = useState(accordionData?.panelWrap);
  const [toggled, setToggled] = useState(false);
  const [labelIconHtml, setlabelIconHtml] = useState("");
  const [iconHtml, seticonHtml] = useState("");
  const [iconToggleHtml, seticonToggleHtml] = useState("");
  const [iconExpandAllHtml, seticonExpandAllHtml] = useState("");
  const [iconCollapseAllHtml, seticonCollapseAllHtml] = useState("");
  const [activeTab, setactiveTab] = useState(0);
  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Copied to clipboard!",
        content: "Use the shortcode in page or post conent where you want to display.",
        type: "success"
      });
    }).catch(err => {});
  };
  useEffect(() => {
    setpostData(props.postData);
  }, [props.postData]);
  useEffect(() => {
    setaccordionData(postData.post_content);
    //setitems(postData.post_content.items);
  }, [postData]);
  useEffect(() => {
    setglobalOptions(accordionData.globalOptions);
    setwrapper(accordionData.wrapper);
    setitems(accordionData.items);
    setcontent(accordionData.content);
    setaccOptions(accordionData.accOptions);
    setheader(accordionData.header);
    setheaderActive(accordionData.headerActive);
    setheaderLabel(accordionData.headerLabel);
    setlabelCounter(accordionData.labelCounter);
    setlabelIcon(accordionData.labelIcon);
    seticon(accordionData.icon);
    seticonToggle(accordionData.iconToggle);
    setsearchInput(accordionData.searchInput);
    setexpandCollapseAll(accordionData.expandCollapseAll);
  }, [accordionData]);
  useEffect(() => {
    //var accordionDataX = { ...accordionData };
    //accordionDataX.items = items;
    //onChange(accordionDataX);
  }, [items]);
  useEffect(() => {
    setpleaseUpdateX(pleaseUpdate);
  }, [pleaseUpdate]);
  useEffect(() => {
    var iconSrc = iconToggle?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    seticonToggleHtml(iconHtml);
  }, [iconToggle?.options]);
  useEffect(() => {
    var iconSrc = icon?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    seticonHtml(iconHtml);
  }, [icon?.options]);
  useEffect(() => {
    var iconSrc = labelIcon?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    setlabelIconHtml(iconHtml);
  }, [labelIcon?.options]);
  useEffect(() => {
    var expandAllIconSrc = expandCollapseAll?.options?.expandAllIcon?.iconSrc;
    var collapseAllIconSrc = expandCollapseAll?.options?.collapseAllIcon?.iconSrc;
    var expandIconHtml = `<span class="${expandAllIconSrc}"></span>`;
    seticonExpandAllHtml(expandIconHtml);
    var collapseIconHtml = `<span class="${collapseAllIconSrc}"></span>`;
    seticonCollapseAllHtml(collapseIconHtml);
  }, [expandCollapseAll?.options]);
  var [active, setactive] = useState(9999);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
    className: "px-10 py-10",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      id: `accordions-${id}`,
      className: `${wrapper?.options?.class} `,
      children: "PreviewAccordionMenu"
    })
  });
}
class PreviewAccordionMenu extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      id,
      isLoading,
      onChange,
      pleaseUpdate,
      onUpdate,
      addNotifications,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Html, {
      isLoading: isLoading,
      postData: postData,
      id: id,
      onUpdate: onUpdate,
      pleaseUpdate: pleaseUpdate,
      onChange: onChange,
      addNotifications: addNotifications,
      setHelp: setHelp,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewAccordionMenu);

/***/ }),

/***/ "./src/components/BuilderView/preview-accordions.js":
/*!**********************************************************!*\
  !*** ./src/components/BuilderView/preview-accordions.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;








var myStore = wp.data.select("postgrid-shop");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var id = props.id;
  var onChange = props.onChange;
  var addNotifications = props.addNotifications;
  var setHelp = props.setHelp;
  var isLoading = props.isLoading;
  var onUpdate = props.onUpdate;
  var pleaseUpdate = props.pleaseUpdate;
  if (props.postData.post_content == null) {
    return null;
  }
  var [pleaseUpdateX, setpleaseUpdateX] = useState(props.pleaseUpdate);
  var [postData, setpostData] = useState(props.postData);
  var [accordionData, setaccordionData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(accordionData.globalOptions);
  var [wrapper, setwrapper] = useState(accordionData.wrapper);
  var [items, setitems] = useState(accordionData.items);
  var [content, setcontent] = useState(accordionData.content);
  var [accOptions, setaccOptions] = useState(accordionData.accOptions);
  var [header, setheader] = useState(accordionData.header);
  var [headerActive, setheaderActive] = useState(accordionData.headerActive);
  var [headerLabel, setheaderLabel] = useState(accordionData.headerLabel);
  var [labelCounter, setlabelCounter] = useState(accordionData.labelCounter);
  var [labelIcon, setlabelIcon] = useState(accordionData.labelIcon);
  var [icon, seticon] = useState(accordionData.icon);
  var [iconToggle, seticonToggle] = useState(accordionData.iconToggle);
  var [searchInput, setsearchInput] = useState(accordionData.searchInput);
  var [expandCollapseAll, setexpandCollapseAll] = useState(accordionData.expandCollapseAll);
  const [toggled, setToggled] = useState(false);
  const [labelIconHtml, setlabelIconHtml] = useState("");
  const [iconHtml, seticonHtml] = useState("");
  const [iconToggleHtml, seticonToggleHtml] = useState("");
  const [iconExpandAllHtml, seticonExpandAllHtml] = useState("");
  const [iconCollapseAllHtml, seticonCollapseAllHtml] = useState("");
  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Copied to clipboard!",
        content: "Use the shortcode in page or post conent where you want to display.",
        type: "success"
      });
    }).catch(err => {});
  };
  useEffect(() => {
    setpostData(props.postData);
  }, [props.postData]);
  useEffect(() => {
    setaccordionData(postData.post_content);
    //setitems(postData.post_content.items);
  }, [postData]);
  useEffect(() => {
    setglobalOptions(accordionData.globalOptions);
    setwrapper(accordionData.wrapper);
    setitems(accordionData.items);
    setcontent(accordionData.content);
    setaccOptions(accordionData.accOptions);
    setheader(accordionData.header);
    setheaderActive(accordionData.headerActive);
    setheaderLabel(accordionData.headerLabel);
    setlabelCounter(accordionData.labelCounter);
    setlabelIcon(accordionData.labelIcon);
    seticon(accordionData.icon);
    seticonToggle(accordionData.iconToggle);
    setsearchInput(accordionData.searchInput);
    setexpandCollapseAll(accordionData.expandCollapseAll);
  }, [accordionData]);
  useEffect(() => {
    //var accordionDataX = { ...accordionData };
    //accordionDataX.items = items;
    //onChange(accordionDataX);
  }, [items]);
  useEffect(() => {
    setpleaseUpdateX(pleaseUpdate);
  }, [pleaseUpdate]);
  useEffect(() => {
    var iconSrc = iconToggle?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    seticonToggleHtml(iconHtml);
  }, [iconToggle?.options]);
  useEffect(() => {
    var iconSrc = icon?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    seticonHtml(iconHtml);
  }, [icon?.options]);
  useEffect(() => {
    var iconSrc = labelIcon?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    setlabelIconHtml(iconHtml);
  }, [labelIcon?.options]);
  useEffect(() => {
    var expandAllIconSrc = expandCollapseAll?.options?.expandAllIcon?.iconSrc;
    var collapseAllIconSrc = expandCollapseAll?.options?.collapseAllIcon?.iconSrc;
    var expandIconHtml = `<span class="${expandAllIconSrc}"></span>`;
    seticonExpandAllHtml(expandIconHtml);
    var collapseIconHtml = `<span class="${collapseAllIconSrc}"></span>`;
    seticonCollapseAllHtml(collapseIconHtml);
  }, [expandCollapseAll?.options]);
  var [active, setactive] = useState(9999);
  function unescapeHTML(str) {
    const map = {
      '&amp;': '&',
      '&lt;': '<',
      '&gt;': '>',
      '&quot;': '"',
      '&#039;': "'"
    };
    return str.replace(/&amp;|&lt;|&gt;|&quot;|&#039;/g, function (match) {
      return map[match];
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
    className: "px-10 py-10",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      id: `accordions-${id}`,
      className: `${wrapper?.options?.class} `,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "top-wrap",
        children: [searchInput?.options.enable && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          class: "search-wrap",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("input", {
            type: "text",
            class: "search-input",
            placeholder: searchInput?.options?.placeholder
          })
        }), expandCollapseAll?.options?.enable && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          class: "expand-collapse-all",
          "data-expandAllText": "",
          "data-collapseAllText": "",
          "data-expandAllIconHtml": "",
          "data-collapseAllIconHtml": "",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
            className: ` `,
            dangerouslySetInnerHTML: {
              __html: iconExpandAllHtml
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
            children: expandCollapseAll?.options?.expandAllText
          })]
        })]
      }), items?.map((item, index) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            className: `accordion-header accordion-header-${index} ${header?.options.class} ${active == index ? "accordion-header-active" : ""}`,
            onClick: ev => {
              setToggled(!toggled);
              setactive(index == active ? 999 : index);
            },
            children: [labelCounter?.options.position == "left" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
              className: ` accordion-label-counter`,
              children: index
            }), icon?.options.position == "left" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
              children: [active != index && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-icon`,
                dangerouslySetInnerHTML: {
                  __html: iconHtml
                }
              }), active == index && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-icon accordion-icon-toggle`,
                dangerouslySetInnerHTML: {
                  __html: iconToggleHtml
                }
              })]
            }), labelIcon?.options.position == "beforeLabel" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
              children: [item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-icon`,
                dangerouslySetInnerHTML: {
                  __html: `<span class="${item?.labelIcon?.options.iconSrc}"></span>`
                }
              }), !item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-icon`,
                dangerouslySetInnerHTML: {
                  __html: labelIconHtml
                }
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("a", {
              className: ` accordion-header-label`,
              href: "#" + item.headerLabelSlug,
              onClick: e => {
                return;
              },
              children: [labelCounter?.options.position == "beforeLabelText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-counter`,
                children: index
              }), labelIcon?.options.position == "beforeLabelText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: [item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-icon`,
                  dangerouslySetInnerHTML: {
                    __html: `<span class="${item?.labelIcon?.options.iconSrc}"></span>`
                  }
                }), !item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-icon`,
                  dangerouslySetInnerHTML: {
                    __html: labelIconHtml
                  }
                })]
              }), item?.headerLabelText.length > 0 ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ``,
                  dangerouslySetInnerHTML: {
                    __html: item?.headerLabelText
                  }
                })
              }) : "Start Writing...", labelIcon?.options.position == "afterLabelText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: [item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-icon`,
                  dangerouslySetInnerHTML: {
                    __html: `<span class="${item?.labelIcon?.options.iconSrc}"></span>`
                  }
                }), !item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-icon`,
                  dangerouslySetInnerHTML: {
                    __html: labelIconHtml
                  }
                })]
              }), labelCounter?.options.position == "afterLabelText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-counter`,
                children: index
              })]
            }), labelIcon?.options.position == "afterLabel" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
              children: [item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-icon`,
                dangerouslySetInnerHTML: {
                  __html: `<span class="${item?.labelIcon?.options.iconSrc}"></span>`
                }
              }), !item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-icon`,
                dangerouslySetInnerHTML: {
                  __html: labelIconHtml
                }
              })]
            }), labelCounter?.options.position == "right" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
              className: ` accordion-label-counter`,
              children: index
            }), icon?.options.position == "right" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
              children: [active != index && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-icon`,
                dangerouslySetInnerHTML: {
                  __html: iconHtml
                }
              }), active == index && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-icon-toggle`,
                dangerouslySetInnerHTML: {
                  __html: iconToggleHtml
                }
              })]
            })]
          }), active == index && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: `accordion-content animate__animated animate__${content?.options?.inAnimation}`,
              dangerouslySetInnerHTML: {
                __html: unescapeHTML(item?.contentText)
              }
            })
          })]
        }, index);
      })]
    })
  });
}
class PreviewAccordions extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      id,
      isLoading,
      onChange,
      pleaseUpdate,
      onUpdate,
      addNotifications,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Html, {
      isLoading: isLoading,
      postData: postData,
      id: id,
      onUpdate: onUpdate,
      pleaseUpdate: pleaseUpdate,
      onChange: onChange,
      addNotifications: addNotifications,
      setHelp: setHelp,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewAccordions);

/***/ }),

/***/ "./src/components/BuilderView/preview-faq-grid.js":
/*!********************************************************!*\
  !*** ./src/components/BuilderView/preview-faq-grid.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;








var myStore = wp.data.select("postgrid-shop");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var id = props.id;
  var onChange = props.onChange;
  var addNotifications = props.addNotifications;
  var setHelp = props.setHelp;
  var isLoading = props.isLoading;
  var onUpdate = props.onUpdate;
  var pleaseUpdate = props.pleaseUpdate;
  if (props.postData.post_content == null) {
    return null;
  }
  var [pleaseUpdateX, setpleaseUpdateX] = useState(props.pleaseUpdate);
  var [postData, setpostData] = useState(props.postData);
  var [accordionData, setaccordionData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(accordionData.globalOptions);
  var [wrapper, setwrapper] = useState(accordionData.wrapper);
  var [itemsWrap, setitemsWrap] = useState(accordionData.itemsWrap);
  var [itemWrap, setitemWrap] = useState(accordionData.itemWrap);
  var [items, setitems] = useState(accordionData.items);
  var [content, setcontent] = useState(accordionData.content);
  var [accOptions, setaccOptions] = useState(accordionData.accOptions);
  var [header, setheader] = useState(accordionData.header);
  var [headerLabel, setheaderLabel] = useState(accordionData.headerLabel);
  var [labelCounter, setlabelCounter] = useState(accordionData.labelCounter);
  var [labelIcon, setlabelIcon] = useState(accordionData.labelIcon);
  var [icon, seticon] = useState(accordionData.icon);
  var [searchInput, setsearchInput] = useState(accordionData.searchInput);
  const [toggled, setToggled] = useState(false);
  const [labelIconHtml, setlabelIconHtml] = useState("");
  const [iconHtml, seticonHtml] = useState("");
  const [iconExpandAllHtml, seticonExpandAllHtml] = useState("");
  const [iconCollapseAllHtml, seticonCollapseAllHtml] = useState("");
  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Copied to clipboard!",
        content: "Use the shortcode in page or post conent where you want to display.",
        type: "success"
      });
    }).catch(err => {});
  };
  useEffect(() => {
    setpostData(props.postData);
  }, [props.postData]);
  useEffect(() => {
    setaccordionData(postData.post_content);
    //setitems(postData.post_content.items);
  }, [postData]);
  useEffect(() => {
    setglobalOptions(accordionData.globalOptions);
    setwrapper(accordionData.wrapper);
    setitemsWrap(accordionData.itemsWrap);
    setitemWrap(accordionData.itemWrap);
    setitems(accordionData.items);
    setcontent(accordionData.content);
    setaccOptions(accordionData.accOptions);
    setheader(accordionData.header);
    setheaderLabel(accordionData.headerLabel);
    setlabelCounter(accordionData.labelCounter);
    setlabelIcon(accordionData.labelIcon);
    seticon(accordionData.icon);
    setsearchInput(accordionData.searchInput);
  }, [accordionData]);
  useEffect(() => {
    //var accordionDataX = { ...accordionData };
    //accordionDataX.items = items;
    //onChange(accordionDataX);
  }, [items]);
  useEffect(() => {
    setpleaseUpdateX(pleaseUpdate);
  }, [pleaseUpdate]);
  useEffect(() => {
    var iconSrc = icon?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    seticonHtml(iconHtml);
  }, [icon?.options]);
  useEffect(() => {
    var iconSrc = labelIcon?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    setlabelIconHtml(iconHtml);
  }, [labelIcon?.options]);
  function unescapeHTML(str) {
    const map = {
      '&amp;': '&',
      '&lt;': '<',
      '&gt;': '>',
      '&quot;': '"',
      '&#039;': "'"
    };
    return str.replace(/&amp;|&lt;|&gt;|&quot;|&#039;/g, function (match) {
      return map[match];
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
    className: "px-10 py-10",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      id: `accordions-${id}`,
      className: `${wrapper?.options?.class} `,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: "top-wrap",
        children: searchInput?.options.enable && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          class: "search-wrap",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("input", {
            type: "text",
            class: "search-input",
            placeholder: searchInput?.options?.placeholder
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: `items ${itemsWrap?.options?.class} `,
        children: items?.map((item, index) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            className: `${itemWrap?.options?.class} item`,
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: `accordion-header ${header?.options.class} `,
              onClick: ev => {
                setToggled(!toggled);
              },
              children: [labelCounter?.options.position == "left" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-counter`,
                children: index
              }), icon?.options.position == "left" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-icon`,
                  dangerouslySetInnerHTML: {
                    __html: iconHtml
                  }
                })
              }), labelIcon?.options.position == "beforeLabel" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: [item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-icon`,
                  dangerouslySetInnerHTML: {
                    __html: `<span class="${item?.labelIcon?.options.iconSrc}"></span>`
                  }
                }), !item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-icon`,
                  dangerouslySetInnerHTML: {
                    __html: labelIconHtml
                  }
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("a", {
                className: ` accordion-header-label`,
                href: "#" + item.headerLabelSlug,
                onClick: e => {
                  return;
                },
                children: [labelCounter?.options.position == "beforeLabelText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-counter`,
                  children: index
                }), labelIcon?.options.position == "beforeLabelText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                  children: [item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                    className: ` accordion-label-icon`,
                    dangerouslySetInnerHTML: {
                      __html: `<span class="${item?.labelIcon?.options.iconSrc}"></span>`
                    }
                  }), !item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                    className: ` accordion-label-icon`,
                    dangerouslySetInnerHTML: {
                      __html: labelIconHtml
                    }
                  })]
                }), item?.headerLabelText.length > 0 ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                    className: ``,
                    dangerouslySetInnerHTML: {
                      __html: item?.headerLabelText
                    }
                  })
                }) : "Start Writing...", labelIcon?.options.position == "afterLabelText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                  children: [item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                    className: ` accordion-label-icon`,
                    dangerouslySetInnerHTML: {
                      __html: `<span class="${item?.labelIcon?.options.iconSrc}"></span>`
                    }
                  }), !item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                    className: ` accordion-label-icon`,
                    dangerouslySetInnerHTML: {
                      __html: labelIconHtml
                    }
                  })]
                }), labelCounter?.options.position == "afterLabelText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-counter`,
                  children: index
                })]
              }), labelIcon?.options.position == "afterLabel" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: [item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-icon`,
                  dangerouslySetInnerHTML: {
                    __html: `<span class="${item?.labelIcon?.options.iconSrc}"></span>`
                  }
                }), !item?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-icon`,
                  dangerouslySetInnerHTML: {
                    __html: labelIconHtml
                  }
                })]
              }), labelCounter?.options.position == "right" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-counter`,
                children: index
              }), icon?.options.position == "right" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-icon`,
                  dangerouslySetInnerHTML: {
                    __html: iconHtml
                  }
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
                className: `accordion-content animate__animated animate__${content?.options?.inAnimation}`,
                dangerouslySetInnerHTML: {
                  __html: unescapeHTML(item?.contentText)
                }
              })
            })]
          }, index);
        })
      })]
    })
  });
}
class PreviewFaqGrid extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      id,
      isLoading,
      onChange,
      pleaseUpdate,
      onUpdate,
      addNotifications,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Html, {
      isLoading: isLoading,
      postData: postData,
      id: id,
      onUpdate: onUpdate,
      pleaseUpdate: pleaseUpdate,
      onChange: onChange,
      addNotifications: addNotifications,
      setHelp: setHelp,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewFaqGrid);

/***/ }),

/***/ "./src/components/BuilderView/preview-image-accordion.js":
/*!***************************************************************!*\
  !*** ./src/components/BuilderView/preview-image-accordion.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;
var myStore = wp.data.select("postgrid-shop");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var id = props.id;
  var onChange = props.onChange;
  var addNotifications = props.addNotifications;
  var setHelp = props.setHelp;
  var isLoading = props.isLoading;
  var onUpdate = props.onUpdate;
  var pleaseUpdate = props.pleaseUpdate;
  if (props.postData.post_content == null) {
    return null;
  }
  var [pleaseUpdateX, setpleaseUpdateX] = useState(props.pleaseUpdate);
  var [postData, setpostData] = useState(props.postData);
  var [accordionData, setaccordionData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(accordionData.globalOptions);
  var [wrapper, setwrapper] = useState(accordionData.wrapper); // Using the hook.
  var [items, setitems] = useState(accordionData.items); // Using the hook.
  var [item, setitem] = useState(accordionData.item);
  var [overlay, setoverlay] = useState(accordionData.overlay);
  var [content, setcontent] = useState(accordionData.content);
  var [title, settitle] = useState(accordionData.title);
  var [image, setimage] = useState(accordionData.image);

  // var [wrapper, setwrapper] = useState(accordionData.wrapper);
  // var [items, setitems] = useState(accordionData.items);
  // var [content, setcontent] = useState(accordionData.content);
  // var [accOptions, setaccOptions] = useState(accordionData.accOptions);
  // var [header, setheader] = useState(accordionData.header);
  // var [headerActive, setheaderActive] = useState(accordionData.headerActive);
  // var [headerLabel, setheaderLabel] = useState(accordionData.headerLabel);
  // var [labelCounter, setlabelCounter] = useState(accordionData.labelCounter);
  // var [labelIcon, setlabelIcon] = useState(accordionData.labelIcon);
  // var [icon, seticon] = useState(accordionData.icon);
  // var [iconToggle, seticonToggle] = useState(accordionData.iconToggle);
  // var [searchInput, setsearchInput] = useState(accordionData.searchInput);
  // var [expandCollapseAll, setexpandCollapseAll] = useState(accordionData.expandCollapseAll);

  // var [navsWrap, setnavsWrap] = useState(accordionData?.navsWrap);
  // var [navItem, setnavItem] = useState(accordionData?.navItem);
  // var [activeNavItem, setactiveNavItem] = useState(
  // 	accordionData?.activeNavItem
  // );
  // var [navLabel, setnavLabel] = useState(accordionData?.navLabel);
  // var [panelWrap, setpanelWrap] = useState(accordionData?.panelWrap);

  // const [toggled, setToggled] = useState(false);
  // const [labelIconHtml, setlabelIconHtml] = useState("");

  // const [iconHtml, seticonHtml] = useState("");
  // const [iconToggleHtml, seticonToggleHtml] = useState("");
  // const [iconExpandAllHtml, seticonExpandAllHtml] = useState("");
  // const [iconCollapseAllHtml, seticonCollapseAllHtml] = useState("");
  // const [activeTab, setactiveTab] = useState(0);

  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Copied to clipboard!",
        content: "Use the shortcode in page or post conent where you want to display.",
        type: "success"
      });
    }).catch(err => {});
  };
  useEffect(() => {
    setpostData(props.postData);
  }, [props.postData]);
  useEffect(() => {
    setaccordionData(postData.post_content);
    //setitems(postData.post_content.items);
  }, [postData]);
  useEffect(() => {
    setglobalOptions(accordionData.globalOptions);
    setwrapper(accordionData.wrapper);
    setitems(accordionData.items);
    setitem(accordionData.item);
    setoverlay(accordionData.overlay);
    setcontent(accordionData.content);
    settitle(accordionData.title);
    setimage(accordionData.image);
  }, [accordionData]);
  useEffect(() => {
    //var accordionDataX = { ...accordionData };
    //accordionDataX.items = items;
    //onChange(accordionDataX);
  }, [items]);
  useEffect(() => {
    setpleaseUpdateX(pleaseUpdate);
  }, [pleaseUpdate]);
  var [active, setactive] = useState(9999);
  function unescapeHTML(str) {
    const map = {
      '&amp;': '&',
      '&lt;': '<',
      '&gt;': '>',
      '&quot;': '"',
      '&#039;': "'"
    };
    return str.replace(/&amp;|&lt;|&gt;|&quot;|&#039;/g, function (match) {
      return map[match];
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: "px-10 py-10",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      id: `accordions-${id}`,
      className: `image-accordion-wrapper ${wrapper?.options?.class} `,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        className: "items",
        children: items?.map((i, index) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            className: `image-accordion-item  ${i.active ? "active" : ""} ${index == active ? "active" : ""} ${item?.options?.class} `,
            onMouseOver: ev => {
              setactive(index);
            },
            onMouseLeave: ev => {
              setactive(9999);
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", {
              src: i.image.url,
              className: `image-accordion-image ${image?.options?.class}`
            }), (index == active || i.active) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
              className: `image-accordion-overlay ${overlay?.options?.class} animate__animated animate__${overlay?.options?.inAnimation}`,
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
                className: `image-accordion-title ${title?.options?.class}`,
                children: i.title
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
                className: `image-accordion-content ${content?.options?.class}`,
                dangerouslySetInnerHTML: {
                  __html: unescapeHTML(unescapeHTML(i.content))
                }
              })]
            })]
          }, index);
        })
      })
    })
  });
}
class PreviewImageAccordion extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      id,
      isLoading,
      onChange,
      pleaseUpdate,
      onUpdate,
      addNotifications,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Html, {
      isLoading: isLoading,
      postData: postData,
      id: id,
      onUpdate: onUpdate,
      pleaseUpdate: pleaseUpdate,
      onChange: onChange,
      addNotifications: addNotifications,
      setHelp: setHelp,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewImageAccordion);

/***/ }),

/***/ "./src/components/BuilderView/preview-tabs.js":
/*!****************************************************!*\
  !*** ./src/components/BuilderView/preview-tabs.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;








var myStore = wp.data.select("postgrid-shop");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var id = props.id;
  var onChange = props.onChange;
  var addNotifications = props.addNotifications;
  var setHelp = props.setHelp;
  var isLoading = props.isLoading;
  var onUpdate = props.onUpdate;
  var pleaseUpdate = props.pleaseUpdate;
  if (props.postData.post_content == null) {
    return null;
  }
  var [pleaseUpdateX, setpleaseUpdateX] = useState(props.pleaseUpdate);
  var [postData, setpostData] = useState(props.postData);
  var [accordionData, setaccordionData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(accordionData.globalOptions);
  var [wrapper, setwrapper] = useState(accordionData.wrapper);
  var [items, setitems] = useState(accordionData.items);
  var [content, setcontent] = useState(accordionData.content);
  var [accOptions, setaccOptions] = useState(accordionData.accOptions);
  var [header, setheader] = useState(accordionData.header);
  var [headerActive, setheaderActive] = useState(accordionData.headerActive);
  var [headerLabel, setheaderLabel] = useState(accordionData.headerLabel);
  var [labelCounter, setlabelCounter] = useState(accordionData.labelCounter);
  var [labelIcon, setlabelIcon] = useState(accordionData.labelIcon);
  var [icon, seticon] = useState(accordionData.icon);
  var [iconToggle, seticonToggle] = useState(accordionData.iconToggle);
  var [searchInput, setsearchInput] = useState(accordionData.searchInput);
  var [expandCollapseAll, setexpandCollapseAll] = useState(accordionData.expandCollapseAll);
  var [navsWrap, setnavsWrap] = useState(accordionData?.navsWrap);
  var [navItem, setnavItem] = useState(accordionData?.navItem);
  var [activeNavItem, setactiveNavItem] = useState(accordionData?.activeNavItem);
  var [navLabel, setnavLabel] = useState(accordionData?.navLabel);
  var [panelWrap, setpanelWrap] = useState(accordionData?.panelWrap);
  const [toggled, setToggled] = useState(false);
  const [labelIconHtml, setlabelIconHtml] = useState("");
  const [iconHtml, seticonHtml] = useState("");
  const [iconToggleHtml, seticonToggleHtml] = useState("");
  const [iconExpandAllHtml, seticonExpandAllHtml] = useState("");
  const [iconCollapseAllHtml, seticonCollapseAllHtml] = useState("");
  const [activeTab, setactiveTab] = useState(0);
  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Copied to clipboard!",
        content: "Use the shortcode in page or post conent where you want to display.",
        type: "success"
      });
    }).catch(err => {});
  };
  useEffect(() => {
    setpostData(props.postData);
  }, [props.postData]);
  useEffect(() => {
    setaccordionData(postData.post_content);
    //setitems(postData.post_content.items);
  }, [postData]);
  useEffect(() => {
    setglobalOptions(accordionData.globalOptions);
    setwrapper(accordionData.wrapper);
    setitems(accordionData.items);
    setcontent(accordionData.content);
    setpanelWrap(accordionData.panelWrap);
    setaccOptions(accordionData.accOptions);
    setheader(accordionData.header);
    setheaderActive(accordionData.headerActive);
    setheaderLabel(accordionData.headerLabel);
    setlabelCounter(accordionData.labelCounter);
    setlabelIcon(accordionData.labelIcon);
    seticon(accordionData.icon);
    seticonToggle(accordionData.iconToggle);
    setsearchInput(accordionData.searchInput);
    setexpandCollapseAll(accordionData.expandCollapseAll);
  }, [accordionData]);
  useEffect(() => {
    //var accordionDataX = { ...accordionData };
    //accordionDataX.items = items;
    //onChange(accordionDataX);
  }, [items]);
  useEffect(() => {
    setpleaseUpdateX(pleaseUpdate);
  }, [pleaseUpdate]);
  useEffect(() => {
    var iconSrc = iconToggle?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    seticonToggleHtml(iconHtml);
  }, [iconToggle?.options]);
  useEffect(() => {
    var iconSrc = icon?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    seticonHtml(iconHtml);
  }, [icon?.options]);
  useEffect(() => {
    var iconSrc = labelIcon?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    setlabelIconHtml(iconHtml);
  }, [labelIcon?.options]);
  useEffect(() => {
    var expandAllIconSrc = expandCollapseAll?.options?.expandAllIcon?.iconSrc;
    var collapseAllIconSrc = expandCollapseAll?.options?.collapseAllIcon?.iconSrc;
    var expandIconHtml = `<span class="${expandAllIconSrc}"></span>`;
    seticonExpandAllHtml(expandIconHtml);
    var collapseIconHtml = `<span class="${collapseAllIconSrc}"></span>`;
    seticonCollapseAllHtml(collapseIconHtml);
  }, [expandCollapseAll?.options]);
  var [active, setactive] = useState(9999);
  function unescapeHTML(str) {
    const map = {
      '&amp;': '&',
      '&lt;': '<',
      '&gt;': '>',
      '&quot;': '"',
      '&#039;': "'"
    };
    return str.replace(/&amp;|&lt;|&gt;|&quot;|&#039;/g, function (match) {
      return map[match];
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
    className: "px-10 py-10",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      id: `accordions-${id}`,
      className: `${wrapper?.options?.class} `,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: "top-wrap"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: " navs-wrapper  ",
        role: "tablist",
        children: items.map((tab, index) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            className: ` ${index === activeTab ? "  nav-item-active nav-item " : `nav-item pg${index}-nav-item`}`,
            role: "tab",
            tabIndex: index,
            onClick: () => setactiveTab(index),
            children: [labelCounter?.options.position == "left" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
              className: ` accordion-label-counter`,
              children: index
            }), icon.options.position == "before" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
              children: index == activeTab ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` nav-icon-toggle`,
                  dangerouslySetInnerHTML: {
                    __html: iconToggleHtml
                  }
                })
              }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` nav-icon`,
                  dangerouslySetInnerHTML: {
                    __html: iconHtml
                  }
                })
              })
            }), labelIcon?.options.position == "beforeLabel" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
              children: [tab?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-icon`,
                dangerouslySetInnerHTML: {
                  __html: `<span class="${tab?.labelIcon?.options.iconSrc}"></span>`
                }
              }), !tab?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-icon`,
                dangerouslySetInnerHTML: {
                  __html: labelIconHtml
                }
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: " nav-label",
              children: [labelCounter?.options.position == "beforeLabelText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-counter`,
                children: index
              }), labelIcon?.options.position == "beforeLabelText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: [tab?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-icon`,
                  dangerouslySetInnerHTML: {
                    __html: `<span class="${tab?.labelIcon?.options.iconSrc}"></span>`
                  }
                }), !tab?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-icon`,
                  dangerouslySetInnerHTML: {
                    __html: labelIconHtml
                  }
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                dangerouslySetInnerHTML: {
                  __html: tab.headerLabelText
                }
              }), labelIcon?.options.position == "afterLabelText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: [tab?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-icon`,
                  dangerouslySetInnerHTML: {
                    __html: `<span class="${tab?.labelIcon?.options.iconSrc}"></span>`
                  }
                }), !tab?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` accordion-label-icon`,
                  dangerouslySetInnerHTML: {
                    __html: labelIconHtml
                  }
                })]
              }), labelCounter?.options.position == "afterLabelText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-counter`,
                children: index
              })]
            }), labelIcon?.options.position == "afterLabel" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
              children: [tab?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-icon`,
                dangerouslySetInnerHTML: {
                  __html: `<span class="${tab?.labelIcon?.options.iconSrc}"></span>`
                }
              }), !tab?.labelIcon?.options.iconSrc && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: ` accordion-label-icon`,
                dangerouslySetInnerHTML: {
                  __html: labelIconHtml
                }
              })]
            }), labelCounter?.options.position == "right" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
              className: ` accordion-label-counter`,
              children: index
            }), icon.options.position == "after" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
              children: index == activeTab ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` nav-icon-toggle`,
                  dangerouslySetInnerHTML: {
                    __html: iconToggleHtml
                  }
                })
              }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  className: ` nav-icon`,
                  dangerouslySetInnerHTML: {
                    __html: iconHtml
                  }
                })
              })
            })]
          }, index);
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: "panels-wrap",
        children: items.map((tab, index) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
            className: `tabs-panel animate__animated animate__${panelWrap?.options?.inAnimation}  ${activeTab === index ? "tabs-panel-active" : "hidden"}`,
            dangerouslySetInnerHTML: {
              __html: unescapeHTML(tab.contentText)
            }
          });
        })
      })]
    })
  });
}
class PreviewTabs extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      id,
      isLoading,
      onChange,
      pleaseUpdate,
      onUpdate,
      addNotifications,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Html, {
      isLoading: isLoading,
      postData: postData,
      id: id,
      onUpdate: onUpdate,
      pleaseUpdate: pleaseUpdate,
      onChange: onChange,
      addNotifications: addNotifications,
      setHelp: setHelp,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewTabs);

/***/ }),

/***/ "./src/components/BuilderWelcome/PricingTable.js":
/*!*******************************************************!*\
  !*** ./src/components/BuilderWelcome/PricingTable.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


const PricingTable = ({
  data
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "bg-white rounded-md",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "flex items-center justify-center gap-2 py-5",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
        className: "text-gray-700 line-through text-xl font-medium",
        children: data.price
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
        className: "text-gray-700 text-3xl font-bold",
        children: data.salePrice
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "bg-blue-700 py-4 text-center text-white text-xl font-bold",
      children: data.title
    }), data.features.map((item, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "py-4 text-center font-medium ",
      children: item
    })), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "flex  items-center justify-center p-4",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("a", {
        href: data.link,
        target: "_blank",
        className: "px-8 py-3 no-underline bg-blue-700 text-white cursor-pointer rounded-md",
        children: ["Buy Now ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("i", {
          className: "fas fa-cart-plus"
        })]
      })
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PricingTable);

/***/ }),

/***/ "./src/components/BuilderWelcome/index.js":
/*!************************************************!*\
  !*** ./src/components/BuilderWelcome/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/columns.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/post-comments.js");
/* harmony import */ var _components_support_ticket__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../components/support-ticket */ "./src/components/support-ticket/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _pricingData__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pricingData */ "./src/components/BuilderWelcome/pricingData.js");
/* harmony import */ var _PricingTable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./PricingTable */ "./src/components/BuilderWelcome/PricingTable.js");
/* harmony import */ var _testimonial__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./testimonial */ "./src/components/BuilderWelcome/testimonial.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;








var myStore = wp.data.select("postgrid-shop");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var [postData, setpostData] = useState(props.postData); // Using the hook.
  var addNotifications = props.addNotifications;
  var customerData = props.customerData;
  var appData = props.appData;
  const freeVsProArgs = [{
    feature: "View Type - Accordion",
    free: true,
    pro: true
  }, {
    feature: "View Type - Tabs",
    free: true,
    pro: true
  }, {
    feature: "View Type - Vertical Tabs",
    free: false,
    pro: true
  }, {
    feature: "Multi-level/Nested Accordion",
    free: false,
    pro: true
  }, {
    feature: "Preloader - Hide accordions until page load",
    free: true,
    pro: true
  }, {
    feature: "Stats",
    free: false,
    pro: true
  }, {
    feature: "Click To Scroll Top",
    free: false,
    pro: true
  }, {
    feature: "Search - Accordion",
    free: false,
    pro: true
  }, {
    feature: "Schema",
    isHeading: true
  }, {
    feature: "Enable/Disable Schema ",
    free: true,
    pro: true
  }, {
    feature: "Hide any item in Schema ",
    free: false,
    pro: true
  }, {
    feature: "Expand/Collapse All Features",
    isHeading: true
  }, {
    feature: "Expand All Custom Text",
    free: false,
    pro: true
  }, {
    feature: "Collapse All Custom Text",
    free: false,
    pro: true
  }, {
    feature: "Expand All Custom Icon",
    free: false,
    pro: true
  }, {
    feature: "Collapse All Custom Icon",
    free: false,
    pro: true
  }, {
    feature: "Accordion Content Features",
    isHeading: true
  }, {
    feature: "Enable/Disable Embeds",
    free: true,
    pro: true
  }, {
    feature: "Enable/Disable Shortcodes",
    free: true,
    pro: true
  }, {
    feature: "Enable/Disable wpautop function",
    free: true,
    pro: true
  }, {
    feature: "Content In-Out animation",
    free: false,
    pro: true,
    new: true,
    hot: true
  }, {
    feature: "Edit content with WYSIWYG editor",
    free: true,
    pro: true
  }, {
    feature: "Item Source",
    isHeading: true
  }, {
    feature: "Item Source - Manual",
    free: true,
    pro: true
  }, {
    feature: "Generate items by AI",
    free: false,
    pro: true,
    new: true,
    hot: true
  }, {
    feature: "Item Source - Posts",
    free: false,
    pro: true,
    new: true
  }, {
    feature: "Item Source - Terms",
    free: false,
    pro: true,
    new: true
  }, {
    feature: "Accordion Header & Labels Features",
    isHeading: true
  }, {
    feature: "Edit header label with Richtext editor",
    free: true,
    pro: true,
    new: true
  }, {
    feature: "Edit header label toggled text",
    free: false,
    pro: true,
    new: true
  }, {
    feature: "Header active custom style",
    free: false,
    pro: true
  }, {
    feature: "Header label custom style",
    free: false,
    pro: true,
    new: true
  }, {
    feature: "Header label counter",
    free: false,
    pro: true,
    new: true
  }, {
    feature: "Header label counter position",
    free: false,
    pro: true,
    new: true
  }, {
    feature: "Header label icons",
    free: false,
    pro: true,
    new: true
  }, {
    feature: "Header label icons position",
    free: false,
    pro: true,
    new: true
  }, {
    feature: "Accordion Icons Features",
    isHeading: true
  }, {
    feature: "Icon In-Out animation",
    free: false,
    pro: true,
    new: true,
    hot: true
  }, {
    feature: "Font-awesome Icons",
    free: true,
    pro: true
  }, {
    feature: "Iconfont Icons",
    free: false,
    pro: true,
    new: true
  }, {
    feature: "Bootstrap Icons",
    free: false,
    pro: true,
    new: true
  }, {
    feature: "Custom Idle Icon",
    free: false,
    pro: true
  }, {
    feature: "Custom Toggled Icon",
    free: false,
    pro: true
  }, {
    feature: "Icon Position Left/Right",
    free: true,
    pro: true
  }];
  const ourPlugins = [];
  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Coupon Code Copied!",
        content: "Please use coupon code on checkout page.",
        type: "success"
      });
    }).catch(err => {});
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "ml-5",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "flex justify-between items-center p-5 pb-20 bg-white ",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "flex justify-between items-center gap-3",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
            className: "text-4xl font-extrabold",
            children: appData.name
          }), " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
            className: "text-base",
            children: "By PickPlugins"
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "my-3 flex items-center gap-3",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
            className: " ",
            href: appData.demoUrl,
            target: "_blank",
            children: "Live Demo"
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "my-4 max-w-52",
          children: "Help us by providing your feedbacks and five star reviews on wordpress.org \uD83C\uDF1F\uD83C\uDF1F\uD83C\uDF1F\uD83C\uDF1F\uD83C\uDF1F"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
          className: " bg-amber-500 text-white no-underline font-medium px-[16px] py-[8px]  hover:bg-amber-700 hover:text-white rounded-md w-max transition-colors duration-300",
          href: appData.reviewsUrl,
          target: "_blank",
          children: "Submit Reviews"
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_components_tabs__WEBPACK_IMPORTED_MODULE_2__["default"], {
      activeTab: "overview",
      orientation: "",
      tabsWrapperClass: "mt-[-50px] ",
      contentClass: " w-full",
      navItemsWrapClass: "gap-3 px-10",
      navItemClass: " px-5 py-3 gap-2 rounded-t-md",
      navItemSelectedClass: "!bg-white border-2  border-b-0 border-solid  border-blue-700",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "overview",
        title: "Overview",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"],
        className: "tab-disable-blocks"
      }, {
        name: "edit",
        title: "Free Vs Pro",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"],
        className: "tab-disable-blocks"
      },
      // {
      // 	name: "templates",
      // 	title: "About Us",
      // 	icon: postAuthor,
      // 	className: "tab-disable-blocks",
      // },
      {
        name: "buyNow",
        title: "Buy Now",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__["default"],
        className: "tab-disable-blocks"
      }, {
        name: "supportTicket",
        title: "Send Feedbacks",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"],
        className: "tab-disable-blocks"
      }],
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
        name: "overview",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "flex gap-4 items-start flex-wrap mt-10 px-10",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            className: "flex-1 flex flex-col gap-3 p-[40px] max-w-[70%] bg-white rounded-md shadow-md",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h2", {
              className: "text-[32px] font-semibold text-gray-800",
              children: "Super Excited to See you!"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
              className: "text-gray-500 text-[14px]",
              children: "Thanks for installing Accordions plugin! Watch this video to get started."
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("iframe", {
              width: "100%",
              height: "400",
              src: "https://www.youtube.com/embed/zrIgw9mNA0Y",
              title: "YouTube video player",
              className: "rounded-md overflow-hidden",
              frameborder: "0",
              allow: "accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share",
              referrerpolicy: "strict-origin-when-cross-origin",
              allowfullscreen: true
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            className: "grid md:grid-cols-1 grid-cols-3 content-between md:max-w-[30%] max-w-full gap-3 text-gray-800",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "flex flex-col gap-3 bg-white p-[20px] rounded-md shadow-md",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                className: "text-[18px] font-semibold flex items-center gap-2",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  children: "\uD83C\uDF1F"
                }), "Videos"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
                children: "Watch our videos to see how the accordion works in real-world projects!"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
                target: "_blank",
                href: "https://www.youtube.com/playlist?list=PL0QP7T2SN94ZPeQ83jOnteDDrOeDLBuFD",
                className: "inline-block no-underline font-medium px-[16px] py-[8px] border border-solid border-gray-700 text-gray-700 hover:bg-gray-700 hover:text-white rounded-md w-max transition-colors duration-300",
                children: "Watch on YouTube"
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "flex flex-col gap-3 bg-white p-[20px] rounded-md shadow-md",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                className: "text-[18px] font-semibold flex items-center gap-2",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  children: "\uD83C\uDF1F"
                }), "Documentation"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
                children: "Check out our detailed documentation to learn what the Accordions plugin can do!"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
                target: "_blank",
                href: "#",
                className: "inline-block no-underline font-medium px-[16px] py-[8px] border border-solid border-gray-700 text-gray-700 hover:bg-gray-700 hover:text-white rounded-md w-max transition-colors duration-300",
                children: "Check Documentation"
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "flex flex-col gap-3 bg-white p-[20px] rounded-md shadow-md",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                className: "text-[18px] font-semibold flex items-center gap-2",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  children: "\uD83C\uDF1F"
                }), "Need Help?"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
                children: "Contact our friendly support team for quick and personalized help!"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
                target: "_blank",
                href: "https://pickplugins.com/create-support-ticket/",
                className: "inline-block no-underline font-medium px-[16px] py-[8px] border border-solid border-gray-700 text-gray-700 hover:bg-gray-700 hover:text-white rounded-md w-max transition-colors duration-300",
                children: "Create Support Ticket"
              })]
            })]
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
        name: "edit",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: " rounded-md   mt-10 px-10",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("table", {
            className: "table-auto w-full text-left",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("thead", {
              className: "bg-gray-700 text-white",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("tr", {
                className: "",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("th", {
                  className: "min-w-[550px] py-4 px-8",
                  children: "FEATURES"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("th", {
                  className: "min-w-[100px] py-4 px-8 text-center",
                  children: "Free"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("th", {
                  className: "min-w-[100px] py-4 px-8 text-center",
                  children: "\uD83D\uDC51PRO"
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("tbody", {
              className: "bg-gray-100 text-gray-800",
              children: freeVsProArgs.map((item, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: [item.isHeading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("tr", {
                  className: "bg-gray-400 last:rounded-b-md last:overflow-hidden",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("td", {
                    className: "py-3 px-8",
                    colSpan: "3",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                      className: "flex gap-2 items-center ",
                      children: [item.feature && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                        className: "text-base",
                        children: item.feature
                      }), item.new && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                        className: "text-emerald-100 inline-block text-[12px] leading-none px-2 py-1 bg-emerald-500 rounded-full",
                        children: "NEW"
                      }), item.hot && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                        className: "text-red-100 inline-block text-[12px] leading-none px-2 py-1 bg-orange-400 rounded-full",
                        children: "HOT"
                      })]
                    })
                  })
                }, index), !item?.isHeading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("tr", {
                  className: "even:bg-gray-200 last:rounded-b-md last:overflow-hidden",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("td", {
                    className: "py-3 px-8",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                      className: "flex gap-2 items-center",
                      children: [item.feature && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                        children: item.feature
                      }), item.new && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                        className: "text-emerald-100 inline-block text-[12px] leading-none px-2 py-1 bg-emerald-500 rounded-full",
                        children: "NEW"
                      }), item.hot && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                        className: "text-red-100 inline-block text-[12px] leading-none px-2 py-1 bg-orange-400 rounded-full",
                        children: "HOT"
                      })]
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("td", {
                    className: "py-3 px-8  text-center",
                    children: [item.free && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                      children: "\u2714\uFE0F"
                    }), !item.free && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                      children: "\u274C"
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("td", {
                    className: "py-3 px-8 text-center",
                    children: [item.pro && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                      children: "\u2714\uFE0F"
                    }), !item.pro && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                      children: "\u274C"
                    })]
                  })]
                }, index)]
              }))
            })]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
        name: "templates",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "grid grid-cols-2 gap-4 w-full p-7 bg-white mt-10",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
            className: "self-center",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("figure", {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("img", {
                src: "https://images.pexels.com/photos/1595385/pexels-photo-1595385.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1",
                alt: "",
                className: "w-full rounded-lg shadow-sm object-contain"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("figcaption", {
                className: "text-sm text-center mt-2",
                children: "ShapedPlugin Team"
              })]
            })
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h3", {
            className: "text-2xl font-medium my-8",
            children: "Improve your website with our top-notch plugins!"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
            className: "grid grid-cols-3 gap-4",
            children: ourPlugins.map(plugin => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "bg-gray-200 hover:bg-gray-300 shadow-sm p-8 rounded-lg relative",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h4", {
                className: "font-medium text-lg mb-4",
                children: plugin.name
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
                className: "text-[14px]",
                children: plugin.description
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
                target: "_blank",
                href: plugin.link,
                className: "absolute inset-0 "
              })]
            }))
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
        name: "supportTicket",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: " mx-10 p-5 my-10 bg-white rounded-sm",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_support_ticket__WEBPACK_IMPORTED_MODULE_0__["default"], {})
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
        name: "buyNow",
        children: [customerData.isPro && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "mx-10 p-5 my-10  rounded-sm text-center bg-orange-200",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h3", {
            className: "text-2xl ",
            children: "You already purchased, Want to Buy Again!"
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "flex items-center justify-between mx-10 p-5 my-10 bg-white rounded-sm",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h3", {
              className: "text-2xl ",
              children: "Unlock Pro Features"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
              className: "text-base",
              children: "Get 25% off today by using our exclusive coupon code!"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: "p-2 px-4 border-2 border-blue-600 border-dashed cursor-pointer text-xl",
              onClick: () => {
                var str = `BUILDER25`;
                copyData(str);
              },
              children: "BUILDER25"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: "text-center p-3",
              children: "Click To Copy"
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_components_tabs__WEBPACK_IMPORTED_MODULE_2__["default"], {
          activeTab: "yearly",
          orientation: "",
          tabsWrapperClass: "mt-[50px] ",
          contentClass: " w-full",
          navItemsWrapClass: "gap-3 px-10 justify-center",
          navItemClass: " px-5 py-3 gap-2 rounded-md",
          navItemSelectedClass: "!bg-white border-2  border-solid  border-blue-700",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "yearly",
            title: "Yearly",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"],
            className: "tab-yearly"
          }, {
            name: "lifetime",
            title: "Lifetime",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"],
            className: "tab-lifetime"
          }
          // {
          // 	name: "freeTrail",
          // 	title: "Free Trail",
          // 	icon: columns,
          // 	className: "tab-yearly",
          // },
          ],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
            name: "yearly",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: "grid grid-cols-3 gap-6 mt-10 px-10",
              children: _pricingData__WEBPACK_IMPORTED_MODULE_3__.pricingData.yearly.map((item, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_PricingTable__WEBPACK_IMPORTED_MODULE_4__["default"], {
                data: item
              }, i))
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
            name: "lifetime",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: "grid grid-cols-3 gap-6 mt-10 px-10",
              children: _pricingData__WEBPACK_IMPORTED_MODULE_3__.pricingData.lifetime.map((item, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_PricingTable__WEBPACK_IMPORTED_MODULE_4__["default"], {
                data: item
              }, i))
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
            name: "freeTrail",
            children: "freeTrail"
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "flex items-center justify-between mx-10 p-5 my-10 bg-white rounded-sm",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h3", {
              className: "text-2xl ",
              children: "Enjoy a 14-Day Money-Back Guarantee\u2014No Questions Asked!"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
              className: "text-base",
              children: "We are committed to ensuring 100% satisfaction with our plugin and support. If, for any reason, our plugin doesn't meet your expectations, simply let us know. We'll provide a full refund within 14 days of your purchase\u2014no questions asked. Learn more in our refund policy."
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: "p-2 px-4 ",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("svg", {
                width: "212",
                height: "28",
                viewBox: "0 0 212 28",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M42.5847 13.8542H48.8882C48.4685 12.2528 47.3185 11.6035 45.9179 11.6035C44.3778 11.6035 43.1437 12.4429 42.5847 13.8542M52.5864 16.5927H42.3611C42.7808 18.6553 44.517 19.4153 46.0296 19.4153C47.9346 19.4153 48.749 18.2756 48.749 18.2756H52.2783C51.213 20.9877 48.6646 22.4787 45.9179 22.4787C42.1353 22.4787 38.8297 19.6848 38.8297 15.4551C38.8297 11.25 42.1078 8.646 45.8059 8.646C49.3924 8.646 53.0358 11.0598 52.5864 16.5927",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M87.3226 15.5633C87.3226 13.4474 86.0337 11.7932 83.905 11.7932C81.7745 11.7932 80.346 13.4474 80.346 15.5633C80.346 17.6792 81.7745 19.3333 83.905 19.3333C86.0337 19.3333 87.3226 17.6792 87.3226 15.5633M76.6754 15.5896C76.6754 11.25 80.1499 8.646 83.905 8.646C87.6876 8.646 90.9932 11.2764 90.9932 15.5345C90.9932 19.848 87.5735 22.4784 83.7912 22.4784C79.9811 22.4784 76.6754 19.848 76.6754 15.5896",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M105.991 14.9937V22.3439H102.263V15.8064C102.263 15.3449 102.601 11.9279 99.9113 11.7935C98.5927 11.7117 96.2403 12.416 96.2403 15.9699V22.3439H92.5425V8.78076H95.9372L95.9482 10.6636C95.9482 10.6636 97.4788 8.646 100.333 8.646C103.947 8.646 105.991 11.25 105.991 14.9937",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M119.618 11.5216C118.441 11.5216 117.936 12.0914 117.936 12.6613C117.936 13.5824 119.198 13.854 120.038 14.0175C122.533 14.5319 125.054 15.2653 125.054 18.1385C125.054 20.9326 122.673 22.4787 119.787 22.4787C116.565 22.4787 114.072 20.5814 113.903 17.7058H117.348C117.432 18.5185 117.993 19.5764 119.702 19.5764C121.13 19.5764 121.468 18.8455 121.468 18.2756C121.468 17.2707 120.487 16.9724 119.533 16.7559C117.882 16.4026 114.323 15.7534 114.323 12.6613C114.323 10.0022 116.958 8.646 119.675 8.646C122.812 8.646 124.885 10.4903 125.054 12.7694H121.607C121.495 12.3079 121.048 11.5216 119.618 11.5216",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M136.381 15.5633C136.381 13.3106 135.12 11.9831 133.299 11.9831C131.59 11.9831 129.879 13.1758 129.879 15.5633C129.879 17.9487 131.59 19.1435 133.299 19.1435C135.12 19.1435 136.381 17.814 136.381 15.5633V15.5633ZM139.883 8.78076V27.7681H136.381V21.0141C135.485 21.9903 134.223 22.4784 132.765 22.4784C129.209 22.4784 126.238 19.6582 126.238 15.5632C126.238 11.4662 129.209 8.646 132.765 8.646C135.561 8.646 136.608 10.4625 136.608 10.4625L136.603 8.78076H139.883Z",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M159.905 13.8542H166.208C165.788 12.2528 164.638 11.6035 163.238 11.6035C161.698 11.6035 160.464 12.4429 159.905 13.8542M169.906 16.5927H159.679C160.101 18.6553 161.837 19.4153 163.349 19.4153C165.254 19.4153 166.069 18.2756 166.069 18.2756H169.598C168.533 20.9877 165.984 22.4787 163.238 22.4787C159.455 22.4787 156.15 19.6848 156.15 15.4551C156.15 11.25 159.428 8.646 163.126 8.646C166.712 8.646 170.356 11.0598 169.906 16.5927",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M174.791 13.8542H181.094C180.674 12.2528 179.524 11.6035 178.124 11.6035C176.584 11.6035 175.35 12.4429 174.791 13.8542M184.792 16.5927H174.567C174.987 18.6553 176.723 19.4153 178.235 19.4153C180.141 19.4153 180.955 18.2756 180.955 18.2756H184.484C183.419 20.9877 180.87 22.4787 178.124 22.4787C174.341 22.4787 171.036 19.6848 171.036 15.4551C171.036 11.25 174.314 8.646 178.012 8.646C181.598 8.646 185.242 11.0598 184.792 16.5927",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M197.267 19.3069V22.3436H185.36V20.5527L192.113 11.8198H185.641V8.78076H196.988V10.5717L190.235 19.3069H197.267Z",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M211.845 8.78076V20.7161V20.9877C211.845 24.6497 209.91 27.9053 205.119 27.9053C200.636 27.9053 198.2 25.056 198.2 22.9138H201.702C201.702 22.9138 202.233 24.7314 205.007 24.7314C207.362 24.7314 208.343 23.4282 208.343 21.5309V20.9611C207.724 21.6393 206.55 22.4787 204.448 22.4787C200.778 22.4787 198.48 19.9034 198.48 16.1331L198.451 8.78076H202.094V15.3183C202.094 17.1623 202.767 19.3336 205.092 19.3336C206.296 19.3336 208.286 18.7637 208.286 15.1548V8.78076H211.845Z",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M36.1626 18.2723C36.1626 19.1181 36.4958 19.467 37.1141 19.467C37.5497 19.467 37.8327 19.4164 38.2454 19.2926L38.4761 22.0799C37.7048 22.3272 36.959 22.4774 36.0075 22.4774C33.8244 22.4774 32.4874 21.7817 32.4874 18.7693V3.35645H36.1626V18.2723Z",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M75.0944 14.9937V22.3439H71.3665V15.8064C71.3665 13.9357 71.563 11.5749 68.9848 11.7935C68.3142 11.8465 66.4639 12.1444 66.4639 15.9699V22.3439H62.7658V15.8064C62.7658 13.9357 62.9619 11.5749 60.3841 11.7935C59.711 11.8465 57.8632 12.1444 57.8632 15.9699V22.3439H54.165V8.78075H57.56L57.5631 10.6636C57.5631 10.6636 58.8605 8.64599 61.2805 8.64599C64.1966 8.64599 65.3412 10.8424 65.3412 10.8424C65.3412 10.8424 66.5967 8.61963 69.7992 8.61963C73.4405 8.61963 75.0944 11.2236 75.0944 14.9937",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M141.455 16.131V8.78076H145.183V15.3183C145.183 15.7797 144.845 19.1967 147.535 19.3312C148.853 19.413 151.205 18.7086 151.205 15.1548V8.78076H154.904V22.3439H151.513L151.498 20.4611C151.498 20.4611 149.967 22.4787 147.113 22.4787C143.499 22.4787 141.455 19.8747 141.455 16.131",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M6.92836 17.1856L14.4397 20.6583C15.3706 21.0889 16.0278 21.8116 16.3827 22.6406C17.2803 24.7399 16.0535 26.8869 14.1276 27.6591C12.2015 28.4309 10.1486 27.9342 9.21523 25.7511L5.94631 18.0866C5.693 17.4925 6.32934 16.9087 6.92836 17.1856",
                  fill: "#FFC233"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M7.37953 14.9376L15.1332 12.0066C17.71 11.0325 20.525 12.8756 20.487 15.5536C20.4864 15.5886 20.4858 15.6235 20.4849 15.6588C20.4292 18.2666 17.6926 20.0194 15.1723 19.0968L7.38688 16.2473C6.76583 16.0201 6.76124 15.1713 7.37953 14.9376",
                  fill: "#FFC233"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M6.9449 13.9224L14.567 10.6837C17.0998 9.60736 17.7426 6.37695 15.7589 4.51043C15.7329 4.48585 15.7069 4.46156 15.6806 4.43728C13.7357 2.63207 10.5207 3.26767 9.41349 5.64539L5.99314 12.9915C5.72024 13.5773 6.33701 14.1806 6.9449 13.9224",
                  fill: "#FFC233"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M4.98349 12.6426L7.75465 5.04415C8.09822 4.102 8.03458 3.1412 7.67939 2.3122C6.77994 0.21378 4.34409 -0.463579 2.41853 0.309741C0.493284 1.08336 -0.594621 2.84029 0.340622 5.02253L3.63095 12.6787C3.8861 13.272 4.76261 13.2486 4.98349 12.6426",
                  fill: "#FFC233"
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "text-center p-3",
              children: ["Secure Payment by", " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: "font-bold",
                children: "Lemon Squeezy"
              })]
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "grid grid-cols-3 gap-5 mx-10",
          children: _testimonial__WEBPACK_IMPORTED_MODULE_5__.testimonial.map((item, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            className: " flex flex-col text-center",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
              className: "bg-white shadow-lg rounded-lg p-6 text-left text-gray-600",
              children: item.comment
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "flex items-center gap-6",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("img", {
                src: item.profileImage,
                alt: `${name}'s profile`,
                className: "w-12 h-12 rounded-full border border-gray-300"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                children: [" ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
                  href: item.profileLink,
                  target: "_blank",
                  rel: "noopener noreferrer",
                  className: "flex flex-col",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
                    className: "font-bold text-gray-700 text-xl my-2 mb-1",
                    children: item.name
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
                  className: "flex items-center",
                  children: [...Array(item.stars)].map((_, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                    className: "text-yellow-500",
                    children: "\u2605"
                  }, i))
                })]
              })]
            })]
          }, i))
        })]
      })]
    })]
  });
}
class BuilderWelcome extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      appData,
      addNotifications,
      customerData
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Html, {
      postData: postData,
      appData: appData,
      addNotifications: addNotifications,
      customerData: customerData,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BuilderWelcome);

/***/ }),

/***/ "./src/components/BuilderWelcome/pricingData.js":
/*!******************************************************!*\
  !*** ./src/components/BuilderWelcome/pricingData.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   pricingData: () => (/* binding */ pricingData)
/* harmony export */ });
const pricingData = {
  yearly: [{
    title: "Personal",
    features: ["Up to 3 Sites", "1 Year of Updates", "1 Year Free Support", "Access to All PRO Features"],
    price: "$40",
    salePrice: "$25",
    link: "https://pickplugins.lemonsqueezy.com/checkout/buy/e8d33f98-b84e-480a-a422-bc175af6ada9?enabled=270427&checkout%5Bcustom%5D%5Bproduct_id%5D=3935"
  }, {
    title: "Plus",
    features: ["Up to 10 Sites", "1 Year of Updates", "1 Year Free Support", "Access to All PRO Features"],
    price: "$99",
    salePrice: "$75",
    link: "https://pickplugins.lemonsqueezy.com/checkout/buy/98b2b146-9ed0-4d97-b0ad-ee54b762f799?enabled=270430&checkout%5Bcustom%5D%5Bproduct_id%5D=3934"
  }, {
    title: "Agency",
    features: ["Up to 500 Sites", "1 Year of Updates", "1 Year Free Support", "Access to All PRO Features"],
    price: "$199",
    salePrice: "$150",
    link: "https://pickplugins.lemonsqueezy.com/checkout/buy/365ae069-9604-4a4c-b83c-12a315df8b38?enabled=270434&checkout%5Bcustom%5D%5Bproduct_id%5D=3933"
  }],
  lifetime: [{
    title: "Personal",
    features: ["Up to 3 Sites", "Lifetime Free Updates", "Lifetime Support", "Access to All PRO Features"],
    price: "$99",
    salePrice: "$80",
    link: "https://pickplugins.lemonsqueezy.com/checkout/buy/6d25c9ad-d2af-4732-b8cd-2716a961e6d0?enabled=270429&checkout%5Bcustom%5D%5Bproduct_id%5D=37934"
  }, {
    title: "Plus",
    features: ["Up to 10 Sites", "Lifetime Free Updates", "Lifetime Support", "Access to All PRO Features"],
    price: "$199",
    salePrice: "$160",
    link: "https://pickplugins.lemonsqueezy.com/checkout/buy/47471695-88ef-40ad-80b8-da6853929627?enabled=270431&checkout%5Bcustom%5D%5Bproduct_id%5D=37933"
  }, {
    title: "Agency",
    features: ["Up to 500 Sites", "Lifetime Free Updates", "Lifetime Support", "Access to All PRO Features"],
    price: "$299",
    salePrice: "$240",
    link: "https://pickplugins.lemonsqueezy.com/checkout/buy/76616a32-9e29-481a-8344-ece4686b3718?enabled=270435&checkout%5Bcustom%5D%5Bproduct_id%5D=37935"
  }]
};

/***/ }),

/***/ "./src/components/BuilderWelcome/testimonial.js":
/*!******************************************************!*\
  !*** ./src/components/BuilderWelcome/testimonial.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   testimonial: () => (/* binding */ testimonial)
/* harmony export */ });
const testimonial = [{
  comment: "I’ve used this on a client’s site for almost 5 years and I have nothing but praise about it. It just does the job and never had any issues. Highly recommended.",
  name: "Pradeep",
  profileLink: "https://wordpress.org/support/users/pmaheepala/",
  profileImage: "https://secure.gravatar.com/avatar/567dcfbf43e4122bfa2cb055db04376cc1623b030ccbe56811ba2e56c9c946ad?s=100&d=retro&r=g",
  testimonialLink: "https://wordpress.org/support/topic/great-plugin-36818/",
  stars: 5
}, {
  comment: "Awesome keep it up. The service you provide in the free version are really a saviour, it helped me very much. Thank you very much. God bless you guys!",
  name: "foodbazinga",
  profileLink: "https://wordpress.org/support/users/foodbazinga/",
  profileImage: "https://secure.gravatar.com/avatar/a125df575465a997d9450c03debe3beb5898231d3ca0864b58ce38f5a8577ced?s=100&d=retro&r=g",
  testimonialLink: "https://wordpress.org/support/topic/best-app-solved-a-huge-problem-great-customization-in-free-as-well/",
  stars: 5
}, {
  comment: "Thank you for this beautiful ACCORDION & TABS plugin. I need something with just enough extensible options but not crazily over-styled. This was perfect. Thank you a hundred times over!",
  name: "treeflips",
  profileLink: "https://wordpress.org/support/users/treeflips/",
  profileImage: "https://secure.gravatar.com/avatar/698bbdf8465d26fb7054b19aa2e8663c52a1fa4e8b9363a13700c101a210066d?s=100&d=retro&r=g",
  testimonialLink: "https://wordpress.org/support/topic/best-developer-friendly-accordion-plugin/",
  stars: 5
}];

/***/ }),

/***/ "./src/components/Builder/BuilderTabList.js":
/*!**************************************************!*\
  !*** ./src/components/Builder/BuilderTabList.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/add-card.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/check.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/copy-small.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/trash.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/pencil.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;




var myStore = wp.data.select('postgrid-shop');


function Html(props) {
  if (!props.warn) {
    return null;
  }
  var isLoaded = props.isLoaded;
  var selectAccordion = props.selectAccordion;
  var activeAccordion = props.activeAccordion;
  var addNotifications = props.addNotifications;
  var setHelp = props.setHelp;
  var listQueryPrams = props.listQueryPrams;
  var setlistQueryPrams = props.setlistQueryPrams;
  var [searchPrams, setsearchPrams] = useState(listQueryPrams); // Using the hook.
  var [posts, setPosts] = useState(null); // Using the hook.
  var [pagination, setPagination] = useState({
    currentPage: listQueryPrams.page
  }); // Using the hook.
  var [dataLoaded, setdataLoaded] = useState(false); // Using the hook.
  var [isLoading, setisLoading] = useState(false); // Using the hook.
  var [deleteConfirm, setdeleteConfirm] = useState({
    id: "",
    confirm: false
  }); // Using the hook.
  var [rename, setrename] = useState({
    id: "",
    confirm: false
  }); // Using the hook.

  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Copied to clipboard!",
        content: "Use the shortcode in page or post conent where you want to display.",
        type: "success"
      });
    }).catch(err => {});
  };
  var queryArgs = [{
    "id": "postType",
    "val": ["accordions"]
  }, {
    "id": "postStatus",
    "val": ["publish"]
  }, {
    "id": "s",
    "val": ""
  }, {
    "id": "order",
    "val": "DESC"
  }, {
    "id": "orderby",
    "val": ["date"]
  }, {
    "id": "postsPerPage",
    "val": "20"
  }, {
    "id": "paged",
    "val": "1"
  }];
  function Prev() {}
  useEffect(() => {
    setisLoading(true);
    queryArgs.map(item => {
      var id = item.id;
      if (id == "paged") {
        item.val = pagination.currentPage;
      }
      if (id == "s") {
        item.val = searchPrams.search;
      }
    });
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      path: "/accordions/v2/accordions_list",
      method: "POST",
      data: {
        queryArgs: queryArgs,
        _wpnonce: accordions_builder_js._wpnonce
      }
    }).then(res => {
      setisLoading(false);
      if (res.posts == undefined) {
        setPosts([]);
        addNotifications({
          title: "No Items Found",
          content: "It seems there is no items in the list.",
          type: "success"
        });
      } else {
        setPosts(res.posts);
        addNotifications({
          title: "Accordions Loaded",
          content: "All Accordions loaded, Now click to pick one to edit.",
          type: "success"
        });
      }
    });
  }, [isLoaded, pagination.currentPage, searchPrams.search]);
  function create_post() {
    setisLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      path: "/accordions/v2/create_post",
      method: "POST",
      data: {
        postTitle: searchPrams.search
      }
    }).then(res => {
      if (res.error) {
        addNotifications({
          title: "There is an Error!",
          content: res.errorMessage,
          type: "error"
        });
      }
      if (res.success) {
        var postsX = [...posts];
        postsX.unshift({
          ID: res.id,
          post_content: "",
          post_author: 0,
          post_title: searchPrams.search
        });
        setPosts(postsX);
        addNotifications({
          title: "Accordion Create!",
          content: res.successMessage,
          type: "success"
        });
      }
      setisLoading(false);
      if (res.status) {}
    });
  }
  function update_post_title(newValue, postId) {
    setisLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      path: "/accordions/v2/update_post_title",
      method: "POST",
      data: {
        postTitle: newValue,
        postId: postId
      }
    }).then(res => {
      console.log(res);
      if (res.error) {
        addNotifications({
          title: "There is an Error!",
          content: res.errorMessage,
          type: "error"
        });
      }
      if (res.success) {
        //var postsX = [...posts];

        //postsX.unshift({ ID: res.id, post_content: "", post_author: 0, post_title: searchPrams.search });

        //setPosts(postsX)

        addNotifications({
          title: "Accordion Title Updated!",
          content: res.successMessage,
          type: "success"
        });
      }
      setisLoading(false);
      if (res.status) {}
    });
  }
  function duplicate_post(postId) {
    setisLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      path: "/accordions/v2/duplicate_post",
      method: "POST",
      data: {
        postId: postId
      }
    }).then(res => {
      if (res.error) {
        addNotifications({
          title: "There is an Error!",
          content: res.errorMessage,
          type: "error"
        });
      }
      if (res.success) {
        var postsX = [...posts];
        postsX.unshift({
          ID: res.id,
          post_title: res.post_title
        });
        setPosts(postsX);
        addNotifications({
          title: "Accordion duplicated!",
          content: res.successMessage,
          type: "success"
        });
      }
      setisLoading(false);
      if (res.status) {}
    });
  }
  function delete_post(postId, index) {
    if (!deleteConfirm) {
      return;
    }
    setisLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      path: "/accordions/v2/delete_post",
      method: "POST",
      data: {
        postId: postId
      }
    }).then(res => {
      if (res.error) {
        addNotifications({
          title: "There is an Error!",
          content: res.errorMessage,
          type: "error"
        });
      }
      if (res.success) {
        var postsX = [...posts];
        postsX.splice(index, 1);
        setPosts(postsX);
        //posts.unshift({ ID: res.id, post_title: res.post_title });

        addNotifications({
          title: "Accordion deleted!",
          content: res.successMessage,
          type: "success"
        });
        setdeleteConfirm({
          id: "",
          confirm: false
        });
      }
      setisLoading(false);
      if (res.status) {}
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "my-4 flex items-center gap-3",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_3__["default"], {
        value: searchPrams.search,
        placeholder: "Search.../Add New...",
        className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[200px]",
        onChange: newVal => {
          var searchPramsX = {
            ...searchPrams
          };
          searchPramsX.search = newVal;
          setsearchPrams(searchPramsX);
          const timer = setTimeout(() => {
            // Update the debounced value after delay
          }, 3000); // 300ms debounce delay
          return () => clearTimeout(timer); // Cleanup timer on value change or unmount
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "flex items-center  gap-2 py-2 px-3 cursor-pointer  capitalize bg-gray-700 text-white font-medium rounded hover:bg-gray-600 focus:outline-none focus:bg-gray-600",
        onClick: ev => {
          create_post();
        },
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"], {
          fill: "#fff",
          icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
          children: "Create"
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
        className: "cursor-pointer",
        title: "Click to know more",
        onClick: () => {
          setHelp({
            id: "createAccordion",
            enable: true
          });
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"], {
          icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"]
        })
      })]
    }), posts == null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "p-3 my-5 bg-orange-400 ",
      children: "No Items, Please Create First One!"
    }), posts != null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
      children: posts.map((item, index) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
          className: "border-0 border-b border-solid border-[#ddd]",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
            className: "flex justify-between align-middle items-center p-3  hover:bg-slate-300 cursor-pointer",
            onClick: ev => {
              selectAccordion(item.ID);
              addNotifications({
                title: "Ready to Edit",
                content: "Now go to Edit panel to customize accordion.",
                type: "success"
              });
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
              className: "flex  align-middle items-center gap-2  ",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                className: "text-base mb-2",
                children: item.post_title
              })
            }), activeAccordion == item.ID && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"], {
                icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"]
              })
            })]
          }, index), activeAccordion == item.ID && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
              className: " px-3 flex flex-wrap align-middle items-center text-xs gap-3 my-2",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                className: "",
                children: ["#", item.ID]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                className: "cursor-pointer flex items-center",
                onClick: ev => {
                  duplicate_post(item.ID);
                },
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"], {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__["default"],
                  size: "20"
                }), "Duplicate"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                className: "cursor-pointer text-red-700 flex items-center",
                title: "Delete Post",
                onClick: ev => {
                  setdeleteConfirm({
                    id: item.ID,
                    confirm: true
                  });
                  if (deleteConfirm.confirm) {
                    delete_post(item.ID, index);
                  }
                },
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"], {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"],
                  size: "20"
                }), deleteConfirm.id == item.ID && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
                  children: deleteConfirm && "Confirm"
                }), deleteConfirm.id != item.ID && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
                  children: deleteConfirm && "Delete"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                className: "cursor-pointer flex items-center",
                title: "Copy Shortcodes",
                onClick: () => {
                  var str = `[accordions_builder id="${item.ID}"]`;
                  copyData(str);
                },
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"], {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__["default"],
                  size: "20"
                }), " Shortcode"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
                className: "cursor-pointer flex items-center",
                title: "Rename",
                onClick: () => {
                  if (rename.id.length == 0) {
                    setrename({
                      id: item.ID,
                      confirm: false
                    });
                  } else {
                    setrename({
                      id: "",
                      confirm: false
                    });
                  }
                },
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"], {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_11__["default"],
                  size: "20"
                }), " Rename"]
              })]
            }), rename.id == item.ID && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
              className: "my-4 flex items-center justify-between gap-3",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_3__["default"], {
                placeholder: item.post_title,
                value: item.post_title,
                className: " px-2 !rounded-none border !border-[#8c8f94] !border-solid w-full",
                onChange: newVal => {
                  var postsX = [...posts];
                  postsX[index].post_title = newVal;
                  setPosts(postsX);
                  const timer = setTimeout(() => {
                    // Update the debounced value after delay
                    update_post_title(newVal, item.ID);
                  }, 3000); // 300ms debounce delay
                  return () => clearTimeout(timer); // Cleanup timer on value change or unmount
                }
              })
            })]
          })]
        });
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "flex py-5 justify-between px-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        className: "bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600",
        onClick: ev => {
          if (pagination.currentPage > 1) {
            var currentPage = pagination.currentPage - 1;
            setPagination({
              currentPage: currentPage
            });
            setlistQueryPrams({
              ...listQueryPrams,
              page: currentPage
            });
          }
        },
        children: "Prev"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        className: "bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600",
        onClick: ev => {
          var currentPage = pagination.currentPage + 1;
          setPagination({
            currentPage: currentPage
          });
          setlistQueryPrams({
            ...listQueryPrams,
            page: currentPage
          });
        },
        children: "Next"
      })]
    })]
  });
}
class BuilderTabList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true,
      isLoaded: false
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  componentDidMount() {
    setTimeout(() => {
      this.setState(state => ({
        isLoaded: !state.isLoaded
      }));
    }, 1000);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      selectAccordion,
      activeAccordion,
      setHelp,
      listQueryPrams,
      setlistQueryPrams,
      addNotifications
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(Html, {
      selectAccordion: selectAccordion,
      activeAccordion: activeAccordion,
      warn: this.state.showWarning,
      isLoaded: this.state.isLoaded,
      setHelp: setHelp,
      addNotifications: addNotifications,
      listQueryPrams: listQueryPrams,
      setlistQueryPrams: setlistQueryPrams
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BuilderTabList);

/***/ }),

/***/ "./src/components/Builder/BuilderTabTemplates.js":
/*!*******************************************************!*\
  !*** ./src/components/Builder/BuilderTabTemplates.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _splidejs_react_splide__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @splidejs/react-splide */ "./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;










var myStore = wp.data.select("postgrid-shop");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var addNotifications = props.addNotifications;
  if (!props?.postData?.post_content?.globalOptions?.viewType) {
    addNotifications({
      title: "Opps item missing",
      content: "Please select post first.",
      type: "error"
    });
    return null;
  }
  var onChange = props.onChange;
  var setHelp = props.setHelp;
  var [postData, setpostData] = useState(props.postData); // Using the hook.
  var [accordionData, setaccordionData] = useState(postData.post_content); // Using the hook.
  var [isLoading, setisLoading] = useState(false); // Using the hook.
  var [isProFeature, setisProFeature] = useState(true);
  var [customerData, setcustomerData] = useState(props.customerData);
  var [templates, settemplates] = useState([]); // Using the hook.
  const [queryLayouts, setqueryLayouts] = useState({
    keyword: "",
    price: "",
    viewType: postData.post_content.globalOptions.viewType == undefined ? "accordion" : postData.post_content.globalOptions.viewType,
    page: 1
  });
  useEffect(() => {
    if (customerData.isPro) {
      setisProFeature(false);
    }
  }, [props.customerData]);
  useEffect(() => {
    setisLoading(true);
    var requestData = {
      keyword: queryLayouts.keyword,
      page: queryLayouts.page,
      price: queryLayouts.price,
      viewType: queryLayouts.viewType
    };
    requestData = JSON.stringify(requestData);
    fetch("https://demo.pickplugins.com/accordions/wp-json/accordions/v2/get_posts_accordions",
    // "http://localhost/wordpress/wp-json/accordions/v2/get_posts_accordions",
    {
      method: "POST",
      headers: {
        "Content-Type": "application/json;charset=utf-8"
      },
      body: requestData
    }).then(response => {
      if (response.ok && response.status < 400) {
        response.json().then(data => {
          var posts = data.posts;
          var postsX = [];
          posts.map(item => {
            postsX.push({
              label: item.post_title,
              thumb: item.thumb,
              isPro: item?.is_pro == "yes" ? true : false,
              data: item.post_content
            });
            settemplates(postsX);
          });
          setisLoading(false);
        });
      }
    }).catch(_error => {
      //this.saveAsStatus = 'error';
      // handle the error
    });
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
    className: "",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
      className: "p-3",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("p", {
        className: "flex items-center gap-2",
        children: ["How templates work.", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
          className: "cursor-pointer",
          title: "Click to know more",
          onClick: () => {
            setHelp({
              id: "accordionTemplatesHelp",
              enable: true
            });
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_9__["default"], {
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"]
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
        className: "my-4  items-center hidden gap-3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_6__["default"], {
          value: queryLayouts.keyword,
          placeholder: "Search...",
          className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[200px]",
          onChange: newVal => {
            var queryLayoutsX = {
              ...queryLayouts
            };
            queryLayoutsX.keyword = newVal;
            setqueryLayouts(queryLayoutsX);
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.SelectControl, {
          label: "",
          value: queryLayouts.price,
          options: [{
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Free/Pro", "accordions"),
            value: ""
          }, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Free", "accordions"),
            value: "free"
          }, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Pro", "accordions"),
            value: "pro"
          }],
          onChange: newVal => {
            var queryLayoutsX = {
              ...queryLayouts
            };
            queryLayoutsX.keyword = newVal;
            setqueryLayouts(queryLayoutsX);
          }
        })]
      }), isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
        className: "text-center py-3",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Spinner, {})
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
        children: templates.map((preset, index) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
            className: "my-5 bg-slate-400 hover:bg-slate-500 p-3 rounded-sm cursor-pointer",
            title: "Click To Apply",
            onClick: ev => {
              if (preset.isPro) {
                if (isProFeature) {
                  addNotifications({
                    title: "Opps its pro!",
                    content: "This feature only avilable in premium version",
                    type: "error"
                  });
                  return;
                }
              }

              // addNotifications({
              // 	title: "Preset Applied",
              // 	content: "WOW, Your accordion just got new look!",
              // 	type: "success",
              // });

              var data = preset.data;
              data = JSON.parse(data);
              var presetClean = {};
              Object.entries(data).map(item => {
                var itemIndex = item[0];
                var itemArg = item[1];
                if (itemArg.options != undefined) {
                  delete itemArg.options;
                }
                if (accordionData[itemIndex]) {
                  delete accordionData[itemIndex]?.styles;
                  delete accordionData[itemIndex]?.hover;
                  delete accordionData[itemIndex]?.after;
                  delete accordionData[itemIndex]?.before;
                  delete accordionData[itemIndex]?.active;
                  delete accordionData[itemIndex]?.focus;
                  delete accordionData[itemIndex]?.target;
                  delete accordionData[itemIndex]?.visited;
                }
                presetClean[itemIndex] = {
                  ...accordionData[itemIndex],
                  ...itemArg
                };
              });
              var accordionDataX = {
                ...accordionData,
                ...presetClean
              };
              onChange(accordionDataX);

              // addNotifications({
              // 	title: "Preset Applied",
              // 	content: "WOW, Your accordion just got new look!",
              // 	type: "success",
              // });
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("img", {
              className: "w-full",
              src: preset.thumb,
              alt: ""
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
              className: "mt-3 flex justify-between  items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
                className: "text-lg  text-white ",
                children: preset.label
              }), preset.isPro && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
                children: isProFeature && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
                  className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white ",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Pro", "accordions")
                })
              })]
            })]
          }, index);
        })
      })]
    })
  });
}
class BuilderTabTemplates extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      onChange,
      customerData,
      addNotifications,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(Html, {
      postData: postData,
      onChange: onChange,
      customerData: customerData,
      addNotifications: addNotifications,
      setHelp: setHelp,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BuilderTabTemplates);

/***/ }),

/***/ "./src/components/Builder/accordion-menu-default-data.js":
/*!***************************************************************!*\
  !*** ./src/components/Builder/accordion-menu-default-data.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var AccordionMenuDefaultData = {
  globalOptions: {
    viewType: "accordionMenu",
    itemSource: "manual",
    search: true
  },
  itemQueryArgs: [],
  styleObj: {},
  reponsiveCss: "",
  wrapper: {
    options: {
      content: "",
      tag: "div",
      class: "accordion-menu-wrapper"
    },
    styles: {}
  },
  item: {
    options: {
      content: "",
      tag: "div",
      class: "image-accordion-item"
    },
    styles: {}
  },
  items: [{
    "isActive": false,
    "image": {
      id: "",
      url: "",
      altText: ""
    },
    link: "",
    "title": "What is Lorem Ipsum?",
    "content": "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."
  }]
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AccordionMenuDefaultData);

/***/ }),

/***/ "./src/components/Builder/default-data-accordion.js":
/*!**********************************************************!*\
  !*** ./src/components/Builder/default-data-accordion.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var accordionDefaultData = {
  globalOptions: {
    viewType: "accordion",
    itemSource: "manual",
    search: true
  },
  itemQueryArgs: [],
  styleObj: {},
  reponsiveCss: "",
  wrapper: {
    options: {
      tag: "div",
      class: "tabs-wrapper"
    },
    styles: {}
  },
  items: [{
    active: 0,
    hideOnSchema: 0,
    headerLabelText: "Accordion Header 1 ",
    headerLabelSlug: "",
    headerLabelToggledText: "",
    contentText: "Accordion Content 1"
  }, {
    active: 0,
    hideOnSchema: 0,
    headerLabelText: "Accordion Header 2",
    headerLabelSlug: "",
    headerLabelToggledText: "",
    contentText: "Accordion Content 2"
  }, {
    active: 0,
    hideOnSchema: 0,
    headerLabelText: "Accordion Header 3",
    headerLabelSlug: "",
    headerLabelToggledText: "",
    contentText: "Accordion Content 3"
  }],
  content: {
    options: {
      tag: "div",
      class: "accordion-content"
    },
    styles: {
      padding: {
        Desktop: "15px 15px 15px 15px"
      },
      backgroundColor: {
        Desktop: "#d5d4d9"
      }
    }
  },
  nthItemStyle: [],
  header: {
    options: {
      tag: "div",
      class: "accordion-header"
    },
    styles: {
      display: {
        Desktop: "flex"
      },
      gap: {
        Desktop: "1em"
      },
      padding: {
        Desktop: "12px 12px 12px 12px"
      },
      backgroundColor: {
        Desktop: "#9DD6DF"
      },
      margin: {
        Desktop: "0px 0px 1px 0px"
      },
      fontSize: {
        Desktop: "16px"
      }
    }
  },
  headerActive: {
    options: {
      tag: "div",
      class: "accordion-header-active"
    },
    styles: {}
  },
  headerLabel: {
    options: {
      text: "Accordion Header",
      tag: "a",
      class: "accordion-header-label"
    },
    styles: {}
  },
  labelCounter: {
    options: {
      enable: false,
      position: "",
      tag: "div",
      class: "accordion-label-counter"
    },
    styles: {}
  },
  labelIcon: {
    options: {
      library: "fontAwesome",
      srcType: "class",
      iconSrc: "",
      position: "",
      class: "accordion-label-icon"
    },
    styles: {}
  },
  icon: {
    options: {
      library: "fontAwesome",
      srcType: "class",
      iconSrc: "fas fa-angle-down",
      position: "left",
      class: "accordion-icon"
    },
    styles: {}
  },
  iconToggle: {
    options: {
      library: "fontAwesome",
      srcType: "class",
      iconSrc: " fas fa-angle-up",
      class: "accordion-icon-toggle"
    },
    styles: {}
  },
  searchInput: {
    options: {
      placeholder: "",
      class: "search-input"
    },
    styles: {}
  },
  expandCollapseAll: {
    options: {
      enable: false,
      class: "expand-collapse-all",
      expandAllText: "Expand All",
      collapseAllText: "Collapse All",
      expandAllIcon: {
        library: "fontAwesome",
        srcType: "class",
        iconSrc: " fas fa-angle-up"
      },
      collapseAllIcon: {
        library: "fontAwesome",
        srcType: "class",
        iconSrc: " fas fa-angle-up"
      }
    },
    styles: {}
  },
  topWrap: {
    options: {
      class: "top-wrap"
    },
    styles: {}
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (accordionDefaultData);

/***/ }),

/***/ "./src/components/Builder/default-data-faq-grid.js":
/*!*********************************************************!*\
  !*** ./src/components/Builder/default-data-faq-grid.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var faqGridDefaultData = {
  globalOptions: {
    viewType: "faqGrid",
    itemSource: "manual",
    search: true
  },
  itemQueryArgs: [],
  styleObj: {},
  reponsiveCss: "",
  wrapper: {
    options: {
      tag: "div",
      class: "faq-grid-wrapper"
    },
    styles: {}
  },
  itemsWrap: {
    options: {
      tag: "div",
      class: "faq-grid-items items"
    },
    styles: {
      display: {
        Desktop: "grid"
      },
      gap: {
        Desktop: "2em"
      },
      gridTemplateColumns: {
        Desktop: "1fr 1fr"
      }
    }
  },
  itemWrap: {
    options: {
      tag: "div",
      class: "faq-grid-item item"
    },
    styles: {}
  },
  items: [{
    active: 0,
    hideOnSchema: 0,
    headerLabelText: "Accordion Header 1 ",
    headerLabelSlug: "",
    headerLabelToggledText: "",
    contentText: "Accordion Content 1"
  }, {
    active: 0,
    hideOnSchema: 0,
    headerLabelText: "Accordion Header 2",
    headerLabelSlug: "",
    headerLabelToggledText: "",
    contentText: "Accordion Content 2"
  }, {
    active: 0,
    hideOnSchema: 0,
    headerLabelText: "Accordion Header 3",
    headerLabelSlug: "",
    headerLabelToggledText: "",
    contentText: "Accordion Content 3"
  }],
  content: {
    options: {
      tag: "div",
      class: "faq-content accordion-content"
    },
    styles: {
      padding: {
        Desktop: "15px 15px 15px 15px"
      },
      backgroundColor: {
        Desktop: "#d5d4d9"
      }
    }
  },
  header: {
    options: {
      tag: "div",
      class: "faq-header accordion-header"
    },
    styles: {
      display: {
        Desktop: "flex"
      },
      gap: {
        Desktop: "1em"
      },
      padding: {
        Desktop: "12px 12px 12px 12px"
      },
      backgroundColor: {
        Desktop: "#9DD6DF"
      },
      margin: {
        Desktop: "0px 0px 1px 0px"
      },
      fontSize: {
        Desktop: "16px"
      }
    }
  },
  headerLabel: {
    options: {
      text: "Accordion Header",
      tag: "a",
      class: "accordion-header-label"
    },
    styles: {}
  },
  labelCounter: {
    options: {
      enable: false,
      position: "",
      tag: "div",
      class: "faq-label-counter accordion-label-counter"
    },
    styles: {}
  },
  labelIcon: {
    options: {
      library: "fontAwesome",
      srcType: "class",
      iconSrc: "",
      position: "",
      class: "accordion-label-icon"
    },
    styles: {}
  },
  icon: {
    options: {
      library: "fontAwesome",
      srcType: "class",
      iconSrc: "far fa-question-circle",
      position: "left",
      class: "accordion-icon"
    },
    styles: {}
  },
  searchInput: {
    options: {
      placeholder: "",
      class: "search-input"
    },
    styles: {}
  },
  topWrap: {
    options: {
      class: "top-wrap"
    },
    styles: {}
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (faqGridDefaultData);

/***/ }),

/***/ "./src/components/Builder/generate-css.js":
/*!************************************************!*\
  !*** ./src/components/Builder/generate-css.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _splidejs_react_splide__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @splidejs/react-splide */ "./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;








var myStore = wp.data.select("postgrid-shop");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var onChange = props.onChange;
  var [postData, setpostData] = useState(props.postData); // Using the hook.
  var [accordionData, setaccordionData] = useState(postData.post_content); // Using the hook.

  var [styleObj, setstyleObj] = useState({}); // Using the hook.

  var [globalOptions, setglobalOptions] = useState(accordionData.globalOptions); // Using the hook.

  useEffect(() => {
    setpostData(props.postData);
  }, [props.postData]);
  useEffect(() => {
    setaccordionData(postData.post_content);
  }, [postData]);
  var blockClass = "#accordions-" + postData.ID;
  var wrapperSelector = blockClass + "";
  if (globalOptions.viewType == "imageAccordion") {
    var contentSelector = blockClass + " .image-accordion-content";
  } else {
    var contentSelector = blockClass + " .accordion-content";
  }
  var itemActiveSelector = blockClass + " .image-accordion-item.active";
  var itemsWrapSelector = blockClass + " .items";
  var itemWrapSelector = blockClass + " .item";
  var headerSelector = blockClass + " .accordion-header";
  var headerActiveSelector = blockClass + " .accordion-header-active";
  var headerLabelSelector = blockClass + " .accordion-header-label";
  var labelCounterSelector = blockClass + " .accordion-label-counter";
  var labelIconSelector = blockClass + " .accordion-label-icon";
  var iconSelector = blockClass + " .accordion-icon";
  var iconToggleSelector = blockClass + " .accordion-icon-toggle";
  var expandCollapseAllSelector = blockClass + " .expand-collapse-all";
  var topWrapSelector = blockClass + " .top-wrap";
  var searchInputSelector = blockClass + " .search-input";
  var navsWrapSelector = blockClass + " .navs-wrapper";
  var navItemSelector = blockClass + " .nav-item";
  var activeNavItemSelector = blockClass + " .nav-item-active";
  var navLabelSelector = blockClass + " .nav-label";
  var panelWrapSelector = blockClass + " .tabs-panel";
  var panelWrapActiveSelector = blockClass + " .tabs-panel-active";
  var itemSelector = blockClass + " .image-accordion-item";
  var overlaySelector = blockClass + " .image-accordion-overlay";
  var imageSelector = blockClass + " .image-accordion-image";
  var titleSelector = blockClass + " .image-accordion-title";
  function getElementSelector(sudoScource, mainSelector) {
    var elementSelector = mainSelector;
    if (sudoScource == "styles") {
      elementSelector = mainSelector;
    } else if (sudoScource == "hover") {
      elementSelector = mainSelector + ":hover";
    } else if (sudoScource == "after") {
      elementSelector = mainSelector + "::after";
    } else if (sudoScource == "before") {
      elementSelector = mainSelector + "::before";
    } else if (sudoScource == "first-child") {
      elementSelector = mainSelector + ":first-child";
    } else if (sudoScource == "last-child") {
      elementSelector = mainSelector + ":last-child";
    } else if (sudoScource == "visited") {
      elementSelector = mainSelector + ":visited";
    } else if (sudoScource == "selection") {
      elementSelector = mainSelector + "::selection";
    } else if (sudoScource == "first-letter") {
      elementSelector = mainSelector + "::first-letter";
    } else if (sudoScource == "first-line") {
      elementSelector = mainSelector + "::first-line";
    } else {
      elementSelector = mainSelector + ":" + sudoScource;
    }
    return elementSelector;
  }
  function cssAttrParse(key) {
    var cssProp = "";
    if (key == "alignContent") {
      cssProp = "align-content";
    } else if (key == "alignItems") {
      cssProp = "align-items";
    } else if (key == "animationName") {
      cssProp = "animation-name";
    } else if (key == "alignSelf") {
      cssProp = "align-self";
    } else if (key == "aspectRatio") {
      cssProp = "aspect-ratio";
    } else if (key == "backfaceVisibility") {
      cssProp = "backface-visibility";
    } else if (key == "backgroundAttachment") {
      cssProp = "background-attachment";
    } else if (key == "backgroundBlendMode") {
      cssProp = "background-blend-mode";
    } else if (key == "backgroundClip") {
      cssProp = "background-clip";
    } else if (key == "bgColor") {
      cssProp = "background-color";
    } else if (key == "backgroundColor") {
      cssProp = "background-color";
    } else if (key == "backgroundOrigin") {
      cssProp = "background-origin";
    } else if (key == "backgroundRepeat") {
      cssProp = "background-repeat";
    } else if (key == "backgroundSize") {
      cssProp = "background-size";
    } else if (key == "backgroundPosition") {
      cssProp = "background-position";
    } else if (key == "backgroundImage") {
      cssProp = "background-image";
    } else if (key == "border") {
      cssProp = "border";
    } else if (key == "borderTop") {
      cssProp = "border-top";
    } else if (key == "borderRight") {
      cssProp = "border-right";
    } else if (key == "borderBottom") {
      cssProp = "border-bottom";
    } else if (key == "borderLeft") {
      cssProp = "border-left";
    } else if (key == "borderRadius") {
      cssProp = "border-radius";
    } else if (key == "borderCollapse") {
      cssProp = "border-collapse";
    } else if (key == "borderSpacing") {
      cssProp = "border-spacing";
    } else if (key == "borderImage") {
      cssProp = "border-image";
    } else if (key == "boxShadow") {
      cssProp = "box-shadow";
    } else if (key == "backdropFilter") {
      cssProp = "backdrop-filter";
    } else if (key == "bottom" || key == "top" || key == "left" || key == "right" || key == "clear" || key == "color" || key == "filter" || key == "float") {
      cssProp = key;
    } else if (key == "boxSizing") {
      cssProp = "box-sizing";
    } else if (key == "cursor") {
      cssProp = "cursor";
    } else if (key == "content") {
      cssProp = "content";
    } else if (key == "counterIncrement") {
      cssProp = "counter-increment";
    } else if (key == "counterReset") {
      cssProp = "counter-reset";
    } else if (key == "counterSet") {
      cssProp = "counter-set";
    } else if (key == "columnCount") {
      cssProp = "column-count";
    } else if (key == "columnRule") {
      cssProp = "column-rule";
    } else if (key == "direction") {
      cssProp = "direction";
    } else if (key == "fontFamily") {
      cssProp = "font-family";
    } else if (key == "fontSize") {
      cssProp = "font-size";
    } else if (key == "fontStyle") {
      cssProp = "font-style";
    } else if (key == "fontStretch") {
      cssProp = "font-stretch";
    } else if (key == "fontWeight") {
      cssProp = "font-weight";
    } else if (key == "fontVariantCaps") {
      cssProp = "font-variant-caps";
    } else if (key == "flexWrap") {
      cssProp = "flex-wrap";
    } else if (key == "flexDirection") {
      cssProp = "flex-direction";
    } else if (key == "flexGrow") {
      cssProp = "flex-grow";
    } else if (key == "flexShrink") {
      cssProp = "flex-shrink";
    } else if (key == "flexBasis") {
      cssProp = "flex-basis";
    } else if (key == "flexFlow") {
      cssProp = "flex-flow";
    } else if (key == "letterSpacing") {
      cssProp = "letter-spacing";
    } else if (key == "gridAutoFlow") {
      cssProp = "grid-auto-flow";
    } else if (key == "gridColumnEnd") {
      cssProp = "grid-column-end";
    } else if (key == "gridColumnStart") {
      cssProp = "grid-column-start";
    } else if (key == "gridRowEnd") {
      cssProp = "grid-row-end";
    } else if (key == "gridRowStart") {
      cssProp = "grid-row-start";
    } else if (key == "gridTemplateColumns") {
      cssProp = "grid-template-columns";
    } else if (key == "gridTemplateRows") {
      cssProp = "grid-template-rows";
    } else if (key == "listStyle") {
      cssProp = "list-style";
    } else if (key == "lineHeight") {
      cssProp = "line-height";
    } else if (key == "justifyContent") {
      cssProp = "justify-content";
    } else if (key == "maskImage") {
      cssProp = "mask-image";
    } else if (key == "objectFit") {
      cssProp = "object-fit";
    } else if (key == "opacity") {
      cssProp = "opacity";
    } else if (key == "outline") {
      cssProp = "outline";
    } else if (key == "order") {
      cssProp = "order";
    } else if (key == "outlineOffset") {
      cssProp = "outline-offset";
    } else if (key == "position") {
      cssProp = "position";
    } else if (key == "textIndent") {
      cssProp = "text-indent";
    } else if (key == "textJustify") {
      cssProp = "text-justify";
    } else if (key == "textTransform") {
      cssProp = "text-transform";
    } else if (key == "textDecoration") {
      cssProp = "text-decoration";
    } else if (key == "textOverflow") {
      cssProp = "text-overflow";
    } else if (key == "textShadow") {
      cssProp = "text-shadow";
    } else if (key == "textAlign") {
      cssProp = "text-align";
    } else if (key == "visibility") {
      cssProp = "visibility";
    } else if (key == "wordBreak") {
      cssProp = "word-break";
    } else if (key == "wordSpacing") {
      cssProp = "word-spacing";
    } else if (key == "zIndex") {
      cssProp = "z-index";
    } else if (key == "padding") {
      cssProp = "padding";
    } else if (key == "paddingTop") {
      cssProp = "padding-top";
    } else if (key == "paddingRight") {
      cssProp = "padding-right";
    } else if (key == "paddingBottom") {
      cssProp = "padding-bottom";
    } else if (key == "paddingLeft") {
      cssProp = "padding-left";
    } else if (key == "placeItems") {
      cssProp = "place-items";
    } else if (key == "margin") {
      cssProp = "margin";
    } else if (key == "marginTop") {
      cssProp = "margin-top";
    } else if (key == "marginRight") {
      cssProp = "margin-right";
    } else if (key == "marginBottom") {
      cssProp = "margin-bottom";
    } else if (key == "marginLeft") {
      cssProp = "margin-left";
    } else if (key == "display") {
      cssProp = "display";
    } else if (key == "width") {
      cssProp = "width";
    } else if (key == "height") {
      cssProp = "height";
    } else if (key == "verticalAlign") {
      cssProp = "vertical-align";
    } else if (key == "overflow") {
      cssProp = "overflow";
    } else if (key == "overflowX") {
      cssProp = "overflow-x";
    } else if (key == "overflowY") {
      cssProp = "overflow-y";
    } else if (key == "writingMode") {
      cssProp = "writing-mode";
    } else if (key == "wordWrap") {
      cssProp = "word-wrap";
    } else if (key == "perspective") {
      cssProp = "perspective";
    } else if (key == "minWidth") {
      cssProp = "min-width";
    } else if (key == "minHeight") {
      cssProp = "min-height";
    } else if (key == "maxHeight") {
      cssProp = "max-height";
    } else if (key == "maxWidth") {
      cssProp = "max-width";
    } else if (key == "transition") {
      cssProp = "transition";
    } else if (key == "transform") {
      cssProp = "transform";
    } else if (key == "transformOrigin") {
      cssProp = "transform-origin";
    } else if (key == "transformStyle") {
      cssProp = "transform-style";
    } else if (key == "tableLayout") {
      cssProp = "table-layout";
    } else if (key == "emptyCells") {
      cssProp = "empty-cells";
    } else if (key == "captionSide") {
      cssProp = "caption-side";
    } else if (key == "gap") {
      cssProp = "gap";
    } else if (key == "rowGap") {
      cssProp = "row-gap";
    } else if (key == "columnGap") {
      cssProp = "column-gap";
    } else if (key == "userSelect") {
      cssProp = "user-select";
    } else if (key == "-webkit-text-fill-color") {
      cssProp = "-webkit-text-fill-color";
    } else {
      cssProp = key;
    }
    return cssProp;
  }
  function generateElementCss(obj, elementSelector) {
    if (obj == null) {
      return {};
    }
    var cssObj = {};
    Object.entries(obj).map(args => {
      var sudoSrc = args[0];
      var sudoArgs = args[1];
      if (sudoSrc != "options" && sudoArgs != null) {
        var selector = getElementSelector(sudoSrc, elementSelector);
        Object.entries(args[1]).map(x => {
          var attr = x[0];
          var propVal = x[1];
          var cssPropty = cssAttrParse(attr);
          var found = Object.entries(propVal).reduce((a, [k, v]) => v ? (a[k] = v, a) : a, {});
          if (Object.keys(found).length > 0) {
            if (cssObj[selector] == undefined) {
              cssObj[selector] = {};
            }
            if (cssObj[selector][cssPropty] == undefined) {
              cssObj[selector][cssPropty] = {};
            }
            cssObj[selector][cssPropty] = x[1];
          }
        });
      }
    });
    return cssObj;
  }
  function generateBlockCss(items) {
    var reponsiveCssGroups = {};
    for (var selector in items) {
      var attrs = items[selector];
      for (var attr in attrs) {
        var breakpoints = attrs[attr];
        for (var device in breakpoints) {
          var attrValue = breakpoints[device];
          if (reponsiveCssGroups[device] == undefined) {
            reponsiveCssGroups[device] = [];
          }
          if (reponsiveCssGroups[device] == undefined) {
            reponsiveCssGroups[device] = [];
          }
          if (reponsiveCssGroups[device][selector] == undefined) {
            reponsiveCssGroups[device][selector] = [];
          }
          if (typeof attrValue == "string") {
            attrValue = attrValue.replaceAll("u0022", '"');
            reponsiveCssGroups[device][selector].push({
              attr: attr,
              val: attrValue
            });
          }
        }
      }
    }
    var reponsiveCssDesktop = "";
    if (reponsiveCssGroups["Desktop"] != undefined) {
      for (var selector in reponsiveCssGroups["Desktop"]) {
        var attrs = reponsiveCssGroups["Desktop"][selector];
        reponsiveCssDesktop += selector + "{";
        for (var index in attrs) {
          var attr = attrs[index];
          var attrName = attr.attr;
          var attrValue = attr.val;
          reponsiveCssDesktop += attrName + ":" + attrValue + ";";
        }
        reponsiveCssDesktop += "}";
      }
    }
    var reponsiveCssTablet = "";
    if (reponsiveCssGroups["Tablet"] != undefined) {
      reponsiveCssTablet += "@media(max-width: 991px){";
      for (var selector in reponsiveCssGroups["Tablet"]) {
        var attrs = reponsiveCssGroups["Tablet"][selector];
        reponsiveCssTablet += selector + "{";
        for (var index in attrs) {
          var attr = attrs[index];
          var attrName = attr.attr;
          var attrValue = attr.val;
          reponsiveCssTablet += attrName + ":" + attrValue + ";";
        }
        reponsiveCssTablet += "}";
      }
      reponsiveCssTablet += "}";
    }
    var reponsiveCssMobile = "";
    if (reponsiveCssGroups["Mobile"] != undefined) {
      reponsiveCssMobile += "@media(max-width:767px){";
      for (var selector in reponsiveCssGroups["Mobile"]) {
        var attrs = reponsiveCssGroups["Mobile"][selector];
        reponsiveCssMobile += selector + "{";
        for (var index in attrs) {
          var attr = attrs[index];
          var attrName = attr.attr;
          var attrValue = attr.val;
          reponsiveCssMobile += attrName + ":" + attrValue + ";";
        }
        reponsiveCssMobile += "}";
      }
      reponsiveCssMobile += "}";
    }
    var reponsiveCss = reponsiveCssDesktop + reponsiveCssTablet + reponsiveCssMobile;
    return reponsiveCss;
  }
  useEffect(() => {
    var reponsiveCss = generateBlockCss(styleObj);
    onChange(reponsiveCss);
    var wpfooter = document.getElementById("wpfooter");
    var csswrappg = document.getElementById("css-block");

    // var divWrap = document.getElementById("css-block");

    // if (divWrap != undefined) {
    // 	divWrap.outerHTML = "";
    // }

    if (csswrappg == null) {
      var divWrap = '<style id="css-block">' + reponsiveCss + '</style>';
      wpfooter.insertAdjacentHTML("beforeend", divWrap);
      var csswrappg = document.getElementById("css-block");
      csswrappg.innerHtml = reponsiveCss;
    } else {
      //csswrappg.insertAdjacentHTML("beforeend", reponsiveCss);

      csswrappg.innerHTML = reponsiveCss;
    }
  }, [styleObj]);
  useEffect(() => {
    var styleObjX = {};
    var wrapperCss = generateElementCss(accordionData.wrapper, wrapperSelector);
    Object.entries(wrapperCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var contentCss = generateElementCss(accordionData.content, contentSelector);
    Object.entries(contentCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var headerCss = generateElementCss(accordionData.header, headerSelector);
    Object.entries(headerCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var itemsWrapCss = generateElementCss(accordionData.itemsWrap, itemsWrapSelector);
    Object.entries(itemsWrapCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var itemWrapCss = generateElementCss(accordionData.itemWrap, itemWrapSelector);
    Object.entries(itemWrapCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var headerActiveCss = generateElementCss(accordionData.headerActive, headerActiveSelector);
    Object.entries(headerActiveCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var headerLabelCss = generateElementCss(accordionData.headerLabel, headerLabelSelector);
    Object.entries(headerLabelCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var labelCounterCss = generateElementCss(accordionData.labelCounter, labelCounterSelector);
    Object.entries(labelCounterCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var labelIconCss = generateElementCss(accordionData.labelIcon, labelIconSelector);
    Object.entries(labelIconCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var iconCss = generateElementCss(accordionData.icon, iconSelector);
    Object.entries(iconCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var iconToggleCss = generateElementCss(accordionData.iconToggle, iconToggleSelector);
    Object.entries(iconToggleCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var topWrapCss = generateElementCss(accordionData.topWrap, topWrapSelector);
    Object.entries(topWrapCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var expandCollapseAllCss = generateElementCss(accordionData.expandCollapseAll, expandCollapseAllSelector);
    Object.entries(expandCollapseAllCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var searchInputCss = generateElementCss(accordionData.searchInput, searchInputSelector);
    Object.entries(searchInputCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var navsWrapCss = generateElementCss(accordionData.navsWrap, navsWrapSelector);
    Object.entries(navsWrapCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var navItemCss = generateElementCss(accordionData.navItem, navItemSelector);
    Object.entries(navItemCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var activeNavItemCss = generateElementCss(accordionData.activeNavItem, activeNavItemSelector);
    Object.entries(activeNavItemCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var navLabelCss = generateElementCss(accordionData.navLabel, navLabelSelector);
    Object.entries(navLabelCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var panelWrapCss = generateElementCss(accordionData.panelWrap, panelWrapSelector);
    Object.entries(panelWrapCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var panelWrapActiveCss = generateElementCss(accordionData.panelWrapActive, panelWrapActiveSelector);
    Object.entries(panelWrapActiveCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var itemCss = generateElementCss(accordionData.item, itemSelector);
    Object.entries(itemCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var itemActiveCss = generateElementCss(accordionData.itemActive, itemActiveSelector);
    Object.entries(itemActiveCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var overlayCss = generateElementCss(accordionData.overlay, overlaySelector);
    Object.entries(overlayCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var imageCss = generateElementCss(accordionData.image, imageSelector);
    Object.entries(imageCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });
    var titleCss = generateElementCss(accordionData.title, titleSelector);
    Object.entries(titleCss).map(selectors => {
      var selector = selectors[0];
      var selectorData = selectors[1];
      styleObjX[selector] = selectorData;
    });

    //nthItemStyle
    accordionData?.nthItemStyle?.map((loopElement, index) => {
      var elementId = loopElement.id;
      var headerLoopHdnle = wrapperSelector + ' ' + ".accordion-header-" + index;

      // console.log(headerLoopHdnle)
      var loopElementCss = generateElementCss(loopElement, headerLoopHdnle);
      Object.entries(loopElementCss).map(element => {
        var sudoSelector = element[0];
        var selectorData = element[1];

        //var headerLoopSudoHdnle = getElementSelector(sudoSelector, headerLoopHdnle);

        styleObjX[sudoSelector] = selectorData;
      });
    });
    console.log(styleObjX);
    setstyleObj(styleObjX);
  }, [accordionData]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
    className: "ml-5"
  });
}
class AccordionsGenerateCss extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Html, {
      postData: postData,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AccordionsGenerateCss);

/***/ }),

/***/ "./src/components/Builder/help.js":
/*!****************************************!*\
  !*** ./src/components/Builder/help.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
const {
  Component,
  useState,
  useEffect
} = wp.element;


function Html(props) {
  if (!props.warn) {
    return null;
  }
  var [help, sethelp] = useState(props.help); // Using the hook.

  useEffect(() => {
    sethelp(props.help);
  }, [props.help]);
  var helpPrams = {
    createAccordion: {
      title: "How to create Accordion",
      content: `, 
`,
      video: "zrIgw9mNA0Y",
      docsUrl: "#"
    },
    useShortcodes: {
      title: "How to create Accordion",
      content: ` 
`,
      video: "zrIgw9mNA0Y",
      docsUrl: "#"
    },
    urlHash: {
      title: "",
      content: ``,
      video: "ol4rtx7RWiI",
      docsUrl: ""
    },
    addPostQuery: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    lazyloadSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    autoembedSetting: {
      title: "",
      content: ``,
      video: "bzwa0Zggjqo",
      docsUrl: ""
    },
    shortcodesSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    wpautopSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    schemaSetting: {
      title: "",
      content: ``,
      video: "_DdR2ncLOws",
      docsUrl: ""
    },
    toggleTextSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    expandCollapseSetting: {
      title: "",
      content: ``,
      video: "c3POl-34kUw",
      docsUrl: ""
    },
    enableSearchSetting: {
      title: "",
      content: ``,
      video: "tdqQhPYEXGU",
      docsUrl: ""
    },
    statsSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    scrollToTopSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    animationSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    accordionTemplatesHelp: {
      title: "",
      content: ``,
      video: "LdPcQeWe_nQ",
      docsUrl: ""
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: `${help.enable ? "" : "hidden"} z-[99999] top-0 left-0 fixed w-full h-full bg-slate-600 bg-opacity-90   `,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: " bg-white my-[100px] p-5 relative w-[800px] h-[600px] overflow-y-scroll mx-auto rounded-md overflow-hidden",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
        className: "cursor-pointer px-2 py-1 bg-red-500 hover:bg-red-700 hover:text-white absolute top-0 right-0",
        onClick: ev => {
          var helpX = {
            ...help
          };
          helpX.enable = false;
          sethelp(helpX);
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_1__["default"], {
          fill: "#fff",
          icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__["default"]
        })
      }), !helpPrams[help?.id]?.video && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        children: "Coming Soon"
      }), helpPrams[help?.id]?.video && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "flex items-center  gap-2 align-middle"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "my-4 text-base",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("iframe", {
            width: "100%",
            height: "450",
            src: `https://www.youtube.com/embed/${helpPrams[help?.id]?.video}`,
            title: "YouTube video player",
            frameborder: "0",
            allow: "accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share",
            referrerpolicy: "strict-origin-when-cross-origin",
            allowfullscreen: true
          })
        })]
      })]
    })
  });
}
class PGHelp extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      help
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Html, {
      help: help,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGHelp);

/***/ }),

/***/ "./src/components/Builder/image-accordion-default-data.js":
/*!****************************************************************!*\
  !*** ./src/components/Builder/image-accordion-default-data.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const imageAccordionDefaultData = {
  globalOptions: {
    viewType: "imageAccordion",
    itemSource: "manual",
    search: true
  },
  itemQueryArgs: [],
  styleObj: {},
  responsiveCss: "",
  wrapper: {
    options: {
      content: "",
      tag: "div",
      class: "image-accordion-wrapper"
    },
    styles: {}
  },
  itemsWrap: {
    options: {
      content: "",
      tag: "div",
      class: "items"
    },
    styles: {
      height: {
        Desktop: "70vh"
      },
      width: {
        Desktop: "100%"
      },
      display: {
        Desktop: "flex"
      }
    }
  },
  items: [{
    isActive: false,
    image: {
      id: "",
      url: "",
      altText: ""
    },
    link: "",
    title: "What is Lorem Ipsum?",
    content: "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s."
  }],
  item: {
    options: {
      content: "",
      tag: "div",
      class: "image-accordion-item"
    },
    styles: {
      height: {
        Desktop: "100%"
      },
      backgroundPosition: {
        Desktop: "center center"
      },
      backgroundSize: {
        Desktop: "cover"
      },
      flexBasis: {
        Desktop: "0%"
      },
      flexGrow: {
        Desktop: "1"
      },
      flexShrink: {
        Desktop: "1"
      },
      position: {
        Desktop: "relative"
      },
      overflow: {
        Desktop: "hidden"
      },
      transition: {
        Desktop: "all 1s ease-in-out 0s"
      }
    }
  },
  itemActive: {
    options: {},
    styles: {
      flexBasis: {
        Desktop: "0%"
      },
      flexGrow: {
        Desktop: "8"
      },
      flexShrink: {
        Desktop: "1"
      }
    }
  },
  overlay: {
    options: {
      class: "image-accordion-overlay"
    },
    styles: {
      backgroundColor: {
        Desktop: "#ffffff"
      },
      padding: {
        Desktop: "20px 20px 20px 20px"
      },
      position: {
        Desktop: "absolute"
      },
      left: {
        Desktop: "30px"
      },
      width: {
        Desktop: "80%"
      },
      top: {
        Desktop: "200%"
      },
      transition: {
        Desktop: "all 1s ease-in-out 0s"
      }
    }
  },
  content: {
    options: {
      content: "",
      tag: "div",
      class: "image-accordion-content"
    },
    styles: {}
  },
  title: {
    options: {
      content: "",
      tag: "div",
      class: "image-accordion-title"
    },
    styles: {
      margin: {
        Desktop: "0px 0px 12px 0px"
      }
    }
  },
  image: {
    options: {
      class: "image-accordion-image"
    },
    styles: {
      height: {
        Desktop: "100%"
      },
      width: {
        Desktop: "100%"
      },
      objectFit: {
        Desktop: "cover"
      }
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (imageAccordionDefaultData);

/***/ }),

/***/ "./src/components/Builder/index.js":
/*!*****************************************!*\
  !*** ./src/components/Builder/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/cog.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/columns.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/category.js");
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _dropdown__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_edit_image_accordion__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../components/edit-image-accordion */ "./src/components/edit-image-accordion/index.js");
/* harmony import */ var _components_edit_accordion_menu__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/edit-accordion-menu */ "./src/components/edit-accordion-menu/index.js");
/* harmony import */ var _components_edit_tabs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../components/edit-tabs */ "./src/components/edit-tabs/index.js");
/* harmony import */ var _components_edit_accordion__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../components/edit-accordion */ "./src/components/edit-accordion/index.js");
/* harmony import */ var _components_edit_faq_grid__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../components/edit-faq-grid */ "./src/components/edit-faq-grid/index.js");
/* harmony import */ var _components_BuilderWelcome__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../components/BuilderWelcome */ "./src/components/BuilderWelcome/index.js");
/* harmony import */ var _components_BuilderView__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/BuilderView */ "./src/components/BuilderView/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _BuilderTabList__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./BuilderTabList */ "./src/components/Builder/BuilderTabList.js");
/* harmony import */ var _default_data_accordion__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./default-data-accordion */ "./src/components/Builder/default-data-accordion.js");
/* harmony import */ var _default_data_faq_grid__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./default-data-faq-grid */ "./src/components/Builder/default-data-faq-grid.js");
/* harmony import */ var _tabs_default_data__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./tabs-default-data */ "./src/components/Builder/tabs-default-data.js");
/* harmony import */ var _image_accordion_default_data__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./image-accordion-default-data */ "./src/components/Builder/image-accordion-default-data.js");
/* harmony import */ var _accordion_menu_default_data__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./accordion-menu-default-data */ "./src/components/Builder/accordion-menu-default-data.js");
/* harmony import */ var _BuilderTabTemplates__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./BuilderTabTemplates */ "./src/components/Builder/BuilderTabTemplates.js");
/* harmony import */ var _generate_css__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./generate-css */ "./src/components/Builder/generate-css.js");
/* harmony import */ var _help__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./help */ "./src/components/Builder/help.js");
/* harmony import */ var _notify__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./notify */ "./src/components/Builder/notify.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__);
const {
  Component,
  useState,
  useEffect
} = wp.element;



























function Html(props) {
  var _optionData$user_role, _optionData$font_aw_v, _optionData$allow_ifr, _optionData$accordion, _optionData$openaiApi, _optionData$license_k;
  if (!props.warn) {
    return null;
  }
  var isProFeature = true;
  var appData = props.appData;
  var [activeAccordion, setActiveAccordion] = useState(null);
  var [postData, setpostData] = useState({
    ID: null,
    post_content: {},
    post_title: ""
  });
  var [accordionData, setaccordionData] = useState(postData?.post_content);
  var [globalOptions, setglobalOptions] = useState(accordionData.globalOptions); // Using the hook.
  var [listQueryPrams, setlistQueryPrams] = useState({
    page: 1,
    search: ""
  }); // Using the hook.

  var [isLoading, setisLoading] = useState(false);
  var [pleaseUpdate, setpleaseUpdate] = useState(false);
  const [optionData, setoptionData] = useState({});
  const [roles, setroles] = useState([]);
  var [needSave, setneedSave] = useState(false);
  var [toggleSettings, settoggleSettings] = useState(false);
  var [notifications, setnotifications] = useState([]);
  var [help, sethelp] = useState({
    id: "",
    enable: false
  });
  var [customerData, setcustomerData] = useState({
    id: "",
    isPro: false
  });
  var [isProFeature, setisProFeature] = useState(true);
  var viewTypeArgs = {
    accordion: {
      label: "Accordion",
      value: "accordion"
    },
    tabs: {
      label: "Tabs",
      value: "tabs"
    },
    imageAccordion: {
      label: "Image Accordion",
      value: "imageAccordion"
    },
    faqGrid: {
      label: "FAQ Grid",
      value: "faqGrid"
    }
    // accordionMenu: { label: "Accordion Menu", value: "accordionMenu", coming: true },
  };
  useEffect(() => {
    setaccordionData(postData.post_content);
    //setglobalOptions(postData.post_content.globalOptions);
  }, [postData]);
  useEffect(() => {

    //setglobalOptions(accordionData.globalOptions);
  }, [accordionData]);
  useEffect(() => {
    // if (globalOptions?.viewType == "accordion") {
    // 	setpostData({ ...postData, post_content: accordionDefaultData })
    // }
    // if (globalOptions?.viewType == "tabs") {
    // 	setpostData({ ...postData, post_content: tabsDefaultData })
    // }

    if (globalOptions?.viewType == "accordion") {
      setpostData({
        ...postData,
        post_content: _default_data_accordion__WEBPACK_IMPORTED_MODULE_16__["default"]
      });
    }
    if (globalOptions?.viewType == "tabs") {
      setpostData({
        ...postData,
        post_content: _tabs_default_data__WEBPACK_IMPORTED_MODULE_18__["default"]
      });
    }
    if (globalOptions?.viewType == "imageAccordion") {
      setpostData({
        ...postData,
        post_content: _image_accordion_default_data__WEBPACK_IMPORTED_MODULE_19__["default"]
      });
    }
    if (globalOptions?.viewType == "accordionMenu") {
      setpostData({
        ...postData,
        post_content: _accordion_menu_default_data__WEBPACK_IMPORTED_MODULE_20__["default"]
      });
    }
    if (globalOptions?.viewType == "faqGrid") {
      setpostData({
        ...postData,
        post_content: _default_data_faq_grid__WEBPACK_IMPORTED_MODULE_17__["default"]
      });
    }
  }, [globalOptions]);
  useEffect(() => {
    setisLoading(true);
    if (activeAccordion == null) return;
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: "/accordions/v2/accordions_data",
      method: "POST",
      data: {
        postId: activeAccordion,
        _wpnonce: accordions_builder_js._wpnonce
      }
    }).then(res => {
      setisLoading(false);
      if (res.post_content == null) {
        res.post_content = _default_data_accordion__WEBPACK_IMPORTED_MODULE_16__["default"];
      }
      setpostData(res);
    });
  }, [activeAccordion]);
  useEffect(() => {
    setnotifications(notifications);
    const timer = setTimeout(() => {
      setnotifications([]); // Update the debounced value after delay
    }, 5000); // 300ms debounce delay

    return () => clearTimeout(timer); // Cleanup timer on value change or unmount
  }, [notifications]);
  useEffect(() => {
    if (customerData.isPro) {
      setisProFeature(false);
    }
  }, [customerData]);
  function handleAlertConfirmation() {
    if (confirm("Are you sure you want to reset the option data?")) {
      resetOptionData();
    }
  }
  function resetOptionData() {
    setoptionData(optionDataDefault);
  }
  function updateOption() {
    setisLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: "/accordions/v2/update_options",
      method: "POST",
      data: {
        name: "accordions_settings",
        value: optionData
      }
    }).then(res => {
      setisLoading(false);
      if (res.status) {
        setneedSave(false);
      }
    });
  }
  function addNotifications(notification) {
    var notificationsX = [...notifications];
    notificationsX.push(notification);
    setnotifications(notificationsX);
  }
  function setHelp(helpX) {
    sethelp(helpX);
  }
  function selectAccordion(args) {
    setActiveAccordion(args);
  }
  function onChangeStyle(args) {
    var accordionDataX = {
      ...accordionData
    };
    accordionDataX.reponsiveCss = escapeHTML(args);
    //accordionDataX.reponsiveCss = (args);
    setaccordionData(accordionDataX);
  }
  function onChangeAccordion(args) {
    var postDataX = {
      ...postData
    };
    postDataX.post_content = args;
    setpostData(postDataX);
    setaccordionData(args);
    setpleaseUpdate(true);
  }
  function onUpdateAccordion() {
    setisLoading(true);
    var content = accordionData;
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: "/accordions/v2/update_post_data",
      method: "POST",
      data: {
        postId: activeAccordion,
        content: JSON.stringify(content),
        _wpnonce: accordions_builder_js._wpnonce
      }
    }).then(res => {
      setisLoading(false);
      setpleaseUpdate(false);
      addNotifications({
        title: "Accordion Saved!",
        content: "You change successfully saved!.",
        type: "success"
      });
    });
  }
  useEffect(() => {
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: "/accordions/v2/user_roles_list",
      method: "POST",
      data: {}
    }).then(res => {
      var rolesX = [];
      Object.entries(res?.roles).map(role => {
        var index = role[0];
        var val = role[1];
        rolesX.push({
          label: val,
          value: index
        });
      });
      setroles(rolesX);
    });
  }, []);
  useEffect(() => {
    setisLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: "/accordions/v2/get_options",
      method: "POST",
      data: {
        option: "accordions_settings"
      }
    }).then(res => {
      if (res.length != 0) {
        var resX = {
          ...res
        };
        if (resX?.license_key.length > 0) {
          setcustomerData({
            ...customerData,
            isPro: true
          });
        }
        setoptionData(resX);
      }
      setisLoading(false);
    });
  }, []);
  function escapeHTML(str) {
    const map = {
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      "'": '&#039;'
    };
    return str.replace(/[&<>"']/g, function (match) {
      return map[match];
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
    className: "pg-setting-input-text pg-dashboard",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
      className: "flex h-[800px]",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
        className: "w-[500px] overflow-y-scroll light-scrollbar",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
          className: "flex items-center justify-between bg-blue-700 py-3 px-3",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
              className: "flex items-center align-middle gap-3",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
                className: "text-xl text-white",
                children: "Accordions"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
                className: "text-xs text-white flex items-center gap-2",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("span", {
                  className: "bg-lime-600 px-3 py-1 rounded-md",
                  children: "Beta"
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
              className: "text-sm text-white",
              children: "By PickPlugins"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
              className: `py-1 px-2 cursor-pointer  capitalize  text-white font-medium rounded hover:bg-gray-700 focus:outline-none focus:bg-gray-700 ${toggleSettings ? "bg-gray-800" : "bg-gray-500"}`,
              onClick: ev => {
                settoggleSettings(!toggleSettings);
              },
              children: [isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Spinner, {}), !isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.Fragment, {
                children: [toggleSettings && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"], {
                  fill: "#fff",
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"]
                }), !toggleSettings && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"], {
                  fill: "#fff",
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"]
                })]
              })]
            })
          })]
        }), toggleSettings && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.Fragment, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
            className: "relative bg-white",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
              className: "px-4 py-2 bg-slate-400 text-white  ",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
                className: "text-xl text-white mb-4",
                children: "Accordions Settings"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
                className: "flex gap-2 items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
                  className: "bg-amber-500 rounded-sm text-md p-2 px-4 cursor-pointer pg-font text-white ",
                  onClick: ev => {
                    handleAlertConfirmation();
                  },
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Reset", "accordions")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
                  className: "bg-green-700 rounded-sm text-md p-2 px-4 cursor-pointer pg-font text-white flex items-center",
                  onClick: ev => {
                    updateOption();
                  },
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("span", {
                    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Save", "accordions")
                  }), needSave && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("span", {
                    className: "w-5 inline-block h-5 ml-3 rounded-xl text-center bg-red-500",
                    children: "!"
                  })]
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
              className: "p-3",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
                className: "my-5",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("label", {
                  className: " text-base",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Allow access by roles", "accordions")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_input_select__WEBPACK_IMPORTED_MODULE_3__["default"], {
                  val: (_optionData$user_role = optionData?.user_roles) !== null && _optionData$user_role !== void 0 ? _optionData$user_role : [],
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[250px]",
                  options: roles,
                  onChange: newVal => {
                    var optionsX = {
                      ...optionData,
                      user_roles: newVal
                    };
                    setoptionData(optionsX);
                  },
                  multiple: true
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
                className: "my-5",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("label", {
                  className: "text-base",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Font-awesome version", "accordions")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_input_select__WEBPACK_IMPORTED_MODULE_3__["default"], {
                  val: (_optionData$font_aw_v = optionData?.font_aw_version) !== null && _optionData$font_aw_v !== void 0 ? _optionData$font_aw_v : "none",
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[250px]",
                  options: [{
                    label: "None",
                    value: "none"
                  }, {
                    label: "Version 4+",
                    value: "v_4"
                  }, {
                    label: "Version 5+",
                    value: "v_5"
                  }],
                  onChange: newVal => {
                    var optionsX = {
                      ...optionData,
                      font_aw_version: newVal
                    };
                    setoptionData(optionsX);
                  },
                  multiple: false
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
                className: "my-5",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("label", {
                  className: "text-base",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Allow Iframe on accordion", "accordions")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_input_select__WEBPACK_IMPORTED_MODULE_3__["default"], {
                  val: (_optionData$allow_ifr = optionData?.allow_iframe) !== null && _optionData$allow_ifr !== void 0 ? _optionData$allow_ifr : "no",
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[250px]",
                  options: [{
                    label: "No",
                    value: "no"
                  }, {
                    label: "Yes",
                    value: "yes"
                  }],
                  onChange: newVal => {
                    var optionsX = {
                      ...optionData,
                      allow_iframe: newVal
                    };
                    setoptionData(optionsX);
                  },
                  multiple: false
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
                className: "my-5",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("label", {
                  className: "text-base",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Enable accordions preview", "accordions")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_input_select__WEBPACK_IMPORTED_MODULE_3__["default"], {
                  val: (_optionData$accordion = optionData?.accordions_preview) !== null && _optionData$accordion !== void 0 ? _optionData$accordion : "no",
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[250px]",
                  options: [{
                    label: "No",
                    value: "no"
                  }, {
                    label: "Yes",
                    value: "yes"
                  }],
                  onChange: newVal => {
                    var optionsX = {
                      ...optionData,
                      accordions_preview: newVal
                    };
                    setoptionData(optionsX);
                  },
                  multiple: false
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
                className: "my-5",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("label", {
                  className: "text-base",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Open AI API Key", "accordions")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_4__["default"], {
                  label: "",
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[250px]",
                  value: (_optionData$openaiApi = optionData?.openaiApiKey) !== null && _optionData$openaiApi !== void 0 ? _optionData$openaiApi : "",
                  onChange: newVal => {
                    var optionsX = {
                      ...optionData,
                      openaiApiKey: newVal
                    };
                    setoptionData(optionsX);
                  }
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
                className: "my-5",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
                  className: "text-base",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("License Key", "accordions")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_4__["default"], {
                  label: "",
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[250px]",
                  value: (_optionData$license_k = optionData?.license_key) !== null && _optionData$license_k !== void 0 ? _optionData$license_k : "",
                  onChange: newVal => {
                    var optionsX = {
                      ...optionData,
                      license_key: newVal
                    };
                    setoptionData(optionsX);
                  }
                })]
              })]
            })]
          })
        }), !toggleSettings && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.Fragment, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)(_components_tabs__WEBPACK_IMPORTED_MODULE_14__["default"], {
            activeTab: "accordions",
            orientation: "",
            stickyNavs: true,
            contentClass: " bg-white w-full",
            navItemClass: "bg-gray-200 px-5 py-3 gap-2 grow ",
            navItemLabelClass: "flex-col ",
            navItemSelectedClass: "!bg-white",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "accordions",
              title: "Accordions",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
              className: "tab-disable-blocks"
            }, {
              name: "edit",
              title: "Edit",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__["default"],
              className: "tab-disable-blocks"
            }, {
              name: "templates",
              title: "Templates",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_31__["default"],
              className: "tab-disable-blocks"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
              name: "accordions",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
                className: "relative p-3",
                children: [postData?.post_content == null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
                  className: "p-3 my-5 bg-orange-400",
                  children: "Please choose an accordion first."
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_BuilderTabList__WEBPACK_IMPORTED_MODULE_15__["default"], {
                  addNotifications: addNotifications,
                  selectAccordion: selectAccordion,
                  activeAccordion: activeAccordion,
                  setHelp: setHelp,
                  listQueryPrams: listQueryPrams,
                  setlistQueryPrams: setlistQueryPrams
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
              name: "edit",
              children: [postData?.ID == null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
                className: "py-3",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
                  className: "my-3 bg-orange-400 p-3  text-white  text-center animate__animated animate__flash animate__repeat-2",
                  children: "Please select post from list."
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
                className: " ",
                children: postData?.ID != null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.Fragment, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
                    className: "my-4 p-3",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("label", {
                        htmlFor: "",
                        children: "View Type?"
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
                        position: "bottom right",
                        variant: "secondary",
                        buttonTitle: postData?.post_content?.globalOptions?.viewType ? viewTypeArgs[postData?.post_content?.globalOptions?.viewType]?.label : "Choose",
                        options: viewTypeArgs,
                        onChange: (option, index) => {
                          if (confirm("Data will reset, Please confirm?")) {
                            if (option.value == "accordion") {
                              setpostData({
                                ...postData,
                                post_content: _default_data_accordion__WEBPACK_IMPORTED_MODULE_16__["default"]
                              });
                            }
                            if (option.value == "tabs") {
                              setpostData({
                                ...postData,
                                post_content: _tabs_default_data__WEBPACK_IMPORTED_MODULE_18__["default"]
                              });
                            }
                            if (option.value == "imageAccordion") {
                              setpostData({
                                ...postData,
                                post_content: _image_accordion_default_data__WEBPACK_IMPORTED_MODULE_19__["default"]
                              });
                            }
                            if (option.value == "accordionMenu") {
                              setpostData({
                                ...postData,
                                post_content: _accordion_menu_default_data__WEBPACK_IMPORTED_MODULE_20__["default"]
                              });
                            }
                            if (option.value == "faqGrid") {
                              setpostData({
                                ...postData,
                                post_content: _default_data_faq_grid__WEBPACK_IMPORTED_MODULE_17__["default"]
                              });
                            }
                          }
                        },
                        values: ""
                      })]
                    })
                  }), postData.post_content.globalOptions?.viewType == "accordion" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_components_edit_accordion__WEBPACK_IMPORTED_MODULE_9__["default"], {
                    onChange: onChangeAccordion,
                    addNotifications: addNotifications,
                    postData: postData,
                    customerData: customerData,
                    setHelp: setHelp
                  }), postData.post_content.globalOptions?.viewType == "tabs" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_components_edit_tabs__WEBPACK_IMPORTED_MODULE_8__["default"], {
                    onChange: onChangeAccordion,
                    addNotifications: addNotifications,
                    postData: postData,
                    customerData: customerData,
                    setHelp: setHelp
                  }), postData.post_content.globalOptions?.viewType == "imageAccordion" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_components_edit_image_accordion__WEBPACK_IMPORTED_MODULE_6__["default"], {
                    onChange: onChangeAccordion,
                    addNotifications: addNotifications,
                    postData: postData,
                    customerData: customerData,
                    setHelp: setHelp
                  }), postData.post_content.globalOptions?.viewType == "accordionMenu" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_components_edit_accordion_menu__WEBPACK_IMPORTED_MODULE_7__["default"], {
                    onChange: onChangeAccordion,
                    addNotifications: addNotifications,
                    postData: postData,
                    customerData: customerData,
                    setHelp: setHelp
                  }), postData.post_content.globalOptions?.viewType == "faqGrid" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_components_edit_faq_grid__WEBPACK_IMPORTED_MODULE_10__["default"], {
                    onChange: onChangeAccordion,
                    addNotifications: addNotifications,
                    postData: postData,
                    customerData: customerData,
                    setHelp: setHelp
                  })]
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)(_components_tab__WEBPACK_IMPORTED_MODULE_13__["default"], {
              name: "templates",
              children: [postData?.ID == null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
                className: "py-3",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
                  className: "my-3 bg-orange-400 p-3  text-white  text-center animate__animated animate__flash animate__repeat-2",
                  children: "Please select post from list."
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_BuilderTabTemplates__WEBPACK_IMPORTED_MODULE_21__["default"], {
                onChange: onChangeAccordion,
                addNotifications: addNotifications,
                postData: postData,
                customerData: customerData,
                setHelp: setHelp
              })]
            })]
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
        className: "w-full sticky top-0 overflow-y-scroll",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
          className: "  relative",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
            className: "my-3 hidden bg-orange-400 p-3 ml-5 text-white  text-center animate__animated animate__flash animate__repeat-2",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsxs)("div", {
              className: "text-xl",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("i", {
                class: "fa-solid fa-triangle-exclamation"
              }), " Please test the Accordions Builder and ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("span", {
                className: "font-bold cursor-pointer underline",
                onClick: ev => {
                  settoggleSettings(!toggleSettings);
                },
                children: "send us feedbacks."
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)("div", {
              children: "Please do not use for old accordion, we will add migration later."
            })]
          }), (postData?.ID == null || toggleSettings) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_components_BuilderWelcome__WEBPACK_IMPORTED_MODULE_11__["default"], {
            appData: appData,
            addNotifications: addNotifications,
            customerData: customerData
          }), !toggleSettings && postData?.ID != null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_components_BuilderView__WEBPACK_IMPORTED_MODULE_12__["default"], {
            pleaseUpdate: pleaseUpdate,
            onUpdate: onUpdateAccordion,
            isLoading: isLoading,
            onChange: onChangeAccordion,
            postData: postData,
            appData: appData,
            id: activeAccordion,
            addNotifications: addNotifications,
            setHelp: setHelp
          }), postData?.ID != null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_generate_css__WEBPACK_IMPORTED_MODULE_22__["default"], {
            postData: postData,
            onChange: onChangeStyle
          })]
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_notify__WEBPACK_IMPORTED_MODULE_24__["default"], {
      notifications: notifications
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(_help__WEBPACK_IMPORTED_MODULE_23__["default"], {
      help: help
    })]
  });
}
class Builder extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      onChange,
      appData
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_25__.jsx)(Html, {
      appData: appData,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Builder);

/***/ }),

/***/ "./src/components/Builder/notify.js":
/*!******************************************!*\
  !*** ./src/components/Builder/notify.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/check.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
const {
  Component,
  useState,
  useEffect
} = wp.element;


function Html(props) {
  if (!props.warn) {
    return null;
  }
  var [notifications, setnotifications] = useState(props.notifications); // Using the hook.

  useEffect(() => {
    var slicedArray = props.notifications.slice(-3);
    setnotifications(slicedArray);
    //setnotifications(props.notifications)
  }, [props.notifications]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: `${notifications.length > 0 ? "" : "hidden"} fixed right-6 bottom-6 `,
    children: notifications?.map((item, index) => {
      var type = item.type;
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: `max-w-72 min-w-64 mb-2 animate__animated animate__backInRight overflow-hidden relative rounded-sm shadow-md bg-white p-3 border-l-4 border-0 ${type == 'success' ? "   border-l-green-700 border-solid " : ""} ${type == 'error' ? "   border-l-red-700 border-solid" : ""} ${type == 'warnning' ? "  border-l-yellow-500 border-solid" : ""}`,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
          className: "cursor-pointer px-1 bg-red-500 hover:bg-red-700 hover:text-white absolute top-0 right-0",
          onClick: ev => {
            var notificationsX = [...notifications];
            notificationsX.splice(index, 1);
            setnotifications(notificationsX);
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_1__["default"], {
            fill: "#fff",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__["default"]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
          className: "flex items-center gap-3 ",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            children: [type == "warnning" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_1__["default"], {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__["default"]
            }), type == "error" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_1__["default"], {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__["default"]
            }), type == "success" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_1__["default"], {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__["default"]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
            className: "text-base mb-2",
            children: item?.title
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "text-xs",
          children: item?.content
        })]
      }, index);
    })
  });
}
class PGNotify extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      notifications
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Html, {
      notifications: notifications,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGNotify);

/***/ }),

/***/ "./src/components/Builder/tabs-default-data.js":
/*!*****************************************************!*\
  !*** ./src/components/Builder/tabs-default-data.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var tabsDefaultData = {
  globalOptions: {
    viewType: "tabs",
    itemSource: "manual",
    search: true
  },
  itemQueryArgs: [],
  styleObj: {},
  reponsiveCss: "",
  wrapper: {
    options: {
      content: "",
      tag: "div",
      class: "accordions-wrapper"
    },
    styles: {}
  },
  items: [{
    "isActive": false,
    "headerLabelSlug": "",
    "headerLabelText": "What is Lorem Ipsum?",
    "contentText": "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."
  }],
  content: {
    options: {
      tag: "div",
      class: "accordion-content"
    },
    styles: {
      padding: {
        Desktop: "15px 15px 15px 15px"
      },
      backgroundColor: {
        Desktop: "#d5d4d9"
      }
    }
  },
  navsWrap: {
    options: {
      class: "navs-wrapper"
    },
    "styles": {
      "display": {
        "Desktop": "flex"
      },
      "gap": {
        "Desktop": "1em"
      },
      "alignItems": {
        "Desktop": "center"
      }
    }
  },
  navItem: {
    options: {
      class: "nav-item "
    },
    "styles": {
      "padding": {
        "Desktop": "15px 15px 15px 15px"
      },
      "backgroundColor": {
        "Desktop": "#735efbfa"
      },
      "borderRadius": {
        "Desktop": "3px 3px 3px 3px"
      },
      "color": {
        "Desktop": "#ffffff"
      },
      "display": {
        "Desktop": "flex"
      },
      "justifyContent": {
        "Desktop": "start"
      },
      "gap": {
        "Desktop": "1em"
      }
    }
  },
  activeNavItem: {
    options: {
      class: "nav-item-active",
      id: ""
    },
    "styles": {
      "backgroundColor": {
        "Desktop": "#462aff"
      }
    }
  },
  navLabel: {
    options: {
      class: ""
    },
    styles: {}
  },
  panelsWrap: {
    options: {
      class: "panels-wrap"
    },
    styles: {}
  },
  panelWrap: {
    options: {
      class: "tabs-panel "
    },
    "styles": {
      "padding": {
        "Desktop": "15px 15px 15px 15px"
      },
      "backgroundColor": {
        "Desktop": "#ffffff"
      },
      "margin": {
        "Desktop": "15px 0px 0px 0px"
      },
      "borderRadius": {
        "Desktop": "5px 5px 5px 5px"
      }
    }
  },
  panelWrapActive: {
    options: {
      class: "tabs-panel-active"
    },
    styles: {
      "display": {
        "Desktop": "block"
      }
    }
  },
  labelCounter: {
    options: {
      enable: false,
      position: "",
      tag: "div",
      class: "accordion-label-counter"
    },
    styles: {}
  },
  icon: {
    options: {
      library: "fontAwesome",
      srcType: "class",
      iconSrc: "fas fa-angle-down",
      position: "before",
      class: " nav-icon-idle nav-icon"
    },
    styles: {}
  },
  iconToggle: {
    options: {
      library: "fontAwesome",
      srcType: "class",
      iconSrc: " fas fa-angle-up",
      class: "nav-icon-toggle nav-icon"
    },
    styles: {}
  },
  labelIcon: {
    options: {
      library: "fontAwesome",
      srcType: "class",
      iconSrc: "",
      position: "beforeLabel",
      class: "label-icon"
    },
    styles: {}
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (tabsDefaultData);

/***/ }),

/***/ "./src/components/css-align-content/index.js":
/*!***************************************************!*\
  !*** ./src/components/css-align-content/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    stretch: {
      "label": "stretch",
      "value": "stretch"
    },
    center: {
      "label": "center",
      "value": "center"
    },
    'flex-start': {
      "label": "flex start	",
      "value": "flex-start"
    },
    'flex-end': {
      "label": "flex end	",
      "value": "flex-end"
    },
    'space-between': {
      "label": "space between",
      "value": "space-between"
    },
    'space-around': {
      "label": "space around",
      "value": "space-around"
    },
    'space-evenly': {
      "label": "space evenly",
      "value": "space-evenly"
    },
    start: {
      "label": "start",
      "value": "start"
    },
    end: {
      "label": "end",
      "value": "end"
    },
    normal: {
      "label": "normal",
      "value": "normal"
    },
    start: {
      "label": "start",
      "value": "start"
    },
    baseline: {
      "label": "baseline",
      "value": "baseline"
    },
    revert: {
      "label": "revert",
      "value": "revert"
    },
    unset: {
      "label": "unset",
      "value": "unset"
    },
    inherit: {
      "label": "inherit",
      "value": "inherit"
    },
    initial: {
      "label": "initial",
      "value": "initial"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Align Content", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? 'Select...' : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: 'px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer',
            onClick: ev => {
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + ' !important', 'alignContent');
              } else {
                props.onChange(x.value, 'alignContent');
              }
              // props.onChange(x.value, 'alignContent');
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Important (Enabled)', "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Important?', "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, 'alignContent');
        } else {
          props.onChange(align + ' !important', 'alignContent');
        }
      }
    })]
  });
}
class PGcssAlignContent extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssAlignContent);

/***/ }),

/***/ "./src/components/css-align-items/index.js":
/*!*************************************************!*\
  !*** ./src/components/css-align-items/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    stretch: {
      label: "stretch",
      value: "stretch"
    },
    center: {
      label: "center",
      value: "center"
    },
    "flex-start": {
      label: "flex start	",
      value: "flex-start"
    },
    "flex-end": {
      label: "flex end	",
      value: "flex-end"
    },
    "space-between": {
      label: "space between",
      value: "space-between"
    },
    "space-around": {
      label: "space around",
      value: "space-around"
    },
    "space-evenly": {
      label: "space evenly",
      value: "space-evenly"
    },
    start: {
      label: "start",
      value: "start"
    },
    end: {
      label: "end",
      value: "end"
    },
    normal: {
      label: "normal",
      value: "normal"
    },
    start: {
      label: "start",
      value: "start"
    },
    baseline: {
      label: "baseline",
      value: "baseline"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: "Align Items",
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // props.onChange(x.value, 'alignItems');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "alignItems");
              } else {
                props.onChange(x.value, "alignItems");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Important (Enabled)', "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Important?', "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "alignItems");
        } else {
          props.onChange(align + " !important", "alignItems");
        }
      }
    })]
  });
}
class PGcssAlignItems extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssAlignItems);

/***/ }),

/***/ "./src/components/css-align-self/index.js":
/*!************************************************!*\
  !*** ./src/components/css-align-self/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    auto: {
      label: "auto",
      value: "auto"
    },
    stretch: {
      label: "Stretch",
      value: "stretch"
    },
    center: {
      label: "Center",
      value: "center"
    },
    "flex-start": {
      label: "Flex start	",
      value: "flex-start"
    },
    "flex-end": {
      label: "Flex end	",
      value: "flex-end"
    },
    normal: {
      label: "normal",
      value: "normal"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    "self-end": {
      label: "self-end",
      value: "self-end"
    },
    " self-start": {
      label: " self-start",
      value: " self-start"
    },
    start: {
      label: "start",
      value: "start"
    },
    end: {
      label: "end",
      value: "end"
    },
    unset: {
      label: "unset",
      value: "unset"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Align Self", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'alignSelf');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "alignSelf");
              } else {
                props.onChange(x.value, "alignSelf");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "flex items-center gap-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("label", {
        htmlFor: "",
        children: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
        className: "!mb-0",
        checked: isImportant,
        onChange: arg => {
          setImportant(isImportant => !isImportant);
          if (isImportant) {
            props.onChange(align, "alignSelf");
          } else {
            props.onChange(align + " !important", "alignSelf");
          }
        }
      })]
    })]
  });
}
class PGcssAlignSelf extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssAlignSelf);

/***/ }),

/***/ "./src/components/css-animation-name/index.js":
/*!****************************************************!*\
  !*** ./src/components/css-animation-name/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var content = props.val == null || props.val == undefined ? '' : props.val.replaceAll('"', '');
  content = content.replaceAll('u0022', '');
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    className: "mt-4",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: content,
      type: "text",
      onChange: newVal => {
        //setwidthVal(newVal);
        props.onChange(newVal, 'animationName');
      }
    })
  });
}
class PGcssAnimationName extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssAnimationName);

/***/ }),

/***/ "./src/components/css-aspect-ratio/index.js":
/*!**************************************************!*\
  !*** ./src/components/css-aspect-ratio/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? 'auto' : props.val;
  var valX = valZ != 'auto' ? valZ.split("/")[0] : 1;
  var valY = valZ != 'auto' ? valZ.split("/")[1] : 1;
  const [isAuto, setisAuto] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes("auto") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "mt-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isAuto ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Auto', "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Auto?', "accordions"),
      checked: isAuto,
      onChange: arg => {
        setisAuto(isAuto => !isAuto);
        props.onChange('auto', 'aspectRatio');
      }
    }), !isAuto && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "flex mt-4",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
        value: valX,
        type: "number",
        onChange: newVal => {
          props.onChange(newVal + '/' + valY, 'aspectRatio');
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "mx-2",
        children: " / "
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
        value: valY,
        type: "number",
        onChange: newVal => {
          props.onChange(valX + '/' + newVal, 'aspectRatio');
        }
      })]
    })]
  });
}
class PGcssAspectRatio extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssAspectRatio);

/***/ }),

/***/ "./src/components/css-backdrop-filter/index.js":
/*!*****************************************************!*\
  !*** ./src/components/css-backdrop-filter/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
const {
  Component
} = wp.element;







function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valParts = props.val != undefined ? props.val.split(" ") : [];
  const [valArgs, setvalArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)([]);
  function addFilter(option, index) {
    var isExist = valArgs.find(x => x.id === option.value);
    if (isExist == undefined) {
      var obj = {};
      obj['id'] = option.value;
      obj['val'] = option.val;
      obj['unit'] = option.unit;
      valArgs.push(obj);
      var str = '';
      valArgs.map(x => {
        str += x.id + '(' + x.val + x.unit + ') ';
      });
      props.onChange(str, 'backdropFilter');
    }
  }
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    var filtered = valParts.filter(Boolean);
    var res = filtered.map(x => {
      if (x.length != 0) {
        var argVal = x != undefined ? x.match(/-?\d+/g)[0] : 1;
        var argUnit = x != undefined ? x.match(/-?\d+(px|deg|%)/g)[0] : "px";
        var argId = x != undefined ? x.match(/[a-zA-Z]+/g)[0] : '';
        return {
          id: argId,
          val: argVal,
          unit: argUnit
        };
      }
    });
    setvalArgs(res);
  }, [props.val]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    //onChange('contrast(200%) brightness(150%) blur(10%)', 'filter');
  }, [valArgs]);
  const [filterArgs, setfilterArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({
    blur: {
      label: "Blur",
      value: "blur",
      val: "1",
      unit: "px"
    },
    brightness: {
      label: "Brightness",
      value: "brightness",
      val: "10",
      unit: "%"
    },
    contrast: {
      label: "Contrast",
      value: "contrast",
      val: "10",
      unit: "%"
    },
    grayscale: {
      label: "Grayscale",
      value: "grayscale",
      val: "10",
      unit: "%"
    },
    "hue-rotate": {
      label: "Hue-rotate",
      value: "hue-rotate",
      val: "10",
      unit: "deg"
    },
    invert: {
      label: "Invert",
      value: "invert",
      val: "10",
      unit: "%"
    },
    opacity: {
      label: "Opacity",
      value: "opacity",
      val: "10",
      unit: "%"
    },
    saturate: {
      label: "Saturate",
      value: "saturate",
      val: "10",
      unit: "%"
    },
    sepia: {
      label: "Sepia",
      value: "sepia",
      val: "10",
      unit: "%"
    }
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "mt-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "flex",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_3__["default"], {
        position: "bottom right",
        variant: "secondary",
        options: filterArgs,
        buttonTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Add Filter", "accordions"),
        onChange: addFilter,
        values: ""
      })
    }), valArgs != undefined && valArgs.map((arg, i) => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "flex my-3 items-center justify-between",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("label", {
          htmlFor: "",
          children: filterArgs[arg.id]?.label
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
          className: "flex",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
            value: arg.val,
            type: "number",
            ...(valArgs[i].id !== "blur" && {
              min: 0,
              max: 100
            }),
            onChange: newVal => {
              valArgs[i].val = newVal;
              // setvalArgs(valArgs);
              var str = '';
              valArgs.map((x, i) => {
                if (x.id == "blur") {
                  x.unit = "px";
                }
                if (x.id == "hue-rotate") {
                  x.unit = "deg";
                }
                if (x.id == "brightness" || x.id == "contrast" || x.id == "grayscale" || x.id == "invert" || x.id == "opacity" || x.id == "saturate" || x.id == "sepia") {
                  x.unit = "%";
                }
                str += x.id + '(' + x.val + x.unit + ') ';
              });
              props.onChange(str, 'backdropFilter');
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
            className: "hover:bg-red-500 bg-red-400 text-white ml-1 inline-block p-1 cursor-pointer",
            onClick: ev => {
              valArgs.splice(i, 1);
              setvalArgs(valArgs);
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
              className: "dashicons dashicons-no-alt"
            })
          })]
        })]
      });
    })]
  });
}
class PGcssBackdropFilter extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBackdropFilter);

/***/ }),

/***/ "./src/components/css-backface-visibility/index.js":
/*!*********************************************************!*\
  !*** ./src/components/css-backface-visibility/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    visible: {
      label: "Visible",
      value: "visible"
    },
    hidden: {
      label: "Hidden",
      value: "hidden"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: "",
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'backfaceVisibility');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "backfaceVisibility");
              } else {
                props.onChange(x.value, "backfaceVisibility");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "backfaceVisibility");
        } else {
          props.onChange(align + " !important", "backfaceVisibility");
        }
      }
    })]
  });
}
class PGcssBackfaceVisibility extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBackfaceVisibility);

/***/ }),

/***/ "./src/components/css-background-attachment/index.js":
/*!***********************************************************!*\
  !*** ./src/components/css-background-attachment/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    scroll: {
      label: "Scroll",
      value: "scroll"
    },
    fixed: {
      label: "Fixed",
      value: "fixed"
    },
    local: {
      label: "Local",
      value: "local"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Background Attachment", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'backgroundAttachment');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "backgroundAttachment");
              } else {
                props.onChange(x.value, "backgroundAttachment");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "backgroundAttachment");
        } else {
          props.onChange(align + " !important", "backgroundAttachment");
        }
      }
    })]
  });
}
class PGcssBackgroundAttachment extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBackgroundAttachment);

/***/ }),

/***/ "./src/components/css-background-blend-mode/index.js":
/*!***********************************************************!*\
  !*** ./src/components/css-background-blend-mode/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    normal: {
      label: "Normal",
      value: "normal"
    },
    multiply: {
      label: "Multiply",
      value: "multiply"
    },
    screen: {
      label: "Screen",
      value: "screen"
    },
    overlay: {
      label: "Overlay",
      value: "overlay"
    },
    darken: {
      label: "Darken",
      value: "darken"
    },
    lighten: {
      label: "Lighten",
      value: "lighten"
    },
    "color-dodge": {
      label: "Color dodge",
      value: "color-dodge"
    },
    saturation: {
      label: "Saturation",
      value: "saturation"
    },
    color: {
      label: "Color",
      value: "color"
    },
    luminosity: {
      label: "Luminosity",
      value: "luminosity"
    },
    exclusion: {
      label: "exclusion",
      value: "exclusion"
    },
    hue: {
      label: "hue",
      value: "hue"
    },
    "color-burn": {
      label: "color-burn",
      value: "color-burn"
    },
    difference: {
      label: "difference",
      value: "difference"
    },
    "hard-light": {
      label: "hard-light",
      value: "hard-light"
    },
    "soft-light": {
      label: "soft-light",
      value: "soft-light"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Background Blend Mode", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'backgroundBlendMode');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "backgroundBlendMode");
              } else {
                props.onChange(x.value, "backgroundBlendMode");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "backgroundBlendMode");
        } else {
          props.onChange(align + " !important", "backgroundBlendMode");
        }
      }
    })]
  });
}
class PGcssBackgroundBlendMode extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBackgroundBlendMode);

/***/ }),

/***/ "./src/components/css-background-clip/index.js":
/*!*****************************************************!*\
  !*** ./src/components/css-background-clip/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    "border-box": {
      label: "Border box",
      value: "border-box"
    },
    "padding-box": {
      label: "Padding box",
      value: "padding-box"
    },
    "content-box": {
      label: "Content box",
      value: "content-box"
    },
    "revert-layer": {
      label: "revert-layer",
      value: "revert-layer"
    },
    text: {
      label: "text",
      value: "text"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Background Blend Mode", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'backgroundClip');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "backgroundClip");
              } else {
                props.onChange(x.value, "backgroundClip");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "backgroundClip");
        } else {
          props.onChange(align + " !important", "backgroundClip");
        }
      }
    })]
  });
}
class PGcssBackgroundClip extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBackgroundClip);

/***/ }),

/***/ "./src/components/css-background-color/index.js":
/*!******************************************************!*\
  !*** ./src/components/css-background-color/index.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component
} = wp.element;






function Html(props) {
  if (!props.warn) {
    return null;
  }
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(props.val.split(" "));
  const [val, setval] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(valArgs[1] == undefined ? false : true);
  const [customColor, setCustomColor] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)([]);
  const [newColorPreset, setNewColorPreset] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)([]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    const transformedColors = customColor.map((color, index) => {
      const name = color.substring(1).toUpperCase();
      const upperCaseColor = color.toUpperCase();
      return {
        name,
        color: upperCaseColor
      };
    });
    let newColor;
    if (transformedColors.length >= 6) {
      newColor = transformedColors;
    } else {
      newColor = transformedColors.concat(_colors_presets__WEBPACK_IMPORTED_MODULE_2__["default"].slice(0, 6 - transformedColors.length));
    }
    setNewColorPreset(newColor);
  }, [customColor]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "p-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
        className: "mb-2",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
          label: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
          checked: isImportant,
          className: "!mb-0",
          onChange: arg => {
            setImportant(isImportant => !isImportant);
            if (isImportant) {
              props.onChange(val, "backgroundColor");
            } else {
              props.onChange(val + " !important", "backgroundColor");
            }
          }
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ColorPalette, {
        value: val,
        colors: newColorPreset,
        enableAlpha: true,
        onChange: newVal => {
          //props.onChange(newVal, 'backgroundColor');
          setval(newVal);
          if (isImportant) {
            props.onChange(newVal + " !important", "backgroundColor");
          } else {
            props.onChange(newVal, "backgroundColor");
          }
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
          htmlFor: "",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Global Value", "accordions")
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
          label: "",
          value: val,
          options: [{
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Choose", "accordions"),
            value: ""
          }, {
            label: "Inherit",
            value: "inherit"
          }, {
            label: "Initial",
            value: "initial"
          }, {
            label: "Revert",
            value: "revert"
          }, {
            label: "Revert-layer",
            value: "revert-layer"
          }, {
            label: "Unset",
            value: "unset"
          }],
          onChange: newVal => {
            setval(newVal);
            if (isImportant) {
              props.onChange(newVal + " !important", "backgroundColor");
            } else {
              props.onChange(newVal, "backgroundColor");
            }
          }
        })]
      })]
    })
  });
}
class PGcssBackgroundColor extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      enableAlpha,
      onChange,
      label
    } = this.props;
    var colorVal = val.replace(" !important", "");
    var placeholderStyle = {
      backgroundImage: "repeating-linear-gradient(45deg,#e0e0e0 25%,transparent 0,transparent 75%,#e0e0e0 0,#e0e0e0),repeating-linear-gradient(45deg,#e0e0e0 25%,transparent 0,transparent 75%,#e0e0e0 0,#e0e0e0)",
      backgroundPosition: "0 0,25px 25px",
      backgroundSize: "50px 50px",
      boxShadow: "inset 0 0 0 1px rgb(0 0 0 / 20%)",
      cursor: "pointer"
    };
    var defaultbtnStyle = {
      backgroundImage: "repeating-linear-gradient(45deg,#e0e0e0 25%,transparent 0,transparent 75%,#e0e0e0 0,#e0e0e0),repeating-linear-gradient(45deg,#e0e0e0 25%,transparent 0,transparent 75%,#e0e0e0 0,#e0e0e0)",
      backgroundPosition: "0 0,25px 25px",
      backgroundSize: "50px 50px",
      boxShadow: "inset 0 0 0 1px rgb(0 0 0 / 20%)",
      cursor: "pointer"
    };
    var btnStyle = {
      backgroundColor: val,
      boxShadow: "inset 0 0 0 1px rgb(0 0 0 / 20%)",
      cursor: "pointer"
    };
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
        enableAlpha: enableAlpha,
        val: val,
        onChange: onChange,
        warn: this.state.showWarning,
        handleToggleClick: this.handleToggleClick
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBackgroundColor);

/***/ }),

/***/ "./src/components/css-background-image/index.js":
/*!******************************************************!*\
  !*** ./src/components/css-background-image/index.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
const {
  Component,
  RawHTML
} = wp.element;










function Html(props) {
  if (!props.warn) {
    return null;
  }
  var typeArgs = {
    url: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Image URL', "accordions"),
      id: 'url'
    },
    //conicGradient: { label: 'Conic Gradient', id: 'conicGradient' },
    linearGradient: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Linear Gradient', "accordions"),
      id: 'linearGradient'
    },
    radialGradient: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Radial Gradient', "accordions"),
      id: 'radialGradient'
    }
    // repeatingConicGradient: { label: 'Repeating Conic Gradient', id: 'repeatingConicGradient' },
    // repeatingLinearGradient: { label: 'Repeating Linear Gradient', id: 'repeatingLinearGradient' },
    // repeatingRadialGradient: { label: 'Repeating Radial Gradient', id: 'repeatingRadialGradient' },
  };
  var valX = props.val == undefined || props.val == null || props.val.length == 0 ? '' : props.val;
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valX.split(",  ").filter(n => n));
  var RemoveQueryPram = function ({
    index,
    arg
  }) {
    var typeName = '';
    if (arg.includes("url")) {
      typeName = 'URL';
    } else if (arg.includes("conic-gradient")) {
      typeName = 'Conic Gradient';
    } else if (arg.includes("linear-gradient")) {
      typeName = 'Linear Gradient';
    } else if (arg.includes("radial-gradient")) {
      typeName = 'Radial Gradient';
    } else if (arg.includes("repeating-conic-gradient")) {
      typeName = 'R Conic Gradient';
    } else if (arg.includes("repeating-linear-gradient")) {
      typeName = 'R Linear Gradient';
    } else if (arg.includes("repeating-radial-gradient")) {
      typeName = 'R Radial Gradient';
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
        className: "cursor-pointer hover:bg-red-500 hover:text-white px-1 py-1",
        onClick: ev => {
          valArgs.splice(index, 1);
          var ssdsd = valArgs.concat([]);
          setValArgs(ssdsd);
          var valString = ssdsd.join(',  ');
          props.onChange(valString, 'backgroundImage');
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"], {
          icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
        className: "mx-2",
        children: typeName.length == 0 ? '#' + index : typeName
      })]
    });
  };
  const ALLOWED_MEDIA_TYPES = ['image'];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "my-4",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_4__["default"], {
        position: "bottom right",
        variant: "secondary",
        options: typeArgs,
        buttonTitle: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Add", "accordions"),
        onChange: (option, index) => {
          if (option.id == 'url') {
            var dsdsf = valArgs.concat('url()');
          } else if (option.id == 'linearGradient') {
            var dsdsf = valArgs.concat("linear-gradient(135deg,#12c2e9 0%,#c471ed 50%,#f64f59 100%)");
          } else if (option.id == 'radialGradient') {
            var dsdsf = valArgs.concat("radial-gradient(#12c2e9 0%,#c471ed 50%,#f64f59 100%)");
          } else if (option.id == 'conicGradient') {
            var dsdsf = valArgs.concat("conic-gradient(135deg,#12c2e9 0%,#c471ed 50%,#f64f59 100%)");
          }
          setValArgs(dsdsf);
          var valString = valArgs.join(',  ');
          props.onChange(valString, 'backgroundImage');
        },
        values: ""
      })
    }), valArgs.length != 0 && valArgs.map((x, index) => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: "pg-setting-input-gradient",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelBody, {
          initialOpen: false,
          title: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(RemoveQueryPram, {
            index: index,
            arg: x
          }),
          children: [x.includes("url") && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: "my-3",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("img", {
                src: x.replace("url(", "").replace(")", ""),
                alt: ""
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
              className: "mr-2",
              value: x.replace("url(", "").replace(")", ""),
              placeholder: "Image URL",
              onChange: newVal => {
                valArgs[index] = "url(" + newVal + ")";
                setValArgs(valArgs);
                var valString = valArgs.join(",  ");
                props.onChange(valString, "backgroundImage");
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__.MediaUploadCheck, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__.MediaUpload, {
                className: "bg-gray-700 hover:bg-gray-600",
                onSelect: media => {
                  // media.id
                  valArgs[index] = "url(" + media.url + ")";
                  setValArgs(valArgs);
                  var valString = valArgs.join(",  ");
                  props.onChange(valString, "backgroundImage");
                },
                onClose: () => {},
                allowedTypes: ALLOWED_MEDIA_TYPES,
                render: ({
                  open
                }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
                  className: "my-3 bg-gray-700 hover:bg-gray-600 text-white border border-solid border-gray-300 text-center w-full",
                  onClick: open,
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Open Media Library", "accordions")
                })
              })
            })]
          }), !x.includes("url") && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.GradientPicker, {
            value: x == null || x == undefined ? null : x,
            onChange: currentGradient => {
              if (currentGradient == undefined) {
                valArgs.splice(index, 1);
                var ssdsd = valArgs.concat([]);
                setValArgs(ssdsd);
                var valString = ssdsd.join(",  ");
              } else {
                valArgs[index] = currentGradient;
                setValArgs(valArgs);
                var valString = valArgs.join(",  ");
              }
              props.onChange(valString, "backgroundImage");
            },
            gradients: [{
              name: "JShine",
              gradient: "linear-gradient(135deg,#12c2e9 0%,#c471ed 50%,#f64f59 100%)",
              slug: "jshine"
            }, {
              name: "Moonlit Asteroid",
              gradient: "linear-gradient(135deg,#0F2027 0%, #203A43 0%, #2c5364 100%)",
              slug: "moonlit-asteroid"
            }, {
              name: "Rastafarie",
              gradient: "linear-gradient(135deg,#1E9600 0%, #FFF200 0%, #FF0000 100%)",
              slug: "rastafari"
            }]
          })]
        })
      });
    })]
  });
}
class PGcssBackgroundImage extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBackgroundImage);

/***/ }),

/***/ "./src/components/css-background-origin/index.js":
/*!*******************************************************!*\
  !*** ./src/components/css-background-origin/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    "border-box": {
      label: "border-box",
      value: "border-box"
    },
    "padding-box": {
      label: "padding-box",
      value: "padding-box"
    },
    "content-box": {
      label: "content-box",
      value: "content-box"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Background Blend Mode", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'backgroundOrigin');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "backgroundOrigin");
              } else {
                props.onChange(x.value, "backgroundOrigin");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "backgroundOrigin");
        } else {
          props.onChange(align + " !important", "backgroundOrigin");
        }
      }
    })]
  });
}
class PGcssBackgroundOrigin extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBackgroundOrigin);

/***/ }),

/***/ "./src/components/css-background-position/index.js":
/*!*********************************************************!*\
  !*** ./src/components/css-background-position/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = [{
    label: "left top",
    value: "left top"
  }, {
    label: "left center",
    value: "left center"
  }, {
    label: "left bottom",
    value: "left bottom"
  }, {
    label: "right top",
    value: "right top"
  }, {
    label: "right center",
    value: "right center"
  }, {
    label: "right bottom",
    value: "right bottom"
  }, {
    label: "center top",
    value: "center top"
  }, {
    label: "center center",
    value: "center center"
  }, {
    label: "center bottom",
    value: "center bottom"
  }, {
    label: "inherit",
    value: "inherit"
  }, {
    label: "initial",
    value: "initial"
  }, {
    label: "revert",
    value: "revert"
  }, {
    label: "unset",
    value: "unset"
  }];
  const [isCustom, setisCustom] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.match(/-?\d+/g) == null ? false : true);
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [position, setposition] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.includes("!important") ? true : false);
  const [ValX, setValX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0] == undefined || valArgs[0].match(/-?\d+/g) == null ? 0 : valArgs[0].match(/-?\d+/g)[0]);
  const [valUnitX, setvalUnitX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0] == undefined || valArgs[0].match(/[a-zA-Z%]+/g) == null ? "px" : valArgs[0].match(/[a-zA-Z%]+/g)[0]);
  const [ValY, setValY] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined || valArgs[1].match(/-?\d+/g) == null ? 0 : valArgs[1].match(/-?\d+/g)[0]);
  const [valUnitY, setvalUnitY] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined || valArgs[1].match(/[a-zA-Z%]+/g) == null ? "px" : valArgs[1].match(/[a-zA-Z%]+/g)[0]);
  // var ValX = (valArgs[0] == undefined || valArgs[0].match(/-?\d+/g) == null) ? 0 : valArgs[0].match(/-?\d+/g)[0];
  // var valUnitX = (valArgs[0] == undefined || valArgs[0].match(/[a-zA-Z%]+/g) == null) ? 'px' : valArgs[0].match(/[a-zA-Z%]+/g)[0];
  // var ValY = (valArgs[1] == undefined || valArgs[1].match(/-?\d+/g) == null) ? 0 : valArgs[1].match(/-?\d+/g)[0];
  // var valUnitY = (valArgs[1] == undefined || valArgs[1].match(/[a-zA-Z%]+/g) == null) ? 'px' : valArgs[1].match(/[a-zA-Z%]+/g)[0];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      label: isCustom ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Custom Value enabled?", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Custom Value?", "accordions"),
      checked: isCustom,
      onChange: arg => {
        setisCustom(isCustom => !isCustom);
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "flex justify-between items-center my-3",
      children: !isCustom && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: "",
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: " ",
            children: position.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : position
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "w-32",
          children: args.map(x => {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                setisCustom(false);
                setposition(x.value);
                if (isImportant) {
                  props.onChange(x.value + " !important", "backgroundPosition");
                } else {
                  props.onChange(x.value, "backgroundPosition");
                }
              },
              children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
              }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: x.label
              })]
            });
          })
        })
      })
    }), isCustom && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "flex mt-4",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
          value: ValX,
          type: "number",
          onChange: newVal => {
            setValX(newVal);
            if (isImportant) {
              props.onChange(newVal + valUnitX + " " + ValY + valUnitY + " " + "!important", "backgroundPosition");
            } else {
              props.onChange(newVal + valUnitX + " " + ValY + valUnitY, "backgroundPosition");
            }
          }
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "mx-2",
        children: " / "
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
          value: ValY,
          type: "number",
          onChange: newVal => {
            setValY(newVal);
            if (isImportant) {
              props.onChange(ValX + valUnitX + " " + newVal + valUnitY + " " + "!important", "backgroundPosition");
            } else {
              props.onChange(ValX + valUnitX + " " + newVal + valUnitY, "backgroundPosition");
            }
          }
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      label: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          if (isCustom) {
            props.onChange(ValX + valUnitX + " " + ValY + valUnitY, "backgroundPosition");
          } else {
            props.onChange(position, "backgroundPosition");
          }
        } else {
          if (isCustom) {
            props.onChange(ValX + valUnitX + " " + ValY + valUnitY + " " + "!important", "backgroundPosition");
          } else {
            props.onChange(position + " !important", "backgroundPosition");
          }
        }
      }
    })]
  });
}
class PGcssBackgroundPosition extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBackgroundPosition);

/***/ }),

/***/ "./src/components/css-background-repeat/index.js":
/*!*******************************************************!*\
  !*** ./src/components/css-background-repeat/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    repeat: {
      label: "Repeat",
      value: "repeat"
    },
    "repeat-x": {
      label: "Repeat X",
      value: "repeat-x"
    },
    "repeat-y": {
      label: "Repeat Y",
      value: "repeat-y"
    },
    "no-repeat": {
      label: "No repeat",
      value: "no-repeat"
    },
    space: {
      label: "Space",
      value: "space"
    },
    round: {
      label: "Round",
      value: "round"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Background Repeat", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'backgroundRepeat');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "backgroundRepeat");
              } else {
                props.onChange(x.value, "backgroundRepeat");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "backgroundRepeat");
        } else {
          props.onChange(align + " !important", "backgroundRepeat");
        }
      }
    })]
  });
}
class PGcssBackgroundRepeat extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBackgroundRepeat);

/***/ }),

/***/ "./src/components/css-background-size/index.js":
/*!*****************************************************!*\
  !*** ./src/components/css-background-size/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    auto: {
      label: "auto",
      value: "auto"
    },
    cover: {
      label: "Cover",
      value: "cover"
    },
    contain: {
      label: "Contain",
      value: "contain"
    },
    custom: {
      label: "Custom",
      value: "custom"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    }
  };
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  const [isMultiple, setisMultiple] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.includes(", ") ? true : false);
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(isMultiple ? props.val.split(", ") : props.val.split(" "));
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.includes("!important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "flex justify-between items-center",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "cursor-pointer bg-gray-700 hover:bg-gray-600 text-white px-3 py-1 my-3",
        onClick: ev => {
          valArgs.push("auto");
          setValArgs(valArgs);
          props.onChange(valArgs.join(" "), "backgroundSize");
        },
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Add", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
        label: isMultiple ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Multiple (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Multiple?", "accordions"),
        checked: isMultiple,
        onChange: arg => {
          setisMultiple(isMultiple => !isMultiple);
          if (isMultiple) {
            if (isImportant) {
              props.onChange(valArgs.join(" ") + " !important", "backgroundSize");
            } else {
              props.onChange(valArgs.join(" "), "backgroundSize");
            }
          } else {
            if (isImportant) {
              props.onChange(valArgs.join(", ") + " !important", "backgroundSize");
            } else {
              props.onChange(valArgs.join(", "), "backgroundSize");
            }
          }
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: valArgs.map((item, i) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "flex items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            className: "bg-red-500 text-white",
            onClick: ev => {
              valArgs.splice(i, 1);
              if (isMultiple) {
                if (isImportant) {
                  props.onChange(valArgs.join(", ") + " !important", "backgroundSize");
                } else {
                  props.onChange(valArgs.join(", "), "backgroundSize");
                }
              } else {
                if (isImportant) {
                  props.onChange(valArgs.join(" ") + " !important", "backgroundSize");
                } else {
                  props.onChange(valArgs.join(" "), "backgroundSize");
                }
              }
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"], {
              fill: "#fff",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
            position: "bottom",
            renderToggle: ({
              isOpen,
              onToggle
            }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
              title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Background Repeat", "accordions"),
              onClick: onToggle,
              "aria-expanded": isOpen,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                className: " ",
                children: args[item] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Custom", "accordions") : args[item].label
              })
            }),
            renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "w-32",
              children: Object.entries(args).map(args => {
                var index = args[0];
                var x = args[1];
                return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                  className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
                  onClick: ev => {
                    if (x.value == "custom") {
                      valArgs[i] = "0px";
                    } else {
                      valArgs[i] = x.value;
                    }
                    props.onChange(valArgs.join(" "), "backgroundSize");
                    setValArgs(valArgs);
                  },
                  children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
                  }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                    children: x.label
                  })]
                });
              })
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {}), item.match(/-?\d+/g) != null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "flex justify-between",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
              value: item.match(/-?\d+/g) == null ? "0" : item.match(/-?\d+/g)[0],
              type: "number",
              onChange: newVal => {
                if (newVal.length > 0) {
                  valArgs[i] = newVal + item.match(/[a-zA-Z%]+/g)[0];
                  props.onChange(valArgs.join(" "), "backgroundSize");
                  setValArgs(valArgs);
                }
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
              position: "bottom left",
              renderToggle: ({
                isOpen,
                onToggle
              }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
                title: "",
                onClick: onToggle,
                "aria-expanded": isOpen,
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                  className: " ",
                  children: item.match(/[a-zA-Z%]+/g) == null ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : unitArgs[item.match(/[a-zA-Z%]+/g)[0]] == undefined ? "" : unitArgs[item.match(/[a-zA-Z%]+/g)[0]].label
                })
              }),
              renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                className: "w-32",
                children: Object.entries(unitArgs).map(y => {
                  var index = y[0];
                  var x = y[1];
                  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                    className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
                    onClick: ev => {
                      var val = item.match(/-?\d+/g) == null ? 0 : item.match(/-?\d+/g)[0];
                      valArgs[i] = val + x.value;
                      props.onChange(valArgs.join(" "), "backgroundSize");
                      setValArgs(valArgs);
                    },
                    children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                      children: x.label
                    })
                  });
                })
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {})]
        });
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      label: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isMultiple) {
          if (isImportant) {
            props.onChange(valArgs.join(", ").replace("!important", ""), "backgroundSize");
          } else {
            props.onChange(valArgs.join(", ") + " !important", "backgroundSize");
          }
        } else {
          if (isImportant) {
            props.onChange(valArgs.join(" ").replace("!important", ""), "backgroundSize");
          } else {
            props.onChange(valArgs.join(" ") + " !important", "backgroundSize");
          }
        }
      }
    })]
  });
}
class PGcssBackgroundSize extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBackgroundSize);

/***/ }),

/***/ "./src/components/css-bg-color/index.js":
/*!**********************************************!*\
  !*** ./src/components/css-bg-color/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Popover, {
      position: "bottom right",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        className: "p-2",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ColorPalette, {
          value: props.value,
          colors: _colors_presets__WEBPACK_IMPORTED_MODULE_2__["default"],
          enableAlpha: true,
          onChange: newVal => {
            props.onChange(newVal, 'bgColor');
          }
        })
      })
    })
  });
}
class PGcssBgColor extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: false
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      enableAlpha,
      onChange,
      label
    } = this.props;
    var placeholderStyle = {
      backgroundImage: 'repeating-linear-gradient(45deg,#e0e0e0 25%,transparent 0,transparent 75%,#e0e0e0 0,#e0e0e0),repeating-linear-gradient(45deg,#e0e0e0 25%,transparent 0,transparent 75%,#e0e0e0 0,#e0e0e0)',
      backgroundPosition: '0 0,25px 25px',
      backgroundSize: '50px 50px',
      boxShadow: 'inset 0 0 0 1px rgb(0 0 0 / 20%)',
      cursor: 'pointer'
    };
    var defaultbtnStyle = {
      backgroundImage: 'repeating-linear-gradient(45deg,#e0e0e0 25%,transparent 0,transparent 75%,#e0e0e0 0,#e0e0e0),repeating-linear-gradient(45deg,#e0e0e0 25%,transparent 0,transparent 75%,#e0e0e0 0,#e0e0e0)',
      backgroundPosition: '0 0,25px 25px',
      backgroundSize: '50px 50px',
      boxShadow: 'inset 0 0 0 1px rgb(0 0 0 / 20%)',
      cursor: 'pointer'
    };
    var btnStyle = {
      backgroundColor: val,
      boxShadow: 'inset 0 0 0 1px rgb(0 0 0 / 20%)',
      cursor: 'pointer'
    };
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "my-4",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("p", {
          className: "text-sm",
          children: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("This css property is depricated, please use", "accordions"), " ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("strong", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Background Color", "accordions")
          }), " ", (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("instead", "accordions")]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
          className: "relative h-10",
          style: placeholderStyle,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
            className: "absolute w-full  h-full top-0 left-0 text-center",
            style: btnStyle,
            onClick: this.handleToggleClick,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
              className: "w-full text-center left-0 top-1/2 -translate-y-1/2\t absolute",
              children: val == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Set Color', "accordions") : val
            })
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(Html, {
        enableAlpha: enableAlpha,
        value: val,
        onChange: onChange,
        warn: this.state.showWarning
      })]
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBgColor);

/***/ }),

/***/ "./src/components/css-border-bottom/index.js":
/*!***************************************************!*\
  !*** ./src/components/css-border-bottom/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/input-color-picker */ "./src/components/input-color-picker/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component,
  RawHTML
} = wp.element;







function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valParts = props.val != undefined ? props.val.split(" ") : ["0px", "solid", "#000000"];
  var widthVal = valParts[0] != undefined ? valParts[0] : "0px";
  var styleVal = valParts[1] != undefined ? valParts[1] : "solid";
  var colorVal = valParts[2] != undefined ? valParts[2] : "#000000";
  var outlineStyleArgs = {
    none: {
      label: "None",
      value: "none"
    },
    hidden: {
      label: "Hidden",
      value: "hidden"
    },
    dotted: {
      label: "Dotted",
      value: "dotted"
    },
    dashed: {
      label: "Dashed",
      value: "dashed"
    },
    solid: {
      label: "Solid",
      value: "solid"
    },
    double: {
      label: "Double",
      value: "double"
    },
    groove: {
      label: "Groove",
      value: "groove"
    },
    ridge: {
      label: "Ridge",
      value: "ridge"
    },
    inset: {
      label: "Inset",
      value: "inset"
    },
    outset: {
      label: "Outset",
      value: "outset"
    }
  };
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    // "%": { "label": "%", "value": "%" },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
    // none: { "label": "none", "value": "none" },
    // inherit: { "label": "inherit", "value": "inherit" },
    // initial: { "label": "initial", "value": "initial" },
    // revert: { "label": "revert", "value": "revert" },
    // unset: { "label": "unset", "value": "unset" },
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = widthVal.match(/-?\d+/g) != null ? widthVal.match(/-?\d+/g)[0] : 1;
  var widthUnitX = widthVal.match(/[a-zA-Z%]+/g) != null ? widthVal.match(/[a-zA-Z%]+/g)[0] : "px";
  const [widthValY, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnitY, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  const [outlineWidthVal, setoutlineWidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthVal);
  const [outlineStyleVal, setoutlineStyleVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(styleVal);
  const [outlineColorVal, setoutlineColorVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(colorVal);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "my-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Width", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "flex justify-between items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
          value: widthValY,
          type: "number",
          onChange: newVal => {
            setwidthVal(newVal);
            props.onChange(newVal + widthUnitY + " " + styleVal + " " + colorVal, "borderBottom");
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
            position: "bottom right",
            renderToggle: ({
              isOpen,
              onToggle
            }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
              title: "",
              onClick: onToggle,
              "aria-expanded": isOpen,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                className: " ",
                children: widthUnitY != undefined ? unitArgs[widthUnitY].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
              })
            }),
            renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "w-32",
              children: Object.entries(unitArgs).map(y => {
                var index = y[0];
                var x = y[1];
                return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                  className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
                  onClick: ev => {
                    setwidthUnit(x.value);
                    props.onChange(widthValY + x.value + " " + styleVal + " " + colorVal, "borderBottom");
                  },
                  children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                    children: x.label
                  })
                });
              })
            })
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "my-2 flex justify-between items-center",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Style", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom right",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            className: " ",
            children: outlineStyleVal ? outlineStyleArgs[outlineStyleVal].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "w-32",
          children: Object.entries(outlineStyleArgs).map(arg => {
            var index = arg[0];
            var x = arg[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                props.onChange(widthVal + " " + x.value + " " + colorVal, "borderBottom");
                setoutlineStyleVal(x.value);
              },
              children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
              }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                children: x.label
              })]
            });
          })
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
      htmlFor: "",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Color", "accordions")
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__["default"], {
      value: outlineColorVal,
      colors: _colors_presets__WEBPACK_IMPORTED_MODULE_3__["default"],
      enableAlpha: true,
      onChange: newVal => {
        props.onChange(widthVal + " " + styleVal + " " + newVal, "borderBottom");
        setoutlineColorVal(newVal);
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(widthVal + " " + styleVal + " " + colorVal, "borderBottom");
        } else {
          props.onChange(widthVal + " " + styleVal + " " + colorVal + " !important", "borderBottom");
        }
      }
    })]
  });
}
class PGcssBorderBottom extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBorderBottom);

/***/ }),

/***/ "./src/components/css-border-collapse/index.js":
/*!*****************************************************!*\
  !*** ./src/components/css-border-collapse/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    separate: {
      label: "Separate",
      value: "separate"
    },
    collapse: {
      label: "Collapse",
      value: "collapse"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Empty Cells", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // props.onChange(x.value, 'borderCollapse');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "borderCollapse");
              } else {
                props.onChange(x.value, "borderCollapse");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "borderCollapse");
        } else {
          props.onChange(align + " !important", "borderCollapse");
        }
      }
    })]
  });
}
class PGcssBorderCollapse extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBorderCollapse);

/***/ }),

/***/ "./src/components/css-border-image/index.js":
/*!**************************************************!*\
  !*** ./src/components/css-border-image/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _components_input_color_picker__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../components/input-color-picker */ "./src/components/input-color-picker/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
const {
  Component,
  RawHTML
} = wp.element;












function Html(props) {
  if (!props.warn) {
    return null;
  }
  const ALLOWED_MEDIA_TYPES = ["image"];
  var valZ = props.val == undefined || props.val == null || props.val.length == 0 ? "url(border.png)  1 1 1 1/  10px 10px 10px 10px /  0px 0px 0px 0px  round" : props.val;
  var source = valZ == undefined ? "" : valZ.split("  ")[0];
  var slice = valZ == undefined ? 10 : valZ.split("  ")[1].replace("/", "");
  var width = valZ == undefined ? 10 : valZ.split("  ")[2].replace("/", "");
  var outset = valZ == undefined ? 10 : valZ.split("  ")[3];
  var repeat = valZ == undefined ? "" : valZ.split("  ")[4];
  slice = slice.replaceAll(" ", "px ");
  slice = slice + "px";
  var imageVal = source.replace('url("', "");
  imageVal = imageVal.replace('")', "");
  const [type, setType] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)("linear");
  const [linearGradientValue, setLinearGradientValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)("linear-gradient(135deg,#12c2e9 0%,#c471ed 50%,#f64f59 100%)");
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Source", "accordions")
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "my-4",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 pg-font ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select Source", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
        options: [{
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Linear Gradient", "accordions"),
          value: "linear"
        }, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Image", "accordions"),
          value: "image"
        }],
        values: "",
        onChange: newVal => {
          setType(newVal);
        }
      })]
    }), type === "linear" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.GradientPicker, {
      value: linearGradientValue,
      onChange: currentGradient => {
        setLinearGradientValue(currentGradient);
        var sliceX = slice.replaceAll("px", "");
        props.onChange(currentGradient + sliceX + "/  " + width + "/  " + outset + "  " + repeat, "borderImage");
      },
      gradients: [{
        name: "JShine",
        gradient: "linear-gradient(135deg,#12c2e9 0%,#c471ed 50%,#f64f59 100%)",
        slug: "jshine"
      }, {
        name: "Moonlit Asteroid",
        gradient: "linear-gradient(135deg,#0F2027 0%, #203A43 0%, #2c5364 100%)",
        slug: "moonlit-asteroid"
      }, {
        name: "Rastafarie",
        gradient: "linear-gradient(135deg,#1E9600 0%, #FFF200 0%, #FF0000 100%)",
        slug: "rastafari"
      }]
    }), type === "image" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
        className: "my-3",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("img", {
          src: imageVal,
          alt: ""
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
        className: "mr-2",
        value: imageVal.replace("url(", "").replace(")", ""),
        placeholder: "Image URL",
        onChange: newVal => {
          var sliceX = slice.replaceAll("px", "");
          props.onChange("url(" + newVal + ")  " + sliceX + "/  " + width + "/  " + outset + "  " + repeat, "borderImage");
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__.MediaUploadCheck, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__.MediaUpload, {
          className: "bg-gray-700 hover:bg-gray-600",
          onSelect: media => {
            // media.id
            var sliceX = slice.replaceAll("px", "");
            props.onChange("url(" + media.url + ")  " + sliceX + "/  " + width + "/  " + outset + "  " + repeat, "borderImage");
          },
          onClose: () => {},
          allowedTypes: ALLOWED_MEDIA_TYPES,
          render: ({
            open
          }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
            className: "my-3 bg-gray-700 hover:bg-gray-600 text-white border border-solid border-gray-300 text-center w-full",
            onClick: open,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Open Media Library", "accordions")
          })
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Slice", "accordions")
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalBoxControl, {
      label: "",
      values: {
        top: slice.split(" ")[0],
        right: slice.split(" ")[1],
        bottom: slice.split(" ")[2],
        left: slice.split(" ")[3]
      },
      onChange: nextValues => {
        var top = parseInt(nextValues.top);
        var right = parseInt(nextValues.right);
        var bottom = parseInt(nextValues.bottom);
        var left = parseInt(nextValues.left);
        var sliceX = top + " " + right + " " + bottom + " " + left;
        props.onChange(source + "  " + sliceX + "/  " + width + "/  " + outset + "  " + repeat, "borderImage");
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Width", "accordions")
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalBoxControl, {
      label: "",
      values: {
        top: width.split(" ")[0],
        right: width.split(" ")[1],
        bottom: width.split(" ")[2],
        left: width.split(" ")[3]
      },
      onChange: nextValues => {
        var sliceX = slice.replaceAll("px", "");
        var top = nextValues.top;
        var right = nextValues.right;
        var bottom = nextValues.bottom;
        var left = nextValues.left;
        var widthX = top + " " + right + " " + bottom + " " + left;
        props.onChange(source + "  " + sliceX + "/  " + widthX + "/  " + outset + "  " + repeat, "borderImage");
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Outset", "accordions")
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalBoxControl, {
      label: "",
      values: {
        top: outset.split(" ")[0],
        right: outset.split(" ")[1],
        bottom: outset.split(" ")[2],
        left: outset.split(" ")[3]
      },
      onChange: nextValues => {
        var sliceX = slice.replaceAll("px", "");
        var top = nextValues.top;
        var right = nextValues.right;
        var bottom = nextValues.bottom;
        var left = nextValues.left;
        var outsetX = top + " " + right + " " + bottom + " " + left;
        props.onChange(source + "  " + sliceX + "/  " + width + "/  " + outsetX + "  " + repeat, "borderImage");
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Repeat", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
        label: "",
        value: repeat,
        options: [{
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Stretch", "accordions"),
          value: "stretch"
        }, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Repeat", "accordions"),
          value: "repeat"
        }, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Round", "accordions"),
          value: "round"
        }, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Space", "accordions"),
          value: "space"
        }, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Fill", "accordions"),
          value: "fill"
        }],
        onChange: newVal => {
          var sliceX = slice.replaceAll("px", "");
          props.onChange(source + "  " + sliceX + "/  " + width + "/  " + outset + "  " + newVal, "borderImage");
        }
      })]
    })]
  });
}
class PGcssBorderImage extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBorderImage);

/***/ }),

/***/ "./src/components/css-border-left/index.js":
/*!*************************************************!*\
  !*** ./src/components/css-border-left/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/input-color-picker */ "./src/components/input-color-picker/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component,
  RawHTML
} = wp.element;







function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valParts = props.val != undefined ? props.val.split(" ") : ["0px", "solid", "#000000"];
  var widthVal = valParts[0] != undefined ? valParts[0] : "0px";
  var styleVal = valParts[1] != undefined ? valParts[1] : "solid";
  var colorVal = valParts[2] != undefined ? valParts[2] : "#000000";
  var outlineStyleArgs = {
    none: {
      label: "None",
      value: "none"
    },
    hidden: {
      label: "Hidden",
      value: "hidden"
    },
    dotted: {
      label: "Dotted",
      value: "dotted"
    },
    dashed: {
      label: "Dashed",
      value: "dashed"
    },
    solid: {
      label: "Solid",
      value: "solid"
    },
    double: {
      label: "Double",
      value: "double"
    },
    groove: {
      label: "Groove",
      value: "groove"
    },
    ridge: {
      label: "Ridge",
      value: "ridge"
    },
    inset: {
      label: "Inset",
      value: "inset"
    },
    outset: {
      label: "Outset",
      value: "outset"
    }
  };
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    // "%": { "label": "%", "value": "%" },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
    // none: { "label": "none", "value": "none" },
    // inherit: { "label": "inherit", "value": "inherit" },
    // initial: { "label": "initial", "value": "initial" },
    // revert: { "label": "revert", "value": "revert" },
    // unset: { "label": "unset", "value": "unset" },
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = widthVal.match(/-?\d+/g) != null ? widthVal.match(/-?\d+/g)[0] : 1;
  var widthUnitX = widthVal.match(/[a-zA-Z%]+/g) != null ? widthVal.match(/[a-zA-Z%]+/g)[0] : "px";
  const [widthValY, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnitY, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  const [outlineWidthVal, setoutlineWidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthVal);
  const [outlineStyleVal, setoutlineStyleVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(styleVal);
  const [outlineColorVal, setoutlineColorVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(colorVal);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "my-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Width", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "flex justify-between items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
          value: widthValY,
          type: "number",
          onChange: newVal => {
            setwidthVal(newVal);
            props.onChange(newVal + widthUnitY + " " + styleVal + " " + colorVal, "borderLeft");
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
            position: "bottom right",
            renderToggle: ({
              isOpen,
              onToggle
            }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
              title: "",
              onClick: onToggle,
              "aria-expanded": isOpen,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                className: " ",
                children: widthUnitY != undefined ? unitArgs[widthUnitY].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
              })
            }),
            renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "w-32",
              children: Object.entries(unitArgs).map(y => {
                var index = y[0];
                var x = y[1];
                return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                  className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
                  onClick: ev => {
                    setwidthUnit(x.value);
                    props.onChange(widthValY + x.value + " " + styleVal + " " + colorVal, "borderLeft");
                  },
                  children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                    children: x.label
                  })
                });
              })
            })
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "my-2 flex justify-between items-center",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Style", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom right",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            className: " ",
            children: outlineStyleVal ? outlineStyleArgs[outlineStyleVal].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "w-32",
          children: Object.entries(outlineStyleArgs).map(arg => {
            var index = arg[0];
            var x = arg[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                props.onChange(widthVal + " " + x.value + " " + colorVal, "borderLeft");
                setoutlineStyleVal(x.value);
              },
              children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
              }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                children: x.label
              })]
            });
          })
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
      htmlFor: "",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Color", "accordions")
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__["default"], {
      value: outlineColorVal,
      colors: _colors_presets__WEBPACK_IMPORTED_MODULE_3__["default"],
      enableAlpha: true,
      onChange: newVal => {
        props.onChange(widthVal + " " + styleVal + " " + newVal, "borderLeft");
        setoutlineColorVal(newVal);
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(outlineWidthVal + " " + outlineStyleVal + " " + outlineColorVal, "borderLeft");
        } else {
          props.onChange(outlineWidthVal + " " + outlineStyleVal + " " + outlineColorVal + " !important", "borderLeft");
        }
      }
    })]
  });
}
class PGcssBorderLeft extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBorderLeft);

/***/ }),

/***/ "./src/components/css-border-radius/index.js":
/*!***************************************************!*\
  !*** ./src/components/css-border-radius/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component,
  RawHTML
} = wp.element;









function Html(props) {
  if (!props.warn) {
    return null;
  }
  var important = "";
  if (typeof props.val == "object") {
    var topX = props.val.top;
    var rightX = props.val.right;
    var bottomX = props.val.bottom;
    var leftX = props.val.left;
    var important = "";
  } else {
    var valParts = props.val != undefined ? props.val.split(" ") : ["5px", "5px", "5px", "5px", ""];
    var topX = valParts[0];
    var rightX = valParts[1];
    var bottomX = valParts[2];
    var leftX = valParts[3];
    var important = valParts[4];
  }
  const [valX, setvalX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({
    top: topX,
    right: rightX,
    bottom: bottomX,
    left: leftX
  });
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valParts.includes("!important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalBoxControl, {
      label: "",
      values: valX,
      onChange: nextValues => {
        // setvalX({ top: nextValues.top, right: nextValues.right, bottom: nextValues.bottom, left: nextValues.left })
        // props.onChange(nextValues.top + ' ' + nextValues.right + ' ' + nextValues.bottom + ' ' + nextValues.left, 'borderRadius');
        setvalX({
          top: nextValues.top,
          right: nextValues.right,
          bottom: nextValues.bottom,
          left: nextValues.left
        });
        if (isImportant) {
          props.onChange(nextValues.top + " " + nextValues.right + " " + nextValues.bottom + " " + nextValues.left + " !important", "borderRadius");
        } else {
          props.onChange(nextValues.top + " " + nextValues.right + " " + nextValues.bottom + " " + nextValues.left, "borderRadius");
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(valX.top + " " + valX.right + " " + valX.bottom + " " + valX.left, "borderRadius");
        } else {
          props.onChange(valX.top + " " + valX.right + " " + valX.bottom + " " + valX.left + " !important", "borderRadius");
        }
      }
    })]
  });
}
class PGcssBorderRadius extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBorderRadius);

/***/ }),

/***/ "./src/components/css-border-right/index.js":
/*!**************************************************!*\
  !*** ./src/components/css-border-right/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/input-color-picker */ "./src/components/input-color-picker/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component,
  RawHTML
} = wp.element;







function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valParts = props.val != undefined ? props.val.split(" ") : ["0px", "solid", "#000000"];
  var widthVal = valParts[0] != undefined ? valParts[0] : "0px";
  var styleVal = valParts[1] != undefined ? valParts[1] : "solid";
  var colorVal = valParts[2] != undefined ? valParts[2] : "#000000";
  var outlineStyleArgs = {
    none: {
      label: "None",
      value: "none"
    },
    hidden: {
      label: "Hidden",
      value: "hidden"
    },
    dotted: {
      label: "Dotted",
      value: "dotted"
    },
    dashed: {
      label: "Dashed",
      value: "dashed"
    },
    solid: {
      label: "Solid",
      value: "solid"
    },
    double: {
      label: "Double",
      value: "double"
    },
    groove: {
      label: "Groove",
      value: "groove"
    },
    ridge: {
      label: "Ridge",
      value: "ridge"
    },
    inset: {
      label: "Inset",
      value: "inset"
    },
    outset: {
      label: "Outset",
      value: "outset"
    }
  };
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    // "%": { "label": "%", "value": "%" },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
    // none: { "label": "none", "value": "none" },
    // inherit: { "label": "inherit", "value": "inherit" },
    // initial: { "label": "initial", "value": "initial" },
    // revert: { "label": "revert", "value": "revert" },
    // unset: { "label": "unset", "value": "unset" },
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = widthVal.match(/-?\d+/g) != null ? widthVal.match(/-?\d+/g)[0] : 1;
  var widthUnitX = widthVal.match(/[a-zA-Z%]+/g) != null ? widthVal.match(/[a-zA-Z%]+/g)[0] : "px";
  const [widthValY, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnitY, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  const [outlineWidthVal, setoutlineWidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthVal);
  const [outlineStyleVal, setoutlineStyleVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(styleVal);
  const [outlineColorVal, setoutlineColorVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(colorVal);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "my-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Width", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "flex justify-between items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
          value: widthValY,
          type: "number",
          onChange: newVal => {
            setwidthVal(newVal);
            props.onChange(newVal + widthUnitY + " " + styleVal + " " + colorVal, "borderRight");
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
            position: "bottom right",
            renderToggle: ({
              isOpen,
              onToggle
            }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
              title: "",
              onClick: onToggle,
              "aria-expanded": isOpen,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                className: " ",
                children: widthUnitY != undefined ? unitArgs[widthUnitY].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
              })
            }),
            renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "w-32",
              children: Object.entries(unitArgs).map(y => {
                var index = y[0];
                var x = y[1];
                return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                  className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
                  onClick: ev => {
                    setwidthUnit(x.value);
                    props.onChange(widthValY + x.value + " " + styleVal + " " + colorVal, "borderRight");
                  },
                  children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                    children: x.label
                  })
                });
              })
            })
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "my-2 flex justify-between items-center",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Style", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom right",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            className: " ",
            children: outlineStyleVal ? outlineStyleArgs[outlineStyleVal].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "w-32",
          children: Object.entries(outlineStyleArgs).map(arg => {
            var index = arg[0];
            var x = arg[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                props.onChange(widthVal + " " + x.value + " " + colorVal, "borderRight");
                setoutlineStyleVal(x.value);
              },
              children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
              }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                children: x.label
              })]
            });
          })
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
      htmlFor: "",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Color", "accordions")
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__["default"], {
      value: outlineColorVal,
      colors: _colors_presets__WEBPACK_IMPORTED_MODULE_3__["default"],
      enableAlpha: true,
      onChange: newVal => {
        props.onChange(widthVal + " " + styleVal + " " + newVal, "borderRight");
        setoutlineColorVal(newVal);
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(outlineWidthVal + " " + outlineStyleVal + " " + outlineColorVal, "borderRight");
        } else {
          props.onChange(outlineWidthVal + " " + outlineStyleVal + " " + outlineColorVal + " !important", "borderRight");
        }
      }
    })]
  });
}
class PGcssBorderRight extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBorderRight);

/***/ }),

/***/ "./src/components/css-border-spacing/index.js":
/*!****************************************************!*\
  !*** ./src/components/css-border-spacing/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
const {
  Component,
  RawHTML
} = wp.element;






function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "1px 1px #000000" : props.val;
  var valParts = valZ != undefined ? valZ.split(" ") : ["1px", "1px", "#000000"];
  var horizontalVal = valParts[0];
  var vericalVal = valParts[1];
  var colorVal = valParts[2];
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    // auto: { "label": "AUTO", "value": "auto" },
    // "%": { "label": "%", "value": "%" },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    }
  };
  var horizontalValX = horizontalVal != undefined ? horizontalVal.match(/-?\d+/g)[0] : 1;
  var horizontalUnitX = horizontalVal != undefined ? horizontalVal.match(/[a-zA-Z%]+/g)[0] : "px";
  var vericalValX = vericalVal != undefined ? vericalVal.match(/-?\d+/g)[0] : 1;
  var vericalUnitX = vericalVal != undefined ? vericalVal.match(/[a-zA-Z%]+/g)[0] : "px";
  const [horizontalValY, sethorizontalVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(horizontalValX);
  const [horizontalUnitY, sethorizontalUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(horizontalUnitX);
  const [vericalValY, setvericalVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(vericalValX);
  const [vericalUnitY, setvericalUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(vericalUnitX);
  const [outlinehorizontalVal, setoutlinehorizontalVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(horizontalVal);
  const [outlinevericalVal, setoutlinevericalVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(vericalVal);
  const [outlineColorVal, setoutlineColorVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(colorVal);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "grid grid-cols-2 gap-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "my-2",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("label", {
          htmlFor: "",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Horizontal", "accordions")
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
          className: "flex justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
            value: horizontalValY,
            type: "number",
            onChange: newVal => {
              sethorizontalVal(newVal);
              props.onChange(newVal + horizontalUnitY + " " + outlinevericalVal, "borderSpacing");
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
              position: "bottom right",
              renderToggle: ({
                isOpen,
                onToggle
              }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
                title: "",
                onClick: onToggle,
                "aria-expanded": isOpen,
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                  className: " ",
                  children: horizontalUnitY != undefined ? unitArgs[horizontalUnitY].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
                })
              }),
              renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                className: "w-32",
                children: Object.entries(unitArgs).map(y => {
                  var index = y[0];
                  var x = y[1];
                  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                    className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
                    onClick: ev => {
                      sethorizontalUnit(x.value);
                      props.onChange(horizontalValY + x.value + " " + outlinevericalVal, "borderSpacing");
                    },
                    children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
                      children: x.label
                    })
                  });
                })
              })
            })
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "my-2",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("label", {
          htmlFor: "",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Verical", "accordions")
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
          className: "flex justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
            value: vericalValY,
            type: "number",
            onChange: newVal => {
              setvericalVal(newVal);
              props.onChange(outlinehorizontalVal + " " + newVal + vericalUnitY, "borderSpacing");
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
              position: "bottom right",
              renderToggle: ({
                isOpen,
                onToggle
              }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
                title: "",
                onClick: onToggle,
                "aria-expanded": isOpen,
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                  className: " ",
                  children: vericalUnitY != undefined ? unitArgs[vericalUnitY].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
                })
              }),
              renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                className: "w-32",
                children: Object.entries(unitArgs).map(y => {
                  var index = y[0];
                  var x = y[1];
                  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
                    className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
                    onClick: ev => {
                      setvericalUnit(x.value);
                      props.onChange(outlinehorizontalVal + " " + vericalValY + x.value, "borderSpacing");
                    },
                    children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
                      children: x.label
                    })
                  });
                })
              })
            })
          })]
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(horizontalVal + " " + vericalVal + " ", "borderSpacing");
        } else {
          props.onChange(horizontalVal + " " + vericalVal + " " + " !important", "borderSpacing");
        }
      }
    })]
  });
}
class PGcssBorderSpacing extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    var args = {
      fill: {
        label: "fill",
        value: "fill"
      },
      contain: {
        label: "contain",
        value: "contain"
      },
      cover: {
        label: "cover",
        value: "cover"
      },
      "scale-down": {
        label: "scale-down",
        value: "scale-down"
      },
      none: {
        label: "none",
        value: "none"
      }
    };
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBorderSpacing);

/***/ }),

/***/ "./src/components/css-border-top/index.js":
/*!************************************************!*\
  !*** ./src/components/css-border-top/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/input-color-picker */ "./src/components/input-color-picker/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component,
  RawHTML
} = wp.element;







function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valParts = props.val != undefined ? props.val.split(" ") : ["0px", "solid", "#000000"];
  var widthVal = valParts[0] != undefined ? valParts[0] : "0px";
  var styleVal = valParts[1] != undefined ? valParts[1] : "solid";
  var colorVal = valParts[2] != undefined ? valParts[2] : "#000000";
  var outlineStyleArgs = {
    none: {
      label: "None",
      value: "none"
    },
    hidden: {
      label: "Hidden",
      value: "hidden"
    },
    dotted: {
      label: "Dotted",
      value: "dotted"
    },
    dashed: {
      label: "Dashed",
      value: "dashed"
    },
    solid: {
      label: "Solid",
      value: "solid"
    },
    double: {
      label: "Double",
      value: "double"
    },
    groove: {
      label: "Groove",
      value: "groove"
    },
    ridge: {
      label: "Ridge",
      value: "ridge"
    },
    inset: {
      label: "Inset",
      value: "inset"
    },
    outset: {
      label: "Outset",
      value: "outset"
    }
  };
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    // "%": { "label": "%", "value": "%" },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
    // none: { "label": "none", "value": "none" },
    // inherit: { "label": "inherit", "value": "inherit" },
    // initial: { "label": "initial", "value": "initial" },
    // revert: { "label": "revert", "value": "revert" },
    // unset: { "label": "unset", "value": "unset" },
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = widthVal.match(/-?\d+/g) != null ? widthVal.match(/-?\d+/g)[0] : 1;
  var widthUnitX = widthVal.match(/[a-zA-Z%]+/g) != null ? widthVal.match(/[a-zA-Z%]+/g)[0] : "px";
  const [widthValY, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnitY, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  const [outlineWidthVal, setoutlineWidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthVal);
  const [outlineStyleVal, setoutlineStyleVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(styleVal);
  const [outlineColorVal, setoutlineColorVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(colorVal);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "my-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Width", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "flex justify-between items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
          value: widthValY,
          type: "number",
          onChange: newVal => {
            setwidthVal(newVal);
            props.onChange(newVal + widthUnitY + " " + styleVal + " " + colorVal, "borderTop");
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
            position: "bottom right",
            renderToggle: ({
              isOpen,
              onToggle
            }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
              title: "",
              onClick: onToggle,
              "aria-expanded": isOpen,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                className: " ",
                children: widthUnitY != undefined ? unitArgs[widthUnitY].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
              })
            }),
            renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "w-32",
              children: Object.entries(unitArgs).map(y => {
                var index = y[0];
                var x = y[1];
                return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                  className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
                  onClick: ev => {
                    setwidthUnit(x.value);
                    props.onChange(widthValY + x.value + " " + styleVal + " " + colorVal, "borderTop");
                  },
                  children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                    children: x.label
                  })
                });
              })
            })
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "my-2 flex justify-between items-center",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Style", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom right",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            className: " ",
            children: outlineStyleVal ? outlineStyleArgs[outlineStyleVal].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "w-32",
          children: Object.entries(outlineStyleArgs).map(arg => {
            var index = arg[0];
            var x = arg[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                props.onChange(widthVal + " " + x.value + " " + colorVal, "borderTop");
                setoutlineStyleVal(x.value);
              },
              children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
              }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                children: x.label
              })]
            });
          })
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
      htmlFor: "",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Color", "accordions")
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__["default"], {
      value: outlineColorVal,
      colors: _colors_presets__WEBPACK_IMPORTED_MODULE_3__["default"],
      enableAlpha: true,
      onChange: newVal => {
        props.onChange(widthVal + " " + styleVal + " " + newVal, "borderTop");
        setoutlineColorVal(newVal);
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(widthVal + " " + styleVal + " " + colorVal, "borderTop");
        } else {
          props.onChange(widthVal + " " + styleVal + " " + colorVal + " !important", "borderTop");
        }
      }
    })]
  });
}
class PGcssBorderTop extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBorderTop);

/***/ }),

/***/ "./src/components/css-border/index.js":
/*!********************************************!*\
  !*** ./src/components/css-border/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/input-color-picker */ "./src/components/input-color-picker/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component,
  RawHTML
} = wp.element;







function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valParts = props.val != undefined ? props.val.split(" ") : ["0px", "solid", "#000000"];
  var widthVal = valParts[0] != undefined ? valParts[0] : "0px";
  var styleVal = valParts[1] != undefined ? valParts[1] : "solid";
  var colorVal = valParts[2] != undefined ? valParts[2] : "#000000";
  var outlineStyleArgs = {
    none: {
      label: "None",
      value: "none"
    },
    hidden: {
      label: "Hidden",
      value: "hidden"
    },
    dotted: {
      label: "Dotted",
      value: "dotted"
    },
    dashed: {
      label: "Dashed",
      value: "dashed"
    },
    solid: {
      label: "Solid",
      value: "solid"
    },
    double: {
      label: "Double",
      value: "double"
    },
    groove: {
      label: "Groove",
      value: "groove"
    },
    ridge: {
      label: "Ridge",
      value: "ridge"
    },
    inset: {
      label: "Inset",
      value: "inset"
    },
    outset: {
      label: "Outset",
      value: "outset"
    }
  };
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    // "%": { "label": "%", "value": "%" },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
    // none: { "label": "none", "value": "none" },
    // inherit: { "label": "inherit", "value": "inherit" },
    // initial: { "label": "initial", "value": "initial" },
    // revert: { "label": "revert", "value": "revert" },
    // unset: { "label": "unset", "value": "unset" },
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = widthVal.match(/-?\d+/g) != null ? widthVal.match(/-?\d+/g)[0] : 1;
  var widthUnitX = widthVal.match(/[a-zA-Z%]+/g) != null ? widthVal.match(/[a-zA-Z%]+/g)[0] : "px";
  const [widthValY, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnitY, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  const [outlineWidthVal, setoutlineWidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthVal);
  const [outlineStyleVal, setoutlineStyleVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(styleVal);
  const [outlineColorVal, setoutlineColorVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(colorVal);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "my-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Width", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "flex justify-between items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
          value: widthValY,
          type: "number",
          onChange: newVal => {
            setwidthVal(newVal);
            props.onChange(newVal + widthUnitY + " " + styleVal + " " + colorVal, "border");
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
            position: "bottom right",
            renderToggle: ({
              isOpen,
              onToggle
            }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
              title: "",
              onClick: onToggle,
              "aria-expanded": isOpen,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                className: " ",
                children: widthUnitY != undefined ? unitArgs[widthUnitY].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
              })
            }),
            renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "w-32",
              children: Object.entries(unitArgs).map(y => {
                var index = y[0];
                var x = y[1];
                return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                  className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
                  onClick: ev => {
                    setwidthUnit(x.value);
                    props.onChange(widthValY + x.value + " " + styleVal + " " + colorVal, "border");
                  },
                  children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                    children: x.label
                  })
                });
              })
            })
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "my-2 flex justify-between items-center",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Style", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom right",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            className: " ",
            children: outlineStyleVal ? outlineStyleArgs[outlineStyleVal].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "w-32",
          children: Object.entries(outlineStyleArgs).map(arg => {
            var index = arg[0];
            var x = arg[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                props.onChange(widthVal + " " + x.value + " " + colorVal, "border");
                setoutlineStyleVal(x.value);
              },
              children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
              }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                children: x.label
              })]
            });
          })
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
      htmlFor: "",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Border Color", "accordions")
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__["default"], {
      value: outlineColorVal,
      colors: _colors_presets__WEBPACK_IMPORTED_MODULE_3__["default"],
      enableAlpha: true,
      onChange: newVal => {
        props.onChange(widthVal + " " + styleVal + " " + newVal, "border");
        setoutlineColorVal(newVal);
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(widthVal + " " + styleVal + " " + colorVal, "border");
        } else {
          props.onChange(widthVal + " " + styleVal + " " + colorVal + " !important", "border");
        }
      }
    })]
  });
}
class PGcssBorder extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBorder);

/***/ }),

/***/ "./src/components/css-bottom/index.js":
/*!********************************************!*\
  !*** ./src/components/css-bottom/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    auto: {
      label: "AUTO",
      value: "auto"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  if (typeof props.val == "object") {
    var valZ = props.val.val + props.val.unit;
  } else {
    var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  }
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  var widthUnitX = valZ == undefined || valZ.match(/[a-zA-Z%]+/g) == null ? "px" : valZ.match(/[a-zA-Z%]+/g)[0];
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnit, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between",
    children: [widthUnit != "auto" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      disabled: widthUnit == "auto" ? true : false,
      onChange: newVal => {
        setwidthVal(newVal);
        if (widthUnit == "auto") {
          // props.onChange(widthUnit, 'width');
          if (isImportant) {
            props.onChange(widthUnit + " !important", "bottom");
          } else {
            props.onChange(widthUnit, "bottom");
          }
        } else {
          //props.onChange(newVal + widthUnit, 'width');
          if (isImportant) {
            props.onChange(newVal + widthUnit + " !important", "bottom");
          } else {
            props.onChange(newVal + widthUnit, "bottom");
          }
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: "",
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: " ",
            children: valZ ? unitArgs[widthUnit].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "w-32",
          children: Object.entries(unitArgs).map(y => {
            var index = y[0];
            var x = y[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                setwidthUnit(x.value);
                if (x.value == "auto") {
                  if (isImportant) {
                    props.onChange(x.value + " !important", "bottom");
                  } else {
                    props.onChange(x.value, "bottom");
                  }
                } else {
                  if (isImportant) {
                    props.onChange(widthVal + x.value + " !important", "bottom");
                  } else {
                    props.onChange(widthVal + x.value, "bottom");
                  }
                }
              },
              children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: x.label
              })
            });
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          if (widthUnit == "auto") {
            props.onChange(widthUnit, "bottom");
          } else {
            props.onChange(widthVal + widthUnit, "bottom");
          }
        } else {
          if (widthUnit == "auto") {
            props.onChange(widthUnit + " !important", "bottom");
          } else {
            props.onChange(widthVal + widthUnit + " !important", "bottom");
          }
        }
      }
    })]
  });
}
class PGcssBottom extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBottom);

/***/ }),

/***/ "./src/components/css-box-shadow/index.js":
/*!************************************************!*\
  !*** ./src/components/css-box-shadow/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_input_color_picker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../components/input-color-picker */ "./src/components/input-color-picker/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
const {
  Component,
  RawHTML
} = wp.element;








function Html(props) {
  if (!props.warn) {
    return null;
  }
  let isProFeature = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__.applyFilters)("isProFeature", true);
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px 0px 10px 5px #50547d4f" : props.val;
  // var valZ = (props.val == null || props.val == undefined || props.val.length == 0) ? '0px' : props.val;
  var colorNames = ["AliceBlue", "AntiqueWhite", "Aqua", "Aquamarine", "Azure", "Beige", "Bisque", "Black", "BlanchedAlmond", "Blue", "BlueViolet", "Brown", "BurlyWood", "CadetBlue", "Chartreuse", "Chocolate", "Coral", "CornflowerBlue", "Cornsilk", "Crimson", "Cyan", "DarkBlue", "DarkCyan", "DarkGoldenRod", "DarkGray", "DarkGrey", "DarkGreen", "DarkKhaki", "DarkMagenta", "DarkOliveGreen", "Darkorange", "DarkOrchid", "DarkRed", "DarkSalmon", "DarkSeaGreen", "DarkSlateBlue", "DarkSlateGray", "DarkSlateGrey", "DarkTurquoise", "DarkViolet", "DeepPink", "DeepSkyBlue", "DimGray", "DimGrey", "DodgerBlue", "FireBrick", "FloralWhite", "ForestGreen", "Fuchsia", "Gainsboro", "GhostWhite", "Gold", "GoldenRod", "Gray", "Grey", "Green", "GreenYellow", "HoneyDew", "HotPink", "IndianRed", "Indigo", "Ivory", "Khaki", "Lavender", "LavenderBlush", "LawnGreen", "LemonChiffon", "LightBlue", "LightCoral", "LightCyan", "LightGoldenRodYellow", "LightGray", "LightGrey", "LightGreen", "LightPink", "LightSalmon", "LightSeaGreen", "LightSkyBlue", "LightSlateGray", "LightSlateGrey", "LightSteelBlue", "LightYellow", "Lime", "LimeGreen", "Linen", "Magenta", "Maroon", "MediumAquaMarine", "MediumBlue", "MediumOrchid", "MediumPurple", "MediumSeaGreen", "MediumSlateBlue", "MediumSpringGreen", "MediumTurquoise", "MediumVioletRed", "MidnightBlue", "MintCream", "MistyRose", "Moccasin", "NavajoWhite", "Navy", "OldLace", "Olive", "OliveDrab", "Orange", "OrangeRed", "Orchid", "PaleGoldenRod", "PaleGreen", "PaleTurquoise", "PaleVioletRed", "PapayaWhip", "PeachPuff", "Peru", "Pink", "Plum", "PowderBlue", "Purple", "Red", "RosyBrown", "RoyalBlue", "SaddleBrown", "Salmon", "SandyBrown", "SeaGreen", "SeaShell", "Sienna", "Silver", "SkyBlue", "SlateBlue", "SlateGray", "SlateGrey", "Snow", "SpringGreen", "SteelBlue", "Tan", "Teal", "Thistle", "Tomato", "Turquoise", "Violet", "Wheat", "White", "WhiteSmoke", "Yellow", "YellowGreen"];
  var isMulti = valZ.split(",").length > 1 ? true : false;
  var shadows = isMulti ? valZ.split(", ") : [valZ];
  const getBoxShadowObj = boxshadow => {
    var sadhow_arr = [];
    boxshadow.map(arg => {
      var inset = arg.includes("inset");
      var color = "";
      var re = /(rgba|rgb|#|hsla|hsl)/;
      var colorMatch = arg.match(re);
      var colorType = colorMatch != null ? colorMatch[0] : "";
      if (colorType == "hsl") {
        var regex = /hsl\(([^)]+)\)/;
        var matches = arg.match(regex);
        if (matches && matches.length > 1) {
          var extractedValues = matches[1];
          color = "hsl(" + extractedValues + ")";
        }
      } else if (colorType == "hsla") {
        var regex = /hsla\(([^)]+)\)/;
        var matches = arg.match(regex);
        if (matches && matches.length > 1) {
          var extractedValues = matches[1];
          color = "hsla(" + extractedValues + ")";
        }
      } else if (colorType == "rgba") {
        var regex = /rgba\(([^)]+)\)/;
        var matches = arg.match(regex);
        if (matches && matches.length > 1) {
          var extractedValues = matches[1];
          color = "rgba(" + extractedValues + ")";
        }
      } else if (colorType == "rgb") {
        var regex = /rgb\(([^)]+)\)/;
        var matches = arg.match(regex);
        if (matches && matches.length > 1) {
          var extractedValues = matches[1];
          color = "rgb(" + extractedValues + ")";
        }
      } else if (colorType == "#") {
        var regex = /#\w+/;
        var matches = arg.match(regex);
        if (matches) {
          var color = matches[0];
        }
      } else {
        var regexPattern = new RegExp(colorNames.join("|").toLocaleLowerCase(), "g");
        var matches = arg.match(regexPattern);
        if (matches && matches.length > 0) {
          color = matches[0];
        }
      }
      var placement = arg;
      if (inset) {
        placement = placement.replace("inset", "");
      }
      if (color) {
        placement = placement.replace(color, "");
      }
      var placementArr = placement.trim().split(" ");
      if (placementArr.length == 2) {
        var h = placementArr[0];
        var v = placementArr[1];
        var blur = "";
        var spread = "";
      } else if (placementArr.length == 3) {
        var h = placementArr[0];
        var v = placementArr[1];
        var blur = placementArr[2];
        var spread = "";
      } else if (placementArr.length == 4) {
        var h = placementArr[0];
        var v = placementArr[1];
        var blur = placementArr[2];
        var spread = placementArr[3];
      }
      sadhow_arr.push({
        h: h,
        v: v,
        blur: blur,
        spread: spread,
        inset: inset,
        color: color
      });
    });
    return sadhow_arr;
  };
  const [shadowObj, setShadowObj] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(getBoxShadowObj(shadows));
  // const [shadowObj, setShadowObj] = useState(isProFeature ? shadows[0] :getBoxShadowObj(shadows));
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(valZ.includes(" !important") ? true : false);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    //props.onChange(newVal + 'px ' + v + 'px ' + blur + 'px ' + spread + 'px ' + color, 'boxShadow');
    var stringArr = [];
    shadowObj.map((shadow, index) => {
      var h = shadow.h;
      var v = shadow.v;
      var blur = shadow.blur;
      var spread = shadow.spread;
      var inset = shadow.inset ? "inset" : "";
      var color = shadow.color;
      var item = [h, v, blur, spread, color, inset];
      var filtered = item.filter(function (el) {
        return el;
      });
      stringArr.push(filtered.join(" "));
    });
    stringArr = stringArr.join(",  ");
    if (isImportant) {
      stringArr = stringArr + " !important";
    } else {
      stringArr = stringArr;
    }
    props.onChange(stringArr, "boxShadow");
  }, [shadowObj, isImportant]);
  var unitArgs = [{
    label: "PX",
    value: "px"
  }, {
    label: "EM",
    value: "em"
  }, {
    label: "REM",
    value: "rem"
  }, {
    label: "%",
    value: "%"
  }, {
    label: "CM",
    value: "cm"
  }, {
    label: "MM",
    value: "mm"
  }, {
    label: "IN",
    value: "in"
  }, {
    label: "PT",
    value: "pt"
  }, {
    label: "PC",
    value: "pc"
  }, {
    label: "EX",
    value: "ex"
  }, {
    label: "CH",
    value: "ch"
  }, {
    label: "VW",
    value: "vw"
  }, {
    label: "VH",
    value: "vh"
  }, {
    label: "VMIN",
    value: "vmin"
  }, {
    label: "VMAX",
    value: "vmax"
  }];
  const [proText, setProText] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
  const handleClick = () => {
    setProText(true);
    setTimeout(() => {
      setProText(false);
    }, 5000);
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("button", {
      className: "pg-font flex gap-2 justify-center my-2 cursor-pointer py-2 px-4 capitalize  bg-gray-700 text-white font-medium rounded hover:bg-gray-600 hover:text-white focus:outline-none focus:bg-gray-700",
      onClick: () => {
        if (isProFeature) {
          handleClick();
          return;
        }
        var shadowObjX = [...shadowObj];
        shadowObjX.push({
          h: "0px",
          v: "0px",
          blur: "10px",
          spread: "5px",
          inset: false,
          color: "#50547d4f"
        });
        setShadowObj(shadowObjX);
      },
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Add", "accordions")
    }), proText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
      href: "https://comboblocks.com/pricing/",
      className: "pg-text-color block py-2 px-1",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Subscribe to add multiple shadows.", "accordions")
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
      children: [shadowObj.map((shadow, index) => {
        var h = shadow.h;
        var v = shadow.v;
        var blur = shadow.blur;
        var spread = shadow.spread;
        var inset = shadow.inset;
        var color = shadow.color;
        var hVal = h.match(/-?\d+/g) == null ? 0 : h.match(/-?\d+/g)[0];
        var hUnit = h.match(/[a-zA-Z%]+/g) == null ? "px" : h.match(/[a-zA-Z%]+/g)[0];
        var vVal = v.match(/-?\d+/g) == null ? 0 : v.match(/-?\d+/g)[0];
        var vUnit = v.match(/[a-zA-Z%]+/g) == null ? "px" : v.match(/[a-zA-Z%]+/g)[0];
        var blurVal = blur.match(/-?\d+/g) == null ? 0 : blur.match(/-?\d+/g)[0];
        var blurUnit = blur.match(/[a-zA-Z%]+/g) == null ? "px" : blur.match(/[a-zA-Z%]+/g)[0];
        var spreadVal = spread.match(/-?\d+/g) == null ? 0 : spread.match(/-?\d+/g)[0];
        var spreadUnit = spread.match(/[a-zA-Z%]+/g) == null ? "px" : spread.match(/[a-zA-Z%]+/g)[0];
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
              className: "cursor-pointer hover:bg-red-500 hover:text-white ",
              onClick: ev => {
                var shadowObjX = [...shadowObj];
                shadowObjX.splice(index, 1);
                setShadowObj(shadowObjX);
              },
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"], {
                icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
              children: h + " " + v + " " + blur + " " + spread + " " + color + " " + (inset ? "inset" : "")
            })]
          })
          // title={
          // 	h +
          // 	" " +
          // 	v +
          // 	" " +
          // 	blur +
          // 	" " +
          // 	spread +
          // 	" " +
          // 	color +
          // 	" " +
          // 	(inset ? "inset" : "")
          // }
          ,
          initialOpen: false,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("label", {
              htmlFor: "",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("H-Offset", "accordions")
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalInputControl, {
              value: hVal,
              type: "number",
              onChange: newVal => {
                var shadowObjX = [...shadowObj];
                shadowObjX[index].h = newVal + hUnit;
                setShadowObj(shadowObjX);
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
              label: "",
              value: hUnit,
              options: unitArgs,
              onChange: newVal => {
                var shadowObjX = [...shadowObj];
                shadowObjX[index].h = hVal + newVal;
                setShadowObj(shadowObjX);
              }
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("label", {
              htmlFor: "",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("V-Offset", "accordions")
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalInputControl, {
              value: vVal,
              type: "number",
              onChange: newVal => {
                var shadowObjX = [...shadowObj];
                shadowObjX[index].v = newVal + vUnit;
                setShadowObj(shadowObjX);
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
              label: "",
              value: vUnit,
              options: unitArgs,
              onChange: newVal => {
                var shadowObjX = [...shadowObj];
                shadowObjX[index].v = vVal + newVal;
                setShadowObj(shadowObjX);
              }
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("label", {
              htmlFor: "",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Blur", "accordions")
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalInputControl, {
              value: blurVal,
              type: "number",
              onChange: newVal => {
                var shadowObjX = [...shadowObj];
                shadowObjX[index].blur = newVal + blurUnit;
                setShadowObj(shadowObjX);
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
              label: "",
              value: blurUnit,
              options: unitArgs,
              onChange: newVal => {
                var shadowObjX = [...shadowObj];
                shadowObjX[index].blur = blurVal + newVal;
                setShadowObj(shadowObjX);
              }
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("label", {
              htmlFor: "",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Spread", "accordions")
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.__experimentalInputControl, {
              value: spreadVal,
              type: "number",
              onChange: newVal => {
                var shadowObjX = [...shadowObj];
                shadowObjX[index].spread = newVal + spreadUnit;
                setShadowObj(shadowObjX);
              }
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.SelectControl, {
              label: "",
              value: spreadUnit,
              options: unitArgs,
              onChange: newVal => {
                var shadowObjX = [...shadowObj];
                shadowObjX[index].spread = spreadVal + newVal;
                setShadowObj(shadowObjX);
              }
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("label", {
              htmlFor: "",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Color", "accordions")
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_input_color_picker__WEBPACK_IMPORTED_MODULE_3__["default"], {
            value: color,
            colors: _colors_presets__WEBPACK_IMPORTED_MODULE_1__["default"],
            enableAlpha: true,
            onChange: newVal => {
              var shadowObjX = [...shadowObj];
              shadowObjX[index].color = newVal;
              setShadowObj(shadowObjX);
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
            help: inset ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Inset Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Inset ?", "accordions"),
            checked: inset,
            onChange: arg => {
              var shadowObjX = [...shadowObj];
              if (inset) {
                shadowObjX[index].inset = false;
              } else {
                shadowObjX[index].inset = true;
              }
              setShadowObj(shadowObjX);
            }
          })]
        });
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.ToggleControl, {
        help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
        checked: isImportant,
        onChange: arg => {
          setImportant(isImportant => !isImportant);
        }
      })]
    })]
  });
}
class PGcssBoxShadow extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBoxShadow);

/***/ }),

/***/ "./src/components/css-box-sizing/index.js":
/*!************************************************!*\
  !*** ./src/components/css-box-sizing/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    "border-box": {
      label: "border-box",
      value: "border-box"
    },
    "content-box": {
      label: "content-box",
      value: "content-box"
    }
    // none: { "label": "none", "value": "none" },
    // inherit: { "label": "inherit", "value": "inherit" },
    // initial: { "label": "initial", "value": "initial" },
    // revert: { "label": "revert", "value": "revert" },
    // unset: { "label": "unset", "value": "unset" },
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Box Sizing", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'boxSizing');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "boxSizing");
              } else {
                props.onChange(x.value, "boxSizing");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "boxSizing");
        } else {
          props.onChange(align + " !important", "boxSizing");
        }
      }
    })]
  });
}
class PGcssBoxSizing extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssBoxSizing);

/***/ }),

/***/ "./src/components/css-caption-side/index.js":
/*!**************************************************!*\
  !*** ./src/components/css-caption-side/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    top: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Top", "accordions"),
      value: "top"
    },
    bottom: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Bottom", "accordions"),
      value: "bottom"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Empty Cells", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // props.onChange(x.value, 'captionSide');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "captionSide");
              } else {
                props.onChange(x.value, "captionSide");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "captionSide");
        } else {
          props.onChange(align + " !important", "captionSide");
        }
      }
    })]
  });
}
class PGcssCaptionSide extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssCaptionSide);

/***/ }),

/***/ "./src/components/css-clear/index.js":
/*!*******************************************!*\
  !*** ./src/components/css-clear/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    none: {
      label: "None",
      value: "none"
    },
    left: {
      label: "Left",
      value: "left"
    },
    right: {
      label: "Right",
      value: "right"
    },
    both: {
      label: "Both",
      value: "both"
    },
    "inline-end": {
      label: "inline-end",
      value: "inline-end"
    },
    "inline-start": {
      label: "inline-start",
      value: "inline-start"
    }
    // inherit: { "label": "inherit", "value": "inherit" },
    // initial: { "label": "initial", "value": "initial" },
    // revert: { "label": "revert", "value": "revert" },
    // unset: { "label": "unset", "value": "unset" },
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'clear');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "clear");
              } else {
                props.onChange(x.value, "clear");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "clear");
        } else {
          props.onChange(align + " !important", "clear");
        }
      }
    })]
  });
}
class PGcssClear extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssClear);

/***/ }),

/***/ "./src/components/css-clip/index.js":
/*!******************************************!*\
  !*** ./src/components/css-clip/index.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component,
  RawHTML
} = wp.element;









function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valZ = props.val;
  if (typeof props.val == 'object') {
    var topX = props.val.top;
    var rightX = props.val.right;
    var bottomX = props.val.bottom;
    var leftX = props.val.left;
  } else {
    var valParts = props.val != undefined ? props.val.split(" ") : ['5px', '5px', '5px', '5px'];
    var topX = valParts[0];
    var rightX = valParts[1];
    var bottomX = valParts[2];
    var leftX = valParts[3];
  }
  const [valX, setvalX] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({
    top: topX,
    right: rightX,
    bottom: bottomX,
    left: leftX
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalBoxControl, {
      label: "",
      values: valX,
      onChange: nextValues => {
        setvalX({
          top: nextValues.top,
          right: nextValues.right,
          bottom: nextValues.bottom,
          left: nextValues.left
        });
        //nextValues.top + ' ' + nextValues.right + ' ' + nextValues.bottom + ' ' + nextValues.left
        props.onChange(nextValues.top + ' ' + nextValues.right + ' ' + nextValues.bottom + ' ' + nextValues.left, 'clip');
      }
    })
  });
}
class PGcssClip extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssClip);

/***/ }),

/***/ "./src/components/css-color/index.js":
/*!*******************************************!*\
  !*** ./src/components/css-color/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component
} = wp.element;






function Html(props) {
  if (!props.warn) {
    return null;
  }
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(props.val.split(" "));
  const [val, setval] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(valArgs[1] == undefined ? false : true);
  const [customColor, setCustomColor] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)([]);
  const [newColorPreset, setNewColorPreset] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)([]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    const transformedColors = customColor.map((color, index) => {
      const name = color.substring(1).toUpperCase();
      const upperCaseColor = color.toUpperCase();
      return {
        name,
        color: upperCaseColor
      };
    });
    // const newColor = transformedColors.concat(
    // 	colorsPresets.slice(0, 6 - transformedColors.length)
    // );
    let newColor;
    if (transformedColors.length >= 6) {
      newColor = transformedColors;
    } else {
      newColor = transformedColors.concat(_colors_presets__WEBPACK_IMPORTED_MODULE_2__["default"].slice(0, 6 - transformedColors.length));
    }
    setNewColorPreset(newColor);
  }, [customColor]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "p-2 relative",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
        className: "mb-2",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
          label: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
          checked: isImportant,
          className: "!mb-0",
          onChange: arg => {
            setImportant(isImportant => !isImportant);
            if (isImportant) {
              props.onChange(val, "color");
            } else {
              props.onChange(val + " !important", "color");
            }
          }
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ColorPalette, {
        value: val,
        colors: newColorPreset,
        enableAlpha: true,
        onChange: newVal => {
          //props.onChange(newVal, 'color');
          setval(newVal);
          if (isImportant) {
            props.onChange(newVal + " !important", "color");
          } else {
            props.onChange(newVal, "color");
          }
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
          htmlFor: "",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Global Value", "accordions")
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
          label: "",
          value: val,
          options: [{
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Choose", "accordions"),
            value: ""
          }, {
            label: "Inherit",
            value: "inherit"
          }, {
            label: "Initial",
            value: "initial"
          }, {
            label: "Revert",
            value: "revert"
          }, {
            label: "Revert-layer",
            value: "revert-layer"
          }, {
            label: "Unset",
            value: "unset"
          }],
          onChange: newVal => {
            setval(newVal);
            if (isImportant) {
              props.onChange(newVal + " !important", "color");
            } else {
              props.onChange(newVal, "color");
            }
          }
        })]
      })]
    })
  });
}
class PGcssColor extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      enableAlpha,
      onChange,
      label
    } = this.props;
    var colorVal = val.replace(" !important", "");
    var placeholderStyle = {
      backgroundImage: "repeating-linear-gradient(45deg,#e0e0e0 25%,transparent 0,transparent 75%,#e0e0e0 0,#e0e0e0),repeating-linear-gradient(45deg,#e0e0e0 25%,transparent 0,transparent 75%,#e0e0e0 0,#e0e0e0)",
      backgroundPosition: "0 0,25px 25px",
      backgroundSize: "50px 50px",
      boxShadow: "inset 0 0 0 1px rgb(0 0 0 / 20%)",
      cursor: "pointer"
    };
    var defaultbtnStyle = {
      backgroundImage: "repeating-linear-gradient(45deg,#e0e0e0 25%,transparent 0,transparent 75%,#e0e0e0 0,#e0e0e0),repeating-linear-gradient(45deg,#e0e0e0 25%,transparent 0,transparent 75%,#e0e0e0 0,#e0e0e0)",
      backgroundPosition: "0 0,25px 25px",
      backgroundSize: "50px 50px",
      boxShadow: "inset 0 0 0 1px rgb(0 0 0 / 20%)",
      cursor: "pointer"
    };
    var btnStyle = {
      backgroundColor: val,
      boxShadow: "inset 0 0 0 1px rgb(0 0 0 / 20%)",
      cursor: "pointer"
    };
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
        enableAlpha: enableAlpha,
        val: val,
        onChange: onChange,
        warn: this.state.showWarning,
        handleToggleClick: this.handleToggleClick
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssColor);

/***/ }),

/***/ "./src/components/css-column-count/index.js":
/*!**************************************************!*\
  !*** ./src/components/css-column-count/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "mt-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: align,
      type: "number",
      onChange: newVal => {
        //setwidthVal(newVal);
        setalign(newVal);
        if (isImportant) {
          props.onChange(newVal + " !important", "columnCount");
        } else {
          props.onChange(newVal, "columnCount");
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "columnCount");
        } else {
          props.onChange(align + " !important", "columnCount");
        }
      }
    })]
  });
}
class PGcssColumnCount extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssColumnCount);

/***/ }),

/***/ "./src/components/css-column-gap/index.js":
/*!************************************************!*\
  !*** ./src/components/css-column-gap/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    auto: {
      label: "AUTO",
      value: "auto"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  var widthUnitX = valZ == undefined || valZ.match(/[a-zA-Z%]+/g) == null ? "px" : valZ.match(/[a-zA-Z%]+/g)[0];
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnit, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between",
    children: [widthUnit != "auto" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      disabled: widthUnit == "auto" ? true : false,
      onChange: newVal => {
        setwidthVal(newVal);
        if (widthUnit == "auto") {
          // props.onChange(widthUnit, 'width');
          if (isImportant) {
            props.onChange(widthUnit + " !important", "columnGap");
          } else {
            props.onChange(widthUnit, "columnGap");
          }
        } else {
          //props.onChange(newVal + widthUnit, 'columnGap');
          if (isImportant) {
            props.onChange(newVal + widthUnit + " !important", "columnGap");
          } else {
            props.onChange(newVal + widthUnit, "columnGap");
          }
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom left",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: "",
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: " ",
            children: valZ ? unitArgs[widthUnit].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "w-32 pg-font",
          children: Object.entries(unitArgs).map(y => {
            var index = y[0];
            var x = y[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                setwidthUnit(x.value);
                if (x.value == "auto") {
                  if (isImportant) {
                    props.onChange(x.value + " !important", "columnGap");
                  } else {
                    props.onChange(x.value, "columnGap");
                  }
                } else {
                  if (isImportant) {
                    props.onChange(widthVal + x.value + " !important", "columnGap");
                  } else {
                    props.onChange(widthVal + x.value, "columnGap");
                  }
                }
              },
              children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: x.label
              })
            });
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          if (widthUnit == "auto") {
            props.onChange(widthUnit, "columnGap");
          } else {
            props.onChange(widthVal + widthUnit, "columnGap");
          }
        } else {
          if (widthUnit == "auto") {
            props.onChange(widthUnit + " !important", "columnGap");
          } else {
            props.onChange(widthVal + widthUnit + " !important", "columnGap");
          }
        }
      }
    })]
  });
}
class PGcssColumnGap extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssColumnGap);

/***/ }),

/***/ "./src/components/css-column-rule/index.js":
/*!*************************************************!*\
  !*** ./src/components/css-column-rule/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/input-color-picker */ "./src/components/input-color-picker/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component,
  RawHTML
} = wp.element;







function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valParts = props.val.length == 0 || props.val == undefined ? ["0px", "solid", "#000000", ""] : props.val.split(" ");
  var widthVal = valParts[0] != undefined ? valParts[0] : "0px";
  var styleVal = valParts[1] != undefined ? valParts[1] : "solid";
  var colorVal = valParts[2] != undefined ? valParts[2] : "#000000";
  var importantVal = valParts[3] != undefined ? valParts[3] : "";
  var outlineStyleArgs = {
    none: {
      label: "None",
      value: "none"
    },
    hidden: {
      label: "Hidden",
      value: "hidden"
    },
    dotted: {
      label: "Dotted",
      value: "dotted"
    },
    dashed: {
      label: "Dashed",
      value: "dashed"
    },
    solid: {
      label: "Solid",
      value: "solid"
    },
    double: {
      label: "Double",
      value: "double"
    },
    groove: {
      label: "Groove",
      value: "groove"
    },
    ridge: {
      label: "Ridge",
      value: "ridge"
    },
    inset: {
      label: "Inset",
      value: "inset"
    },
    outset: {
      label: "Outset",
      value: "outset"
    }
  };
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    auto: {
      label: "AUTO",
      value: "auto"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  var widthValX = widthVal.match(/-?\d+/g) != null ? widthVal.match(/-?\d+/g)[0] : 1;
  var widthUnitX = widthVal.match(/[a-zA-Z%]+/g) != null ? widthVal.match(/[a-zA-Z%]+/g)[0] : "px";
  const [widthValY, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnitY, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [outlineimportantVal, setoutlineimportantVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(importantVal.includes(" !important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "my-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Width", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "flex justify-between items-center",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
          value: widthValY,
          type: "number",
          onChange: newVal => {
            setwidthVal(newVal);
            if (outlineimportantVal) {
              props.onChange(newVal + widthUnitY + " " + styleVal + " " + colorVal + " " + "!important", "columnRule");
            } else {
              props.onChange(newVal + widthUnitY + " " + styleVal + " " + colorVal, "columnRule");
            }
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
            position: "bottom right",
            renderToggle: ({
              isOpen,
              onToggle
            }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
              title: "",
              onClick: onToggle,
              "aria-expanded": isOpen,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                className: " ",
                children: unitArgs[widthUnitY] == undefined ? "Select..." : unitArgs[widthUnitY].label
              })
            }),
            renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "w-32",
              children: Object.entries(unitArgs).map(y => {
                var index = y[0];
                var x = y[1];
                return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                  className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
                  onClick: ev => {
                    setwidthUnit(x.value);
                    if (outlineimportantVal) {
                      props.onChange(widthValY + x.value + " " + styleVal + " " + colorVal + " " + "!important", "columnRule");
                    } else {
                      props.onChange(widthValY + x.value + " " + styleVal + " " + colorVal, "columnRule");
                    }
                  },
                  children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                    children: x.label
                  })
                });
              })
            })
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "my-2 flex justify-between items-center",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Style", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom right",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            className: " ",
            children: outlineStyleArgs[styleVal] == undefined ? "Select..." : outlineStyleArgs[styleVal].label
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "w-32",
          children: Object.entries(outlineStyleArgs).map(arg => {
            var index = arg[0];
            var x = arg[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                if (outlineimportantVal) {
                  props.onChange(widthVal + " " + x.value + " " + colorVal + " " + "!important", "columnRule");
                } else {
                  props.onChange(widthVal + " " + x.value + " " + colorVal, "columnRule");
                }
              },
              children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
              }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                children: x.label
              })]
            });
          })
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("label", {
      htmlFor: "",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Color", "accordions")
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__["default"], {
      value: colorVal,
      colors: _colors_presets__WEBPACK_IMPORTED_MODULE_3__["default"],
      enableAlpha: true,
      onChange: newVal => {
        if (outlineimportantVal) {
          props.onChange(widthVal + " " + styleVal + " " + newVal + " " + "!important", "columnRule");
        } else {
          props.onChange(widthVal + " " + styleVal + " " + newVal, "columnRule");
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: outlineimportantVal ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: outlineimportantVal,
      onChange: arg => {
        setoutlineimportantVal(outlineimportantVal => !outlineimportantVal);
        if (outlineimportantVal) {
          props.onChange(widthVal + " " + styleVal + " " + colorVal, "columnRule");
        } else {
          props.onChange(widthVal + " " + styleVal + " " + colorVal + " " + "!important", "columnRule");
        }
      }
    })]
  });
}
class PGcssColumnRule extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssColumnRule);

/***/ }),

/***/ "./src/components/css-content/index.js":
/*!*********************************************!*\
  !*** ./src/components/css-content/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var content = props.val == null || props.val == undefined ? " " : props.val;
  content = props.val.replaceAll('"', "");
  content = content.replaceAll("u2018", "'");
  content = content.replaceAll("u0022", "");
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    className: "mt-4",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: content,
      type: "text",
      onChange: newVal => {
        if (newVal.includes("attr")) {
          newVal = newVal.replaceAll('"', "u0022");
          newVal = newVal.replaceAll('"', "u2018");
          props.onChange(newVal, "content");
        }
        //setwidthVal(newVal);
        else {
          newVal = newVal.replaceAll('"', "u0022");
          newVal = newVal.replaceAll("'", "u2018");
          newVal = 'u0022' + newVal + 'u0022';
          console.log(newVal);
          props.onChange(newVal, "content");
        }
      }
    })
  });
}
class PGcssContent extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssContent);

/***/ }),

/***/ "./src/components/css-counter-increment/index.js":
/*!*******************************************************!*\
  !*** ./src/components/css-counter-increment/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var content = props.val == null || props.val == undefined ? '' : props.val.replaceAll('"', '');
  content = content.replaceAll('u0022', '');
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    className: "mt-4",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: content,
      type: "text",
      onChange: newVal => {
        //setwidthVal(newVal);
        props.onChange('"' + newVal + '"', 'counterIncrement');
      }
    })
  });
}
class PGcssCounterIncrement extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssCounterIncrement);

/***/ }),

/***/ "./src/components/css-counter-reset/index.js":
/*!***************************************************!*\
  !*** ./src/components/css-counter-reset/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var content = props.val == null || props.val == undefined ? '' : props.val.replaceAll('"', '');
  content = content.replaceAll('u0022', '');
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    className: "mt-4",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: content,
      type: "text",
      onChange: newVal => {
        //setwidthVal(newVal);
        props.onChange('"' + newVal + '"', 'counterReset');
      }
    })
  });
}
class PGcssCounterReset extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssCounterReset);

/***/ }),

/***/ "./src/components/css-counter-set/index.js":
/*!*************************************************!*\
  !*** ./src/components/css-counter-set/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var content = props.val == null || props.val == undefined ? '' : props.val.replaceAll('"', '');
  content = content.replaceAll('u0022', '');
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    className: "mt-4",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: content,
      type: "text",
      onChange: newVal => {
        //setwidthVal(newVal);
        props.onChange('"' + newVal + '"', 'counterSet');
      }
    })
  });
}
class PGcssCounterSet extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssCounterSet);

/***/ }),

/***/ "./src/components/css-cursor/index.js":
/*!********************************************!*\
  !*** ./src/components/css-cursor/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    auto: {
      label: "auto",
      value: "auto"
    },
    pointer: {
      label: "pointer",
      value: "pointer"
    },
    progress: {
      label: "progress",
      value: "progress"
    },
    alias: {
      label: "alias",
      value: "alias"
    },
    cell: {
      label: "cell",
      value: "cell"
    },
    copy: {
      label: "copy",
      value: "copy"
    },
    crosshair: {
      label: "crosshair",
      value: "crosshair"
    },
    default: {
      label: "default",
      value: "default"
    },
    grab: {
      label: "grab",
      value: "grab"
    },
    grabbing: {
      label: "grabbing",
      value: "grabbing"
    },
    help: {
      label: "help",
      value: "help"
    },
    move: {
      label: "move",
      value: "move"
    },
    "col-resize": {
      label: "col-resize",
      value: "col-resize"
    },
    "context-menu": {
      label: "context-menu",
      value: "context-menu"
    },
    "e-resize": {
      label: "e-resize",
      value: "e-resize"
    },
    "ew-resize": {
      label: "ew-resize",
      value: "ew-resize"
    },
    "n-resize": {
      label: "n-resize",
      value: "n-resize"
    },
    "ne-resize": {
      label: "ne-resize",
      value: "ne-resize"
    },
    "nesw-resize": {
      label: "nesw-resize",
      value: "nesw-resize"
    },
    "ns-resize": {
      label: "ns-resize",
      value: "ns-resize"
    },
    "nw-resize": {
      label: "nw-resize",
      value: "nw-resize"
    },
    "nwse-resize": {
      label: "nwse-resize",
      value: "nwse-resize"
    },
    "no-drop": {
      label: "no-drop",
      value: "no-drop"
    },
    none: {
      label: "none",
      value: "none"
    },
    "not-allowed": {
      label: "not-allowed",
      value: "not-allowed"
    },
    "row-resize": {
      label: "row-resize",
      value: "row-resize"
    },
    "s-resize;": {
      label: "s-resize;",
      value: "s-resize;"
    },
    "se-resize": {
      label: "se-resize",
      value: "se-resize"
    },
    "sw-resize": {
      label: "sw-resize",
      value: "sw-resize"
    },
    text: {
      label: "text",
      value: "text"
    },
    "w-resize": {
      label: "w-resize",
      value: "w-resize"
    },
    wait: {
      label: "wait",
      value: "wait"
    },
    "zoom-in": {
      label: "zoom-in",
      value: "zoom-in"
    },
    "zoom-out": {
      label: "zoom-out",
      value: "zoom-out"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: "",
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'cursor');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "cursor");
              } else {
                props.onChange(x.value, "cursor");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "cursor");
        } else {
          props.onChange(align + " !important", "cursor");
        }
      }
    })]
  });
}
class PGcssCursor extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssCursor);

/***/ }),

/***/ "./src/components/css-direction/index.js":
/*!***********************************************!*\
  !*** ./src/components/css-direction/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    ltr: {
      label: "ltr",
      value: "ltr"
    },
    rtl: {
      label: "rtl",
      value: "rtl"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Align Content", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'direction');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "direction");
              } else {
                props.onChange(x.value, "direction");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "direction");
        } else {
          props.onChange(align + " !important", "direction");
        }
      }
    })]
  });
}
class PGcssDirection extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssDirection);

/***/ }),

/***/ "./src/components/css-display/index.js":
/*!*********************************************!*\
  !*** ./src/components/css-display/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    none: {
      label: "None",
      value: "none"
    },
    block: {
      label: "Block",
      value: "block"
    },
    inline: {
      label: "Inline",
      value: "inline"
    },
    "inline-block": {
      label: "Inline Block",
      value: "inline-block"
    },
    grid: {
      label: "Grid",
      value: "grid"
    },
    flex: {
      label: "Flex",
      value: "flex"
    },
    contents: {
      label: "contents",
      value: "contents"
    },
    "inline-flex": {
      label: "inline-flex",
      value: "inline-flex"
    },
    "inline-grid": {
      label: "inline-grid",
      value: "inline-grid"
    },
    "inline-table": {
      label: "inline-table",
      value: "inline-table"
    },
    "list-item": {
      label: "list-item",
      value: "list-item"
    },
    // 'run-in': { "label": "run-in", "value": "run-in" },
    table: {
      label: "table",
      value: "table"
    },
    "table-caption": {
      label: "table-caption",
      value: "table-caption"
    },
    "table-column-group": {
      label: "table-column-group",
      value: "table-column-group"
    },
    "table-header-group": {
      label: "table-header-group",
      value: "table-header-group"
    },
    "table-footer-group": {
      label: "table-footer-group",
      value: "table-footer-group"
    },
    "table-row-group": {
      label: "table-row-group",
      value: "table-row-group"
    },
    "table-cell": {
      label: "table-cell",
      value: "table-cell"
    },
    "table-column": {
      label: "table-column",
      value: "table-column"
    },
    "table-row": {
      label: "table-row",
      value: "table-row"
    },
    "flow-root": {
      label: "flow-root",
      value: "flow-root"
    },
    "inline-grid": {
      label: "inline-grid",
      value: "inline-grid"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom left",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: "",
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'display');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "display");
              } else {
                props.onChange(x.value, "display");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "display");
        } else {
          props.onChange(align + " !important", "display");
        }
      }
    })]
  });
}
class PGcssDisplay extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssDisplay);

/***/ }),

/***/ "./src/components/css-empty-cells/index.js":
/*!*************************************************!*\
  !*** ./src/components/css-empty-cells/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    show: {
      label: "Show",
      value: "show"
    },
    hide: {
      label: "Hide",
      value: "hide"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Empty Cells", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // props.onChange(x.value, 'emptyCells');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "emptyCells");
              } else {
                props.onChange(x.value, "emptyCells");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "emptyCells");
        } else {
          props.onChange(align + " !important", "emptyCells");
        }
      }
    })]
  });
}
class PGcssEmptyCells extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssEmptyCells);

/***/ }),

/***/ "./src/components/css-filter/index.js":
/*!********************************************!*\
  !*** ./src/components/css-filter/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
const {
  Component
} = wp.element;







function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valParts = props.val == null || props.val == undefined || props.val.length == 0 ? [] : props.val.split(" ");
  var [valArgs, setvalArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)([]);
  function addFilter(option, index) {
    var isExist = valArgs.find(x => x.id === option.value);
    if (isExist == undefined) {
      var obj = {};
      obj['id'] = option.value;
      obj['val'] = option.val;
      valArgs.push(obj);
      var str = '';
      valArgs.map(x => {
        if (x.id == 'blur') {
          str += x.id + '(' + x.val + 'px) ';
        } else if (x.id == 'hue-rotate') {
          str += x.id + '(' + x.val + 'deg) ';
        } else {
          str += x.id + '(' + x.val + '%) ';
        }
      });
      props.onChange(str, 'filter');
    }
  }
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    var filtered = valParts.filter(Boolean);
    var res = filtered.map(x => {
      if (x.length != 0) {
        var argVal = x != undefined ? x.match(/-?\d+/g)[0] : 1;
        var argId = x != undefined ? x.match(/[a-zA-Z]+/g)[0] : '';
        return {
          id: argId,
          val: argVal
        };
      }
    });
    setvalArgs(res);
  }, [props.val]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {}, [valArgs]);
  const [filterArgs, setfilterArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({
    blur: {
      label: 'Blur',
      value: 'blur',
      val: '1',
      unit: 'px'
    },
    brightness: {
      label: 'Brightness',
      value: 'brightness',
      val: '10',
      unit: '%'
    },
    contrast: {
      label: 'Contrast',
      value: 'contrast',
      val: '10',
      unit: '%'
    },
    grayscale: {
      label: 'Grayscale',
      value: 'grayscale',
      val: '10',
      unit: '%'
    },
    'hue-rotate': {
      label: 'Hue-rotate',
      value: 'hue-rotate',
      val: '10',
      unit: 'deg'
    },
    invert: {
      label: 'Invert',
      value: 'invert',
      val: '10',
      unit: '%'
    },
    opacity: {
      label: 'Opacity',
      value: 'opacity',
      val: '10',
      unit: '%'
    },
    saturate: {
      label: 'Saturate',
      value: 'saturate',
      val: '10',
      unit: '%'
    },
    sepia: {
      label: 'Sepia',
      value: 'sepia',
      val: '10',
      unit: '%'
    }
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "mt-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      className: "flex",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_3__["default"], {
        position: "bottom right",
        variant: "secondary",
        options: filterArgs,
        buttonTitle: "Add Filter",
        onChange: addFilter,
        values: ""
      })
    }), valArgs != undefined && valArgs.map((arg, i) => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
        className: "flex my-3 items-center justify-between",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("label", {
          htmlFor: "",
          children: filterArgs[arg.id] != undefined ? filterArgs[arg.id].label : arg.id
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
          className: "flex",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
            value: arg.val,
            type: "number",
            min: 0,
            max: 100,
            onChange: newVal => {
              valArgs[i].val = newVal;
              // setvalArgs(valArgs);
              var str = '';
              valArgs.map(x => {
                if (x.id == 'blur') {
                  str += x.id + '(' + x.val + 'px) ';
                } else if (x.id == 'hue-rotate') {
                  str += x.id + '(' + x.val + 'deg) ';
                } else {
                  str += x.id + '(' + x.val + '%) ';
                }
              });
              props.onChange(str, 'filter');
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
            className: "hover:bg-red-500 bg-red-400 text-white ml-1 inline-block p-1 cursor-pointer",
            onClick: ev => {
              valArgs.splice(i, 1);
              setvalArgs(valArgs);
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
              className: "dashicons dashicons-no-alt"
            })
          })]
        })]
      });
    })]
  });
}
class PGcssFilter extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFilter);

/***/ }),

/***/ "./src/components/css-flex-basis/index.js":
/*!************************************************!*\
  !*** ./src/components/css-flex-basis/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  var widthUnitX = valZ == undefined || valZ.match(/[a-zA-Z%]+/g) == null ? "px" : valZ.match(/[a-zA-Z%]+/g)[0];
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnit, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex mt-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      onChange: newVal => {
        setwidthVal(newVal);
        props.onChange(newVal + widthUnit, "flexBasis");
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom left",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: "",
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: " ",
            children: props.val ? unitArgs[widthUnit].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "w-32",
          children: Object.entries(unitArgs).map(y => {
            var index = y[0];
            var x = y[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                setwidthUnit(x.value);
                props.onChange(widthVal + x.value, "flexBasis");
              },
              children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: x.label
              })
            });
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(widthVal + widthUnit, "flexBasis");
        } else {
          props.onChange(widthVal + widthUnit + " !important", "flexBasis");
        }
      }
    })]
  });
}
class PGcssFlexBasis extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFlexBasis);

/***/ }),

/***/ "./src/components/css-flex-direction/index.js":
/*!****************************************************!*\
  !*** ./src/components/css-flex-direction/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    row: {
      label: "row",
      value: "row"
    },
    "row-reverse": {
      label: "row-reverse",
      value: "row-reverse"
    },
    column: {
      label: "column",
      value: "column"
    },
    "column-reverse": {
      label: "column-reverse",
      value: "column-reverse"
    }
  };
  var valX = props.val == undefined || props.val == null || props.val.length == 0 ? "wrap" : props.val;
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valX.split(" "));
  const [value, setValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[value] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[value].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              setValue(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "flexDirection");
              } else {
                props.onChange(x.value, "flexDirection");
              }
            },
            children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      label: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(value, "flexDirection");
        } else {
          props.onChange(value + " !important", "flexDirection");
        }
      }
    })]
  });
}
class PGcssFlexDirection extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFlexDirection);

/***/ }),

/***/ "./src/components/css-flex-flow/index.js":
/*!***********************************************!*\
  !*** ./src/components/css-flex-flow/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;






function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    row: {
      label: "row",
      value: "row"
    },
    "row-reverse": {
      label: "row-reverse",
      value: "row-reverse"
    },
    column: {
      label: "column",
      value: "column"
    },
    "column-reverse": {
      label: "column-reverse",
      value: "column-reverse"
    },
    nowrap: {
      label: "nowrap",
      value: "nowrap"
    },
    wrap: {
      label: "wrap",
      value: "wrap"
    },
    "wrap-reverse": {
      label: "wrap-reverse",
      value: "wrap-reverse"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    "revert-layer": {
      label: "revert-layer",
      value: "revert-layer"
    },
    unset: {
      label: "unset",
      value: "unset"
    }
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "" : props.val;
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.split(" "));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "mt-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: "Select..."
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              valArgs.push(x.value);
              setValArgs(valArgs);
              props.onChange(valArgs.join(" "), "flexFlow");
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), valArgs.map((x, i) => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: "flex items-center my-1 border hover:bg-gray-400 cursor-pointer",
        children: [" ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
          className: "bg-red-500 mr-2 p-1",
          onClick: ev => {
            valArgs.splice(i, 1);
            setValArgs(valArgs);
            props.onChange(valArgs.join(" "), "flexFlow");
          },
          children: [" ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"], {
            fill: "#fff",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"]
          }), " "]
        }), " ", x]
      });
    })]
  });
}
class PGcssFlexFlow extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFlexFlow);

/***/ }),

/***/ "./src/components/css-flex-grow/index.js":
/*!***********************************************!*\
  !*** ./src/components/css-flex-grow/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex mt-4 justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      onChange: newVal => {
        setwidthVal(newVal);
        props.onChange(newVal, "flexGrow");
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(widthValX, "flexGrow");
        } else {
          props.onChange(widthValX + " !important", "flexGrow");
        }
      }
    })]
  });
}
class PGcssFlexGrow extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFlexGrow);

/***/ }),

/***/ "./src/components/css-flex-shrink/index.js":
/*!*************************************************!*\
  !*** ./src/components/css-flex-shrink/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex mt-4 justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      onChange: newVal => {
        setwidthVal(newVal);
        props.onChange(newVal, "flexShrink");
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(widthValX, "flexShrink");
        } else {
          props.onChange(widthValX + " !important", "flexShrink");
        }
      }
    })]
  });
}
class PGcssFlexShrink extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFlexShrink);

/***/ }),

/***/ "./src/components/css-flex-wrap/index.js":
/*!***********************************************!*\
  !*** ./src/components/css-flex-wrap/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    nowrap: {
      label: "nowrap",
      value: "nowrap"
    },
    wrap: {
      label: "wrap",
      value: "wrap"
    },
    "wrap-reverse": {
      label: "wrap-reverse",
      value: "wrap-reverse"
    }
  };
  var valX = props.val == undefined || props.val == null || props.val.length == 0 ? "wrap" : props.val;
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valX.split(" "));
  const [value, setValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Clear', "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[value] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[value].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              setValue(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "flexWrap");
              } else {
                props.onChange(x.value, "flexWrap");
              }
            },
            children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      label: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(value, "flexWrap");
        } else {
          props.onChange(value + " !important", "flexWrap");
        }
      }
    })]
  });
}
class PGcssFlexWrap extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFlexWrap);

/***/ }),

/***/ "./src/components/css-float/index.js":
/*!*******************************************!*\
  !*** ./src/components/css-float/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    none: {
      label: "None",
      value: "none"
    },
    left: {
      label: "Left",
      value: "left"
    },
    right: {
      label: "Right",
      value: "right"
    },
    "inline-end": {
      label: "inline-end",
      value: "inline-end"
    },
    "inline-start": {
      label: "inline-start",
      value: "inline-start"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'float');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "float");
              } else {
                props.onChange(x.value, "float");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "float");
        } else {
          props.onChange(align + " !important", "float");
        }
      }
    })]
  });
}
class PGcssFloat extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFloat);

/***/ }),

/***/ "./src/components/css-font-family/index.js":
/*!*************************************************!*\
  !*** ./src/components/css-font-family/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/plus.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component
} = wp.element;








function Html(props) {
  if (!props.warn) {
    return null;
  }
  var isLoaded = props.isLoaded;
  var fontsLibrary = ["ABeeZee", "Abel", "Abhaya Libre", "Aboreto", "Abril Fatface", "Abyssinica SIL", "Aclonica", "Acme", "Actor", "Adamina", "Advent Pro", "Agdasima", "Aguafina Script", "Akatab", "Akaya Kanadaka", "Akaya Telivigala", "Akronim", "Akshar", "Aladin", "Alata", "Alatsi", "Albert Sans", "Aldrich", "Alef", "Alegreya", "Alegreya SC", "Alegreya Sans", "Alegreya Sans SC", "Aleo", "Alex Brush", "Alexandria", "Alfa Slab One", "Alice", "Alike", "Alike Angular", "Alkalami", "Alkatra", "Allan", "Allerta", "Allerta Stencil", "Allison", "Allura", "Almarai", "Almendra", "Almendra Display", "Almendra SC", "Alumni Sans", "Alumni Sans Collegiate One", "Alumni Sans Inline One", "Alumni Sans Pinstripe", "Amarante", "Amaranth", "Amatic SC", "Amethysta", "Amiko", "Amiri", "Amiri Quran", "Amita", "Anaheim", "Andada Pro", "Andika", "Anek Bangla", "Anek Devanagari", "Anek Gujarati", "Anek Gurmukhi", "Anek Kannada", "Anek Latin", "Anek Malayalam", "Anek Odia", "Anek Tamil", "Anek Telugu", "Angkor", "Annie Use Your Telescope", "Anonymous Pro", "Antic", "Antic Didone", "Antic Slab", "Anton", "Antonio", "Anuphan", "Anybody", "Aoboshi One", "Arapey", "Arbutus", "Arbutus Slab", "Architects Daughter", "Archivo", "Archivo Black", "Archivo Narrow", "Are You Serious", "Aref Ruqaa", "Aref Ruqaa Ink", "Arima", "Arimo", "Arizonia", "Armata", "Arsenal", "Artifika", "Arvo", "Arya", "Asap", "Asap Condensed", "Asar", "Asset", "Assistant", "Astloch", "Asul", "Athiti", "Atkinson Hyperlegible", "Atma", "Atomic Age", "Aubrey", "Audiowide", "Autour One", "Average", "Average Sans", "Averia Gruesa Libre", "Averia Libre", "Averia Sans Libre", "Averia Serif Libre", "Azeret Mono", "B612", "B612 Mono", "BIZ UDGothic", "BIZ UDMincho", "BIZ UDPGothic", "BIZ UDPMincho", "Babylonica", "Bacasime Antique", "Bad Script", "Bagel Fat One", "Bahiana", "Bahianita", "Bai Jamjuree", "Bakbak One", "Ballet", "Baloo 2", "Baloo Bhai 2", "Baloo Bhaijaan 2", "Baloo Bhaina 2", "Baloo Chettan 2", "Baloo Da 2", "Baloo Paaji 2", "Baloo Tamma 2", "Baloo Tammudu 2", "Baloo Thambi 2", "Balsamiq Sans", "Balthazar", "Bangers", "Barlow", "Barlow Condensed", "Barlow Semi Condensed", "Barriecito", "Barrio", "Basic", "Baskervville", "Battambang", "Baumans", "Bayon", "Be Vietnam Pro", "Beau Rivage", "Bebas Neue", "Belanosima", "Belgrano", "Bellefair", "Belleza", "Bellota", "Bellota Text", "BenchNine", "Benne", "Bentham", "Berkshire Swash", "Besley", "Beth Ellen", "Bevan", "BhuTuka Expanded One", "Big Shoulders Display", "Big Shoulders Inline Display", "Big Shoulders Inline Text", "Big Shoulders Stencil Display", "Big Shoulders Stencil Text", "Big Shoulders Text", "Bigelow Rules", "Bigshot One", "Bilbo", "Bilbo Swash Caps", "BioRhyme", "BioRhyme Expanded", "Birthstone", "Birthstone Bounce", "Biryani", "Bitter", "Black And White Picture", "Black Han Sans", "Black Ops One", "Blaka", "Blaka Hollow", "Blaka Ink", "Blinker", "Bodoni Moda", "Bokor", "Bona Nova", "Bonbon", "Bonheur Royale", "Boogaloo", "Borel", "Bowlby One", "Bowlby One SC", "Braah One", "Brawler", "Bree Serif", "Bruno Ace", "Bruno Ace SC", "Brygada 1918", "Bubblegum Sans", "Bubbler One", "Buda", "Buenard", "Bungee", "Bungee Hairline", "Bungee Inline", "Bungee Outline", "Bungee Shade", "Bungee Spice", "Butcherman", "Butterfly Kids", "Cabin", "Cabin Condensed", "Cabin Sketch", "Caesar Dressing", "Cagliostro", "Cairo", "Cairo Play", "Caladea", "Calistoga", "Calligraffitti", "Cambay", "Cambo", "Candal", "Cantarell", "Cantata One", "Cantora One", "Caprasimo", "Capriola", "Caramel", "Carattere", "Cardo", "Carlito", "Carme", "Carrois Gothic", "Carrois Gothic SC", "Carter One", "Castoro", "Castoro Titling", "Catamaran", "Caudex", "Caveat", "Caveat Brush", "Cedarville Cursive", "Ceviche One", "Chakra Petch", "Changa", "Changa One", "Chango", "Charis SIL", "Charm", "Charmonman", "Chathura", "Chau Philomene One", "Chela One", "Chelsea Market", "Chenla", "Cherish", "Cherry Bomb One", "Cherry Cream Soda", "Cherry Swash", "Chewy", "Chicle", "Chilanka", "Chivo", "Chivo Mono", "Chokokutai", "Chonburi", "Cinzel", "Cinzel Decorative", "Clicker Script", "Climate Crisis", "Coda", "Codystar", "Coiny", "Combo", "Comfortaa", "Comforter", "Comforter Brush", "Comic Neue", "Coming Soon", "Comme", "Commissioner", "Concert One", "Condiment", "Content", "Contrail One", "Convergence", "Cookie", "Copse", "Corben", "Corinthia", "Cormorant", "Cormorant Garamond", "Cormorant Infant", "Cormorant SC", "Cormorant Unicase", "Cormorant Upright", "Courgette", "Courier Prime", "Cousine", "Coustard", "Covered By Your Grace", "Crafty Girls", "Creepster", "Crete Round", "Crimson Pro", "Crimson Text", "Croissant One", "Crushed", "Cuprum", "Cute Font", "Cutive", "Cutive Mono", "DM Mono", "DM Sans", "DM Serif Display", "DM Serif Text", "Dai Banna SIL", "Damion", "Dancing Script", "Dangrek", "Darker Grotesque", "Darumadrop One", "David Libre", "Dawning of a New Day", "Days One", "Dekko", "Dela Gothic One", "Delicious Handrawn", "Delius", "Delius Swash Caps", "Delius Unicase", "Della Respira", "Denk One", "Devonshire", "Dhurjati", "Didact Gothic", "Diphylleia", "Diplomata", "Diplomata SC", "Do Hyeon", "Dokdo", "Domine", "Donegal One", "Dongle", "Doppio One", "Dorsa", "Dosis", "DotGothic16", "Dr Sugiyama", "Duru Sans", "DynaPuff", "Dynalight", "EB Garamond", "Eagle Lake", "East Sea Dokdo", "Eater", "Economica", "Eczar", "Edu NSW ACT Foundation", "Edu QLD Beginner", "Edu SA Beginner", "Edu TAS Beginner", "Edu VIC WA NT Beginner", "El Messiri", "Electrolize", "Elsie", "Elsie Swash Caps", "Emblema One", "Emilys Candy", "Encode Sans", "Encode Sans Condensed", "Encode Sans Expanded", "Encode Sans SC", "Encode Sans Semi Condensed", "Encode Sans Semi Expanded", "Engagement", "Englebert", "Enriqueta", "Ephesis", "Epilogue", "Erica One", "Esteban", "Estonia", "Euphoria Script", "Ewert", "Exo", "Exo 2", "Expletus Sans", "Explora", "Fahkwang", "Familjen Grotesk", "Fanwood Text", "Farro", "Farsan", "Fascinate", "Fascinate Inline", "Faster One", "Fasthand", "Fauna One", "Faustina", "Federant", "Federo", "Felipa", "Fenix", "Festive", "Figtree", "Finger Paint", "Finlandica", "Fira Code", "Fira Mono", "Fira Sans", "Fira Sans Condensed", "Fira Sans Extra Condensed", "Fjalla One", "Fjord One", "Flamenco", "Flavors", "Fleur De Leah", "Flow Block", "Flow Circular", "Flow Rounded", "Foldit", "Fondamento", "Fontdiner Swanky", "Forum", "Fragment Mono", "Francois One", "Frank Ruhl Libre", "Fraunces", "Freckle Face", "Fredericka the Great", "Fredoka", "Freehand", "Fresca", "Frijole", "Fruktur", "Fugaz One", "Fuggles", "Fuzzy Bubbles", "GFS Didot", "GFS Neohellenic", "Gabriela", "Gaegu", "Gafata", "Gajraj One", "Galada", "Galdeano", "Galindo", "Gamja Flower", "Gantari", "Gasoek One", "Gayathri", "Gelasio", "Gemunu Libre", "Genos", "Gentium Book Plus", "Gentium Plus", "Geo", "Geologica", "Georama", "Geostar", "Geostar Fill", "Germania One", "Gideon Roman", "Gidugu", "Gilda Display", "Girassol", "Give You Glory", "Glass Antiqua", "Glegoo", "Gloock", "Gloria Hallelujah", "Glory", "Gluten", "Goblin One", "Gochi Hand", "Goldman", "Golos Text", "Gorditas", "Gothic A1", "Gotu", "Goudy Bookletter 1911", "Gowun Batang", "Gowun Dodum", "Graduate", "Grand Hotel", "Grandiflora One", "Grandstander", "Grape Nuts", "Gravitas One", "Great Vibes", "Grechen Fuemen", "Grenze", "Grenze Gotisch", "Grey Qo", "Griffy", "Gruppo", "Gudea", "Gugi", "Gulzar", "Gupter", "Gurajada", "Gwendolyn", "Habibi", "Hachi Maru Pop", "Hahmlet", "Halant", "Hammersmith One", "Hanalei", "Hanalei Fill", "Handjet", "Handlee", "Hanken Grotesk", "Hanuman", "Happy Monkey", "Harmattan", "Headland One", "Heebo", "Henny Penny", "Hepta Slab", "Herr Von Muellerhoff", "Hi Melody", "Hina Mincho", "Hind", "Hind Guntur", "Hind Madurai", "Hind Siliguri", "Hind Vadodara", "Holtwood One SC", "Homemade Apple", "Homenaje", "Hubballi", "Hurricane", "IBM Plex Mono", "IBM Plex Sans", "IBM Plex Sans Arabic", "IBM Plex Sans Condensed", "IBM Plex Sans Devanagari", "IBM Plex Sans Hebrew", "IBM Plex Sans JP", "IBM Plex Sans KR", "IBM Plex Sans Thai", "IBM Plex Sans Thai Looped", "IBM Plex Serif", "IM Fell DW Pica", "IM Fell DW Pica SC", "IM Fell Double Pica", "IM Fell Double Pica SC", "IM Fell English", "IM Fell English SC", "IM Fell French Canon", "IM Fell French Canon SC", "IM Fell Great Primer", "IM Fell Great Primer SC", "Ibarra Real Nova", "Iceberg", "Iceland", "Imbue", "Imperial Script", "Imprima", "Inconsolata", "Inder", "Indie Flower", "Ingrid Darling", "Inika", "Inknut Antiqua", "Inria Sans", "Inria Serif", "Inspiration", "Instrument Sans", "Instrument Serif", "Inter", "Inter Tight", "Irish Grover", "Island Moments", "Istok Web", "Italiana", "Italianno", "Itim", "Jacques Francois", "Jacques Francois Shadow", "Jaldi", "JetBrains Mono", "Jim Nightshade", "Joan", "Jockey One", "Jolly Lodger", "Jomhuria", "Jomolhari", "Josefin Sans", "Josefin Slab", "Jost", "Joti One", "Jua", "Judson", "Julee", "Julius Sans One", "Junge", "Jura", "Just Another Hand", "Just Me Again Down Here", "K2D", "Kablammo", "Kadwa", "Kaisei Decol", "Kaisei HarunoUmi", "Kaisei Opti", "Kaisei Tokumin", "Kalam", "Kameron", "Kanit", "Kantumruy Pro", "Karantina", "Karla", "Karma", "Katibeh", "Kaushan Script", "Kavivanar", "Kavoon", "Kdam Thmor Pro", "Keania One", "Kelly Slab", "Kenia", "Khand", "Khmer", "Khula", "Kings", "Kirang Haerang", "Kite One", "Kiwi Maru", "Klee One", "Knewave", "KoHo", "Kodchasan", "Koh Santepheap", "Kolker Brush", "Konkhmer Sleokchher", "Kosugi", "Kosugi Maru", "Kotta One", "Koulen", "Kranky", "Kreon", "Kristi", "Krona One", "Krub", "Kufam", "Kulim Park", "Kumar One", "Kumar One Outline", "Kumbh Sans", "Kurale", "La Belle Aurore", "Labrada", "Lacquer", "Laila", "Lakki Reddy", "Lalezar", "Lancelot", "Langar", "Lateef", "Lato", "Lavishly Yours", "League Gothic", "League Script", "League Spartan", "Leckerli One", "Ledger", "Lekton", "Lemon", "Lemonada", "Lexend", "Lexend Deca", "Lexend Exa", "Lexend Giga", "Lexend Mega", "Lexend Peta", "Lexend Tera", "Lexend Zetta", "Libre Barcode 128", "Libre Barcode 128 Text", "Libre Barcode 39", "Libre Barcode 39 Extended", "Libre Barcode 39 Extended Text", "Libre Barcode 39 Text", "Libre Barcode EAN13 Text", "Libre Baskerville", "Libre Bodoni", "Libre Caslon Display", "Libre Caslon Text", "Libre Franklin", "Licorice", "Life Savers", "Lilita One", "Lily Script One", "Limelight", "Linden Hill", "Lisu Bosa", "Literata", "Liu Jian Mao Cao", "Livvic", "Lobster", "Lobster Two", "Londrina Outline", "Londrina Shadow", "Londrina Sketch", "Londrina Solid", "Long Cang", "Lora", "Love Light", "Love Ya Like A Sister", "Loved by the King", "Lovers Quarrel", "Luckiest Guy", "Lugrasimo", "Lumanosimo", "Lunasima", "Lusitana", "Lustria", "Luxurious Roman", "Luxurious Script", "M PLUS 1", "M PLUS 1 Code", "M PLUS 1p", "M PLUS 2", "M PLUS Code Latin", "M PLUS Rounded 1c", "Ma Shan Zheng", "Macondo", "Macondo Swash Caps", "Mada", "Magra", "Maiden Orange", "Maitree", "Major Mono Display", "Mako", "Mali", "Mallanna", "Mandali", "Manjari", "Manrope", "Mansalva", "Manuale", "Marcellus", "Marcellus SC", "Marck Script", "Margarine", "Marhey", "Markazi Text", "Marko One", "Marmelad", "Martel", "Martel Sans", "Martian Mono", "Marvel", "Mate", "Mate SC", "Material Icons", "Material Icons Outlined", "Material Icons Round", "Material Icons Sharp", "Material Icons Two Tone", "Material Symbols Outlined", "Material Symbols Rounded", "Material Symbols Sharp", "Maven Pro", "McLaren", "Mea Culpa", "Meddon", "MedievalSharp", "Medula One", "Meera Inimai", "Megrim", "Meie Script", "Meow Script", "Merienda", "Merriweather", "Merriweather Sans", "Metal", "Metal Mania", "Metamorphous", "Metrophobic", "Michroma", "Milonga", "Miltonian", "Miltonian Tattoo", "Mina", "Mingzat", "Miniver", "Miriam Libre", "Mirza", "Miss Fajardose", "Mitr", "Mochiy Pop One", "Mochiy Pop P One", "Modak", "Modern Antiqua", "Mogra", "Mohave", "Moirai One", "Molengo", "Molle", "Monda", "Monofett", "Monomaniac One", "Monoton", "Monsieur La Doulaise", "Montaga", "Montagu Slab", "MonteCarlo", "Montez", "Montserrat", "Montserrat Alternates", "Montserrat Subrayada", "Moo Lah Lah", "Moon Dance", "Moul", "Moulpali", "Mountains of Christmas", "Mouse Memoirs", "Mr Bedfort", "Mr Dafoe", "Mr De Haviland", "Mrs Saint Delafield", "Mrs Sheppards", "Ms Madi", "Mukta", "Mukta Mahee", "Mukta Malar", "Mukta Vaani", "Mulish", "Murecho", "MuseoModerno", "My Soul", "Mynerve", "Mystery Quest", "NTR", "Nabla", "Nanum Brush Script", "Nanum Gothic", "Nanum Gothic Coding", "Nanum Myeongjo", "Nanum Pen Script", "Narnoor", "Neonderthaw", "Nerko One", "Neucha", "Neuton", "New Rocker", "New Tegomin", "News Cycle", "Newsreader", "Niconne", "Niramit", "Nixie One", "Nobile", "Nokora", "Norican", "Nosifer", "Notable", "Nothing You Could Do", "Noticia Text", "Noto Color Emoji", "Noto Emoji", "Noto Kufi Arabic", "Noto Music", "Noto Naskh Arabic", "Noto Nastaliq Urdu", "Noto Rashi Hebrew", "Noto Sans", "Noto Sans Adlam", "Noto Sans Adlam Unjoined", "Noto Sans Anatolian Hieroglyphs", "Noto Sans Arabic", "Noto Sans Armenian", "Noto Sans Avestan", "Noto Sans Balinese", "Noto Sans Bamum", "Noto Sans Bassa Vah", "Noto Sans Batak", "Noto Sans Bengali", "Noto Sans Bhaiksuki", "Noto Sans Brahmi", "Noto Sans Buginese", "Noto Sans Buhid", "Noto Sans Canadian Aboriginal", "Noto Sans Carian", "Noto Sans Caucasian Albanian", "Noto Sans Chakma", "Noto Sans Cham", "Noto Sans Cherokee", "Noto Sans Chorasmian", "Noto Sans Coptic", "Noto Sans Cuneiform", "Noto Sans Cypriot", "Noto Sans Cypro Minoan", "Noto Sans Deseret", "Noto Sans Devanagari", "Noto Sans Display", "Noto Sans Duployan", "Noto Sans Egyptian Hieroglyphs", "Noto Sans Elbasan", "Noto Sans Elymaic", "Noto Sans Ethiopic", "Noto Sans Georgian", "Noto Sans Glagolitic", "Noto Sans Gothic", "Noto Sans Grantha", "Noto Sans Gujarati", "Noto Sans Gunjala Gondi", "Noto Sans Gurmukhi", "Noto Sans HK", "Noto Sans Hanifi Rohingya", "Noto Sans Hanunoo", "Noto Sans Hatran", "Noto Sans Hebrew", "Noto Sans Imperial Aramaic", "Noto Sans Indic Siyaq Numbers", "Noto Sans Inscriptional Pahlavi", "Noto Sans Inscriptional Parthian", "Noto Sans JP", "Noto Sans Javanese", "Noto Sans KR", "Noto Sans Kaithi", "Noto Sans Kannada", "Noto Sans Kayah Li", "Noto Sans Kharoshthi", "Noto Sans Khmer", "Noto Sans Khojki", "Noto Sans Khudawadi", "Noto Sans Lao", "Noto Sans Lao Looped", "Noto Sans Lepcha", "Noto Sans Limbu", "Noto Sans Linear A", "Noto Sans Linear B", "Noto Sans Lisu", "Noto Sans Lycian", "Noto Sans Lydian", "Noto Sans Mahajani", "Noto Sans Malayalam", "Noto Sans Mandaic", "Noto Sans Manichaean", "Noto Sans Marchen", "Noto Sans Masaram Gondi", "Noto Sans Math", "Noto Sans Mayan Numerals", "Noto Sans Medefaidrin", "Noto Sans Meetei Mayek", "Noto Sans Mende Kikakui", "Noto Sans Meroitic", "Noto Sans Miao", "Noto Sans Modi", "Noto Sans Mongolian", "Noto Sans Mono", "Noto Sans Mro", "Noto Sans Multani", "Noto Sans Myanmar", "Noto Sans NKo", "Noto Sans Nabataean", "Noto Sans Nag Mundari", "Noto Sans Nandinagari", "Noto Sans New Tai Lue", "Noto Sans Newa", "Noto Sans Nushu", "Noto Sans Ogham", "Noto Sans Ol Chiki", "Noto Sans Old Hungarian", "Noto Sans Old Italic", "Noto Sans Old North Arabian", "Noto Sans Old Permic", "Noto Sans Old Persian", "Noto Sans Old Sogdian", "Noto Sans Old South Arabian", "Noto Sans Old Turkic", "Noto Sans Oriya", "Noto Sans Osage", "Noto Sans Osmanya", "Noto Sans Pahawh Hmong", "Noto Sans Palmyrene", "Noto Sans Pau Cin Hau", "Noto Sans Phags Pa", "Noto Sans Phoenician", "Noto Sans Psalter Pahlavi", "Noto Sans Rejang", "Noto Sans Runic", "Noto Sans SC", "Noto Sans Samaritan", "Noto Sans Saurashtra", "Noto Sans Sharada", "Noto Sans Shavian", "Noto Sans Siddham", "Noto Sans SignWriting", "Noto Sans Sinhala", "Noto Sans Sogdian", "Noto Sans Sora Sompeng", "Noto Sans Soyombo", "Noto Sans Sundanese", "Noto Sans Syloti Nagri", "Noto Sans Symbols", "Noto Sans Symbols 2", "Noto Sans Syriac", "Noto Sans Syriac Eastern", "Noto Sans TC", "Noto Sans Tagalog", "Noto Sans Tagbanwa", "Noto Sans Tai Le", "Noto Sans Tai Tham", "Noto Sans Tai Viet", "Noto Sans Takri", "Noto Sans Tamil", "Noto Sans Tamil Supplement", "Noto Sans Tangsa", "Noto Sans Telugu", "Noto Sans Thaana", "Noto Sans Thai", "Noto Sans Thai Looped", "Noto Sans Tifinagh", "Noto Sans Tirhuta", "Noto Sans Ugaritic", "Noto Sans Vai", "Noto Sans Vithkuqi", "Noto Sans Wancho", "Noto Sans Warang Citi", "Noto Sans Yi", "Noto Sans Zanabazar Square", "Noto Serif", "Noto Serif Ahom", "Noto Serif Armenian", "Noto Serif Balinese", "Noto Serif Bengali", "Noto Serif Devanagari", "Noto Serif Display", "Noto Serif Dogra", "Noto Serif Ethiopic", "Noto Serif Georgian", "Noto Serif Grantha", "Noto Serif Gujarati", "Noto Serif Gurmukhi", "Noto Serif HK", "Noto Serif Hebrew", "Noto Serif JP", "Noto Serif KR", "Noto Serif Kannada", "Noto Serif Khitan Small Script", "Noto Serif Khmer", "Noto Serif Khojki", "Noto Serif Lao", "Noto Serif Makasar", "Noto Serif Malayalam", "Noto Serif Myanmar", "Noto Serif NP Hmong", "Noto Serif Oriya", "Noto Serif Ottoman Siyaq", "Noto Serif SC", "Noto Serif Sinhala", "Noto Serif TC", "Noto Serif Tamil", "Noto Serif Tangut", "Noto Serif Telugu", "Noto Serif Thai", "Noto Serif Tibetan", "Noto Serif Toto", "Noto Serif Vithkuqi", "Noto Serif Yezidi", "Noto Traditional Nushu", "Nova Cut", "Nova Flat", "Nova Mono", "Nova Oval", "Nova Round", "Nova Script", "Nova Slim", "Nova Square", "Numans", "Nunito", "Nunito Sans", "Nuosu SIL", "Odibee Sans", "Odor Mean Chey", "Offside", "Oi", "Old Standard TT", "Oldenburg", "Ole", "Oleo Script", "Oleo Script Swash Caps", "Oooh Baby", "Open Sans", "Oranienbaum", "Orbit", "Orbitron", "Oregano", "Orelega One", "Orienta", "Original Surfer", "Oswald", "Outfit", "Over the Rainbow", "Overlock", "Overlock SC", "Overpass", "Overpass Mono", "Ovo", "Oxanium", "Oxygen", "Oxygen Mono", "PT Mono", "PT Sans", "PT Sans Caption", "PT Sans Narrow", "PT Serif", "PT Serif Caption", "Pacifico", "Padauk", "Padyakke Expanded One", "Palanquin", "Palanquin Dark", "Palette Mosaic", "Pangolin", "Paprika", "Parisienne", "Passero One", "Passion One", "Passions Conflict", "Pathway Extreme", "Pathway Gothic One", "Patrick Hand", "Patrick Hand SC", "Pattaya", "Patua One", "Pavanam", "Paytone One", "Peddana", "Peralta", "Permanent Marker", "Petemoss", "Petit Formal Script", "Petrona", "Philosopher", "Phudu", "Piazzolla", "Piedra", "Pinyon Script", "Pirata One", "Plaster", "Play", "Playball", "Playfair", "Playfair Display", "Playfair Display SC", "Plus Jakarta Sans", "Podkova", "Poiret One", "Poller One", "Poltawski Nowy", "Poly", "Pompiere", "Pontano Sans", "Poor Story", "Poppins", "Port Lligat Sans", "Port Lligat Slab", "Potta One", "Pragati Narrow", "Praise", "Prata", "Preahvihear", "Press Start 2P", "Pridi", "Princess Sofia", "Prociono", "Prompt", "Prosto One", "Proza Libre", "Public Sans", "Puppies Play", "Puritan", "Purple Purse", "Qahiri", "Quando", "Quantico", "Quattrocento", "Quattrocento Sans", "Questrial", "Quicksand", "Quintessential", "Qwigley", "Qwitcher Grypen", "REM", "Racing Sans One", "Radio Canada", "Radley", "Rajdhani", "Rakkas", "Raleway", "Raleway Dots", "Ramabhadra", "Ramaraja", "Rambla", "Rammetto One", "Rampart One", "Ranchers", "Rancho", "Ranga", "Rasa", "Rationale", "Ravi Prakash", "Readex Pro", "Recursive", "Red Hat Display", "Red Hat Mono", "Red Hat Text", "Red Rose", "Redacted", "Redacted Script", "Redressed", "Reem Kufi", "Reem Kufi Fun", "Reem Kufi Ink", "Reenie Beanie", "Reggae One", "Revalia", "Rhodium Libre", "Ribeye", "Ribeye Marrow", "Righteous", "Risque", "Road Rage", "Roboto", "Roboto Condensed", "Roboto Flex", "Roboto Mono", "Roboto Serif", "Roboto Slab", "Rochester", "Rock 3D", "Rock Salt", "RocknRoll One", "Rokkitt", "Romanesco", "Ropa Sans", "Rosario", "Rosarivo", "Rouge Script", "Rowdies", "Rozha One", "Rubik", "Rubik 80s Fade", "Rubik Beastly", "Rubik Bubbles", "Rubik Burned", "Rubik Dirt", "Rubik Distressed", "Rubik Gemstones", "Rubik Glitch", "Rubik Iso", "Rubik Marker Hatch", "Rubik Maze", "Rubik Microbe", "Rubik Mono One", "Rubik Moonrocks", "Rubik Pixels", "Rubik Puddles", "Rubik Spray Paint", "Rubik Storm", "Rubik Vinyl", "Rubik Wet Paint", "Ruda", "Rufina", "Ruge Boogie", "Ruluko", "Rum Raisin", "Ruslan Display", "Russo One", "Ruthie", "Rye", "STIX Two Text", "Sacramento", "Sahitya", "Sail", "Saira", "Saira Condensed", "Saira Extra Condensed", "Saira Semi Condensed", "Saira Stencil One", "Salsa", "Sanchez", "Sancreek", "Sansita", "Sansita Swashed", "Sarabun", "Sarala", "Sarina", "Sarpanch", "Sassy Frass", "Satisfy", "Sawarabi Gothic", "Sawarabi Mincho", "Scada", "Scheherazade New", "Schibsted Grotesk", "Schoolbell", "Scope One", "Seaweed Script", "Secular One", "Sedgwick Ave", "Sedgwick Ave Display", "Sen", "Send Flowers", "Sevillana", "Seymour One", "Shadows Into Light", "Shadows Into Light Two", "Shalimar", "Shantell Sans", "Shanti", "Share", "Share Tech", "Share Tech Mono", "Shippori Antique", "Shippori Antique B1", "Shippori Mincho", "Shippori Mincho B1", "Shizuru", "Shojumaru", "Short Stack", "Shrikhand", "Siemreap", "Sigmar", "Sigmar One", "Signika", "Signika Negative", "Silkscreen", "Simonetta", "Single Day", "Sintony", "Sirin Stencil", "Six Caps", "Skranji", "Slabo 13px", "Slabo 27px", "Slackey", "Slackside One", "Smokum", "Smooch", "Smooch Sans", "Smythe", "Sniglet", "Snippet", "Snowburst One", "Sofadi One", "Sofia", "Sofia Sans", "Sofia Sans Condensed", "Sofia Sans Extra Condensed", "Sofia Sans Semi Condensed", "Solitreo", "Solway", "Song Myung", "Sono", "Sonsie One", "Sora", "Sorts Mill Goudy", "Source Code Pro", "Source Sans 3", "Source Serif 4", "Space Grotesk", "Space Mono", "Special Elite", "Spectral", "Spectral SC", "Spicy Rice", "Spinnaker", "Spirax", "Splash", "Spline Sans", "Spline Sans Mono", "Squada One", "Square Peg", "Sree Krushnadevaraya", "Sriracha", "Srisakdi", "Staatliches", "Stalemate", "Stalinist One", "Stardos Stencil", "Stick", "Stick No Bills", "Stint Ultra Condensed", "Stint Ultra Expanded", "Stoke", "Strait", "Style Script", "Stylish", "Sue Ellen Francisco", "Suez One", "Sulphur Point", "Sumana", "Sunflower", "Sunshiney", "Supermercado One", "Sura", "Suranna", "Suravaram", "Suwannaphum", "Swanky and Moo Moo", "Syncopate", "Syne", "Syne Mono", "Syne Tactile", "Tai Heritage Pro", "Tajawal", "Tangerine", "Tapestry", "Taprom", "Tauri", "Taviraj", "Teko", "Tektur", "Telex", "Tenali Ramakrishna", "Tenor Sans", "Text Me One", "Texturina", "Thasadith", "The Girl Next Door", "The Nautigal", "Tienne", "Tillana", "Tilt Neon", "Tilt Prism", "Tilt Warp", "Timmana", "Tinos", "Tiro Bangla", "Tiro Devanagari Hindi", "Tiro Devanagari Marathi", "Tiro Devanagari Sanskrit", "Tiro Gurmukhi", "Tiro Kannada", "Tiro Tamil", "Tiro Telugu", "Titan One", "Titillium Web", "Tomorrow", "Tourney", "Trade Winds", "Train One", "Trirong", "Trispace", "Trocchi", "Trochut", "Truculenta", "Trykker", "Tsukimi Rounded", "Tulpen One", "Turret Road", "Twinkle Star", "Ubuntu", "Ubuntu Condensed", "Ubuntu Mono", "Uchen", "Ultra", "Unbounded", "Uncial Antiqua", "Underdog", "Unica One", "UnifrakturCook", "UnifrakturMaguntia", "Unkempt", "Unlock", "Unna", "Updock", "Urbanist", "VT323", "Vampiro One", "Varela", "Varela Round", "Varta", "Vast Shadow", "Vazirmatn", "Vesper Libre", "Viaoda Libre", "Vibes", "Vibur", "Victor Mono", "Vidaloka", "Viga", "Vina Sans", "Voces", "Volkhov", "Vollkorn", "Vollkorn SC", "Voltaire", "Vujahday Script", "Waiting for the Sunrise", "Wallpoet", "Walter Turncoat", "Warnes", "Water Brush", "Waterfall", "Wellfleet", "Wendy One", "Whisper", "WindSong", "Wire One", "Wix Madefor Display", "Wix Madefor Text", "Work Sans", "Xanh Mono", "Yaldevi", "Yanone Kaffeesatz", "Yantramanav", "Yatra One", "Yellowtail", "Yeon Sung", "Yeseva One", "Yesteryear", "Yomogi", "Yrsa", "Ysabeau", "Ysabeau Infant", "Ysabeau Office", "Ysabeau SC", "Yuji Boku", "Yuji Hentaigana Akari", "Yuji Hentaigana Akebono", "Yuji Mai", "Yuji Syuku", "Yusei Magic", "ZCOOL KuaiLe", "ZCOOL QingKe HuangYou", "ZCOOL XiaoWei", "Zen Antique", "Zen Antique Soft", "Zen Dots", "Zen Kaku Gothic Antique", "Zen Kaku Gothic New", "Zen Kurenaido", "Zen Loop", "Zen Maru Gothic", "Zen Old Mincho", "Zen Tokyo Zoo", "Zeyada", "Zhi Mang Xing", "Zilla Slab", "Zilla Slab Highlight"];
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "" : props.val;
  const [fonts, setfonts] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val == null || props.val == undefined || props.val.length == 0 ? [] : valZ.split(","));
  const [keyword, setkeyword] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)("");
  const [fontsFiltered, setfontsFiltered] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)([]);
  const [customFonts, setCustomFonts] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)([]);
  const [fontFaceCSS, setFontFaceCSS] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)("");
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (window?.postGridBlockEditor?.customFonts !== undefined && window?.postGridBlockEditor?.customFonts.length != 0) {
      setCustomFonts(window.postGridBlockEditor.customFonts);
    }
  }, [window.postGridBlockEditor]);
  // useEffect(() => {
  // 	apiFetch({
  // 		path: "/accordions/v2/get_options",
  // 		method: "POST",
  // 		data: { option: "post_grid_block_editor" },
  // 	}).then((res) => {
  // 		if (res.customFonts !== undefined && res.customFonts.length != 0) {
  // 			setCustomFonts(res.customFonts);
  // 		}
  // 	});
  // }, []);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    var str = "";
    {
      customFonts.length != 0 && customFonts.map((font, index) => {
        var fontFamily = font.family;
        var src = font.src[0]?.url;
        var fontWeight = font.weight;
        str += `@font-face {
    font-family: '${fontFamily}';
    src: url('${src}');
    font-weight: ${fontWeight};
  }`;
      });
    }
    setFontFaceCSS(str);
    var wpfooter = document.getElementById("wpfooter");
    var divWrap = document.getElementById("pg-font-face");
    if (divWrap != undefined) {
      document.getElementById("pg-font-face").outerHTML = "";
    }
    var divWrap = '<div id="pg-font-face"></div>';
    wpfooter.insertAdjacentHTML("beforeend", divWrap);
    var csswrappg = document.getElementById("pg-font-face");
    var fontFace = "<style>" + str + "</style>";
    csswrappg.insertAdjacentHTML("beforeend", fontFace);
  }, [customFonts]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: " mt-4",
    children: [!isLoaded && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Spinner, {})
    }), isLoaded && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_sortablejs__WEBPACK_IMPORTED_MODULE_3__.ReactSortable, {
        list: fonts,
        setList: item => {
          setfonts(item);
          props.onChange(item.toString(), "fontFamily");
        },
        children: fonts.map((font, i) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
            className: "flex my-3 items-center justify-between cursor-move hover:bg-gray-300",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "flex items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
                className: "bg-red-500 p-1 mr-2 cursor-pointer ",
                onClick: ev => {
                  fonts.splice(i, 1);
                  setfonts(fonts);
                  props.onChange(fonts.toString(), "fontFamily");
                },
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"], {
                  fill: "#fff",
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"]
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
                style: {
                  fontFamily: font
                },
                children: font
              })]
            }), i == 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
              className: "bg-yellow-500 p-1",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Primary", "accordions")
            })]
          }, i);
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "flex justify-between",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
          value: keyword,
          type: "text",
          autocomplete: "off",
          onChange: newVal => {
            setkeyword(newVal);
            var newValX = newVal.replace(/[^a-zA-Z ]/g, "");
            var newOptions = [];
            fontsLibrary.map(font => {
              let position = font.toLowerCase().search(newValX.toLowerCase());
              if (position < 0) {} else {
                newOptions.push(font);
              }
            });
            setfontsFiltered(newOptions);
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
          className: "bg-gray-400 text-white p-1 px-2 cursor-pointer",
          onClick: ev => {
            fonts.unshift(keyword);
            var fontsY = fonts.slice(0, 3);
            setfonts(fontsY);
            //setfonts(fonts);
            props.onChange(fontsY.toString(), "fontFamily");
          },
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Add", "accordions")
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "my-3 h-60 overflow-y-scroll",
        children: [keyword.length == 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
          children: [customFonts.length > 0 && customFonts.map(font => {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "p-1 my-1 bg-white hover:bg-gray-300 border flex items-center cursor-pointer",
              style: {
                fontFamily: font.family
              },
              onClick: ev => {
                var fontsX = fonts.unshift(font.family);
                var fontsY = fonts.slice(0, 3);
                // var fontsY = fonts.slice(0, 3);
                setfonts(fontsY);
                props.onChange(fontsY.toString(), "fontFamily");
              },
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"], {
                icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("span", {
                children: [" ", font.family]
              })]
            });
          }), fontsLibrary.map(font => {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "p-1 my-1 bg-white hover:bg-gray-300 border flex items-center cursor-pointer",
              style: {
                fontFamily: font
              },
              onClick: ev => {
                var fontsX = fonts.unshift(font);
                var fontsY = fonts.slice(0, 3);
                setfonts(fontsY);
                props.onChange(fontsY.toString(), "fontFamily");
              },
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"], {
                icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("span", {
                children: [" ", font]
              })]
            });
          })]
        }), keyword.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
          children: fontsFiltered.map(font => {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
              className: "p-1 my-1 bg-white hover:bg-gray-300 border flex items-center cursor-pointer",
              style: {
                fontFamily: font
              },
              onClick: ev => {
                var fontsX = fonts.unshift(font);
                var fontsY = fonts.slice(0, 3);
                setfonts(fontsY);
                //setfonts(fonts);
                props.onChange(fonts.toString(), "fontFamily");
              },
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"], {
                icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("span", {
                children: [" ", font]
              })]
            });
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {})]
  });
}
class PGcssFontFamily extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true,
      isLoaded: false
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  componentDidMount() {
    setTimeout(() => {
      this.setState(state => ({
        isLoaded: !state.isLoaded
      }));
    }, 1000);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning,
      isLoaded: this.state.isLoaded
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFontFamily);

/***/ }),

/***/ "./src/components/css-font-size/index.js":
/*!***********************************************!*\
  !*** ./src/components/css-font-size/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
    // large: { "label": "large", "value": "large" },
    // larger: { "label": "larger", "value": "larger" },
    // medium: { "label": "medium", "value": "medium" },
    // small: { "label": "small", "value": "small" },
    // smaller: { "label": "smaller", "value": "smaller" },
    // "x-large": { "label": "x-large", "value": "x-large" },
    // "x-small": { "label": "x-small", "value": "x-small" },
    // "xx-large": { "label": "xx-large", "value": "xx-large" },
    // "xx-small": { "label": "xx-small", "value": "xx-small" },
    // "xxx-large": { "label": "xxx-large", "value": "xxx-large" },
    // revert: { "label": "revert", "value": "revert" },
    // unset: { "label": "unset", "value": "unset" },
    // initial: { "label": "initial", "value": "initial" },
    // inherit: { "label": "inherit", "value": "inherit" },
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  valZ = typeof valZ == "object" ? (valZ.val == undefined ? "px" : valZ.val) + (valZ.unit == undefined ? "px" : valZ.unit) : valZ;
  var widthValX = valZ == undefined || valZ.match(/[+-]?([0-9]*[.])?[0-9]+/g) == null ? 0 : valZ.match(/[+-]?([0-9]*[.])?[0-9]+/g)[0];
  var widthUnitX = valZ == undefined || valZ.match(/[a-zA-Z%]+/g) == null ? "px" : valZ.match(/[a-zA-Z%]+/g)[0];
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnit, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between",
    children: [widthUnit != "auto" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      step: "0.01",
      disabled: widthUnit == "auto" ? true : false,
      onChange: newVal => {
        setwidthVal(newVal);
        if (widthUnit == "auto") {
          // props.onChange(widthUnit, 'width');
          if (isImportant) {
            props.onChange(widthUnit + " !important", "fontSize");
          } else {
            props.onChange(widthUnit, "fontSize");
          }
        } else {
          //props.onChange(newVal + widthUnit, 'width');
          if (isImportant) {
            props.onChange(newVal + widthUnit + " !important", "fontSize");
          } else {
            props.onChange(newVal + widthUnit, "fontSize");
          }
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: "",
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: " ",
            children: valZ ? unitArgs[widthUnit].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "w-32",
          children: Object.entries(unitArgs).map(y => {
            var index = y[0];
            var x = y[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                setwidthUnit(x.value);
                if (x.value == "auto") {
                  if (isImportant) {
                    props.onChange(x.value + " !important", "fontSize");
                  } else {
                    props.onChange(x.value, "fontSize");
                  }
                } else {
                  if (isImportant) {
                    props.onChange(widthVal + x.value + " !important", "fontSize");
                  } else {
                    props.onChange(widthVal + x.value, "fontSize");
                  }
                }
              },
              children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: x.label
              })
            });
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          if (widthUnit == "auto") {
            props.onChange(widthUnit, "fontSize");
          } else {
            props.onChange(widthVal + widthUnit, "fontSize");
          }
        } else {
          if (widthUnit == "auto") {
            props.onChange(widthUnit + " !important", "fontSize");
          } else {
            props.onChange(widthVal + widthUnit + " !important", "fontSize");
          }
        }
      }
    })]
  });
}
class PGcssFontSize extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFontSize);

/***/ }),

/***/ "./src/components/css-font-stretch/index.js":
/*!**************************************************!*\
  !*** ./src/components/css-font-stretch/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    "ultra-condensed": {
      label: "ultra-condensed",
      value: "ultra-condensed"
    },
    "extra-condensed": {
      label: "extra-condensed",
      value: "extra-condensed"
    },
    condensed: {
      label: "condensed",
      value: "condensed"
    },
    "semi-condensed": {
      label: "semi-condensed",
      value: "semi-condensed"
    },
    normal: {
      label: "normal",
      value: "normal"
    },
    "semi-expanded": {
      label: "semi-expanded",
      value: "semi-expanded"
    },
    expanded: {
      label: "expanded",
      value: "expanded"
    },
    "extra-expanded": {
      label: "extra-expanded",
      value: "extra-expanded"
    },
    "ultra-expanded": {
      label: "ultra-expanded",
      value: "ultra-expanded"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'fontStretch');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "fontStretch");
              } else {
                props.onChange(x.value, "fontStretch");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "fontStretch");
        } else {
          props.onChange(align + " !important", "fontStretch");
        }
      }
    })]
  });
}
class PGcssFontStretch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFontStretch);

/***/ }),

/***/ "./src/components/css-font-style/index.js":
/*!************************************************!*\
  !*** ./src/components/css-font-style/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    normal: {
      label: "normal",
      value: "normal"
    },
    italic: {
      label: "italic",
      value: "italic"
    },
    oblique: {
      label: "oblique",
      value: "oblique"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'fontStyle');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "fontStyle");
              } else {
                props.onChange(x.value, "fontStyle");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "fontStyle");
        } else {
          props.onChange(align + " !important", "fontStyle");
        }
      }
    })]
  });
}
class PGcssFontStyle extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFontStyle);

/***/ }),

/***/ "./src/components/css-font-variant-caps/index.js":
/*!*******************************************************!*\
  !*** ./src/components/css-font-variant-caps/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    normal: {
      label: "normal",
      value: "normal"
    },
    "small-caps": {
      label: "small-caps",
      value: "small-caps"
    },
    "all-small-caps": {
      label: "all-small-caps",
      value: "all-small-caps"
    },
    "petite-caps": {
      label: "petite-caps",
      value: "petite-caps"
    },
    "all-petite-caps": {
      label: "all-petite-caps",
      value: "all-petite-caps"
    },
    unicase: {
      label: "unicase",
      value: "unicase"
    },
    "titling-caps": {
      label: "titling-caps",
      value: "titling-caps"
    },
    initial: {
      label: "initial",
      value: "initial"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    unset: {
      label: "unset",
      value: "unset"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'fontVariantCaps');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "fontVariantCaps");
              } else {
                props.onChange(x.value, "fontVariantCaps");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "fontVariantCaps");
        } else {
          props.onChange(align + " !important", "fontVariantCaps");
        }
      }
    })]
  });
}
class PGcssFontVariantCaps extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFontVariantCaps);

/***/ }),

/***/ "./src/components/css-font-weight/index.js":
/*!*************************************************!*\
  !*** ./src/components/css-font-weight/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    normal: {
      label: "normal",
      value: "normal"
    },
    bold: {
      label: "bold",
      value: "bold"
    },
    bolder: {
      label: "bolder",
      value: "bolder"
    },
    lighter: {
      label: "lighter",
      value: "lighter"
    },
    100: {
      label: "100",
      value: "100"
    },
    200: {
      label: "200",
      value: "200"
    },
    300: {
      label: "300",
      value: "300"
    },
    400: {
      label: "400",
      value: "400"
    },
    500: {
      label: "500",
      value: "500"
    },
    600: {
      label: "600",
      value: "600"
    },
    700: {
      label: "700",
      value: "700"
    },
    800: {
      label: "800",
      value: "800"
    },
    900: {
      label: "900",
      value: "900"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Clear", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // onChange(x.value, 'fontWeight');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "fontWeight");
              } else {
                props.onChange(x.value, "fontWeight");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "fontWeight");
        } else {
          props.onChange(align + " !important", "fontWeight");
        }
      }
    })]
  });
}
class PGcssFontWeight extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssFontWeight);

/***/ }),

/***/ "./src/components/css-gap/index.js":
/*!*****************************************!*\
  !*** ./src/components/css-gap/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    auto: {
      label: "AUTO",
      value: "auto"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  var widthUnitX = valZ == undefined || valZ.match(/[a-zA-Z%]+/g) == null ? "px" : valZ.match(/[a-zA-Z%]+/g)[0];
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnit, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between",
    children: [widthUnit != "auto" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      disabled: widthUnit == "auto" ? true : false,
      onChange: newVal => {
        setwidthVal(newVal);
        if (widthUnit == "auto") {
          // props.onChange(widthUnit, 'width');
          if (isImportant) {
            props.onChange(widthUnit + " !important", "gap");
          } else {
            props.onChange(widthUnit, "gap");
          }
        } else {
          //props.onChange(newVal + widthUnit, 'width');
          if (isImportant) {
            props.onChange(newVal + widthUnit + " !important", "gap");
          } else {
            props.onChange(newVal + widthUnit, "gap");
          }
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom left",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: "",
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: " ",
            children: valZ ? unitArgs[widthUnit].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "w-32 pg-font",
          children: Object.entries(unitArgs).map(y => {
            var index = y[0];
            var x = y[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                setwidthUnit(x.value);
                if (x.value == "auto") {
                  if (isImportant) {
                    props.onChange(x.value + " !important", "gap");
                  } else {
                    props.onChange(x.value, "gap");
                  }
                } else {
                  if (isImportant) {
                    props.onChange(widthVal + x.value + " !important", "gap");
                  } else {
                    props.onChange(widthVal + x.value, "gap");
                  }
                }
              },
              children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: x.label
              })
            });
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          if (widthUnit == "auto") {
            props.onChange(widthUnit, "gap");
          } else {
            props.onChange(widthVal + widthUnit, "gap");
          }
        } else {
          if (widthUnit == "auto") {
            props.onChange(widthUnit + " !important", "gap");
          } else {
            props.onChange(widthVal + widthUnit + " !important", "gap");
          }
        }
      }
    })]
  });
}
class PGcssGap extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssGap);

/***/ }),

/***/ "./src/components/css-grid-auto-columns/index.js":
/*!*******************************************************!*\
  !*** ./src/components/css-grid-auto-columns/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    fr: {
      label: "FR",
      value: "fr"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    auto: {
      label: "AUTO",
      value: "auto"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  var widthUnitX = valZ == undefined || valZ.match(/[a-zA-Z%]+/g) == null ? "px" : valZ.match(/[a-zA-Z%]+/g)[0];
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnit, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between",
    children: [widthUnit != "auto" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      disabled: widthUnit == "auto" ? true : false,
      onChange: newVal => {
        setwidthVal(newVal);
        if (widthUnit == "auto") {
          // props.onChange(widthUnit, 'width');
          if (isImportant) {
            props.onChange(widthUnit + " !important", "gridAutoColumns");
          } else {
            props.onChange(widthUnit, "gridAutoColumns");
          }
        } else {
          //props.onChange(newVal + widthUnit, 'width');
          if (isImportant) {
            props.onChange(newVal + widthUnit + " !important", "gridAutoColumns");
          } else {
            props.onChange(newVal + widthUnit, "gridAutoColumns");
          }
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom left",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: "",
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: " ",
            children: valZ ? unitArgs[widthUnit].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "w-32 pg-font",
          children: Object.entries(unitArgs).map(y => {
            var index = y[0];
            var x = y[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                setwidthUnit(x.value);
                if (x.value == "auto") {
                  if (isImportant) {
                    props.onChange(x.value + " !important", "gridAutoColumns");
                  } else {
                    props.onChange(x.value, "gridAutoColumns");
                  }
                } else {
                  if (isImportant) {
                    props.onChange(widthVal + x.value + " !important", "gridAutoColumns");
                  } else {
                    props.onChange(widthVal + x.value, "gridAutoColumns");
                  }
                }
              },
              children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: x.label
              })
            });
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          if (widthUnit == "auto") {
            props.onChange(widthUnit, "gridAutoColumns");
          } else {
            props.onChange(widthVal + widthUnit, "gridAutoColumns");
          }
        } else {
          if (widthUnit == "auto") {
            props.onChange(widthUnit + " !important", "gridAutoColumns");
          } else {
            props.onChange(widthVal + widthUnit + " !important", "gridAutoColumns");
          }
        }
      }
    })]
  });
}
class PGcssGridAutoColumns extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssGridAutoColumns);

/***/ }),

/***/ "./src/components/css-grid-auto-flow/index.js":
/*!****************************************************!*\
  !*** ./src/components/css-grid-auto-flow/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    column: {
      label: "column",
      value: "column"
    },
    row: {
      label: "row",
      value: "row"
    },
    dense: {
      label: "dense",
      value: "dense"
    },
    "column-dense": {
      label: "column dense",
      value: "column-dense"
    },
    "row-dense": {
      label: "row dense",
      value: "row-dense"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Place Items", "accordions"),
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // props.onChange(x.value, 'alignItems');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "gridAutoFlow");
              } else {
                props.onChange(x.value, "gridAutoFlow");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "gridAutoFlow");
        } else {
          props.onChange(align + " !important", "gridAutoFlow");
        }
      }
    })]
  });
}
class PGcssGridAutoFlow extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssGridAutoFlow);

/***/ }),

/***/ "./src/components/css-grid-column-end/index.js":
/*!*****************************************************!*\
  !*** ./src/components/css-grid-column-end/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex mt-4 justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      onChange: newVal => {
        setwidthVal(newVal);
        // props.onChange(newVal, 'gridColumnEnd');
        if (isImportant) {
          props.onChange(newVal + " !important", "gridColumnEnd");
        } else {
          props.onChange(newVal, "gridColumnEnd");
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(widthVal, "gridColumnEnd");
        } else {
          props.onChange(widthVal + " !important", "gridColumnEnd");
        }
      }
    })]
  });
}
class PGcssGridColumnEnd extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssGridColumnEnd);

/***/ }),

/***/ "./src/components/css-grid-column-start/index.js":
/*!*******************************************************!*\
  !*** ./src/components/css-grid-column-start/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      onChange: newVal => {
        setwidthVal(newVal);
        // props.onChange(newVal, 'gridColumnStart');
        if (isImportant) {
          props.onChange(newVal + " !important", "gridColumnStart");
        } else {
          props.onChange(newVal, "gridColumnStart");
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(widthVal, "gridColumnStart");
        } else {
          props.onChange(widthVal + " !important", "gridColumnStart");
        }
      }
    })]
  });
}
class PGcssGridColumnStart extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssGridColumnStart);

/***/ }),

/***/ "./src/components/css-grid-row-end/index.js":
/*!**************************************************!*\
  !*** ./src/components/css-grid-row-end/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex mt-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      onChange: newVal => {
        setwidthVal(newVal);
        // props.onChange(newVal, 'gridRowEnd');
        if (isImportant) {
          props.onChange(newVal + " !important", "gridRowEnd");
        } else {
          props.onChange(newVal, "gridRowEnd");
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(widthVal, "gridRowEnd");
        } else {
          props.onChange(widthVal + " !important", "gridRowEnd");
        }
      }
    })]
  });
}
class PGcssGridRowEnd extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssGridRowEnd);

/***/ }),

/***/ "./src/components/css-grid-row-start/index.js":
/*!****************************************************!*\
  !*** ./src/components/css-grid-row-start/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex mt-4 justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      onChange: newVal => {
        setwidthVal(newVal);
        // props.onChange(newVal, 'gridRowStart');
        if (isImportant) {
          props.onChange(newVal + " !important", "gridRowStart");
        } else {
          props.onChange(newVal, "gridRowStart");
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(widthVal, "gridRowStart");
        } else {
          props.onChange(widthVal + " !important", "gridRowStart");
        }
      }
    })]
  });
}
class PGcssGridRowStart extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssGridRowStart);

/***/ }),

/***/ "./src/components/css-grid-template-columns/index.js":
/*!***********************************************************!*\
  !*** ./src/components/css-grid-template-columns/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/input-color-picker */ "./src/components/input-color-picker/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component,
  RawHTML
} = wp.element;








function Html(props) {
  if (!props.warn) {
    return null;
  }
  //var valParts = ['1fr', '1fr', '1fr'];
  var valParts = props.val == undefined || props.val == null || props.val.length == 0 ? ['1fr'] : props.val.split(" ");
  var unitArgs = {
    fr: {
      "label": "FR",
      "value": "fr"
    },
    px: {
      "label": "PX",
      "value": "px"
    },
    em: {
      "label": "EM",
      "value": "em"
    },
    rem: {
      "label": "REM",
      "value": "rem"
    },
    "%": {
      "label": "%",
      "value": "%"
    },
    cm: {
      "label": "CM",
      "value": "cm"
    },
    mm: {
      "label": "MM",
      "value": "mm"
    },
    in: {
      "label": "IN",
      "value": "in"
    },
    pt: {
      "label": "PT",
      "value": "pt"
    },
    pc: {
      "label": "PC",
      "value": "pc"
    },
    ex: {
      "label": "EX",
      "value": "ex"
    },
    ch: {
      "label": "CH",
      "value": "ch"
    },
    vw: {
      "label": "VW",
      "value": "vw"
    },
    vh: {
      "label": "VH",
      "value": "vh"
    },
    vmin: {
      "label": "VMIN",
      "value": "vmin"
    },
    vmax: {
      "label": "VMAX",
      "value": "vmax"
    }
    // none: { "label": "none", "value": "none" },
    // inherit: { "label": "inherit", "value": "inherit" },
    // initial: { "label": "initial", "value": "initial" },
    // revert: { "label": "revert", "value": "revert" },
    // unset: { "label": "unset", "value": "unset" },
  };
  const [valArgs, setvalArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valParts);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {}, [props.val]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "bg-green-600 hover:bg-green-500 rounded-sm inline-block cursor-pointer text-white px-3 py-1 my-4",
      onClick: ev => {
        var valArgsX = valArgs.concat('1fr');
        setvalArgs(valArgsX);
        props.onChange(valArgsX.join(' '), 'gridTemplateColumns');
      },
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Add", "accordions")
    }), valArgs.map((part, index) => {
      var valNumber = part.match(/-?\d+/g) != null ? part.match(/-?\d+/g)[0] : 1;
      var valUnit = part.match(/[a-zA-Z%]+/g) != null ? part.match(/[a-zA-Z%]+/g)[0] : 'fr';
      // var valNumber = (valArgs[0] == undefined || valArgs[0].match(/-?\d+/g) == null) ? 0 : valArgs[0].match(/-?\d+/g)[0];
      //   var valUnit = (valArgs[0] == undefined || valArgs[0].match(/[a-zA-Z%]+/g) == null) ? 'px' : valArgs[0].match(/[a-zA-Z%]+/g)[0];
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "my-2",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "flex justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
            className: "bg-red-500  inline-block hover:bg-red-400 mx-3 p-1 cursor-pointer",
            onClick: ev => {
              valArgs.splice(index, 1);
              setvalArgs(valArgs);
              props.onChange(valArgs.join(' '), 'gridTemplateColumns');
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"], {
              fill: "#fff",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
            value: valNumber,
            type: "number",
            onChange: newVal => {
              var valIndex = newVal + valUnit;
              valArgs[index] = valIndex;
              setvalArgs(valArgs);
              props.onChange(valArgs.join(' '), 'gridTemplateColumns');
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
              position: "bottom right",
              renderToggle: ({
                isOpen,
                onToggle
              }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
                title: "",
                onClick: onToggle,
                "aria-expanded": isOpen,
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                  className: " ",
                  children: valUnit != undefined ? unitArgs[valUnit].label : 'Select...'
                })
              }),
              renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                className: "w-32",
                children: Object.entries(unitArgs).map(y => {
                  var j = y[0];
                  var x = y[1];
                  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                    className: 'px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer',
                    onClick: ev => {
                      //props.onChange(valNumber + x.value, 'border');
                      var valIndex = valNumber + x.value;
                      valArgs[index] = valIndex;
                      setvalArgs(valArgs);
                      props.onChange(valArgs.join(' '), 'gridTemplateColumns');
                    },
                    children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                      children: x.label
                    })
                  });
                })
              })
            })
          })]
        })
      });
    })]
  });
}
class PGcssGridTemplateColumns extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssGridTemplateColumns);

/***/ }),

/***/ "./src/components/css-grid-template-rows/index.js":
/*!********************************************************!*\
  !*** ./src/components/css-grid-template-rows/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _components_input_color_picker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/input-color-picker */ "./src/components/input-color-picker/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
const {
  Component,
  RawHTML
} = wp.element;








function Html(props) {
  if (!props.warn) {
    return null;
  }
  //var valParts = ['1fr', '1fr', '1fr'];
  var valParts = props.val == undefined || props.val == null || props.val.length == 0 ? ["1fr"] : props.val.split(" ");
  var unitArgs = {
    fr: {
      label: "FR",
      value: "fr"
    },
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
    // none: { "label": "none", "value": "none" },
    // inherit: { "label": "inherit", "value": "inherit" },
    // initial: { "label": "initial", "value": "initial" },
    // revert: { "label": "revert", "value": "revert" },
    // unset: { "label": "unset", "value": "unset" },
  };
  const [valArgs, setvalArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valParts);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {}, [props.val]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: "bg-green-600 hover:bg-green-500 rounded-sm inline-block cursor-pointer text-white px-3 py-1 my-4",
      onClick: ev => {
        var valArgsX = valArgs.concat("1fr");
        setvalArgs(valArgsX);
        props.onChange(valArgsX.join(" "), "gridTemplateRows");
      },
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Add", "accordions")
    }), valArgs.map((part, index) => {
      var valNumber = part.match(/-?\d+/g) != null ? part.match(/-?\d+/g)[0] : 1;
      var valUnit = part.match(/[a-zA-Z%]+/g) != null ? part.match(/[a-zA-Z%]+/g)[0] : "fr";
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
        className: "my-2",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
          className: "flex justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
            className: "bg-red-500  inline-block hover:bg-red-400 mx-3 p-1 cursor-pointer",
            onClick: ev => {
              valArgs.splice(index, 1);
              setvalArgs(valArgs);
              props.onChange(valArgs.join(" "), "gridTemplateRows");
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"], {
              fill: "#fff",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
            value: valNumber,
            type: "number",
            onChange: newVal => {
              var valIndex = newVal + valUnit;
              valArgs[index] = valIndex;
              setvalArgs(valArgs);
              props.onChange(valArgs.join(" "), "gridTemplateRows");
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
              position: "bottom right",
              renderToggle: ({
                isOpen,
                onToggle
              }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
                title: "",
                onClick: onToggle,
                "aria-expanded": isOpen,
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                  className: " ",
                  children: valUnit != undefined ? unitArgs[valUnit].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
                })
              }),
              renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                className: "w-32",
                children: Object.entries(unitArgs).map(y => {
                  var j = y[0];
                  var x = y[1];
                  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
                    className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
                    onClick: ev => {
                      //props.onChange(valNumber + x.value, 'border');
                      var valIndex = valNumber + x.value;
                      valArgs[index] = valIndex;
                      setvalArgs(valArgs);
                      props.onChange(valArgs.join(" "), "gridTemplateRows");
                    },
                    children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
                      children: x.label
                    })
                  });
                })
              })
            })
          })]
        })
      });
    })]
  });
}
class PGcssGridTemplateRows extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssGridTemplateRows);

/***/ }),

/***/ "./src/components/css-height/index.js":
/*!********************************************!*\
  !*** ./src/components/css-height/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    auto: {
      label: "AUTO",
      value: "auto"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  if (typeof props.val == "object") {
    var valZ = props.val.val + props.val.unit;
  } else {
    var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  }
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.split(" "));
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  var widthValX = valArgs[0] == undefined || valArgs[0].match(/-?\d+/g) == null ? 0 : valArgs[0].match(/-?\d+/g)[0];
  var widthUnitX = valArgs[0] == undefined || valArgs[0].match(/[a-zA-Z%]+/g) == null ? "px" : valArgs[0].match(/[a-zA-Z%]+/g)[0];
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnit, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [widthUnit != "auto" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      disabled: widthUnit == "auto" ? true : false,
      onChange: newVal => {
        setwidthVal(newVal);
        // if (widthUnit == 'auto') {
        //   props.onChange(widthUnit, 'height');
        // } else {
        //   props.onChange(newVal + widthUnit, 'height');
        // }
        if (widthUnit == "auto") {
          // props.onChange(widthUnit, 'width');
          if (isImportant) {
            props.onChange(widthUnit + " !important", "height");
          } else {
            props.onChange(widthUnit, "height");
          }
        } else {
          //props.onChange(newVal + widthUnit, 'width');
          if (isImportant) {
            props.onChange(newVal + widthUnit + " !important", "height");
          } else {
            props.onChange(newVal + widthUnit, "height");
          }
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom left",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: "",
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: " ",
            children: valZ ? unitArgs[widthUnit].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "w-32",
          children: Object.entries(unitArgs).map(y => {
            var index = y[0];
            var x = y[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                setwidthUnit(x.value);
                if (x.value == "auto") {
                  if (isImportant) {
                    props.onChange(x.value + " !important", "height");
                  } else {
                    props.onChange(x.value, "height");
                  }
                } else {
                  if (isImportant) {
                    props.onChange(widthVal + x.value + " !important", "height");
                  } else {
                    props.onChange(widthVal + x.value, "height");
                  }
                }
              },
              children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: x.label
              })
            });
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          if (widthUnit == "auto") {
            props.onChange(widthUnit, "height");
          } else {
            props.onChange(widthVal + widthUnit, "height");
          }
        } else {
          if (widthUnit == "auto") {
            props.onChange(widthUnit + " !important", "height");
          } else {
            props.onChange(widthVal + widthUnit + " !important", "height");
          }
        }
      }
    })]
  });
}
class PGcssHeight extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssHeight);

/***/ }),

/***/ "./src/components/css-justify-content/index.js":
/*!*****************************************************!*\
  !*** ./src/components/css-justify-content/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML
} = wp.element;




function Html(props) {
  if (!props.warn) {
    return null;
  }
  var args = {
    start: {
      label: "start",
      value: "start"
    },
    end: {
      label: "end",
      value: "end"
    },
    left: {
      label: "left",
      value: "left"
    },
    center: {
      label: "center",
      value: "center"
    },
    right: {
      label: "right",
      value: "right"
    },
    stretch: {
      label: "stretch",
      value: "stretch"
    },
    "flex-start": {
      label: "flex start	",
      value: "flex-start"
    },
    "flex-end": {
      label: "flex end	",
      value: "flex-end"
    },
    "space-between": {
      label: "space between",
      value: "space-between"
    },
    "space-around": {
      label: "space around",
      value: "space-around"
    },
    "space-evenly": {
      label: "space evenly",
      value: "space-evenly"
    },
    normal: {
      label: "normal",
      value: "normal"
    },
    start: {
      label: "start",
      value: "start"
    },
    baseline: {
      label: "baseline",
      value: "baseline"
    },
    revert: {
      label: "revert",
      value: "revert"
    },
    unset: {
      label: "unset",
      value: "unset"
    },
    inherit: {
      label: "inherit",
      value: "inherit"
    },
    initial: {
      label: "initial",
      value: "initial"
    }
  };
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(props.val.split(" "));
  const [align, setalign] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[0]);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between items-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
      position: "bottom",
      renderToggle: ({
        isOpen,
        onToggle
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        title: "Align Content",
        onClick: onToggle,
        "aria-expanded": isOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: " ",
          children: args[align] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions") : args[align].label
        })
      }),
      renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "w-32 pg-font",
        children: Object.entries(args).map(args => {
          var index = args[0];
          var x = args[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
            onClick: ev => {
              // props.onChange(x.value, 'justifyContent');
              setalign(x.value);
              if (isImportant) {
                props.onChange(x.value + " !important", "justifyContent");
              } else {
                props.onChange(x.value, "justifyContent");
              }
            },
            children: [!x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Reset", "accordions")
            }), x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.label
            })]
          });
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important (Enabled)", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          props.onChange(align, "justifyContent");
        } else {
          props.onChange(align + " !important", "justifyContent");
        }
      }
    })]
  });
}
class PGcssJustifyContent extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssJustifyContent);

/***/ }),

/***/ "./src/components/css-left/index.js":
/*!******************************************!*\
  !*** ./src/components/css-left/index.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    auto: {
      label: "AUTO",
      value: "auto"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  if (typeof props.val == "object") {
    var valZ = props.val.val + props.val.unit;
  } else {
    var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  }
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  var widthUnitX = valZ == undefined || valZ.match(/[a-zA-Z%]+/g) == null ? "px" : valZ.match(/[a-zA-Z%]+/g)[0];
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnit, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between",
    children: [widthUnit != "auto" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      disabled: widthUnit == "auto" ? true : false,
      onChange: newVal => {
        setwidthVal(newVal);
        if (widthUnit == "auto") {
          // props.onChange(widthUnit, 'width');
          if (isImportant) {
            props.onChange(widthUnit + " !important", "left");
          } else {
            props.onChange(widthUnit, "left");
          }
        } else {
          //props.onChange(newVal + widthUnit, 'width');
          if (isImportant) {
            props.onChange(newVal + widthUnit + " !important", "left");
          } else {
            props.onChange(newVal + widthUnit, "left");
          }
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom left",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: "",
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: " ",
            children: valZ ? unitArgs[widthUnit].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "w-32",
          children: Object.entries(unitArgs).map(y => {
            var index = y[0];
            var x = y[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                setwidthUnit(x.value);
                if (x.value == "auto") {
                  if (isImportant) {
                    props.onChange(x.value + " !important", "left");
                  } else {
                    props.onChange(x.value, "left");
                  }
                } else {
                  if (isImportant) {
                    props.onChange(widthVal + x.value + " !important", "left");
                  } else {
                    props.onChange(widthVal + x.value, "left");
                  }
                }
              },
              children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: x.label
              })
            });
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          if (widthUnit == "auto") {
            props.onChange(widthUnit, "left");
          } else {
            props.onChange(widthVal + widthUnit, "left");
          }
        } else {
          if (widthUnit == "auto") {
            props.onChange(widthUnit + " !important", "left");
          } else {
            props.onChange(widthVal + widthUnit + " !important", "left");
          }
        }
      }
    })]
  });
}
class PGcssLeft extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssLeft);

/***/ }),

/***/ "./src/components/css-letter-spacing/index.js":
/*!****************************************************!*\
  !*** ./src/components/css-letter-spacing/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/[+-]?([0-9]*[.])?[0-9]+/g) == null ? 0 : valZ.match(/[+-]?([0-9]*[.])?[0-9]+/g)[0];
  var widthUnitX = valZ == undefined || valZ.match(/[a-zA-Z%]+/g) == null ? "px" : valZ.match(/[a-zA-Z%]+/g)[0];
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnit, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex mt-4",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      onChange: newVal => {
        setwidthVal(newVal);
        if (widthUnit == "auto") {
          // props.onChange(widthUnit, 'width');
          if (isImportant) {
            props.onChange(widthUnit + " !important", "letterSpacing");
          } else {
            props.onChange(widthUnit, "letterSpacing");
          }
        } else {
          //props.onChange(newVal + widthUnit, 'width');
          if (isImportant) {
            props.onChange(newVal + widthUnit + " !important", "letterSpacing");
          } else {
            props.onChange(newVal + widthUnit, "letterSpacing");
          }
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: "Letter Spacing",
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: " ",
            children: props.val ? unitArgs[widthUnit].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "w-32",
          children: Object.entries(unitArgs).map(y => {
            var index = y[0];
            var x = y[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                setwidthUnit(x.value);
                if (x.value == "auto") {
                  if (isImportant) {
                    props.onChange(x.value + " !important", "letterSpacing");
                  } else {
                    props.onChange(x.value, "letterSpacing");
                  }
                } else {
                  if (isImportant) {
                    props.onChange(widthVal + x.value + " !important", "letterSpacing");
                  } else {
                    props.onChange(widthVal + x.value, "letterSpacing");
                  }
                }
              },
              children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: x.label
              })
            });
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          if (widthUnit == "auto") {
            props.onChange(widthUnit, "letterSpacing");
          } else {
            props.onChange(widthVal + widthUnit, "letterSpacing");
          }
        } else {
          if (widthUnit == "auto") {
            props.onChange(widthUnit + " !important", "letterSpacing");
          } else {
            props.onChange(widthVal + widthUnit + " !important", "letterSpacing");
          }
        }
      }
    })]
  });
}
class PGcssLetterSpacing extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssLetterSpacing);

/***/ }),

/***/ "./src/components/css-line-height/index.js":
/*!*************************************************!*\
  !*** ./src/components/css-line-height/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    normal: {
      label: "Normal",
      value: "normal"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  if (typeof props.val == "object") {
    var valZ = props.val.val + props.val.unit;
  } else {
    var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  }
  const [valArgs, setValArgs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.split(" "));
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valArgs[1] == undefined ? false : true);
  var widthValX = valArgs[0] == undefined || valArgs[0].match(/-?\d+/g) == null ? 0 : valArgs[0].match(/-?\d+/g)[0];
  var widthUnitX = valArgs[0] == undefined || valArgs[0].match(/[a-zA-Z%]+/g) == null ? "px" : valArgs[0].match(/[a-zA-Z%]+/g)[0];
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnit, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: [(widthUnit != "max-content" || widthUnit != "min-content" || widthUnit != "inherit" || widthUnit != "initial" || widthUnit != "revert" || widthUnit != "revert-layer" || widthUnit != "unset") && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "flex justify-between items-center",
      children: [widthUnit != "normal" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
        value: widthVal,
        type: "number",
        disabled: widthUnit == "normal" || widthUnit == "max-content" || widthUnit == "min-content" || widthUnit == "inherit" || widthUnit == "initial" || widthUnit == "revert" || widthUnit == "revert-layer" || widthUnit == "unset" ? true : false,
        onChange: newVal => {
          setwidthVal(newVal);
          if (widthUnit == "normal") {
            // props.onChange(widthUnit, 'lineHeight');
            if (isImportant) {
              props.onChange(widthUnit + " !important", "lineHeight");
            } else {
              props.onChange(widthUnit, "lineHeight");
            }
          } else {
            //props.onChange(newVal + widthUnit, 'lineHeight');
            if (isImportant) {
              props.onChange(newVal + widthUnit + " !important", "lineHeight");
            } else {
              props.onChange(newVal + widthUnit, "lineHeight");
            }
          }
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
          position: "bottom left",
          renderToggle: ({
            isOpen,
            onToggle
          }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
            title: "",
            onClick: onToggle,
            "aria-expanded": isOpen,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: " ",
              children: unitArgs[widthUnit] == undefined ? "Select..." : unitArgs[widthUnit].label
            })
          }),
          renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: "w-32",
            children: Object.entries(unitArgs).map(y => {
              var index = y[0];
              var x = y[1];
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
                onClick: ev => {
                  setwidthUnit(x.value);
                  if (x.value == "normal") {
                    if (isImportant) {
                      props.onChange(x.value + " !important", "lineHeight");
                    } else {
                      props.onChange(x.value, "lineHeight");
                    }
                  } else {
                    if (isImportant) {
                      props.onChange(widthVal + x.value + " !important", "lineHeight");
                    } else {
                      props.onChange(widthVal + x.value, "lineHeight");
                    }
                  }
                },
                children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                  children: x.label
                })
              });
            })
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
        help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
        checked: isImportant,
        onChange: arg => {
          setImportant(isImportant => !isImportant);
          if (isImportant) {
            if (widthUnit == "normal") {
              props.onChange(widthUnit, "lineHeight");
            } else {
              props.onChange(widthVal + widthUnit, "lineHeight");
            }
          } else {
            if (widthUnit == "normal") {
              props.onChange(widthUnit + " !important", "lineHeight");
            } else {
              props.onChange(widthVal + widthUnit + " !important", "lineHeight");
            }
          }
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("label", {
          htmlFor: "",
          children: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Global Value", "accordions"), " "]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.SelectControl, {
          label: "",
          value: widthUnit,
          options: [{
            label: "Choose",
            value: "px"
          }, {
            label: "normal",
            value: "normal"
          }, {
            label: "Inherit",
            value: "inherit"
          }, {
            label: "Initial",
            value: "initial"
          }, {
            label: "Revert",
            value: "revert"
          }, {
            label: "Revert-layer",
            value: "revert-layer"
          }, {
            label: "Unset",
            value: "unset"
          }],
          onChange: newVal => {
            setwidthUnit(newVal);
            if (newVal == "normal" || newVal == "max-content" || newVal == "min-content" || newVal == "inherit" || newVal == "initial" || newVal == "revert" || newVal == "revert-layer" || newVal == "unset") {
              if (isImportant) {
                props.onChange(newVal + " !important", "lineHeight");
              } else {
                props.onChange(newVal, "lineHeight");
              }
            } else {
              if (isImportant) {
                props.onChange(widthVal + newVal + " !important", "lineHeight");
              } else {
                props.onChange(widthVal + newVal, "lineHeight");
              }
            }
          }
        })]
      })
    })]
  });
}
class PGcssLineHeight extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssLineHeight);

/***/ }),

/***/ "./src/components/css-list-style/index.js":
/*!************************************************!*\
  !*** ./src/components/css-list-style/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _colors_presets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../colors-presets */ "./src/colors-presets.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
const {
  Component,
  RawHTML
} = wp.element;








function Html(props) {
  if (!props.warn) {
    return null;
  }
  var valParts = props.val != undefined ? props.val.split(" ") : ['square', 'inside', 'url("")'];
  var type = valParts[0] != undefined ? valParts[0] : 'square';
  var position = valParts[1] != undefined ? valParts[1] : 'inside';
  var image = valParts[2] != undefined ? valParts[2] : 'url("")';
  var imageVal = image.replace('url("', '');
  imageVal = imageVal.replace('")', '');
  var typeArgs = [{
    label: 'Select..',
    value: ''
  }, {
    label: 'disc',
    value: 'disc'
  }, {
    label: 'armenian',
    value: 'armenian'
  }, {
    label: 'circle',
    value: 'circle'
  }, {
    label: 'cjk-ideographic',
    value: 'cjk-ideographic'
  }, {
    label: 'decimal',
    value: 'decimal'
  }, {
    label: 'decimal-leading-zero',
    value: 'decimal-leading-zero'
  }, {
    label: 'georgian',
    value: 'georgian'
  }, {
    label: 'hebrew',
    value: 'hebrew'
  }, {
    label: 'hiragana',
    value: 'hiragana'
  }, {
    label: 'hiragana-iroha',
    value: 'hiragana-iroha'
  }, {
    label: 'katakana',
    value: 'katakana'
  }, {
    label: 'katakana-iroha',
    value: 'katakana-iroha'
  }, {
    label: 'lower-alpha',
    value: 'lower-alpha'
  }, {
    label: 'lower-greek',
    value: 'lower-greek'
  }, {
    label: 'lower-latin',
    value: 'lower-latin'
  }, {
    label: 'lower-roman',
    value: 'lower-roman'
  }, {
    label: 'square',
    value: 'square'
  }, {
    label: 'upper-alpha',
    value: 'upper-alpha'
  }, {
    label: 'upper-greek',
    value: 'upper-greek'
  }, {
    label: 'upper-latin',
    value: 'upper-latin'
  }, {
    label: 'upper-roman',
    value: 'upper-roman'
  }, {
    label: 'none',
    value: 'none'
  }];
  const ALLOWED_MEDIA_TYPES = ['image'];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Type", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_4__["default"], {
        position: "bottom right",
        variant: "secondary",
        options: typeArgs,
        buttonTitle: type,
        onChange: (option, index) => {
          props.onChange(option.value + ' ' + position + ' ' + image, 'listStyle');
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("label", {
        htmlFor: "",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Position", "accordions")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_4__["default"], {
        position: "bottom right",
        variant: "secondary",
        options: [{
          label: 'inside',
          value: 'inside'
        }, {
          label: 'outside',
          value: 'outside'
        }],
        buttonTitle: position,
        onChange: (option, index) => {
          props.onChange(type + ' ' + option.value + ' ' + image, 'listStyle');
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "my-3",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("img", {
        src: imageVal,
        alt: ""
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__.MediaUploadCheck, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__.MediaUpload, {
        className: "bg-gray-700 hover:bg-gray-600",
        onSelect: media => {
          // media.id
          props.onChange(type + ' ' + position + ' url("' + media.url + '")', 'listStyle');
        },
        onClose: () => {},
        allowedTypes: ALLOWED_MEDIA_TYPES,
        render: ({
          open
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          className: "my-3 bg-gray-700 hover:bg-gray-600 text-white border border-solid border-gray-300 text-center w-full",
          onClick: open,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Open Media Library", "accordions")
        })
      })
    })]
  });
}
class PGcssListStyle extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    const {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Html, {
        val: val,
        onChange: onChange,
        warn: this.state.showWarning
      })
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssListStyle);

/***/ }),

/***/ "./src/components/css-margin-bottom/index.js":
/*!***************************************************!*\
  !*** ./src/components/css-margin-bottom/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    auto: {
      label: "AUTO",
      value: "auto"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  var widthUnitX = valZ == undefined || valZ.match(/[a-zA-Z%]+/g) == null ? "px" : valZ.match(/[a-zA-Z%]+/g)[0];
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnit, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between",
    children: [widthUnit != "auto" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      disabled: widthUnit == "auto" ? true : false,
      onChange: newVal => {
        setwidthVal(newVal);
        if (widthUnit == "auto") {
          // props.onChange(widthUnit, 'width');
          if (isImportant) {
            props.onChange(widthUnit + " !important", "marginBottom");
          } else {
            props.onChange(widthUnit, "marginBottom");
          }
        } else {
          //props.onChange(newVal + widthUnit, 'width');
          if (isImportant) {
            props.onChange(newVal + widthUnit + " !important", "marginBottom");
          } else {
            props.onChange(newVal + widthUnit, "marginBottom");
          }
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom left",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: "",
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: " ",
            children: valZ ? unitArgs[widthUnit].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "w-32",
          children: Object.entries(unitArgs).map(y => {
            var index = y[0];
            var x = y[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                setwidthUnit(x.value);
                if (x.value == "auto") {
                  if (isImportant) {
                    props.onChange(x.value + " !important", "marginBottom");
                  } else {
                    props.onChange(x.value, "marginBottom");
                  }
                } else {
                  if (isImportant) {
                    props.onChange(widthVal + x.value + " !important", "marginBottom");
                  } else {
                    props.onChange(widthVal + x.value, "marginBottom");
                  }
                }
              },
              children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: x.label
              })
            });
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImportant(isImportant => !isImportant);
        if (isImportant) {
          if (widthUnit == "auto") {
            props.onChange(widthUnit, "marginBottom");
          } else {
            props.onChange(widthVal + widthUnit, "marginBottom");
          }
        } else {
          if (widthUnit == "auto") {
            props.onChange(widthUnit + " !important", "marginBottom");
          } else {
            props.onChange(widthVal + widthUnit + " !important", "marginBottom");
          }
        }
      }
    })]
  });
}
class PGcssMarginBottom extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      val,
      onChange
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      val: val,
      onChange: onChange,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PGcssMarginBottom);

/***/ }),

/***/ "./src/components/css-margin-left/index.js":
/*!*************************************************!*\
  !*** ./src/components/css-margin-left/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var unitArgs = {
    px: {
      label: "PX",
      value: "px"
    },
    em: {
      label: "EM",
      value: "em"
    },
    rem: {
      label: "REM",
      value: "rem"
    },
    auto: {
      label: "AUTO",
      value: "auto"
    },
    "%": {
      label: "%",
      value: "%"
    },
    cm: {
      label: "CM",
      value: "cm"
    },
    mm: {
      label: "MM",
      value: "mm"
    },
    in: {
      label: "IN",
      value: "in"
    },
    pt: {
      label: "PT",
      value: "pt"
    },
    pc: {
      label: "PC",
      value: "pc"
    },
    ex: {
      label: "EX",
      value: "ex"
    },
    ch: {
      label: "CH",
      value: "ch"
    },
    vw: {
      label: "VW",
      value: "vw"
    },
    vh: {
      label: "VH",
      value: "vh"
    },
    vmin: {
      label: "VMIN",
      value: "vmin"
    },
    vmax: {
      label: "VMAX",
      value: "vmax"
    }
  };
  var valZ = props.val == null || props.val == undefined || props.val.length == 0 ? "0px" : props.val;
  var widthValX = valZ == undefined || valZ.match(/-?\d+/g) == null ? 0 : valZ.match(/-?\d+/g)[0];
  var widthUnitX = valZ == undefined || valZ.match(/[a-zA-Z%]+/g) == null ? "px" : valZ.match(/[a-zA-Z%]+/g)[0];
  const [widthVal, setwidthVal] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthValX);
  const [widthUnit, setwidthUnit] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(widthUnitX);
  const [isImportant, setImportant] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(valZ.includes(" !important") ? true : false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "flex justify-between",
    children: [widthUnit != "auto" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.__experimentalInputControl, {
      value: widthVal,
      type: "number",
      disabled: widthUnit == "auto" ? true : false,
      onChange: newVal => {
        setwidthVal(newVal);
        if (widthUnit == "auto") {
          // props.onChange(widthUnit, 'width');
          if (isImportant) {
            props.onChange(widthUnit + " !important", "marginLeft");
          } else {
            props.onChange(widthUnit, "marginLeft");
          }
        } else {
          //props.onChange(newVal + widthUnit, 'width');
          if (isImportant) {
            props.onChange(newVal + widthUnit + " !important", "marginLeft");
          } else {
            props.onChange(newVal + widthUnit, "marginLeft");
          }
        }
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Dropdown, {
        position: "bottom left",
        renderToggle: ({
          isOpen,
          onToggle
        }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          title: "",
          onClick: onToggle,
          "aria-expanded": isOpen,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: " ",
            children: valZ ? unitArgs[widthUnit].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Select...", "accordions")
          })
        }),
        renderContent: () => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "w-32",
          children: Object.entries(unitArgs).map(y => {
            var index = y[0];
            var x = y[1];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "px-3 py-1 border-b block hover:bg-gray-400 cursor-pointer",
              onClick: ev => {
                setwidthUnit(x.value);
                if (x.value == "auto") {
                  if (isImportant) {
                    props.onChange(x.value + " !important", "marginLeft");
                  } else {
                    props.onChange(x.value, "marginLeft");
                  }
                } else {
                  if (isImportant) {
                    props.onChange(widthVal + x.value + " !important", "marginLeft");
                  } else {
                    props.onChange(widthVal + x.value, "marginLeft");
                  }
                }
              },
              children: x.value && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
                children: x.label
              })
            });
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
      help: isImportant ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important Enabled", "accordions") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Important?", "accordions"),
      checked: isImportant,
      onChange: arg => {
        setImpor